package dyliss.biopax.graph;


import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.TreeSet;

import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.biopax.paxtools.controller.Fetcher;
import org.biopax.paxtools.controller.ModelUtils;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.impl.level3.BiochemicalReactionImpl;
import org.biopax.paxtools.impl.level3.CatalysisImpl;
import org.biopax.paxtools.impl.level3.ComplexAssemblyImpl;
import org.biopax.paxtools.impl.level3.ComplexImpl;
import org.biopax.paxtools.impl.level3.ControlImpl;
import org.biopax.paxtools.impl.level3.ConversionImpl;
import org.biopax.paxtools.impl.level3.DegradationImpl;
import org.biopax.paxtools.impl.level3.EntityImpl;
import org.biopax.paxtools.impl.level3.ModulationImpl;
import org.biopax.paxtools.impl.level3.PhysicalEntityImpl;
import org.biopax.paxtools.impl.level3.ProteinImpl;
import org.biopax.paxtools.impl.level3.ProteinReferenceImpl;
import org.biopax.paxtools.impl.level3.SmallMoleculeReferenceImpl;
import org.biopax.paxtools.impl.level3.TemplateReactionImpl;
import org.biopax.paxtools.impl.level3.TemplateReactionRegulationImpl;
import org.biopax.paxtools.impl.level3.TransportImpl;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.BioSource;
import org.biopax.paxtools.model.level3.BiochemicalReaction;
import org.biopax.paxtools.model.level3.CellularLocationVocabulary;
import org.biopax.paxtools.model.level3.ComplexAssembly;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.ControlType;
import org.biopax.paxtools.model.level3.Controller;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.Entity;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.Gene;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.model.level3.Named;
import org.biopax.paxtools.model.level3.NucleicAcid;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Process;
import org.biopax.paxtools.model.level3.Provenance;
import org.biopax.paxtools.model.level3.SequenceEntity;
import org.biopax.paxtools.model.level3.SequenceEntityReference;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.model.level3.SmallMolecule;
import org.biopax.paxtools.model.level3.SmallMoleculeReference;
import org.biopax.paxtools.model.level3.Stoichiometry;
import org.biopax.paxtools.model.level3.TemplateReactionRegulation;
import org.biopax.paxtools.model.level3.XReferrable;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.paxtools.pattern.Match;
import org.biopax.paxtools.pattern.Pattern;

//import org.biopax.paxtools.pattern.Searcher;
import dyliss.biopax.pattern.PatternSearcher;
import org.biopax.paxtools.pattern.miner.SIFType;
import org.biopax.paxtools.pattern.util.Blacklist;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.slf4j.LoggerFactory;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;

import dyliss.biopax.GraphConfig;
import dyliss.biopax.SpaimEnum;
import dyliss.biopax.app.MainGenerator;
import dyliss.biopax.pattern.SpaimPatternBox;
import dyliss.biopax.util.LogUtils;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;



public class SpaimGraphGenerator {

	public   Integer CONTROL_VERSION=2;
	 
	private static final String R2 = "R2";
	private static final String R3 = "R3";
	private static final String R1 = "R1";
	private static final String SUP = "SUP_";
	public static final String R1_CONTROLSEXPRESSIONWITHCONVERSION ="CONTROLSEXPRESSIONWITHCONVERSION"; 
	public static final String R1_CONTROLSEXPRESSIONWITHTEMPLATEREAC ="CONTROLSEXPRESSIONWITHTEMPLATEREAC"; 
	public static final String R2_CONTROLSMETABOLICCATALYSIS ="CONTROLSMETABOLICCATALYSIS"; 
	public static final String R3_REACTSWITH ="REACTSWITH";
	public static final String RX_CONTROLSPHOSPHORYLATION="CONTROLSPHOSPHORYLATION";
	public static final String RX_INCOMPLEXWITH="INCOMPLEXWITH";
	public static final String RX_INSAMECOMPLEX="INSAMECOMPLEX";
	public static final String RX_COMPLEX="COMPLEX";

	public boolean EXIT_ON_ISSUE=false;

	
	private   Boolean isAddEntityReference=true;

	private   Boolean isAddComplexComponent=true;

	private   final  ch.qos.logback.classic.Logger logger = 
			  (ch.qos.logback.classic.Logger)LoggerFactory.getLogger(this.getClass());
	 
	
	 

	private HashMap<String, SpaimNode> vmap=null;
	private HashMap<String, SpaimEdge> emap=null;

	private DirectedSparseMultigraph spaimGraph=null;
	private HashMap<String,String> mapBench=null;


	public DirectedSparseMultigraph getSpaimGraph() {
		return spaimGraph;
	}

	public void setSpaimGraph(DirectedSparseMultigraph spaimGraph) {
		this.spaimGraph = spaimGraph;
	}

	public void init() {

		if(spaimGraph==null){
			spaimGraph = new DirectedSparseMultigraph<SpaimNode, SpaimEdge>();
		}
		if(vmap==null){
			vmap=new HashMap<String, SpaimNode>();
			/* Collection<SpaimNode> vm = spaimGraph.getVertices();
			 for(SpaimNode spn: vm){
				 vmap.put(spn.getPk(), spn);
			 }*/

		}
		if(emap==null){
			emap=new HashMap<String, SpaimEdge>();
			/* Collection<SpaimEdge> vm = spaimGraph.getEdges();
			 for(SpaimEdge spe: vm){
				 emap.put(spe.getPk(), spe);
			 }*/

		}

	}

 	public SpaimGraphGenerator(Boolean isAddEntityRef , Boolean isAddComplexComp,
 			HashMap mapBench,
 			Integer controlVersion) {
		super();
		this.isAddEntityReference=isAddEntityRef;
		this.isAddComplexComponent=isAddComplexComp;
		this.init();
		this.mapBench=mapBench;
		this.CONTROL_VERSION=controlVersion;

	}


	private int displayMatchInfo(Map<BioPAXElement, List<Match>> matches) {

		int ct=0;
		for(Entry<BioPAXElement, List<Match>> ent  : matches.entrySet()){
			ct++;
			BioPAXElement k = ent .getKey();
			String klbl=k.toString();

			if(k.getClass().isAssignableFrom(SequenceEntityReference.class) || k  instanceof SequenceEntityReference ){
				SequenceEntityReference o = (SequenceEntityReference) k;
				klbl+=": "+o.getDisplayName();
			}
			else if(k.getClass().isAssignableFrom(ProteinReferenceImpl.class)){
				ProteinReferenceImpl o = (ProteinReferenceImpl) k;
				klbl+=":: "+o.getDisplayName();
			}
			else if(k.getClass().isAssignableFrom(SmallMoleculeReference.class)  || k  instanceof SmallMoleculeReference  ){
				SmallMoleculeReference o = (SmallMoleculeReference) k;
				klbl+=":: "+o.getDisplayName();
			}

			logger.trace("\n----------------1key:"+klbl +"\n");
			List<Match> v = ent.getValue();
			for(Match ma : v){


				for(BioPAXElement b:ma.getVariables()){
					//System.out.print( b+": "+b.getClass().getSimpleName()+": ");
					if(b instanceof ProteinImpl){
						ProteinImpl o = (ProteinImpl )b ;
						//System.out.print( "|"+o.getDisplayName());
					}
					if(b instanceof ComplexImpl){
						ComplexImpl o = (ComplexImpl )b ;
						//System.out.print("|"+ o.getDisplayName());
					}
					if(b instanceof BiochemicalReactionImpl){
						BiochemicalReactionImpl o = (BiochemicalReactionImpl )b ;
						//System.out.print( "|"+o.getDisplayName());
					}
					if(b.getClass().isAssignableFrom(Conversion.class) || b instanceof Conversion ){
						Conversion o = (Conversion )b ;
						//System.out.print( " |**isa_conversion**");

					}
					if(b.getClass().isAssignableFrom(Control.class) || b instanceof Control ){
						Control o = (Control )b ;
						//System.out.print( "|**isa_control: "+o.getControlType().name()+"");

					}
					logger.trace("");
				}

			}

		}
		return ct;
	}



	public void subGraphControlsExpressionWithConversion(Pattern p, Map<BioPAXElement, List<Match>> matches  ) throws Exception {

		if(matches==null){return;}

		for(Entry<BioPAXElement, List<Match>> ent  : matches.entrySet()){
			BioPAXElement k = ent .getKey();
			List<Match> v = ent.getValue();
			for(Match ma : v){


				Control control = (Control) ma.get("Control", p);
				// System.out.print(">>>>Control"+": ");
				if(control==null){
					// System.out.print("@@NULL control");
				}
				if(control instanceof TemplateReactionRegulationImpl){
					TemplateReactionRegulationImpl o = (TemplateReactionRegulationImpl )
							control ;

					//System.out.print( "|TemplateReactionRegulationImpl:"+
					// o.getDisplayName()+"");
				}else{
					// System.out.print( "|"+control.getDisplayName()+"");
				}
				// System.out.print( "|1|"+control.getUri()+"");
				// System.out.print("\n");




				Set<Controller> colr = control.getController();
				ControlType controlType = control.getControlType(); 

				ArrayList<SpaimNode>clA= new ArrayList<SpaimNode>();

				for(Controller c:colr){
					boolean validEntity=false;
					if(c instanceof ProteinImpl){
						ProteinImpl o = (ProteinImpl )c ;

						validEntity=true;
					}
					else if(c instanceof ComplexImpl){
						ComplexImpl o = (ComplexImpl )c ;

						validEntity=true;
					}
					if(validEntity==false){


						if(EXIT_ON_ISSUE==true){
							throw new Exception("subGraphControlsExpressionWithConversion: unexpected entity "+c.getClass()+","+c);
						}else{
							System.err.println("subGraphControlsExpressionWithConversion: unexpected entity "+c.getClass()+","+c);
						}

					}else{


						//node a, case R1
						SpaimNode ncontroller_A = addSpaimNode(spaimGraph, c,R1);
						if(ncontroller_A!=null){
							clA.add(ncontroller_A);
						} 

					}

				}
				 
				SpaimNode ncontrl_R1 =null;
				if (CONTROL_VERSION==1) {
					
						
						  ncontrl_R1 = addSpaimNode(spaimGraph, control,R1); // reaction R1 a activ/inhib b
						ncontrl_R1.getSpaimCase().add(R1);
						ncontrl_R1.getPatternTag().add(R1_CONTROLSEXPRESSIONWITHCONVERSION);
						for(SpaimNode ncontrollerA:clA){
							String ct = SpaimEnum.controlTypeToSpaimCodeValidated(control,controlType);
							if(ct!=null){ //ct=a or i
								SpaimEdge e = addSpaimEdge(spaimGraph, ncontrollerA, ncontrl_R1,R1,ct);
							}
		
						  }
				}
				
				
				Set<Process> col = control.getControlled();

				for( Process c:col){
					boolean validEntity=false;
					boolean tograph=true;
					if (c.getClass().isAssignableFrom(Conversion.class) || c instanceof Conversion ){

						Conversion co =(Conversion) c;
						if(c instanceof BiochemicalReactionImpl ){
							validEntity=true;

						}
						else if(c instanceof ComplexAssemblyImpl ){
							validEntity=true;

						}
						else if (c instanceof TransportImpl){
							validEntity=true;
							tograph=false;
						}
						else if (c instanceof DegradationImpl){
							validEntity=true;
						}
						else if(c instanceof ConversionImpl ){
							validEntity=true;
							tograph=false;
							// must be added to graph ???
						}
						if(validEntity==false){
							//throw new Exception("unexpected entity "+c.getClass()+","+c);
							if(EXIT_ON_ISSUE==true){
								throw new Exception("subGraphControlsExpressionWithConversion:2: unexpected entity "+c.getClass()+","+c);
							}else{
								System.err.println("subGraphControlsExpressionWithConversion:2: unexpected entity "+c.getClass()+","+c);
							}


						}else{
							//co: intermediate reaction : 
							// we use co products direcly
							if(tograph==true){
								
								if (CONTROL_VERSION==1) {

								   Set<PhysicalEntity> outp = co.getRight();
								   for(PhysicalEntity ou:outp){
									SpaimNode np = addSpaimNode(spaimGraph, ou,R1);
									SpaimEdge ep = addSpaimEdge(spaimGraph, ncontrl_R1, np,R1,SpaimEnum.product);
									// logger.trace( "  >>>>out:"+ou.getDisplayName()+"");
								 }
								}								
								
							}
							
							

						}


						/*
						  // intermediate reaction : not in R1 case but added independently in graph to increase graph size

						 */
						logger.trace( "  >>>>processToSubGraph:start");
						
						//TODO check if need to reuse rnode
						SpaimNode controlledReactionNode = processToSubGraph(co, R3,SUP+R1_CONTROLSEXPRESSIONWITHCONVERSION);
						
						logger.trace( "  >>>>processToSubGraph:end");
						if (CONTROL_VERSION==2) {
							


	 					   logger.trace("V2");
	 					   if(controlledReactionNode!=null) {
	 						   //-----------------V2--------------do not add control as node  ,but controller to controlled reaction---------------------------			
								logger.trace("@=@subGraphControlExpression=   === add controller to controlled reaction "); 
								
								for(SpaimNode ncontrollerA:clA){
									String ct = SpaimEnum.controlTypeToSpaimCodeValidated(control,controlType);
									if(ct!=null){ //ct=a or i
										SpaimEdge e = addSpaimEdge(spaimGraph, ncontrollerA, controlledReactionNode,R1,ct);
										 e.setDebug("CE");
									}
				
								  }
	 					 }
	 					
						
							
						}

					}

				}





			} 
		}
	}


	public void subGraphControlsExpressionWithTemplateReac(Pattern p, Map<BioPAXElement, List<Match>> matches  ) throws Exception {
		//logger.trace(">>>>>>>>>>>>>>><<<<<<<<<<<<<<<<<<<<" );

		if(matches==null){return;}
		for(Entry<BioPAXElement, List<Match>> ent  : matches.entrySet()){
			BioPAXElement k = ent .getKey();
			List<Match> v = ent.getValue();
			for(Match ma : v){


				Control control = (Control) ma.get("Control", p);
				if(control==null){
					//  logger.trace("@@NULL control");
				}
				// System.out.print(">>>>Control"+": ");
				if(control instanceof TemplateReactionRegulationImpl){
					TemplateReactionRegulationImpl o = (TemplateReactionRegulationImpl )control ;
					//		System.out.print( "|TemplateReactionRegulationImpl:"+o.getDisplayName()+"");
				}else{
					//	 System.out.print( "|"+control.getDisplayName()+"");
				}
				// System.out.print( "|2|"+control.getUri()+"");
				// System.out.print("\n");		 



				Set<Controller> colr = control.getController();
				ControlType controlType = control.getControlType(); 
				// activation, inhibition, inhibition-allosteric, inhinition-competitive, inhibition-irreversible,
				//inhibition-noncompetitive, inhibition-other, inhibition-uncompetitive, activation-nonallosteric, activation-allosteric

				//String s="";
				ArrayList<SpaimNode>clA= new ArrayList<SpaimNode>();

				for(Controller c:colr){
					boolean validEntity=false;
					if(c instanceof ProteinImpl){
						ProteinImpl o = (ProteinImpl )c ;
						//s+=  o.getDisplayName();
						validEntity=true;
					}
					else if(c instanceof ComplexImpl){
						ComplexImpl o = (ComplexImpl )c ;
						//s+=  o.getDisplayName();
						validEntity=true;
					}
					if(validEntity==false){
						//	throw new Exception("unexpected entity "+c.getClass()+","+c);
					}


					//node a, case R1
					SpaimNode ncontroller_A = addSpaimNode(spaimGraph, c,R1);
					clA.add(ncontroller_A);



				}

				SpaimNode ncontrl_R1 =null;
				if (CONTROL_VERSION==1) {
				
			    	 ncontrl_R1 = addSpaimNode(spaimGraph, control,R1); // reaction R1 a activ/inhib b
				    ncontrl_R1.getSpaimCase().add(R1);
				    ncontrl_R1.getPatternTag().add(R1_CONTROLSEXPRESSIONWITHTEMPLATEREAC);

					for(SpaimNode ncontrollerA:clA){
  						  String ct = SpaimEnum.controlTypeToSpaimCodeValidated(control,controlType);

						   if(ct!=null){ //a or i
							   SpaimEdge e = addSpaimEdge(spaimGraph, ncontrollerA, ncontrl_R1,R1,ct);
	 				    	} 

				    	}
			    	}	

					Set<Process> controlled = control.getControlled();

					//String s="";
					for( Process ctrled:controlled){
						boolean validEntity=false;
						if (ctrled.getClass().isAssignableFrom(Interaction.class) || ctrled instanceof Interaction ){

							TemplateReactionImpl controlledTemplateReact =null;
							if(ctrled instanceof TemplateReactionImpl ){
								validEntity=true;

								controlledTemplateReact = (TemplateReactionImpl )ctrled ;  //BiochemicalReaction|ComplexAssembly|Transport

							}
							else if(ctrled instanceof BiochemicalReaction ){
								validEntity=false;

							}
							else if (ctrled instanceof ComplexAssemblyImpl){
								validEntity=false;
							}
							else if (ctrled instanceof TransportImpl){
								validEntity=false;
							}

							if(validEntity==false){
								if(EXIT_ON_ISSUE==true){
									throw new Exception("subGraphControlsExpressionWithTemplateReac: unexpected entity "+ctrled.getClass()+","+ctrled);
								}else{
									System.err.println("subGraphControlsExpressionWithTemplateReac: unexpected entity "+ctrled.getClass()+","+ctrled);
								}
							}
							
							if (CONTROL_VERSION==1) {
							  if(controlledTemplateReact!=null){
								
								//co: intermediate reaction : 
								// we use co products direcly
								Set<PhysicalEntity> outp = controlledTemplateReact.getProduct();
								
								for(PhysicalEntity ou:outp){

									SpaimNode np = addSpaimNode(spaimGraph, ou,R1);

									SpaimEdge ep = addSpaimEdge(spaimGraph, ncontrl_R1, np,R1,SpaimEnum.product);
	 								// logger.trace( "  >>>>out:"+ou.getDisplayName()+"");
								 }
				
			                 	}
							}
							/*
							  // intermediate reaction : not in R1 case but added independently in graph to increase graph size

							 */
							//TODO check if need to reuse rnode
							SpaimNode controlledReactionNode =processToSubGraph(controlledTemplateReact, R3,SUP+R1_CONTROLSEXPRESSIONWITHTEMPLATEREAC);
						
							if (CONTROL_VERSION==2) {

		 						logger.trace("V2");
		 					   if(controlledReactionNode!=null) {
		 						   //-----------------V2--------------do not add control as node  ,but controller to controlled reaction---------------------------			
									logger.trace("@=@subGraphControlExpressionWithTemplateReaction=   === add controller to controlled reaction "); 
									
									for(SpaimNode ncontrollerA:clA){
				  						  String ct = SpaimEnum.controlTypeToSpaimCodeValidated(control,controlType);

										   if(ct!=null){ //a or i
											   SpaimEdge e = addSpaimEdge(spaimGraph, ncontrollerA, controlledReactionNode,R1,ct);
											   e.setDebug("CETR");
					 				    	} 

								    	}		 						 
		 					 }
		 					
							}
						
						}
					}
					//-------

				
				




			} 
		}
	}

	private SpaimNode processToSubGraph( Process  c, String cas, String patc) throws Exception {
		
		logger.trace("<<<<<processToSubGraph>>");
		SpaimNode rnode=null;
		boolean validEntity=false;

		boolean tograph=true;
		String msg="";

		if (c.getClass().isAssignableFrom(Interaction.class) || c instanceof Interaction ){
			//BiochemicalReaction|ComplexAssembly|Transport
			if (c.getClass().isAssignableFrom(Conversion.class) || c instanceof Conversion ){



				Conversion co =(Conversion) c;
				if(c instanceof BiochemicalReactionImpl ){
					validEntity=true;

				}
				else if(c instanceof ComplexAssemblyImpl ){
					validEntity=true;
					//	s+=  "<biomchemreact: " +co.getDisplayName()+">";
				}
				else if(c instanceof ConversionImpl ){
					validEntity=true;
					tograph=false;
					msg=" TODO ConversionImpl";

				}
				else if (c instanceof TransportImpl){

					tograph=false;
					validEntity=true;
					msg=" TODO TransportImpl";
				}
				else if (c instanceof DegradationImpl){
					tograph=false;
					validEntity=true;
					msg=" TODO DegradationImpl";
				}
				else if(c instanceof ConversionImpl ){
					validEntity=true;
					tograph=false;
					// must be added to graph ???
				}
				if(validEntity==false){
					//	throw new Exception("unexpected entity "+c.getClass()+","+c);
					if(EXIT_ON_ISSUE==true){
						throw new Exception("processToSubGraph: unexpected entity "+c.getClass()+","+c);
					}else{
						System.err.println("processToSubGraph: unexpected entity "+c.getClass()+","+c);
					}

				}else{

					if(tograph==true){

						  rnode= addSpaimNode(spaimGraph, co,cas);

						Set<PhysicalEntity> inl = co.getLeft();
						for(PhysicalEntity in : inl){

							SpaimNode n = addSpaimNode(spaimGraph, in,cas);

							SpaimEdge e = addSpaimEdge(spaimGraph, n, rnode,cas,SpaimEnum.substrat);

 							n.getSpaimCase().add(cas);
							n.getPatternTag().add(patc);

							//logger.trace( "  >>>>in:"+in.getDisplayName()+"");

						}	

						Set<PhysicalEntity> outp2 = co.getRight();
						for(PhysicalEntity ou:outp2){

							SpaimNode np = addSpaimNode(spaimGraph, ou,cas);

							SpaimEdge ep = addSpaimEdge(spaimGraph, rnode, np,cas,SpaimEnum.product);
 							//  logger.trace( "  >>>>out:"+ou.getDisplayName()+"");
							np.getSpaimCase().add(cas);
							np.getPatternTag().add(patc);

						}
					}else{
						logger.info("**WARNING**"+c+"excluded from graph, " +msg);
					}

				}

			}

			if(c instanceof TemplateReactionImpl ){


				validEntity=true;

				TemplateReactionImpl  co = (TemplateReactionImpl )c ;
				  rnode= addSpaimNode(spaimGraph, co,cas);
				NucleicAcid in = co.getTemplate();
				//0 to 1
				if(in==null){
					//throw new Exception("unexpected null entity NucleicAcid "+in +" for controlled "+co+co.getParticipant()+" "+co.getProduct());
				}else{
					SpaimNode n = addSpaimNode(spaimGraph, in,cas);




					SpaimEdge e = addSpaimEdge(spaimGraph, n, rnode,cas,SpaimEnum.substrat);
					 
					n.getSpaimCase().add(cas);
					n.getPatternTag().add(patc);

					// logger.info( "  >>>>in:"+in.getDisplayName()+"");
				}


				Set<PhysicalEntity> outp2 = co.getProduct();
				for(PhysicalEntity ou:outp2){

					SpaimNode np = addSpaimNode(spaimGraph, ou,cas);

					SpaimEdge ep = addSpaimEdge(spaimGraph, rnode, np,cas,SpaimEnum.product);
 					//  logger.info( "  >>>>out:"+ou.getDisplayName()+"");
					np.getSpaimCase().add(cas);
					np.getPatternTag().add(patc);

				}



			}


			if(validEntity==false){
				//throw new Exception(msg+", unexpected entity "+c.getClass()+","+c +"");


				if(EXIT_ON_ISSUE==true){
					throw new Exception(msg+",processToSubGraph, unexpected entity "+c.getClass()+","+c +"");
				}else{
					System.err.println(msg+",processToSubGraph, unexpected entity "+c.getClass()+","+c +"");
				}
			}



		}

      return rnode;
	}

	public void subGraphControlPhospho(Pattern p, Map<BioPAXElement, List<Match>> matches  ) throws Exception {
		if(matches==null){return;}
		subGraphControl(  p,   matches,R2 ,RX_CONTROLSPHOSPHORYLATION );

	}

	public void subGraphControlsMetabolicCatalysis(Pattern p, Map<BioPAXElement, List<Match>> matches  ) throws Exception {
		logger.trace(String.format(">>>>>>>>>>>>>>>subGraphControlsMetabolicCatalysis<<<<<<<%s<<<%s<<<<<<<<<<" 
				,R2 ,R2_CONTROLSMETABOLICCATALYSIS ) );

		if(matches==null){return;}  
		subGraphControl(  p,   matches,R2 ,R2_CONTROLSMETABOLICCATALYSIS );
	}

	public void subGraphControl(Pattern p, 
			Map<BioPAXElement, List<Match>> matches , 
			String spaimC , String patc) throws Exception {
		logger.trace(">>>>>>>>>>>>>>>subGraphControl<<<<<<<<<<<<<<<<<<<<" );
		if(matches==null){return;}
		String msg="";
		for(Entry<BioPAXElement, List<Match>> ent  : matches.entrySet()){
			BioPAXElement k = ent .getKey();
			List<Match> v = ent.getValue();
			for(Match ma : v){

				logger.trace("****** match");

				Control control = (Control) ma.get("Control", p);
				if(control==null){
					// System.out.print("@@NULL control");
				}else {
					logger.trace("== control:"+control.getClass().getSimpleName());
				}
				// System.out.print(">>>>Control"+": ");
				if(control instanceof TemplateReactionRegulationImpl){
					TemplateReactionRegulationImpl o = (TemplateReactionRegulationImpl )control ;
					//	System.out.print( "|TemplateReactionRegulationImpl:"+o.getDisplayName()+"");
				}else{
					// System.out.print( "|"+control.getDisplayName()+"");
				}
				// System.out.print( "|3|"+control.getUri()+"");
				// System.out.print("\n");
				
				//--------------
				Set<Process> controlled = control.getControlled();
				
                //----------------
				Set<Controller> colr = control.getController();
				ControlType controlType = control.getControlType(); 
				// activation, inhibition, inhibition-allosteric, inhinition-competitive, inhibition-irreversible,
				//inhibition-noncompetitive, inhibition-other, inhibition-uncompetitive, activation-nonallosteric, activation-allosteric

 
				ArrayList<SpaimNode>clA= new ArrayList<SpaimNode>();

				for(Controller c:colr){
					logger.trace("= controller:"+c.getName().toString());
					boolean validEntity=false;
					if(c instanceof ProteinImpl){
						ProteinImpl o = (ProteinImpl )c ;
						 
						validEntity=true;
					}
					else if(c instanceof ComplexImpl){
						ComplexImpl o = (ComplexImpl )c ;
						 
						validEntity=true;
					}
					else if(c instanceof PhysicalEntityImpl){
						PhysicalEntityImpl o = (PhysicalEntityImpl )c ;
						 
						validEntity=true;
					}

					if(validEntity==false){

						if(EXIT_ON_ISSUE==true){
							throw new Exception("subGraphControl: unexpected entity "+c.getClass()+","+c);
						}else{
							System.err.println("subGraphControl: unexpected entity "+c.getClass()+","+c);
						}

					}
					else{ 
                       logger.trace("***C1");
						SpaimNode ncontroller_E = addSpaimNode(spaimGraph, c,R2);
						clA.add(ncontroller_E);
					}

				}
				boolean validEntityC=false;
				if (control.getClass().isAssignableFrom(CatalysisImpl.class) || control instanceof CatalysisImpl ){
					validEntityC=true;
				}
				else if (control.getClass().isAssignableFrom(TemplateReactionRegulationImpl.class) || control instanceof TemplateReactionRegulationImpl ){
					 
					validEntityC=true;
				}
				else if (control.getClass().isAssignableFrom(ModulationImpl.class) || control instanceof ModulationImpl ){
					 
					validEntityC=true;
				}
				if(validEntityC==false){

					if(EXIT_ON_ISSUE==true){
						throw new Exception("subGraphControl2: unexpected entity "+control.getClass()+","+control +", "+msg);
					}else{
						System.err.println("subGraphControl2: unexpected entity "+control.getClass()+","+control +", "+msg);
					}


				}
				else{
					 
					for( Process ctrled:controlled){
						boolean validEntity=false;
						boolean tograph=true;
						if (ctrled.getClass().isAssignableFrom(Conversion.class) || ctrled instanceof Conversion ){

							Conversion convers =(Conversion) ctrled;
							if(ctrled instanceof BiochemicalReactionImpl ){
								validEntity=true;

							}
							else if(ctrled instanceof ComplexAssemblyImpl ){
								validEntity=true;
								 
							}
							else if (ctrled instanceof TransportImpl){
								validEntity=true;
								tograph=false;
							}
							else if (ctrled instanceof DegradationImpl){
								validEntity=true;						
							}
							else if(ctrled instanceof ConversionImpl ){
								validEntity=true;
								tograph=false;
								// must be added to graph ???
								/*
								 * java.lang.Exception: unexpected entity class org.biopax.paxtools.impl.level3.ConversionImpl,http://pathwaycommons.org/pc2/Conversion_d1aed227a9574dc45e01ade386b6cb5a
				                     at dyliss.biopax.graph.SpaimGraphGenerator.subGraphControl(SpaimGraphGenerator.java:749)
								 */
							}
					
					        logger.trace("****");
							//    reuse rnode
		 					SpaimNode controlledReactionNode =processToSubGraph(convers, R3,SUP+patc);

		 					
                   //----------------------REVIEWER COMMENT-----------------------------------
				
 					if (CONTROL_VERSION==1) {
  						    //-----------------V1--------------add control as node  (e.g. catalysis)---------------------------			
										logger.trace("   === add control as node ");
										SpaimNode ncontrol_R2 = addSpaimNode(spaimGraph, control,R2); // reaction R2
										ncontrol_R2.getSpaimCase().add(spaimC);
										ncontrol_R2.getPatternTag().add(patc);
									   //---------------------------------------------------------
										for(SpaimNode ncontrollerE:clA){
					
											String ct = SpaimEnum.controlTypeToSpaimCodeValidated(control,controlType);
											if(ct!=null){//a or i
												SpaimEdge e = addSpaimEdge(spaimGraph, ncontrollerE, ncontrol_R2,R2,ct);
 											}
										}

 					
										if(validEntity==false){

											if(EXIT_ON_ISSUE==true){
												throw new Exception("subGraphControl:3: unexpected entity "+ctrled.getClass()+","+ctrled);
											}else{
												System.err.println("subGraphControl:3: unexpected entity "+ctrled.getClass()+","+ctrled);
											}
										}
										else{
											//co: intermediate reaction : 
											// we use co products direcly
											if(tograph==true){

												Set<PhysicalEntity> inp = convers.getLeft();
												for(PhysicalEntity in:inp){
                                                    logger.trace("%%%co-subs");
													SpaimNode np = addSpaimNode(spaimGraph, in,R2);
													//IMPORTANT FIX DONE FOR INFLUENCE GENERATION
			                                       //reverse edge way : 05 2020
 													
													SpaimEdge ep = addSpaimEdge(spaimGraph, np,ncontrol_R2, R2,SpaimEnum.substrat);
												 
													
													// logger.info( "  >>>>in:"+in.getDisplayName()+"");
												}


												Set<PhysicalEntity> outp = convers.getRight();
												for(PhysicalEntity ou:outp){
                                                    logger.trace("%%%co-prod");
   
													SpaimNode np = addSpaimNode(spaimGraph, ou,R2);

													SpaimEdge ep = addSpaimEdge(spaimGraph, ncontrol_R2, np,R2,SpaimEnum.product);
												 
													//	 logger.info( "  >>>>out:"+ou.getDisplayName()+"");
												}
											}
 					
 					
 					}
				   //----------------------------------------------------------
										
								/*
										  // intermediate reaction : not in R1 case but added independently in graph to increase graph size

								 */
 							}
 					
 					
 					//----------------------------------------------------------
 					if (CONTROL_VERSION==2) {
 						logger.trace("V2");
 					   if(controlledReactionNode!=null) {
 						   //-----------------V2--------------do not add control as node  ,but controller to controlled reaction---------------------------			
							logger.trace("@=@subGraphControl=== add controller to controlled reaction "); 
							
							for(SpaimNode ncontrollerE:clA){
		
								String ct = SpaimEnum.controlTypeToSpaimCodeValidated(control,controlType);
								if(ct!=null){//a or i
									SpaimEdge e = addSpaimEdge(spaimGraph, ncontrollerE, controlledReactionNode,R2,ct);
 									logger.trace(String.format("addSpaimEdge   %s --%s-->%s", ncontrollerE.getLabel(),ct, controlledReactionNode.getLabel()));
                                    e.setDebug("C");
								}
							}
 						 
 					 }
 					}
					
                    //----------------------------------------------------------

						}
					}
					logger.trace( "            >>>>subGraphControl:END<<<<<<<<<<<<<<<<<<<<" );

				}



			} 
		}
	}



	public void subGraphReactWith(Pattern p, Map<BioPAXElement, List<Match>> matches ) throws Exception {
		subGraphsp(  p,  matches ,R3,R3_REACTSWITH) ;
	}

	public void subGraphsp(Pattern p, Map<BioPAXElement, List<Match>> matches , String cat,String  pc) throws Exception {
		//	logger.info(">>>>>>>>>>>>>>>subGraphsp+<<<<<<<<<<<<<<<<<<<<" );
		if(matches==null){return;}
		for(Entry<BioPAXElement, List<Match>> ent  : matches.entrySet()){
			BioPAXElement k = ent .getKey();
			List<Match> v = ent.getValue();
			for(Match ma : v){

				SmallMoleculeReferenceImpl lpe = (SmallMoleculeReferenceImpl) ma.get("SMR1", p);

				// logger.info(">>>>SMR1"+": "+lpe.getDisplayName());
				SmallMoleculeReferenceImpl rpe = (SmallMoleculeReferenceImpl) ma.get("SMR2", p);
				// logger.info(">>>>SMR2"+": "+rpe.getDisplayName());

				Conversion co = (Conversion) ma.get("Conv", p);
				// System.out.print(">>>>Conversion"+": "+co.getUri());
				if(co instanceof BiochemicalReactionImpl){
					BiochemicalReactionImpl o = (BiochemicalReactionImpl )co ;
					//	System.out.print( "|BiochemicalReaction:"+o.getDisplayName()+"");
				}else{
					// System.out.print( "|"+co.getDisplayName()+"");
				}
				// System.out.print("\n");



				SpaimNode no = addSpaimNode(spaimGraph, co,cat);
				//if(no==null){
				// System.out.print("@@@"+no.getClass().getSimpleName()+" "+co.getDisplayName()+" "+co.getUri());
				//System.exit(0);
				//}
				no.getSpaimCase().add(cat);
				no.getPatternTag().add(pc);
				// logger.info( " ==>>>0");
				Set<PhysicalEntity> inp = co.getLeft();
				for(PhysicalEntity in:inp){
					// logger.info( " ==>>>0.1");

					SpaimNode n = addSpaimNode(spaimGraph, in,cat);
					// logger.info( "==>>>0.2");
					SpaimEdge e = addSpaimEdge(spaimGraph, n, no,cat,SpaimEnum.substrat);
					 
					//logger.info( "  >>>>in:"+in.getDisplayName()+","+in.getClass().getSimpleName());


				}
				// logger.info( "==>>>1");
				Set<PhysicalEntity> outp = co.getRight();
				for(PhysicalEntity ou:outp){

					// logger.info( "==>>>1.1");
					SpaimNode n = addSpaimNode(spaimGraph, ou,cat);
					//logger.info( "==>>>1.2");
					SpaimEdge e = addSpaimEdge(spaimGraph, no, n,cat,SpaimEnum.product);
 
					// logger.info( "  >>>>out:"+ou.getDisplayName()+","+ou.getClass().getSimpleName());
				}
			} 
		}
	}








	//TODO

	public void subGraphInComplexWithOrInSameComplex(Pattern p, Map<BioPAXElement, List<Match>> matches, String cat,String patternCase ) throws Exception {
		//logger.info(">>>>>>>>>>>>>>>A implementer correctement<<<<<<<<<<<<<<<<<<<<" );
		if(matches==null){return;}

		for(Entry<BioPAXElement, List<Match>> ent  : matches.entrySet()){
			BioPAXElement k = ent .getKey();
			List<Match> v = ent.getValue();
			for(Match ma : v){
				ComplexImpl complx = (ComplexImpl) ma.get("Complex", p);
				if(complx!=null){

					subGraphComplex( complx, cat, patternCase,null);

				}

			} 
		}
	}


	//TODO
	private void subGraphComplex( ComplexImpl complx, String cat, String patternCase, SpaimNode defcomplxn) throws Exception {
        logger.trace("<<<subGraphComplex");
		SpaimNode complxn = null;


		if(defcomplxn!=null){

			complxn=defcomplxn;

		}else{

			complxn=addSpaimNode(spaimGraph, complx, cat,false);

		}
		Set<Control> ctrll = complx.getControllerOf();
		Boolean asControl=null;
		if(ctrll!=null && ctrll.size()>0){
			//logger.info( "@Complx.getControllerOf.size>0");
			asControl=true;
			//R2

			for(Control cont:ctrll){

				ControlType controlType = cont.getControlType();
				Set<Process> col = cont.getControlled();
				SpaimNode complexAssemblyNode =null;

				//String s="";
				for( Process c:col){
					boolean validEntity=false;
					if (c.getClass().isAssignableFrom(Conversion.class) || c instanceof Conversion ){
						Conversion controlledConv = (Conversion )c ;  //BiochemicalReaction|ComplexAssembly|Transport
						// we dont keep only t complex assembl
						// can we  keep as well chem react to have more nodes and edges ...? 

						if(c instanceof BiochemicalReaction ){
							validEntity=false;

						}
						else if(c instanceof BiochemicalReactionImpl ){
							validEntity=false;

						}
						else  if(c instanceof ComplexAssembly ){
							validEntity=true;

						}
						else if(c instanceof ComplexAssemblyImpl ){
							validEntity=true;

						}

						//if(validEntity==false){
						//	throw new Exception("unexpected entity "+c.getClass()+","+c);
						//}
						if(validEntity==true){


							complexAssemblyNode = addSpaimNode(spaimGraph, controlledConv, cat,false);
							complexAssemblyNode.getSpaimCase().add("R2COMPLX");
							complexAssemblyNode.getPatternTag().add(patternCase);
							//TODO RV
							SpaimEdge e0 = addSpaimEdge(spaimGraph, complexAssemblyNode, complxn,cat,SpaimEnum.product);
					 
							//redundante



							Set<PhysicalEntity> inp = controlledConv.getLeft();
							for(PhysicalEntity in:inp){


								SpaimNode n = addSpaimNode(spaimGraph, in, cat,false);

								SpaimEdge e = addSpaimEdge(spaimGraph, n, complexAssemblyNode,cat,SpaimEnum.substrat);
								 
								// logger.info( "  >>>>in:"+in.getDisplayName()+"");


							}
							Set<PhysicalEntity> outp = controlledConv.getRight();
							for(PhysicalEntity ou:outp){


								SpaimNode n = addSpaimNode(spaimGraph, ou, cat,false);

								SpaimEdge e = addSpaimEdge(spaimGraph, complexAssemblyNode, n,cat,SpaimEnum.product);
								 
								// logger.info( "  >>>>out:"+ou.getDisplayName()+"");
							}
						}


					}

				}

				Set<Controller> colr = cont.getController();
				//String s="";
				for(Controller controller:colr){
					boolean validEntity=false;
					boolean addControler=false;
					if(controller instanceof ProteinImpl){
						ProteinImpl o = (ProteinImpl )controller ;
						//s+=  o.getDisplayName();
						validEntity=true;
						addControler=true;
					}
					else if(controller instanceof ComplexImpl){
						ComplexImpl o = (ComplexImpl )controller ;
						//s+=  o.getDisplayName();
						validEntity=true;
						addControler=true;
					}
					else if(controller instanceof PhysicalEntityImpl){
						PhysicalEntityImpl o = (PhysicalEntityImpl )controller ;
						//s+=  o.getDisplayName();
						//logger.info("[WARNING] "+o.getClass().getName()+" found");
						validEntity=true;
						addControler=true;
					}
					/*java.lang.Exception: unexpected entity class org.biopax.paxtools.impl.level3.PathwayImpl,http://pathwaycommons.org/pc2/Pathway_38f5a54cb2e6a6696b2b27eee66e9370
	at dyliss.biopax.graph.SpaimGraphGenerator.subGraphComplex(SpaimGraphGenerator.java:1025)
					 * 
					 */

					//if(validEntity==false){
					//	throw new Exception("unexpected entity "+controller.getClass()+","+controller);
					//}


					// 	getComponent()
					//     getMemberReferences()

					if(complexAssemblyNode==null){
						// throw new Exception("null  complexAssemblyNode "+controller.getClass()+","+controller);

					}else{

						if(addControler==true){
							String ct = SpaimEnum.controlTypeToSpaimCodeValidated(cont,controlType);

							if(ct!=null){
								SpaimNode controllern = addSpaimNode(spaimGraph, controller, cat,false);
								SpaimEdge e = addSpaimEdge(spaimGraph, controllern, complexAssemblyNode,cat,ct);
 							} 
						}


					}
				}


			}

		}else{
			asControl=false;
			//R3 
			// logger.info( "@NEWComplexAssemblyImpl():Complx.getControllerOf.size<0");
			ComplexAssemblyImpl ca = new ComplexAssemblyImpl();

			//to fix pk issue 
			//+
			String  l=complxn.getLabel();
			if(l==null){
				l=complxn.getPk();
			}


			SpaimNode complexAssemblyNode = addSpaimNodeImpl(
					spaimGraph, ca, cat,
					false,"assembly of "+l);
			complexAssemblyNode.setPk(complexAssemblyNode.getLabel()+"|"+complxn.getPk());
			//-


			if(complexAssemblyNode!=null){

				complexAssemblyNode.getSpaimCase().add("R3COMPLX");
				complexAssemblyNode.getPatternTag().add(patternCase);
				Set<PhysicalEntity> inp = complx.getComponent();
				for(PhysicalEntity in:inp){


					SpaimNode n = addSpaimNode(spaimGraph, in, cat,false);

					SpaimEdge e = addSpaimEdge(spaimGraph, n, complexAssemblyNode,cat,SpaimEnum.substrat);
					 
					// logger.info( "  >>>>in:"+in.getDisplayName()+"");

				}

				SpaimEdge e = addSpaimEdge(spaimGraph, complexAssemblyNode, complxn,cat,SpaimEnum.product);
				 

			}
		}
        logger.trace("<<<subGraphComplex:END");

	}




	private SpaimEdge addSpaimEdge(DirectedSparseMultigraph<SpaimNode, SpaimEdge> g,  
			SpaimNode source,SpaimNode target, String spaimTag, String spaim) {



		SpaimEdge  e = new SpaimEdge();

		if(source!=null && target!=null){



			e.setPkFromNodes(source, target);
			




			if(emap.containsKey(e.getPk())){
				e = emap.get(e.getPk());
			}else{
				g.addEdge(e, source,target);	 
				emap.put(e.getPk(),e);
			}
			
			if(e.getSpaimTag()!=null) {
				 
				e.setSpaimTag(e.getSpaimTag()+";"+spaimTag);
			}else {
				e.setSpaimTag(spaimTag);
			}
			
		} 
		
		e.setSpaim(spaim);

		logger.trace(String.format(" !! addSpaimEdge   %s --%s-->%s     %s", 
				source.getLabel(),e.getSpaim(), target.getLabel(),e.getSpaimTag()));

		
		return e;


	}
	private SpaimNode addSpaimNode(DirectedSparseMultigraph<SpaimNode, SpaimEdge> g, 
			BioPAXElement be, String cat ) throws Exception {
		return addSpaimNode( g, be,cat, true) ;
	}

	private SpaimNode addSpaimNode(DirectedSparseMultigraph<SpaimNode, SpaimEdge> g,
			BioPAXElement be, String cat, boolean rec) throws Exception {
		return 	 addSpaimNodeImpl( g,  be, cat,  rec,null);

	}





	private SpaimNode addSpaimNodeImpl(DirectedSparseMultigraph<SpaimNode, SpaimEdge> g,
			BioPAXElement be, String cat, boolean rec,String defaultlabel) throws Exception {


       logger.trace(String.format("    --addSpaimNodeImpl %s %s",be.getClass().getSimpleName(),cat));


		SpaimNode no = null;
		no=new SpaimNode();
		no.setElement(be);

		String label = null;
		if(defaultlabel==null){
			label = defineNodeLabel(no);
		}else{
			label=defaultlabel;
		} 

		if(label==null){

			return null;

		}


		no.setLabel(label);
		no.getSafeLabel();

		no.setDescription(definedDescription(be));


		no.setGroup("");

		if(be.getClass().isAssignableFrom(EntityImpl.class) || be instanceof EntityImpl  ){

			Entity ent = (Entity) be;
			Map<String, Object> prop  =new HashMap<String, Object>();
			if(be.getClass().isAssignableFrom(PhysicalEntityImpl.class) || be instanceof PhysicalEntityImpl  ){
				PhysicalEntity pe=(PhysicalEntity ) be;
		       
		      
		    	if(!(pe instanceof SmallMolecule)) {
					List<Object> hgnc=new ArrayList<Object>();
					hgnc.addAll(identifiers(pe, "hgnc symbol", false, false));
					no.setHgnc(formatStr(join(hgnc,";")));
					
					List<Object> uni=new ArrayList<Object>();
					uni.addAll(identifiers(pe, "uniprot", true, false));
					no.setUniprot(formatStr(join(uni,";")));
				}
				if(pe instanceof SmallMolecule || PhysicalEntity.class.equals(pe.getModelInterface())) {
					List<Object> cheb=new ArrayList<Object>();
					cheb.addAll(identifiers(pe, "chebi", false, false));
					no.setChebi(   formatStr( join(cheb,";")  )   );
				}
		      
				
				List<Object> org=new ArrayList<Object>();
				for(BioSource bs : ModelUtils.getOrganisms(pe)) { 
					org.add(bs.getDisplayName());
					}
				no.setOrganism(  formatStr( join(org,";")  ) );

			
	
				
			}
 			
			no.setUri(formatStr(be.getUri()));
		  no.setGeneric( ModelUtils.isGeneric(be));
		 
			

			List<Object> prov=new ArrayList<Object>();		
			for(Provenance ds : ent.getDataSource()) {
				prov.add(ds.getDisplayName());
			}
			no.setProvider(  formatStr( join(prov,";")  ) );
			
 
			Set<String> nm = ent.getName();
			nm.add(ent.getDisplayName());
			no.setAlias( formatStr( join(nm,";")));
			
			no.setEvidence( formatStr( join(ent.getEvidence(),";")));

 
			logger.trace(no.getLabel());
			
			
		}


 
		String pk = no.getPk();

		SpaimNode fo = findNodeFromPk(no);
		if( fo!=null   ){
			no = fo;
		}else{
			g.addVertex(no);
			vmap.put(pk, no);
		}


		//+ additional processing related to entityReference management
		//  and complex
		if(be.getClass().isAssignableFrom(PhysicalEntityImpl.class) || be instanceof PhysicalEntityImpl  ){
          
	 
			if( isAddEntityReference ==true){ 
				if (SequenceEntity.class.isAssignableFrom(be.getClass())) {
					//add all entityRefecences
					SequenceEntity se = (SequenceEntity) be;
					EntityReference er = se.getEntityReference();
					SpaimNode ern = addSpaimNode(  g,   er,cat);
					addSpaimEdge(g, ern, no,cat,SpaimEnum.product);
				}
			}
			if( isAddComplexComponent ==true && rec==true){ 
				if(be instanceof ComplexImpl){
					ComplexImpl co = (ComplexImpl) be;
					subGraphComplex(co,"R2_R3?",RX_COMPLEX,no);
				}
			}
			 

		}

 

		return no;
	}



	private static Set<String> identifiers(final PhysicalEntity entity, final String xrefdb,
			boolean isPrefix, boolean includeEvidence)
	{
		final Set<String> ids = new HashSet<String>();
		final Fetcher fetcher = (includeEvidence)
				? new Fetcher(SimpleEditorMap.L3, Fetcher.nextStepFilter)
						: new Fetcher(SimpleEditorMap.L3, Fetcher.nextStepFilter, Fetcher.evidenceFilter);
				fetcher.setSkipSubPathways(true); //makes no difference now  but good to have/know...
				Set<XReferrable> children = fetcher.fetch(entity, XReferrable.class);
				children.add(entity); //include itself
				for(XReferrable child : children) {//ignore some classes, such as controlled vocabularies, interactions, etc.
					if (child instanceof PhysicalEntity || child instanceof EntityReference || child instanceof Gene)
						for (Xref x : child.getXref())
							if ((x.getId()!=null && x.getDb()!=null) && (isPrefix)
									? x.getDb().toLowerCase().startsWith(xrefdb.toLowerCase())
											: xrefdb.equalsIgnoreCase(x.getDb()))
							{
								ids.add(x.getId());
							}
				}
				return ids;
	}

	private String formatStr(String s) {
		// s=s.replace( "&apos;"  , "&quot;" );
		//return StringEscapeUtils.escapeHtml4(s);

		return StringEscapeUtils.escapeXml(s);

	}





	private String definedDescription(BioPAXElement be) {
		String d= "";
		String sep=";";
		if(be!=null) {
			if(be.toString()!=null && be.toString().equals("null")) {

			}else {
				d+=be.toString()+sep;
			}
			if(be.getUri()!=null && be.getUri().equals("null")) {

			}else {
				d+=be.toString()+sep;
			}

			if(d.endsWith(sep) ){
				d=removeLastChar(d,sep);
			}
		}

		return d;
	}

	private String join(Iterable<?> set, String sep) {
		String s="";
		String sp=null;
		int sz=0;
		for(Object o : set) {
			sz++;
		}
		int i=0;
		for(Object o : set) {
			if( o!=null && (! o.toString().equals("")) ) {
				i++;
				if( i>=sz ) {
					sp="";
				}
				else{
					sp=sep;
				}
				s+= o.toString()+sp;
			}
		}
		if(s.endsWith(sep) ){
			s=removeLastChar(s,sep);
		}
		return s;
	}

	public String removeLastChar(String str, String sc) {
		char c=sc.charAt(0);
		if (str != null && str.length() > 0 && str.charAt(str.length() - 1) ==c) {
			str = str.substring(0, str.length() - 1);
		}
		return str;
	}
	//FM 02 2020 : adding direct alias system du avoid ducplicate entities
	private SpaimNode findNodeFromPk(SpaimNode no) {

		SpaimNode fo=null; 
		String pk=no.getPk();
		if(vmap.containsKey(pk)) {
			fo=vmap.get(pk);
		}else {
			//TODO : implement alias system to avoid duplicate 
			//alias e.g. for water +H2O
			List<String> alias=alias(no.pkFirstPart()); 
			if(alias!=null) {
				for(String apk : alias) {
					if(vmap.containsKey(apk)) {
						fo=vmap.get(apk);
					}	          		
				}
			}


		}

		return fo;
	}	



	private List<String> alias(String pkFirstPart) {
		// TODO Auto-generated method stub
		return null;
	}

	private String defineNodeLabel(SpaimNode no) {
		BioPAXElement be= no.getElement();
		no.setSimpleuri(SpaimNode.simpleURI(be.getUri()));

        boolean luri=false;
        
		// for graphml output
		String label="";
		if (be.getClass().isAssignableFrom(PhysicalEntity.class) || be instanceof PhysicalEntity ){
			PhysicalEntity o = (PhysicalEntity )be ;
			label=o.getDisplayName() ;
		}
		else if (be.getClass().isAssignableFrom(Interaction.class) || be instanceof Interaction ){
			Interaction o = (Interaction )be ;
			label=o.getDisplayName() ;
		}
		else if (be.getClass().isAssignableFrom(Control.class) || be instanceof Control ){
			Control o = (Control )be ;
			label=o.getDisplayName() ;
		}
		else if (be.getClass().isAssignableFrom(EntityReference.class) || be instanceof EntityReference ){
			EntityReference o = (EntityReference )be ;
			label=o.getDisplayName() ;
		}
		else if (be.getClass().isAssignableFrom(TemplateReactionRegulation.class) || be instanceof TemplateReactionRegulation){
			TemplateReactionRegulation o = (TemplateReactionRegulation )be ;
			label=o.getDisplayName() ;
		}

		else{
			label=be.toString();
		}


		if(label==null  || label.equals("null")){
			if(be instanceof CatalysisImpl){
				CatalysisImpl o = (CatalysisImpl )be ;
				label=o.getDisplayName() ;
				if(label==null){
					label=o.getStandardName();
				}

				if(label==null){
					label="CATALYSIS|"+be.toString();
				}
			}
			if(be instanceof TemplateReactionRegulationImpl){
				TemplateReactionRegulationImpl o = (TemplateReactionRegulationImpl )be ;
				label=o.getDisplayName() ;
				if(label==null){
					label=o.getStandardName();
				}



				if(label==null){
					label="CATALYSIS|"+be.toString();
				}
			}
			else if (be.getClass().isAssignableFrom(Interaction.class) || be instanceof Interaction ){
				Interaction o = (Interaction )be ;
				label=o.getDisplayName() ;
				if(label==null){
					label=o.getStandardName();

				}

				label=no.getSimpleuri();
				luri=true;
			}
			else{

				label=no.getSimpleuri();
				luri=true;
			}
		}

		if(label == null){
			label=defineLabelfx(be);
			luri=true;
		}



		if (be.getClass().isAssignableFrom(ComplexAssemblyImpl.class) ||
				be instanceof ComplexAssemblyImpl){ 
			if(label == null){
				label= defineComplexAssemblyID(be, label);
			}
		}
        
     if(luri==true && no.getBiopaxType()!=null && label!=null && label.startsWith("http:") && label.contains(no.getBiopaxType())) {
			/*
			 //to be tested (unique values /vs double???)
		   try {
			URI uri =new URI(no.getUri());
			label=uri.getPath();
		  } catch ( Exception e) {
			
		  }	
		   */
		}
		return label;
	}

	private String defineComplexAssemblyID(BioPAXElement be, String lb) {
		String joined=null;


 
		Conversion o = (Conversion )be ;



		lb=o.getDisplayName() ;

		List<String> plabl = new ArrayList<String>();
 

		for(Stoichiometry  p:	o.getParticipantStoichiometry()){
			String v=defineLabelfx((BioPAXElement) p);
			if(v!=null){

				plabl.add(v);

			}
		}

		for(Entity p:	o.getParticipant()){
			String v=defineLabelfx((BioPAXElement) p);
			if(v!=null){

				plabl.add(v);

			}
		}

		for(Entity p:	o.getRight()){
			String v=defineLabelfx((BioPAXElement) p);
			if(v!=null){

				plabl.add(v);

			}
		}

		for(Entity p:	o.getLeft()){
			String v=defineLabelfx((BioPAXElement) p);
			if(v!=null){

				plabl.add(v);

			}
		}



		if(lb != null){
			plabl.add(lb);
		}
		sortByStringLength(plabl);
		joined = Joiner.on("").join(plabl);
		if(joined!=null && !joined.equals("")){
			return joined;
		}else{
			return null;
		}
	}


	private void sortByStringLength( List<String> plabl) {	

		Ordering<String> byLength = new Ordering<String>() {
			@Override
			public int compare(String s1, String s2) {
				return Ints.compare(s1.length(), s2.length());
			}
		};


		Collections.sort(plabl,byLength.nullsFirst().reverse());
	}
	/*
	 * 
	 */

	/**
	 * The method returns the smallest entity having a name, i.e. a gene symbol,
	 * which could be parsed
	 * 
	 * @param entity
	 * @return Collection containing {@link entity}s having a name and are not
	 *         instance of a complex or ComplexAssembly
	 */

	/*protected Collection<? extends entity> getEntitiesWithName(Entity entity) {
	    Set<entity> resEntities = new HashSet<entity>();
	    String name = entity==null?null:entity.getNAME();

	    if (name!=null && !name.isEmpty() && !(pathway.class.isAssignableFrom(entity.getClass()))) {
	      if (complex.class.isAssignableFrom(entity.getClass())) {
	        complex c = (complex) entity;
	        for (physicalEntityParticipant pe : c.getCOMPONENTS()) {
	          resEntities.addAll(getEntitiesWithName(pe.getPHYSICAL_ENTITY()));
	        }
	      } else if (complexAssembly.class.isAssignableFrom(entity.getClass())) {
	        complexAssembly c = (complexAssembly) entity;
	        for (InteractionParticipant pe : c.getPARTICIPANTS()) {
	          resEntities.addAll(getEntitiesWithName(((physicalEntityParticipant)pe).getPHYSICAL_ENTITY()));          
	        }

	      } else {
	        resEntities.add(entity);
	      }
	    } 
	    return resEntities;
	  }  
	 */

	/*
	 *from 
	 *https://github.com/PathwayCommons/CyPath2/blob/master/src/main/java/org/pathwaycommons/cypath2/internal/BioPaxMapper.java
	 * 
	 */


	/*
	 * Given a binding element (complex or interaction)
	 * and type (like left or right),
	 * returns chemical modification (abbreviated form).
	 */
	private static Set<String> getInteractionChemicalModifications(BioPAXElement participantElement) 
	{
		if(participantElement == null) {
			return null;
		}

		final Set<String> chemicalModificationsSet = new HashSet<String>();

		// if we are dealing with participant processes (interactions
		// or complexes), we have to go through the participants to get the
		// proper chemical modifications
		Collection<?> modificationFeatures = getValues(participantElement, "feature");
		if (modificationFeatures != null) {
			for (Object modification : modificationFeatures) {
				if (modification != null) {
					Object value = getValue((BioPAXElement) modification, "modificationType");
					if (value != null) {
						String mod = value.toString();
						//remove the ClassName_ prefix and square braces -
						mod = mod.substring(mod.indexOf("_") + 1).replaceAll("\\[|\\]", "");
						chemicalModificationsSet.add(mod);
					}
				}
			}
		}

		Collection<?> modificationNotFeatures = getValues(participantElement, "notFeature");
		if (modificationNotFeatures != null) {
			for (Object modification : modificationNotFeatures) {
				if (modification != null) {
					Object value = getValue((BioPAXElement) modification, "modificationType");
					if (value != null) {
						String mod = value.toString();
						//remove the ClassName_ prefix and square braces;
						//add "!" upfront (i.e. "NOT")
						mod = "!" + mod.substring(mod.indexOf("_") + 1).replaceAll("\\[|\\]", "");
						chemicalModificationsSet.add(mod);
					}
				}
			}
		}

		return  chemicalModificationsSet ;
	}

	/*
	 *from 
	 *https://github.com/PathwayCommons/CyPath2/blob/master/src/main/java/org/pathwaycommons/cypath2/internal/BioPaxMapper.java
	 * 
	 */

	/**
	 * Attempts to get the value of any of the BioPAX properties
	 * in the list.
	 * @param bpe BioPAX Element
	 * @param properties BioPAX property names
	 * 
	 * @return the value or null
	 */
	public static Object getValue(BioPAXElement bpe, String... properties) {
		for (String property : properties) {
			try {
				Method method = bpe.getModelInterface().getMethod(
						"get" + property.substring(0, 1).toUpperCase()
						+ property.substring(1).replace('-', '_'));
				Object invoke = method.invoke(bpe);
				if (invoke != null) {
					return invoke;
				}
				//				PropertyEditor editor = SimpleEditorMap.L3
				//					.getEditorForProperty(property, bpe.getModelInterface());
				//				return editor.getValueFromBean(bpe); // is always a Set!
			} catch (Exception e) {
				e.printStackTrace();
				/*
				if(log.isDebugEnabled()) {
					// this is often OK, as we guess L2 or L3 properties...
					log.debug("Ignore property " + property + " for " 
						+ bpe.getUri() + ": " + e);
				}*/
			}
		}
		return null;
	}

	/*
	 *from 
	 *https://github.com/PathwayCommons/CyPath2/blob/master/src/main/java/org/pathwaycommons/cypath2/internal/BioPaxMapper.java
	 * 
	 */

	/**
	 * Attempts to get the values of specified BioPAX properties.
	 * @param bpe BioPAX Element
	 * @param properties BioPAX property names
	 * 
	 * @return the set of property values or null
	 */
	public static Collection<?> getValues(BioPAXElement bpe, String... properties) {
		Collection<Object> col = new HashSet<Object>();

		for (String property : properties) {
			try {
				Method method = bpe.getModelInterface().getMethod(
						"get" + property.substring(0, 1).toUpperCase()
						+ property.substring(1).replace('-', '_'));

				Object invoke = method.invoke(bpe);
				if (invoke != null) {
					// return value can be collection or Object
					if (invoke instanceof Collection) {
						col.addAll((Collection) invoke);
					} else {
						col.add(invoke);
					}
				}
			} catch (Exception e) {
				e.printStackTrace();
				/*if(log.isDebugEnabled()) {
				log.debug("Cannot get value of '" + property + "' for "
					+ bpe.getUri() + ": " + e);
			}*/
			}


		}

		return col;
	}
	/*
	 *from 
	 *https://github.com/PathwayCommons/CyPath2/blob/master/src/main/java/org/pathwaycommons/cypath2/internal/BioPaxMapper.java
	 * 
	 */


	public static String defineLabelfx(BioPAXElement element) {

		String label = defineNamefx(element);

		if (!(element instanceof Interaction)) {
			// get chemical modification & cellular location attributes
			Set<String> chemicalModificationsWrapper = getInteractionChemicalModifications(element);
			// set node attributes
			if(chemicalModificationsWrapper != null) {
				// add modifications to the label/name
				label += chemicalModificationsWrapper.toString();
				 
			}

			// add cellular location to the label/name
			if(element instanceof PhysicalEntity) {
				CellularLocationVocabulary cl = ((PhysicalEntity) element).getCellularLocation();
				if(cl != null) {
					String terms = cl.toString();//it's like CellularLocationVocabulary_terms...
					terms =  terms.substring(terms.indexOf("_") + 1).replaceAll("\\[|\\]", "");
					label += (terms.length() > 0) ? ("; " + terms) : "";
				}
			}
		}
		return label;
	}

	/*
	 *from 
	 *https://github.com/PathwayCommons/CyPath2/blob/master/src/main/java/org/pathwaycommons/cypath2/internal/BioPaxMapper.java
	 * 
	 */


	public static String defineNamefx(BioPAXElement bpe) {

		String nodeName = null;
		if(bpe instanceof Named)
			nodeName = ((Named)bpe).getDisplayName();
		String r=null;
		if(nodeName == null || nodeName.isEmpty()){
			r=  bpe.getUri();
		}
		else{
			r=  StringEscapeUtils.unescapeHtml4(nodeName);
		}
		return r;
	}


	public static void normalize(Model m) throws URISyntaxException {
		//merge interactions with exactly same properties...
		ModelUtils.mergeEquivalentInteractions(m);
		//some extra normalization to get better conversion results
		ModelUtils.normalizeGenerics(m); //TODO not sure want to apply this...
		for(SimplePhysicalEntity spe : new HashSet<SimplePhysicalEntity>(m.getObjects(SimplePhysicalEntity.class))) {
			ModelUtils.addMissingEntityReference(m, spe);
			URI uri = new URI(spe.getUri());
			//logger.info(" "+spe.getDisplayName()+" ---- "+uri.getFragment());
		}
	}

	public   RawPatternSearchResult rawPatternSearch(
			Model m,
			SIFType[] sifTypes, //SIF rules/patterns to apply/search
			Blacklist blacklist 
			) throws Exception
	{
		SpaimGraphGenerator.normalize(m);


		Pattern p =null;
		Map<BioPAXElement, List<Match>> matches =null;
		String report="";


		ArrayList<DirectedSparseMultigraph<SpaimNode, SpaimEdge>> glist = new ArrayList<DirectedSparseMultigraph<SpaimNode, SpaimEdge>>();


		//R1
		//NOT found with glucose metab file
		//found with mapK.owl
		logger.info("**************CASE_R1*******************");
		int r1ct=-1;
		int r1ct1=-1; 
		int r1ct2=-1;
		int rphospho=-1;
		int r2ct=-1;
		int rcomplx1=-1;
		int rcomplx2=-1;
		int r3ct= -1;

		logger.info("**************CASE_R1_1*******************");
		p =SpaimPatternBox.controlsExpressionWithTemplateReac();
		matches = PatternSearcher.search(m, p);
		r1ct1= MainGenerator.countPatternSearchResult(p, matches);


		this.subGraphControlsExpressionWithTemplateReac(p, matches);


		logger.info("**************CASE_R1_2*******************");
		p =SpaimPatternBox.controlsExpressionWithConversion();
		matches = PatternSearcher.search(m, p);
		r1ct2= MainGenerator.countPatternSearchResult(p, matches);
		r1ct=r1ct1+r1ct2;

		this.subGraphControlsExpressionWithConversion(p, matches); 


		logger.info("**************CASE_R1_3*******************");
		p =SpaimPatternBox.controlsPhosphorylation();
		matches = PatternSearcher.search(m, p);
		rphospho= MainGenerator.countPatternSearchResult(p, matches);
		this.subGraphControlPhospho(p, matches);


		//R2
		//found with glucose metab file
		logger.info("**************CASE_R2_1*******************");
		p =SpaimPatternBox.controlsMetabolicCatalysis(blacklist, true);
		matches = PatternSearcher.search(m, p);
		r2ct=  MainGenerator.countPatternSearchResult(p, matches);
		this.subGraphControlsMetabolicCatalysis(p, matches);





		//R3
		//found with glucose metab file
		logger.info("**************CASE_R3*******************");
		logger.info("**************CASE_R3_1*******************");

		//HERE

		// ******WARNING***** :  must manage case R3 with only one substrate
		p =SpaimPatternBox.reactsWith(blacklist);
		matches = PatternSearcher.search(m, p);
		int  r3ct1=  MainGenerator.countPatternSearchResult(p, matches);
		//sgg.generateSubGraphFromPatternMatches(p,   matches,SpaimGraphGenerator.R3_REACTSWITH);
		this.subGraphReactWith(p, matches);

		logger.info("**************CASE_R3_2*******************");
		// ******WARNING***** :  must manage case R3 with only one substrate
		p =SpaimPatternBox.usedToProduce(blacklist);
		matches = PatternSearcher.search(m, p);
		int  r3ct2=  MainGenerator.countPatternSearchResult(p, matches);
		//sgg.generateSubGraphFromPatternMatches(p,   matches,SpaimGraphGenerator.R3_REACTSWITH);
		this.subGraphReactWith(p, matches);


		r3ct=r3ct1+r3ct2;
		logger.info("**************CASE_R3_3*******************");
		p =SpaimPatternBox.inComplexWith();
		matches = PatternSearcher.search(m, p);
		rcomplx1= MainGenerator.countPatternSearchResult(p, matches);


		this.subGraphInComplexWithOrInSameComplex(p, matches, "R2_R3?",RX_INCOMPLEXWITH);


		logger.info("**************CASE_R3_4*******************");
		p =SpaimPatternBox.inSameComplex();
		matches = PatternSearcher.search(m, p);
		rcomplx2= MainGenerator.countPatternSearchResult(p, matches);


		this.subGraphInComplexWithOrInSameComplex(p, matches, "R2_R3?",RX_INSAMECOMPLEX);



		report+=" R1="+r1ct;
		report+=" R2="+r2ct;
		report+=" R3="+r3ct;
		report+=" RPHOSPHO="+rphospho;
		report+=" RCOMPLX1="+rcomplx1;
		report+=" RCOMPLX2="+rcomplx2;


		glist.add(this.getSpaimGraph());
		RawPatternSearchResult rp = new RawPatternSearchResult(  report,  glist);
		return rp;

	}



}
