package dyliss.biopax.app;
import static dyliss.biopax.pattern.ConBox.controlToConv;
import static dyliss.biopax.pattern.ConBox.erToPE;
import static dyliss.biopax.pattern.ConBox.linkToComplex;
import static dyliss.biopax.pattern.ConBox.linkToSimple;
import static dyliss.biopax.pattern.ConBox.linkedER;
import static dyliss.biopax.pattern.ConBox.notGeneric;
import static dyliss.biopax.pattern.ConBox.participantER;
import static dyliss.biopax.pattern.ConBox.peToControl;
import static dyliss.biopax.pattern.ConBox.peToER;
import static dyliss.biopax.pattern.ConBox.type;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import javax.xml.transform.OutputKeys;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.Merger;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.controller.SimpleMerger;
import org.biopax.paxtools.impl.level3.BiochemicalReactionImpl;
import org.biopax.paxtools.impl.level3.ComplexAssemblyImpl;
import org.biopax.paxtools.impl.level3.ComplexImpl;
import org.biopax.paxtools.impl.level3.ProteinImpl;
import org.biopax.paxtools.impl.level3.ProteinReferenceImpl;
import org.biopax.paxtools.io.BioPAXIOHandler;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.BiochemicalReaction;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.Controller;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.Named;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.SequenceEntityReference;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.model.level3.SmallMolecule;
import org.biopax.paxtools.model.level3.SmallMoleculeReference;
import org.biopax.paxtools.pattern.Constraint;
import org.biopax.paxtools.pattern.MappedConst;
import org.biopax.paxtools.pattern.Match;
import org.biopax.paxtools.pattern.Pattern;
import org.biopax.paxtools.pattern.constraint.ConBox;
import org.biopax.paxtools.pattern.constraint.ConversionSide;
import org.biopax.paxtools.pattern.constraint.Equality;
import org.biopax.paxtools.pattern.constraint.InterToPartER;
import org.biopax.paxtools.pattern.constraint.LinkedPE;
import org.biopax.paxtools.pattern.constraint.ModificationChangeConstraint;
import org.biopax.paxtools.pattern.constraint.NOT;
import org.biopax.paxtools.pattern.constraint.Participant;
import org.biopax.paxtools.pattern.constraint.ParticipatesInConv;
import org.biopax.paxtools.pattern.constraint.PathConstraint;
import org.biopax.paxtools.pattern.constraint.SelfOrThis;
import org.biopax.paxtools.pattern.constraint.XOR;
import org.biopax.paxtools.pattern.miner.BlacklistGenerator;
import org.biopax.paxtools.pattern.miner.CustomFormat;
import org.biopax.paxtools.pattern.miner.IDFetcher;
import org.biopax.paxtools.pattern.miner.OutputColumn;
import org.biopax.paxtools.pattern.miner.SIFInteraction;
import org.biopax.paxtools.pattern.miner.SIFSearcher;
import org.biopax.paxtools.pattern.miner.SIFToText;
import org.biopax.paxtools.pattern.miner.SIFType;
import org.biopax.paxtools.pattern.util.Blacklist;
import org.biopax.paxtools.pattern.util.RelType;
import org.cytoscape.work.util.ListMultipleSelection;
import org.jdom.JDOMException;

import dyliss.biopax.BioPax2SpaimMapper;
import dyliss.biopax.GraphConfig;
import dyliss.biopax.GraphWriter;
import dyliss.biopax.db.SpaimGraph2Validator;
import dyliss.biopax.db.SpaimGraphDBWriter;
import dyliss.biopax.graph.RawPatternSearchResult;
import dyliss.biopax.graph.SpaimEdge;
import dyliss.biopax.graph.SpaimGraphGenerator;
import dyliss.biopax.graph.SpaimNode;
import dyliss.biopax.pattern.SpaimPatternBox;
import dyliss.biopax.pattern.SpaimSIFEnum;
import dyliss.biopax.util.BioPaxReaderError;
import dyliss.biopax.util.LogUtils;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;


public class MainGenerator {
	/*
* **************REPORT*******************
* 

biopax file =/home/fm/Documents/keyreg/data/PathwayCommons.8.reactome.BIOPAX.owl
R1=1370 R2=2325 R3=272
 

biopax file =/home/fm/Documents/workspace/biopax_cyto/data/mapK.owl
 
 R1=151 R2=693 R3=98 RPHOSPHO=301 RCOMPLX1=2456 RCOMPLX2=2724
 
biopax file =/home/fm/Documents/workspace/biopax_cyto/data/glycolyse_biopax3_reactome_71387.owl
 R1=0 R2=208 R3=88
 
biopax file =/home/fm/Documents/workspace/biopax_cyto/data/glucose.owl
 R1=0 R2=208 R3=88
 
 biopax file =/home/fm/Documents/workspace/biopax_cyto/data/G6P_cropped.owl
 R1=0 R2=9 R3=0
 
*********************************
*
*
	 */

/** INTERESTING PATTERNS:
 * 
 * 
	 * Pattern for a EntityReference has a member PhysicalEntity that is controlling a state change
	 * reaction of another EntityReference.

controlsStateChange()

	  
	 * Pattern for a EntityReference has a member PhysicalEntity that is controlling a state change
	 * reaction of another EntityReference. In this case the controller is also an input to the
	 * reaction. The affected protein is the one that is represented with different non-generic
	 * physical entities at left and right of the reaction.
	
 controlsStateChangeBothControlAndPart()
	  
	 * Pattern for a EntityReference has a member PhysicalEntity that is controlling a state change
	 * reaction of another EntityReference. This pattern is different from the original
	 * controls-state-change. The controller in this case is not modeled as a controller, but as a
	 * participant of the conversion, and it is at both sides.
	  controlsStateChangeButIsParticipant()
 
	 * Pattern for a Conversion has an input PhysicalEntity and another output PhysicalEntity that
	 * belongs to the same EntityReference.
	 *
stateChange(Pattern p, String ctrlLabel)
 
	 * Pattern for an entity is producing a small molecule, and the small molecule controls state
	 * change of another molecule.
	 * controlsStateChangeThroughControllerSmallMolecule(Blacklist blacklist)
	  
	 * Finds cases where proteins affect their degradation.
controlsStateChangeThroughDegradation()
	  
 * controlsPhosphorylation
 
controlsPhosphorylation()
  
	 * Pattern for a Protein controlling a reaction whose participant is a small molecule.
	 *
controlsMetabolicCatalysis(Blacklist blacklist, boolean consumption)
	  
	 * Finds transcription factors that trans-activate or trans-inhibit an entity.

controlsExpressionWithTemplateReac()
	 
	 * Finds the cases where transcription relation is shown using a Conversion instead of a
	 * TemplateReaction.
controlsExpressionWithConversion()
	 
	 * A small molecule controls an interaction of which the protein is a participant.

chemicalAffectsProteinThroughControl()
	 
	 * Constructs a pattern where first and last small molecules are substrates to the same
	 * biochemical reaction.
	 *
reactsWith(Blacklist blacklist)
 * @throws Exception 

	 */
	


 
	 // Pattern for the activity of an EntityReference is changed through a Conversion.
	 
	 //public static Pattern actChange(boolean activating,


	public static void main(String[] args) throws Exception {
		
		Integer  controlVersion=2;
		String propFilePath = null;
        if(args==null){
        	propFilePath = "config.properties";
        	System.err.println("no properties file found. using default file location: "+new File(propFilePath).getAbsolutePath());
        }else{
        	propFilePath =args[0];
        }
        if(!new File(propFilePath).exists()){
        	System.err.println("  properties file does not exist or not accessible: "+new File(propFilePath).getAbsolutePath());
        	System.exit(0);
        }
        
		GraphConfig gc = new GraphConfig(propFilePath);
		
		LogUtils.info(":gc.isDoSpaim()"+gc.isDoSpaim());
		LogUtils.info(":gc.isDoMerge()"+gc.isDoMerge());
		
		if(gc.isDoSpaim()){
			MainGenerator b = new MainGenerator();
			LogUtils.info("***start spaim generator");
			b.runDoSpaim(gc,  controlVersion);
		}
		if(gc.isDoMerge()){
			MainGenerator b = new MainGenerator();
			LogUtils.info("***start merge ");
		    createMergedBioPax(gc);
		}
		if(gc.isDoVizu()){
			 
		  LogUtils.info("***start do vizualization ");
		  VizuGenerator vz = new VizuGenerator(gc,2);
		  vz.generateVizFile(propFilePath);
		}
	}

public static void createMergedBioPax(GraphConfig gc ) throws IOException, FileNotFoundException {
	 
	String ouputBiopaxFilePath=gc.getOuputBiopaxFilePath();
	 List<Model> models=new ArrayList<Model>();
 
	String biopaxInDir= gc.getBiopaxInDir();
	
	
	LogUtils.info("***biopaxInDir:"+biopaxInDir);
	
	File dir = new File(biopaxInDir);
	File[] biopaxFileList = dir.listFiles(new FilenameFilter() {
	    public boolean accept(File dir, String name) {
	        return name.toLowerCase().endsWith(".owl");
	    }
	});
	for(File f:biopaxFileList){
		models.add(readBiopax3File(f));
	}
	
	 mergeBioPax3ToFile(ouputBiopaxFilePath,models);
}

public static void mergeBioPax3ToFile(String outFilePath, List<Model> models) throws FileNotFoundException, IOException {
	
			EditorMap editorMap = SimpleEditorMap.L3;
			Model targetModel =editorMap.getLevel().getDefaultFactory().createModel();
 
	        SimpleMerger merger = new SimpleMerger(editorMap);
	        BioPAXIOHandler handler = new SimpleIOHandler();
	        
	       
			File outFile= new File(outFilePath);;
			OutputStream outputStream=new FileOutputStream(outFile);
	 
		 
			int i=0;
			Model modelLast =null;
			for(Model modelCurrent:models){
				if(i>0){
					merger.merge(targetModel, modelLast, modelCurrent);
					modelLast=targetModel;
				}else{
					modelLast=modelCurrent;	
				}
				
				i++;
			 }
	       handler.convertToOWL(targetModel, outputStream);
	       outputStream.close();
}
	

public static void  writeBioPax3ToFile(String outFilePath, Model  modelCurrent ) throws FileNotFoundException, IOException {
	
			 
	        BioPAXIOHandler handler = new SimpleIOHandler();
	        
	       
			File outFile= new File(outFilePath);;
			OutputStream outputStream=new FileOutputStream(outFile);
 
			 
	       handler.convertToOWL(modelCurrent, outputStream);
	       outputStream.close();
}

	 
	public   void  runDoSpaim(GraphConfig gc,Integer  controlVersion) throws Exception {
		
		
		
		
		 String blackListFile= gc.getBlackListFilePath();
		 String graphmlOutputFilePath= gc.getGraphmlOutputFilePath();
		 File inputBiopaxFile =   new File(gc.getInputBiopaxFilePath()) ;
		 
		 Boolean doGenerateBlackList=gc.isDoGenerateBlackList();
		 Boolean addEntityReference = gc.isAddEntityReference();
		 Boolean addComplexComponent = gc.isAddComplexComponent();
		 Boolean doGraphml = gc.isDoGraphml(); 
		 
		 String graphmlTemplateFilePath = gc.getGraphmlTemplateFilePath();
		 
		 Boolean doDB = gc.isDoDB();
		 Boolean doDBtoFile = gc.isDoDBtoFile();
		 Boolean doHub= gc.isDoHub();
		 String hubFile=gc.getHubFile();
		 String dBFile=gc.getDBFile();
		 String dbDriver=gc.getDbDriver();
		 String dbUser=gc.getDbUser();
		 String dbUrl=gc.getDbUrl();
		 String dbPassword=gc.getDbPassword();
		  
	   
		 
		 
		
		runDoSpaim(
				blackListFile, graphmlOutputFilePath, inputBiopaxFile, 
				doGenerateBlackList, addEntityReference,
				addComplexComponent, doGraphml, graphmlTemplateFilePath,
				doDB, doDBtoFile, doHub, hubFile, dBFile,
				dbDriver, dbUser, dbUrl, dbPassword,   controlVersion
				);
	
	}

	public void runDoSpaim(String blackListFile, String graphmlOutputFilePath, File inputBiopaxFile,
			Boolean doGenerateBlackList, Boolean addEntityReference, Boolean addComplexComponent, Boolean doGraphml,
			String graphmlTemplateFilePath, Boolean doDB, Boolean doDBtoFile, Boolean doHub, String hubFile,
			String dBFile, String dbDriver, String dbUser, String dbUrl, String dbPassword, Integer controlVersion)
			throws Exception {
		
		
		LogUtils.info("*************runDoSpaim::1********************");
		
		
		HashMap<String,String> mapBench = null;
		 
		Model model = readBiopax3File(inputBiopaxFile);
		if(model != null){
			fixDisplayName(model) ;
		}
		Blacklist blacklist =null;
		
		
		LogUtils.info(String.format("*************runDoSpaim::1.1:doGenerateBlackList:%s********************",doGenerateBlackList));
	
		if(doGenerateBlackList==true){
			generateBlackListFromModel(model, blackListFile);
		}
	 
		blacklist = new Blacklist(blackListFile);
		
		LogUtils.info("*************runDoSpaim::2********************");
		
		ListMultipleSelection<SIFType> sifSelection;
		
			// init the SPAIM rules/patterns list
	 
		SIFType[] selectedSifType = {SpaimSIFEnum.TEST_CONTROLS_STATE_CHANGE_OF};
 
		sifSelection = new ListMultipleSelection<SIFType>(selectedSifType);
		sifSelection.setSelectedValues(sifSelection.getPossibleValues());
	        
 
	 		 RawPatternSearchResult rp;
		try {
			
			LogUtils.info("*************runDoSpaim::3********************");
			SpaimGraphGenerator sgg = new SpaimGraphGenerator(
					 addEntityReference,
					 addComplexComponent,
					 mapBench,controlVersion);
			
			 rp = sgg.rawPatternSearch(model,sifSelection.getSelectedValues().toArray(new SIFType[]{}),
					 blacklist);
			 LogUtils.info("**************REPORT*******************");
			 LogUtils.info("biopax file ="+inputBiopaxFile.getAbsolutePath());		
			 LogUtils.info("*********************************");
			 LogUtils.info(rp.getReport());
			 LogUtils.info("*********************************");
			 
			 
			if( rp.getGraphList().size()>0){
				
				 LogUtils.info("*************runDoSpaim::4.0.1********************");
				 DirectedSparseMultigraph<SpaimNode, SpaimEdge> g = rp.getGraphList().get(0);
				
				if(doGraphml){
					LogUtils.info("*************runDoSpaim::4.1********************");
					File graphmlTemplateFile = new File(graphmlTemplateFilePath);
					 LogUtils.info(inputBiopaxFile.getName());
					 LogUtils.info(graphmlOutputFilePath);
					 LogUtils.info(graphmlTemplateFile);
					 LogUtils.info("*********************************graphmlOutputFile:"+graphmlOutputFilePath);
					 LogUtils.info("*********************************");
				    //02 2020 new version with export attribute
					 SpaimGraph2Validator g2v= new SpaimGraph2Validator();
					 g2v.iterateAndComplete(g);		
					 
					 GraphWriter.writeGraphToGraphmlFile( 
							 FilenameUtils.getBaseName(
									 inputBiopaxFile.getName()), g,
							 graphmlOutputFilePath ,graphmlTemplateFile	); 
				 }
			
				if(doDB || doDBtoFile){
					
					
					LogUtils.info("*************runDoSpaim::5********************");
					 SpaimGraphDBWriter sgw = new SpaimGraphDBWriter( 	
							doDB  , doDBtoFile  ,	
							 doHub  ,hubFile  ,dBFile ,
							dbDriver ,dbUrl ,
							dbUser ,dbPassword 
								);
	 
					 sgw.iterateAndComplete(g);			 }
				 
				 
				}else{
				LogUtils.info("*************runDoSpaim::4.0.2********************");
				LogUtils.info("************no graph*********");
			}
		} catch (Exception e) {
			LogUtils.info("*************runDoSpaim::error:"+e.getMessage()+"********************");
			e.printStackTrace();
		}
		
		LogUtils.info("*************runDoSpaim::end********************");
	}

	private void confBench(GraphConfig gc, HashMap<String, String> mapBench) throws IOException {
		String bench1 =gc.getBench1(); 
		String bench2 =gc.getBench2(); 
		String bench3 =gc.getBench3(); 
		
		String tag1 = gc.getBenchtag1();//"GLYCOLYSE";
		String tag2 = gc.getBenchtag2();//"PPAR";
		String tag3 = gc.getBenchtag3();//"LXR";
		

		addTag(parseIds(bench1), tag1, mapBench);
		addTag(parseIds(bench2), tag2, mapBench);
		addTag(parseIds(bench3), tag3, mapBench);
	}
	

	/**
	 * For all Named biopax objects, sets 'displayName'
	 * from other names if it was missing.
	 * 
	 * @param model
	 */
	public static void fixDisplayName(Model model) {
		//log.info("Trying to auto-set displayName for all BioPAX elements");
		// where it's null, set to the shortest name if possible
		//  LogUtils.info("@@INFO::0:::fixDisplayName"); 
		/* 
		for (ComplexAssemblyImpl e : model.getObjects(ComplexAssemblyImpl.class)) {
			 
			  LogUtils.info("@@INFO::1:fixDisplayName:"+e.getClass()+e.toString()); 
	
			 
		}*/
		for (Named e : model.getObjects(Named.class)) {
			/*
			 if (e.getClass().isAssignableFrom(ComplexAssemblyImpl.class) ||
					 e instanceof ComplexAssemblyImpl){ 
					  LogUtils.info("@@INFO::2:fixDisplayName:"+e.getClass()+e.toString()); 

			}*/
			
			if (e.getDisplayName() == null) {
				if (e.getStandardName() != null) {
					e.setDisplayName(e.getStandardName());
				} else if (!e.getName().isEmpty()) {
					String dsp = e.getName().iterator().next();
					for (String name : e.getName()) {
						if (name.length() < dsp.length())
							dsp = name;
					}
					e.setDisplayName(dsp);
				}
			}
			 //TODO displayname=> uri 
			//  LogUtils.info("@@INFO::3:fixDisplayName:"+e.getClass()+e.getUri()+e.getDisplayName());
		}
		// if required, set PE name to (already fixed) ER's name...
		for(EntityReference er : model.getObjects(EntityReference.class)) {
			for(SimplePhysicalEntity spe : er.getEntityReferenceOf()) {
				if(spe.getDisplayName() == null || spe.getDisplayName().trim().length() == 0) {
					if(er.getDisplayName() != null && er.getDisplayName().trim().length() > 0) {
						spe.setDisplayName(er.getDisplayName());
					}
				}
			}
		}
		
	
		 
	}


	public static Model readBiopax3File(File inputBiopaxFile) throws IOException, FileNotFoundException {
		File tmpf = File.createTempFile("tmp_biopax2sif", ".xml");
		LogUtils.info(tmpf.getAbsolutePath());
		formatFlat(inputBiopaxFile,tmpf ) ;
		
		InputStream stream = new FileInputStream(tmpf);
		
		//test1(outputSifFile, stream);
		
		// import BioPAX data into a new in-memory model
		Model model = null;
		try {
			//model = BioPax2SpaimMapper.read(copy(stream));
			//changed for outofmemory issue
			model = BioPax2SpaimMapper.read(stream);
		} catch (Throwable e) {
			e.printStackTrace();
			throw new BioPaxReaderError("failed to build a BioPAX model " +
					" - " + e);
		}
		
		if(model == null) {
			throw new BioPaxReaderError("did not find any BioPAX data there.");
		}
		return model;
	}

	private void addTag(ArrayList<String> bench1L, String tag, HashMap mapB) {
		ArrayList<String> ba = bench1L;
		for(String id:ba){
			
			mapB.put(id.toUpperCase(), tag);
		}
	}

	private ArrayList<String> parseIds(String pf) throws IOException {
		ArrayList<String> ar = new ArrayList<String>();
		List<String> lines=FileUtils.readLines(new File(pf));
		for(String l:lines){
			l=l.trim();
			if(l.startsWith("#")){
				
			}else{
				ar.add(l);
			}
		}
		return ar;
	}
	
@Deprecated
	private void generateBlackListFromModel(Model model, String blackListFile) throws FileNotFoundException {
		try{
			
			
			File blFile = new File(blackListFile);
			//blFile.getParentFile().mkdirs();
			blFile.createNewFile();  
			FileOutputStream oFile = new FileOutputStream(blFile, false); 
			
			Blacklist blacklist;
			BlacklistGenerator gen = new BlacklistGenerator();
			blacklist = gen.generateBlacklist(model);
			blacklist.write(oFile);
		}catch(Exception e){
			e.printStackTrace();
		}
	}
	
	
	public static int countPatternSearchResult(Pattern p, Map<BioPAXElement, List<Match>> map) {
		boolean verbose=false;
		
		int ct=0;
		if(map==null){return ct;}
		// In this case, keys of the result map will all be Conversion objects and 
		// values will contain list of the related pattern matches.
		// Values of elements in a result Match can be accessed using the label of the element.
		for(Entry<BioPAXElement, List<Match>> ent  : map.entrySet()){
			ct++;
			BioPAXElement k = ent.getKey();
			  if(k!=null){
				  
				  if(verbose==true){
							  
						String klbl=k.toString();
						
						if(k.getClass().isAssignableFrom(SequenceEntityReference.class) || k  instanceof SequenceEntityReference ){
							SequenceEntityReference o = (SequenceEntityReference) k;
							klbl+=": "+o.getDisplayName();
						}
						else if(k.getClass().isAssignableFrom(ProteinReferenceImpl.class)){
							ProteinReferenceImpl o = (ProteinReferenceImpl) k;
							klbl+=":: "+o.getDisplayName();
						}
						else if(k.getClass().isAssignableFrom(SmallMoleculeReference.class)  || k  instanceof SmallMoleculeReference  ){
							SmallMoleculeReference o = (SmallMoleculeReference) k;
							klbl+=":: "+o.getDisplayName();
						}
						
				  LogUtils.info("\n----------------0key:"+klbl +"\n");
				  List<Match> v = ent.getValue();
				  matchDisplayInfo(p,v);
				 }
				}
		}
		LogUtils.info("number of matched key :"+ct);
		//Match m = ... // next Match 
		//
		return ct;
	}

	private static void matchDisplayInfo(Pattern p, List<Match> v) {
		for(Match ma : v){
			
			
			for(BioPAXElement b:ma.getVariables()){
				if(b!=null){
					System.out.print( b+": "+b.getClass().getSimpleName()+": ");
					if(b instanceof ProteinImpl){
						ProteinImpl o = (ProteinImpl )b ;
						
						System.out.print( "|"+o.getDisplayName());
						
					}
					if(b instanceof ComplexImpl){
						ComplexImpl o = (ComplexImpl )b ;
						System.out.print("|"+ o.getDisplayName());
					}
					if(b instanceof BiochemicalReactionImpl){
						BiochemicalReactionImpl o = (BiochemicalReactionImpl )b ;
						System.out.print( "|"+o.getDisplayName());
					}
					if(b.getClass().isAssignableFrom(Conversion.class) || b instanceof Conversion ){
						Conversion o = (Conversion )b ;
						System.out.print( " |**isa_conversion**");
						 
					}
					if(b.getClass().isAssignableFrom(Control.class) || b instanceof Control ){
						Control o = (Control )b ;
						if(o!=null && o.getControlType()!=null ){
							System.out.print( "|**isa_control: "+o.getControlType().name()+", controller:"+controllerInfo(o)+", controlled:"+controlledInfo(o));	
						}
						
						 
					}
					LogUtils.info("");
				}
			}
		}
	}

	private static String  controllerInfo(Control co) {
		String s="";
		if(co!=null && co.getController()!=null){
			Set<Controller> col = co.getController();
			
			for(Controller c:col){
				if(c instanceof ProteinImpl){
					ProteinImpl o = (ProteinImpl )c ;
					s+=  o.getDisplayName();
				}
				else if(c instanceof ComplexImpl){
					ComplexImpl o = (ComplexImpl )c ;
					s+=  o.getDisplayName();
				}
				else{
					 
					s+=  c.toString();
				}
			}
		}
		return s;

		
	}
	
	private static String  controlledInfo(Control co) {
		Set<org.biopax.paxtools.model.level3.Process> col = co.getControlled();
		String s="";
		for(org.biopax.paxtools.model.level3.Process c:col){
			if(c instanceof BiochemicalReaction ){
				BiochemicalReaction o = (BiochemicalReaction )c ;
				s+=  "<biomchemreact: " +o.getDisplayName()+">";
			}
			else if (c.getClass().isAssignableFrom(Conversion.class) || c instanceof Conversion ){
				Conversion o = (Conversion )c ;  //BiochemicalReaction|ComplexAssembly|Transport
			
				s+=  "<conversion: "+o.getDisplayName()+">";
				 
			}
			 
			else{
				 
				s+=  "<"+c.toString()+">";
			}
		}
   
		return s;

		
	}
	private static void mypatternDisplayInfo(Pattern p, List<Match> v) {
		for(Match ma : v){
			PhysicalEntity lpe = (PhysicalEntity) ma.get("left PE", p);
			
			LogUtils.info("left PE"+": "+lpe.getDisplayName());
			PhysicalEntity rpe = (PhysicalEntity) ma.get("right PE", p);
			LogUtils.info("right PE"+": "+rpe.getDisplayName());
		}
	}
	
	
	/**
	 * Constructs a pattern where first and last small molecules are substrates to the same
	 * biochemical reaction.
	 *
	 
	 */
	 //CASE 3 
	public static Pattern mypatternCase3(Blacklist blacklist, boolean consumption)
	{   //=> filter results   for matching case  3  ?
		return SpaimPatternBox.reactsWith(blacklist);
	}
	
	//CASE 1 or 2 ?
	public static Pattern mypatterninCase1or2(Blacklist blacklist, boolean consumption)
	{    //
		 //from ControlsMetabolicCatalysis
		//Pattern for a Protein controlling a reaction whose participant is **a** small molecule.
		//=> filter results ? for matching case 2 
		Pattern p = new Pattern(SequenceEntityReference.class, "controller ER"); 
		//SequenceEntityReference: Tagger interface for protein, dna and rna entities
		p.add(linkedER(true), "controller ER", "controller generic ER");
		 
		//public static Constraint linkedER(boolean up){
		// return new SelfOrThis(new PathConstraint("EntityReference/memberEntityReference" + (up ? "Of" : "") + "*"));}
	 
		p.add(erToPE(), "controller generic ER", "controller simple PE");
		//	public static Constraint erToPE(){return new PathConstraint("EntityReference/entityReferenceOf");}
		 
		p.add(linkToComplex(), "controller simple PE", "controller PE");
		//	public static Constraint linkToComplex(){return new LinkedPE(LinkedPE.Type.TO_GENERAL);}
		p.add(peToControl(), "controller PE", "Control");
		//	public static Constraint peToControl(){return new PathConstraint("PhysicalEntity/controllerOf");}
		p.add(controlToConv(), "Control", "Conversion");
		//public static Constraint controlToConv(){return new PathConstraint("Control/controlled*:Conversion");}
		p.add(new NOT(participantER()), "Conversion", "controller ER");
		//public static Constraint participantER(){
		//	return new ConstraintChain(participant(), linkToSpecific(), peToER(), linkedER(false));}
		p.add(new Participant(consumption ? RelType.INPUT : RelType.OUTPUT, blacklist, true),"Control", "Conversion", "part PE");

		p.add(linkToSimple(blacklist), "part PE", "part SM");
		//	public static Constraint linkToSimple(Blacklist blacklist){
		//	return new LinkedPE(LinkedPE.Type.TO_SPECIFIC, blacklist);}
		p.add(notGeneric(), "part SM");
		//	public static Constraint notGeneric(){
		//	return new Empty(new PathConstraint("PhysicalEntity/memberPhysicalEntity"));}
		p.add(type(SmallMolecule.class), "part SM");
		p.add(peToER(), "part SM", "part SMR");
		//public static Constraint peToER(){
		//	return new PathConstraint("SimplePhysicalEntity/entityReference");}
		// The small molecule is associated only with left or right, but not both.
		p.add(new XOR(
			new MappedConst(new InterToPartER(InterToPartER.Direction.LEFT), 0, 1),
			new MappedConst(new InterToPartER(InterToPartER.Direction.RIGHT), 0, 1)),
			"Conversion", "part SMR");

		return p;
	}
	
	
	public static Pattern mypattern()
	{
		/* see https://github.com/BioPAX/Paxtools/wiki/PatternQuickStart
		 * Assume we are looking for a structure that a Conversion has a PhysicalEntity
		 *  at its left and another PhysicalEntity at its right, both belong to the same EntityReference. 
		 * The pattern contains 4 elements (a Conversion, two PhysicalEntity, and an EntityReference).
		 */
		Pattern p = new Pattern(Conversion.class, "Conv"); // Conversion is the initial element (key in map)
       // all elements added with p.add will be available as map values
		p.add(ConBox.left(), "Conv", "left PE"); // left PE: The PhysicalEntity at left
		p.add(ConBox.peToER(), "left PE", "ER"); // ER: The related EntityReference
		p.add(ConBox.right(), "Conv", "right PE"); // right PE: The PhysicalEntity at right
		p.add(ConBox.peToER(), "right PE", "ER"); // Last constraint makes sure that the last PhysicalEntity has the same EntityReference

		return p;
	}
	
	public static Pattern mypattern2()
	{
		// Type.TO_MEMEBR and TO_COMPLEX does not exist => modif
		Pattern p = new Pattern(EntityReference.class, "ER"); // Start from an EntityReference
		p.add(ConBox.erToPE(), "ER", "simple PE1"); // Get a related PhysicalEntity
		p.add(new LinkedPE(LinkedPE.Type.TO_GENERAL), "simple PE1", "PE1"); // Include parent complexes and all equivalent generics recursively
		p.add(new ParticipatesInConv(RelType.INPUT), "PE1", "Conv"); // Get to the Conversion
		p.add(new ConversionSide(ConversionSide.Type.OTHER_SIDE), "PE1", "Conv", "PE2"); // Get to the PhysicalEntity at the other side
		//PhysicalEntity at the other side
		p.add(new Equality(false), "PE1", "PE2"); // Make sure that the PhysicalEntity objects at each sides are different
		p.add(new LinkedPE(LinkedPE.Type.TO_GENERAL), "PE2", "simple PE2"); // Include complex members and all equivalent generics recursively
		p.add(ConBox.peToER(), "simple PE2", "ER"); // Make sure that the last PhysicalEntity has the same EntityReference

		return p;
	}
	
	
	public static void convertToCustomSIFCUSTOM(
			Model m,
			SIFType[] sifTypes, //SIF rules/patterns to apply/search
			OutputStream sifOutputStream, Blacklist blacklist) throws IOException, URISyntaxException
	{
		SpaimGraphGenerator.normalize(m);
		for(SIFType s:sifTypes){
			LogUtils.info(" sifType : "+s);
		}
		
		//convert to binary interactions
		
		

		IDFetcher idf = initIdFetcher();
		
		SIFSearcher sifSearcher = new SIFSearcher(idf, sifTypes);
		if(blacklist!=null){
			sifSearcher.setBlacklist(blacklist);
		}
		LogUtils.info(" SIFSearcher:start");
		
		
		
		
		
		
		Set<SIFInteraction> binaryInts = sifSearcher.searchSIF(m);
		// write interactions and some of their attributes (publications, datasources, pathways)
		SIFToText stt = new CustomFormat(
				OutputColumn.Type.RESOURCE.name(),
				OutputColumn.Type.PUBMED.name(),
				OutputColumn.Type.PATHWAY.name()
		);
		 
		
		
		LogUtils.info(" SIFSearcher:end");
		if (!binaryInts.isEmpty()) {
			LogUtils.info(" not empty ");
			List<SIFInteraction> interList = new ArrayList<SIFInteraction>(binaryInts);
			Collections.sort(interList);
			
			for(SIFInteraction s :  interList){
				LogUtils.info(displayInfoSifInteraction(s));
			}
			LogUtils.info("interList.size():"+interList.size());
			OutputStreamWriter writer = new OutputStreamWriter(sifOutputStream);
//			writer.write("PARTICIPANT_A\tINTERACTION_TYPE\tPARTICIPANT_B\tINTERACTION_DATA_SOURCE\tINTERACTION_PUBMED_ID\tPATHWAY_NAMES");
			for (SIFInteraction inter : interList){
				writer.write(stt.convert(inter)+"\n");
			}
			writer.close();
		}else{
			LogUtils.info("  **empty ** ");
		}
	}

	private static IDFetcher initIdFetcher() {
		IDFetcher idf = new IDFetcher()
		{
		    @Override
		    public Set<String> fetchID(BioPAXElement ele)
		    {
		        if (ele instanceof Named) {return Collections.singleton((  (Named) ele).getDisplayName().replaceAll("\\s", "_"))      ;}
		        else {
		        	return Collections.emptySet();
		        	//return Collections.singleton("N/A");
		        		}
		    }
		};
		//IDFetcher idf =new SimpleIDFetcher();
		return idf;
	}

	private static String displayInfoSifInteraction(SIFInteraction s) throws URISyntaxException {
	
		
		SIFToText sttext = new CustomFormat(
				OutputColumn.Type.RESOURCE.name(),
				OutputColumn.Type.PUBMED.name(),
				OutputColumn.Type.PATHWAY.name(),
				OutputColumn.Type.MEDIATOR.name()
		);
		
		 String spes="";
		 for(BioPAXElement spe:s.sourcePEs){
			 spes+=" "+spe.getClass().getSimpleName();
		 }
		 spes+=",";
		 for(BioPAXElement spe:s.sourceERs){
			 spes+=" "+ spe.getClass().getSimpleName();
		 }
		 
		 String tpes="";
		 for(BioPAXElement tpe:s.targetPEs){
			 tpes+=" " +tpe.getClass().getSimpleName();;
		 }
		 tpes+=",";
		 for(BioPAXElement spe:s.targetERs){
			 tpes+=" "+spe.getClass().getSimpleName();
		 }
			String str=  (new URI(s.sourceID)).getFragment() +" "+spes+ "\t**" + s.type.getTag() + "**\t" +(new URI(s.targetID)).getFragment() +" "+tpes;
			
			str+="\n###" + sttext.convert(s);
		return str;
	}
 
	public static void formatFlat(File inf,File outf ) {
	    try {
	        Source xmlInput = new StreamSource(inf);
	 
	        StreamResult xmlOutput = new StreamResult(outf);
	        TransformerFactory transformerFactory = TransformerFactory.newInstance();
	        transformerFactory.setAttribute("indent-number", 0);
	        Transformer transformer = transformerFactory.newTransformer(); 
	        transformer.setOutputProperty(OutputKeys.INDENT, "no");
	        
	        transformer.transform(xmlInput, xmlOutput);
	        
	        
	    } catch (Exception e) {
	        throw new RuntimeException(e); // simple exception handling, please review it
	    }
	}

 
	private static InputStream copy(InputStream is) throws IOException {
		ByteArrayOutputStream copy = new ByteArrayOutputStream();
		int chunk = 0;
		byte[] data = new byte[1024*1024];
		while((-1 != (chunk = is.read(data)))) {
			copy.write(data, 0, chunk);
		}
		is.close();
		return new ByteArrayInputStream( copy.toByteArray() );
	}	
}
