package dyliss.biopax;


import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.collections15.Transformer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.velocity.VelocityContext;
import org.biopax.paxtools.impl.level3.CatalysisImpl;
import org.biopax.paxtools.impl.level3.ComplexImpl;
import org.biopax.paxtools.impl.level3.DnaImpl;
import org.biopax.paxtools.impl.level3.ProteinImpl;
import org.biopax.paxtools.impl.level3.RnaImpl;
import org.biopax.paxtools.impl.level3.SmallMoleculeImpl;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.model.level3.PhysicalEntity;

import dyliss.biopax.graph.SpaimEdge;
import dyliss.biopax.graph.SpaimNode;
import edu.uci.ics.jung.algorithms.cluster.WeakComponentClusterer;
import edu.uci.ics.jung.algorithms.filters.FilterUtils;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
//import edu.uci.ics.jung.io.GraphMLWriter;


public class GraphWriter {
	private static final String SHAPE = "Ellipse";
	private static final String COLOR = "silver";
	public static void writeGraphToGraphmlFile(
			String graphname, 
			DirectedSparseMultigraph<SpaimNode, SpaimEdge> jg,
			String graphmlfile,
			File templateF 
			)
			throws IOException, Exception {
		
		
		PrintWriter writer = new PrintWriter(graphmlfile, "UTF-8");
 
		Collection<SpaimNode> vl = jg.getVertices();
		int vct=0;
		for(SpaimNode v:vl){
			vct++;
			v.setNumid(vct);
		    v.setSafeLabel(StringEscapeUtils.escapeXml(v.getLabel() ));
		    String shape = shapeFromBiopaxType(v); 
		    v.setShape(shape);
		    String color = colorFromBiopaxType(v);
		    v.setColor(color);
		    //v.setInput(0);
		    v.setGroup(StringEscapeUtils.escapeXml(v.getGroup()));
		}
		Collection<SpaimEdge> edges = jg.getEdges();
		if(edges.size()>0){
			int cte=0;
			for(SpaimEdge e:edges){
				cte++;
				Pair<SpaimNode> ep = jg.getEndpoints(e);
				SpaimNode f = ep.getFirst();
				SpaimNode s = ep.getSecond();
					
				String interaction = e.getPk();
				e.setInteraction(StringEscapeUtils.escapeXml(interaction)+"");
				e.setNumid(cte);
				e.setSource(""+f.getNumid());
				e.setTarget(""+s.getNumid());
				//writer.println(f.getID()+"\t"+x+"\t"+s.getID());

			}

		}
		
		
		HashMap<String, Object> context = new HashMap<String, Object>();
		TemplateManager ct = TemplateManager.getInstance();
		ct.setTemplateDir(templateF.getParent());
		ct.init();
		String templateFile=templateF.getName();
		
		context.put("graphname",graphname);
		 
		
		context.put("edges",jg.getEdges());
		context.put("nodes",jg.getVertices());
		
		
		VelocityContext vcontext = new VelocityContext();
		for(String k:context.keySet()){
			   vcontext.put(k,  context.get(k));
		}
		String output=ct.evaluateFromTemplate(   templateFile,   vcontext);
		writer.print(output);
	//	LogUtils.info(output);
		//
		
		
		
		
		
		
		
		
		
		

		writer.close();
		
		
		
		
		
		
		
		
	}
	private static String shapeFromBiopaxType(SpaimNode v) {
		String shape=SHAPE;
		BioPAXElement be = v.getElement();
		 
		 if (be.getClass().isAssignableFrom(PhysicalEntity.class) || be instanceof PhysicalEntity ){
				 
				shape="0";
				 if(be instanceof ProteinImpl){
					 shape="1"; 
				 }
				 else if(be instanceof ComplexImpl){
					 shape="2"; 
				 }
				 else if(be instanceof SmallMoleculeImpl){
					 shape="3"; 
				 }
				 else if(be instanceof DnaImpl){
					 shape="4"; 
				 }
				 else if(be instanceof RnaImpl){
					 shape="5"; 
				 }
				
		 }
		 else if (be.getClass().isAssignableFrom(Interaction.class) || be instanceof Interaction ){
			 
			 shape="6" ;
			 
			 if (be.getClass().isAssignableFrom(Control.class) || be instanceof Control ){
				   
				   shape="7" ;
			 }
		 }
		 else{
			 shape="8";
		 }
		 
		 
		 
		return shape;
	}
	
	private static String colorFromBiopaxType(SpaimNode v) {
		String color=COLOR;
		BioPAXElement be = v.getElement();
		 
		 if (be.getClass().isAssignableFrom(PhysicalEntity.class) || be instanceof PhysicalEntity ){
				 
				color="1";
				 if(be instanceof ProteinImpl){
					 color="2"; 
				 }
				 else if(be instanceof ComplexImpl){
					 color="3"; 
				 }
				 else if(be instanceof SmallMoleculeImpl){
					 color="4"; 
				 }
				 else if(be instanceof DnaImpl){
					 color="5"; 
				 }
				 else if(be instanceof RnaImpl){
					 color="6"; 
				 }
				
				
		 }
		 else if(be instanceof EntityReference){
			 color="7"; 
		 }
		 else if (be.getClass().isAssignableFrom(Interaction.class) || be instanceof Interaction ){
			 
			 color="8" ;
			 
			 if (be.getClass().isAssignableFrom(Control.class) || be instanceof Control ){
				   
				   color="9" ;
			 }
		 }
		 else{
			 color="0";
		 }
		 
		 
		 
		return color;
	}
	
	
}
