package dyliss.biopax;

import java.io.File;
import java.util.Properties;

import dyliss.biopax.util.LogUtils;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Properties;

public class GraphConfig {

	private boolean doVizu=false;
	
	private String  vizuresult=null;
	private String  vizuft=null;
	private String  vizutarget=null;
	
	private boolean doSpaim=true;
	private boolean doMerge = false;
	
	
	
	
	private boolean useDb=false;
	private String  dbDriver = "com.mysql.jdbc.Driver";  
	private String  dbUrl = "jdbc:mysql://localhost/transpath_to_influences_v2_lt";
	private String  dbUser = "root";
	private String  dbPassword = "kikikoko";
	private boolean addEntityReference=false;
	private boolean addComplexComponent=false;
	private boolean doEmptyDB=false;
	private boolean doLogSTDOUT=true;
	private boolean doDBtoFile=false;
	private String DBFile="db_insert.sql";
	
	
	private boolean doHub=false;
	private String hubFile="hub.txt";


	private boolean doBench=false;


	private String blackListFilePath = null;
	private String inputBiopaxFilePath = null;
	private String graphmlOutputFilePath = null;
	
	private String  inputvizu = null;
	private String outputSifFilePath = null;
	private String graphmlTemplateFilePath = null;
	private String graphmlSimpleTemplateFilePath = null;
	private String bench1 = null;
	private String bench2 = null;
	private String bench3 = null;
	private String benchtag1 = null;
	private String benchtag2 = null;
	private String benchtag3 = null;
	private String biopaxInDir = null;
	private String level = null;
	private String ouputBiopaxFilePath = null;
	private boolean doGenerateBlackList=false;
	
	
	public boolean isDoGenerateBlackList() {
		return doGenerateBlackList;
	}

	public void setDoGenerateBlackList(boolean doGenerateBlackList) {
		this.doGenerateBlackList = doGenerateBlackList;
	}
	private boolean doGraphml=false;
	private boolean doDB=false;
	 
	public boolean isDoGraphml() {
		return doGraphml;
	}

	public void setDoGraphml(boolean doGraphml) {
		this.doGraphml = doGraphml;
	}

	public boolean isDoDB() {
		return doDB;
	}

	public void setDoDB(boolean doDB) {
		this.doDB = doDB;
	}

	public String getOuputBiopaxFilePath() {
		return ouputBiopaxFilePath;
	}

	public void setOuputBiopaxFilePath(String ouputBiopaxFilePath) {
		this.ouputBiopaxFilePath = ouputBiopaxFilePath;
	}

	public String getBiopaxInDir() {
		return biopaxInDir;
	}

	public void setBiopaxInDir(String biopaxInDir) {
		this.biopaxInDir = biopaxInDir;
	}

	public String getGraphmlOutputFilePath() {
		return graphmlOutputFilePath;
	}

	public void setGraphmlOutputFilePath(String graphmlOutputFile) {
		this.graphmlOutputFilePath = graphmlOutputFile;
	}

	public String getInputBiopaxFilePath() {
		return inputBiopaxFilePath;
	}
	public boolean isDoEmptyDB() {
		return doEmptyDB;
	}

	public void setDoEmptyDB(boolean doEmptyDB) {
		this.doEmptyDB = doEmptyDB;
	}
	public void setInputBiopaxFilePath(String inputBiopaxFilePath) {
		this.inputBiopaxFilePath = inputBiopaxFilePath;
	}

	public String getOutputSifFilePath() {
		return outputSifFilePath;
	}

	public void setOutputSifFilePath(String outputSifFilePath) {
		this.outputSifFilePath = outputSifFilePath;
	}
	public boolean isAddComplexComponent() {
		return addComplexComponent;
	}

	public void setAddComplexComponent(boolean addComplexComponent) {
		this.addComplexComponent = addComplexComponent;
	}

	public boolean isAddEntityReference() {
		return addEntityReference;
	}

	public void setAddEntityReference(boolean addEntityReference) {
		this.addEntityReference = addEntityReference;
	}
	Properties properties = new Properties();
	
	
 
	
	public boolean isUseDb() {
		return useDb;
	}

	public void setUseDb(boolean useDb) {
		this.useDb = useDb;
	}

	public String getDbDriver() {
		return dbDriver;
	}

	public void setDbDriver(String dbDriver) {
		this.dbDriver = dbDriver;
	}

	public String getDbUrl() {
		return dbUrl;
	}

	public void setDbUrl(String dbUrl) {
		this.dbUrl = dbUrl;
	}

	public String getDbUser() {
		return dbUser;
	}

	public void setDbUser(String dbUser) {
		this.dbUser = dbUser;
	}

	public String getDbPassword() {
		return dbPassword;
	}

	public void setDbPassword(String dbPassword) {
		this.dbPassword = dbPassword;
	}

	
	public static void main(String[] args) throws IllegalArgumentException, IllegalAccessException, IOException {
		//String propFilePath = "data/config.properties";
		//GraphConfig g = new GraphConfig(propFilePath);
		GraphConfig g = new GraphConfig();
		g.save("graphconf.properties");
	}
	
	public   void save(String f) throws IOException, IllegalArgumentException, IllegalAccessException{
		this.properties = new Properties();
		File file = new File(f);
		 Field[] fields = GraphConfig.class.getDeclaredFields();
		  for(Field fi:fields){
				LogUtils.info( fi.get(this));
			 
			 if( fi.get(this)!=null){
				 String v= (fi.get(this)).toString();
				 this.properties.setProperty(fi.getName(),v);
			 } 

		  }
		FileOutputStream out = new FileOutputStream(file.getAbsolutePath());
		this.properties.store(out, "generated by GraphConfig.save()");
		out.close();
		LogUtils.info("properties saved in "+file.getAbsolutePath());
	}
	
	public GraphConfig() {
		super();
	}
	
	public GraphConfig(String  propFilePath) {
		super();
		this.useDb = useDb;
		File f;
		this.properties = new Properties();
		InputStream input = null;

		try {

			
			input = new FileInputStream(propFilePath);
 
		  this.properties.load(input);
		  for(Object k: this.properties.keySet()){
				LogUtils.info("config:"+this.properties.getProperty(k.toString()));
			  
		  }
		  Field[] fields = GraphConfig.class.getDeclaredFields();
		  for(Field fi:fields){
			  
			  //fi.getType()
			  try {
				  String name = fi.getName();
				  Object v=this.properties.getProperty(name);
				  
				   LogUtils.info("prop:"+name+"="+v);
				  String val =null;
				  if (v!=null){
					  val=v.toString().trim();
					  if(fi.getType().toString().toLowerCase().equals("boolean") ){
						  LogUtils.info("prop:"+name+"::"+val+"=boolean!!" );
						  
						  fi.set(this,new Boolean( val));
					  }
					  else if(fi.getType().toString().toLowerCase().equals("integer") ){
						  fi.set(this,new Boolean( val));
					  }
					  else if(fi.getType().toString().toLowerCase().equals("float") ){
						  fi.set(this,new Float( val));
					  }
					  else if(fi.getType().toString().toLowerCase().equals("double") ){
						  fi.set(this,new Double( val));
					  }
					  else if(fi.getType().toString().toLowerCase().equals("string") ){
						  
						  fi.set(this,new Double( val));
					  }
					 
					  else{
						  try{
						  fi.set(this, val);
						  }catch(Exception  e){
							  e.printStackTrace();
						  }
					  }
					  
					  LogUtils.info(name+"--"+fi.getType()+"--"+fi.get(this));
					  
				  }
				  
	
				  
			} catch (IllegalArgumentException | IllegalAccessException e) {
				 
				e.printStackTrace();
			}
		  }
	 

		} catch (IOException ex) {
			ex.printStackTrace();
		} finally {
			if (input != null) {
				try {
					input.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}

		 
		 
	}

	public boolean isDoSpaim() {
		return doSpaim;
	}

	public void setDoSpaim(boolean doSpaim) {
		this.doSpaim = doSpaim;
	}

	public boolean isDoMerge() {
		return doMerge;
	}

	public void setDoMerge(boolean doMerge) {
		this.doMerge = doMerge;
	}

	public String getBlackListFilePath() {
		return blackListFilePath;
	}

	public void setBlackListFilePath(String blackListFilePath) {
		this.blackListFilePath = blackListFilePath;
	}

	public String getGraphmlTemplateFilePath() {
		return graphmlTemplateFilePath;
	}

	public String getSimpleGraphmlTemplateFilePath() {
		return graphmlSimpleTemplateFilePath;
	}
	
	public void setGraphmlTemplateFilePath(String graphmlTemplateFilePath) {
		this.graphmlTemplateFilePath = graphmlTemplateFilePath;
	}

	public String getBench1() {
		return bench1;
	}

	public void setBench1(String bench1) {
		this.bench1 = bench1;
	}

	public String getBench2() {
		return bench2;
	}

	public void setBench2(String bench2) {
		this.bench2 = bench2;
	}

	public String getBench3() {
		return bench3;
	}

	public void setBench3(String bench3) {
		this.bench3 = bench3;
	}

	public String getBenchtag1() {
		return benchtag1;
	}

	public void setBenchtag1(String benchtag1) {
		this.benchtag1 = benchtag1;
	}

	public String getBenchtag2() {
		return benchtag2;
	}

	public void setBenchtag2(String benchtag2) {
		this.benchtag2 = benchtag2;
	}

	public String getBenchtag3() {
		return benchtag3;
	}

	public void setBenchtag3(String benchtag3) {
		this.benchtag3 = benchtag3;
	}
	
 
	public boolean isDoDBtoFile() {
		return doDBtoFile;
	}

	public void setDoDBtoFile(boolean doDBtoFile) {
		this.doDBtoFile = doDBtoFile;
	}

	public String getDBFile() {
		return DBFile;
	}

	public void setDBFile(String dBFile) {
		DBFile = dBFile;
	}

	public boolean isDoLogSTDOUT() {
		return doLogSTDOUT;
	}

	public void setDoLogSTDOUT(boolean doLogSTDOUT) {
		this.doLogSTDOUT = doLogSTDOUT;
	}
 
	public boolean isDoHub() {
		return doHub;
	}

	public void setDoHub(boolean doHub) {
		this.doHub = doHub;
	}

	public String getHubFile() {
		return hubFile;
	}

	public void setHubFile(String hubFile) {
		this.hubFile = hubFile;
	}
	
	public boolean isDoBench() {
		return doBench;
	}

	public void setDoBench(boolean doBench) {
		this.doBench = doBench;
	}

	public boolean isDoVizu() {
		return doVizu;
	}

	public void setDoVizu(boolean doVizu) {
		this.doVizu = doVizu;
	}

	public String getLevel() {
		return level;
	}

	public void setLevel(String level) {
		this.level = level;
	}

	public String getInputvizu() {
		return inputvizu;
	}

	public void setInputvizu(String inputvizu) {
		this.inputvizu = inputvizu;
	}

	public String getVizuresult() {
		return vizuresult;
	}

	public String getVizuft() {
		return vizuft;
	}

	public String getVizutarget() {
		return vizutarget;
	}

	public void setVizuresult(String vizuresult) {
		this.vizuresult = vizuresult;
	}

	public void setVizuft(String vizuft) {
		this.vizuft = vizuft;
	}

	public void setVizutarget(String vizutarget) {
		this.vizutarget = vizutarget;
	}
	
}
