"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RemixApp = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_cognito_1 = require("aws-cdk-lib/aws-cognito");
const aws_dynamodb_1 = require("aws-cdk-lib/aws-dynamodb");
const aws_secretsmanager_1 = require("aws-cdk-lib/aws-secretsmanager");
const constructs_1 = require("constructs");
const api_1 = require("./api");
const cdn_1 = require("./cdn");
class RemixApp extends constructs_1.Construct {
    constructor(scope, id, { ddbSessions, customDomain, remixPath, cognitoAuth, isDev = true, }) {
        super(scope, id);
        let domainName, certificate;
        const remixPublicPath = path.join(remixPath, '/public');
        const remixServerPath = path.join(remixPath, '/server/index.ts');
        const api = new api_1.Api(this, 'api', { remixServerPath });
        this.handler = api.handler;
        if (ddbSessions) {
            const sessionsTable = new aws_dynamodb_1.Table(this, 'sessionsTable', {
                partitionKey: { name: 'pk', type: aws_dynamodb_1.AttributeType.STRING },
                billingMode: aws_dynamodb_1.BillingMode.PAY_PER_REQUEST,
                timeToLiveAttribute: 'ttl',
                encryption: aws_dynamodb_1.TableEncryption.AWS_MANAGED,
            });
            const cookieSecret = new aws_secretsmanager_1.Secret(this, 'cookieSecret', {
                generateSecretString: {
                    excludeUppercase: true,
                    excludePunctuation: true,
                },
            });
            sessionsTable.grantReadWriteData(api.handler);
            api.handler.addEnvironment('SESSIONS_TABLE', sessionsTable.tableName);
            api.handler.addEnvironment('COOKIE_SECRET', cookieSecret.secretValue.toString() ?? '');
            new aws_cdk_lib_1.CfnOutput(this, 'sessions-table', {
                value: sessionsTable.tableName,
            });
        }
        if (customDomain) {
            domainName = customDomain.domainName;
            certificate = customDomain.certificate;
        }
        const cdn = new cdn_1.CDN(this, 'cdn', {
            certificate,
            domainName,
            httpApi: api.httpApi,
            remixPublicPath,
        });
        this.cdnDomainName = cdn.distribution.distributionDomainName;
        this.cdnDistributionId = cdn.distribution.distributionId;
        const publicDomainName = domainName ?? cdn.distribution.domainName;
        api.handler.addEnvironment('COOKIE_DOMAIN', publicDomainName);
        api.handler.addEnvironment('HOST_URI', `https://${publicDomainName}`);
        if (cognitoAuth) {
            const callbackUrls = [`https://${publicDomainName}/auth/callback`];
            const logoutUrls = [`https://${publicDomainName}/logout`];
            if (isDev) {
                callbackUrls.push('http://localhost:3000/auth/callback');
                logoutUrls.push('http://localhost:3000/logout');
            }
            const { userPool, authDomain } = cognitoAuth;
            const userPoolClient = new aws_cognito_1.UserPoolClient(this, 'userPoolClient', {
                userPool,
                supportedIdentityProviders: [
                    aws_cognito_1.UserPoolClientIdentityProvider.COGNITO,
                    aws_cognito_1.UserPoolClientIdentityProvider.GOOGLE,
                ],
                oAuth: {
                    scopes: [
                        aws_cognito_1.OAuthScope.EMAIL,
                        aws_cognito_1.OAuthScope.OPENID,
                        aws_cognito_1.OAuthScope.PROFILE,
                        aws_cognito_1.OAuthScope.COGNITO_ADMIN,
                    ],
                    flows: { authorizationCodeGrant: true },
                    callbackUrls,
                    logoutUrls,
                },
                preventUserExistenceErrors: true,
            });
            api.handler.addEnvironment('AUTH_DOMAIN', authDomain);
            api.handler.addEnvironment('CLIENT_ID', userPoolClient.userPoolClientId);
        }
        new aws_cdk_lib_1.CfnOutput(this, 'apiUrl', { value: api.httpApi.url || '' });
        new aws_cdk_lib_1.CfnOutput(this, 'publicDomainName', {
            value: publicDomainName,
        });
        new aws_cdk_lib_1.CfnOutput(this, 'cdnDomainName', {
            value: this.cdnDomainName,
        });
        new aws_cdk_lib_1.CfnOutput(this, 'cdnDistributionId', {
            value: this.cdnDistributionId,
        });
    }
}
exports.RemixApp = RemixApp;
_a = JSII_RTTI_SYMBOL_1;
RemixApp[_a] = { fqn: "@rogerchi/cdk-remix-app.RemixApp", version: "0.0.1" };
//# sourceMappingURL=data:application/json;base64,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