"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Api = void 0;
const aws_apigatewayv2_alpha_1 = require("@aws-cdk/aws-apigatewayv2-alpha");
const aws_apigatewayv2_integrations_alpha_1 = require("@aws-cdk/aws-apigatewayv2-integrations-alpha");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const aws_lambda_nodejs_1 = require("aws-cdk-lib/aws-lambda-nodejs");
const constructs_1 = require("constructs");
class Api extends constructs_1.Construct {
    constructor(scope, id, { remixServerPath }) {
        super(scope, id);
        this.handler = new aws_lambda_nodejs_1.NodejsFunction(this, 'defaultLambda', {
            entry: remixServerPath,
            environment: {
                AWS_NODEJS_CONNECTION_REUSE_ENABLED: '1',
                NODE_ENV: 'production',
            },
            architecture: aws_lambda_1.Architecture.ARM_64,
            handler: 'handler',
            memorySize: 2048,
            runtime: aws_lambda_1.Runtime.NODEJS_16_X,
            timeout: aws_cdk_lib_1.Duration.seconds(30),
        });
        const integration = new aws_apigatewayv2_integrations_alpha_1.HttpLambdaIntegration('remixIntegration', this.handler);
        this.httpApi = new aws_apigatewayv2_alpha_1.HttpApi(this, 'api', {
            defaultIntegration: integration,
        });
    }
}
exports.Api = Api;
//# sourceMappingURL=data:application/json;base64,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