#!/usr/bin/python3
# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""Converts a data log generated by exit speed to Traqmate's CSV format."""
import logging
import sys

from absl import app
from absl import flags

from exit_speed import csv_lib
from exit_speed import replay_data

FLAGS = flags.FLAGS


def main(unused_argv):
  logging.basicConfig(stream=sys.stdout, level=logging.INFO)
  es = replay_data.ReplayLog(FLAGS.filepath, include_sleep=False)
  new_path = '%s.csv' % FLAGS.filepath
  print('%s > %s' % (FLAGS.filepath, new_path))
  csv_lib.ConvertProtoToTraqmate(es.session, new_path)

if __name__ == '__main__':
  app.run(main)
