# flake8: noqa
# generated by datamodel-codegen:
#   filename:  api.json.clean
#   timestamp: 2022-08-18T22:27:20+00:00

from __future__ import annotations

from ezcharts.plots.util import JSCode

from typing import Any, Dict, List, Optional, Union

from pydantic import Field

from ezcharts.plots._base import BaseModel

class _StyleName(BaseModel):
    color: Optional[Any] = Field('#fff', description='\n\n<p> text color.</p>\n')
    fontStyle: Optional[str] = Field(
        'normal',
        description='\n\n<p> font style.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;italic&#39;</code></li>\n<li><code class="codespan">&#39;oblique&#39;</code></li>\n</ul>\n',
    )
    fontWeight: Optional[Union[str, float]] = Field(
        'normal',
        description='\n\n<p> font thick weight.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;bold&#39;</code></li>\n<li><code class="codespan">&#39;bolder&#39;</code></li>\n<li><code class="codespan">&#39;lighter&#39;</code></li>\n<li>100 | 200 | 300 | 400...</li>\n</ul>\n',
    )
    fontFamily: Optional[str] = Field(
        'sans-serif',
        description='\n\n<p> font family.</p>\n<p>Can also be &#39;serif&#39; , &#39;monospace&#39;, ...</p>\n',
    )
    fontSize: Optional[float] = Field(12, description='\n\n<p> font size.</p>\n')
    align: Optional[str] = Field(
        None,
        description='\n\n<p>Horizontal alignment of text, automatic by default.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;left&#39;</code></li>\n<li><code class="codespan">&#39;center&#39;</code></li>\n<li><code class="codespan">&#39;right&#39;</code></li>\n</ul>\n<p>If <code class="codespan">align</code> is not set in <code class="codespan">rich</code>, <code class="codespan">align</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    align: right,\n    rich: {\n        a: {\n            // `align` is not set, then it will be right\n        }\n    }\n}\n</code></pre>\n',
    )
    verticalAlign: Optional[str] = Field(
        None,
        description='\n\n<p>Vertical alignment of text, automatic by default.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;top&#39;</code></li>\n<li><code class="codespan">&#39;middle&#39;</code></li>\n<li><code class="codespan">&#39;bottom&#39;</code></li>\n</ul>\n<p>If <code class="codespan">verticalAlign</code> is not set in <code class="codespan">rich</code>, <code class="codespan">verticalAlign</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    verticalAlign: bottom,\n    rich: {\n        a: {\n            // `verticalAlign` is not set, then it will be bottom\n        }\n    }\n}\n</code></pre>\n',
    )
    lineHeight: Optional[float] = Field(
        None,
        description='\n\n<p>Line height of the text fragment.</p>\n<p>If <code class="codespan">lineHeight</code> is not set in <code class="codespan">rich</code>, <code class="codespan">lineHeight</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    lineHeight: 56,\n    rich: {\n        a: {\n            // `lineHeight` is not set, then it will be 56\n        }\n    }\n}\n</code></pre>\n',
    )
    backgroundColor: Optional[Union[str, Any]] = Field(
        'transparent',
        description='\n\n<p>Background color of the text fragment.</p>\n<p>Can be color string, like <code class="codespan">&#39;#123234&#39;</code>, <code class="codespan">&#39;red&#39;</code>, <code class="codespan">&#39;rgba(0,23,11,0.3)&#39;</code>.</p>\n<p>Or image can be used, for example:</p>\n<pre><code class="lang-ts">backgroundColor: {\n    image: &#39;xxx/xxx.png&#39;\n    // It can be URL of a image,\n    // or dataURI,\n    // or HTMLImageElement,\n    // or HTMLCanvasElement.\n}\n</code></pre>\n<p><code class="codespan">width</code> or <code class="codespan">height</code> can be specified when using background image, or\nauto adapted by default.</p>\n',
    )
    borderColor: Optional[Any] = Field(
        None, description='\n\n<p>Border color of the text fragment.</p>\n'
    )
    borderWidth: Optional[float] = Field(
        0, description='\n\n<p>Border width of the text fragment.</p>\n'
    )
    borderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>the text fragment border type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">borderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\nborderType: [5, 10],\n\nborderDashOffset: 5\n}\n</code></pre>\n',
    )
    borderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">borderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    borderRadius: Optional[float] = Field(
        0, description='\n\n<p>Border radius of the text fragment.</p>\n'
    )
    padding: Optional[Union[float, Any]] = Field(
        0,
        description='\n\n<p>Padding of the text fragment, for example:</p>\n<ul>\n<li><code class="codespan">padding: [3, 4, 5, 6]</code>: represents padding of <code class="codespan">[top, right, bottom, left]</code>.</li>\n<li><code class="codespan">padding: 4</code>: represents <code class="codespan">padding: [4, 4, 4, 4]</code>.</li>\n<li><code class="codespan">padding: [3, 4]</code>: represents <code class="codespan">padding: [3, 4, 3, 4]</code>.</li>\n</ul>\n<p>Notice, <code class="codespan">width</code> and <code class="codespan">height</code> specifies the width and height of the content, without <code class="codespan">padding</code>.</p>\n',
    )
    shadowColor: Optional[Any] = Field(
        'transparent', description='\n\n<p>Shadow color of the text block.</p>\n'
    )
    shadowBlur: Optional[float] = Field(
        0, description='\n\n<p>Show blur of the text block.</p>\n'
    )
    shadowOffsetX: Optional[float] = Field(
        0, description='\n\n<p>Shadow X offset of the text block.</p>\n'
    )
    shadowOffsetY: Optional[float] = Field(
        0, description='\n\n<p>Shadow Y offset of the text block.</p>\n'
    )
    width: Optional[Union[float, str]] = Field(
        None,
        description='<p>Width of the text block. It is the width of the text by default. In most cases, there is no need to specify it. You may want to use it in some cases like make simple table or using background image (see <code class="codespan">backgroundColor</code>).</p>\n<p>Notice, <code class="codespan">width</code> and <code class="codespan">height</code> specifies the width and height of the content, without <code class="codespan">padding</code>.</p>\n<p><code class="codespan">width</code> can also be percent string, like <code class="codespan">&#39;100%&#39;</code>, which represents the percent of <code class="codespan">contentWidth</code> (that is, the width without <code class="codespan">padding</code>) of its container box. It is based on <code class="codespan">contentWidth</code> because that each text fragment is layout based on the <code class="codespan">content box</code>, where it makes no sense that calculating width based on <code class="codespan">outerWith</code> in prectice.</p>\n<p>Notice, <code class="codespan">width</code> and <code class="codespan">height</code> only work when <code class="codespan">rich</code> specified.</p>\n',
    )
    height: Optional[Union[float, str]] = Field(
        None,
        description='<p>Height of the text block. It is the width of the text by default. You may want to use it in some cases like using background image (see <code class="codespan">backgroundColor</code>).</p>\n<p>Notice, <code class="codespan">width</code> and <code class="codespan">height</code> specifies the width and height of the content, without <code class="codespan">padding</code>.</p>\n<p>Notice, <code class="codespan">width</code> and <code class="codespan">height</code> only work when <code class="codespan">rich</code> specified.</p>\n',
    )
    textBorderColor: Optional[Any] = Field(
        None, description='\n\n<p>Stroke color of the text.</p>\n'
    )
    textBorderWidth: Optional[float] = Field(
        None, description='\n\n<p>Stroke line width of the text.</p>\n'
    )
    textBorderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>Stroke line type of the text.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">textBorderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\ntextBorderType: [5, 10],\n\ntextBorderDashOffset: 5\n}\n</code></pre>\n',
    )
    textBorderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">textBorderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    textShadowColor: Optional[Any] = Field(
        'transparent', description='\n\n<p>Shadow color of the text itself.</p>\n'
    )
    textShadowBlur: Optional[float] = Field(
        0, description='\n\n<p>Shadow blue of the text itself.</p>\n'
    )
    textShadowOffsetX: Optional[float] = Field(
        0, description='\n\n<p>Shadow X offset of the text itself.</p>\n'
    )
    textShadowOffsetY: Optional[float] = Field(
        0, description='\n\n<p>Shadow Y offset of the text itself.</p>\n'
    )


class Rich(BaseModel):
    """
        <p>&quot;Rich text styles&quot; can be defined in this <code class="codespan">rich</code> property. For example:</p>
    <pre><code class="lang-ts">label: {
        // Styles defined in &#39;rich&#39; can be applied to some fragments
        // of text by adding some markers to those fragment, like
        // `{styleName|text content text content}`.
        // `&#39;\n&#39;` is the newline character.
        formatter: [
            &#39;{a|Style &quot;a&quot; is applied to this snippet}&#39;
            &#39;{b|Style &quot;b&quot; is applied to this snippet}This snippet use default style{x|use style &quot;x&quot;}&#39;
        ].join(&#39;\n&#39;),

        rich: {
            a: {
                color: &#39;red&#39;,
                lineHeight: 10
            },
            b: {
                backgroundColor: {
                    image: &#39;xxx/xxx.jpg&#39;
                },
                height: 40
            },
            x: {
                fontSize: 18,
                fontFamily: &#39;Microsoft YaHei&#39;,
                borderColor: &#39;#449933&#39;,
                borderRadius: 4
            },
            ...
        }
    }
    </code></pre>
    <p>For more details, see <a href="tutorial.html#Rich%20Text" target="_blank">Rich Text</a> please.</p>

    """

    _style_name_: Optional[_StyleName] = Field(
        None, alias='<style_name>', description=''
    )


class TextStyle(BaseModel):
    color: Optional[Any] = Field(
        '#333', description='\n\n<p>main title text color.</p>\n'
    )
    fontStyle: Optional[str] = Field(
        'normal',
        description='\n\n<p>main title font style.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;italic&#39;</code></li>\n<li><code class="codespan">&#39;oblique&#39;</code></li>\n</ul>\n',
    )
    fontWeight: Optional[Union[str, float]] = Field(
        'bolder',
        description='\n\n<p>main title font thick weight.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;bold&#39;</code></li>\n<li><code class="codespan">&#39;bolder&#39;</code></li>\n<li><code class="codespan">&#39;lighter&#39;</code></li>\n<li>100 | 200 | 300 | 400...</li>\n</ul>\n',
    )
    fontFamily: Optional[str] = Field(
        'sans-serif',
        description='\n\n<p>main title font family.</p>\n<p>Can also be &#39;serif&#39; , &#39;monospace&#39;, ...</p>\n',
    )
    fontSize: Optional[float] = Field(
        18, description='\n\n<p>main title font size.</p>\n'
    )
    lineHeight: Optional[float] = Field(
        None,
        description='\n\n<p>Line height of the text fragment.</p>\n<p>If <code class="codespan">lineHeight</code> is not set in <code class="codespan">rich</code>, <code class="codespan">lineHeight</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    lineHeight: 56,\n    rich: {\n        a: {\n            // `lineHeight` is not set, then it will be 56\n        }\n    }\n}\n</code></pre>\n',
    )
    width: Optional[float] = Field(
        None, description='\n\n<p>Width of text block.</p>\n'
    )
    height: Optional[float] = Field(
        None, description='\n\n<p>Height of text block.</p>\n'
    )
    textBorderColor: Optional[Any] = Field(
        None, description='\n\n<p>Stroke color of the text.</p>\n'
    )
    textBorderWidth: Optional[float] = Field(
        None, description='\n\n<p>Stroke line width of the text.</p>\n'
    )
    textBorderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>Stroke line type of the text.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">textBorderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\ntextBorderType: [5, 10],\n\ntextBorderDashOffset: 5\n}\n</code></pre>\n',
    )
    textBorderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">textBorderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    textShadowColor: Optional[Any] = Field(
        'transparent', description='\n\n<p>Shadow color of the text itself.</p>\n'
    )
    textShadowBlur: Optional[float] = Field(
        0, description='\n\n<p>Shadow blue of the text itself.</p>\n'
    )
    textShadowOffsetX: Optional[float] = Field(
        0, description='\n\n<p>Shadow X offset of the text itself.</p>\n'
    )
    textShadowOffsetY: Optional[float] = Field(
        0, description='\n\n<p>Shadow Y offset of the text itself.</p>\n'
    )
    overflow: Optional[str] = Field(
        'none',
        description='\n\n<p>Determine how to display the text when it&#39;s overflow. Available when <code class="codespan">width</code> is set.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the text and trailing with <code class="codespan">ellipsis</code>.</li>\n<li><code class="codespan">&#39;break&#39;</code> Break by word</li>\n<li><code class="codespan">&#39;breakAll&#39;</code> Break by character.</li>\n</ul>\n',
    )
    ellipsis: Optional[str] = Field(
        '...',
        description='<p>Ellipsis to be displayed when <code class="codespan">overflow</code> is set to <code class="codespan">truncate</code>.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the overflow lines.</li>\n</ul>\n',
    )
    rich: Optional[Rich] = Field(
        None,
        description='<p>&quot;Rich text styles&quot; can be defined in this <code class="codespan">rich</code> property. For example:</p>\n<pre><code class="lang-ts">label: {\n    // Styles defined in &#39;rich&#39; can be applied to some fragments\n    // of text by adding some markers to those fragment, like\n    // `{styleName|text content text content}`.\n    // `&#39;\\n&#39;` is the newline character.\n    formatter: [\n        &#39;{a|Style &quot;a&quot; is applied to this snippet}&#39;\n        &#39;{b|Style &quot;b&quot; is applied to this snippet}This snippet use default style{x|use style &quot;x&quot;}&#39;\n    ].join(&#39;\\n&#39;),\n\n    rich: {\n        a: {\n            color: &#39;red&#39;,\n            lineHeight: 10\n        },\n        b: {\n            backgroundColor: {\n                image: &#39;xxx/xxx.jpg&#39;\n            },\n            height: 40\n        },\n        x: {\n            fontSize: 18,\n            fontFamily: &#39;Microsoft YaHei&#39;,\n            borderColor: &#39;#449933&#39;,\n            borderRadius: 4\n        },\n        ...\n    }\n}\n</code></pre>\n<p>For more details, see <a href="tutorial.html#Rich%20Text" target="_blank">Rich Text</a> please.</p>\n',
    )


class _StyleName1(_StyleName):
    pass


class Rich1(BaseModel):
    """
        <p>&quot;Rich text styles&quot; can be defined in this <code class="codespan">rich</code> property. For example:</p>
    <pre><code class="lang-ts">label: {
        // Styles defined in &#39;rich&#39; can be applied to some fragments
        // of text by adding some markers to those fragment, like
        // `{styleName|text content text content}`.
        // `&#39;\n&#39;` is the newline character.
        formatter: [
            &#39;{a|Style &quot;a&quot; is applied to this snippet}&#39;
            &#39;{b|Style &quot;b&quot; is applied to this snippet}This snippet use default style{x|use style &quot;x&quot;}&#39;
        ].join(&#39;\n&#39;),

        rich: {
            a: {
                color: &#39;red&#39;,
                lineHeight: 10
            },
            b: {
                backgroundColor: {
                    image: &#39;xxx/xxx.jpg&#39;
                },
                height: 40
            },
            x: {
                fontSize: 18,
                fontFamily: &#39;Microsoft YaHei&#39;,
                borderColor: &#39;#449933&#39;,
                borderRadius: 4
            },
            ...
        }
    }
    </code></pre>
    <p>For more details, see <a href="tutorial.html#Rich%20Text" target="_blank">Rich Text</a> please.</p>

    """

    _style_name_: Optional[_StyleName1] = Field(
        None, alias='<style_name>', description=''
    )


class SubtextStyle(BaseModel):
    color: Optional[Any] = Field(
        '#aaa', description='\n\n<p>subtitle text color.</p>\n'
    )
    fontStyle: Optional[str] = Field(
        'normal',
        description='\n\n<p>subtitle font style.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;italic&#39;</code></li>\n<li><code class="codespan">&#39;oblique&#39;</code></li>\n</ul>\n',
    )
    fontWeight: Optional[Union[str, float]] = Field(
        'normal',
        description='\n\n<p>subtitle font thick weight.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;bold&#39;</code></li>\n<li><code class="codespan">&#39;bolder&#39;</code></li>\n<li><code class="codespan">&#39;lighter&#39;</code></li>\n<li>100 | 200 | 300 | 400...</li>\n</ul>\n',
    )
    fontFamily: Optional[str] = Field(
        'sans-serif',
        description='\n\n<p>subtitle font family.</p>\n<p>Can also be &#39;serif&#39; , &#39;monospace&#39;, ...</p>\n',
    )
    fontSize: Optional[float] = Field(
        12, description='\n\n<p>subtitle font size.</p>\n'
    )
    align: Optional[str] = Field(
        None,
        description='\n\n<p>Horizontal alignment of text, automatic by default.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;left&#39;</code></li>\n<li><code class="codespan">&#39;center&#39;</code></li>\n<li><code class="codespan">&#39;right&#39;</code></li>\n</ul>\n<p>If <code class="codespan">align</code> is not set in <code class="codespan">rich</code>, <code class="codespan">align</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    align: right,\n    rich: {\n        a: {\n            // `align` is not set, then it will be right\n        }\n    }\n}\n</code></pre>\n',
    )
    verticalAlign: Optional[str] = Field(
        None,
        description='\n\n<p>Vertical alignment of text, automatic by default.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;top&#39;</code></li>\n<li><code class="codespan">&#39;middle&#39;</code></li>\n<li><code class="codespan">&#39;bottom&#39;</code></li>\n</ul>\n<p>If <code class="codespan">verticalAlign</code> is not set in <code class="codespan">rich</code>, <code class="codespan">verticalAlign</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    verticalAlign: bottom,\n    rich: {\n        a: {\n            // `verticalAlign` is not set, then it will be bottom\n        }\n    }\n}\n</code></pre>\n',
    )
    lineHeight: Optional[float] = Field(
        None,
        description='\n\n<p>Line height of the text fragment.</p>\n<p>If <code class="codespan">lineHeight</code> is not set in <code class="codespan">rich</code>, <code class="codespan">lineHeight</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    lineHeight: 56,\n    rich: {\n        a: {\n            // `lineHeight` is not set, then it will be 56\n        }\n    }\n}\n</code></pre>\n',
    )
    width: Optional[float] = Field(
        None, description='\n\n<p>Width of text block.</p>\n'
    )
    height: Optional[float] = Field(
        None, description='\n\n<p>Height of text block.</p>\n'
    )
    textBorderColor: Optional[Any] = Field(
        None, description='\n\n<p>Stroke color of the text.</p>\n'
    )
    textBorderWidth: Optional[float] = Field(
        None, description='\n\n<p>Stroke line width of the text.</p>\n'
    )
    textBorderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>Stroke line type of the text.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">textBorderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\ntextBorderType: [5, 10],\n\ntextBorderDashOffset: 5\n}\n</code></pre>\n',
    )
    textBorderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">textBorderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    textShadowColor: Optional[Any] = Field(
        'transparent', description='\n\n<p>Shadow color of the text itself.</p>\n'
    )
    textShadowBlur: Optional[float] = Field(
        0, description='\n\n<p>Shadow blue of the text itself.</p>\n'
    )
    textShadowOffsetX: Optional[float] = Field(
        0, description='\n\n<p>Shadow X offset of the text itself.</p>\n'
    )
    textShadowOffsetY: Optional[float] = Field(
        0, description='\n\n<p>Shadow Y offset of the text itself.</p>\n'
    )
    overflow: Optional[str] = Field(
        'none',
        description='\n\n<p>Determine how to display the text when it&#39;s overflow. Available when <code class="codespan">width</code> is set.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the text and trailing with <code class="codespan">ellipsis</code>.</li>\n<li><code class="codespan">&#39;break&#39;</code> Break by word</li>\n<li><code class="codespan">&#39;breakAll&#39;</code> Break by character.</li>\n</ul>\n',
    )
    ellipsis: Optional[str] = Field(
        '...',
        description='<p>Ellipsis to be displayed when <code class="codespan">overflow</code> is set to <code class="codespan">truncate</code>.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the overflow lines.</li>\n</ul>\n',
    )
    rich: Optional[Rich1] = Field(
        None,
        description='<p>&quot;Rich text styles&quot; can be defined in this <code class="codespan">rich</code> property. For example:</p>\n<pre><code class="lang-ts">label: {\n    // Styles defined in &#39;rich&#39; can be applied to some fragments\n    // of text by adding some markers to those fragment, like\n    // `{styleName|text content text content}`.\n    // `&#39;\\n&#39;` is the newline character.\n    formatter: [\n        &#39;{a|Style &quot;a&quot; is applied to this snippet}&#39;\n        &#39;{b|Style &quot;b&quot; is applied to this snippet}This snippet use default style{x|use style &quot;x&quot;}&#39;\n    ].join(&#39;\\n&#39;),\n\n    rich: {\n        a: {\n            color: &#39;red&#39;,\n            lineHeight: 10\n        },\n        b: {\n            backgroundColor: {\n                image: &#39;xxx/xxx.jpg&#39;\n            },\n            height: 40\n        },\n        x: {\n            fontSize: 18,\n            fontFamily: &#39;Microsoft YaHei&#39;,\n            borderColor: &#39;#449933&#39;,\n            borderRadius: 4\n        },\n        ...\n    }\n}\n</code></pre>\n<p>For more details, see <a href="tutorial.html#Rich%20Text" target="_blank">Rich Text</a> please.</p>\n',
    )


class Title(BaseModel):
    """
        <p>Title component, including main title and subtitle.</p>
    <p>In ECharts 2.x, a single instance of ECharts could contains one title component at most. However, in ECharts 3, there could be one or more than one title components. It is more useful when multiple diagrams in one instance all need titles.</p>
    <p><strong>Here are some instances of different animation easing functions, among which every instance has a title component: </strong></p>
    <iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=line-easing&edit=1&reset=1" width="700" height="400"></iframe>




    """

    id: Optional[str] = Field(
        None,
        description='<p>Component ID, not specified by default. If specified, it can be used to refer the component in option or API.</p>\n',
    )
    show: Optional[bool] = Field(
        True,
        description='\n\n<p>Set this to <code class="codespan">false</code> to prevent the title from showing</p>\n',
    )
    text: Optional[str] = Field(
        '',
        description='\n\n<p>The main title text, supporting for <code class="codespan">\\n</code> for newlines.</p>\n',
    )
    link: Optional[str] = Field(
        '', description='<p>The hyper link of main title text.</p>\n'
    )
    target: Optional[str] = Field(
        'blank',
        description='<p>Open the hyper link of main title in specified tab.</p>\n<p><strong>options: </strong></p>\n<ul>\n<li><p><code class="codespan">&#39;self&#39;</code> opening it in current tab</p>\n</li>\n<li><p><code class="codespan">&#39;blank&#39;</code> opening it in a new tab</p>\n</li>\n</ul>\n',
    )
    textStyle: Optional[TextStyle] = Field(None, description='')
    subtext: Optional[str] = Field(
        '',
        description='\n\n<p>Subtitle text, supporting for <code class="codespan">\\n</code> for newlines.</p>\n',
    )
    sublink: Optional[str] = Field(
        '', description='<p>The hyper link of subtitle text.</p>\n'
    )
    subtarget: Optional[str] = Field(
        'blank',
        description='<p>Open the hyper link of subtitle in specified tab, options:</p>\n<ul>\n<li><p><code class="codespan">&#39;self&#39;</code> opening it in current tab</p>\n</li>\n<li><p><code class="codespan">&#39;blank&#39;</code> opening it in a new tab</p>\n</li>\n</ul>\n',
    )
    subtextStyle: Optional[SubtextStyle] = Field(None, description='')
    textAlign: Optional[str] = Field(
        'auto',
        description='\n\n<p>The horizontal align of the component (including &quot;text&quot; and &quot;subtext&quot;).</p>\n<p>Optional values: <code class="codespan">&#39;auto&#39;</code>, <code class="codespan">&#39;left&#39;</code>, <code class="codespan">&#39;right&#39;</code>, <code class="codespan">&#39;center&#39;</code>.</p>\n',
    )
    textVerticalAlign: Optional[str] = Field(
        'auto',
        description='\n\n<p>The vertical align of the component (including &quot;text&quot; and &quot;subtext&quot;).</p>\n<p>Optional values: <code class="codespan">&#39;auto&#39;</code>, <code class="codespan">&#39;top&#39;</code>, <code class="codespan">&#39;bottom&#39;</code>, <code class="codespan">&#39;middle&#39;</code>.</p>\n',
    )
    triggerEvent: Optional[bool] = Field(
        False,
        description='<p>Set this to <code class="codespan">true</code> to enable triggering events</p>\n',
    )
    padding: Optional[Union[float, Any]] = Field(
        5,
        description='\n\n<p>title space around content. The unit is px. Default values for each position are 5. And they can be set to different values with left, right, top, and bottom.</p>\n<p>Examples:</p>\n<pre><code class="lang-ts">// Set padding to be 5\npadding: 5\n// Set the top and bottom paddings to be 5, and left and right paddings to be 10\npadding: [5, 10]\n// Set each of the four paddings seperately\npadding: [\n    5,  // up\n    10, // right\n    5,  // down\n    10, // left\n]\n</code></pre>\n',
    )
    itemGap: Optional[float] = Field(
        10, description='\n\n<p>The gap between the main title and subtitle.</p>\n'
    )
    zlevel: Optional[float] = Field(
        0,
        description='<p><code class="codespan">zlevel</code> value of all graphical elements in .</p>\n<p><code class="codespan">zlevel</code> is used to make layers with Canvas. Graphical elements with different <code class="codespan">zlevel</code> values will be placed in different Canvases, which is a common optimization technique. We can put those frequently changed elements (like those with animations) to a separate <code class="codespan">zlevel</code>. Notice that too many Canvases will increase memory cost, and should be used carefully on mobile phones to avoid crash.</p>\n<p>Canvases with bigger <code class="codespan">zlevel</code> will be placed on Canvases with smaller <code class="codespan">zlevel</code>.</p>\n',
    )
    z: Optional[float] = Field(
        2,
        description='<p><code class="codespan">z</code> value of all graphical elements in , which controls order of drawing graphical components. Components with smaller <code class="codespan">z</code> values may be overwritten by those with larger <code class="codespan">z</code> values.</p>\n<p><code class="codespan">z</code> has a lower priority to <code class="codespan">zlevel</code>, and will not create new Canvas.</p>\n',
    )
    left: Optional[Union[str, float]] = Field(
        'auto',
        description='<p>Distance between title  component and the left side of the container.</p>\n<p><code class="codespan">left</code> value can be instant pixel value like <code class="codespan">20</code>; it can also be a percentage value relative to container width like <code class="codespan">&#39;20%&#39;</code>; and it can also be <code class="codespan">&#39;left&#39;</code>, <code class="codespan">&#39;center&#39;</code>, or <code class="codespan">&#39;right&#39;</code>.</p>\n<p>If the <code class="codespan">left</code> value is set to be <code class="codespan">&#39;left&#39;</code>, <code class="codespan">&#39;center&#39;</code>, or <code class="codespan">&#39;right&#39;</code>, then the component will be aligned automatically based on position.</p>\n',
    )
    top: Optional[Union[str, float]] = Field(
        'auto',
        description='<p>Distance between title  component and the top side of the container.</p>\n<p><code class="codespan">top</code> value can be instant pixel value like <code class="codespan">20</code>; it can also be a percentage value relative to container width like <code class="codespan">&#39;20%&#39;</code>; and it can also be <code class="codespan">&#39;top&#39;</code>, <code class="codespan">&#39;middle&#39;</code>, or <code class="codespan">&#39;bottom&#39;</code>.</p>\n<p>If the <code class="codespan">top</code> value is set to be <code class="codespan">&#39;top&#39;</code>, <code class="codespan">&#39;middle&#39;</code>, or <code class="codespan">&#39;bottom&#39;</code>, then the component will be aligned automatically based on position.</p>\n',
    )
    right: Optional[Union[str, float]] = Field(
        'auto',
        description='<p>Distance between title  component and the right side of the container.</p>\n<p><code class="codespan">right</code> value can be instant pixel value like <code class="codespan">20</code>; it can also be a percentage value relative to container width like <code class="codespan">&#39;20%&#39;</code>.</p>\n<p>Adaptive by default.</p>\n',
    )
    bottom: Optional[Union[str, float]] = Field(
        'auto',
        description='<p>Distance between title  component and the bottom side of the container.</p>\n<p><code class="codespan">bottom</code> value can be instant pixel value like <code class="codespan">20</code>; it can also be a percentage value relative to container width like <code class="codespan">&#39;20%&#39;</code>.</p>\n<p>Adaptive by default.</p>\n',
    )
    backgroundColor: Optional[Any] = Field(
        'transparent',
        description='\n\n<p>Background color of title, which is transparent by default.</p>\n<blockquote>\n<p>Color can be represented in RGB, for example <code class="codespan">&#39;rgb(128, 128, 128)&#39;</code>. RGBA can be used when you need alpha channel, for example <code class="codespan">&#39;rgba(128, 128, 128, 0.5)&#39;</code>. You may also use hexadecimal format, for example <code class="codespan">&#39;#ccc&#39;</code>.</p>\n</blockquote>\n',
    )
    borderColor: Optional[Any] = Field(
        '#ccc',
        description='\n\n<p>Border color of title. Support the same color format as backgroundColor.</p>\n',
    )
    borderWidth: Optional[float] = Field(
        1, description='\n\n<p>Border width of title.</p>\n'
    )
    borderRadius: Optional[Union[float, Any]] = Field(
        0,
        description='\n\n<p>The radius of rounded corner. Its unit is px. And it supports use array to respectively specify the 4 corner radiuses.</p>\n<p>For example:</p>\n<pre><code>borderRadius: 5, // consistently set the size of 4 rounded corners\nborderRadius: [5, 5, 0, 0] // (clockwise upper left, upper right, bottom right and bottom left)\n</code></pre>',
    )
    shadowBlur: Optional[float] = Field(
        None,
        description='\n\n<p>Size of shadow blur. This attribute should be used along with <code class="codespan">shadowColor</code>,<code class="codespan">shadowOffsetX</code>, <code class="codespan">shadowOffsetY</code> to set shadow to component.</p>\n<p>For example:</p>\n<pre><code class="lang-ts">{\n    shadowColor: &#39;rgba(0, 0, 0, 0.5)&#39;,\n    shadowBlur: 10\n}\n</code></pre>\n<p><strong>Attention</strong>: This property works only if <code class="codespan">show: true</code> is configured and <code class="codespan">backgroundColor</code> is defined other than <code class="codespan">transparent</code>.</p>\n',
    )
    shadowColor: Optional[Any] = Field(
        None,
        description='\n\n<p>Shadow color. Support same format as <code class="codespan">color</code>.</p>\n<p><strong>Attention</strong>: This property works only if <code class="codespan">show: true</code> configured.</p>\n',
    )
    shadowOffsetX: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the horizontal direction of shadow.</p>\n<p><strong>Attention</strong>: This property works only if <code class="codespan">show: true</code> configured.</p>\n',
    )
    shadowOffsetY: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the vertical direction of shadow.</p>\n<p><strong>Attention</strong>: This property works only if <code class="codespan">show: true</code> configured.</p>\n',
    )


class Decal(BaseModel):
    """
        <p>The style of the decal pattern. It works only if <a href="#aria.enabled">aria.enabled</a> and <a href="#aria.decal.show">aria.decal.show</a> are both set to be <code class="codespan">true</code>.</p>
    <p>If it is set to be <code class="codespan">&#39;none&#39;</code>, no decal will be used.</p>

    """

    symbol: Optional[Union[str, Any]] = Field(
        'rect',
        description='<p>The symbol type of the decal. If it is in the type of <code class="codespan">string[]</code>, it means the symbols are used one by one.</p>\n<p>Icon types provided by ECharts includes</p>\n<p><code class="codespan">&#39;circle&#39;</code>, <code class="codespan">&#39;rect&#39;</code>, <code class="codespan">&#39;roundRect&#39;</code>, <code class="codespan">&#39;triangle&#39;</code>, <code class="codespan">&#39;diamond&#39;</code>, <code class="codespan">&#39;pin&#39;</code>, <code class="codespan">&#39;arrow&#39;</code>, <code class="codespan">&#39;none&#39;</code></p>\n<p>It can be set to an image with <code class="codespan">&#39;image://url&#39;</code> , in which URL is the link to an image, or <code class="codespan">dataURI</code> of an image.</p>\n<p>An image URL example:</p>\n<pre><code>&#39;image://http://example.website/a/b.png&#39;\n</code></pre><p>A <code class="codespan">dataURI</code> example:</p>\n<pre><code>&#39;image://data:image/gif;base64,R0lGODlhEAAQAMQAAORHHOVSKudfOulrSOp3WOyDZu6QdvCchPGolfO0o/XBs/fNwfjZ0frl3/zy7////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAkAABAALAAAAAAQABAAAAVVICSOZGlCQAosJ6mu7fiyZeKqNKToQGDsM8hBADgUXoGAiqhSvp5QAnQKGIgUhwFUYLCVDFCrKUE1lBavAViFIDlTImbKC5Gm2hB0SlBCBMQiB0UjIQA7&#39;\n</code></pre><p>Icons can be set to arbitrary vector path via <code class="codespan">&#39;path://&#39;</code> in ECharts. As compared with a raster image, vector paths prevent jagging and blurring when scaled, and have better control over changing colors. The size of the vector icon will be adapted automatically. Refer to <a href="http://www.w3.org/TR/SVG/paths.html#PathData" target="_blank">SVG PathData</a> for more information about the format of the path. You may export vector paths from tools like Adobe </p>\n<p>For example:</p>\n<pre><code>&#39;path://M30.9,53.2C16.8,53.2,5.3,41.7,5.3,27.6S16.8,2,30.9,2C45,2,56.4,13.5,56.4,27.6S45,53.2,30.9,53.2z M30.9,3.5C17.6,3.5,6.8,14.4,6.8,27.6c0,13.3,10.8,24.1,24.101,24.1C44.2,51.7,55,40.9,55,27.6C54.9,14.4,44.1,3.5,30.9,3.5z M36.9,35.8c0,0.601-0.4,1-0.9,1h-1.3c-0.5,0-0.9-0.399-0.9-1V19.5c0-0.6,0.4-1,0.9-1H36c0.5,0,0.9,0.4,0.9,1V35.8z M27.8,35.8 c0,0.601-0.4,1-0.9,1h-1.3c-0.5,0-0.9-0.399-0.9-1V19.5c0-0.6,0.4-1,0.9-1H27c0.5,0,0.9,0.4,0.9,1L27.8,35.8L27.8,35.8z&#39;\n</code></pre>',
    )
    symbolSize: Optional[float] = Field(
        1,
        description='<p>Range of values: <code class="codespan">0</code> to <code class="codespan">1</code>, representing the size of symbol relative to decal.</p>\n',
    )
    symbolKeepAspect: Optional[bool] = Field(
        True,
        description='<p>Whether or not to keep the aspect ratio of the pattern.</p>\n',
    )
    color: Optional[str] = Field(
        'rgba(0, 0, 0, 0.2)',
        description='<p>For the color of the decal pattern, it is recommended to use a translucent color, which can be superimposed on the color of the series itself.</p>\n',
    )
    backgroundColor: Optional[str] = Field(
        None,
        description='<p>The background color of the decal will be over the color of the series itself, under the decal pattern.</p>\n',
    )
    dashArrayX: Optional[Union[float, Any]] = Field(
        5,
        description='<p>The basic pattern of the decal pattern is an infinite loop in the form of <code class="codespan">Pattern - Blank - Pattern - Blank - Pattern - Blank</code> both horizontally and vertically, respectively. By setting the length of each pattern and blank, complex pattern effects can be achieved.</p>\n<p><code class="codespan">dashArrayX</code> controls the horizontal pattern pattern. When its value is of type <code class="codespan">number</code> or <code class="codespan">number[]</code>, it is similar to <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">SVG stroke-dasharray</a>.</p>\n<ul>\n<li><p>If it is of type <code class="codespan">number</code>, it means that the pattern and the blank space are of this value respectively. For example, <code class="codespan">5</code> means the pattern with width 5 is displayed first, then 5 pixels empty, then the pattern with width 5 is displayed...</p>\n</li>\n<li><p>In the case of <code class="codespan">number[]</code> type, it means that the pattern and empty space are loops of an array of values. For example: <code class="codespan">[5, 10, 2, 6]</code> means the pattern is 5 pixels wide, then 10 pixels empty, then the pattern is 2 pixels wide, then 6 pixels empty, then the pattern is 5 pixels wide...</p>\n</li>\n<li><p>If of type <code class="codespan">(number | number[])[]</code>, it means that each row is a loop with an array of values for the pattern and blank space. For example: <code class="codespan">[10, [2, 5]]</code> means that the first line will be 10 pixels by 10 pixels and empty space, the second line will be 2 pixels by 2 pixels and empty space, and the third line will be 10 pixels by 10 pixels and empty space...</p>\n</li>\n</ul>\n<p>This interface can be better understood with the following examples.</p>\n<iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=doc-example/aria-decal&edit=1&reset=1" width="700" height="300"></iframe>\n\n',
    )
    dashArrayY: Optional[Union[float, Any]] = Field(
        5,
        description='<p>The basic pattern of the decal pattern is an infinite loop in the form of <code class="codespan">Pattern - Blank - Pattern - Blank - Pattern - Blank</code> both horizontally and vertically, respectively. By setting the length of each pattern and blank, complex pattern effects can be achieved.</p>\n<p><code class="codespan">dashArrayY</code> controls the horizontal pattern pattern. Similar to <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">SVG stroke-dasharray</a>.</p>\n<ul>\n<li><p>If it is a <code class="codespan">number</code> type, it means the pattern and the blank are each of this value. For example, <code class="codespan">5</code> means that the pattern with a height of 5 is displayed first, then 5 pixels empty, then the pattern with a height of 5 is displayed...</p>\n</li>\n<li><p>In the case of <code class="codespan">number[]</code> type, it means that the pattern and empty space are loops of sequential array values. For example: <code class="codespan">[5, 10, 2, 6]</code> means the pattern is 5 pixels high, then 10 pixels empty, then the pattern is 2 pixels high, then 6 pixels empty, then the pattern is 5 pixels high...</p>\n</li>\n</ul>\n<p>This interface can be better understood with the following examples.</p>\n<iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=doc-example/aria-decal&edit=1&reset=1" width="700" height="300"></iframe>\n\n',
    )
    rotation: Optional[float] = Field(
        0,
        description='<p>The overall rotation angle (in radians) of the pattern, in the range from `-Math.</p>\n',
    )
    maxTileWidth: Optional[float] = Field(
        512,
        description='<p>The upper limit of the width of the generated pattern before it is duplicated. Usually this value is not necessary, but you can try to increase it if you notice discontinuous seams in the pattern when it repeats.</p>\n',
    )
    maxTileHeight: Optional[float] = Field(
        512,
        description='<p>The upper limit of the height of the generated pattern before it repeats. This value is usually not necessary to set, but you can try to increase it if you find that the pattern has discontinuous seams when it is repeated.</p>\n',
    )


class ItemStyle(BaseModel):
    """
    <p>Legend item style. If its children have values as <code class="codespan">&#39;inherit&#39;</code>, the values are inherited from corresponding series options.</p>

    """

    color: Optional[Any] = Field(
        'inherit',
        description='\n\n<p> color. </p>\n<blockquote>\n<p>Supports setting as solid color using <code class="codespan">rgb(255,255,255)</code>, <code class="codespan">rgba(255,255,255,1)</code>, <code class="codespan">#fff</code>, etc. Also supports setting as gradient color and pattern fill, see <a href="#color">option.color</a> for details</p>\n</blockquote>\n',
    )
    borderColor: Optional[Any] = Field(
        'inherit',
        description='\n\n<p> border color, whose format is similar to that of <code class="codespan">color</code>.</p>\n',
    )
    borderWidth: Optional[float] = Field(
        'auto',
        description='\n\n<p> border width. No border when it is set to be 0.</p>\n<p>When its value is <code class="codespan">&quot;auto&quot;</code>, if there is <code class="codespan">borderWidth</code> in series, then it is set to be 2, otherwise, it is set to be 0. If its value is <code class="codespan">&quot;inherit&quot;</code>, then the <code class="codespan">borderWidth</code> of the series are always used</p>\n',
    )
    borderType: Optional[Union[str, float, Any]] = Field(
        'inherit',
        description='\n\n\n<p> border type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">borderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\nborderType: [5, 10],\n\nborderDashOffset: 5\n}\n</code></pre>\n',
    )
    borderDashOffset: Optional[float] = Field(
        'inherit',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">borderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    borderCap: Optional[str] = Field(
        'inherit',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To specify how to draw the end points of the line.\nPossible values are:</p>\n<ul>\n<li><code class="codespan">&#39;butt&#39;</code>: The ends of lines are squared off at the endpoints.</li>\n<li><code class="codespan">&#39;round&#39;</code>: The ends of lines are rounded.</li>\n<li><code class="codespan">&#39;square&#39;</code>: The ends of lines are squared off by adding a box with an equal width and half the height of the line&#39;s thickness.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;butt&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineCap" target="_blank">lineCap</a> for more details.</p>\n',
    )
    borderJoin: Optional[str] = Field(
        'inherit',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To determine the shape used to join two line segments where they meet.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;bevel&#39;</code>: Fills an additional triangular area between the common endpoint of connected segments, and the separate outside rectangular corners of each segment.</li>\n<li><code class="codespan">&#39;round&#39;</code>: Rounds off the corners of a shape by filling an additional sector of disc centered at the common endpoint of connected segments. The radius for these rounded corners is equal to the line width.</li>\n<li><code class="codespan">&#39;miter&#39;</code>: Connected segments are joined by extending their outside edges to connect at a single point, with the effect of filling an additional lozenge-shaped area. This setting is affected by the \n<code class="codespan">borderMiterLimit</code>\nproperty.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;bevel&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineJoin" target="_blank">lineJoin</a> for more details.</p>\n',
    )
    borderMiterLimit: Optional[float] = Field(
        'inherit',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the miter limit ratio. Only works when \n<code class="codespan">borderJoin</code>\n is set as <code class="codespan">miter</code>.</p>\n<p>Default value is <code class="codespan">10</code>. Negative、<code class="codespan">0</code>、<code class="codespan">Infinity</code> and <code class="codespan">NaN</code> values are ignored.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/miterLimit" target="_blank">miterLimit</a> for more details.</p>\n',
    )
    shadowBlur: Optional[float] = Field(
        0,
        description='\n\n<p>Size of shadow blur. This attribute should be used along with <code class="codespan">shadowColor</code>,<code class="codespan">shadowOffsetX</code>, <code class="codespan">shadowOffsetY</code> to set shadow to component.</p>\n<p>For example:</p>\n<pre><code class="lang-ts">{\n    shadowColor: &#39;rgba(0, 0, 0, 0.5)&#39;,\n    shadowBlur: 10\n}\n</code></pre>\n',
    )
    shadowColor: Optional[Any] = Field(
        None,
        description='\n\n<p>Shadow color. Support same format as <code class="codespan">color</code>.</p>\n',
    )
    shadowOffsetX: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the horizontal direction of shadow.</p>\n',
    )
    shadowOffsetY: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the vertical direction of shadow.</p>\n',
    )
    opacity: Optional[float] = Field(
        'inherit',
        description='\n\n<p>Opacity of the component. Supports value from 0 to 1, and the component will not be drawn when set to 0.</p>\n',
    )
    decal: Optional[Decal] = Field(
        'inherit',
        description='<p>The style of the decal pattern. It works only if <a href="#aria.enabled">aria.enabled</a> and <a href="#aria.decal.show">aria.decal.show</a> are both set to be <code class="codespan">true</code>.</p>\n<p>If it is set to be <code class="codespan">&#39;none&#39;</code>, no decal will be used.</p>\n',
    )


class LineStyle(BaseModel):
    """
    <p>Legend line style. If its children have values as <code class="codespan">&#39;inherit&#39;</code>, the values are inherited from corresponding series options.</p>

    """

    color: Optional[Any] = Field(
        'inherit',
        description='\n\n<p>Line color. </p>\n<blockquote>\n<p>Supports setting as solid color using <code class="codespan">rgb(255,255,255)</code>, <code class="codespan">rgba(255,255,255,1)</code>, <code class="codespan">#fff</code>, etc. Also supports setting as gradient color and pattern fill, see <a href="#color">option.color</a> for details</p>\n</blockquote>\n',
    )
    width: Optional[float] = Field('auto', description='\n\n<p> line width.</p>\n')
    type: Optional[Union[str, float, Any]] = Field(
        'inherit',
        description='\n\n\n<p>line type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">dashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\ntype: [5, 10],\n\ndashOffset: 5\n}\n</code></pre>\n',
    )
    dashOffset: Optional[float] = Field(
        'inherit',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">type</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    cap: Optional[str] = Field(
        'inherit',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To specify how to draw the end points of the line.\nPossible values are:</p>\n<ul>\n<li><code class="codespan">&#39;butt&#39;</code>: The ends of lines are squared off at the endpoints.</li>\n<li><code class="codespan">&#39;round&#39;</code>: The ends of lines are rounded.</li>\n<li><code class="codespan">&#39;square&#39;</code>: The ends of lines are squared off by adding a box with an equal width and half the height of the line&#39;s thickness.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;butt&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineCap" target="_blank">lineCap</a> for more details.</p>\n',
    )
    join: Optional[str] = Field(
        'inherit',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To determine the shape used to join two line segments where they meet.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;bevel&#39;</code>: Fills an additional triangular area between the common endpoint of connected segments, and the separate outside rectangular corners of each segment.</li>\n<li><code class="codespan">&#39;round&#39;</code>: Rounds off the corners of a shape by filling an additional sector of disc centered at the common endpoint of connected segments. The radius for these rounded corners is equal to the line width.</li>\n<li><code class="codespan">&#39;miter&#39;</code>: Connected segments are joined by extending their outside edges to connect at a single point, with the effect of filling an additional lozenge-shaped area. This setting is affected by the \n<code class="codespan">miterLimit</code>\nproperty.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;bevel&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineJoin" target="_blank">lineJoin</a> for more details.</p>\n',
    )
    miterLimit: Optional[float] = Field(
        'inherit',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the miter limit ratio. Only works when \n<code class="codespan">join</code>\n is set as <code class="codespan">miter</code>.</p>\n<p>Default value is <code class="codespan">10</code>. Negative、<code class="codespan">0</code>、<code class="codespan">Infinity</code> and <code class="codespan">NaN</code> values are ignored.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/miterLimit" target="_blank">miterLimit</a> for more details.</p>\n',
    )
    shadowBlur: Optional[float] = Field(
        'inherit',
        description='\n\n<p>Size of shadow blur. This attribute should be used along with <code class="codespan">shadowColor</code>,<code class="codespan">shadowOffsetX</code>, <code class="codespan">shadowOffsetY</code> to set shadow to component.</p>\n<p>For example:</p>\n<pre><code class="lang-ts">{\n    shadowColor: &#39;rgba(0, 0, 0, 0.5)&#39;,\n    shadowBlur: 10\n}\n</code></pre>\n',
    )
    shadowColor: Optional[Any] = Field(
        None,
        description='\n\n<p>Shadow color. Support same format as <code class="codespan">color</code>.</p>\n',
    )
    shadowOffsetX: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the horizontal direction of shadow.</p>\n',
    )
    shadowOffsetY: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the vertical direction of shadow.</p>\n',
    )
    opacity: Optional[float] = Field(
        'inherit',
        description='\n\n<p>Opacity of the component. Supports value from 0 to 1, and the component will not be drawn when set to 0.</p>\n',
    )


class _StyleName2(_StyleName):
    pass


class Rich2(BaseModel):
    """
        <p>&quot;Rich text styles&quot; can be defined in this <code class="codespan">rich</code> property. For example:</p>
    <pre><code class="lang-ts">label: {
        // Styles defined in &#39;rich&#39; can be applied to some fragments
        // of text by adding some markers to those fragment, like
        // `{styleName|text content text content}`.
        // `&#39;\n&#39;` is the newline character.
        formatter: [
            &#39;{a|Style &quot;a&quot; is applied to this snippet}&#39;
            &#39;{b|Style &quot;b&quot; is applied to this snippet}This snippet use default style{x|use style &quot;x&quot;}&#39;
        ].join(&#39;\n&#39;),

        rich: {
            a: {
                color: &#39;red&#39;,
                lineHeight: 10
            },
            b: {
                backgroundColor: {
                    image: &#39;xxx/xxx.jpg&#39;
                },
                height: 40
            },
            x: {
                fontSize: 18,
                fontFamily: &#39;Microsoft YaHei&#39;,
                borderColor: &#39;#449933&#39;,
                borderRadius: 4
            },
            ...
        }
    }
    </code></pre>
    <p>For more details, see <a href="tutorial.html#Rich%20Text" target="_blank">Rich Text</a> please.</p>

    """

    _style_name_: Optional[_StyleName2] = Field(
        None, alias='<style_name>', description=''
    )


class TextStyle1(BaseModel):
    """
    <p>Legend text style.</p>

    """

    color: Optional[Any] = Field('#333', description='\n\n<p> text color.</p>\n')
    fontStyle: Optional[str] = Field(
        'normal',
        description='\n\n<p> font style.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;italic&#39;</code></li>\n<li><code class="codespan">&#39;oblique&#39;</code></li>\n</ul>\n',
    )
    fontWeight: Optional[Union[str, float]] = Field(
        'normal',
        description='\n\n<p> font thick weight.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;bold&#39;</code></li>\n<li><code class="codespan">&#39;bolder&#39;</code></li>\n<li><code class="codespan">&#39;lighter&#39;</code></li>\n<li>100 | 200 | 300 | 400...</li>\n</ul>\n',
    )
    fontFamily: Optional[str] = Field(
        'sans-serif',
        description='\n\n<p> font family.</p>\n<p>Can also be &#39;serif&#39; , &#39;monospace&#39;, ...</p>\n',
    )
    fontSize: Optional[float] = Field(12, description='\n\n<p> font size.</p>\n')
    lineHeight: Optional[float] = Field(
        None,
        description='\n\n<p>Line height of the text fragment.</p>\n<p>If <code class="codespan">lineHeight</code> is not set in <code class="codespan">rich</code>, <code class="codespan">lineHeight</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    lineHeight: 56,\n    rich: {\n        a: {\n            // `lineHeight` is not set, then it will be 56\n        }\n    }\n}\n</code></pre>\n',
    )
    backgroundColor: Optional[Union[str, Any]] = Field(
        'transparent',
        description='\n\n<p>Background color of the text fragment.</p>\n<p>Can be color string, like <code class="codespan">&#39;#123234&#39;</code>, <code class="codespan">&#39;red&#39;</code>, <code class="codespan">&#39;rgba(0,23,11,0.3)&#39;</code>.</p>\n<p>Or image can be used, for example:</p>\n<pre><code class="lang-ts">backgroundColor: {\n    image: &#39;xxx/xxx.png&#39;\n    // It can be URL of a image,\n    // or dataURI,\n    // or HTMLImageElement,\n    // or HTMLCanvasElement.\n}\n</code></pre>\n<p><code class="codespan">width</code> or <code class="codespan">height</code> can be specified when using background image, or\nauto adapted by default.</p>\n',
    )
    borderColor: Optional[Any] = Field(
        None, description='\n\n<p>Border color of the text fragment.</p>\n'
    )
    borderWidth: Optional[float] = Field(
        0, description='\n\n<p>Border width of the text fragment.</p>\n'
    )
    borderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>the text fragment border type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">borderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\nborderType: [5, 10],\n\nborderDashOffset: 5\n}\n</code></pre>\n',
    )
    borderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">borderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    borderRadius: Optional[float] = Field(
        0, description='\n\n<p>Border radius of the text fragment.</p>\n'
    )
    padding: Optional[Union[float, Any]] = Field(
        0,
        description='\n\n<p>Padding of the text fragment, for example:</p>\n<ul>\n<li><code class="codespan">padding: [3, 4, 5, 6]</code>: represents padding of <code class="codespan">[top, right, bottom, left]</code>.</li>\n<li><code class="codespan">padding: 4</code>: represents <code class="codespan">padding: [4, 4, 4, 4]</code>.</li>\n<li><code class="codespan">padding: [3, 4]</code>: represents <code class="codespan">padding: [3, 4, 3, 4]</code>.</li>\n</ul>\n<p>Notice, <code class="codespan">width</code> and <code class="codespan">height</code> specifies the width and height of the content, without <code class="codespan">padding</code>.</p>\n',
    )
    shadowColor: Optional[Any] = Field(
        'transparent', description='\n\n<p>Shadow color of the text block.</p>\n'
    )
    shadowBlur: Optional[float] = Field(
        0, description='\n\n<p>Show blur of the text block.</p>\n'
    )
    shadowOffsetX: Optional[float] = Field(
        0, description='\n\n<p>Shadow X offset of the text block.</p>\n'
    )
    shadowOffsetY: Optional[float] = Field(
        0, description='\n\n<p>Shadow Y offset of the text block.</p>\n'
    )
    width: Optional[float] = Field(
        None, description='\n\n<p>Width of text block.</p>\n'
    )
    height: Optional[float] = Field(
        None, description='\n\n<p>Height of text block.</p>\n'
    )
    textBorderColor: Optional[Any] = Field(
        None, description='\n\n<p>Stroke color of the text.</p>\n'
    )
    textBorderWidth: Optional[float] = Field(
        None, description='\n\n<p>Stroke line width of the text.</p>\n'
    )
    textBorderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>Stroke line type of the text.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">textBorderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\ntextBorderType: [5, 10],\n\ntextBorderDashOffset: 5\n}\n</code></pre>\n',
    )
    textBorderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">textBorderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    textShadowColor: Optional[Any] = Field(
        'transparent', description='\n\n<p>Shadow color of the text itself.</p>\n'
    )
    textShadowBlur: Optional[float] = Field(
        0, description='\n\n<p>Shadow blue of the text itself.</p>\n'
    )
    textShadowOffsetX: Optional[float] = Field(
        0, description='\n\n<p>Shadow X offset of the text itself.</p>\n'
    )
    textShadowOffsetY: Optional[float] = Field(
        0, description='\n\n<p>Shadow Y offset of the text itself.</p>\n'
    )
    overflow: Optional[str] = Field(
        'none',
        description='\n\n<p>Determine how to display the text when it&#39;s overflow. Available when <code class="codespan">width</code> is set.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the text and trailing with <code class="codespan">ellipsis</code>.</li>\n<li><code class="codespan">&#39;break&#39;</code> Break by word</li>\n<li><code class="codespan">&#39;breakAll&#39;</code> Break by character.</li>\n</ul>\n',
    )
    ellipsis: Optional[str] = Field(
        '...',
        description='<p>Ellipsis to be displayed when <code class="codespan">overflow</code> is set to <code class="codespan">truncate</code>.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the overflow lines.</li>\n</ul>\n',
    )
    rich: Optional[Rich2] = Field(
        None,
        description='<p>&quot;Rich text styles&quot; can be defined in this <code class="codespan">rich</code> property. For example:</p>\n<pre><code class="lang-ts">label: {\n    // Styles defined in &#39;rich&#39; can be applied to some fragments\n    // of text by adding some markers to those fragment, like\n    // `{styleName|text content text content}`.\n    // `&#39;\\n&#39;` is the newline character.\n    formatter: [\n        &#39;{a|Style &quot;a&quot; is applied to this snippet}&#39;\n        &#39;{b|Style &quot;b&quot; is applied to this snippet}This snippet use default style{x|use style &quot;x&quot;}&#39;\n    ].join(&#39;\\n&#39;),\n\n    rich: {\n        a: {\n            color: &#39;red&#39;,\n            lineHeight: 10\n        },\n        b: {\n            backgroundColor: {\n                image: &#39;xxx/xxx.jpg&#39;\n            },\n            height: 40\n        },\n        x: {\n            fontSize: 18,\n            fontFamily: &#39;Microsoft YaHei&#39;,\n            borderColor: &#39;#449933&#39;,\n            borderRadius: 4\n        },\n        ...\n    }\n}\n</code></pre>\n<p>For more details, see <a href="tutorial.html#Rich%20Text" target="_blank">Rich Text</a> please.</p>\n',
    )


class Decal1(Decal):
    """
        <p>The style of the decal pattern. It works only if <a href="#aria.enabled">aria.enabled</a> and <a href="#aria.decal.show">aria.decal.show</a> are both set to be <code class="codespan">true</code>.</p>
    <p>If it is set to be <code class="codespan">&#39;none&#39;</code>, no decal will be used.</p>

    """

    pass


class ItemStyle1(BaseModel):
    """
    <p>Legend Item item style. If its children have values as <code class="codespan">&#39;inherit&#39;</code>, the values are inherited from corresponding series options.</p>

    """

    color: Optional[Any] = Field(
        'inherit',
        description='\n\n<p> color. </p>\n<blockquote>\n<p>Supports setting as solid color using <code class="codespan">rgb(255,255,255)</code>, <code class="codespan">rgba(255,255,255,1)</code>, <code class="codespan">#fff</code>, etc. Also supports setting as gradient color and pattern fill, see <a href="#color">option.color</a> for details</p>\n</blockquote>\n',
    )
    borderColor: Optional[Any] = Field(
        'inherit',
        description='\n\n<p> border color, whose format is similar to that of <code class="codespan">color</code>.</p>\n',
    )
    borderWidth: Optional[float] = Field(
        'auto',
        description='\n\n<p> border width. No border when it is set to be 0.</p>\n<p>When its value is <code class="codespan">&quot;auto&quot;</code>, if there is <code class="codespan">borderWidth</code> in series, then it is set to be 2, otherwise, it is set to be 0. If its value is <code class="codespan">&quot;inherit&quot;</code>, then the <code class="codespan">borderWidth</code> of the series are always used</p>\n',
    )
    borderType: Optional[Union[str, float, Any]] = Field(
        'inherit',
        description='\n\n\n<p> border type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">borderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\nborderType: [5, 10],\n\nborderDashOffset: 5\n}\n</code></pre>\n',
    )
    borderDashOffset: Optional[float] = Field(
        'inherit',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">borderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    borderCap: Optional[str] = Field(
        'inherit',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To specify how to draw the end points of the line.\nPossible values are:</p>\n<ul>\n<li><code class="codespan">&#39;butt&#39;</code>: The ends of lines are squared off at the endpoints.</li>\n<li><code class="codespan">&#39;round&#39;</code>: The ends of lines are rounded.</li>\n<li><code class="codespan">&#39;square&#39;</code>: The ends of lines are squared off by adding a box with an equal width and half the height of the line&#39;s thickness.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;butt&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineCap" target="_blank">lineCap</a> for more details.</p>\n',
    )
    borderJoin: Optional[str] = Field(
        'inherit',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To determine the shape used to join two line segments where they meet.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;bevel&#39;</code>: Fills an additional triangular area between the common endpoint of connected segments, and the separate outside rectangular corners of each segment.</li>\n<li><code class="codespan">&#39;round&#39;</code>: Rounds off the corners of a shape by filling an additional sector of disc centered at the common endpoint of connected segments. The radius for these rounded corners is equal to the line width.</li>\n<li><code class="codespan">&#39;miter&#39;</code>: Connected segments are joined by extending their outside edges to connect at a single point, with the effect of filling an additional lozenge-shaped area. This setting is affected by the \n<code class="codespan">borderMiterLimit</code>\nproperty.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;bevel&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineJoin" target="_blank">lineJoin</a> for more details.</p>\n',
    )
    borderMiterLimit: Optional[float] = Field(
        'inherit',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the miter limit ratio. Only works when \n<code class="codespan">borderJoin</code>\n is set as <code class="codespan">miter</code>.</p>\n<p>Default value is <code class="codespan">10</code>. Negative、<code class="codespan">0</code>、<code class="codespan">Infinity</code> and <code class="codespan">NaN</code> values are ignored.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/miterLimit" target="_blank">miterLimit</a> for more details.</p>\n',
    )
    shadowBlur: Optional[float] = Field(
        0,
        description='\n\n<p>Size of shadow blur. This attribute should be used along with <code class="codespan">shadowColor</code>,<code class="codespan">shadowOffsetX</code>, <code class="codespan">shadowOffsetY</code> to set shadow to component.</p>\n<p>For example:</p>\n<pre><code class="lang-ts">{\n    shadowColor: &#39;rgba(0, 0, 0, 0.5)&#39;,\n    shadowBlur: 10\n}\n</code></pre>\n',
    )
    shadowColor: Optional[Any] = Field(
        None,
        description='\n\n<p>Shadow color. Support same format as <code class="codespan">color</code>.</p>\n',
    )
    shadowOffsetX: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the horizontal direction of shadow.</p>\n',
    )
    shadowOffsetY: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the vertical direction of shadow.</p>\n',
    )
    opacity: Optional[float] = Field(
        'inherit',
        description='\n\n<p>Opacity of the component. Supports value from 0 to 1, and the component will not be drawn when set to 0.</p>\n',
    )
    decal: Optional[Decal1] = Field(
        'inherit',
        description='<p>The style of the decal pattern. It works only if <a href="#aria.enabled">aria.enabled</a> and <a href="#aria.decal.show">aria.decal.show</a> are both set to be <code class="codespan">true</code>.</p>\n<p>If it is set to be <code class="codespan">&#39;none&#39;</code>, no decal will be used.</p>\n',
    )


class LineStyle1(LineStyle):
    """
    <p>Legend Item line style. If its children have values as <code class="codespan">&#39;inherit&#39;</code>, the values are inherited from corresponding series options.</p>

    """

    pass


class Datum(BaseModel):
    name: Optional[str] = Field(
        None,
        description='<p>Name of legend, which should be the <code class="codespan">name</code> value of a certain series. If it is a pie chart, legend name can also be the name of a single data item.</p>\n',
    )
    icon: Optional[str] = Field(
        None,
        description='<p>Icon of the legend.</p>\n<p>Icon types provided by ECharts includes</p>\n<p><code class="codespan">&#39;circle&#39;</code>, <code class="codespan">&#39;rect&#39;</code>, <code class="codespan">&#39;roundRect&#39;</code>, <code class="codespan">&#39;triangle&#39;</code>, <code class="codespan">&#39;diamond&#39;</code>, <code class="codespan">&#39;pin&#39;</code>, <code class="codespan">&#39;arrow&#39;</code>, <code class="codespan">&#39;none&#39;</code></p>\n<p>It can be set to an image with <code class="codespan">&#39;image://url&#39;</code> , in which URL is the link to an image, or <code class="codespan">dataURI</code> of an image.</p>\n<p>An image URL example:</p>\n<pre><code>&#39;image://http://example.website/a/b.png&#39;\n</code></pre><p>A <code class="codespan">dataURI</code> example:</p>\n<pre><code>&#39;image://data:image/gif;base64,R0lGODlhEAAQAMQAAORHHOVSKudfOulrSOp3WOyDZu6QdvCchPGolfO0o/XBs/fNwfjZ0frl3/zy7////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAkAABAALAAAAAAQABAAAAVVICSOZGlCQAosJ6mu7fiyZeKqNKToQGDsM8hBADgUXoGAiqhSvp5QAnQKGIgUhwFUYLCVDFCrKUE1lBavAViFIDlTImbKC5Gm2hB0SlBCBMQiB0UjIQA7&#39;\n</code></pre><p>Icons can be set to arbitrary vector path via <code class="codespan">&#39;path://&#39;</code> in ECharts. As compared with a raster image, vector paths prevent jagging and blurring when scaled, and have better control over changing colors. The size of the vector icon will be adapted automatically. Refer to <a href="http://www.w3.org/TR/SVG/paths.html#PathData" target="_blank">SVG PathData</a> for more information about the format of the path. You may export vector paths from tools like Adobe </p>\n<p>For example:</p>\n<pre><code>&#39;path://M30.9,53.2C16.8,53.2,5.3,41.7,5.3,27.6S16.8,2,30.9,2C45,2,56.4,13.5,56.4,27.6S45,53.2,30.9,53.2z M30.9,3.5C17.6,3.5,6.8,14.4,6.8,27.6c0,13.3,10.8,24.1,24.101,24.1C44.2,51.7,55,40.9,55,27.6C54.9,14.4,44.1,3.5,30.9,3.5z M36.9,35.8c0,0.601-0.4,1-0.9,1h-1.3c-0.5,0-0.9-0.399-0.9-1V19.5c0-0.6,0.4-1,0.9-1H36c0.5,0,0.9,0.4,0.9,1V35.8z M27.8,35.8 c0,0.601-0.4,1-0.9,1h-1.3c-0.5,0-0.9-0.399-0.9-1V19.5c0-0.6,0.4-1,0.9-1H27c0.5,0,0.9,0.4,0.9,1L27.8,35.8L27.8,35.8z&#39;\n</code></pre>',
    )
    itemStyle: Optional[ItemStyle1] = Field(
        None,
        description='<p>Legend Item item style. If its children have values as <code class="codespan">&#39;inherit&#39;</code>, the values are inherited from corresponding series options.</p>\n',
    )
    lineStyle: Optional[LineStyle1] = Field(
        None,
        description='<p>Legend Item line style. If its children have values as <code class="codespan">&#39;inherit&#39;</code>, the values are inherited from corresponding series options.</p>\n',
    )
    symbolRotate: Optional[Union[float, str]] = Field(
        'inherit',
        description='<p>Rotation of the symbol, which can be <code class="codespan">number | &#39;inherit&#39;</code>. If it&#39;s <code class="codespan">&#39;inherit&#39;</code>, <code class="codespan">symbolRotate</code> of the series will be used.</p>\n',
    )
    textStyle: Optional[Any] = Field(None, description='<p>Text style of legend.</p>\n')


class PageIcons(BaseModel):
    """
        <p>It works when <a href="#legend.type">legend.type</a> is <code class="codespan">&#39;scroll&#39;</code>.</p>
    <p>The icons of page buttons.</p>

    """

    horizontal: Optional[Any] = Field(
        None,
        description='<p>The icons of page buttons when <a href="#legend.orient">legend.orient</a> is <code class="codespan">&#39;horizontal&#39;</code>.</p>\n<p>It should be an array, <code class="codespan">[previous page button, next page button]</code>, <code class="codespan">[&#39;M0,0L12,-10L12,10z&#39;, &#39;M0,0L-12,-10L-12,10z&#39;]</code> by default.</p>\n<p>For the each item of the array,</p>\n<p>It can be set to an image with <code class="codespan">&#39;image://url&#39;</code> , in which URL is the link to an image, or <code class="codespan">dataURI</code> of an image.</p>\n<p>An image URL example:</p>\n<pre><code>&#39;image://http://example.website/a/b.png&#39;\n</code></pre><p>A <code class="codespan">dataURI</code> example:</p>\n<pre><code>&#39;image://data:image/gif;base64,R0lGODlhEAAQAMQAAORHHOVSKudfOulrSOp3WOyDZu6QdvCchPGolfO0o/XBs/fNwfjZ0frl3/zy7////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAkAABAALAAAAAAQABAAAAVVICSOZGlCQAosJ6mu7fiyZeKqNKToQGDsM8hBADgUXoGAiqhSvp5QAnQKGIgUhwFUYLCVDFCrKUE1lBavAViFIDlTImbKC5Gm2hB0SlBCBMQiB0UjIQA7&#39;\n</code></pre><p>Icons can be set to arbitrary vector path via <code class="codespan">&#39;path://&#39;</code> in ECharts. As compared with a raster image, vector paths prevent jagging and blurring when scaled, and have better control over changing colors. The size of the vector icon will be adapted automatically. Refer to <a href="http://www.w3.org/TR/SVG/paths.html#PathData" target="_blank">SVG PathData</a> for more information about the format of the path. You may export vector paths from tools like Adobe </p>\n<p>For example:</p>\n<pre><code>&#39;path://M30.9,53.2C16.8,53.2,5.3,41.7,5.3,27.6S16.8,2,30.9,2C45,2,56.4,13.5,56.4,27.6S45,53.2,30.9,53.2z M30.9,3.5C17.6,3.5,6.8,14.4,6.8,27.6c0,13.3,10.8,24.1,24.101,24.1C44.2,51.7,55,40.9,55,27.6C54.9,14.4,44.1,3.5,30.9,3.5z M36.9,35.8c0,0.601-0.4,1-0.9,1h-1.3c-0.5,0-0.9-0.399-0.9-1V19.5c0-0.6,0.4-1,0.9-1H36c0.5,0,0.9,0.4,0.9,1V35.8z M27.8,35.8 c0,0.601-0.4,1-0.9,1h-1.3c-0.5,0-0.9-0.399-0.9-1V19.5c0-0.6,0.4-1,0.9-1H27c0.5,0,0.9,0.4,0.9,1L27.8,35.8L27.8,35.8z&#39;\n</code></pre><p>See <a href="http://localhost/echarts-website/examples/en/editor.html?c=pie-legend&amp;edit=1&amp;reset=1" target="_blank">vertically scrollable legend</a> or <a href="http://localhost/echarts-website/examples/en/editor.html?c=radar2&amp;edit=1&amp;reset=1" target="_blank">horizontally scrollable legend</a>.</p>\n',
    )
    vertical: Optional[Any] = Field(
        None,
        description='<p>The icons of page buttons when <a href="#legend.orient">legend.orient</a> is <code class="codespan">&#39;vertical&#39;</code>.</p>\n<p>It should be an array, <code class="codespan">[previous page button, next page button]</code>, <code class="codespan">[&#39;M0,0L20,0L10,-20z&#39;, &#39;M0,0L20,0L10,20z&#39;]</code> by default.</p>\n<p>For the each item of the array,</p>\n<p>It can be set to an image with <code class="codespan">&#39;image://url&#39;</code> , in which URL is the link to an image, or <code class="codespan">dataURI</code> of an image.</p>\n<p>An image URL example:</p>\n<pre><code>&#39;image://http://example.website/a/b.png&#39;\n</code></pre><p>A <code class="codespan">dataURI</code> example:</p>\n<pre><code>&#39;image://data:image/gif;base64,R0lGODlhEAAQAMQAAORHHOVSKudfOulrSOp3WOyDZu6QdvCchPGolfO0o/XBs/fNwfjZ0frl3/zy7////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAkAABAALAAAAAAQABAAAAVVICSOZGlCQAosJ6mu7fiyZeKqNKToQGDsM8hBADgUXoGAiqhSvp5QAnQKGIgUhwFUYLCVDFCrKUE1lBavAViFIDlTImbKC5Gm2hB0SlBCBMQiB0UjIQA7&#39;\n</code></pre><p>Icons can be set to arbitrary vector path via <code class="codespan">&#39;path://&#39;</code> in ECharts. As compared with a raster image, vector paths prevent jagging and blurring when scaled, and have better control over changing colors. The size of the vector icon will be adapted automatically. Refer to <a href="http://www.w3.org/TR/SVG/paths.html#PathData" target="_blank">SVG PathData</a> for more information about the format of the path. You may export vector paths from tools like Adobe </p>\n<p>For example:</p>\n<pre><code>&#39;path://M30.9,53.2C16.8,53.2,5.3,41.7,5.3,27.6S16.8,2,30.9,2C45,2,56.4,13.5,56.4,27.6S45,53.2,30.9,53.2z M30.9,3.5C17.6,3.5,6.8,14.4,6.8,27.6c0,13.3,10.8,24.1,24.101,24.1C44.2,51.7,55,40.9,55,27.6C54.9,14.4,44.1,3.5,30.9,3.5z M36.9,35.8c0,0.601-0.4,1-0.9,1h-1.3c-0.5,0-0.9-0.399-0.9-1V19.5c0-0.6,0.4-1,0.9-1H36c0.5,0,0.9,0.4,0.9,1V35.8z M27.8,35.8 c0,0.601-0.4,1-0.9,1h-1.3c-0.5,0-0.9-0.399-0.9-1V19.5c0-0.6,0.4-1,0.9-1H27c0.5,0,0.9,0.4,0.9,1L27.8,35.8L27.8,35.8z&#39;\n</code></pre><p>See <a href="http://localhost/echarts-website/examples/en/editor.html?c=pie-legend&amp;edit=1&amp;reset=1" target="_blank">vertically scrollable legend</a> or <a href="http://localhost/echarts-website/examples/en/editor.html?c=radar2&amp;edit=1&amp;reset=1" target="_blank">horizontally scrollable legend</a>.</p>\n',
    )


class PageTextStyle(BaseModel):
    """
        <p>It works when <a href="#legend.type">legend.type</a> is <code class="codespan">&#39;scroll&#39;</code>.</p>
    <p>The text style of page info.</p>

    """

    color: Optional[Any] = Field('#333', description='\n\n<p> text color.</p>\n')
    fontStyle: Optional[str] = Field(
        'normal',
        description='\n\n<p> font style.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;italic&#39;</code></li>\n<li><code class="codespan">&#39;oblique&#39;</code></li>\n</ul>\n',
    )
    fontWeight: Optional[Union[str, float]] = Field(
        'normal',
        description='\n\n<p> font thick weight.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;bold&#39;</code></li>\n<li><code class="codespan">&#39;bolder&#39;</code></li>\n<li><code class="codespan">&#39;lighter&#39;</code></li>\n<li>100 | 200 | 300 | 400...</li>\n</ul>\n',
    )
    fontFamily: Optional[str] = Field(
        'sans-serif',
        description='\n\n<p> font family.</p>\n<p>Can also be &#39;serif&#39; , &#39;monospace&#39;, ...</p>\n',
    )
    fontSize: Optional[float] = Field(12, description='\n\n<p> font size.</p>\n')
    lineHeight: Optional[float] = Field(
        None,
        description='\n\n<p>Line height of the text fragment.</p>\n<p>If <code class="codespan">lineHeight</code> is not set in <code class="codespan">rich</code>, <code class="codespan">lineHeight</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    lineHeight: 56,\n    rich: {\n        a: {\n            // `lineHeight` is not set, then it will be 56\n        }\n    }\n}\n</code></pre>\n',
    )
    width: Optional[float] = Field(
        None, description='\n\n<p>Width of text block.</p>\n'
    )
    height: Optional[float] = Field(
        None, description='\n\n<p>Height of text block.</p>\n'
    )
    textBorderColor: Optional[Any] = Field(
        None, description='\n\n<p>Stroke color of the text.</p>\n'
    )
    textBorderWidth: Optional[float] = Field(
        None, description='\n\n<p>Stroke line width of the text.</p>\n'
    )
    textBorderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>Stroke line type of the text.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">textBorderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\ntextBorderType: [5, 10],\n\ntextBorderDashOffset: 5\n}\n</code></pre>\n',
    )
    textBorderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">textBorderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    textShadowColor: Optional[Any] = Field(
        'transparent', description='\n\n<p>Shadow color of the text itself.</p>\n'
    )
    textShadowBlur: Optional[float] = Field(
        0, description='\n\n<p>Shadow blue of the text itself.</p>\n'
    )
    textShadowOffsetX: Optional[float] = Field(
        0, description='\n\n<p>Shadow X offset of the text itself.</p>\n'
    )
    textShadowOffsetY: Optional[float] = Field(
        0, description='\n\n<p>Shadow Y offset of the text itself.</p>\n'
    )
    overflow: Optional[str] = Field(
        'none',
        description='\n\n<p>Determine how to display the text when it&#39;s overflow. Available when <code class="codespan">width</code> is set.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the text and trailing with <code class="codespan">ellipsis</code>.</li>\n<li><code class="codespan">&#39;break&#39;</code> Break by word</li>\n<li><code class="codespan">&#39;breakAll&#39;</code> Break by character.</li>\n</ul>\n',
    )
    ellipsis: Optional[str] = Field(
        '...',
        description='<p>Ellipsis to be displayed when <code class="codespan">overflow</code> is set to <code class="codespan">truncate</code>.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the overflow lines.</li>\n</ul>\n',
    )


class _StyleName3(BaseModel):
    color: Optional[Any] = Field(
        '#fff',
        description='\n\n<p> text color.</p>\n<p>If set as <code class="codespan">&#39;inherit&#39;</code>, the color will assigned as visual color, such as series color.</p>\n',
    )
    fontStyle: Optional[str] = Field(
        'normal',
        description='\n\n<p> font style.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;italic&#39;</code></li>\n<li><code class="codespan">&#39;oblique&#39;</code></li>\n</ul>\n',
    )
    fontWeight: Optional[Union[str, float]] = Field(
        'normal',
        description='\n\n<p> font thick weight.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;bold&#39;</code></li>\n<li><code class="codespan">&#39;bolder&#39;</code></li>\n<li><code class="codespan">&#39;lighter&#39;</code></li>\n<li>100 | 200 | 300 | 400...</li>\n</ul>\n',
    )
    fontFamily: Optional[str] = Field(
        'sans-serif',
        description='\n\n<p> font family.</p>\n<p>Can also be &#39;serif&#39; , &#39;monospace&#39;, ...</p>\n',
    )
    fontSize: Optional[float] = Field(12, description='\n\n<p> font size.</p>\n')
    align: Optional[str] = Field(
        None,
        description='\n\n<p>Horizontal alignment of text, automatic by default.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;left&#39;</code></li>\n<li><code class="codespan">&#39;center&#39;</code></li>\n<li><code class="codespan">&#39;right&#39;</code></li>\n</ul>\n<p>If <code class="codespan">align</code> is not set in <code class="codespan">rich</code>, <code class="codespan">align</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    align: right,\n    rich: {\n        a: {\n            // `align` is not set, then it will be right\n        }\n    }\n}\n</code></pre>\n',
    )
    verticalAlign: Optional[str] = Field(
        None,
        description='\n\n<p>Vertical alignment of text, automatic by default.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;top&#39;</code></li>\n<li><code class="codespan">&#39;middle&#39;</code></li>\n<li><code class="codespan">&#39;bottom&#39;</code></li>\n</ul>\n<p>If <code class="codespan">verticalAlign</code> is not set in <code class="codespan">rich</code>, <code class="codespan">verticalAlign</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    verticalAlign: bottom,\n    rich: {\n        a: {\n            // `verticalAlign` is not set, then it will be bottom\n        }\n    }\n}\n</code></pre>\n',
    )
    lineHeight: Optional[float] = Field(
        None,
        description='\n\n<p>Line height of the text fragment.</p>\n<p>If <code class="codespan">lineHeight</code> is not set in <code class="codespan">rich</code>, <code class="codespan">lineHeight</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    lineHeight: 56,\n    rich: {\n        a: {\n            // `lineHeight` is not set, then it will be 56\n        }\n    }\n}\n</code></pre>\n',
    )
    backgroundColor: Optional[Union[str, Any]] = Field(
        'transparent',
        description='\n\n<p>Background color of the text fragment.</p>\n<p>Can be color string, like <code class="codespan">&#39;#123234&#39;</code>, <code class="codespan">&#39;red&#39;</code>, <code class="codespan">&#39;rgba(0,23,11,0.3)&#39;</code>.</p>\n<p>Or image can be used, for example:</p>\n<pre><code class="lang-ts">backgroundColor: {\n    image: &#39;xxx/xxx.png&#39;\n    // It can be URL of a image,\n    // or dataURI,\n    // or HTMLImageElement,\n    // or HTMLCanvasElement.\n}\n</code></pre>\n<p><code class="codespan">width</code> or <code class="codespan">height</code> can be specified when using background image, or\nauto adapted by default.</p>\n<p>If set as <code class="codespan">&#39;inherit&#39;</code>, the color will assigned as visual color, such as series color.</p>\n',
    )
    borderColor: Optional[Any] = Field(
        None,
        description='\n\n<p>Border color of the text fragment.</p>\n<p>If set as <code class="codespan">&#39;inherit&#39;</code>, the color will assigned as visual color, such as series color.</p>\n',
    )
    borderWidth: Optional[float] = Field(
        0, description='\n\n<p>Border width of the text fragment.</p>\n'
    )
    borderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>the text fragment border type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">borderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\nborderType: [5, 10],\n\nborderDashOffset: 5\n}\n</code></pre>\n',
    )
    borderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">borderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    borderRadius: Optional[float] = Field(
        0, description='\n\n<p>Border radius of the text fragment.</p>\n'
    )
    padding: Optional[Union[float, Any]] = Field(
        0,
        description='\n\n<p>Padding of the text fragment, for example:</p>\n<ul>\n<li><code class="codespan">padding: [3, 4, 5, 6]</code>: represents padding of <code class="codespan">[top, right, bottom, left]</code>.</li>\n<li><code class="codespan">padding: 4</code>: represents <code class="codespan">padding: [4, 4, 4, 4]</code>.</li>\n<li><code class="codespan">padding: [3, 4]</code>: represents <code class="codespan">padding: [3, 4, 3, 4]</code>.</li>\n</ul>\n<p>Notice, <code class="codespan">width</code> and <code class="codespan">height</code> specifies the width and height of the content, without <code class="codespan">padding</code>.</p>\n',
    )
    shadowColor: Optional[Any] = Field(
        'transparent', description='\n\n<p>Shadow color of the text block.</p>\n'
    )
    shadowBlur: Optional[float] = Field(
        0, description='\n\n<p>Show blur of the text block.</p>\n'
    )
    shadowOffsetX: Optional[float] = Field(
        0, description='\n\n<p>Shadow X offset of the text block.</p>\n'
    )
    shadowOffsetY: Optional[float] = Field(
        0, description='\n\n<p>Shadow Y offset of the text block.</p>\n'
    )
    width: Optional[Union[float, str]] = Field(
        None,
        description='<p>Width of the text block. It is the width of the text by default. In most cases, there is no need to specify it. You may want to use it in some cases like make simple table or using background image (see <code class="codespan">backgroundColor</code>).</p>\n<p>Notice, <code class="codespan">width</code> and <code class="codespan">height</code> specifies the width and height of the content, without <code class="codespan">padding</code>.</p>\n<p><code class="codespan">width</code> can also be percent string, like <code class="codespan">&#39;100%&#39;</code>, which represents the percent of <code class="codespan">contentWidth</code> (that is, the width without <code class="codespan">padding</code>) of its container box. It is based on <code class="codespan">contentWidth</code> because that each text fragment is layout based on the <code class="codespan">content box</code>, where it makes no sense that calculating width based on <code class="codespan">outerWith</code> in prectice.</p>\n<p>Notice, <code class="codespan">width</code> and <code class="codespan">height</code> only work when <code class="codespan">rich</code> specified.</p>\n',
    )
    height: Optional[Union[float, str]] = Field(
        None,
        description='<p>Height of the text block. It is the width of the text by default. You may want to use it in some cases like using background image (see <code class="codespan">backgroundColor</code>).</p>\n<p>Notice, <code class="codespan">width</code> and <code class="codespan">height</code> specifies the width and height of the content, without <code class="codespan">padding</code>.</p>\n<p>Notice, <code class="codespan">width</code> and <code class="codespan">height</code> only work when <code class="codespan">rich</code> specified.</p>\n',
    )
    textBorderColor: Optional[Any] = Field(
        None,
        description='\n\n<p>Stroke color of the text.</p>\n<p>If set as <code class="codespan">&#39;inherit&#39;</code>, the color will assigned as visual color, such as series color.</p>\n',
    )
    textBorderWidth: Optional[float] = Field(
        None, description='\n\n<p>Stroke line width of the text.</p>\n'
    )
    textBorderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>Stroke line type of the text.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">textBorderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\ntextBorderType: [5, 10],\n\ntextBorderDashOffset: 5\n}\n</code></pre>\n',
    )
    textBorderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">textBorderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    textShadowColor: Optional[Any] = Field(
        'transparent', description='\n\n<p>Shadow color of the text itself.</p>\n'
    )
    textShadowBlur: Optional[float] = Field(
        0, description='\n\n<p>Shadow blue of the text itself.</p>\n'
    )
    textShadowOffsetX: Optional[float] = Field(
        0, description='\n\n<p>Shadow X offset of the text itself.</p>\n'
    )
    textShadowOffsetY: Optional[float] = Field(
        0, description='\n\n<p>Shadow Y offset of the text itself.</p>\n'
    )


class Rich3(BaseModel):
    """
        <p>&quot;Rich text styles&quot; can be defined in this <code class="codespan">rich</code> property. For example:</p>
    <pre><code class="lang-ts">label: {
        // Styles defined in &#39;rich&#39; can be applied to some fragments
        // of text by adding some markers to those fragment, like
        // `{styleName|text content text content}`.
        // `&#39;\n&#39;` is the newline character.
        formatter: [
            &#39;{a|Style &quot;a&quot; is applied to this snippet}&#39;
            &#39;{b|Style &quot;b&quot; is applied to this snippet}This snippet use default style{x|use style &quot;x&quot;}&#39;
        ].join(&#39;\n&#39;),

        rich: {
            a: {
                color: &#39;red&#39;,
                lineHeight: 10
            },
            b: {
                backgroundColor: {
                    image: &#39;xxx/xxx.jpg&#39;
                },
                height: 40
            },
            x: {
                fontSize: 18,
                fontFamily: &#39;Microsoft YaHei&#39;,
                borderColor: &#39;#449933&#39;,
                borderRadius: 4
            },
            ...
        }
    }
    </code></pre>
    <p>For more details, see <a href="tutorial.html#Rich%20Text" target="_blank">Rich Text</a> please.</p>

    """

    _style_name_: Optional[_StyleName3] = Field(
        None, alias='<style_name>', description=''
    )


class SelectorLabel(BaseModel):
    """
        <blockquote>
    <p>Since <code class="codespan">v4.4.0</code></p>
    </blockquote>

    """

    show: Optional[bool] = Field(
        True, description='\n\n<p>Whether to show label.</p>\n'
    )
    distance: Optional[float] = Field(
        5, description='\n\n<p>Distance to the host graphic element.</p>\n'
    )
    rotate: Optional[float] = Field(
        None,
        description='\n\n<p>Rotate label, from -90 degree to 90, positive value represents rotate anti-clockwise.</p>\n<p>See: <a href="http://localhost/echarts-website/examples/en/editor.html?c=bar-label-rotation" target="_blank">label rotation</a>.</p>\n',
    )
    offset: Optional[Any] = Field(
        None,
        description='\n\n<p>Whether to move text slightly. For example: <code class="codespan">[30, 40]</code> means move <code class="codespan">30</code> horizontally and move <code class="codespan">40</code> vertically.</p>\n',
    )
    color: Optional[Any] = Field(
        '#fff',
        description='\n\n<p> text color.</p>\n<p>If set as <code class="codespan">&#39;inherit&#39;</code>, the color will assigned as visual color, such as series color.</p>\n',
    )
    fontStyle: Optional[str] = Field(
        'normal',
        description='\n\n<p> font style.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;italic&#39;</code></li>\n<li><code class="codespan">&#39;oblique&#39;</code></li>\n</ul>\n',
    )
    fontWeight: Optional[Union[str, float]] = Field(
        'normal',
        description='\n\n<p> font thick weight.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;bold&#39;</code></li>\n<li><code class="codespan">&#39;bolder&#39;</code></li>\n<li><code class="codespan">&#39;lighter&#39;</code></li>\n<li>100 | 200 | 300 | 400...</li>\n</ul>\n',
    )
    fontFamily: Optional[str] = Field(
        'sans-serif',
        description='\n\n<p> font family.</p>\n<p>Can also be &#39;serif&#39; , &#39;monospace&#39;, ...</p>\n',
    )
    fontSize: Optional[float] = Field(12, description='\n\n<p> font size.</p>\n')
    align: Optional[str] = Field(
        None,
        description='\n\n<p>Horizontal alignment of text, automatic by default.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;left&#39;</code></li>\n<li><code class="codespan">&#39;center&#39;</code></li>\n<li><code class="codespan">&#39;right&#39;</code></li>\n</ul>\n<p>If <code class="codespan">align</code> is not set in <code class="codespan">rich</code>, <code class="codespan">align</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    align: right,\n    rich: {\n        a: {\n            // `align` is not set, then it will be right\n        }\n    }\n}\n</code></pre>\n',
    )
    verticalAlign: Optional[str] = Field(
        None,
        description='\n\n<p>Vertical alignment of text, automatic by default.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;top&#39;</code></li>\n<li><code class="codespan">&#39;middle&#39;</code></li>\n<li><code class="codespan">&#39;bottom&#39;</code></li>\n</ul>\n<p>If <code class="codespan">verticalAlign</code> is not set in <code class="codespan">rich</code>, <code class="codespan">verticalAlign</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    verticalAlign: bottom,\n    rich: {\n        a: {\n            // `verticalAlign` is not set, then it will be bottom\n        }\n    }\n}\n</code></pre>\n',
    )
    lineHeight: Optional[float] = Field(
        None,
        description='\n\n<p>Line height of the text fragment.</p>\n<p>If <code class="codespan">lineHeight</code> is not set in <code class="codespan">rich</code>, <code class="codespan">lineHeight</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    lineHeight: 56,\n    rich: {\n        a: {\n            // `lineHeight` is not set, then it will be 56\n        }\n    }\n}\n</code></pre>\n',
    )
    backgroundColor: Optional[Union[str, Any]] = Field(
        'transparent',
        description='\n\n<p>Background color of the text fragment.</p>\n<p>Can be color string, like <code class="codespan">&#39;#123234&#39;</code>, <code class="codespan">&#39;red&#39;</code>, <code class="codespan">&#39;rgba(0,23,11,0.3)&#39;</code>.</p>\n<p>Or image can be used, for example:</p>\n<pre><code class="lang-ts">backgroundColor: {\n    image: &#39;xxx/xxx.png&#39;\n    // It can be URL of a image,\n    // or dataURI,\n    // or HTMLImageElement,\n    // or HTMLCanvasElement.\n}\n</code></pre>\n<p><code class="codespan">width</code> or <code class="codespan">height</code> can be specified when using background image, or\nauto adapted by default.</p>\n<p>If set as <code class="codespan">&#39;inherit&#39;</code>, the color will assigned as visual color, such as series color.</p>\n',
    )
    borderColor: Optional[Any] = Field(
        None,
        description='\n\n<p>Border color of the text fragment.</p>\n<p>If set as <code class="codespan">&#39;inherit&#39;</code>, the color will assigned as visual color, such as series color.</p>\n',
    )
    borderWidth: Optional[float] = Field(
        0, description='\n\n<p>Border width of the text fragment.</p>\n'
    )
    borderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>the text fragment border type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">borderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\nborderType: [5, 10],\n\nborderDashOffset: 5\n}\n</code></pre>\n',
    )
    borderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">borderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    borderRadius: Optional[float] = Field(
        0, description='\n\n<p>Border radius of the text fragment.</p>\n'
    )
    padding: Optional[Union[float, Any]] = Field(
        0,
        description='\n\n<p>Padding of the text fragment, for example:</p>\n<ul>\n<li><code class="codespan">padding: [3, 4, 5, 6]</code>: represents padding of <code class="codespan">[top, right, bottom, left]</code>.</li>\n<li><code class="codespan">padding: 4</code>: represents <code class="codespan">padding: [4, 4, 4, 4]</code>.</li>\n<li><code class="codespan">padding: [3, 4]</code>: represents <code class="codespan">padding: [3, 4, 3, 4]</code>.</li>\n</ul>\n<p>Notice, <code class="codespan">width</code> and <code class="codespan">height</code> specifies the width and height of the content, without <code class="codespan">padding</code>.</p>\n',
    )
    shadowColor: Optional[Any] = Field(
        'transparent', description='\n\n<p>Shadow color of the text block.</p>\n'
    )
    shadowBlur: Optional[float] = Field(
        0, description='\n\n<p>Show blur of the text block.</p>\n'
    )
    shadowOffsetX: Optional[float] = Field(
        0, description='\n\n<p>Shadow X offset of the text block.</p>\n'
    )
    shadowOffsetY: Optional[float] = Field(
        0, description='\n\n<p>Shadow Y offset of the text block.</p>\n'
    )
    width: Optional[float] = Field(
        None, description='\n\n<p>Width of text block.</p>\n'
    )
    height: Optional[float] = Field(
        None, description='\n\n<p>Height of text block.</p>\n'
    )
    textBorderColor: Optional[Any] = Field(
        None,
        description='\n\n<p>Stroke color of the text.</p>\n<p>If set as <code class="codespan">&#39;inherit&#39;</code>, the color will assigned as visual color, such as series color.</p>\n',
    )
    textBorderWidth: Optional[float] = Field(
        None, description='\n\n<p>Stroke line width of the text.</p>\n'
    )
    textBorderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>Stroke line type of the text.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">textBorderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\ntextBorderType: [5, 10],\n\ntextBorderDashOffset: 5\n}\n</code></pre>\n',
    )
    textBorderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">textBorderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    textShadowColor: Optional[Any] = Field(
        'transparent', description='\n\n<p>Shadow color of the text itself.</p>\n'
    )
    textShadowBlur: Optional[float] = Field(
        0, description='\n\n<p>Shadow blue of the text itself.</p>\n'
    )
    textShadowOffsetX: Optional[float] = Field(
        0, description='\n\n<p>Shadow X offset of the text itself.</p>\n'
    )
    textShadowOffsetY: Optional[float] = Field(
        0, description='\n\n<p>Shadow Y offset of the text itself.</p>\n'
    )
    overflow: Optional[str] = Field(
        'none',
        description='\n\n<p>Determine how to display the text when it&#39;s overflow. Available when <code class="codespan">width</code> is set.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the text and trailing with <code class="codespan">ellipsis</code>.</li>\n<li><code class="codespan">&#39;break&#39;</code> Break by word</li>\n<li><code class="codespan">&#39;breakAll&#39;</code> Break by character.</li>\n</ul>\n',
    )
    ellipsis: Optional[str] = Field(
        '...',
        description='<p>Ellipsis to be displayed when <code class="codespan">overflow</code> is set to <code class="codespan">truncate</code>.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the overflow lines.</li>\n</ul>\n',
    )
    rich: Optional[Rich3] = Field(
        None,
        description='<p>&quot;Rich text styles&quot; can be defined in this <code class="codespan">rich</code> property. For example:</p>\n<pre><code class="lang-ts">label: {\n    // Styles defined in &#39;rich&#39; can be applied to some fragments\n    // of text by adding some markers to those fragment, like\n    // `{styleName|text content text content}`.\n    // `&#39;\\n&#39;` is the newline character.\n    formatter: [\n        &#39;{a|Style &quot;a&quot; is applied to this snippet}&#39;\n        &#39;{b|Style &quot;b&quot; is applied to this snippet}This snippet use default style{x|use style &quot;x&quot;}&#39;\n    ].join(&#39;\\n&#39;),\n\n    rich: {\n        a: {\n            color: &#39;red&#39;,\n            lineHeight: 10\n        },\n        b: {\n            backgroundColor: {\n                image: &#39;xxx/xxx.jpg&#39;\n            },\n            height: 40\n        },\n        x: {\n            fontSize: 18,\n            fontFamily: &#39;Microsoft YaHei&#39;,\n            borderColor: &#39;#449933&#39;,\n            borderRadius: 4\n        },\n        ...\n    }\n}\n</code></pre>\n<p>For more details, see <a href="tutorial.html#Rich%20Text" target="_blank">Rich Text</a> please.</p>\n',
    )


class Emphasis(BaseModel):
    selectorLabel: Optional[SelectorLabel] = Field(
        None,
        description='<blockquote>\n<p>Since <code class="codespan">v4.4.0</code></p>\n</blockquote>\n',
    )


class _StyleName4(_StyleName3):
    pass


class Rich4(BaseModel):
    """
        <p>&quot;Rich text styles&quot; can be defined in this <code class="codespan">rich</code> property. For example:</p>
    <pre><code class="lang-ts">label: {
        // Styles defined in &#39;rich&#39; can be applied to some fragments
        // of text by adding some markers to those fragment, like
        // `{styleName|text content text content}`.
        // `&#39;\n&#39;` is the newline character.
        formatter: [
            &#39;{a|Style &quot;a&quot; is applied to this snippet}&#39;
            &#39;{b|Style &quot;b&quot; is applied to this snippet}This snippet use default style{x|use style &quot;x&quot;}&#39;
        ].join(&#39;\n&#39;),

        rich: {
            a: {
                color: &#39;red&#39;,
                lineHeight: 10
            },
            b: {
                backgroundColor: {
                    image: &#39;xxx/xxx.jpg&#39;
                },
                height: 40
            },
            x: {
                fontSize: 18,
                fontFamily: &#39;Microsoft YaHei&#39;,
                borderColor: &#39;#449933&#39;,
                borderRadius: 4
            },
            ...
        }
    }
    </code></pre>
    <p>For more details, see <a href="tutorial.html#Rich%20Text" target="_blank">Rich Text</a> please.</p>

    """

    _style_name_: Optional[_StyleName4] = Field(
        None, alias='<style_name>', description=''
    )


class SelectorLabel1(BaseModel):
    """
        <blockquote>
    <p>Since <code class="codespan">v4.4.0</code></p>
    </blockquote>
    <p>The text label style of the selector button, which is displayed by default.</p>

    """

    show: Optional[bool] = Field(
        True, description='\n\n<p>Whether to show label.</p>\n'
    )
    distance: Optional[float] = Field(
        5, description='\n\n<p>Distance to the host graphic element.</p>\n'
    )
    rotate: Optional[float] = Field(
        None,
        description='\n\n<p>Rotate label, from -90 degree to 90, positive value represents rotate anti-clockwise.</p>\n<p>See: <a href="http://localhost/echarts-website/examples/en/editor.html?c=bar-label-rotation" target="_blank">label rotation</a>.</p>\n',
    )
    offset: Optional[Any] = Field(
        None,
        description='\n\n<p>Whether to move text slightly. For example: <code class="codespan">[30, 40]</code> means move <code class="codespan">30</code> horizontally and move <code class="codespan">40</code> vertically.</p>\n',
    )
    color: Optional[Any] = Field(
        '#fff',
        description='\n\n<p> text color.</p>\n<p>If set as <code class="codespan">&#39;inherit&#39;</code>, the color will assigned as visual color, such as series color.</p>\n',
    )
    fontStyle: Optional[str] = Field(
        'normal',
        description='\n\n<p> font style.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;italic&#39;</code></li>\n<li><code class="codespan">&#39;oblique&#39;</code></li>\n</ul>\n',
    )
    fontWeight: Optional[Union[str, float]] = Field(
        'normal',
        description='\n\n<p> font thick weight.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;bold&#39;</code></li>\n<li><code class="codespan">&#39;bolder&#39;</code></li>\n<li><code class="codespan">&#39;lighter&#39;</code></li>\n<li>100 | 200 | 300 | 400...</li>\n</ul>\n',
    )
    fontFamily: Optional[str] = Field(
        'sans-serif',
        description='\n\n<p> font family.</p>\n<p>Can also be &#39;serif&#39; , &#39;monospace&#39;, ...</p>\n',
    )
    fontSize: Optional[float] = Field(12, description='\n\n<p> font size.</p>\n')
    align: Optional[str] = Field(
        None,
        description='\n\n<p>Horizontal alignment of text, automatic by default.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;left&#39;</code></li>\n<li><code class="codespan">&#39;center&#39;</code></li>\n<li><code class="codespan">&#39;right&#39;</code></li>\n</ul>\n<p>If <code class="codespan">align</code> is not set in <code class="codespan">rich</code>, <code class="codespan">align</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    align: right,\n    rich: {\n        a: {\n            // `align` is not set, then it will be right\n        }\n    }\n}\n</code></pre>\n',
    )
    verticalAlign: Optional[str] = Field(
        None,
        description='\n\n<p>Vertical alignment of text, automatic by default.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;top&#39;</code></li>\n<li><code class="codespan">&#39;middle&#39;</code></li>\n<li><code class="codespan">&#39;bottom&#39;</code></li>\n</ul>\n<p>If <code class="codespan">verticalAlign</code> is not set in <code class="codespan">rich</code>, <code class="codespan">verticalAlign</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    verticalAlign: bottom,\n    rich: {\n        a: {\n            // `verticalAlign` is not set, then it will be bottom\n        }\n    }\n}\n</code></pre>\n',
    )
    lineHeight: Optional[float] = Field(
        None,
        description='\n\n<p>Line height of the text fragment.</p>\n<p>If <code class="codespan">lineHeight</code> is not set in <code class="codespan">rich</code>, <code class="codespan">lineHeight</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    lineHeight: 56,\n    rich: {\n        a: {\n            // `lineHeight` is not set, then it will be 56\n        }\n    }\n}\n</code></pre>\n',
    )
    backgroundColor: Optional[Union[str, Any]] = Field(
        'transparent',
        description='\n\n<p>Background color of the text fragment.</p>\n<p>Can be color string, like <code class="codespan">&#39;#123234&#39;</code>, <code class="codespan">&#39;red&#39;</code>, <code class="codespan">&#39;rgba(0,23,11,0.3)&#39;</code>.</p>\n<p>Or image can be used, for example:</p>\n<pre><code class="lang-ts">backgroundColor: {\n    image: &#39;xxx/xxx.png&#39;\n    // It can be URL of a image,\n    // or dataURI,\n    // or HTMLImageElement,\n    // or HTMLCanvasElement.\n}\n</code></pre>\n<p><code class="codespan">width</code> or <code class="codespan">height</code> can be specified when using background image, or\nauto adapted by default.</p>\n<p>If set as <code class="codespan">&#39;inherit&#39;</code>, the color will assigned as visual color, such as series color.</p>\n',
    )
    borderColor: Optional[Any] = Field(
        None,
        description='\n\n<p>Border color of the text fragment.</p>\n<p>If set as <code class="codespan">&#39;inherit&#39;</code>, the color will assigned as visual color, such as series color.</p>\n',
    )
    borderWidth: Optional[float] = Field(
        0, description='\n\n<p>Border width of the text fragment.</p>\n'
    )
    borderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>the text fragment border type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">borderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\nborderType: [5, 10],\n\nborderDashOffset: 5\n}\n</code></pre>\n',
    )
    borderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">borderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    borderRadius: Optional[float] = Field(
        0, description='\n\n<p>Border radius of the text fragment.</p>\n'
    )
    padding: Optional[Union[float, Any]] = Field(
        0,
        description='\n\n<p>Padding of the text fragment, for example:</p>\n<ul>\n<li><code class="codespan">padding: [3, 4, 5, 6]</code>: represents padding of <code class="codespan">[top, right, bottom, left]</code>.</li>\n<li><code class="codespan">padding: 4</code>: represents <code class="codespan">padding: [4, 4, 4, 4]</code>.</li>\n<li><code class="codespan">padding: [3, 4]</code>: represents <code class="codespan">padding: [3, 4, 3, 4]</code>.</li>\n</ul>\n<p>Notice, <code class="codespan">width</code> and <code class="codespan">height</code> specifies the width and height of the content, without <code class="codespan">padding</code>.</p>\n',
    )
    shadowColor: Optional[Any] = Field(
        'transparent', description='\n\n<p>Shadow color of the text block.</p>\n'
    )
    shadowBlur: Optional[float] = Field(
        0, description='\n\n<p>Show blur of the text block.</p>\n'
    )
    shadowOffsetX: Optional[float] = Field(
        0, description='\n\n<p>Shadow X offset of the text block.</p>\n'
    )
    shadowOffsetY: Optional[float] = Field(
        0, description='\n\n<p>Shadow Y offset of the text block.</p>\n'
    )
    width: Optional[float] = Field(
        None, description='\n\n<p>Width of text block.</p>\n'
    )
    height: Optional[float] = Field(
        None, description='\n\n<p>Height of text block.</p>\n'
    )
    textBorderColor: Optional[Any] = Field(
        None,
        description='\n\n<p>Stroke color of the text.</p>\n<p>If set as <code class="codespan">&#39;inherit&#39;</code>, the color will assigned as visual color, such as series color.</p>\n',
    )
    textBorderWidth: Optional[float] = Field(
        None, description='\n\n<p>Stroke line width of the text.</p>\n'
    )
    textBorderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>Stroke line type of the text.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">textBorderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\ntextBorderType: [5, 10],\n\ntextBorderDashOffset: 5\n}\n</code></pre>\n',
    )
    textBorderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">textBorderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    textShadowColor: Optional[Any] = Field(
        'transparent', description='\n\n<p>Shadow color of the text itself.</p>\n'
    )
    textShadowBlur: Optional[float] = Field(
        0, description='\n\n<p>Shadow blue of the text itself.</p>\n'
    )
    textShadowOffsetX: Optional[float] = Field(
        0, description='\n\n<p>Shadow X offset of the text itself.</p>\n'
    )
    textShadowOffsetY: Optional[float] = Field(
        0, description='\n\n<p>Shadow Y offset of the text itself.</p>\n'
    )
    overflow: Optional[str] = Field(
        'none',
        description='\n\n<p>Determine how to display the text when it&#39;s overflow. Available when <code class="codespan">width</code> is set.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the text and trailing with <code class="codespan">ellipsis</code>.</li>\n<li><code class="codespan">&#39;break&#39;</code> Break by word</li>\n<li><code class="codespan">&#39;breakAll&#39;</code> Break by character.</li>\n</ul>\n',
    )
    ellipsis: Optional[str] = Field(
        '...',
        description='<p>Ellipsis to be displayed when <code class="codespan">overflow</code> is set to <code class="codespan">truncate</code>.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the overflow lines.</li>\n</ul>\n',
    )
    rich: Optional[Rich4] = Field(
        None,
        description='<p>&quot;Rich text styles&quot; can be defined in this <code class="codespan">rich</code> property. For example:</p>\n<pre><code class="lang-ts">label: {\n    // Styles defined in &#39;rich&#39; can be applied to some fragments\n    // of text by adding some markers to those fragment, like\n    // `{styleName|text content text content}`.\n    // `&#39;\\n&#39;` is the newline character.\n    formatter: [\n        &#39;{a|Style &quot;a&quot; is applied to this snippet}&#39;\n        &#39;{b|Style &quot;b&quot; is applied to this snippet}This snippet use default style{x|use style &quot;x&quot;}&#39;\n    ].join(&#39;\\n&#39;),\n\n    rich: {\n        a: {\n            color: &#39;red&#39;,\n            lineHeight: 10\n        },\n        b: {\n            backgroundColor: {\n                image: &#39;xxx/xxx.jpg&#39;\n            },\n            height: 40\n        },\n        x: {\n            fontSize: 18,\n            fontFamily: &#39;Microsoft YaHei&#39;,\n            borderColor: &#39;#449933&#39;,\n            borderRadius: 4\n        },\n        ...\n    }\n}\n</code></pre>\n<p>For more details, see <a href="tutorial.html#Rich%20Text" target="_blank">Rich Text</a> please.</p>\n',
    )


class Legend(BaseModel):
    """
        <p>Legend component.</p>
    <p>Legend component shows symbol, color and name of different series. You can click legends to toggle displaying series in the chart.</p>
    <p>In ECharts 3, a single echarts instance may contain multiple legend components, which makes it easier for the layout of multiple legend components.</p>
    <p>If there have to be too many legend items, <a href="http://localhost/echarts-website/examples/en/editor.html?c=pie-legend&amp;edit=1&amp;reset=1" target="_blank">vertically scrollable legend</a> or <a href="http://localhost/echarts-website/examples/en/editor.html?c=radar2&amp;edit=1&amp;reset=1" target="_blank">horizontally scrollable legend</a> are options to paginate them. Check <a href="#legend.type">legend.type</a> please.</p>

    """

    type: Optional[str] = Field(
        None,
        description='\n\n<p>Type of legend. Optional values:</p>\n<ul>\n<li><code class="codespan">&#39;plain&#39;</code>: Simple legend. (default)</li>\n<li><code class="codespan">&#39;scroll&#39;</code>: Scrollable legend. It helps when too many legend items needed to be shown.</li>\n</ul>\n<p>See <a href="http://localhost/echarts-website/examples/en/editor.html?c=pie-legend&amp;edit=1&amp;reset=1" target="_blank">vertically scrollable legend</a> or <a href="http://localhost/echarts-website/examples/en/editor.html?c=radar2&amp;edit=1&amp;reset=1" target="_blank">horizontally scrollable legend</a>.</p>\n<p>When <code class="codespan">&#39;scroll&#39;</code> used, these options below can be used for detailed configuration:</p>\n<ul>\n<li><a href="#legend.scrollDataIndex">legend.scrollDataIndex</a></li>\n<li><a href="#legend.pageButtonItemGap">legend.pageButtonItemGap</a></li>\n<li><a href="#legend.pageButtonGap">legend.pageButtonGap</a></li>\n<li><a href="#legend.pageButtonPosition">legend.pageButtonPosition</a></li>\n<li><a href="#legend.pageFormatter">legend.pageFormatter</a></li>\n<li><a href="#legend.pageIcons">legend.pageIcons</a></li>\n<li><a href="#legend.pageIconColor">legend.pageIconColor</a></li>\n<li><a href="#legend.pageIconInactiveColor">legend.pageIconInactiveColor</a></li>\n<li><a href="#legend.pageIconSize">legend.pageIconSize</a></li>\n<li><a href="#legend.pageTextStyle">legend.pageTextStyle</a></li>\n<li><a href="#legend.animation">legend.animation</a></li>\n<li><a href="#legend.animationDurationUpdate">legend.animationDurationUpdate</a></li>\n</ul>\n',
    )
    id: Optional[str] = Field(
        None,
        description='<p>Component ID, not specified by default. If specified, it can be used to refer the component in option or API.</p>\n',
    )
    show: Optional[bool] = Field(True, description='\n\n\n\n\n\n\n\n')
    zlevel: Optional[float] = Field(
        0,
        description='<p><code class="codespan">zlevel</code> value of all graphical elements in .</p>\n<p><code class="codespan">zlevel</code> is used to make layers with Canvas. Graphical elements with different <code class="codespan">zlevel</code> values will be placed in different Canvases, which is a common optimization technique. We can put those frequently changed elements (like those with animations) to a separate <code class="codespan">zlevel</code>. Notice that too many Canvases will increase memory cost, and should be used carefully on mobile phones to avoid crash.</p>\n<p>Canvases with bigger <code class="codespan">zlevel</code> will be placed on Canvases with smaller <code class="codespan">zlevel</code>.</p>\n',
    )
    z: Optional[float] = Field(
        2,
        description='<p><code class="codespan">z</code> value of all graphical elements in , which controls order of drawing graphical components. Components with smaller <code class="codespan">z</code> values may be overwritten by those with larger <code class="codespan">z</code> values.</p>\n<p><code class="codespan">z</code> has a lower priority to <code class="codespan">zlevel</code>, and will not create new Canvas.</p>\n',
    )
    left: Optional[Union[str, float]] = Field(
        'auto',
        description='<p>Distance between legend component and the left side of the container.</p>\n<p><code class="codespan">left</code> value can be instant pixel value like <code class="codespan">20</code>; it can also be a percentage value relative to container width like <code class="codespan">&#39;20%&#39;</code>; and it can also be <code class="codespan">&#39;left&#39;</code>, <code class="codespan">&#39;center&#39;</code>, or <code class="codespan">&#39;right&#39;</code>.</p>\n<p>If the <code class="codespan">left</code> value is set to be <code class="codespan">&#39;left&#39;</code>, <code class="codespan">&#39;center&#39;</code>, or <code class="codespan">&#39;right&#39;</code>, then the component will be aligned automatically based on position.</p>\n',
    )
    top: Optional[Union[str, float]] = Field(
        'auto',
        description='<p>Distance between legend component and the top side of the container.</p>\n<p><code class="codespan">top</code> value can be instant pixel value like <code class="codespan">20</code>; it can also be a percentage value relative to container width like <code class="codespan">&#39;20%&#39;</code>; and it can also be <code class="codespan">&#39;top&#39;</code>, <code class="codespan">&#39;middle&#39;</code>, or <code class="codespan">&#39;bottom&#39;</code>.</p>\n<p>If the <code class="codespan">top</code> value is set to be <code class="codespan">&#39;top&#39;</code>, <code class="codespan">&#39;middle&#39;</code>, or <code class="codespan">&#39;bottom&#39;</code>, then the component will be aligned automatically based on position.</p>\n',
    )
    right: Optional[Union[str, float]] = Field(
        'auto',
        description='<p>Distance between legend component and the right side of the container.</p>\n<p><code class="codespan">right</code> value can be instant pixel value like <code class="codespan">20</code>; it can also be a percentage value relative to container width like <code class="codespan">&#39;20%&#39;</code>.</p>\n<p>Adaptive by default.</p>\n',
    )
    bottom: Optional[Union[str, float]] = Field(
        'auto',
        description='<p>Distance between legend component and the bottom side of the container.</p>\n<p><code class="codespan">bottom</code> value can be instant pixel value like <code class="codespan">20</code>; it can also be a percentage value relative to container width like <code class="codespan">&#39;20%&#39;</code>.</p>\n<p>Adaptive by default.</p>\n',
    )
    width: Optional[Union[str, float]] = Field(
        'auto', description='<p>Width of legend component. Adaptive by default.</p>\n'
    )
    height: Optional[Union[str, float]] = Field(
        'auto', description='<p>Height of legend component. Adaptive by default.</p>\n'
    )
    orient: Optional[str] = Field(
        'horizontal',
        description='\n\n<p>The layout orientation of legend.</p>\n<p>Options:</p>\n<ul>\n<li>&#39;horizontal&#39;</li>\n<li>&#39;vertical&#39;</li>\n</ul>\n',
    )
    align: Optional[str] = Field(
        'auto',
        description='\n\n<p>Legend marker and text aligning. By default, it automatically calculates from component location and orientation. When <a href="#legend.left">left</a> value of this component is &#39;right&#39;, and the vertical layout (<a href="#legend.orient">orient</a> is &#39;vertical&#39;), it would be aligned to &#39;right&#39;.</p>\n<p>Option:</p>\n<ul>\n<li>&#39;auto&#39;</li>\n<li>&#39;left&#39;</li>\n<li>&#39;right&#39;</li>\n</ul>\n',
    )
    padding: Optional[Union[float, Any]] = Field(
        5,
        description='\n\n\n\n\n\n<p>legend space around content. The unit is px. Default values for each position are 5. And they can be set to different values with left, right, top, and bottom.</p>\n<p>Examples:</p>\n<pre><code class="lang-ts">// Set padding to be 5\npadding: 5\n// Set the top and bottom paddings to be 5, and left and right paddings to be 10\npadding: [5, 10]\n// Set each of the four paddings seperately\npadding: [\n    5,  // up\n    10, // right\n    5,  // down\n    10, // left\n]\n</code></pre>\n',
    )
    itemGap: Optional[float] = Field(
        10,
        description='\n\n<p>The distance between each legend, horizontal distance in horizontal layout, and vertical distance in vertical layout.</p>\n',
    )
    itemWidth: Optional[float] = Field(
        25, description='\n\n<p>Image width of legend symbol.</p>\n'
    )
    itemHeight: Optional[float] = Field(
        14, description='\n\n<p>Image height of legend symbol.</p>\n'
    )
    itemStyle: Optional[ItemStyle] = Field(
        None,
        description='<p>Legend item style. If its children have values as <code class="codespan">&#39;inherit&#39;</code>, the values are inherited from corresponding series options.</p>\n',
    )
    lineStyle: Optional[LineStyle] = Field(
        None,
        description='<p>Legend line style. If its children have values as <code class="codespan">&#39;inherit&#39;</code>, the values are inherited from corresponding series options.</p>\n',
    )
    symbolRotate: Optional[Union[float, str]] = Field(
        'inherit',
        description='<p>Rotation of the symbol, which can be <code class="codespan">number | &#39;inherit&#39;</code>. If it&#39;s <code class="codespan">&#39;inherit&#39;</code>, <code class="codespan">symbolRotate</code> of the series will be used.</p>\n',
    )
    formatter: Optional[Union[str, Any]] = Field(
        None,
        description='<p>Formatter is used to format label of legend, which supports string template and callback function.</p>\n<p>Example:</p>\n<pre><code class="lang-ts">// using string template, the template variable is legend name {name}\nformatter: &#39;Legend {name}&#39;\n// using callback function\nformatter: function (name) {\n    return &#39;Legend &#39; + name;\n}\n</code></pre>\n',
    )
    selectedMode: Optional[Union[str, bool]] = Field(
        True,
        description='\n\n<p>Selected mode of legend, which controls whether series can be toggled displaying by clicking legends. It is enabled by default, and you may set it to be <code class="codespan">false</code> to disable it.</p>\n<p>Besides, it can be set to <code class="codespan">&#39;single&#39;</code> or <code class="codespan">&#39;multiple&#39;</code>, for single selection and multiple selection.</p>\n',
    )
    inactiveColor: Optional[Any] = Field(
        '#ccc', description='\n\n<p>Legend color when not selected.</p>\n'
    )
    inactiveBorderColor: Optional[Any] = Field(
        '#ccc', description='\n\n<p>Legend border color when not selected.</p>\n'
    )
    inactiveBorderWidth: Optional[Any] = Field(
        'auto',
        description='\n\n<p>Legend border width when not selected. If it is <code class="codespan">&#39;auto&#39;</code>, the border width is set to be 2 if there is border width in the series, 0 elsewise. If it is <code class="codespan">&#39;inherit&#39;</code>, it always takes the border width of the series.</p>\n',
    )
    selected: Optional[Any] = Field(
        None,
        description='<p>State table of selected legend.</p>\n<p>example:</p>\n<pre><code>selected: {\n    // selected&#39;series 1&#39;\n    &#39;series 1&#39;: true,\n    // unselected&#39;series 2&#39;\n    &#39;series 2&#39;: false\n}\n</code></pre>',
    )
    textStyle: Optional[TextStyle1] = Field(
        None, description='<p>Legend text style.</p>\n'
    )
    tooltip: Optional[Any] = Field(
        None,
        description='<p>Tooltip configuration for legend tooltip, which is similar to <a href="#tooltip">tooltip</a>.</p>\n',
    )
    icon: Optional[str] = Field(
        None,
        description='\n\n<p>Icon of the legend items.</p>\n<p>Icon types provided by ECharts includes</p>\n<p><code class="codespan">&#39;circle&#39;</code>, <code class="codespan">&#39;rect&#39;</code>, <code class="codespan">&#39;roundRect&#39;</code>, <code class="codespan">&#39;triangle&#39;</code>, <code class="codespan">&#39;diamond&#39;</code>, <code class="codespan">&#39;pin&#39;</code>, <code class="codespan">&#39;arrow&#39;</code>, <code class="codespan">&#39;none&#39;</code></p>\n<p>It can be set to an image with <code class="codespan">&#39;image://url&#39;</code> , in which URL is the link to an image, or <code class="codespan">dataURI</code> of an image.</p>\n<p>An image URL example:</p>\n<pre><code>&#39;image://http://example.website/a/b.png&#39;\n</code></pre><p>A <code class="codespan">dataURI</code> example:</p>\n<pre><code>&#39;image://data:image/gif;base64,R0lGODlhEAAQAMQAAORHHOVSKudfOulrSOp3WOyDZu6QdvCchPGolfO0o/XBs/fNwfjZ0frl3/zy7////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAkAABAALAAAAAAQABAAAAVVICSOZGlCQAosJ6mu7fiyZeKqNKToQGDsM8hBADgUXoGAiqhSvp5QAnQKGIgUhwFUYLCVDFCrKUE1lBavAViFIDlTImbKC5Gm2hB0SlBCBMQiB0UjIQA7&#39;\n</code></pre><p>Icons can be set to arbitrary vector path via <code class="codespan">&#39;path://&#39;</code> in ECharts. As compared with a raster image, vector paths prevent jagging and blurring when scaled, and have better control over changing colors. The size of the vector icon will be adapted automatically. Refer to <a href="http://www.w3.org/TR/SVG/paths.html#PathData" target="_blank">SVG PathData</a> for more information about the format of the path. You may export vector paths from tools like Adobe </p>\n<p>For example:</p>\n<pre><code>&#39;path://M30.9,53.2C16.8,53.2,5.3,41.7,5.3,27.6S16.8,2,30.9,2C45,2,56.4,13.5,56.4,27.6S45,53.2,30.9,53.2z M30.9,3.5C17.6,3.5,6.8,14.4,6.8,27.6c0,13.3,10.8,24.1,24.101,24.1C44.2,51.7,55,40.9,55,27.6C54.9,14.4,44.1,3.5,30.9,3.5z M36.9,35.8c0,0.601-0.4,1-0.9,1h-1.3c-0.5,0-0.9-0.399-0.9-1V19.5c0-0.6,0.4-1,0.9-1H36c0.5,0,0.9,0.4,0.9,1V35.8z M27.8,35.8 c0,0.601-0.4,1-0.9,1h-1.3c-0.5,0-0.9-0.399-0.9-1V19.5c0-0.6,0.4-1,0.9-1H27c0.5,0,0.9,0.4,0.9,1L27.8,35.8L27.8,35.8z&#39;\n</code></pre>',
    )
    data: Optional[List[Datum]] = Field(
        None,
        description='<p>Data array of legend. An array item is usually a <code class="codespan">name</code> representing string. (If it is a <a href="#series-pie">pie chart</a>, it could also be the <code class="codespan">name</code> of a single data in the pie chart) of a series. Legend component would automatically calculate the color and icon according to series. Special string <code class="codespan">&#39;&#39;</code> (null string) or <code class="codespan">&#39;\\n&#39;</code> (new line string) can be used for a new line.</p>\n<p>If <code class="codespan">data</code> is not specified, it will be auto collected from series. For most of series, it will be collected from <a href="#series.name">series.name</a> or the dimension name specified by <code class="codespan">seriesName</code> of <a href="#series.encode">series.encode</a>. For some types of series like <a href="#series-pie">pie</a> and <a href="#series-funnel">funnel</a>, it will be collected from the name field of <code class="codespan">series.data</code>.</p>\n<p>If you need to set the style for a single item, you may also set the configuration of it. In this case, <code class="codespan">name</code> attribute is used to represent name of <code class="codespan">series</code>.</p>\n<p>Example:</p>\n<pre><code>data: [{\n    name: &#39;series 1&#39;,\n    // compulsorily set icon as a circle\n    icon: &#39;circle&#39;,\n    // set up the text in red\n    textStyle: {\n        color: &#39;red&#39;\n    }\n}]\n</code></pre>',
    )
    backgroundColor: Optional[Any] = Field(
        'transparent',
        description='\n\n<p>Background color of legend, which is transparent by default.</p>\n<blockquote>\n<p>Color can be represented in RGB, for example <code class="codespan">&#39;rgb(128, 128, 128)&#39;</code>. RGBA can be used when you need alpha channel, for example <code class="codespan">&#39;rgba(128, 128, 128, 0.5)&#39;</code>. You may also use hexadecimal format, for example <code class="codespan">&#39;#ccc&#39;</code>.</p>\n</blockquote>\n',
    )
    borderColor: Optional[Any] = Field(
        '#ccc',
        description='\n\n<p>Border color of legend. Support the same color format as backgroundColor.</p>\n',
    )
    borderWidth: Optional[float] = Field(
        1, description='\n\n<p>Border width of legend.</p>\n'
    )
    borderRadius: Optional[Union[float, Any]] = Field(
        0,
        description='\n\n<p>The radius of rounded corner. Its unit is px. And it supports use array to respectively specify the 4 corner radiuses.</p>\n<p>For example:</p>\n<pre><code>borderRadius: 5, // consistently set the size of 4 rounded corners\nborderRadius: [5, 5, 0, 0] // (clockwise upper left, upper right, bottom right and bottom left)\n</code></pre>',
    )
    shadowBlur: Optional[float] = Field(
        None,
        description='\n\n<p>Size of shadow blur. This attribute should be used along with <code class="codespan">shadowColor</code>,<code class="codespan">shadowOffsetX</code>, <code class="codespan">shadowOffsetY</code> to set shadow to component.</p>\n<p>For example:</p>\n<pre><code class="lang-ts">{\n    shadowColor: &#39;rgba(0, 0, 0, 0.5)&#39;,\n    shadowBlur: 10\n}\n</code></pre>\n<p><strong>Attention</strong>: This property works only if <code class="codespan">show: true</code> is configured and <code class="codespan">backgroundColor</code> is defined other than <code class="codespan">transparent</code>.</p>\n',
    )
    shadowColor: Optional[Any] = Field(
        None,
        description='\n\n<p>Shadow color. Support same format as <code class="codespan">color</code>.</p>\n<p><strong>Attention</strong>: This property works only if <code class="codespan">show: true</code> configured.</p>\n',
    )
    shadowOffsetX: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the horizontal direction of shadow.</p>\n<p><strong>Attention</strong>: This property works only if <code class="codespan">show: true</code> configured.</p>\n',
    )
    shadowOffsetY: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the vertical direction of shadow.</p>\n<p><strong>Attention</strong>: This property works only if <code class="codespan">show: true</code> configured.</p>\n',
    )
    scrollDataIndex: Optional[float] = Field(
        0,
        description='<p>It works when <a href="#legend.type">legend.type</a> is <code class="codespan">&#39;scroll&#39;</code>.</p>\n<p><code class="codespan">dataIndex</code> of the left top most displayed item.</p>\n<p>Although the scrolling of legend items can be controlled by calling <code class="codespan">setOption</code> and specifying this property, we suggest that do not control legend in this way unless necessary (<code class="codespan">setOption</code> might be time-consuming), but just use action <a href="api.html#action.legend.legendScroll" target="_blank">legendScroll</a> to do that.</p>\n<p>See <a href="http://localhost/echarts-website/examples/en/editor.html?c=pie-legend&amp;edit=1&amp;reset=1" target="_blank">vertically scrollable legend</a> or <a href="http://localhost/echarts-website/examples/en/editor.html?c=radar2&amp;edit=1&amp;reset=1" target="_blank">horizontally scrollable legend</a>.</p>\n',
    )
    pageButtonItemGap: Optional[float] = Field(
        5,
        description='<p>It works when <a href="#legend.type">legend.type</a> is <code class="codespan">&#39;scroll&#39;</code>.</p>\n<p>The gap between page buttons and page info text.</p>\n<p>See <a href="http://localhost/echarts-website/examples/en/editor.html?c=pie-legend&amp;edit=1&amp;reset=1" target="_blank">vertically scrollable legend</a> or <a href="http://localhost/echarts-website/examples/en/editor.html?c=radar2&amp;edit=1&amp;reset=1" target="_blank">horizontally scrollable legend</a>.</p>\n',
    )
    pageButtonGap: Optional[float] = Field(
        None,
        description='<p>It works when <a href="#legend.type">legend.type</a> is <code class="codespan">&#39;scroll&#39;</code>.</p>\n<p>The gap between page buttons and legend items.</p>\n<p>See <a href="http://localhost/echarts-website/examples/en/editor.html?c=pie-legend&amp;edit=1&amp;reset=1" target="_blank">vertically scrollable legend</a> or <a href="http://localhost/echarts-website/examples/en/editor.html?c=radar2&amp;edit=1&amp;reset=1" target="_blank">horizontally scrollable legend</a>.</p>\n',
    )
    pageButtonPosition: Optional[str] = Field(
        'end',
        description='<p>It works when <a href="#legend.type">legend.type</a> is <code class="codespan">&#39;scroll&#39;</code>.</p>\n<p>The position of page buttons and page info. Optional values:</p>\n<ul>\n<li><code class="codespan">&#39;start&#39;</code>: on the left or top.</li>\n<li><code class="codespan">&#39;end&#39;</code>: on the right or bottom.</li>\n</ul>\n<p>See <a href="http://localhost/echarts-website/examples/en/editor.html?c=pie-legend&amp;edit=1&amp;reset=1" target="_blank">vertically scrollable legend</a> or <a href="http://localhost/echarts-website/examples/en/editor.html?c=radar2&amp;edit=1&amp;reset=1" target="_blank">horizontally scrollable legend</a>.</p>\n',
    )
    pageFormatter: Optional[Union[str, Any]] = Field(
        '{current}/{total}',
        description='<p>It works when <a href="#legend.type">legend.type</a> is <code class="codespan">&#39;scroll&#39;</code>.</p>\n<p>Page info formatter. It is <code class="codespan">&#39;{current}/{total}&#39;</code> by default, where <code class="codespan">{current}</code> is current page number (start from 1), and <code class="codespan">{total}</code> is the total page number.</p>\n<p>If <code class="codespan">pageFormatter</code> is a function, it should return a string. The parameters is:</p>\n<pre><code class="lang-ts">{\n    current: number\n    total: number\n}\n</code></pre>\n<p>See <a href="http://localhost/echarts-website/examples/en/editor.html?c=pie-legend&amp;edit=1&amp;reset=1" target="_blank">vertically scrollable legend</a> or <a href="http://localhost/echarts-website/examples/en/editor.html?c=radar2&amp;edit=1&amp;reset=1" target="_blank">horizontally scrollable legend</a>.</p>\n',
    )
    pageIcons: Optional[PageIcons] = Field(
        None,
        description='<p>It works when <a href="#legend.type">legend.type</a> is <code class="codespan">&#39;scroll&#39;</code>.</p>\n<p>The icons of page buttons.</p>\n',
    )
    pageIconColor: Optional[str] = Field(
        '#2f4554',
        description='\n\n<p>It works when <a href="#legend.type">legend.type</a> is <code class="codespan">&#39;scroll&#39;</code>.</p>\n<p>The color of page buttons.</p>\n<p>See <a href="http://localhost/echarts-website/examples/en/editor.html?c=pie-legend&amp;edit=1&amp;reset=1" target="_blank">vertically scrollable legend</a> or <a href="http://localhost/echarts-website/examples/en/editor.html?c=radar2&amp;edit=1&amp;reset=1" target="_blank">horizontally scrollable legend</a>.</p>\n',
    )
    pageIconInactiveColor: Optional[str] = Field(
        '#aaa',
        description='\n\n<p>It works when <a href="#legend.type">legend.type</a> is <code class="codespan">&#39;scroll&#39;</code>.</p>\n<p>The color of page buttons when they are inactive.</p>\n<p>See <a href="http://localhost/echarts-website/examples/en/editor.html?c=pie-legend&amp;edit=1&amp;reset=1" target="_blank">vertically scrollable legend</a> or <a href="http://localhost/echarts-website/examples/en/editor.html?c=radar2&amp;edit=1&amp;reset=1" target="_blank">horizontally scrollable legend</a>.</p>\n',
    )
    pageIconSize: Optional[Union[float, Any]] = Field(
        15,
        description='\n\n<p>It works when <a href="#legend.type">legend.type</a> is <code class="codespan">&#39;scroll&#39;</code>.</p>\n<p>The size of page buttons. It can be a number, or an array, like <code class="codespan">[10, 3]</code>, represents <code class="codespan">[width, height]</code>.</p>\n<p>See <a href="http://localhost/echarts-website/examples/en/editor.html?c=pie-legend&amp;edit=1&amp;reset=1" target="_blank">vertically scrollable legend</a> or <a href="http://localhost/echarts-website/examples/en/editor.html?c=radar2&amp;edit=1&amp;reset=1" target="_blank">horizontally scrollable legend</a>.</p>\n',
    )
    pageTextStyle: Optional[PageTextStyle] = Field(
        None,
        description='<p>It works when <a href="#legend.type">legend.type</a> is <code class="codespan">&#39;scroll&#39;</code>.</p>\n<p>The text style of page info.</p>\n',
    )
    animation: Optional[bool] = Field(
        None, description='\n\n<p>Whether to use animation when page scrolls.</p>\n'
    )
    animationDurationUpdate: Optional[float] = Field(
        800, description='\n\n<p>Duration of the page scroll animation.</p>\n'
    )
    emphasis: Optional[Emphasis] = Field(None, description='')
    selector: Optional[Union[bool, Any]] = Field(
        False,
        description='<blockquote>\n<p>Since <code class="codespan">v4.4.0</code></p>\n</blockquote>\n<p>The selector button in the legend component. Currently includes both a full selection and an inverse selection. The selector button doesn&#39;t display by default, the user can manually configure it.</p>\n<p>Usage:</p>\n<pre><code class="lang-ts">selector: [\n    {\n        type: &#39;all or inverse&#39;,\n        // can be any title you like\n        title: &#39;All&#39;\n    },\n    {\n        type: &#39;inverse&#39;,\n        title: &#39;Inv&#39;\n    }\n]\n\n// or\nselector: true\n\n// or\nselector: [&#39;all&#39;, &#39;inverse&#39;]\n</code></pre>\n',
    )
    selectorLabel: Optional[SelectorLabel1] = Field(
        None,
        description='<blockquote>\n<p>Since <code class="codespan">v4.4.0</code></p>\n</blockquote>\n<p>The text label style of the selector button, which is displayed by default.</p>\n',
    )
    selectorPosition: Optional[str] = Field(
        'auto',
        description='\n\n\n\n<blockquote>\n<p>Since <code class="codespan">v4.4.0</code></p>\n</blockquote>\n<p>The position of the selector button, which can be placed at the end or start of the legend component, the corresponding values are <code class="codespan">&#39;end&#39;</code> and <code class="codespan">&#39;start&#39;</code>. By default, when the legend is laid out horizontally, the selector is placed at the end of it, and when the legend is laid out vertically, the selector is placed at the start of it.</p>\n',
    )
    selectorItemGap: Optional[float] = Field(
        7,
        description='\n\n\n\n<blockquote>\n<p>Since <code class="codespan">v4.4.0</code></p>\n</blockquote>\n<p>The gap between the selector button.</p>\n',
    )
    selectorButtonGap: Optional[float] = Field(
        10,
        description='\n\n\n\n<blockquote>\n<p>Since <code class="codespan">v4.4.0</code></p>\n</blockquote>\n<p>The gap between selector button and legend component.</p>\n',
    )


class Label(BaseModel):
    """
    <p>label of axisPointer</p>

    """

    show: Optional[bool] = Field(
        False,
        description='<p>Whether show label. Label will not show by default. But if <a href="#tooltip.axisPointer.type">tooltip.axisPointer.type</a> is set as  <code class="codespan">&#39;cross&#39;</code>, label will be displayed automatically.</p>\n',
    )
    precision: Optional[Union[float, str]] = Field(
        'auto',
        description='<p>The precision of value in label. It is auto determined by default. You can also set it as <code class="codespan">&#39;2&#39;</code>, which indicates that two decimal fractions are reserved.</p>\n',
    )
    formatter: Optional[Union[str, Any]] = Field(
        None,
        description='<p>The formatter of label.</p>\n<p>If set as <code class="codespan">string</code>, for example it can be: <code class="codespan">formatter: &#39;some text {value} some text</code>, where <code class="codespan">{value}</code> will be replaced by axis value automatically.</p>\n<p>If set as <code class="codespan">function</code>:</p>\n<p><strong>Parameters:</strong></p>\n<p><code class="codespan">{Object}</code> params: Including fields as follows:</p>\n<p><code class="codespan">{Object}</code> params.value: current value of this axis. If <code class="codespan">axis.type</code> is <code class="codespan">&#39;category&#39;</code>, it is one of the value in <code class="codespan">axis.data</code>. If <code class="codespan">axis.type</code> is <code class="codespan">&#39;time&#39;</code>, it is a timestamp.</p>\n<p><code class="codespan">{Array.&lt;Object&gt;}</code> params.seriesData: An array, containing info of nearest points. Each item is:</p>\n<p><code class="codespan">{string}</code> params.axisDimension: The dimension name of the axis. For example, in catesian it will be <code class="codespan">&#39;x&#39;</code>, <code class="codespan">&#39;y&#39;</code>, and in polar it will be <code class="codespan">&#39;radius&#39;</code>, <code class="codespan">&#39;angle&#39;</code>.</p>\n<p><code class="codespan">{number}</code> params.axisIndex: The index of the axis, for example, <code class="codespan">0</code>,<code class="codespan">1</code>, <code class="codespan">2</code>, ...</p>\n<pre><code class="lang-ts">{\n    componentType: &#39;series&#39;,\n    // Series type\n    seriesType: string,\n    // Series index in option.series\n    seriesIndex: number,\n    // Series name\n    seriesName: string,\n    // Data name, or category name\n    name: string,\n    // Data index in input data array\n    dataIndex: number,\n    // Original data as input\n    data: Object,\n    // Value of data. In most series it is the same as data.\n    // But in some series it is some part of the data (e.g., in map, radar)\n    value: number|Array|Object,\n    // encoding info of coordinate system\n    // Key: coord, like (&#39;x&#39; &#39;y&#39; &#39;radius&#39; &#39;angle&#39;)\n    // value: Must be an array, not null/undefined. Contain dimension indices, like:\n    // {\n    //     x: [2] // values on dimension index 2 are mapped to x axis.\n    //     y: [0] // values on dimension index 0 are mapped to y axis.\n    // }\n    encode: Object,\n    // dimension names list\n    dimensionNames: Array&lt;String&gt;,\n    // data dimension index, for example 0 or 1 or 2 ...\n    // Only work in `radar` series.\n    dimensionIndex: number,\n    // Color of data\n    color: string\n}\n</code></pre>\n<p><strong>How to use <code class="codespan">encode</code> and <code class="codespan">dimensionNames</code>?</strong></p>\n<p>When the dataset is like</p>\n<pre><code class="lang-ts">dataset: {\n    source: [\n        [&#39;Matcha Latte&#39;, 43.3, 85.8, 93.7],\n        [&#39;Milk Tea&#39;, 83.1, 73.4, 55.1],\n        [&#39;Cheese Cocoa&#39;, 86.4, 65.2, 82.5],\n        [&#39;Walnut Brownie&#39;, 72.4, 53.9, 39.1]\n    ]\n}\n</code></pre>\n<p>We can get the value of the y-axis via</p>\n<pre><code class="lang-ts">params.value[params.encode.y[0]]\n</code></pre>\n<p>When the dataset is like</p>\n<pre><code class="lang-ts">dataset: {\n    dimensions: [&#39;product&#39;, &#39;2015&#39;, &#39;2016&#39;, &#39;2017&#39;],\n    source: [\n        {product: &#39;Matcha Latte&#39;, &#39;2015&#39;: 43.3, &#39;2016&#39;: 85.8, &#39;2017&#39;: 93.7},\n        {product: &#39;Milk Tea&#39;, &#39;2015&#39;: 83.1, &#39;2016&#39;: 73.4, &#39;2017&#39;: 55.1},\n        {product: &#39;Cheese Cocoa&#39;, &#39;2015&#39;: 86.4, &#39;2016&#39;: 65.2, &#39;2017&#39;: 82.5},\n        {product: &#39;Walnut Brownie&#39;, &#39;2015&#39;: 72.4, &#39;2016&#39;: 53.9, &#39;2017&#39;: 39.1}\n    ]\n}\n</code></pre>\n<p>We can get the value of the y-axis via</p>\n<pre><code class="lang-ts">params.value[params.dimensionNames[params.encode.y[0]]]\n</code></pre>\n<p>Each item also includes axis infomation:</p>\n<pre><code class="lang-ts">{\n    axisDim: &#39;x&#39;, // &#39;x&#39;, &#39;y&#39;, &#39;angle&#39;, &#39;radius&#39;, &#39;single&#39;\n    axisId: &#39;xxx&#39;,\n    axisName: &#39;xxx&#39;,\n    axisIndex: 3,\n    axisValue: 121, // The current value of axisPointer\n    axisValueLabel: &#39;text of value&#39;\n}\n</code></pre>\n<p><strong>Return:</strong></p>\n<p>The string to be displayed.</p>\n<p>For example:</p>\n<pre><code class="lang-ts">formatter: function (params) {\n    // If axis.type is &#39;time&#39;\n    return &#39;some text&#39; + echarts.format.formatTime(params.value);\n}\n</code></pre>\n',
    )
    margin: Optional[float] = Field(
        3, description='<p>Distance between label and axis.</p>\n'
    )
    color: Optional[Any] = Field('#fff', description='\n\n<p> text color.</p>\n')
    fontStyle: Optional[str] = Field(
        'normal',
        description='\n\n<p> font style.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;italic&#39;</code></li>\n<li><code class="codespan">&#39;oblique&#39;</code></li>\n</ul>\n',
    )
    fontWeight: Optional[Union[str, float]] = Field(
        'normal',
        description='\n\n<p> font thick weight.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;bold&#39;</code></li>\n<li><code class="codespan">&#39;bolder&#39;</code></li>\n<li><code class="codespan">&#39;lighter&#39;</code></li>\n<li>100 | 200 | 300 | 400...</li>\n</ul>\n',
    )
    fontFamily: Optional[str] = Field(
        'sans-serif',
        description='\n\n<p> font family.</p>\n<p>Can also be &#39;serif&#39; , &#39;monospace&#39;, ...</p>\n',
    )
    fontSize: Optional[float] = Field(12, description='\n\n<p> font size.</p>\n')
    lineHeight: Optional[float] = Field(
        None,
        description='\n\n<p>Line height of the text fragment.</p>\n<p>If <code class="codespan">lineHeight</code> is not set in <code class="codespan">rich</code>, <code class="codespan">lineHeight</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    lineHeight: 56,\n    rich: {\n        a: {\n            // `lineHeight` is not set, then it will be 56\n        }\n    }\n}\n</code></pre>\n',
    )
    width: Optional[float] = Field(
        None, description='\n\n<p>Width of text block.</p>\n'
    )
    height: Optional[float] = Field(
        None, description='\n\n<p>Height of text block.</p>\n'
    )
    textBorderColor: Optional[Any] = Field(
        None, description='\n\n<p>Stroke color of the text.</p>\n'
    )
    textBorderWidth: Optional[float] = Field(
        None, description='\n\n<p>Stroke line width of the text.</p>\n'
    )
    textBorderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>Stroke line type of the text.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">textBorderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\ntextBorderType: [5, 10],\n\ntextBorderDashOffset: 5\n}\n</code></pre>\n',
    )
    textBorderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">textBorderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    textShadowColor: Optional[Any] = Field(
        'transparent', description='\n\n<p>Shadow color of the text itself.</p>\n'
    )
    textShadowBlur: Optional[float] = Field(
        0, description='\n\n<p>Shadow blue of the text itself.</p>\n'
    )
    textShadowOffsetX: Optional[float] = Field(
        0, description='\n\n<p>Shadow X offset of the text itself.</p>\n'
    )
    textShadowOffsetY: Optional[float] = Field(
        0, description='\n\n<p>Shadow Y offset of the text itself.</p>\n'
    )
    overflow: Optional[str] = Field(
        'none',
        description='\n\n<p>Determine how to display the text when it&#39;s overflow. Available when <code class="codespan">width</code> is set.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the text and trailing with <code class="codespan">ellipsis</code>.</li>\n<li><code class="codespan">&#39;break&#39;</code> Break by word</li>\n<li><code class="codespan">&#39;breakAll&#39;</code> Break by character.</li>\n</ul>\n',
    )
    ellipsis: Optional[str] = Field(
        '...',
        description='<p>Ellipsis to be displayed when <code class="codespan">overflow</code> is set to <code class="codespan">truncate</code>.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the overflow lines.</li>\n</ul>\n',
    )
    padding: Optional[Union[str, Any]] = Field(
        '[5, 7, 5, 7]',
        description='\n\n<p>axisPointer space around content. The unit is px. Default values for each position are 5. And they can be set to different values with left, right, top, and bottom.</p>\n<p>Examples:</p>\n<pre><code class="lang-ts">// Set padding to be 5\npadding: 5\n// Set the top and bottom paddings to be 5, and left and right paddings to be 10\npadding: [5, 10]\n// Set each of the four paddings seperately\npadding: [\n    5,  // up\n    10, // right\n    5,  // down\n    10, // left\n]\n</code></pre>\n',
    )
    backgroundColor: Optional[str] = Field(
        'auto',
        description='<p>Background color of label, the same as <a href="#xAxis.axisLine.lineStyle.color">axis.axisLine.lineStyle.color</a> by default.</p>\n',
    )
    borderColor: Optional[str] = Field(
        None, description='<p>Border color of label.</p>\n'
    )
    borderWidth: Optional[str] = Field(0, description='<p>Border width of label.</p>\n')
    shadowBlur: Optional[float] = Field(
        3,
        description='\n\n<p>Size of shadow blur. This attribute should be used along with <code class="codespan">shadowColor</code>,<code class="codespan">shadowOffsetX</code>, <code class="codespan">shadowOffsetY</code> to set shadow to component.</p>\n<p>For example:</p>\n<pre><code class="lang-ts">{\n    shadowColor: &#39;rgba(0, 0, 0, 0.5)&#39;,\n    shadowBlur: 10\n}\n</code></pre>\n',
    )
    shadowColor: Optional[Any] = Field(
        '#aaa',
        description='\n\n<p>Shadow color. Support same format as <code class="codespan">color</code>.</p>\n',
    )
    shadowOffsetX: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the horizontal direction of shadow.</p>\n',
    )
    shadowOffsetY: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the vertical direction of shadow.</p>\n',
    )


class LineStyle2(BaseModel):
    """
    <p>It is valid when <a href="#tooltip.axisPointer.type">axisPointer.type</a> is <code class="codespan">&#39;line&#39;</code>.</p>

    """

    color: Optional[Any] = Field(
        '#555',
        description='\n\n<p>Line color. </p>\n<blockquote>\n<p>Supports setting as solid color using <code class="codespan">rgb(255,255,255)</code>, <code class="codespan">rgba(255,255,255,1)</code>, <code class="codespan">#fff</code>, etc. Also supports setting as gradient color and pattern fill, see <a href="#color">option.color</a> for details</p>\n</blockquote>\n',
    )
    width: Optional[float] = Field(1, description='\n\n<p> line width.</p>\n')
    type: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>line type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">dashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\ntype: [5, 10],\n\ndashOffset: 5\n}\n</code></pre>\n',
    )
    dashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">type</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    cap: Optional[str] = Field(
        'butt',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To specify how to draw the end points of the line.\nPossible values are:</p>\n<ul>\n<li><code class="codespan">&#39;butt&#39;</code>: The ends of lines are squared off at the endpoints.</li>\n<li><code class="codespan">&#39;round&#39;</code>: The ends of lines are rounded.</li>\n<li><code class="codespan">&#39;square&#39;</code>: The ends of lines are squared off by adding a box with an equal width and half the height of the line&#39;s thickness.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;butt&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineCap" target="_blank">lineCap</a> for more details.</p>\n',
    )
    join: Optional[str] = Field(
        'bevel',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To determine the shape used to join two line segments where they meet.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;bevel&#39;</code>: Fills an additional triangular area between the common endpoint of connected segments, and the separate outside rectangular corners of each segment.</li>\n<li><code class="codespan">&#39;round&#39;</code>: Rounds off the corners of a shape by filling an additional sector of disc centered at the common endpoint of connected segments. The radius for these rounded corners is equal to the line width.</li>\n<li><code class="codespan">&#39;miter&#39;</code>: Connected segments are joined by extending their outside edges to connect at a single point, with the effect of filling an additional lozenge-shaped area. This setting is affected by the \n<code class="codespan">miterLimit</code>\nproperty.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;bevel&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineJoin" target="_blank">lineJoin</a> for more details.</p>\n',
    )
    miterLimit: Optional[float] = Field(
        10,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the miter limit ratio. Only works when \n<code class="codespan">join</code>\n is set as <code class="codespan">miter</code>.</p>\n<p>Default value is <code class="codespan">10</code>. Negative、<code class="codespan">0</code>、<code class="codespan">Infinity</code> and <code class="codespan">NaN</code> values are ignored.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/miterLimit" target="_blank">miterLimit</a> for more details.</p>\n',
    )
    shadowBlur: Optional[float] = Field(
        None,
        description='\n\n<p>Size of shadow blur. This attribute should be used along with <code class="codespan">shadowColor</code>,<code class="codespan">shadowOffsetX</code>, <code class="codespan">shadowOffsetY</code> to set shadow to component.</p>\n<p>For example:</p>\n<pre><code class="lang-ts">{\n    shadowColor: &#39;rgba(0, 0, 0, 0.5)&#39;,\n    shadowBlur: 10\n}\n</code></pre>\n',
    )
    shadowColor: Optional[Any] = Field(
        None,
        description='\n\n<p>Shadow color. Support same format as <code class="codespan">color</code>.</p>\n',
    )
    shadowOffsetX: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the horizontal direction of shadow.</p>\n',
    )
    shadowOffsetY: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the vertical direction of shadow.</p>\n',
    )
    opacity: Optional[float] = Field(
        None,
        description='\n\n<p>Opacity of the component. Supports value from 0 to 1, and the component will not be drawn when set to 0.</p>\n',
    )


class ShadowStyle(BaseModel):
    """
    <p>It is valid when <a href="#tooltip.axisPointer.type">axisPointer.type</a> is <code class="codespan">&#39;shadow&#39;</code>.</p>

    """

    color: Optional[Any] = Field(
        'rgba(150,150,150,0.3)',
        description='\n\n<p>Fill color. </p>\n<blockquote>\n<p>Supports setting as solid color using <code class="codespan">rgb(255,255,255)</code>, <code class="codespan">rgba(255,255,255,1)</code>, <code class="codespan">#fff</code>, etc. Also supports setting as gradient color and pattern fill, see <a href="#color">option.color</a> for details</p>\n</blockquote>\n',
    )
    shadowBlur: Optional[float] = Field(
        None,
        description='\n\n<p>Size of shadow blur. This attribute should be used along with <code class="codespan">shadowColor</code>,<code class="codespan">shadowOffsetX</code>, <code class="codespan">shadowOffsetY</code> to set shadow to component.</p>\n<p>For example:</p>\n<pre><code class="lang-ts">{\n    shadowColor: &#39;rgba(0, 0, 0, 0.5)&#39;,\n    shadowBlur: 10\n}\n</code></pre>\n',
    )
    shadowColor: Optional[Any] = Field(
        None,
        description='\n\n<p>Shadow color. Support same format as <code class="codespan">color</code>.</p>\n',
    )
    shadowOffsetX: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the horizontal direction of shadow.</p>\n',
    )
    shadowOffsetY: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the vertical direction of shadow.</p>\n',
    )
    opacity: Optional[float] = Field(
        None,
        description='\n\n<p>Opacity of the component. Supports value from 0 to 1, and the component will not be drawn when set to 0.</p>\n',
    )


class CrossStyle(BaseModel):
    """
    <p>It is valid when <a href="#tooltip.axisPointer.type">axisPointer.type</a> is <code class="codespan">&#39;cross&#39;</code>.</p>

    """

    color: Optional[Any] = Field(
        '#555',
        description='\n\n<p>Line color. </p>\n<blockquote>\n<p>Supports setting as solid color using <code class="codespan">rgb(255,255,255)</code>, <code class="codespan">rgba(255,255,255,1)</code>, <code class="codespan">#fff</code>, etc. Also supports setting as gradient color and pattern fill, see <a href="#color">option.color</a> for details</p>\n</blockquote>\n',
    )
    width: Optional[float] = Field(1, description='\n\n<p> line width.</p>\n')
    type: Optional[Union[str, float, Any]] = Field(
        'dashed',
        description='\n\n\n<p>line type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">dashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\ntype: [5, 10],\n\ndashOffset: 5\n}\n</code></pre>\n',
    )
    dashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">type</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    cap: Optional[str] = Field(
        'butt',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To specify how to draw the end points of the line.\nPossible values are:</p>\n<ul>\n<li><code class="codespan">&#39;butt&#39;</code>: The ends of lines are squared off at the endpoints.</li>\n<li><code class="codespan">&#39;round&#39;</code>: The ends of lines are rounded.</li>\n<li><code class="codespan">&#39;square&#39;</code>: The ends of lines are squared off by adding a box with an equal width and half the height of the line&#39;s thickness.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;butt&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineCap" target="_blank">lineCap</a> for more details.</p>\n',
    )
    join: Optional[str] = Field(
        'bevel',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To determine the shape used to join two line segments where they meet.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;bevel&#39;</code>: Fills an additional triangular area between the common endpoint of connected segments, and the separate outside rectangular corners of each segment.</li>\n<li><code class="codespan">&#39;round&#39;</code>: Rounds off the corners of a shape by filling an additional sector of disc centered at the common endpoint of connected segments. The radius for these rounded corners is equal to the line width.</li>\n<li><code class="codespan">&#39;miter&#39;</code>: Connected segments are joined by extending their outside edges to connect at a single point, with the effect of filling an additional lozenge-shaped area. This setting is affected by the \n<code class="codespan">miterLimit</code>\nproperty.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;bevel&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineJoin" target="_blank">lineJoin</a> for more details.</p>\n',
    )
    miterLimit: Optional[float] = Field(
        10,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the miter limit ratio. Only works when \n<code class="codespan">join</code>\n is set as <code class="codespan">miter</code>.</p>\n<p>Default value is <code class="codespan">10</code>. Negative、<code class="codespan">0</code>、<code class="codespan">Infinity</code> and <code class="codespan">NaN</code> values are ignored.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/miterLimit" target="_blank">miterLimit</a> for more details.</p>\n',
    )
    shadowBlur: Optional[float] = Field(
        None,
        description='\n\n<p>Size of shadow blur. This attribute should be used along with <code class="codespan">shadowColor</code>,<code class="codespan">shadowOffsetX</code>, <code class="codespan">shadowOffsetY</code> to set shadow to component.</p>\n<p>For example:</p>\n<pre><code class="lang-ts">{\n    shadowColor: &#39;rgba(0, 0, 0, 0.5)&#39;,\n    shadowBlur: 10\n}\n</code></pre>\n',
    )
    shadowColor: Optional[Any] = Field(
        None,
        description='\n\n<p>Shadow color. Support same format as <code class="codespan">color</code>.</p>\n',
    )
    shadowOffsetX: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the horizontal direction of shadow.</p>\n',
    )
    shadowOffsetY: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the vertical direction of shadow.</p>\n',
    )
    opacity: Optional[float] = Field(
        None,
        description='\n\n<p>Opacity of the component. Supports value from 0 to 1, and the component will not be drawn when set to 0.</p>\n',
    )


class AxisPointer(BaseModel):
    """
        <p>Configuration item for axisPointer.</p>
    <p><code class="codespan">tooltip.axisPointer</code> is like syntactic sugar of axisPointer settings on axes (for example, <a href="#xAxis.axisPointer">xAxis.axisPointer</a> or <a href="#angleAxis.axisPointer">angleAxis.axisPointer</a>). More detailed features can be configured on <code class="codespan">someAxis.axisPointer</code>. But in common cases, using <code class="codespan">tooltip.axisPointer</code> is more convenient.</p>
    <blockquote>
    <p><strong>Notice:</strong> configurations of <code class="codespan">tooltip.axisPointer</code> has lower priority than that of <code class="codespan">someAxis.axisPointer</code>.</p>
    </blockquote>
    <hr>
    <p><code class="codespan">axisPointer</code> is a tool for displaying reference line and axis value under mouse pointer.</p>
    <p>For example:</p>
    <iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=doc-example/candlestick-axisPointer&edit=1&reset=1" width="600" height="450"></iframe>


    <p>In the demo above, <a href="#axisPointer.link">axisPointer.link</a> is used to link axisPointer from different coordinate systems.</p>
    <p><code class="codespan">axisPointer</code> can also be used on touch device, where user can drag the button to move the reference line and label.</p>
    <iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=line-tooltip-touch&edit=1&reset=1" width="600" height="400"></iframe>


    <p>In the cases that more than one axis exist, axisPointer helps to look inside the data.</p>
    <iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=multiple-y-axis&edit=1&reset=1" width="600" height="300"></iframe>

    <iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=multiple-x-axis&edit=1&reset=1" width="600" height="300"></iframe>



    <hr>
    <blockquote>
    <p><strong>Notice:</strong>
    Generally, axisPointers is configured in each axes who need them (for example <a href="#xAxis.axisPointer">xAxis.axisPointer</a>), or configured in <code class="codespan">tooltip</code> (for example <a href="#tooltip.axisPointer">tooltip.axisPointer</a>).</p>
    </blockquote>
    <blockquote>
    <p>But these configurations can only be configured in global axisPointer:
    <a href="#axisPointer.triggerOn">axisPointer.triggerOn</a>, <a href="#axisPointer.link">axisPointer.link</a>.</p>
    </blockquote>
    <hr>
    <hr>
    <p><strong>How to display axisPointer:</strong></p>
    <p>In <a href="#grid">cartesian (grid)</a> and <a href="#single">polar](~polar) and (single axis</a>, each axis has its own axisPointer.</p>
    <p>Those axisPointer will not be displayed by default, utill configured as follows:</p>
    <ul>
    <li><p>Set <code class="codespan">someAxis.axisPointer.show</code> (like <a href="#xAxis.axisPointer.show">xAxis.axisPointer.show</a>) as <code class="codespan">true</code>. Then axisPointer of this axis will be displayed.</p>
    </li>
    <li><p>Set <a href="#tooltip.trigger">tooltip.trigger</a> as <code class="codespan">&#39;axis&#39;</code>, or set <a href="#tooltip.axisPointer.type">tooltip.axisPointer.type</a> as <code class="codespan">&#39;cross&#39;</code>. Then coordinate system will automatically chose the axes who will display their axisPointers. (<a href="#tooltip.axisPointer.axis">tooltip.axisPointer.axis</a> can be used to change the choice.) Notice, <code class="codespan">axis.axisPointer</code> will override <code class="codespan">tooltip.axisPointer</code> settings.</p>
    </li>
    </ul>
    <hr>
    <p><strong>How to display the label of axisPointer:</strong></p>
    <p>The label of axisPointer will not be displayed by default(namely, only reference line will be displayed by default), utill configured as follows:</p>
    <ul>
    <li><p>Set <code class="codespan">someAxis.axisPointer.label.show</code> (for example <a href="#xAxis.axisPointer.show">xAxis.axisPointer.label.show</a>) as <code class="codespan">true</code>. Then the label of the axisPointer will be displayed.</p>
    </li>
    <li><p>Set <a href="#tooltip.axisPointer.type">tooltip.axisPointer.type</a> as  <code class="codespan">&#39;cross&#39;</code>. Then the label of the crossed axisPointers will be displayed.</p>
    </li>
    </ul>
    <hr>
    <p><strong>How to configure axisPointer on touch device:</strong></p>
    <p>Set <code class="codespan">someAxis.axisPointer.handle.show</code> (for example <a href="#xAxis.axisPointer.handle.show">xAxis.axisPointer.handle.show</a> as <code class="codespan">true</code>. Then the button for dragging will be displayed. (This feature is not supported on polar).</p>
    <p><strong>Notice:</strong>
    If tooltip does not work well in this case, try to set<a href="#tooltip.triggerOn">tooltip.triggerOn</a> as <code class="codespan">&#39;none&#39;</code> (for the effect: show tooltip when finger holding on the button, and hide tooltip after finger left the button), or set <a href="#tooltip.alwaysShowContent">tooltip.alwaysShowContent</a> as <code class="codespan">true</code> (then tooltip will always be displayed).</p>
    <p>See the <a href="http://localhost/echarts-website/examples/en/editor.html?c=line-tooltip-touch&amp;edit=1&amp;reset=1" target="_blank">example</a>.</p>
    <hr>
    <p><strong>Snap to point</strong></p>
    <p>In value axis and time axis, if <a href="#xAxis.axisPointer.snap">snap</a> is set as true, axisPointer will snap to point automatically.</p>
    <hr>

    """

    type: Optional[str] = Field(
        'line',
        description='\n\n<p>Indicator type.</p>\n<p>Options:</p>\n<ul>\n<li><p><code class="codespan">&#39;line&#39;</code> line indicator.</p>\n</li>\n<li><p><code class="codespan">&#39;shadow&#39;</code> shadow crosshair indicator.</p>\n</li>\n<li><p><code class="codespan">&#39;none&#39;</code> no indicator displayed.</p>\n</li>\n<li><p><code class="codespan">&#39;cross&#39;</code> crosshair indicator, which is actually the shortcut of enable two axisPointers of two orthometric axes.</p>\n</li>\n</ul>\n',
    )
    axis: Optional[str] = Field(
        'auto',
        description='<p>The coordinate axis, which could be <code class="codespan">&#39;x&#39;</code>, <code class="codespan">&#39;y&#39;</code>, <code class="codespan">&#39;radius&#39;</code>, or <code class="codespan">&#39;angle&#39;</code>. By default, each coordinate system will automatically chose the axes whose will display its axisPointer (category axis or time axis is used by default).</p>\n',
    )
    snap: Optional[bool] = Field(
        None,
        description='<p>Whether snap to point automatically. The default value is auto determined.</p>\n<p>This feature usually makes sense in value axis and time axis, where tiny points can be seeked automatically.</p>\n',
    )
    z: Optional[float] = Field(
        None,
        description='<p>z value, which controls order of drawing graphical components. Components with smaller <code class="codespan">z</code> values may be overwritten by those with larger <code class="codespan">z</code> values.</p>\n',
    )
    label: Optional[Label] = Field(None, description='<p>label of axisPointer</p>\n')
    lineStyle: Optional[LineStyle2] = Field(
        None,
        description='<p>It is valid when <a href="#tooltip.axisPointer.type">axisPointer.type</a> is <code class="codespan">&#39;line&#39;</code>.</p>\n',
    )
    shadowStyle: Optional[ShadowStyle] = Field(
        None,
        description='<p>It is valid when <a href="#tooltip.axisPointer.type">axisPointer.type</a> is <code class="codespan">&#39;shadow&#39;</code>.</p>\n',
    )
    crossStyle: Optional[CrossStyle] = Field(
        None,
        description='<p>It is valid when <a href="#tooltip.axisPointer.type">axisPointer.type</a> is <code class="codespan">&#39;cross&#39;</code>.</p>\n',
    )
    animation: Optional[bool] = Field(
        True, description='\n\n<p>Whether to enable animation.</p>\n'
    )
    animationThreshold: Optional[float] = Field(
        2000,
        description='<p>Whether to set graphic number threshold to animation. Animation will be disabled when graphic number is larger than threshold.</p>\n',
    )
    animationDuration: Optional[Union[float, Any]] = Field(
        1000,
        description='\n\n<p>Duration of the first animation, which supports callback function for different data to have different animation effect:</p>\n<pre><code class="lang-ts">animationDuration: function (idx) {\n    // delay for later data is larger\n    return idx * 100;\n}\n</code></pre>\n',
    )
    animationEasing: Optional[str] = Field(
        'cubicOut',
        description='\n\n<p>Easing method used for the first animation. Varied easing effects can be found at <a href="http://localhost/echarts-website/examples/en/editor.html?c=line-easing" target="_blank">easing effect example</a>.</p>\n',
    )
    animationDelay: Optional[Union[float, Any]] = Field(
        0,
        description='<p>Delay before updating the first animation, which supports callback function for different data to have different animation effect.</p>\n<p>For example:</p>\n<pre><code class="lang-ts">animationDelay: function (idx) {\n    // delay for later data is larger\n    return idx * 100;\n}\n</code></pre>\n<p>See <a href="http://localhost/echarts-website/examples/en/editor.html?c=bar-animation-delay" target="_blank">this example</a> for more information.</p>\n',
    )
    animationDurationUpdate: Optional[Union[float, Any]] = Field(
        200,
        description='\n\n<p>Time for animation to complete, which supports callback function for different data to have different animation effect:</p>\n<pre><code class="lang-ts">animationDurationUpdate: function (idx) {\n    // delay for later data is larger\n    return idx * 100;\n}\n</code></pre>\n',
    )
    animationEasingUpdate: Optional[str] = Field(
        'exponentialOut', description='\n\n<p>Easing method used for animation.</p>\n'
    )
    animationDelayUpdate: Optional[Union[float, Any]] = Field(
        0,
        description='<p>Delay before updating animation, which supports callback function for different data to have different animation effects.</p>\n<p>For example:</p>\n<pre><code class="lang-ts">animationDelayUpdate: function (idx) {\n    // delay for later data is larger\n    return idx * 100;\n}\n</code></pre>\n<p>See <a href="http://localhost/echarts-website/examples/en/editor.html?c=bar-animation-delay" target="_blank">this example</a> for more information.</p>\n',
    )


class TextStyle2(BaseModel):
    """
    <p>The text syle of tooltip&#39;s floating layer.</p>

    """

    color: Optional[Any] = Field('#fff', description='\n\n<p> text color.</p>\n')
    fontStyle: Optional[str] = Field(
        'normal',
        description='\n\n<p> font style.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;italic&#39;</code></li>\n<li><code class="codespan">&#39;oblique&#39;</code></li>\n</ul>\n',
    )
    fontWeight: Optional[Union[str, float]] = Field(
        'normal',
        description='\n\n<p> font thick weight.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;bold&#39;</code></li>\n<li><code class="codespan">&#39;bolder&#39;</code></li>\n<li><code class="codespan">&#39;lighter&#39;</code></li>\n<li>100 | 200 | 300 | 400...</li>\n</ul>\n',
    )
    fontFamily: Optional[str] = Field(
        'sans-serif',
        description='\n\n<p> font family.</p>\n<p>Can also be &#39;serif&#39; , &#39;monospace&#39;, ...</p>\n',
    )
    fontSize: Optional[float] = Field(14, description='\n\n<p> font size.</p>\n')
    lineHeight: Optional[float] = Field(
        None,
        description='\n\n<p>Line height of the text fragment.</p>\n<p>If <code class="codespan">lineHeight</code> is not set in <code class="codespan">rich</code>, <code class="codespan">lineHeight</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    lineHeight: 56,\n    rich: {\n        a: {\n            // `lineHeight` is not set, then it will be 56\n        }\n    }\n}\n</code></pre>\n',
    )
    width: Optional[float] = Field(
        None, description='\n\n<p>Width of text block.</p>\n'
    )
    height: Optional[float] = Field(
        None, description='\n\n<p>Height of text block.</p>\n'
    )
    textBorderColor: Optional[Any] = Field(
        None, description='\n\n<p>Stroke color of the text.</p>\n'
    )
    textBorderWidth: Optional[float] = Field(
        None, description='\n\n<p>Stroke line width of the text.</p>\n'
    )
    textBorderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>Stroke line type of the text.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">textBorderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\ntextBorderType: [5, 10],\n\ntextBorderDashOffset: 5\n}\n</code></pre>\n',
    )
    textBorderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">textBorderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    textShadowColor: Optional[Any] = Field(
        'transparent', description='\n\n<p>Shadow color of the text itself.</p>\n'
    )
    textShadowBlur: Optional[float] = Field(
        0, description='\n\n<p>Shadow blue of the text itself.</p>\n'
    )
    textShadowOffsetX: Optional[float] = Field(
        0, description='\n\n<p>Shadow X offset of the text itself.</p>\n'
    )
    textShadowOffsetY: Optional[float] = Field(
        0, description='\n\n<p>Shadow Y offset of the text itself.</p>\n'
    )
    overflow: Optional[str] = Field(
        'none',
        description='\n\n<p>Determine how to display the text when it&#39;s overflow. Available when <code class="codespan">width</code> is set.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the text and trailing with <code class="codespan">ellipsis</code>.</li>\n<li><code class="codespan">&#39;break&#39;</code> Break by word</li>\n<li><code class="codespan">&#39;breakAll&#39;</code> Break by character.</li>\n</ul>\n',
    )
    ellipsis: Optional[str] = Field(
        '...',
        description='<p>Ellipsis to be displayed when <code class="codespan">overflow</code> is set to <code class="codespan">truncate</code>.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the overflow lines.</li>\n</ul>\n',
    )


class Tooltip(BaseModel):
    """
        <p>tooltip settings in the coordinate system component.</p>
    <p><strong>General Introduction:</strong></p>
    <p>tooltip can be configured on different places:</p>
    <ul>
    <li><p>Configured on global: <a href="#tooltip">tooltip</a></p>
    </li>
    <li><p>Configured in a coordinate system: <a href="#grid.tooltip">grid.tooltip</a>, <a href="#polar.tooltip">polar.tooltip</a>, <a href="#single.tooltip">single.tooltip</a></p>
    </li>
    <li><p>Configured in a series: <a href="#series.tooltip">series.tooltip</a></p>
    </li>
    <li><p>Configured in each item of <code class="codespan">series.data</code>: <a href="#series.data.tooltip">series.data.tooltip</a></p>
    </li>
    </ul>

    """

    show: Optional[bool] = Field(
        True,
        description='\n\n<p>Whether to show the tooltip component.</p>\n<p>including tooltip floating layer and <a href="#tooltip.axisPointer">axisPointer</a>.</p>\n',
    )
    trigger: Optional[str] = Field(
        'item',
        description='\n\n<p>Type of triggering.</p>\n<p>Options:</p>\n<ul>\n<li><p><code class="codespan">&#39;item&#39;</code></p>\n<p>  Triggered by data item, which is mainly used for charts that don&#39;t have a category axis like scatter charts or pie charts.</p>\n</li>\n<li><p><code class="codespan">&#39;axis&#39;</code></p>\n<p>  Triggered by axes, which is mainly used for charts that have category axes, like bar charts or line charts.</p>\n<p> ECharts 2.x only supports axis trigger for category axis. In ECharts 3, it is supported for all types of axes in <a href="#grid">grid</a> or <a href="#polar">polar</a>. Also, you may assign axis with <a href="#tooltip.axisPointer.axis">axisPointer.axis</a>.</p>\n</li>\n<li><p><code class="codespan">&#39;none&#39;</code></p>\n<p>  Trigger nothing.</p>\n</li>\n</ul>\n',
    )
    axisPointer: Optional[AxisPointer] = Field(
        None,
        description='<p>Configuration item for axisPointer.</p>\n<p><code class="codespan">tooltip.axisPointer</code> is like syntactic sugar of axisPointer settings on axes (for example, <a href="#xAxis.axisPointer">xAxis.axisPointer</a> or <a href="#angleAxis.axisPointer">angleAxis.axisPointer</a>). More detailed features can be configured on <code class="codespan">someAxis.axisPointer</code>. But in common cases, using <code class="codespan">tooltip.axisPointer</code> is more convenient.</p>\n<blockquote>\n<p><strong>Notice:</strong> configurations of <code class="codespan">tooltip.axisPointer</code> has lower priority than that of <code class="codespan">someAxis.axisPointer</code>.</p>\n</blockquote>\n<hr>\n<p><code class="codespan">axisPointer</code> is a tool for displaying reference line and axis value under mouse pointer.</p>\n<p>For example:</p>\n<iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=doc-example/candlestick-axisPointer&edit=1&reset=1" width="600" height="450"></iframe>\n\n\n<p>In the demo above, <a href="#axisPointer.link">axisPointer.link</a> is used to link axisPointer from different coordinate systems.</p>\n<p><code class="codespan">axisPointer</code> can also be used on touch device, where user can drag the button to move the reference line and label.</p>\n<iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=line-tooltip-touch&edit=1&reset=1" width="600" height="400"></iframe>\n\n\n<p>In the cases that more than one axis exist, axisPointer helps to look inside the data.</p>\n<iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=multiple-y-axis&edit=1&reset=1" width="600" height="300"></iframe>\n\n<iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=multiple-x-axis&edit=1&reset=1" width="600" height="300"></iframe>\n\n\n\n<hr>\n<blockquote>\n<p><strong>Notice:</strong>\nGenerally, axisPointers is configured in each axes who need them (for example <a href="#xAxis.axisPointer">xAxis.axisPointer</a>), or configured in <code class="codespan">tooltip</code> (for example <a href="#tooltip.axisPointer">tooltip.axisPointer</a>).</p>\n</blockquote>\n<blockquote>\n<p>But these configurations can only be configured in global axisPointer:\n<a href="#axisPointer.triggerOn">axisPointer.triggerOn</a>, <a href="#axisPointer.link">axisPointer.link</a>.</p>\n</blockquote>\n<hr>\n<hr>\n<p><strong>How to display axisPointer:</strong></p>\n<p>In <a href="#grid">cartesian (grid)</a> and <a href="#single">polar](~polar) and (single axis</a>, each axis has its own axisPointer.</p>\n<p>Those axisPointer will not be displayed by default, utill configured as follows:</p>\n<ul>\n<li><p>Set <code class="codespan">someAxis.axisPointer.show</code> (like <a href="#xAxis.axisPointer.show">xAxis.axisPointer.show</a>) as <code class="codespan">true</code>. Then axisPointer of this axis will be displayed.</p>\n</li>\n<li><p>Set <a href="#tooltip.trigger">tooltip.trigger</a> as <code class="codespan">&#39;axis&#39;</code>, or set <a href="#tooltip.axisPointer.type">tooltip.axisPointer.type</a> as <code class="codespan">&#39;cross&#39;</code>. Then coordinate system will automatically chose the axes who will display their axisPointers. (<a href="#tooltip.axisPointer.axis">tooltip.axisPointer.axis</a> can be used to change the choice.) Notice, <code class="codespan">axis.axisPointer</code> will override <code class="codespan">tooltip.axisPointer</code> settings.</p>\n</li>\n</ul>\n<hr>\n<p><strong>How to display the label of axisPointer:</strong></p>\n<p>The label of axisPointer will not be displayed by default(namely, only reference line will be displayed by default), utill configured as follows:</p>\n<ul>\n<li><p>Set <code class="codespan">someAxis.axisPointer.label.show</code> (for example <a href="#xAxis.axisPointer.show">xAxis.axisPointer.label.show</a>) as <code class="codespan">true</code>. Then the label of the axisPointer will be displayed.</p>\n</li>\n<li><p>Set <a href="#tooltip.axisPointer.type">tooltip.axisPointer.type</a> as  <code class="codespan">&#39;cross&#39;</code>. Then the label of the crossed axisPointers will be displayed.</p>\n</li>\n</ul>\n<hr>\n<p><strong>How to configure axisPointer on touch device:</strong></p>\n<p>Set <code class="codespan">someAxis.axisPointer.handle.show</code> (for example <a href="#xAxis.axisPointer.handle.show">xAxis.axisPointer.handle.show</a> as <code class="codespan">true</code>. Then the button for dragging will be displayed. (This feature is not supported on polar).</p>\n<p><strong>Notice:</strong>\nIf tooltip does not work well in this case, try to set<a href="#tooltip.triggerOn">tooltip.triggerOn</a> as <code class="codespan">&#39;none&#39;</code> (for the effect: show tooltip when finger holding on the button, and hide tooltip after finger left the button), or set <a href="#tooltip.alwaysShowContent">tooltip.alwaysShowContent</a> as <code class="codespan">true</code> (then tooltip will always be displayed).</p>\n<p>See the <a href="http://localhost/echarts-website/examples/en/editor.html?c=line-tooltip-touch&amp;edit=1&amp;reset=1" target="_blank">example</a>.</p>\n<hr>\n<p><strong>Snap to point</strong></p>\n<p>In value axis and time axis, if <a href="#xAxis.axisPointer.snap">snap</a> is set as true, axisPointer will snap to point automatically.</p>\n<hr>\n',
    )
    position: Optional[Union[str, Any]] = Field(
        None,
        description='<p>The position of the tooltip&#39;s floating layer, which would follow the position of mouse by default.</p>\n<p>Options:</p>\n<ul>\n<li><p><code class="codespan">Array</code></p>\n<p>  Display the position of tooltip&#39;s floating layer through array, which supports absolute position and relative percentage.</p>\n<p>  Example:</p>\n<pre><code class="lang-ts">  // absolute position, which is 10px to the left side and 10px to the top side of the container\n  position: [10, 10]\n  // relative position, in the exact center of the container\n  position: [&#39;50%&#39;, &#39;50%&#39;]\n</code></pre>\n</li>\n<li><p><code class="codespan">Function</code></p>\n<p>  Callback function in the following form:</p>\n<pre><code class="lang-ts">  (point: Array, params: Object|Array.&lt;Object&gt;, dom: HTMLDomElement, rect: Object, size: Object) =&gt; Array\n</code></pre>\n<p>  <strong>Parameters:</strong><br>\n  point: Mouse position.<br>\n  param: The same as formatter.<br>\n  dom: The DOM object of tooltip.<br>\n  rect: It is valid only when mouse is on graphic elements, which stands for a bounding box with <code class="codespan">x</code>, <code class="codespan">y</code>, <code class="codespan">width</code>, and <code class="codespan">height</code>.<br>\n  size: The size of dom echarts container. For example: <code class="codespan">{contentSize: [width, height], viewSize: [width, height]}</code>. <br></p>\n<p>  <strong>Return:</strong><br>\n  Return value is an array standing for tooltip position, which can be absolute pixels, or relative percentage.<br>\n  Or can be an object, like <code class="codespan">{left: 10, top: 30}</code>, or <code class="codespan">{right: &#39;20%&#39;, bottom: 40}</code>.<br></p>\n<p>  For example:</p>\n<pre><code class="lang-ts">  position: function (point, params, dom, rect, size) {\n      // fixed at top\n      return [point[0], &#39;10%&#39;];\n  }\n</code></pre>\n<p>  Or:</p>\n<pre><code class="lang-ts">  position: function (pos, params, dom, rect, size) {\n      // tooltip will be fixed on the right if mouse hovering on the left,\n      // and on the left if hovering on the right.\n      var obj = {top: 60};\n      obj[[&#39;left&#39;, &#39;right&#39;][+(pos[0] &lt; size.viewSize[0] / 2)]] = 5;\n      return obj;\n  }\n</code></pre>\n</li>\n<li><p><code class="codespan">&#39;inside&#39;</code></p>\n<p> Center position of the graphic element where the mouse is in, which is only valid when <a href="#tooltip.trigger">trigger</a> is <code class="codespan">&#39;item&#39;</code>.</p>\n</li>\n<li><p><code class="codespan">&#39;top&#39;</code></p>\n<p>  Top position of the graphic element where the mouse is in, which is only valid when <a href="#tooltip.trigger">trigger</a> is <code class="codespan">&#39;item&#39;</code>.</p>\n</li>\n<li><p><code class="codespan">&#39;left&#39;</code></p>\n<p>  Left position of the graphic element where the mouse is in, which is only valid when <a href="#tooltip.trigger">trigger</a> is <code class="codespan">&#39;item&#39;</code>.</p>\n</li>\n<li><p><code class="codespan">&#39;right&#39;</code></p>\n<p>  Right position of the graphic element where the mouse is in, which is only valid when <a href="#tooltip.trigger">trigger</a> is <code class="codespan">&#39;item&#39;</code>.</p>\n</li>\n<li><p><code class="codespan">&#39;bottom&#39;</code></p>\n<p>  Bottom position of the graphic element where the mouse is in, which is only valid when <a href="#tooltip.trigger">trigger</a> is <code class="codespan">&#39;item&#39;</code>.</p>\n</li>\n</ul>\n',
    )
    formatter: Optional[Union[str, Any]] = Field(
        None,
        description='<p>The content formatter of tooltip&#39;s floating layer which supports string template and callback function.</p>\n<p><strong>1. String template</strong></p>\n<p>The template variables are <code class="codespan">{a}</code>, <code class="codespan">{b}</code>, <code class="codespan">{c}</code>, <code class="codespan">{d}</code> and <code class="codespan">{e}</code>, which stands for series name, data name and data value and ect. When <a href="#tooltip.trigger">trigger</a> is set to be <code class="codespan">&#39;axis&#39;</code>, there may be data from multiple series. In this time, series index can be refered as <code class="codespan">{a0}</code>, <code class="codespan">{a1}</code>, or <code class="codespan">{a2}</code>.</p>\n<p><code class="codespan">{a}</code>, <code class="codespan">{b}</code>, <code class="codespan">{c}</code>, <code class="codespan">{d}</code> have different meanings for different series types:</p>\n<ul>\n<li><p>Line (area) charts, bar (column) charts, K charts: <code class="codespan">{a}</code> for series name, <code class="codespan">{b}</code> for category name, <code class="codespan">{c}</code> for data value, <code class="codespan">{d}</code> for none;</p>\n</li>\n<li><p>Scatter (bubble) charts: <code class="codespan">{a}</code> for series name, <code class="codespan">{b}</code> for data name, <code class="codespan">{c}</code> for data value, <code class="codespan">{d}</code> for none;</p>\n</li>\n<li><p>Map: <code class="codespan">{a}</code> for series name, <code class="codespan">{b}</code> for area name, <code class="codespan">{c}</code> for merging data, <code class="codespan">{d}</code> for none;</p>\n</li>\n<li><p>Pie charts, gauge charts, funnel charts: <code class="codespan">{a}</code> for series name, <code class="codespan">{b}</code> for data item name, <code class="codespan">{c}</code> for data value, <code class="codespan">{d}</code> for percentage.</p>\n</li>\n</ul>\n<p><strong>Example: </strong></p>\n<pre><code class="lang-ts">formatter: &#39;{b0}: {c0}&lt;br /&gt;{b1}: {c1}&#39;\n</code></pre>\n<p><strong>2. Callback function</strong></p>\n<p>The format of callback function:</p>\n<pre><code class="lang-ts">(params: Object|Array, ticket: string, callback: (ticket: string, html: string)) =&gt; string | HTMLElement | HTMLElement[]\n</code></pre>\n<p>The first parameter <code class="codespan">params</code> is the data that the formatter needs. Its format is shown as follows:</p>\n<pre><code class="lang-ts">{\n    componentType: &#39;series&#39;,\n    // Series type\n    seriesType: string,\n    // Series index in option.series\n    seriesIndex: number,\n    // Series name\n    seriesName: string,\n    // Data name, or category name\n    name: string,\n    // Data index in input data array\n    dataIndex: number,\n    // Original data as input\n    data: Object,\n    // Value of data. In most series it is the same as data.\n    // But in some series it is some part of the data (e.g., in map, radar)\n    value: number|Array|Object,\n    // encoding info of coordinate system\n    // Key: coord, like (&#39;x&#39; &#39;y&#39; &#39;radius&#39; &#39;angle&#39;)\n    // value: Must be an array, not null/undefined. Contain dimension indices, like:\n    // {\n    //     x: [2] // values on dimension index 2 are mapped to x axis.\n    //     y: [0] // values on dimension index 0 are mapped to y axis.\n    // }\n    encode: Object,\n    // dimension names list\n    dimensionNames: Array&lt;String&gt;,\n    // data dimension index, for example 0 or 1 or 2 ...\n    // Only work in `radar` series.\n    dimensionIndex: number,\n    // Color of data\n    color: string,\n    // the percentage of pie chart\n    percent: number\n}\n</code></pre>\n<p><strong>How to use <code class="codespan">encode</code> and <code class="codespan">dimensionNames</code>?</strong></p>\n<p>When the dataset is like</p>\n<pre><code class="lang-ts">dataset: {\n    source: [\n        [&#39;Matcha Latte&#39;, 43.3, 85.8, 93.7],\n        [&#39;Milk Tea&#39;, 83.1, 73.4, 55.1],\n        [&#39;Cheese Cocoa&#39;, 86.4, 65.2, 82.5],\n        [&#39;Walnut Brownie&#39;, 72.4, 53.9, 39.1]\n    ]\n}\n</code></pre>\n<p>We can get the value of the y-axis via</p>\n<pre><code class="lang-ts">params.value[params.encode.y[0]]\n</code></pre>\n<p>When the dataset is like</p>\n<pre><code class="lang-ts">dataset: {\n    dimensions: [&#39;product&#39;, &#39;2015&#39;, &#39;2016&#39;, &#39;2017&#39;],\n    source: [\n        {product: &#39;Matcha Latte&#39;, &#39;2015&#39;: 43.3, &#39;2016&#39;: 85.8, &#39;2017&#39;: 93.7},\n        {product: &#39;Milk Tea&#39;, &#39;2015&#39;: 83.1, &#39;2016&#39;: 73.4, &#39;2017&#39;: 55.1},\n        {product: &#39;Cheese Cocoa&#39;, &#39;2015&#39;: 86.4, &#39;2016&#39;: 65.2, &#39;2017&#39;: 82.5},\n        {product: &#39;Walnut Brownie&#39;, &#39;2015&#39;: 72.4, &#39;2016&#39;: 53.9, &#39;2017&#39;: 39.1}\n    ]\n}\n</code></pre>\n<p>We can get the value of the y-axis via</p>\n<pre><code class="lang-ts">params.value[params.dimensionNames[params.encode.y[0]]]\n</code></pre>\n<p>When <a href="#tooltip.trigger">trigger</a> is <code class="codespan">&#39;axis&#39;</code>, or when tooltip is triggered by <a href="#xAxis.axisPointer">axisPointer</a>, <code class="codespan">params</code> is the data array of multiple series. The content of each item of the array is the same as above. Besides,</p>\n<pre><code class="lang-ts">{\n    componentType: &#39;series&#39;,\n    // Series type\n    seriesType: string,\n    // Series index in option.series\n    seriesIndex: number,\n    // Series name\n    seriesName: string,\n    // Data name, or category name\n    name: string,\n    // Data index in input data array\n    dataIndex: number,\n    // Original data as input\n    data: Object,\n    // Value of data. In most series it is the same as data.\n    // But in some series it is some part of the data (e.g., in map, radar)\n    value: number|Array|Object,\n    // encoding info of coordinate system\n    // Key: coord, like (&#39;x&#39; &#39;y&#39; &#39;radius&#39; &#39;angle&#39;)\n    // value: Must be an array, not null/undefined. Contain dimension indices, like:\n    // {\n    //     x: [2] // values on dimension index 2 are mapped to x axis.\n    //     y: [0] // values on dimension index 0 are mapped to y axis.\n    // }\n    encode: Object,\n    // dimension names list\n    dimensionNames: Array&lt;String&gt;,\n    // data dimension index, for example 0 or 1 or 2 ...\n    // Only work in `radar` series.\n    dimensionIndex: number,\n    // Color of data\n    color: string\n}\n</code></pre>\n<p><strong>How to use <code class="codespan">encode</code> and <code class="codespan">dimensionNames</code>?</strong></p>\n<p>When the dataset is like</p>\n<pre><code class="lang-ts">dataset: {\n    source: [\n        [&#39;Matcha Latte&#39;, 43.3, 85.8, 93.7],\n        [&#39;Milk Tea&#39;, 83.1, 73.4, 55.1],\n        [&#39;Cheese Cocoa&#39;, 86.4, 65.2, 82.5],\n        [&#39;Walnut Brownie&#39;, 72.4, 53.9, 39.1]\n    ]\n}\n</code></pre>\n<p>We can get the value of the y-axis via</p>\n<pre><code class="lang-ts">params.value[params.encode.y[0]]\n</code></pre>\n<p>When the dataset is like</p>\n<pre><code class="lang-ts">dataset: {\n    dimensions: [&#39;product&#39;, &#39;2015&#39;, &#39;2016&#39;, &#39;2017&#39;],\n    source: [\n        {product: &#39;Matcha Latte&#39;, &#39;2015&#39;: 43.3, &#39;2016&#39;: 85.8, &#39;2017&#39;: 93.7},\n        {product: &#39;Milk Tea&#39;, &#39;2015&#39;: 83.1, &#39;2016&#39;: 73.4, &#39;2017&#39;: 55.1},\n        {product: &#39;Cheese Cocoa&#39;, &#39;2015&#39;: 86.4, &#39;2016&#39;: 65.2, &#39;2017&#39;: 82.5},\n        {product: &#39;Walnut Brownie&#39;, &#39;2015&#39;: 72.4, &#39;2016&#39;: 53.9, &#39;2017&#39;: 39.1}\n    ]\n}\n</code></pre>\n<p>We can get the value of the y-axis via</p>\n<pre><code class="lang-ts">params.value[params.dimensionNames[params.encode.y[0]]]\n</code></pre>\n<p><strong>Note: </strong>Using array to present all the parameters in ECharts 2.x is not supported anymore.</p>\n<p>The second parameter <code class="codespan">ticket</code> is the asynchronous callback flag which should be used along with the third parameter <code class="codespan">callback</code> when it is used.</p>\n<p>The third parameter <code class="codespan">callback</code> is asynchronous callback. When the content of tooltip is acquired asynchronously, <code class="codespan">ticket</code> and <code class="codespan">htm</code> as introduced above can be used to update tooltip with callback.</p>\n<p>Example:</p>\n<pre><code class="lang-ts">formatter: function (params, ticket, callback) {\n    $.get(&#39;detail?name=&#39; + params.name, function (content) {\n        callback(ticket, toHTML(content));\n    });\n    return &#39;Loading&#39;;\n}\n</code></pre>\n',
    )
    valueFormatter: Optional[str] = Field(
        None,
        description='<blockquote>\n<p>Since <code class="codespan">v5.3.0</code></p>\n</blockquote>\n<p>Callback function for formatting the value section in tooltip.</p>\n<p>Interface:</p>\n<pre><code class="lang-ts">(value: number | string) =&gt; string\n</code></pre>\n<p>Example:</p>\n<pre><code class="lang-ts">// Add $ prefix\nvalueFormatter: (value) =&gt; &#39;$&#39; + value.toFixed(2)\n</code></pre>\n',
    )
    backgroundColor: Optional[Any] = Field(
        'rgba(50,50,50,0.7)',
        description='<p>The background color of tooltip&#39;s floating layer.</p>\n',
    )
    borderColor: Optional[Any] = Field(
        '#333',
        description='\n\n\n\n\n\n\n\n\n\n<p>The border color of tooltip&#39;s floating layer.</p>\n',
    )
    borderWidth: Optional[float] = Field(
        0,
        description='\n\n\n\n\n\n\n\n\n\n<p>The border width of tooltip&#39;s floating layer.</p>\n',
    )
    padding: Optional[float] = Field(
        5,
        description='\n\n\n\n\n\n\n\n\n\n\n\n\n\n<p>The floating layer of tooltip space around content. The unit is px. Default values for each position are 5. And they can be set to different values with left, right, top, and bottom.</p>\n<p>Examples:</p>\n<pre><code class="lang-ts">// Set padding to be 5\npadding: 5\n// Set the top and bottom paddings to be 5, and left and right paddings to be 10\npadding: [5, 10]\n// Set each of the four paddings seperately\npadding: [\n    5,  // up\n    10, // right\n    5,  // down\n    10, // left\n]\n</code></pre>\n',
    )
    textStyle: Optional[TextStyle2] = Field(
        None, description='<p>The text syle of tooltip&#39;s floating layer.</p>\n'
    )
    extraCssText: Optional[str] = Field(
        None,
        description='\n\n\n\n\n\n\n\n\n\n<p>Extra CSS style for floating layer. The following is an example for adding shadow.</p>\n<pre><code class="lang-ts">extraCssText: &#39;box-shadow: 0 0 3px rgba(0, 0, 0, 0.3);&#39;\n</code></pre>\n',
    )


class Grid(BaseModel):
    """
        <p>Drawing grid in rectangular coordinate. In a single grid, at most two X and Y axes each is allowed. <a href="#series-line">Line chart</a>, <a href="#series-bar">bar chart</a>, and <a href="#series-scatter">scatter chart (bubble chart)</a> can be drawn in grid.</p>
    <p>In ECharts 2.x, there could only be one single grid component at most in a single echarts instance. But in ECharts 3, there is no limitation.</p>
    <p><strong>Following is an example of Anscombe Quartet:</strong></p>
    <iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=scatter-anscombe-quartet&edit=1&reset=1" width="600" height="400"></iframe>




    """

    id: Optional[str] = Field(
        None,
        description='<p>Component ID, not specified by default. If specified, it can be used to refer the component in option or API.</p>\n',
    )
    show: Optional[bool] = Field(
        False,
        description='\n\n<p>Whether to show the grid in rectangular coordinate.</p>\n',
    )
    zlevel: Optional[float] = Field(
        0,
        description='<p><code class="codespan">zlevel</code> value of all graphical elements in .</p>\n<p><code class="codespan">zlevel</code> is used to make layers with Canvas. Graphical elements with different <code class="codespan">zlevel</code> values will be placed in different Canvases, which is a common optimization technique. We can put those frequently changed elements (like those with animations) to a separate <code class="codespan">zlevel</code>. Notice that too many Canvases will increase memory cost, and should be used carefully on mobile phones to avoid crash.</p>\n<p>Canvases with bigger <code class="codespan">zlevel</code> will be placed on Canvases with smaller <code class="codespan">zlevel</code>.</p>\n',
    )
    z: Optional[float] = Field(
        2,
        description='<p><code class="codespan">z</code> value of all graphical elements in , which controls order of drawing graphical components. Components with smaller <code class="codespan">z</code> values may be overwritten by those with larger <code class="codespan">z</code> values.</p>\n<p><code class="codespan">z</code> has a lower priority to <code class="codespan">zlevel</code>, and will not create new Canvas.</p>\n',
    )
    left: Optional[Union[str, float]] = Field(
        '10%',
        description='<p>Distance between grid  component and the left side of the container.</p>\n<p><code class="codespan">left</code> value can be instant pixel value like <code class="codespan">20</code>; it can also be a percentage value relative to container width like <code class="codespan">&#39;20%&#39;</code>; and it can also be <code class="codespan">&#39;left&#39;</code>, <code class="codespan">&#39;center&#39;</code>, or <code class="codespan">&#39;right&#39;</code>.</p>\n<p>If the <code class="codespan">left</code> value is set to be <code class="codespan">&#39;left&#39;</code>, <code class="codespan">&#39;center&#39;</code>, or <code class="codespan">&#39;right&#39;</code>, then the component will be aligned automatically based on position.</p>\n',
    )
    top: Optional[Union[str, float]] = Field(
        60,
        description='<p>Distance between grid  component and the top side of the container.</p>\n<p><code class="codespan">top</code> value can be instant pixel value like <code class="codespan">20</code>; it can also be a percentage value relative to container width like <code class="codespan">&#39;20%&#39;</code>; and it can also be <code class="codespan">&#39;top&#39;</code>, <code class="codespan">&#39;middle&#39;</code>, or <code class="codespan">&#39;bottom&#39;</code>.</p>\n<p>If the <code class="codespan">top</code> value is set to be <code class="codespan">&#39;top&#39;</code>, <code class="codespan">&#39;middle&#39;</code>, or <code class="codespan">&#39;bottom&#39;</code>, then the component will be aligned automatically based on position.</p>\n',
    )
    right: Optional[Union[str, float]] = Field(
        '10%',
        description='<p>Distance between grid  component and the right side of the container.</p>\n<p><code class="codespan">right</code> value can be instant pixel value like <code class="codespan">20</code>; it can also be a percentage value relative to container width like <code class="codespan">&#39;20%&#39;</code>.</p>\n',
    )
    bottom: Optional[Union[str, float]] = Field(
        60,
        description='<p>Distance between grid  component and the bottom side of the container.</p>\n<p><code class="codespan">bottom</code> value can be instant pixel value like <code class="codespan">20</code>; it can also be a percentage value relative to container width like <code class="codespan">&#39;20%&#39;</code>.</p>\n',
    )
    width: Optional[Union[str, float]] = Field(
        'auto', description='<p>Width of grid  component. Adaptive by default.</p>\n'
    )
    height: Optional[Union[str, float]] = Field(
        'auto', description='<p>Height of grid  component. Adaptive by default.</p>\n'
    )
    containLabel: Optional[bool] = Field(
        False,
        description='\n\n<p>Whether the grid region contains <a href="#yAxis.axisLabel">axis tick label</a> of axis.</p>\n<ul>\n<li>When containLabel is <code class="codespan">false</code>:<ul>\n<li><code class="codespan">grid.left</code> <code class="codespan">grid.right</code> <code class="codespan">grid.top</code> <code class="codespan">grid.bottom</code> <code class="codespan">grid.width</code> <code class="codespan">grid.height</code> decide the location and size of the rectangle that is made of by xAxis and yAxis.</li>\n<li>Setting to <code class="codespan">false</code> will help when multiple grids need to be aligned at their axes.</li>\n</ul>\n</li>\n<li>When containLabel is <code class="codespan">true</code>:<ul>\n<li><code class="codespan">grid.left</code> <code class="codespan">grid.right</code> <code class="codespan">grid.top</code> <code class="codespan">grid.bottom</code> <code class="codespan">grid.width</code> <code class="codespan">grid.height</code> decide the location and size of the rectangle that contains the axes and the labels of the axes.</li>\n<li>Setting to <code class="codespan">true</code> will help when the length of axis labels is dynamic and is hard to approximate. This will avoid labels from overflowing the container or overlapping other components.</li>\n</ul>\n</li>\n</ul>\n',
    )
    backgroundColor: Optional[Any] = Field(
        'transparent',
        description='\n\n<p>Background color of grid, which is transparent by default.</p>\n<blockquote>\n<p>Color can be represented in RGB, for example <code class="codespan">&#39;rgb(128, 128, 128)&#39;</code>. RGBA can be used when you need alpha channel, for example <code class="codespan">&#39;rgba(128, 128, 128, 0.5)&#39;</code>. You may also use hexadecimal format, for example <code class="codespan">&#39;#ccc&#39;</code>.</p>\n</blockquote>\n<p><strong>Attention</strong>: Works only if <code class="codespan">show: true</code> is set.</p>\n',
    )
    borderColor: Optional[Any] = Field(
        '#ccc',
        description='\n\n<p>Border color of grid. Support the same color format as backgroundColor.</p>\n<p><strong>Attention</strong>: Works only if <code class="codespan">show: true</code> is set.</p>\n',
    )
    borderWidth: Optional[float] = Field(
        1,
        description='\n\n<p>Border width of grid.</p>\n<p><strong>Attention</strong>: Works only if <code class="codespan">show: true</code> is set.</p>\n',
    )
    shadowBlur: Optional[float] = Field(
        None,
        description='\n\n<p>Size of shadow blur. This attribute should be used along with <code class="codespan">shadowColor</code>,<code class="codespan">shadowOffsetX</code>, <code class="codespan">shadowOffsetY</code> to set shadow to component.</p>\n<p>For example:</p>\n<pre><code class="lang-ts">{\n    shadowColor: &#39;rgba(0, 0, 0, 0.5)&#39;,\n    shadowBlur: 10\n}\n</code></pre>\n<p><strong>Attention</strong>: This property works only if <code class="codespan">show: true</code> is configured and <code class="codespan">backgroundColor</code> is defined other than <code class="codespan">transparent</code>.</p>\n',
    )
    shadowColor: Optional[Any] = Field(
        None,
        description='\n\n<p>Shadow color. Support same format as <code class="codespan">color</code>.</p>\n<p><strong>Attention</strong>: This property works only if <code class="codespan">show: true</code> configured.</p>\n',
    )
    shadowOffsetX: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the horizontal direction of shadow.</p>\n<p><strong>Attention</strong>: This property works only if <code class="codespan">show: true</code> configured.</p>\n',
    )
    shadowOffsetY: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the vertical direction of shadow.</p>\n<p><strong>Attention</strong>: This property works only if <code class="codespan">show: true</code> configured.</p>\n',
    )
    tooltip: Optional[Tooltip] = Field(
        None,
        description='<p>tooltip settings in the coordinate system component.</p>\n<p><strong>General Introduction:</strong></p>\n<p>tooltip can be configured on different places:</p>\n<ul>\n<li><p>Configured on global: <a href="#tooltip">tooltip</a></p>\n</li>\n<li><p>Configured in a coordinate system: <a href="#grid.tooltip">grid.tooltip</a>, <a href="#polar.tooltip">polar.tooltip</a>, <a href="#single.tooltip">single.tooltip</a></p>\n</li>\n<li><p>Configured in a series: <a href="#series.tooltip">series.tooltip</a></p>\n</li>\n<li><p>Configured in each item of <code class="codespan">series.data</code>: <a href="#series.data.tooltip">series.data.tooltip</a></p>\n</li>\n</ul>\n',
    )


class _StyleName5(BaseModel):
    color: Optional[Any] = Field('#fff', description='\n\n<p> text color.</p>\n')
    fontStyle: Optional[str] = Field(
        'normal',
        description='\n\n<p> font style.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;italic&#39;</code></li>\n<li><code class="codespan">&#39;oblique&#39;</code></li>\n</ul>\n',
    )
    fontWeight: Optional[Union[str, float]] = Field(
        'normal',
        description='\n\n<p> font thick weight.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;bold&#39;</code></li>\n<li><code class="codespan">&#39;bolder&#39;</code></li>\n<li><code class="codespan">&#39;lighter&#39;</code></li>\n<li>100 | 200 | 300 | 400...</li>\n</ul>\n',
    )
    fontFamily: Optional[str] = Field(
        'sans-serif',
        description='\n\n<p> font family.</p>\n<p>Can also be &#39;serif&#39; , &#39;monospace&#39;, ...</p>\n',
    )
    fontSize: Optional[float] = Field(12, description='\n\n<p> font size.</p>\n')
    align: Optional[str] = Field(
        None,
        description='\n\n<p>Horizontal alignment of text, automatic by default.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;left&#39;</code></li>\n<li><code class="codespan">&#39;center&#39;</code></li>\n<li><code class="codespan">&#39;right&#39;</code></li>\n</ul>\n<p>If <code class="codespan">align</code> is not set in <code class="codespan">rich</code>, <code class="codespan">align</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    align: right,\n    rich: {\n        a: {\n            // `align` is not set, then it will be right\n        }\n    }\n}\n</code></pre>\n',
    )
    verticalAlign: Optional[str] = Field(
        None,
        description='\n\n<p>Vertical alignment of text, automatic by default.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;top&#39;</code></li>\n<li><code class="codespan">&#39;middle&#39;</code></li>\n<li><code class="codespan">&#39;bottom&#39;</code></li>\n</ul>\n<p>If <code class="codespan">verticalAlign</code> is not set in <code class="codespan">rich</code>, <code class="codespan">verticalAlign</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    verticalAlign: bottom,\n    rich: {\n        a: {\n            // `verticalAlign` is not set, then it will be bottom\n        }\n    }\n}\n</code></pre>\n',
    )
    lineHeight: Optional[float] = Field(
        None,
        description='\n\n<p>Line height of the text fragment.</p>\n<p>If <code class="codespan">lineHeight</code> is not set in <code class="codespan">rich</code>, <code class="codespan">lineHeight</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    lineHeight: 56,\n    rich: {\n        a: {\n            // `lineHeight` is not set, then it will be 56\n        }\n    }\n}\n</code></pre>\n',
    )
    backgroundColor: Optional[Union[str, Any]] = Field(
        'transparent',
        description='\n\n<p>Background color of the text fragment.</p>\n<p>Can be color string, like <code class="codespan">&#39;#123234&#39;</code>, <code class="codespan">&#39;red&#39;</code>, <code class="codespan">&#39;rgba(0,23,11,0.3)&#39;</code>.</p>\n<p>Or image can be used, for example:</p>\n<pre><code class="lang-ts">backgroundColor: {\n    image: &#39;xxx/xxx.png&#39;\n    // It can be URL of a image,\n    // or dataURI,\n    // or HTMLImageElement,\n    // or HTMLCanvasElement.\n}\n</code></pre>\n<p><code class="codespan">width</code> or <code class="codespan">height</code> can be specified when using background image, or\nauto adapted by default.</p>\n',
    )
    borderColor: Optional[Any] = Field(
        None, description='\n\n<p>Border color of the text fragment.</p>\n'
    )
    borderWidth: Optional[float] = Field(
        0, description='\n\n<p>Border width of the text fragment.</p>\n'
    )
    borderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>the text fragment border type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">borderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\nborderType: [5, 10],\n\nborderDashOffset: 5\n}\n</code></pre>\n',
    )
    borderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">borderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    borderRadius: Optional[float] = Field(
        0, description='\n\n<p>Border radius of the text fragment.</p>\n'
    )
    padding: Optional[Union[float, Any]] = Field(
        0,
        description='\n\n<p>Padding of the text fragment, for example:</p>\n<ul>\n<li><code class="codespan">padding: [3, 4, 5, 6]</code>: represents padding of <code class="codespan">[top, right, bottom, left]</code>.</li>\n<li><code class="codespan">padding: 4</code>: represents <code class="codespan">padding: [4, 4, 4, 4]</code>.</li>\n<li><code class="codespan">padding: [3, 4]</code>: represents <code class="codespan">padding: [3, 4, 3, 4]</code>.</li>\n</ul>\n<p>Notice, <code class="codespan">width</code> and <code class="codespan">height</code> specifies the width and height of the content, without <code class="codespan">padding</code>.</p>\n',
    )
    shadowColor: Optional[Any] = Field(
        'transparent', description='\n\n<p>Shadow color of the text block.</p>\n'
    )
    shadowBlur: Optional[float] = Field(
        0, description='\n\n<p>Show blur of the text block.</p>\n'
    )
    shadowOffsetX: Optional[float] = Field(
        0, description='\n\n<p>Shadow X offset of the text block.</p>\n'
    )
    shadowOffsetY: Optional[float] = Field(
        0, description='\n\n<p>Shadow Y offset of the text block.</p>\n'
    )
    width: Optional[Union[float, str]] = Field(
        None,
        description='<p>Width of the text block. It is the width of the text by default. In most cases, there is no need to specify it. You may want to use it in some cases like make simple table or using background image (see <code class="codespan">backgroundColor</code>).</p>\n<p>Notice, <code class="codespan">width</code> and <code class="codespan">height</code> specifies the width and height of the content, without <code class="codespan">padding</code>.</p>\n<p><code class="codespan">width</code> can also be percent string, like <code class="codespan">&#39;100%&#39;</code>, which represents the percent of <code class="codespan">contentWidth</code> (that is, the width without <code class="codespan">padding</code>) of its container box. It is based on <code class="codespan">contentWidth</code> because that each text fragment is layout based on the <code class="codespan">content box</code>, where it makes no sense that calculating width based on <code class="codespan">outerWith</code> in prectice.</p>\n<p>Notice, <code class="codespan">width</code> and <code class="codespan">height</code> only work when <code class="codespan">rich</code> specified.</p>\n',
    )
    height: Optional[Union[float, str]] = Field(
        None,
        description='<p>Height of the text block. It is the width of the text by default. You may want to use it in some cases like using background image (see <code class="codespan">backgroundColor</code>).</p>\n<p>Notice, <code class="codespan">width</code> and <code class="codespan">height</code> specifies the width and height of the content, without <code class="codespan">padding</code>.</p>\n<p>Notice, <code class="codespan">width</code> and <code class="codespan">height</code> only work when <code class="codespan">rich</code> specified.</p>\n',
    )
    textBorderColor: Optional[Any] = Field(
        None, description='\n\n<p>Stroke color of the text.</p>\n'
    )
    textBorderWidth: Optional[float] = Field(
        None, description='\n\n<p>Stroke line width of the text.</p>\n'
    )
    textBorderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>Stroke line type of the text.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">textBorderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\ntextBorderType: [5, 10],\n\ntextBorderDashOffset: 5\n}\n</code></pre>\n',
    )
    textBorderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">textBorderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    textShadowColor: Optional[Any] = Field(
        'transparent', description='\n\n<p>Shadow color of the text itself.</p>\n'
    )
    textShadowBlur: Optional[float] = Field(
        0, description='\n\n<p>Shadow blue of the text itself.</p>\n'
    )
    textShadowOffsetX: Optional[float] = Field(
        0, description='\n\n<p>Shadow X offset of the text itself.</p>\n'
    )
    textShadowOffsetY: Optional[float] = Field(
        0, description='\n\n<p>Shadow Y offset of the text itself.</p>\n\n'
    )


class Rich5(BaseModel):
    """
        <p>&quot;Rich text styles&quot; can be defined in this <code class="codespan">rich</code> property. For example:</p>
    <pre><code class="lang-ts">label: {
        // Styles defined in &#39;rich&#39; can be applied to some fragments
        // of text by adding some markers to those fragment, like
        // `{styleName|text content text content}`.
        // `&#39;\n&#39;` is the newline character.
        formatter: [
            &#39;{a|Style &quot;a&quot; is applied to this snippet}&#39;
            &#39;{b|Style &quot;b&quot; is applied to this snippet}This snippet use default style{x|use style &quot;x&quot;}&#39;
        ].join(&#39;\n&#39;),

        rich: {
            a: {
                color: &#39;red&#39;,
                lineHeight: 10
            },
            b: {
                backgroundColor: {
                    image: &#39;xxx/xxx.jpg&#39;
                },
                height: 40
            },
            x: {
                fontSize: 18,
                fontFamily: &#39;Microsoft YaHei&#39;,
                borderColor: &#39;#449933&#39;,
                borderRadius: 4
            },
            ...
        }
    }
    </code></pre>
    <p>For more details, see <a href="tutorial.html#Rich%20Text" target="_blank">Rich Text</a> please.</p>

    """

    _style_name_: Optional[_StyleName5] = Field(
        None, alias='<style_name>', description=''
    )


class NameTextStyle(BaseModel):
    """
    <p>Text style of axis name.</p>

    """

    color: Optional[Any] = Field(
        None,
        description='\n\n<p>Color of axis name uses <a href="#xAxis.axisLine.lineStyle.color">axisLine.lineStyle.color</a> by default.</p>\n',
    )
    fontStyle: Optional[str] = Field(
        'normal',
        description='\n\n<p>axis name font style.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;italic&#39;</code></li>\n<li><code class="codespan">&#39;oblique&#39;</code></li>\n</ul>\n',
    )
    fontWeight: Optional[Union[str, float]] = Field(
        'normal',
        description='\n\n<p>axis name font thick weight.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;bold&#39;</code></li>\n<li><code class="codespan">&#39;bolder&#39;</code></li>\n<li><code class="codespan">&#39;lighter&#39;</code></li>\n<li>100 | 200 | 300 | 400...</li>\n</ul>\n',
    )
    fontFamily: Optional[str] = Field(
        'sans-serif',
        description='\n\n<p>axis name font family.</p>\n<p>Can also be &#39;serif&#39; , &#39;monospace&#39;, ...</p>\n',
    )
    fontSize: Optional[float] = Field(
        12, description='\n\n<p>axis name font size.</p>\n'
    )
    align: Optional[str] = Field(
        None,
        description='\n\n<p>Horizontal alignment of text, automatic by default.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;left&#39;</code></li>\n<li><code class="codespan">&#39;center&#39;</code></li>\n<li><code class="codespan">&#39;right&#39;</code></li>\n</ul>\n<p>If <code class="codespan">align</code> is not set in <code class="codespan">rich</code>, <code class="codespan">align</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    align: right,\n    rich: {\n        a: {\n            // `align` is not set, then it will be right\n        }\n    }\n}\n</code></pre>\n',
    )
    verticalAlign: Optional[str] = Field(
        None,
        description='\n\n<p>Vertical alignment of text, automatic by default.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;top&#39;</code></li>\n<li><code class="codespan">&#39;middle&#39;</code></li>\n<li><code class="codespan">&#39;bottom&#39;</code></li>\n</ul>\n<p>If <code class="codespan">verticalAlign</code> is not set in <code class="codespan">rich</code>, <code class="codespan">verticalAlign</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    verticalAlign: bottom,\n    rich: {\n        a: {\n            // `verticalAlign` is not set, then it will be bottom\n        }\n    }\n}\n</code></pre>\n',
    )
    lineHeight: Optional[float] = Field(
        None,
        description='\n\n<p>Line height of the text fragment.</p>\n<p>If <code class="codespan">lineHeight</code> is not set in <code class="codespan">rich</code>, <code class="codespan">lineHeight</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    lineHeight: 56,\n    rich: {\n        a: {\n            // `lineHeight` is not set, then it will be 56\n        }\n    }\n}\n</code></pre>\n',
    )
    backgroundColor: Optional[Union[str, Any]] = Field(
        'transparent',
        description='\n\n<p>Background color of the text fragment.</p>\n<p>Can be color string, like <code class="codespan">&#39;#123234&#39;</code>, <code class="codespan">&#39;red&#39;</code>, <code class="codespan">&#39;rgba(0,23,11,0.3)&#39;</code>.</p>\n<p>Or image can be used, for example:</p>\n<pre><code class="lang-ts">backgroundColor: {\n    image: &#39;xxx/xxx.png&#39;\n    // It can be URL of a image,\n    // or dataURI,\n    // or HTMLImageElement,\n    // or HTMLCanvasElement.\n}\n</code></pre>\n<p><code class="codespan">width</code> or <code class="codespan">height</code> can be specified when using background image, or\nauto adapted by default.</p>\n',
    )
    borderColor: Optional[Any] = Field(
        None, description='\n\n<p>Border color of the text fragment.</p>\n'
    )
    borderWidth: Optional[float] = Field(
        0, description='\n\n<p>Border width of the text fragment.</p>\n'
    )
    borderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>the text fragment border type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">borderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\nborderType: [5, 10],\n\nborderDashOffset: 5\n}\n</code></pre>\n',
    )
    borderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">borderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    borderRadius: Optional[float] = Field(
        0, description='\n\n<p>Border radius of the text fragment.</p>\n'
    )
    padding: Optional[Union[float, Any]] = Field(
        0,
        description='\n\n<p>Padding of the text fragment, for example:</p>\n<ul>\n<li><code class="codespan">padding: [3, 4, 5, 6]</code>: represents padding of <code class="codespan">[top, right, bottom, left]</code>.</li>\n<li><code class="codespan">padding: 4</code>: represents <code class="codespan">padding: [4, 4, 4, 4]</code>.</li>\n<li><code class="codespan">padding: [3, 4]</code>: represents <code class="codespan">padding: [3, 4, 3, 4]</code>.</li>\n</ul>\n<p>Notice, <code class="codespan">width</code> and <code class="codespan">height</code> specifies the width and height of the content, without <code class="codespan">padding</code>.</p>\n',
    )
    shadowColor: Optional[Any] = Field(
        'transparent', description='\n\n<p>Shadow color of the text block.</p>\n'
    )
    shadowBlur: Optional[float] = Field(
        0, description='\n\n<p>Show blur of the text block.</p>\n'
    )
    shadowOffsetX: Optional[float] = Field(
        0, description='\n\n<p>Shadow X offset of the text block.</p>\n'
    )
    shadowOffsetY: Optional[float] = Field(
        0, description='\n\n<p>Shadow Y offset of the text block.</p>\n'
    )
    width: Optional[float] = Field(
        None, description='\n\n<p>Width of text block.</p>\n'
    )
    height: Optional[float] = Field(
        None, description='\n\n<p>Height of text block.</p>\n'
    )
    textBorderColor: Optional[Any] = Field(
        None, description='\n\n<p>Stroke color of the text.</p>\n'
    )
    textBorderWidth: Optional[float] = Field(
        None, description='\n\n<p>Stroke line width of the text.</p>\n'
    )
    textBorderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>Stroke line type of the text.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">textBorderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\ntextBorderType: [5, 10],\n\ntextBorderDashOffset: 5\n}\n</code></pre>\n',
    )
    textBorderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">textBorderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    textShadowColor: Optional[Any] = Field(
        'transparent', description='\n\n<p>Shadow color of the text itself.</p>\n'
    )
    textShadowBlur: Optional[float] = Field(
        0, description='\n\n<p>Shadow blue of the text itself.</p>\n'
    )
    textShadowOffsetX: Optional[float] = Field(
        0, description='\n\n<p>Shadow X offset of the text itself.</p>\n'
    )
    textShadowOffsetY: Optional[float] = Field(
        0, description='\n\n<p>Shadow Y offset of the text itself.</p>\n'
    )
    overflow: Optional[str] = Field(
        'none',
        description='\n\n<p>Determine how to display the text when it&#39;s overflow. Available when <code class="codespan">width</code> is set.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the text and trailing with <code class="codespan">ellipsis</code>.</li>\n<li><code class="codespan">&#39;break&#39;</code> Break by word</li>\n<li><code class="codespan">&#39;breakAll&#39;</code> Break by character.</li>\n</ul>\n',
    )
    ellipsis: Optional[str] = Field(
        '...',
        description='<p>Ellipsis to be displayed when <code class="codespan">overflow</code> is set to <code class="codespan">truncate</code>.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the overflow lines.</li>\n</ul>\n',
    )
    rich: Optional[Rich5] = Field(
        None,
        description='<p>&quot;Rich text styles&quot; can be defined in this <code class="codespan">rich</code> property. For example:</p>\n<pre><code class="lang-ts">label: {\n    // Styles defined in &#39;rich&#39; can be applied to some fragments\n    // of text by adding some markers to those fragment, like\n    // `{styleName|text content text content}`.\n    // `&#39;\\n&#39;` is the newline character.\n    formatter: [\n        &#39;{a|Style &quot;a&quot; is applied to this snippet}&#39;\n        &#39;{b|Style &quot;b&quot; is applied to this snippet}This snippet use default style{x|use style &quot;x&quot;}&#39;\n    ].join(&#39;\\n&#39;),\n\n    rich: {\n        a: {\n            color: &#39;red&#39;,\n            lineHeight: 10\n        },\n        b: {\n            backgroundColor: {\n                image: &#39;xxx/xxx.jpg&#39;\n            },\n            height: 40\n        },\n        x: {\n            fontSize: 18,\n            fontFamily: &#39;Microsoft YaHei&#39;,\n            borderColor: &#39;#449933&#39;,\n            borderRadius: 4\n        },\n        ...\n    }\n}\n</code></pre>\n<p>For more details, see <a href="tutorial.html#Rich%20Text" target="_blank">Rich Text</a> please.</p>\n',
    )


class LineStyle3(BaseModel):
    color: Optional[Any] = Field(
        '#333',
        description='\n\n<p>line styleLine color. </p>\n<blockquote>\n<p>Supports setting as solid color using <code class="codespan">rgb(255,255,255)</code>, <code class="codespan">rgba(255,255,255,1)</code>, <code class="codespan">#fff</code>, etc. Also supports setting as gradient color and pattern fill, see <a href="#color">option.color</a> for details</p>\n</blockquote>\n',
    )
    width: Optional[float] = Field(1, description='\n\n<p>line style line width.</p>\n')
    type: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>line type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">dashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\ntype: [5, 10],\n\ndashOffset: 5\n}\n</code></pre>\n',
    )
    dashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">type</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    cap: Optional[str] = Field(
        'butt',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To specify how to draw the end points of the line.\nPossible values are:</p>\n<ul>\n<li><code class="codespan">&#39;butt&#39;</code>: The ends of lines are squared off at the endpoints.</li>\n<li><code class="codespan">&#39;round&#39;</code>: The ends of lines are rounded.</li>\n<li><code class="codespan">&#39;square&#39;</code>: The ends of lines are squared off by adding a box with an equal width and half the height of the line&#39;s thickness.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;butt&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineCap" target="_blank">lineCap</a> for more details.</p>\n',
    )
    join: Optional[str] = Field(
        'bevel',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To determine the shape used to join two line segments where they meet.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;bevel&#39;</code>: Fills an additional triangular area between the common endpoint of connected segments, and the separate outside rectangular corners of each segment.</li>\n<li><code class="codespan">&#39;round&#39;</code>: Rounds off the corners of a shape by filling an additional sector of disc centered at the common endpoint of connected segments. The radius for these rounded corners is equal to the line width.</li>\n<li><code class="codespan">&#39;miter&#39;</code>: Connected segments are joined by extending their outside edges to connect at a single point, with the effect of filling an additional lozenge-shaped area. This setting is affected by the \n<code class="codespan">miterLimit</code>\nproperty.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;bevel&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineJoin" target="_blank">lineJoin</a> for more details.</p>\n',
    )
    miterLimit: Optional[float] = Field(
        10,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the miter limit ratio. Only works when \n<code class="codespan">join</code>\n is set as <code class="codespan">miter</code>.</p>\n<p>Default value is <code class="codespan">10</code>. Negative、<code class="codespan">0</code>、<code class="codespan">Infinity</code> and <code class="codespan">NaN</code> values are ignored.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/miterLimit" target="_blank">miterLimit</a> for more details.</p>\n',
    )
    shadowBlur: Optional[float] = Field(
        None,
        description='\n\n<p>Size of shadow blur. This attribute should be used along with <code class="codespan">shadowColor</code>,<code class="codespan">shadowOffsetX</code>, <code class="codespan">shadowOffsetY</code> to set shadow to component.</p>\n<p>For example:</p>\n<pre><code class="lang-ts">{\n    shadowColor: &#39;rgba(0, 0, 0, 0.5)&#39;,\n    shadowBlur: 10\n}\n</code></pre>\n',
    )
    shadowColor: Optional[Any] = Field(
        None,
        description='\n\n<p>Shadow color. Support same format as <code class="codespan">color</code>.</p>\n',
    )
    shadowOffsetX: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the horizontal direction of shadow.</p>\n',
    )
    shadowOffsetY: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the vertical direction of shadow.</p>\n',
    )
    opacity: Optional[float] = Field(
        None,
        description='\n\n<p>Opacity of the component. Supports value from 0 to 1, and the component will not be drawn when set to 0.</p>\n',
    )


class AxisLine(BaseModel):
    """
    <p>Settings related to axis line.</p>

    """

    show: Optional[bool] = Field(
        True,
        description='\n\n<p>Set this to <code class="codespan">false</code> to prevent the axis line from showing.</p>\n',
    )
    onZero: Optional[bool] = Field(
        True,
        description='\n\n<p>Specifies whether X or Y axis lies on the other&#39;s origin position, where value is 0 on axis. Valid only if the other axis is of value type, and contains 0 value.</p>\n',
    )
    onZeroAxisIndex: Optional[float] = Field(
        None,
        description='<p>When mutiple axes exists, this option can be used to specify which axis can be &quot;onZero&quot; to.</p>\n',
    )
    symbol: Optional[Union[str, Any]] = Field(
        'none',
        description='\n\n<p>Symbol of the two ends of the axis. It could be a string, representing the same symbol for two ends; or an array with two string elements, representing the two ends separately. It&#39;s set to be <code class="codespan">&#39;none&#39;</code> by default, meaning no arrow for either end. If it is set to be <code class="codespan">&#39;arrow&#39;</code>, there shall be two arrows. If there should only one arrow at the end, it should set to be <code class="codespan">[&#39;none&#39;, &#39;arrow&#39;]</code>.</p>\n',
    )
    symbolSize: Optional[Any] = Field(
        '[10, 15]',
        description='\n\n<p>Size of the arrows at two ends. The first is the width perpendicular to the axis, the next is the width parallel to the axis.</p>\n',
    )
    symbolOffset: Optional[Union[Any, float]] = Field(
        '[0, 0]',
        description='\n\n<p>Arrow offset of axis. If is array, the first number is the offset of the arrow at the beginning, and the second number is the offset of the arrow at the end. If is number, it means the arrows have the same offset.</p>\n',
    )
    lineStyle: Optional[LineStyle3] = Field(None, description='')


class LineStyle4(BaseModel):
    """
    <p>Line style of axis ticks.</p>

    """

    color: Optional[Any] = Field(
        None,
        description='<p>Color of axis label is set to be <a href="#xAxis.axisLine.lineStyle.color">axisLine.lineStyle.color</a> by default.</p>\n',
    )
    width: Optional[float] = Field(1, description='\n\n<p>axisTick line width.</p>\n')
    type: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>line type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">dashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\ntype: [5, 10],\n\ndashOffset: 5\n}\n</code></pre>\n',
    )
    dashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">type</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    cap: Optional[str] = Field(
        'butt',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To specify how to draw the end points of the line.\nPossible values are:</p>\n<ul>\n<li><code class="codespan">&#39;butt&#39;</code>: The ends of lines are squared off at the endpoints.</li>\n<li><code class="codespan">&#39;round&#39;</code>: The ends of lines are rounded.</li>\n<li><code class="codespan">&#39;square&#39;</code>: The ends of lines are squared off by adding a box with an equal width and half the height of the line&#39;s thickness.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;butt&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineCap" target="_blank">lineCap</a> for more details.</p>\n',
    )
    join: Optional[str] = Field(
        'bevel',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To determine the shape used to join two line segments where they meet.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;bevel&#39;</code>: Fills an additional triangular area between the common endpoint of connected segments, and the separate outside rectangular corners of each segment.</li>\n<li><code class="codespan">&#39;round&#39;</code>: Rounds off the corners of a shape by filling an additional sector of disc centered at the common endpoint of connected segments. The radius for these rounded corners is equal to the line width.</li>\n<li><code class="codespan">&#39;miter&#39;</code>: Connected segments are joined by extending their outside edges to connect at a single point, with the effect of filling an additional lozenge-shaped area. This setting is affected by the \n<code class="codespan">miterLimit</code>\nproperty.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;bevel&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineJoin" target="_blank">lineJoin</a> for more details.</p>\n',
    )
    miterLimit: Optional[float] = Field(
        10,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the miter limit ratio. Only works when \n<code class="codespan">join</code>\n is set as <code class="codespan">miter</code>.</p>\n<p>Default value is <code class="codespan">10</code>. Negative、<code class="codespan">0</code>、<code class="codespan">Infinity</code> and <code class="codespan">NaN</code> values are ignored.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/miterLimit" target="_blank">miterLimit</a> for more details.</p>\n',
    )
    shadowBlur: Optional[float] = Field(
        None,
        description='\n\n<p>Size of shadow blur. This attribute should be used along with <code class="codespan">shadowColor</code>,<code class="codespan">shadowOffsetX</code>, <code class="codespan">shadowOffsetY</code> to set shadow to component.</p>\n<p>For example:</p>\n<pre><code class="lang-ts">{\n    shadowColor: &#39;rgba(0, 0, 0, 0.5)&#39;,\n    shadowBlur: 10\n}\n</code></pre>\n',
    )
    shadowColor: Optional[Any] = Field(
        None,
        description='\n\n<p>Shadow color. Support same format as <code class="codespan">color</code>.</p>\n',
    )
    shadowOffsetX: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the horizontal direction of shadow.</p>\n',
    )
    shadowOffsetY: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the vertical direction of shadow.</p>\n',
    )
    opacity: Optional[float] = Field(
        None,
        description='\n\n<p>Opacity of the component. Supports value from 0 to 1, and the component will not be drawn when set to 0.</p>\n\n',
    )


class AxisTick(BaseModel):
    """
    <p>Settings related to axis tick.</p>

    """

    show: Optional[bool] = Field(
        True,
        description='\n\n<p>Set this to <code class="codespan">false</code> to prevent the axis tick from showing.</p>\n',
    )
    alignWithLabel: Optional[bool] = Field(
        False,
        description='\n\n<p>Align axis tick with label, which is available only when <code class="codespan">boundaryGap</code> is set to be <code class="codespan">true</code> in category axis. See the following picture:</p>\n<p><img width="600" height="auto" src="documents/asset/img/axis-align-with-label.png"></p>\n',
    )
    interval: Optional[Union[float, Any]] = Field(
        'auto',
        description='\n\n\n\n<p>Interval of axisTick, which is available in category axis.  is set to be the same as <a href="#xAxis.axisLabel.interval">axisLabel.interval</a> by default.</p>\n<p>It uses a strategy that labels do not overlap by default.</p>\n<p>You may set it to be 0 to display all labels compulsively.</p>\n<p>If it is set to be 1, it means that labels are shown once after one label. And if it is set to be 2, it means labels are shown once after two labels, and so on.</p>\n<p>On the other hand, you can control by callback function, whose format is shown below:</p>\n<pre><code class="lang-ts">(index:number, value: string) =&gt; boolean\n</code></pre>\n<p>The first parameter is index of category, and the second parameter is the name of category. The return values decides whether to display label.</p>\n',
    )
    inside: Optional[bool] = Field(
        False,
        description='\n\n<p>Set this to <code class="codespan">true</code> so the axis labels face the <code class="codespan">inside</code> direction.</p>\n',
    )
    length: Optional[float] = Field(
        5, description='\n\n<p>The length of the axis tick.</p>\n'
    )
    lineStyle: Optional[LineStyle4] = Field(
        None, description='<p>Line style of axis ticks.</p>\n'
    )


class LineStyle5(BaseModel):
    color: Optional[Any] = Field(
        None,
        description='\n\n<p>Style configuration of minor ticks lines <a href="#xAxis.axisLine.lineStyle.color">axisLine.lineStyle.color</a>。</p>\n',
    )
    width: Optional[float] = Field(1, description='\n\n<p>minorTick line width.</p>\n')
    type: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>line type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">dashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\ntype: [5, 10],\n\ndashOffset: 5\n}\n</code></pre>\n',
    )
    dashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">type</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    cap: Optional[str] = Field(
        'butt',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To specify how to draw the end points of the line.\nPossible values are:</p>\n<ul>\n<li><code class="codespan">&#39;butt&#39;</code>: The ends of lines are squared off at the endpoints.</li>\n<li><code class="codespan">&#39;round&#39;</code>: The ends of lines are rounded.</li>\n<li><code class="codespan">&#39;square&#39;</code>: The ends of lines are squared off by adding a box with an equal width and half the height of the line&#39;s thickness.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;butt&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineCap" target="_blank">lineCap</a> for more details.</p>\n',
    )
    join: Optional[str] = Field(
        'bevel',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To determine the shape used to join two line segments where they meet.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;bevel&#39;</code>: Fills an additional triangular area between the common endpoint of connected segments, and the separate outside rectangular corners of each segment.</li>\n<li><code class="codespan">&#39;round&#39;</code>: Rounds off the corners of a shape by filling an additional sector of disc centered at the common endpoint of connected segments. The radius for these rounded corners is equal to the line width.</li>\n<li><code class="codespan">&#39;miter&#39;</code>: Connected segments are joined by extending their outside edges to connect at a single point, with the effect of filling an additional lozenge-shaped area. This setting is affected by the \n<code class="codespan">miterLimit</code>\nproperty.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;bevel&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineJoin" target="_blank">lineJoin</a> for more details.</p>\n',
    )
    miterLimit: Optional[float] = Field(
        10,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the miter limit ratio. Only works when \n<code class="codespan">join</code>\n is set as <code class="codespan">miter</code>.</p>\n<p>Default value is <code class="codespan">10</code>. Negative、<code class="codespan">0</code>、<code class="codespan">Infinity</code> and <code class="codespan">NaN</code> values are ignored.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/miterLimit" target="_blank">miterLimit</a> for more details.</p>\n',
    )
    shadowBlur: Optional[float] = Field(
        None,
        description='\n\n<p>Size of shadow blur. This attribute should be used along with <code class="codespan">shadowColor</code>,<code class="codespan">shadowOffsetX</code>, <code class="codespan">shadowOffsetY</code> to set shadow to component.</p>\n<p>For example:</p>\n<pre><code class="lang-ts">{\n    shadowColor: &#39;rgba(0, 0, 0, 0.5)&#39;,\n    shadowBlur: 10\n}\n</code></pre>\n',
    )
    shadowColor: Optional[Any] = Field(
        None,
        description='\n\n<p>Shadow color. Support same format as <code class="codespan">color</code>.</p>\n',
    )
    shadowOffsetX: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the horizontal direction of shadow.</p>\n',
    )
    shadowOffsetY: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the vertical direction of shadow.</p>\n',
    )
    opacity: Optional[float] = Field(
        None,
        description='\n\n<p>Opacity of the component. Supports value from 0 to 1, and the component will not be drawn when set to 0.</p>\n\n',
    )


class MinorTick(BaseModel):
    """
        <blockquote>
    <p>Since <code class="codespan">v4.6.0</code></p>
    </blockquote>
    <p>Settings related minor ticks.</p>
    <p>Note: <code class="codespan">minorTick</code> is not available in the <code class="codespan">category</code> type axis.</p>
    <p>Examples:</p>
    <p>1) Using minor ticks in function plotting.</p>
    <iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=line-function&edit=1&reset=1" width="600" height="350"></iframe>


    <p>2) Using minor ticks in log axis.</p>
    <iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=line-log&edit=1&reset=1" width="600" height="350"></iframe>


    """

    show: Optional[bool] = Field(False, description='\n\n<p>If show minor ticks.</p>\n')
    splitNumber: Optional[float] = Field(
        5, description='\n\n<p>Number of interval splited by minor ticks.</p>\n'
    )
    length: Optional[float] = Field(
        3, description='\n\n<p>Length of minor ticks lines。</p>\n'
    )
    lineStyle: Optional[LineStyle5] = Field(None, description='')


class _StyleName6(_StyleName5):
    pass


class Rich6(BaseModel):
    """
        <p>&quot;Rich text styles&quot; can be defined in this <code class="codespan">rich</code> property. For example:</p>
    <pre><code class="lang-ts">label: {
        // Styles defined in &#39;rich&#39; can be applied to some fragments
        // of text by adding some markers to those fragment, like
        // `{styleName|text content text content}`.
        // `&#39;\n&#39;` is the newline character.
        formatter: [
            &#39;{a|Style &quot;a&quot; is applied to this snippet}&#39;
            &#39;{b|Style &quot;b&quot; is applied to this snippet}This snippet use default style{x|use style &quot;x&quot;}&#39;
        ].join(&#39;\n&#39;),

        rich: {
            a: {
                color: &#39;red&#39;,
                lineHeight: 10
            },
            b: {
                backgroundColor: {
                    image: &#39;xxx/xxx.jpg&#39;
                },
                height: 40
            },
            x: {
                fontSize: 18,
                fontFamily: &#39;Microsoft YaHei&#39;,
                borderColor: &#39;#449933&#39;,
                borderRadius: 4
            },
            ...
        }
    }
    </code></pre>
    <p>For more details, see <a href="tutorial.html#Rich%20Text" target="_blank">Rich Text</a> please.</p>

    """

    _style_name_: Optional[_StyleName6] = Field(
        None, alias='<style_name>', description=''
    )


class AxisLabel(BaseModel):
    """
    <p>Settings related to axis label.</p>

    """

    show: Optional[bool] = Field(
        True,
        description='\n\n<p>Set this to <code class="codespan">false</code> to prevent the axis label from appearing.</p>\n',
    )
    interval: Optional[Union[float, Any]] = Field(
        'auto',
        description='\n\n\n\n<p>Interval of Axis label, which is available in category axis. </p>\n<p>It uses a strategy that labels do not overlap by default.</p>\n<p>You may set it to be 0 to display all labels compulsively.</p>\n<p>If it is set to be 1, it means that labels are shown once after one label. And if it is set to be 2, it means labels are shown once after two labels, and so on.</p>\n<p>On the other hand, you can control by callback function, whose format is shown below:</p>\n<pre><code class="lang-ts">(index:number, value: string) =&gt; boolean\n</code></pre>\n<p>The first parameter is index of category, and the second parameter is the name of category. The return values decides whether to display label.</p>\n',
    )
    inside: Optional[bool] = Field(
        False,
        description='\n\n<p>Set this to <code class="codespan">true</code> so the axis labels face the <code class="codespan">inside</code> direction.</p>\n',
    )
    rotate: Optional[float] = Field(
        0,
        description='\n\n<p>Rotation degree of axis label, which is especially useful when there is no enough space for category axis.</p>\n<p>Rotation degree is from -90 to 90.</p>\n',
    )
    margin: Optional[float] = Field(
        8,
        description='\n\n<p>The margin between the axis label and the axis line.</p>\n',
    )
    formatter: Optional[Union[str, Any]] = Field(
        None,
        description='<p>Formatter of axis label, which supports string template and callback function.</p>\n<p>Example:</p>\n<pre><code class="lang-ts">// Use string template; template variable is the default label of axis {value}\nformatter: &#39;{value} kg&#39;\n// Use callback.\nformatter: function (value, index) {\n    return value + &#39;kg&#39;;\n}\n</code></pre>\n<hr>\n<p>For axes of time <a href="#.type">type</a>: <code class="codespan">&#39;time&#39;</code>, <code class="codespan">formatter</code> supports the following forms:</p>\n<ul>\n<li><strong>String Templates</strong>: an easy and fast way to make frequently used date/time template, formed in <code class="codespan">string</code></li>\n<li><strong>Callback Functions</strong>: customized formatter to make complex format, formed in <code class="codespan">Function</code></li>\n<li><strong>Cascading Templates</strong>: to adopt different formatters for different time granularity, formed in <code class="codespan">object</code></li>\n</ul>\n<p>Next, we are going to introduce these three forms one by one.</p>\n<p><strong> String Templates </strong></p>\n<p>Using string templates is an easy way to format date/time with frequently used formats. If it can be used to make what you want, you are advised to do so. If not, you could then consider the others. Supported formats are:</p>\n<table>\n<thead>\n<tr>\n<th>Group</th>\n<th>Template</th>\n<th>Value (EN)</th>\n<th>Value (ZH)</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n<td>Year</td>\n<td>{yyyy}</td>\n<td>e.g., 2020, 2021, ...</td>\n<td>例：2020, 2021, ...</td>\n</tr>\n<tr>\n<td></td>\n<td>{yy}</td>\n<td>00-99</td>\n<td>00-99</td>\n</tr>\n<tr>\n<td>Quarter</td>\n<td>{Q}</td>\n<td>1, 2, 3, 4</td>\n<td>1, 2, 3, 4</td>\n</tr>\n<tr>\n<td>Month</td>\n<td>{MMMM}</td>\n<td>e.g., January, February, ...</td>\n<td>一月、二月、……</td>\n</tr>\n<tr>\n<td></td>\n<td>{MMM}</td>\n<td>e.g., Jan, Feb, ...</td>\n<td>1月、2月、……</td>\n</tr>\n<tr>\n<td></td>\n<td>{MM}</td>\n<td>01-12</td>\n<td>01-12</td>\n</tr>\n<tr>\n<td></td>\n<td>{M}</td>\n<td>1-12</td>\n<td>1-12</td>\n</tr>\n<tr>\n<td>Day of Month</td>\n<td>{dd}</td>\n<td>01-31</td>\n<td>01-31</td>\n</tr>\n<tr>\n<td></td>\n<td>{d}</td>\n<td>1-31</td>\n<td>1-31</td>\n</tr>\n<tr>\n<td>Day of Week</td>\n<td>{eeee}</td>\n<td>Sunday, Monday, Tuesday, Wednesday, Thursday, Friday, Saturday</td>\n<td>星期日、星期一、星期二、星期三、星期四、星期五、星期六</td>\n</tr>\n<tr>\n<td></td>\n<td>{ee}</td>\n<td>Sun, Mon, Tues, Wed, Thu, Fri, Sat</td>\n<td>日、一、二、三、四、五、六</td>\n</tr>\n<tr>\n<td></td>\n<td>{e}</td>\n<td>1-54</td>\n<td>1-54</td>\n</tr>\n<tr>\n<td>Hour</td>\n<td>{HH}</td>\n<td>00-23</td>\n<td>00-23</td>\n</tr>\n<tr>\n<td></td>\n<td>{H}</td>\n<td>0-23</td>\n<td>0-23</td>\n</tr>\n<tr>\n<td></td>\n<td>{hh}</td>\n<td>01-12</td>\n<td>01-12</td>\n</tr>\n<tr>\n<td></td>\n<td>{h}</td>\n<td>1-12</td>\n<td>1-12</td>\n</tr>\n<tr>\n<td>Minute</td>\n<td>{mm}</td>\n<td>00-59</td>\n<td>00-59</td>\n</tr>\n<tr>\n<td></td>\n<td>{m}</td>\n<td>0-59</td>\n<td>0-59</td>\n</tr>\n<tr>\n<td>Second</td>\n<td>{ss}</td>\n<td>00-59</td>\n<td>00-59</td>\n</tr>\n<tr>\n<td></td>\n<td>{s}</td>\n<td>0-59</td>\n<td>0-59</td>\n</tr>\n<tr>\n<td>Millisecond</td>\n<td>{SSS}</td>\n<td>000-999</td>\n<td>000-999</td>\n</tr>\n<tr>\n<td></td>\n<td>{S}</td>\n<td>0-999</td>\n<td>0-999</td>\n</tr>\n</tbody>\n</table>\n<blockquote>\n<p>Templates of other languages can be found in <a href="https://github.com/apache/echarts/tree/master/src/i18n" target="_blank">the language package</a>. Please refer to <a href="api.html#echarts.registerLocale" target="_blank">echarts.registerLocale</a> to register a language.</p>\n</blockquote>\n<p>Example:</p>\n<pre><code class="lang-ts">formatter: &#39;{yyyy}-{MM}-{dd}&#39; // gets labels like &#39;2020-12-02&#39;\nformatter: &#39;Day {d}&#39; // gets labels like &#39;Day 2&#39;\n</code></pre>\n<p><strong> Callback Functions </strong></p>\n<p>Callback functions can be used to get different formats for different axis tick values. Sometimes, if you have complex date/time formatting requirement, third-party libraries like <a href="https://momentjs.com/" target="_blank">Moment.js</a> or <a href="https://date-fns.org/" target="_blank">date-fns</a> can be used to return formatted labels.</p>\n<p>Example:</p>\n<pre><code class="lang-ts">// Use callback function; function parameters are axis index\nformatter: function (value, index) {\n    // Formatted to be month/day; display year only in the first label\n    var date = new Date(value);\n    var texts = [(date.getMonth() + 1), date.getDate()];\n    if (index === 0) {\n        texts.unshift(date.getYear());\n    }\n    return texts.join(&#39;/&#39;);\n}\n</code></pre>\n<p><strong> Cascading Templates </strong></p>\n<p>Sometimes, we wish to use different formats for different time granularity. For example, in a quarter-year chart, we may wish to see the month name with the first date of the month, while see the date name with others. This can be made with:</p>\n<p>Example:</p>\n<pre><code class="lang-ts">formatter: {\n    month: &#39;{MMMM}&#39;, // Jan, Feb, ...\n    day: &#39;{d}&#39; // 1, 2, ...\n}\n</code></pre>\n<p>Supported levels and their default formatters are:</p>\n<pre><code class="lang-ts">{\n    year: &#39;{yyyy}&#39;,\n    month: &#39;{MMM}&#39;,\n    day: &#39;{d}&#39;,\n    hour: &#39;{HH}:{mm}&#39;,\n    minute: &#39;{HH}:{mm}&#39;,\n    second: &#39;{HH}:{mm}:{ss}&#39;,\n    millisecond: &#39;{hh}:{mm}:{ss} {SSS}&#39;,\n    none: &#39;{yyyy}-{MM}-{dd} {hh}:{mm}:{ss} {SSS}&#39;\n}\n</code></pre>\n<p>Let&#39;s take <code class="codespan">day</code> for example. When a tick value is <code class="codespan">0</code> for its hour, minute, second, and millisecond, <code class="codespan">day</code> level will be used to make formatter. <code class="codespan">none</code> is used when no other level fulfills, which is for tick values with millisecond values other than <code class="codespan">0</code>.</p>\n<p><strong> Rich Text </strong></p>\n<p>The above three forms all support rich text, so it can be used to make some complex effects.</p>\n<p>Example:</p>\n<pre><code class="lang-ts">xAxis: {\n    type: &#39;time&#39;,\n    axisLabel: {\n        formatter: {\n            // Display year and month information on the first data of a year\n            year: &#39;{yearStyle|{yyyy}}\\n{monthStyle|{MMM}}&#39;,\n            month: &#39;{monthStyle|{MMM}}&#39;\n        },\n        rich: {\n            yearStyle: {\n                // Make yearly text more standing out\n                color: &#39;#000&#39;,\n                fontWeight: &#39;bold&#39;\n            },\n            monthStyle: {\n                color: &#39;#999&#39;\n            }\n        }\n    }\n},\n</code></pre>\n<p>The above example can also be made with a callback function:</p>\n<p>Example:</p>\n<pre><code class="lang-ts">xAxis: {\n    type: &#39;time&#39;,\n    axisLabel: {\n        formatter: function (value) {\n            const date = new Date(value);\n            const yearStart = new Date(value);\n            yearStart.setMonth(0);\n            yearStart.setDate(1);\n            yearStart.setHours(0);\n            yearStart.setMinutes(0);\n            yearStart.setSeconds(0);\n            yearStart.setMilliseconds(0);\n            // Whether a tick value is the start of a year\n            if (date.getTime() === yearStart.getTime()) {\n                return &#39;{year|&#39; + date.getFullYear() + &#39;}\\n&#39;\n                    + &#39;{month|&#39; + (date.getMonth() + 1) + &#39;月}&#39;;\n            }\n            else {\n                return &#39;{month|&#39; + (date.getMonth() + 1) + &#39;月}&#39;\n            }\n        },\n        rich: {\n            year: {\n                color: &#39;#000&#39;,\n                fontWeight: &#39;bold&#39;\n            },\n            month: {\n                color: &#39;#999&#39;\n            }\n        }\n    }\n},\n</code></pre>\n',
    )
    showMinLabel: Optional[bool] = Field(
        None,
        description='\n\n<p>Whether to show the label of the min tick. Optional values: <code class="codespan">true</code>, <code class="codespan">false</code>, <code class="codespan">null</code>. It is auto determined by default, that is, if labels are overlapped, the label of the min tick will not be displayed.</p>\n',
    )
    showMaxLabel: Optional[bool] = Field(
        None,
        description='\n\n<p>Whether to show the label of the max tick. Optional values: <code class="codespan">true</code>, <code class="codespan">false</code>, <code class="codespan">null</code>. It is auto determined by default, that is, if labels are overlapped, the label of the max tick will not be displayed.</p>\n',
    )
    hideOverlap: Optional[bool] = Field(
        None,
        description='\n\n\n\n<blockquote>\n<p>Since <code class="codespan">v5.2.0</code></p>\n</blockquote>\n<p>Whether to hide overlapped labels.</p>\n',
    )
    color: Optional[Union[Any, Any]] = Field(
        None,
        description='\n\n<p>Color of axis label is set to be <a href="#xAxis.axisLine.lineStyle.color">axisLine.lineStyle.color</a> by default. Callback function is supported, in the following format:</p>\n<pre><code class="lang-ts">(val: string) =&gt; Color\n</code></pre>\n<p>Parameter is the text of label, and return value is the color. See the following example:</p>\n<pre><code class="lang-ts">textStyle: {\n    color: function (value, index) {\n        return value &gt;= 0 ? &#39;green&#39; : &#39;red&#39;;\n    }\n}\n</code></pre>\n',
    )
    fontStyle: Optional[str] = Field(
        'normal',
        description='\n\n<p> font style.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;italic&#39;</code></li>\n<li><code class="codespan">&#39;oblique&#39;</code></li>\n</ul>\n',
    )
    fontWeight: Optional[Union[str, float]] = Field(
        'normal',
        description='\n\n<p> font thick weight.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;bold&#39;</code></li>\n<li><code class="codespan">&#39;bolder&#39;</code></li>\n<li><code class="codespan">&#39;lighter&#39;</code></li>\n<li>100 | 200 | 300 | 400...</li>\n</ul>\n',
    )
    fontFamily: Optional[str] = Field(
        'sans-serif',
        description='\n\n<p> font family.</p>\n<p>Can also be &#39;serif&#39; , &#39;monospace&#39;, ...</p>\n',
    )
    fontSize: Optional[float] = Field(12, description='\n\n<p> font size.</p>\n')
    align: Optional[str] = Field(
        None,
        description='\n\n<p>Horizontal alignment of text, automatic by default.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;left&#39;</code></li>\n<li><code class="codespan">&#39;center&#39;</code></li>\n<li><code class="codespan">&#39;right&#39;</code></li>\n</ul>\n<p>If <code class="codespan">align</code> is not set in <code class="codespan">rich</code>, <code class="codespan">align</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    align: right,\n    rich: {\n        a: {\n            // `align` is not set, then it will be right\n        }\n    }\n}\n</code></pre>\n',
    )
    verticalAlign: Optional[str] = Field(
        None,
        description='\n\n<p>Vertical alignment of text, automatic by default.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;top&#39;</code></li>\n<li><code class="codespan">&#39;middle&#39;</code></li>\n<li><code class="codespan">&#39;bottom&#39;</code></li>\n</ul>\n<p>If <code class="codespan">verticalAlign</code> is not set in <code class="codespan">rich</code>, <code class="codespan">verticalAlign</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    verticalAlign: bottom,\n    rich: {\n        a: {\n            // `verticalAlign` is not set, then it will be bottom\n        }\n    }\n}\n</code></pre>\n',
    )
    lineHeight: Optional[float] = Field(
        None,
        description='\n\n<p>Line height of the text fragment.</p>\n<p>If <code class="codespan">lineHeight</code> is not set in <code class="codespan">rich</code>, <code class="codespan">lineHeight</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    lineHeight: 56,\n    rich: {\n        a: {\n            // `lineHeight` is not set, then it will be 56\n        }\n    }\n}\n</code></pre>\n',
    )
    backgroundColor: Optional[Union[str, Any]] = Field(
        'transparent',
        description='\n\n<p>Background color of the text fragment.</p>\n<p>Can be color string, like <code class="codespan">&#39;#123234&#39;</code>, <code class="codespan">&#39;red&#39;</code>, <code class="codespan">&#39;rgba(0,23,11,0.3)&#39;</code>.</p>\n<p>Or image can be used, for example:</p>\n<pre><code class="lang-ts">backgroundColor: {\n    image: &#39;xxx/xxx.png&#39;\n    // It can be URL of a image,\n    // or dataURI,\n    // or HTMLImageElement,\n    // or HTMLCanvasElement.\n}\n</code></pre>\n<p><code class="codespan">width</code> or <code class="codespan">height</code> can be specified when using background image, or\nauto adapted by default.</p>\n',
    )
    borderColor: Optional[Any] = Field(
        None, description='\n\n<p>Border color of the text fragment.</p>\n'
    )
    borderWidth: Optional[float] = Field(
        0, description='\n\n<p>Border width of the text fragment.</p>\n'
    )
    borderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>the text fragment border type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">borderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\nborderType: [5, 10],\n\nborderDashOffset: 5\n}\n</code></pre>\n',
    )
    borderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">borderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    borderRadius: Optional[float] = Field(
        0, description='\n\n<p>Border radius of the text fragment.</p>\n'
    )
    padding: Optional[Union[float, Any]] = Field(
        0,
        description='\n\n<p>Padding of the text fragment, for example:</p>\n<ul>\n<li><code class="codespan">padding: [3, 4, 5, 6]</code>: represents padding of <code class="codespan">[top, right, bottom, left]</code>.</li>\n<li><code class="codespan">padding: 4</code>: represents <code class="codespan">padding: [4, 4, 4, 4]</code>.</li>\n<li><code class="codespan">padding: [3, 4]</code>: represents <code class="codespan">padding: [3, 4, 3, 4]</code>.</li>\n</ul>\n<p>Notice, <code class="codespan">width</code> and <code class="codespan">height</code> specifies the width and height of the content, without <code class="codespan">padding</code>.</p>\n',
    )
    shadowColor: Optional[Any] = Field(
        'transparent', description='\n\n<p>Shadow color of the text block.</p>\n'
    )
    shadowBlur: Optional[float] = Field(
        0, description='\n\n<p>Show blur of the text block.</p>\n'
    )
    shadowOffsetX: Optional[float] = Field(
        0, description='\n\n<p>Shadow X offset of the text block.</p>\n'
    )
    shadowOffsetY: Optional[float] = Field(
        0, description='\n\n<p>Shadow Y offset of the text block.</p>\n'
    )
    width: Optional[float] = Field(
        None, description='\n\n<p>Width of text block.</p>\n'
    )
    height: Optional[float] = Field(
        None, description='\n\n<p>Height of text block.</p>\n'
    )
    textBorderColor: Optional[Any] = Field(
        None, description='\n\n<p>Stroke color of the text.</p>\n'
    )
    textBorderWidth: Optional[float] = Field(
        None, description='\n\n<p>Stroke line width of the text.</p>\n'
    )
    textBorderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>Stroke line type of the text.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">textBorderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\ntextBorderType: [5, 10],\n\ntextBorderDashOffset: 5\n}\n</code></pre>\n',
    )
    textBorderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">textBorderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    textShadowColor: Optional[Any] = Field(
        'transparent', description='\n\n<p>Shadow color of the text itself.</p>\n'
    )
    textShadowBlur: Optional[float] = Field(
        0, description='\n\n<p>Shadow blue of the text itself.</p>\n'
    )
    textShadowOffsetX: Optional[float] = Field(
        0, description='\n\n<p>Shadow X offset of the text itself.</p>\n'
    )
    textShadowOffsetY: Optional[float] = Field(
        0, description='\n\n<p>Shadow Y offset of the text itself.</p>\n'
    )
    overflow: Optional[str] = Field(
        'none',
        description='\n\n<p>Determine how to display the text when it&#39;s overflow. Available when <code class="codespan">width</code> is set.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the text and trailing with <code class="codespan">ellipsis</code>.</li>\n<li><code class="codespan">&#39;break&#39;</code> Break by word</li>\n<li><code class="codespan">&#39;breakAll&#39;</code> Break by character.</li>\n</ul>\n',
    )
    ellipsis: Optional[str] = Field(
        '...',
        description='<p>Ellipsis to be displayed when <code class="codespan">overflow</code> is set to <code class="codespan">truncate</code>.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the overflow lines.</li>\n</ul>\n',
    )
    rich: Optional[Rich6] = Field(
        None,
        description='<p>&quot;Rich text styles&quot; can be defined in this <code class="codespan">rich</code> property. For example:</p>\n<pre><code class="lang-ts">label: {\n    // Styles defined in &#39;rich&#39; can be applied to some fragments\n    // of text by adding some markers to those fragment, like\n    // `{styleName|text content text content}`.\n    // `&#39;\\n&#39;` is the newline character.\n    formatter: [\n        &#39;{a|Style &quot;a&quot; is applied to this snippet}&#39;\n        &#39;{b|Style &quot;b&quot; is applied to this snippet}This snippet use default style{x|use style &quot;x&quot;}&#39;\n    ].join(&#39;\\n&#39;),\n\n    rich: {\n        a: {\n            color: &#39;red&#39;,\n            lineHeight: 10\n        },\n        b: {\n            backgroundColor: {\n                image: &#39;xxx/xxx.jpg&#39;\n            },\n            height: 40\n        },\n        x: {\n            fontSize: 18,\n            fontFamily: &#39;Microsoft YaHei&#39;,\n            borderColor: &#39;#449933&#39;,\n            borderRadius: 4\n        },\n        ...\n    }\n}\n</code></pre>\n<p>For more details, see <a href="tutorial.html#Rich%20Text" target="_blank">Rich Text</a> please.</p>\n',
    )


class LineStyle6(BaseModel):
    color: Optional[Union[Any, str]] = Field(
        "['#ccc']",
        description='\n\n<p>The color of the splitLine, which could be set separately.</p>\n<p>SplitLine color could also be set in color array, which the split lines would take as their colors in turns.</p>\n<p>Example:</p>\n<pre><code>splitLine: {\n    lineStyle: {\n        // Dark and light colors will be used in turns\n        color: [&#39;#aaa&#39;, &#39;#ddd&#39;]\n    }\n}\n</code></pre>',
    )
    width: Optional[float] = Field(1, description='\n\n<p>splitLine line width.</p>\n')
    type: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>line type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">dashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\ntype: [5, 10],\n\ndashOffset: 5\n}\n</code></pre>\n',
    )
    dashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">type</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    cap: Optional[str] = Field(
        'butt',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To specify how to draw the end points of the line.\nPossible values are:</p>\n<ul>\n<li><code class="codespan">&#39;butt&#39;</code>: The ends of lines are squared off at the endpoints.</li>\n<li><code class="codespan">&#39;round&#39;</code>: The ends of lines are rounded.</li>\n<li><code class="codespan">&#39;square&#39;</code>: The ends of lines are squared off by adding a box with an equal width and half the height of the line&#39;s thickness.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;butt&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineCap" target="_blank">lineCap</a> for more details.</p>\n',
    )
    join: Optional[str] = Field(
        'bevel',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To determine the shape used to join two line segments where they meet.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;bevel&#39;</code>: Fills an additional triangular area between the common endpoint of connected segments, and the separate outside rectangular corners of each segment.</li>\n<li><code class="codespan">&#39;round&#39;</code>: Rounds off the corners of a shape by filling an additional sector of disc centered at the common endpoint of connected segments. The radius for these rounded corners is equal to the line width.</li>\n<li><code class="codespan">&#39;miter&#39;</code>: Connected segments are joined by extending their outside edges to connect at a single point, with the effect of filling an additional lozenge-shaped area. This setting is affected by the \n<code class="codespan">miterLimit</code>\nproperty.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;bevel&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineJoin" target="_blank">lineJoin</a> for more details.</p>\n',
    )
    miterLimit: Optional[float] = Field(
        10,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the miter limit ratio. Only works when \n<code class="codespan">join</code>\n is set as <code class="codespan">miter</code>.</p>\n<p>Default value is <code class="codespan">10</code>. Negative、<code class="codespan">0</code>、<code class="codespan">Infinity</code> and <code class="codespan">NaN</code> values are ignored.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/miterLimit" target="_blank">miterLimit</a> for more details.</p>\n',
    )
    shadowBlur: Optional[float] = Field(
        None,
        description='\n\n<p>Size of shadow blur. This attribute should be used along with <code class="codespan">shadowColor</code>,<code class="codespan">shadowOffsetX</code>, <code class="codespan">shadowOffsetY</code> to set shadow to component.</p>\n<p>For example:</p>\n<pre><code class="lang-ts">{\n    shadowColor: &#39;rgba(0, 0, 0, 0.5)&#39;,\n    shadowBlur: 10\n}\n</code></pre>\n',
    )
    shadowColor: Optional[Any] = Field(
        None,
        description='\n\n<p>Shadow color. Support same format as <code class="codespan">color</code>.</p>\n',
    )
    shadowOffsetX: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the horizontal direction of shadow.</p>\n',
    )
    shadowOffsetY: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the vertical direction of shadow.</p>\n',
    )
    opacity: Optional[float] = Field(
        None,
        description='\n\n<p>Opacity of the component. Supports value from 0 to 1, and the component will not be drawn when set to 0.</p>\n\n',
    )


class SplitLine(BaseModel):
    """
    <p>Split line of axis in <a href="#grid">grid</a> area.</p>

    """

    show: Optional[bool] = Field(
        True,
        description='\n\n<p>Set this to <code class="codespan">false</code> to prevent the splitLine from showing.\n<code class="codespan">value</code> type axes are shown by default, while <code class="codespan">category</code> type axes are hidden.</p>\n',
    )
    interval: Optional[Union[float, Any]] = Field(
        'auto',
        description='\n\n\n\n<p>Interval of Axis splitLine, which is available in category axis.  is set to be the same as <a href="#xAxis.axisLabel.interval">axisLabel.interval</a> by default.</p>\n<p>It uses a strategy that labels do not overlap by default.</p>\n<p>You may set it to be 0 to display all labels compulsively.</p>\n<p>If it is set to be 1, it means that labels are shown once after one label. And if it is set to be 2, it means labels are shown once after two labels, and so on.</p>\n<p>On the other hand, you can control by callback function, whose format is shown below:</p>\n<pre><code class="lang-ts">(index:number, value: string) =&gt; boolean\n</code></pre>\n<p>The first parameter is index of category, and the second parameter is the name of category. The return values decides whether to display label.</p>\n',
    )
    lineStyle: Optional[LineStyle6] = Field(None, description='')


class LineStyle7(BaseModel):
    color: Optional[Any] = Field(
        '#eee',
        description='\n\n<p>minorSplitLineLine color. </p>\n<blockquote>\n<p>Supports setting as solid color using <code class="codespan">rgb(255,255,255)</code>, <code class="codespan">rgba(255,255,255,1)</code>, <code class="codespan">#fff</code>, etc. Also supports setting as gradient color and pattern fill, see <a href="#color">option.color</a> for details</p>\n</blockquote>\n',
    )
    width: Optional[float] = Field(
        1, description='\n\n<p>minorSplitLine line width.</p>\n'
    )
    type: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>line type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">dashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\ntype: [5, 10],\n\ndashOffset: 5\n}\n</code></pre>\n',
    )
    dashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">type</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    cap: Optional[str] = Field(
        'butt',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To specify how to draw the end points of the line.\nPossible values are:</p>\n<ul>\n<li><code class="codespan">&#39;butt&#39;</code>: The ends of lines are squared off at the endpoints.</li>\n<li><code class="codespan">&#39;round&#39;</code>: The ends of lines are rounded.</li>\n<li><code class="codespan">&#39;square&#39;</code>: The ends of lines are squared off by adding a box with an equal width and half the height of the line&#39;s thickness.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;butt&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineCap" target="_blank">lineCap</a> for more details.</p>\n',
    )
    join: Optional[str] = Field(
        'bevel',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To determine the shape used to join two line segments where they meet.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;bevel&#39;</code>: Fills an additional triangular area between the common endpoint of connected segments, and the separate outside rectangular corners of each segment.</li>\n<li><code class="codespan">&#39;round&#39;</code>: Rounds off the corners of a shape by filling an additional sector of disc centered at the common endpoint of connected segments. The radius for these rounded corners is equal to the line width.</li>\n<li><code class="codespan">&#39;miter&#39;</code>: Connected segments are joined by extending their outside edges to connect at a single point, with the effect of filling an additional lozenge-shaped area. This setting is affected by the \n<code class="codespan">miterLimit</code>\nproperty.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;bevel&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineJoin" target="_blank">lineJoin</a> for more details.</p>\n',
    )
    miterLimit: Optional[float] = Field(
        10,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the miter limit ratio. Only works when \n<code class="codespan">join</code>\n is set as <code class="codespan">miter</code>.</p>\n<p>Default value is <code class="codespan">10</code>. Negative、<code class="codespan">0</code>、<code class="codespan">Infinity</code> and <code class="codespan">NaN</code> values are ignored.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/miterLimit" target="_blank">miterLimit</a> for more details.</p>\n',
    )
    shadowBlur: Optional[float] = Field(
        None,
        description='\n\n<p>Size of shadow blur. This attribute should be used along with <code class="codespan">shadowColor</code>,<code class="codespan">shadowOffsetX</code>, <code class="codespan">shadowOffsetY</code> to set shadow to component.</p>\n<p>For example:</p>\n<pre><code class="lang-ts">{\n    shadowColor: &#39;rgba(0, 0, 0, 0.5)&#39;,\n    shadowBlur: 10\n}\n</code></pre>\n',
    )
    shadowColor: Optional[Any] = Field(
        None,
        description='\n\n<p>Shadow color. Support same format as <code class="codespan">color</code>.</p>\n',
    )
    shadowOffsetX: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the horizontal direction of shadow.</p>\n',
    )
    shadowOffsetY: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the vertical direction of shadow.</p>\n',
    )
    opacity: Optional[float] = Field(
        None,
        description='\n\n<p>Opacity of the component. Supports value from 0 to 1, and the component will not be drawn when set to 0.</p>\n',
    )


class MinorSplitLine(BaseModel):
    """
        <blockquote>
    <p>Since <code class="codespan">v4.6.0</code></p>
    </blockquote>
    <p>Minor split lines of axis in the <a href="#grid">grid</a> area。It will align to the <a href="#xAxis.minorTick">minorTick</a></p>

    """

    show: Optional[bool] = Field(
        False, description='\n\n<p>If show minor split lines.</p>\n'
    )
    lineStyle: Optional[LineStyle7] = Field(None, description='')


class AreaStyle(BaseModel):
    """
    <p>Split area style.</p>

    """

    color: Optional[Any] = Field(
        "['rgba(250,250,250,0.3)','rgba(200,200,200,0.3)']",
        description='<p>Color of split area.\nSplitArea color could also be set in color array, which the split lines would take as their colors in turns. Dark and light colors in turns are used by default.</p>\n',
    )
    shadowBlur: Optional[float] = Field(
        None,
        description='\n\n<p>Size of shadow blur. This attribute should be used along with <code class="codespan">shadowColor</code>,<code class="codespan">shadowOffsetX</code>, <code class="codespan">shadowOffsetY</code> to set shadow to component.</p>\n<p>For example:</p>\n<pre><code class="lang-ts">{\n    shadowColor: &#39;rgba(0, 0, 0, 0.5)&#39;,\n    shadowBlur: 10\n}\n</code></pre>\n',
    )
    shadowColor: Optional[Any] = Field(
        None,
        description='\n\n<p>Shadow color. Support same format as <code class="codespan">color</code>.</p>\n',
    )
    shadowOffsetX: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the horizontal direction of shadow.</p>\n',
    )
    shadowOffsetY: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the vertical direction of shadow.</p>\n',
    )
    opacity: Optional[float] = Field(
        None,
        description='\n\n<p>Opacity of the component. Supports value from 0 to 1, and the component will not be drawn when set to 0.</p>\n',
    )


class SplitArea(BaseModel):
    """
    <p>Split area of axis in <a href="#grid">grid</a> area, not shown by default.</p>

    """

    interval: Optional[Union[float, Any]] = Field(
        'auto',
        description='\n\n\n\n<p>Interval of Axis splitArea, which is available in category axis.  is set to be the same as <a href="#xAxis.axisLabel.interval">axisLabel.interval</a> by default.</p>\n<p>It uses a strategy that labels do not overlap by default.</p>\n<p>You may set it to be 0 to display all labels compulsively.</p>\n<p>If it is set to be 1, it means that labels are shown once after one label. And if it is set to be 2, it means labels are shown once after two labels, and so on.</p>\n<p>On the other hand, you can control by callback function, whose format is shown below:</p>\n<pre><code class="lang-ts">(index:number, value: string) =&gt; boolean\n</code></pre>\n<p>The first parameter is index of category, and the second parameter is the name of category. The return values decides whether to display label.</p>\n',
    )
    show: Optional[bool] = Field(
        False,
        description='\n\n<p>Set this to <code class="codespan">true</code> to show the splitArea.</p>\n',
    )
    areaStyle: Optional[AreaStyle] = Field(
        None, description='<p>Split area style.</p>\n'
    )


class _StyleName7(_StyleName):
    pass


class Rich7(BaseModel):
    """
        <p>&quot;Rich text styles&quot; can be defined in this <code class="codespan">rich</code> property. For example:</p>
    <pre><code class="lang-ts">label: {
        // Styles defined in &#39;rich&#39; can be applied to some fragments
        // of text by adding some markers to those fragment, like
        // `{styleName|text content text content}`.
        // `&#39;\n&#39;` is the newline character.
        formatter: [
            &#39;{a|Style &quot;a&quot; is applied to this snippet}&#39;
            &#39;{b|Style &quot;b&quot; is applied to this snippet}This snippet use default style{x|use style &quot;x&quot;}&#39;
        ].join(&#39;\n&#39;),

        rich: {
            a: {
                color: &#39;red&#39;,
                lineHeight: 10
            },
            b: {
                backgroundColor: {
                    image: &#39;xxx/xxx.jpg&#39;
                },
                height: 40
            },
            x: {
                fontSize: 18,
                fontFamily: &#39;Microsoft YaHei&#39;,
                borderColor: &#39;#449933&#39;,
                borderRadius: 4
            },
            ...
        }
    }
    </code></pre>
    <p>For more details, see <a href="tutorial.html#Rich%20Text" target="_blank">Rich Text</a> please.</p>

    """

    _style_name_: Optional[_StyleName7] = Field(
        None, alias='<style_name>', description=''
    )


class TextStyle3(BaseModel):
    """
    <p>Text style of the category.</p>

    """

    color: Optional[Any] = Field('#fff', description='\n\n<p> text color.</p>\n')
    fontStyle: Optional[str] = Field(
        'normal',
        description='\n\n<p> font style.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;italic&#39;</code></li>\n<li><code class="codespan">&#39;oblique&#39;</code></li>\n</ul>\n',
    )
    fontWeight: Optional[Union[str, float]] = Field(
        'normal',
        description='\n\n<p> font thick weight.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;bold&#39;</code></li>\n<li><code class="codespan">&#39;bolder&#39;</code></li>\n<li><code class="codespan">&#39;lighter&#39;</code></li>\n<li>100 | 200 | 300 | 400...</li>\n</ul>\n',
    )
    fontFamily: Optional[str] = Field(
        'sans-serif',
        description='\n\n<p> font family.</p>\n<p>Can also be &#39;serif&#39; , &#39;monospace&#39;, ...</p>\n',
    )
    fontSize: Optional[float] = Field(12, description='\n\n<p> font size.</p>\n')
    align: Optional[str] = Field(
        None,
        description='\n\n<p>Horizontal alignment of text, automatic by default.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;left&#39;</code></li>\n<li><code class="codespan">&#39;center&#39;</code></li>\n<li><code class="codespan">&#39;right&#39;</code></li>\n</ul>\n<p>If <code class="codespan">align</code> is not set in <code class="codespan">rich</code>, <code class="codespan">align</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    align: right,\n    rich: {\n        a: {\n            // `align` is not set, then it will be right\n        }\n    }\n}\n</code></pre>\n',
    )
    verticalAlign: Optional[str] = Field(
        None,
        description='\n\n<p>Vertical alignment of text, automatic by default.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;top&#39;</code></li>\n<li><code class="codespan">&#39;middle&#39;</code></li>\n<li><code class="codespan">&#39;bottom&#39;</code></li>\n</ul>\n<p>If <code class="codespan">verticalAlign</code> is not set in <code class="codespan">rich</code>, <code class="codespan">verticalAlign</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    verticalAlign: bottom,\n    rich: {\n        a: {\n            // `verticalAlign` is not set, then it will be bottom\n        }\n    }\n}\n</code></pre>\n',
    )
    lineHeight: Optional[float] = Field(
        None,
        description='\n\n<p>Line height of the text fragment.</p>\n<p>If <code class="codespan">lineHeight</code> is not set in <code class="codespan">rich</code>, <code class="codespan">lineHeight</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    lineHeight: 56,\n    rich: {\n        a: {\n            // `lineHeight` is not set, then it will be 56\n        }\n    }\n}\n</code></pre>\n',
    )
    backgroundColor: Optional[Union[str, Any]] = Field(
        'transparent',
        description='\n\n<p>Background color of the text fragment.</p>\n<p>Can be color string, like <code class="codespan">&#39;#123234&#39;</code>, <code class="codespan">&#39;red&#39;</code>, <code class="codespan">&#39;rgba(0,23,11,0.3)&#39;</code>.</p>\n<p>Or image can be used, for example:</p>\n<pre><code class="lang-ts">backgroundColor: {\n    image: &#39;xxx/xxx.png&#39;\n    // It can be URL of a image,\n    // or dataURI,\n    // or HTMLImageElement,\n    // or HTMLCanvasElement.\n}\n</code></pre>\n<p><code class="codespan">width</code> or <code class="codespan">height</code> can be specified when using background image, or\nauto adapted by default.</p>\n',
    )
    borderColor: Optional[Any] = Field(
        None, description='\n\n<p>Border color of the text fragment.</p>\n'
    )
    borderWidth: Optional[float] = Field(
        0, description='\n\n<p>Border width of the text fragment.</p>\n'
    )
    borderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>the text fragment border type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">borderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\nborderType: [5, 10],\n\nborderDashOffset: 5\n}\n</code></pre>\n',
    )
    borderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">borderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    borderRadius: Optional[float] = Field(
        0, description='\n\n<p>Border radius of the text fragment.</p>\n'
    )
    padding: Optional[Union[float, Any]] = Field(
        0,
        description='\n\n<p>Padding of the text fragment, for example:</p>\n<ul>\n<li><code class="codespan">padding: [3, 4, 5, 6]</code>: represents padding of <code class="codespan">[top, right, bottom, left]</code>.</li>\n<li><code class="codespan">padding: 4</code>: represents <code class="codespan">padding: [4, 4, 4, 4]</code>.</li>\n<li><code class="codespan">padding: [3, 4]</code>: represents <code class="codespan">padding: [3, 4, 3, 4]</code>.</li>\n</ul>\n<p>Notice, <code class="codespan">width</code> and <code class="codespan">height</code> specifies the width and height of the content, without <code class="codespan">padding</code>.</p>\n',
    )
    shadowColor: Optional[Any] = Field(
        'transparent', description='\n\n<p>Shadow color of the text block.</p>\n'
    )
    shadowBlur: Optional[float] = Field(
        0, description='\n\n<p>Show blur of the text block.</p>\n'
    )
    shadowOffsetX: Optional[float] = Field(
        0, description='\n\n<p>Shadow X offset of the text block.</p>\n'
    )
    shadowOffsetY: Optional[float] = Field(
        0, description='\n\n<p>Shadow Y offset of the text block.</p>\n'
    )
    width: Optional[float] = Field(
        None, description='\n\n<p>Width of text block.</p>\n'
    )
    height: Optional[float] = Field(
        None, description='\n\n<p>Height of text block.</p>\n'
    )
    textBorderColor: Optional[Any] = Field(
        None, description='\n\n<p>Stroke color of the text.</p>\n'
    )
    textBorderWidth: Optional[float] = Field(
        None, description='\n\n<p>Stroke line width of the text.</p>\n'
    )
    textBorderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>Stroke line type of the text.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">textBorderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\ntextBorderType: [5, 10],\n\ntextBorderDashOffset: 5\n}\n</code></pre>\n',
    )
    textBorderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">textBorderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    textShadowColor: Optional[Any] = Field(
        'transparent', description='\n\n<p>Shadow color of the text itself.</p>\n'
    )
    textShadowBlur: Optional[float] = Field(
        0, description='\n\n<p>Shadow blue of the text itself.</p>\n'
    )
    textShadowOffsetX: Optional[float] = Field(
        0, description='\n\n<p>Shadow X offset of the text itself.</p>\n'
    )
    textShadowOffsetY: Optional[float] = Field(
        0, description='\n\n<p>Shadow Y offset of the text itself.</p>\n'
    )
    overflow: Optional[str] = Field(
        'none',
        description='\n\n<p>Determine how to display the text when it&#39;s overflow. Available when <code class="codespan">width</code> is set.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the text and trailing with <code class="codespan">ellipsis</code>.</li>\n<li><code class="codespan">&#39;break&#39;</code> Break by word</li>\n<li><code class="codespan">&#39;breakAll&#39;</code> Break by character.</li>\n</ul>\n',
    )
    ellipsis: Optional[str] = Field(
        '...',
        description='<p>Ellipsis to be displayed when <code class="codespan">overflow</code> is set to <code class="codespan">truncate</code>.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the overflow lines.</li>\n</ul>\n',
    )
    rich: Optional[Rich7] = Field(
        None,
        description='<p>&quot;Rich text styles&quot; can be defined in this <code class="codespan">rich</code> property. For example:</p>\n<pre><code class="lang-ts">label: {\n    // Styles defined in &#39;rich&#39; can be applied to some fragments\n    // of text by adding some markers to those fragment, like\n    // `{styleName|text content text content}`.\n    // `&#39;\\n&#39;` is the newline character.\n    formatter: [\n        &#39;{a|Style &quot;a&quot; is applied to this snippet}&#39;\n        &#39;{b|Style &quot;b&quot; is applied to this snippet}This snippet use default style{x|use style &quot;x&quot;}&#39;\n    ].join(&#39;\\n&#39;),\n\n    rich: {\n        a: {\n            color: &#39;red&#39;,\n            lineHeight: 10\n        },\n        b: {\n            backgroundColor: {\n                image: &#39;xxx/xxx.jpg&#39;\n            },\n            height: 40\n        },\n        x: {\n            fontSize: 18,\n            fontFamily: &#39;Microsoft YaHei&#39;,\n            borderColor: &#39;#449933&#39;,\n            borderRadius: 4\n        },\n        ...\n    }\n}\n</code></pre>\n<p>For more details, see <a href="tutorial.html#Rich%20Text" target="_blank">Rich Text</a> please.</p>\n',
    )


class Datum1(BaseModel):
    value: Optional[str] = Field(None, description='<p>Name of a category.</p>\n')
    textStyle: Optional[TextStyle3] = Field(
        None, description='<p>Text style of the category.</p>\n'
    )


class Label1(Label):
    """
    <p>label of axisPointer</p>

    """

    pass


class LineStyle8(LineStyle2):
    """
    <p>It is valid when <a href="#tooltip.axisPointer.type">axisPointer.type</a> is <code class="codespan">&#39;line&#39;</code>.</p>

    """

    pass


class ShadowStyle1(ShadowStyle):
    """
    <p>It is valid when <a href="#tooltip.axisPointer.type">axisPointer.type</a> is <code class="codespan">&#39;shadow&#39;</code>.</p>

    """

    pass


class Handle(BaseModel):
    """
    <p>A button used to drag axisPointer. This feature is applicable in touch device. See <a href="http://localhost/echarts-website/examples/en/editor.html?c=line-tooltip-touch&amp;edit=1&amp;reset=1" target="_blank">example</a>.</p>

    """

    show: Optional[bool] = Field(
        False,
        description='\n\n<p>Set to <code class="codespan">true</code> to use handle.</p>\n',
    )
    icon: Optional[Any] = Field(
        None,
        description='\n\n<p>The icon of the handle.</p>\n<p>It can be set to an image with <code class="codespan">&#39;image://url&#39;</code> , in which URL is the link to an image, or <code class="codespan">dataURI</code> of an image.</p>\n<p>An image URL example:</p>\n<pre><code>&#39;image://http://example.website/a/b.png&#39;\n</code></pre><p>A <code class="codespan">dataURI</code> example:</p>\n<pre><code>&#39;image://data:image/gif;base64,R0lGODlhEAAQAMQAAORHHOVSKudfOulrSOp3WOyDZu6QdvCchPGolfO0o/XBs/fNwfjZ0frl3/zy7////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAkAABAALAAAAAAQABAAAAVVICSOZGlCQAosJ6mu7fiyZeKqNKToQGDsM8hBADgUXoGAiqhSvp5QAnQKGIgUhwFUYLCVDFCrKUE1lBavAViFIDlTImbKC5Gm2hB0SlBCBMQiB0UjIQA7&#39;\n</code></pre><p>Icons can be set to arbitrary vector path via <code class="codespan">&#39;path://&#39;</code> in ECharts. As compared with a raster image, vector paths prevent jagging and blurring when scaled, and have better control over changing colors. The size of the vector icon will be adapted automatically. Refer to <a href="http://www.w3.org/TR/SVG/paths.html#PathData" target="_blank">SVG PathData</a> for more information about the format of the path. You may export vector paths from tools like Adobe </p>\n<p>For example:</p>\n<pre><code>&#39;path://M30.9,53.2C16.8,53.2,5.3,41.7,5.3,27.6S16.8,2,30.9,2C45,2,56.4,13.5,56.4,27.6S45,53.2,30.9,53.2z M30.9,3.5C17.6,3.5,6.8,14.4,6.8,27.6c0,13.3,10.8,24.1,24.101,24.1C44.2,51.7,55,40.9,55,27.6C54.9,14.4,44.1,3.5,30.9,3.5z M36.9,35.8c0,0.601-0.4,1-0.9,1h-1.3c-0.5,0-0.9-0.399-0.9-1V19.5c0-0.6,0.4-1,0.9-1H36c0.5,0,0.9,0.4,0.9,1V35.8z M27.8,35.8 c0,0.601-0.4,1-0.9,1h-1.3c-0.5,0-0.9-0.399-0.9-1V19.5c0-0.6,0.4-1,0.9-1H27c0.5,0,0.9,0.4,0.9,1L27.8,35.8L27.8,35.8z&#39;\n</code></pre><p>See the <a href="http://localhost/echarts-website/examples/en/editor.html?c=doc-example/axisPointer-handle-image&amp;edit=1&amp;reset=1" target="_blank">example of using image</a></p>\n',
    )
    size: Optional[Union[float, Any]] = Field(
        45,
        description='\n\n<p>The size of the handle, which can be set as a single value or an array (<code class="codespan">[width, height]</code>).</p>\n',
    )
    margin: Optional[float] = Field(
        50, description='\n\n<p>Distance from handle center to axis.</p>\n'
    )
    color: Optional[str] = Field(
        '#333', description='\n\n<p>The color of the handle.</p>\n'
    )
    throttle: Optional[float] = Field(
        40,
        description='\n\n<p>Throttle rate of trigger view update when dragging handle, in ms. Increase the value to improve performance, but decrease the experience.</p>\n',
    )
    shadowBlur: Optional[float] = Field(
        3,
        description='\n\n<p>Size of shadow blur. This attribute should be used along with <code class="codespan">shadowColor</code>,<code class="codespan">shadowOffsetX</code>, <code class="codespan">shadowOffsetY</code> to set shadow to component.</p>\n<p>For example:</p>\n<pre><code class="lang-ts">{\n    shadowColor: &#39;rgba(0, 0, 0, 0.5)&#39;,\n    shadowBlur: 10\n}\n</code></pre>\n',
    )
    shadowColor: Optional[Any] = Field(
        '#aaa',
        description='\n\n<p>Shadow color. Support same format as <code class="codespan">color</code>.</p>\n',
    )
    shadowOffsetX: Optional[float] = Field(
        2,
        description='\n\n<p>Offset distance on the horizontal direction of shadow.</p>\n',
    )
    shadowOffsetY: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the vertical direction of shadow.</p>\n',
    )


class AxisPointer1(BaseModel):
    """
    <p>axisPointer settings on the axis.</p>

    """

    show: Optional[bool] = Field(
        False,
        description='\n\n<p>axisPointer will not be displayed by default. But if <a href="#tooltip.trigger">tooltip.trigger</a> is set as <code class="codespan">&#39;axis&#39;</code> or <a href="#tooltip.axisPointer.type">tooltip.axisPointer.type</a> is set as  <code class="codespan">&#39;cross&#39;</code>, axisPointer will be displayed automatically. Each coordinate system will automatically chose the axes whose will display its axisPointer. <a href="#tooltip.axisPointer.axis">tooltip.axisPointer.axis</a> can be used to change the choice.</p>\n',
    )
    type: Optional[str] = Field(
        'line',
        description='\n\n<p>Indicator type.</p>\n<p>Options:</p>\n<ul>\n<li><p><code class="codespan">&#39;line&#39;</code> line indicator.</p>\n</li>\n<li><p><code class="codespan">&#39;shadow&#39;</code> shadow crosshair indicator.</p>\n</li>\n<li><p><code class="codespan">&#39;none&#39;</code> no indicator displayed.</p>\n</li>\n</ul>\n',
    )
    snap: Optional[bool] = Field(
        None,
        description='<p>Whether snap to point automatically. The default value is auto determined.</p>\n<p>This feature usually makes sense in value axis and time axis, where tiny points can be seeked automatically.</p>\n',
    )
    z: Optional[float] = Field(
        None,
        description='<p>z value, which controls order of drawing graphical components. Components with smaller <code class="codespan">z</code> values may be overwritten by those with larger <code class="codespan">z</code> values.</p>\n',
    )
    label: Optional[Label1] = Field(None, description='<p>label of axisPointer</p>\n')
    lineStyle: Optional[LineStyle8] = Field(
        None,
        description='<p>It is valid when <a href="#tooltip.axisPointer.type">axisPointer.type</a> is <code class="codespan">&#39;line&#39;</code>.</p>\n',
    )
    shadowStyle: Optional[ShadowStyle1] = Field(
        None,
        description='<p>It is valid when <a href="#tooltip.axisPointer.type">axisPointer.type</a> is <code class="codespan">&#39;shadow&#39;</code>.</p>\n',
    )
    triggerTooltip: Optional[bool] = Field(
        True, description='\n\n<p>Whether to trigger tooltip.</p>\n'
    )
    value: Optional[float] = Field(
        None,
        description='<p>current value. When using <a href="xAxisPointer.handle" target="_blank">axisPointer.handle</a>, <code class="codespan">value</code> can be set to define the initial position of axisPointer.</p>\n',
    )
    status: Optional[bool] = Field(
        None,
        description='\n\n<p>Current status, can be <code class="codespan">&#39;show&#39;</code> 和 <code class="codespan">&#39;hide&#39;</code>.</p>\n',
    )
    handle: Optional[Handle] = Field(
        None,
        description='<p>A button used to drag axisPointer. This feature is applicable in touch device. See <a href="http://localhost/echarts-website/examples/en/editor.html?c=line-tooltip-touch&amp;edit=1&amp;reset=1" target="_blank">example</a>.</p>\n',
    )


class XAxis(BaseModel):
    """
    <p>The x axis in cartesian(rectangular) coordinate. Usually a single grid component can place at most 2 x axis, one on the bottom and another on the top. <a href="#xAxis.offset">offset</a> can be used to avoid overlap when you need to put more than two x axis.</p>

    """

    id: Optional[str] = Field(
        None,
        description='<p>Component ID, not specified by default. If specified, it can be used to refer the component in option or API.</p>\n',
    )
    show: Optional[bool] = Field(
        True,
        description='\n\n<p>Set this to <code class="codespan">false</code> to prevent the axis from showing.</p>\n',
    )
    gridIndex: Optional[float] = Field(
        0,
        description='<p>The index of grid which the x axis belongs to. Defaults to be in the first grid.</p>\n',
    )
    alignTicks: Optional[bool] = Field(
        False,
        description='<blockquote>\n<p>Since <code class="codespan">v5.3.0</code></p>\n</blockquote>\n<p><code class="codespan">alignTicks</code> turned on to automatically align ticks when multiple numeric x axes. Only available for axes of type <code class="codespan">&#39;value&#39;</code> and <code class="codespan">&#39;log&#39;</code>.</p>\n',
    )
    position: Optional[str] = Field(
        None,
        description='\n\n<p>The position of x axis.</p>\n<p>options:</p>\n<ul>\n<li><code class="codespan">&#39;top&#39;</code></li>\n<li><code class="codespan">&#39;bottom&#39;</code></li>\n</ul>\n<p>The first x axis in grid defaults to be on the bottom of the grid, and the second x axis is on the other side against the first x axis.<br>Notice: Set <code class="codespan">xAxis.axisLine.onZero</code> to <code class="codespan">false</code> to activate this option.</p>\n',
    )
    offset: Optional[float] = Field(
        0,
        description='\n\n<p>Offset of x axis relative to default position. Useful when multiple x axis has same <a href="#xAxis.position">position</a> value.<br>Notice: Set <code class="codespan">xAxis.axisLine.onZero</code> to <code class="codespan">false</code> to activate this option.</p>\n',
    )
    type: Optional[str] = Field(
        'category',
        description='<p>Type of axis.</p>\n<p>Option:</p>\n<ul>\n<li><p><code class="codespan">&#39;value&#39;</code>\n  Numerical axis, suitable for continuous data.</p>\n</li>\n<li><p><code class="codespan">&#39;category&#39;</code>\n  Category axis, suitable for discrete category data. Category data can be auto retrieved from <a href="#series.data">series.data</a> or <a href="#dataset.source">dataset.source</a>, or can be specified via <a href="#xAxis.data">xAxis.data</a>.</p>\n</li>\n<li><p><code class="codespan">&#39;time&#39;</code>\n  Time axis, suitable for continuous time series data. As compared to value axis, it has a better formatting for time and a different tick calculation method. For example, it decides to use month, week, day or hour for tick based on the range of span.</p>\n</li>\n<li><p><code class="codespan">&#39;log&#39;</code>\n  Log axis, suitable for log data.</p>\n</li>\n</ul>\n',
    )
    name: Optional[str] = Field(None, description='\n\n<p>Name of axis.</p>\n')
    nameLocation: Optional[str] = Field(
        'end',
        description='\n\n<p>Location of axis name.</p>\n<p><strong>Options: </strong></p>\n<ul>\n<li><code class="codespan">&#39;start&#39;</code></li>\n<li><code class="codespan">&#39;middle&#39;</code> or <code class="codespan">&#39;center&#39;</code></li>\n<li><code class="codespan">&#39;end&#39;</code></li>\n</ul>\n',
    )
    nameTextStyle: Optional[NameTextStyle] = Field(
        None, description='<p>Text style of axis name.</p>\n'
    )
    nameGap: Optional[float] = Field(
        15, description='\n\n<p>Gap between axis name and axis line.</p>\n'
    )
    nameRotate: Optional[float] = Field(
        None, description='\n\n<p>Rotation of axis name.</p>\n'
    )
    inverse: Optional[bool] = Field(
        False,
        description='\n\n<p>Set this to <code class="codespan">true</code> to invert the axis.\nThis is a new option available from Echarts 3 and newer.</p>\n',
    )
    boundaryGap: Optional[Union[bool, Any]] = Field(
        None,
        description='\n\n<p>The boundary gap on both sides of a coordinate axis. The setting and behavior of category axes and non-category axes are different.</p>\n<p>The <code class="codespan">boundaryGap</code> of category axis can be set to either <code class="codespan">true</code> or <code class="codespan">false</code>. Default value is set to be <code class="codespan">true</code>, in which case <a href="#xAxis.axisTick">axisTick</a> is served only as a separation line, and labels and data appear only in the center part of two <a href="#xAxis.axisTick">axis ticks</a>, which is called <em>band</em>.</p>\n<p>For non-category axis, including time, numerical value, and log axes, <code class="codespan">boundaryGap</code> is an array of two values, representing the spanning range between minimum and maximum value. The value can be set in numeric value or relative percentage, which becomes invalid after setting <a href="#xAxis.min">min</a> and <a href="#xAxis.max">max</a>.\n<strong>Example: </strong></p>\n<pre><code class="lang-ts">boundaryGap: [&#39;20%&#39;, &#39;20%&#39;]\n</code></pre>\n',
    )
    min: Optional[Union[float, str, Any]] = Field(
        None,
        description='\n\n<p>The minimun value of axis.</p>\n<p>It can be set to a special value <code class="codespan">&#39;dataMin&#39;</code> so that the minimum value on this axis is set to be the minimum label.</p>\n<p>It will be automatically computed to make sure axis tick is equally distributed when not set.</p>\n<p>In category axis, it can also be set as the ordinal number. For example, if a catergory axis has <code class="codespan">data: [&#39;categoryA&#39;, &#39;categoryB&#39;, &#39;categoryC&#39;]</code>, and the ordinal <code class="codespan">2</code> represents <code class="codespan">&#39;categoryC&#39;</code>. Moreover, it can be set as negative number, like <code class="codespan">-3</code>.</p>\n<p>If <code class="codespan">min</code> is specified as a function, it should return a min value, like:</p>\n<pre><code class="lang-ts">min: function (value) {\n    return value.min - 20;\n}\n</code></pre>\n<p><code class="codespan">value</code> is an object, containing the <code class="codespan">min</code> value and <code class="codespan">max</code> value of the data. This function should return the min value of axis, or return <code class="codespan">null</code>/<code class="codespan">undefined</code> to make echarts use the auto calculated min value (<code class="codespan">null</code>/<code class="codespan">undefined</code> return is only supported since <code class="codespan">v4.8.0</code>).</p>\n',
    )
    max: Optional[Union[float, str, Any]] = Field(
        None,
        description='\n\n<p>The maximum value of axis.</p>\n<p>It can be set to a special value <code class="codespan">&#39;dataMax&#39;</code> so that the minimum value on this axis is set to be the maximum label.</p>\n<p>It will be automatically computed to make sure axis tick is equally distributed when not set.</p>\n<p>In category axis, it can also be set as the ordinal number. For example, if a catergory axis has <code class="codespan">data: [&#39;categoryA&#39;, &#39;categoryB&#39;, &#39;categoryC&#39;]</code>, and the ordinal <code class="codespan">2</code> represents <code class="codespan">&#39;categoryC&#39;</code>. Moreover, it can be set as negative number, like <code class="codespan">-3</code>.</p>\n<p>If <code class="codespan">max</code> is specified as a function, it should return a max value, like:</p>\n<pre><code class="lang-ts">max: function (value) {\n    return value.max - 20;\n}\n</code></pre>\n<p><code class="codespan">value</code> is an object, containing the <code class="codespan">min</code> value and <code class="codespan">max</code> value of the data. This function should return the max value of axis, or return <code class="codespan">null</code>/<code class="codespan">undefined</code> to make echarts use the auto calculated max value (<code class="codespan">null</code>/<code class="codespan">undefined</code> return is only supported since <code class="codespan">v4.8.0</code>).</p>\n',
    )
    scale: Optional[bool] = Field(
        False,
        description='\n\n<p>It is available only in numerical axis, i.e., <a href="#xAxis.type">type</a>: &#39;value&#39;.</p>\n<p>It specifies whether not to contain zero position of axis compulsively. When it is set to be <code class="codespan">true</code>, the axis may not contain zero position, which is useful in the scatter chart for both value axes.</p>\n<p>This configuration item is unavailable when the <a href="#xAxis.min">min</a> and <a href="#xAxis.max">max</a> are set.</p>\n',
    )
    splitNumber: Optional[float] = Field(
        5,
        description='\n\n<p>Number of segments that the axis is split into. Note that this number serves only as a recommendation, and the true segments may be adjusted based on readability.</p>\n<p>This is unavailable for category axis.</p>\n',
    )
    minInterval: Optional[float] = Field(
        0,
        description='\n\n<p>Minimum gap between split lines.</p>\n<p>For example, it can be set to be <code class="codespan">1</code> to make sure axis label is show as integer.</p>\n<pre><code class="lang-ts">{\n    minInterval: 1\n}\n</code></pre>\n<p>It is available only for axis of <a href="#xAxis.type">type</a> &#39;value&#39; or &#39;time&#39;.</p>\n',
    )
    maxInterval: Optional[float] = Field(
        None,
        description='\n\n<p>Maximum gap between split lines.</p>\n<p>For example, in time axis (<a href="#xAxis.type">type</a> is &#39;time&#39;), it can be set to be <code class="codespan">3600 * 24 * 1000</code> to make sure that the gap between axis labels is less than or equal to one day.</p>\n<pre><code class="lang-ts">{\n    maxInterval: 3600 * 1000 * 24\n}\n</code></pre>\n<p>It is available only for axis of <a href="#xAxis.type">type</a> &#39;value&#39; or &#39;time&#39;.</p>\n',
    )
    interval: Optional[float] = Field(
        None,
        description='\n\n<p>Compulsively set segmentation interval for axis.</p>\n<p>As <a href="#xAxis.splitNumber">splitNumber</a> is a recommendation value, the calculated tick may not be the same as expected. In this case, interval should be used along with <a href="#xAxis.min">min</a> and <a href="#xAxis.max">max</a> to compulsively set tickings. But in most cases, we do not suggest using this, our automatic calculation is enough for most situations.</p>\n<p>This is unavailable for category axis. Timestamp should be passed for <a href="#xAxis.type">type</a>: &#39;time&#39; axis. Logged value should be passed for <a href="#xAxis.type">type</a>: &#39;log&#39; axis.</p>\n',
    )
    logBase: Optional[float] = Field(
        10,
        description='\n\n<p>Base of logarithm, which is valid only for numeric axes with <a href="#xAxis.type">type</a>: &#39;log&#39;.</p>\n',
    )
    silent: Optional[bool] = Field(
        False,
        description='<p>Set this to <code class="codespan">true</code>, to prevent interaction with the axis.</p>\n',
    )
    triggerEvent: Optional[bool] = Field(
        False,
        description='<p>Set this to <code class="codespan">true</code> to enable triggering events.</p>\n<p>Parameters of the event include:</p>\n<pre><code class="lang-ts">{\n    // Component type: xAxis, yAxis, radiusAxis, angleAxis\n    // Each of which has an attribute for index, e.g., xAxisIndex for xAxis\n    componentType: string,\n    // Value on axis before being formatted.\n    // Click on value label to trigger event.\n    value: &#39;&#39;,\n    // Name of axis.\n    // Click on laben name to trigger event.\n    name: &#39;&#39;\n}\n</code></pre>\n',
    )
    axisLine: Optional[AxisLine] = Field(
        None, description='<p>Settings related to axis line.</p>\n'
    )
    axisTick: Optional[AxisTick] = Field(
        None, description='<p>Settings related to axis tick.</p>\n'
    )
    minorTick: Optional[MinorTick] = Field(
        None,
        description='<blockquote>\n<p>Since <code class="codespan">v4.6.0</code></p>\n</blockquote>\n<p>Settings related minor ticks.</p>\n<p>Note: <code class="codespan">minorTick</code> is not available in the <code class="codespan">category</code> type axis.</p>\n<p>Examples:</p>\n<p>1) Using minor ticks in function plotting.</p>\n<iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=line-function&edit=1&reset=1" width="600" height="350"></iframe>\n\n\n<p>2) Using minor ticks in log axis.</p>\n<iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=line-log&edit=1&reset=1" width="600" height="350"></iframe>\n\n',
    )
    axisLabel: Optional[AxisLabel] = Field(
        None, description='<p>Settings related to axis label.</p>\n'
    )
    splitLine: Optional[SplitLine] = Field(
        None,
        description='<p>Split line of axis in <a href="#grid">grid</a> area.</p>\n',
    )
    minorSplitLine: Optional[MinorSplitLine] = Field(
        None,
        description='<blockquote>\n<p>Since <code class="codespan">v4.6.0</code></p>\n</blockquote>\n<p>Minor split lines of axis in the <a href="#grid">grid</a> area。It will align to the <a href="#xAxis.minorTick">minorTick</a></p>\n',
    )
    splitArea: Optional[SplitArea] = Field(
        None,
        description='<p>Split area of axis in <a href="#grid">grid</a> area, not shown by default.</p>\n',
    )
    data: Optional[List[Datum1]] = Field(
        None,
        description='<p>Category data, available in <a href="#xAxis.type">type</a>: &#39;category&#39; axis.</p>\n<p>If <a href="#xAxis.type">type</a> is not specified, but <code class="codespan">axis.data</code> is specified, the <a href="#xAxis.type">type</a> is auto set as <code class="codespan">&#39;category&#39;</code>.</p>\n<p>If <a href="#xAxis.type">type</a> is specified as <code class="codespan">&#39;category&#39;</code>, but <code class="codespan">axis.data</code> is not specified, <code class="codespan">axis.data</code> will be auto collected from <a href="#series.data">series.data</a>. It brings convenience, but we should notice that <code class="codespan">axis.data</code> provides then value range of the <code class="codespan">&#39;category&#39;</code> axis. If  it is auto collected from <a href="#series.data">series.data</a>, Only the values appearing in <a href="#series.data">series.data</a> can be collected. For example, if <a href="#series.data">series.data</a> is empty, nothing will be collected.</p>\n<p>Example:</p>\n<pre><code class="lang-ts">// Name list of all categories\ndata: [&#39;Monday&#39;, &#39;Tuesday&#39;, &#39;Wednesday&#39;, &#39;Thursday&#39;, &#39;Friday&#39;, &#39;Saturday&#39;, &#39;Sunday&#39;]\n// Each item could also be a specific configuration item.\n// In this case, `value` is used as the category name.\ndata: [{\n    value: &#39;Monday&#39;,\n    // Highlight Monday\n    textStyle: {\n        fontSize: 20,\n        color: &#39;red&#39;\n    }\n}, &#39;Tuesday&#39;, &#39;Wednesday&#39;, &#39;Thursday&#39;, &#39;Friday&#39;, &#39;Saturday&#39;, &#39;Sunday&#39;]\n</code></pre>\n',
    )
    axisPointer: Optional[AxisPointer1] = Field(
        None, description='<p>axisPointer settings on the axis.</p>\n'
    )
    zlevel: Optional[float] = Field(
        0,
        description='<p><code class="codespan">zlevel</code> value of all graphical elements in x axis.</p>\n<p><code class="codespan">zlevel</code> is used to make layers with Canvas. Graphical elements with different <code class="codespan">zlevel</code> values will be placed in different Canvases, which is a common optimization technique. We can put those frequently changed elements (like those with animations) to a separate <code class="codespan">zlevel</code>. Notice that too many Canvases will increase memory cost, and should be used carefully on mobile phones to avoid crash.</p>\n<p>Canvases with bigger <code class="codespan">zlevel</code> will be placed on Canvases with smaller <code class="codespan">zlevel</code>.</p>\n',
    )
    z: Optional[float] = Field(
        0,
        description='<p><code class="codespan">z</code> value of all graphical elements in x axis, which controls order of drawing graphical components. Components with smaller <code class="codespan">z</code> values may be overwritten by those with larger <code class="codespan">z</code> values.</p>\n<p><code class="codespan">z</code> has a lower priority to <code class="codespan">zlevel</code>, and will not create new Canvas.</p>\n',
    )


class _StyleName8(_StyleName5):
    pass


class Rich8(BaseModel):
    """
        <p>&quot;Rich text styles&quot; can be defined in this <code class="codespan">rich</code> property. For example:</p>
    <pre><code class="lang-ts">label: {
        // Styles defined in &#39;rich&#39; can be applied to some fragments
        // of text by adding some markers to those fragment, like
        // `{styleName|text content text content}`.
        // `&#39;\n&#39;` is the newline character.
        formatter: [
            &#39;{a|Style &quot;a&quot; is applied to this snippet}&#39;
            &#39;{b|Style &quot;b&quot; is applied to this snippet}This snippet use default style{x|use style &quot;x&quot;}&#39;
        ].join(&#39;\n&#39;),

        rich: {
            a: {
                color: &#39;red&#39;,
                lineHeight: 10
            },
            b: {
                backgroundColor: {
                    image: &#39;xxx/xxx.jpg&#39;
                },
                height: 40
            },
            x: {
                fontSize: 18,
                fontFamily: &#39;Microsoft YaHei&#39;,
                borderColor: &#39;#449933&#39;,
                borderRadius: 4
            },
            ...
        }
    }
    </code></pre>
    <p>For more details, see <a href="tutorial.html#Rich%20Text" target="_blank">Rich Text</a> please.</p>

    """

    _style_name_: Optional[_StyleName8] = Field(
        None, alias='<style_name>', description=''
    )


class NameTextStyle1(BaseModel):
    """
    <p>Text style of axis name.</p>

    """

    color: Optional[Any] = Field(
        None,
        description='\n\n<p>Color of axis name uses <a href="#yAxis.axisLine.lineStyle.color">axisLine.lineStyle.color</a> by default.</p>\n',
    )
    fontStyle: Optional[str] = Field(
        'normal',
        description='\n\n<p>axis name font style.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;italic&#39;</code></li>\n<li><code class="codespan">&#39;oblique&#39;</code></li>\n</ul>\n',
    )
    fontWeight: Optional[Union[str, float]] = Field(
        'normal',
        description='\n\n<p>axis name font thick weight.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;bold&#39;</code></li>\n<li><code class="codespan">&#39;bolder&#39;</code></li>\n<li><code class="codespan">&#39;lighter&#39;</code></li>\n<li>100 | 200 | 300 | 400...</li>\n</ul>\n',
    )
    fontFamily: Optional[str] = Field(
        'sans-serif',
        description='\n\n<p>axis name font family.</p>\n<p>Can also be &#39;serif&#39; , &#39;monospace&#39;, ...</p>\n',
    )
    fontSize: Optional[float] = Field(
        12, description='\n\n<p>axis name font size.</p>\n'
    )
    align: Optional[str] = Field(
        None,
        description='\n\n<p>Horizontal alignment of text, automatic by default.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;left&#39;</code></li>\n<li><code class="codespan">&#39;center&#39;</code></li>\n<li><code class="codespan">&#39;right&#39;</code></li>\n</ul>\n<p>If <code class="codespan">align</code> is not set in <code class="codespan">rich</code>, <code class="codespan">align</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    align: right,\n    rich: {\n        a: {\n            // `align` is not set, then it will be right\n        }\n    }\n}\n</code></pre>\n',
    )
    verticalAlign: Optional[str] = Field(
        None,
        description='\n\n<p>Vertical alignment of text, automatic by default.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;top&#39;</code></li>\n<li><code class="codespan">&#39;middle&#39;</code></li>\n<li><code class="codespan">&#39;bottom&#39;</code></li>\n</ul>\n<p>If <code class="codespan">verticalAlign</code> is not set in <code class="codespan">rich</code>, <code class="codespan">verticalAlign</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    verticalAlign: bottom,\n    rich: {\n        a: {\n            // `verticalAlign` is not set, then it will be bottom\n        }\n    }\n}\n</code></pre>\n',
    )
    lineHeight: Optional[float] = Field(
        None,
        description='\n\n<p>Line height of the text fragment.</p>\n<p>If <code class="codespan">lineHeight</code> is not set in <code class="codespan">rich</code>, <code class="codespan">lineHeight</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    lineHeight: 56,\n    rich: {\n        a: {\n            // `lineHeight` is not set, then it will be 56\n        }\n    }\n}\n</code></pre>\n',
    )
    backgroundColor: Optional[Union[str, Any]] = Field(
        'transparent',
        description='\n\n<p>Background color of the text fragment.</p>\n<p>Can be color string, like <code class="codespan">&#39;#123234&#39;</code>, <code class="codespan">&#39;red&#39;</code>, <code class="codespan">&#39;rgba(0,23,11,0.3)&#39;</code>.</p>\n<p>Or image can be used, for example:</p>\n<pre><code class="lang-ts">backgroundColor: {\n    image: &#39;xxx/xxx.png&#39;\n    // It can be URL of a image,\n    // or dataURI,\n    // or HTMLImageElement,\n    // or HTMLCanvasElement.\n}\n</code></pre>\n<p><code class="codespan">width</code> or <code class="codespan">height</code> can be specified when using background image, or\nauto adapted by default.</p>\n',
    )
    borderColor: Optional[Any] = Field(
        None, description='\n\n<p>Border color of the text fragment.</p>\n'
    )
    borderWidth: Optional[float] = Field(
        0, description='\n\n<p>Border width of the text fragment.</p>\n'
    )
    borderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>the text fragment border type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">borderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\nborderType: [5, 10],\n\nborderDashOffset: 5\n}\n</code></pre>\n',
    )
    borderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">borderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    borderRadius: Optional[float] = Field(
        0, description='\n\n<p>Border radius of the text fragment.</p>\n'
    )
    padding: Optional[Union[float, Any]] = Field(
        0,
        description='\n\n<p>Padding of the text fragment, for example:</p>\n<ul>\n<li><code class="codespan">padding: [3, 4, 5, 6]</code>: represents padding of <code class="codespan">[top, right, bottom, left]</code>.</li>\n<li><code class="codespan">padding: 4</code>: represents <code class="codespan">padding: [4, 4, 4, 4]</code>.</li>\n<li><code class="codespan">padding: [3, 4]</code>: represents <code class="codespan">padding: [3, 4, 3, 4]</code>.</li>\n</ul>\n<p>Notice, <code class="codespan">width</code> and <code class="codespan">height</code> specifies the width and height of the content, without <code class="codespan">padding</code>.</p>\n',
    )
    shadowColor: Optional[Any] = Field(
        'transparent', description='\n\n<p>Shadow color of the text block.</p>\n'
    )
    shadowBlur: Optional[float] = Field(
        0, description='\n\n<p>Show blur of the text block.</p>\n'
    )
    shadowOffsetX: Optional[float] = Field(
        0, description='\n\n<p>Shadow X offset of the text block.</p>\n'
    )
    shadowOffsetY: Optional[float] = Field(
        0, description='\n\n<p>Shadow Y offset of the text block.</p>\n'
    )
    width: Optional[float] = Field(
        None, description='\n\n<p>Width of text block.</p>\n'
    )
    height: Optional[float] = Field(
        None, description='\n\n<p>Height of text block.</p>\n'
    )
    textBorderColor: Optional[Any] = Field(
        None, description='\n\n<p>Stroke color of the text.</p>\n'
    )
    textBorderWidth: Optional[float] = Field(
        None, description='\n\n<p>Stroke line width of the text.</p>\n'
    )
    textBorderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>Stroke line type of the text.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">textBorderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\ntextBorderType: [5, 10],\n\ntextBorderDashOffset: 5\n}\n</code></pre>\n',
    )
    textBorderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">textBorderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    textShadowColor: Optional[Any] = Field(
        'transparent', description='\n\n<p>Shadow color of the text itself.</p>\n'
    )
    textShadowBlur: Optional[float] = Field(
        0, description='\n\n<p>Shadow blue of the text itself.</p>\n'
    )
    textShadowOffsetX: Optional[float] = Field(
        0, description='\n\n<p>Shadow X offset of the text itself.</p>\n'
    )
    textShadowOffsetY: Optional[float] = Field(
        0, description='\n\n<p>Shadow Y offset of the text itself.</p>\n'
    )
    overflow: Optional[str] = Field(
        'none',
        description='\n\n<p>Determine how to display the text when it&#39;s overflow. Available when <code class="codespan">width</code> is set.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the text and trailing with <code class="codespan">ellipsis</code>.</li>\n<li><code class="codespan">&#39;break&#39;</code> Break by word</li>\n<li><code class="codespan">&#39;breakAll&#39;</code> Break by character.</li>\n</ul>\n',
    )
    ellipsis: Optional[str] = Field(
        '...',
        description='<p>Ellipsis to be displayed when <code class="codespan">overflow</code> is set to <code class="codespan">truncate</code>.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the overflow lines.</li>\n</ul>\n',
    )
    rich: Optional[Rich8] = Field(
        None,
        description='<p>&quot;Rich text styles&quot; can be defined in this <code class="codespan">rich</code> property. For example:</p>\n<pre><code class="lang-ts">label: {\n    // Styles defined in &#39;rich&#39; can be applied to some fragments\n    // of text by adding some markers to those fragment, like\n    // `{styleName|text content text content}`.\n    // `&#39;\\n&#39;` is the newline character.\n    formatter: [\n        &#39;{a|Style &quot;a&quot; is applied to this snippet}&#39;\n        &#39;{b|Style &quot;b&quot; is applied to this snippet}This snippet use default style{x|use style &quot;x&quot;}&#39;\n    ].join(&#39;\\n&#39;),\n\n    rich: {\n        a: {\n            color: &#39;red&#39;,\n            lineHeight: 10\n        },\n        b: {\n            backgroundColor: {\n                image: &#39;xxx/xxx.jpg&#39;\n            },\n            height: 40\n        },\n        x: {\n            fontSize: 18,\n            fontFamily: &#39;Microsoft YaHei&#39;,\n            borderColor: &#39;#449933&#39;,\n            borderRadius: 4\n        },\n        ...\n    }\n}\n</code></pre>\n<p>For more details, see <a href="tutorial.html#Rich%20Text" target="_blank">Rich Text</a> please.</p>\n',
    )


class LineStyle9(LineStyle3):
    pass


class AxisLine1(BaseModel):
    """
    <p>Settings related to axis line.</p>

    """

    show: Optional[bool] = Field(
        True,
        description='\n\n<p>Set this to <code class="codespan">false</code> to prevent the axis line from showing.</p>\n',
    )
    onZero: Optional[bool] = Field(
        True,
        description='\n\n<p>Specifies whether X or Y axis lies on the other&#39;s origin position, where value is 0 on axis. Valid only if the other axis is of value type, and contains 0 value.</p>\n',
    )
    onZeroAxisIndex: Optional[float] = Field(
        None,
        description='<p>When mutiple axes exists, this option can be used to specify which axis can be &quot;onZero&quot; to.</p>\n',
    )
    symbol: Optional[Union[str, Any]] = Field(
        'none',
        description='\n\n<p>Symbol of the two ends of the axis. It could be a string, representing the same symbol for two ends; or an array with two string elements, representing the two ends separately. It&#39;s set to be <code class="codespan">&#39;none&#39;</code> by default, meaning no arrow for either end. If it is set to be <code class="codespan">&#39;arrow&#39;</code>, there shall be two arrows. If there should only one arrow at the end, it should set to be <code class="codespan">[&#39;none&#39;, &#39;arrow&#39;]</code>.</p>\n',
    )
    symbolSize: Optional[Any] = Field(
        '[10, 15]',
        description='\n\n<p>Size of the arrows at two ends. The first is the width perpendicular to the axis, the next is the width parallel to the axis.</p>\n',
    )
    symbolOffset: Optional[Union[Any, float]] = Field(
        '[0, 0]',
        description='\n\n<p>Arrow offset of axis. If is array, the first number is the offset of the arrow at the beginning, and the second number is the offset of the arrow at the end. If is number, it means the arrows have the same offset.</p>\n',
    )
    lineStyle: Optional[LineStyle9] = Field(None, description='')


class LineStyle10(BaseModel):
    """
    <p>Line style of axis ticks.</p>

    """

    color: Optional[Any] = Field(
        None,
        description='<p>Color of axis label is set to be <a href="#yAxis.axisLine.lineStyle.color">axisLine.lineStyle.color</a> by default.</p>\n',
    )
    width: Optional[float] = Field(1, description='\n\n<p>axisTick line width.</p>\n')
    type: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>line type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">dashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\ntype: [5, 10],\n\ndashOffset: 5\n}\n</code></pre>\n',
    )
    dashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">type</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    cap: Optional[str] = Field(
        'butt',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To specify how to draw the end points of the line.\nPossible values are:</p>\n<ul>\n<li><code class="codespan">&#39;butt&#39;</code>: The ends of lines are squared off at the endpoints.</li>\n<li><code class="codespan">&#39;round&#39;</code>: The ends of lines are rounded.</li>\n<li><code class="codespan">&#39;square&#39;</code>: The ends of lines are squared off by adding a box with an equal width and half the height of the line&#39;s thickness.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;butt&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineCap" target="_blank">lineCap</a> for more details.</p>\n',
    )
    join: Optional[str] = Field(
        'bevel',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To determine the shape used to join two line segments where they meet.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;bevel&#39;</code>: Fills an additional triangular area between the common endpoint of connected segments, and the separate outside rectangular corners of each segment.</li>\n<li><code class="codespan">&#39;round&#39;</code>: Rounds off the corners of a shape by filling an additional sector of disc centered at the common endpoint of connected segments. The radius for these rounded corners is equal to the line width.</li>\n<li><code class="codespan">&#39;miter&#39;</code>: Connected segments are joined by extending their outside edges to connect at a single point, with the effect of filling an additional lozenge-shaped area. This setting is affected by the \n<code class="codespan">miterLimit</code>\nproperty.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;bevel&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineJoin" target="_blank">lineJoin</a> for more details.</p>\n',
    )
    miterLimit: Optional[float] = Field(
        10,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the miter limit ratio. Only works when \n<code class="codespan">join</code>\n is set as <code class="codespan">miter</code>.</p>\n<p>Default value is <code class="codespan">10</code>. Negative、<code class="codespan">0</code>、<code class="codespan">Infinity</code> and <code class="codespan">NaN</code> values are ignored.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/miterLimit" target="_blank">miterLimit</a> for more details.</p>\n',
    )
    shadowBlur: Optional[float] = Field(
        None,
        description='\n\n<p>Size of shadow blur. This attribute should be used along with <code class="codespan">shadowColor</code>,<code class="codespan">shadowOffsetX</code>, <code class="codespan">shadowOffsetY</code> to set shadow to component.</p>\n<p>For example:</p>\n<pre><code class="lang-ts">{\n    shadowColor: &#39;rgba(0, 0, 0, 0.5)&#39;,\n    shadowBlur: 10\n}\n</code></pre>\n',
    )
    shadowColor: Optional[Any] = Field(
        None,
        description='\n\n<p>Shadow color. Support same format as <code class="codespan">color</code>.</p>\n',
    )
    shadowOffsetX: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the horizontal direction of shadow.</p>\n',
    )
    shadowOffsetY: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the vertical direction of shadow.</p>\n',
    )
    opacity: Optional[float] = Field(
        None,
        description='\n\n<p>Opacity of the component. Supports value from 0 to 1, and the component will not be drawn when set to 0.</p>\n\n',
    )


class AxisTick1(BaseModel):
    """
    <p>Settings related to axis tick.</p>

    """

    show: Optional[bool] = Field(
        True,
        description='\n\n<p>Set this to <code class="codespan">false</code> to prevent the axis tick from showing.</p>\n',
    )
    alignWithLabel: Optional[bool] = Field(
        False,
        description='\n\n<p>Align axis tick with label, which is available only when <code class="codespan">boundaryGap</code> is set to be <code class="codespan">true</code> in category axis. See the following picture:</p>\n<p><img width="600" height="auto" src="documents/asset/img/axis-align-with-label.png"></p>\n',
    )
    interval: Optional[Union[float, Any]] = Field(
        'auto',
        description='\n\n\n\n<p>Interval of axisTick, which is available in category axis.  is set to be the same as <a href="#yAxis.axisLabel.interval">axisLabel.interval</a> by default.</p>\n<p>It uses a strategy that labels do not overlap by default.</p>\n<p>You may set it to be 0 to display all labels compulsively.</p>\n<p>If it is set to be 1, it means that labels are shown once after one label. And if it is set to be 2, it means labels are shown once after two labels, and so on.</p>\n<p>On the other hand, you can control by callback function, whose format is shown below:</p>\n<pre><code class="lang-ts">(index:number, value: string) =&gt; boolean\n</code></pre>\n<p>The first parameter is index of category, and the second parameter is the name of category. The return values decides whether to display label.</p>\n',
    )
    inside: Optional[bool] = Field(
        False,
        description='\n\n<p>Set this to <code class="codespan">true</code> so the axis labels face the <code class="codespan">inside</code> direction.</p>\n',
    )
    length: Optional[float] = Field(
        5, description='\n\n<p>The length of the axis tick.</p>\n'
    )
    lineStyle: Optional[LineStyle10] = Field(
        None, description='<p>Line style of axis ticks.</p>\n'
    )


class LineStyle11(BaseModel):
    color: Optional[Any] = Field(
        None,
        description='\n\n<p>Style configuration of minor ticks lines <a href="#yAxis.axisLine.lineStyle.color">axisLine.lineStyle.color</a>。</p>\n',
    )
    width: Optional[float] = Field(1, description='\n\n<p>minorTick line width.</p>\n')
    type: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>line type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">dashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\ntype: [5, 10],\n\ndashOffset: 5\n}\n</code></pre>\n',
    )
    dashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">type</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    cap: Optional[str] = Field(
        'butt',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To specify how to draw the end points of the line.\nPossible values are:</p>\n<ul>\n<li><code class="codespan">&#39;butt&#39;</code>: The ends of lines are squared off at the endpoints.</li>\n<li><code class="codespan">&#39;round&#39;</code>: The ends of lines are rounded.</li>\n<li><code class="codespan">&#39;square&#39;</code>: The ends of lines are squared off by adding a box with an equal width and half the height of the line&#39;s thickness.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;butt&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineCap" target="_blank">lineCap</a> for more details.</p>\n',
    )
    join: Optional[str] = Field(
        'bevel',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To determine the shape used to join two line segments where they meet.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;bevel&#39;</code>: Fills an additional triangular area between the common endpoint of connected segments, and the separate outside rectangular corners of each segment.</li>\n<li><code class="codespan">&#39;round&#39;</code>: Rounds off the corners of a shape by filling an additional sector of disc centered at the common endpoint of connected segments. The radius for these rounded corners is equal to the line width.</li>\n<li><code class="codespan">&#39;miter&#39;</code>: Connected segments are joined by extending their outside edges to connect at a single point, with the effect of filling an additional lozenge-shaped area. This setting is affected by the \n<code class="codespan">miterLimit</code>\nproperty.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;bevel&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineJoin" target="_blank">lineJoin</a> for more details.</p>\n',
    )
    miterLimit: Optional[float] = Field(
        10,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the miter limit ratio. Only works when \n<code class="codespan">join</code>\n is set as <code class="codespan">miter</code>.</p>\n<p>Default value is <code class="codespan">10</code>. Negative、<code class="codespan">0</code>、<code class="codespan">Infinity</code> and <code class="codespan">NaN</code> values are ignored.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/miterLimit" target="_blank">miterLimit</a> for more details.</p>\n',
    )
    shadowBlur: Optional[float] = Field(
        None,
        description='\n\n<p>Size of shadow blur. This attribute should be used along with <code class="codespan">shadowColor</code>,<code class="codespan">shadowOffsetX</code>, <code class="codespan">shadowOffsetY</code> to set shadow to component.</p>\n<p>For example:</p>\n<pre><code class="lang-ts">{\n    shadowColor: &#39;rgba(0, 0, 0, 0.5)&#39;,\n    shadowBlur: 10\n}\n</code></pre>\n',
    )
    shadowColor: Optional[Any] = Field(
        None,
        description='\n\n<p>Shadow color. Support same format as <code class="codespan">color</code>.</p>\n',
    )
    shadowOffsetX: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the horizontal direction of shadow.</p>\n',
    )
    shadowOffsetY: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the vertical direction of shadow.</p>\n',
    )
    opacity: Optional[float] = Field(
        None,
        description='\n\n<p>Opacity of the component. Supports value from 0 to 1, and the component will not be drawn when set to 0.</p>\n\n',
    )


class MinorTick1(BaseModel):
    """
        <blockquote>
    <p>Since <code class="codespan">v4.6.0</code></p>
    </blockquote>
    <p>Settings related minor ticks.</p>
    <p>Note: <code class="codespan">minorTick</code> is not available in the <code class="codespan">category</code> type axis.</p>
    <p>Examples:</p>
    <p>1) Using minor ticks in function plotting.</p>
    <iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=line-function&edit=1&reset=1" width="600" height="350"></iframe>


    <p>2) Using minor ticks in log axis.</p>
    <iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=line-log&edit=1&reset=1" width="600" height="350"></iframe>


    """

    show: Optional[bool] = Field(False, description='\n\n<p>If show minor ticks.</p>\n')
    splitNumber: Optional[float] = Field(
        5, description='\n\n<p>Number of interval splited by minor ticks.</p>\n'
    )
    length: Optional[float] = Field(
        3, description='\n\n<p>Length of minor ticks lines。</p>\n'
    )
    lineStyle: Optional[LineStyle11] = Field(None, description='')


class _StyleName9(_StyleName5):
    pass


class Rich9(BaseModel):
    """
        <p>&quot;Rich text styles&quot; can be defined in this <code class="codespan">rich</code> property. For example:</p>
    <pre><code class="lang-ts">label: {
        // Styles defined in &#39;rich&#39; can be applied to some fragments
        // of text by adding some markers to those fragment, like
        // `{styleName|text content text content}`.
        // `&#39;\n&#39;` is the newline character.
        formatter: [
            &#39;{a|Style &quot;a&quot; is applied to this snippet}&#39;
            &#39;{b|Style &quot;b&quot; is applied to this snippet}This snippet use default style{x|use style &quot;x&quot;}&#39;
        ].join(&#39;\n&#39;),

        rich: {
            a: {
                color: &#39;red&#39;,
                lineHeight: 10
            },
            b: {
                backgroundColor: {
                    image: &#39;xxx/xxx.jpg&#39;
                },
                height: 40
            },
            x: {
                fontSize: 18,
                fontFamily: &#39;Microsoft YaHei&#39;,
                borderColor: &#39;#449933&#39;,
                borderRadius: 4
            },
            ...
        }
    }
    </code></pre>
    <p>For more details, see <a href="tutorial.html#Rich%20Text" target="_blank">Rich Text</a> please.</p>

    """

    _style_name_: Optional[_StyleName9] = Field(
        None, alias='<style_name>', description=''
    )


class AxisLabel1(BaseModel):
    """
    <p>Settings related to axis label.</p>

    """

    show: Optional[bool] = Field(
        True,
        description='\n\n<p>Set this to <code class="codespan">false</code> to prevent the axis label from appearing.</p>\n',
    )
    interval: Optional[Union[float, Any]] = Field(
        'auto',
        description='\n\n\n\n<p>Interval of Axis label, which is available in category axis. </p>\n<p>It uses a strategy that labels do not overlap by default.</p>\n<p>You may set it to be 0 to display all labels compulsively.</p>\n<p>If it is set to be 1, it means that labels are shown once after one label. And if it is set to be 2, it means labels are shown once after two labels, and so on.</p>\n<p>On the other hand, you can control by callback function, whose format is shown below:</p>\n<pre><code class="lang-ts">(index:number, value: string) =&gt; boolean\n</code></pre>\n<p>The first parameter is index of category, and the second parameter is the name of category. The return values decides whether to display label.</p>\n',
    )
    inside: Optional[bool] = Field(
        False,
        description='\n\n<p>Set this to <code class="codespan">true</code> so the axis labels face the <code class="codespan">inside</code> direction.</p>\n',
    )
    rotate: Optional[float] = Field(
        0,
        description='\n\n<p>Rotation degree of axis label, which is especially useful when there is no enough space for category axis.</p>\n<p>Rotation degree is from -90 to 90.</p>\n',
    )
    margin: Optional[float] = Field(
        8,
        description='\n\n<p>The margin between the axis label and the axis line.</p>\n',
    )
    formatter: Optional[Union[str, Any]] = Field(
        None,
        description='<p>Formatter of axis label, which supports string template and callback function.</p>\n<p>Example:</p>\n<pre><code class="lang-ts">// Use string template; template variable is the default label of axis {value}\nformatter: &#39;{value} kg&#39;\n// Use callback.\nformatter: function (value, index) {\n    return value + &#39;kg&#39;;\n}\n</code></pre>\n<hr>\n<p>For axes of time <a href="#.type">type</a>: <code class="codespan">&#39;time&#39;</code>, <code class="codespan">formatter</code> supports the following forms:</p>\n<ul>\n<li><strong>String Templates</strong>: an easy and fast way to make frequently used date/time template, formed in <code class="codespan">string</code></li>\n<li><strong>Callback Functions</strong>: customized formatter to make complex format, formed in <code class="codespan">Function</code></li>\n<li><strong>Cascading Templates</strong>: to adopt different formatters for different time granularity, formed in <code class="codespan">object</code></li>\n</ul>\n<p>Next, we are going to introduce these three forms one by one.</p>\n<p><strong> String Templates </strong></p>\n<p>Using string templates is an easy way to format date/time with frequently used formats. If it can be used to make what you want, you are advised to do so. If not, you could then consider the others. Supported formats are:</p>\n<table>\n<thead>\n<tr>\n<th>Group</th>\n<th>Template</th>\n<th>Value (EN)</th>\n<th>Value (ZH)</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n<td>Year</td>\n<td>{yyyy}</td>\n<td>e.g., 2020, 2021, ...</td>\n<td>例：2020, 2021, ...</td>\n</tr>\n<tr>\n<td></td>\n<td>{yy}</td>\n<td>00-99</td>\n<td>00-99</td>\n</tr>\n<tr>\n<td>Quarter</td>\n<td>{Q}</td>\n<td>1, 2, 3, 4</td>\n<td>1, 2, 3, 4</td>\n</tr>\n<tr>\n<td>Month</td>\n<td>{MMMM}</td>\n<td>e.g., January, February, ...</td>\n<td>一月、二月、……</td>\n</tr>\n<tr>\n<td></td>\n<td>{MMM}</td>\n<td>e.g., Jan, Feb, ...</td>\n<td>1月、2月、……</td>\n</tr>\n<tr>\n<td></td>\n<td>{MM}</td>\n<td>01-12</td>\n<td>01-12</td>\n</tr>\n<tr>\n<td></td>\n<td>{M}</td>\n<td>1-12</td>\n<td>1-12</td>\n</tr>\n<tr>\n<td>Day of Month</td>\n<td>{dd}</td>\n<td>01-31</td>\n<td>01-31</td>\n</tr>\n<tr>\n<td></td>\n<td>{d}</td>\n<td>1-31</td>\n<td>1-31</td>\n</tr>\n<tr>\n<td>Day of Week</td>\n<td>{eeee}</td>\n<td>Sunday, Monday, Tuesday, Wednesday, Thursday, Friday, Saturday</td>\n<td>星期日、星期一、星期二、星期三、星期四、星期五、星期六</td>\n</tr>\n<tr>\n<td></td>\n<td>{ee}</td>\n<td>Sun, Mon, Tues, Wed, Thu, Fri, Sat</td>\n<td>日、一、二、三、四、五、六</td>\n</tr>\n<tr>\n<td></td>\n<td>{e}</td>\n<td>1-54</td>\n<td>1-54</td>\n</tr>\n<tr>\n<td>Hour</td>\n<td>{HH}</td>\n<td>00-23</td>\n<td>00-23</td>\n</tr>\n<tr>\n<td></td>\n<td>{H}</td>\n<td>0-23</td>\n<td>0-23</td>\n</tr>\n<tr>\n<td></td>\n<td>{hh}</td>\n<td>01-12</td>\n<td>01-12</td>\n</tr>\n<tr>\n<td></td>\n<td>{h}</td>\n<td>1-12</td>\n<td>1-12</td>\n</tr>\n<tr>\n<td>Minute</td>\n<td>{mm}</td>\n<td>00-59</td>\n<td>00-59</td>\n</tr>\n<tr>\n<td></td>\n<td>{m}</td>\n<td>0-59</td>\n<td>0-59</td>\n</tr>\n<tr>\n<td>Second</td>\n<td>{ss}</td>\n<td>00-59</td>\n<td>00-59</td>\n</tr>\n<tr>\n<td></td>\n<td>{s}</td>\n<td>0-59</td>\n<td>0-59</td>\n</tr>\n<tr>\n<td>Millisecond</td>\n<td>{SSS}</td>\n<td>000-999</td>\n<td>000-999</td>\n</tr>\n<tr>\n<td></td>\n<td>{S}</td>\n<td>0-999</td>\n<td>0-999</td>\n</tr>\n</tbody>\n</table>\n<blockquote>\n<p>Templates of other languages can be found in <a href="https://github.com/apache/echarts/tree/master/src/i18n" target="_blank">the language package</a>. Please refer to <a href="api.html#echarts.registerLocale" target="_blank">echarts.registerLocale</a> to register a language.</p>\n</blockquote>\n<p>Example:</p>\n<pre><code class="lang-ts">formatter: &#39;{yyyy}-{MM}-{dd}&#39; // gets labels like &#39;2020-12-02&#39;\nformatter: &#39;Day {d}&#39; // gets labels like &#39;Day 2&#39;\n</code></pre>\n<p><strong> Callback Functions </strong></p>\n<p>Callback functions can be used to get different formats for different axis tick values. Sometimes, if you have complex date/time formatting requirement, third-party libraries like <a href="https://momentjs.com/" target="_blank">Moment.js</a> or <a href="https://date-fns.org/" target="_blank">date-fns</a> can be used to return formatted labels.</p>\n<p>Example:</p>\n<pre><code class="lang-ts">// Use callback function; function parameters are axis index\nformatter: function (value, index) {\n    // Formatted to be month/day; display year only in the first label\n    var date = new Date(value);\n    var texts = [(date.getMonth() + 1), date.getDate()];\n    if (index === 0) {\n        texts.unshift(date.getYear());\n    }\n    return texts.join(&#39;/&#39;);\n}\n</code></pre>\n<p><strong> Cascading Templates </strong></p>\n<p>Sometimes, we wish to use different formats for different time granularity. For example, in a quarter-year chart, we may wish to see the month name with the first date of the month, while see the date name with others. This can be made with:</p>\n<p>Example:</p>\n<pre><code class="lang-ts">formatter: {\n    month: &#39;{MMMM}&#39;, // Jan, Feb, ...\n    day: &#39;{d}&#39; // 1, 2, ...\n}\n</code></pre>\n<p>Supported levels and their default formatters are:</p>\n<pre><code class="lang-ts">{\n    year: &#39;{yyyy}&#39;,\n    month: &#39;{MMM}&#39;,\n    day: &#39;{d}&#39;,\n    hour: &#39;{HH}:{mm}&#39;,\n    minute: &#39;{HH}:{mm}&#39;,\n    second: &#39;{HH}:{mm}:{ss}&#39;,\n    millisecond: &#39;{hh}:{mm}:{ss} {SSS}&#39;,\n    none: &#39;{yyyy}-{MM}-{dd} {hh}:{mm}:{ss} {SSS}&#39;\n}\n</code></pre>\n<p>Let&#39;s take <code class="codespan">day</code> for example. When a tick value is <code class="codespan">0</code> for its hour, minute, second, and millisecond, <code class="codespan">day</code> level will be used to make formatter. <code class="codespan">none</code> is used when no other level fulfills, which is for tick values with millisecond values other than <code class="codespan">0</code>.</p>\n<p><strong> Rich Text </strong></p>\n<p>The above three forms all support rich text, so it can be used to make some complex effects.</p>\n<p>Example:</p>\n<pre><code class="lang-ts">xAxis: {\n    type: &#39;time&#39;,\n    axisLabel: {\n        formatter: {\n            // Display year and month information on the first data of a year\n            year: &#39;{yearStyle|{yyyy}}\\n{monthStyle|{MMM}}&#39;,\n            month: &#39;{monthStyle|{MMM}}&#39;\n        },\n        rich: {\n            yearStyle: {\n                // Make yearly text more standing out\n                color: &#39;#000&#39;,\n                fontWeight: &#39;bold&#39;\n            },\n            monthStyle: {\n                color: &#39;#999&#39;\n            }\n        }\n    }\n},\n</code></pre>\n<p>The above example can also be made with a callback function:</p>\n<p>Example:</p>\n<pre><code class="lang-ts">xAxis: {\n    type: &#39;time&#39;,\n    axisLabel: {\n        formatter: function (value) {\n            const date = new Date(value);\n            const yearStart = new Date(value);\n            yearStart.setMonth(0);\n            yearStart.setDate(1);\n            yearStart.setHours(0);\n            yearStart.setMinutes(0);\n            yearStart.setSeconds(0);\n            yearStart.setMilliseconds(0);\n            // Whether a tick value is the start of a year\n            if (date.getTime() === yearStart.getTime()) {\n                return &#39;{year|&#39; + date.getFullYear() + &#39;}\\n&#39;\n                    + &#39;{month|&#39; + (date.getMonth() + 1) + &#39;月}&#39;;\n            }\n            else {\n                return &#39;{month|&#39; + (date.getMonth() + 1) + &#39;月}&#39;\n            }\n        },\n        rich: {\n            year: {\n                color: &#39;#000&#39;,\n                fontWeight: &#39;bold&#39;\n            },\n            month: {\n                color: &#39;#999&#39;\n            }\n        }\n    }\n},\n</code></pre>\n',
    )
    showMinLabel: Optional[bool] = Field(
        None,
        description='\n\n<p>Whether to show the label of the min tick. Optional values: <code class="codespan">true</code>, <code class="codespan">false</code>, <code class="codespan">null</code>. It is auto determined by default, that is, if labels are overlapped, the label of the min tick will not be displayed.</p>\n',
    )
    showMaxLabel: Optional[bool] = Field(
        None,
        description='\n\n<p>Whether to show the label of the max tick. Optional values: <code class="codespan">true</code>, <code class="codespan">false</code>, <code class="codespan">null</code>. It is auto determined by default, that is, if labels are overlapped, the label of the max tick will not be displayed.</p>\n',
    )
    hideOverlap: Optional[bool] = Field(
        None,
        description='\n\n\n\n<blockquote>\n<p>Since <code class="codespan">v5.2.0</code></p>\n</blockquote>\n<p>Whether to hide overlapped labels.</p>\n',
    )
    color: Optional[Union[Any, Any]] = Field(
        None,
        description='\n\n<p>Color of axis label is set to be <a href="#yAxis.axisLine.lineStyle.color">axisLine.lineStyle.color</a> by default. Callback function is supported, in the following format:</p>\n<pre><code class="lang-ts">(val: string) =&gt; Color\n</code></pre>\n<p>Parameter is the text of label, and return value is the color. See the following example:</p>\n<pre><code class="lang-ts">textStyle: {\n    color: function (value, index) {\n        return value &gt;= 0 ? &#39;green&#39; : &#39;red&#39;;\n    }\n}\n</code></pre>\n',
    )
    fontStyle: Optional[str] = Field(
        'normal',
        description='\n\n<p> font style.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;italic&#39;</code></li>\n<li><code class="codespan">&#39;oblique&#39;</code></li>\n</ul>\n',
    )
    fontWeight: Optional[Union[str, float]] = Field(
        'normal',
        description='\n\n<p> font thick weight.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;bold&#39;</code></li>\n<li><code class="codespan">&#39;bolder&#39;</code></li>\n<li><code class="codespan">&#39;lighter&#39;</code></li>\n<li>100 | 200 | 300 | 400...</li>\n</ul>\n',
    )
    fontFamily: Optional[str] = Field(
        'sans-serif',
        description='\n\n<p> font family.</p>\n<p>Can also be &#39;serif&#39; , &#39;monospace&#39;, ...</p>\n',
    )
    fontSize: Optional[float] = Field(12, description='\n\n<p> font size.</p>\n')
    align: Optional[str] = Field(
        None,
        description='\n\n<p>Horizontal alignment of text, automatic by default.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;left&#39;</code></li>\n<li><code class="codespan">&#39;center&#39;</code></li>\n<li><code class="codespan">&#39;right&#39;</code></li>\n</ul>\n<p>If <code class="codespan">align</code> is not set in <code class="codespan">rich</code>, <code class="codespan">align</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    align: right,\n    rich: {\n        a: {\n            // `align` is not set, then it will be right\n        }\n    }\n}\n</code></pre>\n',
    )
    verticalAlign: Optional[str] = Field(
        None,
        description='\n\n<p>Vertical alignment of text, automatic by default.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;top&#39;</code></li>\n<li><code class="codespan">&#39;middle&#39;</code></li>\n<li><code class="codespan">&#39;bottom&#39;</code></li>\n</ul>\n<p>If <code class="codespan">verticalAlign</code> is not set in <code class="codespan">rich</code>, <code class="codespan">verticalAlign</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    verticalAlign: bottom,\n    rich: {\n        a: {\n            // `verticalAlign` is not set, then it will be bottom\n        }\n    }\n}\n</code></pre>\n',
    )
    lineHeight: Optional[float] = Field(
        None,
        description='\n\n<p>Line height of the text fragment.</p>\n<p>If <code class="codespan">lineHeight</code> is not set in <code class="codespan">rich</code>, <code class="codespan">lineHeight</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    lineHeight: 56,\n    rich: {\n        a: {\n            // `lineHeight` is not set, then it will be 56\n        }\n    }\n}\n</code></pre>\n',
    )
    backgroundColor: Optional[Union[str, Any]] = Field(
        'transparent',
        description='\n\n<p>Background color of the text fragment.</p>\n<p>Can be color string, like <code class="codespan">&#39;#123234&#39;</code>, <code class="codespan">&#39;red&#39;</code>, <code class="codespan">&#39;rgba(0,23,11,0.3)&#39;</code>.</p>\n<p>Or image can be used, for example:</p>\n<pre><code class="lang-ts">backgroundColor: {\n    image: &#39;xxx/xxx.png&#39;\n    // It can be URL of a image,\n    // or dataURI,\n    // or HTMLImageElement,\n    // or HTMLCanvasElement.\n}\n</code></pre>\n<p><code class="codespan">width</code> or <code class="codespan">height</code> can be specified when using background image, or\nauto adapted by default.</p>\n',
    )
    borderColor: Optional[Any] = Field(
        None, description='\n\n<p>Border color of the text fragment.</p>\n'
    )
    borderWidth: Optional[float] = Field(
        0, description='\n\n<p>Border width of the text fragment.</p>\n'
    )
    borderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>the text fragment border type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">borderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\nborderType: [5, 10],\n\nborderDashOffset: 5\n}\n</code></pre>\n',
    )
    borderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">borderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    borderRadius: Optional[float] = Field(
        0, description='\n\n<p>Border radius of the text fragment.</p>\n'
    )
    padding: Optional[Union[float, Any]] = Field(
        0,
        description='\n\n<p>Padding of the text fragment, for example:</p>\n<ul>\n<li><code class="codespan">padding: [3, 4, 5, 6]</code>: represents padding of <code class="codespan">[top, right, bottom, left]</code>.</li>\n<li><code class="codespan">padding: 4</code>: represents <code class="codespan">padding: [4, 4, 4, 4]</code>.</li>\n<li><code class="codespan">padding: [3, 4]</code>: represents <code class="codespan">padding: [3, 4, 3, 4]</code>.</li>\n</ul>\n<p>Notice, <code class="codespan">width</code> and <code class="codespan">height</code> specifies the width and height of the content, without <code class="codespan">padding</code>.</p>\n',
    )
    shadowColor: Optional[Any] = Field(
        'transparent', description='\n\n<p>Shadow color of the text block.</p>\n'
    )
    shadowBlur: Optional[float] = Field(
        0, description='\n\n<p>Show blur of the text block.</p>\n'
    )
    shadowOffsetX: Optional[float] = Field(
        0, description='\n\n<p>Shadow X offset of the text block.</p>\n'
    )
    shadowOffsetY: Optional[float] = Field(
        0, description='\n\n<p>Shadow Y offset of the text block.</p>\n'
    )
    width: Optional[float] = Field(
        None, description='\n\n<p>Width of text block.</p>\n'
    )
    height: Optional[float] = Field(
        None, description='\n\n<p>Height of text block.</p>\n'
    )
    textBorderColor: Optional[Any] = Field(
        None, description='\n\n<p>Stroke color of the text.</p>\n'
    )
    textBorderWidth: Optional[float] = Field(
        None, description='\n\n<p>Stroke line width of the text.</p>\n'
    )
    textBorderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>Stroke line type of the text.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">textBorderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\ntextBorderType: [5, 10],\n\ntextBorderDashOffset: 5\n}\n</code></pre>\n',
    )
    textBorderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">textBorderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    textShadowColor: Optional[Any] = Field(
        'transparent', description='\n\n<p>Shadow color of the text itself.</p>\n'
    )
    textShadowBlur: Optional[float] = Field(
        0, description='\n\n<p>Shadow blue of the text itself.</p>\n'
    )
    textShadowOffsetX: Optional[float] = Field(
        0, description='\n\n<p>Shadow X offset of the text itself.</p>\n'
    )
    textShadowOffsetY: Optional[float] = Field(
        0, description='\n\n<p>Shadow Y offset of the text itself.</p>\n'
    )
    overflow: Optional[str] = Field(
        'none',
        description='\n\n<p>Determine how to display the text when it&#39;s overflow. Available when <code class="codespan">width</code> is set.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the text and trailing with <code class="codespan">ellipsis</code>.</li>\n<li><code class="codespan">&#39;break&#39;</code> Break by word</li>\n<li><code class="codespan">&#39;breakAll&#39;</code> Break by character.</li>\n</ul>\n',
    )
    ellipsis: Optional[str] = Field(
        '...',
        description='<p>Ellipsis to be displayed when <code class="codespan">overflow</code> is set to <code class="codespan">truncate</code>.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the overflow lines.</li>\n</ul>\n',
    )
    rich: Optional[Rich9] = Field(
        None,
        description='<p>&quot;Rich text styles&quot; can be defined in this <code class="codespan">rich</code> property. For example:</p>\n<pre><code class="lang-ts">label: {\n    // Styles defined in &#39;rich&#39; can be applied to some fragments\n    // of text by adding some markers to those fragment, like\n    // `{styleName|text content text content}`.\n    // `&#39;\\n&#39;` is the newline character.\n    formatter: [\n        &#39;{a|Style &quot;a&quot; is applied to this snippet}&#39;\n        &#39;{b|Style &quot;b&quot; is applied to this snippet}This snippet use default style{x|use style &quot;x&quot;}&#39;\n    ].join(&#39;\\n&#39;),\n\n    rich: {\n        a: {\n            color: &#39;red&#39;,\n            lineHeight: 10\n        },\n        b: {\n            backgroundColor: {\n                image: &#39;xxx/xxx.jpg&#39;\n            },\n            height: 40\n        },\n        x: {\n            fontSize: 18,\n            fontFamily: &#39;Microsoft YaHei&#39;,\n            borderColor: &#39;#449933&#39;,\n            borderRadius: 4\n        },\n        ...\n    }\n}\n</code></pre>\n<p>For more details, see <a href="tutorial.html#Rich%20Text" target="_blank">Rich Text</a> please.</p>\n',
    )


class LineStyle12(LineStyle6):
    pass


class SplitLine1(BaseModel):
    """
    <p>Split line of axis in <a href="#grid">grid</a> area.</p>

    """

    show: Optional[bool] = Field(
        True,
        description='\n\n<p>Set this to <code class="codespan">false</code> to prevent the splitLine from showing.\n<code class="codespan">value</code> type axes are shown by default, while <code class="codespan">category</code> type axes are hidden.</p>\n',
    )
    interval: Optional[Union[float, Any]] = Field(
        'auto',
        description='\n\n\n\n<p>Interval of Axis splitLine, which is available in category axis.  is set to be the same as <a href="#yAxis.axisLabel.interval">axisLabel.interval</a> by default.</p>\n<p>It uses a strategy that labels do not overlap by default.</p>\n<p>You may set it to be 0 to display all labels compulsively.</p>\n<p>If it is set to be 1, it means that labels are shown once after one label. And if it is set to be 2, it means labels are shown once after two labels, and so on.</p>\n<p>On the other hand, you can control by callback function, whose format is shown below:</p>\n<pre><code class="lang-ts">(index:number, value: string) =&gt; boolean\n</code></pre>\n<p>The first parameter is index of category, and the second parameter is the name of category. The return values decides whether to display label.</p>\n',
    )
    lineStyle: Optional[LineStyle12] = Field(None, description='')


class LineStyle13(LineStyle7):
    pass


class MinorSplitLine1(BaseModel):
    """
        <blockquote>
    <p>Since <code class="codespan">v4.6.0</code></p>
    </blockquote>
    <p>Minor split lines of axis in the <a href="#grid">grid</a> area。It will align to the <a href="#yAxis.minorTick">minorTick</a></p>

    """

    show: Optional[bool] = Field(
        False, description='\n\n<p>If show minor split lines.</p>\n'
    )
    lineStyle: Optional[LineStyle13] = Field(None, description='')


class AreaStyle1(AreaStyle):
    """
    <p>Split area style.</p>

    """

    pass


class SplitArea1(BaseModel):
    """
    <p>Split area of axis in <a href="#grid">grid</a> area, not shown by default.</p>

    """

    interval: Optional[Union[float, Any]] = Field(
        'auto',
        description='\n\n\n\n<p>Interval of Axis splitArea, which is available in category axis.  is set to be the same as <a href="#yAxis.axisLabel.interval">axisLabel.interval</a> by default.</p>\n<p>It uses a strategy that labels do not overlap by default.</p>\n<p>You may set it to be 0 to display all labels compulsively.</p>\n<p>If it is set to be 1, it means that labels are shown once after one label. And if it is set to be 2, it means labels are shown once after two labels, and so on.</p>\n<p>On the other hand, you can control by callback function, whose format is shown below:</p>\n<pre><code class="lang-ts">(index:number, value: string) =&gt; boolean\n</code></pre>\n<p>The first parameter is index of category, and the second parameter is the name of category. The return values decides whether to display label.</p>\n',
    )
    show: Optional[bool] = Field(
        False,
        description='\n\n<p>Set this to <code class="codespan">true</code> to show the splitArea.</p>\n',
    )
    areaStyle: Optional[AreaStyle1] = Field(
        None, description='<p>Split area style.</p>\n'
    )


class _StyleName10(_StyleName):
    pass


class Rich10(BaseModel):
    """
        <p>&quot;Rich text styles&quot; can be defined in this <code class="codespan">rich</code> property. For example:</p>
    <pre><code class="lang-ts">label: {
        // Styles defined in &#39;rich&#39; can be applied to some fragments
        // of text by adding some markers to those fragment, like
        // `{styleName|text content text content}`.
        // `&#39;\n&#39;` is the newline character.
        formatter: [
            &#39;{a|Style &quot;a&quot; is applied to this snippet}&#39;
            &#39;{b|Style &quot;b&quot; is applied to this snippet}This snippet use default style{x|use style &quot;x&quot;}&#39;
        ].join(&#39;\n&#39;),

        rich: {
            a: {
                color: &#39;red&#39;,
                lineHeight: 10
            },
            b: {
                backgroundColor: {
                    image: &#39;xxx/xxx.jpg&#39;
                },
                height: 40
            },
            x: {
                fontSize: 18,
                fontFamily: &#39;Microsoft YaHei&#39;,
                borderColor: &#39;#449933&#39;,
                borderRadius: 4
            },
            ...
        }
    }
    </code></pre>
    <p>For more details, see <a href="tutorial.html#Rich%20Text" target="_blank">Rich Text</a> please.</p>

    """

    _style_name_: Optional[_StyleName10] = Field(
        None, alias='<style_name>', description=''
    )


class TextStyle4(BaseModel):
    """
    <p>Text style of the category.</p>

    """

    color: Optional[Any] = Field('#fff', description='\n\n<p> text color.</p>\n')
    fontStyle: Optional[str] = Field(
        'normal',
        description='\n\n<p> font style.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;italic&#39;</code></li>\n<li><code class="codespan">&#39;oblique&#39;</code></li>\n</ul>\n',
    )
    fontWeight: Optional[Union[str, float]] = Field(
        'normal',
        description='\n\n<p> font thick weight.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;bold&#39;</code></li>\n<li><code class="codespan">&#39;bolder&#39;</code></li>\n<li><code class="codespan">&#39;lighter&#39;</code></li>\n<li>100 | 200 | 300 | 400...</li>\n</ul>\n',
    )
    fontFamily: Optional[str] = Field(
        'sans-serif',
        description='\n\n<p> font family.</p>\n<p>Can also be &#39;serif&#39; , &#39;monospace&#39;, ...</p>\n',
    )
    fontSize: Optional[float] = Field(12, description='\n\n<p> font size.</p>\n')
    align: Optional[str] = Field(
        None,
        description='\n\n<p>Horizontal alignment of text, automatic by default.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;left&#39;</code></li>\n<li><code class="codespan">&#39;center&#39;</code></li>\n<li><code class="codespan">&#39;right&#39;</code></li>\n</ul>\n<p>If <code class="codespan">align</code> is not set in <code class="codespan">rich</code>, <code class="codespan">align</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    align: right,\n    rich: {\n        a: {\n            // `align` is not set, then it will be right\n        }\n    }\n}\n</code></pre>\n',
    )
    verticalAlign: Optional[str] = Field(
        None,
        description='\n\n<p>Vertical alignment of text, automatic by default.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;top&#39;</code></li>\n<li><code class="codespan">&#39;middle&#39;</code></li>\n<li><code class="codespan">&#39;bottom&#39;</code></li>\n</ul>\n<p>If <code class="codespan">verticalAlign</code> is not set in <code class="codespan">rich</code>, <code class="codespan">verticalAlign</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    verticalAlign: bottom,\n    rich: {\n        a: {\n            // `verticalAlign` is not set, then it will be bottom\n        }\n    }\n}\n</code></pre>\n',
    )
    lineHeight: Optional[float] = Field(
        None,
        description='\n\n<p>Line height of the text fragment.</p>\n<p>If <code class="codespan">lineHeight</code> is not set in <code class="codespan">rich</code>, <code class="codespan">lineHeight</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    lineHeight: 56,\n    rich: {\n        a: {\n            // `lineHeight` is not set, then it will be 56\n        }\n    }\n}\n</code></pre>\n',
    )
    backgroundColor: Optional[Union[str, Any]] = Field(
        'transparent',
        description='\n\n<p>Background color of the text fragment.</p>\n<p>Can be color string, like <code class="codespan">&#39;#123234&#39;</code>, <code class="codespan">&#39;red&#39;</code>, <code class="codespan">&#39;rgba(0,23,11,0.3)&#39;</code>.</p>\n<p>Or image can be used, for example:</p>\n<pre><code class="lang-ts">backgroundColor: {\n    image: &#39;xxx/xxx.png&#39;\n    // It can be URL of a image,\n    // or dataURI,\n    // or HTMLImageElement,\n    // or HTMLCanvasElement.\n}\n</code></pre>\n<p><code class="codespan">width</code> or <code class="codespan">height</code> can be specified when using background image, or\nauto adapted by default.</p>\n',
    )
    borderColor: Optional[Any] = Field(
        None, description='\n\n<p>Border color of the text fragment.</p>\n'
    )
    borderWidth: Optional[float] = Field(
        0, description='\n\n<p>Border width of the text fragment.</p>\n'
    )
    borderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>the text fragment border type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">borderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\nborderType: [5, 10],\n\nborderDashOffset: 5\n}\n</code></pre>\n',
    )
    borderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">borderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    borderRadius: Optional[float] = Field(
        0, description='\n\n<p>Border radius of the text fragment.</p>\n'
    )
    padding: Optional[Union[float, Any]] = Field(
        0,
        description='\n\n<p>Padding of the text fragment, for example:</p>\n<ul>\n<li><code class="codespan">padding: [3, 4, 5, 6]</code>: represents padding of <code class="codespan">[top, right, bottom, left]</code>.</li>\n<li><code class="codespan">padding: 4</code>: represents <code class="codespan">padding: [4, 4, 4, 4]</code>.</li>\n<li><code class="codespan">padding: [3, 4]</code>: represents <code class="codespan">padding: [3, 4, 3, 4]</code>.</li>\n</ul>\n<p>Notice, <code class="codespan">width</code> and <code class="codespan">height</code> specifies the width and height of the content, without <code class="codespan">padding</code>.</p>\n',
    )
    shadowColor: Optional[Any] = Field(
        'transparent', description='\n\n<p>Shadow color of the text block.</p>\n'
    )
    shadowBlur: Optional[float] = Field(
        0, description='\n\n<p>Show blur of the text block.</p>\n'
    )
    shadowOffsetX: Optional[float] = Field(
        0, description='\n\n<p>Shadow X offset of the text block.</p>\n'
    )
    shadowOffsetY: Optional[float] = Field(
        0, description='\n\n<p>Shadow Y offset of the text block.</p>\n'
    )
    width: Optional[float] = Field(
        None, description='\n\n<p>Width of text block.</p>\n'
    )
    height: Optional[float] = Field(
        None, description='\n\n<p>Height of text block.</p>\n'
    )
    textBorderColor: Optional[Any] = Field(
        None, description='\n\n<p>Stroke color of the text.</p>\n'
    )
    textBorderWidth: Optional[float] = Field(
        None, description='\n\n<p>Stroke line width of the text.</p>\n'
    )
    textBorderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>Stroke line type of the text.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">textBorderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\ntextBorderType: [5, 10],\n\ntextBorderDashOffset: 5\n}\n</code></pre>\n',
    )
    textBorderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">textBorderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    textShadowColor: Optional[Any] = Field(
        'transparent', description='\n\n<p>Shadow color of the text itself.</p>\n'
    )
    textShadowBlur: Optional[float] = Field(
        0, description='\n\n<p>Shadow blue of the text itself.</p>\n'
    )
    textShadowOffsetX: Optional[float] = Field(
        0, description='\n\n<p>Shadow X offset of the text itself.</p>\n'
    )
    textShadowOffsetY: Optional[float] = Field(
        0, description='\n\n<p>Shadow Y offset of the text itself.</p>\n'
    )
    overflow: Optional[str] = Field(
        'none',
        description='\n\n<p>Determine how to display the text when it&#39;s overflow. Available when <code class="codespan">width</code> is set.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the text and trailing with <code class="codespan">ellipsis</code>.</li>\n<li><code class="codespan">&#39;break&#39;</code> Break by word</li>\n<li><code class="codespan">&#39;breakAll&#39;</code> Break by character.</li>\n</ul>\n',
    )
    ellipsis: Optional[str] = Field(
        '...',
        description='<p>Ellipsis to be displayed when <code class="codespan">overflow</code> is set to <code class="codespan">truncate</code>.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the overflow lines.</li>\n</ul>\n',
    )
    rich: Optional[Rich10] = Field(
        None,
        description='<p>&quot;Rich text styles&quot; can be defined in this <code class="codespan">rich</code> property. For example:</p>\n<pre><code class="lang-ts">label: {\n    // Styles defined in &#39;rich&#39; can be applied to some fragments\n    // of text by adding some markers to those fragment, like\n    // `{styleName|text content text content}`.\n    // `&#39;\\n&#39;` is the newline character.\n    formatter: [\n        &#39;{a|Style &quot;a&quot; is applied to this snippet}&#39;\n        &#39;{b|Style &quot;b&quot; is applied to this snippet}This snippet use default style{x|use style &quot;x&quot;}&#39;\n    ].join(&#39;\\n&#39;),\n\n    rich: {\n        a: {\n            color: &#39;red&#39;,\n            lineHeight: 10\n        },\n        b: {\n            backgroundColor: {\n                image: &#39;xxx/xxx.jpg&#39;\n            },\n            height: 40\n        },\n        x: {\n            fontSize: 18,\n            fontFamily: &#39;Microsoft YaHei&#39;,\n            borderColor: &#39;#449933&#39;,\n            borderRadius: 4\n        },\n        ...\n    }\n}\n</code></pre>\n<p>For more details, see <a href="tutorial.html#Rich%20Text" target="_blank">Rich Text</a> please.</p>\n',
    )


class Datum2(BaseModel):
    value: Optional[str] = Field(None, description='<p>Name of a category.</p>\n')
    textStyle: Optional[TextStyle4] = Field(
        None, description='<p>Text style of the category.</p>\n'
    )


class Label2(Label):
    """
    <p>label of axisPointer</p>

    """

    pass


class LineStyle14(LineStyle2):
    """
    <p>It is valid when <a href="#tooltip.axisPointer.type">axisPointer.type</a> is <code class="codespan">&#39;line&#39;</code>.</p>

    """

    pass


class ShadowStyle2(ShadowStyle):
    """
    <p>It is valid when <a href="#tooltip.axisPointer.type">axisPointer.type</a> is <code class="codespan">&#39;shadow&#39;</code>.</p>

    """

    pass


class Handle1(Handle):
    """
    <p>A button used to drag axisPointer. This feature is applicable in touch device. See <a href="http://localhost/echarts-website/examples/en/editor.html?c=line-tooltip-touch&amp;edit=1&amp;reset=1" target="_blank">example</a>.</p>

    """

    pass


class AxisPointer2(BaseModel):
    """
    <p>axisPointer settings on the axis.</p>

    """

    show: Optional[bool] = Field(
        False,
        description='\n\n<p>axisPointer will not be displayed by default. But if <a href="#tooltip.trigger">tooltip.trigger</a> is set as <code class="codespan">&#39;axis&#39;</code> or <a href="#tooltip.axisPointer.type">tooltip.axisPointer.type</a> is set as  <code class="codespan">&#39;cross&#39;</code>, axisPointer will be displayed automatically. Each coordinate system will automatically chose the axes whose will display its axisPointer. <a href="#tooltip.axisPointer.axis">tooltip.axisPointer.axis</a> can be used to change the choice.</p>\n',
    )
    type: Optional[str] = Field(
        'line',
        description='\n\n<p>Indicator type.</p>\n<p>Options:</p>\n<ul>\n<li><p><code class="codespan">&#39;line&#39;</code> line indicator.</p>\n</li>\n<li><p><code class="codespan">&#39;shadow&#39;</code> shadow crosshair indicator.</p>\n</li>\n<li><p><code class="codespan">&#39;none&#39;</code> no indicator displayed.</p>\n</li>\n</ul>\n',
    )
    snap: Optional[bool] = Field(
        None,
        description='<p>Whether snap to point automatically. The default value is auto determined.</p>\n<p>This feature usually makes sense in value axis and time axis, where tiny points can be seeked automatically.</p>\n',
    )
    z: Optional[float] = Field(
        None,
        description='<p>z value, which controls order of drawing graphical components. Components with smaller <code class="codespan">z</code> values may be overwritten by those with larger <code class="codespan">z</code> values.</p>\n',
    )
    label: Optional[Label2] = Field(None, description='<p>label of axisPointer</p>\n')
    lineStyle: Optional[LineStyle14] = Field(
        None,
        description='<p>It is valid when <a href="#tooltip.axisPointer.type">axisPointer.type</a> is <code class="codespan">&#39;line&#39;</code>.</p>\n',
    )
    shadowStyle: Optional[ShadowStyle2] = Field(
        None,
        description='<p>It is valid when <a href="#tooltip.axisPointer.type">axisPointer.type</a> is <code class="codespan">&#39;shadow&#39;</code>.</p>\n',
    )
    triggerTooltip: Optional[bool] = Field(
        True, description='\n\n<p>Whether to trigger tooltip.</p>\n'
    )
    value: Optional[float] = Field(
        None,
        description='<p>current value. When using <a href="xAxisPointer.handle" target="_blank">axisPointer.handle</a>, <code class="codespan">value</code> can be set to define the initial position of axisPointer.</p>\n',
    )
    status: Optional[bool] = Field(
        None,
        description='\n\n<p>Current status, can be <code class="codespan">&#39;show&#39;</code> 和 <code class="codespan">&#39;hide&#39;</code>.</p>\n',
    )
    handle: Optional[Handle1] = Field(
        None,
        description='<p>A button used to drag axisPointer. This feature is applicable in touch device. See <a href="http://localhost/echarts-website/examples/en/editor.html?c=line-tooltip-touch&amp;edit=1&amp;reset=1" target="_blank">example</a>.</p>\n',
    )


class YAxis(BaseModel):
    """
    <p>The y axis in cartesian(rectangular) coordinate. Usually a single grid component can place at most 2 y axis, one on the left and another on the right. <a href="#yAxis.offset">offset</a> can be used to avoid overlap when you need to put more than two y axis.</p>

    """

    id: Optional[str] = Field(
        None,
        description='<p>Component ID, not specified by default. If specified, it can be used to refer the component in option or API.</p>\n',
    )
    show: Optional[bool] = Field(
        True,
        description='\n\n<p>Set this to <code class="codespan">false</code> to prevent the axis from showing.</p>\n',
    )
    gridIndex: Optional[float] = Field(
        0,
        description='<p>The index of grid which the y axis belongs to. Defaults to be in the first grid.</p>\n',
    )
    alignTicks: Optional[bool] = Field(
        False,
        description='<blockquote>\n<p>Since <code class="codespan">v5.3.0</code></p>\n</blockquote>\n<p><code class="codespan">alignTicks</code> turned on to automatically align ticks when multiple numeric y axes. Only available for axes of type <code class="codespan">&#39;value&#39;</code> and <code class="codespan">&#39;log&#39;</code>.</p>\n',
    )
    position: Optional[str] = Field(
        None,
        description='\n\n<p>the position of y axis.</p>\n<p>options:</p>\n<ul>\n<li><code class="codespan">&#39;left&#39;</code></li>\n<li><code class="codespan">&#39;right&#39;</code></li>\n</ul>\n<p>The first y axis in grid defaults to be the left (<code class="codespan">&#39;left&#39;</code>)  of the grid, and the second y axis is on the other side against the first y axis.<br>Notice: Set <code class="codespan">yAxis.axisLine.onZero</code> to <code class="codespan">false</code> to activate this option.</p>\n',
    )
    offset: Optional[float] = Field(
        0,
        description='\n\n<p>Offset of y axis relative to default position. Useful when multiple y axis has same <a href="#yAxis.position">position</a> value.\nNotice: Set <code class="codespan">yAxis.axisLine.onZero</code> to <code class="codespan">false</code> to activate this option.</p>\n',
    )
    type: Optional[str] = Field(
        'value',
        description='<p>Type of axis.</p>\n<p>Option:</p>\n<ul>\n<li><p><code class="codespan">&#39;value&#39;</code>\n  Numerical axis, suitable for continuous data.</p>\n</li>\n<li><p><code class="codespan">&#39;category&#39;</code>\n  Category axis, suitable for discrete category data. Category data can be auto retrieved from <a href="#series.data">series.data</a> or <a href="#dataset.source">dataset.source</a>, or can be specified via <a href="#yAxis.data">yAxis.data</a>.</p>\n</li>\n<li><p><code class="codespan">&#39;time&#39;</code>\n  Time axis, suitable for continuous time series data. As compared to value axis, it has a better formatting for time and a different tick calculation method. For example, it decides to use month, week, day or hour for tick based on the range of span.</p>\n</li>\n<li><p><code class="codespan">&#39;log&#39;</code>\n  Log axis, suitable for log data.</p>\n</li>\n</ul>\n',
    )
    name: Optional[str] = Field(None, description='\n\n<p>Name of axis.</p>\n')
    nameLocation: Optional[str] = Field(
        'end',
        description='\n\n<p>Location of axis name.</p>\n<p><strong>Options: </strong></p>\n<ul>\n<li><code class="codespan">&#39;start&#39;</code></li>\n<li><code class="codespan">&#39;middle&#39;</code> or <code class="codespan">&#39;center&#39;</code></li>\n<li><code class="codespan">&#39;end&#39;</code></li>\n</ul>\n',
    )
    nameTextStyle: Optional[NameTextStyle1] = Field(
        None, description='<p>Text style of axis name.</p>\n'
    )
    nameGap: Optional[float] = Field(
        15, description='\n\n<p>Gap between axis name and axis line.</p>\n'
    )
    nameRotate: Optional[float] = Field(
        None, description='\n\n<p>Rotation of axis name.</p>\n'
    )
    inverse: Optional[bool] = Field(
        False,
        description='\n\n<p>Set this to <code class="codespan">true</code> to invert the axis.\nThis is a new option available from Echarts 3 and newer.</p>\n',
    )
    boundaryGap: Optional[Union[bool, Any]] = Field(
        None,
        description='\n\n<p>The boundary gap on both sides of a coordinate axis. The setting and behavior of category axes and non-category axes are different.</p>\n<p>The <code class="codespan">boundaryGap</code> of category axis can be set to either <code class="codespan">true</code> or <code class="codespan">false</code>. Default value is set to be <code class="codespan">true</code>, in which case <a href="#yAxis.axisTick">axisTick</a> is served only as a separation line, and labels and data appear only in the center part of two <a href="#yAxis.axisTick">axis ticks</a>, which is called <em>band</em>.</p>\n<p>For non-category axis, including time, numerical value, and log axes, <code class="codespan">boundaryGap</code> is an array of two values, representing the spanning range between minimum and maximum value. The value can be set in numeric value or relative percentage, which becomes invalid after setting <a href="#yAxis.min">min</a> and <a href="#yAxis.max">max</a>.\n<strong>Example: </strong></p>\n<pre><code class="lang-ts">boundaryGap: [&#39;20%&#39;, &#39;20%&#39;]\n</code></pre>\n',
    )
    min: Optional[Union[float, str, Any]] = Field(
        None,
        description='\n\n<p>The minimun value of axis.</p>\n<p>It can be set to a special value <code class="codespan">&#39;dataMin&#39;</code> so that the minimum value on this axis is set to be the minimum label.</p>\n<p>It will be automatically computed to make sure axis tick is equally distributed when not set.</p>\n<p>In category axis, it can also be set as the ordinal number. For example, if a catergory axis has <code class="codespan">data: [&#39;categoryA&#39;, &#39;categoryB&#39;, &#39;categoryC&#39;]</code>, and the ordinal <code class="codespan">2</code> represents <code class="codespan">&#39;categoryC&#39;</code>. Moreover, it can be set as negative number, like <code class="codespan">-3</code>.</p>\n<p>If <code class="codespan">min</code> is specified as a function, it should return a min value, like:</p>\n<pre><code class="lang-ts">min: function (value) {\n    return value.min - 20;\n}\n</code></pre>\n<p><code class="codespan">value</code> is an object, containing the <code class="codespan">min</code> value and <code class="codespan">max</code> value of the data. This function should return the min value of axis, or return <code class="codespan">null</code>/<code class="codespan">undefined</code> to make echarts use the auto calculated min value (<code class="codespan">null</code>/<code class="codespan">undefined</code> return is only supported since <code class="codespan">v4.8.0</code>).</p>\n',
    )
    max: Optional[Union[float, str, Any]] = Field(
        None,
        description='\n\n<p>The maximum value of axis.</p>\n<p>It can be set to a special value <code class="codespan">&#39;dataMax&#39;</code> so that the minimum value on this axis is set to be the maximum label.</p>\n<p>It will be automatically computed to make sure axis tick is equally distributed when not set.</p>\n<p>In category axis, it can also be set as the ordinal number. For example, if a catergory axis has <code class="codespan">data: [&#39;categoryA&#39;, &#39;categoryB&#39;, &#39;categoryC&#39;]</code>, and the ordinal <code class="codespan">2</code> represents <code class="codespan">&#39;categoryC&#39;</code>. Moreover, it can be set as negative number, like <code class="codespan">-3</code>.</p>\n<p>If <code class="codespan">max</code> is specified as a function, it should return a max value, like:</p>\n<pre><code class="lang-ts">max: function (value) {\n    return value.max - 20;\n}\n</code></pre>\n<p><code class="codespan">value</code> is an object, containing the <code class="codespan">min</code> value and <code class="codespan">max</code> value of the data. This function should return the max value of axis, or return <code class="codespan">null</code>/<code class="codespan">undefined</code> to make echarts use the auto calculated max value (<code class="codespan">null</code>/<code class="codespan">undefined</code> return is only supported since <code class="codespan">v4.8.0</code>).</p>\n',
    )
    scale: Optional[bool] = Field(
        False,
        description='\n\n<p>It is available only in numerical axis, i.e., <a href="#yAxis.type">type</a>: &#39;value&#39;.</p>\n<p>It specifies whether not to contain zero position of axis compulsively. When it is set to be <code class="codespan">true</code>, the axis may not contain zero position, which is useful in the scatter chart for both value axes.</p>\n<p>This configuration item is unavailable when the <a href="#yAxis.min">min</a> and <a href="#yAxis.max">max</a> are set.</p>\n',
    )
    splitNumber: Optional[float] = Field(
        5,
        description='\n\n<p>Number of segments that the axis is split into. Note that this number serves only as a recommendation, and the true segments may be adjusted based on readability.</p>\n<p>This is unavailable for category axis.</p>\n',
    )
    minInterval: Optional[float] = Field(
        0,
        description='\n\n<p>Minimum gap between split lines.</p>\n<p>For example, it can be set to be <code class="codespan">1</code> to make sure axis label is show as integer.</p>\n<pre><code class="lang-ts">{\n    minInterval: 1\n}\n</code></pre>\n<p>It is available only for axis of <a href="#yAxis.type">type</a> &#39;value&#39; or &#39;time&#39;.</p>\n',
    )
    maxInterval: Optional[float] = Field(
        None,
        description='\n\n<p>Maximum gap between split lines.</p>\n<p>For example, in time axis (<a href="#yAxis.type">type</a> is &#39;time&#39;), it can be set to be <code class="codespan">3600 * 24 * 1000</code> to make sure that the gap between axis labels is less than or equal to one day.</p>\n<pre><code class="lang-ts">{\n    maxInterval: 3600 * 1000 * 24\n}\n</code></pre>\n<p>It is available only for axis of <a href="#yAxis.type">type</a> &#39;value&#39; or &#39;time&#39;.</p>\n',
    )
    interval: Optional[float] = Field(
        None,
        description='\n\n<p>Compulsively set segmentation interval for axis.</p>\n<p>As <a href="#yAxis.splitNumber">splitNumber</a> is a recommendation value, the calculated tick may not be the same as expected. In this case, interval should be used along with <a href="#yAxis.min">min</a> and <a href="#yAxis.max">max</a> to compulsively set tickings. But in most cases, we do not suggest using this, our automatic calculation is enough for most situations.</p>\n<p>This is unavailable for category axis. Timestamp should be passed for <a href="#yAxis.type">type</a>: &#39;time&#39; axis. Logged value should be passed for <a href="#yAxis.type">type</a>: &#39;log&#39; axis.</p>\n',
    )
    logBase: Optional[float] = Field(
        10,
        description='\n\n<p>Base of logarithm, which is valid only for numeric axes with <a href="#yAxis.type">type</a>: &#39;log&#39;.</p>\n',
    )
    silent: Optional[bool] = Field(
        False,
        description='<p>Set this to <code class="codespan">true</code>, to prevent interaction with the axis.</p>\n',
    )
    triggerEvent: Optional[bool] = Field(
        False,
        description='<p>Set this to <code class="codespan">true</code> to enable triggering events.</p>\n<p>Parameters of the event include:</p>\n<pre><code class="lang-ts">{\n    // Component type: xAxis, yAxis, radiusAxis, angleAxis\n    // Each of which has an attribute for index, e.g., xAxisIndex for xAxis\n    componentType: string,\n    // Value on axis before being formatted.\n    // Click on value label to trigger event.\n    value: &#39;&#39;,\n    // Name of axis.\n    // Click on laben name to trigger event.\n    name: &#39;&#39;\n}\n</code></pre>\n',
    )
    axisLine: Optional[AxisLine1] = Field(
        None, description='<p>Settings related to axis line.</p>\n'
    )
    axisTick: Optional[AxisTick1] = Field(
        None, description='<p>Settings related to axis tick.</p>\n'
    )
    minorTick: Optional[MinorTick1] = Field(
        None,
        description='<blockquote>\n<p>Since <code class="codespan">v4.6.0</code></p>\n</blockquote>\n<p>Settings related minor ticks.</p>\n<p>Note: <code class="codespan">minorTick</code> is not available in the <code class="codespan">category</code> type axis.</p>\n<p>Examples:</p>\n<p>1) Using minor ticks in function plotting.</p>\n<iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=line-function&edit=1&reset=1" width="600" height="350"></iframe>\n\n\n<p>2) Using minor ticks in log axis.</p>\n<iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=line-log&edit=1&reset=1" width="600" height="350"></iframe>\n\n',
    )
    axisLabel: Optional[AxisLabel1] = Field(
        None, description='<p>Settings related to axis label.</p>\n'
    )
    splitLine: Optional[SplitLine1] = Field(
        None,
        description='<p>Split line of axis in <a href="#grid">grid</a> area.</p>\n',
    )
    minorSplitLine: Optional[MinorSplitLine1] = Field(
        None,
        description='<blockquote>\n<p>Since <code class="codespan">v4.6.0</code></p>\n</blockquote>\n<p>Minor split lines of axis in the <a href="#grid">grid</a> area。It will align to the <a href="#yAxis.minorTick">minorTick</a></p>\n',
    )
    splitArea: Optional[SplitArea1] = Field(
        None,
        description='<p>Split area of axis in <a href="#grid">grid</a> area, not shown by default.</p>\n',
    )
    data: Optional[List[Datum2]] = Field(
        None,
        description='<p>Category data, available in <a href="#yAxis.type">type</a>: &#39;category&#39; axis.</p>\n<p>If <a href="#yAxis.type">type</a> is not specified, but <code class="codespan">axis.data</code> is specified, the <a href="#yAxis.type">type</a> is auto set as <code class="codespan">&#39;category&#39;</code>.</p>\n<p>If <a href="#yAxis.type">type</a> is specified as <code class="codespan">&#39;category&#39;</code>, but <code class="codespan">axis.data</code> is not specified, <code class="codespan">axis.data</code> will be auto collected from <a href="#series.data">series.data</a>. It brings convenience, but we should notice that <code class="codespan">axis.data</code> provides then value range of the <code class="codespan">&#39;category&#39;</code> axis. If  it is auto collected from <a href="#series.data">series.data</a>, Only the values appearing in <a href="#series.data">series.data</a> can be collected. For example, if <a href="#series.data">series.data</a> is empty, nothing will be collected.</p>\n<p>Example:</p>\n<pre><code class="lang-ts">// Name list of all categories\ndata: [&#39;Monday&#39;, &#39;Tuesday&#39;, &#39;Wednesday&#39;, &#39;Thursday&#39;, &#39;Friday&#39;, &#39;Saturday&#39;, &#39;Sunday&#39;]\n// Each item could also be a specific configuration item.\n// In this case, `value` is used as the category name.\ndata: [{\n    value: &#39;Monday&#39;,\n    // Highlight Monday\n    textStyle: {\n        fontSize: 20,\n        color: &#39;red&#39;\n    }\n}, &#39;Tuesday&#39;, &#39;Wednesday&#39;, &#39;Thursday&#39;, &#39;Friday&#39;, &#39;Saturday&#39;, &#39;Sunday&#39;]\n</code></pre>\n',
    )
    axisPointer: Optional[AxisPointer2] = Field(
        None, description='<p>axisPointer settings on the axis.</p>\n'
    )
    zlevel: Optional[float] = Field(
        0,
        description='<p><code class="codespan">zlevel</code> value of all graphical elements in y axis.</p>\n<p><code class="codespan">zlevel</code> is used to make layers with Canvas. Graphical elements with different <code class="codespan">zlevel</code> values will be placed in different Canvases, which is a common optimization technique. We can put those frequently changed elements (like those with animations) to a separate <code class="codespan">zlevel</code>. Notice that too many Canvases will increase memory cost, and should be used carefully on mobile phones to avoid crash.</p>\n<p>Canvases with bigger <code class="codespan">zlevel</code> will be placed on Canvases with smaller <code class="codespan">zlevel</code>.</p>\n',
    )
    z: Optional[float] = Field(
        0,
        description='<p><code class="codespan">z</code> value of all graphical elements in y axis, which controls order of drawing graphical components. Components with smaller <code class="codespan">z</code> values may be overwritten by those with larger <code class="codespan">z</code> values.</p>\n<p><code class="codespan">z</code> has a lower priority to <code class="codespan">zlevel</code>, and will not create new Canvas.</p>\n',
    )


class Label3(Label):
    """
    <p>label of axisPointer</p>

    """

    pass


class LineStyle15(LineStyle2):
    """
    <p>It is valid when <a href="#tooltip.axisPointer.type">axisPointer.type</a> is <code class="codespan">&#39;line&#39;</code>.</p>

    """

    pass


class ShadowStyle3(ShadowStyle):
    """
    <p>It is valid when <a href="#tooltip.axisPointer.type">axisPointer.type</a> is <code class="codespan">&#39;shadow&#39;</code>.</p>

    """

    pass


class CrossStyle1(CrossStyle):
    """
    <p>It is valid when <a href="#tooltip.axisPointer.type">axisPointer.type</a> is <code class="codespan">&#39;cross&#39;</code>.</p>

    """

    pass


class AxisPointer3(BaseModel):
    """
        <p>Configuration item for axisPointer.</p>
    <p><code class="codespan">tooltip.axisPointer</code> is like syntactic sugar of axisPointer settings on axes (for example, <a href="#xAxis.axisPointer">xAxis.axisPointer</a> or <a href="#angleAxis.axisPointer">angleAxis.axisPointer</a>). More detailed features can be configured on <code class="codespan">someAxis.axisPointer</code>. But in common cases, using <code class="codespan">tooltip.axisPointer</code> is more convenient.</p>
    <blockquote>
    <p><strong>Notice:</strong> configurations of <code class="codespan">tooltip.axisPointer</code> has lower priority than that of <code class="codespan">someAxis.axisPointer</code>.</p>
    </blockquote>
    <hr>
    <p><code class="codespan">axisPointer</code> is a tool for displaying reference line and axis value under mouse pointer.</p>
    <p>For example:</p>
    <iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=doc-example/candlestick-axisPointer&edit=1&reset=1" width="600" height="450"></iframe>


    <p>In the demo above, <a href="#axisPointer.link">axisPointer.link</a> is used to link axisPointer from different coordinate systems.</p>
    <p><code class="codespan">axisPointer</code> can also be used on touch device, where user can drag the button to move the reference line and label.</p>
    <iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=line-tooltip-touch&edit=1&reset=1" width="600" height="400"></iframe>


    <p>In the cases that more than one axis exist, axisPointer helps to look inside the data.</p>
    <iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=multiple-y-axis&edit=1&reset=1" width="600" height="300"></iframe>

    <iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=multiple-x-axis&edit=1&reset=1" width="600" height="300"></iframe>



    <hr>
    <blockquote>
    <p><strong>Notice:</strong>
    Generally, axisPointers is configured in each axes who need them (for example <a href="#xAxis.axisPointer">xAxis.axisPointer</a>), or configured in <code class="codespan">tooltip</code> (for example <a href="#tooltip.axisPointer">tooltip.axisPointer</a>).</p>
    </blockquote>
    <blockquote>
    <p>But these configurations can only be configured in global axisPointer:
    <a href="#axisPointer.triggerOn">axisPointer.triggerOn</a>, <a href="#axisPointer.link">axisPointer.link</a>.</p>
    </blockquote>
    <hr>
    <hr>
    <p><strong>How to display axisPointer:</strong></p>
    <p>In <a href="#grid">cartesian (grid)</a> and <a href="#single">polar](~polar) and (single axis</a>, each axis has its own axisPointer.</p>
    <p>Those axisPointer will not be displayed by default, utill configured as follows:</p>
    <ul>
    <li><p>Set <code class="codespan">someAxis.axisPointer.show</code> (like <a href="#xAxis.axisPointer.show">xAxis.axisPointer.show</a>) as <code class="codespan">true</code>. Then axisPointer of this axis will be displayed.</p>
    </li>
    <li><p>Set <a href="#tooltip.trigger">tooltip.trigger</a> as <code class="codespan">&#39;axis&#39;</code>, or set <a href="#tooltip.axisPointer.type">tooltip.axisPointer.type</a> as <code class="codespan">&#39;cross&#39;</code>. Then coordinate system will automatically chose the axes who will display their axisPointers. (<a href="#tooltip.axisPointer.axis">tooltip.axisPointer.axis</a> can be used to change the choice.) Notice, <code class="codespan">axis.axisPointer</code> will override <code class="codespan">tooltip.axisPointer</code> settings.</p>
    </li>
    </ul>
    <hr>
    <p><strong>How to display the label of axisPointer:</strong></p>
    <p>The label of axisPointer will not be displayed by default(namely, only reference line will be displayed by default), utill configured as follows:</p>
    <ul>
    <li><p>Set <code class="codespan">someAxis.axisPointer.label.show</code> (for example <a href="#xAxis.axisPointer.show">xAxis.axisPointer.label.show</a>) as <code class="codespan">true</code>. Then the label of the axisPointer will be displayed.</p>
    </li>
    <li><p>Set <a href="#tooltip.axisPointer.type">tooltip.axisPointer.type</a> as  <code class="codespan">&#39;cross&#39;</code>. Then the label of the crossed axisPointers will be displayed.</p>
    </li>
    </ul>
    <hr>
    <p><strong>How to configure axisPointer on touch device:</strong></p>
    <p>Set <code class="codespan">someAxis.axisPointer.handle.show</code> (for example <a href="#xAxis.axisPointer.handle.show">xAxis.axisPointer.handle.show</a> as <code class="codespan">true</code>. Then the button for dragging will be displayed. (This feature is not supported on polar).</p>
    <p><strong>Notice:</strong>
    If tooltip does not work well in this case, try to set<a href="#tooltip.triggerOn">tooltip.triggerOn</a> as <code class="codespan">&#39;none&#39;</code> (for the effect: show tooltip when finger holding on the button, and hide tooltip after finger left the button), or set <a href="#tooltip.alwaysShowContent">tooltip.alwaysShowContent</a> as <code class="codespan">true</code> (then tooltip will always be displayed).</p>
    <p>See the <a href="http://localhost/echarts-website/examples/en/editor.html?c=line-tooltip-touch&amp;edit=1&amp;reset=1" target="_blank">example</a>.</p>
    <hr>
    <p><strong>Snap to point</strong></p>
    <p>In value axis and time axis, if <a href="#xAxis.axisPointer.snap">snap</a> is set as true, axisPointer will snap to point automatically.</p>
    <hr>

    """

    type: Optional[str] = Field(
        'line',
        description='\n\n<p>Indicator type.</p>\n<p>Options:</p>\n<ul>\n<li><p><code class="codespan">&#39;line&#39;</code> line indicator.</p>\n</li>\n<li><p><code class="codespan">&#39;shadow&#39;</code> shadow crosshair indicator.</p>\n</li>\n<li><p><code class="codespan">&#39;none&#39;</code> no indicator displayed.</p>\n</li>\n<li><p><code class="codespan">&#39;cross&#39;</code> crosshair indicator, which is actually the shortcut of enable two axisPointers of two orthometric axes.</p>\n</li>\n</ul>\n',
    )
    axis: Optional[str] = Field(
        'auto',
        description='<p>The coordinate axis, which could be <code class="codespan">&#39;x&#39;</code>, <code class="codespan">&#39;y&#39;</code>, <code class="codespan">&#39;radius&#39;</code>, or <code class="codespan">&#39;angle&#39;</code>. By default, each coordinate system will automatically chose the axes whose will display its axisPointer (category axis or time axis is used by default).</p>\n',
    )
    snap: Optional[bool] = Field(
        None,
        description='<p>Whether snap to point automatically. The default value is auto determined.</p>\n<p>This feature usually makes sense in value axis and time axis, where tiny points can be seeked automatically.</p>\n',
    )
    z: Optional[float] = Field(
        None,
        description='<p>z value, which controls order of drawing graphical components. Components with smaller <code class="codespan">z</code> values may be overwritten by those with larger <code class="codespan">z</code> values.</p>\n',
    )
    label: Optional[Label3] = Field(None, description='<p>label of axisPointer</p>\n')
    lineStyle: Optional[LineStyle15] = Field(
        None,
        description='<p>It is valid when <a href="#tooltip.axisPointer.type">axisPointer.type</a> is <code class="codespan">&#39;line&#39;</code>.</p>\n',
    )
    shadowStyle: Optional[ShadowStyle3] = Field(
        None,
        description='<p>It is valid when <a href="#tooltip.axisPointer.type">axisPointer.type</a> is <code class="codespan">&#39;shadow&#39;</code>.</p>\n',
    )
    crossStyle: Optional[CrossStyle1] = Field(
        None,
        description='<p>It is valid when <a href="#tooltip.axisPointer.type">axisPointer.type</a> is <code class="codespan">&#39;cross&#39;</code>.</p>\n',
    )
    animation: Optional[bool] = Field(
        True, description='\n\n<p>Whether to enable animation.</p>\n'
    )
    animationThreshold: Optional[float] = Field(
        2000,
        description='<p>Whether to set graphic number threshold to animation. Animation will be disabled when graphic number is larger than threshold.</p>\n',
    )
    animationDuration: Optional[Union[float, Any]] = Field(
        1000,
        description='\n\n<p>Duration of the first animation, which supports callback function for different data to have different animation effect:</p>\n<pre><code class="lang-ts">animationDuration: function (idx) {\n    // delay for later data is larger\n    return idx * 100;\n}\n</code></pre>\n',
    )
    animationEasing: Optional[str] = Field(
        'cubicOut',
        description='\n\n<p>Easing method used for the first animation. Varied easing effects can be found at <a href="http://localhost/echarts-website/examples/en/editor.html?c=line-easing" target="_blank">easing effect example</a>.</p>\n',
    )
    animationDelay: Optional[Union[float, Any]] = Field(
        0,
        description='<p>Delay before updating the first animation, which supports callback function for different data to have different animation effect.</p>\n<p>For example:</p>\n<pre><code class="lang-ts">animationDelay: function (idx) {\n    // delay for later data is larger\n    return idx * 100;\n}\n</code></pre>\n<p>See <a href="http://localhost/echarts-website/examples/en/editor.html?c=bar-animation-delay" target="_blank">this example</a> for more information.</p>\n',
    )
    animationDurationUpdate: Optional[Union[float, Any]] = Field(
        200,
        description='\n\n<p>Time for animation to complete, which supports callback function for different data to have different animation effect:</p>\n<pre><code class="lang-ts">animationDurationUpdate: function (idx) {\n    // delay for later data is larger\n    return idx * 100;\n}\n</code></pre>\n',
    )
    animationEasingUpdate: Optional[str] = Field(
        'exponentialOut', description='\n\n<p>Easing method used for animation.</p>\n'
    )
    animationDelayUpdate: Optional[Union[float, Any]] = Field(
        0,
        description='<p>Delay before updating animation, which supports callback function for different data to have different animation effects.</p>\n<p>For example:</p>\n<pre><code class="lang-ts">animationDelayUpdate: function (idx) {\n    // delay for later data is larger\n    return idx * 100;\n}\n</code></pre>\n<p>See <a href="http://localhost/echarts-website/examples/en/editor.html?c=bar-animation-delay" target="_blank">this example</a> for more information.</p>\n',
    )


class TextStyle5(TextStyle2):
    """
    <p>The text syle of tooltip&#39;s floating layer.</p>

    """

    pass


class Tooltip1(BaseModel):
    """
        <p>tooltip settings in the coordinate system component.</p>
    <p><strong>General Introduction:</strong></p>
    <p>tooltip can be configured on different places:</p>
    <ul>
    <li><p>Configured on global: <a href="#tooltip">tooltip</a></p>
    </li>
    <li><p>Configured in a coordinate system: <a href="#grid.tooltip">grid.tooltip</a>, <a href="#polar.tooltip">polar.tooltip</a>, <a href="#single.tooltip">single.tooltip</a></p>
    </li>
    <li><p>Configured in a series: <a href="#series.tooltip">series.tooltip</a></p>
    </li>
    <li><p>Configured in each item of <code class="codespan">series.data</code>: <a href="#series.data.tooltip">series.data.tooltip</a></p>
    </li>
    </ul>

    """

    show: Optional[bool] = Field(
        True,
        description='\n\n<p>Whether to show the tooltip component.</p>\n<p>including tooltip floating layer and <a href="#tooltip.axisPointer">axisPointer</a>.</p>\n',
    )
    trigger: Optional[str] = Field(
        'item',
        description='\n\n<p>Type of triggering.</p>\n<p>Options:</p>\n<ul>\n<li><p><code class="codespan">&#39;item&#39;</code></p>\n<p>  Triggered by data item, which is mainly used for charts that don&#39;t have a category axis like scatter charts or pie charts.</p>\n</li>\n<li><p><code class="codespan">&#39;axis&#39;</code></p>\n<p>  Triggered by axes, which is mainly used for charts that have category axes, like bar charts or line charts.</p>\n<p> ECharts 2.x only supports axis trigger for category axis. In ECharts 3, it is supported for all types of axes in <a href="#grid">grid</a> or <a href="#polar">polar</a>. Also, you may assign axis with <a href="#tooltip.axisPointer.axis">axisPointer.axis</a>.</p>\n</li>\n<li><p><code class="codespan">&#39;none&#39;</code></p>\n<p>  Trigger nothing.</p>\n</li>\n</ul>\n',
    )
    axisPointer: Optional[AxisPointer3] = Field(
        None,
        description='<p>Configuration item for axisPointer.</p>\n<p><code class="codespan">tooltip.axisPointer</code> is like syntactic sugar of axisPointer settings on axes (for example, <a href="#xAxis.axisPointer">xAxis.axisPointer</a> or <a href="#angleAxis.axisPointer">angleAxis.axisPointer</a>). More detailed features can be configured on <code class="codespan">someAxis.axisPointer</code>. But in common cases, using <code class="codespan">tooltip.axisPointer</code> is more convenient.</p>\n<blockquote>\n<p><strong>Notice:</strong> configurations of <code class="codespan">tooltip.axisPointer</code> has lower priority than that of <code class="codespan">someAxis.axisPointer</code>.</p>\n</blockquote>\n<hr>\n<p><code class="codespan">axisPointer</code> is a tool for displaying reference line and axis value under mouse pointer.</p>\n<p>For example:</p>\n<iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=doc-example/candlestick-axisPointer&edit=1&reset=1" width="600" height="450"></iframe>\n\n\n<p>In the demo above, <a href="#axisPointer.link">axisPointer.link</a> is used to link axisPointer from different coordinate systems.</p>\n<p><code class="codespan">axisPointer</code> can also be used on touch device, where user can drag the button to move the reference line and label.</p>\n<iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=line-tooltip-touch&edit=1&reset=1" width="600" height="400"></iframe>\n\n\n<p>In the cases that more than one axis exist, axisPointer helps to look inside the data.</p>\n<iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=multiple-y-axis&edit=1&reset=1" width="600" height="300"></iframe>\n\n<iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=multiple-x-axis&edit=1&reset=1" width="600" height="300"></iframe>\n\n\n\n<hr>\n<blockquote>\n<p><strong>Notice:</strong>\nGenerally, axisPointers is configured in each axes who need them (for example <a href="#xAxis.axisPointer">xAxis.axisPointer</a>), or configured in <code class="codespan">tooltip</code> (for example <a href="#tooltip.axisPointer">tooltip.axisPointer</a>).</p>\n</blockquote>\n<blockquote>\n<p>But these configurations can only be configured in global axisPointer:\n<a href="#axisPointer.triggerOn">axisPointer.triggerOn</a>, <a href="#axisPointer.link">axisPointer.link</a>.</p>\n</blockquote>\n<hr>\n<hr>\n<p><strong>How to display axisPointer:</strong></p>\n<p>In <a href="#grid">cartesian (grid)</a> and <a href="#single">polar](~polar) and (single axis</a>, each axis has its own axisPointer.</p>\n<p>Those axisPointer will not be displayed by default, utill configured as follows:</p>\n<ul>\n<li><p>Set <code class="codespan">someAxis.axisPointer.show</code> (like <a href="#xAxis.axisPointer.show">xAxis.axisPointer.show</a>) as <code class="codespan">true</code>. Then axisPointer of this axis will be displayed.</p>\n</li>\n<li><p>Set <a href="#tooltip.trigger">tooltip.trigger</a> as <code class="codespan">&#39;axis&#39;</code>, or set <a href="#tooltip.axisPointer.type">tooltip.axisPointer.type</a> as <code class="codespan">&#39;cross&#39;</code>. Then coordinate system will automatically chose the axes who will display their axisPointers. (<a href="#tooltip.axisPointer.axis">tooltip.axisPointer.axis</a> can be used to change the choice.) Notice, <code class="codespan">axis.axisPointer</code> will override <code class="codespan">tooltip.axisPointer</code> settings.</p>\n</li>\n</ul>\n<hr>\n<p><strong>How to display the label of axisPointer:</strong></p>\n<p>The label of axisPointer will not be displayed by default(namely, only reference line will be displayed by default), utill configured as follows:</p>\n<ul>\n<li><p>Set <code class="codespan">someAxis.axisPointer.label.show</code> (for example <a href="#xAxis.axisPointer.show">xAxis.axisPointer.label.show</a>) as <code class="codespan">true</code>. Then the label of the axisPointer will be displayed.</p>\n</li>\n<li><p>Set <a href="#tooltip.axisPointer.type">tooltip.axisPointer.type</a> as  <code class="codespan">&#39;cross&#39;</code>. Then the label of the crossed axisPointers will be displayed.</p>\n</li>\n</ul>\n<hr>\n<p><strong>How to configure axisPointer on touch device:</strong></p>\n<p>Set <code class="codespan">someAxis.axisPointer.handle.show</code> (for example <a href="#xAxis.axisPointer.handle.show">xAxis.axisPointer.handle.show</a> as <code class="codespan">true</code>. Then the button for dragging will be displayed. (This feature is not supported on polar).</p>\n<p><strong>Notice:</strong>\nIf tooltip does not work well in this case, try to set<a href="#tooltip.triggerOn">tooltip.triggerOn</a> as <code class="codespan">&#39;none&#39;</code> (for the effect: show tooltip when finger holding on the button, and hide tooltip after finger left the button), or set <a href="#tooltip.alwaysShowContent">tooltip.alwaysShowContent</a> as <code class="codespan">true</code> (then tooltip will always be displayed).</p>\n<p>See the <a href="http://localhost/echarts-website/examples/en/editor.html?c=line-tooltip-touch&amp;edit=1&amp;reset=1" target="_blank">example</a>.</p>\n<hr>\n<p><strong>Snap to point</strong></p>\n<p>In value axis and time axis, if <a href="#xAxis.axisPointer.snap">snap</a> is set as true, axisPointer will snap to point automatically.</p>\n<hr>\n',
    )
    position: Optional[Union[str, Any]] = Field(
        None,
        description='<p>The position of the tooltip&#39;s floating layer, which would follow the position of mouse by default.</p>\n<p>Options:</p>\n<ul>\n<li><p><code class="codespan">Array</code></p>\n<p>  Display the position of tooltip&#39;s floating layer through array, which supports absolute position and relative percentage.</p>\n<p>  Example:</p>\n<pre><code class="lang-ts">  // absolute position, which is 10px to the left side and 10px to the top side of the container\n  position: [10, 10]\n  // relative position, in the exact center of the container\n  position: [&#39;50%&#39;, &#39;50%&#39;]\n</code></pre>\n</li>\n<li><p><code class="codespan">Function</code></p>\n<p>  Callback function in the following form:</p>\n<pre><code class="lang-ts">  (point: Array, params: Object|Array.&lt;Object&gt;, dom: HTMLDomElement, rect: Object, size: Object) =&gt; Array\n</code></pre>\n<p>  <strong>Parameters:</strong><br>\n  point: Mouse position.<br>\n  param: The same as formatter.<br>\n  dom: The DOM object of tooltip.<br>\n  rect: It is valid only when mouse is on graphic elements, which stands for a bounding box with <code class="codespan">x</code>, <code class="codespan">y</code>, <code class="codespan">width</code>, and <code class="codespan">height</code>.<br>\n  size: The size of dom echarts container. For example: <code class="codespan">{contentSize: [width, height], viewSize: [width, height]}</code>. <br></p>\n<p>  <strong>Return:</strong><br>\n  Return value is an array standing for tooltip position, which can be absolute pixels, or relative percentage.<br>\n  Or can be an object, like <code class="codespan">{left: 10, top: 30}</code>, or <code class="codespan">{right: &#39;20%&#39;, bottom: 40}</code>.<br></p>\n<p>  For example:</p>\n<pre><code class="lang-ts">  position: function (point, params, dom, rect, size) {\n      // fixed at top\n      return [point[0], &#39;10%&#39;];\n  }\n</code></pre>\n<p>  Or:</p>\n<pre><code class="lang-ts">  position: function (pos, params, dom, rect, size) {\n      // tooltip will be fixed on the right if mouse hovering on the left,\n      // and on the left if hovering on the right.\n      var obj = {top: 60};\n      obj[[&#39;left&#39;, &#39;right&#39;][+(pos[0] &lt; size.viewSize[0] / 2)]] = 5;\n      return obj;\n  }\n</code></pre>\n</li>\n<li><p><code class="codespan">&#39;inside&#39;</code></p>\n<p> Center position of the graphic element where the mouse is in, which is only valid when <a href="#tooltip.trigger">trigger</a> is <code class="codespan">&#39;item&#39;</code>.</p>\n</li>\n<li><p><code class="codespan">&#39;top&#39;</code></p>\n<p>  Top position of the graphic element where the mouse is in, which is only valid when <a href="#tooltip.trigger">trigger</a> is <code class="codespan">&#39;item&#39;</code>.</p>\n</li>\n<li><p><code class="codespan">&#39;left&#39;</code></p>\n<p>  Left position of the graphic element where the mouse is in, which is only valid when <a href="#tooltip.trigger">trigger</a> is <code class="codespan">&#39;item&#39;</code>.</p>\n</li>\n<li><p><code class="codespan">&#39;right&#39;</code></p>\n<p>  Right position of the graphic element where the mouse is in, which is only valid when <a href="#tooltip.trigger">trigger</a> is <code class="codespan">&#39;item&#39;</code>.</p>\n</li>\n<li><p><code class="codespan">&#39;bottom&#39;</code></p>\n<p>  Bottom position of the graphic element where the mouse is in, which is only valid when <a href="#tooltip.trigger">trigger</a> is <code class="codespan">&#39;item&#39;</code>.</p>\n</li>\n</ul>\n',
    )
    formatter: Optional[Union[str, Any]] = Field(
        None,
        description='<p>The content formatter of tooltip&#39;s floating layer which supports string template and callback function.</p>\n<p><strong>1. String template</strong></p>\n<p>The template variables are <code class="codespan">{a}</code>, <code class="codespan">{b}</code>, <code class="codespan">{c}</code>, <code class="codespan">{d}</code> and <code class="codespan">{e}</code>, which stands for series name, data name and data value and ect. When <a href="#tooltip.trigger">trigger</a> is set to be <code class="codespan">&#39;axis&#39;</code>, there may be data from multiple series. In this time, series index can be refered as <code class="codespan">{a0}</code>, <code class="codespan">{a1}</code>, or <code class="codespan">{a2}</code>.</p>\n<p><code class="codespan">{a}</code>, <code class="codespan">{b}</code>, <code class="codespan">{c}</code>, <code class="codespan">{d}</code> have different meanings for different series types:</p>\n<ul>\n<li><p>Line (area) charts, bar (column) charts, K charts: <code class="codespan">{a}</code> for series name, <code class="codespan">{b}</code> for category name, <code class="codespan">{c}</code> for data value, <code class="codespan">{d}</code> for none;</p>\n</li>\n<li><p>Scatter (bubble) charts: <code class="codespan">{a}</code> for series name, <code class="codespan">{b}</code> for data name, <code class="codespan">{c}</code> for data value, <code class="codespan">{d}</code> for none;</p>\n</li>\n<li><p>Map: <code class="codespan">{a}</code> for series name, <code class="codespan">{b}</code> for area name, <code class="codespan">{c}</code> for merging data, <code class="codespan">{d}</code> for none;</p>\n</li>\n<li><p>Pie charts, gauge charts, funnel charts: <code class="codespan">{a}</code> for series name, <code class="codespan">{b}</code> for data item name, <code class="codespan">{c}</code> for data value, <code class="codespan">{d}</code> for percentage.</p>\n</li>\n</ul>\n<p><strong>Example: </strong></p>\n<pre><code class="lang-ts">formatter: &#39;{b0}: {c0}&lt;br /&gt;{b1}: {c1}&#39;\n</code></pre>\n<p><strong>2. Callback function</strong></p>\n<p>The format of callback function:</p>\n<pre><code class="lang-ts">(params: Object|Array, ticket: string, callback: (ticket: string, html: string)) =&gt; string | HTMLElement | HTMLElement[]\n</code></pre>\n<p>The first parameter <code class="codespan">params</code> is the data that the formatter needs. Its format is shown as follows:</p>\n<pre><code class="lang-ts">{\n    componentType: &#39;series&#39;,\n    // Series type\n    seriesType: string,\n    // Series index in option.series\n    seriesIndex: number,\n    // Series name\n    seriesName: string,\n    // Data name, or category name\n    name: string,\n    // Data index in input data array\n    dataIndex: number,\n    // Original data as input\n    data: Object,\n    // Value of data. In most series it is the same as data.\n    // But in some series it is some part of the data (e.g., in map, radar)\n    value: number|Array|Object,\n    // encoding info of coordinate system\n    // Key: coord, like (&#39;x&#39; &#39;y&#39; &#39;radius&#39; &#39;angle&#39;)\n    // value: Must be an array, not null/undefined. Contain dimension indices, like:\n    // {\n    //     x: [2] // values on dimension index 2 are mapped to x axis.\n    //     y: [0] // values on dimension index 0 are mapped to y axis.\n    // }\n    encode: Object,\n    // dimension names list\n    dimensionNames: Array&lt;String&gt;,\n    // data dimension index, for example 0 or 1 or 2 ...\n    // Only work in `radar` series.\n    dimensionIndex: number,\n    // Color of data\n    color: string,\n    // the percentage of pie chart\n    percent: number\n}\n</code></pre>\n<p><strong>How to use <code class="codespan">encode</code> and <code class="codespan">dimensionNames</code>?</strong></p>\n<p>When the dataset is like</p>\n<pre><code class="lang-ts">dataset: {\n    source: [\n        [&#39;Matcha Latte&#39;, 43.3, 85.8, 93.7],\n        [&#39;Milk Tea&#39;, 83.1, 73.4, 55.1],\n        [&#39;Cheese Cocoa&#39;, 86.4, 65.2, 82.5],\n        [&#39;Walnut Brownie&#39;, 72.4, 53.9, 39.1]\n    ]\n}\n</code></pre>\n<p>We can get the value of the y-axis via</p>\n<pre><code class="lang-ts">params.value[params.encode.y[0]]\n</code></pre>\n<p>When the dataset is like</p>\n<pre><code class="lang-ts">dataset: {\n    dimensions: [&#39;product&#39;, &#39;2015&#39;, &#39;2016&#39;, &#39;2017&#39;],\n    source: [\n        {product: &#39;Matcha Latte&#39;, &#39;2015&#39;: 43.3, &#39;2016&#39;: 85.8, &#39;2017&#39;: 93.7},\n        {product: &#39;Milk Tea&#39;, &#39;2015&#39;: 83.1, &#39;2016&#39;: 73.4, &#39;2017&#39;: 55.1},\n        {product: &#39;Cheese Cocoa&#39;, &#39;2015&#39;: 86.4, &#39;2016&#39;: 65.2, &#39;2017&#39;: 82.5},\n        {product: &#39;Walnut Brownie&#39;, &#39;2015&#39;: 72.4, &#39;2016&#39;: 53.9, &#39;2017&#39;: 39.1}\n    ]\n}\n</code></pre>\n<p>We can get the value of the y-axis via</p>\n<pre><code class="lang-ts">params.value[params.dimensionNames[params.encode.y[0]]]\n</code></pre>\n<p>When <a href="#tooltip.trigger">trigger</a> is <code class="codespan">&#39;axis&#39;</code>, or when tooltip is triggered by <a href="#xAxis.axisPointer">axisPointer</a>, <code class="codespan">params</code> is the data array of multiple series. The content of each item of the array is the same as above. Besides,</p>\n<pre><code class="lang-ts">{\n    componentType: &#39;series&#39;,\n    // Series type\n    seriesType: string,\n    // Series index in option.series\n    seriesIndex: number,\n    // Series name\n    seriesName: string,\n    // Data name, or category name\n    name: string,\n    // Data index in input data array\n    dataIndex: number,\n    // Original data as input\n    data: Object,\n    // Value of data. In most series it is the same as data.\n    // But in some series it is some part of the data (e.g., in map, radar)\n    value: number|Array|Object,\n    // encoding info of coordinate system\n    // Key: coord, like (&#39;x&#39; &#39;y&#39; &#39;radius&#39; &#39;angle&#39;)\n    // value: Must be an array, not null/undefined. Contain dimension indices, like:\n    // {\n    //     x: [2] // values on dimension index 2 are mapped to x axis.\n    //     y: [0] // values on dimension index 0 are mapped to y axis.\n    // }\n    encode: Object,\n    // dimension names list\n    dimensionNames: Array&lt;String&gt;,\n    // data dimension index, for example 0 or 1 or 2 ...\n    // Only work in `radar` series.\n    dimensionIndex: number,\n    // Color of data\n    color: string\n}\n</code></pre>\n<p><strong>How to use <code class="codespan">encode</code> and <code class="codespan">dimensionNames</code>?</strong></p>\n<p>When the dataset is like</p>\n<pre><code class="lang-ts">dataset: {\n    source: [\n        [&#39;Matcha Latte&#39;, 43.3, 85.8, 93.7],\n        [&#39;Milk Tea&#39;, 83.1, 73.4, 55.1],\n        [&#39;Cheese Cocoa&#39;, 86.4, 65.2, 82.5],\n        [&#39;Walnut Brownie&#39;, 72.4, 53.9, 39.1]\n    ]\n}\n</code></pre>\n<p>We can get the value of the y-axis via</p>\n<pre><code class="lang-ts">params.value[params.encode.y[0]]\n</code></pre>\n<p>When the dataset is like</p>\n<pre><code class="lang-ts">dataset: {\n    dimensions: [&#39;product&#39;, &#39;2015&#39;, &#39;2016&#39;, &#39;2017&#39;],\n    source: [\n        {product: &#39;Matcha Latte&#39;, &#39;2015&#39;: 43.3, &#39;2016&#39;: 85.8, &#39;2017&#39;: 93.7},\n        {product: &#39;Milk Tea&#39;, &#39;2015&#39;: 83.1, &#39;2016&#39;: 73.4, &#39;2017&#39;: 55.1},\n        {product: &#39;Cheese Cocoa&#39;, &#39;2015&#39;: 86.4, &#39;2016&#39;: 65.2, &#39;2017&#39;: 82.5},\n        {product: &#39;Walnut Brownie&#39;, &#39;2015&#39;: 72.4, &#39;2016&#39;: 53.9, &#39;2017&#39;: 39.1}\n    ]\n}\n</code></pre>\n<p>We can get the value of the y-axis via</p>\n<pre><code class="lang-ts">params.value[params.dimensionNames[params.encode.y[0]]]\n</code></pre>\n<p><strong>Note: </strong>Using array to present all the parameters in ECharts 2.x is not supported anymore.</p>\n<p>The second parameter <code class="codespan">ticket</code> is the asynchronous callback flag which should be used along with the third parameter <code class="codespan">callback</code> when it is used.</p>\n<p>The third parameter <code class="codespan">callback</code> is asynchronous callback. When the content of tooltip is acquired asynchronously, <code class="codespan">ticket</code> and <code class="codespan">htm</code> as introduced above can be used to update tooltip with callback.</p>\n<p>Example:</p>\n<pre><code class="lang-ts">formatter: function (params, ticket, callback) {\n    $.get(&#39;detail?name=&#39; + params.name, function (content) {\n        callback(ticket, toHTML(content));\n    });\n    return &#39;Loading&#39;;\n}\n</code></pre>\n',
    )
    valueFormatter: Optional[str] = Field(
        None,
        description='<blockquote>\n<p>Since <code class="codespan">v5.3.0</code></p>\n</blockquote>\n<p>Callback function for formatting the value section in tooltip.</p>\n<p>Interface:</p>\n<pre><code class="lang-ts">(value: number | string) =&gt; string\n</code></pre>\n<p>Example:</p>\n<pre><code class="lang-ts">// Add $ prefix\nvalueFormatter: (value) =&gt; &#39;$&#39; + value.toFixed(2)\n</code></pre>\n',
    )
    backgroundColor: Optional[Any] = Field(
        'rgba(50,50,50,0.7)',
        description='<p>The background color of tooltip&#39;s floating layer.</p>\n',
    )
    borderColor: Optional[Any] = Field(
        '#333',
        description='\n\n\n\n\n\n\n\n\n\n<p>The border color of tooltip&#39;s floating layer.</p>\n',
    )
    borderWidth: Optional[float] = Field(
        0,
        description='\n\n\n\n\n\n\n\n\n\n<p>The border width of tooltip&#39;s floating layer.</p>\n',
    )
    padding: Optional[float] = Field(
        5,
        description='\n\n\n\n\n\n\n\n\n\n\n\n\n\n<p>The floating layer of tooltip space around content. The unit is px. Default values for each position are 5. And they can be set to different values with left, right, top, and bottom.</p>\n<p>Examples:</p>\n<pre><code class="lang-ts">// Set padding to be 5\npadding: 5\n// Set the top and bottom paddings to be 5, and left and right paddings to be 10\npadding: [5, 10]\n// Set each of the four paddings seperately\npadding: [\n    5,  // up\n    10, // right\n    5,  // down\n    10, // left\n]\n</code></pre>\n',
    )
    textStyle: Optional[TextStyle5] = Field(
        None, description='<p>The text syle of tooltip&#39;s floating layer.</p>\n'
    )
    extraCssText: Optional[str] = Field(
        None,
        description='\n\n\n\n\n\n\n\n\n\n<p>Extra CSS style for floating layer. The following is an example for adding shadow.</p>\n<pre><code class="lang-ts">extraCssText: &#39;box-shadow: 0 0 3px rgba(0, 0, 0, 0.3);&#39;\n</code></pre>\n',
    )


class Polar(BaseModel):
    """
        <p>Polar coordinate can be used in scatter and line chart. Every polar coordinate has an <a href="#angleAxis">angleAxis</a> and a <a href="#radiusAxis">radiusAxis</a>.</p>
    <p><strong>For example: </strong></p>
    <iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=scatter-polar-punchCard&edit=1&reset=1" width="600" height="400"></iframe>




    """

    id: Optional[str] = Field(
        None,
        description='<p>Component ID, not specified by default. If specified, it can be used to refer the component in option or API.</p>\n',
    )
    zlevel: Optional[float] = Field(
        0,
        description='<p><code class="codespan">zlevel</code> value of all graphical elements in .</p>\n<p><code class="codespan">zlevel</code> is used to make layers with Canvas. Graphical elements with different <code class="codespan">zlevel</code> values will be placed in different Canvases, which is a common optimization technique. We can put those frequently changed elements (like those with animations) to a separate <code class="codespan">zlevel</code>. Notice that too many Canvases will increase memory cost, and should be used carefully on mobile phones to avoid crash.</p>\n<p>Canvases with bigger <code class="codespan">zlevel</code> will be placed on Canvases with smaller <code class="codespan">zlevel</code>.</p>\n',
    )
    z: Optional[float] = Field(
        2,
        description='<p><code class="codespan">z</code> value of all graphical elements in , which controls order of drawing graphical components. Components with smaller <code class="codespan">z</code> values may be overwritten by those with larger <code class="codespan">z</code> values.</p>\n<p><code class="codespan">z</code> has a lower priority to <code class="codespan">zlevel</code>, and will not create new Canvas.</p>\n',
    )
    center: Optional[Any] = Field(
        "['50%', '50%']",
        description='\n\n<p>Center position of Polar coordinate, the first of which is the horizontal position, and the second is the vertical position.</p>\n<p>Percentage is supported. When set in percentage, the item is relative to the container width, and the second item to the height.</p>\n<p><strong>Example: </strong></p>\n<pre><code>// Set to absolute pixel values\ncenter: [400, 300]\n// Set to relative percent\ncenter: [&#39;50%&#39;, &#39;50%&#39;]\n</code></pre>',
    )
    radius: Optional[Union[float, str, Any]] = Field(
        None,
        description='\n\n<p>Radius of Polar coordinate. Value can be:</p>\n<ul>\n<li><code class="codespan">number</code>: Specify outside radius directly.</li>\n<li><code class="codespan">string</code>: For example, <code class="codespan">&#39;20%&#39;</code>, means that the outside radius is 20% of the viewport size (the little one between width and height of the chart container).</li>\n</ul>\n<ul>\n<li><code class="codespan">Array.&lt;number|string&gt;</code>: The first item specifies the inside radius, and the second item specifies the outside radius. Each item follows the definitions above.</li>\n</ul>\n',
    )
    tooltip: Optional[Tooltip1] = Field(
        None,
        description='<p>tooltip settings in the coordinate system component.</p>\n<p><strong>General Introduction:</strong></p>\n<p>tooltip can be configured on different places:</p>\n<ul>\n<li><p>Configured on global: <a href="#tooltip">tooltip</a></p>\n</li>\n<li><p>Configured in a coordinate system: <a href="#grid.tooltip">grid.tooltip</a>, <a href="#polar.tooltip">polar.tooltip</a>, <a href="#single.tooltip">single.tooltip</a></p>\n</li>\n<li><p>Configured in a series: <a href="#series.tooltip">series.tooltip</a></p>\n</li>\n<li><p>Configured in each item of <code class="codespan">series.data</code>: <a href="#series.data.tooltip">series.data.tooltip</a></p>\n</li>\n</ul>\n',
    )


class _StyleName11(_StyleName5):
    pass


class Rich11(BaseModel):
    """
        <p>&quot;Rich text styles&quot; can be defined in this <code class="codespan">rich</code> property. For example:</p>
    <pre><code class="lang-ts">label: {
        // Styles defined in &#39;rich&#39; can be applied to some fragments
        // of text by adding some markers to those fragment, like
        // `{styleName|text content text content}`.
        // `&#39;\n&#39;` is the newline character.
        formatter: [
            &#39;{a|Style &quot;a&quot; is applied to this snippet}&#39;
            &#39;{b|Style &quot;b&quot; is applied to this snippet}This snippet use default style{x|use style &quot;x&quot;}&#39;
        ].join(&#39;\n&#39;),

        rich: {
            a: {
                color: &#39;red&#39;,
                lineHeight: 10
            },
            b: {
                backgroundColor: {
                    image: &#39;xxx/xxx.jpg&#39;
                },
                height: 40
            },
            x: {
                fontSize: 18,
                fontFamily: &#39;Microsoft YaHei&#39;,
                borderColor: &#39;#449933&#39;,
                borderRadius: 4
            },
            ...
        }
    }
    </code></pre>
    <p>For more details, see <a href="tutorial.html#Rich%20Text" target="_blank">Rich Text</a> please.</p>

    """

    _style_name_: Optional[_StyleName11] = Field(
        None, alias='<style_name>', description=''
    )


class NameTextStyle2(BaseModel):
    """
    <p>Text style of axis name.</p>

    """

    color: Optional[Any] = Field(
        None,
        description='\n\n<p>Color of axis name uses <a href="#radiusAxis.axisLine.lineStyle.color">axisLine.lineStyle.color</a> by default.</p>\n',
    )
    fontStyle: Optional[str] = Field(
        'normal',
        description='\n\n<p>axis name font style.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;italic&#39;</code></li>\n<li><code class="codespan">&#39;oblique&#39;</code></li>\n</ul>\n',
    )
    fontWeight: Optional[Union[str, float]] = Field(
        'normal',
        description='\n\n<p>axis name font thick weight.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;bold&#39;</code></li>\n<li><code class="codespan">&#39;bolder&#39;</code></li>\n<li><code class="codespan">&#39;lighter&#39;</code></li>\n<li>100 | 200 | 300 | 400...</li>\n</ul>\n',
    )
    fontFamily: Optional[str] = Field(
        'sans-serif',
        description='\n\n<p>axis name font family.</p>\n<p>Can also be &#39;serif&#39; , &#39;monospace&#39;, ...</p>\n',
    )
    fontSize: Optional[float] = Field(
        12, description='\n\n<p>axis name font size.</p>\n'
    )
    align: Optional[str] = Field(
        None,
        description='\n\n<p>Horizontal alignment of text, automatic by default.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;left&#39;</code></li>\n<li><code class="codespan">&#39;center&#39;</code></li>\n<li><code class="codespan">&#39;right&#39;</code></li>\n</ul>\n<p>If <code class="codespan">align</code> is not set in <code class="codespan">rich</code>, <code class="codespan">align</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    align: right,\n    rich: {\n        a: {\n            // `align` is not set, then it will be right\n        }\n    }\n}\n</code></pre>\n',
    )
    verticalAlign: Optional[str] = Field(
        None,
        description='\n\n<p>Vertical alignment of text, automatic by default.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;top&#39;</code></li>\n<li><code class="codespan">&#39;middle&#39;</code></li>\n<li><code class="codespan">&#39;bottom&#39;</code></li>\n</ul>\n<p>If <code class="codespan">verticalAlign</code> is not set in <code class="codespan">rich</code>, <code class="codespan">verticalAlign</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    verticalAlign: bottom,\n    rich: {\n        a: {\n            // `verticalAlign` is not set, then it will be bottom\n        }\n    }\n}\n</code></pre>\n',
    )
    lineHeight: Optional[float] = Field(
        None,
        description='\n\n<p>Line height of the text fragment.</p>\n<p>If <code class="codespan">lineHeight</code> is not set in <code class="codespan">rich</code>, <code class="codespan">lineHeight</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    lineHeight: 56,\n    rich: {\n        a: {\n            // `lineHeight` is not set, then it will be 56\n        }\n    }\n}\n</code></pre>\n',
    )
    backgroundColor: Optional[Union[str, Any]] = Field(
        'transparent',
        description='\n\n<p>Background color of the text fragment.</p>\n<p>Can be color string, like <code class="codespan">&#39;#123234&#39;</code>, <code class="codespan">&#39;red&#39;</code>, <code class="codespan">&#39;rgba(0,23,11,0.3)&#39;</code>.</p>\n<p>Or image can be used, for example:</p>\n<pre><code class="lang-ts">backgroundColor: {\n    image: &#39;xxx/xxx.png&#39;\n    // It can be URL of a image,\n    // or dataURI,\n    // or HTMLImageElement,\n    // or HTMLCanvasElement.\n}\n</code></pre>\n<p><code class="codespan">width</code> or <code class="codespan">height</code> can be specified when using background image, or\nauto adapted by default.</p>\n',
    )
    borderColor: Optional[Any] = Field(
        None, description='\n\n<p>Border color of the text fragment.</p>\n'
    )
    borderWidth: Optional[float] = Field(
        0, description='\n\n<p>Border width of the text fragment.</p>\n'
    )
    borderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>the text fragment border type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">borderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\nborderType: [5, 10],\n\nborderDashOffset: 5\n}\n</code></pre>\n',
    )
    borderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">borderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    borderRadius: Optional[float] = Field(
        0, description='\n\n<p>Border radius of the text fragment.</p>\n'
    )
    padding: Optional[Union[float, Any]] = Field(
        0,
        description='\n\n<p>Padding of the text fragment, for example:</p>\n<ul>\n<li><code class="codespan">padding: [3, 4, 5, 6]</code>: represents padding of <code class="codespan">[top, right, bottom, left]</code>.</li>\n<li><code class="codespan">padding: 4</code>: represents <code class="codespan">padding: [4, 4, 4, 4]</code>.</li>\n<li><code class="codespan">padding: [3, 4]</code>: represents <code class="codespan">padding: [3, 4, 3, 4]</code>.</li>\n</ul>\n<p>Notice, <code class="codespan">width</code> and <code class="codespan">height</code> specifies the width and height of the content, without <code class="codespan">padding</code>.</p>\n',
    )
    shadowColor: Optional[Any] = Field(
        'transparent', description='\n\n<p>Shadow color of the text block.</p>\n'
    )
    shadowBlur: Optional[float] = Field(
        0, description='\n\n<p>Show blur of the text block.</p>\n'
    )
    shadowOffsetX: Optional[float] = Field(
        0, description='\n\n<p>Shadow X offset of the text block.</p>\n'
    )
    shadowOffsetY: Optional[float] = Field(
        0, description='\n\n<p>Shadow Y offset of the text block.</p>\n'
    )
    width: Optional[float] = Field(
        None, description='\n\n<p>Width of text block.</p>\n'
    )
    height: Optional[float] = Field(
        None, description='\n\n<p>Height of text block.</p>\n'
    )
    textBorderColor: Optional[Any] = Field(
        None, description='\n\n<p>Stroke color of the text.</p>\n'
    )
    textBorderWidth: Optional[float] = Field(
        None, description='\n\n<p>Stroke line width of the text.</p>\n'
    )
    textBorderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>Stroke line type of the text.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">textBorderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\ntextBorderType: [5, 10],\n\ntextBorderDashOffset: 5\n}\n</code></pre>\n',
    )
    textBorderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">textBorderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    textShadowColor: Optional[Any] = Field(
        'transparent', description='\n\n<p>Shadow color of the text itself.</p>\n'
    )
    textShadowBlur: Optional[float] = Field(
        0, description='\n\n<p>Shadow blue of the text itself.</p>\n'
    )
    textShadowOffsetX: Optional[float] = Field(
        0, description='\n\n<p>Shadow X offset of the text itself.</p>\n'
    )
    textShadowOffsetY: Optional[float] = Field(
        0, description='\n\n<p>Shadow Y offset of the text itself.</p>\n'
    )
    overflow: Optional[str] = Field(
        'none',
        description='\n\n<p>Determine how to display the text when it&#39;s overflow. Available when <code class="codespan">width</code> is set.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the text and trailing with <code class="codespan">ellipsis</code>.</li>\n<li><code class="codespan">&#39;break&#39;</code> Break by word</li>\n<li><code class="codespan">&#39;breakAll&#39;</code> Break by character.</li>\n</ul>\n',
    )
    ellipsis: Optional[str] = Field(
        '...',
        description='<p>Ellipsis to be displayed when <code class="codespan">overflow</code> is set to <code class="codespan">truncate</code>.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the overflow lines.</li>\n</ul>\n',
    )
    rich: Optional[Rich11] = Field(
        None,
        description='<p>&quot;Rich text styles&quot; can be defined in this <code class="codespan">rich</code> property. For example:</p>\n<pre><code class="lang-ts">label: {\n    // Styles defined in &#39;rich&#39; can be applied to some fragments\n    // of text by adding some markers to those fragment, like\n    // `{styleName|text content text content}`.\n    // `&#39;\\n&#39;` is the newline character.\n    formatter: [\n        &#39;{a|Style &quot;a&quot; is applied to this snippet}&#39;\n        &#39;{b|Style &quot;b&quot; is applied to this snippet}This snippet use default style{x|use style &quot;x&quot;}&#39;\n    ].join(&#39;\\n&#39;),\n\n    rich: {\n        a: {\n            color: &#39;red&#39;,\n            lineHeight: 10\n        },\n        b: {\n            backgroundColor: {\n                image: &#39;xxx/xxx.jpg&#39;\n            },\n            height: 40\n        },\n        x: {\n            fontSize: 18,\n            fontFamily: &#39;Microsoft YaHei&#39;,\n            borderColor: &#39;#449933&#39;,\n            borderRadius: 4\n        },\n        ...\n    }\n}\n</code></pre>\n<p>For more details, see <a href="tutorial.html#Rich%20Text" target="_blank">Rich Text</a> please.</p>\n',
    )


class LineStyle16(LineStyle3):
    pass


class AxisLine2(BaseModel):
    """
    <p>Settings related to axis line.</p>

    """

    show: Optional[bool] = Field(
        True,
        description='\n\n<p>Set this to <code class="codespan">false</code> to prevent the axis line from showing.</p>\n',
    )
    symbol: Optional[Union[str, Any]] = Field(
        'none',
        description='\n\n<p>Symbol of the two ends of the axis. It could be a string, representing the same symbol for two ends; or an array with two string elements, representing the two ends separately. It&#39;s set to be <code class="codespan">&#39;none&#39;</code> by default, meaning no arrow for either end. If it is set to be <code class="codespan">&#39;arrow&#39;</code>, there shall be two arrows. If there should only one arrow at the end, it should set to be <code class="codespan">[&#39;none&#39;, &#39;arrow&#39;]</code>.</p>\n',
    )
    symbolSize: Optional[Any] = Field(
        '[10, 15]',
        description='\n\n<p>Size of the arrows at two ends. The first is the width perpendicular to the axis, the next is the width parallel to the axis.</p>\n',
    )
    symbolOffset: Optional[Union[Any, float]] = Field(
        '[0, 0]',
        description='\n\n<p>Arrow offset of axis. If is array, the first number is the offset of the arrow at the beginning, and the second number is the offset of the arrow at the end. If is number, it means the arrows have the same offset.</p>\n',
    )
    lineStyle: Optional[LineStyle16] = Field(None, description='')


class LineStyle17(BaseModel):
    """
    <p>Line style of axis ticks.</p>

    """

    color: Optional[Any] = Field(
        None,
        description='<p>Color of axis label is set to be <a href="#radiusAxis.axisLine.lineStyle.color">axisLine.lineStyle.color</a> by default.</p>\n',
    )
    width: Optional[float] = Field(1, description='\n\n<p>axisTick line width.</p>\n')
    type: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>line type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">dashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\ntype: [5, 10],\n\ndashOffset: 5\n}\n</code></pre>\n',
    )
    dashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">type</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    cap: Optional[str] = Field(
        'butt',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To specify how to draw the end points of the line.\nPossible values are:</p>\n<ul>\n<li><code class="codespan">&#39;butt&#39;</code>: The ends of lines are squared off at the endpoints.</li>\n<li><code class="codespan">&#39;round&#39;</code>: The ends of lines are rounded.</li>\n<li><code class="codespan">&#39;square&#39;</code>: The ends of lines are squared off by adding a box with an equal width and half the height of the line&#39;s thickness.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;butt&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineCap" target="_blank">lineCap</a> for more details.</p>\n',
    )
    join: Optional[str] = Field(
        'bevel',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To determine the shape used to join two line segments where they meet.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;bevel&#39;</code>: Fills an additional triangular area between the common endpoint of connected segments, and the separate outside rectangular corners of each segment.</li>\n<li><code class="codespan">&#39;round&#39;</code>: Rounds off the corners of a shape by filling an additional sector of disc centered at the common endpoint of connected segments. The radius for these rounded corners is equal to the line width.</li>\n<li><code class="codespan">&#39;miter&#39;</code>: Connected segments are joined by extending their outside edges to connect at a single point, with the effect of filling an additional lozenge-shaped area. This setting is affected by the \n<code class="codespan">miterLimit</code>\nproperty.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;bevel&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineJoin" target="_blank">lineJoin</a> for more details.</p>\n',
    )
    miterLimit: Optional[float] = Field(
        10,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the miter limit ratio. Only works when \n<code class="codespan">join</code>\n is set as <code class="codespan">miter</code>.</p>\n<p>Default value is <code class="codespan">10</code>. Negative、<code class="codespan">0</code>、<code class="codespan">Infinity</code> and <code class="codespan">NaN</code> values are ignored.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/miterLimit" target="_blank">miterLimit</a> for more details.</p>\n',
    )
    shadowBlur: Optional[float] = Field(
        None,
        description='\n\n<p>Size of shadow blur. This attribute should be used along with <code class="codespan">shadowColor</code>,<code class="codespan">shadowOffsetX</code>, <code class="codespan">shadowOffsetY</code> to set shadow to component.</p>\n<p>For example:</p>\n<pre><code class="lang-ts">{\n    shadowColor: &#39;rgba(0, 0, 0, 0.5)&#39;,\n    shadowBlur: 10\n}\n</code></pre>\n',
    )
    shadowColor: Optional[Any] = Field(
        None,
        description='\n\n<p>Shadow color. Support same format as <code class="codespan">color</code>.</p>\n',
    )
    shadowOffsetX: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the horizontal direction of shadow.</p>\n',
    )
    shadowOffsetY: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the vertical direction of shadow.</p>\n',
    )
    opacity: Optional[float] = Field(
        None,
        description='\n\n<p>Opacity of the component. Supports value from 0 to 1, and the component will not be drawn when set to 0.</p>\n\n',
    )


class AxisTick2(BaseModel):
    """
    <p>Settings related to axis tick.</p>

    """

    show: Optional[bool] = Field(
        True,
        description='\n\n<p>Set this to <code class="codespan">false</code> to prevent the axis tick from showing.</p>\n',
    )
    alignWithLabel: Optional[bool] = Field(
        False,
        description='\n\n<p>Align axis tick with label, which is available only when <code class="codespan">boundaryGap</code> is set to be <code class="codespan">true</code> in category axis. See the following picture:</p>\n<p><img width="600" height="auto" src="documents/asset/img/axis-align-with-label.png"></p>\n',
    )
    interval: Optional[Union[float, Any]] = Field(
        'auto',
        description='\n\n\n\n<p>Interval of axisTick, which is available in category axis.  is set to be the same as <a href="#radiusAxis.axisLabel.interval">axisLabel.interval</a> by default.</p>\n<p>It uses a strategy that labels do not overlap by default.</p>\n<p>You may set it to be 0 to display all labels compulsively.</p>\n<p>If it is set to be 1, it means that labels are shown once after one label. And if it is set to be 2, it means labels are shown once after two labels, and so on.</p>\n<p>On the other hand, you can control by callback function, whose format is shown below:</p>\n<pre><code class="lang-ts">(index:number, value: string) =&gt; boolean\n</code></pre>\n<p>The first parameter is index of category, and the second parameter is the name of category. The return values decides whether to display label.</p>\n',
    )
    inside: Optional[bool] = Field(
        False,
        description='\n\n<p>Set this to <code class="codespan">true</code> so the axis labels face the <code class="codespan">inside</code> direction.</p>\n',
    )
    length: Optional[float] = Field(
        5, description='\n\n<p>The length of the axis tick.</p>\n'
    )
    lineStyle: Optional[LineStyle17] = Field(
        None, description='<p>Line style of axis ticks.</p>\n'
    )


class LineStyle18(BaseModel):
    color: Optional[Any] = Field(
        None,
        description='\n\n<p>Style configuration of minor ticks lines <a href="#radiusAxis.axisLine.lineStyle.color">axisLine.lineStyle.color</a>。</p>\n',
    )
    width: Optional[float] = Field(1, description='\n\n<p>minorTick line width.</p>\n')
    type: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>line type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">dashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\ntype: [5, 10],\n\ndashOffset: 5\n}\n</code></pre>\n',
    )
    dashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">type</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    cap: Optional[str] = Field(
        'butt',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To specify how to draw the end points of the line.\nPossible values are:</p>\n<ul>\n<li><code class="codespan">&#39;butt&#39;</code>: The ends of lines are squared off at the endpoints.</li>\n<li><code class="codespan">&#39;round&#39;</code>: The ends of lines are rounded.</li>\n<li><code class="codespan">&#39;square&#39;</code>: The ends of lines are squared off by adding a box with an equal width and half the height of the line&#39;s thickness.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;butt&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineCap" target="_blank">lineCap</a> for more details.</p>\n',
    )
    join: Optional[str] = Field(
        'bevel',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To determine the shape used to join two line segments where they meet.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;bevel&#39;</code>: Fills an additional triangular area between the common endpoint of connected segments, and the separate outside rectangular corners of each segment.</li>\n<li><code class="codespan">&#39;round&#39;</code>: Rounds off the corners of a shape by filling an additional sector of disc centered at the common endpoint of connected segments. The radius for these rounded corners is equal to the line width.</li>\n<li><code class="codespan">&#39;miter&#39;</code>: Connected segments are joined by extending their outside edges to connect at a single point, with the effect of filling an additional lozenge-shaped area. This setting is affected by the \n<code class="codespan">miterLimit</code>\nproperty.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;bevel&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineJoin" target="_blank">lineJoin</a> for more details.</p>\n',
    )
    miterLimit: Optional[float] = Field(
        10,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the miter limit ratio. Only works when \n<code class="codespan">join</code>\n is set as <code class="codespan">miter</code>.</p>\n<p>Default value is <code class="codespan">10</code>. Negative、<code class="codespan">0</code>、<code class="codespan">Infinity</code> and <code class="codespan">NaN</code> values are ignored.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/miterLimit" target="_blank">miterLimit</a> for more details.</p>\n',
    )
    shadowBlur: Optional[float] = Field(
        None,
        description='\n\n<p>Size of shadow blur. This attribute should be used along with <code class="codespan">shadowColor</code>,<code class="codespan">shadowOffsetX</code>, <code class="codespan">shadowOffsetY</code> to set shadow to component.</p>\n<p>For example:</p>\n<pre><code class="lang-ts">{\n    shadowColor: &#39;rgba(0, 0, 0, 0.5)&#39;,\n    shadowBlur: 10\n}\n</code></pre>\n',
    )
    shadowColor: Optional[Any] = Field(
        None,
        description='\n\n<p>Shadow color. Support same format as <code class="codespan">color</code>.</p>\n',
    )
    shadowOffsetX: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the horizontal direction of shadow.</p>\n',
    )
    shadowOffsetY: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the vertical direction of shadow.</p>\n',
    )
    opacity: Optional[float] = Field(
        None,
        description='\n\n<p>Opacity of the component. Supports value from 0 to 1, and the component will not be drawn when set to 0.</p>\n\n',
    )


class MinorTick2(BaseModel):
    """
        <blockquote>
    <p>Since <code class="codespan">v4.6.0</code></p>
    </blockquote>
    <p>Settings related minor ticks.</p>
    <p>Note: <code class="codespan">minorTick</code> is not available in the <code class="codespan">category</code> type axis.</p>
    <p>Examples:</p>
    <p>1) Using minor ticks in function plotting.</p>
    <iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=line-function&edit=1&reset=1" width="600" height="350"></iframe>


    <p>2) Using minor ticks in log axis.</p>
    <iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=line-log&edit=1&reset=1" width="600" height="350"></iframe>


    """

    show: Optional[bool] = Field(False, description='\n\n<p>If show minor ticks.</p>\n')
    splitNumber: Optional[float] = Field(
        5, description='\n\n<p>Number of interval splited by minor ticks.</p>\n'
    )
    length: Optional[float] = Field(
        3, description='\n\n<p>Length of minor ticks lines。</p>\n'
    )
    lineStyle: Optional[LineStyle18] = Field(None, description='')


class _StyleName12(_StyleName5):
    pass


class Rich12(BaseModel):
    """
        <p>&quot;Rich text styles&quot; can be defined in this <code class="codespan">rich</code> property. For example:</p>
    <pre><code class="lang-ts">label: {
        // Styles defined in &#39;rich&#39; can be applied to some fragments
        // of text by adding some markers to those fragment, like
        // `{styleName|text content text content}`.
        // `&#39;\n&#39;` is the newline character.
        formatter: [
            &#39;{a|Style &quot;a&quot; is applied to this snippet}&#39;
            &#39;{b|Style &quot;b&quot; is applied to this snippet}This snippet use default style{x|use style &quot;x&quot;}&#39;
        ].join(&#39;\n&#39;),

        rich: {
            a: {
                color: &#39;red&#39;,
                lineHeight: 10
            },
            b: {
                backgroundColor: {
                    image: &#39;xxx/xxx.jpg&#39;
                },
                height: 40
            },
            x: {
                fontSize: 18,
                fontFamily: &#39;Microsoft YaHei&#39;,
                borderColor: &#39;#449933&#39;,
                borderRadius: 4
            },
            ...
        }
    }
    </code></pre>
    <p>For more details, see <a href="tutorial.html#Rich%20Text" target="_blank">Rich Text</a> please.</p>

    """

    _style_name_: Optional[_StyleName12] = Field(
        None, alias='<style_name>', description=''
    )


class AxisLabel2(BaseModel):
    """
    <p>Settings related to axis label.</p>

    """

    show: Optional[bool] = Field(
        True,
        description='\n\n<p>Set this to <code class="codespan">false</code> to prevent the axis label from appearing.</p>\n',
    )
    interval: Optional[Union[float, Any]] = Field(
        'auto',
        description='\n\n\n\n<p>Interval of Axis label, which is available in category axis. </p>\n<p>It uses a strategy that labels do not overlap by default.</p>\n<p>You may set it to be 0 to display all labels compulsively.</p>\n<p>If it is set to be 1, it means that labels are shown once after one label. And if it is set to be 2, it means labels are shown once after two labels, and so on.</p>\n<p>On the other hand, you can control by callback function, whose format is shown below:</p>\n<pre><code class="lang-ts">(index:number, value: string) =&gt; boolean\n</code></pre>\n<p>The first parameter is index of category, and the second parameter is the name of category. The return values decides whether to display label.</p>\n',
    )
    inside: Optional[bool] = Field(
        False,
        description='\n\n<p>Set this to <code class="codespan">true</code> so the axis labels face the <code class="codespan">inside</code> direction.</p>\n',
    )
    rotate: Optional[float] = Field(
        0,
        description='\n\n<p>Rotation degree of axis label, which is especially useful when there is no enough space for category axis.</p>\n<p>Rotation degree is from -90 to 90.</p>\n',
    )
    margin: Optional[float] = Field(
        8,
        description='\n\n<p>The margin between the axis label and the axis line.</p>\n',
    )
    formatter: Optional[Union[str, Any]] = Field(
        None,
        description='<p>Formatter of axis label, which supports string template and callback function.</p>\n<p>Example:</p>\n<pre><code class="lang-ts">// Use string template; template variable is the default label of axis {value}\nformatter: &#39;{value} kg&#39;\n// Use callback.\nformatter: function (value, index) {\n    return value + &#39;kg&#39;;\n}\n</code></pre>\n<hr>\n<p>For axes of time <a href="#.type">type</a>: <code class="codespan">&#39;time&#39;</code>, <code class="codespan">formatter</code> supports the following forms:</p>\n<ul>\n<li><strong>String Templates</strong>: an easy and fast way to make frequently used date/time template, formed in <code class="codespan">string</code></li>\n<li><strong>Callback Functions</strong>: customized formatter to make complex format, formed in <code class="codespan">Function</code></li>\n<li><strong>Cascading Templates</strong>: to adopt different formatters for different time granularity, formed in <code class="codespan">object</code></li>\n</ul>\n<p>Next, we are going to introduce these three forms one by one.</p>\n<p><strong> String Templates </strong></p>\n<p>Using string templates is an easy way to format date/time with frequently used formats. If it can be used to make what you want, you are advised to do so. If not, you could then consider the others. Supported formats are:</p>\n<table>\n<thead>\n<tr>\n<th>Group</th>\n<th>Template</th>\n<th>Value (EN)</th>\n<th>Value (ZH)</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n<td>Year</td>\n<td>{yyyy}</td>\n<td>e.g., 2020, 2021, ...</td>\n<td>例：2020, 2021, ...</td>\n</tr>\n<tr>\n<td></td>\n<td>{yy}</td>\n<td>00-99</td>\n<td>00-99</td>\n</tr>\n<tr>\n<td>Quarter</td>\n<td>{Q}</td>\n<td>1, 2, 3, 4</td>\n<td>1, 2, 3, 4</td>\n</tr>\n<tr>\n<td>Month</td>\n<td>{MMMM}</td>\n<td>e.g., January, February, ...</td>\n<td>一月、二月、……</td>\n</tr>\n<tr>\n<td></td>\n<td>{MMM}</td>\n<td>e.g., Jan, Feb, ...</td>\n<td>1月、2月、……</td>\n</tr>\n<tr>\n<td></td>\n<td>{MM}</td>\n<td>01-12</td>\n<td>01-12</td>\n</tr>\n<tr>\n<td></td>\n<td>{M}</td>\n<td>1-12</td>\n<td>1-12</td>\n</tr>\n<tr>\n<td>Day of Month</td>\n<td>{dd}</td>\n<td>01-31</td>\n<td>01-31</td>\n</tr>\n<tr>\n<td></td>\n<td>{d}</td>\n<td>1-31</td>\n<td>1-31</td>\n</tr>\n<tr>\n<td>Day of Week</td>\n<td>{eeee}</td>\n<td>Sunday, Monday, Tuesday, Wednesday, Thursday, Friday, Saturday</td>\n<td>星期日、星期一、星期二、星期三、星期四、星期五、星期六</td>\n</tr>\n<tr>\n<td></td>\n<td>{ee}</td>\n<td>Sun, Mon, Tues, Wed, Thu, Fri, Sat</td>\n<td>日、一、二、三、四、五、六</td>\n</tr>\n<tr>\n<td></td>\n<td>{e}</td>\n<td>1-54</td>\n<td>1-54</td>\n</tr>\n<tr>\n<td>Hour</td>\n<td>{HH}</td>\n<td>00-23</td>\n<td>00-23</td>\n</tr>\n<tr>\n<td></td>\n<td>{H}</td>\n<td>0-23</td>\n<td>0-23</td>\n</tr>\n<tr>\n<td></td>\n<td>{hh}</td>\n<td>01-12</td>\n<td>01-12</td>\n</tr>\n<tr>\n<td></td>\n<td>{h}</td>\n<td>1-12</td>\n<td>1-12</td>\n</tr>\n<tr>\n<td>Minute</td>\n<td>{mm}</td>\n<td>00-59</td>\n<td>00-59</td>\n</tr>\n<tr>\n<td></td>\n<td>{m}</td>\n<td>0-59</td>\n<td>0-59</td>\n</tr>\n<tr>\n<td>Second</td>\n<td>{ss}</td>\n<td>00-59</td>\n<td>00-59</td>\n</tr>\n<tr>\n<td></td>\n<td>{s}</td>\n<td>0-59</td>\n<td>0-59</td>\n</tr>\n<tr>\n<td>Millisecond</td>\n<td>{SSS}</td>\n<td>000-999</td>\n<td>000-999</td>\n</tr>\n<tr>\n<td></td>\n<td>{S}</td>\n<td>0-999</td>\n<td>0-999</td>\n</tr>\n</tbody>\n</table>\n<blockquote>\n<p>Templates of other languages can be found in <a href="https://github.com/apache/echarts/tree/master/src/i18n" target="_blank">the language package</a>. Please refer to <a href="api.html#echarts.registerLocale" target="_blank">echarts.registerLocale</a> to register a language.</p>\n</blockquote>\n<p>Example:</p>\n<pre><code class="lang-ts">formatter: &#39;{yyyy}-{MM}-{dd}&#39; // gets labels like &#39;2020-12-02&#39;\nformatter: &#39;Day {d}&#39; // gets labels like &#39;Day 2&#39;\n</code></pre>\n<p><strong> Callback Functions </strong></p>\n<p>Callback functions can be used to get different formats for different axis tick values. Sometimes, if you have complex date/time formatting requirement, third-party libraries like <a href="https://momentjs.com/" target="_blank">Moment.js</a> or <a href="https://date-fns.org/" target="_blank">date-fns</a> can be used to return formatted labels.</p>\n<p>Example:</p>\n<pre><code class="lang-ts">// Use callback function; function parameters are axis index\nformatter: function (value, index) {\n    // Formatted to be month/day; display year only in the first label\n    var date = new Date(value);\n    var texts = [(date.getMonth() + 1), date.getDate()];\n    if (index === 0) {\n        texts.unshift(date.getYear());\n    }\n    return texts.join(&#39;/&#39;);\n}\n</code></pre>\n<p><strong> Cascading Templates </strong></p>\n<p>Sometimes, we wish to use different formats for different time granularity. For example, in a quarter-year chart, we may wish to see the month name with the first date of the month, while see the date name with others. This can be made with:</p>\n<p>Example:</p>\n<pre><code class="lang-ts">formatter: {\n    month: &#39;{MMMM}&#39;, // Jan, Feb, ...\n    day: &#39;{d}&#39; // 1, 2, ...\n}\n</code></pre>\n<p>Supported levels and their default formatters are:</p>\n<pre><code class="lang-ts">{\n    year: &#39;{yyyy}&#39;,\n    month: &#39;{MMM}&#39;,\n    day: &#39;{d}&#39;,\n    hour: &#39;{HH}:{mm}&#39;,\n    minute: &#39;{HH}:{mm}&#39;,\n    second: &#39;{HH}:{mm}:{ss}&#39;,\n    millisecond: &#39;{hh}:{mm}:{ss} {SSS}&#39;,\n    none: &#39;{yyyy}-{MM}-{dd} {hh}:{mm}:{ss} {SSS}&#39;\n}\n</code></pre>\n<p>Let&#39;s take <code class="codespan">day</code> for example. When a tick value is <code class="codespan">0</code> for its hour, minute, second, and millisecond, <code class="codespan">day</code> level will be used to make formatter. <code class="codespan">none</code> is used when no other level fulfills, which is for tick values with millisecond values other than <code class="codespan">0</code>.</p>\n<p><strong> Rich Text </strong></p>\n<p>The above three forms all support rich text, so it can be used to make some complex effects.</p>\n<p>Example:</p>\n<pre><code class="lang-ts">xAxis: {\n    type: &#39;time&#39;,\n    axisLabel: {\n        formatter: {\n            // Display year and month information on the first data of a year\n            year: &#39;{yearStyle|{yyyy}}\\n{monthStyle|{MMM}}&#39;,\n            month: &#39;{monthStyle|{MMM}}&#39;\n        },\n        rich: {\n            yearStyle: {\n                // Make yearly text more standing out\n                color: &#39;#000&#39;,\n                fontWeight: &#39;bold&#39;\n            },\n            monthStyle: {\n                color: &#39;#999&#39;\n            }\n        }\n    }\n},\n</code></pre>\n<p>The above example can also be made with a callback function:</p>\n<p>Example:</p>\n<pre><code class="lang-ts">xAxis: {\n    type: &#39;time&#39;,\n    axisLabel: {\n        formatter: function (value) {\n            const date = new Date(value);\n            const yearStart = new Date(value);\n            yearStart.setMonth(0);\n            yearStart.setDate(1);\n            yearStart.setHours(0);\n            yearStart.setMinutes(0);\n            yearStart.setSeconds(0);\n            yearStart.setMilliseconds(0);\n            // Whether a tick value is the start of a year\n            if (date.getTime() === yearStart.getTime()) {\n                return &#39;{year|&#39; + date.getFullYear() + &#39;}\\n&#39;\n                    + &#39;{month|&#39; + (date.getMonth() + 1) + &#39;月}&#39;;\n            }\n            else {\n                return &#39;{month|&#39; + (date.getMonth() + 1) + &#39;月}&#39;\n            }\n        },\n        rich: {\n            year: {\n                color: &#39;#000&#39;,\n                fontWeight: &#39;bold&#39;\n            },\n            month: {\n                color: &#39;#999&#39;\n            }\n        }\n    }\n},\n</code></pre>\n',
    )
    showMinLabel: Optional[bool] = Field(
        None,
        description='\n\n<p>Whether to show the label of the min tick. Optional values: <code class="codespan">true</code>, <code class="codespan">false</code>, <code class="codespan">null</code>. It is auto determined by default, that is, if labels are overlapped, the label of the min tick will not be displayed.</p>\n',
    )
    showMaxLabel: Optional[bool] = Field(
        None,
        description='\n\n<p>Whether to show the label of the max tick. Optional values: <code class="codespan">true</code>, <code class="codespan">false</code>, <code class="codespan">null</code>. It is auto determined by default, that is, if labels are overlapped, the label of the max tick will not be displayed.</p>\n',
    )
    hideOverlap: Optional[bool] = Field(
        None,
        description='\n\n\n\n<blockquote>\n<p>Since <code class="codespan">v5.2.0</code></p>\n</blockquote>\n<p>Whether to hide overlapped labels.</p>\n',
    )
    color: Optional[Union[Any, Any]] = Field(
        None,
        description='\n\n<p>Color of axis label is set to be <a href="#radiusAxis.axisLine.lineStyle.color">axisLine.lineStyle.color</a> by default. Callback function is supported, in the following format:</p>\n<pre><code class="lang-ts">(val: string) =&gt; Color\n</code></pre>\n<p>Parameter is the text of label, and return value is the color. See the following example:</p>\n<pre><code class="lang-ts">textStyle: {\n    color: function (value, index) {\n        return value &gt;= 0 ? &#39;green&#39; : &#39;red&#39;;\n    }\n}\n</code></pre>\n',
    )
    fontStyle: Optional[str] = Field(
        'normal',
        description='\n\n<p> font style.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;italic&#39;</code></li>\n<li><code class="codespan">&#39;oblique&#39;</code></li>\n</ul>\n',
    )
    fontWeight: Optional[Union[str, float]] = Field(
        'normal',
        description='\n\n<p> font thick weight.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;bold&#39;</code></li>\n<li><code class="codespan">&#39;bolder&#39;</code></li>\n<li><code class="codespan">&#39;lighter&#39;</code></li>\n<li>100 | 200 | 300 | 400...</li>\n</ul>\n',
    )
    fontFamily: Optional[str] = Field(
        'sans-serif',
        description='\n\n<p> font family.</p>\n<p>Can also be &#39;serif&#39; , &#39;monospace&#39;, ...</p>\n',
    )
    fontSize: Optional[float] = Field(12, description='\n\n<p> font size.</p>\n')
    align: Optional[str] = Field(
        None,
        description='\n\n<p>Horizontal alignment of text, automatic by default.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;left&#39;</code></li>\n<li><code class="codespan">&#39;center&#39;</code></li>\n<li><code class="codespan">&#39;right&#39;</code></li>\n</ul>\n<p>If <code class="codespan">align</code> is not set in <code class="codespan">rich</code>, <code class="codespan">align</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    align: right,\n    rich: {\n        a: {\n            // `align` is not set, then it will be right\n        }\n    }\n}\n</code></pre>\n',
    )
    verticalAlign: Optional[str] = Field(
        None,
        description='\n\n<p>Vertical alignment of text, automatic by default.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;top&#39;</code></li>\n<li><code class="codespan">&#39;middle&#39;</code></li>\n<li><code class="codespan">&#39;bottom&#39;</code></li>\n</ul>\n<p>If <code class="codespan">verticalAlign</code> is not set in <code class="codespan">rich</code>, <code class="codespan">verticalAlign</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    verticalAlign: bottom,\n    rich: {\n        a: {\n            // `verticalAlign` is not set, then it will be bottom\n        }\n    }\n}\n</code></pre>\n',
    )
    lineHeight: Optional[float] = Field(
        None,
        description='\n\n<p>Line height of the text fragment.</p>\n<p>If <code class="codespan">lineHeight</code> is not set in <code class="codespan">rich</code>, <code class="codespan">lineHeight</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    lineHeight: 56,\n    rich: {\n        a: {\n            // `lineHeight` is not set, then it will be 56\n        }\n    }\n}\n</code></pre>\n',
    )
    backgroundColor: Optional[Union[str, Any]] = Field(
        'transparent',
        description='\n\n<p>Background color of the text fragment.</p>\n<p>Can be color string, like <code class="codespan">&#39;#123234&#39;</code>, <code class="codespan">&#39;red&#39;</code>, <code class="codespan">&#39;rgba(0,23,11,0.3)&#39;</code>.</p>\n<p>Or image can be used, for example:</p>\n<pre><code class="lang-ts">backgroundColor: {\n    image: &#39;xxx/xxx.png&#39;\n    // It can be URL of a image,\n    // or dataURI,\n    // or HTMLImageElement,\n    // or HTMLCanvasElement.\n}\n</code></pre>\n<p><code class="codespan">width</code> or <code class="codespan">height</code> can be specified when using background image, or\nauto adapted by default.</p>\n',
    )
    borderColor: Optional[Any] = Field(
        None, description='\n\n<p>Border color of the text fragment.</p>\n'
    )
    borderWidth: Optional[float] = Field(
        0, description='\n\n<p>Border width of the text fragment.</p>\n'
    )
    borderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>the text fragment border type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">borderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\nborderType: [5, 10],\n\nborderDashOffset: 5\n}\n</code></pre>\n',
    )
    borderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">borderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    borderRadius: Optional[float] = Field(
        0, description='\n\n<p>Border radius of the text fragment.</p>\n'
    )
    padding: Optional[Union[float, Any]] = Field(
        0,
        description='\n\n<p>Padding of the text fragment, for example:</p>\n<ul>\n<li><code class="codespan">padding: [3, 4, 5, 6]</code>: represents padding of <code class="codespan">[top, right, bottom, left]</code>.</li>\n<li><code class="codespan">padding: 4</code>: represents <code class="codespan">padding: [4, 4, 4, 4]</code>.</li>\n<li><code class="codespan">padding: [3, 4]</code>: represents <code class="codespan">padding: [3, 4, 3, 4]</code>.</li>\n</ul>\n<p>Notice, <code class="codespan">width</code> and <code class="codespan">height</code> specifies the width and height of the content, without <code class="codespan">padding</code>.</p>\n',
    )
    shadowColor: Optional[Any] = Field(
        'transparent', description='\n\n<p>Shadow color of the text block.</p>\n'
    )
    shadowBlur: Optional[float] = Field(
        0, description='\n\n<p>Show blur of the text block.</p>\n'
    )
    shadowOffsetX: Optional[float] = Field(
        0, description='\n\n<p>Shadow X offset of the text block.</p>\n'
    )
    shadowOffsetY: Optional[float] = Field(
        0, description='\n\n<p>Shadow Y offset of the text block.</p>\n'
    )
    width: Optional[float] = Field(
        None, description='\n\n<p>Width of text block.</p>\n'
    )
    height: Optional[float] = Field(
        None, description='\n\n<p>Height of text block.</p>\n'
    )
    textBorderColor: Optional[Any] = Field(
        None, description='\n\n<p>Stroke color of the text.</p>\n'
    )
    textBorderWidth: Optional[float] = Field(
        None, description='\n\n<p>Stroke line width of the text.</p>\n'
    )
    textBorderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>Stroke line type of the text.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">textBorderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\ntextBorderType: [5, 10],\n\ntextBorderDashOffset: 5\n}\n</code></pre>\n',
    )
    textBorderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">textBorderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    textShadowColor: Optional[Any] = Field(
        'transparent', description='\n\n<p>Shadow color of the text itself.</p>\n'
    )
    textShadowBlur: Optional[float] = Field(
        0, description='\n\n<p>Shadow blue of the text itself.</p>\n'
    )
    textShadowOffsetX: Optional[float] = Field(
        0, description='\n\n<p>Shadow X offset of the text itself.</p>\n'
    )
    textShadowOffsetY: Optional[float] = Field(
        0, description='\n\n<p>Shadow Y offset of the text itself.</p>\n'
    )
    overflow: Optional[str] = Field(
        'none',
        description='\n\n<p>Determine how to display the text when it&#39;s overflow. Available when <code class="codespan">width</code> is set.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the text and trailing with <code class="codespan">ellipsis</code>.</li>\n<li><code class="codespan">&#39;break&#39;</code> Break by word</li>\n<li><code class="codespan">&#39;breakAll&#39;</code> Break by character.</li>\n</ul>\n',
    )
    ellipsis: Optional[str] = Field(
        '...',
        description='<p>Ellipsis to be displayed when <code class="codespan">overflow</code> is set to <code class="codespan">truncate</code>.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the overflow lines.</li>\n</ul>\n',
    )
    rich: Optional[Rich12] = Field(
        None,
        description='<p>&quot;Rich text styles&quot; can be defined in this <code class="codespan">rich</code> property. For example:</p>\n<pre><code class="lang-ts">label: {\n    // Styles defined in &#39;rich&#39; can be applied to some fragments\n    // of text by adding some markers to those fragment, like\n    // `{styleName|text content text content}`.\n    // `&#39;\\n&#39;` is the newline character.\n    formatter: [\n        &#39;{a|Style &quot;a&quot; is applied to this snippet}&#39;\n        &#39;{b|Style &quot;b&quot; is applied to this snippet}This snippet use default style{x|use style &quot;x&quot;}&#39;\n    ].join(&#39;\\n&#39;),\n\n    rich: {\n        a: {\n            color: &#39;red&#39;,\n            lineHeight: 10\n        },\n        b: {\n            backgroundColor: {\n                image: &#39;xxx/xxx.jpg&#39;\n            },\n            height: 40\n        },\n        x: {\n            fontSize: 18,\n            fontFamily: &#39;Microsoft YaHei&#39;,\n            borderColor: &#39;#449933&#39;,\n            borderRadius: 4\n        },\n        ...\n    }\n}\n</code></pre>\n<p>For more details, see <a href="tutorial.html#Rich%20Text" target="_blank">Rich Text</a> please.</p>\n',
    )


class LineStyle19(LineStyle6):
    pass


class SplitLine2(BaseModel):
    """
    <p>Split line of axis in <a href="#grid">grid</a> area.</p>

    """

    show: Optional[bool] = Field(
        True,
        description='\n\n<p>Set this to <code class="codespan">false</code> to prevent the splitLine from showing.\n<code class="codespan">value</code> type axes are shown by default, while <code class="codespan">category</code> type axes are hidden.</p>\n',
    )
    interval: Optional[Union[float, Any]] = Field(
        'auto',
        description='\n\n\n\n<p>Interval of Axis splitLine, which is available in category axis.  is set to be the same as <a href="#radiusAxis.axisLabel.interval">axisLabel.interval</a> by default.</p>\n<p>It uses a strategy that labels do not overlap by default.</p>\n<p>You may set it to be 0 to display all labels compulsively.</p>\n<p>If it is set to be 1, it means that labels are shown once after one label. And if it is set to be 2, it means labels are shown once after two labels, and so on.</p>\n<p>On the other hand, you can control by callback function, whose format is shown below:</p>\n<pre><code class="lang-ts">(index:number, value: string) =&gt; boolean\n</code></pre>\n<p>The first parameter is index of category, and the second parameter is the name of category. The return values decides whether to display label.</p>\n',
    )
    lineStyle: Optional[LineStyle19] = Field(None, description='')


class LineStyle20(LineStyle7):
    pass


class MinorSplitLine2(BaseModel):
    """
        <blockquote>
    <p>Since <code class="codespan">v4.6.0</code></p>
    </blockquote>
    <p>Minor split lines of axis in the <a href="#grid">grid</a> area。It will align to the <a href="#radiusAxis.minorTick">minorTick</a></p>

    """

    show: Optional[bool] = Field(
        False, description='\n\n<p>If show minor split lines.</p>\n'
    )
    lineStyle: Optional[LineStyle20] = Field(None, description='')


class AreaStyle2(AreaStyle):
    """
    <p>Split area style.</p>

    """

    pass


class SplitArea2(BaseModel):
    """
    <p>Split area of axis in <a href="#grid">grid</a> area, not shown by default.</p>

    """

    interval: Optional[Union[float, Any]] = Field(
        'auto',
        description='\n\n\n\n<p>Interval of Axis splitArea, which is available in category axis.  is set to be the same as <a href="#radiusAxis.axisLabel.interval">axisLabel.interval</a> by default.</p>\n<p>It uses a strategy that labels do not overlap by default.</p>\n<p>You may set it to be 0 to display all labels compulsively.</p>\n<p>If it is set to be 1, it means that labels are shown once after one label. And if it is set to be 2, it means labels are shown once after two labels, and so on.</p>\n<p>On the other hand, you can control by callback function, whose format is shown below:</p>\n<pre><code class="lang-ts">(index:number, value: string) =&gt; boolean\n</code></pre>\n<p>The first parameter is index of category, and the second parameter is the name of category. The return values decides whether to display label.</p>\n',
    )
    show: Optional[bool] = Field(
        False,
        description='\n\n<p>Set this to <code class="codespan">true</code> to show the splitArea.</p>\n',
    )
    areaStyle: Optional[AreaStyle2] = Field(
        None, description='<p>Split area style.</p>\n'
    )


class _StyleName13(_StyleName):
    pass


class Rich13(BaseModel):
    """
        <p>&quot;Rich text styles&quot; can be defined in this <code class="codespan">rich</code> property. For example:</p>
    <pre><code class="lang-ts">label: {
        // Styles defined in &#39;rich&#39; can be applied to some fragments
        // of text by adding some markers to those fragment, like
        // `{styleName|text content text content}`.
        // `&#39;\n&#39;` is the newline character.
        formatter: [
            &#39;{a|Style &quot;a&quot; is applied to this snippet}&#39;
            &#39;{b|Style &quot;b&quot; is applied to this snippet}This snippet use default style{x|use style &quot;x&quot;}&#39;
        ].join(&#39;\n&#39;),

        rich: {
            a: {
                color: &#39;red&#39;,
                lineHeight: 10
            },
            b: {
                backgroundColor: {
                    image: &#39;xxx/xxx.jpg&#39;
                },
                height: 40
            },
            x: {
                fontSize: 18,
                fontFamily: &#39;Microsoft YaHei&#39;,
                borderColor: &#39;#449933&#39;,
                borderRadius: 4
            },
            ...
        }
    }
    </code></pre>
    <p>For more details, see <a href="tutorial.html#Rich%20Text" target="_blank">Rich Text</a> please.</p>

    """

    _style_name_: Optional[_StyleName13] = Field(
        None, alias='<style_name>', description=''
    )


class TextStyle6(BaseModel):
    """
    <p>Text style of the category.</p>

    """

    color: Optional[Any] = Field('#fff', description='\n\n<p> text color.</p>\n')
    fontStyle: Optional[str] = Field(
        'normal',
        description='\n\n<p> font style.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;italic&#39;</code></li>\n<li><code class="codespan">&#39;oblique&#39;</code></li>\n</ul>\n',
    )
    fontWeight: Optional[Union[str, float]] = Field(
        'normal',
        description='\n\n<p> font thick weight.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;bold&#39;</code></li>\n<li><code class="codespan">&#39;bolder&#39;</code></li>\n<li><code class="codespan">&#39;lighter&#39;</code></li>\n<li>100 | 200 | 300 | 400...</li>\n</ul>\n',
    )
    fontFamily: Optional[str] = Field(
        'sans-serif',
        description='\n\n<p> font family.</p>\n<p>Can also be &#39;serif&#39; , &#39;monospace&#39;, ...</p>\n',
    )
    fontSize: Optional[float] = Field(12, description='\n\n<p> font size.</p>\n')
    align: Optional[str] = Field(
        None,
        description='\n\n<p>Horizontal alignment of text, automatic by default.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;left&#39;</code></li>\n<li><code class="codespan">&#39;center&#39;</code></li>\n<li><code class="codespan">&#39;right&#39;</code></li>\n</ul>\n<p>If <code class="codespan">align</code> is not set in <code class="codespan">rich</code>, <code class="codespan">align</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    align: right,\n    rich: {\n        a: {\n            // `align` is not set, then it will be right\n        }\n    }\n}\n</code></pre>\n',
    )
    verticalAlign: Optional[str] = Field(
        None,
        description='\n\n<p>Vertical alignment of text, automatic by default.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;top&#39;</code></li>\n<li><code class="codespan">&#39;middle&#39;</code></li>\n<li><code class="codespan">&#39;bottom&#39;</code></li>\n</ul>\n<p>If <code class="codespan">verticalAlign</code> is not set in <code class="codespan">rich</code>, <code class="codespan">verticalAlign</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    verticalAlign: bottom,\n    rich: {\n        a: {\n            // `verticalAlign` is not set, then it will be bottom\n        }\n    }\n}\n</code></pre>\n',
    )
    lineHeight: Optional[float] = Field(
        None,
        description='\n\n<p>Line height of the text fragment.</p>\n<p>If <code class="codespan">lineHeight</code> is not set in <code class="codespan">rich</code>, <code class="codespan">lineHeight</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    lineHeight: 56,\n    rich: {\n        a: {\n            // `lineHeight` is not set, then it will be 56\n        }\n    }\n}\n</code></pre>\n',
    )
    backgroundColor: Optional[Union[str, Any]] = Field(
        'transparent',
        description='\n\n<p>Background color of the text fragment.</p>\n<p>Can be color string, like <code class="codespan">&#39;#123234&#39;</code>, <code class="codespan">&#39;red&#39;</code>, <code class="codespan">&#39;rgba(0,23,11,0.3)&#39;</code>.</p>\n<p>Or image can be used, for example:</p>\n<pre><code class="lang-ts">backgroundColor: {\n    image: &#39;xxx/xxx.png&#39;\n    // It can be URL of a image,\n    // or dataURI,\n    // or HTMLImageElement,\n    // or HTMLCanvasElement.\n}\n</code></pre>\n<p><code class="codespan">width</code> or <code class="codespan">height</code> can be specified when using background image, or\nauto adapted by default.</p>\n',
    )
    borderColor: Optional[Any] = Field(
        None, description='\n\n<p>Border color of the text fragment.</p>\n'
    )
    borderWidth: Optional[float] = Field(
        0, description='\n\n<p>Border width of the text fragment.</p>\n'
    )
    borderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>the text fragment border type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">borderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\nborderType: [5, 10],\n\nborderDashOffset: 5\n}\n</code></pre>\n',
    )
    borderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">borderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    borderRadius: Optional[float] = Field(
        0, description='\n\n<p>Border radius of the text fragment.</p>\n'
    )
    padding: Optional[Union[float, Any]] = Field(
        0,
        description='\n\n<p>Padding of the text fragment, for example:</p>\n<ul>\n<li><code class="codespan">padding: [3, 4, 5, 6]</code>: represents padding of <code class="codespan">[top, right, bottom, left]</code>.</li>\n<li><code class="codespan">padding: 4</code>: represents <code class="codespan">padding: [4, 4, 4, 4]</code>.</li>\n<li><code class="codespan">padding: [3, 4]</code>: represents <code class="codespan">padding: [3, 4, 3, 4]</code>.</li>\n</ul>\n<p>Notice, <code class="codespan">width</code> and <code class="codespan">height</code> specifies the width and height of the content, without <code class="codespan">padding</code>.</p>\n',
    )
    shadowColor: Optional[Any] = Field(
        'transparent', description='\n\n<p>Shadow color of the text block.</p>\n'
    )
    shadowBlur: Optional[float] = Field(
        0, description='\n\n<p>Show blur of the text block.</p>\n'
    )
    shadowOffsetX: Optional[float] = Field(
        0, description='\n\n<p>Shadow X offset of the text block.</p>\n'
    )
    shadowOffsetY: Optional[float] = Field(
        0, description='\n\n<p>Shadow Y offset of the text block.</p>\n'
    )
    width: Optional[float] = Field(
        None, description='\n\n<p>Width of text block.</p>\n'
    )
    height: Optional[float] = Field(
        None, description='\n\n<p>Height of text block.</p>\n'
    )
    textBorderColor: Optional[Any] = Field(
        None, description='\n\n<p>Stroke color of the text.</p>\n'
    )
    textBorderWidth: Optional[float] = Field(
        None, description='\n\n<p>Stroke line width of the text.</p>\n'
    )
    textBorderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>Stroke line type of the text.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">textBorderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\ntextBorderType: [5, 10],\n\ntextBorderDashOffset: 5\n}\n</code></pre>\n',
    )
    textBorderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">textBorderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    textShadowColor: Optional[Any] = Field(
        'transparent', description='\n\n<p>Shadow color of the text itself.</p>\n'
    )
    textShadowBlur: Optional[float] = Field(
        0, description='\n\n<p>Shadow blue of the text itself.</p>\n'
    )
    textShadowOffsetX: Optional[float] = Field(
        0, description='\n\n<p>Shadow X offset of the text itself.</p>\n'
    )
    textShadowOffsetY: Optional[float] = Field(
        0, description='\n\n<p>Shadow Y offset of the text itself.</p>\n'
    )
    overflow: Optional[str] = Field(
        'none',
        description='\n\n<p>Determine how to display the text when it&#39;s overflow. Available when <code class="codespan">width</code> is set.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the text and trailing with <code class="codespan">ellipsis</code>.</li>\n<li><code class="codespan">&#39;break&#39;</code> Break by word</li>\n<li><code class="codespan">&#39;breakAll&#39;</code> Break by character.</li>\n</ul>\n',
    )
    ellipsis: Optional[str] = Field(
        '...',
        description='<p>Ellipsis to be displayed when <code class="codespan">overflow</code> is set to <code class="codespan">truncate</code>.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the overflow lines.</li>\n</ul>\n',
    )
    rich: Optional[Rich13] = Field(
        None,
        description='<p>&quot;Rich text styles&quot; can be defined in this <code class="codespan">rich</code> property. For example:</p>\n<pre><code class="lang-ts">label: {\n    // Styles defined in &#39;rich&#39; can be applied to some fragments\n    // of text by adding some markers to those fragment, like\n    // `{styleName|text content text content}`.\n    // `&#39;\\n&#39;` is the newline character.\n    formatter: [\n        &#39;{a|Style &quot;a&quot; is applied to this snippet}&#39;\n        &#39;{b|Style &quot;b&quot; is applied to this snippet}This snippet use default style{x|use style &quot;x&quot;}&#39;\n    ].join(&#39;\\n&#39;),\n\n    rich: {\n        a: {\n            color: &#39;red&#39;,\n            lineHeight: 10\n        },\n        b: {\n            backgroundColor: {\n                image: &#39;xxx/xxx.jpg&#39;\n            },\n            height: 40\n        },\n        x: {\n            fontSize: 18,\n            fontFamily: &#39;Microsoft YaHei&#39;,\n            borderColor: &#39;#449933&#39;,\n            borderRadius: 4\n        },\n        ...\n    }\n}\n</code></pre>\n<p>For more details, see <a href="tutorial.html#Rich%20Text" target="_blank">Rich Text</a> please.</p>\n',
    )


class Datum3(BaseModel):
    value: Optional[str] = Field(None, description='<p>Name of a category.</p>\n')
    textStyle: Optional[TextStyle6] = Field(
        None, description='<p>Text style of the category.</p>\n'
    )


class Label4(Label):
    """
    <p>label of axisPointer</p>

    """

    pass


class LineStyle21(LineStyle2):
    """
    <p>It is valid when <a href="#tooltip.axisPointer.type">axisPointer.type</a> is <code class="codespan">&#39;line&#39;</code>.</p>

    """

    pass


class ShadowStyle4(ShadowStyle):
    """
    <p>It is valid when <a href="#tooltip.axisPointer.type">axisPointer.type</a> is <code class="codespan">&#39;shadow&#39;</code>.</p>

    """

    pass


class Handle2(Handle):
    """
    <p>A button used to drag axisPointer. This feature is applicable in touch device. See <a href="http://localhost/echarts-website/examples/en/editor.html?c=line-tooltip-touch&amp;edit=1&amp;reset=1" target="_blank">example</a>.</p>

    """

    pass


class AxisPointer4(BaseModel):
    """
    <p>axisPointer settings on the axis.</p>

    """

    show: Optional[bool] = Field(
        False,
        description='\n\n<p>axisPointer will not be displayed by default. But if <a href="#tooltip.trigger">tooltip.trigger</a> is set as <code class="codespan">&#39;axis&#39;</code> or <a href="#tooltip.axisPointer.type">tooltip.axisPointer.type</a> is set as  <code class="codespan">&#39;cross&#39;</code>, axisPointer will be displayed automatically. Each coordinate system will automatically chose the axes whose will display its axisPointer. <a href="#tooltip.axisPointer.axis">tooltip.axisPointer.axis</a> can be used to change the choice.</p>\n',
    )
    type: Optional[str] = Field(
        'line',
        description='\n\n<p>Indicator type.</p>\n<p>Options:</p>\n<ul>\n<li><p><code class="codespan">&#39;line&#39;</code> line indicator.</p>\n</li>\n<li><p><code class="codespan">&#39;shadow&#39;</code> shadow crosshair indicator.</p>\n</li>\n<li><p><code class="codespan">&#39;none&#39;</code> no indicator displayed.</p>\n</li>\n</ul>\n',
    )
    snap: Optional[bool] = Field(
        None,
        description='<p>Whether snap to point automatically. The default value is auto determined.</p>\n<p>This feature usually makes sense in value axis and time axis, where tiny points can be seeked automatically.</p>\n',
    )
    z: Optional[float] = Field(
        None,
        description='<p>z value, which controls order of drawing graphical components. Components with smaller <code class="codespan">z</code> values may be overwritten by those with larger <code class="codespan">z</code> values.</p>\n',
    )
    label: Optional[Label4] = Field(None, description='<p>label of axisPointer</p>\n')
    lineStyle: Optional[LineStyle21] = Field(
        None,
        description='<p>It is valid when <a href="#tooltip.axisPointer.type">axisPointer.type</a> is <code class="codespan">&#39;line&#39;</code>.</p>\n',
    )
    shadowStyle: Optional[ShadowStyle4] = Field(
        None,
        description='<p>It is valid when <a href="#tooltip.axisPointer.type">axisPointer.type</a> is <code class="codespan">&#39;shadow&#39;</code>.</p>\n',
    )
    triggerTooltip: Optional[bool] = Field(
        True, description='\n\n<p>Whether to trigger tooltip.</p>\n'
    )
    value: Optional[float] = Field(
        None,
        description='<p>current value. When using <a href="xAxisPointer.handle" target="_blank">axisPointer.handle</a>, <code class="codespan">value</code> can be set to define the initial position of axisPointer.</p>\n',
    )
    status: Optional[bool] = Field(
        None,
        description='\n\n<p>Current status, can be <code class="codespan">&#39;show&#39;</code> 和 <code class="codespan">&#39;hide&#39;</code>.</p>\n',
    )
    handle: Optional[Handle2] = Field(
        None,
        description='<p>A button used to drag axisPointer. This feature is applicable in touch device. See <a href="http://localhost/echarts-website/examples/en/editor.html?c=line-tooltip-touch&amp;edit=1&amp;reset=1" target="_blank">example</a>.</p>\n',
    )


class RadiusAxis(BaseModel):
    """
    <p>Radial axis of polar coordinate.</p>

    """

    id: Optional[str] = Field(
        None,
        description='<p>Component ID, not specified by default. If specified, it can be used to refer the component in option or API.</p>\n',
    )
    polarIndex: Optional[float] = Field(
        0,
        description='<p>Index of radial axis in polor coordinate. It&#39;s the first axis by default.</p>\n',
    )
    type: Optional[str] = Field(
        'value',
        description='<p>Type of axis.</p>\n<p>Option:</p>\n<ul>\n<li><p><code class="codespan">&#39;value&#39;</code>\n  Numerical axis, suitable for continuous data.</p>\n</li>\n<li><p><code class="codespan">&#39;category&#39;</code>\n  Category axis, suitable for discrete category data. Category data can be auto retrieved from <a href="#series.data">series.data</a> or <a href="#dataset.source">dataset.source</a>, or can be specified via <a href="#radiusAxis.data">radiusAxis.data</a>.</p>\n</li>\n<li><p><code class="codespan">&#39;time&#39;</code>\n  Time axis, suitable for continuous time series data. As compared to value axis, it has a better formatting for time and a different tick calculation method. For example, it decides to use month, week, day or hour for tick based on the range of span.</p>\n</li>\n<li><p><code class="codespan">&#39;log&#39;</code>\n  Log axis, suitable for log data.</p>\n</li>\n</ul>\n',
    )
    name: Optional[str] = Field(None, description='\n\n<p>Name of axis.</p>\n')
    nameLocation: Optional[str] = Field(
        'end',
        description='\n\n<p>Location of axis name.</p>\n<p><strong>Options: </strong></p>\n<ul>\n<li><code class="codespan">&#39;start&#39;</code></li>\n<li><code class="codespan">&#39;middle&#39;</code> or <code class="codespan">&#39;center&#39;</code></li>\n<li><code class="codespan">&#39;end&#39;</code></li>\n</ul>\n',
    )
    nameTextStyle: Optional[NameTextStyle2] = Field(
        None, description='<p>Text style of axis name.</p>\n'
    )
    nameGap: Optional[float] = Field(
        15, description='\n\n<p>Gap between axis name and axis line.</p>\n'
    )
    nameRotate: Optional[float] = Field(
        None, description='\n\n<p>Rotation of axis name.</p>\n'
    )
    inverse: Optional[bool] = Field(
        False,
        description='\n\n<p>Set this to <code class="codespan">true</code> to invert the axis.\nThis is a new option available from Echarts 3 and newer.</p>\n',
    )
    boundaryGap: Optional[Union[bool, Any]] = Field(
        None,
        description='\n\n<p>The boundary gap on both sides of a coordinate axis. The setting and behavior of category axes and non-category axes are different.</p>\n<p>The <code class="codespan">boundaryGap</code> of category axis can be set to either <code class="codespan">true</code> or <code class="codespan">false</code>. Default value is set to be <code class="codespan">true</code>, in which case <a href="#radiusAxis.axisTick">axisTick</a> is served only as a separation line, and labels and data appear only in the center part of two <a href="#radiusAxis.axisTick">axis ticks</a>, which is called <em>band</em>.</p>\n<p>For non-category axis, including time, numerical value, and log axes, <code class="codespan">boundaryGap</code> is an array of two values, representing the spanning range between minimum and maximum value. The value can be set in numeric value or relative percentage, which becomes invalid after setting <a href="#radiusAxis.min">min</a> and <a href="#radiusAxis.max">max</a>.\n<strong>Example: </strong></p>\n<pre><code class="lang-ts">boundaryGap: [&#39;20%&#39;, &#39;20%&#39;]\n</code></pre>\n',
    )
    min: Optional[Union[float, str, Any]] = Field(
        None,
        description='\n\n<p>The minimun value of axis.</p>\n<p>It can be set to a special value <code class="codespan">&#39;dataMin&#39;</code> so that the minimum value on this axis is set to be the minimum label.</p>\n<p>It will be automatically computed to make sure axis tick is equally distributed when not set.</p>\n<p>In category axis, it can also be set as the ordinal number. For example, if a catergory axis has <code class="codespan">data: [&#39;categoryA&#39;, &#39;categoryB&#39;, &#39;categoryC&#39;]</code>, and the ordinal <code class="codespan">2</code> represents <code class="codespan">&#39;categoryC&#39;</code>. Moreover, it can be set as negative number, like <code class="codespan">-3</code>.</p>\n<p>If <code class="codespan">min</code> is specified as a function, it should return a min value, like:</p>\n<pre><code class="lang-ts">min: function (value) {\n    return value.min - 20;\n}\n</code></pre>\n<p><code class="codespan">value</code> is an object, containing the <code class="codespan">min</code> value and <code class="codespan">max</code> value of the data. This function should return the min value of axis, or return <code class="codespan">null</code>/<code class="codespan">undefined</code> to make echarts use the auto calculated min value (<code class="codespan">null</code>/<code class="codespan">undefined</code> return is only supported since <code class="codespan">v4.8.0</code>).</p>\n',
    )
    max: Optional[Union[float, str, Any]] = Field(
        None,
        description='\n\n<p>The maximum value of axis.</p>\n<p>It can be set to a special value <code class="codespan">&#39;dataMax&#39;</code> so that the minimum value on this axis is set to be the maximum label.</p>\n<p>It will be automatically computed to make sure axis tick is equally distributed when not set.</p>\n<p>In category axis, it can also be set as the ordinal number. For example, if a catergory axis has <code class="codespan">data: [&#39;categoryA&#39;, &#39;categoryB&#39;, &#39;categoryC&#39;]</code>, and the ordinal <code class="codespan">2</code> represents <code class="codespan">&#39;categoryC&#39;</code>. Moreover, it can be set as negative number, like <code class="codespan">-3</code>.</p>\n<p>If <code class="codespan">max</code> is specified as a function, it should return a max value, like:</p>\n<pre><code class="lang-ts">max: function (value) {\n    return value.max - 20;\n}\n</code></pre>\n<p><code class="codespan">value</code> is an object, containing the <code class="codespan">min</code> value and <code class="codespan">max</code> value of the data. This function should return the max value of axis, or return <code class="codespan">null</code>/<code class="codespan">undefined</code> to make echarts use the auto calculated max value (<code class="codespan">null</code>/<code class="codespan">undefined</code> return is only supported since <code class="codespan">v4.8.0</code>).</p>\n',
    )
    scale: Optional[bool] = Field(
        False,
        description='\n\n<p>It is available only in numerical axis, i.e., <a href="#radiusAxis.type">type</a>: &#39;value&#39;.</p>\n<p>It specifies whether not to contain zero position of axis compulsively. When it is set to be <code class="codespan">true</code>, the axis may not contain zero position, which is useful in the scatter chart for both value axes.</p>\n<p>This configuration item is unavailable when the <a href="#radiusAxis.min">min</a> and <a href="#radiusAxis.max">max</a> are set.</p>\n',
    )
    splitNumber: Optional[float] = Field(
        5,
        description='\n\n<p>Number of segments that the axis is split into. Note that this number serves only as a recommendation, and the true segments may be adjusted based on readability.</p>\n<p>This is unavailable for category axis.</p>\n',
    )
    minInterval: Optional[float] = Field(
        0,
        description='\n\n<p>Minimum gap between split lines.</p>\n<p>For example, it can be set to be <code class="codespan">1</code> to make sure axis label is show as integer.</p>\n<pre><code class="lang-ts">{\n    minInterval: 1\n}\n</code></pre>\n<p>It is available only for axis of <a href="#radiusAxis.type">type</a> &#39;value&#39; or &#39;time&#39;.</p>\n',
    )
    maxInterval: Optional[float] = Field(
        None,
        description='\n\n<p>Maximum gap between split lines.</p>\n<p>For example, in time axis (<a href="#radiusAxis.type">type</a> is &#39;time&#39;), it can be set to be <code class="codespan">3600 * 24 * 1000</code> to make sure that the gap between axis labels is less than or equal to one day.</p>\n<pre><code class="lang-ts">{\n    maxInterval: 3600 * 1000 * 24\n}\n</code></pre>\n<p>It is available only for axis of <a href="#radiusAxis.type">type</a> &#39;value&#39; or &#39;time&#39;.</p>\n',
    )
    interval: Optional[float] = Field(
        None,
        description='\n\n<p>Compulsively set segmentation interval for axis.</p>\n<p>As <a href="#radiusAxis.splitNumber">splitNumber</a> is a recommendation value, the calculated tick may not be the same as expected. In this case, interval should be used along with <a href="#radiusAxis.min">min</a> and <a href="#radiusAxis.max">max</a> to compulsively set tickings. But in most cases, we do not suggest using this, our automatic calculation is enough for most situations.</p>\n<p>This is unavailable for category axis. Timestamp should be passed for <a href="#radiusAxis.type">type</a>: &#39;time&#39; axis. Logged value should be passed for <a href="#radiusAxis.type">type</a>: &#39;log&#39; axis.</p>\n',
    )
    logBase: Optional[float] = Field(
        10,
        description='\n\n<p>Base of logarithm, which is valid only for numeric axes with <a href="#radiusAxis.type">type</a>: &#39;log&#39;.</p>\n',
    )
    silent: Optional[bool] = Field(
        False,
        description='<p>Set this to <code class="codespan">true</code>, to prevent interaction with the axis.</p>\n',
    )
    triggerEvent: Optional[bool] = Field(
        False,
        description='<p>Set this to <code class="codespan">true</code> to enable triggering events.</p>\n<p>Parameters of the event include:</p>\n<pre><code class="lang-ts">{\n    // Component type: xAxis, yAxis, radiusAxis, angleAxis\n    // Each of which has an attribute for index, e.g., xAxisIndex for xAxis\n    componentType: string,\n    // Value on axis before being formatted.\n    // Click on value label to trigger event.\n    value: &#39;&#39;,\n    // Name of axis.\n    // Click on laben name to trigger event.\n    name: &#39;&#39;\n}\n</code></pre>\n',
    )
    axisLine: Optional[AxisLine2] = Field(
        None, description='<p>Settings related to axis line.</p>\n'
    )
    axisTick: Optional[AxisTick2] = Field(
        None, description='<p>Settings related to axis tick.</p>\n'
    )
    minorTick: Optional[MinorTick2] = Field(
        None,
        description='<blockquote>\n<p>Since <code class="codespan">v4.6.0</code></p>\n</blockquote>\n<p>Settings related minor ticks.</p>\n<p>Note: <code class="codespan">minorTick</code> is not available in the <code class="codespan">category</code> type axis.</p>\n<p>Examples:</p>\n<p>1) Using minor ticks in function plotting.</p>\n<iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=line-function&edit=1&reset=1" width="600" height="350"></iframe>\n\n\n<p>2) Using minor ticks in log axis.</p>\n<iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=line-log&edit=1&reset=1" width="600" height="350"></iframe>\n\n',
    )
    axisLabel: Optional[AxisLabel2] = Field(
        None, description='<p>Settings related to axis label.</p>\n'
    )
    splitLine: Optional[SplitLine2] = Field(
        None,
        description='<p>Split line of axis in <a href="#grid">grid</a> area.</p>\n',
    )
    minorSplitLine: Optional[MinorSplitLine2] = Field(
        None,
        description='<blockquote>\n<p>Since <code class="codespan">v4.6.0</code></p>\n</blockquote>\n<p>Minor split lines of axis in the <a href="#grid">grid</a> area。It will align to the <a href="#radiusAxis.minorTick">minorTick</a></p>\n',
    )
    splitArea: Optional[SplitArea2] = Field(
        None,
        description='<p>Split area of axis in <a href="#grid">grid</a> area, not shown by default.</p>\n',
    )
    data: Optional[List[Datum3]] = Field(
        None,
        description='<p>Category data, available in <a href="#radiusAxis.type">type</a>: &#39;category&#39; axis.</p>\n<p>If <a href="#radiusAxis.type">type</a> is not specified, but <code class="codespan">axis.data</code> is specified, the <a href="#radiusAxis.type">type</a> is auto set as <code class="codespan">&#39;category&#39;</code>.</p>\n<p>If <a href="#radiusAxis.type">type</a> is specified as <code class="codespan">&#39;category&#39;</code>, but <code class="codespan">axis.data</code> is not specified, <code class="codespan">axis.data</code> will be auto collected from <a href="#series.data">series.data</a>. It brings convenience, but we should notice that <code class="codespan">axis.data</code> provides then value range of the <code class="codespan">&#39;category&#39;</code> axis. If  it is auto collected from <a href="#series.data">series.data</a>, Only the values appearing in <a href="#series.data">series.data</a> can be collected. For example, if <a href="#series.data">series.data</a> is empty, nothing will be collected.</p>\n<p>Example:</p>\n<pre><code class="lang-ts">// Name list of all categories\ndata: [&#39;Monday&#39;, &#39;Tuesday&#39;, &#39;Wednesday&#39;, &#39;Thursday&#39;, &#39;Friday&#39;, &#39;Saturday&#39;, &#39;Sunday&#39;]\n// Each item could also be a specific configuration item.\n// In this case, `value` is used as the category name.\ndata: [{\n    value: &#39;Monday&#39;,\n    // Highlight Monday\n    textStyle: {\n        fontSize: 20,\n        color: &#39;red&#39;\n    }\n}, &#39;Tuesday&#39;, &#39;Wednesday&#39;, &#39;Thursday&#39;, &#39;Friday&#39;, &#39;Saturday&#39;, &#39;Sunday&#39;]\n</code></pre>\n',
    )
    axisPointer: Optional[AxisPointer4] = Field(
        None, description='<p>axisPointer settings on the axis.</p>\n'
    )
    zlevel: Optional[float] = Field(
        0,
        description='<p><code class="codespan">zlevel</code> value of all graphical elements in Radial axis.</p>\n<p><code class="codespan">zlevel</code> is used to make layers with Canvas. Graphical elements with different <code class="codespan">zlevel</code> values will be placed in different Canvases, which is a common optimization technique. We can put those frequently changed elements (like those with animations) to a separate <code class="codespan">zlevel</code>. Notice that too many Canvases will increase memory cost, and should be used carefully on mobile phones to avoid crash.</p>\n<p>Canvases with bigger <code class="codespan">zlevel</code> will be placed on Canvases with smaller <code class="codespan">zlevel</code>.</p>\n',
    )
    z: Optional[float] = Field(
        0,
        description='<p><code class="codespan">z</code> value of all graphical elements in Radial axis, which controls order of drawing graphical components. Components with smaller <code class="codespan">z</code> values may be overwritten by those with larger <code class="codespan">z</code> values.</p>\n<p><code class="codespan">z</code> has a lower priority to <code class="codespan">zlevel</code>, and will not create new Canvas.</p>\n',
    )


class LineStyle22(LineStyle3):
    pass


class AxisLine3(BaseModel):
    """
    <p>Settings related to axis line.</p>

    """

    show: Optional[bool] = Field(
        True,
        description='\n\n<p>Set this to <code class="codespan">false</code> to prevent the axis line from showing.</p>\n',
    )
    symbol: Optional[Union[str, Any]] = Field(
        'none',
        description='\n\n<p>Symbol of the two ends of the axis. It could be a string, representing the same symbol for two ends; or an array with two string elements, representing the two ends separately. It&#39;s set to be <code class="codespan">&#39;none&#39;</code> by default, meaning no arrow for either end. If it is set to be <code class="codespan">&#39;arrow&#39;</code>, there shall be two arrows. If there should only one arrow at the end, it should set to be <code class="codespan">[&#39;none&#39;, &#39;arrow&#39;]</code>.</p>\n',
    )
    symbolSize: Optional[Any] = Field(
        '[10, 15]',
        description='\n\n<p>Size of the arrows at two ends. The first is the width perpendicular to the axis, the next is the width parallel to the axis.</p>\n',
    )
    symbolOffset: Optional[Union[Any, float]] = Field(
        '[0, 0]',
        description='\n\n<p>Arrow offset of axis. If is array, the first number is the offset of the arrow at the beginning, and the second number is the offset of the arrow at the end. If is number, it means the arrows have the same offset.</p>\n',
    )
    lineStyle: Optional[LineStyle22] = Field(None, description='')


class LineStyle23(BaseModel):
    """
    <p>Line style of axis ticks.</p>

    """

    color: Optional[Any] = Field(
        None,
        description='<p>Color of axis label is set to be <a href="#angleAxis.axisLine.lineStyle.color">axisLine.lineStyle.color</a> by default.</p>\n',
    )
    width: Optional[float] = Field(1, description='\n\n<p>axisTick line width.</p>\n')
    type: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>line type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">dashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\ntype: [5, 10],\n\ndashOffset: 5\n}\n</code></pre>\n',
    )
    dashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">type</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    cap: Optional[str] = Field(
        'butt',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To specify how to draw the end points of the line.\nPossible values are:</p>\n<ul>\n<li><code class="codespan">&#39;butt&#39;</code>: The ends of lines are squared off at the endpoints.</li>\n<li><code class="codespan">&#39;round&#39;</code>: The ends of lines are rounded.</li>\n<li><code class="codespan">&#39;square&#39;</code>: The ends of lines are squared off by adding a box with an equal width and half the height of the line&#39;s thickness.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;butt&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineCap" target="_blank">lineCap</a> for more details.</p>\n',
    )
    join: Optional[str] = Field(
        'bevel',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To determine the shape used to join two line segments where they meet.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;bevel&#39;</code>: Fills an additional triangular area between the common endpoint of connected segments, and the separate outside rectangular corners of each segment.</li>\n<li><code class="codespan">&#39;round&#39;</code>: Rounds off the corners of a shape by filling an additional sector of disc centered at the common endpoint of connected segments. The radius for these rounded corners is equal to the line width.</li>\n<li><code class="codespan">&#39;miter&#39;</code>: Connected segments are joined by extending their outside edges to connect at a single point, with the effect of filling an additional lozenge-shaped area. This setting is affected by the \n<code class="codespan">miterLimit</code>\nproperty.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;bevel&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineJoin" target="_blank">lineJoin</a> for more details.</p>\n',
    )
    miterLimit: Optional[float] = Field(
        10,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the miter limit ratio. Only works when \n<code class="codespan">join</code>\n is set as <code class="codespan">miter</code>.</p>\n<p>Default value is <code class="codespan">10</code>. Negative、<code class="codespan">0</code>、<code class="codespan">Infinity</code> and <code class="codespan">NaN</code> values are ignored.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/miterLimit" target="_blank">miterLimit</a> for more details.</p>\n',
    )
    shadowBlur: Optional[float] = Field(
        None,
        description='\n\n<p>Size of shadow blur. This attribute should be used along with <code class="codespan">shadowColor</code>,<code class="codespan">shadowOffsetX</code>, <code class="codespan">shadowOffsetY</code> to set shadow to component.</p>\n<p>For example:</p>\n<pre><code class="lang-ts">{\n    shadowColor: &#39;rgba(0, 0, 0, 0.5)&#39;,\n    shadowBlur: 10\n}\n</code></pre>\n',
    )
    shadowColor: Optional[Any] = Field(
        None,
        description='\n\n<p>Shadow color. Support same format as <code class="codespan">color</code>.</p>\n',
    )
    shadowOffsetX: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the horizontal direction of shadow.</p>\n',
    )
    shadowOffsetY: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the vertical direction of shadow.</p>\n',
    )
    opacity: Optional[float] = Field(
        None,
        description='\n\n<p>Opacity of the component. Supports value from 0 to 1, and the component will not be drawn when set to 0.</p>\n\n',
    )


class AxisTick3(BaseModel):
    """
    <p>Settings related to axis tick.</p>

    """

    show: Optional[bool] = Field(
        True,
        description='\n\n<p>Set this to <code class="codespan">false</code> to prevent the axis tick from showing.</p>\n',
    )
    alignWithLabel: Optional[bool] = Field(
        False,
        description='\n\n<p>Align axis tick with label, which is available only when <code class="codespan">boundaryGap</code> is set to be <code class="codespan">true</code> in category axis. See the following picture:</p>\n<p><img width="600" height="auto" src="documents/asset/img/axis-align-with-label.png"></p>\n',
    )
    interval: Optional[Union[float, Any]] = Field(
        'auto',
        description='\n\n\n\n<p>Interval of axisTick, which is available in category axis.  is set to be the same as <a href="#angleAxis.axisLabel.interval">axisLabel.interval</a> by default.</p>\n<p>It uses a strategy that labels do not overlap by default.</p>\n<p>You may set it to be 0 to display all labels compulsively.</p>\n<p>If it is set to be 1, it means that labels are shown once after one label. And if it is set to be 2, it means labels are shown once after two labels, and so on.</p>\n<p>On the other hand, you can control by callback function, whose format is shown below:</p>\n<pre><code class="lang-ts">(index:number, value: string) =&gt; boolean\n</code></pre>\n<p>The first parameter is index of category, and the second parameter is the name of category. The return values decides whether to display label.</p>\n',
    )
    inside: Optional[bool] = Field(
        False,
        description='\n\n<p>Set this to <code class="codespan">true</code> so the axis labels face the <code class="codespan">inside</code> direction.</p>\n',
    )
    length: Optional[float] = Field(
        5, description='\n\n<p>The length of the axis tick.</p>\n'
    )
    lineStyle: Optional[LineStyle23] = Field(
        None, description='<p>Line style of axis ticks.</p>\n'
    )


class LineStyle24(BaseModel):
    color: Optional[Any] = Field(
        None,
        description='\n\n<p>Style configuration of minor ticks lines <a href="#angleAxis.axisLine.lineStyle.color">axisLine.lineStyle.color</a>。</p>\n',
    )
    width: Optional[float] = Field(1, description='\n\n<p>minorTick line width.</p>\n')
    type: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>line type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">dashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\ntype: [5, 10],\n\ndashOffset: 5\n}\n</code></pre>\n',
    )
    dashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">type</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    cap: Optional[str] = Field(
        'butt',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To specify how to draw the end points of the line.\nPossible values are:</p>\n<ul>\n<li><code class="codespan">&#39;butt&#39;</code>: The ends of lines are squared off at the endpoints.</li>\n<li><code class="codespan">&#39;round&#39;</code>: The ends of lines are rounded.</li>\n<li><code class="codespan">&#39;square&#39;</code>: The ends of lines are squared off by adding a box with an equal width and half the height of the line&#39;s thickness.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;butt&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineCap" target="_blank">lineCap</a> for more details.</p>\n',
    )
    join: Optional[str] = Field(
        'bevel',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To determine the shape used to join two line segments where they meet.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;bevel&#39;</code>: Fills an additional triangular area between the common endpoint of connected segments, and the separate outside rectangular corners of each segment.</li>\n<li><code class="codespan">&#39;round&#39;</code>: Rounds off the corners of a shape by filling an additional sector of disc centered at the common endpoint of connected segments. The radius for these rounded corners is equal to the line width.</li>\n<li><code class="codespan">&#39;miter&#39;</code>: Connected segments are joined by extending their outside edges to connect at a single point, with the effect of filling an additional lozenge-shaped area. This setting is affected by the \n<code class="codespan">miterLimit</code>\nproperty.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;bevel&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineJoin" target="_blank">lineJoin</a> for more details.</p>\n',
    )
    miterLimit: Optional[float] = Field(
        10,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the miter limit ratio. Only works when \n<code class="codespan">join</code>\n is set as <code class="codespan">miter</code>.</p>\n<p>Default value is <code class="codespan">10</code>. Negative、<code class="codespan">0</code>、<code class="codespan">Infinity</code> and <code class="codespan">NaN</code> values are ignored.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/miterLimit" target="_blank">miterLimit</a> for more details.</p>\n',
    )
    shadowBlur: Optional[float] = Field(
        None,
        description='\n\n<p>Size of shadow blur. This attribute should be used along with <code class="codespan">shadowColor</code>,<code class="codespan">shadowOffsetX</code>, <code class="codespan">shadowOffsetY</code> to set shadow to component.</p>\n<p>For example:</p>\n<pre><code class="lang-ts">{\n    shadowColor: &#39;rgba(0, 0, 0, 0.5)&#39;,\n    shadowBlur: 10\n}\n</code></pre>\n',
    )
    shadowColor: Optional[Any] = Field(
        None,
        description='\n\n<p>Shadow color. Support same format as <code class="codespan">color</code>.</p>\n',
    )
    shadowOffsetX: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the horizontal direction of shadow.</p>\n',
    )
    shadowOffsetY: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the vertical direction of shadow.</p>\n',
    )
    opacity: Optional[float] = Field(
        None,
        description='\n\n<p>Opacity of the component. Supports value from 0 to 1, and the component will not be drawn when set to 0.</p>\n\n',
    )


class MinorTick3(BaseModel):
    """
        <blockquote>
    <p>Since <code class="codespan">v4.6.0</code></p>
    </blockquote>
    <p>Settings related minor ticks.</p>
    <p>Note: <code class="codespan">minorTick</code> is not available in the <code class="codespan">category</code> type axis.</p>
    <p>Examples:</p>
    <p>1) Using minor ticks in function plotting.</p>
    <iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=line-function&edit=1&reset=1" width="600" height="350"></iframe>


    <p>2) Using minor ticks in log axis.</p>
    <iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=line-log&edit=1&reset=1" width="600" height="350"></iframe>


    """

    show: Optional[bool] = Field(False, description='\n\n<p>If show minor ticks.</p>\n')
    splitNumber: Optional[float] = Field(
        5, description='\n\n<p>Number of interval splited by minor ticks.</p>\n'
    )
    length: Optional[float] = Field(
        3, description='\n\n<p>Length of minor ticks lines。</p>\n'
    )
    lineStyle: Optional[LineStyle24] = Field(None, description='')


class _StyleName14(_StyleName5):
    pass


class Rich14(BaseModel):
    """
        <p>&quot;Rich text styles&quot; can be defined in this <code class="codespan">rich</code> property. For example:</p>
    <pre><code class="lang-ts">label: {
        // Styles defined in &#39;rich&#39; can be applied to some fragments
        // of text by adding some markers to those fragment, like
        // `{styleName|text content text content}`.
        // `&#39;\n&#39;` is the newline character.
        formatter: [
            &#39;{a|Style &quot;a&quot; is applied to this snippet}&#39;
            &#39;{b|Style &quot;b&quot; is applied to this snippet}This snippet use default style{x|use style &quot;x&quot;}&#39;
        ].join(&#39;\n&#39;),

        rich: {
            a: {
                color: &#39;red&#39;,
                lineHeight: 10
            },
            b: {
                backgroundColor: {
                    image: &#39;xxx/xxx.jpg&#39;
                },
                height: 40
            },
            x: {
                fontSize: 18,
                fontFamily: &#39;Microsoft YaHei&#39;,
                borderColor: &#39;#449933&#39;,
                borderRadius: 4
            },
            ...
        }
    }
    </code></pre>
    <p>For more details, see <a href="tutorial.html#Rich%20Text" target="_blank">Rich Text</a> please.</p>

    """

    _style_name_: Optional[_StyleName14] = Field(
        None, alias='<style_name>', description=''
    )


class AxisLabel3(BaseModel):
    """
    <p>Settings related to axis label.</p>

    """

    show: Optional[bool] = Field(
        True,
        description='\n\n<p>Set this to <code class="codespan">false</code> to prevent the axis label from appearing.</p>\n',
    )
    interval: Optional[Union[float, Any]] = Field(
        'auto',
        description='\n\n\n\n<p>Interval of Axis label, which is available in category axis. </p>\n<p>It uses a strategy that labels do not overlap by default.</p>\n<p>You may set it to be 0 to display all labels compulsively.</p>\n<p>If it is set to be 1, it means that labels are shown once after one label. And if it is set to be 2, it means labels are shown once after two labels, and so on.</p>\n<p>On the other hand, you can control by callback function, whose format is shown below:</p>\n<pre><code class="lang-ts">(index:number, value: string) =&gt; boolean\n</code></pre>\n<p>The first parameter is index of category, and the second parameter is the name of category. The return values decides whether to display label.</p>\n',
    )
    inside: Optional[bool] = Field(
        False,
        description='\n\n<p>Set this to <code class="codespan">true</code> so the axis labels face the <code class="codespan">inside</code> direction.</p>\n',
    )
    margin: Optional[float] = Field(
        8,
        description='\n\n<p>The margin between the axis label and the axis line.</p>\n',
    )
    formatter: Optional[Union[str, Any]] = Field(
        None,
        description='<p>Formatter of axis label, which supports string template and callback function.</p>\n<p>Example:</p>\n<pre><code class="lang-ts">// Use string template; template variable is the default label of axis {value}\nformatter: &#39;{value} kg&#39;\n// Use callback.\nformatter: function (value, index) {\n    return value + &#39;kg&#39;;\n}\n</code></pre>\n<hr>\n<p>For axes of time <a href="#.type">type</a>: <code class="codespan">&#39;time&#39;</code>, <code class="codespan">formatter</code> supports the following forms:</p>\n<ul>\n<li><strong>String Templates</strong>: an easy and fast way to make frequently used date/time template, formed in <code class="codespan">string</code></li>\n<li><strong>Callback Functions</strong>: customized formatter to make complex format, formed in <code class="codespan">Function</code></li>\n<li><strong>Cascading Templates</strong>: to adopt different formatters for different time granularity, formed in <code class="codespan">object</code></li>\n</ul>\n<p>Next, we are going to introduce these three forms one by one.</p>\n<p><strong> String Templates </strong></p>\n<p>Using string templates is an easy way to format date/time with frequently used formats. If it can be used to make what you want, you are advised to do so. If not, you could then consider the others. Supported formats are:</p>\n<table>\n<thead>\n<tr>\n<th>Group</th>\n<th>Template</th>\n<th>Value (EN)</th>\n<th>Value (ZH)</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n<td>Year</td>\n<td>{yyyy}</td>\n<td>e.g., 2020, 2021, ...</td>\n<td>例：2020, 2021, ...</td>\n</tr>\n<tr>\n<td></td>\n<td>{yy}</td>\n<td>00-99</td>\n<td>00-99</td>\n</tr>\n<tr>\n<td>Quarter</td>\n<td>{Q}</td>\n<td>1, 2, 3, 4</td>\n<td>1, 2, 3, 4</td>\n</tr>\n<tr>\n<td>Month</td>\n<td>{MMMM}</td>\n<td>e.g., January, February, ...</td>\n<td>一月、二月、……</td>\n</tr>\n<tr>\n<td></td>\n<td>{MMM}</td>\n<td>e.g., Jan, Feb, ...</td>\n<td>1月、2月、……</td>\n</tr>\n<tr>\n<td></td>\n<td>{MM}</td>\n<td>01-12</td>\n<td>01-12</td>\n</tr>\n<tr>\n<td></td>\n<td>{M}</td>\n<td>1-12</td>\n<td>1-12</td>\n</tr>\n<tr>\n<td>Day of Month</td>\n<td>{dd}</td>\n<td>01-31</td>\n<td>01-31</td>\n</tr>\n<tr>\n<td></td>\n<td>{d}</td>\n<td>1-31</td>\n<td>1-31</td>\n</tr>\n<tr>\n<td>Day of Week</td>\n<td>{eeee}</td>\n<td>Sunday, Monday, Tuesday, Wednesday, Thursday, Friday, Saturday</td>\n<td>星期日、星期一、星期二、星期三、星期四、星期五、星期六</td>\n</tr>\n<tr>\n<td></td>\n<td>{ee}</td>\n<td>Sun, Mon, Tues, Wed, Thu, Fri, Sat</td>\n<td>日、一、二、三、四、五、六</td>\n</tr>\n<tr>\n<td></td>\n<td>{e}</td>\n<td>1-54</td>\n<td>1-54</td>\n</tr>\n<tr>\n<td>Hour</td>\n<td>{HH}</td>\n<td>00-23</td>\n<td>00-23</td>\n</tr>\n<tr>\n<td></td>\n<td>{H}</td>\n<td>0-23</td>\n<td>0-23</td>\n</tr>\n<tr>\n<td></td>\n<td>{hh}</td>\n<td>01-12</td>\n<td>01-12</td>\n</tr>\n<tr>\n<td></td>\n<td>{h}</td>\n<td>1-12</td>\n<td>1-12</td>\n</tr>\n<tr>\n<td>Minute</td>\n<td>{mm}</td>\n<td>00-59</td>\n<td>00-59</td>\n</tr>\n<tr>\n<td></td>\n<td>{m}</td>\n<td>0-59</td>\n<td>0-59</td>\n</tr>\n<tr>\n<td>Second</td>\n<td>{ss}</td>\n<td>00-59</td>\n<td>00-59</td>\n</tr>\n<tr>\n<td></td>\n<td>{s}</td>\n<td>0-59</td>\n<td>0-59</td>\n</tr>\n<tr>\n<td>Millisecond</td>\n<td>{SSS}</td>\n<td>000-999</td>\n<td>000-999</td>\n</tr>\n<tr>\n<td></td>\n<td>{S}</td>\n<td>0-999</td>\n<td>0-999</td>\n</tr>\n</tbody>\n</table>\n<blockquote>\n<p>Templates of other languages can be found in <a href="https://github.com/apache/echarts/tree/master/src/i18n" target="_blank">the language package</a>. Please refer to <a href="api.html#echarts.registerLocale" target="_blank">echarts.registerLocale</a> to register a language.</p>\n</blockquote>\n<p>Example:</p>\n<pre><code class="lang-ts">formatter: &#39;{yyyy}-{MM}-{dd}&#39; // gets labels like &#39;2020-12-02&#39;\nformatter: &#39;Day {d}&#39; // gets labels like &#39;Day 2&#39;\n</code></pre>\n<p><strong> Callback Functions </strong></p>\n<p>Callback functions can be used to get different formats for different axis tick values. Sometimes, if you have complex date/time formatting requirement, third-party libraries like <a href="https://momentjs.com/" target="_blank">Moment.js</a> or <a href="https://date-fns.org/" target="_blank">date-fns</a> can be used to return formatted labels.</p>\n<p>Example:</p>\n<pre><code class="lang-ts">// Use callback function; function parameters are axis index\nformatter: function (value, index) {\n    // Formatted to be month/day; display year only in the first label\n    var date = new Date(value);\n    var texts = [(date.getMonth() + 1), date.getDate()];\n    if (index === 0) {\n        texts.unshift(date.getYear());\n    }\n    return texts.join(&#39;/&#39;);\n}\n</code></pre>\n<p><strong> Cascading Templates </strong></p>\n<p>Sometimes, we wish to use different formats for different time granularity. For example, in a quarter-year chart, we may wish to see the month name with the first date of the month, while see the date name with others. This can be made with:</p>\n<p>Example:</p>\n<pre><code class="lang-ts">formatter: {\n    month: &#39;{MMMM}&#39;, // Jan, Feb, ...\n    day: &#39;{d}&#39; // 1, 2, ...\n}\n</code></pre>\n<p>Supported levels and their default formatters are:</p>\n<pre><code class="lang-ts">{\n    year: &#39;{yyyy}&#39;,\n    month: &#39;{MMM}&#39;,\n    day: &#39;{d}&#39;,\n    hour: &#39;{HH}:{mm}&#39;,\n    minute: &#39;{HH}:{mm}&#39;,\n    second: &#39;{HH}:{mm}:{ss}&#39;,\n    millisecond: &#39;{hh}:{mm}:{ss} {SSS}&#39;,\n    none: &#39;{yyyy}-{MM}-{dd} {hh}:{mm}:{ss} {SSS}&#39;\n}\n</code></pre>\n<p>Let&#39;s take <code class="codespan">day</code> for example. When a tick value is <code class="codespan">0</code> for its hour, minute, second, and millisecond, <code class="codespan">day</code> level will be used to make formatter. <code class="codespan">none</code> is used when no other level fulfills, which is for tick values with millisecond values other than <code class="codespan">0</code>.</p>\n<p><strong> Rich Text </strong></p>\n<p>The above three forms all support rich text, so it can be used to make some complex effects.</p>\n<p>Example:</p>\n<pre><code class="lang-ts">xAxis: {\n    type: &#39;time&#39;,\n    axisLabel: {\n        formatter: {\n            // Display year and month information on the first data of a year\n            year: &#39;{yearStyle|{yyyy}}\\n{monthStyle|{MMM}}&#39;,\n            month: &#39;{monthStyle|{MMM}}&#39;\n        },\n        rich: {\n            yearStyle: {\n                // Make yearly text more standing out\n                color: &#39;#000&#39;,\n                fontWeight: &#39;bold&#39;\n            },\n            monthStyle: {\n                color: &#39;#999&#39;\n            }\n        }\n    }\n},\n</code></pre>\n<p>The above example can also be made with a callback function:</p>\n<p>Example:</p>\n<pre><code class="lang-ts">xAxis: {\n    type: &#39;time&#39;,\n    axisLabel: {\n        formatter: function (value) {\n            const date = new Date(value);\n            const yearStart = new Date(value);\n            yearStart.setMonth(0);\n            yearStart.setDate(1);\n            yearStart.setHours(0);\n            yearStart.setMinutes(0);\n            yearStart.setSeconds(0);\n            yearStart.setMilliseconds(0);\n            // Whether a tick value is the start of a year\n            if (date.getTime() === yearStart.getTime()) {\n                return &#39;{year|&#39; + date.getFullYear() + &#39;}\\n&#39;\n                    + &#39;{month|&#39; + (date.getMonth() + 1) + &#39;月}&#39;;\n            }\n            else {\n                return &#39;{month|&#39; + (date.getMonth() + 1) + &#39;月}&#39;\n            }\n        },\n        rich: {\n            year: {\n                color: &#39;#000&#39;,\n                fontWeight: &#39;bold&#39;\n            },\n            month: {\n                color: &#39;#999&#39;\n            }\n        }\n    }\n},\n</code></pre>\n',
    )
    showMinLabel: Optional[bool] = Field(
        None,
        description='\n\n<p>Whether to show the label of the min tick. Optional values: <code class="codespan">true</code>, <code class="codespan">false</code>, <code class="codespan">null</code>. It is auto determined by default, that is, if labels are overlapped, the label of the min tick will not be displayed.</p>\n',
    )
    showMaxLabel: Optional[bool] = Field(
        None,
        description='\n\n<p>Whether to show the label of the max tick. Optional values: <code class="codespan">true</code>, <code class="codespan">false</code>, <code class="codespan">null</code>. It is auto determined by default, that is, if labels are overlapped, the label of the max tick will not be displayed.</p>\n',
    )
    hideOverlap: Optional[bool] = Field(
        None,
        description='\n\n\n\n<blockquote>\n<p>Since <code class="codespan">v5.2.0</code></p>\n</blockquote>\n<p>Whether to hide overlapped labels.</p>\n',
    )
    color: Optional[Union[Any, Any]] = Field(
        None,
        description='\n\n<p>Color of axis label is set to be <a href="#angleAxis.axisLine.lineStyle.color">axisLine.lineStyle.color</a> by default. Callback function is supported, in the following format:</p>\n<pre><code class="lang-ts">(val: string) =&gt; Color\n</code></pre>\n<p>Parameter is the text of label, and return value is the color. See the following example:</p>\n<pre><code class="lang-ts">textStyle: {\n    color: function (value, index) {\n        return value &gt;= 0 ? &#39;green&#39; : &#39;red&#39;;\n    }\n}\n</code></pre>\n',
    )
    fontStyle: Optional[str] = Field(
        'normal',
        description='\n\n<p> font style.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;italic&#39;</code></li>\n<li><code class="codespan">&#39;oblique&#39;</code></li>\n</ul>\n',
    )
    fontWeight: Optional[Union[str, float]] = Field(
        'normal',
        description='\n\n<p> font thick weight.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;bold&#39;</code></li>\n<li><code class="codespan">&#39;bolder&#39;</code></li>\n<li><code class="codespan">&#39;lighter&#39;</code></li>\n<li>100 | 200 | 300 | 400...</li>\n</ul>\n',
    )
    fontFamily: Optional[str] = Field(
        'sans-serif',
        description='\n\n<p> font family.</p>\n<p>Can also be &#39;serif&#39; , &#39;monospace&#39;, ...</p>\n',
    )
    fontSize: Optional[float] = Field(12, description='\n\n<p> font size.</p>\n')
    align: Optional[str] = Field(
        None,
        description='\n\n<p>Horizontal alignment of text, automatic by default.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;left&#39;</code></li>\n<li><code class="codespan">&#39;center&#39;</code></li>\n<li><code class="codespan">&#39;right&#39;</code></li>\n</ul>\n<p>If <code class="codespan">align</code> is not set in <code class="codespan">rich</code>, <code class="codespan">align</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    align: right,\n    rich: {\n        a: {\n            // `align` is not set, then it will be right\n        }\n    }\n}\n</code></pre>\n',
    )
    verticalAlign: Optional[str] = Field(
        None,
        description='\n\n<p>Vertical alignment of text, automatic by default.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;top&#39;</code></li>\n<li><code class="codespan">&#39;middle&#39;</code></li>\n<li><code class="codespan">&#39;bottom&#39;</code></li>\n</ul>\n<p>If <code class="codespan">verticalAlign</code> is not set in <code class="codespan">rich</code>, <code class="codespan">verticalAlign</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    verticalAlign: bottom,\n    rich: {\n        a: {\n            // `verticalAlign` is not set, then it will be bottom\n        }\n    }\n}\n</code></pre>\n',
    )
    lineHeight: Optional[float] = Field(
        None,
        description='\n\n<p>Line height of the text fragment.</p>\n<p>If <code class="codespan">lineHeight</code> is not set in <code class="codespan">rich</code>, <code class="codespan">lineHeight</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    lineHeight: 56,\n    rich: {\n        a: {\n            // `lineHeight` is not set, then it will be 56\n        }\n    }\n}\n</code></pre>\n',
    )
    backgroundColor: Optional[Union[str, Any]] = Field(
        'transparent',
        description='\n\n<p>Background color of the text fragment.</p>\n<p>Can be color string, like <code class="codespan">&#39;#123234&#39;</code>, <code class="codespan">&#39;red&#39;</code>, <code class="codespan">&#39;rgba(0,23,11,0.3)&#39;</code>.</p>\n<p>Or image can be used, for example:</p>\n<pre><code class="lang-ts">backgroundColor: {\n    image: &#39;xxx/xxx.png&#39;\n    // It can be URL of a image,\n    // or dataURI,\n    // or HTMLImageElement,\n    // or HTMLCanvasElement.\n}\n</code></pre>\n<p><code class="codespan">width</code> or <code class="codespan">height</code> can be specified when using background image, or\nauto adapted by default.</p>\n',
    )
    borderColor: Optional[Any] = Field(
        None, description='\n\n<p>Border color of the text fragment.</p>\n'
    )
    borderWidth: Optional[float] = Field(
        0, description='\n\n<p>Border width of the text fragment.</p>\n'
    )
    borderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>the text fragment border type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">borderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\nborderType: [5, 10],\n\nborderDashOffset: 5\n}\n</code></pre>\n',
    )
    borderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">borderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    borderRadius: Optional[float] = Field(
        0, description='\n\n<p>Border radius of the text fragment.</p>\n'
    )
    padding: Optional[Union[float, Any]] = Field(
        0,
        description='\n\n<p>Padding of the text fragment, for example:</p>\n<ul>\n<li><code class="codespan">padding: [3, 4, 5, 6]</code>: represents padding of <code class="codespan">[top, right, bottom, left]</code>.</li>\n<li><code class="codespan">padding: 4</code>: represents <code class="codespan">padding: [4, 4, 4, 4]</code>.</li>\n<li><code class="codespan">padding: [3, 4]</code>: represents <code class="codespan">padding: [3, 4, 3, 4]</code>.</li>\n</ul>\n<p>Notice, <code class="codespan">width</code> and <code class="codespan">height</code> specifies the width and height of the content, without <code class="codespan">padding</code>.</p>\n',
    )
    shadowColor: Optional[Any] = Field(
        'transparent', description='\n\n<p>Shadow color of the text block.</p>\n'
    )
    shadowBlur: Optional[float] = Field(
        0, description='\n\n<p>Show blur of the text block.</p>\n'
    )
    shadowOffsetX: Optional[float] = Field(
        0, description='\n\n<p>Shadow X offset of the text block.</p>\n'
    )
    shadowOffsetY: Optional[float] = Field(
        0, description='\n\n<p>Shadow Y offset of the text block.</p>\n'
    )
    width: Optional[float] = Field(
        None, description='\n\n<p>Width of text block.</p>\n'
    )
    height: Optional[float] = Field(
        None, description='\n\n<p>Height of text block.</p>\n'
    )
    textBorderColor: Optional[Any] = Field(
        None, description='\n\n<p>Stroke color of the text.</p>\n'
    )
    textBorderWidth: Optional[float] = Field(
        None, description='\n\n<p>Stroke line width of the text.</p>\n'
    )
    textBorderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>Stroke line type of the text.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">textBorderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\ntextBorderType: [5, 10],\n\ntextBorderDashOffset: 5\n}\n</code></pre>\n',
    )
    textBorderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">textBorderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    textShadowColor: Optional[Any] = Field(
        'transparent', description='\n\n<p>Shadow color of the text itself.</p>\n'
    )
    textShadowBlur: Optional[float] = Field(
        0, description='\n\n<p>Shadow blue of the text itself.</p>\n'
    )
    textShadowOffsetX: Optional[float] = Field(
        0, description='\n\n<p>Shadow X offset of the text itself.</p>\n'
    )
    textShadowOffsetY: Optional[float] = Field(
        0, description='\n\n<p>Shadow Y offset of the text itself.</p>\n'
    )
    overflow: Optional[str] = Field(
        'none',
        description='\n\n<p>Determine how to display the text when it&#39;s overflow. Available when <code class="codespan">width</code> is set.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the text and trailing with <code class="codespan">ellipsis</code>.</li>\n<li><code class="codespan">&#39;break&#39;</code> Break by word</li>\n<li><code class="codespan">&#39;breakAll&#39;</code> Break by character.</li>\n</ul>\n',
    )
    ellipsis: Optional[str] = Field(
        '...',
        description='<p>Ellipsis to be displayed when <code class="codespan">overflow</code> is set to <code class="codespan">truncate</code>.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the overflow lines.</li>\n</ul>\n',
    )
    rich: Optional[Rich14] = Field(
        None,
        description='<p>&quot;Rich text styles&quot; can be defined in this <code class="codespan">rich</code> property. For example:</p>\n<pre><code class="lang-ts">label: {\n    // Styles defined in &#39;rich&#39; can be applied to some fragments\n    // of text by adding some markers to those fragment, like\n    // `{styleName|text content text content}`.\n    // `&#39;\\n&#39;` is the newline character.\n    formatter: [\n        &#39;{a|Style &quot;a&quot; is applied to this snippet}&#39;\n        &#39;{b|Style &quot;b&quot; is applied to this snippet}This snippet use default style{x|use style &quot;x&quot;}&#39;\n    ].join(&#39;\\n&#39;),\n\n    rich: {\n        a: {\n            color: &#39;red&#39;,\n            lineHeight: 10\n        },\n        b: {\n            backgroundColor: {\n                image: &#39;xxx/xxx.jpg&#39;\n            },\n            height: 40\n        },\n        x: {\n            fontSize: 18,\n            fontFamily: &#39;Microsoft YaHei&#39;,\n            borderColor: &#39;#449933&#39;,\n            borderRadius: 4\n        },\n        ...\n    }\n}\n</code></pre>\n<p>For more details, see <a href="tutorial.html#Rich%20Text" target="_blank">Rich Text</a> please.</p>\n',
    )


class LineStyle25(LineStyle6):
    pass


class SplitLine3(BaseModel):
    """
    <p>Split line of axis in <a href="#grid">grid</a> area.</p>

    """

    show: Optional[bool] = Field(
        True,
        description='\n\n<p>Set this to <code class="codespan">false</code> to prevent the splitLine from showing.\n<code class="codespan">value</code> type axes are shown by default, while <code class="codespan">category</code> type axes are hidden.</p>\n',
    )
    interval: Optional[Union[float, Any]] = Field(
        'auto',
        description='\n\n\n\n<p>Interval of Axis splitLine, which is available in category axis.  is set to be the same as <a href="#angleAxis.axisLabel.interval">axisLabel.interval</a> by default.</p>\n<p>It uses a strategy that labels do not overlap by default.</p>\n<p>You may set it to be 0 to display all labels compulsively.</p>\n<p>If it is set to be 1, it means that labels are shown once after one label. And if it is set to be 2, it means labels are shown once after two labels, and so on.</p>\n<p>On the other hand, you can control by callback function, whose format is shown below:</p>\n<pre><code class="lang-ts">(index:number, value: string) =&gt; boolean\n</code></pre>\n<p>The first parameter is index of category, and the second parameter is the name of category. The return values decides whether to display label.</p>\n',
    )
    lineStyle: Optional[LineStyle25] = Field(None, description='')


class LineStyle26(LineStyle7):
    pass


class MinorSplitLine3(BaseModel):
    """
        <blockquote>
    <p>Since <code class="codespan">v4.6.0</code></p>
    </blockquote>
    <p>Minor split lines of axis in the <a href="#grid">grid</a> area。It will align to the <a href="#angleAxis.minorTick">minorTick</a></p>

    """

    show: Optional[bool] = Field(
        False, description='\n\n<p>If show minor split lines.</p>\n'
    )
    lineStyle: Optional[LineStyle26] = Field(None, description='')


class AreaStyle3(AreaStyle):
    """
    <p>Split area style.</p>

    """

    pass


class SplitArea3(BaseModel):
    """
    <p>Split area of axis in <a href="#grid">grid</a> area, not shown by default.</p>

    """

    interval: Optional[Union[float, Any]] = Field(
        'auto',
        description='\n\n\n\n<p>Interval of Axis splitArea, which is available in category axis.  is set to be the same as <a href="#angleAxis.axisLabel.interval">axisLabel.interval</a> by default.</p>\n<p>It uses a strategy that labels do not overlap by default.</p>\n<p>You may set it to be 0 to display all labels compulsively.</p>\n<p>If it is set to be 1, it means that labels are shown once after one label. And if it is set to be 2, it means labels are shown once after two labels, and so on.</p>\n<p>On the other hand, you can control by callback function, whose format is shown below:</p>\n<pre><code class="lang-ts">(index:number, value: string) =&gt; boolean\n</code></pre>\n<p>The first parameter is index of category, and the second parameter is the name of category. The return values decides whether to display label.</p>\n',
    )
    show: Optional[bool] = Field(
        False,
        description='\n\n<p>Set this to <code class="codespan">true</code> to show the splitArea.</p>\n',
    )
    areaStyle: Optional[AreaStyle3] = Field(
        None, description='<p>Split area style.</p>\n'
    )


class _StyleName15(_StyleName):
    pass


class Rich15(BaseModel):
    """
        <p>&quot;Rich text styles&quot; can be defined in this <code class="codespan">rich</code> property. For example:</p>
    <pre><code class="lang-ts">label: {
        // Styles defined in &#39;rich&#39; can be applied to some fragments
        // of text by adding some markers to those fragment, like
        // `{styleName|text content text content}`.
        // `&#39;\n&#39;` is the newline character.
        formatter: [
            &#39;{a|Style &quot;a&quot; is applied to this snippet}&#39;
            &#39;{b|Style &quot;b&quot; is applied to this snippet}This snippet use default style{x|use style &quot;x&quot;}&#39;
        ].join(&#39;\n&#39;),

        rich: {
            a: {
                color: &#39;red&#39;,
                lineHeight: 10
            },
            b: {
                backgroundColor: {
                    image: &#39;xxx/xxx.jpg&#39;
                },
                height: 40
            },
            x: {
                fontSize: 18,
                fontFamily: &#39;Microsoft YaHei&#39;,
                borderColor: &#39;#449933&#39;,
                borderRadius: 4
            },
            ...
        }
    }
    </code></pre>
    <p>For more details, see <a href="tutorial.html#Rich%20Text" target="_blank">Rich Text</a> please.</p>

    """

    _style_name_: Optional[_StyleName15] = Field(
        None, alias='<style_name>', description=''
    )


class TextStyle7(BaseModel):
    """
    <p>Text style of the category.</p>

    """

    color: Optional[Any] = Field('#fff', description='\n\n<p> text color.</p>\n')
    fontStyle: Optional[str] = Field(
        'normal',
        description='\n\n<p> font style.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;italic&#39;</code></li>\n<li><code class="codespan">&#39;oblique&#39;</code></li>\n</ul>\n',
    )
    fontWeight: Optional[Union[str, float]] = Field(
        'normal',
        description='\n\n<p> font thick weight.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;bold&#39;</code></li>\n<li><code class="codespan">&#39;bolder&#39;</code></li>\n<li><code class="codespan">&#39;lighter&#39;</code></li>\n<li>100 | 200 | 300 | 400...</li>\n</ul>\n',
    )
    fontFamily: Optional[str] = Field(
        'sans-serif',
        description='\n\n<p> font family.</p>\n<p>Can also be &#39;serif&#39; , &#39;monospace&#39;, ...</p>\n',
    )
    fontSize: Optional[float] = Field(12, description='\n\n<p> font size.</p>\n')
    align: Optional[str] = Field(
        None,
        description='\n\n<p>Horizontal alignment of text, automatic by default.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;left&#39;</code></li>\n<li><code class="codespan">&#39;center&#39;</code></li>\n<li><code class="codespan">&#39;right&#39;</code></li>\n</ul>\n<p>If <code class="codespan">align</code> is not set in <code class="codespan">rich</code>, <code class="codespan">align</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    align: right,\n    rich: {\n        a: {\n            // `align` is not set, then it will be right\n        }\n    }\n}\n</code></pre>\n',
    )
    verticalAlign: Optional[str] = Field(
        None,
        description='\n\n<p>Vertical alignment of text, automatic by default.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;top&#39;</code></li>\n<li><code class="codespan">&#39;middle&#39;</code></li>\n<li><code class="codespan">&#39;bottom&#39;</code></li>\n</ul>\n<p>If <code class="codespan">verticalAlign</code> is not set in <code class="codespan">rich</code>, <code class="codespan">verticalAlign</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    verticalAlign: bottom,\n    rich: {\n        a: {\n            // `verticalAlign` is not set, then it will be bottom\n        }\n    }\n}\n</code></pre>\n',
    )
    lineHeight: Optional[float] = Field(
        None,
        description='\n\n<p>Line height of the text fragment.</p>\n<p>If <code class="codespan">lineHeight</code> is not set in <code class="codespan">rich</code>, <code class="codespan">lineHeight</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    lineHeight: 56,\n    rich: {\n        a: {\n            // `lineHeight` is not set, then it will be 56\n        }\n    }\n}\n</code></pre>\n',
    )
    backgroundColor: Optional[Union[str, Any]] = Field(
        'transparent',
        description='\n\n<p>Background color of the text fragment.</p>\n<p>Can be color string, like <code class="codespan">&#39;#123234&#39;</code>, <code class="codespan">&#39;red&#39;</code>, <code class="codespan">&#39;rgba(0,23,11,0.3)&#39;</code>.</p>\n<p>Or image can be used, for example:</p>\n<pre><code class="lang-ts">backgroundColor: {\n    image: &#39;xxx/xxx.png&#39;\n    // It can be URL of a image,\n    // or dataURI,\n    // or HTMLImageElement,\n    // or HTMLCanvasElement.\n}\n</code></pre>\n<p><code class="codespan">width</code> or <code class="codespan">height</code> can be specified when using background image, or\nauto adapted by default.</p>\n',
    )
    borderColor: Optional[Any] = Field(
        None, description='\n\n<p>Border color of the text fragment.</p>\n'
    )
    borderWidth: Optional[float] = Field(
        0, description='\n\n<p>Border width of the text fragment.</p>\n'
    )
    borderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>the text fragment border type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">borderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\nborderType: [5, 10],\n\nborderDashOffset: 5\n}\n</code></pre>\n',
    )
    borderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">borderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    borderRadius: Optional[float] = Field(
        0, description='\n\n<p>Border radius of the text fragment.</p>\n'
    )
    padding: Optional[Union[float, Any]] = Field(
        0,
        description='\n\n<p>Padding of the text fragment, for example:</p>\n<ul>\n<li><code class="codespan">padding: [3, 4, 5, 6]</code>: represents padding of <code class="codespan">[top, right, bottom, left]</code>.</li>\n<li><code class="codespan">padding: 4</code>: represents <code class="codespan">padding: [4, 4, 4, 4]</code>.</li>\n<li><code class="codespan">padding: [3, 4]</code>: represents <code class="codespan">padding: [3, 4, 3, 4]</code>.</li>\n</ul>\n<p>Notice, <code class="codespan">width</code> and <code class="codespan">height</code> specifies the width and height of the content, without <code class="codespan">padding</code>.</p>\n',
    )
    shadowColor: Optional[Any] = Field(
        'transparent', description='\n\n<p>Shadow color of the text block.</p>\n'
    )
    shadowBlur: Optional[float] = Field(
        0, description='\n\n<p>Show blur of the text block.</p>\n'
    )
    shadowOffsetX: Optional[float] = Field(
        0, description='\n\n<p>Shadow X offset of the text block.</p>\n'
    )
    shadowOffsetY: Optional[float] = Field(
        0, description='\n\n<p>Shadow Y offset of the text block.</p>\n'
    )
    width: Optional[float] = Field(
        None, description='\n\n<p>Width of text block.</p>\n'
    )
    height: Optional[float] = Field(
        None, description='\n\n<p>Height of text block.</p>\n'
    )
    textBorderColor: Optional[Any] = Field(
        None, description='\n\n<p>Stroke color of the text.</p>\n'
    )
    textBorderWidth: Optional[float] = Field(
        None, description='\n\n<p>Stroke line width of the text.</p>\n'
    )
    textBorderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>Stroke line type of the text.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">textBorderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\ntextBorderType: [5, 10],\n\ntextBorderDashOffset: 5\n}\n</code></pre>\n',
    )
    textBorderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">textBorderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    textShadowColor: Optional[Any] = Field(
        'transparent', description='\n\n<p>Shadow color of the text itself.</p>\n'
    )
    textShadowBlur: Optional[float] = Field(
        0, description='\n\n<p>Shadow blue of the text itself.</p>\n'
    )
    textShadowOffsetX: Optional[float] = Field(
        0, description='\n\n<p>Shadow X offset of the text itself.</p>\n'
    )
    textShadowOffsetY: Optional[float] = Field(
        0, description='\n\n<p>Shadow Y offset of the text itself.</p>\n'
    )
    overflow: Optional[str] = Field(
        'none',
        description='\n\n<p>Determine how to display the text when it&#39;s overflow. Available when <code class="codespan">width</code> is set.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the text and trailing with <code class="codespan">ellipsis</code>.</li>\n<li><code class="codespan">&#39;break&#39;</code> Break by word</li>\n<li><code class="codespan">&#39;breakAll&#39;</code> Break by character.</li>\n</ul>\n',
    )
    ellipsis: Optional[str] = Field(
        '...',
        description='<p>Ellipsis to be displayed when <code class="codespan">overflow</code> is set to <code class="codespan">truncate</code>.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the overflow lines.</li>\n</ul>\n',
    )
    rich: Optional[Rich15] = Field(
        None,
        description='<p>&quot;Rich text styles&quot; can be defined in this <code class="codespan">rich</code> property. For example:</p>\n<pre><code class="lang-ts">label: {\n    // Styles defined in &#39;rich&#39; can be applied to some fragments\n    // of text by adding some markers to those fragment, like\n    // `{styleName|text content text content}`.\n    // `&#39;\\n&#39;` is the newline character.\n    formatter: [\n        &#39;{a|Style &quot;a&quot; is applied to this snippet}&#39;\n        &#39;{b|Style &quot;b&quot; is applied to this snippet}This snippet use default style{x|use style &quot;x&quot;}&#39;\n    ].join(&#39;\\n&#39;),\n\n    rich: {\n        a: {\n            color: &#39;red&#39;,\n            lineHeight: 10\n        },\n        b: {\n            backgroundColor: {\n                image: &#39;xxx/xxx.jpg&#39;\n            },\n            height: 40\n        },\n        x: {\n            fontSize: 18,\n            fontFamily: &#39;Microsoft YaHei&#39;,\n            borderColor: &#39;#449933&#39;,\n            borderRadius: 4\n        },\n        ...\n    }\n}\n</code></pre>\n<p>For more details, see <a href="tutorial.html#Rich%20Text" target="_blank">Rich Text</a> please.</p>\n',
    )


class Datum4(BaseModel):
    value: Optional[str] = Field(None, description='<p>Name of a category.</p>\n')
    textStyle: Optional[TextStyle7] = Field(
        None, description='<p>Text style of the category.</p>\n'
    )


class Label5(Label):
    """
    <p>label of axisPointer</p>

    """

    pass


class LineStyle27(LineStyle2):
    """
    <p>It is valid when <a href="#tooltip.axisPointer.type">axisPointer.type</a> is <code class="codespan">&#39;line&#39;</code>.</p>

    """

    pass


class ShadowStyle5(ShadowStyle):
    """
    <p>It is valid when <a href="#tooltip.axisPointer.type">axisPointer.type</a> is <code class="codespan">&#39;shadow&#39;</code>.</p>

    """

    pass


class Handle3(Handle):
    """
    <p>A button used to drag axisPointer. This feature is applicable in touch device. See <a href="http://localhost/echarts-website/examples/en/editor.html?c=line-tooltip-touch&amp;edit=1&amp;reset=1" target="_blank">example</a>.</p>

    """

    pass


class AxisPointer5(BaseModel):
    """
    <p>axisPointer settings on the axis.</p>

    """

    show: Optional[bool] = Field(
        False,
        description='\n\n<p>axisPointer will not be displayed by default. But if <a href="#tooltip.trigger">tooltip.trigger</a> is set as <code class="codespan">&#39;axis&#39;</code> or <a href="#tooltip.axisPointer.type">tooltip.axisPointer.type</a> is set as  <code class="codespan">&#39;cross&#39;</code>, axisPointer will be displayed automatically. Each coordinate system will automatically chose the axes whose will display its axisPointer. <a href="#tooltip.axisPointer.axis">tooltip.axisPointer.axis</a> can be used to change the choice.</p>\n',
    )
    type: Optional[str] = Field(
        'line',
        description='\n\n<p>Indicator type.</p>\n<p>Options:</p>\n<ul>\n<li><p><code class="codespan">&#39;line&#39;</code> line indicator.</p>\n</li>\n<li><p><code class="codespan">&#39;shadow&#39;</code> shadow crosshair indicator.</p>\n</li>\n<li><p><code class="codespan">&#39;none&#39;</code> no indicator displayed.</p>\n</li>\n</ul>\n',
    )
    snap: Optional[bool] = Field(
        None,
        description='<p>Whether snap to point automatically. The default value is auto determined.</p>\n<p>This feature usually makes sense in value axis and time axis, where tiny points can be seeked automatically.</p>\n',
    )
    z: Optional[float] = Field(
        None,
        description='<p>z value, which controls order of drawing graphical components. Components with smaller <code class="codespan">z</code> values may be overwritten by those with larger <code class="codespan">z</code> values.</p>\n',
    )
    label: Optional[Label5] = Field(None, description='<p>label of axisPointer</p>\n')
    lineStyle: Optional[LineStyle27] = Field(
        None,
        description='<p>It is valid when <a href="#tooltip.axisPointer.type">axisPointer.type</a> is <code class="codespan">&#39;line&#39;</code>.</p>\n',
    )
    shadowStyle: Optional[ShadowStyle5] = Field(
        None,
        description='<p>It is valid when <a href="#tooltip.axisPointer.type">axisPointer.type</a> is <code class="codespan">&#39;shadow&#39;</code>.</p>\n',
    )
    triggerTooltip: Optional[bool] = Field(
        True, description='\n\n<p>Whether to trigger tooltip.</p>\n'
    )
    value: Optional[float] = Field(
        None,
        description='<p>current value. When using <a href="xAxisPointer.handle" target="_blank">axisPointer.handle</a>, <code class="codespan">value</code> can be set to define the initial position of axisPointer.</p>\n',
    )
    status: Optional[bool] = Field(
        None,
        description='\n\n<p>Current status, can be <code class="codespan">&#39;show&#39;</code> 和 <code class="codespan">&#39;hide&#39;</code>.</p>\n',
    )
    handle: Optional[Handle3] = Field(
        None,
        description='<p>A button used to drag axisPointer. This feature is applicable in touch device. See <a href="http://localhost/echarts-website/examples/en/editor.html?c=line-tooltip-touch&amp;edit=1&amp;reset=1" target="_blank">example</a>.</p>\n',
    )


class AngleAxis(BaseModel):
    """
    <p>The angle axis in Polar Coordinate.</p>

    """

    id: Optional[str] = Field(
        None,
        description='<p>Component ID, not specified by default. If specified, it can be used to refer the component in option or API.</p>\n',
    )
    polarIndex: Optional[float] = Field(
        0,
        description='<p>The index of angle axis in Polar Coordinate. The first axis is used by default.</p>\n',
    )
    startAngle: Optional[float] = Field(
        90,
        description='\n\n<p>Starting angle of axis. 90 degrees by default, standing for top position of center. 0 degree stands for right position of center.</p>\n<p>The following shows an example with startAngle of 45 deg.</p>\n<iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=doc-example/polar-start-angle&edit=1&reset=1" width="400" height="400"></iframe>\n\n',
    )
    clockwise: Optional[bool] = Field(
        True,
        description='\n\n<p>Whether the positive position of axis is clockwise. True for clockwise by default.</p>\n<p>The following shows an example with clockwise as <code class="codespan">false</code>.</p>\n<iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=doc-example/polar-anticlockwise&edit=1&reset=1" width="400" height="400"></iframe>\n\n\n\n',
    )
    type: Optional[str] = Field(
        'category',
        description='<p>Type of axis.</p>\n<p>Option:</p>\n<ul>\n<li><p><code class="codespan">&#39;value&#39;</code>\n  Numerical axis, suitable for continuous data.</p>\n</li>\n<li><p><code class="codespan">&#39;category&#39;</code>\n  Category axis, suitable for discrete category data. Category data can be auto retrieved from <a href="#series.data">series.data</a> or <a href="#dataset.source">dataset.source</a>, or can be specified via <a href="#angleAxis.data">angleAxis.data</a>.</p>\n</li>\n<li><p><code class="codespan">&#39;time&#39;</code>\n  Time axis, suitable for continuous time series data. As compared to value axis, it has a better formatting for time and a different tick calculation method. For example, it decides to use month, week, day or hour for tick based on the range of span.</p>\n</li>\n<li><p><code class="codespan">&#39;log&#39;</code>\n  Log axis, suitable for log data.</p>\n</li>\n</ul>\n',
    )
    boundaryGap: Optional[Union[bool, Any]] = Field(
        None,
        description='\n\n<p>The boundary gap on both sides of a coordinate axis. The setting and behavior of category axes and non-category axes are different.</p>\n<p>The <code class="codespan">boundaryGap</code> of category axis can be set to either <code class="codespan">true</code> or <code class="codespan">false</code>. Default value is set to be <code class="codespan">true</code>, in which case <a href="#angleAxis.axisTick">axisTick</a> is served only as a separation line, and labels and data appear only in the center part of two <a href="#angleAxis.axisTick">axis ticks</a>, which is called <em>band</em>.</p>\n<p>For non-category axis, including time, numerical value, and log axes, <code class="codespan">boundaryGap</code> is an array of two values, representing the spanning range between minimum and maximum value. The value can be set in numeric value or relative percentage, which becomes invalid after setting <a href="#angleAxis.min">min</a> and <a href="#angleAxis.max">max</a>.\n<strong>Example: </strong></p>\n<pre><code class="lang-ts">boundaryGap: [&#39;20%&#39;, &#39;20%&#39;]\n</code></pre>\n',
    )
    min: Optional[Union[float, str, Any]] = Field(
        None,
        description='\n\n<p>The minimun value of axis.</p>\n<p>It can be set to a special value <code class="codespan">&#39;dataMin&#39;</code> so that the minimum value on this axis is set to be the minimum label.</p>\n<p>It will be automatically computed to make sure axis tick is equally distributed when not set.</p>\n<p>In category axis, it can also be set as the ordinal number. For example, if a catergory axis has <code class="codespan">data: [&#39;categoryA&#39;, &#39;categoryB&#39;, &#39;categoryC&#39;]</code>, and the ordinal <code class="codespan">2</code> represents <code class="codespan">&#39;categoryC&#39;</code>. Moreover, it can be set as negative number, like <code class="codespan">-3</code>.</p>\n<p>If <code class="codespan">min</code> is specified as a function, it should return a min value, like:</p>\n<pre><code class="lang-ts">min: function (value) {\n    return value.min - 20;\n}\n</code></pre>\n<p><code class="codespan">value</code> is an object, containing the <code class="codespan">min</code> value and <code class="codespan">max</code> value of the data. This function should return the min value of axis, or return <code class="codespan">null</code>/<code class="codespan">undefined</code> to make echarts use the auto calculated min value (<code class="codespan">null</code>/<code class="codespan">undefined</code> return is only supported since <code class="codespan">v4.8.0</code>).</p>\n',
    )
    max: Optional[Union[float, str, Any]] = Field(
        None,
        description='\n\n<p>The maximum value of axis.</p>\n<p>It can be set to a special value <code class="codespan">&#39;dataMax&#39;</code> so that the minimum value on this axis is set to be the maximum label.</p>\n<p>It will be automatically computed to make sure axis tick is equally distributed when not set.</p>\n<p>In category axis, it can also be set as the ordinal number. For example, if a catergory axis has <code class="codespan">data: [&#39;categoryA&#39;, &#39;categoryB&#39;, &#39;categoryC&#39;]</code>, and the ordinal <code class="codespan">2</code> represents <code class="codespan">&#39;categoryC&#39;</code>. Moreover, it can be set as negative number, like <code class="codespan">-3</code>.</p>\n<p>If <code class="codespan">max</code> is specified as a function, it should return a max value, like:</p>\n<pre><code class="lang-ts">max: function (value) {\n    return value.max - 20;\n}\n</code></pre>\n<p><code class="codespan">value</code> is an object, containing the <code class="codespan">min</code> value and <code class="codespan">max</code> value of the data. This function should return the max value of axis, or return <code class="codespan">null</code>/<code class="codespan">undefined</code> to make echarts use the auto calculated max value (<code class="codespan">null</code>/<code class="codespan">undefined</code> return is only supported since <code class="codespan">v4.8.0</code>).</p>\n',
    )
    scale: Optional[bool] = Field(
        False,
        description='\n\n<p>It is available only in numerical axis, i.e., <a href="#angleAxis.type">type</a>: &#39;value&#39;.</p>\n<p>It specifies whether not to contain zero position of axis compulsively. When it is set to be <code class="codespan">true</code>, the axis may not contain zero position, which is useful in the scatter chart for both value axes.</p>\n<p>This configuration item is unavailable when the <a href="#angleAxis.min">min</a> and <a href="#angleAxis.max">max</a> are set.</p>\n',
    )
    splitNumber: Optional[float] = Field(
        5,
        description='\n\n<p>Number of segments that the axis is split into. Note that this number serves only as a recommendation, and the true segments may be adjusted based on readability.</p>\n<p>This is unavailable for category axis.</p>\n',
    )
    minInterval: Optional[float] = Field(
        0,
        description='\n\n<p>Minimum gap between split lines.</p>\n<p>For example, it can be set to be <code class="codespan">1</code> to make sure axis label is show as integer.</p>\n<pre><code class="lang-ts">{\n    minInterval: 1\n}\n</code></pre>\n<p>It is available only for axis of <a href="#angleAxis.type">type</a> &#39;value&#39; or &#39;time&#39;.</p>\n',
    )
    maxInterval: Optional[float] = Field(
        None,
        description='\n\n<p>Maximum gap between split lines.</p>\n<p>For example, in time axis (<a href="#angleAxis.type">type</a> is &#39;time&#39;), it can be set to be <code class="codespan">3600 * 24 * 1000</code> to make sure that the gap between axis labels is less than or equal to one day.</p>\n<pre><code class="lang-ts">{\n    maxInterval: 3600 * 1000 * 24\n}\n</code></pre>\n<p>It is available only for axis of <a href="#angleAxis.type">type</a> &#39;value&#39; or &#39;time&#39;.</p>\n',
    )
    interval: Optional[float] = Field(
        None,
        description='\n\n<p>Compulsively set segmentation interval for axis.</p>\n<p>As <a href="#angleAxis.splitNumber">splitNumber</a> is a recommendation value, the calculated tick may not be the same as expected. In this case, interval should be used along with <a href="#angleAxis.min">min</a> and <a href="#angleAxis.max">max</a> to compulsively set tickings. But in most cases, we do not suggest using this, our automatic calculation is enough for most situations.</p>\n<p>This is unavailable for category axis. Timestamp should be passed for <a href="#angleAxis.type">type</a>: &#39;time&#39; axis. Logged value should be passed for <a href="#angleAxis.type">type</a>: &#39;log&#39; axis.</p>\n',
    )
    logBase: Optional[float] = Field(
        10,
        description='\n\n<p>Base of logarithm, which is valid only for numeric axes with <a href="#angleAxis.type">type</a>: &#39;log&#39;.</p>\n',
    )
    silent: Optional[bool] = Field(
        False,
        description='<p>Set this to <code class="codespan">true</code>, to prevent interaction with the axis.</p>\n',
    )
    triggerEvent: Optional[bool] = Field(
        False,
        description='<p>Set this to <code class="codespan">true</code> to enable triggering events.</p>\n<p>Parameters of the event include:</p>\n<pre><code class="lang-ts">{\n    // Component type: xAxis, yAxis, radiusAxis, angleAxis\n    // Each of which has an attribute for index, e.g., xAxisIndex for xAxis\n    componentType: string,\n    // Value on axis before being formatted.\n    // Click on value label to trigger event.\n    value: &#39;&#39;,\n    // Name of axis.\n    // Click on laben name to trigger event.\n    name: &#39;&#39;\n}\n</code></pre>\n',
    )
    axisLine: Optional[AxisLine3] = Field(
        None, description='<p>Settings related to axis line.</p>\n'
    )
    axisTick: Optional[AxisTick3] = Field(
        None, description='<p>Settings related to axis tick.</p>\n'
    )
    minorTick: Optional[MinorTick3] = Field(
        None,
        description='<blockquote>\n<p>Since <code class="codespan">v4.6.0</code></p>\n</blockquote>\n<p>Settings related minor ticks.</p>\n<p>Note: <code class="codespan">minorTick</code> is not available in the <code class="codespan">category</code> type axis.</p>\n<p>Examples:</p>\n<p>1) Using minor ticks in function plotting.</p>\n<iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=line-function&edit=1&reset=1" width="600" height="350"></iframe>\n\n\n<p>2) Using minor ticks in log axis.</p>\n<iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=line-log&edit=1&reset=1" width="600" height="350"></iframe>\n\n',
    )
    axisLabel: Optional[AxisLabel3] = Field(
        None, description='<p>Settings related to axis label.</p>\n'
    )
    splitLine: Optional[SplitLine3] = Field(
        None,
        description='<p>Split line of axis in <a href="#grid">grid</a> area.</p>\n',
    )
    minorSplitLine: Optional[MinorSplitLine3] = Field(
        None,
        description='<blockquote>\n<p>Since <code class="codespan">v4.6.0</code></p>\n</blockquote>\n<p>Minor split lines of axis in the <a href="#grid">grid</a> area。It will align to the <a href="#angleAxis.minorTick">minorTick</a></p>\n',
    )
    splitArea: Optional[SplitArea3] = Field(
        None,
        description='<p>Split area of axis in <a href="#grid">grid</a> area, not shown by default.</p>\n',
    )
    data: Optional[List[Datum4]] = Field(
        None,
        description='<p>Category data, available in <a href="#angleAxis.type">type</a>: &#39;category&#39; axis.</p>\n<p>If <a href="#angleAxis.type">type</a> is not specified, but <code class="codespan">axis.data</code> is specified, the <a href="#angleAxis.type">type</a> is auto set as <code class="codespan">&#39;category&#39;</code>.</p>\n<p>If <a href="#angleAxis.type">type</a> is specified as <code class="codespan">&#39;category&#39;</code>, but <code class="codespan">axis.data</code> is not specified, <code class="codespan">axis.data</code> will be auto collected from <a href="#series.data">series.data</a>. It brings convenience, but we should notice that <code class="codespan">axis.data</code> provides then value range of the <code class="codespan">&#39;category&#39;</code> axis. If  it is auto collected from <a href="#series.data">series.data</a>, Only the values appearing in <a href="#series.data">series.data</a> can be collected. For example, if <a href="#series.data">series.data</a> is empty, nothing will be collected.</p>\n<p>Example:</p>\n<pre><code class="lang-ts">// Name list of all categories\ndata: [&#39;Monday&#39;, &#39;Tuesday&#39;, &#39;Wednesday&#39;, &#39;Thursday&#39;, &#39;Friday&#39;, &#39;Saturday&#39;, &#39;Sunday&#39;]\n// Each item could also be a specific configuration item.\n// In this case, `value` is used as the category name.\ndata: [{\n    value: &#39;Monday&#39;,\n    // Highlight Monday\n    textStyle: {\n        fontSize: 20,\n        color: &#39;red&#39;\n    }\n}, &#39;Tuesday&#39;, &#39;Wednesday&#39;, &#39;Thursday&#39;, &#39;Friday&#39;, &#39;Saturday&#39;, &#39;Sunday&#39;]\n</code></pre>\n',
    )
    axisPointer: Optional[AxisPointer5] = Field(
        None, description='<p>axisPointer settings on the axis.</p>\n'
    )
    zlevel: Optional[float] = Field(
        0,
        description='<p><code class="codespan">zlevel</code> value of all graphical elements in Angle Axis.</p>\n<p><code class="codespan">zlevel</code> is used to make layers with Canvas. Graphical elements with different <code class="codespan">zlevel</code> values will be placed in different Canvases, which is a common optimization technique. We can put those frequently changed elements (like those with animations) to a separate <code class="codespan">zlevel</code>. Notice that too many Canvases will increase memory cost, and should be used carefully on mobile phones to avoid crash.</p>\n<p>Canvases with bigger <code class="codespan">zlevel</code> will be placed on Canvases with smaller <code class="codespan">zlevel</code>.</p>\n',
    )
    z: Optional[float] = Field(
        0,
        description='<p><code class="codespan">z</code> value of all graphical elements in Angle Axis, which controls order of drawing graphical components. Components with smaller <code class="codespan">z</code> values may be overwritten by those with larger <code class="codespan">z</code> values.</p>\n<p><code class="codespan">z</code> has a lower priority to <code class="codespan">zlevel</code>, and will not create new Canvas.</p>\n',
    )


class _StyleName16(_StyleName):
    pass


class Rich16(BaseModel):
    """
        <p>&quot;Rich text styles&quot; can be defined in this <code class="codespan">rich</code> property. For example:</p>
    <pre><code class="lang-ts">label: {
        // Styles defined in &#39;rich&#39; can be applied to some fragments
        // of text by adding some markers to those fragment, like
        // `{styleName|text content text content}`.
        // `&#39;\n&#39;` is the newline character.
        formatter: [
            &#39;{a|Style &quot;a&quot; is applied to this snippet}&#39;
            &#39;{b|Style &quot;b&quot; is applied to this snippet}This snippet use default style{x|use style &quot;x&quot;}&#39;
        ].join(&#39;\n&#39;),

        rich: {
            a: {
                color: &#39;red&#39;,
                lineHeight: 10
            },
            b: {
                backgroundColor: {
                    image: &#39;xxx/xxx.jpg&#39;
                },
                height: 40
            },
            x: {
                fontSize: 18,
                fontFamily: &#39;Microsoft YaHei&#39;,
                borderColor: &#39;#449933&#39;,
                borderRadius: 4
            },
            ...
        }
    }
    </code></pre>
    <p>For more details, see <a href="tutorial.html#Rich%20Text" target="_blank">Rich Text</a> please.</p>

    """

    _style_name_: Optional[_StyleName16] = Field(
        None, alias='<style_name>', description=''
    )


class AxisName(BaseModel):
    """
    <p>Name options for radar indicators.</p>

    """

    show: Optional[bool] = Field(
        True, description='<p>Whether to display the indicator&#39;s name.</p>\n'
    )
    formatter: Optional[Union[str, Any]] = Field(
        None,
        description='<p>The formatter of indicator&#39;s name, in which the string and callback function are supported. See the following example:</p>\n<pre><code class="lang-ts">// using string template, the template variable should be the indicator&#39;s name {value}\nformatter: &#39;【{value}】&#39;\n// using callback function, the first parameter is the indicator&#39;s name, and the second parameter id the indicator&#39;s cinfiguration item\nformatter: function (value, indicator) {\n    return &#39;【&#39; + value + &#39;】&#39;;\n}\n</code></pre>\n',
    )
    color: Optional[Any] = Field('#333', description='\n\n<p> text color.</p>\n')
    fontStyle: Optional[str] = Field(
        'normal',
        description='\n\n<p> font style.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;italic&#39;</code></li>\n<li><code class="codespan">&#39;oblique&#39;</code></li>\n</ul>\n',
    )
    fontWeight: Optional[Union[str, float]] = Field(
        'normal',
        description='\n\n<p> font thick weight.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;bold&#39;</code></li>\n<li><code class="codespan">&#39;bolder&#39;</code></li>\n<li><code class="codespan">&#39;lighter&#39;</code></li>\n<li>100 | 200 | 300 | 400...</li>\n</ul>\n',
    )
    fontFamily: Optional[str] = Field(
        'sans-serif',
        description='\n\n<p> font family.</p>\n<p>Can also be &#39;serif&#39; , &#39;monospace&#39;, ...</p>\n',
    )
    fontSize: Optional[float] = Field(12, description='\n\n<p> font size.</p>\n')
    lineHeight: Optional[float] = Field(
        None,
        description='\n\n<p>Line height of the text fragment.</p>\n<p>If <code class="codespan">lineHeight</code> is not set in <code class="codespan">rich</code>, <code class="codespan">lineHeight</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    lineHeight: 56,\n    rich: {\n        a: {\n            // `lineHeight` is not set, then it will be 56\n        }\n    }\n}\n</code></pre>\n',
    )
    backgroundColor: Optional[Union[str, Any]] = Field(
        'transparent',
        description='\n\n<p>Background color of the text fragment.</p>\n<p>Can be color string, like <code class="codespan">&#39;#123234&#39;</code>, <code class="codespan">&#39;red&#39;</code>, <code class="codespan">&#39;rgba(0,23,11,0.3)&#39;</code>.</p>\n<p>Or image can be used, for example:</p>\n<pre><code class="lang-ts">backgroundColor: {\n    image: &#39;xxx/xxx.png&#39;\n    // It can be URL of a image,\n    // or dataURI,\n    // or HTMLImageElement,\n    // or HTMLCanvasElement.\n}\n</code></pre>\n<p><code class="codespan">width</code> or <code class="codespan">height</code> can be specified when using background image, or\nauto adapted by default.</p>\n',
    )
    borderColor: Optional[Any] = Field(
        None, description='\n\n<p>Border color of the text fragment.</p>\n'
    )
    borderWidth: Optional[float] = Field(
        0, description='\n\n<p>Border width of the text fragment.</p>\n'
    )
    borderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>the text fragment border type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">borderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\nborderType: [5, 10],\n\nborderDashOffset: 5\n}\n</code></pre>\n',
    )
    borderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">borderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    borderRadius: Optional[float] = Field(
        0, description='\n\n<p>Border radius of the text fragment.</p>\n'
    )
    padding: Optional[Union[float, Any]] = Field(
        0,
        description='\n\n<p>Padding of the text fragment, for example:</p>\n<ul>\n<li><code class="codespan">padding: [3, 4, 5, 6]</code>: represents padding of <code class="codespan">[top, right, bottom, left]</code>.</li>\n<li><code class="codespan">padding: 4</code>: represents <code class="codespan">padding: [4, 4, 4, 4]</code>.</li>\n<li><code class="codespan">padding: [3, 4]</code>: represents <code class="codespan">padding: [3, 4, 3, 4]</code>.</li>\n</ul>\n<p>Notice, <code class="codespan">width</code> and <code class="codespan">height</code> specifies the width and height of the content, without <code class="codespan">padding</code>.</p>\n',
    )
    shadowColor: Optional[Any] = Field(
        'transparent', description='\n\n<p>Shadow color of the text block.</p>\n'
    )
    shadowBlur: Optional[float] = Field(
        0, description='\n\n<p>Show blur of the text block.</p>\n'
    )
    shadowOffsetX: Optional[float] = Field(
        0, description='\n\n<p>Shadow X offset of the text block.</p>\n'
    )
    shadowOffsetY: Optional[float] = Field(
        0, description='\n\n<p>Shadow Y offset of the text block.</p>\n'
    )
    width: Optional[float] = Field(
        None, description='\n\n<p>Width of text block.</p>\n'
    )
    height: Optional[float] = Field(
        None, description='\n\n<p>Height of text block.</p>\n'
    )
    textBorderColor: Optional[Any] = Field(
        None, description='\n\n<p>Stroke color of the text.</p>\n'
    )
    textBorderWidth: Optional[float] = Field(
        None, description='\n\n<p>Stroke line width of the text.</p>\n'
    )
    textBorderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>Stroke line type of the text.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">textBorderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\ntextBorderType: [5, 10],\n\ntextBorderDashOffset: 5\n}\n</code></pre>\n',
    )
    textBorderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">textBorderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    textShadowColor: Optional[Any] = Field(
        'transparent', description='\n\n<p>Shadow color of the text itself.</p>\n'
    )
    textShadowBlur: Optional[float] = Field(
        0, description='\n\n<p>Shadow blue of the text itself.</p>\n'
    )
    textShadowOffsetX: Optional[float] = Field(
        0, description='\n\n<p>Shadow X offset of the text itself.</p>\n'
    )
    textShadowOffsetY: Optional[float] = Field(
        0, description='\n\n<p>Shadow Y offset of the text itself.</p>\n'
    )
    overflow: Optional[str] = Field(
        'none',
        description='\n\n<p>Determine how to display the text when it&#39;s overflow. Available when <code class="codespan">width</code> is set.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the text and trailing with <code class="codespan">ellipsis</code>.</li>\n<li><code class="codespan">&#39;break&#39;</code> Break by word</li>\n<li><code class="codespan">&#39;breakAll&#39;</code> Break by character.</li>\n</ul>\n',
    )
    ellipsis: Optional[str] = Field(
        '...',
        description='<p>Ellipsis to be displayed when <code class="codespan">overflow</code> is set to <code class="codespan">truncate</code>.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the overflow lines.</li>\n</ul>\n',
    )
    rich: Optional[Rich16] = Field(
        None,
        description='<p>&quot;Rich text styles&quot; can be defined in this <code class="codespan">rich</code> property. For example:</p>\n<pre><code class="lang-ts">label: {\n    // Styles defined in &#39;rich&#39; can be applied to some fragments\n    // of text by adding some markers to those fragment, like\n    // `{styleName|text content text content}`.\n    // `&#39;\\n&#39;` is the newline character.\n    formatter: [\n        &#39;{a|Style &quot;a&quot; is applied to this snippet}&#39;\n        &#39;{b|Style &quot;b&quot; is applied to this snippet}This snippet use default style{x|use style &quot;x&quot;}&#39;\n    ].join(&#39;\\n&#39;),\n\n    rich: {\n        a: {\n            color: &#39;red&#39;,\n            lineHeight: 10\n        },\n        b: {\n            backgroundColor: {\n                image: &#39;xxx/xxx.jpg&#39;\n            },\n            height: 40\n        },\n        x: {\n            fontSize: 18,\n            fontFamily: &#39;Microsoft YaHei&#39;,\n            borderColor: &#39;#449933&#39;,\n            borderRadius: 4\n        },\n        ...\n    }\n}\n</code></pre>\n<p>For more details, see <a href="tutorial.html#Rich%20Text" target="_blank">Rich Text</a> please.</p>\n',
    )


class LineStyle28(LineStyle3):
    pass


class AxisLine4(BaseModel):
    """
    <p>Settings related to axis line.</p>

    """

    show: Optional[bool] = Field(
        True,
        description='\n\n<p>Set this to <code class="codespan">false</code> to prevent the axis line from showing.</p>\n',
    )
    symbol: Optional[Union[str, Any]] = Field(
        'none',
        description='\n\n<p>Symbol of the two ends of the axis. It could be a string, representing the same symbol for two ends; or an array with two string elements, representing the two ends separately. It&#39;s set to be <code class="codespan">&#39;none&#39;</code> by default, meaning no arrow for either end. If it is set to be <code class="codespan">&#39;arrow&#39;</code>, there shall be two arrows. If there should only one arrow at the end, it should set to be <code class="codespan">[&#39;none&#39;, &#39;arrow&#39;]</code>.</p>\n',
    )
    symbolSize: Optional[Any] = Field(
        '[10, 15]',
        description='\n\n<p>Size of the arrows at two ends. The first is the width perpendicular to the axis, the next is the width parallel to the axis.</p>\n',
    )
    symbolOffset: Optional[Union[Any, float]] = Field(
        '[0, 0]',
        description='\n\n<p>Arrow offset of axis. If is array, the first number is the offset of the arrow at the beginning, and the second number is the offset of the arrow at the end. If is number, it means the arrows have the same offset.</p>\n',
    )
    lineStyle: Optional[LineStyle28] = Field(None, description='')


class LineStyle29(BaseModel):
    """
    <p>Line style of axis ticks.</p>

    """

    color: Optional[Any] = Field(
        None,
        description='<p>Color of axis label is set to be <a href="#.axisLine.lineStyle.color">axisLine.lineStyle.color</a> by default.</p>\n',
    )
    width: Optional[float] = Field(1, description='\n\n<p>axisTick line width.</p>\n')
    type: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>line type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">dashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\ntype: [5, 10],\n\ndashOffset: 5\n}\n</code></pre>\n',
    )
    dashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">type</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    cap: Optional[str] = Field(
        'butt',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To specify how to draw the end points of the line.\nPossible values are:</p>\n<ul>\n<li><code class="codespan">&#39;butt&#39;</code>: The ends of lines are squared off at the endpoints.</li>\n<li><code class="codespan">&#39;round&#39;</code>: The ends of lines are rounded.</li>\n<li><code class="codespan">&#39;square&#39;</code>: The ends of lines are squared off by adding a box with an equal width and half the height of the line&#39;s thickness.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;butt&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineCap" target="_blank">lineCap</a> for more details.</p>\n',
    )
    join: Optional[str] = Field(
        'bevel',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To determine the shape used to join two line segments where they meet.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;bevel&#39;</code>: Fills an additional triangular area between the common endpoint of connected segments, and the separate outside rectangular corners of each segment.</li>\n<li><code class="codespan">&#39;round&#39;</code>: Rounds off the corners of a shape by filling an additional sector of disc centered at the common endpoint of connected segments. The radius for these rounded corners is equal to the line width.</li>\n<li><code class="codespan">&#39;miter&#39;</code>: Connected segments are joined by extending their outside edges to connect at a single point, with the effect of filling an additional lozenge-shaped area. This setting is affected by the \n<code class="codespan">miterLimit</code>\nproperty.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;bevel&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineJoin" target="_blank">lineJoin</a> for more details.</p>\n',
    )
    miterLimit: Optional[float] = Field(
        10,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the miter limit ratio. Only works when \n<code class="codespan">join</code>\n is set as <code class="codespan">miter</code>.</p>\n<p>Default value is <code class="codespan">10</code>. Negative、<code class="codespan">0</code>、<code class="codespan">Infinity</code> and <code class="codespan">NaN</code> values are ignored.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/miterLimit" target="_blank">miterLimit</a> for more details.</p>\n',
    )
    shadowBlur: Optional[float] = Field(
        None,
        description='\n\n<p>Size of shadow blur. This attribute should be used along with <code class="codespan">shadowColor</code>,<code class="codespan">shadowOffsetX</code>, <code class="codespan">shadowOffsetY</code> to set shadow to component.</p>\n<p>For example:</p>\n<pre><code class="lang-ts">{\n    shadowColor: &#39;rgba(0, 0, 0, 0.5)&#39;,\n    shadowBlur: 10\n}\n</code></pre>\n',
    )
    shadowColor: Optional[Any] = Field(
        None,
        description='\n\n<p>Shadow color. Support same format as <code class="codespan">color</code>.</p>\n',
    )
    shadowOffsetX: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the horizontal direction of shadow.</p>\n',
    )
    shadowOffsetY: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the vertical direction of shadow.</p>\n',
    )
    opacity: Optional[float] = Field(
        None,
        description='\n\n<p>Opacity of the component. Supports value from 0 to 1, and the component will not be drawn when set to 0.</p>\n\n',
    )


class AxisTick4(BaseModel):
    """
    <p>Settings related to axis tick.</p>

    """

    show: Optional[bool] = Field(
        True,
        description='\n\n<p>Set this to <code class="codespan">false</code> to prevent the axis tick from showing.</p>\n',
    )
    length: Optional[float] = Field(
        5, description='\n\n<p>The length of the axis tick.</p>\n'
    )
    lineStyle: Optional[LineStyle29] = Field(
        None, description='<p>Line style of axis ticks.</p>\n'
    )


class _StyleName17(_StyleName5):
    pass


class Rich17(BaseModel):
    """
        <p>&quot;Rich text styles&quot; can be defined in this <code class="codespan">rich</code> property. For example:</p>
    <pre><code class="lang-ts">label: {
        // Styles defined in &#39;rich&#39; can be applied to some fragments
        // of text by adding some markers to those fragment, like
        // `{styleName|text content text content}`.
        // `&#39;\n&#39;` is the newline character.
        formatter: [
            &#39;{a|Style &quot;a&quot; is applied to this snippet}&#39;
            &#39;{b|Style &quot;b&quot; is applied to this snippet}This snippet use default style{x|use style &quot;x&quot;}&#39;
        ].join(&#39;\n&#39;),

        rich: {
            a: {
                color: &#39;red&#39;,
                lineHeight: 10
            },
            b: {
                backgroundColor: {
                    image: &#39;xxx/xxx.jpg&#39;
                },
                height: 40
            },
            x: {
                fontSize: 18,
                fontFamily: &#39;Microsoft YaHei&#39;,
                borderColor: &#39;#449933&#39;,
                borderRadius: 4
            },
            ...
        }
    }
    </code></pre>
    <p>For more details, see <a href="tutorial.html#Rich%20Text" target="_blank">Rich Text</a> please.</p>

    """

    _style_name_: Optional[_StyleName17] = Field(
        None, alias='<style_name>', description=''
    )


class AxisLabel4(BaseModel):
    """
    <p>Settings related to axis label.</p>

    """

    show: Optional[bool] = Field(
        True,
        description='\n\n<p>Set this to <code class="codespan">false</code> to prevent the axis label from appearing.</p>\n',
    )
    rotate: Optional[float] = Field(
        0,
        description='\n\n<p>Rotation degree of axis label, which is especially useful when there is no enough space for category axis.</p>\n<p>Rotation degree is from -90 to 90.</p>\n',
    )
    margin: Optional[float] = Field(
        8,
        description='\n\n<p>The margin between the axis label and the axis line.</p>\n',
    )
    formatter: Optional[Union[str, Any]] = Field(
        None,
        description='<p>Formatter of axis label, which supports string template and callback function.</p>\n<p>Example:</p>\n<pre><code class="lang-ts">// Use string template; template variable is the default label of axis {value}\nformatter: &#39;{value} kg&#39;\n// Use callback.\nformatter: function (value, index) {\n    return value + &#39;kg&#39;;\n}\n</code></pre>\n<hr>\n<p>For axes of time <a href="#.type">type</a>: <code class="codespan">&#39;time&#39;</code>, <code class="codespan">formatter</code> supports the following forms:</p>\n<ul>\n<li><strong>String Templates</strong>: an easy and fast way to make frequently used date/time template, formed in <code class="codespan">string</code></li>\n<li><strong>Callback Functions</strong>: customized formatter to make complex format, formed in <code class="codespan">Function</code></li>\n<li><strong>Cascading Templates</strong>: to adopt different formatters for different time granularity, formed in <code class="codespan">object</code></li>\n</ul>\n<p>Next, we are going to introduce these three forms one by one.</p>\n<p><strong> String Templates </strong></p>\n<p>Using string templates is an easy way to format date/time with frequently used formats. If it can be used to make what you want, you are advised to do so. If not, you could then consider the others. Supported formats are:</p>\n<table>\n<thead>\n<tr>\n<th>Group</th>\n<th>Template</th>\n<th>Value (EN)</th>\n<th>Value (ZH)</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n<td>Year</td>\n<td>{yyyy}</td>\n<td>e.g., 2020, 2021, ...</td>\n<td>例：2020, 2021, ...</td>\n</tr>\n<tr>\n<td></td>\n<td>{yy}</td>\n<td>00-99</td>\n<td>00-99</td>\n</tr>\n<tr>\n<td>Quarter</td>\n<td>{Q}</td>\n<td>1, 2, 3, 4</td>\n<td>1, 2, 3, 4</td>\n</tr>\n<tr>\n<td>Month</td>\n<td>{MMMM}</td>\n<td>e.g., January, February, ...</td>\n<td>一月、二月、……</td>\n</tr>\n<tr>\n<td></td>\n<td>{MMM}</td>\n<td>e.g., Jan, Feb, ...</td>\n<td>1月、2月、……</td>\n</tr>\n<tr>\n<td></td>\n<td>{MM}</td>\n<td>01-12</td>\n<td>01-12</td>\n</tr>\n<tr>\n<td></td>\n<td>{M}</td>\n<td>1-12</td>\n<td>1-12</td>\n</tr>\n<tr>\n<td>Day of Month</td>\n<td>{dd}</td>\n<td>01-31</td>\n<td>01-31</td>\n</tr>\n<tr>\n<td></td>\n<td>{d}</td>\n<td>1-31</td>\n<td>1-31</td>\n</tr>\n<tr>\n<td>Day of Week</td>\n<td>{eeee}</td>\n<td>Sunday, Monday, Tuesday, Wednesday, Thursday, Friday, Saturday</td>\n<td>星期日、星期一、星期二、星期三、星期四、星期五、星期六</td>\n</tr>\n<tr>\n<td></td>\n<td>{ee}</td>\n<td>Sun, Mon, Tues, Wed, Thu, Fri, Sat</td>\n<td>日、一、二、三、四、五、六</td>\n</tr>\n<tr>\n<td></td>\n<td>{e}</td>\n<td>1-54</td>\n<td>1-54</td>\n</tr>\n<tr>\n<td>Hour</td>\n<td>{HH}</td>\n<td>00-23</td>\n<td>00-23</td>\n</tr>\n<tr>\n<td></td>\n<td>{H}</td>\n<td>0-23</td>\n<td>0-23</td>\n</tr>\n<tr>\n<td></td>\n<td>{hh}</td>\n<td>01-12</td>\n<td>01-12</td>\n</tr>\n<tr>\n<td></td>\n<td>{h}</td>\n<td>1-12</td>\n<td>1-12</td>\n</tr>\n<tr>\n<td>Minute</td>\n<td>{mm}</td>\n<td>00-59</td>\n<td>00-59</td>\n</tr>\n<tr>\n<td></td>\n<td>{m}</td>\n<td>0-59</td>\n<td>0-59</td>\n</tr>\n<tr>\n<td>Second</td>\n<td>{ss}</td>\n<td>00-59</td>\n<td>00-59</td>\n</tr>\n<tr>\n<td></td>\n<td>{s}</td>\n<td>0-59</td>\n<td>0-59</td>\n</tr>\n<tr>\n<td>Millisecond</td>\n<td>{SSS}</td>\n<td>000-999</td>\n<td>000-999</td>\n</tr>\n<tr>\n<td></td>\n<td>{S}</td>\n<td>0-999</td>\n<td>0-999</td>\n</tr>\n</tbody>\n</table>\n<blockquote>\n<p>Templates of other languages can be found in <a href="https://github.com/apache/echarts/tree/master/src/i18n" target="_blank">the language package</a>. Please refer to <a href="api.html#echarts.registerLocale" target="_blank">echarts.registerLocale</a> to register a language.</p>\n</blockquote>\n<p>Example:</p>\n<pre><code class="lang-ts">formatter: &#39;{yyyy}-{MM}-{dd}&#39; // gets labels like &#39;2020-12-02&#39;\nformatter: &#39;Day {d}&#39; // gets labels like &#39;Day 2&#39;\n</code></pre>\n<p><strong> Callback Functions </strong></p>\n<p>Callback functions can be used to get different formats for different axis tick values. Sometimes, if you have complex date/time formatting requirement, third-party libraries like <a href="https://momentjs.com/" target="_blank">Moment.js</a> or <a href="https://date-fns.org/" target="_blank">date-fns</a> can be used to return formatted labels.</p>\n<p>Example:</p>\n<pre><code class="lang-ts">// Use callback function; function parameters are axis index\nformatter: function (value, index) {\n    // Formatted to be month/day; display year only in the first label\n    var date = new Date(value);\n    var texts = [(date.getMonth() + 1), date.getDate()];\n    if (index === 0) {\n        texts.unshift(date.getYear());\n    }\n    return texts.join(&#39;/&#39;);\n}\n</code></pre>\n<p><strong> Cascading Templates </strong></p>\n<p>Sometimes, we wish to use different formats for different time granularity. For example, in a quarter-year chart, we may wish to see the month name with the first date of the month, while see the date name with others. This can be made with:</p>\n<p>Example:</p>\n<pre><code class="lang-ts">formatter: {\n    month: &#39;{MMMM}&#39;, // Jan, Feb, ...\n    day: &#39;{d}&#39; // 1, 2, ...\n}\n</code></pre>\n<p>Supported levels and their default formatters are:</p>\n<pre><code class="lang-ts">{\n    year: &#39;{yyyy}&#39;,\n    month: &#39;{MMM}&#39;,\n    day: &#39;{d}&#39;,\n    hour: &#39;{HH}:{mm}&#39;,\n    minute: &#39;{HH}:{mm}&#39;,\n    second: &#39;{HH}:{mm}:{ss}&#39;,\n    millisecond: &#39;{hh}:{mm}:{ss} {SSS}&#39;,\n    none: &#39;{yyyy}-{MM}-{dd} {hh}:{mm}:{ss} {SSS}&#39;\n}\n</code></pre>\n<p>Let&#39;s take <code class="codespan">day</code> for example. When a tick value is <code class="codespan">0</code> for its hour, minute, second, and millisecond, <code class="codespan">day</code> level will be used to make formatter. <code class="codespan">none</code> is used when no other level fulfills, which is for tick values with millisecond values other than <code class="codespan">0</code>.</p>\n<p><strong> Rich Text </strong></p>\n<p>The above three forms all support rich text, so it can be used to make some complex effects.</p>\n<p>Example:</p>\n<pre><code class="lang-ts">xAxis: {\n    type: &#39;time&#39;,\n    axisLabel: {\n        formatter: {\n            // Display year and month information on the first data of a year\n            year: &#39;{yearStyle|{yyyy}}\\n{monthStyle|{MMM}}&#39;,\n            month: &#39;{monthStyle|{MMM}}&#39;\n        },\n        rich: {\n            yearStyle: {\n                // Make yearly text more standing out\n                color: &#39;#000&#39;,\n                fontWeight: &#39;bold&#39;\n            },\n            monthStyle: {\n                color: &#39;#999&#39;\n            }\n        }\n    }\n},\n</code></pre>\n<p>The above example can also be made with a callback function:</p>\n<p>Example:</p>\n<pre><code class="lang-ts">xAxis: {\n    type: &#39;time&#39;,\n    axisLabel: {\n        formatter: function (value) {\n            const date = new Date(value);\n            const yearStart = new Date(value);\n            yearStart.setMonth(0);\n            yearStart.setDate(1);\n            yearStart.setHours(0);\n            yearStart.setMinutes(0);\n            yearStart.setSeconds(0);\n            yearStart.setMilliseconds(0);\n            // Whether a tick value is the start of a year\n            if (date.getTime() === yearStart.getTime()) {\n                return &#39;{year|&#39; + date.getFullYear() + &#39;}\\n&#39;\n                    + &#39;{month|&#39; + (date.getMonth() + 1) + &#39;月}&#39;;\n            }\n            else {\n                return &#39;{month|&#39; + (date.getMonth() + 1) + &#39;月}&#39;\n            }\n        },\n        rich: {\n            year: {\n                color: &#39;#000&#39;,\n                fontWeight: &#39;bold&#39;\n            },\n            month: {\n                color: &#39;#999&#39;\n            }\n        }\n    }\n},\n</code></pre>\n',
    )
    showMinLabel: Optional[bool] = Field(
        None,
        description='\n\n<p>Whether to show the label of the min tick. Optional values: <code class="codespan">true</code>, <code class="codespan">false</code>, <code class="codespan">null</code>. It is auto determined by default, that is, if labels are overlapped, the label of the min tick will not be displayed.</p>\n',
    )
    showMaxLabel: Optional[bool] = Field(
        None,
        description='\n\n<p>Whether to show the label of the max tick. Optional values: <code class="codespan">true</code>, <code class="codespan">false</code>, <code class="codespan">null</code>. It is auto determined by default, that is, if labels are overlapped, the label of the max tick will not be displayed.</p>\n',
    )
    hideOverlap: Optional[bool] = Field(
        None,
        description='\n\n\n\n<blockquote>\n<p>Since <code class="codespan">v5.2.0</code></p>\n</blockquote>\n<p>Whether to hide overlapped labels.</p>\n',
    )
    color: Optional[Union[Any, Any]] = Field(
        None,
        description='\n\n<p>Color of axis label is set to be <a href="#.axisLine.lineStyle.color">axisLine.lineStyle.color</a> by default. Callback function is supported, in the following format:</p>\n<pre><code class="lang-ts">(val: string) =&gt; Color\n</code></pre>\n<p>Parameter is the text of label, and return value is the color. See the following example:</p>\n<pre><code class="lang-ts">textStyle: {\n    color: function (value, index) {\n        return value &gt;= 0 ? &#39;green&#39; : &#39;red&#39;;\n    }\n}\n</code></pre>\n',
    )
    fontStyle: Optional[str] = Field(
        'normal',
        description='\n\n<p> font style.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;italic&#39;</code></li>\n<li><code class="codespan">&#39;oblique&#39;</code></li>\n</ul>\n',
    )
    fontWeight: Optional[Union[str, float]] = Field(
        'normal',
        description='\n\n<p> font thick weight.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;bold&#39;</code></li>\n<li><code class="codespan">&#39;bolder&#39;</code></li>\n<li><code class="codespan">&#39;lighter&#39;</code></li>\n<li>100 | 200 | 300 | 400...</li>\n</ul>\n',
    )
    fontFamily: Optional[str] = Field(
        'sans-serif',
        description='\n\n<p> font family.</p>\n<p>Can also be &#39;serif&#39; , &#39;monospace&#39;, ...</p>\n',
    )
    fontSize: Optional[float] = Field(12, description='\n\n<p> font size.</p>\n')
    align: Optional[str] = Field(
        None,
        description='\n\n<p>Horizontal alignment of text, automatic by default.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;left&#39;</code></li>\n<li><code class="codespan">&#39;center&#39;</code></li>\n<li><code class="codespan">&#39;right&#39;</code></li>\n</ul>\n<p>If <code class="codespan">align</code> is not set in <code class="codespan">rich</code>, <code class="codespan">align</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    align: right,\n    rich: {\n        a: {\n            // `align` is not set, then it will be right\n        }\n    }\n}\n</code></pre>\n',
    )
    verticalAlign: Optional[str] = Field(
        None,
        description='\n\n<p>Vertical alignment of text, automatic by default.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;top&#39;</code></li>\n<li><code class="codespan">&#39;middle&#39;</code></li>\n<li><code class="codespan">&#39;bottom&#39;</code></li>\n</ul>\n<p>If <code class="codespan">verticalAlign</code> is not set in <code class="codespan">rich</code>, <code class="codespan">verticalAlign</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    verticalAlign: bottom,\n    rich: {\n        a: {\n            // `verticalAlign` is not set, then it will be bottom\n        }\n    }\n}\n</code></pre>\n',
    )
    lineHeight: Optional[float] = Field(
        None,
        description='\n\n<p>Line height of the text fragment.</p>\n<p>If <code class="codespan">lineHeight</code> is not set in <code class="codespan">rich</code>, <code class="codespan">lineHeight</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    lineHeight: 56,\n    rich: {\n        a: {\n            // `lineHeight` is not set, then it will be 56\n        }\n    }\n}\n</code></pre>\n',
    )
    backgroundColor: Optional[Union[str, Any]] = Field(
        'transparent',
        description='\n\n<p>Background color of the text fragment.</p>\n<p>Can be color string, like <code class="codespan">&#39;#123234&#39;</code>, <code class="codespan">&#39;red&#39;</code>, <code class="codespan">&#39;rgba(0,23,11,0.3)&#39;</code>.</p>\n<p>Or image can be used, for example:</p>\n<pre><code class="lang-ts">backgroundColor: {\n    image: &#39;xxx/xxx.png&#39;\n    // It can be URL of a image,\n    // or dataURI,\n    // or HTMLImageElement,\n    // or HTMLCanvasElement.\n}\n</code></pre>\n<p><code class="codespan">width</code> or <code class="codespan">height</code> can be specified when using background image, or\nauto adapted by default.</p>\n',
    )
    borderColor: Optional[Any] = Field(
        None, description='\n\n<p>Border color of the text fragment.</p>\n'
    )
    borderWidth: Optional[float] = Field(
        0, description='\n\n<p>Border width of the text fragment.</p>\n'
    )
    borderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>the text fragment border type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">borderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\nborderType: [5, 10],\n\nborderDashOffset: 5\n}\n</code></pre>\n',
    )
    borderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">borderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    borderRadius: Optional[float] = Field(
        0, description='\n\n<p>Border radius of the text fragment.</p>\n'
    )
    padding: Optional[Union[float, Any]] = Field(
        0,
        description='\n\n<p>Padding of the text fragment, for example:</p>\n<ul>\n<li><code class="codespan">padding: [3, 4, 5, 6]</code>: represents padding of <code class="codespan">[top, right, bottom, left]</code>.</li>\n<li><code class="codespan">padding: 4</code>: represents <code class="codespan">padding: [4, 4, 4, 4]</code>.</li>\n<li><code class="codespan">padding: [3, 4]</code>: represents <code class="codespan">padding: [3, 4, 3, 4]</code>.</li>\n</ul>\n<p>Notice, <code class="codespan">width</code> and <code class="codespan">height</code> specifies the width and height of the content, without <code class="codespan">padding</code>.</p>\n',
    )
    shadowColor: Optional[Any] = Field(
        'transparent', description='\n\n<p>Shadow color of the text block.</p>\n'
    )
    shadowBlur: Optional[float] = Field(
        0, description='\n\n<p>Show blur of the text block.</p>\n'
    )
    shadowOffsetX: Optional[float] = Field(
        0, description='\n\n<p>Shadow X offset of the text block.</p>\n'
    )
    shadowOffsetY: Optional[float] = Field(
        0, description='\n\n<p>Shadow Y offset of the text block.</p>\n'
    )
    width: Optional[float] = Field(
        None, description='\n\n<p>Width of text block.</p>\n'
    )
    height: Optional[float] = Field(
        None, description='\n\n<p>Height of text block.</p>\n'
    )
    textBorderColor: Optional[Any] = Field(
        None, description='\n\n<p>Stroke color of the text.</p>\n'
    )
    textBorderWidth: Optional[float] = Field(
        None, description='\n\n<p>Stroke line width of the text.</p>\n'
    )
    textBorderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>Stroke line type of the text.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">textBorderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\ntextBorderType: [5, 10],\n\ntextBorderDashOffset: 5\n}\n</code></pre>\n',
    )
    textBorderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">textBorderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    textShadowColor: Optional[Any] = Field(
        'transparent', description='\n\n<p>Shadow color of the text itself.</p>\n'
    )
    textShadowBlur: Optional[float] = Field(
        0, description='\n\n<p>Shadow blue of the text itself.</p>\n'
    )
    textShadowOffsetX: Optional[float] = Field(
        0, description='\n\n<p>Shadow X offset of the text itself.</p>\n'
    )
    textShadowOffsetY: Optional[float] = Field(
        0, description='\n\n<p>Shadow Y offset of the text itself.</p>\n'
    )
    overflow: Optional[str] = Field(
        'none',
        description='\n\n<p>Determine how to display the text when it&#39;s overflow. Available when <code class="codespan">width</code> is set.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the text and trailing with <code class="codespan">ellipsis</code>.</li>\n<li><code class="codespan">&#39;break&#39;</code> Break by word</li>\n<li><code class="codespan">&#39;breakAll&#39;</code> Break by character.</li>\n</ul>\n',
    )
    ellipsis: Optional[str] = Field(
        '...',
        description='<p>Ellipsis to be displayed when <code class="codespan">overflow</code> is set to <code class="codespan">truncate</code>.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the overflow lines.</li>\n</ul>\n',
    )
    rich: Optional[Rich17] = Field(
        None,
        description='<p>&quot;Rich text styles&quot; can be defined in this <code class="codespan">rich</code> property. For example:</p>\n<pre><code class="lang-ts">label: {\n    // Styles defined in &#39;rich&#39; can be applied to some fragments\n    // of text by adding some markers to those fragment, like\n    // `{styleName|text content text content}`.\n    // `&#39;\\n&#39;` is the newline character.\n    formatter: [\n        &#39;{a|Style &quot;a&quot; is applied to this snippet}&#39;\n        &#39;{b|Style &quot;b&quot; is applied to this snippet}This snippet use default style{x|use style &quot;x&quot;}&#39;\n    ].join(&#39;\\n&#39;),\n\n    rich: {\n        a: {\n            color: &#39;red&#39;,\n            lineHeight: 10\n        },\n        b: {\n            backgroundColor: {\n                image: &#39;xxx/xxx.jpg&#39;\n            },\n            height: 40\n        },\n        x: {\n            fontSize: 18,\n            fontFamily: &#39;Microsoft YaHei&#39;,\n            borderColor: &#39;#449933&#39;,\n            borderRadius: 4\n        },\n        ...\n    }\n}\n</code></pre>\n<p>For more details, see <a href="tutorial.html#Rich%20Text" target="_blank">Rich Text</a> please.</p>\n',
    )


class LineStyle30(LineStyle6):
    pass


class SplitLine4(BaseModel):
    """
    <p>Split line of axis in <a href="#grid">grid</a> area.</p>

    """

    show: Optional[bool] = Field(
        True,
        description='\n\n<p>Set this to <code class="codespan">false</code> to prevent the splitLine from showing.\n<code class="codespan">value</code> type axes are shown by default, while <code class="codespan">category</code> type axes are hidden.</p>\n',
    )
    lineStyle: Optional[LineStyle30] = Field(None, description='')


class AreaStyle4(AreaStyle):
    """
    <p>Split area style.</p>

    """

    pass


class SplitArea4(BaseModel):
    """
    <p>Split area of axis in <a href="#grid">grid</a> area, not shown by default.</p>

    """

    show: Optional[bool] = Field(
        True,
        description='\n\n<p>Set this to <code class="codespan">true</code> to show the splitArea.</p>\n',
    )
    areaStyle: Optional[AreaStyle4] = Field(
        None, description='<p>Split area style.</p>\n'
    )


class IndicatorItem(BaseModel):
    name: Optional[str] = Field(None, description='<p>Indicator&#39;s name.</p>\n')
    max: Optional[float] = Field(
        None,
        description='\n\n<p>The maximum value of indicator. It is an optional configuration, but we recommend to set it manually.</p>\n',
    )
    min: Optional[float] = Field(
        None,
        description='\n\n<p>The minimum value of indicator. It it an optional configuration, with default value of 0.</p>\n',
    )
    color: Optional[str] = Field(
        None, description='\n\n<p>Specfy a color of the indicator.</p>\n'
    )


class Radar(BaseModel):
    """
        <p>Coordinate for <a href="#series-radar">radar charts</a>. This component is equal to the polar component in ECharts 2. Because the polar component in the echarts 3 is reconstructed to be the standard polar coordinate component, this component is renamed to be radar to avoid confusion.</p>
    <p>Radar chart coordinate is different from polar coordinate, in that every axis indicator of the radar chart coordinate is an individual dimension. The style of indicator coordinate axis could be configured through the following configuration items, including <a href="#radar.name">name</a>, <a href="#radar.axisLine">axisLine</a>, <a href="#radar.axisTick">axisTick</a>, <a href="#radar.axisLabel">axisLabel</a>, <a href="#radar.splitLine">splitLine</a>, <a href="#radar.splitArea">splitArea</a>.</p>
    <p>Here is a custom example of radar component.</p>
    <iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=doc-example/radar&edit=1&reset=1" width="400" height="400"></iframe>




    """

    id: Optional[str] = Field(
        None,
        description='<p>Component ID, not specified by default. If specified, it can be used to refer the component in option or API.</p>\n',
    )
    zlevel: Optional[float] = Field(
        0,
        description='<p><code class="codespan">zlevel</code> value of all graphical elements in .</p>\n<p><code class="codespan">zlevel</code> is used to make layers with Canvas. Graphical elements with different <code class="codespan">zlevel</code> values will be placed in different Canvases, which is a common optimization technique. We can put those frequently changed elements (like those with animations) to a separate <code class="codespan">zlevel</code>. Notice that too many Canvases will increase memory cost, and should be used carefully on mobile phones to avoid crash.</p>\n<p>Canvases with bigger <code class="codespan">zlevel</code> will be placed on Canvases with smaller <code class="codespan">zlevel</code>.</p>\n',
    )
    z: Optional[float] = Field(
        2,
        description='<p><code class="codespan">z</code> value of all graphical elements in , which controls order of drawing graphical components. Components with smaller <code class="codespan">z</code> values may be overwritten by those with larger <code class="codespan">z</code> values.</p>\n<p><code class="codespan">z</code> has a lower priority to <code class="codespan">zlevel</code>, and will not create new Canvas.</p>\n',
    )
    center: Optional[Any] = Field(
        "['50%', '50%']",
        description='\n\n<p>Center position of , the first of which is the horizontal position, and the second is the vertical position.</p>\n<p>Percentage is supported. When set in percentage, the item is relative to the container width, and the second item to the height.</p>\n<p><strong>Example: </strong></p>\n<pre><code>// Set to absolute pixel values\ncenter: [400, 300]\n// Set to relative percent\ncenter: [&#39;50%&#39;, &#39;50%&#39;]\n</code></pre>',
    )
    radius: Optional[Union[float, str, Any]] = Field(
        '75%',
        description='\n\n<p>Radius of . Value can be:</p>\n<ul>\n<li><code class="codespan">number</code>: Specify outside radius directly.</li>\n<li><code class="codespan">string</code>: For example, <code class="codespan">&#39;20%&#39;</code>, means that the outside radius is 20% of the viewport size (the little one between width and height of the chart container).</li>\n</ul>\n<ul>\n<li><code class="codespan">Array.&lt;number|string&gt;</code>: The first item specifies the inside radius, and the second item specifies the outside radius. Each item follows the definitions above.</li>\n</ul>\n',
    )
    startAngle: Optional[float] = Field(
        90,
        description='<p>The start angle of coordinate, which is the angle of the first indicator axis.</p>\n',
    )
    axisName: Optional[AxisName] = Field(
        None, description='<p>Name options for radar indicators.</p>\n'
    )
    nameGap: Optional[float] = Field(
        15,
        description='\n\n<p>Distance between the indicator&#39;s name and axis.</p>\n',
    )
    splitNumber: Optional[float] = Field(
        5, description='\n\n<p>Segments of indicator axis.</p>\n'
    )
    shape: Optional[str] = Field(
        'polygon',
        description='\n\n<p>Radar render type, in which <code class="codespan">&#39;polygon&#39;</code> and <code class="codespan">&#39;circle&#39;</code> are supported.</p>\n',
    )
    scale: Optional[bool] = Field(
        False,
        description='\n\n<p>Whether to prevent calculating the scaling relative to zero. If it is set to be <code class="codespan">true</code>, the coordinate tick would not compulsorily contain zero value, which is usually useful in scatter diagram of double numerical values axis.</p>\n',
    )
    silent: Optional[bool] = Field(
        False,
        description='<p>Set this to <code class="codespan">true</code>, to prevent interaction with the axis.</p>\n',
    )
    triggerEvent: Optional[bool] = Field(
        False,
        description='<p>Set this to <code class="codespan">true</code> to enable triggering events.</p>\n<p>Parameters of the event include:</p>\n<pre><code class="lang-ts">{\n    // Component type: xAxis, yAxis, radiusAxis, angleAxis\n    // Each of which has an attribute for index, e.g., xAxisIndex for xAxis\n    componentType: string,\n    // Value on axis before being formatted.\n    // Click on value label to trigger event.\n    value: &#39;&#39;,\n    // Name of axis.\n    // Click on laben name to trigger event.\n    name: &#39;&#39;\n}\n</code></pre>\n',
    )
    axisLine: Optional[AxisLine4] = Field(
        None, description='<p>Settings related to axis line.</p>\n'
    )
    axisTick: Optional[AxisTick4] = Field(
        None, description='<p>Settings related to axis tick.</p>\n'
    )
    axisLabel: Optional[AxisLabel4] = Field(
        None, description='<p>Settings related to axis label.</p>\n'
    )
    splitLine: Optional[SplitLine4] = Field(
        None,
        description='<p>Split line of axis in <a href="#grid">grid</a> area.</p>\n',
    )
    splitArea: Optional[SplitArea4] = Field(
        None,
        description='<p>Split area of axis in <a href="#grid">grid</a> area, not shown by default.</p>\n',
    )
    indicator: Optional[List[IndicatorItem]] = Field(
        None,
        description='<p>Indicator of radar chart, which is used to assign multiple variables(dimensions) in radar chart. Here is the example.</p>\n<pre><code class="lang-ts">indicator: [\n   { name: &#39;Sales (sales) &#39;, max: 6500},\n   { name: &#39;Administration (Administration) &#39;, max: 16000, color: &#39;red&#39;}, // Set the indicator as &#39;red&#39;\n   { name: &#39;Information Technology (Information Technology) &#39;, max: 30000},\n   { name: &#39;Customer Support (Customer Support) &#39;, max: 38000},\n   { name: &#39;Development (Development) &#39;, max: 52000},\n   { name: &#39;Marketing (Marketing) &#39;, max: 25000}\n]\n</code></pre>\n',
    )


class DataZoomItem(BaseModel):
    """
        <p><strong>dataZoomInside</strong></p>
    <p>Data zoom component of <em>inside</em> type.</p>
    <p>Refer to <a href="#dataZoom">dataZoom</a> for more information.</p>
    <p>The <em>inside</em> means it&#39;s inside the coordinates.</p>
    <ul>
    <li>Translation: data area can be translated when moving in coordinates.</li>
    <li>Scaling:<ul>
    <li>PC: when mouse rolls (similar with touch pad) in coordinates.</li>
    <li>Mobile: when touches and moved with two fingers in coordinates on touch screens.</li>
    </ul>
    </li>
    </ul>
    <p><br>
    <br></p>

    """

    type: Optional[str] = Field('inside', description='')
    id: Optional[str] = Field(
        None,
        description='<p>Component ID, not specified by default. If specified, it can be used to refer the component in option or API.</p>\n',
    )
    disabled: Optional[bool] = Field(
        False, description='\n\n<p>Whether disable inside zoom.</p>\n'
    )
    xAxisIndex: Optional[Union[float, Any]] = Field(
        None,
        description='<p>Specify which <a href="#xAxis">xAxis</a> is/are controlled by the <code class="codespan">dataZoom-inside</code> when <a href="#grid">catesian coordinate system</a> is used.</p>\n<p>By default the first <code class="codespan">xAxis</code> that parallel to <code class="codespan">dataZoom</code> are controlled when <a href="#dataZoom-inside.orient">dataZoom-inside.orient</a> is set as <code class="codespan">&#39;horizontal&#39;</code>. But it is recommended to specify it explicitly but not use default value.</p>\n<p>If it is set as a single <code class="codespan">number</code>, one axis is controlled, while if it is set as an <code class="codespan">Array</code> , multiple axes are controlled.</p>\n<p>For example:</p>\n<pre><code class="lang-javascript">option: {\n    xAxis: [\n        {...}, // The first xAxis\n        {...}, // The second xAxis\n        {...}, // The third xAxis\n        {...}  // The fourth xAxis\n    ],\n    dataZoom: [\n        { // The first dataZoom component\n            xAxisIndex: [0, 2] // Indicates that this dataZoom component\n                                     // controls the first and the third xAxis\n        },\n        { // The second dataZoom component\n            xAxisIndex: 3      // indicates that this dataZoom component\n                                     // controls the fourth xAxis\n        }\n    ]\n}\n</code></pre>\n',
    )
    yAxisIndex: Optional[Union[float, Any]] = Field(
        None,
        description='<p>Specify which <a href="#yAxis">yAxis</a> is/are controlled by the <code class="codespan">dataZoom-inside</code> when <a href="#grid">catesian coordinate system</a> is used.</p>\n<p>By default the first <code class="codespan">yAxis</code> that parallel to <code class="codespan">dataZoom</code> are controlled when <a href="#dataZoom-inside.orient">dataZoom-inside.orient</a> is set as <code class="codespan">&#39;vertical&#39;</code>. But it is recommended to specify it explicitly but not use default value.</p>\n<p>If it is set as a single <code class="codespan">number</code>, one axis is controlled, while if it is set as an <code class="codespan">Array</code> , multiple axes are controlled.</p>\n<p>For example:</p>\n<pre><code class="lang-javascript">option: {\n    yAxis: [\n        {...}, // The first yAxis\n        {...}, // The second yAxis\n        {...}, // The third yAxis\n        {...}  // The fourth yAxis\n    ],\n    dataZoom: [\n        { // The first dataZoom component\n            yAxisIndex: [0, 2] // Indicates that this dataZoom component\n                                     // controls the first and the third yAxis\n        },\n        { // The second dataZoom component\n            yAxisIndex: 3      // indicates that this dataZoom component\n                                     // controls the fourth yAxis\n        }\n    ]\n}\n</code></pre>\n',
    )
    radiusAxisIndex: Optional[Union[float, Any]] = Field(
        None,
        description='<p>Specify which <a href="#radiusAxis">radiusAxis</a> is/are controlled by the <code class="codespan">dataZoom-inside</code> when <a href="#polar">polar coordinate system</a> is used.</p>\n<p>If it is set as a single <code class="codespan">number</code>, one axis is controlled, while if it is set as an <code class="codespan">Array</code> , multiple axes are controlled.</p>\n<p>For example:</p>\n<pre><code class="lang-javascript">option: {\n    radiusAxis: [\n        {...}, // The first radiusAxis\n        {...}, // The second radiusAxis\n        {...}, // The third radiusAxis\n        {...}  // The fourth radiusAxis\n    ],\n    dataZoom: [\n        { // The first dataZoom component\n            radiusAxisIndex: [0, 2] // Indicates that this dataZoom component\n                                     // controls the first and the third radiusAxis\n        },\n        { // The second dataZoom component\n            radiusAxisIndex: 3      // indicates that this dataZoom component\n                                     // controls the fourth radiusAxis\n        }\n    ]\n}\n</code></pre>\n',
    )
    angleAxisIndex: Optional[Union[float, Any]] = Field(
        None,
        description='<p>Specify which <a href="#angleAxis">angleAxis</a> is/are controlled by the <code class="codespan">dataZoom-inside</code> when <a href="#polar">polar coordinate system</a> is used.</p>\n<p>If it is set as a single <code class="codespan">number</code>, one axis is controlled, while if it is set as an <code class="codespan">Array</code> , multiple axes are controlled.</p>\n<p>For example:</p>\n<pre><code class="lang-javascript">option: {\n    angleAxis: [\n        {...}, // The first angleAxis\n        {...}, // The second angleAxis\n        {...}, // The third angleAxis\n        {...}  // The fourth angleAxis\n    ],\n    dataZoom: [\n        { // The first dataZoom component\n            angleAxisIndex: [0, 2] // Indicates that this dataZoom component\n                                     // controls the first and the third angleAxis\n        },\n        { // The second dataZoom component\n            angleAxisIndex: 3      // indicates that this dataZoom component\n                                     // controls the fourth angleAxis\n        }\n    ]\n}\n</code></pre>\n',
    )
    filterMode: Optional[str] = Field(
        'filter',
        description='\n\n\n\n<p>Generally <code class="codespan">dataZoom</code> component zoom or roam coordinate system through data filtering and set the windows of axes internally.</p>\n<p>Its behaviours vary according to filtering mode settings (<a href="#dataZoom.filterMode">dataZoom.filterMode</a>).</p>\n<p>Possible values:</p>\n<ul>\n<li><p>&#39;filter&#39;: data that outside the window will be <strong>filtered</strong>, which may lead to some changes of windows of other axes. For each data item, it will be filtered if one of the relevant dimensions is out of the window.</p>\n</li>\n<li><p>&#39;weakFilter&#39;: data that outside the window will be <strong>filtered</strong>, which may lead to some changes of windows of other axes. For each data item, it will be filtered only if all of the relevant dimensions are out of the same side of the window.</p>\n</li>\n<li><p>&#39;empty&#39;: data that outside the window will be <strong>set to NaN</strong>, which will not lead to changes of windows of other axes.</p>\n</li>\n<li><p>&#39;none&#39;: Do not filter data.</p>\n</li>\n</ul>\n<p>How to set <code class="codespan">filterMode</code> is up to users, depending on the requirments and scenarios. Expirically:</p>\n<ul>\n<li><p>If only <code class="codespan">xAxis</code> or only <code class="codespan">yAxis</code> is controlled by <code class="codespan">dataZoom</code>, <code class="codespan">filterMode: &#39;filter&#39;</code> is typically used, which enable the other axis auto adapte its window to the extent of the filtered data.</p>\n</li>\n<li><p>If both <code class="codespan">xAxis</code> and <code class="codespan">yAxis</code> are operated by <code class="codespan">dataZoom</code>:</p>\n<ul>\n<li><p>If <code class="codespan">xAxis</code> and <code class="codespan">yAxis</code> should not effect mutually (e.g. a scatter chart with both axes on the type of <code class="codespan">&#39;value&#39;</code>), they should be set to be <code class="codespan">filterMode: &#39;empty&#39;</code>.</p>\n</li>\n<li><p>If <code class="codespan">xAxis</code> is the main axis and <code class="codespan">yAxis</code> is the auxiliary axis (or vise versa) (e.g., in a bar chart, when dragging <code class="codespan">dataZoomX</code> to change the window of xAxis, we need the yAxis to adapt to the clipped data, but when dragging <code class="codespan">dataZoomY</code> to change the window of yAxis, we need the xAxis not to be changed), in this case, <code class="codespan">xAxis</code> should be set to be <code class="codespan">fiterMode: &#39;filter&#39;</code>, while <code class="codespan">yAxis</code> should be set to be <code class="codespan">fiterMode: &#39;empty&#39;</code>.</p>\n</li>\n</ul>\n</li>\n</ul>\n<p>It can be demonstrated by the sample:</p>\n<pre><code class="lang-javascript">option = {\n    dataZoom: [\n        {\n            id: &#39;dataZoomX&#39;,\n            type: &#39;slider&#39;,\n            xAxisIndex: [0],\n            filterMode: &#39;filter&#39;\n        },\n        {\n            id: &#39;dataZoomY&#39;,\n            type: &#39;slider&#39;,\n            yAxisIndex: [0],\n            filterMode: &#39;empty&#39;\n        }\n    ],\n    xAxis: {type: &#39;value&#39;},\n    yAxis: {type: &#39;value&#39;},\n    series{\n        type: &#39;bar&#39;,\n        data: [\n            // The first column corresponds to xAxis,\n            // and the second coloum corresponds to yAxis.\n            [12, 24, 36],\n            [90, 80, 70],\n            [3, 9, 27],\n            [1, 11, 111]\n        ]\n    }\n}\n</code></pre>\n<p>In the sample above, <code class="codespan">dataZoomX</code> is set as <code class="codespan">filterMode: &#39;filter&#39;</code>. When use drags <code class="codespan">dataZoomX</code> (do not touch <code class="codespan">dataZoomY</code>) and the valueWindow of <code class="codespan">xAxis</code> is changed to <code class="codespan">[2, 50]</code> consequently, <code class="codespan">dataZoomX</code> travel the first column of series.data and filter items that out of the window. The series.data turns out to be:</p>\n<pre><code class="lang-javascript">[\n    [12, 24, 36],\n    // [90, 80, 70] This item is filtered, as 90 is out of the window.\n    [3, 9, 27]\n    // [1, 11, 111] This item is filtered, as 1 is out of the window.\n]\n</code></pre>\n<p>Before filtering, the second column, which corresponds to yAxis, has values <code class="codespan">24</code>, <code class="codespan">80</code>, <code class="codespan">9</code>, <code class="codespan">11</code>. After filtering, only <code class="codespan">24</code> and <code class="codespan">9</code> are left. Then the extent of <code class="codespan">yAxis</code> is adjusted to adapt the two values (if <code class="codespan">yAxis.min</code> and <code class="codespan">yAxis.max</code> are not set).</p>\n<p>So <code class="codespan">filterMode: &#39;filter&#39;</code> can be used to enable the other axis to auto adapt the filtered data.</p>\n<p>Then let&#39;s review the sample from the beginning, <code class="codespan">dataZoomY</code> is set as <code class="codespan">filterMode: &#39;empty&#39;</code>. So if user drags <code class="codespan">dataZoomY</code> (do not touch <code class="codespan">dataZoomX</code>) and its window is changed to <code class="codespan">[10, 60]</code> consequently, <code class="codespan">dataZoomY</code> travels the second column of series.data and set NaN to all of the values that outside the window (NaN cause the graphical elements, i.e., bar elements, do not show, but still hold the place). The series.data turns out to be:</p>\n<pre><code class="lang-javascript">[\n    [12, 24, 36],\n    [90, NaN, 70], // Set to NaN\n    [3, NaN, 27],  // Set to NaN\n    [1, 11, 111]\n]\n</code></pre>\n<p>In this case, the first column (i.e., <code class="codespan">12</code>, <code class="codespan">90</code>, <code class="codespan">3</code>, <code class="codespan">1</code>, which corresponds to <code class="codespan">xAxis</code>), will not be changed at all. So dragging <code class="codespan">yAxis</code> will not change extent of <code class="codespan">xAxis</code>, which is good for requirements like outlier filtering.</p>\n<p>See this example:</p>\n<iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=doc-example/bar-dataZoom-filterMode&edit=1&reset=1" width="600" height="400"></iframe>\n\n\n\n\n\n',
    )
    start: Optional[float] = Field(
        0,
        description='\n\n<p>The start percentage of the window out of the data extent, in the range of 0 ~ 100.</p>\n<p><a href="#dataZoom-inside.start">dataZoom-inside.start</a> and <a href="#dataZoom-inside.end">dataZoom-inside.end</a> define the window of the data in <strong>percent</strong> form.</p>\n<p>More info about the relationship between <code class="codespan">dataZoom-inside.start</code> and axis extent can be checked in <a href="#dataZoom-inside.rangeMode">dataZoom-inside.rangeMode</a>.</p>\n',
    )
    end: Optional[float] = Field(
        100,
        description='\n\n<p>The end percentage of the window out of the data extent, in the range of 0 ~ 100.</p>\n<p><a href="#dataZoom-inside.start">dataZoom-inside.start</a> and <a href="#dataZoom-inside.end">dataZoom-inside.end</a> define the window of the data in <strong>percent</strong> form.</p>\n<p>More info about the relationship between <code class="codespan">dataZoom-inside.end</code> and axis extent can be checked in <a href="#dataZoom-inside.rangeMode">dataZoom-inside.rangeMode</a>.</p>\n',
    )
    startValue: Optional[Union[float, str, Any]] = Field(
        None,
        description='<p>The start absolute value of the window, not works when <a href="#dataZoom-inside.start">dataZoom-inside.start</a> is set.</p>\n<p><a href="#dataZoom-inside.startValue">dataZoom-inside.startValue</a> and <a href="#dataZoom-inside.endValue">dataZoom-inside.endValue</a> define the window of the data window in <strong>absolute value</strong> form.</p>\n<p>Notice, if an axis is set to be <code class="codespan">category</code>, <code class="codespan">startValue</code> could be set as <code class="codespan">index</code> of the array of <code class="codespan">axis.data</code> or as the array value itself. In the latter case, it will internally and automatically translate to the index of array.</p>\n<p>More info about the relationship between <code class="codespan">dataZoom-inside.startValue</code> and axis extent can be checked in <a href="#dataZoom-inside.rangeMode">dataZoom-inside.rangeMode</a>.</p>\n',
    )
    endValue: Optional[Union[float, str, Any]] = Field(
        None,
        description='<p>The end absolute value of the window, doesn&#39;t work when <a href="#dataZoom-inside.end">dataZoom-inside.end</a> is set.</p>\n<p><a href="#dataZoom-inside.startValue">dataZoom-inside.startValue</a> and <a href="#dataZoom-inside.endValue">dataZoom-inside.endValue</a> define the window of the data window in <strong>absolute value</strong> form.</p>\n<p>Notice, if an axis is set to be <code class="codespan">category</code>, <code class="codespan">startValue</code> could be set as <code class="codespan">index</code> of the array of <code class="codespan">axis.data</code> or as the array value itself. In the latter case, it will internally and automatically translate to the index of array.</p>\n<p>More info about the relationship between <code class="codespan">dataZoom-inside.endValue</code> and axis extent can be checked in <a href="#dataZoom-inside.rangeMode">dataZoom-inside.rangeMode</a>.</p>\n',
    )
    minSpan: Optional[float] = Field(
        None,
        description='\n\n<p>Used to restrict minimal window size, in percent, which value is in the range of [0, 100].</p>\n<p>If <a href="#dataZoom-inside.minValueSpan">dataZoom-inside.minValueSpan</a> is set, <code class="codespan">minSpan</code> does not work any more.</p>\n',
    )
    maxSpan: Optional[float] = Field(
        None,
        description='\n\n<p>Used to restrict maximal window size, in percent, which value is in the range of [0, 100].</p>\n<p>If <a href="#dataZoom-inside.maxValueSpan">dataZoom-inside.maxValueSpan</a> is set, <code class="codespan">maxSpan</code> does not work any more.</p>\n',
    )
    minValueSpan: Optional[Union[float, str, Any]] = Field(
        None,
        description='<p>Used to restrict minimal window size.</p>\n<p>For example:\nIn time axis it can be set as <code class="codespan">3600 * 24 * 1000 * 5</code> to represent &quot;5 day&quot;.\nIn category axis it can be set as <code class="codespan">5</code> to represent 5 categories.</p>\n',
    )
    maxValueSpan: Optional[Union[float, str, Any]] = Field(
        None,
        description='<p>Used to restrict maximal window size.</p>\n<p>For example:\nIn time axis it can be set as <code class="codespan">3600 * 24 * 1000 * 5</code> to represent &quot;5 day&quot;.\nIn category axis it can be set as <code class="codespan">5</code> to represent 5 categories.</p>\n',
    )
    orient: Optional[str] = Field(
        None,
        description='\n\n<p>Specify whether the layout of <code class="codespan">dataZoom</code> component is horizontal or vertical. What&#39;s more, it indicates whether the horizontal axis or vertical axis is controlled by default in catesian coordinate system.</p>\n<p>Valid values:</p>\n<ul>\n<li><p><code class="codespan">&#39;horizontal&#39;</code>: horizontal.</p>\n</li>\n<li><p><code class="codespan">&#39;vertical&#39;</code>: vertical.</p>\n</li>\n</ul>\n',
    )
    zoomLock: Optional[bool] = Field(
        False,
        description='\n\n<p>Specify whether to lock the size of window (selected area).</p>\n<p>When set as <code class="codespan">true</code>, the size of window is locked, that is, only the translation (by mouse drag or touch drag) is avialable but zoom is not.</p>\n',
    )
    throttle: Optional[float] = Field(
        100,
        description='\n\n<p>Specify the frame rate of views refreshing, with unit millisecond (ms).</p>\n<p>If <a href="#animation">animation</a> set as <code class="codespan">true</code> and <a href="#animationDurationUpdate">animationDurationUpdate</a> set as bigger than <code class="codespan">0</code>, you can keep <code class="codespan">throttle</code> as the default value <code class="codespan">100</code> (or set it as a value bigger than <code class="codespan">0</code>), otherwise it might be not smooth when dragging.</p>\n<p>If <a href="#animation">animation</a> set as <code class="codespan">false</code> or <a href="#animationDurationUpdate">animationDurationUpdate</a> set as <code class="codespan">0</code>, and data size is not very large, and it seems to be not smooth when dragging, you can set <code class="codespan">throttle</code> as <code class="codespan">0</code> to improve that.</p>\n',
    )
    rangeMode: Optional[Any] = Field(
        None,
        description='<p>The format is <code class="codespan">[rangeModeForStart, rangeModeForEnd]</code>.</p>\n<p>For example <code class="codespan">rangeMode: [&#39;value&#39;, &#39;percent&#39;]</code> means that use absolute value in <code class="codespan">start</code> and percent value in <code class="codespan">end</code>.</p>\n<p>Optional value for each item: <code class="codespan">&#39;value&#39;</code>, <code class="codespan">&#39;percent&#39;</code>.</p>\n<ul>\n<li><code class="codespan">&#39;value&#39;</code> mode: the axis extent will always only be determined by <code class="codespan">dataZoom.startValue</code> and <code class="codespan">dataZoom.endValue</code>, despite how data like and how <code class="codespan">axis.min</code> and <code class="codespan">axis.max</code> are.</li>\n<li><code class="codespan">&#39;percent&#39;</code> mode: <code class="codespan">100</code> represents 100% of the <code class="codespan">[dMin, dMax]</code>, where <code class="codespan">dMin</code> is <code class="codespan">axis.min</code> if <code class="codespan">axis.min</code> specified, otherwise <code class="codespan">data.extent[0]</code>, and <code class="codespan">dMax</code> is <code class="codespan">axis.max</code> if <code class="codespan">axis.max</code> specified, otherwise <code class="codespan">data.extent[1]</code>. Axis extent will only be determined by the result of the percent of <code class="codespan">[dMin, dMax]</code>.</li>\n</ul>\n<p><code class="codespan">rangeMode</code> are auto determined by whether <code class="codespan">option.start</code>/<code class="codespan">option.end</code> are specified (represents <code class="codespan">&#39;percent&#39;</code> mode) or <code class="codespan">option.startValue</code>/<code class="codespan">option.endValue</code> specified (represents <code class="codespan">&#39;value&#39;</code> mode). And when user behavior trigger the changing of the view, the <code class="codespan">rangeMode</code> would be modified automatically. For example, if triggered by <code class="codespan">toolbox.dataZoom</code>, it will be modefied to <code class="codespan">&#39;value&#39;</code>, and if triggered by <code class="codespan">dataZoom-inside</code> or <code class="codespan">dataZoom-slider</code>, it will be modified to <code class="codespan">&#39;percent&#39;</code>.</p>\n<p>If we specify <code class="codespan">rangeMode</code> manually in <code class="codespan">option</code>, it only works when both <code class="codespan">start</code> and <code class="codespan">startValue</code> specified or both <code class="codespan">end</code> and <code class="codespan">endValue</code> specified. So usually we do not need to specify <code class="codespan">dataZoom.rangeMode</code> manually.</p>\n<p>Take a scenario as an example. When we are using dynamic data (update data periodically via <code class="codespan">setOption</code>), if in <code class="codespan">&#39;value</code>&#39; mode, the window will be kept in a fixed value range despite how data are appended, while if in <code class="codespan">&#39;percent&#39;</code> mode, whe window range will be changed alone with the appended data (suppose <code class="codespan">axis.min</code> and <code class="codespan">axis.max</code> are not specified).</p>\n',
    )
    zoomOnMouseWheel: Optional[Union[bool, str]] = Field(
        True,
        description='\n\n<p>How to trigger zoom. Optional values:</p>\n<ul>\n<li><code class="codespan">true</code>：Mouse wheel triggers zoom.</li>\n<li><code class="codespan">false</code>：Mouse wheel can not triggers zoom.</li>\n<li><code class="codespan">&#39;shift&#39;</code>：Holding <code class="codespan">shift</code> and mouse wheel triggers zoom.</li>\n<li><code class="codespan">&#39;ctrl&#39;</code>：Holding <code class="codespan">ctrl</code> and mouse wheel triggers zoom.</li>\n<li><code class="codespan">&#39;alt&#39;</code>：Holding <code class="codespan">alt</code> and mouse wheel triggers zoom.</li>\n</ul>\n',
    )
    moveOnMouseMove: Optional[Union[bool, str]] = Field(
        True,
        description='\n\n<p>How to trigger data window move. Optional values:</p>\n<ul>\n<li><code class="codespan">true</code>：Mouse move triggers data window move.</li>\n<li><code class="codespan">false</code>：Mouse move can not triggers data window move.</li>\n<li><code class="codespan">&#39;shift&#39;</code>：Holding <code class="codespan">shift</code> and mouse move triggers data window move.</li>\n<li><code class="codespan">&#39;ctrl&#39;</code>：Holding <code class="codespan">ctrl</code> and mouse move triggers data window move.</li>\n<li><code class="codespan">&#39;alt&#39;</code>：Holding <code class="codespan">alt</code> and mouse move triggers data window move.</li>\n</ul>\n',
    )
    moveOnMouseWheel: Optional[Union[bool, str]] = Field(
        False,
        description='\n\n<p>How to trigger data window move. Optional values:</p>\n<ul>\n<li><code class="codespan">true</code>：Mouse wheel triggers data window move.</li>\n<li><code class="codespan">false</code>：Mouse wheel can not triggers data window move.</li>\n<li><code class="codespan">&#39;shift&#39;</code>：Holding <code class="codespan">shift</code> and mouse wheel triggers data window move.</li>\n<li><code class="codespan">&#39;ctrl&#39;</code>：Holding <code class="codespan">ctrl</code> and mouse wheel triggers data window move.</li>\n<li><code class="codespan">&#39;alt&#39;</code>：Holding <code class="codespan">alt</code> and mouse wheel triggers data window move.</li>\n</ul>\n',
    )
    preventDefaultMouseMove: Optional[bool] = Field(
        True,
        description='\n\n<p>Whether to prevent default behavior of mouse move event.</p>\n',
    )


class LineStyle31(BaseModel):
    """
    <p>Line style of data shadow</p>

    """

    color: Optional[Any] = Field(
        '#d2dbee',
        description='\n\n<p>Line color. </p>\n<blockquote>\n<p>Supports setting as solid color using <code class="codespan">rgb(255,255,255)</code>, <code class="codespan">rgba(255,255,255,1)</code>, <code class="codespan">#fff</code>, etc. Also supports setting as gradient color and pattern fill, see <a href="#color">option.color</a> for details</p>\n</blockquote>\n',
    )
    width: Optional[float] = Field(0.5, description='\n\n<p> line width.</p>\n')
    type: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>line type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">dashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\ntype: [5, 10],\n\ndashOffset: 5\n}\n</code></pre>\n',
    )
    dashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">type</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    cap: Optional[str] = Field(
        'butt',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To specify how to draw the end points of the line.\nPossible values are:</p>\n<ul>\n<li><code class="codespan">&#39;butt&#39;</code>: The ends of lines are squared off at the endpoints.</li>\n<li><code class="codespan">&#39;round&#39;</code>: The ends of lines are rounded.</li>\n<li><code class="codespan">&#39;square&#39;</code>: The ends of lines are squared off by adding a box with an equal width and half the height of the line&#39;s thickness.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;butt&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineCap" target="_blank">lineCap</a> for more details.</p>\n',
    )
    join: Optional[str] = Field(
        'bevel',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To determine the shape used to join two line segments where they meet.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;bevel&#39;</code>: Fills an additional triangular area between the common endpoint of connected segments, and the separate outside rectangular corners of each segment.</li>\n<li><code class="codespan">&#39;round&#39;</code>: Rounds off the corners of a shape by filling an additional sector of disc centered at the common endpoint of connected segments. The radius for these rounded corners is equal to the line width.</li>\n<li><code class="codespan">&#39;miter&#39;</code>: Connected segments are joined by extending their outside edges to connect at a single point, with the effect of filling an additional lozenge-shaped area. This setting is affected by the \n<code class="codespan">miterLimit</code>\nproperty.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;bevel&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineJoin" target="_blank">lineJoin</a> for more details.</p>\n',
    )
    miterLimit: Optional[float] = Field(
        10,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the miter limit ratio. Only works when \n<code class="codespan">join</code>\n is set as <code class="codespan">miter</code>.</p>\n<p>Default value is <code class="codespan">10</code>. Negative、<code class="codespan">0</code>、<code class="codespan">Infinity</code> and <code class="codespan">NaN</code> values are ignored.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/miterLimit" target="_blank">miterLimit</a> for more details.</p>\n',
    )
    shadowBlur: Optional[float] = Field(
        None,
        description='\n\n<p>Size of shadow blur. This attribute should be used along with <code class="codespan">shadowColor</code>,<code class="codespan">shadowOffsetX</code>, <code class="codespan">shadowOffsetY</code> to set shadow to component.</p>\n<p>For example:</p>\n<pre><code class="lang-ts">{\n    shadowColor: &#39;rgba(0, 0, 0, 0.5)&#39;,\n    shadowBlur: 10\n}\n</code></pre>\n',
    )
    shadowColor: Optional[Any] = Field(
        None,
        description='\n\n<p>Shadow color. Support same format as <code class="codespan">color</code>.</p>\n',
    )
    shadowOffsetX: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the horizontal direction of shadow.</p>\n',
    )
    shadowOffsetY: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the vertical direction of shadow.</p>\n',
    )
    opacity: Optional[float] = Field(
        None,
        description='\n\n<p>Opacity of the component. Supports value from 0 to 1, and the component will not be drawn when set to 0.</p>\n',
    )


class AreaStyle5(BaseModel):
    """
    <p>Area style of data shadow</p>

    """

    color: Optional[Any] = Field(
        'd2dbee',
        description='\n\n<p>Fill color. </p>\n<blockquote>\n<p>Supports setting as solid color using <code class="codespan">rgb(255,255,255)</code>, <code class="codespan">rgba(255,255,255,1)</code>, <code class="codespan">#fff</code>, etc. Also supports setting as gradient color and pattern fill, see <a href="#color">option.color</a> for details</p>\n</blockquote>\n',
    )
    shadowBlur: Optional[float] = Field(
        None,
        description='\n\n<p>Size of shadow blur. This attribute should be used along with <code class="codespan">shadowColor</code>,<code class="codespan">shadowOffsetX</code>, <code class="codespan">shadowOffsetY</code> to set shadow to component.</p>\n<p>For example:</p>\n<pre><code class="lang-ts">{\n    shadowColor: &#39;rgba(0, 0, 0, 0.5)&#39;,\n    shadowBlur: 10\n}\n</code></pre>\n',
    )
    shadowColor: Optional[Any] = Field(
        None,
        description='\n\n<p>Shadow color. Support same format as <code class="codespan">color</code>.</p>\n',
    )
    shadowOffsetX: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the horizontal direction of shadow.</p>\n',
    )
    shadowOffsetY: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the vertical direction of shadow.</p>\n',
    )
    opacity: Optional[float] = Field(
        0.2,
        description='\n\n<p>Opacity of the component. Supports value from 0 to 1, and the component will not be drawn when set to 0.</p>\n',
    )


class DataBackground(BaseModel):
    """
    <p>The style of data shadow.</p>

    """

    lineStyle: Optional[LineStyle31] = Field(
        None, description='<p>Line style of data shadow</p>\n'
    )
    areaStyle: Optional[AreaStyle5] = Field(
        None, description='<p>Area style of data shadow</p>\n'
    )


class LineStyle32(BaseModel):
    """
    <p>Line style of selected data shadow.</p>

    """

    color: Optional[Any] = Field(
        '#8fb0f7',
        description='\n\n<p>Line color. </p>\n<blockquote>\n<p>Supports setting as solid color using <code class="codespan">rgb(255,255,255)</code>, <code class="codespan">rgba(255,255,255,1)</code>, <code class="codespan">#fff</code>, etc. Also supports setting as gradient color and pattern fill, see <a href="#color">option.color</a> for details</p>\n</blockquote>\n',
    )
    width: Optional[float] = Field(0.5, description='\n\n<p> line width.</p>\n')
    type: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>line type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">dashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\ntype: [5, 10],\n\ndashOffset: 5\n}\n</code></pre>\n',
    )
    dashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">type</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    cap: Optional[str] = Field(
        'butt',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To specify how to draw the end points of the line.\nPossible values are:</p>\n<ul>\n<li><code class="codespan">&#39;butt&#39;</code>: The ends of lines are squared off at the endpoints.</li>\n<li><code class="codespan">&#39;round&#39;</code>: The ends of lines are rounded.</li>\n<li><code class="codespan">&#39;square&#39;</code>: The ends of lines are squared off by adding a box with an equal width and half the height of the line&#39;s thickness.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;butt&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineCap" target="_blank">lineCap</a> for more details.</p>\n',
    )
    join: Optional[str] = Field(
        'bevel',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To determine the shape used to join two line segments where they meet.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;bevel&#39;</code>: Fills an additional triangular area between the common endpoint of connected segments, and the separate outside rectangular corners of each segment.</li>\n<li><code class="codespan">&#39;round&#39;</code>: Rounds off the corners of a shape by filling an additional sector of disc centered at the common endpoint of connected segments. The radius for these rounded corners is equal to the line width.</li>\n<li><code class="codespan">&#39;miter&#39;</code>: Connected segments are joined by extending their outside edges to connect at a single point, with the effect of filling an additional lozenge-shaped area. This setting is affected by the \n<code class="codespan">miterLimit</code>\nproperty.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;bevel&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineJoin" target="_blank">lineJoin</a> for more details.</p>\n',
    )
    miterLimit: Optional[float] = Field(
        10,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the miter limit ratio. Only works when \n<code class="codespan">join</code>\n is set as <code class="codespan">miter</code>.</p>\n<p>Default value is <code class="codespan">10</code>. Negative、<code class="codespan">0</code>、<code class="codespan">Infinity</code> and <code class="codespan">NaN</code> values are ignored.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/miterLimit" target="_blank">miterLimit</a> for more details.</p>\n',
    )
    shadowBlur: Optional[float] = Field(
        None,
        description='\n\n<p>Size of shadow blur. This attribute should be used along with <code class="codespan">shadowColor</code>,<code class="codespan">shadowOffsetX</code>, <code class="codespan">shadowOffsetY</code> to set shadow to component.</p>\n<p>For example:</p>\n<pre><code class="lang-ts">{\n    shadowColor: &#39;rgba(0, 0, 0, 0.5)&#39;,\n    shadowBlur: 10\n}\n</code></pre>\n',
    )
    shadowColor: Optional[Any] = Field(
        None,
        description='\n\n<p>Shadow color. Support same format as <code class="codespan">color</code>.</p>\n',
    )
    shadowOffsetX: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the horizontal direction of shadow.</p>\n',
    )
    shadowOffsetY: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the vertical direction of shadow.</p>\n',
    )
    opacity: Optional[float] = Field(
        None,
        description='\n\n<p>Opacity of the component. Supports value from 0 to 1, and the component will not be drawn when set to 0.</p>\n',
    )


class AreaStyle6(BaseModel):
    """
    <p>Area style of selected data shadow.</p>

    """

    color: Optional[Any] = Field(
        '#8fb0f7',
        description='\n\n<p>Fill color. </p>\n<blockquote>\n<p>Supports setting as solid color using <code class="codespan">rgb(255,255,255)</code>, <code class="codespan">rgba(255,255,255,1)</code>, <code class="codespan">#fff</code>, etc. Also supports setting as gradient color and pattern fill, see <a href="#color">option.color</a> for details</p>\n</blockquote>\n',
    )
    shadowBlur: Optional[float] = Field(
        None,
        description='\n\n<p>Size of shadow blur. This attribute should be used along with <code class="codespan">shadowColor</code>,<code class="codespan">shadowOffsetX</code>, <code class="codespan">shadowOffsetY</code> to set shadow to component.</p>\n<p>For example:</p>\n<pre><code class="lang-ts">{\n    shadowColor: &#39;rgba(0, 0, 0, 0.5)&#39;,\n    shadowBlur: 10\n}\n</code></pre>\n',
    )
    shadowColor: Optional[Any] = Field(
        None,
        description='\n\n<p>Shadow color. Support same format as <code class="codespan">color</code>.</p>\n',
    )
    shadowOffsetX: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the horizontal direction of shadow.</p>\n',
    )
    shadowOffsetY: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the vertical direction of shadow.</p>\n',
    )
    opacity: Optional[float] = Field(
        0.2,
        description='\n\n<p>Opacity of the component. Supports value from 0 to 1, and the component will not be drawn when set to 0.</p>\n',
    )


class SelectedDataBackground(BaseModel):
    """
        <blockquote>
    <p>Since <code class="codespan">v5.0.0</code></p>
    </blockquote>
    <p>Styles of selected data shadow.</p>

    """

    lineStyle: Optional[LineStyle32] = Field(
        None, description='<p>Line style of selected data shadow.</p>\n'
    )
    areaStyle: Optional[AreaStyle6] = Field(
        None, description='<p>Area style of selected data shadow.</p>\n'
    )


class HandleStyle(BaseModel):
    """
    <p>Style of handle. Please refer to <a href="http://localhost/echarts-website/examples/en/editor.html?c=area-simple" target="_blank">area-simple example</a>.</p>

    """

    color: Optional[Any] = Field(
        '#fff',
        description='\n\n<p> color. </p>\n<blockquote>\n<p>Supports setting as solid color using <code class="codespan">rgb(255,255,255)</code>, <code class="codespan">rgba(255,255,255,1)</code>, <code class="codespan">#fff</code>, etc. Also supports setting as gradient color and pattern fill, see <a href="#color">option.color</a> for details</p>\n</blockquote>\n',
    )
    borderColor: Optional[Any] = Field(
        '#ACB8D1',
        description='\n\n<p> border color, whose format is similar to that of <code class="codespan">color</code>.</p>\n',
    )
    borderWidth: Optional[float] = Field(
        0,
        description='\n\n<p> border width. No border when it is set to be 0.</p>\n<p> border width. No border when it is set to be 0.</p>\n',
    )
    borderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p> border type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">borderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\nborderType: [5, 10],\n\nborderDashOffset: 5\n}\n</code></pre>\n',
    )
    borderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">borderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    borderCap: Optional[str] = Field(
        'butt',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To specify how to draw the end points of the line.\nPossible values are:</p>\n<ul>\n<li><code class="codespan">&#39;butt&#39;</code>: The ends of lines are squared off at the endpoints.</li>\n<li><code class="codespan">&#39;round&#39;</code>: The ends of lines are rounded.</li>\n<li><code class="codespan">&#39;square&#39;</code>: The ends of lines are squared off by adding a box with an equal width and half the height of the line&#39;s thickness.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;butt&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineCap" target="_blank">lineCap</a> for more details.</p>\n',
    )
    borderJoin: Optional[str] = Field(
        'bevel',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To determine the shape used to join two line segments where they meet.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;bevel&#39;</code>: Fills an additional triangular area between the common endpoint of connected segments, and the separate outside rectangular corners of each segment.</li>\n<li><code class="codespan">&#39;round&#39;</code>: Rounds off the corners of a shape by filling an additional sector of disc centered at the common endpoint of connected segments. The radius for these rounded corners is equal to the line width.</li>\n<li><code class="codespan">&#39;miter&#39;</code>: Connected segments are joined by extending their outside edges to connect at a single point, with the effect of filling an additional lozenge-shaped area. This setting is affected by the \n<code class="codespan">borderMiterLimit</code>\nproperty.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;bevel&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineJoin" target="_blank">lineJoin</a> for more details.</p>\n',
    )
    borderMiterLimit: Optional[float] = Field(
        10,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the miter limit ratio. Only works when \n<code class="codespan">borderJoin</code>\n is set as <code class="codespan">miter</code>.</p>\n<p>Default value is <code class="codespan">10</code>. Negative、<code class="codespan">0</code>、<code class="codespan">Infinity</code> and <code class="codespan">NaN</code> values are ignored.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/miterLimit" target="_blank">miterLimit</a> for more details.</p>\n',
    )
    shadowBlur: Optional[float] = Field(
        None,
        description='\n\n<p>Size of shadow blur. This attribute should be used along with <code class="codespan">shadowColor</code>,<code class="codespan">shadowOffsetX</code>, <code class="codespan">shadowOffsetY</code> to set shadow to component.</p>\n<p>For example:</p>\n<pre><code class="lang-ts">{\n    shadowColor: &#39;rgba(0, 0, 0, 0.5)&#39;,\n    shadowBlur: 10\n}\n</code></pre>\n',
    )
    shadowColor: Optional[Any] = Field(
        None,
        description='\n\n<p>Shadow color. Support same format as <code class="codespan">color</code>.</p>\n',
    )
    shadowOffsetX: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the horizontal direction of shadow.</p>\n',
    )
    shadowOffsetY: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the vertical direction of shadow.</p>\n',
    )
    opacity: Optional[float] = Field(
        None,
        description='\n\n<p>Opacity of the component. Supports value from 0 to 1, and the component will not be drawn when set to 0.</p>\n',
    )


class MoveHandleStyle(BaseModel):
    """
        <blockquote>
    <p>Since <code class="codespan">v5.0.0</code></p>
    </blockquote>
    <p>Style of move handle.</p>

    """

    color: Optional[Any] = Field(
        '#D2DBEE',
        description='\n\n<p> color. </p>\n<blockquote>\n<p>Supports setting as solid color using <code class="codespan">rgb(255,255,255)</code>, <code class="codespan">rgba(255,255,255,1)</code>, <code class="codespan">#fff</code>, etc. Also supports setting as gradient color and pattern fill, see <a href="#color">option.color</a> for details</p>\n</blockquote>\n',
    )
    borderColor: Optional[Any] = Field(
        '#000',
        description='\n\n<p> border color, whose format is similar to that of <code class="codespan">color</code>.</p>\n',
    )
    borderWidth: Optional[float] = Field(
        0,
        description='\n\n<p> border width. No border when it is set to be 0.</p>\n<p> border width. No border when it is set to be 0.</p>\n',
    )
    borderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p> border type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">borderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\nborderType: [5, 10],\n\nborderDashOffset: 5\n}\n</code></pre>\n',
    )
    borderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">borderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    borderCap: Optional[str] = Field(
        'butt',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To specify how to draw the end points of the line.\nPossible values are:</p>\n<ul>\n<li><code class="codespan">&#39;butt&#39;</code>: The ends of lines are squared off at the endpoints.</li>\n<li><code class="codespan">&#39;round&#39;</code>: The ends of lines are rounded.</li>\n<li><code class="codespan">&#39;square&#39;</code>: The ends of lines are squared off by adding a box with an equal width and half the height of the line&#39;s thickness.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;butt&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineCap" target="_blank">lineCap</a> for more details.</p>\n',
    )
    borderJoin: Optional[str] = Field(
        'bevel',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To determine the shape used to join two line segments where they meet.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;bevel&#39;</code>: Fills an additional triangular area between the common endpoint of connected segments, and the separate outside rectangular corners of each segment.</li>\n<li><code class="codespan">&#39;round&#39;</code>: Rounds off the corners of a shape by filling an additional sector of disc centered at the common endpoint of connected segments. The radius for these rounded corners is equal to the line width.</li>\n<li><code class="codespan">&#39;miter&#39;</code>: Connected segments are joined by extending their outside edges to connect at a single point, with the effect of filling an additional lozenge-shaped area. This setting is affected by the \n<code class="codespan">borderMiterLimit</code>\nproperty.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;bevel&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineJoin" target="_blank">lineJoin</a> for more details.</p>\n',
    )
    borderMiterLimit: Optional[float] = Field(
        10,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the miter limit ratio. Only works when \n<code class="codespan">borderJoin</code>\n is set as <code class="codespan">miter</code>.</p>\n<p>Default value is <code class="codespan">10</code>. Negative、<code class="codespan">0</code>、<code class="codespan">Infinity</code> and <code class="codespan">NaN</code> values are ignored.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/miterLimit" target="_blank">miterLimit</a> for more details.</p>\n',
    )
    shadowBlur: Optional[float] = Field(
        None,
        description='\n\n<p>Size of shadow blur. This attribute should be used along with <code class="codespan">shadowColor</code>,<code class="codespan">shadowOffsetX</code>, <code class="codespan">shadowOffsetY</code> to set shadow to component.</p>\n<p>For example:</p>\n<pre><code class="lang-ts">{\n    shadowColor: &#39;rgba(0, 0, 0, 0.5)&#39;,\n    shadowBlur: 10\n}\n</code></pre>\n',
    )
    shadowColor: Optional[Any] = Field(
        None,
        description='\n\n<p>Shadow color. Support same format as <code class="codespan">color</code>.</p>\n',
    )
    shadowOffsetX: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the horizontal direction of shadow.</p>\n',
    )
    shadowOffsetY: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the vertical direction of shadow.</p>\n',
    )
    opacity: Optional[float] = Field(
        None,
        description='\n\n<p>Opacity of the component. Supports value from 0 to 1, and the component will not be drawn when set to 0.</p>\n',
    )


class TextStyle8(BaseModel):
    color: Optional[Any] = Field(
        '#333', description='\n\n<p>dataZoom  text color.</p>\n'
    )
    fontStyle: Optional[str] = Field(
        'normal',
        description='\n\n<p>dataZoom  font style.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;italic&#39;</code></li>\n<li><code class="codespan">&#39;oblique&#39;</code></li>\n</ul>\n',
    )
    fontWeight: Optional[Union[str, float]] = Field(
        'normal',
        description='\n\n<p>dataZoom  font thick weight.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;bold&#39;</code></li>\n<li><code class="codespan">&#39;bolder&#39;</code></li>\n<li><code class="codespan">&#39;lighter&#39;</code></li>\n<li>100 | 200 | 300 | 400...</li>\n</ul>\n',
    )
    fontFamily: Optional[str] = Field(
        'sans-serif',
        description='\n\n<p>dataZoom  font family.</p>\n<p>Can also be &#39;serif&#39; , &#39;monospace&#39;, ...</p>\n',
    )
    fontSize: Optional[float] = Field(
        12, description='\n\n<p>dataZoom  font size.</p>\n'
    )
    lineHeight: Optional[float] = Field(
        None,
        description='\n\n<p>Line height of the text fragment.</p>\n<p>If <code class="codespan">lineHeight</code> is not set in <code class="codespan">rich</code>, <code class="codespan">lineHeight</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    lineHeight: 56,\n    rich: {\n        a: {\n            // `lineHeight` is not set, then it will be 56\n        }\n    }\n}\n</code></pre>\n',
    )
    width: Optional[float] = Field(
        None, description='\n\n<p>Width of text block.</p>\n'
    )
    height: Optional[float] = Field(
        None, description='\n\n<p>Height of text block.</p>\n'
    )
    textBorderColor: Optional[Any] = Field(
        None, description='\n\n<p>Stroke color of the text.</p>\n'
    )
    textBorderWidth: Optional[float] = Field(
        None, description='\n\n<p>Stroke line width of the text.</p>\n'
    )
    textBorderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>Stroke line type of the text.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">textBorderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\ntextBorderType: [5, 10],\n\ntextBorderDashOffset: 5\n}\n</code></pre>\n',
    )
    textBorderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">textBorderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    textShadowColor: Optional[Any] = Field(
        'transparent', description='\n\n<p>Shadow color of the text itself.</p>\n'
    )
    textShadowBlur: Optional[float] = Field(
        0, description='\n\n<p>Shadow blue of the text itself.</p>\n'
    )
    textShadowOffsetX: Optional[float] = Field(
        0, description='\n\n<p>Shadow X offset of the text itself.</p>\n'
    )
    textShadowOffsetY: Optional[float] = Field(
        0, description='\n\n<p>Shadow Y offset of the text itself.</p>\n'
    )
    overflow: Optional[str] = Field(
        'none',
        description='\n\n<p>Determine how to display the text when it&#39;s overflow. Available when <code class="codespan">width</code> is set.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the text and trailing with <code class="codespan">ellipsis</code>.</li>\n<li><code class="codespan">&#39;break&#39;</code> Break by word</li>\n<li><code class="codespan">&#39;breakAll&#39;</code> Break by character.</li>\n</ul>\n',
    )
    ellipsis: Optional[str] = Field(
        '...',
        description='<p>Ellipsis to be displayed when <code class="codespan">overflow</code> is set to <code class="codespan">truncate</code>.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the overflow lines.</li>\n</ul>\n',
    )


class BrushStyle(BaseModel):
    """
        <blockquote>
    <p>Since <code class="codespan">v5.0.0</code></p>
    </blockquote>
    <p>Style of brushing area.</p>

    """

    color: Optional[Any] = Field(
        'rgba(135,175,274,0.15)',
        description='\n\n<p> color. </p>\n<blockquote>\n<p>Supports setting as solid color using <code class="codespan">rgb(255,255,255)</code>, <code class="codespan">rgba(255,255,255,1)</code>, <code class="codespan">#fff</code>, etc. Also supports setting as gradient color and pattern fill, see <a href="#color">option.color</a> for details</p>\n</blockquote>\n',
    )
    borderColor: Optional[Any] = Field(
        '#000',
        description='\n\n<p> border color, whose format is similar to that of <code class="codespan">color</code>.</p>\n',
    )
    borderWidth: Optional[float] = Field(
        0,
        description='\n\n<p> border width. No border when it is set to be 0.</p>\n<p> border width. No border when it is set to be 0.</p>\n',
    )
    borderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p> border type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">borderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\nborderType: [5, 10],\n\nborderDashOffset: 5\n}\n</code></pre>\n',
    )
    borderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">borderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    borderCap: Optional[str] = Field(
        'butt',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To specify how to draw the end points of the line.\nPossible values are:</p>\n<ul>\n<li><code class="codespan">&#39;butt&#39;</code>: The ends of lines are squared off at the endpoints.</li>\n<li><code class="codespan">&#39;round&#39;</code>: The ends of lines are rounded.</li>\n<li><code class="codespan">&#39;square&#39;</code>: The ends of lines are squared off by adding a box with an equal width and half the height of the line&#39;s thickness.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;butt&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineCap" target="_blank">lineCap</a> for more details.</p>\n',
    )
    borderJoin: Optional[str] = Field(
        'bevel',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To determine the shape used to join two line segments where they meet.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;bevel&#39;</code>: Fills an additional triangular area between the common endpoint of connected segments, and the separate outside rectangular corners of each segment.</li>\n<li><code class="codespan">&#39;round&#39;</code>: Rounds off the corners of a shape by filling an additional sector of disc centered at the common endpoint of connected segments. The radius for these rounded corners is equal to the line width.</li>\n<li><code class="codespan">&#39;miter&#39;</code>: Connected segments are joined by extending their outside edges to connect at a single point, with the effect of filling an additional lozenge-shaped area. This setting is affected by the \n<code class="codespan">borderMiterLimit</code>\nproperty.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;bevel&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineJoin" target="_blank">lineJoin</a> for more details.</p>\n',
    )
    borderMiterLimit: Optional[float] = Field(
        10,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the miter limit ratio. Only works when \n<code class="codespan">borderJoin</code>\n is set as <code class="codespan">miter</code>.</p>\n<p>Default value is <code class="codespan">10</code>. Negative、<code class="codespan">0</code>、<code class="codespan">Infinity</code> and <code class="codespan">NaN</code> values are ignored.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/miterLimit" target="_blank">miterLimit</a> for more details.</p>\n',
    )
    shadowBlur: Optional[float] = Field(
        None,
        description='\n\n<p>Size of shadow blur. This attribute should be used along with <code class="codespan">shadowColor</code>,<code class="codespan">shadowOffsetX</code>, <code class="codespan">shadowOffsetY</code> to set shadow to component.</p>\n<p>For example:</p>\n<pre><code class="lang-ts">{\n    shadowColor: &#39;rgba(0, 0, 0, 0.5)&#39;,\n    shadowBlur: 10\n}\n</code></pre>\n',
    )
    shadowColor: Optional[Any] = Field(
        None,
        description='\n\n<p>Shadow color. Support same format as <code class="codespan">color</code>.</p>\n',
    )
    shadowOffsetX: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the horizontal direction of shadow.</p>\n',
    )
    shadowOffsetY: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the vertical direction of shadow.</p>\n',
    )
    opacity: Optional[float] = Field(
        None,
        description='\n\n<p>Opacity of the component. Supports value from 0 to 1, and the component will not be drawn when set to 0.</p>\n',
    )


class HandleStyle1(BaseModel):
    color: Optional[Any] = Field(
        None,
        description='\n\n<p> color. </p>\n<blockquote>\n<p>Supports setting as solid color using <code class="codespan">rgb(255,255,255)</code>, <code class="codespan">rgba(255,255,255,1)</code>, <code class="codespan">#fff</code>, etc. Also supports setting as gradient color and pattern fill, see <a href="#color">option.color</a> for details</p>\n</blockquote>\n',
    )
    borderColor: Optional[Any] = Field(
        '#000',
        description='\n\n<p> border color, whose format is similar to that of <code class="codespan">color</code>.</p>\n',
    )
    borderWidth: Optional[float] = Field(
        0,
        description='\n\n<p> border width. No border when it is set to be 0.</p>\n<p> border width. No border when it is set to be 0.</p>\n',
    )
    borderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p> border type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">borderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\nborderType: [5, 10],\n\nborderDashOffset: 5\n}\n</code></pre>\n',
    )
    borderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">borderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    borderCap: Optional[str] = Field(
        'butt',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To specify how to draw the end points of the line.\nPossible values are:</p>\n<ul>\n<li><code class="codespan">&#39;butt&#39;</code>: The ends of lines are squared off at the endpoints.</li>\n<li><code class="codespan">&#39;round&#39;</code>: The ends of lines are rounded.</li>\n<li><code class="codespan">&#39;square&#39;</code>: The ends of lines are squared off by adding a box with an equal width and half the height of the line&#39;s thickness.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;butt&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineCap" target="_blank">lineCap</a> for more details.</p>\n',
    )
    borderJoin: Optional[str] = Field(
        'bevel',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To determine the shape used to join two line segments where they meet.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;bevel&#39;</code>: Fills an additional triangular area between the common endpoint of connected segments, and the separate outside rectangular corners of each segment.</li>\n<li><code class="codespan">&#39;round&#39;</code>: Rounds off the corners of a shape by filling an additional sector of disc centered at the common endpoint of connected segments. The radius for these rounded corners is equal to the line width.</li>\n<li><code class="codespan">&#39;miter&#39;</code>: Connected segments are joined by extending their outside edges to connect at a single point, with the effect of filling an additional lozenge-shaped area. This setting is affected by the \n<code class="codespan">borderMiterLimit</code>\nproperty.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;bevel&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineJoin" target="_blank">lineJoin</a> for more details.</p>\n',
    )
    borderMiterLimit: Optional[float] = Field(
        10,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the miter limit ratio. Only works when \n<code class="codespan">borderJoin</code>\n is set as <code class="codespan">miter</code>.</p>\n<p>Default value is <code class="codespan">10</code>. Negative、<code class="codespan">0</code>、<code class="codespan">Infinity</code> and <code class="codespan">NaN</code> values are ignored.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/miterLimit" target="_blank">miterLimit</a> for more details.</p>\n',
    )
    shadowBlur: Optional[float] = Field(
        None,
        description='\n\n<p>Size of shadow blur. This attribute should be used along with <code class="codespan">shadowColor</code>,<code class="codespan">shadowOffsetX</code>, <code class="codespan">shadowOffsetY</code> to set shadow to component.</p>\n<p>For example:</p>\n<pre><code class="lang-ts">{\n    shadowColor: &#39;rgba(0, 0, 0, 0.5)&#39;,\n    shadowBlur: 10\n}\n</code></pre>\n',
    )
    shadowColor: Optional[Any] = Field(
        None,
        description='\n\n<p>Shadow color. Support same format as <code class="codespan">color</code>.</p>\n',
    )
    shadowOffsetX: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the horizontal direction of shadow.</p>\n',
    )
    shadowOffsetY: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the vertical direction of shadow.</p>\n',
    )
    opacity: Optional[float] = Field(
        None,
        description='\n\n<p>Opacity of the component. Supports value from 0 to 1, and the component will not be drawn when set to 0.</p>\n',
    )


class MoveHandleStyle1(HandleStyle1):
    pass


class Emphasis1(BaseModel):
    """
        <blockquote>
    <p>Since <code class="codespan">v5.0.0</code></p>
    </blockquote>
    <p>Style when highlighted.</p>

    """

    handleStyle: Optional[HandleStyle1] = Field(None, description='')
    moveHandleStyle: Optional[MoveHandleStyle1] = Field(None, description='')


class DataZoomItem1(BaseModel):
    """
        <p>Slider type dataZoom component provides functions like data thumbnail, zoom, brush to select, drag to move, click to locate.</p>
    <p>The followling picture shows areas to interact.</p>
    <p><img width="600" height="auto" src="documents/asset/img/dataZoom-zone.png"></p>

    """

    type: Optional[str] = Field('slider', description='')
    id: Optional[str] = Field(
        None,
        description='<p>Component ID, not specified by default. If specified, it can be used to refer the component in option or API.</p>\n',
    )
    show: Optional[bool] = Field(
        True,
        description='\n\n<p>Whether to show the  component. If is set to be <code class="codespan">false</code>, it will not show, but its data filtering function still works.</p>\n',
    )
    backgroundColor: Optional[Any] = Field(
        'rgba(47,69,84,0)',
        description='\n\n<p>The background color of the component.</p>\n',
    )
    dataBackground: Optional[DataBackground] = Field(
        None, description='<p>The style of data shadow.</p>\n'
    )
    selectedDataBackground: Optional[SelectedDataBackground] = Field(
        None,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n<p>Styles of selected data shadow.</p>\n',
    )
    fillerColor: Optional[Any] = Field(
        'rgba(47,69,84,0.25)',
        description='\n\n<p>The color to fill selected area.</p>\n',
    )
    borderColor: Optional[Any] = Field(
        '#ddd', description='\n\n<p>The color of border.</p>\n'
    )
    handleIcon: Optional[str] = Field(
        None,
        description='\n\n<p>Icon shape of handle, which supports path string. Its default value is:</p>\n<pre><code class="lang-ts">&#39;M8.2,13.6V3.9H6.3v9.7H3.1v14.9h3.3v9.7h1.8v-9.7h3.3V13.6H8.2z M9.7,24.4H4.8v-1.4h4.9V24.4z M9.7,19.1H4.8v-1.4h4.9V19.1z&#39;\n</code></pre>\n<p>It can be set to an image with <code class="codespan">&#39;image://url&#39;</code> , in which URL is the link to an image, or <code class="codespan">dataURI</code> of an image.</p>\n<p>An image URL example:</p>\n<pre><code>&#39;image://http://example.website/a/b.png&#39;\n</code></pre><p>A <code class="codespan">dataURI</code> example:</p>\n<pre><code>&#39;image://data:image/gif;base64,R0lGODlhEAAQAMQAAORHHOVSKudfOulrSOp3WOyDZu6QdvCchPGolfO0o/XBs/fNwfjZ0frl3/zy7////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAkAABAALAAAAAAQABAAAAVVICSOZGlCQAosJ6mu7fiyZeKqNKToQGDsM8hBADgUXoGAiqhSvp5QAnQKGIgUhwFUYLCVDFCrKUE1lBavAViFIDlTImbKC5Gm2hB0SlBCBMQiB0UjIQA7&#39;\n</code></pre><p>Icons can be set to arbitrary vector path via <code class="codespan">&#39;path://&#39;</code> in ECharts. As compared with a raster image, vector paths prevent jagging and blurring when scaled, and have better control over changing colors. The size of the vector icon will be adapted automatically. Refer to <a href="http://www.w3.org/TR/SVG/paths.html#PathData" target="_blank">SVG PathData</a> for more information about the format of the path. You may export vector paths from tools like Adobe </p>\n<p>For example:</p>\n<pre><code>&#39;path://M30.9,53.2C16.8,53.2,5.3,41.7,5.3,27.6S16.8,2,30.9,2C45,2,56.4,13.5,56.4,27.6S45,53.2,30.9,53.2z M30.9,3.5C17.6,3.5,6.8,14.4,6.8,27.6c0,13.3,10.8,24.1,24.101,24.1C44.2,51.7,55,40.9,55,27.6C54.9,14.4,44.1,3.5,30.9,3.5z M36.9,35.8c0,0.601-0.4,1-0.9,1h-1.3c-0.5,0-0.9-0.399-0.9-1V19.5c0-0.6,0.4-1,0.9-1H36c0.5,0,0.9,0.4,0.9,1V35.8z M27.8,35.8 c0,0.601-0.4,1-0.9,1h-1.3c-0.5,0-0.9-0.399-0.9-1V19.5c0-0.6,0.4-1,0.9-1H27c0.5,0,0.9,0.4,0.9,1L27.8,35.8L27.8,35.8z&#39;\n</code></pre>',
    )
    handleSize: Optional[Union[float, str]] = Field(
        '100%',
        description='\n\n<p>The size of control handle. It can be in pixels, or in percentage relative to the width of dataZoom component. By default, it&#39;s the same as the width of dataZoom component.</p>\n',
    )
    handleStyle: Optional[HandleStyle] = Field(
        None,
        description='<p>Style of handle. Please refer to <a href="http://localhost/echarts-website/examples/en/editor.html?c=area-simple" target="_blank">area-simple example</a>.</p>\n',
    )
    moveHandleIcon: Optional[str] = Field(
        None,
        description='\n\n\n\n<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n<p>Icon of move handle.</p>\n<pre><code class="lang-ts">&#39;M-320.9-50L-320.9-50c18.1,0,27.1,9,27.1,27.1V85.7c0,18.1-9,27.1-27.1,27.1l0,0c-18.1,0-27.1-9-27.1-27.1V-22.9C-348-41-339-50-320.9-50z M-212.3-50L-212.3-50c18.1,0,27.1,9,27.1,27.1V85.7c0,18.1-9,27.1-27.1,27.1l0,0c-18.1,0-27.1-9-27.1-27.1V-22.9C-239.4-41-230.4-50-212.3-50z M-103.7-50L-103.7-50c18.1,0,27.1,9,27.1,27.1V85.7c0,18.1-9,27.1-27.1,27.1l0,0c-18.1,0-27.1-9-27.1-27.1V-22.9C-130.9-41-121.8-50-103.7-50z&#39;\n</code></pre>\n<p>It can be set to an image with <code class="codespan">&#39;image://url&#39;</code> , in which URL is the link to an image, or <code class="codespan">dataURI</code> of an image.</p>\n<p>An image URL example:</p>\n<pre><code>&#39;image://http://example.website/a/b.png&#39;\n</code></pre><p>A <code class="codespan">dataURI</code> example:</p>\n<pre><code>&#39;image://data:image/gif;base64,R0lGODlhEAAQAMQAAORHHOVSKudfOulrSOp3WOyDZu6QdvCchPGolfO0o/XBs/fNwfjZ0frl3/zy7////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAkAABAALAAAAAAQABAAAAVVICSOZGlCQAosJ6mu7fiyZeKqNKToQGDsM8hBADgUXoGAiqhSvp5QAnQKGIgUhwFUYLCVDFCrKUE1lBavAViFIDlTImbKC5Gm2hB0SlBCBMQiB0UjIQA7&#39;\n</code></pre><p>Icons can be set to arbitrary vector path via <code class="codespan">&#39;path://&#39;</code> in ECharts. As compared with a raster image, vector paths prevent jagging and blurring when scaled, and have better control over changing colors. The size of the vector icon will be adapted automatically. Refer to <a href="http://www.w3.org/TR/SVG/paths.html#PathData" target="_blank">SVG PathData</a> for more information about the format of the path. You may export vector paths from tools like Adobe </p>\n<p>For example:</p>\n<pre><code>&#39;path://M30.9,53.2C16.8,53.2,5.3,41.7,5.3,27.6S16.8,2,30.9,2C45,2,56.4,13.5,56.4,27.6S45,53.2,30.9,53.2z M30.9,3.5C17.6,3.5,6.8,14.4,6.8,27.6c0,13.3,10.8,24.1,24.101,24.1C44.2,51.7,55,40.9,55,27.6C54.9,14.4,44.1,3.5,30.9,3.5z M36.9,35.8c0,0.601-0.4,1-0.9,1h-1.3c-0.5,0-0.9-0.399-0.9-1V19.5c0-0.6,0.4-1,0.9-1H36c0.5,0,0.9,0.4,0.9,1V35.8z M27.8,35.8 c0,0.601-0.4,1-0.9,1h-1.3c-0.5,0-0.9-0.399-0.9-1V19.5c0-0.6,0.4-1,0.9-1H27c0.5,0,0.9,0.4,0.9,1L27.8,35.8L27.8,35.8z&#39;\n</code></pre>',
    )
    moveHandleSize: Optional[float] = Field(
        7,
        description='\n\n\n\n<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n<p>Size of move handle.</p>\n',
    )
    moveHandleStyle: Optional[MoveHandleStyle] = Field(
        None,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n<p>Style of move handle.</p>\n',
    )
    labelPrecision: Optional[Union[float, str]] = Field(
        'auto',
        description='\n\n<p>Precision of label if in number form. By default, it is decided based on the number of data.</p>\n',
    )
    labelFormatter: Optional[Union[str, Any]] = Field(
        None,
        description='<p>The formatter tool for the label.</p>\n<ul>\n<li><p>It is a template if in <code class="codespan">string</code>. For instance, <code class="codespan">aaaa{value}bbbb</code>, where <code class="codespan">{value}</code> will be replaced by the value of actual data value.</p>\n</li>\n<li><p>It is a callback function if in <code class="codespan">Function</code>. For example:</p>\n</li>\n</ul>\n<pre><code class="lang-javascript">/**\n * @param {*} value If axis.type is &#39;category&#39;, `value` is the index of axis.data.\n *                  else `value` is current value.\n * @param {strign} valueStr Inner formatted string.\n * @return {string} Returns the label formatted.\n */\nlabelFormatter: function (value, valueStr) {\n    return &#39;aaa&#39; + value + &#39;bbb&#39;;\n}\n</code></pre>\n',
    )
    showDetail: Optional[bool] = Field(
        True,
        description='\n\n<p>Whether to show detail, that is, show the detailed data information when dragging.</p>\n',
    )
    showDataShadow: Optional[str] = Field(
        'auto',
        description='\n\n<p>Whether to show data shadow in <code class="codespan">dataZoom-silder</code> component, to indicate the data tendency in brief.</p>\n',
    )
    realtime: Optional[bool] = Field(
        True,
        description='\n\n<p>Whether to update view while dragging. If it is set as <code class="codespan">false</code>, the view will be updated only at the end of dragging.</p>\n',
    )
    textStyle: Optional[TextStyle8] = Field(None, description='')
    xAxisIndex: Optional[Union[float, Any]] = Field(
        None,
        description='<p>Specify which <a href="#xAxis">xAxis</a> is/are controlled by the <code class="codespan">dataZoom-slider</code> when <a href="#grid">catesian coordinate system</a> is used.</p>\n<p>By default the first <code class="codespan">xAxis</code> that parallel to <code class="codespan">dataZoom</code> are controlled when <a href="#dataZoom-slider.orient">dataZoom-slider.orient</a> is set as <code class="codespan">&#39;horizontal&#39;</code>. But it is recommended to specify it explicitly but not use default value.</p>\n<p>If it is set as a single <code class="codespan">number</code>, one axis is controlled, while if it is set as an <code class="codespan">Array</code> , multiple axes are controlled.</p>\n<p>For example:</p>\n<pre><code class="lang-javascript">option: {\n    xAxis: [\n        {...}, // The first xAxis\n        {...}, // The second xAxis\n        {...}, // The third xAxis\n        {...}  // The fourth xAxis\n    ],\n    dataZoom: [\n        { // The first dataZoom component\n            xAxisIndex: [0, 2] // Indicates that this dataZoom component\n                                     // controls the first and the third xAxis\n        },\n        { // The second dataZoom component\n            xAxisIndex: 3      // indicates that this dataZoom component\n                                     // controls the fourth xAxis\n        }\n    ]\n}\n</code></pre>\n',
    )
    yAxisIndex: Optional[Union[float, Any]] = Field(
        None,
        description='<p>Specify which <a href="#yAxis">yAxis</a> is/are controlled by the <code class="codespan">dataZoom-slider</code> when <a href="#grid">catesian coordinate system</a> is used.</p>\n<p>By default the first <code class="codespan">yAxis</code> that parallel to <code class="codespan">dataZoom</code> are controlled when <a href="#dataZoom-slider.orient">dataZoom-slider.orient</a> is set as <code class="codespan">&#39;vertical&#39;</code>. But it is recommended to specify it explicitly but not use default value.</p>\n<p>If it is set as a single <code class="codespan">number</code>, one axis is controlled, while if it is set as an <code class="codespan">Array</code> , multiple axes are controlled.</p>\n<p>For example:</p>\n<pre><code class="lang-javascript">option: {\n    yAxis: [\n        {...}, // The first yAxis\n        {...}, // The second yAxis\n        {...}, // The third yAxis\n        {...}  // The fourth yAxis\n    ],\n    dataZoom: [\n        { // The first dataZoom component\n            yAxisIndex: [0, 2] // Indicates that this dataZoom component\n                                     // controls the first and the third yAxis\n        },\n        { // The second dataZoom component\n            yAxisIndex: 3      // indicates that this dataZoom component\n                                     // controls the fourth yAxis\n        }\n    ]\n}\n</code></pre>\n',
    )
    radiusAxisIndex: Optional[Union[float, Any]] = Field(
        None,
        description='<p>Specify which <a href="#radiusAxis">radiusAxis</a> is/are controlled by the <code class="codespan">dataZoom-slider</code> when <a href="#polar">polar coordinate system</a> is used.</p>\n<p>If it is set as a single <code class="codespan">number</code>, one axis is controlled, while if it is set as an <code class="codespan">Array</code> , multiple axes are controlled.</p>\n<p>For example:</p>\n<pre><code class="lang-javascript">option: {\n    radiusAxis: [\n        {...}, // The first radiusAxis\n        {...}, // The second radiusAxis\n        {...}, // The third radiusAxis\n        {...}  // The fourth radiusAxis\n    ],\n    dataZoom: [\n        { // The first dataZoom component\n            radiusAxisIndex: [0, 2] // Indicates that this dataZoom component\n                                     // controls the first and the third radiusAxis\n        },\n        { // The second dataZoom component\n            radiusAxisIndex: 3      // indicates that this dataZoom component\n                                     // controls the fourth radiusAxis\n        }\n    ]\n}\n</code></pre>\n',
    )
    angleAxisIndex: Optional[Union[float, Any]] = Field(
        None,
        description='<p>Specify which <a href="#angleAxis">angleAxis</a> is/are controlled by the <code class="codespan">dataZoom-slider</code> when <a href="#polar">polar coordinate system</a> is used.</p>\n<p>If it is set as a single <code class="codespan">number</code>, one axis is controlled, while if it is set as an <code class="codespan">Array</code> , multiple axes are controlled.</p>\n<p>For example:</p>\n<pre><code class="lang-javascript">option: {\n    angleAxis: [\n        {...}, // The first angleAxis\n        {...}, // The second angleAxis\n        {...}, // The third angleAxis\n        {...}  // The fourth angleAxis\n    ],\n    dataZoom: [\n        { // The first dataZoom component\n            angleAxisIndex: [0, 2] // Indicates that this dataZoom component\n                                     // controls the first and the third angleAxis\n        },\n        { // The second dataZoom component\n            angleAxisIndex: 3      // indicates that this dataZoom component\n                                     // controls the fourth angleAxis\n        }\n    ]\n}\n</code></pre>\n',
    )
    filterMode: Optional[str] = Field(
        'filter',
        description='\n\n\n\n<p>Generally <code class="codespan">dataZoom</code> component zoom or roam coordinate system through data filtering and set the windows of axes internally.</p>\n<p>Its behaviours vary according to filtering mode settings (<a href="#dataZoom.filterMode">dataZoom.filterMode</a>).</p>\n<p>Possible values:</p>\n<ul>\n<li><p>&#39;filter&#39;: data that outside the window will be <strong>filtered</strong>, which may lead to some changes of windows of other axes. For each data item, it will be filtered if one of the relevant dimensions is out of the window.</p>\n</li>\n<li><p>&#39;weakFilter&#39;: data that outside the window will be <strong>filtered</strong>, which may lead to some changes of windows of other axes. For each data item, it will be filtered only if all of the relevant dimensions are out of the same side of the window.</p>\n</li>\n<li><p>&#39;empty&#39;: data that outside the window will be <strong>set to NaN</strong>, which will not lead to changes of windows of other axes.</p>\n</li>\n<li><p>&#39;none&#39;: Do not filter data.</p>\n</li>\n</ul>\n<p>How to set <code class="codespan">filterMode</code> is up to users, depending on the requirments and scenarios. Expirically:</p>\n<ul>\n<li><p>If only <code class="codespan">xAxis</code> or only <code class="codespan">yAxis</code> is controlled by <code class="codespan">dataZoom</code>, <code class="codespan">filterMode: &#39;filter&#39;</code> is typically used, which enable the other axis auto adapte its window to the extent of the filtered data.</p>\n</li>\n<li><p>If both <code class="codespan">xAxis</code> and <code class="codespan">yAxis</code> are operated by <code class="codespan">dataZoom</code>:</p>\n<ul>\n<li><p>If <code class="codespan">xAxis</code> and <code class="codespan">yAxis</code> should not effect mutually (e.g. a scatter chart with both axes on the type of <code class="codespan">&#39;value&#39;</code>), they should be set to be <code class="codespan">filterMode: &#39;empty&#39;</code>.</p>\n</li>\n<li><p>If <code class="codespan">xAxis</code> is the main axis and <code class="codespan">yAxis</code> is the auxiliary axis (or vise versa) (e.g., in a bar chart, when dragging <code class="codespan">dataZoomX</code> to change the window of xAxis, we need the yAxis to adapt to the clipped data, but when dragging <code class="codespan">dataZoomY</code> to change the window of yAxis, we need the xAxis not to be changed), in this case, <code class="codespan">xAxis</code> should be set to be <code class="codespan">fiterMode: &#39;filter&#39;</code>, while <code class="codespan">yAxis</code> should be set to be <code class="codespan">fiterMode: &#39;empty&#39;</code>.</p>\n</li>\n</ul>\n</li>\n</ul>\n<p>It can be demonstrated by the sample:</p>\n<pre><code class="lang-javascript">option = {\n    dataZoom: [\n        {\n            id: &#39;dataZoomX&#39;,\n            type: &#39;slider&#39;,\n            xAxisIndex: [0],\n            filterMode: &#39;filter&#39;\n        },\n        {\n            id: &#39;dataZoomY&#39;,\n            type: &#39;slider&#39;,\n            yAxisIndex: [0],\n            filterMode: &#39;empty&#39;\n        }\n    ],\n    xAxis: {type: &#39;value&#39;},\n    yAxis: {type: &#39;value&#39;},\n    series{\n        type: &#39;bar&#39;,\n        data: [\n            // The first column corresponds to xAxis,\n            // and the second coloum corresponds to yAxis.\n            [12, 24, 36],\n            [90, 80, 70],\n            [3, 9, 27],\n            [1, 11, 111]\n        ]\n    }\n}\n</code></pre>\n<p>In the sample above, <code class="codespan">dataZoomX</code> is set as <code class="codespan">filterMode: &#39;filter&#39;</code>. When use drags <code class="codespan">dataZoomX</code> (do not touch <code class="codespan">dataZoomY</code>) and the valueWindow of <code class="codespan">xAxis</code> is changed to <code class="codespan">[2, 50]</code> consequently, <code class="codespan">dataZoomX</code> travel the first column of series.data and filter items that out of the window. The series.data turns out to be:</p>\n<pre><code class="lang-javascript">[\n    [12, 24, 36],\n    // [90, 80, 70] This item is filtered, as 90 is out of the window.\n    [3, 9, 27]\n    // [1, 11, 111] This item is filtered, as 1 is out of the window.\n]\n</code></pre>\n<p>Before filtering, the second column, which corresponds to yAxis, has values <code class="codespan">24</code>, <code class="codespan">80</code>, <code class="codespan">9</code>, <code class="codespan">11</code>. After filtering, only <code class="codespan">24</code> and <code class="codespan">9</code> are left. Then the extent of <code class="codespan">yAxis</code> is adjusted to adapt the two values (if <code class="codespan">yAxis.min</code> and <code class="codespan">yAxis.max</code> are not set).</p>\n<p>So <code class="codespan">filterMode: &#39;filter&#39;</code> can be used to enable the other axis to auto adapt the filtered data.</p>\n<p>Then let&#39;s review the sample from the beginning, <code class="codespan">dataZoomY</code> is set as <code class="codespan">filterMode: &#39;empty&#39;</code>. So if user drags <code class="codespan">dataZoomY</code> (do not touch <code class="codespan">dataZoomX</code>) and its window is changed to <code class="codespan">[10, 60]</code> consequently, <code class="codespan">dataZoomY</code> travels the second column of series.data and set NaN to all of the values that outside the window (NaN cause the graphical elements, i.e., bar elements, do not show, but still hold the place). The series.data turns out to be:</p>\n<pre><code class="lang-javascript">[\n    [12, 24, 36],\n    [90, NaN, 70], // Set to NaN\n    [3, NaN, 27],  // Set to NaN\n    [1, 11, 111]\n]\n</code></pre>\n<p>In this case, the first column (i.e., <code class="codespan">12</code>, <code class="codespan">90</code>, <code class="codespan">3</code>, <code class="codespan">1</code>, which corresponds to <code class="codespan">xAxis</code>), will not be changed at all. So dragging <code class="codespan">yAxis</code> will not change extent of <code class="codespan">xAxis</code>, which is good for requirements like outlier filtering.</p>\n<p>See this example:</p>\n<iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=doc-example/bar-dataZoom-filterMode&edit=1&reset=1" width="600" height="400"></iframe>\n\n\n\n\n\n',
    )
    start: Optional[float] = Field(
        0,
        description='\n\n<p>The start percentage of the window out of the data extent, in the range of 0 ~ 100.</p>\n<p><a href="#dataZoom-slider.start">dataZoom-slider.start</a> and <a href="#dataZoom-slider.end">dataZoom-slider.end</a> define the window of the data in <strong>percent</strong> form.</p>\n<p>More info about the relationship between <code class="codespan">dataZoom-slider.start</code> and axis extent can be checked in <a href="#dataZoom-slider.rangeMode">dataZoom-slider.rangeMode</a>.</p>\n',
    )
    end: Optional[float] = Field(
        100,
        description='\n\n<p>The end percentage of the window out of the data extent, in the range of 0 ~ 100.</p>\n<p><a href="#dataZoom-slider.start">dataZoom-slider.start</a> and <a href="#dataZoom-slider.end">dataZoom-slider.end</a> define the window of the data in <strong>percent</strong> form.</p>\n<p>More info about the relationship between <code class="codespan">dataZoom-slider.end</code> and axis extent can be checked in <a href="#dataZoom-slider.rangeMode">dataZoom-slider.rangeMode</a>.</p>\n',
    )
    startValue: Optional[Union[float, str, Any]] = Field(
        None,
        description='<p>The start absolute value of the window, not works when <a href="#dataZoom-slider.start">dataZoom-slider.start</a> is set.</p>\n<p><a href="#dataZoom-slider.startValue">dataZoom-slider.startValue</a> and <a href="#dataZoom-slider.endValue">dataZoom-slider.endValue</a> define the window of the data window in <strong>absolute value</strong> form.</p>\n<p>Notice, if an axis is set to be <code class="codespan">category</code>, <code class="codespan">startValue</code> could be set as <code class="codespan">index</code> of the array of <code class="codespan">axis.data</code> or as the array value itself. In the latter case, it will internally and automatically translate to the index of array.</p>\n<p>More info about the relationship between <code class="codespan">dataZoom-slider.startValue</code> and axis extent can be checked in <a href="#dataZoom-slider.rangeMode">dataZoom-slider.rangeMode</a>.</p>\n',
    )
    endValue: Optional[Union[float, str, Any]] = Field(
        None,
        description='<p>The end absolute value of the window, doesn&#39;t work when <a href="#dataZoom-slider.end">dataZoom-slider.end</a> is set.</p>\n<p><a href="#dataZoom-slider.startValue">dataZoom-slider.startValue</a> and <a href="#dataZoom-slider.endValue">dataZoom-slider.endValue</a> define the window of the data window in <strong>absolute value</strong> form.</p>\n<p>Notice, if an axis is set to be <code class="codespan">category</code>, <code class="codespan">startValue</code> could be set as <code class="codespan">index</code> of the array of <code class="codespan">axis.data</code> or as the array value itself. In the latter case, it will internally and automatically translate to the index of array.</p>\n<p>More info about the relationship between <code class="codespan">dataZoom-slider.endValue</code> and axis extent can be checked in <a href="#dataZoom-slider.rangeMode">dataZoom-slider.rangeMode</a>.</p>\n',
    )
    minSpan: Optional[float] = Field(
        None,
        description='\n\n<p>Used to restrict minimal window size, in percent, which value is in the range of [0, 100].</p>\n<p>If <a href="#dataZoom-slider.minValueSpan">dataZoom-slider.minValueSpan</a> is set, <code class="codespan">minSpan</code> does not work any more.</p>\n',
    )
    maxSpan: Optional[float] = Field(
        None,
        description='\n\n<p>Used to restrict maximal window size, in percent, which value is in the range of [0, 100].</p>\n<p>If <a href="#dataZoom-slider.maxValueSpan">dataZoom-slider.maxValueSpan</a> is set, <code class="codespan">maxSpan</code> does not work any more.</p>\n',
    )
    minValueSpan: Optional[Union[float, str, Any]] = Field(
        None,
        description='<p>Used to restrict minimal window size.</p>\n<p>For example:\nIn time axis it can be set as <code class="codespan">3600 * 24 * 1000 * 5</code> to represent &quot;5 day&quot;.\nIn category axis it can be set as <code class="codespan">5</code> to represent 5 categories.</p>\n',
    )
    maxValueSpan: Optional[Union[float, str, Any]] = Field(
        None,
        description='<p>Used to restrict maximal window size.</p>\n<p>For example:\nIn time axis it can be set as <code class="codespan">3600 * 24 * 1000 * 5</code> to represent &quot;5 day&quot;.\nIn category axis it can be set as <code class="codespan">5</code> to represent 5 categories.</p>\n',
    )
    orient: Optional[str] = Field(
        None,
        description='\n\n<p>Specify whether the layout of <code class="codespan">dataZoom</code> component is horizontal or vertical. What&#39;s more, it indicates whether the horizontal axis or vertical axis is controlled by default in catesian coordinate system.</p>\n<p>Valid values:</p>\n<ul>\n<li><p><code class="codespan">&#39;horizontal&#39;</code>: horizontal.</p>\n</li>\n<li><p><code class="codespan">&#39;vertical&#39;</code>: vertical.</p>\n</li>\n</ul>\n',
    )
    zoomLock: Optional[bool] = Field(
        False,
        description='\n\n<p>Specify whether to lock the size of window (selected area).</p>\n<p>When set as <code class="codespan">true</code>, the size of window is locked, that is, only the translation (by mouse drag or touch drag) is avialable but zoom is not.</p>\n',
    )
    throttle: Optional[float] = Field(
        100,
        description='\n\n<p>Specify the frame rate of views refreshing, with unit millisecond (ms).</p>\n<p>If <a href="#animation">animation</a> set as <code class="codespan">true</code> and <a href="#animationDurationUpdate">animationDurationUpdate</a> set as bigger than <code class="codespan">0</code>, you can keep <code class="codespan">throttle</code> as the default value <code class="codespan">100</code> (or set it as a value bigger than <code class="codespan">0</code>), otherwise it might be not smooth when dragging.</p>\n<p>If <a href="#animation">animation</a> set as <code class="codespan">false</code> or <a href="#animationDurationUpdate">animationDurationUpdate</a> set as <code class="codespan">0</code>, and data size is not very large, and it seems to be not smooth when dragging, you can set <code class="codespan">throttle</code> as <code class="codespan">0</code> to improve that.</p>\n',
    )
    rangeMode: Optional[Any] = Field(
        None,
        description='<p>The format is <code class="codespan">[rangeModeForStart, rangeModeForEnd]</code>.</p>\n<p>For example <code class="codespan">rangeMode: [&#39;value&#39;, &#39;percent&#39;]</code> means that use absolute value in <code class="codespan">start</code> and percent value in <code class="codespan">end</code>.</p>\n<p>Optional value for each item: <code class="codespan">&#39;value&#39;</code>, <code class="codespan">&#39;percent&#39;</code>.</p>\n<ul>\n<li><code class="codespan">&#39;value&#39;</code> mode: the axis extent will always only be determined by <code class="codespan">dataZoom.startValue</code> and <code class="codespan">dataZoom.endValue</code>, despite how data like and how <code class="codespan">axis.min</code> and <code class="codespan">axis.max</code> are.</li>\n<li><code class="codespan">&#39;percent&#39;</code> mode: <code class="codespan">100</code> represents 100% of the <code class="codespan">[dMin, dMax]</code>, where <code class="codespan">dMin</code> is <code class="codespan">axis.min</code> if <code class="codespan">axis.min</code> specified, otherwise <code class="codespan">data.extent[0]</code>, and <code class="codespan">dMax</code> is <code class="codespan">axis.max</code> if <code class="codespan">axis.max</code> specified, otherwise <code class="codespan">data.extent[1]</code>. Axis extent will only be determined by the result of the percent of <code class="codespan">[dMin, dMax]</code>.</li>\n</ul>\n<p><code class="codespan">rangeMode</code> are auto determined by whether <code class="codespan">option.start</code>/<code class="codespan">option.end</code> are specified (represents <code class="codespan">&#39;percent&#39;</code> mode) or <code class="codespan">option.startValue</code>/<code class="codespan">option.endValue</code> specified (represents <code class="codespan">&#39;value&#39;</code> mode). And when user behavior trigger the changing of the view, the <code class="codespan">rangeMode</code> would be modified automatically. For example, if triggered by <code class="codespan">toolbox.dataZoom</code>, it will be modefied to <code class="codespan">&#39;value&#39;</code>, and if triggered by <code class="codespan">dataZoom-inside</code> or <code class="codespan">dataZoom-slider</code>, it will be modified to <code class="codespan">&#39;percent&#39;</code>.</p>\n<p>If we specify <code class="codespan">rangeMode</code> manually in <code class="codespan">option</code>, it only works when both <code class="codespan">start</code> and <code class="codespan">startValue</code> specified or both <code class="codespan">end</code> and <code class="codespan">endValue</code> specified. So usually we do not need to specify <code class="codespan">dataZoom.rangeMode</code> manually.</p>\n<p>Take a scenario as an example. When we are using dynamic data (update data periodically via <code class="codespan">setOption</code>), if in <code class="codespan">&#39;value</code>&#39; mode, the window will be kept in a fixed value range despite how data are appended, while if in <code class="codespan">&#39;percent&#39;</code> mode, whe window range will be changed alone with the appended data (suppose <code class="codespan">axis.min</code> and <code class="codespan">axis.max</code> are not specified).</p>\n',
    )
    zlevel: Optional[float] = Field(
        0,
        description='<p><code class="codespan">zlevel</code> value of all graphical elements in .</p>\n<p><code class="codespan">zlevel</code> is used to make layers with Canvas. Graphical elements with different <code class="codespan">zlevel</code> values will be placed in different Canvases, which is a common optimization technique. We can put those frequently changed elements (like those with animations) to a separate <code class="codespan">zlevel</code>. Notice that too many Canvases will increase memory cost, and should be used carefully on mobile phones to avoid crash.</p>\n<p>Canvases with bigger <code class="codespan">zlevel</code> will be placed on Canvases with smaller <code class="codespan">zlevel</code>.</p>\n',
    )
    z: Optional[float] = Field(
        2,
        description='<p><code class="codespan">z</code> value of all graphical elements in , which controls order of drawing graphical components. Components with smaller <code class="codespan">z</code> values may be overwritten by those with larger <code class="codespan">z</code> values.</p>\n<p><code class="codespan">z</code> has a lower priority to <code class="codespan">zlevel</code>, and will not create new Canvas.</p>\n',
    )
    left: Optional[Union[str, float]] = Field(
        'auto',
        description='<p>Distance between dataZoom-slider component and the left side of the container.</p>\n<p><code class="codespan">left</code> value can be instant pixel value like <code class="codespan">20</code>; it can also be a percentage value relative to container width like <code class="codespan">&#39;20%&#39;</code>; and it can also be <code class="codespan">&#39;left&#39;</code>, <code class="codespan">&#39;center&#39;</code>, or <code class="codespan">&#39;right&#39;</code>.</p>\n<p>If the <code class="codespan">left</code> value is set to be <code class="codespan">&#39;left&#39;</code>, <code class="codespan">&#39;center&#39;</code>, or <code class="codespan">&#39;right&#39;</code>, then the component will be aligned automatically based on position.</p>\n',
    )
    top: Optional[Union[str, float]] = Field(
        'auto',
        description='<p>Distance between dataZoom-slider component and the top side of the container.</p>\n<p><code class="codespan">top</code> value can be instant pixel value like <code class="codespan">20</code>; it can also be a percentage value relative to container width like <code class="codespan">&#39;20%&#39;</code>; and it can also be <code class="codespan">&#39;top&#39;</code>, <code class="codespan">&#39;middle&#39;</code>, or <code class="codespan">&#39;bottom&#39;</code>.</p>\n<p>If the <code class="codespan">top</code> value is set to be <code class="codespan">&#39;top&#39;</code>, <code class="codespan">&#39;middle&#39;</code>, or <code class="codespan">&#39;bottom&#39;</code>, then the component will be aligned automatically based on position.</p>\n',
    )
    right: Optional[Union[str, float]] = Field(
        'auto',
        description='<p>Distance between dataZoom-slider component and the right side of the container.</p>\n<p><code class="codespan">right</code> value can be instant pixel value like <code class="codespan">20</code>; it can also be a percentage value relative to container width like <code class="codespan">&#39;20%&#39;</code>.</p>\n<p>Adaptive by default.</p>\n',
    )
    bottom: Optional[Union[str, float]] = Field(
        'auto',
        description='<p>Distance between dataZoom-slider component and the bottom side of the container.</p>\n<p><code class="codespan">bottom</code> value can be instant pixel value like <code class="codespan">20</code>; it can also be a percentage value relative to container width like <code class="codespan">&#39;20%&#39;</code>.</p>\n<p>Adaptive by default.</p>\n',
    )
    width: Optional[Union[str, float]] = Field(
        None,
        description='\n\n<p>Width of dataZoom-slider component. Default to 30 when vertical, adaptive when horizontal.</p>\n<p>Has higer priority than <code class="codespan">left</code> and <code class="codespan">right</code>.</p>\n',
    )
    height: Optional[Union[str, float]] = Field(
        None,
        description='\n\n<p>Height of dataZoom-slider component. Default to 30 when horizontal, adaptive when vertical.</p>\n<p>Has higer priority than <code class="codespan">top</code> and <code class="codespan">bottom</code>.</p>\n',
    )
    brushSelect: Optional[bool] = Field(
        True,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n<p>Whether to enable brush to select.</p>\n',
    )
    brushStyle: Optional[BrushStyle] = Field(
        None,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n<p>Style of brushing area.</p>\n',
    )
    emphasis: Optional[Emphasis1] = Field(
        None,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n<p>Style when highlighted.</p>\n',
    )


class DataZoom(BaseModel):
    """
        <p><code class="codespan">dataZoom</code> component is used for zooming a specific area, which enables user to investigate data in detail, or get an overview of the data, or get rid of outlier points.</p>
    <p>These types of <code class="codespan">dataZoom</code> component are supported:</p>
    <ul>
    <li><p><a href="#dataZoom-inside">dataZoomInside</a>: Data zoom functionalities is embeded inside coordinate systems, enable user to zoom or roam coordinate system by mouse dragging, mouse move or finger touch (in touch screen).</p>
    </li>
    <li><p><a href="#dataZoom-slider">dataZoomSlider</a>: A special slider bar is provided, on which coordinate systems can be zoomed or roamed by mouse dragging or finger touch (in touch screen).</p>
    </li>
    <li><p><a href="#toolbox.feature.dataZoom">dataZoomSelect</a>: A marquee tool is provided for zooming or roaming coordinate system. That is <a href="#toolbox.feature.dataZoom">toolbox.feature.dataZoom</a>, which can only be configured in toolbox.</p>
    </li>
    </ul>
    <p>Example:</p>
    <iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=doc-example/scatter-dataZoom-all&edit=1&reset=1" width="600" height="400"></iframe>


    <p><br></p>
    <hr>
    <p><strong>✦ Relationship between dataZoom and axis ✦</strong></p>
    <p>Basically <code class="codespan">dataZoom</code> component operates &quot;window&quot; on axis to zoom or roam coordinate system.</p>
    <blockquote>
    <p>Use <a href="#dataZoom.xAxisIndex">dataZoom.xAxisIndex</a> or <a href="#dataZoom.yAxisIndex">dataZoom.yAxisIndex</a> or <a href="#dataZoom.radiusAxisIndex">dataZoom.radiusAxisIndex</a> or <a href="#dataZoom.angleAxisIndex">dataZoom.angleAxisIndex</a> to specify which axes are operated by <code class="codespan">dataZoom</code>.</p>
    </blockquote>
    <p>A single chart instance can contain several <code class="codespan">dataZoom</code> components, each of which controls different axes. The <code class="codespan">dataZoom</code> components that control the same axis will be automatically linked (i.e., all of them will be updated when one of them is updated by user action or API call).</p>
    <p><br></p>
    <hr>
    <p><strong>✦ How dataZoom componets operates axes and data ✦</strong></p>
    <p>Generally <code class="codespan">dataZoom</code> component zoom or roam coordinate system through data filtering and set the windows of axes internally.</p>
    <p>Its behaviours vary according to filtering mode settings (<a href="#dataZoom.filterMode">dataZoom.filterMode</a>).</p>
    <p>Possible values:</p>
    <ul>
    <li><p>&#39;filter&#39;: data that outside the window will be <strong>filtered</strong>, which may lead to some changes of windows of other axes. For each data item, it will be filtered if one of the relevant dimensions is out of the window.</p>
    </li>
    <li><p>&#39;weakFilter&#39;: data that outside the window will be <strong>filtered</strong>, which may lead to some changes of windows of other axes. For each data item, it will be filtered only if all of the relevant dimensions are out of the same side of the window.</p>
    </li>
    <li><p>&#39;empty&#39;: data that outside the window will be <strong>set to NaN</strong>, which will not lead to changes of windows of other axes.</p>
    </li>
    <li><p>&#39;none&#39;: Do not filter data.</p>
    </li>
    </ul>
    <p>How to set <code class="codespan">filterMode</code> is up to users, depending on the requirments and scenarios. Expirically:</p>
    <ul>
    <li><p>If only <code class="codespan">xAxis</code> or only <code class="codespan">yAxis</code> is controlled by <code class="codespan">dataZoom</code>, <code class="codespan">filterMode: &#39;filter&#39;</code> is typically used, which enable the other axis auto adapte its window to the extent of the filtered data.</p>
    </li>
    <li><p>If both <code class="codespan">xAxis</code> and <code class="codespan">yAxis</code> are operated by <code class="codespan">dataZoom</code>:</p>
    <ul>
    <li><p>If <code class="codespan">xAxis</code> and <code class="codespan">yAxis</code> should not effect mutually (e.g. a scatter chart with both axes on the type of <code class="codespan">&#39;value&#39;</code>), they should be set to be <code class="codespan">filterMode: &#39;empty&#39;</code>.</p>
    </li>
    <li><p>If <code class="codespan">xAxis</code> is the main axis and <code class="codespan">yAxis</code> is the auxiliary axis (or vise versa) (e.g., in a bar chart, when dragging <code class="codespan">dataZoomX</code> to change the window of xAxis, we need the yAxis to adapt to the clipped data, but when dragging <code class="codespan">dataZoomY</code> to change the window of yAxis, we need the xAxis not to be changed), in this case, <code class="codespan">xAxis</code> should be set to be <code class="codespan">fiterMode: &#39;filter&#39;</code>, while <code class="codespan">yAxis</code> should be set to be <code class="codespan">fiterMode: &#39;empty&#39;</code>.</p>
    </li>
    </ul>
    </li>
    </ul>
    <p>It can be demonstrated by the sample:</p>
    <pre><code class="lang-javascript">option = {
        dataZoom: [
            {
                id: &#39;dataZoomX&#39;,
                type: &#39;slider&#39;,
                xAxisIndex: [0],
                filterMode: &#39;filter&#39;
            },
            {
                id: &#39;dataZoomY&#39;,
                type: &#39;slider&#39;,
                yAxisIndex: [0],
                filterMode: &#39;empty&#39;
            }
        ],
        xAxis: {type: &#39;value&#39;},
        yAxis: {type: &#39;value&#39;},
        series{
            type: &#39;bar&#39;,
            data: [
                // The first column corresponds to xAxis,
                // and the second coloum corresponds to yAxis.
                [12, 24, 36],
                [90, 80, 70],
                [3, 9, 27],
                [1, 11, 111]
            ]
        }
    }
    </code></pre>
    <p>In the sample above, <code class="codespan">dataZoomX</code> is set as <code class="codespan">filterMode: &#39;filter&#39;</code>. When use drags <code class="codespan">dataZoomX</code> (do not touch <code class="codespan">dataZoomY</code>) and the valueWindow of <code class="codespan">xAxis</code> is changed to <code class="codespan">[2, 50]</code> consequently, <code class="codespan">dataZoomX</code> travel the first column of series.data and filter items that out of the window. The series.data turns out to be:</p>
    <pre><code class="lang-javascript">[
        [12, 24, 36],
        // [90, 80, 70] This item is filtered, as 90 is out of the window.
        [3, 9, 27]
        // [1, 11, 111] This item is filtered, as 1 is out of the window.
    ]
    </code></pre>
    <p>Before filtering, the second column, which corresponds to yAxis, has values <code class="codespan">24</code>, <code class="codespan">80</code>, <code class="codespan">9</code>, <code class="codespan">11</code>. After filtering, only <code class="codespan">24</code> and <code class="codespan">9</code> are left. Then the extent of <code class="codespan">yAxis</code> is adjusted to adapt the two values (if <code class="codespan">yAxis.min</code> and <code class="codespan">yAxis.max</code> are not set).</p>
    <p>So <code class="codespan">filterMode: &#39;filter&#39;</code> can be used to enable the other axis to auto adapt the filtered data.</p>
    <p>Then let&#39;s review the sample from the beginning, <code class="codespan">dataZoomY</code> is set as <code class="codespan">filterMode: &#39;empty&#39;</code>. So if user drags <code class="codespan">dataZoomY</code> (do not touch <code class="codespan">dataZoomX</code>) and its window is changed to <code class="codespan">[10, 60]</code> consequently, <code class="codespan">dataZoomY</code> travels the second column of series.data and set NaN to all of the values that outside the window (NaN cause the graphical elements, i.e., bar elements, do not show, but still hold the place). The series.data turns out to be:</p>
    <pre><code class="lang-javascript">[
        [12, 24, 36],
        [90, NaN, 70], // Set to NaN
        [3, NaN, 27],  // Set to NaN
        [1, 11, 111]
    ]
    </code></pre>
    <p>In this case, the first column (i.e., <code class="codespan">12</code>, <code class="codespan">90</code>, <code class="codespan">3</code>, <code class="codespan">1</code>, which corresponds to <code class="codespan">xAxis</code>), will not be changed at all. So dragging <code class="codespan">yAxis</code> will not change extent of <code class="codespan">xAxis</code>, which is good for requirements like outlier filtering.</p>
    <p>See this example:</p>
    <iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=doc-example/bar-dataZoom-filterMode&edit=1&reset=1" width="600" height="400"></iframe>






    <p>Moreover, when <code class="codespan">min</code>, <code class="codespan">max</code> of an axis is set (e.g., <code class="codespan">yAxis: {min: 0, max: 400}</code>), this extent of the axis will not be modified by the behaviour of dataZoom of other axis any more.</p>
    <p><br></p>
    <hr>
    <p><strong>✦ How to set window ✦</strong></p>
    <p>You can set the current window in two forms:</p>
    <ul>
    <li><p>percent value: see <a href="#dataZoom.start">dataZoom.start</a> and <a href="#dataZoom.end">dataZoom.end</a>.</p>
    </li>
    <li><p>absolute value: see <a href="#dataZoom.startValue">dataZoom.startValue</a> and <a href="#dataZoom.endValue">dataZoom.endValue</a>.</p>
    </li>
    </ul>
    <p>Notice: If use percent value form, and it is in the scenario below, the result of dataZoom depends on the sequence of dataZoom definitions appearing in <code class="codespan">option</code>.</p>
    <pre><code class="lang-javascript">option = {
        dataZoom: [
            {
                id: &#39;dataZoomX&#39;,
                type: &#39;slider&#39;,
                xAxisIndex: [0],
                filterMode: &#39;filter&#39;,   // Set as &#39;filter&#39; so that the modification
                                        // of window of xAxis willl effect the
                                        // window of yAxis.
                start: 30,
                end: 70
            },
            {
                id: &#39;dataZoomY&#39;,
                type: &#39;slider&#39;,
                yAxisIndex: [0],
                filterMode: &#39;empty&#39;,
                start: 20,
                end: 80
            }
        ],
        xAxis: {
            type: &#39;value&#39;
        },
        yAxis: {
            type: &#39;value&#39;
            // Notice there is no min or max set to
            // restrict the view extent of yAxis.
        },
        series{
            type: &#39;bar&#39;,
            data: [
                // The first column corresponds to xAxis,
                // and the second column corresponds to yAxis.
                [12, 24, 36],
                [90, 80, 70],
                [3, 9, 27],
                [1, 11, 111]
            ]
        }
    }
    </code></pre>
    <p>What is the exact meaning of <code class="codespan">start: 20, end: 80</code> in <code class="codespan">dataZoomY</code> in the example above?</p>
    <ul>
    <li><p>If <code class="codespan">yAxis.min</code> and <code class="codespan">yAxis.max</code> are set:</p>
    <p>  <code class="codespan">start: 20, end: 80</code> of <code class="codespan">dataZoomY</code> means: from <code class="codespan">20%</code> to <code class="codespan">80%</code> out of <code class="codespan">[yAxis.min, yAxis.max]</code>.</p>
    <p>  If one of <code class="codespan">yAxis.min</code> and <code class="codespan">yAxis.max</code> is not set, the corresponding edge of the full extend also follow rule as follows.</p>
    </li>
    <li><p>If <code class="codespan">yAxis.min</code> and <code class="codespan">yAxis.max</code> are not set:</p>
    <ul>
    <li><p>If <code class="codespan">dataZoomX</code> is set to be <code class="codespan">filterMode: &#39;empty&#39;</code>:</p>
    <p>  <code class="codespan">start: 20, end: 80</code> of <code class="codespan">dataZoomY</code> means: from <code class="codespan">20%</code> to <code class="codespan">80%</code> out of <code class="codespan">[dataMinY to dataMaxY]</code> of series.data (i.e., <code class="codespan">[9, 80]</code> in the example above).</p>
    </li>
    <li><p>If <code class="codespan">dataZoomX</code> is set to <code class="codespan">filterMode: &#39;filter&#39;</code>:</p>
    <p>  Since <code class="codespan">dataZoomX</code> is defined before <code class="codespan">dataZoomY</code>, <code class="codespan">start: 30, end: 70</code> of <code class="codespan">dataZoomX</code> means: from <code class="codespan">30%</code> to <code class="codespan">70%</code> out of full series.data, whereas <code class="codespan">start: 20, end: 80</code> of <code class="codespan">dataZoomY</code> means: from <code class="codespan">20%</code> to <code class="codespan">80%</code> out of the series.data having been filtered by <code class="codespan">dataZoomX</code>.</p>
    <p>  If you want to change the process sequence, you can just change the sequence of the definitions apearing in <code class="codespan">option</code>.</p>
    </li>
    </ul>
    </li>
    </ul>
    <p><br>
    <br></p>

    """

    pass


class Controller(BaseModel):
    """
    <p>Property <code class="codespan">inRange</code> and <code class="codespan">outOfRange</code> can be set within property <code class="codespan">controller</code>, which means those <code class="codespan">inRange</code> and <code class="codespan">outOfRange</code> are only used on the controller (<code class="codespan">visualMap</code> component itself), but are not used on chart (series). This property is useful in some scenarios when the view of controller needs to be customized in detail.</p>

    """

    inRange: Optional[Any] = Field(
        None,
        description='<p>Define visual channels that will mapped from dataValues that are <strong>in selected range</strong>. User can interact with visualMap component and make a seleced range by mouse or touch.</p>\n<p>See available configurations in <a href="#visualMap-continuous.inRange">visualMap-continuous.inRange</a></p>\n',
    )
    outOfRange: Optional[Any] = Field(
        None,
        description='<p>Define visual channels that will mapped from dataValues that are <strong>out of selected range</strong>. User can interact with visualMap component and make a seleced range by mouse or touch.</p>\n<p>See available configurations in <a href="#visualMap-continuous.inRange">visualMap-continuous.inRange</a></p>\n',
    )


class TextStyle9(BaseModel):
    color: Optional[Any] = Field(
        '#333', description='\n\n<p>visualMap  text color.</p>\n'
    )
    fontStyle: Optional[str] = Field(
        'normal',
        description='\n\n<p>visualMap  font style.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;italic&#39;</code></li>\n<li><code class="codespan">&#39;oblique&#39;</code></li>\n</ul>\n',
    )
    fontWeight: Optional[Union[str, float]] = Field(
        'normal',
        description='\n\n<p>visualMap  font thick weight.</p>\n<p>Options are:</p>\n<ul>\n<li><code class="codespan">&#39;normal&#39;</code></li>\n<li><code class="codespan">&#39;bold&#39;</code></li>\n<li><code class="codespan">&#39;bolder&#39;</code></li>\n<li><code class="codespan">&#39;lighter&#39;</code></li>\n<li>100 | 200 | 300 | 400...</li>\n</ul>\n',
    )
    fontFamily: Optional[str] = Field(
        'sans-serif',
        description='\n\n<p>visualMap  font family.</p>\n<p>Can also be &#39;serif&#39; , &#39;monospace&#39;, ...</p>\n',
    )
    fontSize: Optional[float] = Field(
        12, description='\n\n<p>visualMap  font size.</p>\n'
    )
    lineHeight: Optional[float] = Field(
        None,
        description='\n\n<p>Line height of the text fragment.</p>\n<p>If <code class="codespan">lineHeight</code> is not set in <code class="codespan">rich</code>, <code class="codespan">lineHeight</code> in parent level will be used. For example:</p>\n<pre><code class="lang-ts">{\n    lineHeight: 56,\n    rich: {\n        a: {\n            // `lineHeight` is not set, then it will be 56\n        }\n    }\n}\n</code></pre>\n',
    )
    width: Optional[float] = Field(
        None, description='\n\n<p>Width of text block.</p>\n'
    )
    height: Optional[float] = Field(
        None, description='\n\n<p>Height of text block.</p>\n'
    )
    textBorderColor: Optional[Any] = Field(
        None, description='\n\n<p>Stroke color of the text.</p>\n'
    )
    textBorderWidth: Optional[float] = Field(
        None, description='\n\n<p>Stroke line width of the text.</p>\n'
    )
    textBorderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p>Stroke line type of the text.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">textBorderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\ntextBorderType: [5, 10],\n\ntextBorderDashOffset: 5\n}\n</code></pre>\n',
    )
    textBorderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">textBorderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    textShadowColor: Optional[Any] = Field(
        'transparent', description='\n\n<p>Shadow color of the text itself.</p>\n'
    )
    textShadowBlur: Optional[float] = Field(
        0, description='\n\n<p>Shadow blue of the text itself.</p>\n'
    )
    textShadowOffsetX: Optional[float] = Field(
        0, description='\n\n<p>Shadow X offset of the text itself.</p>\n'
    )
    textShadowOffsetY: Optional[float] = Field(
        0, description='\n\n<p>Shadow Y offset of the text itself.</p>\n'
    )
    overflow: Optional[str] = Field(
        'none',
        description='\n\n<p>Determine how to display the text when it&#39;s overflow. Available when <code class="codespan">width</code> is set.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the text and trailing with <code class="codespan">ellipsis</code>.</li>\n<li><code class="codespan">&#39;break&#39;</code> Break by word</li>\n<li><code class="codespan">&#39;breakAll&#39;</code> Break by character.</li>\n</ul>\n',
    )
    ellipsis: Optional[str] = Field(
        '...',
        description='<p>Ellipsis to be displayed when <code class="codespan">overflow</code> is set to <code class="codespan">truncate</code>.</p>\n<ul>\n<li><code class="codespan">&#39;truncate&#39;</code> Truncate the overflow lines.</li>\n</ul>\n',
    )


class HandleStyle2(BaseModel):
    """
        <blockquote>
    <p>Since <code class="codespan">v5.0.0</code></p>
    </blockquote>
    <p>Style of drag handle.</p>

    """

    color: Optional[Any] = Field(
        None,
        description='\n\n<p> color. </p>\n<blockquote>\n<p>Supports setting as solid color using <code class="codespan">rgb(255,255,255)</code>, <code class="codespan">rgba(255,255,255,1)</code>, <code class="codespan">#fff</code>, etc. Also supports setting as gradient color and pattern fill, see <a href="#color">option.color</a> for details</p>\n</blockquote>\n',
    )
    borderColor: Optional[Any] = Field(
        '#fff',
        description='\n\n<p> border color, whose format is similar to that of <code class="codespan">color</code>.</p>\n',
    )
    borderWidth: Optional[float] = Field(
        1,
        description='\n\n<p> border width. No border when it is set to be 0.</p>\n<p> border width. No border when it is set to be 0.</p>\n',
    )
    borderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p> border type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">borderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\nborderType: [5, 10],\n\nborderDashOffset: 5\n}\n</code></pre>\n',
    )
    borderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">borderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    borderCap: Optional[str] = Field(
        'butt',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To specify how to draw the end points of the line.\nPossible values are:</p>\n<ul>\n<li><code class="codespan">&#39;butt&#39;</code>: The ends of lines are squared off at the endpoints.</li>\n<li><code class="codespan">&#39;round&#39;</code>: The ends of lines are rounded.</li>\n<li><code class="codespan">&#39;square&#39;</code>: The ends of lines are squared off by adding a box with an equal width and half the height of the line&#39;s thickness.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;butt&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineCap" target="_blank">lineCap</a> for more details.</p>\n',
    )
    borderJoin: Optional[str] = Field(
        'bevel',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To determine the shape used to join two line segments where they meet.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;bevel&#39;</code>: Fills an additional triangular area between the common endpoint of connected segments, and the separate outside rectangular corners of each segment.</li>\n<li><code class="codespan">&#39;round&#39;</code>: Rounds off the corners of a shape by filling an additional sector of disc centered at the common endpoint of connected segments. The radius for these rounded corners is equal to the line width.</li>\n<li><code class="codespan">&#39;miter&#39;</code>: Connected segments are joined by extending their outside edges to connect at a single point, with the effect of filling an additional lozenge-shaped area. This setting is affected by the \n<code class="codespan">borderMiterLimit</code>\nproperty.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;bevel&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineJoin" target="_blank">lineJoin</a> for more details.</p>\n',
    )
    borderMiterLimit: Optional[float] = Field(
        10,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the miter limit ratio. Only works when \n<code class="codespan">borderJoin</code>\n is set as <code class="codespan">miter</code>.</p>\n<p>Default value is <code class="codespan">10</code>. Negative、<code class="codespan">0</code>、<code class="codespan">Infinity</code> and <code class="codespan">NaN</code> values are ignored.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/miterLimit" target="_blank">miterLimit</a> for more details.</p>\n',
    )
    shadowBlur: Optional[float] = Field(
        None,
        description='\n\n<p>Size of shadow blur. This attribute should be used along with <code class="codespan">shadowColor</code>,<code class="codespan">shadowOffsetX</code>, <code class="codespan">shadowOffsetY</code> to set shadow to component.</p>\n<p>For example:</p>\n<pre><code class="lang-ts">{\n    shadowColor: &#39;rgba(0, 0, 0, 0.5)&#39;,\n    shadowBlur: 10\n}\n</code></pre>\n',
    )
    shadowColor: Optional[Any] = Field(
        None,
        description='\n\n<p>Shadow color. Support same format as <code class="codespan">color</code>.</p>\n',
    )
    shadowOffsetX: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the horizontal direction of shadow.</p>\n',
    )
    shadowOffsetY: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the vertical direction of shadow.</p>\n',
    )
    opacity: Optional[float] = Field(
        None,
        description='\n\n<p>Opacity of the component. Supports value from 0 to 1, and the component will not be drawn when set to 0.</p>\n',
    )


class IndicatorStyle(BaseModel):
    """
    <p>Style of indicator.</p>

    """

    color: Optional[Any] = Field(
        None,
        description='\n\n<p> color. </p>\n<blockquote>\n<p>Supports setting as solid color using <code class="codespan">rgb(255,255,255)</code>, <code class="codespan">rgba(255,255,255,1)</code>, <code class="codespan">#fff</code>, etc. Also supports setting as gradient color and pattern fill, see <a href="#color">option.color</a> for details</p>\n</blockquote>\n',
    )
    borderColor: Optional[Any] = Field(
        '#fff',
        description='\n\n<p> border color, whose format is similar to that of <code class="codespan">color</code>.</p>\n',
    )
    borderWidth: Optional[float] = Field(
        2,
        description='\n\n<p> border width. No border when it is set to be 0.</p>\n<p> border width. No border when it is set to be 0.</p>\n',
    )
    borderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p> border type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">borderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\nborderType: [5, 10],\n\nborderDashOffset: 5\n}\n</code></pre>\n',
    )
    borderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">borderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    borderCap: Optional[str] = Field(
        'butt',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To specify how to draw the end points of the line.\nPossible values are:</p>\n<ul>\n<li><code class="codespan">&#39;butt&#39;</code>: The ends of lines are squared off at the endpoints.</li>\n<li><code class="codespan">&#39;round&#39;</code>: The ends of lines are rounded.</li>\n<li><code class="codespan">&#39;square&#39;</code>: The ends of lines are squared off by adding a box with an equal width and half the height of the line&#39;s thickness.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;butt&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineCap" target="_blank">lineCap</a> for more details.</p>\n',
    )
    borderJoin: Optional[str] = Field(
        'bevel',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To determine the shape used to join two line segments where they meet.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;bevel&#39;</code>: Fills an additional triangular area between the common endpoint of connected segments, and the separate outside rectangular corners of each segment.</li>\n<li><code class="codespan">&#39;round&#39;</code>: Rounds off the corners of a shape by filling an additional sector of disc centered at the common endpoint of connected segments. The radius for these rounded corners is equal to the line width.</li>\n<li><code class="codespan">&#39;miter&#39;</code>: Connected segments are joined by extending their outside edges to connect at a single point, with the effect of filling an additional lozenge-shaped area. This setting is affected by the \n<code class="codespan">borderMiterLimit</code>\nproperty.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;bevel&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineJoin" target="_blank">lineJoin</a> for more details.</p>\n',
    )
    borderMiterLimit: Optional[float] = Field(
        10,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the miter limit ratio. Only works when \n<code class="codespan">borderJoin</code>\n is set as <code class="codespan">miter</code>.</p>\n<p>Default value is <code class="codespan">10</code>. Negative、<code class="codespan">0</code>、<code class="codespan">Infinity</code> and <code class="codespan">NaN</code> values are ignored.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/miterLimit" target="_blank">miterLimit</a> for more details.</p>\n',
    )
    shadowBlur: Optional[float] = Field(
        2,
        description='\n\n<p>Size of shadow blur. This attribute should be used along with <code class="codespan">shadowColor</code>,<code class="codespan">shadowOffsetX</code>, <code class="codespan">shadowOffsetY</code> to set shadow to component.</p>\n<p>For example:</p>\n<pre><code class="lang-ts">{\n    shadowColor: &#39;rgba(0, 0, 0, 0.5)&#39;,\n    shadowBlur: 10\n}\n</code></pre>\n',
    )
    shadowColor: Optional[Any] = Field(
        'rgba(0,0,0,0.2)',
        description='\n\n<p>Shadow color. Support same format as <code class="codespan">color</code>.</p>\n',
    )
    shadowOffsetX: Optional[float] = Field(
        1,
        description='\n\n<p>Offset distance on the horizontal direction of shadow.</p>\n',
    )
    shadowOffsetY: Optional[float] = Field(
        1,
        description='\n\n<p>Offset distance on the vertical direction of shadow.</p>\n',
    )
    opacity: Optional[float] = Field(
        None,
        description='\n\n<p>Opacity of the component. Supports value from 0 to 1, and the component will not be drawn when set to 0.</p>\n',
    )


class VisualMapItem(BaseModel):
    """
        <p><strong>Continuous visualMap component (visualMapContinuous)</strong></p>
    <p> (See <a href="#visualMap">the introduction to visual Map component (visualMap)</a>)</p>
    <p>You can set <a href="#visualMap.calculable">visualMap.calculable</a> to show or hide the handles, which are used to change the selected range in <code class="codespan">visualMapContinuous</code>.</p>
    <p><br>
    <br></p>

    """

    type: Optional[str] = Field(
        'continuous',
        description='<p>Used to determine that it is a continuous visualMap component.</p>\n',
    )
    id: Optional[str] = Field(
        None,
        description='<p>Component ID, not specified by default. If specified, it can be used to refer the component in option or API.</p>\n',
    )
    min: Optional[float] = Field(
        None,
        description='\n\n<p>Specify the min dataValue for the visualMap component. <code class="codespan">[visualMap.min, visualMax.max]</code> make up the domain of viusul mapping.</p>\n<p>Notice that <code class="codespan">min</code> and <code class="codespan">max</code> should be specified explicitly, and be <code class="codespan">[0, 200]</code> by default, but not <code class="codespan">dataMin</code> and <code class="codespan">dataMax</code> in series.data.</p>\n',
    )
    max: Optional[float] = Field(
        None,
        description='\n\n<p>Specify the max dataValue for the visualMap component. <code class="codespan">[visualMap.min, visualMax.max]</code> make up the domain of viusul mapping.</p>\n<p>Notice that <code class="codespan">min</code> and <code class="codespan">max</code> should be specified explicitly, and be <code class="codespan">[0, 200]</code> by default, but not <code class="codespan">dataMin</code> and <code class="codespan">dataMax</code> in series.data.</p>\n',
    )
    range: Optional[Any] = Field(
        None,
        description='<p>Specify selected range, that is, the dataValue corresponding to the two handles. For example:</p>\n<pre><code class="lang-javascript">chart.setOption({\n    visualMap: {\n        min: 0,\n        max: 100,\n        // dataValue corresponding to the two handles.\n        range: [4, 15],\n        ...\n    }\n});\n</code></pre>\n<p><strong>auto-adaption when min or max is modified by setOption</strong></p>\n<ul>\n<li>If <code class="codespan">range</code> is not set (or set to null or undefined)</li>\n</ul>\n<pre><code class="lang-javascript">For instance:\nchart.setOption({visualMap: {min: 10, max: 300}}); // range is not set, then range is [min, max] by default, that is, [10, 300].\n\nchart.setOption({visualMap: {min: 0, max: 400}}); // Modify min and max using setOption again.\n// Then range will be auto-modified to the new [min, max], that is, [0, 400].\n</code></pre>\n<ul>\n<li>If <code class="codespan">range</code> is set explicitly, such as [10, 300]</li>\n</ul>\n<pre><code class="lang-javascript">For instance:\nchart.setOption({visualMap: {min: 10, max: 300, range: [20, 80]}}); // range is set to [20, 80].\n\nchart.setOption({visualMap: {min: 0, max: 400}}); // min and max are modifies using setOption.\n// Then range keep the original value ([20, 80]) but will not do auto-adaption.\n\nchart.setOption({visualMap: {range: null}}); // Set range to null then.\n// Then auto-adaption of range turns on and range is auto modified to [min, max], that is, [0, 400].\n\n</code></pre>\n<p><code class="codespan">range</code> gotten by <code class="codespan">getOption</code> is always an <code class="codespan">Array</code>, but not <code class="codespan">null</code> or <code class="codespan">undefined</code>.</p>\n',
    )
    calculable: Optional[bool] = Field(
        False,
        description='\n\n<p>Whether show handles, which can be dragged to adjust &quot;selected range&quot;.</p>\n<p>Notes: In order to be compatible with ECharts2, the rule, which seems to be a little odd, is retained: when <a href="#visualMap.type">visualMap.type</a> is not set, and <a href="#visualMap-continuous.calculable">visualMap.calculable</a> was set to be <code class="codespan">true</code>, <a href="#visualMap.type">visualMap.type</a> will be automatically set as <code class="codespan">&#39;continuous&#39;</code>, regardless of some settings such as <a href="#visualMap-piecewise.splitNumber">visualMap-piecewise.splitNumber</a>. Therefore, it is recommended to set <a href="#visualMap.type">visualMap.type</a> explicitly, which avoids ambiguity.</p>\n',
    )
    realtime: Optional[bool] = Field(
        True,
        description='\n\n<p>Whether to update view in real time when dragging a handle.</p>\n<ul>\n<li><p>If <code class="codespan">true</code>, the chart view will be updated in real time when dragging.</p>\n</li>\n<li><p>If <code class="codespan">false</code>, the chart view will be updated at the end of the handle dragging.</p>\n</li>\n</ul>\n',
    )
    inverse: Optional[bool] = Field(
        False,
        description='\n\n<p>Whether to inverse the layout of visualMap component.</p>\n<p>As <code class="codespan">inverse</code> is <code class="codespan">false</code>, the layout direction is the same as <a href="#grid">cartesian coordinate</a>. That is:</p>\n<ul>\n<li>As <a href="#visualMap.orient">visualMap.orient</a> is <code class="codespan">&#39;vertical&#39;</code>, large data are placed at the top while small at the bottom.</li>\n<li>As <a href="#visualMap.orient">visualMap.orient</a> is <code class="codespan">&#39;horizontal&#39;</code>,  large data are placed on the right while small on the left.</li>\n</ul>\n<p>As <code class="codespan">inverse</code> is <code class="codespan">true</code>, the result is opposite.</p>\n',
    )
    precision: Optional[float] = Field(
        0,
        description='\n\n<p>The decimal precision of label, defaults to be 0 (no decimals).</p>\n',
    )
    itemWidth: Optional[float] = Field(
        20, description='\n\n<p>The width of the main bar of visualMap component.</p>\n'
    )
    itemHeight: Optional[float] = Field(
        140,
        description='\n\n<p>The height of the main bar of visualMap component.</p>\n',
    )
    align: Optional[str] = Field(
        'auto',
        description='\n\n<p>Specify the position of handles and labels, against the main bar. The possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;auto&#39;</code> Decide automatically.</li>\n<li><code class="codespan">&#39;left&#39;</code> The handles and labels are on the right, which is valid when <code class="codespan">orient</code> is set as <code class="codespan">&#39;horizontal&#39;</code>.</li>\n<li><code class="codespan">&#39;right&#39;</code> The handles and labels are on the left, which is valid when <code class="codespan">orient</code> is set as <code class="codespan">&#39;horizontal&#39;</code>.</li>\n<li><code class="codespan">&#39;top&#39;</code> the handles and labels are at the bottom, which is valid when <code class="codespan">orient</code> is set as  <code class="codespan">&#39;vertical&#39;</code>.</li>\n<li><code class="codespan">&#39;bottom&#39;</code> the handles and labels are at the top, which is valid when <code class="codespan">orient</code> is set as <code class="codespan">&#39;vertical&#39;</code>.</li>\n</ul>\n',
    )
    text: Optional[Any] = Field(
        None,
        description='<p>The label text on both ends, such as <code class="codespan">[&#39;High&#39;, &#39;Low&#39;]</code>. <a href="http://localhost/echarts-website/examples/en/editor.html?c=doc-example/map-visualMap-continuous-text&amp;edit=1&amp;reset=1" target="_blank">sample</a>.</p>\n<p>You can understand the order of items in <code class="codespan">text</code> array just by a simple trial. See <a href="#visualMap.inverse">visualMap.inverse</a>.</p>\n',
    )
    textGap: Optional[float] = Field(
        10,
        description='\n\n<p>The distance between the ends of the main bar and the label, with unit px. See <a href="#visualMap-continuous.text">visualMap-continuous.text</a></p>\n',
    )
    show: Optional[bool] = Field(
        True,
        description='<p>Whether to show visualMap-continuous component. If set as <code class="codespan">false</code>, visualMap-continuous component will not show, but it can still perform visual mapping from dataValue to visual channel in chart.</p>\n',
    )
    dimension: Optional[str] = Field(
        None,
        description='<p>Specify which dimension should be used to fetch dataValue from <a href="#series.data">series.data</a>, and then map them to visual channel.</p>\n<p><a href="#series.data">series.data</a> can be regarded as a two-dimensional array, for instance:</p>\n<pre><code class="lang-javascript">[\n    [12, 23, 43],\n    [12, 23, 43],\n    [43, 545, 65],\n    [92, 23, 33]\n]\n</code></pre>\n<p>Each column of the above array is regarded as a <code class="codespan">dimension</code>. For example, when property <code class="codespan">dimension</code> is set to 1, the second column (i.e., 23, 23, 545, 23) is chosen to perform visual mapping.</p>\n<p>Use the last dimension of <code class="codespan">data</code> by default.</p>\n',
    )
    seriesIndex: Optional[Union[float, Any]] = Field(
        None,
        description='<p>Specify visual mapping should be performed on which series, from which\n<a href="#series.data">series.data</a> is fetched.</p>\n<p>All series are used by default.</p>\n',
    )
    hoverLink: Optional[bool] = Field(
        True,
        description='<p><code class="codespan">hoverLink</code> enable highlight certain graphical elements of chart when mouse hovers on some place of <code class="codespan">visualMap</code> component that is coresponding to those graphical elements by visual mapping.</p>\n<p>Inversely, when mouse hovers a graphical element of chart, its value label will be displayed on its corresponding position in <code class="codespan">visualMap</code>.</p>\n',
    )
    inRange: Optional[Any] = Field(
        None,
        description='<p>Define visual channels that will mapped from dataValues that are <strong>in selected range</strong>. User can interact with visualMap component and make a seleced range by mouse or touch.</p>\n<ul>\n<li><code class="codespan">symbol</code>: Type of symbol.</li>\n<li><code class="codespan">symbolSize</code>: Symbol size.</li>\n<li><code class="codespan">color</code>: Symbol color.</li>\n<li><code class="codespan">colorAlpha</code>: Symbol alpha channel.</li>\n<li><code class="codespan">opacity</code>: Opacity of symbol and others (like labels).</li>\n<li><code class="codespan">colorLightness</code>: Lightness in <a href="https://en.wikipedia.org/wiki/HSL_and_HSV" target="_blank">HSL</a>.</li>\n<li><code class="codespan">colorSaturation</code>: Saturation in <a href="https://en.wikipedia.org/wiki/HSL_and_HSV" target="_blank">HSL</a>.</li>\n<li><code class="codespan">colorHue</code>: Hue in <a href="https://en.wikipedia.org/wiki/HSL_and_HSV" target="_blank">HSL</a>.</li>\n</ul>\n<p><code class="codespan">inRange</code> could customize visual channels both in series (by <a href="#visualMap-continuous.seriesIndex">visualMap-continuous.seriesIndex</a>) and in <code class="codespan">visualMap-continuous</code> itself.</p>\n<p>For instance, if a <code class="codespan">visualMap-continuous</code> component is used on a scatter chart, the mapping approach from data to <code class="codespan">color</code> (or <code class="codespan">symbol</code>, <code class="codespan">size</code>, ...) can be both customized in the scatter chart and <code class="codespan">visualMap-continuous</code> component itself. See the code as following:</p>\n<pre><code class="lang-javascript">visualMap: [\n    {\n        ...,\n        // Define visual channels both in target series and visualMap-continuous component itself:\n        inRange: {\n            color: [&#39;#121122&#39;, &#39;rgba(3,4,5,0.4)&#39;, &#39;red&#39;],\n            symbolSize: [30, 100]\n        }\n    }\n]\n</code></pre>\n<p>If you want to define visual channels for target series and visualMap-continuous component separately, you should do as follows:</p>\n<pre><code class="lang-javascript">visualMap: [\n    {\n        ...,\n        // Define visual channels only for target series.\n        target: {\n            inRange: {\n                color: [&#39;#121122&#39;, &#39;rgba(3,4,5,0.4)&#39;, &#39;red&#39;],\n                symbolSize: [60, 200]\n            }\n        },\n        // Define visual channels only for visualMap-continuous component.\n        controller: {\n            inRange: {\n                symbolSize: [30, 100]\n            }\n        }\n    }\n]\n</code></pre>\n<p>Or define as follows:</p>\n<pre><code class="lang-javascript">visualMap: [\n    {\n        ...,\n        // Define visual channels for both target series and visualMap-continuous component.\n        inRange: {\n            color: [&#39;#121122&#39;, &#39;rgba(3,4,5,0.4)&#39;, &#39;red&#39;],\n            symbolSize: [60, 200]\n        },\n        // Define visual channels only for visualMap-continuous component, which\n        // will overlap the properties with the same name in the above common\n        // definition. (symbolSize is overlapped by [30, 100] while color\n        // keeps the original value)\n        controller: {\n            inRange: {\n                symbolSize: [30, 100]\n            }\n        }\n    }\n]\n</code></pre>\n<p><br></p>\n<hr>\n<p><strong>✦ About visual channels ✦</strong></p>\n<ul>\n<li><p>Various visual channels (such as <code class="codespan">color</code>、<code class="codespan">symbolSize</code> and ect.) can be defined in inRange at the same time and all of them will be apopted.</p>\n</li>\n<li><p>Basically visual channels <code class="codespan">opacity</code> is recommended, rather than <code class="codespan">colorAlpha</code>. The former controls the transparency of both graphical element and its attachments (like label), whereas the latter only controls the transparency of graphical element.</p>\n</li>\n<li><p>There are two approaches of visual mapping supported: &#39;Linear Mapping&#39; and &#39;Table Mapping&#39;.</p>\n</li>\n</ul>\n<p><br></p>\n<hr>\n<p><strong>✦ Linear Mapping to visual channel ✦</strong></p>\n<p><code class="codespan">Linear Mapping</code> means that linear calculation will be performed on each dataValue (value of series.data), mapping them from the domain of <code class="codespan">[visaulMap.min, visualMap.max]</code> to a given range of <code class="codespan">[visual value 1, visual value 2]</code> and obtaining a final value (say visual value) for visual channel rendering.</p>\n<p>For instance, <code class="codespan">[visualMap.min, visualMap.max]</code> is set to be <code class="codespan">[0, 100]</code>, and there is series.data: <code class="codespan">[50, 10, 100]</code>. We intend to map them to an <code class="codespan">opacity</code> range <code class="codespan">[0.4, 1]</code>, by which the size of value can be demostrated by the transparency of graphical elements. visualMap component will then linear calculate them and get opacity values <code class="codespan">[0.7, 0.44, 1]</code>, cooresponding to each dataValue.</p>\n<p>We can also set the visual range inversely, such as <code class="codespan">opacity: [1, 0.4]</code>, and the final mapping result for the given series.data above will be <code class="codespan">[0.7, 0.96, 0.4]</code>.</p>\n<p>Notice: [visualMap.min, visualMap.max] should be set manually and is [0, 100] by default, but not <code class="codespan">dataMin</code> and <code class="codespan">dataMax</code> in series.data.</p>\n<p>How to configure visualMap component to do Linear Mapping?</p>\n<ul>\n<li><p>When use <a href="#visualMap-continuous">visualMap-continuous</a>, or</p>\n</li>\n<li><p>When use <a href="#visualMap-piecewise">visualMap-piecewise</a> and <a href="#visualMap-piecewise.categories">visualMap-piecewise.categories</a> is not used.</p>\n</li>\n</ul>\n<p>About the value of visual channel (visual value):</p>\n<ul>\n<li><p>Basically <code class="codespan">Array</code> is used to express the range of visual value, e.g., <code class="codespan">color: [&#39;#333&#39;, &#39;#777&#39;]</code>.</p>\n</li>\n<li><p>Single <code class="codespan">number</code> or single <code class="codespan">string</code> can also be used, which will be converted to an <code class="codespan">Array</code> by visualMap component. e.g.:  <code class="codespan">opacity: 0.4</code> will be converted to <code class="codespan">opacity: [0.4, 0.4]</code>, <code class="codespan">color: &#39;#333&#39;</code> will be converted to <code class="codespan">color: [&#39;#333&#39;, &#39;#333&#39;]</code>.</p>\n</li>\n<li><p>For visual channel <code class="codespan">symbolSize</code>, <code class="codespan">opacity</code>, <code class="codespan">colorAlpha</code>, <code class="codespan">colorLightness</code>, <code class="codespan">colorSaturation</code>, <code class="codespan">colorHue</code>, the range of visual value is always in the form of: <code class="codespan">[visual value of visualMap.min, visual value of visualMap.max]</code>. For example, <code class="codespan">colorLightness: [0.8, 0.2]</code> means that the dataValue in series.data that equals to <code class="codespan">visualMap.min</code> (if any) will be mapped to lightness <code class="codespan">0.8</code>, and the dataValue that equals to <code class="codespan">visualMap.max</code> (if any) will be mapped to lightness <code class="codespan">0.2</code>, and other dataValues will be mapped by the linear calculateion based on the domain of <code class="codespan">[visualMap.min, visualMap.max]</code> and the range of <code class="codespan">[0.8, 0.2]</code>.</p>\n</li>\n<li><p>For visual channel <code class="codespan">color</code>, array is used, like: <code class="codespan">[&#39;#333&#39;, &#39;#78ab23&#39;, &#39;blue&#39;]</code>, which means a color ribbon is formed based on the three color stops, and dataValues will be mapped to the ribbon. Specifically, the dataValue that equals to <code class="codespan">visualMap.min</code> will be mapped onto <code class="codespan">&#39;#333&#39;</code>, the dataValue that equals to <code class="codespan">visualMap.max</code> will be mapped onto <code class="codespan">&#39;blue&#39;</code>, and other dataValues will be piecewisely interpolated to get the final color.</p>\n</li>\n<li><p>For visual channel <code class="codespan">symbol</code>, array is used, like: <code class="codespan">[&#39;circle&#39;, &#39;rect&#39;, &#39;diamond&#39;]</code>, where the dataValue that equals to <code class="codespan">visualMap.min</code> will be mapped onto <code class="codespan">&#39;circle&#39;</code>, the dataValue that equals to <code class="codespan">visualMap.max</code> will be mapped onto <code class="codespan">&#39;diamond&#39;</code>, and other dataValues will be caculated based on the numerical distance to <code class="codespan">visualMax.min</code> and to <code class="codespan">visualMap.max</code>, and mapped onto one of <code class="codespan">&#39;circle&#39;</code>, <code class="codespan">&#39;rect&#39;</code>, <code class="codespan">&#39;diamond&#39;</code>.</p>\n</li>\n</ul>\n<p>About the possible value range of visual value:</p>\n<ul>\n<li><p><code class="codespan">opacity</code>、<code class="codespan">colorAlpha</code>、<code class="codespan">colorLightness</code>、<code class="codespan">colorSaturation</code>、<code class="codespan">visual value</code></p>\n<p>  possible value range is <code class="codespan">[0, 1]</code>.</p>\n</li>\n<li><p><code class="codespan">colorHue</code>：</p>\n<p>  possible value range is <code class="codespan">[0, 360]</code>.</p>\n</li>\n<li><p><code class="codespan">color</code>：</p>\n<p>  color can use RGB expression, like <code class="codespan">&#39;rgb(128, 128, 128)&#39;</code>, or RGBA expression, like <code class="codespan">&#39;rgba(128, 128, 128, 0.5)&#39;</code>, or Hex expression, like &#39;#ccc&#39;.</p>\n</li>\n<li><p><code class="codespan">symbol</code>：</p>\n</li>\n</ul>\n<p>Icon types provided by ECharts includes</p>\n<p><code class="codespan">&#39;circle&#39;</code>, <code class="codespan">&#39;rect&#39;</code>, <code class="codespan">&#39;roundRect&#39;</code>, <code class="codespan">&#39;triangle&#39;</code>, <code class="codespan">&#39;diamond&#39;</code>, <code class="codespan">&#39;pin&#39;</code>, <code class="codespan">&#39;arrow&#39;</code>, <code class="codespan">&#39;none&#39;</code></p>\n<p>It can be set to an image with <code class="codespan">&#39;image://url&#39;</code> , in which URL is the link to an image, or <code class="codespan">dataURI</code> of an image.</p>\n<p>An image URL example:</p>\n<pre><code>&#39;image://http://example.website/a/b.png&#39;\n</code></pre><p>A <code class="codespan">dataURI</code> example:</p>\n<pre><code>&#39;image://data:image/gif;base64,R0lGODlhEAAQAMQAAORHHOVSKudfOulrSOp3WOyDZu6QdvCchPGolfO0o/XBs/fNwfjZ0frl3/zy7////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAkAABAALAAAAAAQABAAAAVVICSOZGlCQAosJ6mu7fiyZeKqNKToQGDsM8hBADgUXoGAiqhSvp5QAnQKGIgUhwFUYLCVDFCrKUE1lBavAViFIDlTImbKC5Gm2hB0SlBCBMQiB0UjIQA7&#39;\n</code></pre><p>Icons can be set to arbitrary vector path via <code class="codespan">&#39;path://&#39;</code> in ECharts. As compared with a raster image, vector paths prevent jagging and blurring when scaled, and have better control over changing colors. The size of the vector icon will be adapted automatically. Refer to <a href="http://www.w3.org/TR/SVG/paths.html#PathData" target="_blank">SVG PathData</a> for more information about the format of the path. You may export vector paths from tools like Adobe </p>\n<p>For example:</p>\n<pre><code>&#39;path://M30.9,53.2C16.8,53.2,5.3,41.7,5.3,27.6S16.8,2,30.9,2C45,2,56.4,13.5,56.4,27.6S45,53.2,30.9,53.2z M30.9,3.5C17.6,3.5,6.8,14.4,6.8,27.6c0,13.3,10.8,24.1,24.101,24.1C44.2,51.7,55,40.9,55,27.6C54.9,14.4,44.1,3.5,30.9,3.5z M36.9,35.8c0,0.601-0.4,1-0.9,1h-1.3c-0.5,0-0.9-0.399-0.9-1V19.5c0-0.6,0.4-1,0.9-1H36c0.5,0,0.9,0.4,0.9,1V35.8z M27.8,35.8 c0,0.601-0.4,1-0.9,1h-1.3c-0.5,0-0.9-0.399-0.9-1V19.5c0-0.6,0.4-1,0.9-1H27c0.5,0,0.9,0.4,0.9,1L27.8,35.8L27.8,35.8z&#39;\n</code></pre><p><br></p>\n<hr>\n<p><strong>✦ Table Mapping to visual channel ✦</strong></p>\n<p><code class="codespan">Table Mapping</code> could be used when dataValue (values in series.data, specified by <a href="#visualMap.dimension">visualMap.dimension</a>) is enumerable and we intend to map them to visual value by looking up a given table.</p>\n<p>For instance, in a <a href="#visualMap-piecewise">visualMap-piecewise</a> component, <a href="#visualMap-piecewise.categories">visualMap-piecewise.categories</a> is set to <code class="codespan">[&#39;Demon Hunter&#39;, &#39;Blademaster&#39;, &#39;Death Knight&#39;, &#39;Warden&#39;, &#39;Paladin&#39;]</code>. And there is series.data: <code class="codespan">[&#39;Demon Hunter&#39;, &#39;Death Knight&#39;, &#39;Warden&#39;, &#39;Paladin&#39;]</code>. Then we can establish the lookup rule for color: <code class="codespan">color: {&#39;Warden&#39;: &#39;red&#39;, &#39;Demon Hunter&#39;: &#39;black&#39;}</code>, by which the <code class="codespan">visualMap</code> component will map <code class="codespan">dataValue</code> to <code class="codespan">color</code>.</p>\n<p>How to configure <code class="codespan">visualMap</code> component to do <code class="codespan">Table Mapping</code>?</p>\n<p>When use <a href="#visualMap-piecewise">visualMap-piecewise</a> and <a href="#visualMap-piecewise.categories">visualMap-piecewise.categories</a>is set.</p>\n<p>About the value of visual channel (visual value):</p>\n<p>Generally <code class="codespan">Object</code> or <code class="codespan">Array</code> is used, for instance:</p>\n<pre><code class="lang-javascript">visualMap: {\n    type: &#39;piecewise&#39;,\n    // categories defines the items that to be displayed in visualMap-piecewise component.\n    categories: [\n        &#39;Demon Hunter&#39;, &#39;Blademaster&#39;, &#39;Death Knight&#39;, &#39;Warden&#39;, &#39;Paladin&#39;\n    ],\n    inRange: {\n        // visual value can be an Object：\n        color: {\n            &#39;Warden&#39;: &#39;red&#39;,\n            &#39;Demon Hunter&#39;: &#39;black&#39;,\n            &#39;&#39;: &#39;green&#39; // Blank string means that except &#39;Warden&#39; and &#39;Demon Hunter&#39;,\n                        // all other dataValues should be mapped to &#39;green&#39;.\n        }\n        // visual value can also be a single value,\n        // means that all dataValues should be mapped to the value.\n        color: &#39;green&#39;,\n        // visual value can also be a array, with the same length\n        // as the array of categories and one-one mapping onto it.\n        color: [&#39;red&#39;, &#39;black&#39;, &#39;green&#39;, &#39;yellow&#39;, &#39;white&#39;]\n    }\n}\n</code></pre>\n<p><a href="http://localhost/echarts-website/examples/en/editor.html?c=doc-example/scatter-visualMap-categories&amp;edit=1&amp;reset=1" target="_blank">Example</a></p>\n<p><strong>✦ How to modity configurations of vsiual encoding? ✦</strong></p>\n<p>If you want to modify the configurations of visual encoding after chart been rendered (by invoke <code class="codespan">setOption</code> to set the initial <code class="codespan">option</code>), <code class="codespan">setOption</code> can be used again to modify configurations of visual encoding. For instance:</p>\n<pre><code class="lang-javascript">chart.setOption({\n    visualMap: {\n        inRange: {color: [&#39;red&#39;, &#39;blue&#39;]}\n    }\n});\n</code></pre>\n<p>Notice:</p>\n<ul>\n<li><p>These visualMap properties (i.e. <code class="codespan">inRange</code>, <code class="codespan">outOfRange</code>, <code class="codespan">target</code>, <code class="codespan">controller</code>) do not support &quot;merge&quot;, that is, anyone among them is modified when use <code class="codespan">setOption</code> again, all of the original values of them will not be kept but erased. The &quot;merge&quot; brings complication in implemnentation and understanding, whereas &quot;erase all&quot; normalize the practise: once you want to modify some visual values, you should pass all of them to <code class="codespan">setOption</code>, no matter they are to be changed.</p>\n</li>\n<li><p>This way, <code class="codespan">getOption() -&gt; modify the gotten option -&gt; setOption(modified option)</code>, is strongly <strong>not recommended</strong>, for instance:</p>\n</li>\n</ul>\n<pre><code class="lang-javascript">// Not recommended approach, regardless of its correctness:\n\nvar option = chart.getOption(); // Get the entire option.\noption.visualMap.inRange.color = [&#39;red&#39;, &#39;blue&#39;]; // modify color, which is what you want.\n\n// You have to modify those two properties, otherwise you will not get what you want.\noption.visualMap.target.inRange.color = [&#39;red&#39;, &#39;blue&#39;];\noption.visualMap.controller.inRange.color = [&#39;red&#39;, &#39;blue&#39;];\n\nchart.setOption(option); // set the modified option back.\n// You should not use this approach, but use the\n// approach demostrated before this example.\n</code></pre>\n<p><strong>Notice:</strong> There is default color <code class="codespan">[&#39;#f6efa6&#39;, &#39;#d88273&#39;, &#39;#bf444c&#39;]</code> in <code class="codespan">inRange</code> if you not set <code class="codespan">inRange</code>. If you dont want it, set <code class="codespan">inRange: {color: null}</code> to disable it.</p>\n',
    )
    outOfRange: Optional[Any] = Field(
        None,
        description='<p>Define visual channels that will mapped from dataValues that are <strong>out of selected range</strong>. User can interact with visualMap component and make a seleced range by mouse or touch.</p>\n<p>See available configurations in <a href="#visualMap-continuous.inRange">visualMap-continuous.inRange</a></p>\n',
    )
    controller: Optional[Controller] = Field(
        None,
        description='<p>Property <code class="codespan">inRange</code> and <code class="codespan">outOfRange</code> can be set within property <code class="codespan">controller</code>, which means those <code class="codespan">inRange</code> and <code class="codespan">outOfRange</code> are only used on the controller (<code class="codespan">visualMap</code> component itself), but are not used on chart (series). This property is useful in some scenarios when the view of controller needs to be customized in detail.</p>\n',
    )
    zlevel: Optional[float] = Field(
        0,
        description='<p><code class="codespan">zlevel</code> value of all graphical elements in .</p>\n<p><code class="codespan">zlevel</code> is used to make layers with Canvas. Graphical elements with different <code class="codespan">zlevel</code> values will be placed in different Canvases, which is a common optimization technique. We can put those frequently changed elements (like those with animations) to a separate <code class="codespan">zlevel</code>. Notice that too many Canvases will increase memory cost, and should be used carefully on mobile phones to avoid crash.</p>\n<p>Canvases with bigger <code class="codespan">zlevel</code> will be placed on Canvases with smaller <code class="codespan">zlevel</code>.</p>\n',
    )
    z: Optional[float] = Field(
        4,
        description='<p><code class="codespan">z</code> value of all graphical elements in , which controls order of drawing graphical components. Components with smaller <code class="codespan">z</code> values may be overwritten by those with larger <code class="codespan">z</code> values.</p>\n<p><code class="codespan">z</code> has a lower priority to <code class="codespan">zlevel</code>, and will not create new Canvas.</p>\n',
    )
    left: Optional[Union[str, float]] = Field(
        0,
        description='<p>Distance between visualMap  component and the left side of the container.</p>\n<p><code class="codespan">left</code> value can be instant pixel value like <code class="codespan">20</code>; it can also be a percentage value relative to container width like <code class="codespan">&#39;20%&#39;</code>; and it can also be <code class="codespan">&#39;left&#39;</code>, <code class="codespan">&#39;center&#39;</code>, or <code class="codespan">&#39;right&#39;</code>.</p>\n<p>If the <code class="codespan">left</code> value is set to be <code class="codespan">&#39;left&#39;</code>, <code class="codespan">&#39;center&#39;</code>, or <code class="codespan">&#39;right&#39;</code>, then the component will be aligned automatically based on position.</p>\n',
    )
    top: Optional[Union[str, float]] = Field(
        'auto',
        description='<p>Distance between visualMap  component and the top side of the container.</p>\n<p><code class="codespan">top</code> value can be instant pixel value like <code class="codespan">20</code>; it can also be a percentage value relative to container width like <code class="codespan">&#39;20%&#39;</code>; and it can also be <code class="codespan">&#39;top&#39;</code>, <code class="codespan">&#39;middle&#39;</code>, or <code class="codespan">&#39;bottom&#39;</code>.</p>\n<p>If the <code class="codespan">top</code> value is set to be <code class="codespan">&#39;top&#39;</code>, <code class="codespan">&#39;middle&#39;</code>, or <code class="codespan">&#39;bottom&#39;</code>, then the component will be aligned automatically based on position.</p>\n',
    )
    right: Optional[Union[str, float]] = Field(
        'auto',
        description='<p>Distance between visualMap  component and the right side of the container.</p>\n<p><code class="codespan">right</code> value can be instant pixel value like <code class="codespan">20</code>; it can also be a percentage value relative to container width like <code class="codespan">&#39;20%&#39;</code>.</p>\n',
    )
    bottom: Optional[Union[str, float]] = Field(
        0,
        description='<p>Distance between visualMap  component and the bottom side of the container.</p>\n<p><code class="codespan">bottom</code> value can be instant pixel value like <code class="codespan">20</code>; it can also be a percentage value relative to container width like <code class="codespan">&#39;20%&#39;</code>.</p>\n',
    )
    orient: Optional[str] = Field(
        'vertical',
        description='<p>How to layout the visualMap component, <code class="codespan">&#39;horizontal&#39;</code> or <code class="codespan">&#39;vertical&#39;</code>.</p>\n',
    )
    padding: Optional[Union[float, Any]] = Field(
        5,
        description='\n\n<p>visualMap-continuous space around content. The unit is px. Default values for each position are 5. And they can be set to different values with left, right, top, and bottom.</p>\n<p>Examples:</p>\n<pre><code class="lang-ts">// Set padding to be 5\npadding: 5\n// Set the top and bottom paddings to be 5, and left and right paddings to be 10\npadding: [5, 10]\n// Set each of the four paddings seperately\npadding: [\n    5,  // up\n    10, // right\n    5,  // down\n    10, // left\n]\n</code></pre>\n',
    )
    backgroundColor: Optional[Any] = Field(
        'rgba(0,0,0,0)', description='<p>background color of visualMap component.</p>\n'
    )
    borderColor: Optional[Any] = Field(
        '#ccc', description='<p>border color of visualMap component.</p>\n'
    )
    borderWidth: Optional[float] = Field(
        0, description='<p>border width of visualMap component, with unit: px.</p>\n'
    )
    color: Optional[Any] = Field(
        "['#bf444c', '#d88273', '#f6efa6']",
        description='<p>This property remains only for compatibility with ECharts2, and is not recommended in ECharts3. It is recommended to configure color in <a href="#visualMap-continuous.inRange">visualMap-continuous.inRange</a>, or <a href="#visualMap-continuous.outOfRange">visualMap-continuous.outOfRange</a> if needed.</p>\n<p>If you persist in using it, the following issue should be noticed: the sequence of dataValues that are mapped to colorValues in property <code class="codespan">color</code> is from <code class="codespan">large</code> to <code class="codespan">small</code>, whereas that in <a href="#visualMap-continuous.inRange">visualMap-continuous.inRange</a> or <a href="#visualMap-continuous.outOfRange">visualMap-continuous.outOfRange</a> is from <code class="codespan">small</code> to <code class="codespan">large</code>.</p>\n',
    )
    textStyle: Optional[TextStyle9] = Field(None, description='')
    formatter: Optional[Union[str, Any]] = Field(
        None,
        description='<p>the formatter tool for label.</p>\n<ul>\n<li><p>If it was set as a <code class="codespan">string</code>, it refers to a template, for instance: <code class="codespan">aaaa{value}bbbb</code>, where <code class="codespan">{value}</code> represents the value of the edge of the seleted range.</p>\n</li>\n<li><p>If it was set as a <code class="codespan">Function</code>, it refers to a callback function, for instance:</p>\n</li>\n</ul>\n<pre><code class="lang-javascript">formatter: function (value) {\n    return &#39;aaaa&#39; + value + &#39;bbbb&#39;;\n}\n</code></pre>\n',
    )
    handleIcon: Optional[str] = Field(
        None,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>Icon of drag handle.</p>\n<pre><code class="lang-ts">&#39;M-11.39,9.77h0a3.5,3.5,0,0,1-3.5,3.5h-22a3.5,3.5,0,0,1-3.5-3.5h0a3.5,3.5,0,0,1,3.5-3.5h22A3.5,3.5,0,0,1-11.39,9.77Z&#39;\n</code></pre>\n<p>It can be set to an image with <code class="codespan">&#39;image://url&#39;</code> , in which URL is the link to an image, or <code class="codespan">dataURI</code> of an image.</p>\n<p>An image URL example:</p>\n<pre><code>&#39;image://http://example.website/a/b.png&#39;\n</code></pre><p>A <code class="codespan">dataURI</code> example:</p>\n<pre><code>&#39;image://data:image/gif;base64,R0lGODlhEAAQAMQAAORHHOVSKudfOulrSOp3WOyDZu6QdvCchPGolfO0o/XBs/fNwfjZ0frl3/zy7////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAkAABAALAAAAAAQABAAAAVVICSOZGlCQAosJ6mu7fiyZeKqNKToQGDsM8hBADgUXoGAiqhSvp5QAnQKGIgUhwFUYLCVDFCrKUE1lBavAViFIDlTImbKC5Gm2hB0SlBCBMQiB0UjIQA7&#39;\n</code></pre><p>Icons can be set to arbitrary vector path via <code class="codespan">&#39;path://&#39;</code> in ECharts. As compared with a raster image, vector paths prevent jagging and blurring when scaled, and have better control over changing colors. The size of the vector icon will be adapted automatically. Refer to <a href="http://www.w3.org/TR/SVG/paths.html#PathData" target="_blank">SVG PathData</a> for more information about the format of the path. You may export vector paths from tools like Adobe </p>\n<p>For example:</p>\n<pre><code>&#39;path://M30.9,53.2C16.8,53.2,5.3,41.7,5.3,27.6S16.8,2,30.9,2C45,2,56.4,13.5,56.4,27.6S45,53.2,30.9,53.2z M30.9,3.5C17.6,3.5,6.8,14.4,6.8,27.6c0,13.3,10.8,24.1,24.101,24.1C44.2,51.7,55,40.9,55,27.6C54.9,14.4,44.1,3.5,30.9,3.5z M36.9,35.8c0,0.601-0.4,1-0.9,1h-1.3c-0.5,0-0.9-0.399-0.9-1V19.5c0-0.6,0.4-1,0.9-1H36c0.5,0,0.9,0.4,0.9,1V35.8z M27.8,35.8 c0,0.601-0.4,1-0.9,1h-1.3c-0.5,0-0.9-0.399-0.9-1V19.5c0-0.6,0.4-1,0.9-1H27c0.5,0,0.9,0.4,0.9,1L27.8,35.8L27.8,35.8z&#39;\n</code></pre>',
    )
    handleSize: Optional[Union[float, str]] = Field(
        '120%',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n<p>Size of drag handle. It can be a percent string.</p>\n',
    )
    handleStyle: Optional[HandleStyle2] = Field(
        None,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n<p>Style of drag handle.</p>\n',
    )
    indicatorIcon: Optional[str] = Field(
        'circle',
        description='<p>Icon of indicator.</p>\n<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n',
    )
    indicatorSize: Optional[Union[float, str]] = Field(
        '50%',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n<p>Size of indicator. It can be a percent string.</p>\n',
    )
    indicatorStyle: Optional[IndicatorStyle] = Field(
        None, description='<p>Style of indicator.</p>\n'
    )


class Controller1(BaseModel):
    """
    <p>Property <code class="codespan">inRange</code> and <code class="codespan">outOfRange</code> can be set within property <code class="codespan">controller</code>, which means those <code class="codespan">inRange</code> and <code class="codespan">outOfRange</code> are only used on the controller (<code class="codespan">visualMap</code> component itself), but are not used on chart (series). This property is useful in some scenarios when the view of controller needs to be customized in detail.</p>

    """

    inRange: Optional[Any] = Field(
        None,
        description='<p>Define visual channels that will mapped from dataValues that are <strong>in selected range</strong>. User can interact with visualMap component and make a seleced range by mouse or touch.</p>\n<p>See available configurations in <a href="#visualMap-piecewise.inRange">visualMap-piecewise.inRange</a></p>\n',
    )
    outOfRange: Optional[Any] = Field(
        None,
        description='<p>Define visual channels that will mapped from dataValues that are <strong>out of selected range</strong>. User can interact with visualMap component and make a seleced range by mouse or touch.</p>\n<p>See available configurations in <a href="#visualMap-piecewise.inRange">visualMap-piecewise.inRange</a></p>\n',
    )


class TextStyle10(TextStyle9):
    pass


class VisualMapItem1(BaseModel):
    """
        <p><strong>Piecewise visualMap component (visualMapPiecewise) </strong></p>
    <p> (Reference to <a href="#visualMap">the introduction of visual Map component (visualMap)</a>)</p>
    <p>Sample:</p>
    <iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=doc-example/scatter-visualMap-piecewise&edit=1&reset=1" width="600" height="400"></iframe>



    <p>Piecewise visualMap component works in one of the three modes:</p>
    <ul>
    <li><strong>CONTINUOUS-AVERAGE</strong>: The series.data is continuous and is divided into pieces averagely according to <a href="#visualMap-piecewise.splitNumber">visualMap-piecewise.splitNumber</a>.</li>
    <li><strong>CONTINUOUS-CUSTOMIZED</strong>: The series.data is continuous and is divided into pieces according to the given rule defined in <a href="#visualMap-piecewise.pieces">visualMap-piecewise.pieces</a>.</li>
    <li><strong>CATEGORY</strong>: The series.data is discrete and is categorized according to <a href="#visualMap-piecewise.categories">visualMap-piecewise.categories</a>.</li>
    </ul>
    <p><br>
    <br></p>

    """

    type: Optional[str] = Field(
        'piecewise',
        description='<p>Used to determine it is a piecewise visualMap component.</p>\n',
    )
    id: Optional[str] = Field(
        None,
        description='<p>Component ID, not specified by default. If specified, it can be used to refer the component in option or API.</p>\n',
    )
    splitNumber: Optional[float] = Field(
        5,
        description='\n\n<p>Continuous data can be divide into pieces averagely according to splitNumber, that is, if splitNumber is 5, data will be sliced into 5 pieces.</p>\n<p>The range of continuous data should be defined by <a href="#visualMap-piecewise.max">max</a> and <a href="#visualMap-piecewise.min">min</a>.</p>\n<p>If <a href="#visualMap-piecewise.pieces">visualMap-piecewise.pieces</a> or <a href="#visualMap-piecewise.categories">visualMap-piecewise.categories</a> is set up, the <code class="codespan">splitNumber</code> will not be used any more.</p>\n',
    )
    pieces: Optional[Any] = Field(
        None,
        description='<p>Used to customize how to slice continuous data, and some specific view style for some pieces. For instance:</p>\n<pre><code class="lang-javascript">pieces: [\n    // Range of a piece can be specified by property min and max,\n    // where min will be set as -Infinity if ignored,\n    // and max will be set as Infinity if ignored.\n    {min: 1500},\n    {min: 900, max: 1500},\n    {min: 310, max: 1000},\n    {min: 200, max: 300},\n    // Label of the piece can be specified.\n    {min: 10, max: 200, label: &#39;10 to 200 (custom label) &#39;},\n    // Color of the piece can be specified.\n    {value: 123, label: &#39;123 (custom special color) &#39;, color: &#39;grey&#39;},\n    {max: 5}\n]\n</code></pre>\n<p>These visual channel can be customized in each piece:</p>\n<ul>\n<li><code class="codespan">symbol</code>: Type of symbol.</li>\n<li><code class="codespan">symbolSize</code>: Symbol size.</li>\n<li><code class="codespan">color</code>: Symbol color.</li>\n<li><code class="codespan">colorAlpha</code>: Symbol alpha channel.</li>\n<li><code class="codespan">opacity</code>: Opacity of symbol and others (like labels).</li>\n<li><code class="codespan">colorLightness</code>: Lightness in <a href="https://en.wikipedia.org/wiki/HSL_and_HSV" target="_blank">HSL</a>.</li>\n<li><code class="codespan">colorSaturation</code>: Saturation in <a href="https://en.wikipedia.org/wiki/HSL_and_HSV" target="_blank">HSL</a>.</li>\n<li><code class="codespan">colorHue</code>: Hue in <a href="https://en.wikipedia.org/wiki/HSL_and_HSV" target="_blank">HSL</a>.</li>\n</ul>\n<p> (Notes: In ECharts2, <code class="codespan">pieces</code> is called <code class="codespan">splitList</code>, which is retained in ECharts3 for compatibility. But <code class="codespan">pieces</code> is recommended.)</p>\n<p>You would realize the sequence in <code class="codespan">pieces</code> by a simple trial. See more detailed rules in <a href="#visualMap.inverse">visualMap.inverse</a>.</p>\n',
    )
    categories: Optional[Any] = Field(
        None,
        description='<p>When dataValues in series.data (specified by <a href="#visualMap-piecewise.dimension">visualMap-piecewise.dimension</a>) are discrete (or also known as category data or enumerable data), and we intend to perform <strong>Table Mapping</strong> from dataValue to visual channels, <code class="codespan">categories</code> is used to describe the entire enumeration of data. For instance:</p>\n<pre><code class="lang-javascript">categories: [\n    &#39;Demon Hunter&#39;, &#39;Blademaster&#39;, &#39;Death Knight&#39;, &#39;Warden&#39;, &#39;Paladin&#39;\n],\n</code></pre>\n<p><a href="http://localhost/echarts-website/examples/en/editor.html?c=doc-example/scatter-visualMap-categories&amp;edit=1&amp;reset=1" target="_blank">Sample</a></p>\n<p>You would realize the sequence in <code class="codespan">categories</code> by a simple trial. See more detailed rules in <a href="#visualMap.inverse">visualMap.inverse</a>.</p>\n',
    )
    min: Optional[float] = Field(
        None,
        description='\n\n<p>Specify the min dataValue for the visualMap component. <code class="codespan">[visualMap.min, visualMax.max]</code> make up the domain of viusul mapping.</p>\n<p>In <strong>CONTINUOUS-CUSTOMIZED</strong> mode (i.e., <a href="#visualMap-piecewise.pieces">visualMap-piecewise.pieces</a> is used) or <strong>CATEGORY</strong> mode (i.e., <a href="#visualMap-piecewise.categories">visualMap-piecewise.categories</a> is used), <code class="codespan">max</code> and <code class="codespan">min</code> doesn&#39;t need to be specified.</p>\n<p>In <strong>CONTINUOUS-AVERAGE</strong> mode (i.e., <a href="#visualMap-piecewise.splitNumber">visualMap-piecewise.splitNumber</a> is used), they should be specified explicitly, and be <code class="codespan">[0, 200]</code> by default, but not <code class="codespan">dataMin</code> and <code class="codespan">dataMax</code> in series.data.</p>\n',
    )
    max: Optional[float] = Field(
        None,
        description='\n\n<p>Specify the max dataValue for the visualMap component. <code class="codespan">[visualMap.min, visualMax.max]</code> make up the domain of viusul mapping.</p>\n<p>In <strong>CONTINUOUS-CUSTOMIZED</strong> mode (i.e., <a href="#visualMap-piecewise.pieces">visualMap-piecewise.pieces</a> is used) or <strong>CATEGORY</strong> mode (i.e., <a href="#visualMap-piecewise.categories">visualMap-piecewise.categories</a> is used), <code class="codespan">max</code> and <code class="codespan">min</code> doesn&#39;t need to be specified.</p>\n<p>In <strong>CONTINUOUS-AVERAGE</strong> mode (i.e., <a href="#visualMap-piecewise.splitNumber">visualMap-piecewise.splitNumber</a> is used), they should be specified explicitly, and be <code class="codespan">[0, 200]</code> by default, but not <code class="codespan">dataMin</code> and <code class="codespan">dataMax</code> in series.data.</p>\n',
    )
    minOpen: Optional[bool] = Field(
        None,
        description='\n\n<p>This option works when <code class="codespan">type</code> is <code class="codespan">piecewise</code> and <code class="codespan">min</code>/<code class="codespan">max</code>/<code class="codespan">splitNumber</code> are set.</p>\n<p>If it is set as <code class="codespan">true</code>, an extra piece labeled with &quot;&lt; min&quot; will show.</p>\n',
    )
    maxOpen: Optional[bool] = Field(
        None,
        description='\n\n<p>This option works when <code class="codespan">type</code> is <code class="codespan">piecewise</code> and <code class="codespan">min</code>/<code class="codespan">max</code>/<code class="codespan">splitNumber</code> are set.</p>\n<p>If it is set as <code class="codespan">true</code>, an extra piece labeled with &quot;&gt; max&quot; will show.</p>\n',
    )
    selectedMode: Optional[Union[str, bool]] = Field(
        'multiple',
        description='\n\n<p>Selected Mode could be:</p>\n<ul>\n<li><code class="codespan">&#39;multiple&#39;</code> (multiple selection).</li>\n<li><code class="codespan">&#39;single&#39;</code> (single selection).</li>\n<li><code class="codespan">true</code> (single selection) since version <code class="codespan">5.3.3</code>.</li>\n<li><code class="codespan">false</code> (no selection) since version <code class="codespan">5.3.3</code>.</li>\n</ul>\n',
    )
    inverse: Optional[bool] = Field(
        False,
        description='\n\n<p>Whether to inverse the layout of visualMap component.</p>\n<ul>\n<li><p>In <strong>CONTINUOUS-AVERAGE</strong> mode (i.e., <a href="#visualMap-piecewise.splitNumber">visualMap-piecewise.splitNumber</a> is used), the rule of data layout is the same as <a href="#visualMap-continuous.inverse">visualMap-continuous.inverse</a>.</p>\n</li>\n<li><p>In <strong>CONTINUOUS-CUSTOMIZED</strong> mode (i.e., <a href="#visualMap-piecewise.pieces">visualMap-piecewise.pieces</a> is used) or <strong>CATEGORY</strong> mode (i.e., <a href="#visualMap-piecewise.categories">visualMap-piecewise.categories</a> is used), the layout of each piece is determined by the their order in the definition of <code class="codespan">pieces</code> or <code class="codespan">categories</code>, namely:</p>\n<ul>\n<li><p>When <code class="codespan">inverse</code> is <code class="codespan">false</code>:</p>\n<ul>\n<li><p>When <a href="#visualMap.orient">visualMap.orient</a> is <code class="codespan">&#39;vertical&#39;</code>, pieces[0] or categories[0] correspond to upward side.</p>\n</li>\n<li><p>When <a href="#visualMap.orient">visualMap.orient</a> is <code class="codespan">&#39;horizontal&#39;</code>, pieces[0] or categories[0] correspond to left side.</p>\n</li>\n</ul>\n</li>\n<li><p>When <code class="codespan">inverse</code> is <code class="codespan">true</code>, the results are opposite to above.</p>\n</li>\n</ul>\n</li>\n</ul>\n<p>If you just have a try, you&#39;ll know it is not so complicated.</p>\n',
    )
    precision: Optional[float] = Field(
        None,
        description='\n\n<p>The decimal precision of label, defaults to be 0 (no decimals).</p>\n<ul>\n<li><p>In <strong>CONTINUOUS-AVERAGE</strong> mode (i.e., <a href="#visualMap-piecewise.splitNumber">visualMap-piecewise.splitNumber</a> is used), the rule of data layout is the same as <a href="#visualMap-continuous.inverse">visualMap-continuous.inverse</a>, decimal percision auto adapts to series.data.</p>\n</li>\n<li><p>In <strong>CONTINUOUS-CUSTOMIZED</strong> mode (i.e., <a href="#visualMap-piecewise.pieces">visualMap-piecewise.pieces</a> is used) or <strong>CATEGORY</strong> mode (i.e., <a href="#visualMap-piecewise.categories">visualMap-piecewise.categories</a> is used), decimal percision defaults to be 0 (no decimals):</p>\n</li>\n</ul>\n',
    )
    itemWidth: Optional[float] = Field(
        20,
        description='\n\n<p>The width of each graphical element that represents a piece.</p>\n',
    )
    itemHeight: Optional[float] = Field(
        14,
        description='\n\n<p>The height of each graphical element that represents a piece.</p>\n',
    )
    align: Optional[str] = Field(
        'auto',
        description='\n\n<p>The layout relationship between the graphical elements for pieces and their labels. Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;auto&#39;</code> Decide automatically.</li>\n<li><code class="codespan">&#39;left&#39;</code> The graphical elements for pieces are on the left and their labels are on the right.</li>\n<li><code class="codespan">&#39;right&#39;</code> The graphical elements for pieces are on the right and their labels are on the left.</li>\n</ul>\n',
    )
    text: Optional[Any] = Field(
        None,
        description='<p>The label text on both ends, such as <code class="codespan">[&#39;High&#39;, &#39;Low&#39;]</code>. <a href="http://localhost/echarts-website/examples/en/editor.html?c=doc-example/map-visualMap-piecewise-text&amp;edit=1&amp;reset=1" target="_blank">Sample</a>.</p>\n<p>You can understand the order of items in <code class="codespan">text</code> array just by a simple trial. See <a href="#visualMap.inverse">visualMap.inverse</a>.</p>\n<p>The rule, that labels will not show when <code class="codespan">text</code> is use, is retained for compatibility with ECharts2.</p>\n',
    )
    textGap: Optional[float] = Field(
        10,
        description='\n\n<p>The distance between the ends of the graphical elements for pieces and the labels, with unit px. See <a href="#visualMap-piecewise.text">visualMap-piecewise.text</a></p>\n',
    )
    showLabel: Optional[bool] = Field(
        None,
        description='\n\n<p>Whether to show label of each item. By default, label will not be shown when <a href="#visualMap-piecewise.text">visualMap-piecewise.text</a> used, otherwise label will be shown.</p>\n',
    )
    itemGap: Optional[Any] = Field(
        10,
        description='\n\n<p>Its the distance between each two graphical elements for pieces. The unit is px.</p>\n',
    )
    itemSymbol: Optional[str] = Field(
        'roundRect',
        description='<p>Default symbol (the shape of graphical element). Possible values are:</p>\n<p><code class="codespan">&#39;circle&#39;</code>, <code class="codespan">&#39;rect&#39;</code>, <code class="codespan">&#39;roundRect&#39;</code>, <code class="codespan">&#39;triangle&#39;</code>, <code class="codespan">&#39;diamond&#39;</code>, <code class="codespan">&#39;pin&#39;</code>, <code class="codespan">&#39;arrow&#39;</code>, <code class="codespan">&#39;none&#39;</code></p>\n<p>The setting of visual channel <code class="codespan">symbol</code> can refer to <a href="#visualMap-piecewise.inRange">visualMap-piecewise.inRange</a> and <a href="#visualMap-piecewise.outOfRange">visualMap-piecewise.outOfRange</a>.</p>\n<p>When they are not specified, <code class="codespan">itemSymbol</code> is adopted as the default value (but just used in visualMap component itself, not in chart).</p>\n',
    )
    show: Optional[bool] = Field(
        True,
        description='<p>Whether to show visualMap-piecewise component. If set as <code class="codespan">false</code>, visualMap-piecewise component will not show, but it can still perform visual mapping from dataValue to visual channel in chart.</p>\n',
    )
    dimension: Optional[str] = Field(
        None,
        description='<p>Specify which dimension should be used to fetch dataValue from <a href="#series.data">series.data</a>, and then map them to visual channel.</p>\n<p><a href="#series.data">series.data</a> can be regarded as a two-dimensional array, for instance:</p>\n<pre><code class="lang-javascript">[\n    [12, 23, 43],\n    [12, 23, 43],\n    [43, 545, 65],\n    [92, 23, 33]\n]\n</code></pre>\n<p>Each column of the above array is regarded as a <code class="codespan">dimension</code>. For example, when property <code class="codespan">dimension</code> is set to 1, the second column (i.e., 23, 23, 545, 23) is chosen to perform visual mapping.</p>\n<p>Use the last dimension of <code class="codespan">data</code> by default.</p>\n',
    )
    seriesIndex: Optional[Union[float, Any]] = Field(
        None,
        description='<p>Specify visual mapping should be performed on which series, from which\n<a href="#series.data">series.data</a> is fetched.</p>\n<p>All series are used by default.</p>\n',
    )
    hoverLink: Optional[bool] = Field(
        True,
        description='<p><code class="codespan">hoverLink</code> enable highlight certain graphical elements of chart when mouse hovers on some place of <code class="codespan">visualMap</code> component that is coresponding to those graphical elements by visual mapping.</p>\n<p>Inversely, when mouse hovers a graphical element of chart, its value label will be displayed on its corresponding position in <code class="codespan">visualMap</code>.</p>\n',
    )
    inRange: Optional[Any] = Field(
        None,
        description='<p>Define visual channels that will mapped from dataValues that are <strong>in selected range</strong>. User can interact with visualMap component and make a seleced range by mouse or touch.</p>\n<ul>\n<li><code class="codespan">symbol</code>: Type of symbol.</li>\n<li><code class="codespan">symbolSize</code>: Symbol size.</li>\n<li><code class="codespan">color</code>: Symbol color.</li>\n<li><code class="codespan">colorAlpha</code>: Symbol alpha channel.</li>\n<li><code class="codespan">opacity</code>: Opacity of symbol and others (like labels).</li>\n<li><code class="codespan">colorLightness</code>: Lightness in <a href="https://en.wikipedia.org/wiki/HSL_and_HSV" target="_blank">HSL</a>.</li>\n<li><code class="codespan">colorSaturation</code>: Saturation in <a href="https://en.wikipedia.org/wiki/HSL_and_HSV" target="_blank">HSL</a>.</li>\n<li><code class="codespan">colorHue</code>: Hue in <a href="https://en.wikipedia.org/wiki/HSL_and_HSV" target="_blank">HSL</a>.</li>\n</ul>\n<p><code class="codespan">inRange</code> could customize visual channels both in series (by <a href="#visualMap-piecewise.seriesIndex">visualMap-piecewise.seriesIndex</a>) and in <code class="codespan">visualMap-piecewise</code> itself.</p>\n<p>For instance, if a <code class="codespan">visualMap-piecewise</code> component is used on a scatter chart, the mapping approach from data to <code class="codespan">color</code> (or <code class="codespan">symbol</code>, <code class="codespan">size</code>, ...) can be both customized in the scatter chart and <code class="codespan">visualMap-piecewise</code> component itself. See the code as following:</p>\n<pre><code class="lang-javascript">visualMap: [\n    {\n        ...,\n        // Define visual channels both in target series and visualMap-piecewise component itself:\n        inRange: {\n            color: [&#39;#121122&#39;, &#39;rgba(3,4,5,0.4)&#39;, &#39;red&#39;],\n            symbolSize: [30, 100]\n        }\n    }\n]\n</code></pre>\n<p>If you want to define visual channels for target series and visualMap-piecewise component separately, you should do as follows:</p>\n<pre><code class="lang-javascript">visualMap: [\n    {\n        ...,\n        // Define visual channels only for target series.\n        target: {\n            inRange: {\n                color: [&#39;#121122&#39;, &#39;rgba(3,4,5,0.4)&#39;, &#39;red&#39;],\n                symbolSize: [60, 200]\n            }\n        },\n        // Define visual channels only for visualMap-piecewise component.\n        controller: {\n            inRange: {\n                symbolSize: [30, 100]\n            }\n        }\n    }\n]\n</code></pre>\n<p>Or define as follows:</p>\n<pre><code class="lang-javascript">visualMap: [\n    {\n        ...,\n        // Define visual channels for both target series and visualMap-piecewise component.\n        inRange: {\n            color: [&#39;#121122&#39;, &#39;rgba(3,4,5,0.4)&#39;, &#39;red&#39;],\n            symbolSize: [60, 200]\n        },\n        // Define visual channels only for visualMap-piecewise component, which\n        // will overlap the properties with the same name in the above common\n        // definition. (symbolSize is overlapped by [30, 100] while color\n        // keeps the original value)\n        controller: {\n            inRange: {\n                symbolSize: [30, 100]\n            }\n        }\n    }\n]\n</code></pre>\n<p><br></p>\n<hr>\n<p><strong>✦ About visual channels ✦</strong></p>\n<ul>\n<li><p>Various visual channels (such as <code class="codespan">color</code>、<code class="codespan">symbolSize</code> and ect.) can be defined in inRange at the same time and all of them will be apopted.</p>\n</li>\n<li><p>Basically visual channels <code class="codespan">opacity</code> is recommended, rather than <code class="codespan">colorAlpha</code>. The former controls the transparency of both graphical element and its attachments (like label), whereas the latter only controls the transparency of graphical element.</p>\n</li>\n<li><p>There are two approaches of visual mapping supported: &#39;Linear Mapping&#39; and &#39;Table Mapping&#39;.</p>\n</li>\n</ul>\n<p><br></p>\n<hr>\n<p><strong>✦ Linear Mapping to visual channel ✦</strong></p>\n<p><code class="codespan">Linear Mapping</code> means that linear calculation will be performed on each dataValue (value of series.data), mapping them from the domain of <code class="codespan">[visaulMap.min, visualMap.max]</code> to a given range of <code class="codespan">[visual value 1, visual value 2]</code> and obtaining a final value (say visual value) for visual channel rendering.</p>\n<p>For instance, <code class="codespan">[visualMap.min, visualMap.max]</code> is set to be <code class="codespan">[0, 100]</code>, and there is series.data: <code class="codespan">[50, 10, 100]</code>. We intend to map them to an <code class="codespan">opacity</code> range <code class="codespan">[0.4, 1]</code>, by which the size of value can be demostrated by the transparency of graphical elements. visualMap component will then linear calculate them and get opacity values <code class="codespan">[0.7, 0.44, 1]</code>, cooresponding to each dataValue.</p>\n<p>We can also set the visual range inversely, such as <code class="codespan">opacity: [1, 0.4]</code>, and the final mapping result for the given series.data above will be <code class="codespan">[0.7, 0.96, 0.4]</code>.</p>\n<p>Notice: [visualMap.min, visualMap.max] should be set manually and is [0, 100] by default, but not <code class="codespan">dataMin</code> and <code class="codespan">dataMax</code> in series.data.</p>\n<p>How to configure visualMap component to do Linear Mapping?</p>\n<ul>\n<li><p>When use <a href="#visualMap-continuous">visualMap-continuous</a>, or</p>\n</li>\n<li><p>When use <a href="#visualMap-piecewise">visualMap-piecewise</a> and <a href="#visualMap-piecewise.categories">visualMap-piecewise.categories</a> is not used.</p>\n</li>\n</ul>\n<p>About the value of visual channel (visual value):</p>\n<ul>\n<li><p>Basically <code class="codespan">Array</code> is used to express the range of visual value, e.g., <code class="codespan">color: [&#39;#333&#39;, &#39;#777&#39;]</code>.</p>\n</li>\n<li><p>Single <code class="codespan">number</code> or single <code class="codespan">string</code> can also be used, which will be converted to an <code class="codespan">Array</code> by visualMap component. e.g.:  <code class="codespan">opacity: 0.4</code> will be converted to <code class="codespan">opacity: [0.4, 0.4]</code>, <code class="codespan">color: &#39;#333&#39;</code> will be converted to <code class="codespan">color: [&#39;#333&#39;, &#39;#333&#39;]</code>.</p>\n</li>\n<li><p>For visual channel <code class="codespan">symbolSize</code>, <code class="codespan">opacity</code>, <code class="codespan">colorAlpha</code>, <code class="codespan">colorLightness</code>, <code class="codespan">colorSaturation</code>, <code class="codespan">colorHue</code>, the range of visual value is always in the form of: <code class="codespan">[visual value of visualMap.min, visual value of visualMap.max]</code>. For example, <code class="codespan">colorLightness: [0.8, 0.2]</code> means that the dataValue in series.data that equals to <code class="codespan">visualMap.min</code> (if any) will be mapped to lightness <code class="codespan">0.8</code>, and the dataValue that equals to <code class="codespan">visualMap.max</code> (if any) will be mapped to lightness <code class="codespan">0.2</code>, and other dataValues will be mapped by the linear calculateion based on the domain of <code class="codespan">[visualMap.min, visualMap.max]</code> and the range of <code class="codespan">[0.8, 0.2]</code>.</p>\n</li>\n<li><p>For visual channel <code class="codespan">color</code>, array is used, like: <code class="codespan">[&#39;#333&#39;, &#39;#78ab23&#39;, &#39;blue&#39;]</code>, which means a color ribbon is formed based on the three color stops, and dataValues will be mapped to the ribbon. Specifically, the dataValue that equals to <code class="codespan">visualMap.min</code> will be mapped onto <code class="codespan">&#39;#333&#39;</code>, the dataValue that equals to <code class="codespan">visualMap.max</code> will be mapped onto <code class="codespan">&#39;blue&#39;</code>, and other dataValues will be piecewisely interpolated to get the final color.</p>\n</li>\n<li><p>For visual channel <code class="codespan">symbol</code>, array is used, like: <code class="codespan">[&#39;circle&#39;, &#39;rect&#39;, &#39;diamond&#39;]</code>, where the dataValue that equals to <code class="codespan">visualMap.min</code> will be mapped onto <code class="codespan">&#39;circle&#39;</code>, the dataValue that equals to <code class="codespan">visualMap.max</code> will be mapped onto <code class="codespan">&#39;diamond&#39;</code>, and other dataValues will be caculated based on the numerical distance to <code class="codespan">visualMax.min</code> and to <code class="codespan">visualMap.max</code>, and mapped onto one of <code class="codespan">&#39;circle&#39;</code>, <code class="codespan">&#39;rect&#39;</code>, <code class="codespan">&#39;diamond&#39;</code>.</p>\n</li>\n</ul>\n<p>About the possible value range of visual value:</p>\n<ul>\n<li><p><code class="codespan">opacity</code>、<code class="codespan">colorAlpha</code>、<code class="codespan">colorLightness</code>、<code class="codespan">colorSaturation</code>、<code class="codespan">visual value</code></p>\n<p>  possible value range is <code class="codespan">[0, 1]</code>.</p>\n</li>\n<li><p><code class="codespan">colorHue</code>：</p>\n<p>  possible value range is <code class="codespan">[0, 360]</code>.</p>\n</li>\n<li><p><code class="codespan">color</code>：</p>\n<p>  color can use RGB expression, like <code class="codespan">&#39;rgb(128, 128, 128)&#39;</code>, or RGBA expression, like <code class="codespan">&#39;rgba(128, 128, 128, 0.5)&#39;</code>, or Hex expression, like &#39;#ccc&#39;.</p>\n</li>\n<li><p><code class="codespan">symbol</code>：</p>\n</li>\n</ul>\n<p>Icon types provided by ECharts includes</p>\n<p><code class="codespan">&#39;circle&#39;</code>, <code class="codespan">&#39;rect&#39;</code>, <code class="codespan">&#39;roundRect&#39;</code>, <code class="codespan">&#39;triangle&#39;</code>, <code class="codespan">&#39;diamond&#39;</code>, <code class="codespan">&#39;pin&#39;</code>, <code class="codespan">&#39;arrow&#39;</code>, <code class="codespan">&#39;none&#39;</code></p>\n<p>It can be set to an image with <code class="codespan">&#39;image://url&#39;</code> , in which URL is the link to an image, or <code class="codespan">dataURI</code> of an image.</p>\n<p>An image URL example:</p>\n<pre><code>&#39;image://http://example.website/a/b.png&#39;\n</code></pre><p>A <code class="codespan">dataURI</code> example:</p>\n<pre><code>&#39;image://data:image/gif;base64,R0lGODlhEAAQAMQAAORHHOVSKudfOulrSOp3WOyDZu6QdvCchPGolfO0o/XBs/fNwfjZ0frl3/zy7////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAkAABAALAAAAAAQABAAAAVVICSOZGlCQAosJ6mu7fiyZeKqNKToQGDsM8hBADgUXoGAiqhSvp5QAnQKGIgUhwFUYLCVDFCrKUE1lBavAViFIDlTImbKC5Gm2hB0SlBCBMQiB0UjIQA7&#39;\n</code></pre><p>Icons can be set to arbitrary vector path via <code class="codespan">&#39;path://&#39;</code> in ECharts. As compared with a raster image, vector paths prevent jagging and blurring when scaled, and have better control over changing colors. The size of the vector icon will be adapted automatically. Refer to <a href="http://www.w3.org/TR/SVG/paths.html#PathData" target="_blank">SVG PathData</a> for more information about the format of the path. You may export vector paths from tools like Adobe </p>\n<p>For example:</p>\n<pre><code>&#39;path://M30.9,53.2C16.8,53.2,5.3,41.7,5.3,27.6S16.8,2,30.9,2C45,2,56.4,13.5,56.4,27.6S45,53.2,30.9,53.2z M30.9,3.5C17.6,3.5,6.8,14.4,6.8,27.6c0,13.3,10.8,24.1,24.101,24.1C44.2,51.7,55,40.9,55,27.6C54.9,14.4,44.1,3.5,30.9,3.5z M36.9,35.8c0,0.601-0.4,1-0.9,1h-1.3c-0.5,0-0.9-0.399-0.9-1V19.5c0-0.6,0.4-1,0.9-1H36c0.5,0,0.9,0.4,0.9,1V35.8z M27.8,35.8 c0,0.601-0.4,1-0.9,1h-1.3c-0.5,0-0.9-0.399-0.9-1V19.5c0-0.6,0.4-1,0.9-1H27c0.5,0,0.9,0.4,0.9,1L27.8,35.8L27.8,35.8z&#39;\n</code></pre><p><br></p>\n<hr>\n<p><strong>✦ Table Mapping to visual channel ✦</strong></p>\n<p><code class="codespan">Table Mapping</code> could be used when dataValue (values in series.data, specified by <a href="#visualMap.dimension">visualMap.dimension</a>) is enumerable and we intend to map them to visual value by looking up a given table.</p>\n<p>For instance, in a <a href="#visualMap-piecewise">visualMap-piecewise</a> component, <a href="#visualMap-piecewise.categories">visualMap-piecewise.categories</a> is set to <code class="codespan">[&#39;Demon Hunter&#39;, &#39;Blademaster&#39;, &#39;Death Knight&#39;, &#39;Warden&#39;, &#39;Paladin&#39;]</code>. And there is series.data: <code class="codespan">[&#39;Demon Hunter&#39;, &#39;Death Knight&#39;, &#39;Warden&#39;, &#39;Paladin&#39;]</code>. Then we can establish the lookup rule for color: <code class="codespan">color: {&#39;Warden&#39;: &#39;red&#39;, &#39;Demon Hunter&#39;: &#39;black&#39;}</code>, by which the <code class="codespan">visualMap</code> component will map <code class="codespan">dataValue</code> to <code class="codespan">color</code>.</p>\n<p>How to configure <code class="codespan">visualMap</code> component to do <code class="codespan">Table Mapping</code>?</p>\n<p>When use <a href="#visualMap-piecewise">visualMap-piecewise</a> and <a href="#visualMap-piecewise.categories">visualMap-piecewise.categories</a>is set.</p>\n<p>About the value of visual channel (visual value):</p>\n<p>Generally <code class="codespan">Object</code> or <code class="codespan">Array</code> is used, for instance:</p>\n<pre><code class="lang-javascript">visualMap: {\n    type: &#39;piecewise&#39;,\n    // categories defines the items that to be displayed in visualMap-piecewise component.\n    categories: [\n        &#39;Demon Hunter&#39;, &#39;Blademaster&#39;, &#39;Death Knight&#39;, &#39;Warden&#39;, &#39;Paladin&#39;\n    ],\n    inRange: {\n        // visual value can be an Object：\n        color: {\n            &#39;Warden&#39;: &#39;red&#39;,\n            &#39;Demon Hunter&#39;: &#39;black&#39;,\n            &#39;&#39;: &#39;green&#39; // Blank string means that except &#39;Warden&#39; and &#39;Demon Hunter&#39;,\n                        // all other dataValues should be mapped to &#39;green&#39;.\n        }\n        // visual value can also be a single value,\n        // means that all dataValues should be mapped to the value.\n        color: &#39;green&#39;,\n        // visual value can also be a array, with the same length\n        // as the array of categories and one-one mapping onto it.\n        color: [&#39;red&#39;, &#39;black&#39;, &#39;green&#39;, &#39;yellow&#39;, &#39;white&#39;]\n    }\n}\n</code></pre>\n<p><a href="http://localhost/echarts-website/examples/en/editor.html?c=doc-example/scatter-visualMap-categories&amp;edit=1&amp;reset=1" target="_blank">Example</a></p>\n<p><strong>✦ How to modity configurations of vsiual encoding? ✦</strong></p>\n<p>If you want to modify the configurations of visual encoding after chart been rendered (by invoke <code class="codespan">setOption</code> to set the initial <code class="codespan">option</code>), <code class="codespan">setOption</code> can be used again to modify configurations of visual encoding. For instance:</p>\n<pre><code class="lang-javascript">chart.setOption({\n    visualMap: {\n        inRange: {color: [&#39;red&#39;, &#39;blue&#39;]}\n    }\n});\n</code></pre>\n<p>Notice:</p>\n<ul>\n<li><p>These visualMap properties (i.e. <code class="codespan">inRange</code>, <code class="codespan">outOfRange</code>, <code class="codespan">target</code>, <code class="codespan">controller</code>) do not support &quot;merge&quot;, that is, anyone among them is modified when use <code class="codespan">setOption</code> again, all of the original values of them will not be kept but erased. The &quot;merge&quot; brings complication in implemnentation and understanding, whereas &quot;erase all&quot; normalize the practise: once you want to modify some visual values, you should pass all of them to <code class="codespan">setOption</code>, no matter they are to be changed.</p>\n</li>\n<li><p>This way, <code class="codespan">getOption() -&gt; modify the gotten option -&gt; setOption(modified option)</code>, is strongly <strong>not recommended</strong>, for instance:</p>\n</li>\n</ul>\n<pre><code class="lang-javascript">// Not recommended approach, regardless of its correctness:\n\nvar option = chart.getOption(); // Get the entire option.\noption.visualMap.inRange.color = [&#39;red&#39;, &#39;blue&#39;]; // modify color, which is what you want.\n\n// You have to modify those two properties, otherwise you will not get what you want.\noption.visualMap.target.inRange.color = [&#39;red&#39;, &#39;blue&#39;];\noption.visualMap.controller.inRange.color = [&#39;red&#39;, &#39;blue&#39;];\n\nchart.setOption(option); // set the modified option back.\n// You should not use this approach, but use the\n// approach demostrated before this example.\n</code></pre>\n<p><strong>Notice:</strong> There is default color <code class="codespan">[&#39;#f6efa6&#39;, &#39;#d88273&#39;, &#39;#bf444c&#39;]</code> in <code class="codespan">inRange</code> if you not set <code class="codespan">inRange</code>. If you dont want it, set <code class="codespan">inRange: {color: null}</code> to disable it.</p>\n',
    )
    outOfRange: Optional[Any] = Field(
        None,
        description='<p>Define visual channels that will mapped from dataValues that are <strong>out of selected range</strong>. User can interact with visualMap component and make a seleced range by mouse or touch.</p>\n<p>See available configurations in <a href="#visualMap-piecewise.inRange">visualMap-piecewise.inRange</a></p>\n',
    )
    controller: Optional[Controller1] = Field(
        None,
        description='<p>Property <code class="codespan">inRange</code> and <code class="codespan">outOfRange</code> can be set within property <code class="codespan">controller</code>, which means those <code class="codespan">inRange</code> and <code class="codespan">outOfRange</code> are only used on the controller (<code class="codespan">visualMap</code> component itself), but are not used on chart (series). This property is useful in some scenarios when the view of controller needs to be customized in detail.</p>\n',
    )
    zlevel: Optional[float] = Field(
        0,
        description='<p><code class="codespan">zlevel</code> value of all graphical elements in .</p>\n<p><code class="codespan">zlevel</code> is used to make layers with Canvas. Graphical elements with different <code class="codespan">zlevel</code> values will be placed in different Canvases, which is a common optimization technique. We can put those frequently changed elements (like those with animations) to a separate <code class="codespan">zlevel</code>. Notice that too many Canvases will increase memory cost, and should be used carefully on mobile phones to avoid crash.</p>\n<p>Canvases with bigger <code class="codespan">zlevel</code> will be placed on Canvases with smaller <code class="codespan">zlevel</code>.</p>\n',
    )
    z: Optional[float] = Field(
        4,
        description='<p><code class="codespan">z</code> value of all graphical elements in , which controls order of drawing graphical components. Components with smaller <code class="codespan">z</code> values may be overwritten by those with larger <code class="codespan">z</code> values.</p>\n<p><code class="codespan">z</code> has a lower priority to <code class="codespan">zlevel</code>, and will not create new Canvas.</p>\n',
    )
    left: Optional[Union[str, float]] = Field(
        0,
        description='<p>Distance between visualMap  component and the left side of the container.</p>\n<p><code class="codespan">left</code> value can be instant pixel value like <code class="codespan">20</code>; it can also be a percentage value relative to container width like <code class="codespan">&#39;20%&#39;</code>; and it can also be <code class="codespan">&#39;left&#39;</code>, <code class="codespan">&#39;center&#39;</code>, or <code class="codespan">&#39;right&#39;</code>.</p>\n<p>If the <code class="codespan">left</code> value is set to be <code class="codespan">&#39;left&#39;</code>, <code class="codespan">&#39;center&#39;</code>, or <code class="codespan">&#39;right&#39;</code>, then the component will be aligned automatically based on position.</p>\n',
    )
    top: Optional[Union[str, float]] = Field(
        'auto',
        description='<p>Distance between visualMap  component and the top side of the container.</p>\n<p><code class="codespan">top</code> value can be instant pixel value like <code class="codespan">20</code>; it can also be a percentage value relative to container width like <code class="codespan">&#39;20%&#39;</code>; and it can also be <code class="codespan">&#39;top&#39;</code>, <code class="codespan">&#39;middle&#39;</code>, or <code class="codespan">&#39;bottom&#39;</code>.</p>\n<p>If the <code class="codespan">top</code> value is set to be <code class="codespan">&#39;top&#39;</code>, <code class="codespan">&#39;middle&#39;</code>, or <code class="codespan">&#39;bottom&#39;</code>, then the component will be aligned automatically based on position.</p>\n',
    )
    right: Optional[Union[str, float]] = Field(
        'auto',
        description='<p>Distance between visualMap  component and the right side of the container.</p>\n<p><code class="codespan">right</code> value can be instant pixel value like <code class="codespan">20</code>; it can also be a percentage value relative to container width like <code class="codespan">&#39;20%&#39;</code>.</p>\n',
    )
    bottom: Optional[Union[str, float]] = Field(
        0,
        description='<p>Distance between visualMap  component and the bottom side of the container.</p>\n<p><code class="codespan">bottom</code> value can be instant pixel value like <code class="codespan">20</code>; it can also be a percentage value relative to container width like <code class="codespan">&#39;20%&#39;</code>.</p>\n',
    )
    orient: Optional[str] = Field(
        'vertical',
        description='<p>How to layout the visualMap component, <code class="codespan">&#39;horizontal&#39;</code> or <code class="codespan">&#39;vertical&#39;</code>.</p>\n',
    )
    padding: Optional[Union[float, Any]] = Field(
        5,
        description='\n\n<p>visualMap-piecewise space around content. The unit is px. Default values for each position are 5. And they can be set to different values with left, right, top, and bottom.</p>\n<p>Examples:</p>\n<pre><code class="lang-ts">// Set padding to be 5\npadding: 5\n// Set the top and bottom paddings to be 5, and left and right paddings to be 10\npadding: [5, 10]\n// Set each of the four paddings seperately\npadding: [\n    5,  // up\n    10, // right\n    5,  // down\n    10, // left\n]\n</code></pre>\n',
    )
    backgroundColor: Optional[Any] = Field(
        'rgba(0,0,0,0)', description='<p>background color of visualMap component.</p>\n'
    )
    borderColor: Optional[Any] = Field(
        '#ccc', description='<p>border color of visualMap component.</p>\n'
    )
    borderWidth: Optional[float] = Field(
        0, description='<p>border width of visualMap component, with unit: px.</p>\n'
    )
    color: Optional[Any] = Field(
        "['#bf444c', '#d88273', '#f6efa6']",
        description='<p>This property remains only for compatibility with ECharts2, and is not recommended in ECharts3. It is recommended to configure color in <a href="#visualMap-piecewise.inRange">visualMap-piecewise.inRange</a>, or <a href="#visualMap-piecewise.outOfRange">visualMap-piecewise.outOfRange</a> if needed.</p>\n<p>If you persist in using it, the following issue should be noticed: the sequence of dataValues that are mapped to colorValues in property <code class="codespan">color</code> is from <code class="codespan">large</code> to <code class="codespan">small</code>, whereas that in <a href="#visualMap-piecewise.inRange">visualMap-piecewise.inRange</a> or <a href="#visualMap-piecewise.outOfRange">visualMap-piecewise.outOfRange</a> is from <code class="codespan">small</code> to <code class="codespan">large</code>.</p>\n',
    )
    textStyle: Optional[TextStyle10] = Field(None, description='')
    formatter: Optional[Union[str, Any]] = Field(
        None,
        description='<p>the formatter tool for label.</p>\n<ul>\n<li><p>If it was set as a <code class="codespan">string</code>, it refers to a template, for instance: <code class="codespan">aaaa{value}bbbb{value2}</code>, where <code class="codespan">{value}</code> and <code class="codespan">{value2}</code> represents the current selected range of dataValues.</p>\n</li>\n<li><p>If it was set as a <code class="codespan">Function</code>, it refers to a callback function, for instance:</p>\n</li>\n</ul>\n<pre><code class="lang-javascript">formatter: function (value, value2) {\n    return &#39;aaaa&#39; + value + &#39;bbbb&#39; + value2;\n}\n</code></pre>\n',
    )


class VisualMap(DataZoom):
    """
        <p><code class="codespan">visualMap</code> is a type of component for visual encoding, which maps the data to visual channels, including:</p>
    <ul>
    <li><code class="codespan">symbol</code>: Type of symbol.</li>
    <li><code class="codespan">symbolSize</code>: Symbol size.</li>
    <li><code class="codespan">color</code>: Symbol color.</li>
    <li><code class="codespan">colorAlpha</code>: Symbol alpha channel.</li>
    <li><code class="codespan">opacity</code>: Opacity of symbol and others (like labels).</li>
    <li><code class="codespan">colorLightness</code>: Lightness in <a href="https://en.wikipedia.org/wiki/HSL_and_HSV" target="_blank">HSL</a>.</li>
    <li><code class="codespan">colorSaturation</code>: Saturation in <a href="https://en.wikipedia.org/wiki/HSL_and_HSV" target="_blank">HSL</a>.</li>
    <li><code class="codespan">colorHue</code>: Hue in <a href="https://en.wikipedia.org/wiki/HSL_and_HSV" target="_blank">HSL</a>.</li>
    </ul>
    <p>Myltiple <code class="codespan">visualMap</code> component could be defined in a chart instance, which enable that different dimensions of a series data are mapped to different visual channels.</p>
    <p><code class="codespan">visualMap</code> could be defined as <a href="#visualMap-piecewise">Piecewise (visualMapPiecewise)</a> or <a href="#visualMap-continuous">Continuous (visualMapContinuous)</a>, which is distinguished by the property <code class="codespan">type</code>. For instance:</p>
    <pre><code class="lang-javascript">option = {
        visualMap: [
            { // the first visualMap component
                type: &#39;continuous&#39;, // defined to be continuous visualMap
                ...
            },
            { // the second visualMap component
                type: &#39;piecewise&#39;, // defined to be piecewise visualMap
                ...
            }
        ],
        ...
    };
    </code></pre>
    <p><br>
    <strong>✦ Configure mapping ✦</strong></p>
    <p>The dimension of <a href="#series.data">series.data</a> can be specified by <a href="#visualMap.dimension">visualMap.dimension</a>, from which the value can be retrieved and mapped onto visual channels, which can be defined in <a href="#visualMap.inRange">visualMap.inRange</a> and <a href="#visualMap.outOfRange">visualMap.outOfRange</a>.</p>
    <p><br>
    In series that controlled by visualMap, if a data item needs to escape from controlled by visualMap, you can set like this:</p>
    <pre><code>series: {
        type: &#39;...&#39;,
        data: [
            {name: &#39;Shanghai&#39;, value: 251},
            {name: &#39;Haikou&#39;, value: 21},
            // Mark as `visualMap: false`, then this item does not controlled by visualMap any more,
            // and series visual config (like color, symbol, ...) can be used to this item.
            {name: &#39;Beijing&#39;, value: 821, },
            ...
        ]
    }
    </code></pre><p><br>
    <strong>✦ The relationship between visualMap of ECharts3 and dataRange of ECharts2 ✦</strong></p>
    <p><code class="codespan">visualMap</code> is renamed from the <code class="codespan">dataRange</code> of ECharts2, and the scope of functionalities are extended a lot. The configurations of <code class="codespan">dataRange</code> are still compatible in ECharts3, which automatically convert them to <code class="codespan">visualMap</code>. It is recommended to use <code class="codespan">visualMap</code> instead of <code class="codespan">dataRange</code> in ECharts3.</p>
    <p><br>
    <strong>✦ The detailed configurations of visualMap are elaborated as follows. ✦</strong></p>
    <p><br>
    <br></p>

    """

    pass


class Label6(Label):
    """
    <p>label of axisPointer</p>

    """

    pass


class LineStyle33(LineStyle2):
    """
    <p>It is valid when <a href="#tooltip.axisPointer.type">axisPointer.type</a> is <code class="codespan">&#39;line&#39;</code>.</p>

    """

    pass


class ShadowStyle6(ShadowStyle):
    """
    <p>It is valid when <a href="#tooltip.axisPointer.type">axisPointer.type</a> is <code class="codespan">&#39;shadow&#39;</code>.</p>

    """

    pass


class CrossStyle2(CrossStyle):
    """
    <p>It is valid when <a href="#tooltip.axisPointer.type">axisPointer.type</a> is <code class="codespan">&#39;cross&#39;</code>.</p>

    """

    pass


class AxisPointer6(BaseModel):
    """
        <p>Configuration item for axisPointer.</p>
    <p><code class="codespan">tooltip.axisPointer</code> is like syntactic sugar of axisPointer settings on axes (for example, <a href="#xAxis.axisPointer">xAxis.axisPointer</a> or <a href="#angleAxis.axisPointer">angleAxis.axisPointer</a>). More detailed features can be configured on <code class="codespan">someAxis.axisPointer</code>. But in common cases, using <code class="codespan">tooltip.axisPointer</code> is more convenient.</p>
    <blockquote>
    <p><strong>Notice:</strong> configurations of <code class="codespan">tooltip.axisPointer</code> has lower priority than that of <code class="codespan">someAxis.axisPointer</code>.</p>
    </blockquote>
    <hr>
    <p><code class="codespan">axisPointer</code> is a tool for displaying reference line and axis value under mouse pointer.</p>
    <p>For example:</p>
    <iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=doc-example/candlestick-axisPointer&edit=1&reset=1" width="600" height="450"></iframe>


    <p>In the demo above, <a href="#axisPointer.link">axisPointer.link</a> is used to link axisPointer from different coordinate systems.</p>
    <p><code class="codespan">axisPointer</code> can also be used on touch device, where user can drag the button to move the reference line and label.</p>
    <iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=line-tooltip-touch&edit=1&reset=1" width="600" height="400"></iframe>


    <p>In the cases that more than one axis exist, axisPointer helps to look inside the data.</p>
    <iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=multiple-y-axis&edit=1&reset=1" width="600" height="300"></iframe>

    <iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=multiple-x-axis&edit=1&reset=1" width="600" height="300"></iframe>



    <hr>
    <blockquote>
    <p><strong>Notice:</strong>
    Generally, axisPointers is configured in each axes who need them (for example <a href="#xAxis.axisPointer">xAxis.axisPointer</a>), or configured in <code class="codespan">tooltip</code> (for example <a href="#tooltip.axisPointer">tooltip.axisPointer</a>).</p>
    </blockquote>
    <blockquote>
    <p>But these configurations can only be configured in global axisPointer:
    <a href="#axisPointer.triggerOn">axisPointer.triggerOn</a>, <a href="#axisPointer.link">axisPointer.link</a>.</p>
    </blockquote>
    <hr>
    <hr>
    <p><strong>How to display axisPointer:</strong></p>
    <p>In <a href="#grid">cartesian (grid)</a> and <a href="#single">polar](~polar) and (single axis</a>, each axis has its own axisPointer.</p>
    <p>Those axisPointer will not be displayed by default, utill configured as follows:</p>
    <ul>
    <li><p>Set <code class="codespan">someAxis.axisPointer.show</code> (like <a href="#xAxis.axisPointer.show">xAxis.axisPointer.show</a>) as <code class="codespan">true</code>. Then axisPointer of this axis will be displayed.</p>
    </li>
    <li><p>Set <a href="#tooltip.trigger">tooltip.trigger</a> as <code class="codespan">&#39;axis&#39;</code>, or set <a href="#tooltip.axisPointer.type">tooltip.axisPointer.type</a> as <code class="codespan">&#39;cross&#39;</code>. Then coordinate system will automatically chose the axes who will display their axisPointers. (<a href="#tooltip.axisPointer.axis">tooltip.axisPointer.axis</a> can be used to change the choice.) Notice, <code class="codespan">axis.axisPointer</code> will override <code class="codespan">tooltip.axisPointer</code> settings.</p>
    </li>
    </ul>
    <hr>
    <p><strong>How to display the label of axisPointer:</strong></p>
    <p>The label of axisPointer will not be displayed by default(namely, only reference line will be displayed by default), utill configured as follows:</p>
    <ul>
    <li><p>Set <code class="codespan">someAxis.axisPointer.label.show</code> (for example <a href="#xAxis.axisPointer.show">xAxis.axisPointer.label.show</a>) as <code class="codespan">true</code>. Then the label of the axisPointer will be displayed.</p>
    </li>
    <li><p>Set <a href="#tooltip.axisPointer.type">tooltip.axisPointer.type</a> as  <code class="codespan">&#39;cross&#39;</code>. Then the label of the crossed axisPointers will be displayed.</p>
    </li>
    </ul>
    <hr>
    <p><strong>How to configure axisPointer on touch device:</strong></p>
    <p>Set <code class="codespan">someAxis.axisPointer.handle.show</code> (for example <a href="#xAxis.axisPointer.handle.show">xAxis.axisPointer.handle.show</a> as <code class="codespan">true</code>. Then the button for dragging will be displayed. (This feature is not supported on polar).</p>
    <p><strong>Notice:</strong>
    If tooltip does not work well in this case, try to set<a href="#tooltip.triggerOn">tooltip.triggerOn</a> as <code class="codespan">&#39;none&#39;</code> (for the effect: show tooltip when finger holding on the button, and hide tooltip after finger left the button), or set <a href="#tooltip.alwaysShowContent">tooltip.alwaysShowContent</a> as <code class="codespan">true</code> (then tooltip will always be displayed).</p>
    <p>See the <a href="http://localhost/echarts-website/examples/en/editor.html?c=line-tooltip-touch&amp;edit=1&amp;reset=1" target="_blank">example</a>.</p>
    <hr>
    <p><strong>Snap to point</strong></p>
    <p>In value axis and time axis, if <a href="#xAxis.axisPointer.snap">snap</a> is set as true, axisPointer will snap to point automatically.</p>
    <hr>

    """

    type: Optional[str] = Field(
        'line',
        description='\n\n<p>Indicator type.</p>\n<p>Options:</p>\n<ul>\n<li><p><code class="codespan">&#39;line&#39;</code> line indicator.</p>\n</li>\n<li><p><code class="codespan">&#39;shadow&#39;</code> shadow crosshair indicator.</p>\n</li>\n<li><p><code class="codespan">&#39;none&#39;</code> no indicator displayed.</p>\n</li>\n<li><p><code class="codespan">&#39;cross&#39;</code> crosshair indicator, which is actually the shortcut of enable two axisPointers of two orthometric axes.</p>\n</li>\n</ul>\n',
    )
    axis: Optional[str] = Field(
        'auto',
        description='<p>The coordinate axis, which could be <code class="codespan">&#39;x&#39;</code>, <code class="codespan">&#39;y&#39;</code>, <code class="codespan">&#39;radius&#39;</code>, or <code class="codespan">&#39;angle&#39;</code>. By default, each coordinate system will automatically chose the axes whose will display its axisPointer (category axis or time axis is used by default).</p>\n',
    )
    snap: Optional[bool] = Field(
        None,
        description='<p>Whether snap to point automatically. The default value is auto determined.</p>\n<p>This feature usually makes sense in value axis and time axis, where tiny points can be seeked automatically.</p>\n',
    )
    z: Optional[float] = Field(
        None,
        description='<p>z value, which controls order of drawing graphical components. Components with smaller <code class="codespan">z</code> values may be overwritten by those with larger <code class="codespan">z</code> values.</p>\n',
    )
    label: Optional[Label6] = Field(None, description='<p>label of axisPointer</p>\n')
    lineStyle: Optional[LineStyle33] = Field(
        None,
        description='<p>It is valid when <a href="#tooltip.axisPointer.type">axisPointer.type</a> is <code class="codespan">&#39;line&#39;</code>.</p>\n',
    )
    shadowStyle: Optional[ShadowStyle6] = Field(
        None,
        description='<p>It is valid when <a href="#tooltip.axisPointer.type">axisPointer.type</a> is <code class="codespan">&#39;shadow&#39;</code>.</p>\n',
    )
    crossStyle: Optional[CrossStyle2] = Field(
        None,
        description='<p>It is valid when <a href="#tooltip.axisPointer.type">axisPointer.type</a> is <code class="codespan">&#39;cross&#39;</code>.</p>\n',
    )
    animation: Optional[bool] = Field(
        True, description='\n\n<p>Whether to enable animation.</p>\n'
    )
    animationThreshold: Optional[float] = Field(
        2000,
        description='<p>Whether to set graphic number threshold to animation. Animation will be disabled when graphic number is larger than threshold.</p>\n',
    )
    animationDuration: Optional[Union[float, Any]] = Field(
        1000,
        description='\n\n<p>Duration of the first animation, which supports callback function for different data to have different animation effect:</p>\n<pre><code class="lang-ts">animationDuration: function (idx) {\n    // delay for later data is larger\n    return idx * 100;\n}\n</code></pre>\n',
    )
    animationEasing: Optional[str] = Field(
        'cubicOut',
        description='\n\n<p>Easing method used for the first animation. Varied easing effects can be found at <a href="http://localhost/echarts-website/examples/en/editor.html?c=line-easing" target="_blank">easing effect example</a>.</p>\n',
    )
    animationDelay: Optional[Union[float, Any]] = Field(
        0,
        description='<p>Delay before updating the first animation, which supports callback function for different data to have different animation effect.</p>\n<p>For example:</p>\n<pre><code class="lang-ts">animationDelay: function (idx) {\n    // delay for later data is larger\n    return idx * 100;\n}\n</code></pre>\n<p>See <a href="http://localhost/echarts-website/examples/en/editor.html?c=bar-animation-delay" target="_blank">this example</a> for more information.</p>\n',
    )
    animationDurationUpdate: Optional[Union[float, Any]] = Field(
        200,
        description='\n\n<p>Time for animation to complete, which supports callback function for different data to have different animation effect:</p>\n<pre><code class="lang-ts">animationDurationUpdate: function (idx) {\n    // delay for later data is larger\n    return idx * 100;\n}\n</code></pre>\n',
    )
    animationEasingUpdate: Optional[str] = Field(
        'exponentialOut', description='\n\n<p>Easing method used for animation.</p>\n'
    )
    animationDelayUpdate: Optional[Union[float, Any]] = Field(
        0,
        description='<p>Delay before updating animation, which supports callback function for different data to have different animation effects.</p>\n<p>For example:</p>\n<pre><code class="lang-ts">animationDelayUpdate: function (idx) {\n    // delay for later data is larger\n    return idx * 100;\n}\n</code></pre>\n<p>See <a href="http://localhost/echarts-website/examples/en/editor.html?c=bar-animation-delay" target="_blank">this example</a> for more information.</p>\n',
    )


class TextStyle11(TextStyle2):
    """
    <p>The text syle of tooltip&#39;s floating layer.</p>

    """

    pass


class Tooltip2(BaseModel):
    """
        <p>Tooltip component.</p>
    <hr>
    <p><strong>General Introduction:</strong></p>
    <p>tooltip can be configured on different places:</p>
    <ul>
    <li><p>Configured on global: <a href="#tooltip">tooltip</a></p>
    </li>
    <li><p>Configured in a coordinate system: <a href="#grid.tooltip">grid.tooltip</a>, <a href="#polar.tooltip">polar.tooltip</a>, <a href="#single.tooltip">single.tooltip</a></p>
    </li>
    <li><p>Configured in a series: <a href="#series.tooltip">series.tooltip</a></p>
    </li>
    <li><p>Configured in each item of <code class="codespan">series.data</code>: <a href="#series.data.tooltip">series.data.tooltip</a></p>
    </li>
    </ul>




    """

    show: Optional[bool] = Field(
        True,
        description='\n\n<p>Whether to show the tooltip component.</p>\n<p>including tooltip floating layer and <a href="#tooltip.axisPointer">axisPointer</a>.</p>\n',
    )
    trigger: Optional[str] = Field(
        'item',
        description='\n\n<p>Type of triggering.</p>\n<p>Options:</p>\n<ul>\n<li><p><code class="codespan">&#39;item&#39;</code></p>\n<p>  Triggered by data item, which is mainly used for charts that don&#39;t have a category axis like scatter charts or pie charts.</p>\n</li>\n<li><p><code class="codespan">&#39;axis&#39;</code></p>\n<p>  Triggered by axes, which is mainly used for charts that have category axes, like bar charts or line charts.</p>\n<p> ECharts 2.x only supports axis trigger for category axis. In ECharts 3, it is supported for all types of axes in <a href="#grid">grid</a> or <a href="#polar">polar</a>. Also, you may assign axis with <a href="#tooltip.axisPointer.axis">axisPointer.axis</a>.</p>\n</li>\n<li><p><code class="codespan">&#39;none&#39;</code></p>\n<p>  Trigger nothing.</p>\n</li>\n</ul>\n',
    )
    axisPointer: Optional[AxisPointer6] = Field(
        None,
        description='<p>Configuration item for axisPointer.</p>\n<p><code class="codespan">tooltip.axisPointer</code> is like syntactic sugar of axisPointer settings on axes (for example, <a href="#xAxis.axisPointer">xAxis.axisPointer</a> or <a href="#angleAxis.axisPointer">angleAxis.axisPointer</a>). More detailed features can be configured on <code class="codespan">someAxis.axisPointer</code>. But in common cases, using <code class="codespan">tooltip.axisPointer</code> is more convenient.</p>\n<blockquote>\n<p><strong>Notice:</strong> configurations of <code class="codespan">tooltip.axisPointer</code> has lower priority than that of <code class="codespan">someAxis.axisPointer</code>.</p>\n</blockquote>\n<hr>\n<p><code class="codespan">axisPointer</code> is a tool for displaying reference line and axis value under mouse pointer.</p>\n<p>For example:</p>\n<iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=doc-example/candlestick-axisPointer&edit=1&reset=1" width="600" height="450"></iframe>\n\n\n<p>In the demo above, <a href="#axisPointer.link">axisPointer.link</a> is used to link axisPointer from different coordinate systems.</p>\n<p><code class="codespan">axisPointer</code> can also be used on touch device, where user can drag the button to move the reference line and label.</p>\n<iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=line-tooltip-touch&edit=1&reset=1" width="600" height="400"></iframe>\n\n\n<p>In the cases that more than one axis exist, axisPointer helps to look inside the data.</p>\n<iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=multiple-y-axis&edit=1&reset=1" width="600" height="300"></iframe>\n\n<iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=multiple-x-axis&edit=1&reset=1" width="600" height="300"></iframe>\n\n\n\n<hr>\n<blockquote>\n<p><strong>Notice:</strong>\nGenerally, axisPointers is configured in each axes who need them (for example <a href="#xAxis.axisPointer">xAxis.axisPointer</a>), or configured in <code class="codespan">tooltip</code> (for example <a href="#tooltip.axisPointer">tooltip.axisPointer</a>).</p>\n</blockquote>\n<blockquote>\n<p>But these configurations can only be configured in global axisPointer:\n<a href="#axisPointer.triggerOn">axisPointer.triggerOn</a>, <a href="#axisPointer.link">axisPointer.link</a>.</p>\n</blockquote>\n<hr>\n<hr>\n<p><strong>How to display axisPointer:</strong></p>\n<p>In <a href="#grid">cartesian (grid)</a> and <a href="#single">polar](~polar) and (single axis</a>, each axis has its own axisPointer.</p>\n<p>Those axisPointer will not be displayed by default, utill configured as follows:</p>\n<ul>\n<li><p>Set <code class="codespan">someAxis.axisPointer.show</code> (like <a href="#xAxis.axisPointer.show">xAxis.axisPointer.show</a>) as <code class="codespan">true</code>. Then axisPointer of this axis will be displayed.</p>\n</li>\n<li><p>Set <a href="#tooltip.trigger">tooltip.trigger</a> as <code class="codespan">&#39;axis&#39;</code>, or set <a href="#tooltip.axisPointer.type">tooltip.axisPointer.type</a> as <code class="codespan">&#39;cross&#39;</code>. Then coordinate system will automatically chose the axes who will display their axisPointers. (<a href="#tooltip.axisPointer.axis">tooltip.axisPointer.axis</a> can be used to change the choice.) Notice, <code class="codespan">axis.axisPointer</code> will override <code class="codespan">tooltip.axisPointer</code> settings.</p>\n</li>\n</ul>\n<hr>\n<p><strong>How to display the label of axisPointer:</strong></p>\n<p>The label of axisPointer will not be displayed by default(namely, only reference line will be displayed by default), utill configured as follows:</p>\n<ul>\n<li><p>Set <code class="codespan">someAxis.axisPointer.label.show</code> (for example <a href="#xAxis.axisPointer.show">xAxis.axisPointer.label.show</a>) as <code class="codespan">true</code>. Then the label of the axisPointer will be displayed.</p>\n</li>\n<li><p>Set <a href="#tooltip.axisPointer.type">tooltip.axisPointer.type</a> as  <code class="codespan">&#39;cross&#39;</code>. Then the label of the crossed axisPointers will be displayed.</p>\n</li>\n</ul>\n<hr>\n<p><strong>How to configure axisPointer on touch device:</strong></p>\n<p>Set <code class="codespan">someAxis.axisPointer.handle.show</code> (for example <a href="#xAxis.axisPointer.handle.show">xAxis.axisPointer.handle.show</a> as <code class="codespan">true</code>. Then the button for dragging will be displayed. (This feature is not supported on polar).</p>\n<p><strong>Notice:</strong>\nIf tooltip does not work well in this case, try to set<a href="#tooltip.triggerOn">tooltip.triggerOn</a> as <code class="codespan">&#39;none&#39;</code> (for the effect: show tooltip when finger holding on the button, and hide tooltip after finger left the button), or set <a href="#tooltip.alwaysShowContent">tooltip.alwaysShowContent</a> as <code class="codespan">true</code> (then tooltip will always be displayed).</p>\n<p>See the <a href="http://localhost/echarts-website/examples/en/editor.html?c=line-tooltip-touch&amp;edit=1&amp;reset=1" target="_blank">example</a>.</p>\n<hr>\n<p><strong>Snap to point</strong></p>\n<p>In value axis and time axis, if <a href="#xAxis.axisPointer.snap">snap</a> is set as true, axisPointer will snap to point automatically.</p>\n<hr>\n',
    )
    showContent: Optional[bool] = Field(
        True,
        description='\n\n<p>Whether to show the tooltip floating layer, whose default value is true. It should be configurated to be <code class="codespan">false</code>, if you only need tooltip to trigger the event or show the axisPointer without content.</p>\n',
    )
    alwaysShowContent: Optional[bool] = Field(
        False,
        description='\n\n<p>Whether to show tooltip content all the time. By default, it will be hidden <a href="#tooltip.hideDelay">after some time</a>. It can be set to be <code class="codespan">true</code> to preserve displaying.</p>\n<p>This attribute is newly added to ECharts 3.0.</p>\n',
    )
    triggerOn: Optional[str] = Field(
        'mousemove|click',
        description='\n\n<p>Conditions to trigger tooltip. Options:</p>\n<ul>\n<li><p><code class="codespan">&#39;mousemove&#39;</code></p>\n<p>  Trigger when mouse moves.</p>\n</li>\n<li><p><code class="codespan">&#39;click&#39;</code></p>\n<p>  Trigger when mouse clicks.</p>\n</li>\n<li><p><code class="codespan">&#39;mousemove|click&#39;</code></p>\n<p>  Trigger when mouse clicks and moves.</p>\n</li>\n<li><p><code class="codespan">&#39;none&#39;</code></p>\n<p>  Do not triggered by <code class="codespan">&#39;mousemove&#39;</code> and <code class="codespan">&#39;click&#39;</code>. Tooltip can be triggered and hidden manually by calling <a href="api.html#action.tooltip.showTip" target="_blank">action.tooltip.showTip</a> and <a href="api.html#action.tooltip.hideTip" target="_blank">action.tooltip.hideTip</a>. It can also be triggered by <a href="#xAxis.axisPointer.handle">axisPointer.handle</a> in this case.</p>\n</li>\n</ul>\n<p>This attribute is new to ECharts 3.0.</p>\n',
    )
    showDelay: Optional[float] = Field(
        0,
        description='\n\n<p>Delay time for showing tooltip, in ms. No delay by default, and it is not recommended to set. Only valid when <a href="#tooltip.triggerOn">triggerOn</a> is set to be <code class="codespan">&#39;mousemove&#39;</code>.</p>\n',
    )
    hideDelay: Optional[float] = Field(
        100,
        description='\n\n<p>Delay time for hiding tooltip, in ms. It will be invalid when <a href="#tooltip.alwaysShowContent">alwaysShowContent</a> is <code class="codespan">true</code>.</p>\n',
    )
    enterable: Optional[bool] = Field(
        True,
        description='\n\n<p>Whether mouse is allowed to enter the floating layer of tooltip, whose default value is false. If you need to interact in the tooltip like with links or buttons, it can be set as <code class="codespan">true</code>.</p>\n',
    )
    renderMode: Optional[str] = Field(
        'html',
        description='\n\n<p>Render mode for tooltip. By default, it is set to be <code class="codespan">&#39;html&#39;</code> so that extra DOM element is used for tooltip. It can also set to be <code class="codespan">&#39;richText&#39;</code> so that the tooltip will be rendered inside Canvas (SVG rich text is not implemented yet). This is very useful for environments that don&#39;t have DOM, such as Wechat applications.</p>\n',
    )
    confine: Optional[bool] = Field(
        False,
        description='\n\n<p>Whether confine tooltip content in the view rect of chart instance.</p>\n<p>Useful when tooltip is cut because of <code class="codespan">&#39;overflow: hidden&#39;</code> set on outer dom of chart instance, or because of narrow screen on mobile.</p>\n',
    )
    appendToBody: Optional[bool] = Field(
        False,
        description='\n\n\n\n<blockquote>\n<p>Since <code class="codespan">v4.7.0</code></p>\n</blockquote>\n<p>Whether to append the tooltip DOM element as a child of the <code class="codespan">&lt;body&gt;</code> of the HTML page, when using <a href="#tooltip.renderMode">renderMode</a> <code class="codespan">&#39;html&#39;</code>.</p>\n<p>By default <code class="codespan">false</code>, means that the tooltip DOM element will be one of a descendant of its echarts DOM container. But that means that the tooltip might be cut when overflow the container if some of the ancestors DOM element of the echarts container are styled with <code class="codespan">overflow: hidden</code>. This case could also be resolved by setting <a href="#tooltip.confine">tooltip.confine</a>, but it might not suitable for all scenarios.</p>\n<p>Here we provide <code class="codespan">appendToBody: true</code> to auto append the tooltip element to <code class="codespan">&lt;body&gt;</code>, which is a common way to resolve this kind of issue. But <code class="codespan">true</code> is not set as a default value because to void to bring break change for some cases where tooltip is deeply customized and to void some unexpected bad cases.</p>\n<p>Note that it also works when CSS transform used.</p>\n',
    )
    className: Optional[str] = Field(
        None,
        description='\n\n\n\n<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n<p>Specify the classes for the tooltip root DOM. (Only works in <a href="#tooltip.renderMode"><code class="codespan">html</code></a> render mode).</p>\n<p>Example:</p>\n<pre><code class="lang-ts">className: &#39;echarts-tooltip echarts-tooltip-dark&#39;\n</code></pre>\n',
    )
    transitionDuration: Optional[float] = Field(
        0.4,
        description='\n\n<p>The transition duration of tooltip&#39;s animation, in seconds. When it is set to be 0, it would move closely with the mouse.</p>\n',
    )
    position: Optional[Union[str, Any]] = Field(
        None,
        description='<p>The position of the tooltip&#39;s floating layer, which would follow the position of mouse by default.</p>\n<p>Options:</p>\n<ul>\n<li><p><code class="codespan">Array</code></p>\n<p>  Display the position of tooltip&#39;s floating layer through array, which supports absolute position and relative percentage.</p>\n<p>  Example:</p>\n<pre><code class="lang-ts">  // absolute position, which is 10px to the left side and 10px to the top side of the container\n  position: [10, 10]\n  // relative position, in the exact center of the container\n  position: [&#39;50%&#39;, &#39;50%&#39;]\n</code></pre>\n</li>\n<li><p><code class="codespan">Function</code></p>\n<p>  Callback function in the following form:</p>\n<pre><code class="lang-ts">  (point: Array, params: Object|Array.&lt;Object&gt;, dom: HTMLDomElement, rect: Object, size: Object) =&gt; Array\n</code></pre>\n<p>  <strong>Parameters:</strong><br>\n  point: Mouse position.<br>\n  param: The same as formatter.<br>\n  dom: The DOM object of tooltip.<br>\n  rect: It is valid only when mouse is on graphic elements, which stands for a bounding box with <code class="codespan">x</code>, <code class="codespan">y</code>, <code class="codespan">width</code>, and <code class="codespan">height</code>.<br>\n  size: The size of dom echarts container. For example: <code class="codespan">{contentSize: [width, height], viewSize: [width, height]}</code>. <br></p>\n<p>  <strong>Return:</strong><br>\n  Return value is an array standing for tooltip position, which can be absolute pixels, or relative percentage.<br>\n  Or can be an object, like <code class="codespan">{left: 10, top: 30}</code>, or <code class="codespan">{right: &#39;20%&#39;, bottom: 40}</code>.<br></p>\n<p>  For example:</p>\n<pre><code class="lang-ts">  position: function (point, params, dom, rect, size) {\n      // fixed at top\n      return [point[0], &#39;10%&#39;];\n  }\n</code></pre>\n<p>  Or:</p>\n<pre><code class="lang-ts">  position: function (pos, params, dom, rect, size) {\n      // tooltip will be fixed on the right if mouse hovering on the left,\n      // and on the left if hovering on the right.\n      var obj = {top: 60};\n      obj[[&#39;left&#39;, &#39;right&#39;][+(pos[0] &lt; size.viewSize[0] / 2)]] = 5;\n      return obj;\n  }\n</code></pre>\n</li>\n<li><p><code class="codespan">&#39;inside&#39;</code></p>\n<p> Center position of the graphic element where the mouse is in, which is only valid when <a href="#tooltip.trigger">trigger</a> is <code class="codespan">&#39;item&#39;</code>.</p>\n</li>\n<li><p><code class="codespan">&#39;top&#39;</code></p>\n<p>  Top position of the graphic element where the mouse is in, which is only valid when <a href="#tooltip.trigger">trigger</a> is <code class="codespan">&#39;item&#39;</code>.</p>\n</li>\n<li><p><code class="codespan">&#39;left&#39;</code></p>\n<p>  Left position of the graphic element where the mouse is in, which is only valid when <a href="#tooltip.trigger">trigger</a> is <code class="codespan">&#39;item&#39;</code>.</p>\n</li>\n<li><p><code class="codespan">&#39;right&#39;</code></p>\n<p>  Right position of the graphic element where the mouse is in, which is only valid when <a href="#tooltip.trigger">trigger</a> is <code class="codespan">&#39;item&#39;</code>.</p>\n</li>\n<li><p><code class="codespan">&#39;bottom&#39;</code></p>\n<p>  Bottom position of the graphic element where the mouse is in, which is only valid when <a href="#tooltip.trigger">trigger</a> is <code class="codespan">&#39;item&#39;</code>.</p>\n</li>\n</ul>\n',
    )
    formatter: Optional[Union[str, Any]] = Field(
        None,
        description='<p>The content formatter of tooltip&#39;s floating layer which supports string template and callback function.</p>\n<p><strong>1. String template</strong></p>\n<p>The template variables are <code class="codespan">{a}</code>, <code class="codespan">{b}</code>, <code class="codespan">{c}</code>, <code class="codespan">{d}</code> and <code class="codespan">{e}</code>, which stands for series name, data name and data value and ect. When <a href="#tooltip.trigger">trigger</a> is set to be <code class="codespan">&#39;axis&#39;</code>, there may be data from multiple series. In this time, series index can be refered as <code class="codespan">{a0}</code>, <code class="codespan">{a1}</code>, or <code class="codespan">{a2}</code>.</p>\n<p><code class="codespan">{a}</code>, <code class="codespan">{b}</code>, <code class="codespan">{c}</code>, <code class="codespan">{d}</code> have different meanings for different series types:</p>\n<ul>\n<li><p>Line (area) charts, bar (column) charts, K charts: <code class="codespan">{a}</code> for series name, <code class="codespan">{b}</code> for category name, <code class="codespan">{c}</code> for data value, <code class="codespan">{d}</code> for none;</p>\n</li>\n<li><p>Scatter (bubble) charts: <code class="codespan">{a}</code> for series name, <code class="codespan">{b}</code> for data name, <code class="codespan">{c}</code> for data value, <code class="codespan">{d}</code> for none;</p>\n</li>\n<li><p>Map: <code class="codespan">{a}</code> for series name, <code class="codespan">{b}</code> for area name, <code class="codespan">{c}</code> for merging data, <code class="codespan">{d}</code> for none;</p>\n</li>\n<li><p>Pie charts, gauge charts, funnel charts: <code class="codespan">{a}</code> for series name, <code class="codespan">{b}</code> for data item name, <code class="codespan">{c}</code> for data value, <code class="codespan">{d}</code> for percentage.</p>\n</li>\n</ul>\n<p><strong>Example: </strong></p>\n<pre><code class="lang-ts">formatter: &#39;{b0}: {c0}&lt;br /&gt;{b1}: {c1}&#39;\n</code></pre>\n<p><strong>2. Callback function</strong></p>\n<p>The format of callback function:</p>\n<pre><code class="lang-ts">(params: Object|Array, ticket: string, callback: (ticket: string, html: string)) =&gt; string | HTMLElement | HTMLElement[]\n</code></pre>\n<p>The first parameter <code class="codespan">params</code> is the data that the formatter needs. Its format is shown as follows:</p>\n<pre><code class="lang-ts">{\n    componentType: &#39;series&#39;,\n    // Series type\n    seriesType: string,\n    // Series index in option.series\n    seriesIndex: number,\n    // Series name\n    seriesName: string,\n    // Data name, or category name\n    name: string,\n    // Data index in input data array\n    dataIndex: number,\n    // Original data as input\n    data: Object,\n    // Value of data. In most series it is the same as data.\n    // But in some series it is some part of the data (e.g., in map, radar)\n    value: number|Array|Object,\n    // encoding info of coordinate system\n    // Key: coord, like (&#39;x&#39; &#39;y&#39; &#39;radius&#39; &#39;angle&#39;)\n    // value: Must be an array, not null/undefined. Contain dimension indices, like:\n    // {\n    //     x: [2] // values on dimension index 2 are mapped to x axis.\n    //     y: [0] // values on dimension index 0 are mapped to y axis.\n    // }\n    encode: Object,\n    // dimension names list\n    dimensionNames: Array&lt;String&gt;,\n    // data dimension index, for example 0 or 1 or 2 ...\n    // Only work in `radar` series.\n    dimensionIndex: number,\n    // Color of data\n    color: string,\n    // the percentage of pie chart\n    percent: number\n}\n</code></pre>\n<p><strong>How to use <code class="codespan">encode</code> and <code class="codespan">dimensionNames</code>?</strong></p>\n<p>When the dataset is like</p>\n<pre><code class="lang-ts">dataset: {\n    source: [\n        [&#39;Matcha Latte&#39;, 43.3, 85.8, 93.7],\n        [&#39;Milk Tea&#39;, 83.1, 73.4, 55.1],\n        [&#39;Cheese Cocoa&#39;, 86.4, 65.2, 82.5],\n        [&#39;Walnut Brownie&#39;, 72.4, 53.9, 39.1]\n    ]\n}\n</code></pre>\n<p>We can get the value of the y-axis via</p>\n<pre><code class="lang-ts">params.value[params.encode.y[0]]\n</code></pre>\n<p>When the dataset is like</p>\n<pre><code class="lang-ts">dataset: {\n    dimensions: [&#39;product&#39;, &#39;2015&#39;, &#39;2016&#39;, &#39;2017&#39;],\n    source: [\n        {product: &#39;Matcha Latte&#39;, &#39;2015&#39;: 43.3, &#39;2016&#39;: 85.8, &#39;2017&#39;: 93.7},\n        {product: &#39;Milk Tea&#39;, &#39;2015&#39;: 83.1, &#39;2016&#39;: 73.4, &#39;2017&#39;: 55.1},\n        {product: &#39;Cheese Cocoa&#39;, &#39;2015&#39;: 86.4, &#39;2016&#39;: 65.2, &#39;2017&#39;: 82.5},\n        {product: &#39;Walnut Brownie&#39;, &#39;2015&#39;: 72.4, &#39;2016&#39;: 53.9, &#39;2017&#39;: 39.1}\n    ]\n}\n</code></pre>\n<p>We can get the value of the y-axis via</p>\n<pre><code class="lang-ts">params.value[params.dimensionNames[params.encode.y[0]]]\n</code></pre>\n<p>When <a href="#tooltip.trigger">trigger</a> is <code class="codespan">&#39;axis&#39;</code>, or when tooltip is triggered by <a href="#xAxis.axisPointer">axisPointer</a>, <code class="codespan">params</code> is the data array of multiple series. The content of each item of the array is the same as above. Besides,</p>\n<pre><code class="lang-ts">{\n    componentType: &#39;series&#39;,\n    // Series type\n    seriesType: string,\n    // Series index in option.series\n    seriesIndex: number,\n    // Series name\n    seriesName: string,\n    // Data name, or category name\n    name: string,\n    // Data index in input data array\n    dataIndex: number,\n    // Original data as input\n    data: Object,\n    // Value of data. In most series it is the same as data.\n    // But in some series it is some part of the data (e.g., in map, radar)\n    value: number|Array|Object,\n    // encoding info of coordinate system\n    // Key: coord, like (&#39;x&#39; &#39;y&#39; &#39;radius&#39; &#39;angle&#39;)\n    // value: Must be an array, not null/undefined. Contain dimension indices, like:\n    // {\n    //     x: [2] // values on dimension index 2 are mapped to x axis.\n    //     y: [0] // values on dimension index 0 are mapped to y axis.\n    // }\n    encode: Object,\n    // dimension names list\n    dimensionNames: Array&lt;String&gt;,\n    // data dimension index, for example 0 or 1 or 2 ...\n    // Only work in `radar` series.\n    dimensionIndex: number,\n    // Color of data\n    color: string\n}\n</code></pre>\n<p><strong>How to use <code class="codespan">encode</code> and <code class="codespan">dimensionNames</code>?</strong></p>\n<p>When the dataset is like</p>\n<pre><code class="lang-ts">dataset: {\n    source: [\n        [&#39;Matcha Latte&#39;, 43.3, 85.8, 93.7],\n        [&#39;Milk Tea&#39;, 83.1, 73.4, 55.1],\n        [&#39;Cheese Cocoa&#39;, 86.4, 65.2, 82.5],\n        [&#39;Walnut Brownie&#39;, 72.4, 53.9, 39.1]\n    ]\n}\n</code></pre>\n<p>We can get the value of the y-axis via</p>\n<pre><code class="lang-ts">params.value[params.encode.y[0]]\n</code></pre>\n<p>When the dataset is like</p>\n<pre><code class="lang-ts">dataset: {\n    dimensions: [&#39;product&#39;, &#39;2015&#39;, &#39;2016&#39;, &#39;2017&#39;],\n    source: [\n        {product: &#39;Matcha Latte&#39;, &#39;2015&#39;: 43.3, &#39;2016&#39;: 85.8, &#39;2017&#39;: 93.7},\n        {product: &#39;Milk Tea&#39;, &#39;2015&#39;: 83.1, &#39;2016&#39;: 73.4, &#39;2017&#39;: 55.1},\n        {product: &#39;Cheese Cocoa&#39;, &#39;2015&#39;: 86.4, &#39;2016&#39;: 65.2, &#39;2017&#39;: 82.5},\n        {product: &#39;Walnut Brownie&#39;, &#39;2015&#39;: 72.4, &#39;2016&#39;: 53.9, &#39;2017&#39;: 39.1}\n    ]\n}\n</code></pre>\n<p>We can get the value of the y-axis via</p>\n<pre><code class="lang-ts">params.value[params.dimensionNames[params.encode.y[0]]]\n</code></pre>\n<p><strong>Note: </strong>Using array to present all the parameters in ECharts 2.x is not supported anymore.</p>\n<p>The second parameter <code class="codespan">ticket</code> is the asynchronous callback flag which should be used along with the third parameter <code class="codespan">callback</code> when it is used.</p>\n<p>The third parameter <code class="codespan">callback</code> is asynchronous callback. When the content of tooltip is acquired asynchronously, <code class="codespan">ticket</code> and <code class="codespan">htm</code> as introduced above can be used to update tooltip with callback.</p>\n<p>Example:</p>\n<pre><code class="lang-ts">formatter: function (params, ticket, callback) {\n    $.get(&#39;detail?name=&#39; + params.name, function (content) {\n        callback(ticket, toHTML(content));\n    });\n    return &#39;Loading&#39;;\n}\n</code></pre>\n',
    )
    valueFormatter: Optional[str] = Field(
        None,
        description='<blockquote>\n<p>Since <code class="codespan">v5.3.0</code></p>\n</blockquote>\n<p>Callback function for formatting the value section in tooltip.</p>\n<p>Interface:</p>\n<pre><code class="lang-ts">(value: number | string) =&gt; string\n</code></pre>\n<p>Example:</p>\n<pre><code class="lang-ts">// Add $ prefix\nvalueFormatter: (value) =&gt; &#39;$&#39; + value.toFixed(2)\n</code></pre>\n',
    )
    backgroundColor: Optional[Any] = Field(
        'rgba(50,50,50,0.7)',
        description='<p>The background color of tooltip&#39;s floating layer.</p>\n',
    )
    borderColor: Optional[Any] = Field(
        '#333',
        description='\n\n\n\n\n\n\n\n\n\n<p>The border color of tooltip&#39;s floating layer.</p>\n',
    )
    borderWidth: Optional[float] = Field(
        0,
        description='\n\n\n\n\n\n\n\n\n\n<p>The border width of tooltip&#39;s floating layer.</p>\n',
    )
    padding: Optional[float] = Field(
        5,
        description='\n\n\n\n\n\n\n\n\n\n\n\n\n\n<p>The floating layer of tooltip space around content. The unit is px. Default values for each position are 5. And they can be set to different values with left, right, top, and bottom.</p>\n<p>Examples:</p>\n<pre><code class="lang-ts">// Set padding to be 5\npadding: 5\n// Set the top and bottom paddings to be 5, and left and right paddings to be 10\npadding: [5, 10]\n// Set each of the four paddings seperately\npadding: [\n    5,  // up\n    10, // right\n    5,  // down\n    10, // left\n]\n</code></pre>\n',
    )
    textStyle: Optional[TextStyle11] = Field(
        None, description='<p>The text syle of tooltip&#39;s floating layer.</p>\n'
    )
    extraCssText: Optional[str] = Field(
        None,
        description='\n\n\n\n\n\n\n\n\n\n<p>Extra CSS style for floating layer. The following is an example for adding shadow.</p>\n<pre><code class="lang-ts">extraCssText: &#39;box-shadow: 0 0 3px rgba(0, 0, 0, 0.3);&#39;\n</code></pre>\n',
    )
    order: Optional[str] = Field(
        'seriesAsc',
        description='\n\n\n\n<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n<p>Tooltip order for multiple series. Defaults is <code class="codespan">&#39;seriesAsc&#39;</code>.</p>\n<p>Conditions to order tooltip. Options:</p>\n<ul>\n<li><p><code class="codespan">&#39;seriesAsc&#39;</code></p>\n<p>  Base on series declaration, ascending order tooltip.</p>\n</li>\n<li><p><code class="codespan">&#39;seriesDesc&#39;</code></p>\n<p>  Base on series declaration, descending order tooltip.</p>\n</li>\n<li><p><code class="codespan">&#39;valueAsc&#39;</code></p>\n<p>  Base on value, ascending order tooltip, only for numberic value.</p>\n</li>\n<li><p><code class="codespan">&#39;valueDesc&#39;</code></p>\n<p>  Base on value, descending order tooltip, only for numberic value.</p>\n</li>\n</ul>\n',
    )


class Label7(Label):
    """
    <p>label of axisPointer</p>

    """

    pass


class LineStyle34(LineStyle2):
    """
    <p>It is valid when <a href="#tooltip.axisPointer.type">axisPointer.type</a> is <code class="codespan">&#39;line&#39;</code>.</p>

    """

    pass


class ShadowStyle7(ShadowStyle):
    """
    <p>It is valid when <a href="#tooltip.axisPointer.type">axisPointer.type</a> is <code class="codespan">&#39;shadow&#39;</code>.</p>

    """

    pass


class Handle4(Handle):
    """
    <p>A button used to drag axisPointer. This feature is applicable in touch device. See <a href="http://localhost/echarts-website/examples/en/editor.html?c=line-tooltip-touch&amp;edit=1&amp;reset=1" target="_blank">example</a>.</p>

    """

    pass


class AxisPointer7(BaseModel):
    """
        <p>This is the global configurations of axisPointer.</p>
    <hr>
    <p><code class="codespan">axisPointer</code> is a tool for displaying reference line and axis value under mouse pointer.</p>
    <p>For example:</p>
    <iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=doc-example/candlestick-axisPointer&edit=1&reset=1" width="600" height="450"></iframe>


    <p>In the demo above, <a href="#axisPointer.link">axisPointer.link</a> is used to link axisPointer from different coordinate systems.</p>
    <p><code class="codespan">axisPointer</code> can also be used on touch device, where user can drag the button to move the reference line and label.</p>
    <iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=line-tooltip-touch&edit=1&reset=1" width="600" height="400"></iframe>


    <p>In the cases that more than one axis exist, axisPointer helps to look inside the data.</p>
    <iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=multiple-y-axis&edit=1&reset=1" width="600" height="300"></iframe>

    <iframe  data-src="http://localhost/echarts-website/examples/en/view.html?c=multiple-x-axis&edit=1&reset=1" width="600" height="300"></iframe>



    <hr>
    <blockquote>
    <p><strong>Notice:</strong>
    Generally, axisPointers is configured in each axes who need them (for example <a href="#xAxis.axisPointer">xAxis.axisPointer</a>), or configured in <code class="codespan">tooltip</code> (for example <a href="#tooltip.axisPointer">tooltip.axisPointer</a>).</p>
    </blockquote>
    <blockquote>
    <p>But these configurations can only be configured in global axisPointer:
    <a href="#axisPointer.triggerOn">axisPointer.triggerOn</a>, <a href="#axisPointer.link">axisPointer.link</a>.</p>
    </blockquote>
    <hr>
    <hr>
    <p><strong>How to display axisPointer:</strong></p>
    <p>In <a href="#grid">cartesian (grid)</a> and <a href="#single">polar](~polar) and (single axis</a>, each axis has its own axisPointer.</p>
    <p>Those axisPointer will not be displayed by default, utill configured as follows:</p>
    <ul>
    <li><p>Set <code class="codespan">someAxis.axisPointer.show</code> (like <a href="#xAxis.axisPointer.show">xAxis.axisPointer.show</a>) as <code class="codespan">true</code>. Then axisPointer of this axis will be displayed.</p>
    </li>
    <li><p>Set <a href="#tooltip.trigger">tooltip.trigger</a> as <code class="codespan">&#39;axis&#39;</code>, or set <a href="#tooltip.axisPointer.type">tooltip.axisPointer.type</a> as <code class="codespan">&#39;cross&#39;</code>. Then coordinate system will automatically chose the axes who will display their axisPointers. (<a href="#tooltip.axisPointer.axis">tooltip.axisPointer.axis</a> can be used to change the choice.) Notice, <code class="codespan">axis.axisPointer</code> will override <code class="codespan">tooltip.axisPointer</code> settings.</p>
    </li>
    </ul>
    <hr>
    <p><strong>How to display the label of axisPointer:</strong></p>
    <p>The label of axisPointer will not be displayed by default(namely, only reference line will be displayed by default), utill configured as follows:</p>
    <ul>
    <li><p>Set <code class="codespan">someAxis.axisPointer.label.show</code> (for example <a href="#xAxis.axisPointer.show">xAxis.axisPointer.label.show</a>) as <code class="codespan">true</code>. Then the label of the axisPointer will be displayed.</p>
    </li>
    <li><p>Set <a href="#tooltip.axisPointer.type">tooltip.axisPointer.type</a> as  <code class="codespan">&#39;cross&#39;</code>. Then the label of the crossed axisPointers will be displayed.</p>
    </li>
    </ul>
    <hr>
    <p><strong>How to configure axisPointer on touch device:</strong></p>
    <p>Set <code class="codespan">someAxis.axisPointer.handle.show</code> (for example <a href="#xAxis.axisPointer.handle.show">xAxis.axisPointer.handle.show</a> as <code class="codespan">true</code>. Then the button for dragging will be displayed. (This feature is not supported on polar).</p>
    <p><strong>Notice:</strong>
    If tooltip does not work well in this case, try to set<a href="#tooltip.triggerOn">tooltip.triggerOn</a> as <code class="codespan">&#39;none&#39;</code> (for the effect: show tooltip when finger holding on the button, and hide tooltip after finger left the button), or set <a href="#tooltip.alwaysShowContent">tooltip.alwaysShowContent</a> as <code class="codespan">true</code> (then tooltip will always be displayed).</p>
    <p>See the <a href="http://localhost/echarts-website/examples/en/editor.html?c=line-tooltip-touch&amp;edit=1&amp;reset=1" target="_blank">example</a>.</p>
    <hr>
    <p><strong>Snap to point</strong></p>
    <p>In value axis and time axis, if <a href="#xAxis.axisPointer.snap">snap</a> is set as true, axisPointer will snap to point automatically.</p>
    <hr>
    <hr>

    """

    id: Optional[str] = Field(
        None,
        description='<p>Component ID, not specified by default. If specified, it can be used to refer the component in option or API.</p>\n',
    )
    show: Optional[bool] = Field(
        False,
        description='\n\n<p>axisPointer will not be displayed by default. But if <a href="#tooltip.trigger">tooltip.trigger</a> is set as <code class="codespan">&#39;axis&#39;</code> or <a href="#tooltip.axisPointer.type">tooltip.axisPointer.type</a> is set as  <code class="codespan">&#39;cross&#39;</code>, axisPointer will be displayed automatically. Each coordinate system will automatically chose the axes whose will display its axisPointer. <a href="#tooltip.axisPointer.axis">tooltip.axisPointer.axis</a> can be used to change the choice.</p>\n',
    )
    type: Optional[str] = Field(
        'line',
        description='\n\n<p>Indicator type.</p>\n<p>Options:</p>\n<ul>\n<li><p><code class="codespan">&#39;line&#39;</code> line indicator.</p>\n</li>\n<li><p><code class="codespan">&#39;shadow&#39;</code> shadow crosshair indicator.</p>\n</li>\n<li><p><code class="codespan">&#39;none&#39;</code> no indicator displayed.</p>\n</li>\n</ul>\n',
    )
    snap: Optional[bool] = Field(
        None,
        description='<p>Whether snap to point automatically. The default value is auto determined.</p>\n<p>This feature usually makes sense in value axis and time axis, where tiny points can be seeked automatically.</p>\n',
    )
    z: Optional[float] = Field(
        None,
        description='<p>z value, which controls order of drawing graphical components. Components with smaller <code class="codespan">z</code> values may be overwritten by those with larger <code class="codespan">z</code> values.</p>\n',
    )
    label: Optional[Label7] = Field(None, description='<p>label of axisPointer</p>\n')
    lineStyle: Optional[LineStyle34] = Field(
        None,
        description='<p>It is valid when <a href="#tooltip.axisPointer.type">axisPointer.type</a> is <code class="codespan">&#39;line&#39;</code>.</p>\n',
    )
    shadowStyle: Optional[ShadowStyle7] = Field(
        None,
        description='<p>It is valid when <a href="#tooltip.axisPointer.type">axisPointer.type</a> is <code class="codespan">&#39;shadow&#39;</code>.</p>\n',
    )
    triggerTooltip: Optional[bool] = Field(
        True, description='\n\n<p>Whether to trigger tooltip.</p>\n'
    )
    value: Optional[float] = Field(
        None,
        description='<p>current value. When using <a href="xAxisPointer.handle" target="_blank">axisPointer.handle</a>, <code class="codespan">value</code> can be set to define the initial position of axisPointer.</p>\n',
    )
    status: Optional[bool] = Field(
        None,
        description='\n\n<p>Current status, can be <code class="codespan">&#39;show&#39;</code> 和 <code class="codespan">&#39;hide&#39;</code>.</p>\n',
    )
    handle: Optional[Handle4] = Field(
        None,
        description='<p>A button used to drag axisPointer. This feature is applicable in touch device. See <a href="http://localhost/echarts-website/examples/en/editor.html?c=line-tooltip-touch&amp;edit=1&amp;reset=1" target="_blank">example</a>.</p>\n',
    )
    link: Optional[Any] = Field(
        None,
        description='<p>axisPointers can be linked to each other. The term &quot;link&quot; represents that axes are synchronized and move together. Axes are linked according to the value of axisPointer.</p>\n<p>See <a href="http://localhost/echarts-website/examples/en/view.html?c=candlestick-brush&amp;edit=1&amp;reset=1" target="_blank">sampleA</a> and <a href="http://localhost/echarts-website/examples/en/view.html?c=scatter-nutrients-matrix&amp;edit=1&amp;reset=1" target="_blank">sampleB</a>.</p>\n<p>link is an array, where each item represents a &quot;link group&quot;. Axes will be linked when they are refered in the same link group. For example:</p>\n<pre><code class="lang-ts">link: [\n    {\n        // All axes with xAxisIndex 0, 3, 4 and yAxisName &#39;sameName&#39; will be linked.\n        xAxisIndex: [0, 3, 4],\n        yAxisName: &#39;someName&#39;\n    },\n    {\n        // All axes with xAxisId &#39;aa&#39;, &#39;cc&#39; and all angleAxis will be linked.\n        xAxisId: [&#39;aa&#39;, &#39;cc&#39;],\n        angleAxis: &#39;all&#39;\n    },\n    ...\n]\n</code></pre>\n<p>As illustrated above, axes can be refered in these approaches in a link group:</p>\n<pre><code class="lang-ts">{\n    // &#39;some&#39; represent the dimension name of a axis, namely, &#39;x&#39;, &#39;y&#39;, &#39;radius&#39;, &#39;angle&#39;, &#39;single&#39;\n    someAxisIndex: [...], // can be an array or a value or &#39;all&#39;\n    someAxisName: [...],  // can be an array or a value or &#39;all&#39;\n    someAxisId: [...],    // can be an array or a value or &#39;all&#39;\n}\n</code></pre>\n<hr>\n<hr>\n<p><strong>How to link axes with different <a href="#xAxis.type">axis.type</a>?</strong></p>\n<p>For example, the type of axisA is &#39;category&#39;, and the type of axisB type is &#39;time&#39;, we can write conversion function (mapper) in link group to convert values from an axis to another axis. For example:</p>\n<pre><code class="lang-ts">link: [{\n    xAxisIndex: [0, 1],\n    yAxisName: [&#39;yy&#39;],\n    mapper: function (sourceVal, sourceAxisInfo, targetAxisInfo) {\n        if (sourceAxisInfo.axisName === &#39;yy&#39;) {\n            // from timestamp to &#39;2012-02-05&#39;\n            return echarts.format.formatTime(&#39;yyyy-MM-dd&#39;, sourceVal);\n        }\n        else if (targetAxisInfo.axisName === &#39;yy&#39;) {\n            // from &#39;2012-02-05&#39; to date\n            return echarts.number.parseDate(dates[sourceVal]);\n        }\n        else {\n            return sourceVal;\n        }\n    }\n}]\n</code></pre>\n<p>Input parameters of mapper:</p>\n<p><code class="codespan">{number}</code> sourceVal</p>\n<p><code class="codespan">{Object}</code> sourceAxisInfo Including {axisDim, axisId, axisName, axisIndex, ...}</p>\n<p><code class="codespan">{Object}</code> targetAxisInfo Including {axisDim, axisId, axisName, axisIndex, ...}</p>\n<p>Return of mapper:</p>\n<p><code class="codespan">{number}</code> The result of conversion.</p>\n',
    )
    triggerOn: Optional[str] = Field(
        'mousemove|click',
        description='\n\n<p>Conditions to trigger tooltip. Options:</p>\n<ul>\n<li><p><code class="codespan">&#39;mousemove&#39;</code></p>\n<p>  Trigger when mouse moves.</p>\n</li>\n<li><p><code class="codespan">&#39;click&#39;</code></p>\n<p>  Trigger when mouse clicks.</p>\n</li>\n<li><p><code class="codespan">&#39;mousemove|click&#39;</code></p>\n<p>  Trigger when mouse clicks and moves.</p>\n</li>\n<li><p><code class="codespan">&#39;none&#39;</code></p>\n<p>  Do not triggered by <code class="codespan">&#39;mousemove&#39;</code> and <code class="codespan">&#39;click&#39;</code></p>\n</li>\n</ul>\n',
    )


class IconStyle(BaseModel):
    """
    <p>The style setting of save as image icon. Since icon label is displayed only when hovering on the icon, the label configuration options are available under <code class="codespan">emphasis</code>.</p>

    """

    color: Optional[Any] = Field(
        'none',
        description='\n\n<p> color. </p>\n<blockquote>\n<p>Supports setting as solid color using <code class="codespan">rgb(255,255,255)</code>, <code class="codespan">rgba(255,255,255,1)</code>, <code class="codespan">#fff</code>, etc. Also supports setting as gradient color and pattern fill, see <a href="#color">option.color</a> for details</p>\n</blockquote>\n',
    )
    borderColor: Optional[Any] = Field(
        '#666',
        description='\n\n<p> border color, whose format is similar to that of <code class="codespan">color</code>.</p>\n',
    )
    borderWidth: Optional[float] = Field(
        1,
        description='\n\n<p> border width. No border when it is set to be 0.</p>\n<p> border width. No border when it is set to be 0.</p>\n',
    )
    borderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p> border type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">borderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\nborderType: [5, 10],\n\nborderDashOffset: 5\n}\n</code></pre>\n',
    )
    borderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">borderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    borderCap: Optional[str] = Field(
        'butt',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To specify how to draw the end points of the line.\nPossible values are:</p>\n<ul>\n<li><code class="codespan">&#39;butt&#39;</code>: The ends of lines are squared off at the endpoints.</li>\n<li><code class="codespan">&#39;round&#39;</code>: The ends of lines are rounded.</li>\n<li><code class="codespan">&#39;square&#39;</code>: The ends of lines are squared off by adding a box with an equal width and half the height of the line&#39;s thickness.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;butt&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineCap" target="_blank">lineCap</a> for more details.</p>\n',
    )
    borderJoin: Optional[str] = Field(
        'bevel',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To determine the shape used to join two line segments where they meet.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;bevel&#39;</code>: Fills an additional triangular area between the common endpoint of connected segments, and the separate outside rectangular corners of each segment.</li>\n<li><code class="codespan">&#39;round&#39;</code>: Rounds off the corners of a shape by filling an additional sector of disc centered at the common endpoint of connected segments. The radius for these rounded corners is equal to the line width.</li>\n<li><code class="codespan">&#39;miter&#39;</code>: Connected segments are joined by extending their outside edges to connect at a single point, with the effect of filling an additional lozenge-shaped area. This setting is affected by the \n<code class="codespan">borderMiterLimit</code>\nproperty.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;bevel&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineJoin" target="_blank">lineJoin</a> for more details.</p>\n',
    )
    borderMiterLimit: Optional[float] = Field(
        10,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the miter limit ratio. Only works when \n<code class="codespan">borderJoin</code>\n is set as <code class="codespan">miter</code>.</p>\n<p>Default value is <code class="codespan">10</code>. Negative、<code class="codespan">0</code>、<code class="codespan">Infinity</code> and <code class="codespan">NaN</code> values are ignored.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/miterLimit" target="_blank">miterLimit</a> for more details.</p>\n',
    )
    shadowBlur: Optional[float] = Field(
        None,
        description='\n\n<p>Size of shadow blur. This attribute should be used along with <code class="codespan">shadowColor</code>,<code class="codespan">shadowOffsetX</code>, <code class="codespan">shadowOffsetY</code> to set shadow to component.</p>\n<p>For example:</p>\n<pre><code class="lang-ts">{\n    shadowColor: &#39;rgba(0, 0, 0, 0.5)&#39;,\n    shadowBlur: 10\n}\n</code></pre>\n',
    )
    shadowColor: Optional[Any] = Field(
        None,
        description='\n\n<p>Shadow color. Support same format as <code class="codespan">color</code>.</p>\n',
    )
    shadowOffsetX: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the horizontal direction of shadow.</p>\n',
    )
    shadowOffsetY: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the vertical direction of shadow.</p>\n',
    )
    opacity: Optional[float] = Field(
        None,
        description='\n\n<p>Opacity of the component. Supports value from 0 to 1, and the component will not be drawn when set to 0.</p>\n',
    )


class IconStyle1(BaseModel):
    color: Optional[Any] = Field(
        None,
        description='\n\n<p> color. </p>\n<blockquote>\n<p>Supports setting as solid color using <code class="codespan">rgb(255,255,255)</code>, <code class="codespan">rgba(255,255,255,1)</code>, <code class="codespan">#fff</code>, etc. Also supports setting as gradient color and pattern fill, see <a href="#color">option.color</a> for details</p>\n</blockquote>\n',
    )
    borderColor: Optional[Any] = Field(
        '#000',
        description='\n\n<p> border color, whose format is similar to that of <code class="codespan">color</code>.</p>\n',
    )
    borderWidth: Optional[float] = Field(
        0,
        description='\n\n<p> border width. No border when it is set to be 0.</p>\n<p> border width. No border when it is set to be 0.</p>\n',
    )
    borderType: Optional[Union[str, float, Any]] = Field(
        'solid',
        description='\n\n\n<p> border type.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;solid&#39;</code></li>\n<li><code class="codespan">&#39;dashed&#39;</code></li>\n<li><code class="codespan">&#39;dotted&#39;</code></li>\n</ul>\n<p>Since <code class="codespan">v5.0.0</code>, it can also be a number or a number array to specify the <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray" target="_blank">dash array</a> of the line. With \n<code class="codespan">borderDashOffset</code>\n, we can make the line style more flexible.</p>\n<p>For example：</p>\n<pre><code class="lang-ts">{\n\nborderType: [5, 10],\n\nborderDashOffset: 5\n}\n</code></pre>\n',
    )
    borderDashOffset: Optional[float] = Field(
        0,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the line dash offset. With \n<code class="codespan">borderType</code>\n, we can make the line style more flexible.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset" target="_blank">lineDashOffset</a> for more details.</p>\n',
    )
    borderCap: Optional[str] = Field(
        'butt',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To specify how to draw the end points of the line.\nPossible values are:</p>\n<ul>\n<li><code class="codespan">&#39;butt&#39;</code>: The ends of lines are squared off at the endpoints.</li>\n<li><code class="codespan">&#39;round&#39;</code>: The ends of lines are rounded.</li>\n<li><code class="codespan">&#39;square&#39;</code>: The ends of lines are squared off by adding a box with an equal width and half the height of the line&#39;s thickness.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;butt&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineCap" target="_blank">lineCap</a> for more details.</p>\n',
    )
    borderJoin: Optional[str] = Field(
        'bevel',
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To determine the shape used to join two line segments where they meet.</p>\n<p>Possible values are:</p>\n<ul>\n<li><code class="codespan">&#39;bevel&#39;</code>: Fills an additional triangular area between the common endpoint of connected segments, and the separate outside rectangular corners of each segment.</li>\n<li><code class="codespan">&#39;round&#39;</code>: Rounds off the corners of a shape by filling an additional sector of disc centered at the common endpoint of connected segments. The radius for these rounded corners is equal to the line width.</li>\n<li><code class="codespan">&#39;miter&#39;</code>: Connected segments are joined by extending their outside edges to connect at a single point, with the effect of filling an additional lozenge-shaped area. This setting is affected by the \n<code class="codespan">borderMiterLimit</code>\nproperty.</li>\n</ul>\n<p>Default value is <code class="codespan">&#39;bevel&#39;</code>. Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineJoin" target="_blank">lineJoin</a> for more details.</p>\n',
    )
    borderMiterLimit: Optional[float] = Field(
        10,
        description='<blockquote>\n<p>Since <code class="codespan">v5.0.0</code></p>\n</blockquote>\n\n\n<p>To set the miter limit ratio. Only works when \n<code class="codespan">borderJoin</code>\n is set as <code class="codespan">miter</code>.</p>\n<p>Default value is <code class="codespan">10</code>. Negative、<code class="codespan">0</code>、<code class="codespan">Infinity</code> and <code class="codespan">NaN</code> values are ignored.</p>\n<p>Refer to MDN <a href="https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/miterLimit" target="_blank">miterLimit</a> for more details.</p>\n',
    )
    shadowBlur: Optional[float] = Field(
        None,
        description='\n\n<p>Size of shadow blur. This attribute should be used along with <code class="codespan">shadowColor</code>,<code class="codespan">shadowOffsetX</code>, <code class="codespan">shadowOffsetY</code> to set shadow to component.</p>\n<p>For example:</p>\n<pre><code class="lang-ts">{\n    shadowColor: &#39;rgba(0, 0, 0, 0.5)&#39;,\n    shadowBlur: 10\n}\n</code></pre>\n',
    )
    shadowColor: Optional[Any] = Field(
        None,
        description='\n\n<p>Shadow color. Support same format as <code class="codespan">color</code>.</p>\n',
    )
    shadowOffsetX: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the horizontal direction of shadow.</p>\n',
    )
    shadowOffsetY: Optional[float] = Field(
        0,
        description='\n\n<p>Offset distance on the vertical direction of shadow.</p>\n',
    )
    opacity: Optional[float] = Field(
        None,
        description='\n\n<p>Opacity of the component. Supports value from 0 to 1, and the component will not be drawn when set to 0.</p>\n',
    )
    textPosition: Optional[str] = Field(
        'bottom',
        description='<p>Text position: <code class="codespan">&#39;left&#39;</code> / <code class="codespan">&#39;right&#39;</code> / <code class="codespan">&#39;top&#39;</code> / <code class="codespan">&#39;bottom&#39;</code>.</p>\n',
    )
    textFill: Optional[str] = Field(
        '#000',
        description='\n\n<p>Fill color of text. If it&#39;s not set, it will use in the order of icon&#39;s fill color, stroke color, and <code class="codespan">&#39;#000&#39;</code>.</p>\n',
    )
    textAlign: Optional[str] = Field(
        'center',
        description='\n\n<p>Text align: <code class="codespan">&#39;left&#39;</code> / <code class="codespan">&#39;center&#39;</code> / <code class="codespan">&#39;right&#39;</code>.</p>\n',
    )
    textBackgroundColor: Optional[str] = Field(
        None, description='\n\n<p>Text background color.</p>\n'
    )
    textBorderRadius: Optional[float] = Field(
        None, description='\n\n<p>Border radius of text area.</p>\n'
    )
    textPadding: Optional[float] = Field(
        None, description='\n\n<p>Padding of text area.</p>\n'
    )


class Emphasis2(BaseModel):
    iconStyle: Optional[IconStyle1] = Field(None, description='')


class SaveAsImage(BaseModel):
    """
    <p>Save as image.</p>

    """

    type: Optional[str] = Field(
        'png',
        description='\n\n<p>File suffix of the image saved.</p>\n<ul>\n<li>If the <code class="codespan">renderer</code> is set to be <code class="codespan">&#39;canvas&#39;</code> when chart <a href="api.html#echarts.init" target="_blank">initialized</a> (default), then <code class="codespan">&#39;png&#39;</code> (default) and <code class="codespan">&#39;jpg&#39;</code> are supported.</li>\n<li>If the <code class="codespan">renderer</code> is set to be <code class="codespan">&#39;svg&#39;</code> when when chart <a href="api.html#echarts.init" target="_blank">initialized</a>, then only <code class="codespan">&#39;svg&#39;</code> is supported for <code class="codespan">type</code> (<code class="codespan">&#39;svg&#39;</code> type is supported since <code class="codespan">v4.8.0</code>).</li>\n</ul>\n',
    )
    name: Optional[str] = Field(
        None,
        description='\n\n<p>Name to save the image, whose default value is <a href="#title.text">title.text</a>.</p>\n',
    )
    backgroundColor: Optional[Any] = Field(
        'auto',
        description='\n\n<p>Background color to save the image, whose default value is <a href="#backgroundColor">backgroundColor</a>. If <code class="codespan">backgroundColor</code> is not set, white color is used.</p>\n',
    )
    connectedBackgroundColor: Optional[Any] = Field(
        '#fff',
        description='\n\n<p>When <a href="api.html#echarts.connect" target="_blank">echarts.connect</a> is used to connect the interaction of multiple chart series, they will all be included in the exported image. This option sets the background color between these charts.</p>\n',
    )
    excludeComponents: Optional[Any] = Field(
        "['toolbox']",
        description='<p>Components to be excluded when export. By default, toolbox is excluded.</p>\n',
    )
    show: Optional[bool] = Field(True, description='<p>Whether to show the tool.</p>\n')
    title: Optional[str] = Field('save as image', description='')
    icon: Optional[Any] = Field(
        None,
        description='<p>It can be set to an image with <code class="codespan">&#39;image://url&#39;</code> , in which URL is the link to an image, or <code class="codespan">dataURI</code> of an image.</p>\n<p>An image URL example:</p>\n<pre><code>&#39;image://http://example.website/a/b.png&#39;\n</code></pre><p>A <code class="codespan">dataURI</code> example:</p>\n<pre><code>&#39;image://data:image/gif;base64,R0lGODlhEAAQAMQAAORHHOVSKudfOulrSOp3WOyDZu6QdvCchPGolfO0o/XBs/fNwfjZ0frl3/zy7////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAkAABAALAAAAAAQABAAAAVVICSOZGlCQAosJ6mu7fiyZeKqNKToQGDsM8hBADgUXoGAiqhSvp5QAnQKGIgUhwFUYLCVDFCrKUE1lBavAViFIDlTImbKC5Gm2hB0SlBCBMQiB0UjIQA7&#39;\n</code></pre><p>Icons can be set to arbitrary vector path via <code class="codespan">&#39;path://&#39;</code> in ECharts. As compared with a raster image, vector paths prevent jagging and blurring when scaled, and have better control over changing colors. The size of the vector icon will be adapted automatically. Refer to <a href="http://www.w3.org/TR/SVG/paths.html#PathData" target="_blank">SVG PathData</a> for more information about the format of the path. You may export vector paths from tools like Adobe </p>\n<p>For example:</p>\n<pre><code>&#39;path://M30.9,53.2C16.8,53.2,5.3,41.7,5.3,27.6S16.8,2,30.9,2C45,2,56.4,13.5,56.4,27.6S45,53.2,30.9,53.2z M30.9,3.5C17.6,3.5,6.8,14.4,6.8,27.6c0,13.3,10.8,24.1,24.101,24.1C44.2,51.7,55,40.9,55,27.6C54.9,14.4,44.1,3.5,30.9,3.5z M36.9,35.8c0,0.601-0.4,1-0.9,1h-1.3c-0.5,0-0.9-0.399-0.9-1V19.5c0-0.6,0.4-1,0.9-1H36c0.5,0,0.9,0.4,0.9,1V35.8z M27.8,35.8 c0,0.601-0.4,1-0.9,1h-1.3c-0.5,0-0.9-0.399-0.9-1V19.5c0-0.6,0.4-1,0.9-1H27c0.5,0,0.9,0.4,0.9,1L27.8,35.8L27.8,35.8z&#39;\n</code></pre>',
    )
    iconStyle: Optional[IconStyle] = Field(
        None,
        description='<p>The style setting of save as image icon. Since icon label is displayed only when hovering on the icon, the label configuration options are available under <code class="codespan">emphasis</code>.</p>\n',
    )
    emphasis: Optional[Emphasis2] = Field(None, description='')
    pixelRatio: Optional[float] = Field(
        1,
        description='\n\n<p>Resolution ratio to save image, whose default value is that of the container. Values larger than 1 (e.g.: 2) is supported when you need higher resolution.</p>\n',
    )


class IconStyle2(IconStyle):
    """
    <p>The style setting of restore icon. Since icon label is displayed only when hovering on the icon, the label configuration options are available under <code class="codespan">emphasis</code>.</p>

    """

    pass


class IconStyle3(IconStyle1):
    pass


class Emphasis3(BaseModel):
    iconStyle: Optional[IconStyle3] = Field(None, description='')


class Restore(BaseModel):
    """
    <p>Restore configuration item.</p>

    """

    show: Optional[bool] = Field(True, description='<p>Whether to show the tool.</p>\n')
    title: Optional[str] = Field('restore', description='')
    icon: Optional[Any] = Field(
        None,
        description='<p>It can be set to an image with <code class="codespan">&#39;image://url&#39;</code> , in which URL is the link to an image, or <code class="codespan">dataURI</code> of an image.</p>\n<p>An image URL example:</p>\n<pre><code>&#39;image://http://example.website/a/b.png&#39;\n</code></pre><p>A <code class="codespan">dataURI</code> example:</p>\n<pre><code>&#39;image://data:image/gif;base64,R0lGODlhEAAQAMQAAORHHOVSKudfOulrSOp3WOyDZu6QdvCchPGolfO0o/XBs/fNwfjZ0frl3/zy7////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAkAABAALAAAAAAQABAAAAVVICSOZGlCQAosJ6mu7fiyZeKqNKToQGDsM8hBADgUXoGAiqhSvp5QAnQKGIgUhwFUYLCVDFCrKUE1lBavAViFIDlTImbKC5Gm2hB0SlBCBMQiB0UjIQA7&#39;\n</code></pre><p>Icons can be set to arbitrary vector path via <code class="codespan">&#39;path://&#39;</code> in ECharts. As compared with a raster image, vector paths prevent jagging and blurring when scaled, and have better control over changing colors. The size of the vector icon will be adapted automatically. Refer to <a href="http://www.w3.org/TR/SVG/paths.html#PathData" target="_blank">SVG PathData</a> for more information about the format of the path. You may export vector paths from tools like Adobe </p>\n<p>For example:</p>\n<pre><code>&#39;path://M30.9,53.2C16.8,53.2,5.3,41.7,5.3,27.6S16.8,2,30.9,2C45,2,56.4,13.5,56.4,27.6S45,53.2,30.9,53.2z M30.9,3.5C17.6,3.5,6.8,14.4,6.8,27.6c0,13.3,10.8,24.1,24.101,24.1C44.2,51.7,55,40.9,55,27.6C54.9,14.4,44.1,3.5,30.9,3.5z M36.9,35.8c0,0.601-0.4,1-0.9,1h-1.3c-0.5,0-0.9-0.399-0.9-1V19.5c0-0.6,0.4-1,0.9-1H36c0.5,0,0.9,0.4,0.9,1V35.8z M27.8,35.8 c0,0.601-0.4,1-0.9,1h-1.3c-0.5,0-0.9-0.399-0.9-1V19.5c0-0.6,0.4-1,0.9-1H27c0.5,0,0.9,0.4,0.9,1L27.8,35.8L27.8,35.8z&#39;\n</code></pre>',
    )
    iconStyle: Optional[IconStyle2] = Field(
        None,
        description='<p>The style setting of restore icon. Since icon label is displayed only when hovering on the icon, the label configuration options are available under <code class="codespan">emphasis</code>.</p>\n',
    )
    emphasis: Optional[Emphasis3] = Field(None, description='')


class IconStyle4(IconStyle):
    """
    <p>The style setting of data view icon. Since icon label is displayed only when hovering on the icon, the label configuration options are available under <code class="codespan">emphasis</code>.</p>

    """

    pass


class IconStyle5(IconStyle1):
    pass


class Emphasis4(BaseModel):
    iconStyle: Optional[IconStyle5] = Field(None, description='')


class DataView(BaseModel):
    """
    <p>Data view tool, which could display data in current chart and updates chart after being edited.</p>

    """

    show: Optional[bool] = Field(True, description='<p>Whether to show the tool.</p>\n')
    title: Optional[str] = Field('data view', description='')
    icon: Optional[Any] = Field(
        None,
        description='<p>It can be set to an image with <code class="codespan">&#39;image://url&#39;</code> , in which URL is the link to an image, or <code class="codespan">dataURI</code> of an image.</p>\n<p>An image URL example:</p>\n<pre><code>&#39;image://http://example.website/a/b.png&#39;\n</code></pre><p>A <code class="codespan">dataURI</code> example:</p>\n<pre><code>&#39;image://data:image/gif;base64,R0lGODlhEAAQAMQAAORHHOVSKudfOulrSOp3WOyDZu6QdvCchPGolfO0o/XBs/fNwfjZ0frl3/zy7////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAkAABAALAAAAAAQABAAAAVVICSOZGlCQAosJ6mu7fiyZeKqNKToQGDsM8hBADgUXoGAiqhSvp5QAnQKGIgUhwFUYLCVDFCrKUE1lBavAViFIDlTImbKC5Gm2hB0SlBCBMQiB0UjIQA7&#39;\n</code></pre><p>Icons can be set to arbitrary vector path via <code class="codespan">&#39;path://&#39;</code> in ECharts. As compared with a raster image, vector paths prevent jagging and blurring when scaled, and have better control over changing colors. The size of the vector icon will be adapted automatically. Refer to <a href="http://www.w3.org/TR/SVG/paths.html#PathData" target="_blank">SVG PathData</a> for more information about the format of the path. You may export vector paths from tools like Adobe </p>\n<p>For example:</p>\n<pre><code>&#39;path://M30.9,53.2C16.8,53.2,5.3,41.7,5.3,27.6S16.8,2,30.9,2C45,2,56.4,13.5,56.4,27.6S45,53.2,30.9,53.2z M30.9,3.5C17.6,3.5,6.8,14.4,6.8,27.6c0,13.3,10.8,24.1,24.101,24.1C44.2,51.7,55,40.9,55,27.6C54.9,14.4,44.1,3.5,30.9,3.5z M36.9,35.8c0,0.601-0.4,1-0.9,1h-1.3c-0.5,0-0.9-0.399-0.9-1V19.5c0-0.6,0.4-1,0.9-1H36c0.5,0,0.9,0.4,0.9,1V35.8z M27.8,35.8 c0,0.601-0.4,1-0.9,1h-1.3c-0.5,0-0.9-0.399-0.9-1V19.5c0-0.6,0.4-1,0.9-1H27c0.5,0,0.9,0.4,0.9,1L27.8,35.8L27.8,35.8z&#39;\n</code></pre>',
    )
    iconStyle: Optional[IconStyle4] = Field(
        None,
        description='<p>The style setting of data view icon. Since icon label is displayed only when hovering on the icon, the label configuration options are available under <code class="codespan">emphasis</code>.</p>\n',
    )
    emphasis: Optional[Emphasis4] = Field(None, description='')
    readOnly: Optional[bool] = Field(
        False, description='\n\n<p>Whether it is read-only.</p>\n'
    )
    optionToContent: Optional[Any] = Field(
        None,
        description='<pre><code class="lang-ts">(option:Object) =&gt; HTMLDomElement|string\n</code></pre>\n<p>Define a function to present dataView. It is used to replace default textarea for richer data editing. It can return a DOM object, or an HTML string.</p>\n<p>For example:</p>\n<pre><code class="lang-ts">optionToContent: function(opt) {\n    var axisData = opt.xAxis[0].data;\n    var series = opt.series;\n    var table = &#39;&lt;table style=&quot;width:100%;text-align:center&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&#39;\n                 + &#39;&lt;td&gt;Time:&lt;/td&gt;&#39;\n                 + &#39;&lt;td&gt;&#39; + series[0].name + &#39;&lt;/td&gt;&#39;\n                 + &#39;&lt;td&gt;&#39; + series[1].name + &#39;&lt;/td&gt;&#39;\n                 + &#39;&lt;/tr&gt;&#39;;\n    for (var i = 0, l = axisData.length; i &lt; l; i++) {\n        table += &#39;&lt;tr&gt;&#39;\n                 + &#39;&lt;td&gt;&#39; + axisData[i] + &#39;&lt;/td&gt;&#39;\n                 + &#39;&lt;td&gt;&#39; + series[0].data[i] + &#39;&lt;/td&gt;&#39;\n                 + &#39;&lt;td&gt;&#39; + series[1].data[i] + &#39;&lt;/td&gt;&#39;\n                 + &#39;&lt;/tr&gt;&#39;;\n    }\n    table += &#39;&lt;/tbody&gt;&lt;/table&gt;&#39;;\n    return table;\n}\n</code></pre>\n',
    )
    contentToOption: Optional[Any] = Field(
        None,
        description='<pre><code class="lang-ts">(container:HTMLDomElement, option:Object) =&gt; Object\n</code></pre>\n<p>When optionToContent is used, if you want to support refreshing chart after data changes, you need to implement the logic to merge options in this function.</p>\n',
    )
    lang: Optional[Any] = Field(
        "['data view', 'turn off', 'refresh']",
        description='<p>There are 3 names in data view, which are <code class="codespan">[&#39;data view&#39;, &#39;turn off&#39; and &#39;refresh&#39;]</code>.</p>\n',
    )
    backgroundColor: Optional[str] = Field(
        '#fff',
        description='\n\n<p>Background color of the floating layer in data view.</p>\n',
    )
    textareaColor: Optional[str] = Field(
        '#fff',
        description='\n\n<p>Background color of input area of the floating layer in data view.</p>\n',
    )
    textareaBorderColor: Optional[str] = Field(
        '#333',
        description='\n\n<p>Border color of input area of the floating layer in data view.</p>\n',
    )
    textColor: Optional[str] = Field('#000', description='\n\n<p>Text color.</p>\n')
    buttonColor: Optional[str] = Field(
        '#c23531', description='\n\n<p>Button color.</p>\n'
    )
    buttonTextColor: Optional[str] = Field(
        '#fff', description='\n\n<p>Color of button text.</p>\n'
    )


class Title1(BaseModel):
    """
    <p>Restored and zoomed title text.</p>

    """

    zoom: Optional[str] = Field('area zooming', description='')
    back: Optional[str] = Field('restore area zooming', description='')


class Icon(BaseModel):
    """
    <p>Zooming and restore icon path.</p>

    """

    zoom: Optional[str] = Field(
        None,
        description='<p>It can be set to an image with <code class="codespan">&#39;image://url&#39;</code> , in which URL is the link to an image, or <code class="codespan">dataURI</code> of an image.</p>\n<p>An image URL example:</p>\n<pre><code>&#39;image://http://example.website/a/b.png&#39;\n</code></pre><p>A <code class="codespan">dataURI</code> example:</p>\n<pre><code>&#39;image://data:image/gif;base64,R0lGODlhEAAQAMQAAORHHOVSKudfOulrSOp3WOyDZu6QdvCchPGolfO0o/XBs/fNwfjZ0frl3/zy7////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAkAABAALAAAAAAQABAAAAVVICSOZGlCQAosJ6mu7fiyZeKqNKToQGDsM8hBADgUXoGAiqhSvp5QAnQKGIgUhwFUYLCVDFCrKUE1lBavAViFIDlTImbKC5Gm2hB0SlBCBMQiB0UjIQA7&#39;\n</code></pre><p>Icons can be set to arbitrary vector path via <code class="codespan">&#39;path://&#39;</code> in ECharts. As compared with a raster image, vector paths prevent jagging and blurring when scaled, and have better control over changing colors. The size of the vector icon will be adapted automatically. Refer to <a href="http://www.w3.org/TR/SVG/paths.html#PathData" target="_blank">SVG PathData</a> for more information about the format of the path. You may export vector paths from tools like Adobe </p>\n<p>For example:</p>\n<pre><code>&#39;path://M30.9,53.2C16.8,53.2,5.3,41.7,5.3,27.6S16.8,2,30.9,2C45,2,56.4,13.5,56.4,27.6S45,53.2,30.9,53.2z M30.9,3.5C17.6,3.5,6.8,14.4,6.8,27.6c0,13.3,10.8,24.1,24.101,24.1C44.2,51.7,55,40.9,55,27.6C54.9,14.4,44.1,3.5,30.9,3.5z M36.9,35.8c0,0.601-0.4,1-0.9,1h-1.3c-0.5,0-0.9-0.399-0.9-1V19.5c0-0.6,0.4-1,0.9-1H36c0.5,0,0.9,0.4,0.9,1V35.8z M27.8,35.8 c0,0.601-0.4,1-0.9,1h-1.3c-0.5,0-0.9-0.399-0.9-1V19.5c0-0.6,0.4-1,0.9-1H27c0.5,0,0.9,0.4,0.9,1L27.8,35.8L27.8,35.8z&#39;\n</code></pre>',
    )
    back: Optional[str] = Field(
        None,
        description='<p>It can be set to an image with <code class="codespan">&#39;image://url&#39;</code> , in which URL is the link to an image, or <code class="codespan">dataURI</code> of an image.</p>\n<p>An image URL example:</p>\n<pre><code>&#39;image://http://example.website/a/b.png&#39;\n</code></pre><p>A <code class="codespan">dataURI</code> example:</p>\n<pre><code>&#39;image://data:image/gif;base64,R0lGODlhEAAQAMQAAORHHOVSKudfOulrSOp3WOyDZu6QdvCchPGolfO0o/XBs/fNwfjZ0frl3/zy7////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAkAABAALAAAAAAQABAAAAVVICSOZGlCQAosJ6mu7fiyZeKqNKToQGDsM8hBADgUXoGAiqhSvp5QAnQKGIgUhwFUYLCVDFCrKUE1lBavAViFIDlTImbKC5Gm2hB0SlBCBMQiB0UjIQA7&#39;\n</code></pre><p>Icons can be set to arbitrary vector path via <code class="codespan">&#39;path://&#39;</code> in ECharts. As compared with a raster image, vector paths prevent jagging and blurring when scaled, and have better control over changing colors. The size of the vector icon will be adapted automatically. Refer to <a href="http://www.w3.org/TR/SVG/paths.html#PathData" target="_blank">SVG PathData</a> for more information about the format of the path. You may export vector paths from tools like Adobe </p>\n<p>For example:</p>\n<pre><code>&#39;path://M30.9,53.2C16.8,53.2,5.3,41.7,5.3,27.6S16.8,2,30.9,2C45,2,56.4,13.5,56.4,27.6S45,53.2,30.9,53.2z M30.9,3.5C17.6,3.5,6.8,14.4,6.8,27.6c0,13.3,10.8,24.1,24.101,24.1C44.2,51.7,55,40.9,55,27.6C54.9,14.4,44.1,3.5,30.9,3.5z M36.9,35.8c0,0.601-0.4,1-0.9,1h-1.3c-0.5,0-0.9-0.399-0.9-1V19.5c0-0.6,0.4-1,0.9-1H36c0.5,0,0.9,0.4,0.9,1V35.8z M27.8,35.8 c0,0.601-0.4,1-0.9,1h-1.3c-0.5,0-0.9-0.399-0.9-1V19.5c0-0.6,0.4-1,0.9-1H27c0.5,0,0.9,0.4,0.9,1L27.8,35.8L27.8,35.8z&#39;\n</code></pre>',
    )


class IconStyle6(IconStyle):
    """
    <p>The style setting of data area zooming icon. Since icon label is displayed only when hovering on the icon, the label configuration options are available under <code class="codespan">emphasis</code>.</p>

    """

    pass


class IconStyle7(IconStyle1):
    pass


class Emphasis5(BaseModel):
    iconStyle: Optional[IconStyle7] = Field(None, description='')


class BrushStyle1(HandleStyle1):
    """
    <p>Style of brush rectangle.</p>

    """

    pass


class DataZoom1(BaseModel):
    """
    <p>Data area zooming, which only supports rectangular coordinate by now.</p>

    """

    show: Optional[bool] = Field(True, description='<p>Whether to show the tool.</p>\n')
    title: Optional[Title1] = Field(
        None, description='<p>Restored and zoomed title text.</p>\n'
    )
    icon: Optional[Icon] = Field(
        None, description='<p>Zooming and restore icon path.</p>\n'
    )
    iconStyle: Optional[IconStyle6] = Field(
        None,
        description='<p>The style setting of data area zooming icon. Since icon label is displayed only when hovering on the icon, the label configuration options are available under <code class="codespan">emphasis</code>.</p>\n',
    )
    emphasis: Optional[Emphasis5] = Field(None, description='')
    filterMode: Optional[str] = Field(
        'filter',
        description='<p>The same meaning as <a href="#dataZoom.filterMode">dataZoom.filterMode</a>.</p>\n',
    )
    xAxisIndex: Optional[Union[float, Any, bool]] = Field(
        None,
        description='<p>Defines which <a href="#xAxis">xAxis</a> should be controlled. By default, it controls all x axes. If it is set to be <code class="codespan">false</code>, then no x axis is controlled. If it is set to be then it controls axis with axisIndex of <code class="codespan">3</code>. If it is set to be <code class="codespan">[0, 3]</code>, it controls the x-axes with axisIndex of <code class="codespan">0</code> and <code class="codespan">3</code>.</p>\n',
    )
    yAxisIndex: Optional[Union[float, Any, bool]] = Field(
        None,
        description='<p>Defines which <a href="#yAxis">yAxis</a> should be controlled. By default, it controls all y axes. If it is set to be <code class="codespan">false</code>, then no y axis is controlled. If it is set to be then it controls axis with axisIndex of <code class="codespan">3</code>. If it is set to be <code class="codespan">[0, 3]</code>, it controls the x-axes with axisIndex of <code class="codespan">0</code> and <code class="codespan">3</code>.</p>\n',
    )
    brushStyle: Optional[BrushSty