# Generated by Django 3.2.20 on 2023-08-06 06:26

import uuid

import django.core.serializers.json
import django.core.validators
import django.db.models.deletion
import nautobot.extras.models.mixins
import nautobot.extras.models.statuses
import taggit.managers
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('dcim', '0023_interface_redundancy_group_data_migration'),
        ('circuits', '0009_circuittermination_location'),
        ('contenttypes', '0002_remove_content_type_name'),
        ('extras', '0058_jobresult_add_time_status_idxs'),
    ]

    operations = [
        migrations.CreateModel(
            name='RadioAttributes',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True)),
                ('created', models.DateField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('_custom_field_data', models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder)),
                ('human_id', models.CharField(editable=False, max_length=255, unique=True)),
                ('radio_type', models.CharField(default='PTP', max_length=4)),
                ('description', models.CharField(blank=True, max_length=200, null=True)),
                ('failover', models.BooleanField()),
                ('azimuth', models.IntegerField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(359)])),
                ('capacity', models.DecimalField(blank=True, decimal_places=2, max_digits=4, null=True)),
                ('is_duplex', models.BooleanField(default=True)),
                ('tilt', models.IntegerField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(-90), django.core.validators.MaxValueValidator(90)])),
                ('centerline_height', models.IntegerField(blank=True, null=True)),
                ('channel_size', models.IntegerField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(8000)])),
                ('tx_high_low', models.CharField(blank=True, max_length=4, null=True)),
                ('tx_power', models.IntegerField(blank=True, null=True)),
                ('tx_freq_1', models.IntegerField(blank=True, null=True)),
                ('tx_polarization_1', models.CharField(blank=True, max_length=4, null=True)),
                ('tx_freq_2', models.IntegerField(blank=True, null=True)),
                ('tx_polarization_2', models.CharField(blank=True, max_length=4)),
                ('radio', models.OneToOneField(on_delete=django.db.models.deletion.PROTECT, related_name='radio_attributes', to='dcim.device')),
                ('status', nautobot.extras.models.statuses.StatusField(null=True, on_delete=django.db.models.deletion.PROTECT, related_name='nautobot_plugin_w_rrm_radioattributes_related', to='extras.status')),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
            ],
            options={
                'verbose_name': 'Radio Attributes',
                'verbose_name_plural': 'Radio Attributes',
                'ordering': ['radio'],
            },
            bases=(models.Model, nautobot.extras.models.mixins.DynamicGroupMixin, nautobot.extras.models.mixins.NotesMixin),
        ),
        migrations.CreateModel(
            name='CircuitAttributes',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True)),
                ('created', models.DateField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('_custom_field_data', models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder)),
                ('human_id', models.CharField(editable=False, max_length=255, unique=True)),
                ('fcc_reference', models.CharField(blank=True, max_length=200, null=True)),
                ('order', models.IntegerField()),
                ('dl_reliability', models.FloatField()),
                ('ul_reliability', models.FloatField()),
                ('outage', models.FloatField()),
                ('mcs_up', models.IntegerField(default=0)),
                ('mcs_down', models.IntegerField(default=0)),
                ('predicted_rx_power_a', models.IntegerField()),
                ('predicted_rx_power_z', models.IntegerField()),
                ('power_control', models.CharField(blank=True, max_length=50, null=True)),
                ('description', models.CharField(blank=True, max_length=200, null=True)),
                ('ssid', models.CharField(blank=True, max_length=200, null=True)),
                ('rssi_threshold_a_upper', models.FloatField(blank=True, max_length=200, null=True)),
                ('rssi_threshold_a_lower', models.FloatField(blank=True, max_length=200, null=True)),
                ('rssi_threshold_z_upper', models.FloatField(blank=True, max_length=200, null=True)),
                ('rssi_threshold_z_lower', models.FloatField(blank=True, max_length=200, null=True)),
                ('circuit', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='circuit_attributes', to='circuits.circuit')),
                ('fcc_status', nautobot.extras.models.statuses.StatusField(null=True, on_delete=django.db.models.deletion.PROTECT, related_name='nautobot_plugin_w_rrm_circuitattributes_related', to='extras.status')),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
            ],
            options={
                'verbose_name': 'Circuit Attributes',
                'verbose_name_plural': 'Circuit Attributes',
                'ordering': ['order'],
            },
            bases=(models.Model, nautobot.extras.models.mixins.DynamicGroupMixin, nautobot.extras.models.mixins.NotesMixin),
        ),
        migrations.CreateModel(
            name='LocationAttributes',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True)),
                ('created', models.DateField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('_custom_field_data', models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder)),
                ('human_id', models.CharField(editable=False, max_length=255, unique=True)),
                ('object_id', models.UUIDField()),
                ('ground_height', models.IntegerField(default=0, validators=[django.core.validators.MinValueValidator(0)])),
                ('roof_height', models.IntegerField(default=0, validators=[django.core.validators.MinValueValidator(0)])),
                ('building_height', models.PositiveIntegerField(default=0, editable=False, validators=[django.core.validators.MinValueValidator(0)])),
                ('latitude', models.DecimalField(decimal_places=6, max_digits=9, validators=[django.core.validators.MaxValueValidator(90), django.core.validators.MinValueValidator(-90)])),
                ('longitude', models.DecimalField(decimal_places=6, max_digits=9, validators=[django.core.validators.MaxValueValidator(180), django.core.validators.MinValueValidator(-180)])),
                ('content_type', models.ForeignKey(limit_choices_to=models.Q(('app_label', 'dcim'), ('model__in', ('location', 'site'))), on_delete=django.db.models.deletion.PROTECT, related_name='+', related_query_name='+', to='contenttypes.contenttype')),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
            ],
            options={
                'verbose_name': 'Location Attributes',
                'verbose_name_plural': 'Location Attributes',
                'unique_together': {('content_type', 'object_id')},
            },
            bases=(models.Model, nautobot.extras.models.mixins.DynamicGroupMixin, nautobot.extras.models.mixins.NotesMixin),
        ),
    ]
