import json
import random
from pkg_resources import resource_filename
from os import path
cwd = path.dirname(__file__)
package_name = "synchronicity"

try:
    from .. import utils
except:
    from synchron import utils

def get_random_quote():
    return random.choice(quotes_list)

def create_random_tweet():
    quote = get_random_quote()
    tweet = """{} - {}""".format(quote['quoteText'], quote['quoteAuthor'])
    return tweet

def create_post():
    post = {}
    quote = get_random_quote()
    tweet = """{} - {}""".format(quote['quoteText'], quote['quoteAuthor'])
    post['tweet']=tweet
    post['title'] = "Quote for {}".format(utils.datestamp())
    post['description'] = quote['quoteText']
    post['author'] = quote['quoteAuthor']
    post['url'] = ""
    post['img'] = ""
    post['tags'] = "#quotes" 
    return post

def test():
    print("Test quotes.")

def get_update():
    return {'tweet':create_random_tweet()}

def get_multiple(count=1):
    res = []
    for i in range(count):
        res.append(get_update())
    return res

def get_posts(count=1):
    res = []
    for i in range(count):
        res.append(create_post())
    return res
       
    
if(__name__ == "__main__"):
    print("Running in: "+cwd)
    print(get_update())



quotes_list = [{
"quoteText": "Genius is one percent inspiration and ninety-nine percent perspiration.",
"quoteAuthor": "Thomas Edison"
}, {
"quoteText": "You can observe a lot just by watching.",
"quoteAuthor": "Yogi Berra"
}, {
"quoteText": "A house divided against itself cannot stand.",
"quoteAuthor": "Abraham Lincoln"
}, {
"quoteText": "Difficulties increase the nearer we get to the goal.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "Fate is in your hands and no one elses",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Be the chief but never the lord.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Nothing happens unless first we dream.",
"quoteAuthor": "Carl Sandburg"
}, {
"quoteText": "Well begun is half done.",
"quoteAuthor": "Aristotle"
}, {
"quoteText": "Life is a learning experience, only if you learn.",
"quoteAuthor": "Yogi Berra"
}, {
"quoteText": "Self-complacency is fatal to progress.",
"quoteAuthor": "Margaret Sangster"
}, {
"quoteText": "Peace comes from within. Do not seek it without.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "What you give is what you get.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "We can only learn to love by loving.",
"quoteAuthor": "Iris Murdoch"
}, {
"quoteText": "Life is change. Growth is optional. Choose wisely.",
"quoteAuthor": "Karen Clark"
}, {
"quoteText": "You'll see it when you believe it.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Today is the tomorrow we worried about yesterday.",
"quoteAuthor": ""
}, {
"quoteText": "It's easier to see the mistakes on someone else's paper.",
"quoteAuthor": ""
}, {
"quoteText": "Every man dies. Not every man really lives.",
"quoteAuthor": ""
}, {
"quoteText": "To lead people walk behind them.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Having nothing, nothing can he lose.",
"quoteAuthor": "William Shakespeare"
}, {
"quoteText": "Trouble is only opportunity in work clothes.",
"quoteAuthor": "Henry J. Kaiser"
}, {
"quoteText": "A rolling stone gathers no moss.",
"quoteAuthor": "Publilius Syrus"
}, {
"quoteText": "Ideas are the beginning points of all fortunes.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Everything in life is luck.",
"quoteAuthor": "Donald Trump"
}, {
"quoteText": "Doing nothing is better than being busy doing nothing.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Trust yourself. You know more than you think you do.",
"quoteAuthor": "Benjamin Spock"
}, {
"quoteText": "Study the past, if you would divine the future.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "The day is already blessed, find peace within it.",
"quoteAuthor": ""
}, {
"quoteText": "From error to error one discovers the entire truth.",
"quoteAuthor": "Sigmund Freud"
}, {
"quoteText": "Well done is better than well said.",
"quoteAuthor": "Benjamin Franklin"
}, {
"quoteText": "Bite off more than you can chew, then chew it.",
"quoteAuthor": "Ella Williams"
}, {
"quoteText": "Work out your own salvation. Do not depend on others.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "One today is worth two tomorrows.",
"quoteAuthor": "Benjamin Franklin"
}, {
"quoteText": "Once you choose hope, anythings possible.",
"quoteAuthor": "Christopher Reeve"
}, {
"quoteText": "God always takes the simplest way.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "One fails forward toward success.",
"quoteAuthor": "Charles Kettering"
}, {
"quoteText": "From small beginnings come great things.",
"quoteAuthor": ""
}, {
"quoteText": "Learning is a treasure that will follow its owner everywhere",
"quoteAuthor": "Chinese proverb"
}, {
"quoteText": "Be as you wish to seem.",
"quoteAuthor": "Socrates"
}, {
"quoteText": "The world is always in movement.",
"quoteAuthor": "V. Naipaul"
}, {
"quoteText": "Never mistake activity for achievement.",
"quoteAuthor": "John Wooden"
}, {
"quoteText": "What worries you masters you.",
"quoteAuthor": "Haddon Robinson"
}, {
"quoteText": "One faces the future with ones past.",
"quoteAuthor": "Pearl Buck"
}, {
"quoteText": "Goals are the fuel in the furnace of achievement.",
"quoteAuthor": "Brian Tracy"
}, {
"quoteText": "Who sows virtue reaps honour.",
"quoteAuthor": "Leonardo da Vinci"
}, {
"quoteText": "Be kind whenever possible. It is always possible.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Talk doesn't cook rice.",
"quoteAuthor": "Chinese proverb"
}, {
"quoteText": "He is able who thinks he is able.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Be as you wish to seem.",
"quoteAuthor": "Socrates"
}, {
"quoteText": "A goal without a plan is just a wish.",
"quoteAuthor": "Larry Elder"
}, {
"quoteText": "To succeed, we must first believe that we can.",
"quoteAuthor": "Michael Korda"
}, {
"quoteText": "Learn from yesterday, live for today, hope for tomorrow.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "A weed is no more than a flower in disguise.",
"quoteAuthor": "James Lowell"
}, {
"quoteText": "Do, or do not. There is no try.",
"quoteAuthor": "Yoda"
}, {
"quoteText": "All serious daring starts from within.",
"quoteAuthor": "Harriet Beecher Stowe"
}, {
"quoteText": "The best teacher is experience learned from failures.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Think how hard physics would be if particles could think.",
"quoteAuthor": "Murray Gell-Mann"
}, {
"quoteText": "Love is the flower you've got to let grow.",
"quoteAuthor": "John Lennon"
}, {
"quoteText": "Don't wait. The time will never be just right.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "One fails forward toward success.",
"quoteAuthor": "Charles Kettering"
}, {
"quoteText": "Time is the wisest counsellor of all.",
"quoteAuthor": "Pericles"
}, {
"quoteText": "You give before you get.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Wisdom begins in wonder.",
"quoteAuthor": "Socrates"
}, {
"quoteText": "Without courage, wisdom bears no fruit.",
"quoteAuthor": "Baltasar Gracian"
}, {
"quoteText": "Change in all things is sweet.",
"quoteAuthor": "Aristotle"
}, {
"quoteText": "What you fear is that which requires action to overcome.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "The best teacher is experience learned from failures.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "When performance exceeds ambition, the overlap is called success.",
"quoteAuthor": "Cullen Hightower"
}, {
"quoteText": "When deeds speak, words are nothing.",
"quoteAuthor": "African proverb"
}, {
"quoteText": "Real magic in relationships means an absence of judgement of others.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "When performance exceeds ambition, the overlap is called success.",
"quoteAuthor": "Cullen Hightower"
}, {
"quoteText": "I never think of the future. It comes soon enough.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "Skill to do comes of doing.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Wisdom is the supreme part of happiness.",
"quoteAuthor": "Sophocles"
}, {
"quoteText": "I believe that every person is born with talent.",
"quoteAuthor": "Maya Angelou"
}, {
"quoteText": "Important principles may, and must, be inflexible.",
"quoteAuthor": "Abraham Lincoln"
}, {
"quoteText": "The undertaking of a new action brings new strength.",
"quoteAuthor": "Richard Evans"
}, {
"quoteText": "I believe that every person is born with talent.",
"quoteAuthor": "Maya Angelou"
}, {
"quoteText": "The years teach much which the days never know.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Our distrust is very expensive.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "All know the way; few actually walk it.",
"quoteAuthor": "Bodhidharma"
}, {
"quoteText": "Great talent finds happiness in execution.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "Faith in oneself is the best and safest course.",
"quoteAuthor": "Michelangelo"
}, {
"quoteText": "Courage is going from failure to failure without losing enthusiasm.",
"quoteAuthor": "Winston Churchill"
}, {
"quoteText": "The two most powerful warriors are patience and time.",
"quoteAuthor": "Leo Tolstoy"
}, {
"quoteText": "Anticipate the difficult by managing the easy.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Those who are free of resentful thoughts surely find peace.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Talk doesn't cook rice.",
"quoteAuthor": "Chinese proverb"
}, {
"quoteText": "A short saying often contains much wisdom.",
"quoteAuthor": "Sophocles"
}, {
"quoteText": "The day is already blessed, find peace within it.",
"quoteAuthor": ""
}, {
"quoteText": "It takes both sunshine and rain to make a rainbow.",
"quoteAuthor": ""
}, {
"quoteText": "A beautiful thing is never perfect.",
"quoteAuthor": ""
}, {
"quoteText": "Only do what your heart tells you.",
"quoteAuthor": "Princess Diana"
}, {
"quoteText": "Life is movement-we breathe, we eat, we walk, we move!",
"quoteAuthor": "John Pierrakos"
}, {
"quoteText": "No one can make you feel inferior without your consent.",
"quoteAuthor": "Eleanor Roosevelt"
}, {
"quoteText": "One fails forward toward success.",
"quoteAuthor": "Charles Kettering"
}, {
"quoteText": "Argue for your limitations, and sure enough theyre yours.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "Luck is what happens when preparation meets opportunity.",
"quoteAuthor": "Seneca"
}, {
"quoteText": "Victory belongs to the most persevering.",
"quoteAuthor": "Napoleon Bonaparte"
}, {
"quoteText": "Once you choose hope, anythings possible.",
"quoteAuthor": "Christopher Reeve"
}, {
"quoteText": "Love all, trust a few, do wrong to none.",
"quoteAuthor": "William Shakespeare"
}, {
"quoteText": "In order to win, you must expect to win.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "A goal is a dream with a deadline.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "You can do it if you believe you can!",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Set your goals high, and don't stop till you get there.",
"quoteAuthor": "Bo Jackson"
}, {
"quoteText": "Genius is one percent inspiration and ninety-nine percent perspiration.",
"quoteAuthor": "Thomas Edison"
}, {
"quoteText": "Every new day is another chance to change your life.",
"quoteAuthor": ""
}, {
"quoteText": "Smile, breathe, and go slowly.",
"quoteAuthor": "Thich Nhat Hanh"
}, {
"quoteText": "Nobody will believe in you unless you believe in yourself.",
"quoteAuthor": "Liberace"
}, {
"quoteText": "Be kind whenever possible. It is always possible.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Do more than dream: work.",
"quoteAuthor": "William Arthur Ward"
}, {
"quoteText": "No man was ever wise by chance.",
"quoteAuthor": "Seneca"
}, {
"quoteText": "Some pursue happiness, others create it.",
"quoteAuthor": ""
}, {
"quoteText": "It's easier to see the mistakes on someone else's paper.",
"quoteAuthor": ""
}, {
"quoteText": "Think how hard physics would be if particles could think.",
"quoteAuthor": "Murray Gell-Mann"
}, {
"quoteText": "Well begun is half done.",
"quoteAuthor": "Aristotle"
}, {
"quoteText": "He that is giddy thinks the world turns round.",
"quoteAuthor": "William Shakespeare"
}, {
"quoteText": "Don't ruin the present with the ruined past.",
"quoteAuthor": "Ellen Gilchrist"
}, {
"quoteText": "Do something wonderful, people may imitate it.",
"quoteAuthor": "Albert Schweitzer"
}, {
"quoteText": "We do what we do because we believe.",
"quoteAuthor": ""
}, {
"quoteText": "Great talent finds happiness in execution.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "Do one thing every day that scares you.",
"quoteAuthor": "Eleanor Roosevelt"
}, {
"quoteText": "If you cannot be silent be brilliant and thoughtful.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Smile, breathe, and go slowly.",
"quoteAuthor": "Thich Nhat Hanh"
}, {
"quoteText": "Who looks outside, dreams; who looks inside, awakes.",
"quoteAuthor": "Carl Jung"
}, {
"quoteText": "What we think, we become.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "The shortest answer is doing.",
"quoteAuthor": "Lord Herbert"
}, {
"quoteText": "All our knowledge has its origins in our perceptions.",
"quoteAuthor": "Leonardo da Vinci"
}, {
"quoteText": "He is able who thinks he is able.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "The harder you fall, the higher you bounce.",
"quoteAuthor": ""
}, {
"quoteText": "Trusting our intuition often saves us from disaster.",
"quoteAuthor": "Anne Wilson Schaef"
}, {
"quoteText": "Truth is powerful and it prevails.",
"quoteAuthor": "Sojourner Truth"
}, {
"quoteText": "Talk doesn't cook rice.",
"quoteAuthor": "Chinese proverb"
}, {
"quoteText": "Light tomorrow with today!",
"quoteAuthor": "Elizabeth Browning"
}, {
"quoteText": "Silence is a fence around wisdom.",
"quoteAuthor": "German proverb"
}, {
"quoteText": "Society develops wit, but its contemplation alone forms genius.",
"quoteAuthor": "Madame de Stael"
}, {
"quoteText": "Real magic in relationships means an absence of judgement of others.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "The years teach much which the days never know.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "We can only learn to love by loving.",
"quoteAuthor": "Iris Murdoch"
}, {
"quoteText": "The simplest things are often the truest.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "What you give is what you get.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Everyone smiles in the same language.",
"quoteAuthor": ""
}, {
"quoteText": "A short saying often contains much wisdom.",
"quoteAuthor": "Sophocles"
}, {
"quoteText": "Yesterday I dared to struggle. Today I dare to win.",
"quoteAuthor": "Bernadette Devlin"
}, {
"quoteText": "Victory belongs to the most persevering.",
"quoteAuthor": "Napoleon Bonaparte"
}, {
"quoteText": "No alibi will save you from accepting the responsibility.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "If you can dream it, you can do it.",
"quoteAuthor": "Walt Disney"
}, {
"quoteText": "From error to error one discovers the entire truth.",
"quoteAuthor": "Sigmund Freud"
}, {
"quoteText": "It is better to travel well than to arrive.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Life shrinks or expands in proportion to one's courage.",
"quoteAuthor": "Anais Nin"
}, {
"quoteText": "You have to believe in yourself.",
"quoteAuthor": "Sun Tzu"
}, {
"quoteText": "Our intention creates our reality.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Silence is a true friend who never betrays.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Character develops itself in the stream of life.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "From little acorns mighty oaks do grow.",
"quoteAuthor": "American proverb"
}, {
"quoteText": "You have to believe in yourself.",
"quoteAuthor": "Sun Tzu"
}, {
"quoteText": "You can't stop the waves, but you can learn to surf.",
"quoteAuthor": "Jon Kabat-Zinn"
}, {
"quoteText": "Reality does not conform to the ideal, but confirms it.",
"quoteAuthor": "Gustave Flaubert"
}, {
"quoteText": "Speak low, if you speak love.",
"quoteAuthor": "William Shakespeare"
}, {
"quoteText": "A really great talent finds its happiness in execution.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "Reality leaves a lot to the imagination.",
"quoteAuthor": "John Lennon"
}, {
"quoteText": "Our intention creates our reality.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Society develops wit, but its contemplation alone forms genius.",
"quoteAuthor": "Madame de Stael"
}, {
"quoteText": "The greatest remedy for anger is delay.",
"quoteAuthor": "Seneca"
}, {
"quoteText": "Growth itself contains the germ of happiness.",
"quoteAuthor": "Pearl Buck"
}, {
"quoteText": "You can do what's reasonable or you can decide what's possible.",
"quoteAuthor": ""
}, {
"quoteText": "Nothing strengthens authority so much as silence.",
"quoteAuthor": "Leonardo da Vinci"
}, {
"quoteText": "Wherever you go, go with all your heart.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "The only real valuable thing is intuition.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "I believe that every person is born with talent.",
"quoteAuthor": "Maya Angelou"
}, {
"quoteText": "Good luck is another name for tenacity of purpose.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Rainbows apologize for angry skies.",
"quoteAuthor": "Sylvia Voirol"
}, {
"quoteText": "Friendship isn't a big thing. It's a million little things.",
"quoteAuthor": ""
}, {
"quoteText": "Time is the most valuable thing a man can spend.",
"quoteAuthor": "Theophrastus"
}, {
"quoteText": "Whatever happens, take responsibility.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "Experience is simply the name we give our mistakes.",
"quoteAuthor": "Oscar Wilde"
}, {
"quoteText": "I think and that is all that I am.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "A good plan today is better than a perfect plan tomorrow.",
"quoteAuthor": ""
}, {
"quoteText": "Be as you wish to seem.",
"quoteAuthor": "Socrates"
}, {
"quoteText": "If the shoe doesn't fit, must we change the foot?",
"quoteAuthor": "Gloria Steinem"
}, {
"quoteText": "Each day provides its own gifts.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "While we stop to think, we often miss our opportunity.",
"quoteAuthor": "Publilius Syrus"
}, {
"quoteText": "Life isn't about finding yourself. Life is about creating yourself.",
"quoteAuthor": "Bernard Shaw"
}, {
"quoteText": "To bring anything into your life, imagine that it's already there.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "Begin to weave and God will give you the thread.",
"quoteAuthor": "German proverb"
}, {
"quoteText": "The more you know yourself, the more you forgive yourself.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Someone remembers, someone cares; your name is whispered in someone's prayers.",
"quoteAuthor": ""
}, {
"quoteText": "Without faith, nothing is possible. With it, nothing is impossible.",
"quoteAuthor": "Mary Bethune"
}, {
"quoteText": "What worries you masters you.",
"quoteAuthor": "Haddon Robinson"
}, {
"quoteText": "Once we accept our limits, we go beyond them.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "Don't be pushed by your problems; be led by your dreams.",
"quoteAuthor": ""
}, {
"quoteText": "Whatever we expect with confidence becomes our own self-fulfilling prophecy.",
"quoteAuthor": "Brian Tracy"
}, {
"quoteText": "Everything you can imagine is real.",
"quoteAuthor": "Pablo Picasso"
}, {
"quoteText": "The shortest answer is doing.",
"quoteAuthor": "Lord Herbert"
}, {
"quoteText": "A beautiful thing is never perfect.",
"quoteAuthor": ""
}, {
"quoteText": "Fear is a darkroom where negatives develop.",
"quoteAuthor": "Usman Asif"
}, {
"quoteText": "The simplest things are often the truest.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "The truest wisdom is a resolute determination.",
"quoteAuthor": "Napoleon Bonaparte"
}, {
"quoteText": "Life is the flower for which love is the honey.",
"quoteAuthor": "Victor Hugo"
}, {
"quoteText": "Freedom is the right to live as we wish.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "Change your thoughts, change your life!",
"quoteAuthor": ""
}, {
"quoteText": "Never ignore a gut feeling, but never believe that it's enough.",
"quoteAuthor": "Robert Heller"
}, {
"quoteText": "Loss is nothing else but change,and change is Natures delight.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "Someone is special only if you tell them.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Great talent finds happiness in execution.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "Today is the tomorrow you worried about yesterday.",
"quoteAuthor": ""
}, {
"quoteText": "There is no way to happiness, happiness is the way.",
"quoteAuthor": "Thich Nhat Hanh"
}, {
"quoteText": "The day always looks brighter from behind a smile.",
"quoteAuthor": ""
}, {
"quoteText": "A beautiful thing is never perfect.",
"quoteAuthor": ""
}, {
"quoteText": "No alibi will save you from accepting the responsibility.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Argue for your limitations, and sure enough theyre yours.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "You can observe a lot just by watching.",
"quoteAuthor": "Yogi Berra"
}, {
"quoteText": "Reality leaves a lot to the imagination.",
"quoteAuthor": "John Lennon"
}, {
"quoteText": "A stumble may prevent a fall.",
"quoteAuthor": ""
}, {
"quoteText": "He who talks more is sooner exhausted.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Well begun is half done.",
"quoteAuthor": "Aristotle"
}, {
"quoteText": "He who is contented is rich.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Work out your own salvation. Do not depend on others.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "You can do it if you believe you can!",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "What we achieve inwardly will change outer reality.",
"quoteAuthor": "Plutarch"
}, {
"quoteText": "Our strength grows out of our weaknesses.",
"quoteAuthor": "Ralph Waldo Emerson"
}, {
"quoteText": "We must become the change we want to see.",
"quoteAuthor": "Mahatma Gandhi"
}, {
"quoteText": "Happiness is found in doing, not merely possessing.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Put your future in good hands � your own.",
"quoteAuthor": ""
}, {
"quoteText": "We choose our destiny in the way we treat others.",
"quoteAuthor": "Wit"
}, {
"quoteText": "Time is the most valuable thing a man can spend.",
"quoteAuthor": "Theophrastus"
}, {
"quoteText": "No snowflake in an avalanche ever feels responsible.",
"quoteAuthor": "Voltaire"
}, {
"quoteText": "Smile, breathe, and go slowly.",
"quoteAuthor": "Thich Nhat Hanh"
}, {
"quoteText": "Fortune favours the brave.",
"quoteAuthor": "Virgil"
}, {
"quoteText": "I believe in one thing only, the power of human will.",
"quoteAuthor": "Joseph Stalin"
}, {
"quoteText": "The more you know yourself, the more you forgive yourself.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "The best way out is always through.",
"quoteAuthor": "Robert Frost"
}, {
"quoteText": "The mind unlearns with difficulty what it has long learned.",
"quoteAuthor": "Seneca"
}, {
"quoteText": "I destroy my enemies when I make them my friends.",
"quoteAuthor": "Abraham Lincoln"
}, {
"quoteText": "No garden is without its weeds.",
"quoteAuthor": "Thomas Fuller"
}, {
"quoteText": "There is no failure except in no longer trying.",
"quoteAuthor": "Elbert Hubbard"
}, {
"quoteText": "Kind words will unlock an iron door.",
"quoteAuthor": "Turkish proverb"
}, {
"quoteText": "Problems are only opportunities with thorns on them.",
"quoteAuthor": "Hugh Miller"
}, {
"quoteText": "Life is just a chance to grow a soul.",
"quoteAuthor": "A. Powell Davies"
}, {
"quoteText": "Reality does not conform to the ideal, but confirms it.",
"quoteAuthor": "Gustave Flaubert"
}, {
"quoteText": "If you can dream it, you can do it.",
"quoteAuthor": "Walt Disney"
}, {
"quoteText": "Mountains cannot be surmounted except by winding paths.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "May our hearts garden of awakening bloom with hundreds of flowers.",
"quoteAuthor": "Thich Nhat Hanh"
}, {
"quoteText": "Nobody will believe in you unless you believe in yourself.",
"quoteAuthor": "Liberace"
}, {
"quoteText": "Fortune befriends the bold.",
"quoteAuthor": "John Dryden"
}, {
"quoteText": "Keep true to the dreams of thy youth.",
"quoteAuthor": "Friedrich von Schiller"
}, {
"quoteText": "You're never a loser until you quit trying.",
"quoteAuthor": "Mike Ditka"
}, {
"quoteText": "Science is organized knowledge. Wisdom is organized life.",
"quoteAuthor": "Immanuel Kant"
}, {
"quoteText": "Knowing is not enough; we must apply!",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "Strong beliefs win strong men, and then make them stronger.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "Autumn is a second spring when every leaf is a flower.",
"quoteAuthor": "Albert Camus"
}, {
"quoteText": "If you surrender to the wind, you can ride it.",
"quoteAuthor": "Toni Morrison"
}, {
"quoteText": "Character develops itself in the stream of life.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "We must become the change we want to see.",
"quoteAuthor": "Mahatma Gandhi"
}, {
"quoteText": "Keep yourself to the sunshine and you cannot see the shadow.",
"quoteAuthor": "Helen Keller"
}, {
"quoteText": "Write your plans in pencil and give God the eraser.",
"quoteAuthor": "Paulo Coelho"
}, {
"quoteText": "Inspiration exists, but it has to find us working.",
"quoteAuthor": "Pablo Picasso"
}, {
"quoteText": "All serious daring starts from within.",
"quoteAuthor": "Harriet Beecher Stowe"
}, {
"quoteText": "Pick battles big enough to matter, small enough to win.",
"quoteAuthor": "Jonathan Kozol"
}, {
"quoteText": "Don't compromise yourself. You are all you've got.",
"quoteAuthor": "Janis Joplin"
}, {
"quoteText": "He that is giddy thinks the world turns round.",
"quoteAuthor": "William Shakespeare"
}, {
"quoteText": "A short saying oft contains much wisdom.",
"quoteAuthor": "Sophocles"
}, {
"quoteText": "Difficulties are things that show a person what they are.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "When you doubt your power, you give power to your doubt.",
"quoteAuthor": "Honore de Balzac"
}, {
"quoteText": "The cause is hidden. The effect is visible to all.",
"quoteAuthor": "Ovid"
}, {
"quoteText": "A weed is no more than a flower in disguise.",
"quoteAuthor": "James Lowell"
}, {
"quoteText": "Keep true to the dreams of thy youth.",
"quoteAuthor": "Friedrich von Schiller"
}, {
"quoteText": "A prudent question is one half of wisdom.",
"quoteAuthor": "Francis Bacon"
}, {
"quoteText": "The path to success is to take massive, determined action.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "I allow my intuition to lead my path.",
"quoteAuthor": "Manuel Puig"
}, {
"quoteText": "Nature takes away any faculty that is not used.",
"quoteAuthor": "William R. Inge"
}, {
"quoteText": "All our knowledge has its origins in our perceptions.",
"quoteAuthor": "Leonardo da Vinci"
}, {
"quoteText": "If the shoe doesn't fit, must we change the foot?",
"quoteAuthor": "Gloria Steinem"
}, {
"quoteText": "Life shrinks or expands in proportion to one's courage.",
"quoteAuthor": "Anais Nin"
}, {
"quoteText": "May our hearts garden of awakening bloom with hundreds of flowers.",
"quoteAuthor": "Thich Nhat Hanh"
}, {
"quoteText": "If you wish to be a writer, write.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "Today is the tomorrow we worried about yesterday.",
"quoteAuthor": ""
}, {
"quoteText": "There is no way to prosperity, prosperity is the way.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Talk doesn't cook rice.",
"quoteAuthor": "Chinese proverb"
}, {
"quoteText": "Wherever you go, go with all your heart.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Either you run the day or the day runs you.",
"quoteAuthor": "Jim Rohn"
}, {
"quoteText": "Write your plans in pencil and give God the eraser.",
"quoteAuthor": "Paulo Coelho"
}, {
"quoteText": "Better be ignorant of a matter than half know it.",
"quoteAuthor": "Publilius Syrus"
}, {
"quoteText": "Follow your instincts. That is where true wisdom manifests itself.",
"quoteAuthor": "Oprah Winfrey"
}, {
"quoteText": "There never was a good knife made of bad steel.",
"quoteAuthor": "Benjamin Franklin"
}, {
"quoteText": "To accomplish great things, we must dream as well as act.",
"quoteAuthor": "Anatole France"
}, {
"quoteText": "Patience is the companion of wisdom.",
"quoteAuthor": "Saint Augustine"
}, {
"quoteText": "The mind is everything. What you think you become.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "To enjoy life, we must touch much of it lightly.",
"quoteAuthor": "Voltaire"
}, {
"quoteText": "To fly, we have to have resistance.",
"quoteAuthor": "Maya Lin"
}, {
"quoteText": "The more you know yourself, the more you forgive yourself.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "What you see depends on what you're looking for.",
"quoteAuthor": ""
}, {
"quoteText": "The heart has its reasons which reason knows not of.",
"quoteAuthor": "Blaise Pascal"
}, {
"quoteText": "When you doubt your power, you give power to your doubt.",
"quoteAuthor": "Honore de Balzac"
}, {
"quoteText": "Be great in act, as you have been in thought.",
"quoteAuthor": "William Shakespeare"
}, {
"quoteText": "Imagination rules the world.",
"quoteAuthor": "Napoleon Bonaparte"
}, {
"quoteText": "Kind words do not cost much. Yet they accomplish much.",
"quoteAuthor": "Blaise Pascal"
}, {
"quoteText": "Wherever you go, go with all your heart.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "In order to win, you must expect to win.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "You're never a loser until you quit trying.",
"quoteAuthor": "Mike Ditka"
}, {
"quoteText": "There is no greater harm than that of time wasted.",
"quoteAuthor": "Michelangelo"
}, {
"quoteText": "Intuition will tell the thinking mind where to look next.",
"quoteAuthor": "Jonas Salk"
}, {
"quoteText": "Nature takes away any faculty that is not used.",
"quoteAuthor": "William R. Inge"
}, {
"quoteText": "Doing nothing is better than being busy doing nothing.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "It is better to travel well than to arrive.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Once you choose hope, anythings possible.",
"quoteAuthor": "Christopher Reeve"
}, {
"quoteText": "Worry gives a small thing a big shadow.",
"quoteAuthor": ""
}, {
"quoteText": "Do, or do not. There is no try.",
"quoteAuthor": "Yoda"
}, {
"quoteText": "Fears are nothing more than a state of mind.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Mountains cannot be surmounted except by winding paths.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "May our hearts garden of awakening bloom with hundreds of flowers.",
"quoteAuthor": "Thich Nhat Hanh"
}, {
"quoteText": "The journey of a thousand miles begins with one step.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Don't be pushed by your problems; be led by your dreams.",
"quoteAuthor": ""
}, {
"quoteText": "Efficiency is doing things right; effectiveness is doing the right things.",
"quoteAuthor": "Peter Drucker"
}, {
"quoteText": "The greatest remedy for anger is delay.",
"quoteAuthor": "Seneca"
}, {
"quoteText": "Worry gives a small thing a big shadow.",
"quoteAuthor": ""
}, {
"quoteText": "Blaze with the fire that is never extinguished.",
"quoteAuthor": "Luisa Sigea"
}, {
"quoteText": "Don't cry because it's over. Smile because it happened.",
"quoteAuthor": "Dr. Seuss"
}, {
"quoteText": "Time is the wisest counsellor of all.",
"quoteAuthor": "Pericles"
}, {
"quoteText": "No is easier to do. Yes is easier to say.",
"quoteAuthor": "Jason Fried"
}, {
"quoteText": "From little acorns mighty oaks do grow.",
"quoteAuthor": "American proverb"
}, {
"quoteText": "To be wrong is nothing unless you continue to remember it.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Write your plans in pencil and give God the eraser.",
"quoteAuthor": "Paulo Coelho"
}, {
"quoteText": "Once we accept our limits, we go beyond them.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "He who talks more is sooner exhausted.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "I never think of the future. It comes soon enough.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "Whatever happens, take responsibility.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "Yesterdays home runs don't win today's games.",
"quoteAuthor": "Babe Ruth"
}, {
"quoteText": "The world is always in movement.",
"quoteAuthor": "V. Naipaul"
}, {
"quoteText": "Inspiration exists, but it has to find us working.",
"quoteAuthor": "Pablo Picasso"
}, {
"quoteText": "Silence is deep as Eternity, Speech is shallow as Time.",
"quoteAuthor": "Carlyle"
}, {
"quoteText": "Don't smother each other. No one can grow in the shade.",
"quoteAuthor": "Leo F. Buscaglia"
}, {
"quoteText": "We must become the change we want to see.",
"quoteAuthor": "Mahatma Gandhi"
}, {
"quoteText": "An ant on the move does more than a dozing ox",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "You can't shake hands with a clenched fist.",
"quoteAuthor": "Indira Gandhi"
}, {
"quoteText": "A good decision is based on knowledge and not on numbers.",
"quoteAuthor": "Plato"
}, {
"quoteText": "Once we accept our limits, we go beyond them.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "The cautious seldom err.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Ideas are the beginning points of all fortunes.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Every man dies. Not every man really lives.",
"quoteAuthor": ""
}, {
"quoteText": "If there is no struggle, there is no progress.",
"quoteAuthor": "Frederick Douglass"
}, {
"quoteText": "There is no way to prosperity, prosperity is the way.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Where there is great love, there are always miracles.",
"quoteAuthor": "Willa Cather"
}, {
"quoteText": "Trusting our intuition often saves us from disaster.",
"quoteAuthor": "Anne Wilson Schaef"
}, {
"quoteText": "Friendship isn't a big thing. It's a million little things.",
"quoteAuthor": ""
}, {
"quoteText": "Goals are the fuel in the furnace of achievement.",
"quoteAuthor": "Brian Tracy"
}, {
"quoteText": "Each day provides its own gifts.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "Time you enjoy wasting, was not wasted.",
"quoteAuthor": "John Lennon"
}, {
"quoteText": "Every problem has a gift for you in its hands.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "Sadness flies away on the wings of time.",
"quoteAuthor": "Jean de la Fontaine"
}, {
"quoteText": "The only real valuable thing is intuition.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "Fortune befriends the bold.",
"quoteAuthor": "John Dryden"
}, {
"quoteText": "I have often regretted my speech, never my silence.",
"quoteAuthor": "Publilius Syrus"
}, {
"quoteText": "May our hearts garden of awakening bloom with hundreds of flowers.",
"quoteAuthor": "Thich Nhat Hanh"
}, {
"quoteText": "I destroy my enemies when I make them my friends.",
"quoteAuthor": "Abraham Lincoln"
}, {
"quoteText": "Sadness flies away on the wings of time.",
"quoteAuthor": "Jean de la Fontaine"
}, {
"quoteText": "Never put off till tomorrow what you can do today.",
"quoteAuthor": "Thomas Jefferson"
}, {
"quoteText": "Minds are like parachutes. They only function when open.",
"quoteAuthor": "Thomas Dewar"
}, {
"quoteText": "If a man does his best, what else is there?",
"quoteAuthor": "George Patton"
}, {
"quoteText": "The secret of success is constancy to purpose.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "Imagination rules the world.",
"quoteAuthor": "Napoleon Bonaparte"
}, {
"quoteText": "Well begun is half done.",
"quoteAuthor": "Aristotle"
}, {
"quoteText": "The best way out is always through.",
"quoteAuthor": "Robert Frost"
}, {
"quoteText": "Without faith, nothing is possible. With it, nothing is impossible.",
"quoteAuthor": "Mary Bethune"
}, {
"quoteText": "Life is a progress, and not a station.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "All seasons are beautiful for the person who carries happiness within.",
"quoteAuthor": "Horace Friess"
}, {
"quoteText": "To avoid criticism, do nothing, say nothing, be nothing.",
"quoteAuthor": "Elbert Hubbard"
}, {
"quoteText": "Whatever happens, take responsibility.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "All things change; nothing perishes.",
"quoteAuthor": "Ovid"
}, {
"quoteText": "No one can make you feel inferior without your consent.",
"quoteAuthor": "Eleanor Roosevelt"
}, {
"quoteText": "Absence makes the heart grow fonder.",
"quoteAuthor": "Haynes Bayly"
}, {
"quoteText": "Imagination is the highest kite one can fly.",
"quoteAuthor": "Lauren Bacall"
}, {
"quoteText": "Don't be pushed by your problems; be led by your dreams.",
"quoteAuthor": ""
}, {
"quoteText": "Nothing happens unless first we dream.",
"quoteAuthor": "Carl Sandburg"
}, {
"quoteText": "Minds are like parachutes. They only function when open.",
"quoteAuthor": "Thomas Dewar"
}, {
"quoteText": "The beginning of knowledge is the discovery of something we do not understand.",
"quoteAuthor": "Frank Herbert"
}, {
"quoteText": "Love doesn't make the world go round, love is what makes the ride worthwhile.",
"quoteAuthor": "Elizabeth Browning"
}, {
"quoteText": "Whenever you have eliminated the impossible, whatever remains, however improbable, must be the truth.",
"quoteAuthor": "Arthur Conan Doyle"
}, {
"quoteText": "Good timber does not grow with ease; the stronger the wind, the stronger the trees.",
"quoteAuthor": "J. Willard Marriott"
}, {
"quoteText": "I believe that we are fundamentally the same and have the same basic potential.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "The winds and waves are always on the side of the ablest navigators.",
"quoteAuthor": "Edward Gibbon"
}, {
"quoteText": "The future belongs to those who believe in the beauty of their dreams.",
"quoteAuthor": "Eleanor Roosevelt"
}, {
"quoteText": "To get something you never had, you have to do something you never did.",
"quoteAuthor": ""
}, {
"quoteText": "Be thankful when you don't know something for it gives you the opportunity to learn.",
"quoteAuthor": ""
}, {
"quoteText": "Strength does not come from physical capacity. It comes from an indomitable will.",
"quoteAuthor": "Mahatma Gandhi"
}, {
"quoteText": "Each misfortune you encounter will carry in it the seed of tomorrows good luck.",
"quoteAuthor": "Og Mandino"
}, {
"quoteText": "The winds and waves are always on the side of the ablest navigators.",
"quoteAuthor": "Edward Gibbon"
}, {
"quoteText": "To forgive is to set a prisoner free and realize that prisoner was you.",
"quoteAuthor": "Lewis B. Smedes"
}, {
"quoteText": "In separateness lies the world's great misery, in compassion lies the world's true strength.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "By believing passionately in something that does not yet exist, we create it.",
"quoteAuthor": "Nikos Kazantzakis"
}, {
"quoteText": "Letting go isn�t the end of the world; it�s the beginning of a new life.",
"quoteAuthor": ""
}, {
"quoteText": "All the great performers I have worked with are fuelled by a personal dream.",
"quoteAuthor": "John Eliot"
}, {
"quoteText": "One of the advantages of being disorderly is that one is constantly making exciting discoveries.",
"quoteAuthor": "A. A. Milne"
}, {
"quoteText": "I never see what has been done; I only see what remains to be done.",
"quoteAuthor": "Marie Curie"
}, {
"quoteText": "Begin at once to live and count each separate day as a separate life.",
"quoteAuthor": "Seneca"
}, {
"quoteText": "If you don't know where you are going, you will probably end up somewhere else.",
"quoteAuthor": "Lawrence Peter"
}, {
"quoteText": "Love doesn't make the world go round, love is what makes the ride worthwhile.",
"quoteAuthor": "Elizabeth Browning"
}, {
"quoteText": "It is not so important to know everything as to appreciate what we learn.",
"quoteAuthor": "Hannah More"
}, {
"quoteText": "The bird of paradise alights only upon the hand that does not grasp.",
"quoteAuthor": "John Berry"
}, {
"quoteText": "Think as a wise man but communicate in the language of the people.",
"quoteAuthor": "William Yeats"
}, {
"quoteText": "Practice yourself, for heavens sake in little things, and then proceed to greater.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "If one does not know to which port is sailing, no wind is favorable.",
"quoteAuthor": "Seneca"
}, {
"quoteText": "Our greatest glory is not in never failing but rising everytime we fall.",
"quoteAuthor": ""
}, {
"quoteText": "Being right is highly overrated. Even a stopped clock is right twice a day.",
"quoteAuthor": ""
}, {
"quoteText": "To be upset over what you don't have is to waste what you do have.",
"quoteAuthor": "Ken S. Keyes"
}, {
"quoteText": "If we did the things we are capable of, we would astound ourselves.",
"quoteAuthor": "Thomas Edison"
}, {
"quoteText": "Nothing in life is to be feared. It is only to be understood.",
"quoteAuthor": "Marie Curie"
}, {
"quoteText": "Successful people ask better questions, and as a result, they get better answers.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "Love is not blind; it simply enables one to see things others fail to see.",
"quoteAuthor": ""
}, {
"quoteText": "Life is a process. We are a process. The universe is a process.",
"quoteAuthor": "Anne Schaef"
}, {
"quoteText": "I think somehow we learn who we really are and then live with that decision.",
"quoteAuthor": "Eleanor Roosevelt"
}, {
"quoteText": "We learn what we have said from those who listen to our speaking.",
"quoteAuthor": "Kenneth Patton"
}, {
"quoteText": "A little knowledge that acts is worth infinitely more than much knowledge that is idle.",
"quoteAuthor": "Kahlil Gibran"
}, {
"quoteText": "If you get up one more time than you fall, you will make it through.",
"quoteAuthor": ""
}, {
"quoteText": "The beginning of knowledge is the discovery of something we do not understand.",
"quoteAuthor": "Frank Herbert"
}, {
"quoteText": "The doors we open and close each day decide the lives we live.",
"quoteAuthor": "Flora Whittemore"
}, {
"quoteText": "The worst bankrupt in the world is the person who has lost his enthusiasm.",
"quoteAuthor": "H. W. Arnold"
}, {
"quoteText": "Happiness comes when your work and words are of benefit to yourself and others.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Each misfortune you encounter will carry in it the seed of tomorrows good luck.",
"quoteAuthor": "Og Mandino"
}, {
"quoteText": "Don't focus on making the right decision, focus on making the decision the right one.",
"quoteAuthor": ""
}, {
"quoteText": "Everything is perfect in the universe � even your desire to improve it.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Begin at once to live and count each separate day as a separate life.",
"quoteAuthor": "Seneca"
}, {
"quoteText": "The universe is full of magical things, patiently waiting for our wits to grow sharper.",
"quoteAuthor": "Eden Phillpotts"
}, {
"quoteText": "Just as a candle cannot burn without fire, men cannot live without a spiritual life.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "A thing long expected takes the form of the unexpected when at last it comes.",
"quoteAuthor": "Mark Twain"
}, {
"quoteText": "To forgive is to set a prisoner free and realize that prisoner was you.",
"quoteAuthor": "Lewis B. Smedes"
}, {
"quoteText": "Action may not always bring happiness; but there is no happiness without action.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "I don't believe in failure. It is not failure if you enjoyed the process.",
"quoteAuthor": "Oprah Winfrey"
}, {
"quoteText": "What you do not want done to yourself, do not do to others.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Short words are best and the old words when short are best of all.",
"quoteAuthor": "Winston Churchill"
}, {
"quoteText": "If you light a lamp for somebody, it will also brighten your path.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "I have done my best: that is about all the philosophy of living one needs.",
"quoteAuthor": "Lin-yutang"
}, {
"quoteText": "Through perseverance many people win success out of what seemed destined to be certain failure.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "Give thanks for the rain of life that propels us to reach new horizons.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Love is just a word until someone comes along and gives it meaning.",
"quoteAuthor": ""
}, {
"quoteText": "We all have problems. The way we solve them is what makes us different.",
"quoteAuthor": ""
}, {
"quoteText": "The secret to a rich life is to have more beginnings than endings.",
"quoteAuthor": "Dave Weinbaum"
}, {
"quoteText": "It is only when the mind and character slumber that the dress can be seen.",
"quoteAuthor": "Ralph Waldo Emerson"
}, {
"quoteText": "If you don't like something, change it. If you can't change it, change your attitude.",
"quoteAuthor": "Maya Angelou"
}, {
"quoteText": "Nothing in life is to be feared. It is only to be understood.",
"quoteAuthor": "Marie Curie"
}, {
"quoteText": "Reviewing what you have learned and learning anew, you are fit to be a teacher.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "The world is a book, and those who do not travel read only a page.",
"quoteAuthor": "Augustinus Sanctus"
}, {
"quoteText": "Action may not always bring happiness; but there is no happiness without action.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "So long as a person is capable of self-renewal they are a living being.",
"quoteAuthor": "Henri-Frederic Amiel"
}, {
"quoteText": "I'm not afraid of storms, for Im learning how to sail my ship.",
"quoteAuthor": "Louisa Alcott"
}, {
"quoteText": "Think for yourselves and let others enjoy the privilege to do so too.",
"quoteAuthor": "Voltaire"
}, {
"quoteText": "How we spend our days is, of course, how we spend our lives.",
"quoteAuthor": "Annie Dillard"
}, {
"quoteText": "It has never been my object to record my dreams, just to realize them.",
"quoteAuthor": "Man Ray"
}, {
"quoteText": "The most complicated achievements of thought are possible without the assistance of consciousness.",
"quoteAuthor": "Sigmund Freud"
}, {
"quoteText": "Be miserable. Or motivate yourself. Whatever has to be done, it's always your choice.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Most great people have attained their greatest success just one step beyond their greatest failure.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "The doors we open and close each day decide the lives we live.",
"quoteAuthor": "Flora Whittemore"
}, {
"quoteText": "If you think you can, you can. And if you think you can't, you're right.",
"quoteAuthor": "Henry Ford"
}, {
"quoteText": "Better to have loved and lost, than to have never loved at all.",
"quoteAuthor": "St. Augustine"
}, {
"quoteText": "Everyone thinks of changing the world, but no one thinks of changing himself.",
"quoteAuthor": "Leo Tolstoy"
}, {
"quoteText": "Whenever you have eliminated the impossible, whatever remains, however improbable, must be the truth.",
"quoteAuthor": "Arthur Conan Doyle"
}, {
"quoteText": "The best way to pay for a lovely moment is to enjoy it.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "You have enemies? Good. That means you've stood up for something, sometime in your life.",
"quoteAuthor": "Winston Churchill"
}, {
"quoteText": "Slow down and everything you are chasing will come around and catch you.",
"quoteAuthor": "John De Paola"
}, {
"quoteText": "Your worst enemy cannot harm you as much as your own unguarded thoughts.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "I always wanted to be somebody, but I should have been more specific.",
"quoteAuthor": "Lily Tomlin"
}, {
"quoteText": "Yeah we all shine on, like the moon, and the stars, and the sun.",
"quoteAuthor": "John Lennon"
}, {
"quoteText": "Knowledge is a process of piling up facts; wisdom lies in their simplification.",
"quoteAuthor": "Martin Fischer"
}, {
"quoteText": "Life is like riding a bicycle. To keep your balance you must keep moving.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "We should all be thankful for those people who rekindle the inner spirit.",
"quoteAuthor": "Albert Schweitzer"
}, {
"quoteText": "In separateness lies the world's great misery, in compassion lies the world's true strength.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Reviewing what you have learned and learning anew, you are fit to be a teacher.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "To get something you never had, you have to do something you never did.",
"quoteAuthor": ""
}, {
"quoteText": "What you do not want done to yourself, do not do to others.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Opportunity is missed by most because it is dressed in overalls and looks like work.",
"quoteAuthor": "Thomas Edison"
}, {
"quoteText": "Feeling and longing are the motive forces behind all human endeavor and human creations.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "In the end we retain from our studies only that which we practically apply.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "It is only when the mind and character slumber that the dress can be seen.",
"quoteAuthor": "Ralph Waldo Emerson"
}, {
"quoteText": "If you correct your mind, the rest of your life will fall into place.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "The world makes way for the man who knows where he is going.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "When your desires are strong enough you will appear to possess superhuman powers to achieve.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Patience and perseverance have a magical effect before which difficulties disappear and obstacles vanish.",
"quoteAuthor": "John Adams"
}, {
"quoteText": "I cannot make my days longer so I strive to make them better.",
"quoteAuthor": "Henry David Thoreau"
}, {
"quoteText": "Think for yourselves and let others enjoy the privilege to do so too.",
"quoteAuthor": "Voltaire"
}, {
"quoteText": "Tension is who you think you should be. Relaxation is who you are.",
"quoteAuthor": "Chinese proverb"
}, {
"quoteText": "Never bend your head. Always hold it high. Look the world right in the eye.",
"quoteAuthor": "Helen Keller"
}, {
"quoteText": "One who gains strength by overcoming obstacles possesses the only strength which can overcome adversity.",
"quoteAuthor": "Albert Schweitzer"
}, {
"quoteText": "We cannot do everything at once, but we can do something at once.",
"quoteAuthor": "Calvin Coolidge"
}, {
"quoteText": "You have to do your own growing no matter how tall your grandfather was.",
"quoteAuthor": "Abraham Lincoln"
}, {
"quoteText": "Invent your world. Surround yourself with people, color, sounds, and work that nourish you.",
"quoteAuthor": ""
}, {
"quoteText": "It is fatal to enter any war without the will to win it.",
"quoteAuthor": "General Douglas MacArthur"
}, {
"quoteText": "Be what you are. This is the first step toward becoming better than you are.",
"quoteAuthor": "Julius Charles Hare"
}, {
"quoteText": "There is nothing in a caterpillar that tells you it's going to be a butterfly.",
"quoteAuthor": "Buckminster Fuller"
}, {
"quoteText": "Whenever you have eliminated the impossible, whatever remains, however improbable, must be the truth.",
"quoteAuthor": "Arthur Conan Doyle"
}, {
"quoteText": "Love and compassion open our own inner life, reducing stress, distrust and loneliness.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Ideals are an imaginative understanding of that which is desirable in that which is possible.",
"quoteAuthor": "Walter Lippmann"
}, {
"quoteText": "The superior man is satisfied and composed; the mean man is always full of distress.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "If you spend too much time thinking about a thing, you'll never get it done.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "The way is not in the sky. The way is in the heart.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "I don't believe in failure. It is not failure if you enjoyed the process.",
"quoteAuthor": "Oprah Winfrey"
}, {
"quoteText": "Most people are about as happy as they make up their minds to be",
"quoteAuthor": "Abraham Lincoln"
}, {
"quoteText": "Three things cannot be long hidden: the sun, the moon, and the truth.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "More often than not, anger is actually an indication of weakness rather than of strength.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Before you put on a frown, make absolutely sure there are no smiles available.",
"quoteAuthor": "Jim Beggs"
}, {
"quoteText": "A man of ability and the desire to accomplish something can do anything.",
"quoteAuthor": "Donald Kircher"
}, {
"quoteText": "You, yourself, as much as anybody in the entire universe, deserve your love and affection.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "It is not uncommon for people to spend their whole life waiting to start living.",
"quoteAuthor": "Eckhart Tolle"
}, {
"quoteText": "We learn what we have said from those who listen to our speaking.",
"quoteAuthor": "Kenneth Patton"
}, {
"quoteText": "It is only when the mind and character slumber that the dress can be seen.",
"quoteAuthor": "Ralph Waldo Emerson"
}, {
"quoteText": "The way is not in the sky. The way is in the heart.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Don't be afraid to go out on a limb. That's where the fruit is.",
"quoteAuthor": "H. Jackson Browne"
}, {
"quoteText": "Wicked people are always surprised to find ability in those that are good.",
"quoteAuthor": "Marquis Vauvenargues"
}, {
"quoteText": "Life is so constructed that an event does not, cannot, will not, match the expectation.",
"quoteAuthor": "Charlotte Bronte"
}, {
"quoteText": "Ideals are an imaginative understanding of that which is desirable in that which is possible.",
"quoteAuthor": "Walter Lippmann"
}, {
"quoteText": "If you change the way you look at things, the things you look at change.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "No man can succeed in a line of endeavor which he does not like.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Think for yourselves and let others enjoy the privilege to do so too.",
"quoteAuthor": "Voltaire"
}, {
"quoteText": "You will not be punished for your anger, you will be punished by your anger.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "The future belongs to those who believe in the beauty of their dreams.",
"quoteAuthor": "Eleanor Roosevelt"
}, {
"quoteText": "I believe that we are fundamentally the same and have the same basic potential.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Each misfortune you encounter will carry in it the seed of tomorrows good luck.",
"quoteAuthor": "Og Mandino"
}, {
"quoteText": "Don't judge each day by the harvest you reap but by the seeds you plant.",
"quoteAuthor": "Robert Stevenson"
}, {
"quoteText": "They say that time changes things, but you actually have to change them yourself.",
"quoteAuthor": "Andy Warhol"
}, {
"quoteText": "Never apologize for showing feelings. When you do so, you apologize for the truth.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "The truth you believe and cling to makes you unavailable to hear anything new.",
"quoteAuthor": "Pema Chodron"
}, {
"quoteText": "Adversity has the effect of eliciting talents, which in prosperous circumstances would have lain dormant.",
"quoteAuthor": "Horace"
}, {
"quoteText": "The winds and waves are always on the side of the ablest navigators.",
"quoteAuthor": "Edward Gibbon"
}, {
"quoteText": "If you light a lamp for somebody, it will also brighten your path.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "If you spend your whole life waiting for the storm, you'll never enjoy the sunshine.",
"quoteAuthor": "Morris West"
}, {
"quoteText": "The only limit to our realization of tomorrow will be our doubts of today.",
"quoteAuthor": "Franklin Roosevelt"
}, {
"quoteText": "Every action of our lives touches on some chord that will vibrate in eternity.",
"quoteAuthor": "Edwin Chapin"
}, {
"quoteText": "Letting go isn�t the end of the world; it�s the beginning of a new life.",
"quoteAuthor": ""
}, {
"quoteText": "Shoot for the moon. Even if you miss, you'll land among the stars.",
"quoteAuthor": "Les Brown"
}, {
"quoteText": "Just as a candle cannot burn without fire, men cannot live without a spiritual life.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Adversity has the effect of eliciting talents, which in prosperous circumstances would have lain dormant.",
"quoteAuthor": "Horace"
}, {
"quoteText": "I'm not afraid of storms, for Im learning how to sail my ship.",
"quoteAuthor": "Louisa Alcott"
}, {
"quoteText": "It does not matter how slowly you go as long as you do not stop.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Every day may not be good, but there's something good in every day.",
"quoteAuthor": ""
}, {
"quoteText": "The truth you believe and cling to makes you unavailable to hear anything new.",
"quoteAuthor": "Pema Chodron"
}, {
"quoteText": "To forgive is to set a prisoner free and realize that prisoner was you.",
"quoteAuthor": "Lewis B. Smedes"
}, {
"quoteText": "Most folks are about as happy as they make up their minds to be.",
"quoteAuthor": "Abraham Lincoln"
}, {
"quoteText": "If you would take, you must first give, this is the beginning of intelligence.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Some people think it's holding that makes one strong � sometimes it's letting go.",
"quoteAuthor": ""
}, {
"quoteText": "The universe is full of magical things, patiently waiting for our wits to grow sharper.",
"quoteAuthor": "Eden Phillpotts"
}, {
"quoteText": "It is on our failures that we base a new and different and better success.",
"quoteAuthor": "Havelock Ellis"
}, {
"quoteText": "If you spend too much time thinking about a thing, you'll never get it done.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "Quality is never an accident; it is always the result of intelligent effort.",
"quoteAuthor": "John Ruskin"
}, {
"quoteText": "To study and not think is a waste. To think and not study is dangerous.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Life is a succession of lessons, which must be lived to be understood.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Being right is highly overrated. Even a stopped clock is right twice a day.",
"quoteAuthor": ""
}, {
"quoteText": "Love is just a word until someone comes along and gives it meaning.",
"quoteAuthor": ""
}, {
"quoteText": "I have done my best: that is about all the philosophy of living one needs.",
"quoteAuthor": "Lin-yutang"
}, {
"quoteText": "Time changes everything except something within us which is always surprised by change.",
"quoteAuthor": "Thomas Hardy"
}, {
"quoteText": "You are important enough to ask and you are blessed enough to receive back.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Our greatest glory is not in never failing but rising everytime we fall.",
"quoteAuthor": ""
}, {
"quoteText": "Knowledge is a process of piling up facts; wisdom lies in their simplification.",
"quoteAuthor": "Martin Fischer"
}, {
"quoteText": "It is fatal to enter any war without the will to win it.",
"quoteAuthor": "General Douglas MacArthur"
}, {
"quoteText": "If you spend too much time thinking about a thing, you'll never get it done.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "To get something you never had, you have to do something you never did.",
"quoteAuthor": ""
}, {
"quoteText": "If you cannot do great things, do small things in a great way.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Everything is perfect in the universe � even your desire to improve it.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "If you want your life to be more rewarding, you have to change the way you think.",
"quoteAuthor": "Oprah Winfrey"
}, {
"quoteText": "Transformation doesn't take place with a vacuum; instead, it occurs when we are indirectly and directly connected to all those around us.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "The only difference between your abilities and others is the ability to put yourself in their shoes and actually try.",
"quoteAuthor": "Leonardo Ruiz"
}, {
"quoteText": "The free man is he who does not fear to go to the end of his thought.",
"quoteAuthor": "Leon Blum"
}, {
"quoteText": "Great are they who see that spiritual is stronger than any material force, that thoughts rule the world.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "A life spent making mistakes is not only more honourable but more useful than a life spent in doing nothing.",
"quoteAuthor": "Bernard Shaw"
}, {
"quoteText": "The wise man does not lay up his own treasures. The more he gives to others, the more he has for his own.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Don't leave a stone unturned. It's always something, to know you have done the most you could.",
"quoteAuthor": "Charles Dickens"
}, {
"quoteText": "By going beyond your own problems and taking care of others, you gain inner strength, self-confidence, courage, and a greater sense of calm.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "We come to love not by finding a perfect person, but by learning to see an imperfect person perfectly.",
"quoteAuthor": "Sam Keen"
}, {
"quoteText": "What lies behind us and what lies before us are tiny matters compared to what lies within us.",
"quoteAuthor": "Walt Emerson"
}, {
"quoteText": "There are things so deep and complex that only intuition can reach it in our stage of development as human beings.",
"quoteAuthor": "John Astin"
}, {
"quoteText": "A little more persistence, a little more effort, and what seemed hopeless failure may turn to glorious success.",
"quoteAuthor": "Elbert Hubbard"
}, {
"quoteText": "There are things so deep and complex that only intuition can reach it in our stage of development as human beings.",
"quoteAuthor": "John Astin"
}, {
"quoteText": "There is no retirement for an artist, it's your way of living so there is no end to it.",
"quoteAuthor": "Henry Moore"
}, {
"quoteText": "I will not be concerned at other men is not knowing me;I will be concerned at my own want of ability.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Why worry about things you can�t control when you can keep yourself busy controlling the things that depend on you?",
"quoteAuthor": ""
}, {
"quoteText": "When you are content to be simply yourself and don't compare or compete, everybody will respect you.",
"quoteAuthor": "Laozi"
}, {
"quoteText": "Be not afraid of greatness: some are born great, some achieve greatness, and some have greatness thrust upon them.",
"quoteAuthor": "William Shakespeare"
}, {
"quoteText": "Success means having the courage, the determination, and the will to become the person you believe you were meant to be.",
"quoteAuthor": "George Sheehan"
}, {
"quoteText": "Do you want to know who you are? Don't ask. Act! Action will delineate and define you.",
"quoteAuthor": "Thomas Jefferson"
}, {
"quoteText": "It is only with the heart that one can see rightly, what is essential is invisible to the eye.",
"quoteAuthor": "Antoine de Saint-Exupery"
}, {
"quoteText": "Let us be grateful to people who make us happy; they are the charming gardeners who make our souls blossom.",
"quoteAuthor": "Marcel Proust"
}, {
"quoteText": "Make the best use of what is in your power, and take the rest as it happens.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "The thoughts we choose to think are the tools we use to paint the canvas of our lives.",
"quoteAuthor": "Louise Hay"
}, {
"quoteText": "No matter how carefully you plan your goals they will never be more that pipe dreams unless you pursue them with gusto.",
"quoteAuthor": "W. Clement Stone"
}, {
"quoteText": "The reason most goals are not achieved is that we spend our time doing second things first.",
"quoteAuthor": "Robert McKain"
}, {
"quoteText": "If your actions inspire others to dream more, learn more, do more and become more, you are a leader.",
"quoteAuthor": "John Quincy Adams"
}, {
"quoteText": "I'm a great believer in luck and I find the harder I work, the more I have of it.",
"quoteAuthor": "Thomas Jefferson"
}, {
"quoteText": "Do not waste yourself in rejection, nor bark against the bad, but chant the beauty of the good.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "The person born with a talent they are meant to use will find their greatest happiness in using it.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "Good people are good because they've come to wisdom through failure. We get very little wisdom from success, you know.",
"quoteAuthor": "William Saroyan"
}, {
"quoteText": "Your destiny isn't just fate; it is how you use your own developed abilities to get what you want.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Iron rusts from disuse; water loses its purity from stagnation... even so does inaction sap the vigour of the mind.",
"quoteAuthor": "Leonardo da Vinci"
}, {
"quoteText": "A subtle thought that is in error may yet give rise to fruitful inquiry that can establish truths of great value.",
"quoteAuthor": "Isaac Asimov"
}, {
"quoteText": "Be glad of life because it gives you the chance to love, to work, to play, and to look up at the stars.",
"quoteAuthor": "Henry Van Dyke"
}, {
"quoteText": "The person born with a talent they are meant to use will find their greatest happiness in using it.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "You got to be careful if you don't know where you're going, because you might not get there.",
"quoteAuthor": "Yogi Berra"
}, {
"quoteText": "You can tell whether a man is clever by his answers. You can tell whether a man is wise by his questions.",
"quoteAuthor": "Naguib Mahfouz"
}, {
"quoteText": "Life is a gift, and it offers us the privilege, opportunity, and responsibility to give something back by becoming more",
"quoteAuthor": "Anthony Robbins"
}, {
"quoteText": "You can't let praise or criticism get to you. It's a weakness to get caught up in either one.",
"quoteAuthor": "John Wooden"
}, {
"quoteText": "I will love the light for it shows me the way, yet I will endure the darkness because it shows me the stars.",
"quoteAuthor": "Og Mandino"
}, {
"quoteText": "Our doubts are traitors and make us lose the good we often might win, by fearing to attempt.",
"quoteAuthor": "Jane Addams"
}, {
"quoteText": "By nature man hates change; seldom will he quit his old home till it has actually fallen around his ears.",
"quoteAuthor": "Thomas Carlyle"
}, {
"quoteText": "Until you value yourself, you won't value your time. Until you value your time, you won't do anything with it.",
"quoteAuthor": "M. Scott Peck"
}, {
"quoteText": "The minute you settle for less than you deserve, you get even less than you settled for.",
"quoteAuthor": "Maureen Dowd"
}, {
"quoteText": "The highest stage in moral ure at which we can arrive is when we recognize that we ought to control our thoughts.",
"quoteAuthor": "Charles Darwin"
}, {
"quoteText": "It is better to take many small steps in the right direction than to make a great leap forward only to stumble backward.",
"quoteAuthor": ""
}, {
"quoteText": "If we have a positive mental attitude, then even when surrounded by hostility, we shall not lack inner peace.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "There is only one success � to be able to spend your life in your own way.",
"quoteAuthor": "Christopher Morley"
}, {
"quoteText": "Promises are the uniquely human way of ordering the future, making it predictable and reliable to the extent that this is humanly possible.",
"quoteAuthor": "Hannah Arendt"
}, {
"quoteText": "Appreciation is the highest form of prayer, for it acknowledges the presence of good wherever you shine the light of your thankful thoughts.",
"quoteAuthor": "Alan Cohen"
}, {
"quoteText": "Iron rusts from disuse; water loses its purity from stagnation... even so does inaction sap the vigour of the mind.",
"quoteAuthor": "Leonardo da Vinci"
}, {
"quoteText": "There is only one corner of the universe you can be certain of improving, and that's your own self.",
"quoteAuthor": "Aldous Huxley"
}, {
"quoteText": "You're not obligated to win. You're obligated to keep trying to do the best you can every day.",
"quoteAuthor": "Marian Edelman"
}, {
"quoteText": "Everyone can taste success when the going is easy, but few know how to taste victory when times get tough.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Deep listening is miraculous for both listener and speaker.When someone receives us with open-hearted, non-judging, intensely interested listening, our spirits expand.",
"quoteAuthor": "Sue Patton Thoele"
}, {
"quoteText": "You may be deceived if you trust too much, but you will live in torment if you don't trust enough.",
"quoteAuthor": "Frank Crane"
}, {
"quoteText": "Great indeed is the sublimity of the Creative, to which all beings owe their beginning and which permeates all heaven.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "All that is necessary is to accept the impossible, do without the indispensable, and bear the intolerable.",
"quoteAuthor": "Kathleen Norris"
}, {
"quoteText": "Choose a job you love, and you will never have to work a day in your life.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "You cannot find yourself by going into the past. You can find yourself by coming into the present.",
"quoteAuthor": "Eckhart Tolle"
}, {
"quoteText": "All our talents increase in the using, and the every faculty, both good and bad, strengthen by exercise.",
"quoteAuthor": "Anne Bronte"
}, {
"quoteText": "In order to live free and happily you must sacrifice boredom. It is not always an easy sacrifice.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "The fox has many tricks. The hedgehog has but one. But that is the best of all.",
"quoteAuthor": "Desiderius Erasmus"
}, {
"quoteText": "Of course there is no formula for success except perhaps an unconditional acceptance of life and what it brings.",
"quoteAuthor": "Arthur Rubinstein"
}, {
"quoteText": "Let me tell you the secret that has led me to my goal: my strength lies solely in my tenacity",
"quoteAuthor": "Louis Pasteur"
}, {
"quoteText": "Something opens our wings. Something makes boredom and hurt disappear. Someone fills the cup in front of us: We taste only sacredness.",
"quoteAuthor": "Rumi"
}, {
"quoteText": "We must never forget that it is through our actions, words, and thoughts that we have a choice.",
"quoteAuthor": "Sogyal Rinpoche"
}, {
"quoteText": "We see things not as they are, but as we are. Our perception is shaped by our previous experiences.",
"quoteAuthor": "Dennis Kimbro"
}, {
"quoteText": "True silence is the rest of the mind; it is to the spirit what sleep is to the body, nourishment and refreshment.",
"quoteAuthor": "William Penn"
}, {
"quoteText": "There is no retirement for an artist, it's your way of living so there is no end to it.",
"quoteAuthor": "Henry Moore"
}, {
"quoteText": "All our knowledge begins with the senses, proceeds then to the understanding, and ends with reason. There is nothing higher than reason.",
"quoteAuthor": "Immanuel Kant"
}, {
"quoteText": "The thought manifests as the word. The word manifests as the deed. The deed develops into habit. And the habit hardens into character.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "As the rest of the world is walking out the door, your best friends are the ones walking in.",
"quoteAuthor": ""
}, {
"quoteText": "Patience is a virtue but you will never ever accomplish anything if you don't exercise action over patience.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Any of us can achieve virtue, if by virtue we merely mean the avoidance of the vices that do not attract us.",
"quoteAuthor": "Robert Lynd"
}, {
"quoteText": "If the single man plant himself indomitably on his instincts, and there abide, the huge world will come round to him.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "True silence is the rest of the mind; it is to the spirit what sleep is to the body, nourishment and refreshment.",
"quoteAuthor": "William Penn"
}, {
"quoteText": "Money was never a big motivation for me, except as a way to keep score. The real excitement is playing the game.",
"quoteAuthor": "Donald Trump"
}, {
"quoteText": "The person born with a talent they are meant to use will find their greatest happiness in using it.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "We come to love not by finding a perfect person, but by learning to see an imperfect person perfectly.",
"quoteAuthor": "Sam Keen"
}, {
"quoteText": "Friendship with oneself is all important because without it one cannot be friends with anybody else in the world.",
"quoteAuthor": "Eleanor Roosevelt"
}, {
"quoteText": "Peace is not something you wish for. It's something you make, something you do, something you are, and something you give away.",
"quoteAuthor": "Robert Fulghum"
}, {
"quoteText": "A wise man can learn more from a foolish question than a fool can learn from a wise answer.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "The highest stage in moral ure at which we can arrive is when we recognize that we ought to control our thoughts.",
"quoteAuthor": "Charles Darwin"
}, {
"quoteText": "Every man takes the limits of his own field of vision for the limits of the world.",
"quoteAuthor": "Arthur Schopenhauer"
}, {
"quoteText": "One does not discover new lands without consenting to lose sight of the shore for a very long time.",
"quoteAuthor": "Andr� Gide"
}, {
"quoteText": "What is new in the world? Nothing. What is old in the world? Nothing. Everything has always been and will always be.",
"quoteAuthor": "Sai Baba"
}, {
"quoteText": "Genuine love should first be directed at oneself � if we do not love ourselves, how can we love others?",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Life is like a sewer. What you get out of it depends on what you put into it.",
"quoteAuthor": "Tom Lehrer"
}, {
"quoteText": "Notice that the stiffest tree is most easily cracked, while the bamboo or willow survives by bending with the wind.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "Learn all you can from the mistakes of others. You won't have time to make them all yourself.",
"quoteAuthor": "Alfred Sheinwold"
}, {
"quoteText": "There is only one corner of the universe you can be certain of improving, and that's your own self.",
"quoteAuthor": "Aldous Huxley"
}, {
"quoteText": "Judge nothing, you will be happy. Forgive everything, you will be happier. Love everything, you will be happiest.",
"quoteAuthor": "Sri Chinmoy"
}, {
"quoteText": "People are so constituted that everybody would rather undertake what they see others do, whether they have an aptitude for it or not.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "We are either progressing or retrograding all the while. There is no such thing as remaining stationary in this life.",
"quoteAuthor": "James Freeman Clarke"
}, {
"quoteText": "You can't let praise or criticism get to you. It's a weakness to get caught up in either one.",
"quoteAuthor": "John Wooden"
}, {
"quoteText": "The possession of knowledge does not kill the sense of wonder and mystery. There is always more mystery.",
"quoteAuthor": "Anais Nin"
}, {
"quoteText": "Everything that happens happens as it should, and if you observe carefully, you will find this to be so.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "What we think determines what happens to us, so if we want to change our lives, we need to stretch our minds.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Promises are the uniquely human way of ordering the future, making it predictable and reliable to the extent that this is humanly possible.",
"quoteAuthor": "Hannah Arendt"
}, {
"quoteText": "Learn all you can from the mistakes of others. You won't have time to make them all yourself.",
"quoteAuthor": "Alfred Sheinwold"
}, {
"quoteText": "The fox has many tricks. The hedgehog has but one. But that is the best of all.",
"quoteAuthor": "Desiderius Erasmus"
}, {
"quoteText": "In a controversy the instant we feel anger we have already ceased striving for the truth, and have begun striving for ourselves.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "It is the greatest of all mistakes to do nothing because you can only do little � do what you can.",
"quoteAuthor": "Sydney Smith"
}, {
"quoteText": "When you see a man of worth, think of how you may emulate him. When you see one who is unworthy, examine yourself.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Aerodynamically the bumblebee shouldn't be able to fly, but the bumblebee doesn't know that so it goes on flying anyway.",
"quoteAuthor": "Mary Kay Ash"
}, {
"quoteText": "Those who try to do something and fail are infinitely better than those who try nothing and succeed.",
"quoteAuthor": "Lloyd Jones"
}, {
"quoteText": "Snowflakes are one of natures most fragile things, but just look what they can do when they stick together.",
"quoteAuthor": "Vista Kelly"
}, {
"quoteText": "The first step to getting the things you want out of life is this: decide what you want.",
"quoteAuthor": "Ben Stein"
}, {
"quoteText": "Why compare yourself with others? No one in the entire world can do a better job of being you than you.",
"quoteAuthor": ""
}, {
"quoteText": "Experience is not what happens to a man. It is what a man does with what happens to him.",
"quoteAuthor": "Aldous Huxley"
}, {
"quoteText": "A good teacher is like a candle � it consumes itself to light the way for others.",
"quoteAuthor": ""
}, {
"quoteText": "The only thing to do with good advice is to pass it on. It is never of any use to oneself.",
"quoteAuthor": "Oscar Wilde"
}, {
"quoteText": "Life is not measured by the breaths we take, but by the moments that take our breath.",
"quoteAuthor": ""
}, {
"quoteText": "The smallest flower is a thought, a life answering to some feature of the Great Whole, of whom they have a persistent intuition.",
"quoteAuthor": "Honore de Balzac"
}, {
"quoteText": "Consider how hard it is to change yourself and you'll understand what little chance you have in trying to change others.",
"quoteAuthor": "Jacob Braude"
}, {
"quoteText": "If you'll not settle for anything less than your best, you will be amazed at what you can accomplish in your lives.",
"quoteAuthor": "Vince Lombardi"
}, {
"quoteText": "What lies behind us and what lies before us are small matters compared to what lies within us.",
"quoteAuthor": "Oliver Holmes"
}, {
"quoteText": "With the realization of ones own potential and self-confidence in ones ability, one can build a better world.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "There is nothing like returning to a place that remains unchanged to find the ways in which you yourself have altered.",
"quoteAuthor": "Nelson Mandela"
}, {
"quoteText": "Friendship with oneself is all important because without it one cannot be friends with anybody else in the world.",
"quoteAuthor": "Eleanor Roosevelt"
}, {
"quoteText": "Forget about all the reasons why something may not work. You only need to find one good reason why it will.",
"quoteAuthor": "Robert Anthony"
}, {
"quoteText": "It is the mark of an educated mind to be able to entertain a thought without accepting it.",
"quoteAuthor": "Aristotle"
}, {
"quoteText": "Love is never lost. If not reciprocated, it will flow back and soften and purify the heart.",
"quoteAuthor": "Washington Irving"
}, {
"quoteText": "We all live with the objective of being happy; our lives are all different and yet the same.",
"quoteAuthor": "Anne Frank"
}, {
"quoteText": "Let me tell you the secret that has led me to my goal: my strength lies solely in my tenacity",
"quoteAuthor": "Louis Pasteur"
}, {
"quoteText": "Many people think of prosperity that concerns money only to forget that true prosperity is of the mind.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "To be beautiful means to be yourself. You don�t need to be accepted by others. You need to accept yourself.",
"quoteAuthor": "Thich Nhat Hanh"
}, {
"quoteText": "Do not overrate what you have received, nor envy others. He who envies others does not obtain peace of mind.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "It is very easy to forgive others their mistakes; it takes more grit to forgive them for having witnessed your own.",
"quoteAuthor": "Jessamyn West"
}, {
"quoteText": "Bodily exercise, when compulsory, does no harm to the body; but knowledge which is acquired under compulsion obtains no hold on the mind.",
"quoteAuthor": "Plato"
}, {
"quoteText": "Always be yourself, express yourself, have faith in yourself, do not go out and look for a successful personality and duplicate it.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "Let us revere, let us worship, but erect and open-eyed, the highest, not the lowest; the future, not the past!",
"quoteAuthor": "Charlotte Gilman"
}, {
"quoteText": "Every time you smile at someone, it is an action of love, a gift to that person, a beautiful thing.",
"quoteAuthor": "Mother Teresa"
}, {
"quoteText": "Silences make the real conversations between friends. Not the saying but the never needing to say is what counts.",
"quoteAuthor": "Margaret Runbeck"
}, {
"quoteText": "The key to transforming our hearts and minds is to have an understanding of how our thoughts and emotions work.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "If you must tell me your opinions, tell me what you believe in. I have plenty of douts of my own.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "True silence is the rest of the mind; it is to the spirit what sleep is to the body, nourishment and refreshment.",
"quoteAuthor": "William Penn"
}, {
"quoteText": "Chance is always powerful. Let your hook be always cast; in the pool where you least expect it, there will be a fish.",
"quoteAuthor": "Ovid"
}, {
"quoteText": "You're not obligated to win. You're obligated to keep trying to do the best you can every day.",
"quoteAuthor": "Marian Edelman"
}, {
"quoteText": "I seek constantly to improve my manners and graces, for they are the sugar to which all are attracted.",
"quoteAuthor": "Og Mandino"
}, {
"quoteText": "We never understand how little we need in this world until we know the loss of it.",
"quoteAuthor": "James Barrie"
}, {
"quoteText": "It is better to take many small steps in the right direction than to make a great leap forward only to stumble backward.",
"quoteAuthor": ""
}, {
"quoteText": "The real measure of your wealth is how much youd be worth if you lost all your money.",
"quoteAuthor": ""
}, {
"quoteText": "To keep the body in good health is a duty... otherwise we shall not be able to keep our mind strong and clear.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Life is like a sewer. What you get out of it depends on what you put into it.",
"quoteAuthor": "Tom Lehrer"
}, {
"quoteText": "Take no thought of who is right or wrong or who is better than. Be not for or against.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "I am a man of fixed and unbending principles, the first of which is to be flexible at all times.",
"quoteAuthor": "Everett Dirksen"
}, {
"quoteText": "Something opens our wings. Something makes boredom and hurt disappear. Someone fills the cup in front of us: We taste only sacredness.",
"quoteAuthor": "Rumi"
}, {
"quoteText": "Today, give a stranger a smile without waiting for it may be the joy they need to have a great day.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "The moment one gives close attention to anything, even a blade of grass, it becomes a mysterious, awesome, indescribably magnificent world in itself.",
"quoteAuthor": "Henry Miller"
}, {
"quoteText": "Good people are good because they've come to wisdom through failure. We get very little wisdom from success, you know.",
"quoteAuthor": "William Saroyan"
}, {
"quoteText": "At the center of your being you have the answer; you know who you are and you know what you want.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "How wonderful that we have met with a paradox. Now we have some hope of making progress.",
"quoteAuthor": "Niels Bohr"
}, {
"quoteText": "Great indeed is the sublimity of the Creative, to which all beings owe their beginning and which permeates all heaven.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Everyone is a genius at least once a year. A real genius has his original ideas closer together.",
"quoteAuthor": "Georg Lichtenberg"
}, {
"quoteText": "Dreams pass into the reality of action. From the actions stems the dream again; and this interdependence produces the highest form of living.",
"quoteAuthor": "Anais Nin"
}, {
"quoteText": "Without leaps of imagination, or dreaming, we lose the excitement of possibilities. Dreaming, after all, is a form of planning.",
"quoteAuthor": "Gloria Steinem"
}, {
"quoteText": "Sadness may be part of life but there is no need to let it dominate your entire life.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Keeping a little ahead of conditions is one of the secrets of business, the trailer seldom goes far.",
"quoteAuthor": "Charles Schwab"
}, {
"quoteText": "Nature gave us one tongue and two ears so we could hear twice as much as we speak.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "Don't wait for your feelings to change to take the action. Take the action and your feelings will change.",
"quoteAuthor": "Barbara Baron"
}, {
"quoteText": "You are always free to change your mind and choose a different future, or a different past.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "You were not born a winner, and you were not born a loser. You are what you make yourself be.",
"quoteAuthor": "Lou Holtz"
}, {
"quoteText": "Cherish your visions and your dreams as they are the children of your soul, the blueprints of your ultimate achievements.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "You got to be careful if you don't know where you're going, because you might not get there.",
"quoteAuthor": "Yogi Berra"
}, {
"quoteText": "Cherish your visions and your dreams as they are the children of your soul; the blueprints of your ultimate achievements.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "To be what we are, and to become what we are capable of becoming, is the only end of life.",
"quoteAuthor": "Robert Stevenson"
}, {
"quoteText": "The road leading to a goal does not separate you from the destination; it is essentially a part of it.",
"quoteAuthor": "Charles DeLint"
}, {
"quoteText": "Take things as they are. Punch when you have to punch. Kick when you have to kick.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "I believe that a simple and unassuming manner of life is best for everyone, best both for the body and the mind.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "Though no one can go back and make a brand new start, anyone can start from now and make a brand new ending.",
"quoteAuthor": ""
}, {
"quoteText": "Mind is everything: muscle, pieces of rubber. All that I am, I am because of my mind.",
"quoteAuthor": "Paavo Nurmi"
}, {
"quoteText": "The real measure of your wealth is how much youd be worth if you lost all your money.",
"quoteAuthor": ""
}, {
"quoteText": "How wonderful it is that nobody need wait a single moment before starting to improve the world.",
"quoteAuthor": "Anne Frank"
}, {
"quoteText": "A friend is someone who understands your past, believes in your future, and accepts you just the way you are.",
"quoteAuthor": ""
}, {
"quoteText": "By nature man hates change; seldom will he quit his old home till it has actually fallen around his ears.",
"quoteAuthor": "Thomas Carlyle"
}, {
"quoteText": "The first step to getting the things you want out of life is this: decide what you want.",
"quoteAuthor": "Ben Stein"
}, {
"quoteText": "Be glad of life because it gives you the chance to love, to work, to play, and to look up at the stars.",
"quoteAuthor": "Henry Van Dyke"
}, {
"quoteText": "It is one of the blessings of old friends that you can afford to be stupid with them.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "He that never changes his opinions, never corrects his mistakes, and will never be wiser on the morrow than he is today.",
"quoteAuthor": "Tryon Edwards"
}, {
"quoteText": "Give me six hours to chop down a tree and I will spend the first four sharpening the axe.",
"quoteAuthor": "Abraham Lincoln"
}, {
"quoteText": "One must be fond of people and trust them if one is not to make a mess of life.",
"quoteAuthor": "E. M. Forster"
}, {
"quoteText": "There are things so deep and complex that only intuition can reach it in our stage of development as human beings.",
"quoteAuthor": "John Astin"
}, {
"quoteText": "We cannot change our memories, but we can change their meaning and the power they have over us.",
"quoteAuthor": "David Seamans"
}, {
"quoteText": "Being in humaneness is good. If we select other goodness and thus are far apart from humaneness, how can we be the wise?",
"quoteAuthor": "Confucius"
}, {
"quoteText": "To give hope to someone occurs when you teach them how to use the tools to do it for themselves.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "The road leading to a goal does not separate you from the destination; it is essentially a part of it.",
"quoteAuthor": "Charles DeLint"
}, {
"quoteText": "Id rather regret the things that I have done than the things that I have not done.",
"quoteAuthor": "Lucille Ball"
}, {
"quoteText": "The past has no power to stop you from being present now. Only your grievance about the past can do that.",
"quoteAuthor": "Eckhart Tolle"
}, {
"quoteText": "If the stars should appear but one night every thousand years how man would marvel and adore.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "There are two kinds of failures: those who thought and never did, and those who did and never thought.",
"quoteAuthor": "Laurence J. Peter"
}, {
"quoteText": "I'm not interested in age. People who tell me their age are silly. You're as old as you feel.",
"quoteAuthor": "Elizabeth Arden"
}, {
"quoteText": "Promises are the uniquely human way of ordering the future, making it predictable and reliable to the extent that this is humanly possible.",
"quoteAuthor": "Hannah Arendt"
}, {
"quoteText": "I find hope in the darkest of days, and focus in the brightest. I do not judge the universe.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Notice that the stiffest tree is most easily cracked, while the bamboo or willow survives by bending with the wind.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "When it is obvious that the goals cannot be reached, don't adjust the goals, adjust the action steps.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Our virtues and our failings are inseparable, like force and matter. When they separate, man is no more.",
"quoteAuthor": "Nikola Tesla"
}, {
"quoteText": "Blessed is the person who is too busy to worry in the daytime, and too sleepy to worry at night.",
"quoteAuthor": "Leo Aikman"
}, {
"quoteText": "The only difference between your abilities and others is the ability to put yourself in their shoes and actually try.",
"quoteAuthor": "Leonardo Ruiz"
}, {
"quoteText": "He can who thinks he can, and he can't who thinks he can't. This is an inexorable, indisputable law.",
"quoteAuthor": "Pablo Picasso"
}, {
"quoteText": "These days people seek knowledge, not wisdom. Knowledge is of the past, wisdom is of the future.",
"quoteAuthor": "Vernon Cooper"
}, {
"quoteText": "One secret of success in life is for a man to be ready for his opportunity when it comes.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "People take different roads seeking fulfilment and happiness. Just because theyre not on your road doesn't mean they've gotten lost.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "The shoe that fits one person pinches another; there is no recipe for living that suits all cases.",
"quoteAuthor": "Carl Jung"
}, {
"quoteText": "There are only two mistakes one can make along the road to truth; not going all the way, and not starting.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Very little is needed to make a happy life; it is all within yourself, in your way of thinking.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "Giving up doesn't always mean you are weak. Sometimes it means that you are strong enough to let go.",
"quoteAuthor": ""
}, {
"quoteText": "There are two kinds of failures: those who thought and never did, and those who did and never thought.",
"quoteAuthor": "Laurence J. Peter"
}, {
"quoteText": "A life spent making mistakes is not only more honourable but more useful than a life spent in doing nothing.",
"quoteAuthor": "Bernard Shaw"
}, {
"quoteText": "There is only one success � to be able to spend your life in your own way.",
"quoteAuthor": "Christopher Morley"
}, {
"quoteText": "Patience is a virtue but you will never ever accomplish anything if you don't exercise action over patience.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "There is nothing like returning to a place that remains unchanged to find the ways in which you yourself have altered.",
"quoteAuthor": "Nelson Mandela"
}, {
"quoteText": "By nature man hates change; seldom will he quit his old home till it has actually fallen around his ears.",
"quoteAuthor": "Thomas Carlyle"
}, {
"quoteText": "Treat people as if they were what they ought to be and you help them to become what they are capable of being.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "The most precious gift we can offer anyone is our attention. When mindfulness embraces those we love, they will bloom like flowers.",
"quoteAuthor": "Thich Nhat Hanh"
}, {
"quoteText": "If you focus on results, you will never change. If you focus on change, you will get results.",
"quoteAuthor": "Jack Dixon"
}, {
"quoteText": "I would maintain that thanks are the highest form of thought, and that gratitude is happiness doubled by wonder.",
"quoteAuthor": "G. K. Chesterton"
}, {
"quoteText": "No matter how carefully you plan your goals they will never be more that pipe dreams unless you pursue them with gusto.",
"quoteAuthor": "W. Clement Stone"
}, {
"quoteText": "By going beyond your own problems and taking care of others, you gain inner strength, self-confidence, courage, and a greater sense of calm.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "There are two primary choices in life: to accept conditions as they exist, or accept the responsibility for changing them.",
"quoteAuthor": "Denis Waitley"
}, {
"quoteText": "If your actions inspire others to dream more, learn more, do more and become more, you are a leader.",
"quoteAuthor": "John Quincy Adams"
}, {
"quoteText": "Experience is not what happens to a man. It is what a man does with what happens to him.",
"quoteAuthor": "Aldous Huxley"
}, {
"quoteText": "All difficult things have their origin in that which is easy, and great things in that which is small.",
"quoteAuthor": "Lao-Tzu"
}, {
"quoteText": "When it is obvious that the goals cannot be reached, don't adjust the goals, adjust the action steps.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "You can be what you want to be. You have the power within and we will help you always.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "To speak gratitude is courteous and pleasant, to enact gratitude is generous and noble, but to live gratitude is to touch Heaven.",
"quoteAuthor": "Johannes Gaertner"
}, {
"quoteText": "Without leaps of imagination, or dreaming, we lose the excitement of possibilities. Dreaming, after all, is a form of planning.",
"quoteAuthor": "Gloria Steinem"
}, {
"quoteText": "What we think determines what happens to us, so if we want to change our lives, we need to stretch our minds.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Wisdom is the reward you get for a lifetime of listening when you'd have preferred to talk.",
"quoteAuthor": "Doug Larson"
}, {
"quoteText": "Do not waste yourself in rejection, nor bark against the bad, but chant the beauty of the good.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "The greatest pleasure I know is to do a good action by stealth, and to have it found out by accident.",
"quoteAuthor": "Charles Lamb"
}, {
"quoteText": "How wonderful it is that nobody need wait a single moment before starting to improve the world.",
"quoteAuthor": "Anne Frank"
}, {
"quoteText": "The first step to getting the things you want out of life is this: decide what you want.",
"quoteAuthor": "Ben Stein"
}, {
"quoteText": "When one tugs at a single thing in nature, he finds it attached to the rest of the world.",
"quoteAuthor": "John Muir"
}, {
"quoteText": "If you must tell me your opinions, tell me what you believe in. I have plenty of douts of my own.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "Courage is what it takes to stand up and speak; courage is also what it takes to sit down and listen.",
"quoteAuthor": "Winston Churchill"
}, {
"quoteText": "Consider how hard it is to change yourself and you'll understand what little chance you have in trying to change others.",
"quoteAuthor": "Jacob Braude"
}, {
"quoteText": "The most beautiful things in the world cannot be seen or even touched. They must be felt with the heart.",
"quoteAuthor": "Helen Keller"
}, {
"quoteText": "I am a man of fixed and unbending principles, the first of which is to be flexible at all times.",
"quoteAuthor": "Everett Dirksen"
}, {
"quoteText": "To live a pure unselfish life, one must count nothing as ones own in the midst of abundance.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Many of life's failures are people who did not realize how close they were to success when they gave up.",
"quoteAuthor": "Thomas Edison"
}, {
"quoteText": "Very little is needed to make a happy life; it is all within yourself, in your way of thinking.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "When we seek to discover the best in others, we somehow bring out the best in ourselves.",
"quoteAuthor": "William Ward"
}, {
"quoteText": "If you accept the expectations of others, especially negative ones, then you never will change the outcome.",
"quoteAuthor": "Michael Jordan"
}, {
"quoteText": "The first step to getting the things you want out of life is this: decide what you want.",
"quoteAuthor": "Ben Stein"
}, {
"quoteText": "A man may fulfil the object of his existence by asking a question he cannot answer, and attempting a task he cannot achieve.",
"quoteAuthor": "Oliver Holmes"
}, {
"quoteText": "You are always free to change your mind and choose a different future, or a different past.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "I am not bothered by the fact that I am unknown. I am bothered when I do not know others.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Id rather regret the things that I have done than the things that I have not done.",
"quoteAuthor": "Lucille Ball"
}, {
"quoteText": "He is a wise man who does not grieve for the things which he has not, but rejoices for those which he has.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "The person born with a talent they are meant to use will find their greatest happiness in using it.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "I am always doing that which I cannot do, in order that I may learn how to do it.",
"quoteAuthor": "Pablo Picasso"
}, {
"quoteText": "If you're walking down the right path and you're willing to keep walking, eventually you'll make progress.",
"quoteAuthor": "Barack Obama"
}, {
"quoteText": "The world is round and the place which may seem like the end may also be the beginning.",
"quoteAuthor": "Ivy Baker Priest"
}, {
"quoteText": "Never miss an opportunity to make others happy, even if you have to leave them alone in order to do it.",
"quoteAuthor": ""
}, {
"quoteText": "Give it all you've got because you never know if there's going to be a next time.",
"quoteAuthor": "Danielle Ingrum"
}, {
"quoteText": "These days people seek knowledge, not wisdom. Knowledge is of the past, wisdom is of the future.",
"quoteAuthor": "Vernon Cooper"
}, {
"quoteText": "You have to take it as it happens, but you should try to make it happen the way you want to take it.",
"quoteAuthor": "Old German proverb"
}, {
"quoteText": "Nothing is predestined: The obstacles of your past can become the gateways that lead to new beginnings.",
"quoteAuthor": "Ralph Blum"
}, {
"quoteText": "Im not in this world to live up to your expectations and you're not in this world to live up to mine.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "I am not bothered by the fact that I am unknown. I am bothered when I do not know others.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Don't wait for your feelings to change to take the action. Take the action and your feelings will change.",
"quoteAuthor": "Barbara Baron"
}, {
"quoteText": "People take different roads seeking fulfilment and happiness. Just because theyre not on your road doesn't mean they've gotten lost.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Sometimes your joy is the source of your smile, but sometimes your smile can be the source of your joy.",
"quoteAuthor": "Thich Nhat Hanh"
}, {
"quoteText": "The smallest flower is a thought, a life answering to some feature of the Great Whole, of whom they have a persistent intuition.",
"quoteAuthor": "Honore de Balzac"
}, {
"quoteText": "I am always doing that which I cannot do, in order that I may learn how to do it.",
"quoteAuthor": "Pablo Picasso"
}, {
"quoteText": "I can't imagine a person becoming a success who doesn't give this game of life everything hes got.",
"quoteAuthor": "Walter Cronkite"
}, {
"quoteText": "The greatest way to live with honor in this world is to be what we pretend to be.",
"quoteAuthor": "Socrates"
}, {
"quoteText": "The conditions of conquest are always easy. We have but to toil awhile, endure awhile, believe always, and never turn back.",
"quoteAuthor": "Seneca"
}, {
"quoteText": "Success means having the courage, the determination, and the will to become the person you believe you were meant to be.",
"quoteAuthor": "George Sheehan"
}, {
"quoteText": "If you want your life to be more rewarding, you have to change the way you think.",
"quoteAuthor": "Oprah Winfrey"
}, {
"quoteText": "The grand essentials of happiness are: something to do, something to love, and something to hope for.",
"quoteAuthor": "Chalmers"
}, {
"quoteText": "By living deeply in the present moment we can understand the past better and we can prepare for a better future.",
"quoteAuthor": "Thich Nhat Hanh"
}, {
"quoteText": "Do not be too timid and squeamish about your reactions. All life is an experiment. The more experiments you make the better.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Do not go where the path may lead, go instead where there is no path and leave a trail.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "To keep the body in good health is a duty... otherwise we shall not be able to keep our mind strong and clear.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Don't leave a stone unturned. It's always something, to know you have done the most you could.",
"quoteAuthor": "Charles Dickens"
}, {
"quoteText": "There is no duty we so underrate as the duty of being happy. By being happy we sow anonymous benefits upon the world.",
"quoteAuthor": "Robert Louis Stevenson"
}, {
"quoteText": "Edison failed 10,000 times before he made the electric light. Do not be discouraged if you fail a few times.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "There are two kinds of failures: those who thought and never did, and those who did and never thought.",
"quoteAuthor": "Laurence J. Peter"
}, {
"quoteText": "Yesterday is history. Tomorrow is a mystery. And today? Today is a gift that's why they call it the present.",
"quoteAuthor": ""
}, {
"quoteText": "The only way to tell the truth is to speak with kindness. Only the words of a loving man can be heard.",
"quoteAuthor": "Henry Thoreau"
}, {
"quoteText": "The road leading to a goal does not separate you from the destination; it is essentially a part of it.",
"quoteAuthor": "Charles DeLint"
}, {
"quoteText": "Great are they who see that spiritual is stronger than any material force, that thoughts rule the world.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "The greatest good you can do for another is not just to share your riches but to reveal to him his own.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "Money was never a big motivation for me, except as a way to keep score. The real excitement is playing the game.",
"quoteAuthor": "Donald Trump"
}, {
"quoteText": "You can only grow if you're willing to feel awkward and uncomfortable when you try something new.",
"quoteAuthor": "Brian Tracy"
}, {
"quoteText": "To free us from the expectations of others, to give us back to ourselves � there lies the great, singular power of self-respect.",
"quoteAuthor": "Joan Didion"
}, {
"quoteText": "Cherish your visions and your dreams as they are the children of your soul, the blueprints of your ultimate achievements.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "It is more important to know where you are going than to get there quickly. Do not mistake activity for achievement.",
"quoteAuthor": "Mabel Newcomber"
}, {
"quoteText": "Being in humaneness is good. If we select other goodness and thus are far apart from humaneness, how can we be the wise?",
"quoteAuthor": "Confucius"
}, {
"quoteText": "When you don't know what you believe, everything becomes an argument. Everything is debatable. But when you stand for something, decisions are obvious.",
"quoteAuthor": ""
}, {
"quoteText": "Why worry about things you can�t control when you can keep yourself busy controlling the things that depend on you?",
"quoteAuthor": ""
}, {
"quoteText": "There are things so deep and complex that only intuition can reach it in our stage of development as human beings.",
"quoteAuthor": "John Astin"
}, {
"quoteText": "The greatest pleasure I know is to do a good action by stealth, and to have it found out by accident.",
"quoteAuthor": "Charles Lamb"
}, {
"quoteText": "Intuition is the supra-logic that cuts out all the routine processes of thought and leaps straight from the problem to the answer.",
"quoteAuthor": "Robert Graves"
}, {
"quoteText": "All difficult things have their origin in that which is easy, and great things in that which is small.",
"quoteAuthor": "Lao-Tzu"
}, {
"quoteText": "The thing always happens that you really believe in; and the belief in a thing makes it happen.",
"quoteAuthor": "Frank Wright"
}, {
"quoteText": "A true friend is the most precious of all possessions and the one we take the least thought about acquiring.",
"quoteAuthor": "Francois de La Rochefoucauld"
}, {
"quoteText": "There is only one way to happiness and that is to cease worrying about things which are beyond the power of our will.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "The only thing to do with good advice is to pass it on. It is never of any use to oneself.",
"quoteAuthor": "Oscar Wilde"
}, {
"quoteText": "Appreciation can make a day, even change a life. Your willingness to put it into words is all that is necessary.",
"quoteAuthor": "Margaret Cousins"
}, {
"quoteText": "One secret of success in life is for a man to be ready for his opportunity when it comes.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "One must be fond of people and trust them if one is not to make a mess of life.",
"quoteAuthor": "E. M. Forster"
}, {
"quoteText": "There are two primary choices in life: to accept conditions as they exist, or accept the responsibility for changing them.",
"quoteAuthor": "Denis Waitley"
}, {
"quoteText": "Every sixty seconds you spend angry, upset or mad, is a full minute of happiness you�ll never get back.",
"quoteAuthor": ""
}, {
"quoteText": "A little more persistence, a little more effort, and what seemed hopeless failure may turn to glorious success.",
"quoteAuthor": "Elbert Hubbard"
}, {
"quoteText": "There is only one way to happiness and that is to cease worrying about things which are beyond the power of our will.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "This world, after all our science and sciences, is still a miracle; wonderful, inscrutable, magical and more, to whosoever will think of it.",
"quoteAuthor": "Thomas Carlyle"
}, {
"quoteText": "Every great mistake has a halfway moment, a split second when it can be recalled and perhaps remedied.",
"quoteAuthor": "Pearl Buck"
}, {
"quoteText": "You can adopt the attitude there is nothing you can do, or you can see the challenge as your call to action.",
"quoteAuthor": "Catherine Pulsifer"
}, {
"quoteText": "The happiness of a man in this life does not consist in the absence but in the mastery of his passions.",
"quoteAuthor": "Alfred Tennyson"
}, {
"quoteText": "Never doubt that a small group of thoughtful, committed people can change the world. Indeed. It is the only thing that ever has.",
"quoteAuthor": "Margaret Mead"
}, {
"quoteText": "Let your hook always be cast; in the pool where you least expect it, there will be a fish.",
"quoteAuthor": "Ovid"
}, {
"quoteText": "The person born with a talent they are meant to use will find their greatest happiness in using it.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "You get peace of mind not by thinking about it or imagining it, but by quietening and relaxing the restless mind.",
"quoteAuthor": "Remez Sasson"
}, {
"quoteText": "There is only one way to happiness and that is to cease worrying about things which are beyond the power of our will.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "If we have a positive mental attitude, then even when surrounded by hostility, we shall not lack inner peace.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Your friends will know you better in the first minute you meet than your acquaintances will know you in a thousand years.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "It is the greatest of all mistakes to do nothing because you can only do little � do what you can.",
"quoteAuthor": "Sydney Smith"
}, {
"quoteText": "When you are content to be simply yourself and don't compare or compete, everybody will respect you.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "When you begin to touch your heart or let your heart be touched, you begin to discover that it's bottomless.",
"quoteAuthor": "Pema Chodron"
}, {
"quoteText": "The thing always happens that you really believe in; and the belief in a thing makes it happen.",
"quoteAuthor": "Frank Wright"
}, {
"quoteText": "If you love someone, set them free. If they come back they're yours; if they don't they never were.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "The road leading to a goal does not separate you from the destination; it is essentially a part of it.",
"quoteAuthor": "Charles DeLint"
}, {
"quoteText": "Wisdom is knowing what to do next; Skill is knowing how ot do it, and Virtue is doing it.",
"quoteAuthor": "David Jordan"
}, {
"quoteText": "Make the best use of what is in your power, and take the rest as it happens.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "Snowflakes are one of natures most fragile things, but just look what they can do when they stick together.",
"quoteAuthor": "Vista Kelly"
}, {
"quoteText": "Something opens our wings. Something makes boredom and hurt disappear. Someone fills the cup in front of us: We taste only sacredness.",
"quoteAuthor": "Rumi"
}, {
"quoteText": "Why worry about things you can�t control when you can keep yourself busy controlling the things that depend on you?",
"quoteAuthor": ""
}, {
"quoteText": "When one tugs at a single thing in nature, he finds it attached to the rest of the world.",
"quoteAuthor": "John Muir"
}, {
"quoteText": "I'm a great believer in luck and I find the harder I work, the more I have of it.",
"quoteAuthor": "Thomas Jefferson"
}, {
"quoteText": "Bad things are not the worst things that can happen to us. Nothing is the worst thing that can happen to us!",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "Wisdom is knowing what to do next; Skill is knowing how ot do it, and Virtue is doing it.",
"quoteAuthor": "David Jordan"
}, {
"quoteText": "You can only grow if you're willing to feel awkward and uncomfortable when you try something new.",
"quoteAuthor": "Brian Tracy"
}, {
"quoteText": "No valid plans for the future can be made by those who have no capacity for living now.",
"quoteAuthor": "Alan Watts"
}, {
"quoteText": "The aim of life is self-development. To realize ones nature perfectly � that is what each of us is here for.",
"quoteAuthor": "Oscar Wilde"
}, {
"quoteText": "Great indeed is the sublimity of the Creative, to which all beings owe their beginning and which permeates all heaven.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "One does not discover new lands without consenting to lose sight of the shore for a very long time.",
"quoteAuthor": "Andr� Gide"
}, {
"quoteText": "To accomplish great things, we must not only act, but also dream; not only plan, but also believe.",
"quoteAuthor": "Anatole France"
}, {
"quoteText": "The first requisite for success is the ability to apply your physical and mental energies to one problem incessantly without growing weary.",
"quoteAuthor": "Thomas Edison"
}, {
"quoteText": "If we could learn to like ourselves, even a little, maybe our cruelties and angers might melt away.",
"quoteAuthor": "John Steinbeck"
}, {
"quoteText": "We are either progressing or retrograding all the while. There is no such thing as remaining stationary in this life.",
"quoteAuthor": "James Freeman Clarke"
}, {
"quoteText": "If we are facing in the right direction, all we have to do is keep on walking.",
"quoteAuthor": ""
}, {
"quoteText": "The minute you settle for less than you deserve, you get even less than you settled for.",
"quoteAuthor": "Maureen Dowd"
}, {
"quoteText": "Remember always that you not only have the right to be an individual, you have an obligation to be one.",
"quoteAuthor": "Eleanor Roosevelt"
}, {
"quoteText": "There is only one success � to be able to spend your life in your own way.",
"quoteAuthor": "Christopher Morley"
}, {
"quoteText": "It is better to take many small steps in the right direction than to make a great leap forward only to stumble backward.",
"quoteAuthor": ""
}, {
"quoteText": "There are two primary choices in life: to accept conditions as they exist, or accept responsibility for changing them.",
"quoteAuthor": "Denis Waitley"
}, {
"quoteText": "If you must tell me your opinions, tell me what you believe in. I have plenty of douts of my own.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "If you seek truth you will not seek victory by dishonourable means, and if you find truth you will become invincible.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "Through meditation and by giving full attention to one thing at a time, we can learn to direct attention where we choose.",
"quoteAuthor": "Eknath Easwaran"
}, {
"quoteText": "Though no one can go back and make a brand new start, anyone can start from now and make a brand new ending.",
"quoteAuthor": ""
}, {
"quoteText": "If we are facing in the right direction, all we have to do is keep on walking.",
"quoteAuthor": ""
}, {
"quoteText": "We could never learn to be brave and patient if there were only joy in the world.",
"quoteAuthor": "Helen Keller"
}, {
"quoteText": "What is new in the world? Nothing. What is old in the world? Nothing. Everything has always been and will always be.",
"quoteAuthor": "Sai Baba"
}, {
"quoteText": "If it is not right do not do it; if it is not true do not say it.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "You cannot find yourself by going into the past. You can find yourself by coming into the present.",
"quoteAuthor": "Eckhart Tolle"
}, {
"quoteText": "The truth of the matter is that you always know the right thing to do. The hard part is doing it.",
"quoteAuthor": "Norman Schwarzkopf"
}, {
"quoteText": "Let us revere, let us worship, but erect and open-eyed, the highest, not the lowest; the future, not the past!",
"quoteAuthor": "Charlotte Gilman"
}, {
"quoteText": "Some people thrive on huge, dramatic change. Some people prefer the slow and steady route. Do what's right for you.",
"quoteAuthor": "Julie Morgenstern"
}, {
"quoteText": "Man is equally incapable of seeing the nothingness from which he emerges and the infinity in which he is engulfed.",
"quoteAuthor": "Blaise Pascal"
}, {
"quoteText": "Arrogance and rudeness are training wheels on the bicycle of life � for weak people who cannot keep their balance without them.",
"quoteAuthor": "Laura Teresa Marquez"
}, {
"quoteText": "Nothing is predestined: The obstacles of your past can become the gateways that lead to new beginnings.",
"quoteAuthor": "Ralph Blum"
}, {
"quoteText": "If you are patient in one moment of anger, you will escape one hundred days of sorrow.",
"quoteAuthor": "Chinese proverb"
}, {
"quoteText": "To speak gratitude is courteous and pleasant, to enact gratitude is generous and noble, but to live gratitude is to touch Heaven.",
"quoteAuthor": "Johannes Gaertner"
}, {
"quoteText": "When you have got an elephant by the hind legs and he is trying to run away, it's best to let him run.",
"quoteAuthor": "Abraham Lincoln"
}, {
"quoteText": "Courage is not about taking risks unknowingly but putting your own being in front of challenges that others may not be able to.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "The truth of the matter is that you always know the right thing to do. The hard part is doing it.",
"quoteAuthor": "Norman Schwarzkopf"
}, {
"quoteText": "Can miles truly separate you from friends... If you want to be with someone you love, aren't you already there?",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "Arrogance and rudeness are training wheels on the bicycle of life � for weak people who cannot keep their balance without them.",
"quoteAuthor": "Laura Teresa Marquez"
}, {
"quoteText": "One must be fond of people and trust them if one is not to make a mess of life.",
"quoteAuthor": "E. M. Forster"
}, {
"quoteText": "The poor man is not he who is without a cent, but he who is without a dream.",
"quoteAuthor": "Harry Kemp"
}, {
"quoteText": "A subtle thought that is in error may yet give rise to fruitful inquiry that can establish truths of great value.",
"quoteAuthor": "Isaac Asimov"
}, {
"quoteText": "The greatest good you can do for another is not just share your riches, but reveal to them their own.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "Do not dwell in the past, do not dream of the future, concentrate the mind on the present moment.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "If you're walking down the right path and you're willing to keep walking, eventually you'll make progress.",
"quoteAuthor": "Barack Obama"
}, {
"quoteText": "Money was never a big motivation for me, except as a way to keep score. The real excitement is playing the game.",
"quoteAuthor": "Donald Trump"
}, {
"quoteText": "Peace of mind is not the absence of conflict from life, but the ability to cope with it.",
"quoteAuthor": ""
}, {
"quoteText": "I am a man of fixed and unbending principles, the first of which is to be flexible at all times.",
"quoteAuthor": "Everett Dirksen"
}, {
"quoteText": "When it is obvious that the goals cannot be reached, don't adjust the goals, adjust the action steps.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Transformation doesn't take place with a vacuum; instead, it occurs when we are indirectly and directly connected to all those around us.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Face your deficiencies and acknowledge them; but do not let them master you. Let them teach you patience, sweetness, insight.",
"quoteAuthor": "Helen Keller"
}, {
"quoteText": "To give hope to someone occurs when you teach them how to use the tools to do it for themselves.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "There is no duty we so underrate as the duty of being happy. By being happy we sow anonymous benefits upon the world.",
"quoteAuthor": "Robert Louis Stevenson"
}, {
"quoteText": "Change is the law of life. And those who look only to the past or present are certain to miss the future.",
"quoteAuthor": "John Kennedy"
}, {
"quoteText": "You have power over your mind � not outside events. Realize this, and you will find strength.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "Silences make the real conversations between friends. Not the saying but the never needing to say is what counts.",
"quoteAuthor": "Margaret Runbeck"
}, {
"quoteText": "Something opens our wings. Something makes boredom and hurt disappear. Someone fills the cup in front of us: We taste only sacredness.",
"quoteAuthor": "Rumi"
}, {
"quoteText": "A good teacher is like a candle � it consumes itself to light the way for others.",
"quoteAuthor": ""
}, {
"quoteText": "There are two primary choices in life: to accept conditions as they exist, or accept responsibility for changing them.",
"quoteAuthor": "Denis Waitley"
}, {
"quoteText": "The greatest good you can do for another is not just to share your riches but to reveal to him his own.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "To be beautiful means to be yourself. You don�t need to be accepted by others. You need to accept yourself.",
"quoteAuthor": "Thich Nhat Hanh"
}, {
"quoteText": "Intuition is the supra-logic that cuts out all the routine processes of thought and leaps straight from the problem to the answer.",
"quoteAuthor": "Robert Graves"
}, {
"quoteText": "Let me tell you the secret that has led me to my goal: my strength lies solely in my tenacity.",
"quoteAuthor": "Louis Pasteur"
}, {
"quoteText": "One secret of success in life is for a man to be ready for his opportunity when it comes.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "We are what we think. All that we are arises with our thoughts. With our thoughts, we make the world.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "He that respects himself is safe from others; he wears a coat of mail that none can pierce.",
"quoteAuthor": "Henry Longfellow"
}, {
"quoteText": "Bodily exercise, when compulsory, does no harm to the body; but knowledge which is acquired under compulsion obtains no hold on the mind.",
"quoteAuthor": "Plato"
}, {
"quoteText": "I cannot always control what goes on outside. But I can always control what goes on inside.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "The smallest flower is a thought, a life answering to some feature of the Great Whole, of whom they have a persistent intuition.",
"quoteAuthor": "Honore de Balzac"
}, {
"quoteText": "Appreciation can make a day, even change a life. Your willingness to put it into words is all that is necessary.",
"quoteAuthor": "Margaret Cousins"
}, {
"quoteText": "What matters is the value we've created in our lives, the people we've made happy and how much we've grown as people.",
"quoteAuthor": "Daisaku Ikeda"
}, {
"quoteText": "We cannot change our memories, but we can change their meaning and the power they have over us.",
"quoteAuthor": "David Seamans"
}, {
"quoteText": "When you are offended at any man's fault, turn to yourself and study your own failings. Then you will forget your anger.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "Everyone has been made for some particular work, and the desire for that work has been put in every heart.",
"quoteAuthor": "Rumi"
}, {
"quoteText": "To free us from the expectations of others, to give us back to ourselves � there lies the great, singular power of self-respect.",
"quoteAuthor": "Joan Didion"
}, {
"quoteText": "At the center of your being you have the answer; you know who you are and you know what you want.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Life is a gift, and it offers us the privilege, opportunity, and responsibility to give something back by becoming more",
"quoteAuthor": "Anthony Robbins"
}, {
"quoteText": "There is no retirement for an artist, it's your way of living so there is no end to it.",
"quoteAuthor": "Henry Moore"
}, {
"quoteText": "Do not go where the path may lead, go instead where there is no path and leave a trail.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Take time to deliberate, but when the time for action has arrived, stop thinking and go in.",
"quoteAuthor": "Napoleon Bonaparte"
}, {
"quoteText": "Though no one can go back and make a brand new start, anyone can start from now and make a brand new ending.",
"quoteAuthor": ""
}, {
"quoteText": "When one tugs at a single thing in nature, he finds it attached to the rest of the world.",
"quoteAuthor": "John Muir"
}, {
"quoteText": "The happiness of a man in this life does not consist in the absence but in the mastery of his passions.",
"quoteAuthor": "Alfred Tennyson"
}, {
"quoteText": "When you have got an elephant by the hind legs and he is trying to run away, it's best to let him run.",
"quoteAuthor": "Abraham Lincoln"
}, {
"quoteText": "With realization of ones own potential and self-confidence in ones ability, one can build a better world.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Do you want to know who you are? Don't ask. Act! Action will delineate and define you.",
"quoteAuthor": "Thomas Jefferson"
}, {
"quoteText": "The greatest good you can do for another is not just to share your riches but to reveal to him his own.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "The only difference between your abilities and others is the ability to put yourself in their shoes and actually try.",
"quoteAuthor": "Leonardo Ruiz"
}, {
"quoteText": "To free us from the expectations of others, to give us back to ourselves � there lies the great, singular power of self-respect.",
"quoteAuthor": "Joan Didion"
}, {
"quoteText": "You can only grow if you're willing to feel awkward and uncomfortable when you try something new.",
"quoteAuthor": "Brian Tracy"
}, {
"quoteText": "The only thing to do with good advice is to pass it on. It is never of any use to oneself.",
"quoteAuthor": "Oscar Wilde"
}, {
"quoteText": "If you love someone, set them free. If they come back they're yours; if they don't they never were.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "Happiness is not in the mere possession of money; it lies in the joy of achievement, in the thrill of creative effort.",
"quoteAuthor": "Franklin Roosevelt"
}, {
"quoteText": "A life spent making mistakes is not only more honourable but more useful than a life spent in doing nothing.",
"quoteAuthor": "Bernard Shaw"
}, {
"quoteText": "Sadness may be part of life but there is no need to let it dominate your entire life.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "You cannot make yourself feel something you do not feel, but you can make yourself do right in spite of your feelings.",
"quoteAuthor": "Pearl Buck"
}, {
"quoteText": "Those who are blessed with the most talent don't necessarily outperform everyone else. It's the people with follow-through who excel.",
"quoteAuthor": "Mary Kay Ash"
}, {
"quoteText": "Try not to become a man of success, but rather try to become a man of value.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "All difficult things have their origin in that which is easy, and great things in that which is small.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Men of perverse opinion do not know the excellence of what is in their hands, till some one dash it from them.",
"quoteAuthor": "Sophocles"
}, {
"quoteText": "We never understand how little we need in this world until we know the loss of it.",
"quoteAuthor": "James Barrie"
}, {
"quoteText": "If you must tell me your opinions, tell me what you believe in. I have plenty of douts of my own.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "It is not enough to have a good mind; the main thing is to use it well.",
"quoteAuthor": "Rene Descartes"
}, {
"quoteText": "Aerodynamically the bumblebee shouldn't be able to fly, but the bumblebee doesn't know that so it goes on flying anyway.",
"quoteAuthor": "Mary Kay Ash"
}, {
"quoteText": "To be beautiful means to be yourself. You don�t need to be accepted by others. You need to accept yourself.",
"quoteAuthor": "Thich Nhat Hanh"
}, {
"quoteText": "Keeping a little ahead of conditions is one of the secrets of business, the trailer seldom goes far.",
"quoteAuthor": "Charles Schwab"
}, {
"quoteText": "Do you want to know who you are? Don't ask. Act! Action will delineate and define you.",
"quoteAuthor": "Thomas Jefferson"
}, {
"quoteText": "Always be yourself, express yourself, have faith in yourself, do not go out and look for a successful personality and duplicate it.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "All our knowledge begins with the senses, proceeds then to the understanding, and ends with reason. There is nothing higher than reason.",
"quoteAuthor": "Immanuel Kant"
}, {
"quoteText": "Responsibility is not inherited, it is a choice that everyone needs to make at some point in their life.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Remember always that you not only have the right to be an individual, you have an obligation to be one.",
"quoteAuthor": "Eleanor Roosevelt"
}, {
"quoteText": "It is only with the heart that one can see rightly, what is essential is invisible to the eye.",
"quoteAuthor": "Antoine de Saint-Exupery"
}, {
"quoteText": "When you begin to touch your heart or let your heart be touched, you begin to discover that it's bottomless.",
"quoteAuthor": "Pema Chodron"
}, {
"quoteText": "Never do things others can do and will do, if there are things others cannot do or will not do.",
"quoteAuthor": "Amelia Earhart"
}, {
"quoteText": "I will not be concerned at other men is not knowing me;I will be concerned at my own want of ability.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "I can't change the direction of the wind, but I can adjust my sails to always reach my destination.",
"quoteAuthor": "Jimmy Dean"
}, {
"quoteText": "If we could learn to like ourselves, even a little, maybe our cruelties and angers might melt away.",
"quoteAuthor": "John Steinbeck"
}, {
"quoteText": "What we think determines what happens to us, so if we want to change our lives, we need to stretch our minds.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "People of mediocre ability sometimes achieve outstanding success because they don't know when to quit. Most men succeed because they are determined to.",
"quoteAuthor": "George Allen"
}, {
"quoteText": "Every time you smile at someone, it is an action of love, a gift to that person, a beautiful thing.",
"quoteAuthor": "Mother Teresa"
}, {
"quoteText": "A fine quotation is a diamond on the finger of a man of wit, and a pebble in the hand of a fool.",
"quoteAuthor": "Joseph Roux"
}, {
"quoteText": "I cannot always control what goes on outside. But I can always control what goes on inside.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Life's challenges are not supposed to paralyse you, they're supposed to help you discover who you are.",
"quoteAuthor": "Bernice Reagon"
}, {
"quoteText": "If you accept the expectations of others, especially negative ones, then you never will change the outcome.",
"quoteAuthor": "Michael Jordan"
}, {
"quoteText": "Life is like a sewer. What you get out of it depends on what you put into it.",
"quoteAuthor": "Tom Lehrer"
}, {
"quoteText": "You can be what you want to be. You have the power within and we will help you always.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "If the stars should appear but one night every thousand years how man would marvel and adore.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "The greatest way to live with honour in this world is to be what we pretend to be.",
"quoteAuthor": "Socrates"
}, {
"quoteText": "To exist is to change, to change is to mature, to mature is to go on creating oneself endlessly.",
"quoteAuthor": "Henri Bergson"
}, {
"quoteText": "You can adopt the attitude there is nothing you can do, or you can see the challenge as your call to action.",
"quoteAuthor": "Catherine Pulsifer"
}, {
"quoteText": "True silence is the rest of the mind; it is to the spirit what sleep is to the body, nourishment and refreshment.",
"quoteAuthor": "William Penn"
}, {
"quoteText": "A life spent making mistakes is not only more honourable but more useful than a life spent in doing nothing.",
"quoteAuthor": "Bernard Shaw"
}, {
"quoteText": "All our knowledge begins with the senses, proceeds then to the understanding, and ends with reason. There is nothing higher than reason.",
"quoteAuthor": "Immanuel Kant"
}, {
"quoteText": "Try not to become a man of success but rather try to become a man of value.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "Something opens our wings. Something makes boredom and hurt disappear. Someone fills the cup in front of us: We taste only sacredness.",
"quoteAuthor": "Rumi"
}, {
"quoteText": "You can't create in a vacuum. Life gives you the material and dreams can propel new beginnings.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "A true friend is the most precious of all possessions and the one we take the least thought about acquiring.",
"quoteAuthor": "Francois de La Rochefoucauld"
}, {
"quoteText": "It is more important to know where you are going than to get there quickly. Do not mistake activity for achievement.",
"quoteAuthor": "Mabel Newcomber"
}, {
"quoteText": "Your work is to discover your world and then with all your heart give yourself to it.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Arrogance and rudeness are training wheels on the bicycle of life � for weak people who cannot keep their balance without them.",
"quoteAuthor": "Laura Teresa Marquez"
}, {
"quoteText": "I find hope in the darkest of days, and focus in the brightest. I do not judge the universe.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "We cannot change our memories, but we can change their meaning and the power they have over us.",
"quoteAuthor": "David Seamans"
}, {
"quoteText": "The possession of knowledge does not kill the sense of wonder and mystery. There is always more mystery.",
"quoteAuthor": "Anais Nin"
}, {
"quoteText": "One does not discover new lands without consenting to lose sight of the shore for a very long time.",
"quoteAuthor": "Andr� Gide"
}, {
"quoteText": "The person who lives life fully, glowing with life's energy, is the person who lives a successful life.",
"quoteAuthor": "Daisaku Ikeda"
}, {
"quoteText": "Man is equally incapable of seeing the nothingness from which he emerges and the infinity in which he is engulfed.",
"quoteAuthor": "Blaise Pascal"
}, {
"quoteText": "Don't turn away from possible futures before you're certain you don't have anything to learn from them.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "Aerodynamically the bumblebee shouldn't be able to fly, but the bumblebee doesn't know that so it goes on flying anyway.",
"quoteAuthor": "Mary Kay Ash"
}, {
"quoteText": "Some people thrive on huge, dramatic change. Some people prefer the slow and steady route. Do what's right for you.",
"quoteAuthor": "Julie Morgenstern"
}, {
"quoteText": "A successful person is one who can lay a firm foundation with the bricks that others throw at him or her.",
"quoteAuthor": "David Brinkley"
}, {
"quoteText": "A wise man can learn more from a foolish question than a fool can learn from a wise answer.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "All that we are is the result of what we have thought. The mind is everything. What we think we become.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Work while you have the light. You are responsible for the talent that has been entrusted to you.",
"quoteAuthor": "Henri-Frederic Amiel"
}, {
"quoteText": "A life spent making mistakes is not only more honourable but more useful than a life spent in doing nothing.",
"quoteAuthor": "Bernard Shaw"
}, {
"quoteText": "A true friend is the most precious of all possessions and the one we take the least thought about acquiring.",
"quoteAuthor": "Francois de La Rochefoucauld"
}, {
"quoteText": "How far that little candle throws its beams! So shines a good deed in a naughty world.",
"quoteAuthor": "William Shakespeare"
}, {
"quoteText": "Every adversity, every failure, every heartache carries with it the seed of an equal or greater benefit.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "If your actions inspire others to dream more, learn more, do more and become more, you are a leader.",
"quoteAuthor": "John Quincy Adams"
}, {
"quoteText": "Fear is a darkroom where negatives develop.",
"quoteAuthor": "Usman Asif"
}, {
"quoteText": "It is in your moments of decision that your destiny is shaped.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "Those who are free of resentful thoughts surely find peace.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Blaze with the fire that is never extinguished.",
"quoteAuthor": "Luisa Sigea"
}, {
"quoteText": "An obstacle may be either a stepping stone or a stumbling block.",
"quoteAuthor": ""
}, {
"quoteText": "The pain passes, but the beauty remains.",
"quoteAuthor": "Pierre Auguste Renoir"
}, {
"quoteText": "All I can say about life is, Oh God, enjoy it!",
"quoteAuthor": "Bob Newhart"
}, {
"quoteText": "Creativity comes from trust. Trust your instincts. And never hope more than you work.",
"quoteAuthor": "Rita Mae Brown"
}, {
"quoteText": "Love doesn't make the world go round, love is what makes the ride worthwhile.",
"quoteAuthor": "Elizabeth Browning"
}, {
"quoteText": "Your outlook on life is a direct reflection on how much you like yourself.",
"quoteAuthor": "Lululemon"
}, {
"quoteText": "I have just three things to teach: simplicity, patience, compassion. These three are your greatest treasures.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "You won't skid if you stay in a rut.",
"quoteAuthor": "Kin Hubbard"
}, {
"quoteText": "You block your dream when you allow your fear to grow bigger than your faith.",
"quoteAuthor": "Mary Morrissey"
}, {
"quoteText": "Happiness depends upon ourselves.",
"quoteAuthor": "Aristotle"
}, {
"quoteText": "Tension is who you think you should be. Relaxation is who you are.",
"quoteAuthor": "Chinese proverb"
}, {
"quoteText": "Wherever a man turns he can find someone who needs him.",
"quoteAuthor": "Albert Schweitzer"
}, {
"quoteText": "If one is lucky, a solitary fantasy can totally transform one million realities.",
"quoteAuthor": "Maya Angelou"
}, {
"quoteText": "The years teach much which the days never know.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Never idealize others. They will never live up to your expectations.",
"quoteAuthor": "Leo Buscaglia"
}, {
"quoteText": "The only limit to our realization of tomorrow will be our doubts of today.",
"quoteAuthor": "Franklin Roosevelt"
}, {
"quoteText": "He who is contented is rich.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "When you realize there is nothing lacking, the whole world belongs to you.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "No man was ever wise by chance.",
"quoteAuthor": "Seneca"
}, {
"quoteText": "The more you know yourself, the more you forgive yourself.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Trust yourself. You know more than you think you do.",
"quoteAuthor": "Benjamin Spock"
}, {
"quoteText": "Time you enjoy wasting, was not wasted.",
"quoteAuthor": "John Lennon"
}, {
"quoteText": "Happiness is not something ready made. It comes from your own actions.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Meaning is not what you start with but what you end up with.",
"quoteAuthor": "Peter Elbow"
}, {
"quoteText": "No one has ever become poor by giving.",
"quoteAuthor": "Anne Frank"
}, {
"quoteText": "Be faithful in small things because it is in them that your strength lies.",
"quoteAuthor": "Mother Teresa"
}, {
"quoteText": "What you do not want done to yourself, do not do to others.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Each misfortune you encounter will carry in it the seed of tomorrows good luck.",
"quoteAuthor": "Og Mandino"
}, {
"quoteText": "All is flux; nothing stays still.",
"quoteAuthor": "Heraclitus"
}, {
"quoteText": "He who is fixed to a star does not change his mind.",
"quoteAuthor": "Leonardo da Vinci"
}, {
"quoteText": "He who lives in harmony with himself lives in harmony with the universe.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "Ignorant men don't know what good they hold in their hands until they've flung it away.",
"quoteAuthor": "Sophocles"
}, {
"quoteText": "When the solution is simple, God is answering.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "All achievements, all earned riches, have their beginning in an idea.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Do not turn back when you are just at the goal.",
"quoteAuthor": "Publilius Syrus"
}, {
"quoteText": "You can't trust without risk but neither can you live in a cocoon.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "All perceiving is also thinking, all reasoning is also intuition, all observation is also invention.",
"quoteAuthor": "Rudolf Arnheim"
}, {
"quoteText": "Error is discipline through which we advance.",
"quoteAuthor": "Channing"
}, {
"quoteText": "The truth is always exciting. Speak it, then. Life is dull without it.",
"quoteAuthor": "Pearl Buck"
}, {
"quoteText": "What worries you masters you.",
"quoteAuthor": "Haddon Robinson"
}, {
"quoteText": "The worst bankrupt in the world is the person who has lost his enthusiasm.",
"quoteAuthor": "H. W. Arnold"
}, {
"quoteText": "The superior man is modest in his speech, but exceeds in his actions.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "The longer we dwell on our misfortunes, the greater is their power to harm us.",
"quoteAuthor": "Voltaire"
}, {
"quoteText": "Those who will play with cats must expect to be scratched.",
"quoteAuthor": "Cervantes"
}, {
"quoteText": "I've never seen a smiling face that was not beautiful.",
"quoteAuthor": ""
}, {
"quoteText": "In all things of nature there is something of the marvellous.",
"quoteAuthor": "Aristotle"
}, {
"quoteText": "Life isn't about finding yourself. Life is about creating yourself.",
"quoteAuthor": "Bernard Shaw"
}, {
"quoteText": "The universe is transformation; our life is what our thoughts make it.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "Memory is the mother of all wisdom.",
"quoteAuthor": "Samuel Johnson"
}, {
"quoteText": "Silence is the true friend that never betrays.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "You might well remember that nothing can bring you success but yourself.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Watch the little things; a small leak will sink a great ship.",
"quoteAuthor": "Benjamin Franklin"
}, {
"quoteText": "God has given you one face, and you make yourself another.",
"quoteAuthor": "William Shakespeare"
}, {
"quoteText": "All perceiving is also thinking, all reasoning is also intuition, all observation is also invention.",
"quoteAuthor": "Rudolf Arnheim"
}, {
"quoteText": "The more you know yourself, the more you forgive yourself.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Efficiency is doing things right; effectiveness is doing the right things.",
"quoteAuthor": "Peter Drucker"
}, {
"quoteText": "To be wronged is nothing unless you continue to remember it.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Kindness is the greatest wisdom.",
"quoteAuthor": ""
}, {
"quoteText": "Action will remove the doubts that theory cannot solve.",
"quoteAuthor": "Tehyi Hsieh"
}, {
"quoteText": "Don't miss all the beautiful colors of the rainbow looking for that pot of gold.",
"quoteAuthor": ""
}, {
"quoteText": "Your big opportunity may be right where you are now.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Kindness is the greatest wisdom.",
"quoteAuthor": ""
}, {
"quoteText": "People who say it cannot be done should not interrupt those who are doing it.",
"quoteAuthor": "Chinese proverb"
}, {
"quoteText": "The day you decide to do it is your lucky day.",
"quoteAuthor": "Japanese proverb"
}, {
"quoteText": "We must not say every mistake is a foolish one.",
"quoteAuthor": "Cicero"
}, {
"quoteText": "Imagination is the highest kite one can fly.",
"quoteAuthor": "Lauren Bacall"
}, {
"quoteText": "Every action of our lives touches on some chord that will vibrate in eternity.",
"quoteAuthor": "Edwin Chapin"
}, {
"quoteText": "Accept challenges, so that you may feel the exhilaration of victory.",
"quoteAuthor": "George Patton"
}, {
"quoteText": "It is better to understand a little than to misunderstand a lot.",
"quoteAuthor": "Anatole France"
}, {
"quoteText": "You don't drown by falling in water. You drown by staying there.",
"quoteAuthor": ""
}, {
"quoteText": "Never be afraid to try, remember... Amateurs built the ark, Professionals built the Titanic.",
"quoteAuthor": ""
}, {
"quoteText": "Correction does much, but encouragement does more.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "Know, first, who you are, and then adorn yourself accordingly.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "The biggest adventure you can ever take is to live the life of your dreams.",
"quoteAuthor": "Oprah Winfrey"
}, {
"quoteText": "The pain passes, but the beauty remains.",
"quoteAuthor": "Pierre Auguste Renoir"
}, {
"quoteText": "The cause is hidden. The effect is visible to all.",
"quoteAuthor": "Ovid"
}, {
"quoteText": "You will not be punished for your anger, you will be punished by your anger.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Time you enjoy wasting, was not wasted.",
"quoteAuthor": "John Lennon"
}, {
"quoteText": "Happiness is not something ready made. It comes from your own actions.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Don't miss all the beautiful colors of the rainbow looking for that pot of gold.",
"quoteAuthor": ""
}, {
"quoteText": "Life is 10% what happens to you and 90% how you react to it.",
"quoteAuthor": "Charles Swindoll"
}, {
"quoteText": "We all have problems. The way we solve them is what makes us different.",
"quoteAuthor": ""
}, {
"quoteText": "An obstacle may be either a stepping stone or a stumbling block.",
"quoteAuthor": ""
}, {
"quoteText": "To want to be what one can be is purpose in life.",
"quoteAuthor": "Cynthia Ozick"
}, {
"quoteText": "The future belongs to those who believe in the beauty of their dreams.",
"quoteAuthor": "Eleanor Roosevelt"
}, {
"quoteText": "Remember that sometimes not getting what you want is a wonderful stroke of luck.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Truth is powerful and it prevails.",
"quoteAuthor": "Sojourner Truth"
}, {
"quoteText": "History will be kind to me for I intend to write it.",
"quoteAuthor": "Winston Churchill"
}, {
"quoteText": "Short words are best and the old words when short are best of all.",
"quoteAuthor": "Winston Churchill"
}, {
"quoteText": "Our lives are a sum total of the choices we have made.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Time stays long enough for anyone who will use it.",
"quoteAuthor": "Leonardo da Vinci"
}, {
"quoteText": "Each day provides its own gifts.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "You have enemies? Good. That means you've stood up for something, sometime in your life.",
"quoteAuthor": "Winston Churchill"
}, {
"quoteText": "If you light a lamp for somebody, it will also brighten your path.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Never tell me the sky�s the limit when there are footprints on the moon.",
"quoteAuthor": ""
}, {
"quoteText": "You must welcome change as the rule but not as your ruler.",
"quoteAuthor": "Denis Waitley"
}, {
"quoteText": "Give whatever you are doing and whoever you are with the gift of your attention.",
"quoteAuthor": "Jim Rohn"
}, {
"quoteText": "Always be smarter than the people who hire you.",
"quoteAuthor": "Lena Horne"
}, {
"quoteText": "We do what we do because we believe.",
"quoteAuthor": ""
}, {
"quoteText": "Formula for success: under promise and over deliver.",
"quoteAuthor": "Tom Peters"
}, {
"quoteText": "The eye sees only what the mind is prepared to comprehend.",
"quoteAuthor": "Henri Bergson"
}, {
"quoteText": "You can't stop the waves, but you can learn to surf.",
"quoteAuthor": "Jon Kabat-Zinn"
}, {
"quoteText": "Some people think it's holding that makes one strong � sometimes it's letting go.",
"quoteAuthor": ""
}, {
"quoteText": "Genius is one percent inspiration and ninety-nine percent perspiration.",
"quoteAuthor": "Thomas Edison"
}, {
"quoteText": "People seldom notice old clothes if you wear a big smile.",
"quoteAuthor": "Lee Mildon"
}, {
"quoteText": "The more light you allow within you, the brighter the world you live in will be.",
"quoteAuthor": "Shakti Gawain"
}, {
"quoteText": "Nothing diminishes anxiety faster than action.",
"quoteAuthor": "Walter Anderson"
}, {
"quoteText": "Man cannot discover new oceans unless he has the courage to lose sight of the shore.",
"quoteAuthor": "Andr� Gide"
}, {
"quoteText": "Everything that irritates us about others can lead us to an understanding about ourselves.",
"quoteAuthor": "Carl Jung"
}, {
"quoteText": "Never mistake activity for achievement.",
"quoteAuthor": "John Wooden"
}, {
"quoteText": "Fortune favours the brave.",
"quoteAuthor": "Virgil"
}, {
"quoteText": "Can you imagine what I would do if I could do all I can?",
"quoteAuthor": "Sun Tzu"
}, {
"quoteText": "Remember that sometimes not getting what you want is a wonderful stroke of luck.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Practice yourself, for heavens sake in little things, and then proceed to greater.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "Ignorance never settle a question.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "The awareness of our own strength makes us modest.",
"quoteAuthor": "Paul Cezanne"
}, {
"quoteText": "The journey of a thousand miles begins with one step.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "They must often change, who would be constant in happiness or wisdom.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "There are no failures. Just experiences and your reactions to them.",
"quoteAuthor": "Tom Krause"
}, {
"quoteText": "Your future depends on many things, but mostly on you.",
"quoteAuthor": "Frank Tyger"
}, {
"quoteText": "Fear grows in darkness; if you think theres a bogeyman around, turn on the light.",
"quoteAuthor": "Dorothy Thompson"
}, {
"quoteText": "If you surrender to the wind, you can ride it.",
"quoteAuthor": "Toni Morrison"
}, {
"quoteText": "The most important point is to accept yourself and stand on your two feet.",
"quoteAuthor": "Shunryu Suzuki"
}, {
"quoteText": "It is better to understand a little than to misunderstand a lot.",
"quoteAuthor": "Anatole France"
}, {
"quoteText": "If we did the things we are capable of, we would astound ourselves.",
"quoteAuthor": "Thomas Edison"
}, {
"quoteText": "Do not expect the world to look bright, if you habitually wear gray-brown glasses.",
"quoteAuthor": "Tomas Eliot"
}, {
"quoteText": "More often than not, anger is actually an indication of weakness rather than of strength.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "We must not say every mistake is a foolish one.",
"quoteAuthor": "Cicero"
}, {
"quoteText": "The superior man is modest in his speech, but exceeds in his actions.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "As long as your going to be thinking anyway, think big.",
"quoteAuthor": "Donald Trump"
}, {
"quoteText": "Without some goals and some efforts to reach it, no man can live.",
"quoteAuthor": "John Dewey"
}, {
"quoteText": "He who obtains has little. He who scatters has much.",
"quoteAuthor": "Richard Braunstein"
}, {
"quoteText": "Wherever a man turns he can find someone who needs him.",
"quoteAuthor": "Albert Schweitzer"
}, {
"quoteText": "Myths which are believed in tend to become true.",
"quoteAuthor": "George Orwell"
}, {
"quoteText": "If the shoe doesn't fit, must we change the foot?",
"quoteAuthor": "Gloria Steinem"
}, {
"quoteText": "Love all, trust a few, do wrong to none.",
"quoteAuthor": "William Shakespeare"
}, {
"quoteText": "Those who will play with cats must expect to be scratched.",
"quoteAuthor": "Cervantes"
}, {
"quoteText": "You have to do your own growing no matter how tall your grandfather was.",
"quoteAuthor": "Abraham Lincoln"
}, {
"quoteText": "To be upset over what you don't have is to waste what you do have.",
"quoteAuthor": "Ken S. Keyes"
}, {
"quoteText": "The foot feels the foot when it feels the ground.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Not what we have but what we enjoy constitutes our abundance.",
"quoteAuthor": "John Petit-Senn"
}, {
"quoteText": "We should all be thankful for those people who rekindle the inner spirit.",
"quoteAuthor": "Albert Schweitzer"
}, {
"quoteText": "Opportunity is missed by most because it is dressed in overalls and looks like work.",
"quoteAuthor": "Thomas Edison"
}, {
"quoteText": "Successful people ask better questions, and as a result, they get better answers.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "It is never too late to be what you might have been.",
"quoteAuthor": "George Eliot"
}, {
"quoteText": "The beginning is always today.",
"quoteAuthor": "Mary Wollstonecraft"
}, {
"quoteText": "Sadness flies away on the wings of time.",
"quoteAuthor": "Jean de la Fontaine"
}, {
"quoteText": "In the long run we get no more than we have been willing to risk giving.",
"quoteAuthor": "Sheldon Kopp"
}, {
"quoteText": "Self-trust is the first secret of success.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Without some goals and some efforts to reach it, no man can live.",
"quoteAuthor": "John Dewey"
}, {
"quoteText": "So long as a person is capable of self-renewal they are a living being.",
"quoteAuthor": "Henri-Frederic Amiel"
}, {
"quoteText": "Don't look back. Something might be gaining on you.",
"quoteAuthor": "Satchel Paige"
}, {
"quoteText": "From error to error one discovers the entire truth.",
"quoteAuthor": "Sigmund Freud"
}, {
"quoteText": "They must often change, who would be constant in happiness or wisdom.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Many of life's failures are people who did not realize how close they were to success when they gave up.",
"quoteAuthor": "Thomas Edison"
}, {
"quoteText": "Learn all you can from the mistakes of others. You won't have time to make them all yourself.",
"quoteAuthor": "Alfred Sheinwold"
}, {
"quoteText": "Nothing is predestined: The obstacles of your past can become the gateways that lead to new beginnings.",
"quoteAuthor": "Ralph Blum"
}, {
"quoteText": "The greatest way to live with honour in this world is to be what we pretend to be.",
"quoteAuthor": "Socrates"
}, {
"quoteText": "Let us be grateful to people who make us happy; they are the charming gardeners who make our souls blossom.",
"quoteAuthor": "Marcel Proust"
}, {
"quoteText": "Look back over the past, with its changing empires that rose and fell, and you can foresee the future, too.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "All our knowledge begins with the senses, proceeds then to the understanding, and ends with reason. There is nothing higher than reason.",
"quoteAuthor": "Immanuel Kant"
}, {
"quoteText": "Though no one can go back and make a brand new start, anyone can start from now and make a brand new ending.",
"quoteAuthor": ""
}, {
"quoteText": "If it is not right do not do it; if it is not true do not say it.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "Happiness is not in the mere possession of money; it lies in the joy of achievement, in the thrill of creative effort.",
"quoteAuthor": "Franklin Roosevelt"
}, {
"quoteText": "A life spent making mistakes is not only more honourable, but more useful than a life spent doing nothing.",
"quoteAuthor": "George Bernard Shaw"
}, {
"quoteText": "Never doubt that a small group of thoughtful, committed people can change the world. Indeed. It is the only thing that ever has.",
"quoteAuthor": "Margaret Mead"
}, {
"quoteText": "When you have got an elephant by the hind legs and he is trying to run away, it's best to let him run.",
"quoteAuthor": "Abraham Lincoln"
}, {
"quoteText": "Men are disturbed not by things, but by the view which they take of them.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "Imagination disposes of everything; it creates beauty, justice, and happiness, which are everything in this world.",
"quoteAuthor": "Blaise Pascal"
}, {
"quoteText": "Being in humaneness is good. If we select other goodness and thus are far apart from humaneness, how can we be the wise?",
"quoteAuthor": "Confucius"
}, {
"quoteText": "People of mediocre ability sometimes achieve outstanding success because they don't know when to quit. Most men succeed because they are determined to.",
"quoteAuthor": "George Allen"
}, {
"quoteText": "Happiness is a Swedish sunset � it is there for all, but most of us look the other way and lose it.",
"quoteAuthor": "Mark Twain"
}, {
"quoteText": "A smile is a light in the window of your face to show your heart is at home.",
"quoteAuthor": ""
}, {
"quoteText": "The greatest good you can do for another is not just to share your riches but to reveal to him his own.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "The person who lives life fully, glowing with life's energy, is the person who lives a successful life.",
"quoteAuthor": "Daisaku Ikeda"
}, {
"quoteText": "Your work is to discover your world and then with all your heart give yourself to it.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "A man may fulfil the object of his existence by asking a question he cannot answer, and attempting a task he cannot achieve.",
"quoteAuthor": "Oliver Holmes"
}, {
"quoteText": "When we seek to discover the best in others, we somehow bring out the best in ourselves.",
"quoteAuthor": "William Ward"
}, {
"quoteText": "Look forward to spring as a time when you can start to see what nature has to offer once again.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Man is equally incapable of seeing the nothingness from which he emerges and the infinity in which he is engulfed.",
"quoteAuthor": "Blaise Pascal"
}, {
"quoteText": "Trust your own instinct. Your mistakes might as well be your own, instead of someone elses.",
"quoteAuthor": "Billy Wilder"
}, {
"quoteText": "The least movement is of importance to all nature. The entire ocean is affected by a pebble.",
"quoteAuthor": "Blaise Pascal"
}, {
"quoteText": "I am always doing that which I can not do, in order that I may learn how to do it.",
"quoteAuthor": "Pablo Picasso"
}, {
"quoteText": "You are always free to change your mind and choose a different future, or a different past.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "If we have a positive mental attitude, then even when surrounded by hostility, we shall not lack inner peace.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "The grand essentials of happiness are: something to do, something to love, and something to hope for.",
"quoteAuthor": "Chalmers"
}, {
"quoteText": "Responsibility is not inherited, it is a choice that everyone needs to make at some point in their life.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "I find hope in the darkest of days, and focus in the brightest. I do not judge the universe.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Everyone can taste success when the going is easy, but few know how to taste victory when times get tough.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "There are two primary choices in life: to accept conditions as they exist, or accept responsibility for changing them.",
"quoteAuthor": "Denis Waitley"
}, {
"quoteText": "Men in general judge more from appearances than from reality. All men have eyes, but few have the gift of penetration.",
"quoteAuthor": "Niccolo Machiavelli"
}, {
"quoteText": "You may only be someone in the world, but to someone else, you may be the world.",
"quoteAuthor": ""
}, {
"quoteText": "The real measure of your wealth is how much youd be worth if you lost all your money.",
"quoteAuthor": ""
}, {
"quoteText": "Every artist dips his brush in his own soul, and paints his own nature into his pictures.",
"quoteAuthor": "Henry Ward Beecher"
}, {
"quoteText": "To keep the body in good health is a duty... otherwise we shall not be able to keep our mind strong and clear.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "A fine quotation is a diamond on the finger of a man of wit, and a pebble in the hand of a fool.",
"quoteAuthor": "Joseph Roux"
}, {
"quoteText": "It is the greatest of all mistakes to do nothing because you can only do little � do what you can.",
"quoteAuthor": "Sydney Smith"
}, {
"quoteText": "If you take each challenge one step at a time, with faith in every footstep, your strength and understanding will increase.",
"quoteAuthor": "James Faust"
}, {
"quoteText": "There is only one corner of the universe you can be certain of improving, and that's your own self.",
"quoteAuthor": "Aldous Huxley"
}, {
"quoteText": "You, yourself, as much as anybody in the entire universe, deserve your love and affection.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Happiness cannot be travelled to, owned, earned, worn or consumed. Happiness is the spiritual experience of living every minute with love, grace and gratitude.",
"quoteAuthor": "Denis Waitley"
}, {
"quoteText": "He that never changes his opinions, never corrects his mistakes, and will never be wiser on the morrow than he is today.",
"quoteAuthor": "Tryon Edwards"
}, {
"quoteText": "At the center of your being you have the answer; you know who you are and you know what you want.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "There are things so deep and complex that only intuition can reach it in our stage of development as human beings.",
"quoteAuthor": "John Astin"
}, {
"quoteText": "Until you value yourself, you won't value your time. Until you value your time, you won't do anything with it.",
"quoteAuthor": "M. Scott Peck"
}, {
"quoteText": "Responsibility is not inherited, it is a choice that everyone needs to make at some point in their life.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Everyone should carefully observe which way his heart draws him, and then choose that way with all his strength.",
"quoteAuthor": "Hasidic saying"
}, {
"quoteText": "When we quit thinking primarily about ourselves and our own self-preservation, we undergo a truly heroic transformation of consciousness.",
"quoteAuthor": "Joseph Campbell"
}, {
"quoteText": "Nothing is predestined: The obstacles of your past can become the gateways that lead to new beginnings.",
"quoteAuthor": "Ralph Blum"
}, {
"quoteText": "I cannot always control what goes on outside. But I can always control what goes on inside.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Do not give your attention to what others do or fail to do; give it to what you do or fail to do.",
"quoteAuthor": "Dhammapada"
}, {
"quoteText": "The world is round and the place which may seem like the end may also be the beginning.",
"quoteAuthor": "Ivy Baker Priest"
}, {
"quoteText": "He that never changes his opinions, never corrects his mistakes, and will never be wiser on the morrow than he is today.",
"quoteAuthor": "Tryon Edwards"
}, {
"quoteText": "Follow effective action with quiet reflection. From the quiet reflection will come even more effective action.",
"quoteAuthor": "Peter Drucker"
}, {
"quoteText": "A wise man can learn more from a foolish question than a fool can learn from a wise answer.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "Life's challenges are not supposed to paralyze you, they're supposed to help you discover who you are.",
"quoteAuthor": "Bernice Reagon"
}, {
"quoteText": "There is one thing you have got to learn about our movement. Three people are better than no people.",
"quoteAuthor": "Fannie Hamer"
}, {
"quoteText": "We never understand how little we need in this world until we know the loss of it.",
"quoteAuthor": "James Barrie"
}, {
"quoteText": "Happiness is a perfume you cannot pour on others without getting a few drops on yourself.",
"quoteAuthor": "Ralph Waldo Emerson"
}, {
"quoteText": "Cherish your visions and your dreams as they are the children of your soul, the blueprints of your ultimate achievements.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "You get peace of mind not by thinking about it or imagining it, but by quietening and relaxing the restless mind.",
"quoteAuthor": "Remez Sasson"
}, {
"quoteText": "I'm a great believer in luck and I find the harder I work, the more I have of it.",
"quoteAuthor": "Thomas Jefferson"
}, {
"quoteText": "It is the mark of an educated mind to be able to entertain a thought without accepting it.",
"quoteAuthor": "Aristotle"
}, {
"quoteText": "It is not the mistake that has the most power, instead, it is learning from the mistake to advance your own attributes.",
"quoteAuthor": "Byron Roberts"
}, {
"quoteText": "There are two primary choices in life: to accept conditions as they exist, or accept the responsibility for changing them.",
"quoteAuthor": "Denis Waitley"
}, {
"quoteText": "The amount of happiness that you have depends on the amount of freedom you have in your heart.",
"quoteAuthor": "Thich Nhat Hanh"
}, {
"quoteText": "Do not overrate what you have received, nor envy others. He who envies others does not obtain peace of mind.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "You, yourself, as much as anybody in the entire universe, deserve your love and affection.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Do not give your attention to what others do or fail to do; give it to what you do or fail to do.",
"quoteAuthor": "Dhammapada"
}, {
"quoteText": "I believe that a simple and unassuming manner of life is best for everyone, best both for the body and the mind.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "Success means having the courage, the determination, and the will to become the person you believe you were meant to be.",
"quoteAuthor": "George Sheehan"
}, {
"quoteText": "Do not be too timid and squeamish about your reactions. All life is an experiment. The more experiments you make the better.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Let me tell you the secret that has led me to my goal: my strength lies solely in my tenacity",
"quoteAuthor": "Louis Pasteur"
}, {
"quoteText": "Your vision will become clear only when you look into your heart. Who looks outside, dreams. Who looks inside, awakens.",
"quoteAuthor": "Carl Jung"
}, {
"quoteText": "Yesterday is history. Tomorrow is a mystery. And today? Today is a gift. That is why we call it the present.",
"quoteAuthor": "Babatunde Olatunji"
}, {
"quoteText": "Make the best use of what is in your power, and take the rest as it happens.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "A little more persistence, a little more effort, and what seemed hopeless failure may turn to glorious success.",
"quoteAuthor": "Elbert Hubbard"
}, {
"quoteText": "The way we communicate with others and with ourselves ultimately determines the quality of our lives.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "The greatest good you can do for another is not just to share your riches but to reveal to him his own.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "Some people thrive on huge, dramatic change. Some people prefer the slow and steady route. Do what's right for you.",
"quoteAuthor": "Julie Morgenstern"
}, {
"quoteText": "Every man takes the limits of his own field of vision for the limits of the world.",
"quoteAuthor": "Arthur Schopenhauer"
}, {
"quoteText": "Sometimes it is better to lose and do the right thing than to win and do the wrong thing.",
"quoteAuthor": "Tony Blair"
}, {
"quoteText": "If we are facing in the right direction, all we have to do is keep on walking.",
"quoteAuthor": ""
}, {
"quoteText": "I find hope in the darkest of days, and focus in the brightest. I do not judge the universe.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "I seek constantly to improve my manners and graces, for they are the sugar to which all are attracted.",
"quoteAuthor": "Og Mandino"
}, {
"quoteText": "Let us always meet each other with smile, for the smile is the beginning of love.",
"quoteAuthor": "Mother Teresa"
}, {
"quoteText": "A bend in the road is not the end of the road...unless you fail to make the turn.",
"quoteAuthor": ""
}, {
"quoteText": "I would maintain that thanks are the highest form of thought, and that gratitude is happiness doubled by wonder.",
"quoteAuthor": "G. K. Chesterton"
}, {
"quoteText": "We are what we repeatedly do. Excellence, then, is not an act, but a habit.",
"quoteAuthor": "Aristotle"
}, {
"quoteText": "Peace of mind is not the absence of conflict from life, but the ability to cope with it.",
"quoteAuthor": ""
}, {
"quoteText": "Living at risk is jumping off the cliff and building your wings on the way down.",
"quoteAuthor": "Ray Bradbury"
}, {
"quoteText": "The person born with a talent they are meant to use will find their greatest happiness in using it.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "In the depth of winter, I finally learned that there was within me an invincible summer.",
"quoteAuthor": "Albert Camus"
}, {
"quoteText": "Wit lies in recognizing the resemblance among things which differ and the difference between things which are alike.",
"quoteAuthor": "Madame de Stael"
}, {
"quoteText": "Bodily exercise, when compulsory, does no harm to the body; but knowledge which is acquired under compulsion obtains no hold on the mind.",
"quoteAuthor": "Plato"
}, {
"quoteText": "A failure is a man who has blundered but is not capable of cashing in on the experience.",
"quoteAuthor": "Elbert Hubbard"
}, {
"quoteText": "I cannot give you the formula for success, but I can give you the formula for failure: which is: Try to please everybody.",
"quoteAuthor": "Herbert Swope"
}, {
"quoteText": "I believe that a simple and unassuming manner of life is best for everyone, best both for the body and the mind.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "One who asks a question is a fool for five minutes; one who does not ask a question remains a fool forever.",
"quoteAuthor": ""
}, {
"quoteText": "The person who lives life fully, glowing with life's energy, is the person who lives a successful life.",
"quoteAuthor": "Daisaku Ikeda"
}, {
"quoteText": "The power of intuitive understanding will protect you from harm until the end of your days.",
"quoteAuthor": "Laozi"
}, {
"quoteText": "The best thing about the future is that it only comes one day at a time.",
"quoteAuthor": "Abraham Lincoln"
}, {
"quoteText": "A smile is a light in the window of your face to show your heart is at home.",
"quoteAuthor": ""
}, {
"quoteText": "There are two kinds of failures: those who thought and never did, and those who did and never thought.",
"quoteAuthor": "Laurence J. Peter"
}, {
"quoteText": "We have two ears and one mouth so that we can listen twice as much as we speak.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "Fear of failure is one attitude that will keep you at the same point in your life.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Sadness may be part of life but there is no need to let it dominate your entire life.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "By going beyond your own problems and taking care of others, you gain inner strength, self-confidence, courage, and a greater sense of calm.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Friends are those rare people who ask how we are and then wait to hear the answer.",
"quoteAuthor": "Ed Cunningham"
}, {
"quoteText": "A wise man can learn more from a foolish question than a fool can learn from a wise answer.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "I'm a great believer in luck and I find the harder I work, the more I have of it.",
"quoteAuthor": "Thomas Jefferson"
}, {
"quoteText": "I can't change the direction of the wind, but I can adjust my sails to always reach my destination.",
"quoteAuthor": "Jimmy Dean"
}, {
"quoteText": "If we learn to open our hearts, anyone, including the people who drive us crazy, can be our teacher.",
"quoteAuthor": "Pema Chodron"
}, {
"quoteText": "Everyone should carefully observe which way his heart draws him, and then choose that way with all his strength.",
"quoteAuthor": "Hasidic saying"
}, {
"quoteText": "People grow through experience if they meet life honestly and courageously. This is how character is built.",
"quoteAuthor": "Eleanor Roosevelt"
}, {
"quoteText": "A hero is no braver than an ordinary man, but he is braver five minutes longer.",
"quoteAuthor": "Ralph Waldo Emerson"
}, {
"quoteText": "While we try to teach our children all about life, our children teach us what life is all about.",
"quoteAuthor": "Angela Schwindt"
}, {
"quoteText": "If we have a positive mental attitude, then even when surrounded by hostility, we shall not lack inner peace.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "In a controversy the instant we feel anger we have already ceased striving for the truth, and have begun striving for ourselves.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Yesterday is history. Tomorrow is a mystery. And today? Today is a gift that's why they call it the present.",
"quoteAuthor": ""
}, {
"quoteText": "All difficult things have their origin in that which is easy, and great things in that which is small.",
"quoteAuthor": "Lao-Tzu"
}, {
"quoteText": "When you dance, your purpose is not to get to a certain place on the floor. It's to enjoy each step along the way.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "The only difference between your abilities and others is the ability to put yourself in their shoes and actually try.",
"quoteAuthor": "Leonardo Ruiz"
}, {
"quoteText": "The highest stage in moral ure at which we can arrive is when we recognize that we ought to control our thoughts.",
"quoteAuthor": "Charles Darwin"
}, {
"quoteText": "Never miss an opportunity to make others happy, even if you have to leave them alone in order to do it.",
"quoteAuthor": ""
}, {
"quoteText": "One who asks a question is a fool for five minutes; one who does not ask a question remains a fool forever.",
"quoteAuthor": ""
}, {
"quoteText": "This world, after all our science and sciences, is still a miracle; wonderful, inscrutable, magical and more, to whosoever will think of it.",
"quoteAuthor": "Thomas Carlyle"
}, {
"quoteText": "A subtle thought that is in error may yet give rise to fruitful inquiry that can establish truths of great value.",
"quoteAuthor": "Isaac Asimov"
}, {
"quoteText": "By going beyond your own problems and taking care of others, you gain inner strength, self-confidence, courage, and a greater sense of calm.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "The road leading to a goal does not separate you from the destination; it is essentially a part of it.",
"quoteAuthor": "Charles DeLint"
}, {
"quoteText": "Genuine love should first be directed at oneself � if we do not love ourselves, how can we love others?",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Courage is not about taking risks unknowingly but putting your own being in front of challenges that others may not be able to.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Intuition is the supra-logic that cuts out all the routine processes of thought and leaps straight from the problem to the answer.",
"quoteAuthor": "Robert Graves"
}, {
"quoteText": "All difficult things have their origin in that which is easy, and great things in that which is small.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "The Creator has not given you a longing to do that which you have no ability to do.",
"quoteAuthor": "Orison Marden"
}, {
"quoteText": "It's so simple to be wise. Just think of something stupid to say and then don't say it.",
"quoteAuthor": "Sam Levenson"
}, {
"quoteText": "Consider that not only do negative thoughts and emotions destroy our experience of peace, they also undermine our health.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Do not overrate what you have received, nor envy others. He who envies others does not obtain peace of mind.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Until you make peace with who you are, you will never be content with what you have.",
"quoteAuthor": "Doris Mortman"
}, {
"quoteText": "The possession of knowledge does not kill the sense of wonder and mystery. There is always more mystery.",
"quoteAuthor": "Anais Nin"
}, {
"quoteText": "It is more important to know where you are going than to get there quickly. Do not mistake activity for achievement.",
"quoteAuthor": "Mabel Newcomber"
}, {
"quoteText": "To give hope to someone occurs when you teach them how to use the tools to do it for themselves.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "It is the greatest of all mistakes to do nothing because you can only do little � do what you can.",
"quoteAuthor": "Sydney Smith"
}, {
"quoteText": "No one saves us but ourselves. No one can and no one may. We ourselves must walk the path.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "To live a pure unselfish life, one must count nothing as ones own in the midst of abundance.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "The moment one gives close attention to anything, it becomes a mysterious, awesome, indescribably magnificent world in itself.",
"quoteAuthor": "Henry Miller"
}, {
"quoteText": "Happiness is when what you think, what you say, and what you do are in harmony.",
"quoteAuthor": "Mohandas Gandhi"
}, {
"quoteText": "If we are facing in the right direction, all we have to do is keep on walking.",
"quoteAuthor": ""
}, {
"quoteText": "Every time you smile at someone, it is an action of love, a gift to that person, a beautiful thing.",
"quoteAuthor": "Mother Teresa"
}, {
"quoteText": "Great indeed is the sublimity of the Creative, to which all beings owe their beginning and which permeates all heaven.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "People are so constituted that everybody would rather undertake what they see others do, whether they have an aptitude for it or not.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "The smallest flower is a thought, a life answering to some feature of the Great Whole, of whom they have a persistent intuition.",
"quoteAuthor": "Honore de Balzac"
}, {
"quoteText": "The greatest antidote to insecurity and the sense of fear is compassion � it brings one back to the basis of one's inner strength",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Courage is the discovery that you may not win, and trying when you know you can lose.",
"quoteAuthor": ""
}, {
"quoteText": "Nature gave us one tongue and two ears so we could hear twice as much as we speak.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "No valid plans for the future can be made by those who have no capacity for living now.",
"quoteAuthor": "Alan Watts"
}, {
"quoteText": "To be thoughtful and kind only takes a few seconds compared to the timeless hurt caused by one rude gesture.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "The purpose of learning is growth, and our minds, unlike our bodies, can continue growing as we continue to live.",
"quoteAuthor": "Mortimer Adler"
}, {
"quoteText": "Men in general judge more from appearances than from reality. All men have eyes, but few have the gift of penetration.",
"quoteAuthor": "Niccolo Machiavelli"
}, {
"quoteText": "When you realize how perfect everything is you will tilt your head back and laugh at the sky.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Nothing is predestined: The obstacles of your past can become the gateways that lead to new beginnings.",
"quoteAuthor": "Ralph Blum"
}, {
"quoteText": "Blessed is the person who is too busy to worry in the daytime, and too sleepy to worry at night.",
"quoteAuthor": "Leo Aikman"
}, {
"quoteText": "The highest stage in moral ure at which we can arrive is when we recognize that we ought to control our thoughts.",
"quoteAuthor": "Charles Darwin"
}, {
"quoteText": "To keep the body in good health is a duty... otherwise we shall not be able to keep our mind strong and clear.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "For every failure, there's an alternative course of action. You just have to find it. When you come to a roadblock, take a detour.",
"quoteAuthor": "Mary Kay Ash"
}, {
"quoteText": "It is surprising what a man can do when he has to, and how little most men will do when they don't have to.",
"quoteAuthor": "Walter Linn"
}, {
"quoteText": "To be aware of a single shortcoming in oneself is more useful than to be aware of a thousand in someone else.",
"quoteAuthor": "Tenzin Gyatso"
}, {
"quoteText": "Nobody made a greater mistake than he who did nothing because he could do only a little.",
"quoteAuthor": "Edmund Burke"
}, {
"quoteText": "Responsibility is not inherited, it is a choice that everyone needs to make at some point in their life.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Blessed is the person who is too busy to worry in the daytime, and too sleepy to worry at night.",
"quoteAuthor": "Leo Aikman"
}, {
"quoteText": "Today, give a stranger a smile without waiting for it may be the joy they need to have a great day.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "There are two kinds of failures: those who thought and never did, and those who did and never thought.",
"quoteAuthor": "Laurence J. Peter"
}, {
"quoteText": "With realization of ones own potential and self-confidence in ones ability, one can build a better world.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "I cannot give you the formula for success, but I can give you the formula for failure: which is: Try to please everybody.",
"quoteAuthor": "Herbert Swope"
}, {
"quoteText": "Constant kindness can accomplish much. As the sun makes ice melt, kindness causes misunderstanding, mistrust, and hostility to evaporate.",
"quoteAuthor": "Albert Schweitzer"
}, {
"quoteText": "Experience is not what happens to a man. It is what a man does with what happens to him.",
"quoteAuthor": "Aldous Huxley"
}, {
"quoteText": "The greatest minds are capable of the greatest vices as well as of the greatest virtues.",
"quoteAuthor": "Rene Descartes"
}, {
"quoteText": "A man should look for what is, and not for what he thinks should be.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "You can't let praise or criticism get to you. It's a weakness to get caught up in either one.",
"quoteAuthor": "John Wooden"
}, {
"quoteText": "A hero is no braver than an ordinary man, but he is braver five minutes longer.",
"quoteAuthor": "Ralph Waldo Emerson"
}, {
"quoteText": "Cherish your visions and your dreams as they are the children of your soul, the blueprints of your ultimate achievements.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Very little is needed to make a happy life; it is all within yourself, in your way of thinking.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "Difficulties are meant to rouse, not discourage. The human spirit is to grow strong by conflict.",
"quoteAuthor": "William Channing"
}, {
"quoteText": "Peace is not something you wish for. It's something you make, something you do, something you are, and something you give away.",
"quoteAuthor": "Robert Fulghum"
}, {
"quoteText": "If you have no respect for your own values how can you be worthy of respect from others.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "One must be fond of people and trust them if one is not to make a mess of life.",
"quoteAuthor": "E. M. Forster"
}, {
"quoteText": "The real measure of your wealth is how much youd be worth if you lost all your money.",
"quoteAuthor": ""
}, {
"quoteText": "People take different roads seeking fulfilment and happiness. Just because theyre not on your road doesn't mean they've gotten lost.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Some people are always grumbling because roses have thorns; I am thankful that thorns have roses.",
"quoteAuthor": "Alphonse Karr"
}, {
"quoteText": "You are always free to change your mind and choose a different future, or a different past.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "A subtle thought that is in error may yet give rise to fruitful inquiry that can establish truths of great value.",
"quoteAuthor": "Isaac Asimov"
}, {
"quoteText": "Genuine love should first be directed at oneself � if we do not love ourselves, how can we love others?",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "To choose what is difficult all ones days, as if it were easy, that is faith.",
"quoteAuthor": "W. H. Auden"
}, {
"quoteText": "Work while you have the light. You are responsible for the talent that has been entrusted to you.",
"quoteAuthor": "Henri-Frederic Amiel"
}, {
"quoteText": "Ability is what you're capable of doing. Motivation determines what you do.Attitude determines how well you do it.",
"quoteAuthor": "Lou Holtz"
}, {
"quoteText": "Sometimes your joy is the source of your smile, but sometimes your smile can be the source of your joy.",
"quoteAuthor": "Thich Nhat Hanh"
}, {
"quoteText": "People of mediocre ability sometimes achieve outstanding success because they don't know when to quit. Most men succeed because they are determined to.",
"quoteAuthor": "George Allen"
}, {
"quoteText": "There are things so deep and complex that only intuition can reach it in our stage of development as human beings.",
"quoteAuthor": "John Astin"
}, {
"quoteText": "To be beautiful means to be yourself. You don�t need to be accepted by others. You need to accept yourself.",
"quoteAuthor": "Thich Nhat Hanh"
}, {
"quoteText": "He that respects himself is safe from others; he wears a coat of mail that none can pierce.",
"quoteAuthor": "Henry Longfellow"
}, {
"quoteText": "A life spent making mistakes is not only more honourable, but more useful than a life spent doing nothing.",
"quoteAuthor": "George Bernard Shaw"
}, {
"quoteText": "Do not be embarrassed by your mistakes. Nothing can teach us better than our understanding of them. This is one of the best ways of self-education.",
"quoteAuthor": "Thomas Carlyle"
}, {
"quoteText": "Thousands of candles can be lighted from a single candle, and the life of the candle will not be shortened. Happiness never decreases by being shared.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "I care not so much what I am to others as what I am to myself. I will be rich by myself, and not by borrowing.",
"quoteAuthor": "Michel de Montaigne"
}, {
"quoteText": "Know that although in the eternal scheme of things you are small, you are also unique and irreplaceable, as are all your fellow humans everywhere in the world.",
"quoteAuthor": "Margaret Laurence"
}, {
"quoteText": "To do all that one is able to do, is to be a man; to do all that one would like to do, is to be a god.",
"quoteAuthor": "Napoleon Bonaparte"
}, {
"quoteText": "When you see a man of worth, think of how you may emulate him. When you see one who is unworthy, examine yourself.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "If you let go a little, you will have a little peace. If you let go a lot, you will have a lot of peace.",
"quoteAuthor": "Ajahn Chah"
}, {
"quoteText": "Do not be embarrassed by your mistakes. Nothing can teach us better than our understanding of them. This is one of the best ways of self-education.",
"quoteAuthor": "Thomas Carlyle"
}, {
"quoteText": "There is no need for temples, no need for complicated philosophies. My brain and my heart are my temples; my philosophy is kindness.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "The spirit, the will to win, and the will to excel, are the things that endure. These qualities are so much more important than the events that occur.",
"quoteAuthor": "Vincent Lombardi"
}, {
"quoteText": "Man is not sum of what he has already, but rather the sum of what he does not yet have, of what he could have.",
"quoteAuthor": "Jean-Paul Sartre"
}, {
"quoteText": "Don't believe what your eyes are telling you. All they show is limitation. Look with your understanding, find out what you already know, and you'll see the way to fly.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "I believe that we are solely responsible for our choices, and we have to accept the consequences of every deed, word, and thought throughout our lifetime.",
"quoteAuthor": "Elisabeth Kubler-Ross"
}, {
"quoteText": "I will love the light for it shows me the way, yet I will endure the darkness because it shows me the stars.",
"quoteAuthor": "Og Mandino"
}, {
"quoteText": "There is no need for temples, no need for complicated philosophies. My brain and my heart are my temples; my philosophy is kindness.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Wishes can be your best avenue of getting what you want when you turn wishes into action. Action moves your wish to the forefront from thought to reality.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Don't believe what your eyes are telling you. All they show is limitation. Look with your understanding, find out what you already know, and you'll see the way to fly.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "To understand the heart and mind of a person, look not at what he has already achieved, but at what he aspires to do.",
"quoteAuthor": "Kahlil Gibran"
}, {
"quoteText": "I am of the opinion that my life belongs to the community, and as long as I live it is my privilege to do for it whatever I can.",
"quoteAuthor": "Bernard Shaw"
}, {
"quoteText": "Imagination is more important than knowledge. For while knowledge defines all we currently know and understand, imagination points to all we might yet discover and create.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "When you see a good person, think of becoming like him. When you see someone not so good, reflect on your own weak points.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "When you see a man of worth, think of how you may emulate him. When you see one who is unworthy, examine yourself.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "If one is estranged from oneself, then one is estranged from others too. If one is out of touch with oneself, then one cannot touch others.",
"quoteAuthor": "Anne Lindbergh"
}, {
"quoteText": "Most of the important things in the world have been accomplished by people who have kept on trying when there seemed to be no hope at all.",
"quoteAuthor": "Dale Carnegie"
}, {
"quoteText": "You may say Im a dreamer, but Im not the only one, I hope someday you will join us, and the world will live as one.",
"quoteAuthor": "John Lennon"
}, {
"quoteText": "Happiness is as a butterfly which, when pursued, is always beyond our grasp, but which if you will sit down quietly, may alight upon you.",
"quoteAuthor": "Nathaniel Hawthorne"
}, {
"quoteText": "He who experiences the unity of life sees his own Self in all beings, and all beings in his own Self, and looks on everything with an impartial eye.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "In the sky, there is no distinction of east and west; people create distinctions out of their own minds and then believe them to be true.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "You cannot change anything in your life with intention alone, which can become a watered-down, occasional hope that you'll get to tomorrow. Intention without action is useless.",
"quoteAuthor": "Caroline Myss"
}, {
"quoteText": "Do not be embarrassed by your mistakes. Nothing can teach us better than our understanding of them. This is one of the best ways of self-education.",
"quoteAuthor": "Thomas Carlyle"
}, {
"quoteText": "Before you can inspire with emotion, you must be swamped with it yourself. Before you can move their tears, your own must flow. To convince them, you must yourself believe.",
"quoteAuthor": "Winston Churchill"
}, {
"quoteText": "The greatest discovery of our generation is that human beings can alter their lives by altering their attitudes of mind. As you think, so shall you be.",
"quoteAuthor": "William James"
}, {
"quoteText": "If one advances confidently in the direction of his dream, and endeavours to live the life which he had imagines, he will meet with a success unexpected in common hours.",
"quoteAuthor": "Henry David Thoreau"
}, {
"quoteText": "The secret of joy in work is contained in one word � excellence. To know how to do something well is to enjoy it.",
"quoteAuthor": "Pearl Buck"
}, {
"quoteText": "When you meet someone better than yourself, turn your thoughts to becoming his equal. When you meet someone not as good as you are, look within and examine your own self.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Happiness is as a butterfly which, when pursued, is always beyond our grasp, but which if you will sit down quietly, may alight upon you.",
"quoteAuthor": "Nathaniel Hawthorne"
}, {
"quoteText": "We must overcome the notion that we must be regular. It robs you of the chance to be extraordinary and leads you to the mediocre.",
"quoteAuthor": "Uta Hagen"
}, {
"quoteText": "Most of our obstacles would melt away if, instead of cowering before them, we should make up our minds to walk boldly through them.",
"quoteAuthor": "Orison Marden"
}, {
"quoteText": "Everything can be taken from a man but ... the last of the human freedoms � to choose ones attitude in any given set of circumstances, to choose ones own way.",
"quoteAuthor": "Victor Frankl"
}, {
"quoteText": "It is better to have enough ideas for some of them to be wrong, than to be always right by having no ideas at all.",
"quoteAuthor": "Edward de Bono"
}, {
"quoteText": "Character is like a tree and reputation like a shadow. The shadow is what we think of it; the tree is the real thing.",
"quoteAuthor": "Abraham Lincoln"
}, {
"quoteText": "By letting it go it all gets done. The world is won by those who let it go. But when you try and try. The world is beyond the winning.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "I am like a falling star who has finally found her place next to another in a lovely constellation, where we will sparkle in the heavens forever.",
"quoteAuthor": "Amy Tan"
}, {
"quoteText": "Not every difficult and dangerous thing is suitable for training, but only that which is conducive to success in achieving the object of our effort.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "We are not animals. We are not a product of what has happened to us in our past. We have the power of choice.",
"quoteAuthor": "Stephen Covey"
}, {
"quoteText": "The most dangerous way to lose time is not to spend it having fun, but to spend it doing fake work. When you spend time having fun, you know you're being self-indulgent.",
"quoteAuthor": "Paul Graham"
}, {
"quoteText": "Thousands of candles can be lit from a single, and the life of the candle will not be shortened. Happiness never decreases by being shared.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "A lot of times people look at the negative side of what they feel they can't do. I always look on the positive side of what I can do.",
"quoteAuthor": "Chuck Norris"
}, {
"quoteText": "Without passion man is a mere latent force and possibility, like the flint which awaits the shock of the iron before it can give forth its spark.",
"quoteAuthor": "Amiel"
}, {
"quoteText": "Love at first sight is easy to understand; its when two people have been looking at each other for a lifetime that it becomes a miracle.",
"quoteAuthor": "Amy Bloom"
}, {
"quoteText": "With courage you will dare to take risks, have the strength to be compassionate, and the wisdom to be humble. Courage is the foundation of integrity.",
"quoteAuthor": "Keshavan Nair"
}, {
"quoteText": "The right way is not always the popular and easy way. Standing for right when it is unpopular is a true test of moral character.",
"quoteAuthor": "Margaret Smith"
}, {
"quoteText": "I prefer to be true to myself, even at the hazard of incurring the ridicule of others, rather than to be false, and to incur my own abhorrence.",
"quoteAuthor": "Frederick Douglass"
}, {
"quoteText": "No pessimist ever discovered the secrets of the stars, or sailed to an uncharted land, or opened a new heaven to the human spirit.",
"quoteAuthor": "Helen Keller"
}, {
"quoteText": "Thousands of candles can be lighted from a single candle, and the life of the candle will not be shortened. Happiness never decreases by being shared.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "When you arise in the morning, think of what a precious privilege it is to be alive � to breathe, to think, to enjoy, to love.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "Character cannot be developed in ease and quiet. Only through experience of trial and suffering can the soul be strengthened, vision cleared, ambition inspired, and success achieved.",
"quoteAuthor": "Helen Keller"
}, {
"quoteText": "Although there may be tragedy in your life, there's always a possibility to triumph. It doesn't matter who you are, where you come from. The ability to triumph begins with you. Always.",
"quoteAuthor": "Oprah Winfrey"
}, {
"quoteText": "You must train your intuition � you must trust the small voice inside you which tells you exactly what to say, what to decide.",
"quoteAuthor": "Ingrid Bergman"
}, {
"quoteText": "If you let go a little, you will have a little peace. If you let go a lot, you will have a lot of peace.",
"quoteAuthor": "Ajahn Chah"
}, {
"quoteText": "Accept the things to which fate binds you, and love the people with whom fate brings you together, but do so with all your heart.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "Let us resolve to be masters, not the victims, of our history, controlling our own destiny without giving way to blind suspicions and emotions.",
"quoteAuthor": "John Kennedy"
}, {
"quoteText": "The greatest discovery of our generation is that human beings can alter their lives by altering their attitudes of mind. As you think, so shall you be.",
"quoteAuthor": "William James"
}, {
"quoteText": "Nothing in life is to be feared, it is only to be understood. Now is the time to understand more, so that we may fear less.",
"quoteAuthor": "Marie Curie"
}, {
"quoteText": "Parents can only give good advice or put them on the right paths, but the final forming of a persons character lies in their own hands.",
"quoteAuthor": "Anne Frank"
}, {
"quoteText": "Adversity isn't set against you to fail; adversity is a way to build your character so that you can succeed over and over again through perseverance.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Most of the important things in the world have been accomplished by people who have kept on trying when there seemed to be no hope at all.",
"quoteAuthor": "Dale Carnegie"
}, {
"quoteText": "Let us resolve to be masters, not the victims, of our history, controlling our own destiny without giving way to blind suspicions and emotions.",
"quoteAuthor": "John Kennedy"
}, {
"quoteText": "When you meet someone better than yourself, turn your thoughts to becoming his equal. When you meet someone not as good as you are, look within and examine your own self.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "If you break your neck, if you have nothing to eat, if your house is on fire, then you got a problem. Everything else is inconvenience.",
"quoteAuthor": "Robert Fulghum"
}, {
"quoteText": "Success is not the key to happiness. Happiness is the key to success. If you love what you are doing, you will be successful.",
"quoteAuthor": "Albert Schweitzer"
}, {
"quoteText": "If A is success in life, then A equals x plus y plus z. Work is x; y is play; and z is keeping your mouth shut.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "There is no need for temples, no need for complicated philosophies. My brain and my heart are my temples; my philosophy is kindness.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "My advice to you is not to inquire why or whither, but just enjoy your ice cream while its on your plate � that's my philosophy.",
"quoteAuthor": "Thornton Wilder"
}, {
"quoteText": "Conflict is the gadfly of thought. It stirs us to observation and memory. It instigates to invention. It shocks us out of sheeplike passivity, and sets us at noting and contriving.",
"quoteAuthor": "John Dewey"
}, {
"quoteText": "He who conquers others is strong; He who conquers himself is mighty.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Smile, breathe, and go slowly.",
"quoteAuthor": "Thich Nhat Hanh"
}, {
"quoteText": "Nothing diminishes anxiety faster than action.",
"quoteAuthor": "Walter Anderson"
}, {
"quoteText": "The secret of success is constancy to purpose.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "Anything you really want, you can attain, if you really go after it.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Arriving at one point is the starting point to another.",
"quoteAuthor": "John Dewey"
}, {
"quoteText": "The foolish man seeks happiness in the distance, the wise grows it under his feet.",
"quoteAuthor": "James Oppenheim"
}, {
"quoteText": "Don't be afraid to go out on a limb. That's where the fruit is.",
"quoteAuthor": "H. Jackson Browne"
}, {
"quoteText": "When the solution is simple, God is answering.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "Never put off till tomorrow what you can do today.",
"quoteAuthor": "Thomas Jefferson"
}, {
"quoteText": "Do not expect the world to look bright, if you habitually wear gray-brown glasses.",
"quoteAuthor": "Tomas Eliot"
}, {
"quoteText": "The greatest part of our happiness depends on our dispositions, not our circumstances.",
"quoteAuthor": "Martha Washington"
}, {
"quoteText": "It is in your moments of decision that your destiny is shaped.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "It is only possible to live happily ever after on a day to day basis.",
"quoteAuthor": "Margaret Bonnano"
}, {
"quoteText": "Being right is highly overrated. Even a stopped clock is right twice a day.",
"quoteAuthor": ""
}, {
"quoteText": "Love doesn't make the world go round, love is what makes the ride worthwhile.",
"quoteAuthor": "Elizabeth Browning"
}, {
"quoteText": "Don't judge each day by the harvest you reap but by the seeds you plant.",
"quoteAuthor": "Robert Stevenson"
}, {
"quoteText": "One fails forward toward success.",
"quoteAuthor": "Charles Kettering"
}, {
"quoteText": "A man sees in the world what he carries in his heart.",
"quoteAuthor": "Goethe"
}, {
"quoteText": "If you surrender to the wind, you can ride it.",
"quoteAuthor": "Toni Morrison"
}, {
"quoteText": "Action may not always bring happiness, but there is no happiness without action.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "Love is the flower you've got to let grow.",
"quoteAuthor": "John Lennon"
}, {
"quoteText": "Believe deep down in your heart that you're destined to do great things.",
"quoteAuthor": "Joe Paterno"
}, {
"quoteText": "Sooner or later, those who win are those who think they can.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "The only limit to your impact is your imagination and commitment.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "Silence is the true friend that never betrays.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "You are special, you are unique, you are the best!",
"quoteAuthor": "Cathy Pulsifer"
}, {
"quoteText": "Four steps to achievement: Plan purposefully. Prepare prayerfully. Proceed positively. Pursue persistently.",
"quoteAuthor": "William Arthur Ward"
}, {
"quoteText": "It is in your moments of decision that your destiny is shaped.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "Life is a learning experience, only if you learn.",
"quoteAuthor": "Yogi Berra"
}, {
"quoteText": "A short saying oft contains much wisdom.",
"quoteAuthor": "Sophocles"
}, {
"quoteText": "I'm not afraid of storms, for Im learning how to sail my ship.",
"quoteAuthor": "Louisa Alcott"
}, {
"quoteText": "To know oneself is to study oneself in action with another person.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "Whenever you have eliminated the impossible, whatever remains, however improbable, must be the truth.",
"quoteAuthor": "Arthur Conan Doyle"
}, {
"quoteText": "We must not allow ourselves to become like the system we oppose.",
"quoteAuthor": "Bishop Desmond Tutu"
}, {
"quoteText": "Smile, breathe and go slowly.",
"quoteAuthor": "Thich Nhat Hanh"
}, {
"quoteText": "The day you decide to do it is your lucky day.",
"quoteAuthor": "Japanese proverb"
}, {
"quoteText": "To want to be what one can be is purpose in life.",
"quoteAuthor": "Cynthia Ozick"
}, {
"quoteText": "Reality is merely an illusion, albeit a very persistent one.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "When you come to the end of your rope, tie a knot and hang on.",
"quoteAuthor": "Franklin Roosevelt"
}, {
"quoteText": "Always be mindful of the kindness and not the faults of others.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Everything that irritates us about others can lead us to an understanding of ourselves.",
"quoteAuthor": "Carl Jung"
}, {
"quoteText": "When fate hands us a lemon, lets try to make lemonade.",
"quoteAuthor": "Dale Carnegie"
}, {
"quoteText": "The weak can never forgive. Forgiveness is the attribute of the strong.",
"quoteAuthor": "Mohandas Gandhi"
}, {
"quoteText": "A man is great by deeds, not by birth.",
"quoteAuthor": "Chanakya"
}, {
"quoteText": "Success is getting what you want. Happiness is wanting what you get.",
"quoteAuthor": "Dale Carnegie"
}, {
"quoteText": "I believe that every person is born with talent.",
"quoteAuthor": "Maya Angelou"
}, {
"quoteText": "Put your future in good hands � your own.",
"quoteAuthor": ""
}, {
"quoteText": "Don't be pushed by your problems; be led by your dreams.",
"quoteAuthor": ""
}, {
"quoteText": "You are important enough to ask and you are blessed enough to receive back.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Truth isn't all about what actually happens but more about how what has happened is interpreted.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "The cautious seldom err.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "No garden is without its weeds.",
"quoteAuthor": "Thomas Fuller"
}, {
"quoteText": "Who looks outside, dreams; who looks inside, awakes.",
"quoteAuthor": "Carl Jung"
}, {
"quoteText": "A good rest is half the work.",
"quoteAuthor": ""
}, {
"quoteText": "Don't judge each day by the harvest you reap but by the seeds that you plant.",
"quoteAuthor": "Robert Stevenson"
}, {
"quoteText": "Small opportunities are often the beginning of great enterprises.",
"quoteAuthor": "Demosthenes"
}, {
"quoteText": "You can do what's reasonable or you can decide what's possible.",
"quoteAuthor": ""
}, {
"quoteText": "To be tested is good. The challenged life may be the best therapist.",
"quoteAuthor": "Gail Sheehy"
}, {
"quoteText": "If you think you can, you can. And if you think you can't, you're right.",
"quoteAuthor": "Henry Ford"
}, {
"quoteText": "There are no failures. Just experiences and your reactions to them.",
"quoteAuthor": "Tom Krause"
}, {
"quoteText": "I destroy my enemies when I make them my friends.",
"quoteAuthor": "Abraham Lincoln"
}, {
"quoteText": "Do something wonderful, people may imitate it.",
"quoteAuthor": "Albert Schweitzer"
}, {
"quoteText": "Fears are nothing more than a state of mind.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Take heed: you do not find what you do not seek.",
"quoteAuthor": "English proverb"
}, {
"quoteText": "Happiness is the reward we get for living to the highest right we know.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "Be slow of tongue and quick of eye.",
"quoteAuthor": "Cervantes"
}, {
"quoteText": "Freedom is not worth having if it does not connote freedom to err.",
"quoteAuthor": "Mohandas Gandhi"
}, {
"quoteText": "Nothing diminishes anxiety faster than action.",
"quoteAuthor": "Walter Anderson"
}, {
"quoteText": "I have always thought the actions of men the best interpreters of their thoughts.",
"quoteAuthor": "John Locke"
}, {
"quoteText": "If one is lucky, a solitary fantasy can totally transform one million realities.",
"quoteAuthor": "Maya Angelou"
}, {
"quoteText": "He who obtains has little. He who scatters has much.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "I'm not afraid of storms, for Im learning how to sail my ship.",
"quoteAuthor": "Louisa Alcott"
}, {
"quoteText": "Be great in act, as you have been in thought.",
"quoteAuthor": "William Shakespeare"
}, {
"quoteText": "The cause is hidden. The effect is visible to all.",
"quoteAuthor": "Ovid"
}, {
"quoteText": "He who obtains has little. He who scatters has much.",
"quoteAuthor": "Richard Braunstein"
}, {
"quoteText": "To dare is to lose ones footing momentarily. To not dare is to lose oneself.",
"quoteAuthor": "Soren Kierkegaard"
}, {
"quoteText": "No day in which you learn something is a complete loss.",
"quoteAuthor": "David Eddings"
}, {
"quoteText": "When the solution is simple, God is answering.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "Peace cannot be kept by force. It can only be achieved by understanding.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "Real success is finding your lifework in the work that you love.",
"quoteAuthor": "David McCullough"
}, {
"quoteText": "Better than a thousand hollow words, is one word that brings peace.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "All the flowers of all the tomorrows are in the seeds of today.",
"quoteAuthor": ""
}, {
"quoteText": "Some pursue happiness, others create it.",
"quoteAuthor": ""
}, {
"quoteText": "Your sacred space is where you can find yourself again and again.",
"quoteAuthor": "Joseph Campbell"
}, {
"quoteText": "There never was a good knife made of bad steel.",
"quoteAuthor": "Benjamin Franklin"
}, {
"quoteText": "He who talks more is sooner exhausted.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "As you think, so shall you become.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "Do not turn back when you are just at the goal.",
"quoteAuthor": "Publilius Syrus"
}, {
"quoteText": "He who obtains has little. He who scatters has much.",
"quoteAuthor": "Richard Braunstein"
}, {
"quoteText": "In seed time learn, in harvest teach, in winter enjoy.",
"quoteAuthor": "William Blake"
}, {
"quoteText": "A short saying oft contains much wisdom.",
"quoteAuthor": "Sophocles"
}, {
"quoteText": "Happiness does not come from having much, but from being attached to little.",
"quoteAuthor": "Cheng Yen"
}, {
"quoteText": "Every gift from a friend is a wish for your happiness.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "Go put your creed into the deed. Nor speak with double tongue.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "In the end we retain from our studies only that which we practically apply.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "The wisest men follow their own direction.",
"quoteAuthor": "Euripides"
}, {
"quoteText": "Hope arouses, as nothing else can arouse, a passion for the possible.",
"quoteAuthor": "William Sloane Coffin"
}, {
"quoteText": "Myths which are believed in tend to become true.",
"quoteAuthor": "George Orwell"
}, {
"quoteText": "Who sows virtue reaps honour.",
"quoteAuthor": "Leonardo da Vinci"
}, {
"quoteText": "The future belongs to those who believe in the beauty of their dreams.",
"quoteAuthor": "Eleanor Roosevelt"
}, {
"quoteText": "Everything has beauty, but not everyone sees it.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Courage is going from failure to failure without losing enthusiasm.",
"quoteAuthor": "Winston Churchill"
}, {
"quoteText": "He who talks more is sooner exhausted.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Nothing ever goes away until it has taught us what we need to know.",
"quoteAuthor": "Pema Chodron"
}, {
"quoteText": "Smile, breathe, and go slowly.",
"quoteAuthor": "Thich Nhat Hanh"
}, {
"quoteText": "In separateness lies the world's great misery, in compassion lies the world's true strength.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Small opportunities are often the beginning of great enterprises.",
"quoteAuthor": "Demosthenes"
}, {
"quoteText": "If you don't know where you are going, you will probably end up somewhere else.",
"quoteAuthor": "Lawrence Peter"
}, {
"quoteText": "When you learn, teach. When you get, give.",
"quoteAuthor": "Maya Angelou"
}, {
"quoteText": "We choose our destiny in the way we treat others.",
"quoteAuthor": "Wit"
}, {
"quoteText": "The universe is transformation; our life is what our thoughts make it.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "Difficulties increase the nearer we get to the goal.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "Smile, breathe, and go slowly.",
"quoteAuthor": "Thich Nhat Hanh"
}, {
"quoteText": "Science is organized knowledge. Wisdom is organized life.",
"quoteAuthor": "Immanuel Kant"
}, {
"quoteText": "Only when we are no longer afraid do we begin to live.",
"quoteAuthor": "Dorothy Thompson"
}, {
"quoteText": "If you smile when no one else is around, you really mean it.",
"quoteAuthor": "Andy Rooney"
}, {
"quoteText": "Life is a process. We are a process. The universe is a process.",
"quoteAuthor": "Anne Schaef"
}, {
"quoteText": "Love is the only force capable of transforming an enemy into friend.",
"quoteAuthor": "Martin Luther King, Jr."
}, {
"quoteText": "Good luck is another name for tenacity of purpose.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Well done is better than well said.",
"quoteAuthor": "Benjamin Franklin"
}, {
"quoteText": "Our lives are a sum total of the choices we have made.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "In all chaos there is a cosmos, in all disorder a secret order.",
"quoteAuthor": "Carl Jung"
}, {
"quoteText": "A man is not where he lives but where he loves.",
"quoteAuthor": ""
}, {
"quoteText": "You can do what's reasonable or you can decide what's possible.",
"quoteAuthor": ""
}, {
"quoteText": "The greatest remedy for anger is delay.",
"quoteAuthor": "Seneca"
}, {
"quoteText": "The price of greatness is responsibility.",
"quoteAuthor": "Winston Churchill"
}, {
"quoteText": "Decision is a risk rooted in the courage of being free.",
"quoteAuthor": "Paul Tillich"
}, {
"quoteText": "The day is already blessed, find peace within it.",
"quoteAuthor": ""
}, {
"quoteText": "You might well remember that nothing can bring you success but yourself.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Your mind will answer most questions if you learn to relax and wait for the answer.",
"quoteAuthor": "William Burroughs"
}, {
"quoteText": "All things change; nothing perishes.",
"quoteAuthor": "Ovid"
}, {
"quoteText": "You can do it if you believe you can!",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "God has given you one face, and you make yourself another.",
"quoteAuthor": "William Shakespeare"
}, {
"quoteText": "Being right is highly overrated. Even a stopped clock is right twice a day.",
"quoteAuthor": ""
}, {
"quoteText": "The world doesn�t happen to you it happens from you.",
"quoteAuthor": ""
}, {
"quoteText": "It is only possible to live happily ever after on a day to day basis.",
"quoteAuthor": "Margaret Bonnano"
}, {
"quoteText": "We cannot solve our problems with the same thinking we used when we created them.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "More powerful than the will to win is the courage to begin.",
"quoteAuthor": ""
}, {
"quoteText": "Wisdom is the supreme part of happiness.",
"quoteAuthor": "Sophocles"
}, {
"quoteText": "Who looks outside, dreams; who looks inside, awakes.",
"quoteAuthor": "Carl Jung"
}, {
"quoteText": "Learning is finding out what you already know.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "Don't judge each day by the harvest you reap but by the seeds you plant.",
"quoteAuthor": "Robert Stevenson"
}, {
"quoteText": "We learn what we have said from those who listen to our speaking.",
"quoteAuthor": "Kenneth Patton"
}, {
"quoteText": "Efficiency is doing things right; effectiveness is doing the right things.",
"quoteAuthor": "Peter Drucker"
}, {
"quoteText": "Saying thank you is more than good manners. It is good spirituality.",
"quoteAuthor": "Alfred Painter"
}, {
"quoteText": "Silence is a source of great strength.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Joy is the best makeup.",
"quoteAuthor": "Anne Lamott"
}, {
"quoteText": "If you cannot be silent be brilliant and thoughtful.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "There is no great genius without some touch of madness.",
"quoteAuthor": "Seneca"
}, {
"quoteText": "The biggest adventure you can ever take is to live the life of your dreams.",
"quoteAuthor": "Oprah Winfrey"
}, {
"quoteText": "A jug fills drop by drop.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "You must welcome change as the rule but not as your ruler.",
"quoteAuthor": "Denis Waitley"
}, {
"quoteText": "Everything that irritates us about others can lead us to an understanding of ourselves.",
"quoteAuthor": "Carl Jung"
}, {
"quoteText": "Once you choose hope, anythings possible.",
"quoteAuthor": "Christopher Reeve"
}, {
"quoteText": "Talk doesn't cook rice.",
"quoteAuthor": "Chinese proverb"
}, {
"quoteText": "In separateness lies the world's great misery, in compassion lies the world's true strength.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "The only real valuable thing is intuition.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "Accept challenges, so that you may feel the exhilaration of victory.",
"quoteAuthor": "George Patton"
}, {
"quoteText": "Until you make peace with who you are, you'll never be content with what you have.",
"quoteAuthor": "Doris Mortman"
}, {
"quoteText": "Never apologize for showing feelings. When you do so, you apologize for the truth.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "We aim above the mark to hit the mark.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Being angry never solves anything.",
"quoteAuthor": "Catherine Pulsifer"
}, {
"quoteText": "Every problem has a gift for you in its hands.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "All men who have achieved great things have been great dreamers.",
"quoteAuthor": "Orison Marden"
}, {
"quoteText": "Mediocrity knows nothing higher than itself, but talent instantly recognizes genius.",
"quoteAuthor": "Arthur Conan Doyle"
}, {
"quoteText": "Where all think alike, no one thinks very much.",
"quoteAuthor": "Walter Lippmann"
}, {
"quoteText": "Everything that exists is in a manner the seed of that which will be.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "Be less curious about people and more curious about ideas.",
"quoteAuthor": "Marie Curie"
}, {
"quoteText": "The heart has eyes which the brain knows nothing of.",
"quoteAuthor": "Charles Perkhurst"
}, {
"quoteText": "Don't be pushed by your problems; be led by your dreams.",
"quoteAuthor": ""
}, {
"quoteText": "I'm not afraid of storms, for Im learning how to sail my ship.",
"quoteAuthor": "Louisa Alcott"
}, {
"quoteText": "A short saying oft contains much wisdom.",
"quoteAuthor": "Sophocles"
}, {
"quoteText": "Everything is perfect in the universe � even your desire to improve it.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Be miserable. Or motivate yourself. Whatever has to be done, it's always your choice.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Think how hard physics would be if particles could think.",
"quoteAuthor": "Murray Gell-Mann"
}, {
"quoteText": "Only those who dare to fail greatly can ever achieve greatly.",
"quoteAuthor": "Robert Kennedy"
}, {
"quoteText": "Lose an hour in the morning, and you will spend all day looking for it.",
"quoteAuthor": "Richard Whately"
}, {
"quoteText": "Mistakes are always forgivable, if one has the courage to admit them.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "Go to your bosom: Knock there, and ask your heart what it doth know.",
"quoteAuthor": "William Shakespeare"
}, {
"quoteText": "If you think you can, you can. And if you think you can't, you're right.",
"quoteAuthor": "Henry Ford"
}, {
"quoteText": "Through perseverance many people win success out of what seemed destined to be certain failure.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "Happiness mainly comes from our own attitude, rather than from external factors.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "If you do not change direction, you may end up where you are heading.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "What we see is mainly what we look for.",
"quoteAuthor": ""
}, {
"quoteText": "If you correct your mind, the rest of your life will fall into place.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Stay away from what might have been and look at what will be.",
"quoteAuthor": "Marsha Petrie Sue"
}, {
"quoteText": "When the solution is simple, God is answering.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "Act as if what you do makes a difference. It does.",
"quoteAuthor": "William James"
}, {
"quoteText": "Successful people ask better questions, and as a result, they get better answers.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "There never was a good knife made of bad steel.",
"quoteAuthor": "Benjamin Franklin"
}, {
"quoteText": "Better be ignorant of a matter than half know it.",
"quoteAuthor": "Publilius Syrus"
}, {
"quoteText": "Passion creates the desire for more and action fuelled by passion creates a future.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Most people are about as happy as they make up their minds to be",
"quoteAuthor": "Abraham Lincoln"
}, {
"quoteText": "Every new day is another chance to change your life.",
"quoteAuthor": ""
}, {
"quoteText": "Do good by stealth, and blush to find it fame.",
"quoteAuthor": "Alexander Pope"
}, {
"quoteText": "When you doubt your power, you give power to your doubt.",
"quoteAuthor": "Honore de Balzac"
}, {
"quoteText": "I always wanted to be somebody, but I should have been more specific.",
"quoteAuthor": "Lily Tomlin"
}, {
"quoteText": "Opportunity often comes disguised in the form of misfortune, or temporary defeat.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Pick battles big enough to matter, small enough to win.",
"quoteAuthor": "Jonathan Kozol"
}, {
"quoteText": "If we did the things we are capable of, we would astound ourselves.",
"quoteAuthor": "Thomas Edison"
}, {
"quoteText": "Don't talk about what you have done or what you are going to do.",
"quoteAuthor": "Thomas Jefferson"
}, {
"quoteText": "The way is not in the sky. The way is in the heart.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Most powerful is he who has himself in his own power.",
"quoteAuthor": "Seneca"
}, {
"quoteText": "Those who are free of resentful thoughts surely find peace.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "We don't stop playing because we grow old; we grow old because we stop playing.",
"quoteAuthor": "Bernard Shaw"
}, {
"quoteText": "It is not so important to know everything as to appreciate what we learn.",
"quoteAuthor": "Hannah More"
}, {
"quoteText": "Experience can only be gained by doing not by thinking or dreaming.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Always tell the truth. That way, you don't have to remember what you said.",
"quoteAuthor": "Mark Twain"
}, {
"quoteText": "From wonder into wonder existence opens.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "An ant on the move does more than a dozing ox",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "To avoid criticism, do nothing, say nothing, be nothing.",
"quoteAuthor": "Elbert Hubbard"
}, {
"quoteText": "Through perseverance many people win success out of what seemed destined to be certain failure.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "He who fears being conquered is sure of defeat.",
"quoteAuthor": "Napoleon Bonaparte"
}, {
"quoteText": "Life is what happens while you are making other plans.",
"quoteAuthor": "John Lennon"
}, {
"quoteText": "Those who are free of resentful thoughts surely find peace.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Good luck is another name for tenacity of purpose.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Doing what you love is the cornerstone of having abundance in your life.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Nothing diminishes anxiety faster than action.",
"quoteAuthor": "Walter Anderson"
}, {
"quoteText": "Be faithful in small things because it is in them that your strength lies.",
"quoteAuthor": "Mother Teresa"
}, {
"quoteText": "Kindness is the golden chain by which society is bound together.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "You need chaos in your soul to give birth to a dancing star.",
"quoteAuthor": "Nietzsche"
}, {
"quoteText": "I have often regretted my speech, never my silence.",
"quoteAuthor": "Publilius Syrus"
}, {
"quoteText": "It can't be spring if your heart is filled with past failures.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "If you cannot be silent be brilliant and thoughtful.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "If you wish to be a writer, write.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "No yesterdays are ever wasted for those who give themselves to today.",
"quoteAuthor": "Brendan Francis"
}, {
"quoteText": "The truth is always exciting. Speak it, then. Life is dull without it.",
"quoteAuthor": "Pearl Buck"
}, {
"quoteText": "There are no failures � just experiences and your reactions to them.",
"quoteAuthor": "Tom Krause"
}, {
"quoteText": "Action is the foundational key to all success.",
"quoteAuthor": "Pablo Picasso"
}, {
"quoteText": "What is necessary to change a person is to change his awareness of himself.",
"quoteAuthor": "Abraham Maslow"
}, {
"quoteText": "Silence is a fence around wisdom.",
"quoteAuthor": "German proverb"
}, {
"quoteText": "If you spend too much time thinking about a thing, you'll never get it done.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "Positive thinking will let you do everything better than negative thinking will.",
"quoteAuthor": "Zig Ziglar"
}, {
"quoteText": "Think how hard physics would be if particles could think.",
"quoteAuthor": "Murray Gell-Mann"
}, {
"quoteText": "We shall never know all the good that a simple smile can do.",
"quoteAuthor": "Mother Teresa"
}, {
"quoteText": "Nature takes away any faculty that is not used.",
"quoteAuthor": "William R. Inge"
}, {
"quoteText": "Nothing is so strong as gentleness. Nothing is so gentle as real strength.",
"quoteAuthor": "Frances de Sales"
}, {
"quoteText": "Fears are nothing more than a state of mind.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Imagination is not a talent of some men but is the health of every man.",
"quoteAuthor": "Ralph Waldo Emerson"
}, {
"quoteText": "We must embrace pain and burn it as fuel for our journey.",
"quoteAuthor": "Kenji Miyazawa"
}, {
"quoteText": "It has never been my object to record my dreams, just to realize them.",
"quoteAuthor": "Man Ray"
}, {
"quoteText": "Don't wait for people to be friendly. Show them how.",
"quoteAuthor": ""
}, {
"quoteText": "Practice yourself, for heavens sake in little things, and then proceed to greater.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "Your outlook on life is a direct reflection on how much you like yourself.",
"quoteAuthor": "Lululemon"
}, {
"quoteText": "Better to have loved and lost, than to have never loved at all.",
"quoteAuthor": "St. Augustine"
}, {
"quoteText": "A man is not where he lives but where he loves.",
"quoteAuthor": ""
}, {
"quoteText": "From error to error one discovers the entire truth.",
"quoteAuthor": "Sigmund Freud"
}, {
"quoteText": "I believe that every person is born with talent.",
"quoteAuthor": "Maya Angelou"
}, {
"quoteText": "Three things cannot be long hidden: the sun, the moon, and the truth.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Every day may not be good, but there's something good in every day.",
"quoteAuthor": ""
}, {
"quoteText": "Well begun is half done.",
"quoteAuthor": "Aristotle"
}, {
"quoteText": "In separateness lies the world's great misery, in compassion lies the world's true strength.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Do one thing every day that scares you.",
"quoteAuthor": "Eleanor Roosevelt"
}, {
"quoteText": "Whatever happens, take responsibility.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "A gem cannot be polished without friction, nor a man perfected without trials.",
"quoteAuthor": "Chinese proverb"
}, {
"quoteText": "No is easier to do. Yes is easier to say.",
"quoteAuthor": "Jason Fried"
}, {
"quoteText": "Nothing is so strong as gentleness. Nothing is so gentle as real strength.",
"quoteAuthor": "Frances de Sales"
}, {
"quoteText": "Life is a process. We are a process. The universe is a process.",
"quoteAuthor": "Anne Schaef"
}, {
"quoteText": "Don't wait. The time will never be just right.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Be as you wish to seem.",
"quoteAuthor": "Socrates"
}, {
"quoteText": "Knowing is not enough; we must apply!",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "Science is organized knowledge. Wisdom is organized life.",
"quoteAuthor": "Immanuel Kant"
}, {
"quoteText": "The path to success is to take massive, determined action.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "Freedom is not worth having if it does not connote freedom to err.",
"quoteAuthor": "Mohandas Gandhi"
}, {
"quoteText": "Each day can be one of triumph if you keep up your interests.",
"quoteAuthor": "George Matthew Adams"
}, {
"quoteText": "The place to improve the world is first in one's own heart and head and hands.",
"quoteAuthor": "Robert M. Pirsig"
}, {
"quoteText": "The pessimist sees difficulty in every opportunity. The optimist sees the opportunity in every difficulty.",
"quoteAuthor": "Winston Churchill"
}, {
"quoteText": "Winners have simply formed the habit of doing things losers don't like to do.",
"quoteAuthor": "Albert Gray"
}, {
"quoteText": "Nature is a mutable cloud which is always and never the same.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Life is what you make of it. Always has been, always will be.",
"quoteAuthor": "Grandma Moses"
}, {
"quoteText": "If you do not change direction, you may end up where you are heading.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Worry often gives a small thing a big shadow.",
"quoteAuthor": "Swedish proverb"
}, {
"quoteText": "I want you to be everything that's you, deep at the center of your being.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "We know what we are, but know not what we may be.",
"quoteAuthor": "William Shakespeare"
}, {
"quoteText": "Do not turn back when you are just at the goal.",
"quoteAuthor": "Publilius Syrus"
}, {
"quoteText": "Freedom is what you do with what's been done to you.",
"quoteAuthor": "Jean-Paul Sartre"
}, {
"quoteText": "Life is so constructed that an event does not, cannot, will not, match the expectation.",
"quoteAuthor": "Charlotte Bronte"
}, {
"quoteText": "Pick battles big enough to matter, small enough to win.",
"quoteAuthor": "Jonathan Kozol"
}, {
"quoteText": "It is never too late to be what you might have been.",
"quoteAuthor": "George Eliot"
}, {
"quoteText": "The truth which has made us free will in the end make us glad also.",
"quoteAuthor": "Felix Adler"
}, {
"quoteText": "The heart has its reasons which reason knows not of.",
"quoteAuthor": "Blaise Pascal"
}, {
"quoteText": "To succeed, we must first believe that we can.",
"quoteAuthor": "Michael Korda"
}, {
"quoteText": "He who has imagination without learning has wings but no feet.",
"quoteAuthor": "Joseph Joubert"
}, {
"quoteText": "Never ignore a gut feeling, but never believe that it's enough.",
"quoteAuthor": "Robert Heller"
}, {
"quoteText": "Everything in life is luck.",
"quoteAuthor": "Donald Trump"
}, {
"quoteText": "A goal without a plan is just a wish.",
"quoteAuthor": "Larry Elder"
}, {
"quoteText": "Our lives are a sum total of the choices we have made.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Watch the little things; a small leak will sink a great ship.",
"quoteAuthor": "Benjamin Franklin"
}, {
"quoteText": "When performance exceeds ambition, the overlap is called success.",
"quoteAuthor": "Cullen Hightower"
}, {
"quoteText": "Work out your own salvation. Do not depend on others.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Everyone smiles in the same language.",
"quoteAuthor": ""
}, {
"quoteText": "We do what we do because we believe.",
"quoteAuthor": ""
}, {
"quoteText": "Whoso loves, believes the impossible.",
"quoteAuthor": "Elizabeth Browning"
}, {
"quoteText": "Fate is in your hands and no one elses",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "It isn't where you come from, it's where you're going that counts.",
"quoteAuthor": "Ella Fitzgerald"
}, {
"quoteText": "Reality is merely an illusion, albeit a very persistent one.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "Your worst enemy cannot harm you as much as your own unguarded thoughts.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "The greatest obstacle to connecting with our joy is resentment.",
"quoteAuthor": "Pema Chodron"
}, {
"quoteText": "Freedom is what you do with what's been done to you.",
"quoteAuthor": "Jean-Paul Sartre"
}, {
"quoteText": "Mountains cannot be surmounted except by winding paths.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "I believe that every person is born with talent.",
"quoteAuthor": "Maya Angelou"
}, {
"quoteText": "When anger use your energy to do something productive.",
"quoteAuthor": "C. Pulsifer"
}, {
"quoteText": "Growth itself contains the germ of happiness.",
"quoteAuthor": "Pearl Buck"
}, {
"quoteText": "Victory belongs to the most persevering.",
"quoteAuthor": "Napoleon Bonaparte"
}, {
"quoteText": "We are all something, but none of us are everything.",
"quoteAuthor": "Blaise Pascal"
}, {
"quoteText": "To want to be what one can be is purpose in life.",
"quoteAuthor": "Cynthia Ozick"
}, {
"quoteText": "Intuition will tell the thinking mind where to look next.",
"quoteAuthor": "Jonas Salk"
}, {
"quoteText": "Always be mindful of the kindness and not the faults of others.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "No yesterdays are ever wasted for those who give themselves to today.",
"quoteAuthor": "Brendan Francis"
}, {
"quoteText": "Do not turn back when you are just at the goal.",
"quoteAuthor": "Publilius Syrus"
}, {
"quoteText": "Reviewing what you have learned and learning anew, you are fit to be a teacher.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Where all think alike, no one thinks very much.",
"quoteAuthor": "Walter Lippmann"
}, {
"quoteText": "Action is the foundational key to all success.",
"quoteAuthor": "Pablo Picasso"
}, {
"quoteText": "If you can't explain it simply, you don't understand it well enough.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "The truth which has made us free will in the end make us glad also.",
"quoteAuthor": "Felix Adler"
}, {
"quoteText": "Sooner or later, those who win are those who think they can.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "He who lives in harmony with himself lives in harmony with the world.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "Begin at once to live and count each separate day as a separate life.",
"quoteAuthor": "Seneca"
}, {
"quoteText": "He who knows himself is enlightened.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Growth itself contains the germ of happiness.",
"quoteAuthor": "Pearl Buck"
}, {
"quoteText": "Kind words do not cost much. Yet they accomplish much.",
"quoteAuthor": "Blaise Pascal"
}, {
"quoteText": "Think as a wise man but communicate in the language of the people.",
"quoteAuthor": "William Yeats"
}, {
"quoteText": "He who lives in harmony with himself lives in harmony with the universe.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "Kind words will unlock an iron door.",
"quoteAuthor": "Turkish proverb"
}, {
"quoteText": "Build a better mousetrap and the world will beat a path to your door.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "As our case is new, we must think and act anew.",
"quoteAuthor": "Abraham Lincoln"
}, {
"quoteText": "Fear is a darkroom where negatives develop.",
"quoteAuthor": "Usman Asif"
}, {
"quoteText": "Every action of our lives touches on some chord that will vibrate in eternity.",
"quoteAuthor": "Edwin Chapin"
}, {
"quoteText": "If you can't feed a hundred people, then feed just one.",
"quoteAuthor": "Mother Teresa"
}, {
"quoteText": "When anger use your energy to do something productive.",
"quoteAuthor": "C. Pulsifer"
}, {
"quoteText": "In three words I can sum up everything Ive learned about life: it goes on.",
"quoteAuthor": "Robert Frost"
}, {
"quoteText": "From error to error one discovers the entire truth.",
"quoteAuthor": "Sigmund Freud"
}, {
"quoteText": "The day you decide to do it is your lucky day.",
"quoteAuthor": "Japanese proverb"
}, {
"quoteText": "Happiness is not something ready made. It comes from your own actions.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Don't let today's disappointments cast a shadow on tomorrow's dreams.",
"quoteAuthor": ""
}, {
"quoteText": "Silence is a true friend who never betrays.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "As our case is new, we must think and act anew.",
"quoteAuthor": "Abraham Lincoln"
}, {
"quoteText": "Great talent finds happiness in execution.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "Keep yourself to the sunshine and you cannot see the shadow.",
"quoteAuthor": "Helen Keller"
}, {
"quoteText": "Who sows virtue reaps honour.",
"quoteAuthor": "Leonardo da Vinci"
}, {
"quoteText": "If you don't know where you are going, you will probably end up somewhere else.",
"quoteAuthor": "Lawrence Peter"
}, {
"quoteText": "Goals are the fuel in the furnace of achievement.",
"quoteAuthor": "Brian Tracy"
}, {
"quoteText": "To be wronged is nothing unless you continue to remember it.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "You always succeed in producing a result.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "Everything you are against weakens you. Everything you are for empowers you.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "As we risk ourselves, we grow. Each new experience is a risk.",
"quoteAuthor": "Fran Watson"
}, {
"quoteText": "What we achieve inwardly will change outer reality.",
"quoteAuthor": "Plutarch"
}, {
"quoteText": "Who we are never changes. Who we think we are does.",
"quoteAuthor": "Mary Almanac"
}, {
"quoteText": "If you correct your mind, the rest of your life will fall into place.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Feeling and longing are the motive forces behind all human endeavor and human creations.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "The final proof of greatness lies in being able to endure criticism without resentment.",
"quoteAuthor": "Elbert Hubbard"
}, {
"quoteText": "If you do not change direction, you may end up where you are heading.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "An obstacle may be either a stepping stone or a stumbling block.",
"quoteAuthor": ""
}, {
"quoteText": "A beautiful thing is never perfect.",
"quoteAuthor": ""
}, {
"quoteText": "A man sees in the world what he carries in his heart.",
"quoteAuthor": "Goethe"
}, {
"quoteText": "An invasion of armies can be resisted, but not an idea whose time has come.",
"quoteAuthor": "Victor Hugo"
}, {
"quoteText": "Never let lack of money interfere with having fun.",
"quoteAuthor": ""
}, {
"quoteText": "Excellence is not a skill. It is an attitude.",
"quoteAuthor": "Ralph Marston"
}, {
"quoteText": "People may doubt what you say, but they will believe what you do.",
"quoteAuthor": "Lewis Cass"
}, {
"quoteText": "The most formidable weapon against errors of every kind is reason.",
"quoteAuthor": "Thomas Paine"
}, {
"quoteText": "If there is no struggle, there is no progress.",
"quoteAuthor": "Frederick Douglass"
}, {
"quoteText": "It's important to know that words don't move mountains. Work, exacting work moves mountains.",
"quoteAuthor": "Danilo Dolci"
}, {
"quoteText": "No one can make you feel inferior without your consent.",
"quoteAuthor": "Eleanor Roosevelt"
}, {
"quoteText": "When you come to the end of your rope, tie a knot and hang on.",
"quoteAuthor": "Franklin Roosevelt"
}, {
"quoteText": "Sooner or later, those who win are those who think they can.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "Beware of missing chances; otherwise it may be altogether too late some day.",
"quoteAuthor": "Franz Liszt"
}, {
"quoteText": "You only lose what you cling to.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Life is a succession of moments. To live each one is to succeed.",
"quoteAuthor": "Corita Kent"
}, {
"quoteText": "Most of the shadows of life are caused by standing in our own sunshine.",
"quoteAuthor": "Ralph Waldo Emerson"
}, {
"quoteText": "Good actions give strength to ourselves and inspire good actions in others.",
"quoteAuthor": "Plato"
}, {
"quoteText": "I know but one freedom and that is the freedom of the mind.",
"quoteAuthor": "Antoine de Saint-Exupery"
}, {
"quoteText": "Freedom is not worth having if it does not connote freedom to err.",
"quoteAuthor": "Mohandas Gandhi"
}, {
"quoteText": "In the middle of every difficulty lies opportunity.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "Trust yourself. You know more than you think you do.",
"quoteAuthor": "Benjamin Spock"
}, {
"quoteText": "If one does not know to which port is sailing, no wind is favorable.",
"quoteAuthor": "Seneca"
}, {
"quoteText": "Wherever you go, go with all your heart.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Every human being is the author of his own health or disease.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "When in doubt, tell the truth.",
"quoteAuthor": "Mark Twain"
}, {
"quoteText": "Strength does not come from physical capacity. It comes from an indomitable will.",
"quoteAuthor": "Mahatma Gandhi"
}, {
"quoteText": "To be wronged is nothing unless you continue to remember it.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Good timber does not grow with ease; the stronger the wind, the stronger the trees.",
"quoteAuthor": "J. Willard Marriott"
}, {
"quoteText": "Every great advance in science has issued from a new audacity of the imagination.",
"quoteAuthor": "John Dewey"
}, {
"quoteText": "The path to success is to take massive, determined action.",
"quoteAuthor": "Anthony Robbins"
}, {
"quoteText": "The ladder of success is never crowded at the top.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Formula for success: under promise and over deliver.",
"quoteAuthor": "Tom Peters"
}, {
"quoteText": "What you fear is that which requires action to overcome.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Worry often gives a small thing a big shadow.",
"quoteAuthor": "Swedish proverb"
}, {
"quoteText": "He who has health has hope, and he who has hope has everything.",
"quoteAuthor": ""
}, {
"quoteText": "All great achievements require time.",
"quoteAuthor": "Maya Angelou"
}, {
"quoteText": "The heart has eyes which the brain knows nothing of.",
"quoteAuthor": "Charles Perkhurst"
}, {
"quoteText": "No person is your friend who demands your silence, or denies your right to grow.",
"quoteAuthor": "Alice Walker"
}, {
"quoteText": "A really great talent finds its happiness in execution.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "Impossibilities are merely things which we have not yet learned.",
"quoteAuthor": "Charles Chesnutt"
}, {
"quoteText": "Vision without action is a daydream. Action without vision is a nightmare.",
"quoteAuthor": "Japanese proverb"
}, {
"quoteText": "Love all, trust a few, do wrong to none.",
"quoteAuthor": "William Shakespeare"
}, {
"quoteText": "Invent your world. Surround yourself with people, color, sounds, and work that nourish you.",
"quoteAuthor": ""
}, {
"quoteText": "Today is the tomorrow you worried about yesterday.",
"quoteAuthor": ""
}, {
"quoteText": "Without faith, nothing is possible. With it, nothing is impossible.",
"quoteAuthor": "Mary Bethune"
}, {
"quoteText": "Your outlook on life is a direct reflection on how much you like yourself.",
"quoteAuthor": "Lululemon"
}, {
"quoteText": "To be wrong is nothing unless you continue to remember it.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Happiness is not something ready made. It comes from your own actions.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Life is like riding a bicycle. To keep your balance you must keep moving.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "The Superior Man is aware of Righteousness, the inferior man is aware of advantage.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "A rolling stone gathers no moss.",
"quoteAuthor": "Publilius Syrus"
}, {
"quoteText": "Trust yourself. You know more than you think you do.",
"quoteAuthor": "Benjamin Spock"
}, {
"quoteText": "He who angers you conquers you.",
"quoteAuthor": "Elizabeth Kenny"
}, {
"quoteText": "I never worry about action, but only inaction.",
"quoteAuthor": "Winston Churchill"
}, {
"quoteText": "The world makes way for the man who knows where he is going.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Ideals are an imaginative understanding of that which is desirable in that which is possible.",
"quoteAuthor": "Walter Lippmann"
}, {
"quoteText": "No man is free who is not master of himself.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "He who conquers others is strong; He who conquers himself is mighty.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "It is only when the mind and character slumber that the dress can be seen.",
"quoteAuthor": "Ralph Waldo Emerson"
}, {
"quoteText": "The truest wisdom is a resolute determination.",
"quoteAuthor": "Napoleon Bonaparte"
}, {
"quoteText": "Those that know, do. Those that understand, teach.",
"quoteAuthor": "Aristotle"
}, {
"quoteText": "If we are not fully ourselves, truly in the present moment, we miss everything.",
"quoteAuthor": "Thich Nhat Hanh"
}, {
"quoteText": "A thing long expected takes the form of the unexpected when at last it comes.",
"quoteAuthor": "Mark Twain"
}, {
"quoteText": "Do good by stealth, and blush to find it fame.",
"quoteAuthor": "Alexander Pope"
}, {
"quoteText": "An ant on the move does more than a dozing ox",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "No act of kindness, no matter how small, is ever wasted.",
"quoteAuthor": "Aesop"
}, {
"quoteText": "Every man is a volume if you know how to read him.",
"quoteAuthor": "Channing"
}, {
"quoteText": "The difficulties of life are intended to make us better, not bitter.",
"quoteAuthor": ""
}, {
"quoteText": "A good rest is half the work.",
"quoteAuthor": ""
}, {
"quoteText": "We choose our destiny in the way we treat others.",
"quoteAuthor": "Wit"
}, {
"quoteText": "In separateness lies the world's great misery, in compassion lies the world's true strength.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Everything that irritates us about others can lead us to an understanding about ourselves.",
"quoteAuthor": "Carl Jung"
}, {
"quoteText": "Better be ignorant of a matter than half know it.",
"quoteAuthor": "Publilius Syrus"
}, {
"quoteText": "You can't stop the waves, but you can learn to surf.",
"quoteAuthor": "Jon Kabat-Zinn"
}, {
"quoteText": "Quality means doing it right when no one is looking.",
"quoteAuthor": "Henry Ford"
}, {
"quoteText": "The cautious seldom err.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Change your words. Change your world.",
"quoteAuthor": ""
}, {
"quoteText": "Worry often gives a small thing a big shadow.",
"quoteAuthor": "Swedish proverb"
}, {
"quoteText": "The pessimist sees difficulty in every opportunity. The optimist sees the opportunity in every difficulty.",
"quoteAuthor": "Winston Churchill"
}, {
"quoteText": "The superior man is modest in his speech, but exceeds in his actions.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "All is flux; nothing stays still.",
"quoteAuthor": "Heraclitus"
}, {
"quoteText": "To get something you never had, you have to do something you never did.",
"quoteAuthor": ""
}, {
"quoteText": "I know but one freedom and that is the freedom of the mind.",
"quoteAuthor": "Antoine de Saint-Exupery"
}, {
"quoteText": "Every day may not be good, but there's something good in every day.",
"quoteAuthor": ""
}, {
"quoteText": "A short saying often contains much wisdom.",
"quoteAuthor": "Sophocles"
}, {
"quoteText": "Great acts are made up of small deeds.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "The foot feels the foot when it feels the ground.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "The odds of hitting your target go up dramatically when you aim at it.",
"quoteAuthor": "Mal Pancoast"
}, {
"quoteText": "It is in your moments of decision that your destiny is shaped.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "The superior man is satisfied and composed; the mean man is always full of distress.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Open minds lead to open doors.",
"quoteAuthor": ""
}, {
"quoteText": "They can do all because they think they can.",
"quoteAuthor": "Virgil"
}, {
"quoteText": "Life is the flower for which love is the honey.",
"quoteAuthor": "Victor Hugo"
}, {
"quoteText": "The secret of success is constancy to purpose.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "Courage is going from failure to failure without losing enthusiasm.",
"quoteAuthor": "Winston Churchill"
}, {
"quoteText": "The secret of success is constancy to purpose.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "You have to think anyway, so why not think big?",
"quoteAuthor": "Donald Trump"
}, {
"quoteText": "The world is a book, and those who do not travel read only a page.",
"quoteAuthor": "Augustinus Sanctus"
}, {
"quoteText": "On every thorn, delightful wisdom grows, In every rill a sweet instruction flows.",
"quoteAuthor": "Edward Young"
}, {
"quoteText": "Smile, breathe and go slowly.",
"quoteAuthor": "Thich Nhat Hanh"
}, {
"quoteText": "If one does not know to which port is sailing, no wind is favorable.",
"quoteAuthor": "Seneca"
}, {
"quoteText": "It is better to understand a little than to misunderstand a lot.",
"quoteAuthor": "Anatole France"
}, {
"quoteText": "Once you choose hope, anythings possible.",
"quoteAuthor": "Christopher Reeve"
}, {
"quoteText": "Until you make peace with who you are, you'll never be content with what you have.",
"quoteAuthor": "Doris Mortman"
}, {
"quoteText": "To enjoy life, we must touch much of it lightly.",
"quoteAuthor": "Voltaire"
}, {
"quoteText": "It is only when the mind and character slumber that the dress can be seen.",
"quoteAuthor": "Ralph Waldo Emerson"
}, {
"quoteText": "Nothing strengthens authority so much as silence.",
"quoteAuthor": "Leonardo da Vinci"
}, {
"quoteText": "Most folks are about as happy as they make up their minds to be.",
"quoteAuthor": "Abraham Lincoln"
}, {
"quoteText": "The foolish man seeks happiness in the distance, the wise grows it under his feet.",
"quoteAuthor": "James Oppenheim"
}, {
"quoteText": "Your body is precious. It is our vehicle for awakening. Treat it with care.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "You can do what's reasonable or you can decide what's possible.",
"quoteAuthor": ""
}, {
"quoteText": "Nothing is so strong as gentleness. Nothing is so gentle as real strength.",
"quoteAuthor": "Frances de Sales"
}, {
"quoteText": "Practice yourself, for heavens sake in little things, and then proceed to greater.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "Nobody will believe in you unless you believe in yourself.",
"quoteAuthor": "Liberace"
}, {
"quoteText": "The one who always loses, is the only person who gets the reward.",
"quoteAuthor": "Claire Charmont"
}, {
"quoteText": "Better be ignorant of a matter than half know it.",
"quoteAuthor": "Publilius Syrus"
}, {
"quoteText": "Character develops itself in the stream of life.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "All the flowers of all the tomorrows are in the seeds of today.",
"quoteAuthor": ""
}, {
"quoteText": "Self-complacency is fatal to progress.",
"quoteAuthor": "Margaret Sangster"
}, {
"quoteText": "Our intention creates our reality.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "You have enemies? Good. That means you've stood up for something, sometime in your life.",
"quoteAuthor": "Winston Churchill"
}, {
"quoteText": "From wonder into wonder existence opens.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Happiness is found in doing, not merely possessing.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "They say that time changes things, but you actually have to change them yourself.",
"quoteAuthor": "Andy Warhol"
}, {
"quoteText": "The future is completely open, and we are writing it moment to moment.",
"quoteAuthor": "Pema Chodron"
}, {
"quoteText": "Smile, breathe, and go slowly.",
"quoteAuthor": "Thich Nhat Hanh"
}, {
"quoteText": "I cannot make my days longer so I strive to make them better.",
"quoteAuthor": "Henry David Thoreau"
}, {
"quoteText": "No is easier to do. Yes is easier to say.",
"quoteAuthor": "Jason Fried"
}, {
"quoteText": "Nothing happens unless first we dream.",
"quoteAuthor": "Carl Sandburg"
}, {
"quoteText": "I believe that we are fundamentally the same and have the same basic potential.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Successful people ask better questions, and as a result, they get better answers.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "Happiness comes when your work and words are of benefit to yourself and others.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "There is no way to prosperity, prosperity is the way.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "I know but one freedom and that is the freedom of the mind.",
"quoteAuthor": "Antoine de Saint-Exupery"
}, {
"quoteText": "Each time we face a fear, we gain strength, courage, and confidence in the doing.",
"quoteAuthor": ""
}, {
"quoteText": "Ask yourself the secret of your success. Listen to your answer, and practice it.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "Better to have loved and lost, than to have never loved at all.",
"quoteAuthor": "St. Augustine"
}, {
"quoteText": "From error to error one discovers the entire truth.",
"quoteAuthor": "Sigmund Freud"
}, {
"quoteText": "No man can succeed in a line of endeavor which he does not like.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Don't frown because you never know who is falling in love with your smile.",
"quoteAuthor": "Sinvyest Tan"
}, {
"quoteText": "Experience is simply the name we give our mistakes.",
"quoteAuthor": "Oscar Wilde"
}, {
"quoteText": "Better be ignorant of a matter than half know it.",
"quoteAuthor": "Publilius Syrus"
}, {
"quoteText": "Trust your hunches. They're usually based on facts filed away just below the conscious level.",
"quoteAuthor": "Joyce Brothers"
}, {
"quoteText": "The place to improve the world is first in one's own heart and head and hands.",
"quoteAuthor": "Robert M. Pirsig"
}, {
"quoteText": "Nothing is at last sacred but the integrity of your own mind.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Listen to your intuition. It will tell you everything you need to know.",
"quoteAuthor": "Anthony D'Angelo"
}, {
"quoteText": "To bring anything into your life, imagine that it's already there.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "Light tomorrow with today!",
"quoteAuthor": "Elizabeth Browning"
}, {
"quoteText": "The personal life deeply lived always expands into truths beyond itself.",
"quoteAuthor": "Anais Nin"
}, {
"quoteText": "Everything is perfect in the universe � even your desire to improve it.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "The undertaking of a new action brings new strength.",
"quoteAuthor": "Richard Evans"
}, {
"quoteText": "Whenever something negative happens to you, there is a deep lesson concealed within it.",
"quoteAuthor": "Eckhart Tolle"
}, {
"quoteText": "The most complicated achievements of thought are possible without the assistance of consciousness.",
"quoteAuthor": "Sigmund Freud"
}, {
"quoteText": "Being angry never solves anything.",
"quoteAuthor": "Catherine Pulsifer"
}, {
"quoteText": "Fortune favours the brave.",
"quoteAuthor": "Virgil"
}, {
"quoteText": "What is not started today is never finished tomorrow.",
"quoteAuthor": "Goethe"
}, {
"quoteText": "I think somehow we learn who we really are and then live with that decision.",
"quoteAuthor": "Eleanor Roosevelt"
}, {
"quoteText": "Light tomorrow with today!",
"quoteAuthor": "Elizabeth Browning"
}, {
"quoteText": "You can't stop the waves, but you can learn to surf.",
"quoteAuthor": "Jon Kabat-Zinn"
}, {
"quoteText": "Nothing ever goes away until it has taught us what we need to know.",
"quoteAuthor": "Pema Chodron"
}, {
"quoteText": "Fate is in your hands and no one elses",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "The ladder of success is never crowded at the top.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Our kindness may be the most persuasive argument for that which we believe.",
"quoteAuthor": "Gordon Hinckley"
}, {
"quoteText": "It's easier to see the mistakes on someone else's paper.",
"quoteAuthor": ""
}, {
"quoteText": "Chaos is inherent in all compounded things. Strive on with diligence.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Be sure you put your feet in the right place, then stand firm.",
"quoteAuthor": "Abraham Lincoln"
}, {
"quoteText": "Everything that irritates us about others can lead us to an understanding of ourselves.",
"quoteAuthor": "Carl Jung"
}, {
"quoteText": "By believing passionately in something that does not yet exist, we create it.",
"quoteAuthor": "Nikos Kazantzakis"
}, {
"quoteText": "They must often change, who would be constant in happiness or wisdom.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "The heart has eyes which the brain knows nothing of.",
"quoteAuthor": "Charles Perkhurst"
}, {
"quoteText": "The weak can never forgive. Forgiveness is the attribute of the strong.",
"quoteAuthor": "Mohandas Gandhi"
}, {
"quoteText": "Nothing great was ever achieved without enthusiasm.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "God always takes the simplest way.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "We all have problems. The way we solve them is what makes us different.",
"quoteAuthor": ""
}, {
"quoteText": "Real magic in relationships means an absence of judgement of others.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "All serious daring starts from within.",
"quoteAuthor": "Harriet Beecher Stowe"
}, {
"quoteText": "They can do all because they think they can.",
"quoteAuthor": "Virgil"
}, {
"quoteText": "Act as if what you do makes a difference. It does.",
"quoteAuthor": "William James"
}, {
"quoteText": "The journey of a thousand miles begins with one step.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "The meaning I picked, the one that changed my life: Overcome fear, behold wonder.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "Know how to listen, and you will profit even from those who talk badly.",
"quoteAuthor": "Plutarch"
}, {
"quoteText": "It is never too late to be what you might have been.",
"quoteAuthor": "George Eliot"
}, {
"quoteText": "He who obtains has little. He who scatters has much.",
"quoteAuthor": "Richard Braunstein"
}, {
"quoteText": "A man is not old as long as he is seeking something.",
"quoteAuthor": "Edmond Rostand"
}, {
"quoteText": "Ideas are the beginning points of all fortunes.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "The time you think you're missing, misses you too.",
"quoteAuthor": "Ymber Delecto"
}, {
"quoteText": "No man was ever wise by chance.",
"quoteAuthor": "Seneca"
}, {
"quoteText": "You won't skid if you stay in a rut.",
"quoteAuthor": "Kin Hubbard"
}, {
"quoteText": "We don't stop playing because we grow old; we grow old because we stop playing.",
"quoteAuthor": "Bernard Shaw"
}, {
"quoteText": "Give thanks for the rain of life that propels us to reach new horizons.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Patience is the companion of wisdom.",
"quoteAuthor": "Saint Augustine"
}, {
"quoteText": "The foolish man seeks happiness in the distance, the wise grows it under his feet.",
"quoteAuthor": "James Oppenheim"
}, {
"quoteText": "Our kindness may be the most persuasive argument for that which we believe.",
"quoteAuthor": "Gordon Hinckley"
}, {
"quoteText": "Life is not measured by the breaths you take, but by its breathtaking moments.",
"quoteAuthor": "Michael Vance"
}, {
"quoteText": "Much wisdom often goes with fewer words.",
"quoteAuthor": "Sophocles"
}, {
"quoteText": "If you love life, don't waste time, for time is what life is made up of.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "He who talks more is sooner exhausted.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "The greatest way to live with honour in this world is to be what we pretend to be.",
"quoteAuthor": "Socrates"
}, {
"quoteText": "Imagination is the living power and prime agent of all human perception.",
"quoteAuthor": "Samuel Taylor Coleridge"
}, {
"quoteText": "I'm not afraid of storms, for Im learning how to sail my ship.",
"quoteAuthor": "Louisa Alcott"
}, {
"quoteText": "The greatest minds are capable of the greatest vices as well as of the greatest virtues.",
"quoteAuthor": "Rene Descartes"
}, {
"quoteText": "Victory belongs to the most persevering.",
"quoteAuthor": "Napoleon Bonaparte"
}, {
"quoteText": "All that we are is the result of what we have thought. The mind is everything. What we think we become.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "When your desires are strong enough you will appear to possess superhuman powers to achieve.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "What lies behind us and what lies before us are small matters compared to what lies within us.",
"quoteAuthor": "Oliver Holmes"
}, {
"quoteText": "Be slow of tongue and quick of eye.",
"quoteAuthor": "Cervantes"
}, {
"quoteText": "It is impossible to feel grateful and depressed in the same moment.",
"quoteAuthor": "Naomi Williams"
}, {
"quoteText": "A friend is someone who understands your past, believes in your future, and accepts you just the way you are.",
"quoteAuthor": ""
}, {
"quoteText": "The path to success is to take massive, determined action.",
"quoteAuthor": "Anthony Robbins"
}, {
"quoteText": "What lies behind us and what lies before us are tiny matters compared to what lies within us.",
"quoteAuthor": "Walt Emerson"
}, {
"quoteText": "Progress always involves risks. You can't steal second base and keep your foot on first.",
"quoteAuthor": "Frederick Wilcox"
}, {
"quoteText": "Peace comes from within. Do not seek it without.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Bad things are not the worst things that can happen to us. Nothing is the worst thing that can happen to us!",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "Liberty, taking the word in its concrete sense, consists in the ability to choose.",
"quoteAuthor": "Simone Weil"
}, {
"quoteText": "Blaze with the fire that is never extinguished.",
"quoteAuthor": "Luisa Sigea"
}, {
"quoteText": "There are no failures � just experiences and your reactions to them.",
"quoteAuthor": "Tom Krause"
}, {
"quoteText": "He that never changes his opinions, never corrects his mistakes, and will never be wiser on the morrow than he is today.",
"quoteAuthor": "Tryon Edwards"
}, {
"quoteText": "On every thorn, delightful wisdom grows, In every rill a sweet instruction flows.",
"quoteAuthor": "Edward Young"
}, {
"quoteText": "If you would take, you must first give, this is the beginning of intelligence.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "A thing well said will be wit in all languages.",
"quoteAuthor": "John Dryden"
}, {
"quoteText": "Write your plans in pencil and give God the eraser.",
"quoteAuthor": "Paulo Coelho"
}, {
"quoteText": "No is easier to do. Yes is easier to say.",
"quoteAuthor": "Jason Fried"
}, {
"quoteText": "Always do your best. What you plant now, you will harvest later.",
"quoteAuthor": "Og Mandino"
}, {
"quoteText": "My mama always said: life's like a box of chocolate � you never know what you gonna get.",
"quoteAuthor": "Forrest Gump"
}, {
"quoteText": "We are the leaves of one branch, the drops of one sea, the flowers of one garden.",
"quoteAuthor": "Jean Lacordaire"
}, {
"quoteText": "If you light a lamp for somebody, it will also brighten your path.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Strength does not come from physical capacity. It comes from an indomitable will.",
"quoteAuthor": "Mahatma Gandhi"
}, {
"quoteText": "If you come to a fork in the road, take it.",
"quoteAuthor": ""
}, {
"quoteText": "Life is 10% what happens to you and 90% how you react to it.",
"quoteAuthor": "Charles Swindoll"
}, {
"quoteText": "Error is discipline through which we advance.",
"quoteAuthor": "Channing"
}, {
"quoteText": "How wonderful that we have met with a paradox. Now we have some hope of making progress.",
"quoteAuthor": "Niels Bohr"
}, {
"quoteText": "Be slow of tongue and quick of eye.",
"quoteAuthor": "Cervantes"
}, {
"quoteText": "He who conquers others is strong; He who conquers himself is mighty.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "The best way to pay for a lovely moment is to enjoy it.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "If we are facing in the right direction, all we have to do is keep on walking.",
"quoteAuthor": ""
}, {
"quoteText": "It is not only for what we do that we are held responsible, but also for what we do not do.",
"quoteAuthor": "Moliere"
}, {
"quoteText": "The only way to tell the truth is to speak with kindness. Only the words of a loving man can be heard.",
"quoteAuthor": "Henry Thoreau"
}, {
"quoteText": "As the rest of the world is walking out the door, your best friends are the ones walking in.",
"quoteAuthor": ""
}, {
"quoteText": "The greatest minds are capable of the greatest vices as well as of the greatest virtues.",
"quoteAuthor": "Rene Descartes"
}, {
"quoteText": "Someone is special only if you tell them.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "It's so simple to be wise. Just think of something stupid to say and then don't say it.",
"quoteAuthor": "Sam Levenson"
}, {
"quoteText": "A man is great by deeds, not by birth.",
"quoteAuthor": "Chanakya"
}, {
"quoteText": "No garden is without its weeds.",
"quoteAuthor": "Thomas Fuller"
}, {
"quoteText": "Nobody can do everything, but everybody can do something.",
"quoteAuthor": ""
}, {
"quoteText": "The world has the habit of making room for the man whose actions show that he knows where he is going.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Quality is never an accident; it is always the result of intelligent effort.",
"quoteAuthor": "John Ruskin"
}, {
"quoteText": "You cannot step twice into the same river, for other waters are continually flowing in.",
"quoteAuthor": "Heraclitus"
}, {
"quoteText": "We should all be thankful for those people who rekindle the inner spirit.",
"quoteAuthor": "Albert Schweitzer"
}, {
"quoteText": "The only difference between your abilities and others is the ability to put yourself in their shoes and actually try.",
"quoteAuthor": "Leonardo Ruiz"
}, {
"quoteText": "All great achievements require time.",
"quoteAuthor": "Maya Angelou"
}, {
"quoteText": "Never idealize others. They will never live up to your expectations.",
"quoteAuthor": "Leo Buscaglia"
}, {
"quoteText": "Excellence is to do a common thing in an uncommon way.",
"quoteAuthor": "Booker Washington"
}, {
"quoteText": "Edison failed 10,000 times before he made the electric light. Do not be discouraged if you fail a few times.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "No matter how hard the past, you can always begin again.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "I begin with an idea and then it becomes something else.",
"quoteAuthor": "Pablo Picasso"
}, {
"quoteText": "May our hearts garden of awakening bloom with hundreds of flowers.",
"quoteAuthor": "Thich Nhat Hanh"
}, {
"quoteText": "Friends are those rare people who ask how we are and then wait to hear the answer.",
"quoteAuthor": "Ed Cunningham"
}, {
"quoteText": "It is the mark of an educated mind to be able to entertain a thought without accepting it.",
"quoteAuthor": "Aristotle"
}, {
"quoteText": "Every adversity, every failure, every heartache carries with it the seed of an equal or greater benefit.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Whoever is happy will make others happy, too.",
"quoteAuthor": "Mark Twain"
}, {
"quoteText": "The purpose of learning is growth, and our minds, unlike our bodies, can continue growing as we continue to live.",
"quoteAuthor": "Mortimer Adler"
}, {
"quoteText": "He that respects himself is safe from others; he wears a coat of mail that none can pierce.",
"quoteAuthor": "Henry Longfellow"
}, {
"quoteText": "The bird of paradise alights only upon the hand that does not grasp.",
"quoteAuthor": "John Berry"
}, {
"quoteText": "Difficulties increase the nearer we get to the goal.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "Act as if what you do makes a difference. It does.",
"quoteAuthor": "William James"
}, {
"quoteText": "To accomplish great things, we must dream as well as act.",
"quoteAuthor": "Anatole France"
}, {
"quoteText": "You can adopt the attitude there is nothing you can do, or you can see the challenge as your call to action.",
"quoteAuthor": "Catherine Pulsifer"
}, {
"quoteText": "Your work is to discover your work and then with all your heart to give yourself to it.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "There are only two mistakes one can make along the road to truth; not going all the way, and not starting.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "It's not what happens to you, but how you react to it that matters.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "It is very easy to forgive others their mistakes; it takes more grit to forgive them for having witnessed your own.",
"quoteAuthor": "Jessamyn West"
}, {
"quoteText": "Take it easy � but take it.",
"quoteAuthor": "Woody Guthrie"
}, {
"quoteText": "Don't wait for your feelings to change to take the action. Take the action and your feelings will change.",
"quoteAuthor": "Barbara Baron"
}, {
"quoteText": "There is no duty we so underrate as the duty of being happy. By being happy we sow anonymous benefits upon the world.",
"quoteAuthor": "Robert Louis Stevenson"
}, {
"quoteText": "Whoever is happy will make others happy, too.",
"quoteAuthor": "Mark Twain"
}, {
"quoteText": "Never apologize for showing feeling. When you do so, you apologize for truth.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "Where all think alike, no one thinks very much.",
"quoteAuthor": "Walter Lippmann"
}, {
"quoteText": "What is new in the world? Nothing. What is old in the world? Nothing. Everything has always been and will always be.",
"quoteAuthor": "Sai Baba"
}, {
"quoteText": "Face your deficiencies and acknowledge them; but do not let them master you. Let them teach you patience, sweetness, insight.",
"quoteAuthor": "Helen Keller"
}, {
"quoteText": "I have done my best: that is about all the philosophy of living one needs.",
"quoteAuthor": "Lin-yutang"
}, {
"quoteText": "To accomplish great things, we must dream as well as act.",
"quoteAuthor": "Anatole France"
}, {
"quoteText": "The beginning is always today.",
"quoteAuthor": "Mary Wollstonecraft"
}, {
"quoteText": "Keep true to the dreams of thy youth.",
"quoteAuthor": "Friedrich von Schiller"
}, {
"quoteText": "Just as a candle cannot burn without fire, men cannot live without a spiritual life.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "The winds and waves are always on the side of the ablest navigators.",
"quoteAuthor": "Edward Gibbon"
}, {
"quoteText": "Take rest; a field that has rested gives a bountiful crop.",
"quoteAuthor": "Ovid"
}, {
"quoteText": "Truth isn't all about what actually happens but more about how what has happened is interpreted.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Age does not protect you from love. But love, to some extent, protects you from age.",
"quoteAuthor": "Anais Nin"
}, {
"quoteText": "Men are disturbed not by things, but by the view which they take of them.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "Let us revere, let us worship, but erect and open-eyed, the highest, not the lowest; the future, not the past!",
"quoteAuthor": "Charlotte Gilman"
}, {
"quoteText": "Every man takes the limits of his own field of vision for the limits of the world.",
"quoteAuthor": "Arthur Schopenhauer"
}, {
"quoteText": "Doing what you love is the cornerstone of having abundance in your life.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "May our hearts garden of awakening bloom with hundreds of flowers.",
"quoteAuthor": "Thich Nhat Hanh"
}, {
"quoteText": "Do what you can. Want what you have. Be who you are.",
"quoteAuthor": "Forrest Church"
}, {
"quoteText": "There are people who have money and people who are rich.",
"quoteAuthor": "Coco Chanel"
}, {
"quoteText": "He that respects himself is safe from others; he wears a coat of mail that none can pierce.",
"quoteAuthor": "Henry Longfellow"
}, {
"quoteText": "The greatest good you can do for another is not just share your riches, but reveal to them their own.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "Why worry about tomorrow, when today is all we have?",
"quoteAuthor": ""
}, {
"quoteText": "Speak when you are angry and you will make the best speech you will ever regret.",
"quoteAuthor": "Ambrose Bierce"
}, {
"quoteText": "To accomplish great things, we must dream as well as act.",
"quoteAuthor": "Anatole France"
}, {
"quoteText": "Things do not change, we change.",
"quoteAuthor": "Henry Thoreau"
}, {
"quoteText": "The exercise of an extraordinary gift is the supremest pleasure in life.",
"quoteAuthor": "Mark Twain"
}, {
"quoteText": "Sometimes the most important thing in a whole day is the rest we take between two deep breaths.",
"quoteAuthor": "Etty Hillesum"
}, {
"quoteText": "The first requisite for success is the ability to apply your physical and mental energies to one problem incessantly without growing weary.",
"quoteAuthor": "Thomas Edison"
}, {
"quoteText": "To be wronged is nothing unless you continue to remember it.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "We should all be thankful for those people who rekindle the inner spirit.",
"quoteAuthor": "Albert Schweitzer"
}, {
"quoteText": "There is no greater harm than that of time wasted.",
"quoteAuthor": "Michelangelo"
}, {
"quoteText": "Forgiveness is choosing to love. It is the first skill of self-giving love.",
"quoteAuthor": "Mohandas Gandhi"
}, {
"quoteText": "To accomplish great things, we must dream as well as act.",
"quoteAuthor": "Anatole France"
}, {
"quoteText": "It is only with the heart that one can see rightly, what is essential is invisible to the eye.",
"quoteAuthor": "Antoine de Saint-Exupery"
}, {
"quoteText": "To ensure good health: eat lightly, breathe deeply, live moderately, cultivate cheerfulness, and maintain an interest in life.",
"quoteAuthor": "William Londen"
}, {
"quoteText": "Believe deep down in your heart that you're destined to do great things.",
"quoteAuthor": "Joe Paterno"
}, {
"quoteText": "Nothing is so strong as gentleness. Nothing is so gentle as real strength.",
"quoteAuthor": "Frances de Sales"
}, {
"quoteText": "If you cannot do great things, do small things in a great way.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Experience is simply the name we give our mistakes.",
"quoteAuthor": "Oscar Wilde"
}, {
"quoteText": "Most smiles are started by another smile.",
"quoteAuthor": ""
}, {
"quoteText": "Think how hard physics would be if particles could think.",
"quoteAuthor": "Murray Gell-Mann"
}, {
"quoteText": "Man is equally incapable of seeing the nothingness from which he emerges and the infinity in which he is engulfed.",
"quoteAuthor": "Blaise Pascal"
}, {
"quoteText": "Imagination is the highest kite one can fly.",
"quoteAuthor": "Lauren Bacall"
}, {
"quoteText": "The best way out is always through.",
"quoteAuthor": "Robert Frost"
}, {
"quoteText": "Nature gave us one tongue and two ears so we could hear twice as much as we speak.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "Nothing is softer or more flexible than water, yet nothing can resist it.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "The only limit to our realization of tomorrow will be our doubts of today.",
"quoteAuthor": "Franklin Roosevelt"
}, {
"quoteText": "It is difficult to achieve a spirit of genuine cooperation as long as people remain indifferent to the feelings and happiness of others.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "The exercise of an extraordinary gift is the supremest pleasure in life.",
"quoteAuthor": "Mark Twain"
}, {
"quoteText": "To exist is to change, to change is to mature, to mature is to go on creating oneself endlessly.",
"quoteAuthor": "Henri Bergson"
}, {
"quoteText": "A man is not where he lives but where he loves.",
"quoteAuthor": ""
}, {
"quoteText": "Experience keeps a dear school, but fools will learn in no other.",
"quoteAuthor": "Benjamin Franklin"
}, {
"quoteText": "The heart has eyes which the brain knows nothing of.",
"quoteAuthor": "Charles Perkhurst"
}, {
"quoteText": "We can only be said to be alive in those moments when our hearts are conscious of our treasures.",
"quoteAuthor": "Thornton Wilder"
}, {
"quoteText": "Fine words and an insinuating appearance are seldom associated with true virtue",
"quoteAuthor": "Confucius"
}, {
"quoteText": "A subtle thought that is in error may yet give rise to fruitful inquiry that can establish truths of great value.",
"quoteAuthor": "Isaac Asimov"
}, {
"quoteText": "Thousands of candles can be lit from a single, and the life of the candle will not be shortened. Happiness never decreases by being shared.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "If you're walking down the right path and you're willing to keep walking, eventually you'll make progress.",
"quoteAuthor": "Barack Obama"
}, {
"quoteText": "Someone remembers, someone cares; your name is whispered in someone's prayers.",
"quoteAuthor": ""
}, {
"quoteText": "It is more important to know where you are going than to get there quickly. Do not mistake activity for achievement.",
"quoteAuthor": "Mabel Newcomber"
}, {
"quoteText": "God always takes the simplest way.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "Every artist dips his brush in his own soul, and paints his own nature into his pictures.",
"quoteAuthor": "Henry Ward Beecher"
}, {
"quoteText": "When you don't know what you believe, everything becomes an argument. Everything is debatable. But when you stand for something, decisions are obvious.",
"quoteAuthor": ""
}, {
"quoteText": "Those that know, do. Those that understand, teach.",
"quoteAuthor": "Aristotle"
}, {
"quoteText": "The conditions of conquest are always easy. We have but to toil awhile, endure awhile, believe always, and never turn back.",
"quoteAuthor": "Seneca"
}, {
"quoteText": "You can be what you want to be. You have the power within and we will help you always.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "He who knows himself is enlightened.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "The universe is transformation; our life is what our thoughts make it.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "Our kindness may be the most persuasive argument for that which we believe.",
"quoteAuthor": "Gordon Hinckley"
}, {
"quoteText": "We do not quit playing because we grow old, we grow old because we quit playing.",
"quoteAuthor": "Oliver Holmes"
}, {
"quoteText": "You can't choose up sides on a round world.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "The possession of knowledge does not kill the sense of wonder and mystery. There is always more mystery.",
"quoteAuthor": "Anais Nin"
}, {
"quoteText": "What you do not want done to yourself, do not do to others.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "With realization of ones own potential and self-confidence in ones ability, one can build a better world.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Fortune favours the brave.",
"quoteAuthor": "Virgil"
}, {
"quoteText": "You can adopt the attitude there is nothing you can do, or you can see the challenge as your call to action.",
"quoteAuthor": "Catherine Pulsifer"
}, {
"quoteText": "A man is not old as long as he is seeking something.",
"quoteAuthor": "Edmond Rostand"
}, {
"quoteText": "Happiness depends upon ourselves.",
"quoteAuthor": "Aristotle"
}, {
"quoteText": "Smile, breathe and go slowly.",
"quoteAuthor": "Thich Nhat Hanh"
}, {
"quoteText": "A man is not old as long as he is seeking something.",
"quoteAuthor": "Edmond Rostand"
}, {
"quoteText": "Imagination is the living power and prime agent of all human perception.",
"quoteAuthor": "Samuel Taylor Coleridge"
}, {
"quoteText": "The smallest flower is a thought, a life answering to some feature of the Great Whole, of whom they have a persistent intuition.",
"quoteAuthor": "Honore de Balzac"
}, {
"quoteText": "My advice to you is not to inquire why or whither, but just enjoy your ice cream while its on your plate � that's my philosophy.",
"quoteAuthor": "Thornton Wilder"
}, {
"quoteText": "Everyone has been made for some particular work, and the desire for that work has been put in every heart.",
"quoteAuthor": "Rumi"
}, {
"quoteText": "When you have got an elephant by the hind legs and he is trying to run away, it's best to let him run.",
"quoteAuthor": "Abraham Lincoln"
}, {
"quoteText": "Kindness is the language which the deaf can hear and the blind can see.",
"quoteAuthor": "Mark Twain"
}, {
"quoteText": "Be the chief but never the lord.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Every action of our lives touches on some chord that will vibrate in eternity.",
"quoteAuthor": "Edwin Chapin"
}, {
"quoteText": "I may not know everything, but everything is not known yet anyway.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "The bird of paradise alights only upon the hand that does not grasp.",
"quoteAuthor": "John Berry"
}, {
"quoteText": "If we could see the miracle of a single flower clearly, our whole life would change.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "You have to take it as it happens, but you should try to make it happen the way you want to take it.",
"quoteAuthor": "Old German proverb"
}, {
"quoteText": "Without this playing with fantasy no creative work has ever yet come to birth. The debt we owe to the play of the imagination is incalculable.",
"quoteAuthor": "Carl Jung"
}, {
"quoteText": "You cannot travel the path until you have become the path itself.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "I believe that we are solely responsible for our choices, and we have to accept the consequences of every deed, word, and thought throughout our lifetime.",
"quoteAuthor": "Elisabeth Kubler-Ross"
}, {
"quoteText": "Keep your eyes on the stars and your feet on the ground.",
"quoteAuthor": "Theodore Roosevelt"
}, {
"quoteText": "I am not afraid of tomorrow, for I have seen yesterday and I love today.",
"quoteAuthor": "William White"
}, {
"quoteText": "Limitations live only in our minds. But if we use our imaginations, our possibilities become limitless.",
"quoteAuthor": "Jamie Paolinetti"
}, {
"quoteText": "If you are patient in one moment of anger, you will escape one hundred days of sorrow.",
"quoteAuthor": "Chinese proverb"
}, {
"quoteText": "When you lose, don't lose the lesson.",
"quoteAuthor": ""
}, {
"quoteText": "Character develops itself in the stream of life.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "If you want a thing done well, do it yourself.",
"quoteAuthor": "Napoleon Bonaparte"
}, {
"quoteText": "All the great performers I have worked with are fuelled by a personal dream.",
"quoteAuthor": "John Eliot"
}, {
"quoteText": "It's so simple to be wise. Just think of something stupid to say and then don't say it.",
"quoteAuthor": "Sam Levenson"
}, {
"quoteText": "No one has ever become poor by giving.",
"quoteAuthor": "Anne Frank"
}, {
"quoteText": "You can adopt the attitude there is nothing you can do, or you can see the challenge as your call to action.",
"quoteAuthor": "Catherine Pulsifer"
}, {
"quoteText": "An obstacle may be either a stepping stone or a stumbling block.",
"quoteAuthor": ""
}, {
"quoteText": "Everything can be taken from a man but ... the last of the human freedoms � to choose ones attitude in any given set of circumstances, to choose ones own way.",
"quoteAuthor": "Victor Frankl"
}, {
"quoteText": "I think and that is all that I am.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "The greatest barrier to success is the fear of failure.",
"quoteAuthor": "Eriksson"
}, {
"quoteText": "Sunshine is delicious, rain is refreshing, wind braces us up, snow is exhilarating; there is really no such thing as bad weather, only different kinds of good weather.",
"quoteAuthor": "John Ruskin"
}, {
"quoteText": "If you are patient in one moment of anger, you will escape one hundred days of sorrow.",
"quoteAuthor": "Chinese proverb"
}, {
"quoteText": "I want you to be everything that's you, deep at the center of your being.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "The heart has eyes which the brain knows nothing of.",
"quoteAuthor": "Charles Perkhurst"
}, {
"quoteText": "If you aren't going all the way, why go at all?",
"quoteAuthor": "Joe Namath"
}, {
"quoteText": "Our greatest glory is not in never falling, but in rising every time we fall.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "We choose our destiny in the way we treat others.",
"quoteAuthor": "Wit"
}, {
"quoteText": "There are things so deep and complex that only intuition can reach it in our stage of development as human beings.",
"quoteAuthor": "John Astin"
}, {
"quoteText": "If one advances confidently in the direction of his dream, and endeavours to live the life which he had imagines, he will meet with a success unexpected in common hours.",
"quoteAuthor": "Henry David Thoreau"
}, {
"quoteText": "The beginning of wisdom is found in doubting; by doubting we come to the question, and by seeking we may come upon the truth.",
"quoteAuthor": "Pierre Abelard"
}, {
"quoteText": "We can only be said to be alive in those moments when our hearts are conscious of our treasures.",
"quoteAuthor": "Thornton Wilder"
}, {
"quoteText": "Wicked people are always surprised to find ability in those that are good.",
"quoteAuthor": "Marquis Vauvenargues"
}, {
"quoteText": "If I could reach up and hold a star for every time you've made me smile, the entire evening sky would be in the palm of my hand.",
"quoteAuthor": ""
}, {
"quoteText": "We are shaped by our thoughts; we become what we think. When the mind is pure, joy follows like a shadow that never leaves.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Happiness is when what you think, what you say, and what you do are in harmony.",
"quoteAuthor": "Mohandas Gandhi"
}, {
"quoteText": "A wise man can learn more from a foolish question than a fool can learn from a wise answer.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "You have enemies? Good. That means you've stood up for something, sometime in your life.",
"quoteAuthor": "Winston Churchill"
}, {
"quoteText": "Kind words do not cost much. Yet they accomplish much.",
"quoteAuthor": "Blaise Pascal"
}, {
"quoteText": "I destroy my enemies when I make them my friends.",
"quoteAuthor": "Abraham Lincoln"
}, {
"quoteText": "Feeling and longing are the motive forces behind all human endeavor and human creations.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "Any of us can achieve virtue, if by virtue we merely mean the avoidance of the vices that do not attract us.",
"quoteAuthor": "Robert Lynd"
}, {
"quoteText": "Stay committed to your decisions, but stay flexible in your approach.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "The path to success is to take massive, determined action.",
"quoteAuthor": "Anthony Robbins"
}, {
"quoteText": "One who gains strength by overcoming obstacles possesses the only strength which can overcome adversity.",
"quoteAuthor": "Albert Schweitzer"
}, {
"quoteText": "An optimist is a person who sees a green light everywhere, while the pessimist sees only the red spotlight... The truly wise person is colour-blind.",
"quoteAuthor": "Albert Schweitzer"
}, {
"quoteText": "What separates the winners from the losers is how a person reacts to each new twist of fate.",
"quoteAuthor": "Donald Trump"
}, {
"quoteText": "Ignorant men don't know what good they hold in their hands until they've flung it away.",
"quoteAuthor": "Sophocles"
}, {
"quoteText": "One does not discover new lands without consenting to lose sight of the shore for a very long time.",
"quoteAuthor": "Andr� Gide"
}, {
"quoteText": "All our talents increase in the using, and the every faculty, both good and bad, strengthen by exercise.",
"quoteAuthor": "Anne Bronte"
}, {
"quoteText": "Tension is who you think you should be. Relaxation is who you are.",
"quoteAuthor": "Chinese proverb"
}, {
"quoteText": "I have just three things to teach: simplicity, patience, compassion. These three are your greatest treasures.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Most of the important things in the world have been accomplished by people who have kept on trying when there seemed to be no hope at all.",
"quoteAuthor": "Dale Carnegie"
}, {
"quoteText": "Each man has his own vocation; his talent is his call. There is one direction in which all space is open to him.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "We do what we do because we believe.",
"quoteAuthor": ""
}, {
"quoteText": "Never bend your head. Always hold it high. Look the world right in the eye.",
"quoteAuthor": "Helen Keller"
}, {
"quoteText": "Just as a flower, which seems beautiful has color but no perfume, so are the fruitless words of a man who speaks them but does them not.",
"quoteAuthor": "Dhammapada"
}, {
"quoteText": "Chance is always powerful. Let your hook be always cast; in the pool where you least expect it, there will be a fish.",
"quoteAuthor": "Ovid"
}, {
"quoteText": "Just as a candle cannot burn without fire, men cannot live without a spiritual life.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Sometimes it is better to lose and do the right thing than to win and do the wrong thing.",
"quoteAuthor": "Tony Blair"
}, {
"quoteText": "Silence is the true friend that never betrays.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Imagination disposes of everything; it creates beauty, justice, and happiness, which are everything in this world.",
"quoteAuthor": "Blaise Pascal"
}, {
"quoteText": "To want to be what one can be is purpose in life.",
"quoteAuthor": "Cynthia Ozick"
}, {
"quoteText": "To change ones life, start immediately, do it flamboyantly, no exceptions.",
"quoteAuthor": "William James"
}, {
"quoteText": "I have done my best: that is about all the philosophy of living one needs.",
"quoteAuthor": "Lin-yutang"
}, {
"quoteText": "As we express our gratitude, we must never forget that the highest appreciation is not to utter words, but to live by them.",
"quoteAuthor": "John F. Kennedy"
}, {
"quoteText": "If you let go a little, you will have a little peace. If you let go a lot, you will have a lot of peace.",
"quoteAuthor": "Ajahn Chah"
}, {
"quoteText": "Whoever is happy will make others happy, too.",
"quoteAuthor": "Mark Twain"
}, {
"quoteText": "Character develops itself in the stream of life.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "Everything can be taken from a man but ... the last of the human freedoms � to choose ones attitude in any given set of circumstances, to choose ones own way.",
"quoteAuthor": "Victor Frankl"
}, {
"quoteText": "Better than a thousand hollow words, is one word that brings peace.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Man cannot discover new oceans unless he has the courage to lose sight of the shore.",
"quoteAuthor": "Andr� Gide"
}, {
"quoteText": "The only real valuable thing is intuition.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "The world cares very little about what a man or woman knows; it is what a man or woman is able to do that counts.",
"quoteAuthor": "Booker Washington"
}, {
"quoteText": "The steeper the mountain the harder the climb the better the view from the finishing line",
"quoteAuthor": ""
}, {
"quoteText": "Aim for success, not perfection. Never give up your right to be wrong, because then you will lose the ability to learn new things and move forward with your life.",
"quoteAuthor": "Dr. David M. Burns"
}, {
"quoteText": "Wisdom begins in wonder.",
"quoteAuthor": "Socrates"
}, {
"quoteText": "I have done my best: that is about all the philosophy of living one needs.",
"quoteAuthor": "Lin-yutang"
}, {
"quoteText": "Forgiveness is choosing to love. It is the first skill of self-giving love.",
"quoteAuthor": "Mohandas Gandhi"
}, {
"quoteText": "Peace cannot be kept by force. It can only be achieved by understanding.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "When I let go of what I am, I become what I might be.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Transformation does not start with some one else changing you; transformation is an inner self reworking of what you are now to what you will be.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "It does not matter how slowly you go as long as you do not stop.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Time is not a measure the length of a day or month or year but more a measure of what you have accomplished.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Wherever a man may happen to turn, whatever a man may undertake, he will always end up by returning to the path which nature has marked out for him.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "No person is your friend who demands your silence, or denies your right to grow.",
"quoteAuthor": "Alice Walker"
}, {
"quoteText": "Holding on to anger is like grasping a hot coal with the intent of throwing it at someone else; you are the one who gets burned.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Peace comes from within. Do not seek it without.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "When there is no enemy within, the enemies outside cannot hurt you.",
"quoteAuthor": "African proverb"
}, {
"quoteText": "He who controls others may be powerful, but he who has mastered himself is mightier still.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "You may say Im a dreamer, but Im not the only one, I hope someday you will join us, and the world will live as one.",
"quoteAuthor": "John Lennon"
}, {
"quoteText": "There is no scarcity of opportunity to make a living at what you love; theres only scarcity of resolve to make it happen.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Neither a lofty degree of intelligence nor imagination nor both together go to the making of genius. Love, love, love, that is the soul of genius.",
"quoteAuthor": "Wolfgang Amadeus Mozart"
}, {
"quoteText": "The happy and efficient people in this world are those who accept trouble as a normal detail of human life and resolve to capitalize it when it comes along.",
"quoteAuthor": "H. Bertram Lewis"
}, {
"quoteText": "Every adversity, every failure, every heartache carries with it the seed of an equal or greater benefit.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Whatever we expect with confidence becomes our own self-fulfilling prophecy.",
"quoteAuthor": "Brian Tracy"
}, {
"quoteText": "The final proof of greatness lies in being able to endure criticism without resentment.",
"quoteAuthor": "Elbert Hubbard"
}, {
"quoteText": "As an organizer I start from where the world is, as it is, not as I would like it to be.",
"quoteAuthor": "Saul Alinsky"
}, {
"quoteText": "The biggest adventure you can ever take is to live the life of your dreams.",
"quoteAuthor": "Oprah Winfrey"
}, {
"quoteText": "You are the only person on Earth who can use your ability.",
"quoteAuthor": "Zig Ziglar"
}, {
"quoteText": "Don't let what you can't do stop you from doing what you can do.",
"quoteAuthor": ""
}, {
"quoteText": "Complaining doesn't change a thing only taking action does.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Life a culmination of the past, an awareness of the present, an indication of the future beyond knowledge, the quality that gives a touch of divinity to matter.",
"quoteAuthor": "Charles A. Lindbergh"
}, {
"quoteText": "Each man has his own vocation; his talent is his call. There is one direction in which all space is open to him.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "If you can't feed a hundred people, then feed just one.",
"quoteAuthor": "Mother Teresa"
}, {
"quoteText": "Everything that exists is in a manner the seed of that which will be.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "Enjoy the little things, for one day you may look back and realize they were the big things.",
"quoteAuthor": "Robert Brault"
}, {
"quoteText": "With every experience, you alone are painting your own canvas, thought by thought, choice by choice.",
"quoteAuthor": "Oprah Winfrey"
}, {
"quoteText": "Think how hard physics would be if particles could think.",
"quoteAuthor": "Murray Gell-Mann"
}, {
"quoteText": "Let the beauty of what you love be what you do.",
"quoteAuthor": "Rumi"
}, {
"quoteText": "The world turns aside to let any man pass who knows where he is going.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "I can't imagine a person becoming a success who doesn't give this game of life everything hes got.",
"quoteAuthor": "Walter Cronkite"
}, {
"quoteText": "Beauty is not in the face; beauty is a light in the heart.",
"quoteAuthor": "Kahlil Gibran"
}, {
"quoteText": "A day of worry is more exhausting than a day of work.",
"quoteAuthor": "John Lubbock"
}, {
"quoteText": "I never think of the future. It comes soon enough.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "It isn't where you come from, it's where you're going that counts.",
"quoteAuthor": "Ella Fitzgerald"
}, {
"quoteText": "He who controls others may be powerful, but he who has mastered himself is mightier still.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Truth, and goodness, and beauty are but different faces of the same all.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "All I can say about life is, Oh God, enjoy it!",
"quoteAuthor": "Bob Newhart"
}, {
"quoteText": "Trust your hunches. They're usually based on facts filed away just below the conscious level.",
"quoteAuthor": "Joyce Brothers"
}, {
"quoteText": "The day is already blessed, find peace within it.",
"quoteAuthor": ""
}, {
"quoteText": "Tension is who you think you should be. Relaxation is who you are.",
"quoteAuthor": "Chinese proverb"
}, {
"quoteText": "To be great is to be misunderstood.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Love all, trust a few, do wrong to none.",
"quoteAuthor": "William Shakespeare"
}, {
"quoteText": "Consider that not only do negative thoughts and emotions destroy our experience of peace, they also undermine our health.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "We all live with the objective of being happy; our lives are all different and yet the same.",
"quoteAuthor": "Anne Frank"
}, {
"quoteText": "Trust only movement. Life happens at the level of events, not of words. Trust movement.",
"quoteAuthor": "Alfred Adler"
}, {
"quoteText": "Never, never, never give up.",
"quoteAuthor": "Winston Churchill"
}, {
"quoteText": "Think as a wise man but communicate in the language of the people.",
"quoteAuthor": "William Yeats"
}, {
"quoteText": "Parents can only give good advice or put them on the right paths, but the final forming of a persons character lies in their own hands.",
"quoteAuthor": "Anne Frank"
}, {
"quoteText": "I prefer to be true to myself, even at the hazard of incurring the ridicule of others, rather than to be false, and to incur my own abhorrence.",
"quoteAuthor": "Frederick Douglass"
}, {
"quoteText": "The most decisive actions of our life... are most often unconsidered actions.",
"quoteAuthor": "Andr� Gide"
}, {
"quoteText": "As we grow as unique persons, we learn to respect the uniqueness of others.",
"quoteAuthor": "Robert Schuller"
}, {
"quoteText": "Failure doesn't mean you are a failure it just means you haven't succeeded yet.",
"quoteAuthor": "Robert Schuller"
}, {
"quoteText": "Conflict is the gadfly of thought. It stirs us to observation and memory. It instigates to invention. It shocks us out of sheeplike passivity, and sets us at noting and contriving.",
"quoteAuthor": "John Dewey"
}, {
"quoteText": "Success is not the key to happiness. Happiness is the key to success. If you love what you are doing, you will be successful.",
"quoteAuthor": "Albert Schweitzer"
}, {
"quoteText": "No pessimist ever discovered the secrets of the stars, or sailed to an uncharted land, or opened a new heaven to the human spirit.",
"quoteAuthor": "Helen Keller"
}, {
"quoteText": "Those who are blessed with the most talent don't necessarily outperform everyone else. It's the people with follow-through who excel.",
"quoteAuthor": "Mary Kay Ash"
}, {
"quoteText": "They can do all because they think they can.",
"quoteAuthor": "Virgil"
}, {
"quoteText": "It isn't where you come from, it's where you're going that counts.",
"quoteAuthor": "Ella Fitzgerald"
}, {
"quoteText": "All that we are is the result of what we have thought. The mind is everything. What we think we become.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "In all chaos there is a cosmos, in all disorder a secret order.",
"quoteAuthor": "Carl Jung"
}, {
"quoteText": "It is the quality of our work which will please God, not the quantity.",
"quoteAuthor": "Mahatma Gandhi"
}, {
"quoteText": "Try and fail, but don't fail to try.",
"quoteAuthor": "Stephen Kaggwa"
}, {
"quoteText": "The heart has its reasons which reason knows not of.",
"quoteAuthor": "Blaise Pascal"
}, {
"quoteText": "The happy and efficient people in this world are those who accept trouble as a normal detail of human life and resolve to capitalize it when it comes along.",
"quoteAuthor": "H. Bertram Lewis"
}, {
"quoteText": "I am not bothered by the fact that I am unknown. I am bothered when I do not know others.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "First say to yourself what you would be; and then do what you have to do.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "The ladder of success is never crowded at the top.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "You can do what's reasonable or you can decide what's possible.",
"quoteAuthor": ""
}, {
"quoteText": "Nothing diminishes anxiety faster than action.",
"quoteAuthor": "Walter Anderson"
}, {
"quoteText": "Don't be afraid to go out on a limb. That's where the fruit is.",
"quoteAuthor": "H. Jackson Browne"
}, {
"quoteText": "Mistakes are always forgivable, if one has the courage to admit them.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "I allow my intuition to lead my path.",
"quoteAuthor": "Manuel Puig"
}, {
"quoteText": "Today is the tomorrow we worried about yesterday.",
"quoteAuthor": ""
}, {
"quoteText": "Through pride we are ever deceiving ourselves. But deep down below the surface of the average conscience a still, small voice says to us, Something is out of tune.",
"quoteAuthor": "Carl Jung"
}, {
"quoteText": "What is necessary to change a person is to change his awareness of himself.",
"quoteAuthor": "Abraham Maslow"
}, {
"quoteText": "Keep silence for the most part, and speak only when you must, and then briefly.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "Fear not for the future, weep not for the past.",
"quoteAuthor": "Percy Shelley"
}, {
"quoteText": "The mind is everything. What you think you become.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Try not to become a man of success, but rather try to become a man of value.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "Success is not the key to happiness. Happiness is the key to success. If you love what you are doing, you will be successful.",
"quoteAuthor": "Albert Schweitzer"
}, {
"quoteText": "We are Divine enough to ask and we are important enough to receive.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "If you kick a stone in anger, you'll hurt your own foot.",
"quoteAuthor": "Korean proverb"
}, {
"quoteText": "Put your future in good hands � your own.",
"quoteAuthor": ""
}, {
"quoteText": "The wise man does not lay up his own treasures. The more he gives to others, the more he has for his own.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "All men who have achieved great things have been great dreamers.",
"quoteAuthor": "Orison Marden"
}, {
"quoteText": "To live a pure unselfish life, one must count nothing as ones own in the midst of abundance.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Face your deficiencies and acknowledge them; but do not let them master you. Let them teach you patience, sweetness, insight.",
"quoteAuthor": "Helen Keller"
}, {
"quoteText": "Never doubt that a small group of thoughtful, committed people can change the world. Indeed. It is the only thing that ever has.",
"quoteAuthor": "Margaret Mead"
}, {
"quoteText": "To see things in the seed, that is genius.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "The road leading to a goal does not separate you from the destination; it is essentially a part of it.",
"quoteAuthor": "Charles DeLint"
}, {
"quoteText": "Mediocrity knows nothing higher than itself, but talent instantly recognizes genius.",
"quoteAuthor": "Arthur Conan Doyle"
}, {
"quoteText": "The happiness that is genuinely satisfying is accompanied by the fullest exercise of our faculties and the fullest realization of the world in which we live.",
"quoteAuthor": "Bertrand Russell"
}, {
"quoteText": "Human beings, who are almost unique in having the ability to learn from the experience of others, are also remarkable for their apparent disinclination to do so.",
"quoteAuthor": "Douglas Adams"
}, {
"quoteText": "Giving up doesn't always mean you are weak. Sometimes it means that you are strong enough to let go.",
"quoteAuthor": ""
}, {
"quoteText": "The greatest antidote to insecurity and the sense of fear is compassion � it brings one back to the basis of one's inner strength",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "The truth of the matter is that you always know the right thing to do. The hard part is doing it.",
"quoteAuthor": "Norman Schwarzkopf"
}, {
"quoteText": "If we could learn to like ourselves, even a little, maybe our cruelties and angers might melt away.",
"quoteAuthor": "John Steinbeck"
}, {
"quoteText": "No yesterdays are ever wasted for those who give themselves to today.",
"quoteAuthor": "Brendan Francis"
}, {
"quoteText": "It is the greatest of all mistakes to do nothing because you can only do little � do what you can.",
"quoteAuthor": "Sydney Smith"
}, {
"quoteText": "I may not know everything, but everything is not known yet anyway.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "He who obtains has little. He who scatters has much.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Do not give your attention to what others do or fail to do; give it to what you do or fail to do.",
"quoteAuthor": "Dhammapada"
}, {
"quoteText": "Chaos is inherent in all compounded things. Strive on with diligence.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Deep listening is miraculous for both listener and speaker.When someone receives us with open-hearted, non-judging, intensely interested listening, our spirits expand.",
"quoteAuthor": "Sue Patton Thoele"
}, {
"quoteText": "A true friend is the most precious of all possessions and the one we take the least thought about acquiring.",
"quoteAuthor": "Francois de La Rochefoucauld"
}, {
"quoteText": "Make the most of yourself, for that is all there is of you.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "History will be kind to me for I intend to write it.",
"quoteAuthor": "Winston Churchill"
}, {
"quoteText": "As the rest of the world is walking out the door, your best friends are the ones walking in.",
"quoteAuthor": ""
}, {
"quoteText": "These days people seek knowledge, not wisdom. Knowledge is of the past, wisdom is of the future.",
"quoteAuthor": "Vernon Cooper"
}, {
"quoteText": "The person born with a talent they are meant to use will find their greatest happiness in using it.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "Love is never lost. If not reciprocated, it will flow back and soften and purify the heart.",
"quoteAuthor": "Washington Irving"
}, {
"quoteText": "In all chaos there is a cosmos, in all disorder a secret order.",
"quoteAuthor": "Carl Jung"
}, {
"quoteText": "The universe is made of stories, not atoms.",
"quoteAuthor": "Muriel Rukeyser"
}, {
"quoteText": "It is on our failures that we base a new and different and better success.",
"quoteAuthor": "Havelock Ellis"
}, {
"quoteText": "Success means having the courage, the determination, and the will to become the person you believe you were meant to be.",
"quoteAuthor": "George Sheehan"
}, {
"quoteText": "Ask yourself the secret of your success. Listen to your answer, and practice it.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "All our talents increase in the using, and the every faculty, both good and bad, strengthen by exercise.",
"quoteAuthor": "Anne Bronte"
}, {
"quoteText": "The best way to pay for a lovely moment is to enjoy it.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "Respect should be earned by actions, and not acquired by years.",
"quoteAuthor": "Frank Wright"
}, {
"quoteText": "I hear and I forget. I see and I remember. I do and I understand.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "We cannot change our memories, but we can change their meaning and the power they have over us.",
"quoteAuthor": "David Seamans"
}, {
"quoteText": "Always tell the truth. That way, you don't have to remember what you said.",
"quoteAuthor": "Mark Twain"
}, {
"quoteText": "Do something wonderful, people may imitate it.",
"quoteAuthor": "Albert Schweitzer"
}, {
"quoteText": "Do you want to know who you are? Don't ask. Act! Action will delineate and define you.",
"quoteAuthor": "Thomas Jefferson"
}, {
"quoteText": "You can do it if you believe you can!",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "The most dangerous way to lose time is not to spend it having fun, but to spend it doing fake work. When you spend time having fun, you know you're being self-indulgent.",
"quoteAuthor": "Paul Graham"
}, {
"quoteText": "Every adversity, every failure, every heartache carries with it the seed of an equal or greater benefit.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "The trouble with most people is that they think with their hopes or fears or wishes rather than with their minds.",
"quoteAuthor": "Will Durant"
}, {
"quoteText": "We shall never know all the good that a simple smile can do.",
"quoteAuthor": "Mother Teresa"
}, {
"quoteText": "A lot of people give up just before theyre about to make it. You know you never know when that next obstacle is going to be the last one.",
"quoteAuthor": "Chuck Norris"
}, {
"quoteText": "Sometimes the biggest act of courage is a small one.",
"quoteAuthor": "Lauren Raffo"
}, {
"quoteText": "He who experiences the unity of life sees his own Self in all beings, and all beings in his own Self, and looks on everything with an impartial eye.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Let the beauty of what you love be what you do.",
"quoteAuthor": "Rumi"
}, {
"quoteText": "The moment one gives close attention to anything, it becomes a mysterious, awesome, indescribably magnificent world in itself.",
"quoteAuthor": "Henry Miller"
}, {
"quoteText": "Strong beliefs win strong men, and then make them stronger.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "No man is free who is not master of himself.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "Follow effective action with quiet reflection. From the quiet reflection will come even more effective action.",
"quoteAuthor": "Peter Drucker"
}, {
"quoteText": "People are not lazy. They simply have impotent goals � that is, goals that do not inspire them.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "You do not become good by trying to be good, but by finding the goodness that is already within you.",
"quoteAuthor": "Eckhart Tolle"
}, {
"quoteText": "Winners have simply formed the habit of doing things losers don't like to do.",
"quoteAuthor": "Albert Gray"
}, {
"quoteText": "Waste no more time arguing about what a good man should be. Be one.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "A bend in the road is not the end of the road...unless you fail to make the turn.",
"quoteAuthor": ""
}, {
"quoteText": "Don't be afraid to go out on a limb. That's where the fruit is.",
"quoteAuthor": "H. Jackson Browne"
}, {
"quoteText": "Every adversity, every failure, every heartache carries with it the seed of an equal or greater benefit.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Keep true to the dreams of thy youth.",
"quoteAuthor": "Friedrich von Schiller"
}, {
"quoteText": "Great talent finds happiness in execution.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "Happiness often sneaks in through a door you didn't know you left open.",
"quoteAuthor": "John Barrymore"
}, {
"quoteText": "Decision is a risk rooted in the courage of being free.",
"quoteAuthor": "Paul Tillich"
}, {
"quoteText": "There are basically two types of people. People who accomplish things, and people who claim to have accomplished things. The first group is less crowded.",
"quoteAuthor": "Mark Twain"
}, {
"quoteText": "The things that one most wants to do are the things that are probably most worth doing.",
"quoteAuthor": "Winifred Holtby"
}, {
"quoteText": "Always bear in mind that your own resolution to succeed is more important than any one thing.",
"quoteAuthor": "Abraham Lincoln"
}, {
"quoteText": "Think as a wise man but communicate in the language of the people.",
"quoteAuthor": "William Yeats"
}, {
"quoteText": "He who obtains has little. He who scatters has much.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "On every thorn, delightful wisdom grows, In every rill a sweet instruction flows.",
"quoteAuthor": "Edward Young"
}, {
"quoteText": "Life is like a sewer. What you get out of it depends on what you put into it.",
"quoteAuthor": "Tom Lehrer"
}, {
"quoteText": "Setting an example is not the main means of influencing another, it is the only means.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "I want you to be everything that's you, deep at the center of your being.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "It has never been my object to record my dreams, just to realize them.",
"quoteAuthor": "Man Ray"
}, {
"quoteText": "Take things as they are. Punch when you have to punch. Kick when you have to kick.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "What is necessary to change a person is to change his awareness of himself.",
"quoteAuthor": "Abraham Maslow"
}, {
"quoteText": "To forgive is to set a prisoner free and realize that prisoner was you.",
"quoteAuthor": "Lewis B. Smedes"
}, {
"quoteText": "There is no greater harm than that of time wasted.",
"quoteAuthor": "Michelangelo"
}, {
"quoteText": "Happiness mainly comes from our own attitude, rather than from external factors.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Experience is simply the name we give our mistakes.",
"quoteAuthor": "Oscar Wilde"
}, {
"quoteText": "To study and not think is a waste. To think and not study is dangerous.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Life is not measured by the breaths we take, but by the moments that take our breath.",
"quoteAuthor": ""
}, {
"quoteText": "Chaos and Order are not enemies, only opposites.",
"quoteAuthor": "Richard Garriott"
}, {
"quoteText": "You must welcome change as the rule but not as your ruler.",
"quoteAuthor": "Denis Waitley"
}, {
"quoteText": "Progress always involves risks. You can't steal second base and keep your foot on first.",
"quoteAuthor": "Frederick Wilcox"
}, {
"quoteText": "Perseverance is a great element of success. If you only knock long enough and loud enough at the gate, you are sure to wake up somebody.",
"quoteAuthor": "Henry Longfellow"
}, {
"quoteText": "The secret of success is constancy to purpose.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "Only through our connectedness to others can we really know and enhance the self. And only through working on the self can we begin to enhance our connectedness to others.",
"quoteAuthor": "Harriet Lerner"
}, {
"quoteText": "It is only with the heart that one can see rightly, what is essential is invisible to the eye.",
"quoteAuthor": "Antoine de Saint-Exupery"
}, {
"quoteText": "Rainbows apologize for angry skies.",
"quoteAuthor": "Sylvia Voirol"
}, {
"quoteText": "Fear grows in darkness; if you think theres a bogeyman around, turn on the light.",
"quoteAuthor": "Dorothy Thompson"
}, {
"quoteText": "He who deliberates fully before taking a step will spend his entire life on one leg.",
"quoteAuthor": "Chinese proverb"
}, {
"quoteText": "Never miss an opportunity to make others happy, even if you have to leave them alone in order to do it.",
"quoteAuthor": ""
}, {
"quoteText": "We are Divine enough to ask and we are important enough to receive.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Be kind whenever possible. It is always possible.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "A life spent making mistakes is not only more honourable but more useful than a life spent in doing nothing.",
"quoteAuthor": "Bernard Shaw"
}, {
"quoteText": "Peace begins with a smile.",
"quoteAuthor": "Mother Teresa"
}, {
"quoteText": "Every sixty seconds you spend angry, upset or mad, is a full minute of happiness you�ll never get back.",
"quoteAuthor": ""
}, {
"quoteText": "Be your own hero, it's cheaper than a movie ticket.",
"quoteAuthor": "Doug Horton"
}, {
"quoteText": "Kind words will unlock an iron door.",
"quoteAuthor": "Turkish proverb"
}, {
"quoteText": "Turn your face toward the sun and the shadows will fall behind you.",
"quoteAuthor": "Maori proverb"
}, {
"quoteText": "Much wisdom often goes with fewer words.",
"quoteAuthor": "Sophocles"
}, {
"quoteText": "Great talent finds happiness in execution.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "Do not go where the path may lead, go instead where there is no path and leave a trail.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Better to have loved and lost, than to have never loved at all.",
"quoteAuthor": "St. Augustine"
}, {
"quoteText": "The things that one most wants to do are the things that are probably most worth doing.",
"quoteAuthor": "Winifred Holtby"
}, {
"quoteText": "Holding on to anger is like grasping a hot coal with the intent of throwing it at someone else; you are the one who gets burned.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "If we have a positive mental attitude, then even when surrounded by hostility, we shall not lack inner peace.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Courage is what it takes to stand up and speak; courage is also what it takes to sit down and listen.",
"quoteAuthor": "Winston Churchill"
}, {
"quoteText": "Go to your bosom: Knock there, and ask your heart what it doth know.",
"quoteAuthor": "William Shakespeare"
}, {
"quoteText": "Iron rusts from disuse; water loses its purity from stagnation... even so does inaction sap the vigour of the mind.",
"quoteAuthor": "Leonardo da Vinci"
}, {
"quoteText": "Things turn out best for those who make the best of the way things turn out.",
"quoteAuthor": "Jack Buck"
}, {
"quoteText": "As the rest of the world is walking out the door, your best friends are the ones walking in.",
"quoteAuthor": ""
}, {
"quoteText": "Stay away from what might have been and look at what will be.",
"quoteAuthor": "Marsha Petrie Sue"
}, {
"quoteText": "Happiness is a perfume you cannot pour on others without getting a few drops on yourself.",
"quoteAuthor": "Ralph Waldo Emerson"
}, {
"quoteText": "There is no duty we so underrate as the duty of being happy. By being happy we sow anonymous benefits upon the world.",
"quoteAuthor": "Robert Louis Stevenson"
}, {
"quoteText": "No man can succeed in a line of endeavor which he does not like.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Don't wait for people to be friendly. Show them how.",
"quoteAuthor": ""
}, {
"quoteText": "Tension is who you think you should be. Relaxation is who you are.",
"quoteAuthor": "Chinese proverb"
}, {
"quoteText": "Can you imagine what I would do if I could do all I can?",
"quoteAuthor": "Sun Tzu"
}, {
"quoteText": "Many of life's failures are people who did not realize how close they were to success when they gave up.",
"quoteAuthor": "Thomas Edison"
}, {
"quoteText": "Take time to deliberate, but when the time for action has arrived, stop thinking and go in.",
"quoteAuthor": "Napoleon Bonaparte"
}, {
"quoteText": "Were here for a reason. I believe a bit of the reason is to throw little torches out to lead people through the dark.",
"quoteAuthor": "Whoopi Goldberg"
}, {
"quoteText": "Life is a gift, and it offers us the privilege, opportunity, and responsibility to give something back by becoming more",
"quoteAuthor": "Anthony Robbins"
}, {
"quoteText": "To effectively communicate, we must realize that we are all different in the way we perceive the world and use this understanding as a guide to our communication with others.",
"quoteAuthor": "Anthony Robbins"
}, {
"quoteText": "Once you choose hope, anythings possible.",
"quoteAuthor": "Christopher Reeve"
}, {
"quoteText": "Ability will never catch up with the demand for it.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "He who experiences the unity of life sees his own Self in all beings, and all beings in his own Self, and looks on everything with an impartial eye.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Until you value yourself, you won't value your time. Until you value your time, you won't do anything with it.",
"quoteAuthor": "M. Scott Peck"
}, {
"quoteText": "Yeah we all shine on, like the moon, and the stars, and the sun.",
"quoteAuthor": "John Lennon"
}, {
"quoteText": "If one does not know to which port is sailing, no wind is favorable.",
"quoteAuthor": "Seneca"
}, {
"quoteText": "Never say there is nothing beautiful in the world any more. There is always something to make you wonder in the shape of a tree, the trembling of a leaf.",
"quoteAuthor": "Albert Schweitzer"
}, {
"quoteText": "Intuition is the very force or activity of the soul in its experience through whatever has been the experience of the soul itself.",
"quoteAuthor": "Henry Reed"
}, {
"quoteText": "It is impossible to feel grateful and depressed in the same moment.",
"quoteAuthor": "Naomi Williams"
}, {
"quoteText": "Setting goals is the first step in turning the invisible into the visible.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "The day always looks brighter from behind a smile.",
"quoteAuthor": ""
}, {
"quoteText": "Absence makes the heart grow fonder.",
"quoteAuthor": "Haynes Bayly"
}, {
"quoteText": "Follow your instincts. That is where true wisdom manifests itself.",
"quoteAuthor": "Oprah Winfrey"
}, {
"quoteText": "We cannot change our memories, but we can change their meaning and the power they have over us.",
"quoteAuthor": "David Seamans"
}, {
"quoteText": "When you dance, your purpose is not to get to a certain place on the floor. It's to enjoy each step along the way.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Without passion man is a mere latent force and possibility, like the flint which awaits the shock of the iron before it can give forth its spark.",
"quoteAuthor": "Amiel"
}, {
"quoteText": "The longer we dwell on our misfortunes, the greater is their power to harm us.",
"quoteAuthor": "Voltaire"
}, {
"quoteText": "Courage is not the absence of fear, but simply moving on with dignity despite that fear.",
"quoteAuthor": "Pat Riley"
}, {
"quoteText": "Life a culmination of the past, an awareness of the present, an indication of the future beyond knowledge, the quality that gives a touch of divinity to matter.",
"quoteAuthor": "Charles A. Lindbergh"
}, {
"quoteText": "A prudent question is one half of wisdom.",
"quoteAuthor": "Francis Bacon"
}, {
"quoteText": "All truths are easy to understand once they are discovered; the point is to discover them.",
"quoteAuthor": "Galileo Galilei"
}, {
"quoteText": "First say to yourself what you would be; and then do what you have to do.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "Life is a learning experience, only if you learn.",
"quoteAuthor": "Yogi Berra"
}, {
"quoteText": "Don't let what you can't do stop you from doing what you can do.",
"quoteAuthor": ""
}, {
"quoteText": "Four steps to achievement: Plan purposefully. Prepare prayerfully. Proceed positively. Pursue persistently.",
"quoteAuthor": "William Arthur Ward"
}, {
"quoteText": "Never miss an opportunity to make others happy, even if you have to leave them alone in order to do it.",
"quoteAuthor": ""
}, {
"quoteText": "Joy is the best makeup.",
"quoteAuthor": "Anne Lamott"
}, {
"quoteText": "The smallest act of kindness is worth more than the grandest intention.",
"quoteAuthor": "Oscar Wilde"
}, {
"quoteText": "The mind unlearns with difficulty what it has long learned.",
"quoteAuthor": "Seneca"
}, {
"quoteText": "We know from science that nothing in the universe exists as an isolated or independent entity.",
"quoteAuthor": "Margaret Wheatley"
}, {
"quoteText": "Every great advance in science has issued from a new audacity of the imagination.",
"quoteAuthor": "John Dewey"
}, {
"quoteText": "Sunshine is delicious, rain is refreshing, wind braces us up, snow is exhilarating; there is really no such thing as bad weather, only different kinds of good weather.",
"quoteAuthor": "John Ruskin"
}, {
"quoteText": "Everything in the universe goes by indirection. There are no straight lines.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "What do we live for, if it is not to make life less difficult for each other?",
"quoteAuthor": "George Eliot"
}, {
"quoteText": "When we feel love and kindness toward others, it not only makes others feel loved and cared for, but it helps us also to develop inner happiness and peace.",
"quoteAuthor": "Tenzin Gyatso"
}, {
"quoteText": "In all chaos there is a cosmos, in all disorder a secret order.",
"quoteAuthor": "Carl Jung"
}, {
"quoteText": "If you wish to be a writer, write.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "Everything you are against weakens you. Everything you are for empowers you.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "All difficult things have their origin in that which is easy, and great things in that which is small.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "It can't be spring if your heart is filled with past failures.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "We may encounter many defeats but we must not be defeated.",
"quoteAuthor": "Maya Angelou"
}, {
"quoteText": "Whenever something negative happens to you, there is a deep lesson concealed within it.",
"quoteAuthor": "Eckhart Tolle"
}, {
"quoteText": "If the single man plant himself indomitably on his instincts, and there abide, the huge world will come round to him.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Arriving at one point is the starting point to another.",
"quoteAuthor": "John Dewey"
}, {
"quoteText": "Adversity isn't set against you to fail; adversity is a way to build your character so that you can succeed over and over again through perseverance.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Every person, all the events of your life are there because you have drawn them there. What you choose to do with them is up to you.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "Each day provides its own gifts.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "Logic will get you from A to B. Imagination will take you everywhere.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "A man of ability and the desire to accomplish something can do anything.",
"quoteAuthor": "Donald Kircher"
}, {
"quoteText": "Our deepest wishes are whispers of our authentic selves. We must learn to respect them. We must learn to listen.",
"quoteAuthor": "Sarah Breathnach"
}, {
"quoteText": "Arriving at one point is the starting point to another.",
"quoteAuthor": "John Dewey"
}, {
"quoteText": "I am not bothered by the fact that I am unknown. I am bothered when I do not know others.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "The mind unlearns with difficulty what it has long learned.",
"quoteAuthor": "Seneca"
}, {
"quoteText": "Nothing in life is to be feared, it is only to be understood. Now is the time to understand more, so that we may fear less.",
"quoteAuthor": "Marie Curie"
}, {
"quoteText": "Every person, all the events of your life are there because you have drawn them there. What you choose to do with them is up to you.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "All perceiving is also thinking, all reasoning is also intuition, all observation is also invention.",
"quoteAuthor": "Rudolf Arnheim"
}, {
"quoteText": "Inspiration exists, but it has to find us working.",
"quoteAuthor": "Pablo Picasso"
}, {
"quoteText": "Sometimes the most important thing in a whole day is the rest we take between two deep breaths.",
"quoteAuthor": "Etty Hillesum"
}, {
"quoteText": "Only when we are no longer afraid do we begin to live.",
"quoteAuthor": "Dorothy Thompson"
}, {
"quoteText": "If we are not fully ourselves, truly in the present moment, we miss everything.",
"quoteAuthor": "Thich Nhat Hanh"
}, {
"quoteText": "We must not allow ourselves to become like the system we oppose.",
"quoteAuthor": "Bishop Desmond Tutu"
}, {
"quoteText": "He who lives in harmony with himself lives in harmony with the universe.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "Chaos and Order are not enemies, only opposites.",
"quoteAuthor": "Richard Garriott"
}, {
"quoteText": "Never let lack of money interfere with having fun.",
"quoteAuthor": ""
}, {
"quoteText": "Begin at once to live and count each separate day as a separate life.",
"quoteAuthor": "Seneca"
}, {
"quoteText": "The world is but a canvas to the imagination.",
"quoteAuthor": "Henry Thoreau"
}, {
"quoteText": "Difficulties are meant to rouse, not discourage. The human spirit is to grow strong by conflict.",
"quoteAuthor": "William Channing"
}, {
"quoteText": "We choose our destiny in the way we treat others.",
"quoteAuthor": "Wit"
}, {
"quoteText": "Don't be afraid to go out on a limb. That's where the fruit is.",
"quoteAuthor": "H. Jackson Browne"
}, {
"quoteText": "A life spent making mistakes is not only more honourable but more useful than a life spent in doing nothing.",
"quoteAuthor": "Bernard Shaw"
}, {
"quoteText": "We do what we do because we believe.",
"quoteAuthor": ""
}, {
"quoteText": "The most dangerous way to lose time is not to spend it having fun, but to spend it doing fake work. When you spend time having fun, you know you're being self-indulgent.",
"quoteAuthor": "Paul Graham"
}, {
"quoteText": "Never ignore a gut feeling, but never believe that it's enough.",
"quoteAuthor": "Robert Heller"
}, {
"quoteText": "All I can say about life is, Oh God, enjoy it!",
"quoteAuthor": "Bob Newhart"
}, {
"quoteText": "Nothing in life is to be feared, it is only to be understood. Now is the time to understand more, so that we may fear less.",
"quoteAuthor": "Marie Curie"
}, {
"quoteText": "Ignorant men don't know what good they hold in their hands until they've flung it away.",
"quoteAuthor": "Sophocles"
}, {
"quoteText": "The world has the habit of making room for the man whose actions show that he knows where he is going.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "You are special, you are unique, you are the best!",
"quoteAuthor": "Cathy Pulsifer"
}, {
"quoteText": "If you love someone, set them free. If they come back they're yours; if they don't they never were.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "Accept the things to which fate binds you, and love the people with whom fate brings you together, but do so with all your heart.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "Everything that irritates us about others can lead us to an understanding about ourselves.",
"quoteAuthor": "Carl Jung"
}, {
"quoteText": "Thats the risk you take if you change: that people you've been involved with won't like the new you. But other people who do will come along.",
"quoteAuthor": "Lisa Alther"
}, {
"quoteText": "Do not dwell in the past, do not dream of the future, concentrate the mind on the present moment.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "To be happy is to be able to become aware of oneself without fright.",
"quoteAuthor": "Walter Benjamin"
}, {
"quoteText": "Strength to carry on despite the odds means you have faith in your own abilities and know how.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Make the most of yourself for that is all there is of you.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Men of perverse opinion do not know the excellence of what is in their hands, till some one dash it from them.",
"quoteAuthor": "Sophocles"
}, {
"quoteText": "No matter how hard the past, you can always begin again.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Happiness is not something ready made. It comes from your own actions.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Be gentle first with yourself if you wish to be gentle with others.",
"quoteAuthor": "Lama Yeshe"
}, {
"quoteText": "A man who doesn't trust himself can never really trust anyone else.",
"quoteAuthor": "Cardinal Retz"
}, {
"quoteText": "The journey of a thousand miles begins with one step.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "To be wronged is nothing unless you continue to remember it.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "With realization of ones own potential and self-confidence in ones ability, one can build a better world.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Can miles truly separate you from friends... If you want to be with someone you love, aren't you already there?",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "Someone is special only if you tell them.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Joy is the best makeup.",
"quoteAuthor": "Anne Lamott"
}, {
"quoteText": "We make our own fortunes and we call them fate.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "I hear and I forget. I see and I remember. I do and I understand.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Myths which are believed in tend to become true.",
"quoteAuthor": "George Orwell"
}, {
"quoteText": "Leaders aren't born they are made. And they are made just like anything else, through hard work. And that's the price well have to pay to achieve that goal, or any goal.",
"quoteAuthor": "Vince Lombardi"
}, {
"quoteText": "It takes courage to grow up and become who you really are.",
"quoteAuthor": "E. E. Cummings"
}, {
"quoteText": "Always seek out the seed of triumph in every adversity.",
"quoteAuthor": "Og Mandino"
}, {
"quoteText": "At the center of your being you have the answer; you know who you are and you know what you want.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Rather than wishing for change, you first must be prepared to change.",
"quoteAuthor": "Catherine Pulsifer"
}, {
"quoteText": "Always be smarter than the people who hire you.",
"quoteAuthor": "Lena Horne"
}, {
"quoteText": "I do not believe in a fate that falls on men however they act; but I do believe in a fate that falls on them unless they act.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Everything can be taken from a man but ... the last of the human freedoms � to choose ones attitude in any given set of circumstances, to choose ones own way.",
"quoteAuthor": "Victor Frankl"
}, {
"quoteText": "It's important to know that words don't move mountains. Work, exacting work moves mountains.",
"quoteAuthor": "Danilo Dolci"
}, {
"quoteText": "Fame usually comes to those who are thinking about something else.",
"quoteAuthor": "Holmes"
}, {
"quoteText": "With realization of ones own potential and self-confidence in ones ability, one can build a better world.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "I may not know everything, but everything is not known yet anyway.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Know how to listen, and you will profit even from those who talk badly.",
"quoteAuthor": "Plutarch"
}, {
"quoteText": "First comes thought; then organization of that thought, into ideas and plans; then transformation of those plans into reality. The beginning, as you will observe, is in your imagination.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Happiness cannot be travelled to, owned, earned, worn or consumed. Happiness is the spiritual experience of living every minute with love, grace and gratitude.",
"quoteAuthor": "Denis Waitley"
}, {
"quoteText": "It is never too late to be what you might have been.",
"quoteAuthor": "George Eliot"
}, {
"quoteText": "Every gift from a friend is a wish for your happiness.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "Only do what your heart tells you.",
"quoteAuthor": "Princess Diana"
}, {
"quoteText": "To get something you never had, you have to do something you never did.",
"quoteAuthor": ""
}, {
"quoteText": "Make the most of yourself, for that is all there is of you.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "The superior man acts before he speaks, and afterwards speaks according to his action.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "A single conversation across the table with a wise person is worth a months study of books.",
"quoteAuthor": "Chinese proverb"
}, {
"quoteText": "All that is necessary is to accept the impossible, do without the indispensable, and bear the intolerable.",
"quoteAuthor": "Kathleen Norris"
}, {
"quoteText": "Turn your face toward the sun and the shadows will fall behind you.",
"quoteAuthor": "Maori proverb"
}, {
"quoteText": "The beginning of wisdom is found in doubting; by doubting we come to the question, and by seeking we may come upon the truth.",
"quoteAuthor": "Pierre Abelard"
}, {
"quoteText": "One who asks a question is a fool for five minutes; one who does not ask a question remains a fool forever.",
"quoteAuthor": ""
}, {
"quoteText": "Let us revere, let us worship, but erect and open-eyed, the highest, not the lowest; the future, not the past!",
"quoteAuthor": "Charlotte Gilman"
}, {
"quoteText": "The difference between what we do and what we are capable of doing would suffice to solve most of the worlds problems.",
"quoteAuthor": "Mohandas Gandhi"
}, {
"quoteText": "You can never cross the ocean unless you have the courage to lose sight of the shore.",
"quoteAuthor": ""
}, {
"quoteText": "Everyone can taste success when the going is easy, but few know how to taste victory when times get tough.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Myths which are believed in tend to become true.",
"quoteAuthor": "George Orwell"
}, {
"quoteText": "What we think, we become.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "The beginning of knowledge is the discovery of something we do not understand.",
"quoteAuthor": "Frank Herbert"
}, {
"quoteText": "Peace begins with a smile.",
"quoteAuthor": "Mother Teresa"
}, {
"quoteText": "Work for something because it is good, not just because it stands a chance to succeed.",
"quoteAuthor": "Vaclav Havel"
}, {
"quoteText": "Real magic in relationships means an absence of judgement of others.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "The world cares very little about what a man or woman knows; it is what a man or woman is able to do that counts.",
"quoteAuthor": "Booker Washington"
}, {
"quoteText": "Every man takes the limits of his own field of vision for the limits of the world.",
"quoteAuthor": "Arthur Schopenhauer"
}, {
"quoteText": "Who sows virtue reaps honour.",
"quoteAuthor": "Leonardo da Vinci"
}, {
"quoteText": "Knowledge rests not upon truth alone, but upon error also.",
"quoteAuthor": "Carl Jung"
}, {
"quoteText": "Make it a rule of life never to regret and never to look back. Regret is an appalling waste of energy; you can't build on it; it's only for wallowing in.",
"quoteAuthor": "Katherine Mansfield"
}, {
"quoteText": "Be what you are. This is the first step toward becoming better than you are.",
"quoteAuthor": "Julius Charles Hare"
}, {
"quoteText": "Minds are like parachutes. They only function when open.",
"quoteAuthor": "Thomas Dewar"
}, {
"quoteText": "A man is not old as long as he is seeking something.",
"quoteAuthor": "Edmond Rostand"
}, {
"quoteText": "Logic will get you from A to B. Imagination will take you everywhere.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "Faith in oneself is the best and safest course.",
"quoteAuthor": "Michelangelo"
}, {
"quoteText": "In the sky, there is no distinction of east and west; people create distinctions out of their own minds and then believe them to be true.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "The Creator has not given you a longing to do that which you have no ability to do.",
"quoteAuthor": "Orison Marden"
}, {
"quoteText": "Never regret. If it's good, it's wonderful. If it's bad, it's experience.",
"quoteAuthor": "Victoria Holt"
}, {
"quoteText": "No pessimist ever discovered the secrets of the stars, or sailed to an uncharted land, or opened a new heaven to the human spirit.",
"quoteAuthor": "Helen Keller"
}, {
"quoteText": "Our deepest wishes are whispers of our authentic selves. We must learn to respect them. We must learn to listen.",
"quoteAuthor": "Sarah Breathnach"
}, {
"quoteText": "When deeds and words are in accord, the whole world is transformed.",
"quoteAuthor": "Chuang Tzu"
}, {
"quoteText": "Kind words can be short and easy to speak but their echoes are truly endless.",
"quoteAuthor": "Mother Teresa"
}, {
"quoteText": "Take heed: you do not find what you do not seek.",
"quoteAuthor": "English proverb"
}, {
"quoteText": "Yeah we all shine on, like the moon, and the stars, and the sun.",
"quoteAuthor": "John Lennon"
}, {
"quoteText": "No man was ever wise by chance.",
"quoteAuthor": "Seneca"
}, {
"quoteText": "What lies behind us and what lies before us are tiny matters compared to what lies within us.",
"quoteAuthor": "Walt Emerson"
}, {
"quoteText": "Better to have loved and lost, than to have never loved at all.",
"quoteAuthor": "St. Augustine"
}, {
"quoteText": "For everything that lives is holy, life delights in life.",
"quoteAuthor": "William Blake"
}, {
"quoteText": "Intuition is the supra-logic that cuts out all the routine processes of thought and leaps straight from the problem to the answer.",
"quoteAuthor": "Robert Graves"
}, {
"quoteText": "The most important thing is transforming our minds, for a new way of thinking, a new outlook: we should strive to develop a new inner world.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Today is the tomorrow we worried about yesterday.",
"quoteAuthor": ""
}, {
"quoteText": "Promises are the uniquely human way of ordering the future, making it predictable and reliable to the extent that this is humanly possible.",
"quoteAuthor": "Hannah Arendt"
}, {
"quoteText": "Peace comes from within. Do not seek it without.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Strength does not come from physical capacity. It comes from an indomitable will.",
"quoteAuthor": "Mahatma Gandhi"
}, {
"quoteText": "Our passion is our strength.",
"quoteAuthor": "Billie Armstrong"
}, {
"quoteText": "By nature man hates change; seldom will he quit his old home till it has actually fallen around his ears.",
"quoteAuthor": "Thomas Carlyle"
}, {
"quoteText": "Wisdom is the supreme part of happiness.",
"quoteAuthor": "Sophocles"
}, {
"quoteText": "Happiness often sneaks in through a door you didn't know you left open.",
"quoteAuthor": "John Barrymore"
}, {
"quoteText": "With the realization of ones own potential and self-confidence in ones ability, one can build a better world.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "A fine quotation is a diamond on the finger of a man of wit, and a pebble in the hand of a fool.",
"quoteAuthor": "Joseph Roux"
}, {
"quoteText": "Man is equally incapable of seeing the nothingness from which he emerges and the infinity in which he is engulfed.",
"quoteAuthor": "Blaise Pascal"
}, {
"quoteText": "Take heed: you do not find what you do not seek.",
"quoteAuthor": "English proverb"
}, {
"quoteText": "Fear of failure is one attitude that will keep you at the same point in your life.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "In rivers, the water that you touch is the last of what has passed and the first of that which comes; so with present time.",
"quoteAuthor": "Leonardo da Vinci"
}, {
"quoteText": "I do not believe in a fate that falls on men however they act; but I do believe in a fate that falls on them unless they act.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Spring is a time for rebirth and the fulfilment of new life.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Being angry never solves anything.",
"quoteAuthor": "Catherine Pulsifer"
}, {
"quoteText": "My mama always said: life's like a box of chocolate � you never know what you gonna get.",
"quoteAuthor": "Forrest Gump"
}, {
"quoteText": "There is nothing happens to any person but what was in his power to go through with.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "It can't be spring if your heart is filled with past failures.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "From little acorns mighty oaks do grow.",
"quoteAuthor": "American proverb"
}, {
"quoteText": "When deeds speak, words are nothing.",
"quoteAuthor": "African proverb"
}, {
"quoteText": "Peace cannot be kept by force. It can only be achieved by understanding.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "Nature is a mutable cloud which is always and never the same.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Be faithful in small things because it is in them that your strength lies.",
"quoteAuthor": "Mother Teresa"
}, {
"quoteText": "There are two ways to slide easily through life: to believe everything or to doubt everything; both ways save us from thinking.",
"quoteAuthor": "Alfred Korzybski"
}, {
"quoteText": "Society develops wit, but its contemplation alone forms genius.",
"quoteAuthor": "Madame de Stael"
}, {
"quoteText": "The conditions of conquest are always easy. We have but to toil awhile, endure awhile, believe always, and never turn back.",
"quoteAuthor": "Seneca"
}, {
"quoteText": "Try not to become a man of success, but rather try to become a man of value.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "It's so simple to be wise. Just think of something stupid to say and then don't say it.",
"quoteAuthor": "Sam Levenson"
}, {
"quoteText": "Life is what happens while you are making other plans.",
"quoteAuthor": "John Lennon"
}, {
"quoteText": "Be your own hero, it's cheaper than a movie ticket.",
"quoteAuthor": "Doug Horton"
}, {
"quoteText": "One who gains strength by overcoming obstacles possesses the only strength which can overcome adversity.",
"quoteAuthor": "Albert Schweitzer"
}, {
"quoteText": "The art of progress is to preserve order amid change, and to preserve change amid order.",
"quoteAuthor": "Alfred Whitehead"
}, {
"quoteText": "The key to transforming our hearts and minds is to have an understanding of how our thoughts and emotions work.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Things turn out best for those who make the best of the way things turn out.",
"quoteAuthor": "Jack Buck"
}, {
"quoteText": "We make a living by what we get, but we make a life by what we give.",
"quoteAuthor": "Winston Churchill"
}, {
"quoteText": "Can you imagine what I would do if I could do all I can?",
"quoteAuthor": "Sun Tzu"
}, {
"quoteText": "The two most powerful warriors are patience and time.",
"quoteAuthor": "Leo Tolstoy"
}, {
"quoteText": "If you break your neck, if you have nothing to eat, if your house is on fire, then you got a problem. Everything else is inconvenience.",
"quoteAuthor": "Robert Fulghum"
}, {
"quoteText": "The smallest act of kindness is worth more than the grandest intention.",
"quoteAuthor": "Oscar Wilde"
}, {
"quoteText": "Make the best use of what is in your power, and take the rest as it happens.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "If you want to study yourself � look into the hearts of other people. If you want to study other people � look into your own heart.",
"quoteAuthor": "Friedrich von Schiller"
}, {
"quoteText": "Most of the important things in the world have been accomplished by people who have kept on trying when there seemed to be no hope at all.",
"quoteAuthor": "Dale Carnegie"
}, {
"quoteText": "Your destiny isn't just fate; it is how you use your own developed abilities to get what you want.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Nobody will believe in you unless you believe in yourself.",
"quoteAuthor": "Liberace"
}, {
"quoteText": "You can tell whether a man is clever by his answers. You can tell whether a man is wise by his questions.",
"quoteAuthor": "Naguib Mahfouz"
}, {
"quoteText": "Open minds lead to open doors.",
"quoteAuthor": ""
}, {
"quoteText": "You are special, you are unique, you are the best!",
"quoteAuthor": "Cathy Pulsifer"
}, {
"quoteText": "The most important thing is transforming our minds, for a new way of thinking, a new outlook: we should strive to develop a new inner world.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "No matter how carefully you plan your goals they will never be more that pipe dreams unless you pursue them with gusto.",
"quoteAuthor": "W. Clement Stone"
}, {
"quoteText": "Real magic in relationships means an absence of judgement of others.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Imagination disposes of everything; it creates beauty, justice, and happiness, which are everything in this world.",
"quoteAuthor": "Blaise Pascal"
}, {
"quoteText": "Maxim for life: You get treated in life the way you teach people to treat you.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "With every experience, you alone are painting your own canvas, thought by thought, choice by choice.",
"quoteAuthor": "Oprah Winfrey"
}, {
"quoteText": "Make the most of yourself for that is all there is of you.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Happiness is found in doing, not merely possessing.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "The first duty of a human being is to assume the right functional relationship to society � more briefly, to find your real job, and do it.",
"quoteAuthor": "Charlotte Perkins Gilman"
}, {
"quoteText": "The world is but a canvas to the imagination.",
"quoteAuthor": "Henry Thoreau"
}, {
"quoteText": "You'll see it when you believe it.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "We are the leaves of one branch, the drops of one sea, the flowers of one garden.",
"quoteAuthor": "Jean Lacordaire"
}, {
"quoteText": "We make our own fortunes and we call them fate.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "If you spend your whole life waiting for the storm, you'll never enjoy the sunshine.",
"quoteAuthor": "Morris West"
}, {
"quoteText": "It is the mark of an educated mind to be able to entertain a thought without accepting it.",
"quoteAuthor": "Aristotle"
}, {
"quoteText": "A prudent question is one half of wisdom.",
"quoteAuthor": "Francis Bacon"
}, {
"quoteText": "Experience keeps a dear school, but fools will learn in no other.",
"quoteAuthor": "Benjamin Franklin"
}, {
"quoteText": "The poor man is not he who is without a cent, but he who is without a dream.",
"quoteAuthor": "Harry Kemp"
}, {
"quoteText": "The key to growth is the introduction of higher dimensions of consciousness into our awareness.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Thought is the blossom; language the bud; action the fruit behind it.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "True happiness means forging a strong spirit that is undefeated, no matter how trying our circumstances.",
"quoteAuthor": "Daisaku Ikeda"
}, {
"quoteText": "Your work is to discover your world and then with all your heart give yourself to it.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "There is nothing so useless as doing efficiently that which should not be done at all.",
"quoteAuthor": "Peter Drucker"
}, {
"quoteText": "Neither a lofty degree of intelligence nor imagination nor both together go to the making of genius. Love, love, love, that is the soul of genius.",
"quoteAuthor": "Wolfgang Amadeus Mozart"
}, {
"quoteText": "We know from science that nothing in the universe exists as an isolated or independent entity.",
"quoteAuthor": "Margaret Wheatley"
}, {
"quoteText": "First comes thought; then organization of that thought, into ideas and plans; then transformation of those plans into reality. The beginning, as you will observe, is in your imagination.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "A rolling stone gathers no moss.",
"quoteAuthor": "Publilius Syrus"
}, {
"quoteText": "Every problem has a gift for you in its hands.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "Life's challenges are not supposed to paralyse you, they're supposed to help you discover who you are.",
"quoteAuthor": "Bernice Reagon"
}, {
"quoteText": "Everything in the universe goes by indirection. There are no straight lines.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "To be wronged is nothing unless you continue to remember it.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Peace is not something you wish for. It's something you make, something you do, something you are, and something you give away.",
"quoteAuthor": "Robert Fulghum"
}, {
"quoteText": "If a man does his best, what else is there?",
"quoteAuthor": "George Patton"
}, {
"quoteText": "I have been impressed with the urgency of doing. Knowing is not enough; we must apply. Being willing is not enough; we must do.",
"quoteAuthor": "Leonardo da Vinci"
}, {
"quoteText": "If you love someone, set them free. If they come back they're yours; if they don't they never were.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "One of the advantages of being disorderly is that one is constantly making exciting discoveries.",
"quoteAuthor": "A. A. Milne"
}, {
"quoteText": "Take heed: you do not find what you do not seek.",
"quoteAuthor": "English proverb"
}, {
"quoteText": "If you can't feed a hundred people, then feed just one.",
"quoteAuthor": "Mother Teresa"
}, {
"quoteText": "Wisdom is knowing what to do next; Skill is knowing how ot do it, and Virtue is doing it.",
"quoteAuthor": "David Jordan"
}, {
"quoteText": "Although there may be tragedy in your life, there's always a possibility to triumph. It doesn't matter who you are, where you come from. The ability to triumph begins with you. Always.",
"quoteAuthor": "Oprah Winfrey"
}, {
"quoteText": "To live a pure unselfish life, one must count nothing as ones own in the midst of abundance.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "All the world is a stage, And all the men and women merely players.They have their exits and entrances; Each man in his time plays many parts.",
"quoteAuthor": "William Shakespeare"
}, {
"quoteText": "As we are liberated from our own fear, our presence automatically liberates others.",
"quoteAuthor": "Nelson Mandela"
}, {
"quoteText": "Without leaps of imagination, or dreaming, we lose the excitement of possibilities. Dreaming, after all, is a form of planning.",
"quoteAuthor": "Gloria Steinem"
}, {
"quoteText": "It isn't where you come from, it's where you're going that counts.",
"quoteAuthor": "Ella Fitzgerald"
}, {
"quoteText": "Silence is a source of great strength.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "To be tested is good. The challenged life may be the best therapist.",
"quoteAuthor": "Gail Sheehy"
}, {
"quoteText": "Can you imagine what I would do if I could do all I can?",
"quoteAuthor": "Sun Tzu"
}, {
"quoteText": "I have been impressed with the urgency of doing. Knowing is not enough; we must apply. Being willing is not enough; we must do.",
"quoteAuthor": "Leonardo da Vinci"
}, {
"quoteText": "Opportunity often comes disguised in the form of misfortune, or temporary defeat.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "To bring anything into your life, imagine that it's already there.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "The most successful people are those who are good at plan B.",
"quoteAuthor": "James Yorke"
}, {
"quoteText": "Criticism is something you can easily avoid by saying nothing, doing nothing, and being nothing.",
"quoteAuthor": "Aristotle"
}, {
"quoteText": "Our virtues and our failings are inseparable, like force and matter. When they separate, man is no more.",
"quoteAuthor": "Nikola Tesla"
}, {
"quoteText": "Mountains cannot be surmounted except by winding paths.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "Courage is not about taking risks unknowingly but putting your own being in front of challenges that others may not be able to.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Only do what your heart tells you.",
"quoteAuthor": "Princess Diana"
}, {
"quoteText": "Smile, breathe, and go slowly.",
"quoteAuthor": "Thich Nhat Hanh"
}, {
"quoteText": "To fly as fast as thought, you must begin by knowing that you have already arrived.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "To speak gratitude is courteous and pleasant, to enact gratitude is generous and noble, but to live gratitude is to touch Heaven.",
"quoteAuthor": "Johannes Gaertner"
}, {
"quoteText": "Obstacles are those things you see when you take your eyes off the goal.",
"quoteAuthor": "Hannah More"
}, {
"quoteText": "The greatest danger for most of us is not that our aim is too high and we miss it, but that it is too low and we reach it.",
"quoteAuthor": "Michelangelo"
}, {
"quoteText": "Iron rusts from disuse; water loses its purity from stagnation... even so does inaction sap the vigour of the mind.",
"quoteAuthor": "Leonardo da Vinci"
}, {
"quoteText": "In rivers, the water that you touch is the last of what has passed and the first of that which comes; so with present time.",
"quoteAuthor": "Leonardo da Vinci"
}, {
"quoteText": "Kind words do not cost much. Yet they accomplish much.",
"quoteAuthor": "Blaise Pascal"
}, {
"quoteText": "Great ideas often receive violent opposition from mediocre minds.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "The winds and waves are always on the side of the ablest navigators.",
"quoteAuthor": "Edward Gibbon"
}, {
"quoteText": "We can change our lives. We can do, have, and be exactly what we wish.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "Courage is not the absence of fear, but simply moving on with dignity despite that fear.",
"quoteAuthor": "Pat Riley"
}, {
"quoteText": "Never do things others can do and will do, if there are things others cannot do or will not do.",
"quoteAuthor": "Amelia Earhart"
}, {
"quoteText": "The poor man is not he who is without a cent, but he who is without a dream.",
"quoteAuthor": "Harry Kemp"
}, {
"quoteText": "Only those who dare to fail greatly can ever achieve greatly.",
"quoteAuthor": "Robert Kennedy"
}, {
"quoteText": "Being in humaneness is good. If we select other goodness and thus are far apart from humaneness, how can we be the wise?",
"quoteAuthor": "Confucius"
}, {
"quoteText": "You are the only person on earth who can use your ability.",
"quoteAuthor": "Zig Ziglar"
}, {
"quoteText": "If you spend your whole life waiting for the storm, you'll never enjoy the sunshine.",
"quoteAuthor": "Morris West"
}, {
"quoteText": "When you lose, don't lose the lesson.",
"quoteAuthor": ""
}, {
"quoteText": "Kindness is the greatest wisdom.",
"quoteAuthor": ""
}, {
"quoteText": "We may encounter many defeats but we must not be defeated.",
"quoteAuthor": "Maya Angelou"
}, {
"quoteText": "Every day may not be good, but there's something good in every day.",
"quoteAuthor": ""
}, {
"quoteText": "A stumble may prevent a fall.",
"quoteAuthor": ""
}, {
"quoteText": "He that respects himself is safe from others; he wears a coat of mail that none can pierce.",
"quoteAuthor": "Henry Longfellow"
}, {
"quoteText": "Nothing is so strong as gentleness. Nothing is so gentle as real strength.",
"quoteAuthor": "Frances de Sales"
}, {
"quoteText": "The pain passes, but the beauty remains.",
"quoteAuthor": "Pierre Auguste Renoir"
}, {
"quoteText": "One secret of success in life is for a man to be ready for his opportunity when it comes.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "Meaning is not what you start with but what you end up with.",
"quoteAuthor": "Peter Elbow"
}, {
"quoteText": "The foolish man seeks happiness in the distance, the wise grows it under his feet.",
"quoteAuthor": "James Oppenheim"
}, {
"quoteText": "Mind is everything: muscle, pieces of rubber. All that I am, I am because of my mind.",
"quoteAuthor": "Paavo Nurmi"
}, {
"quoteText": "What is new in the world? Nothing. What is old in the world? Nothing. Everything has always been and will always be.",
"quoteAuthor": "Sai Baba"
}, {
"quoteText": "You can't trust without risk but neither can you live in a cocoon.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Take things as they are. Punch when you have to punch. Kick when you have to kick.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "To know oneself is to study oneself in action with another person.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "No man can succeed in a line of endeavor which he does not like.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "If one is lucky, a solitary fantasy can totally transform one million realities.",
"quoteAuthor": "Maya Angelou"
}, {
"quoteText": "Look forward to spring as a time when you can start to see what nature has to offer once again.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Neither genius, fame, nor love show the greatness of the soul. Only kindness can do that.",
"quoteAuthor": "Jean Lacordaire"
}, {
"quoteText": "In the end we retain from our studies only that which we practically apply.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "Genuine love should first be directed at oneself � if we do not love ourselves, how can we love others?",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "The least of things with a meaning is worth more in life than the greatest of things without it.",
"quoteAuthor": "Carl Jung"
}, {
"quoteText": "The noblest worship is to make yourself as good and as just as you can.",
"quoteAuthor": "Isocrates"
}, {
"quoteText": "Though no one can go back and make a brand new start, anyone can start from not and make a brand new ending.",
"quoteAuthor": "Carl Bard"
}, {
"quoteText": "Conflict is the gadfly of thought. It stirs us to observation and memory. It instigates to invention. It shocks us out of sheeplike passivity, and sets us at noting and contriving.",
"quoteAuthor": "John Dewey"
}, {
"quoteText": "A dream is your creative vision for your life in the future. You must break out of your current comfort zone and become comfortable with the unfamiliar and the unknown.",
"quoteAuthor": "Denis Waitley"
}, {
"quoteText": "A fine quotation is a diamond on the finger of a man of wit, and a pebble in the hand of a fool.",
"quoteAuthor": "Joseph Roux"
}, {
"quoteText": "Let us revere, let us worship, but erect and open-eyed, the highest, not the lowest; the future, not the past!",
"quoteAuthor": "Charlotte Gilman"
}, {
"quoteText": "Learn from yesterday, live for today, hope for tomorrow.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "Don't think of it as failure. Think of it as time-released success.",
"quoteAuthor": "Robert Orben"
}, {
"quoteText": "Many people think of prosperity that concerns money only to forget that true prosperity is of the mind.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Very little is needed to make a happy life; it is all within yourself, in your way of thinking.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "The least movement is of importance to all nature. The entire ocean is affected by a pebble.",
"quoteAuthor": "Blaise Pascal"
}, {
"quoteText": "A lot of times people look at the negative side of what they feel they can't do. I always look on the positive side of what I can do.",
"quoteAuthor": "Chuck Norris"
}, {
"quoteText": "We are what we repeatedly do. Excellence, then, is not an act but a habit.",
"quoteAuthor": "Aristotle"
}, {
"quoteText": "Know how to listen, and you will profit even from those who talk badly.",
"quoteAuthor": "Plutarch"
}, {
"quoteText": "You can't trust without risk but neither can you live in a cocoon.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "The doors we open and close each day decide the lives we live.",
"quoteAuthor": "Flora Whittemore"
}, {
"quoteText": "You cannot travel the path until you have become the path itself.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "I walk slowly, but I never walk backward.",
"quoteAuthor": "Abraham Lincoln"
}, {
"quoteText": "As we express our gratitude, we must never forget that the highest appreciation is not to utter words, but to live by them.",
"quoteAuthor": "John F. Kennedy"
}, {
"quoteText": "If you're walking down the right path and you're willing to keep walking, eventually you'll make progress.",
"quoteAuthor": "Barack Obama"
}, {
"quoteText": "The least movement is of importance to all nature. The entire ocean is affected by a pebble.",
"quoteAuthor": "Blaise Pascal"
}, {
"quoteText": "Where there is great love, there are always miracles.",
"quoteAuthor": "Willa Cather"
}, {
"quoteText": "You have enemies? Good. That means you've stood up for something, sometime in your life.",
"quoteAuthor": "Winston Churchill"
}, {
"quoteText": "Keep silence for the most part, and speak only when you must, and then briefly.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "Divide each difficulty into as many parts as is feasible and necessary to resolve it.",
"quoteAuthor": "Rene Descartes"
}, {
"quoteText": "Courage is not about taking risks unknowingly but putting your own being in front of challenges that others may not be able to.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Change your thoughts, change your life!",
"quoteAuthor": ""
}, {
"quoteText": "The best place to find a helping hand is at the end of your own arm.",
"quoteAuthor": ""
}, {
"quoteText": "The purpose of learning is growth, and our minds, unlike our bodies, can continue growing as we continue to live.",
"quoteAuthor": "Mortimer Adler"
}, {
"quoteText": "Every human being is the author of his own health or disease.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "It is better to understand a little than to misunderstand a lot.",
"quoteAuthor": "Anatole France"
}, {
"quoteText": "We are what we repeatedly do. Excellence, then, is not an act, but a habit.",
"quoteAuthor": "Aristotle"
}, {
"quoteText": "Knowing is not enough; we must apply!",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "We know the truth, not only by the reason, but by the heart.",
"quoteAuthor": "Blaise Pascal"
}, {
"quoteText": "We choose our joys and sorrows long before we experience them.",
"quoteAuthor": "Kahlil Gibran"
}, {
"quoteText": "Before you can inspire with emotion, you must be swamped with it yourself. Before you can move their tears, your own must flow. To convince them, you must yourself believe.",
"quoteAuthor": "Winston Churchill"
}, {
"quoteText": "Anybody can make history. Only a great man can write it.",
"quoteAuthor": "Oscar Wilde"
}, {
"quoteText": "Happiness is when what you think, what you say, and what you do are in harmony.",
"quoteAuthor": "Mohandas Gandhi"
}, {
"quoteText": "If I know what love is, it is because of you.",
"quoteAuthor": "Hermann Hesse"
}, {
"quoteText": "The best teacher is experience learned from failures.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Allow the world to live as it chooses, and allow yourself to live as you choose.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "Consider how hard it is to change yourself and you'll understand what little chance you have in trying to change others.",
"quoteAuthor": "Jacob Braude"
}, {
"quoteText": "The years teach much which the days never know.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "A lot of people give up just before theyre about to make it. You know you never know when that next obstacle is going to be the last one.",
"quoteAuthor": "Chuck Norris"
}, {
"quoteText": "Self-trust is the first secret of success.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "The harder you fall, the higher you bounce.",
"quoteAuthor": ""
}, {
"quoteText": "Notice that the stiffest tree is most easily cracked, while the bamboo or willow survives by bending with the wind.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "The foolish man seeks happiness in the distance, the wise grows it under his feet.",
"quoteAuthor": "James Oppenheim"
}, {
"quoteText": "Myths which are believed in tend to become true.",
"quoteAuthor": "George Orwell"
}, {
"quoteText": "Nature takes away any faculty that is not used.",
"quoteAuthor": "William R. Inge"
}, {
"quoteText": "Focusing your life solely on making a buck shows a poverty of ambition. It asks too little of yourself. And it will leave you unfulfilled.",
"quoteAuthor": "Barack Obama"
}, {
"quoteText": "Patience is the companion of wisdom.",
"quoteAuthor": "Saint Augustine"
}, {
"quoteText": "The worst bankrupt in the world is the person who has lost his enthusiasm.",
"quoteAuthor": "H. W. Arnold"
}, {
"quoteText": "Let me tell you the secret that has led me to my goal: my strength lies solely in my tenacity.",
"quoteAuthor": "Louis Pasteur"
}, {
"quoteText": "Meaning is not what you start with but what you end up with.",
"quoteAuthor": "Peter Elbow"
}, {
"quoteText": "While we try to teach our children all about life, our children teach us what life is all about.",
"quoteAuthor": "Angela Schwindt"
}, {
"quoteText": "Compassion and happiness are not a sign of weakness but a sign of strength.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "It is common sense to take a method and try it. If it fails, admit it frankly and try another. But above all, try something.",
"quoteAuthor": "Franklin D. Roosevelt"
}, {
"quoteText": "Opportunity often comes disguised in the form of misfortune, or temporary defeat.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Be here now. Be someplace else later. Is that so complicated?",
"quoteAuthor": "David Bader"
}, {
"quoteText": "If you must tell me your opinions, tell me what you believe in. I have plenty of douts of my own.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "I prefer to be true to myself, even at the hazard of incurring the ridicule of others, rather than to be false, and to incur my own abhorrence.",
"quoteAuthor": "Frederick Douglass"
}, {
"quoteText": "If it is not right do not do it; if it is not true do not say it.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "An invasion of armies can be resisted, but not an idea whose time has come.",
"quoteAuthor": "Victor Hugo"
}, {
"quoteText": "To be able to give away riches is mandatory if you wish to possess them. This is the only way that you will be truly rich.",
"quoteAuthor": "Mahummad Ali"
}, {
"quoteText": "Learning without reflection is a waste, reflection without learning is dangerous.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Don't fear failure so much that you refuse to try new things. The saddest summary of life contains three descriptions: could have, might have, and should have.",
"quoteAuthor": ""
}, {
"quoteText": "All fixed set patterns are incapable of adaptability or pliability. The truth is outside of all fixed patterns.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "You may say Im a dreamer, but Im not the only one, I hope someday you will join us, and the world will live as one.",
"quoteAuthor": "John Lennon"
}, {
"quoteText": "Successful people ask better questions, and as a result, they get better answers.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "Ability is what you're capable of doing. Motivation determines what you do.Attitude determines how well you do it.",
"quoteAuthor": "Lou Holtz"
}, {
"quoteText": "How wonderful it is that nobody need wait a single moment before starting to improve the world.",
"quoteAuthor": "Anne Frank"
}, {
"quoteText": "Do you want to know who you are? Don't ask. Act! Action will delineate and define you.",
"quoteAuthor": "Thomas Jefferson"
}, {
"quoteText": "You can do it if you believe you can!",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Nothing happens unless first we dream.",
"quoteAuthor": "Carl Sandburg"
}, {
"quoteText": "To change ones life, start immediately, do it flamboyantly, no exceptions.",
"quoteAuthor": "William James"
}, {
"quoteText": "The greatest antidote to insecurity and the sense of fear is compassion � it brings one back to the basis of one's inner strength",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "When you have got an elephant by the hind legs and he is trying to run away, it's best to let him run.",
"quoteAuthor": "Abraham Lincoln"
}, {
"quoteText": "Everything you are against weakens you. Everything you are for empowers you.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "In the middle of every difficulty lies opportunity.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "The best way to pay for a lovely moment is to enjoy it.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "I don't believe in failure. It's not failure if you enjoyed the process.",
"quoteAuthor": "Oprah Winfrey"
}, {
"quoteText": "Truth, and goodness, and beauty are but different faces of the same all.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "The best and most beautiful things in the world cannot be seen, nor touched... but are felt in the heart.",
"quoteAuthor": "Helen Keller"
}, {
"quoteText": "You have to take it as it happens, but you should try to make it happen the way you want to take it.",
"quoteAuthor": "Old German proverb"
}, {
"quoteText": "If the single man plant himself indomitably on his instincts, and there abide, the huge world will come round to him.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Learn from yesterday, live for today, hope for tomorrow.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "Beauty is not in the face; beauty is a light in the heart.",
"quoteAuthor": "Kahlil Gibran"
}, {
"quoteText": "Success in business requires training and discipline and hard work. But if you're not frightened by these things, the opportunities are just as great today as they ever were.",
"quoteAuthor": "David Rockefeller"
}, {
"quoteText": "Give it all you've got because you never know if there's going to be a next time.",
"quoteAuthor": "Danielle Ingrum"
}, {
"quoteText": "Happiness comes when your work and words are of benefit to yourself and others.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "With courage you will dare to take risks, have the strength to be compassionate, and the wisdom to be humble. Courage is the foundation of integrity.",
"quoteAuthor": "Keshavan Nair"
}, {
"quoteText": "The man who trusts men will make fewer mistakes than he who distrusts them.",
"quoteAuthor": "Cavour"
}, {
"quoteText": "A jug fills drop by drop.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "When you are content to be simply yourself and don't compare or compete, everybody will respect you.",
"quoteAuthor": "Laozi"
}, {
"quoteText": "Consider that not only do negative thoughts and emotions destroy our experience of peace, they also undermine our health.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "The less effort, the faster and more powerful you will be.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "Responsibility is not inherited, it is a choice that everyone needs to make at some point in their life.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Self-complacency is fatal to progress.",
"quoteAuthor": "Margaret Sangster"
}, {
"quoteText": "Intuition is the very force or activity of the soul in its experience through whatever has been the experience of the soul itself.",
"quoteAuthor": "Henry Reed"
}, {
"quoteText": "Write your plans in pencil and give God the eraser.",
"quoteAuthor": "Paulo Coelho"
}, {
"quoteText": "In separateness lies the world's great misery, in compassion lies the world's true strength.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "The thing always happens that you really believe in; and the belief in a thing makes it happen.",
"quoteAuthor": "Frank Wright"
}, {
"quoteText": "A rolling stone gathers no moss.",
"quoteAuthor": "Publilius Syrus"
}, {
"quoteText": "Freedom is the right to live as we wish.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "We must be as courteous to a man as we are to a picture, which we are willing to give the advantage of a good light.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "The dream was always running ahead of me. To catch up, to live for a moment in unison with it, that was the miracle.",
"quoteAuthor": "Anais Nin"
}, {
"quoteText": "Through perseverance many people win success out of what seemed destined to be certain failure.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "Doing what you love is the cornerstone of having abundance in your life.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Intuition is the very force or activity of the soul in its experience through whatever has been the experience of the soul itself.",
"quoteAuthor": "Henry Reed"
}, {
"quoteText": "Every adversity, every failure, every heartache carries with it the seed of an equal or greater benefit.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Of course there is no formula for success except perhaps an unconditional acceptance of life and what it brings.",
"quoteAuthor": "Arthur Rubinstein"
}, {
"quoteText": "The cure for boredom is curiosity. There is no cure for curiosity.",
"quoteAuthor": "Ellen Parr"
}, {
"quoteText": "The longer we dwell on our misfortunes, the greater is their power to harm us.",
"quoteAuthor": "Voltaire"
}, {
"quoteText": "The greatest barrier to success is the fear of failure.",
"quoteAuthor": "Eriksson"
}, {
"quoteText": "Every great advance in science has issued from a new audacity of the imagination.",
"quoteAuthor": "John Dewey"
}, {
"quoteText": "You may be deceived if you trust too much, but you will live in torment if you don't trust enough.",
"quoteAuthor": "Frank Crane"
}, {
"quoteText": "When there is no enemy within, the enemies outside cannot hurt you.",
"quoteAuthor": "African proverb"
}, {
"quoteText": "The most important thing is transforming our minds, for a new way of thinking, a new outlook: we should strive to develop a new inner world.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "First say to yourself what you would be; and then do what you have to do.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "We can do no great things, only small things with great love.",
"quoteAuthor": "Mother Teresa"
}, {
"quoteText": "As we grow as unique persons, we learn to respect the uniqueness of others.",
"quoteAuthor": "Robert Schuller"
}, {
"quoteText": "There is nothing happens to any person but what was in his power to go through with.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "Work out your own salvation. Do not depend on others.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Don't focus on making the right decision, focus on making the decision the right one.",
"quoteAuthor": ""
}, {
"quoteText": "Everyone has been made for some particular work, and the desire for that work has been put in every heart.",
"quoteAuthor": "Rumi"
}, {
"quoteText": "Be like the flower, turn your face to the sun.",
"quoteAuthor": "Kahlil Gibran"
}, {
"quoteText": "Remembering a wrong is like carrying a burden on the mind.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "He that is giddy thinks the world turns round.",
"quoteAuthor": "William Shakespeare"
}, {
"quoteText": "The foolish man seeks happiness in the distance; the wise grows it under his feet.",
"quoteAuthor": "James Openheim"
}, {
"quoteText": "Gratitude is the fairest blossom which springs from the soul.",
"quoteAuthor": "Henry Beecher"
}, {
"quoteText": "Nothing happens unless first we dream.",
"quoteAuthor": "Carl Sandburg"
}, {
"quoteText": "If you look into your own heart, and you find nothing wrong there, what is there to worry about? What is there to fear?",
"quoteAuthor": "Confucius"
}, {
"quoteText": "It is the mark of an educated mind to be able to entertain a thought without accepting it.",
"quoteAuthor": "Aristotle"
}, {
"quoteText": "Our virtues and our failings are inseparable, like force and matter. When they separate, man is no more.",
"quoteAuthor": "Nikola Tesla"
}, {
"quoteText": "There are no failures � just experiences and your reactions to them.",
"quoteAuthor": "Tom Krause"
}, {
"quoteText": "The heart has eyes which the brain knows nothing of.",
"quoteAuthor": "Charles Perkhurst"
}, {
"quoteText": "Life shrinks or expands in proportion to one's courage.",
"quoteAuthor": "Anais Nin"
}, {
"quoteText": "An optimist is a person who sees a green light everywhere, while the pessimist sees only the red spotlight... The truly wise person is colour-blind.",
"quoteAuthor": "Albert Schweitzer"
}, {
"quoteText": "You cannot have what you do not want.",
"quoteAuthor": "John Acosta"
}, {
"quoteText": "You have to believe in yourself.",
"quoteAuthor": "Sun Tzu"
}, {
"quoteText": "The most important point is to accept yourself and stand on your two feet.",
"quoteAuthor": "Shunryu Suzuki"
}, {
"quoteText": "When you arise in the morning, think of what a precious privilege it is to be alive � to breathe, to think, to enjoy, to love.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "All the flowers of all the tomorrows are in the seeds of today.",
"quoteAuthor": ""
}, {
"quoteText": "Do not follow where the path may lead. Go, instead, where there is no path and leave a trail.",
"quoteAuthor": "Ralph Waldo Emerson"
}, {
"quoteText": "It is not fair to ask of others what you are unwilling to do yourself.",
"quoteAuthor": "Eleanor Roosevelt"
}, {
"quoteText": "The moment one gives close attention to anything, it becomes a mysterious, awesome, indescribably magnificent world in itself.",
"quoteAuthor": "Henry Miller"
}, {
"quoteText": "One today is worth two tomorrows.",
"quoteAuthor": "Benjamin Franklin"
}, {
"quoteText": "You have to think anyway, so why not think big?",
"quoteAuthor": "Donald Trump"
}, {
"quoteText": "Knowing your own darkness is the best method for dealing with the darknesses of other people.",
"quoteAuthor": "Carl Jung"
}, {
"quoteText": "Don't let today's disappointments cast a shadow on tomorrow's dreams.",
"quoteAuthor": ""
}, {
"quoteText": "You cannot make yourself feel something you do not feel, but you can make yourself do right in spite of your feelings.",
"quoteAuthor": "Pearl Buck"
}, {
"quoteText": "I walk slowly, but I never walk backward.",
"quoteAuthor": "Abraham Lincoln"
}, {
"quoteText": "There is no retirement for an artist, it's your way of living so there is no end to it.",
"quoteAuthor": "Henry Moore"
}, {
"quoteText": "To be upset over what you don't have is to waste what you do have.",
"quoteAuthor": "Ken S. Keyes"
}, {
"quoteText": "No one has ever become poor by giving.",
"quoteAuthor": "Anne Frank"
}, {
"quoteText": "Better than a thousand hollow words, is one word that brings peace.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Truth is powerful and it prevails.",
"quoteAuthor": "Sojourner Truth"
}, {
"quoteText": "Don't ruin the present with the ruined past.",
"quoteAuthor": "Ellen Gilchrist"
}, {
"quoteText": "Blaze with the fire that is never extinguished.",
"quoteAuthor": "Luisa Sigea"
}, {
"quoteText": "Make the best use of what is in your power, and take the rest as it happens.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "What is new in the world? Nothing. What is old in the world? Nothing. Everything has always been and will always be.",
"quoteAuthor": "Sai Baba"
}, {
"quoteText": "If you do not change direction, you may end up where you are heading.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "The world is a book, and those who do not travel read only a page.",
"quoteAuthor": "Augustinus Sanctus"
}, {
"quoteText": "He who lives in harmony with himself lives in harmony with the universe.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "The best thing in every noble dream is the dreamer...",
"quoteAuthor": "Moncure Conway"
}, {
"quoteText": "Spring is a time for rebirth and the fulfilment of new life.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Every man is a volume if you know how to read him.",
"quoteAuthor": "Channing"
}, {
"quoteText": "You're not obligated to win. You're obligated to keep trying to do the best you can every day.",
"quoteAuthor": "Marian Edelman"
}, {
"quoteText": "Weve got to have a dream if we are going to make a dream come true.",
"quoteAuthor": "Walt Disney"
}, {
"quoteText": "If you want things to be different, perhaps the answer is to become different yourself.",
"quoteAuthor": "Norman Peale"
}, {
"quoteText": "If you want your life to be more rewarding, you have to change the way you think.",
"quoteAuthor": "Oprah Winfrey"
}, {
"quoteText": "I hear and I forget. I see and I remember. I do and I understand.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "In order to win, you must expect to win.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "Everything in the universe goes by indirection. There are no straight lines.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Don't fear failure so much that you refuse to try new things. The saddest summary of life contains three descriptions: could have, might have, and should have.",
"quoteAuthor": ""
}, {
"quoteText": "To be aware of a single shortcoming in oneself is more useful than to be aware of a thousand in someone else.",
"quoteAuthor": "Tenzin Gyatso"
}, {
"quoteText": "There is nothing impossible to him who will try.",
"quoteAuthor": "Alexander the Great"
}, {
"quoteText": "If you have no respect for your own values how can you be worthy of respect from others.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Kindness is more important than wisdom, and the recognition of this is the beginning of wisdom.",
"quoteAuthor": "Theodore Rubin"
}, {
"quoteText": "How far that little candle throws its beams! So shines a good deed in a naughty world.",
"quoteAuthor": "William Shakespeare"
}, {
"quoteText": "We must become the change we want to see.",
"quoteAuthor": "Mahatma Gandhi"
}, {
"quoteText": "Thousands of candles can be lit from a single, and the life of the candle will not be shortened. Happiness never decreases by being shared.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Every great dream begins with a dreamer. Always remember, you have within you the strength, the patience, and the passion to reach for the stars to change the world.",
"quoteAuthor": "Harriet Tubman"
}, {
"quoteText": "Never mistake activity for achievement.",
"quoteAuthor": "John Wooden"
}, {
"quoteText": "You must train your intuition � you must trust the small voice inside you which tells you exactly what to say, what to decide.",
"quoteAuthor": "Ingrid Bergman"
}, {
"quoteText": "Holding on to anger is like grasping a hot coal with the intent of throwing it at someone else; you are the one who gets burned.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "People grow through experience if they meet life honestly and courageously. This is how character is built.",
"quoteAuthor": "Eleanor Roosevelt"
}, {
"quoteText": "It is only when the mind and character slumber that the dress can be seen.",
"quoteAuthor": "Ralph Waldo Emerson"
}, {
"quoteText": "Waste no more time arguing about what a good man should be. Be one.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "Freedom is not worth having if it does not connote freedom to err.",
"quoteAuthor": "Mohandas Gandhi"
}, {
"quoteText": "Do not be embarrassed by your mistakes. Nothing can teach us better than our understanding of them. This is one of the best ways of self-education.",
"quoteAuthor": "Thomas Carlyle"
}, {
"quoteText": "The only real failure in life is not to be true to the best one knows.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Happiness comes when your work and words are of benefit to yourself and others.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Three things cannot be long hidden: the sun, the moon, and the truth.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Anyone who doesn't take truth seriously in small matters cannot be trusted in large ones either.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "He who talks more is sooner exhausted.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Everything in the universe goes by indirection. There are no straight lines.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Nobody made a greater mistake than he who did nothing because he could do only a little.",
"quoteAuthor": "Edmund Burke"
}, {
"quoteText": "Change will not come if we wait for some other person or some other time. We are the ones weve been waiting for. We are the change that we seek.",
"quoteAuthor": "Barack Obama"
}, {
"quoteText": "I begin with an idea and then it becomes something else.",
"quoteAuthor": "Pablo Picasso"
}, {
"quoteText": "Those who cannot learn from history are doomed to repeat it.",
"quoteAuthor": "George Santayan"
}, {
"quoteText": "The highest stage in moral ure at which we can arrive is when we recognize that we ought to control our thoughts.",
"quoteAuthor": "Charles Darwin"
}, {
"quoteText": "Why worry about tomorrow, when today is all we have?",
"quoteAuthor": ""
}, {
"quoteText": "Transformation doesn't take place with a vacuum; instead, it occurs when we are indirectly and directly connected to all those around us.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Every man dies. Not every man really lives.",
"quoteAuthor": ""
}, {
"quoteText": "They must often change, who would be constant in happiness or wisdom.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Quality is never an accident; it is always the result of intelligent effort.",
"quoteAuthor": "John Ruskin"
}, {
"quoteText": "Courage is not about taking risks unknowingly but putting your own being in front of challenges that others may not be able to.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "The weak can never forgive. Forgiveness is the attribute of the strong.",
"quoteAuthor": "Mohandas Gandhi"
}, {
"quoteText": "Our greatest glory is not in never falling, but in rising every time we fall.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "The trick is in what one emphasizes. We either make ourselves miserable, or we make ourselves happy. The amount of work is the same.",
"quoteAuthor": "Carlos Castaneda"
}, {
"quoteText": "Difficulties are things that show a person what they are.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "Our distrust is very expensive.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "By going beyond your own problems and taking care of others, you gain inner strength, self-confidence, courage, and a greater sense of calm.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Knowing your own darkness is the best method for dealing with the darknesses of other people.",
"quoteAuthor": "Carl Jung"
}, {
"quoteText": "Obstacles are those things you see when you take your eyes off the goal.",
"quoteAuthor": "Hannah More"
}, {
"quoteText": "Happiness is not something ready made. It comes from your own actions.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "To get something you never had, you have to do something you never did.",
"quoteAuthor": ""
}, {
"quoteText": "The one who always loses, is the only person who gets the reward.",
"quoteAuthor": "Claire Charmont"
}, {
"quoteText": "Just as a flower, which seems beautiful has color but no perfume, so are the fruitless words of a man who speaks them but does them not.",
"quoteAuthor": "Dhammapada"
}, {
"quoteText": "Things that were hard to bear are sweet to remember.",
"quoteAuthor": "Seneca"
}, {
"quoteText": "We can change our lives. We can do, have, and be exactly what we wish.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "The heart has eyes which the brain knows nothing of.",
"quoteAuthor": "Charles Perkhurst"
}, {
"quoteText": "To know oneself is to study oneself in action with another person.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "Life is a gift, and it offers us the privilege, opportunity, and responsibility to give something back by becoming more",
"quoteAuthor": "Anthony Robbins"
}, {
"quoteText": "Only those who dare to fail greatly can ever achieve greatly.",
"quoteAuthor": "Robert Kennedy"
}, {
"quoteText": "Peace begins with a smile.",
"quoteAuthor": "Mother Teresa"
}, {
"quoteText": "Stay committed to your decisions, but stay flexible in your approach.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "If we could learn to like ourselves, even a little, maybe our cruelties and angers might melt away.",
"quoteAuthor": "John Steinbeck"
}, {
"quoteText": "The only limit to your impact is your imagination and commitment.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "No matter how hard the past, you can always begin again.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "It is better to understand a little than to misunderstand a lot.",
"quoteAuthor": "Anatole France"
}, {
"quoteText": "The moment one gives close attention to anything, even a blade of grass, it becomes a mysterious, awesome, indescribably magnificent world in itself.",
"quoteAuthor": "Henry Miller"
}, {
"quoteText": "No man can succeed in a line of endeavor which he does not like.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Three things in human life are important. The first is to be kind. The second is to be kind. The third is to be kind.",
"quoteAuthor": "Henry James"
}, {
"quoteText": "Mediocrity knows nothing higher than itself, but talent instantly recognizes genius.",
"quoteAuthor": "Arthur Conan Doyle"
}, {
"quoteText": "Giving up doesn't always mean you are weak. Sometimes it means that you are strong enough to let go.",
"quoteAuthor": ""
}, {
"quoteText": "Autumn is a second spring when every leaf is a flower.",
"quoteAuthor": "Albert Camus"
}, {
"quoteText": "To be beautiful means to be yourself. You don�t need to be accepted by others. You need to accept yourself.",
"quoteAuthor": "Thich Nhat Hanh"
}, {
"quoteText": "No valid plans for the future can be made by those who have no capacity for living now.",
"quoteAuthor": "Alan Watts"
}, {
"quoteText": "Things turn out best for those who make the best of the way things turn out.",
"quoteAuthor": "Jack Buck"
}, {
"quoteText": "Progress always involves risks. You can't steal second base and keep your foot on first.",
"quoteAuthor": "Frederick Wilcox"
}, {
"quoteText": "Each day can be one of triumph if you keep up your interests.",
"quoteAuthor": "George Matthew Adams"
}, {
"quoteText": "There is one thing you have got to learn about our movement. Three people are better than no people.",
"quoteAuthor": "Fannie Hamer"
}, {
"quoteText": "Happiness is a perfume you cannot pour on others without getting a few drops on yourself.",
"quoteAuthor": "Ralph Waldo Emerson"
}, {
"quoteText": "However many holy words you read, However many you speak, What good will they do you If you do not act on upon them?",
"quoteAuthor": "Buddha"
}, {
"quoteText": "They can conquer who believe they can.",
"quoteAuthor": "Virgil"
}, {
"quoteText": "The world has the habit of making room for the man whose actions show that he knows where he is going.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "We are what we think. All that we are arises with our thoughts. With our thoughts, we make the world.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "It is very easy to forgive others their mistakes; it takes more grit to forgive them for having witnessed your own.",
"quoteAuthor": "Jessamyn West"
}, {
"quoteText": "When one tugs at a single thing in nature, he finds it attached to the rest of the world.",
"quoteAuthor": "John Muir"
}, {
"quoteText": "What matters is the value we've created in our lives, the people we've made happy and how much we've grown as people.",
"quoteAuthor": "Daisaku Ikeda"
}, {
"quoteText": "To fly as fast as thought, you must begin by knowing that you have already arrived.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "Without leaps of imagination, or dreaming, we lose the excitement of possibilities. Dreaming, after all, is a form of planning.",
"quoteAuthor": "Gloria Steinem"
}, {
"quoteText": "Successful people ask better questions, and as a result, they get better answers.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "Know, first, who you are, and then adorn yourself accordingly.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "I always wanted to be somebody, but I should have been more specific.",
"quoteAuthor": "Lily Tomlin"
}, {
"quoteText": "To enjoy life, we must touch much of it lightly.",
"quoteAuthor": "Voltaire"
}, {
"quoteText": "We do what we do because we believe.",
"quoteAuthor": ""
}, {
"quoteText": "Learn to listen. Opportunity could be knocking at your door very softly.",
"quoteAuthor": "Frank Tyger"
}, {
"quoteText": "All action results from thought, so it is thoughts that matter.",
"quoteAuthor": "Sai Baba"
}, {
"quoteText": "As we risk ourselves, we grow. Each new experience is a risk.",
"quoteAuthor": "Fran Watson"
}, {
"quoteText": "Without this playing with fantasy no creative work has ever yet come to birth. The debt we owe to the play of the imagination is incalculable.",
"quoteAuthor": "Carl Jung"
}, {
"quoteText": "Ability is what you're capable of doing. Motivation determines what you do.Attitude determines how well you do it.",
"quoteAuthor": "Lou Holtz"
}, {
"quoteText": "The cure for boredom is curiosity. There is no cure for curiosity.",
"quoteAuthor": "Ellen Parr"
}, {
"quoteText": "Don't judge each day by the harvest you reap but by the seeds you plant.",
"quoteAuthor": "Robert Stevenson"
}, {
"quoteText": "There is nothing so useless as doing efficiently that which should not be done at all.",
"quoteAuthor": "Peter Drucker"
}, {
"quoteText": "Conflict is the gadfly of thought. It stirs us to observation and memory. It instigates to invention. It shocks us out of sheeplike passivity, and sets us at noting and contriving.",
"quoteAuthor": "John Dewey"
}, {
"quoteText": "Rather than wishing for change, you first must be prepared to change.",
"quoteAuthor": "Catherine Pulsifer"
}, {
"quoteText": "You'll see it when you believe it.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Everyone smiles in the same language.",
"quoteAuthor": ""
}, {
"quoteText": "Thousands of candles can be lighted from a single candle, and the life of the candle will not be shortened. Happiness never decreases by being shared.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Be faithful in small things because it is in them that your strength lies.",
"quoteAuthor": "Mother Teresa"
}, {
"quoteText": "There is only one success � to be able to spend your life in your own way.",
"quoteAuthor": "Christopher Morley"
}, {
"quoteText": "Yesterdays home runs don't win today's games.",
"quoteAuthor": "Babe Ruth"
}, {
"quoteText": "Letting go isn�t the end of the world; it�s the beginning of a new life.",
"quoteAuthor": ""
}, {
"quoteText": "Nature gave us one tongue and two ears so we could hear twice as much as we speak.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "Work while you have the light. You are responsible for the talent that has been entrusted to you.",
"quoteAuthor": "Henri-Frederic Amiel"
}, {
"quoteText": "There are only two ways to live your life. One is as though nothing is a miracle. The other is as though everything is a miracle.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "I am not afraid of tomorrow, for I have seen yesterday and I love today.",
"quoteAuthor": "William White"
}, {
"quoteText": "I love my past. I love my present. Im not ashamed of what Ive had, and Im not sad because I have it no longer.",
"quoteAuthor": "Colette"
}, {
"quoteText": "Prejudice is a burden that confuses the past, threatens the future and renders the present inaccessible.",
"quoteAuthor": "Maya Angelou"
}, {
"quoteText": "I cannot give you the formula for success, but I can give you the formula for failure: which is: Try to please everybody.",
"quoteAuthor": "Herbert Swope"
}, {
"quoteText": "Just as much as we see in others we have in ourselves.",
"quoteAuthor": "William Hazlitt"
}, {
"quoteText": "Prosperity depends more on wanting what you have than having what you want.",
"quoteAuthor": "Geoffrey F. Abert"
}, {
"quoteText": "Stay committed to your decisions, but stay flexible in your approach.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "How many cares one loses when one decides not to be something but to be someone.",
"quoteAuthor": "Coco Chanel"
}, {
"quoteText": "The most successful people are those who are good at plan B.",
"quoteAuthor": "James Yorke"
}, {
"quoteText": "He who knows, does not speak. He who speaks, does not know.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "There is nothing in a caterpillar that tells you it's going to be a butterfly.",
"quoteAuthor": "Buckminster Fuller"
}, {
"quoteText": "We cannot direct the wind but we can adjust the sails.",
"quoteAuthor": ""
}, {
"quoteText": "He who conquers others is strong; He who conquers himself is mighty.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "True silence is the rest of the mind; it is to the spirit what sleep is to the body, nourishment and refreshment.",
"quoteAuthor": "William Penn"
}, {
"quoteText": "Life is a process. We are a process. The universe is a process.",
"quoteAuthor": "Anne Schaef"
}, {
"quoteText": "One may say the eternal mystery of the world is its comprehensibility.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "Peace of mind is not the absence of conflict from life, but the ability to cope with it.",
"quoteAuthor": ""
}, {
"quoteText": "Adversity isn't set against you to fail; adversity is a way to build your character so that you can succeed over and over again through perseverance.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "To be beautiful means to be yourself. You don�t need to be accepted by others. You need to accept yourself.",
"quoteAuthor": "Thich Nhat Hanh"
}, {
"quoteText": "The self is not something ready-made, but something in continuous formation through choice of action.",
"quoteAuthor": "John Dewey"
}, {
"quoteText": "Once you choose hope, anythings possible.",
"quoteAuthor": "Christopher Reeve"
}, {
"quoteText": "Everything is perfect in the universe � even your desire to improve it.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Ability is what you're capable of doing. Motivation determines what you do.Attitude determines how well you do it.",
"quoteAuthor": "Lou Holtz"
}, {
"quoteText": "Real magic in relationships means an absence of judgement of others.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "To accomplish great things, we must not only act, but also dream; not only plan, but also believe.",
"quoteAuthor": "Anatole France"
}, {
"quoteText": "Limitations live only in our minds. But if we use our imaginations, our possibilities become limitless.",
"quoteAuthor": "Jamie Paolinetti"
}, {
"quoteText": "Yesterdays home runs don't win today's games.",
"quoteAuthor": "Babe Ruth"
}, {
"quoteText": "Our greatness lies not so much in being able to remake the world as being able to remake ourselves.",
"quoteAuthor": "Mahatma Gandhi"
}, {
"quoteText": "The noblest worship is to make yourself as good and as just as you can.",
"quoteAuthor": "Isocrates"
}, {
"quoteText": "Allow the world to live as it chooses, and allow yourself to live as you choose.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "Wherever you go, go with all your heart.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Nothing is at last sacred but the integrity of your own mind.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Moments of complete apathy are the best for new creations.",
"quoteAuthor": "Philip Breedveld"
}, {
"quoteText": "The only real mistake is the one from which we learn nothing.",
"quoteAuthor": "John Powell"
}, {
"quoteText": "Every adversity, every failure, every heartache carries with it the seed of an equal or greater benefit.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "To dream of the person you would like to be is to waste the person you are.",
"quoteAuthor": "Tim Menchen"
}, {
"quoteText": "These days people seek knowledge, not wisdom. Knowledge is of the past, wisdom is of the future.",
"quoteAuthor": "Vernon Cooper"
}, {
"quoteText": "Criticism is something you can easily avoid by saying nothing, doing nothing, and being nothing.",
"quoteAuthor": "Aristotle"
}, {
"quoteText": "Prejudice is a burden that confuses the past, threatens the future and renders the present inaccessible.",
"quoteAuthor": "Maya Angelou"
}, {
"quoteText": "You are the only person on earth who can use your ability.",
"quoteAuthor": "Zig Ziglar"
}, {
"quoteText": "You were not born a winner, and you were not born a loser. You are what you make yourself be.",
"quoteAuthor": "Lou Holtz"
}, {
"quoteText": "He who experiences the unity of life sees his own Self in all beings, and all beings in his own Self, and looks on everything with an impartial eye.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Myths which are believed in tend to become true.",
"quoteAuthor": "George Orwell"
}, {
"quoteText": "Don't let today's disappointments cast a shadow on tomorrow's dreams.",
"quoteAuthor": ""
}, {
"quoteText": "All serious daring starts from within.",
"quoteAuthor": "Harriet Beecher Stowe"
}, {
"quoteText": "The important thing is this: to be able at any moment to sacrifice what we are for what we could become.",
"quoteAuthor": "Charles Dubois"
}, {
"quoteText": "Gratitude is not only the greatest of virtues, but the paren't of all the others.",
"quoteAuthor": "Cicero"
}, {
"quoteText": "There is no scarcity of opportunity to make a living at what you love; theres only scarcity of resolve to make it happen.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "It is never too late. Even if you are going to die tomorrow, keep yourself straight and clear and be a happy human being today.",
"quoteAuthor": "Lama Yeshe"
}, {
"quoteText": "The universe is transformation; our life is what our thoughts make it.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "Do good by stealth, and blush to find it fame.",
"quoteAuthor": "Alexander Pope"
}, {
"quoteText": "Respect is not something that you can ask for, buy or borrow. Respect is what you earn from each person no matter their background or status.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Things do not change; we change.",
"quoteAuthor": "Henry Thoreau"
}, {
"quoteText": "Excellence is not a skill. It is an attitude.",
"quoteAuthor": "Ralph Marston"
}, {
"quoteText": "We must learn our limits. We are all something, but none of us are everything.",
"quoteAuthor": "Blaise Pascal"
}, {
"quoteText": "You have to think anyway, so why not think big?",
"quoteAuthor": "Donald Trump"
}, {
"quoteText": "The harder you fall, the higher you bounce.",
"quoteAuthor": ""
}, {
"quoteText": "Always seek out the seed of triumph in every adversity.",
"quoteAuthor": "Og Mandino"
}, {
"quoteText": "To be upset over what you don't have is to waste what you do have.",
"quoteAuthor": "Ken S. Keyes"
}, {
"quoteText": "Opportunity often comes disguised in the form of misfortune, or temporary defeat.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Yesterdays home runs don't win today's games.",
"quoteAuthor": "Babe Ruth"
}, {
"quoteText": "Happiness does not come from having much, but from being attached to little.",
"quoteAuthor": "Cheng Yen"
}, {
"quoteText": "Everyone has been made for some particular work, and the desire for that work has been put in every heart.",
"quoteAuthor": "Rumi"
}, {
"quoteText": "Act as if what you do makes a difference. It does.",
"quoteAuthor": "William James"
}, {
"quoteText": "Learn wisdom from the ways of a seedling. A seedling which is never hardened off through stressful situations will never become a strong productive plant.",
"quoteAuthor": "Stephen Sigmund"
}, {
"quoteText": "No pessimist ever discovered the secrets of the stars, or sailed to an uncharted land, or opened a new heaven to the human spirit.",
"quoteAuthor": "Helen Keller"
}, {
"quoteText": "We are all faced with a series of great opportunities brilliantly disguised as impossible situations.",
"quoteAuthor": "Charles R. Swindoll"
}, {
"quoteText": "If you are patient in one moment of anger, you will escape one hundred days of sorrow.",
"quoteAuthor": "Chinese proverb"
}, {
"quoteText": "The poor man is not he who is without a cent, but he who is without a dream.",
"quoteAuthor": "Harry Kemp"
}, {
"quoteText": "All men have a sweetness in their life. That is what helps them go on. It is towards that they turn when they feel too worn out.",
"quoteAuthor": "Albert Camus"
}, {
"quoteText": "Be a good listener. Your ears will never get you in trouble.",
"quoteAuthor": "Frank Tyger"
}, {
"quoteText": "Every day may not be good, but there's something good in every day.",
"quoteAuthor": ""
}, {
"quoteText": "Meditation brings wisdom; lack of mediation leaves ignorance. Know well what leads you forward and what hold you back, and choose the path that leads to wisdom.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "The heart has eyes which the brain knows nothing of.",
"quoteAuthor": "Charles Perkhurst"
}, {
"quoteText": "What we see is mainly what we look for.",
"quoteAuthor": ""
}, {
"quoteText": "It is impossible to feel grateful and depressed in the same moment.",
"quoteAuthor": "Naomi Williams"
}, {
"quoteText": "You learn to speak by speaking, to study by studying, to run by running, to work by working; in just the same way, you learn to love by loving.",
"quoteAuthor": "Anatole France"
}, {
"quoteText": "I have been impressed with the urgency of doing. Knowing is not enough; we must apply. Being willing is not enough; we must do.",
"quoteAuthor": "Leonardo da Vinci"
}, {
"quoteText": "The best place to find a helping hand is at the end of your own arm.",
"quoteAuthor": ""
}, {
"quoteText": "The worst bankrupt in the world is the person who has lost his enthusiasm.",
"quoteAuthor": "H. W. Arnold"
}, {
"quoteText": "The purpose of learning is growth, and our minds, unlike our bodies, can continue growing as we continue to live.",
"quoteAuthor": "Mortimer Adler"
}, {
"quoteText": "Strong beliefs win strong men, and then make them stronger.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "He that never changes his opinions, never corrects his mistakes, and will never be wiser on the morrow than he is today.",
"quoteAuthor": "Tryon Edwards"
}, {
"quoteText": "I cannot always control what goes on outside. But I can always control what goes on inside.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "In order to win, you must expect to win.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "For every failure, there's an alternative course of action. You just have to find it. When you come to a roadblock, take a detour.",
"quoteAuthor": "Mary Kay Ash"
}, {
"quoteText": "Opportunity is missed by most because it is dressed in overalls and looks like work.",
"quoteAuthor": "Thomas Edison"
}, {
"quoteText": "Give thanks for the rain of life that propels us to reach new horizons.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "A beautiful thing is never perfect.",
"quoteAuthor": ""
}, {
"quoteText": "You give before you get.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "We must be as courteous to a man as we are to a picture, which we are willing to give the advantage of a good light.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Imagination disposes of everything; it creates beauty, justice, and happiness, which are everything in this world.",
"quoteAuthor": "Blaise Pascal"
}, {
"quoteText": "There are no failures. Just experiences and your reactions to them.",
"quoteAuthor": "Tom Krause"
}, {
"quoteText": "As we grow as unique persons, we learn to respect the uniqueness of others.",
"quoteAuthor": "Robert Schuller"
}, {
"quoteText": "Every great mistake has a halfway moment, a split second when it can be recalled and perhaps remedied.",
"quoteAuthor": "Pearl Buck"
}, {
"quoteText": "The self is not something ready-made, but something in continuous formation through choice of action.",
"quoteAuthor": "John Dewey"
}, {
"quoteText": "Don't let today's disappointments cast a shadow on tomorrow's dreams.",
"quoteAuthor": ""
}, {
"quoteText": "To listen well is as powerful a means of communication and influence as to talk well.",
"quoteAuthor": "John Marshall"
}, {
"quoteText": "Imagination is the living power and prime agent of all human perception.",
"quoteAuthor": "Samuel Taylor Coleridge"
}, {
"quoteText": "When you don't know what you believe, everything becomes an argument. Everything is debatable. But when you stand for something, decisions are obvious.",
"quoteAuthor": ""
}, {
"quoteText": "You only lose what you cling to.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "There is only one happiness in life, to love and be loved.",
"quoteAuthor": "George Sand"
}, {
"quoteText": "Happiness is found in doing, not merely possessing.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Live through feeling and you will live through love. For feeling is the language of the soul, and feeling is truth.",
"quoteAuthor": "Matt Zotti"
}, {
"quoteText": "He who is contented is rich.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "You are always free to change your mind and choose a different future, or a different past.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "Kindness in words creates confidence. Kindness in thinking creates profoundness. Kindness in giving creates love.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Reason and free inquiry are the only effectual agents against error.",
"quoteAuthor": "Thomas Jefferson"
}, {
"quoteText": "Moments of complete apathy are the best for new creations.",
"quoteAuthor": "Philip Breedveld"
}, {
"quoteText": "We don't stop playing because we grow old; we grow old because we stop playing.",
"quoteAuthor": "Bernard Shaw"
}, {
"quoteText": "You can't choose up sides on a round world.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "The best cure for the body is a quiet mind.",
"quoteAuthor": "Napoleon Bonaparte"
}, {
"quoteText": "He who lives in harmony with himself lives in harmony with the universe.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "By believing passionately in something that does not yet exist, we create it.",
"quoteAuthor": "Nikos Kazantzakis"
}, {
"quoteText": "If one is estranged from oneself, then one is estranged from others too. If one is out of touch with oneself, then one cannot touch others.",
"quoteAuthor": "Anne Lindbergh"
}, {
"quoteText": "You got to be careful if you don't know where you're going, because you might not get there.",
"quoteAuthor": "Yogi Berra"
}, {
"quoteText": "See the positive side, the potential, and make an effort.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Always be yourself, express yourself, have faith in yourself, do not go out and look for a successful personality and duplicate it.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "By accepting yourself and being fully what you are, your presence can make others happy.",
"quoteAuthor": "Jane Roberts"
}, {
"quoteText": "Never deny a diagnosis, but do deny the negative verdict that may go with it.",
"quoteAuthor": "Norman Cousins"
}, {
"quoteText": "The really unhappy person is the one who leaves undone what they can do, and starts doing what they don't understand; no wonder they come to grief.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "If you don't know where you are going, you will probably end up somewhere else.",
"quoteAuthor": "Lawrence Peter"
}, {
"quoteText": "I am a man of fixed and unbending principles, the first of which is to be flexible at all times.",
"quoteAuthor": "Everett Dirksen"
}, {
"quoteText": "The happiness of a man in this life does not consist in the absence but in the mastery of his passions.",
"quoteAuthor": "Alfred Tennyson"
}, {
"quoteText": "Life is movement-we breathe, we eat, we walk, we move!",
"quoteAuthor": "John Pierrakos"
}, {
"quoteText": "Your work is to discover your world and then with all your heart give yourself to it.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "You cannot be lonely if you like the person you're alone with.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "The place to improve the world is first in one's own heart and head and hands.",
"quoteAuthor": "Robert M. Pirsig"
}, {
"quoteText": "Why worry about tomorrow, when today is all we have?",
"quoteAuthor": ""
}, {
"quoteText": "One of the advantages of being disorderly is that one is constantly making exciting discoveries.",
"quoteAuthor": "A. A. Milne"
}, {
"quoteText": "I believe that we are solely responsible for our choices, and we have to accept the consequences of every deed, word, and thought throughout our lifetime.",
"quoteAuthor": "Elisabeth Kubler-Ross"
}, {
"quoteText": "To be what we are, and to become what we are capable of becoming, is the only end of life.",
"quoteAuthor": "Robert Stevenson"
}, {
"quoteText": "Face your deficiencies and acknowledge them; but do not let them master you. Let them teach you patience, sweetness, insight.",
"quoteAuthor": "Helen Keller"
}, {
"quoteText": "We know the truth, not only by the reason, but by the heart.",
"quoteAuthor": "Blaise Pascal"
}, {
"quoteText": "Fame usually comes to those who are thinking about something else.",
"quoteAuthor": "Holmes"
}, {
"quoteText": "The truest wisdom is a resolute determination.",
"quoteAuthor": "Napoleon Bonaparte"
}, {
"quoteText": "Never, never, never give up.",
"quoteAuthor": "Winston Churchill"
}, {
"quoteText": "The best thing in every noble dream is the dreamer...",
"quoteAuthor": "Moncure Conway"
}, {
"quoteText": "Everyone smiles in the same language.",
"quoteAuthor": ""
}, {
"quoteText": "If you want a thing done well, do it yourself.",
"quoteAuthor": "Napoleon Bonaparte"
}, {
"quoteText": "Take heed: you do not find what you do not seek.",
"quoteAuthor": "English proverb"
}, {
"quoteText": "If you look into your own heart, and you find nothing wrong there, what is there to worry about? What is there to fear?",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Waste no more time arguing about what a good man should be. Be one.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "Just as a candle cannot burn without fire, men cannot live without a spiritual life.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Yesterday I dared to struggle. Today I dare to win.",
"quoteAuthor": "Bernadette Devlin"
}, {
"quoteText": "Be a good listener. Your ears will never get you in trouble.",
"quoteAuthor": "Frank Tyger"
}, {
"quoteText": "I do not believe in a fate that falls on men however they act; but I do believe in a fate that falls on man unless they act.",
"quoteAuthor": "G. K. Chesterton"
}, {
"quoteText": "If you propose to speak, always ask yourself, is it true, is it necessary, is it kind.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Kind words do not cost much. Yet they accomplish much.",
"quoteAuthor": "Blaise Pascal"
}, {
"quoteText": "Thousands of candles can be lighted from a single candle, and the life of the candle will not be shortened. Happiness never decreases by being shared.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "To understand the heart and mind of a person, look not at what he has already achieved, but at what he aspires to do.",
"quoteAuthor": "Kahlil Gibran"
}, {
"quoteText": "It is not only for what we do that we are held responsible, but also for what we do not do.",
"quoteAuthor": "Moliere"
}, {
"quoteText": "A good teacher is like a candle � it consumes itself to light the way for others.",
"quoteAuthor": ""
}, {
"quoteText": "Be kind whenever possible. It is always possible.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "When fate hands us a lemon, lets try to make lemonade.",
"quoteAuthor": "Dale Carnegie"
}, {
"quoteText": "If the stars should appear but one night every thousand years how man would marvel and adore.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Though no one can go back and make a brand new start, anyone can start from now and make a brand new ending.",
"quoteAuthor": ""
}, {
"quoteText": "Risk more than others think is safe. Care more than others think is wise. Dream more than others think is practical.Expect more than others think is possible.",
"quoteAuthor": "Cadet Maxim"
}, {
"quoteText": "Go put your creed into the deed. Nor speak with double tongue.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "There are two ways to slide easily through life: to believe everything or to doubt everything; both ways save us from thinking.",
"quoteAuthor": "Alfred Korzybski"
}, {
"quoteText": "Ignorant men don't know what good they hold in their hands until they've flung it away.",
"quoteAuthor": "Sophocles"
}, {
"quoteText": "Failure will never overtake me if my determination to succeed is strong enough.",
"quoteAuthor": "Og Mandino"
}, {
"quoteText": "Let go of your attachment to being right, and suddenly your mind is more open. You're able to benefit from the unique viewpoints of others, without being crippled by your own judgement.",
"quoteAuthor": "Ralph Marston"
}, {
"quoteText": "Our doubts are traitors and make us lose the good we often might win, by fearing to attempt.",
"quoteAuthor": "Jane Addams"
}, {
"quoteText": "While we try to teach our children all about life, our children teach us what life is all about.",
"quoteAuthor": "Angela Schwindt"
}, {
"quoteText": "Kind words can be short and easy to speak but their echoes are truly endless.",
"quoteAuthor": "Mother Teresa"
}, {
"quoteText": "Things turn out best for those who make the best of the way things turn out.",
"quoteAuthor": "Jack Buck"
}, {
"quoteText": "Wrinkles should merely indicate where smiles have been.",
"quoteAuthor": "Mark Twain"
}, {
"quoteText": "Your attitude, not your aptitude, will determine your altitude.",
"quoteAuthor": "Zig Ziglar"
}, {
"quoteText": "You can be what you want to be. You have the power within and we will help you always.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "The thoughts we choose to think are the tools we use to paint the canvas of our lives.",
"quoteAuthor": "Louise Hay"
}, {
"quoteText": "Don't be afraid to go out on a limb. That's where the fruit is.",
"quoteAuthor": "H. Jackson Browne"
}, {
"quoteText": "As an organizer I start from where the world is, as it is, not as I would like it to be.",
"quoteAuthor": "Saul Alinsky"
}, {
"quoteText": "If you can dream it, you can do it.",
"quoteAuthor": "Walt Disney"
}, {
"quoteText": "Let yourself be silently drawn by the stronger pull of what you really love.",
"quoteAuthor": "Rumi"
}, {
"quoteText": "Where all think alike, no one thinks very much.",
"quoteAuthor": "Walter Lippmann"
}, {
"quoteText": "Mediocrity knows nothing higher than itself, but talent instantly recognizes genius.",
"quoteAuthor": "Arthur Conan Doyle"
}, {
"quoteText": "The undertaking of a new action brings new strength.",
"quoteAuthor": "Richard Evans"
}, {
"quoteText": "What you see depends on what you're looking for.",
"quoteAuthor": ""
}, {
"quoteText": "Be your own hero, it's cheaper than a movie ticket.",
"quoteAuthor": "Doug Horton"
}, {
"quoteText": "I gave my life to become the person I am right now. Was it worth it?",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "Through pride we are ever deceiving ourselves. But deep down below the surface of the average conscience a still, small voice says to us, Something is out of tune.",
"quoteAuthor": "Carl Jung"
}, {
"quoteText": "Give thanks for a little and you will find a lot.",
"quoteAuthor": "Hausa"
}, {
"quoteText": "Most powerful is he who has himself in his own power.",
"quoteAuthor": "Seneca"
}, {
"quoteText": "If we learn to open our hearts, anyone, including the people who drive us crazy, can be our teacher.",
"quoteAuthor": "Pema Chodron"
}, {
"quoteText": "It is better to take many small steps in the right direction than to make a great leap forward only to stumble backward.",
"quoteAuthor": ""
}, {
"quoteText": "Gratitude is not only the greatest of virtues, but the paren't of all the others.",
"quoteAuthor": "Cicero"
}, {
"quoteText": "When you doubt your power, you give power to your doubt.",
"quoteAuthor": "Honore de Balzac"
}, {
"quoteText": "You may only be someone in the world, but to someone else, you may be the world.",
"quoteAuthor": ""
}, {
"quoteText": "You, yourself, as much as anybody in the entire universe, deserve your love and affection.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "You block your dream when you allow your fear to grow bigger than your faith.",
"quoteAuthor": "Mary Morrissey"
}, {
"quoteText": "Your ability to learn faster than your competition is your only sustainable competitive advantage.",
"quoteAuthor": "Arie de Gues"
}, {
"quoteText": "Nobody made a greater mistake than he who did nothing because he could do only a little.",
"quoteAuthor": "Edmund Burke"
}, {
"quoteText": "A gem cannot be polished without friction, nor a man perfected without trials.",
"quoteAuthor": "Chinese proverb"
}, {
"quoteText": "The first duty of a human being is to assume the right functional relationship to society � more briefly, to find your real job, and do it.",
"quoteAuthor": "Charlotte Perkins Gilman"
}, {
"quoteText": "Mistakes are always forgivable, if one has the courage to admit them.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "Forgiveness does not change the past, but it does enlarge the future.",
"quoteAuthor": "Paul Boese"
}, {
"quoteText": "I have just three things to teach: simplicity, patience, compassion. These three are your greatest treasures.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Let the future tell the truth, and evaluate each one according to his work and accomplishments. The present is theirs; the future, for which I have really worked, is mine.",
"quoteAuthor": "Nikola Tesla"
}, {
"quoteText": "The important thing is this: to be able at any moment to sacrifice what we are for what we could become.",
"quoteAuthor": "Charles Dubois"
}, {
"quoteText": "I think and that is all that I am.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Don't leave a stone unturned. It's always something, to know you have done the most you could.",
"quoteAuthor": "Charles Dickens"
}, {
"quoteText": "In the middle of every difficulty lies opportunity.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "Fame usually comes to those who are thinking about something else.",
"quoteAuthor": "Holmes"
}, {
"quoteText": "If one does not know to which port is sailing, no wind is favorable.",
"quoteAuthor": "Seneca"
}, {
"quoteText": "A fine quotation is a diamond on the finger of a man of wit, and a pebble in the hand of a fool.",
"quoteAuthor": "Joseph Roux"
}, {
"quoteText": "Moral excellence comes about as a result of habit. We become just by doing just acts, temperate by doing temperate acts, brave by doing brave acts.",
"quoteAuthor": "Aristotle"
}, {
"quoteText": "Id rather regret the things that I have done than the things that I have not done.",
"quoteAuthor": "Lucille Ball"
}, {
"quoteText": "Do not be too timid and squeamish about your reactions. All life is an experiment. The more experiments you make the better.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "The deepest craving of human nature is the need to be appreciated.",
"quoteAuthor": "William James"
}, {
"quoteText": "Thousands of candles can be lighted from a single candle, and the life of the candle will not be shortened. Happiness never decreases by being shared.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Love does not consist of gazing at each other, but in looking together in the same direction.",
"quoteAuthor": "Antoine de Saint-Exupery"
}, {
"quoteText": "We are what we think. All that we are arises with our thoughts. With our thoughts, we make the world.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Never doubt that a small group of thoughtful, committed people can change the world. Indeed. It is the only thing that ever has.",
"quoteAuthor": "Margaret Mead"
}, {
"quoteText": "If you can dream it, you can do it.",
"quoteAuthor": "Walt Disney"
}, {
"quoteText": "The odds of hitting your target go up dramatically when you aim at it.",
"quoteAuthor": "Mal Pancoast"
}, {
"quoteText": "Compassion and happiness are not a sign of weakness but a sign of strength.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "I cannot make my days longer so I strive to make them better.",
"quoteAuthor": "Henry David Thoreau"
}, {
"quoteText": "Character cannot be developed in ease and quiet. Only through experience of trial and suffering can the soul be strengthened, vision cleared, ambition inspired, and success achieved.",
"quoteAuthor": "Helen Keller"
}, {
"quoteText": "A wise man can learn more from a foolish question than a fool can learn from a wise answer.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "The key to growth is the introduction of higher dimensions of consciousness into our awareness.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Fortune befriends the bold.",
"quoteAuthor": "John Dryden"
}, {
"quoteText": "Excellence is not a skill. It is an attitude.",
"quoteAuthor": "Ralph Marston"
}, {
"quoteText": "Your attitude, not your aptitude, will determine your altitude.",
"quoteAuthor": "Zig Ziglar"
}, {
"quoteText": "There is no scarcity of opportunity to make a living at what you love; theres only scarcity of resolve to make it happen.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "One must be fond of people and trust them if one is not to make a mess of life.",
"quoteAuthor": "E. M. Forster"
}, {
"quoteText": "The happy and efficient people in this world are those who accept trouble as a normal detail of human life and resolve to capitalize it when it comes along.",
"quoteAuthor": "H. Bertram Lewis"
}, {
"quoteText": "Let your hook always be cast; in the pool where you least expect it, there will be a fish.",
"quoteAuthor": "Ovid"
}, {
"quoteText": "Arrogance and rudeness are training wheels on the bicycle of life � for weak people who cannot keep their balance without them.",
"quoteAuthor": "Laura Teresa Marquez"
}, {
"quoteText": "Every person, all the events of your life are there because you have drawn them there. What you choose to do with them is up to you.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "We never understand how little we need in this world until we know the loss of it.",
"quoteAuthor": "James Barrie"
}, {
"quoteText": "We have committed the Golden Rule to memory; let us now commit it to life.",
"quoteAuthor": "Edwin Markham"
}, {
"quoteText": "Obstacles are those things you see when you take your eyes off the goal.",
"quoteAuthor": "Hannah More"
}, {
"quoteText": "Knowing your own darkness is the best method for dealing with the darknesses of other people.",
"quoteAuthor": "Carl Jung"
}, {
"quoteText": "Life is a learning experience, only if you learn.",
"quoteAuthor": "Yogi Berra"
}, {
"quoteText": "It is only when the mind and character slumber that the dress can be seen.",
"quoteAuthor": "Ralph Waldo Emerson"
}, {
"quoteText": "If you can dream it, you can do it.",
"quoteAuthor": "Walt Disney"
}, {
"quoteText": "Kind words do not cost much. Yet they accomplish much.",
"quoteAuthor": "Blaise Pascal"
}, {
"quoteText": "It is with words as with sunbeams. The more they are condensed, the deeper they burn.",
"quoteAuthor": "Robert Southey"
}, {
"quoteText": "Each time we face a fear, we gain strength, courage, and confidence in the doing.",
"quoteAuthor": ""
}, {
"quoteText": "We cannot direct the wind but we can adjust the sails.",
"quoteAuthor": ""
}, {
"quoteText": "This world, after all our science and sciences, is still a miracle; wonderful, inscrutable, magical and more, to whosoever will think of it.",
"quoteAuthor": "Thomas Carlyle"
}, {
"quoteText": "Every gift from a friend is a wish for your happiness.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "When people are like each other they tend to like each other.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "Id rather regret the things that I have done than the things that I have not done.",
"quoteAuthor": "Lucille Ball"
}, {
"quoteText": "Sincerity is the way of Heaven. The attainment of sincerity is the way of men.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "I always wanted to be somebody, but I should have been more specific.",
"quoteAuthor": "Lily Tomlin"
}, {
"quoteText": "The best and most beautiful things in the world cannot be seen, nor touched... but are felt in the heart.",
"quoteAuthor": "Helen Keller"
}, {
"quoteText": "You can't trust without risk but neither can you live in a cocoon.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Everything you are against weakens you. Everything you are for empowers you.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "All I can say about life is, Oh God, enjoy it!",
"quoteAuthor": "Bob Newhart"
}, {
"quoteText": "The secret of joy in work is contained in one word � excellence. To know how to do something well is to enjoy it.",
"quoteAuthor": "Pearl Buck"
}, {
"quoteText": "There is only one happiness in life, to love and be loved.",
"quoteAuthor": "George Sand"
}, {
"quoteText": "The eye sees only what the mind is prepared to comprehend.",
"quoteAuthor": "Henri Bergson"
}, {
"quoteText": "Well begun is half done.",
"quoteAuthor": "Aristotle"
}, {
"quoteText": "Don't think of it as failure. Think of it as time-released success.",
"quoteAuthor": "Robert Orben"
}, {
"quoteText": "Your friends will know you better in the first minute you meet than your acquaintances will know you in a thousand years.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "Try not to become a man of success, but rather try to become a man of value.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "Meaning is not what you start with but what you end up with.",
"quoteAuthor": "Peter Elbow"
}, {
"quoteText": "Be the change that you want to see in the world.",
"quoteAuthor": "Mohandas Gandhi"
}, {
"quoteText": "The most formidable weapon against errors of every kind is reason.",
"quoteAuthor": "Thomas Paine"
}, {
"quoteText": "I don't believe in failure. It is not failure if you enjoyed the process.",
"quoteAuthor": "Oprah Winfrey"
}, {
"quoteText": "Character cannot be developed in ease and quiet. Only through experience of trial and suffering can the soul be strengthened, vision cleared, ambition inspired, and success achieved.",
"quoteAuthor": "Helen Keller"
}, {
"quoteText": "A little more persistence, a little more effort, and what seemed hopeless failure may turn to glorious success.",
"quoteAuthor": "Elbert Hubbard"
}, {
"quoteText": "The more you care, the stronger you can be.",
"quoteAuthor": "Jim Rohn"
}, {
"quoteText": "Lots of people want to ride with you in the limo, but what you want is someone who will take the bus with you when the limo breaks down.",
"quoteAuthor": "Oprah Winfrey"
}, {
"quoteText": "A good rest is half the work.",
"quoteAuthor": ""
}, {
"quoteText": "Goals are the fuel in the furnace of achievement.",
"quoteAuthor": "Brian Tracy"
}, {
"quoteText": "He who is contented is rich.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "God always takes the simplest way.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "Just trust yourself, then you will know how to live.",
"quoteAuthor": "Goethe"
}, {
"quoteText": "Formula for success: under promise and over deliver.",
"quoteAuthor": "Tom Peters"
}, {
"quoteText": "Everything in life is luck.",
"quoteAuthor": "Donald Trump"
}, {
"quoteText": "The greatest part of our happiness depends on our dispositions, not our circumstances.",
"quoteAuthor": "Martha Washington"
}, {
"quoteText": "Neither genius, fame, nor love show the greatness of the soul. Only kindness can do that.",
"quoteAuthor": "Jean Lacordaire"
}, {
"quoteText": "Living at risk is jumping off the cliff and building your wings on the way down.",
"quoteAuthor": "Ray Bradbury"
}, {
"quoteText": "What matters is the value we've created in our lives, the people we've made happy and how much we've grown as people.",
"quoteAuthor": "Daisaku Ikeda"
}, {
"quoteText": "Our intention creates our reality.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "To be fully alive, fully human, and completely awake is to be continually thrown out of the nest.",
"quoteAuthor": "Pema Chodron"
}, {
"quoteText": "To free us from the expectations of others, to give us back to ourselves � there lies the great, singular power of self-respect.",
"quoteAuthor": "Joan Didion"
}, {
"quoteText": "Success means having the courage, the determination, and the will to become the person you believe you were meant to be.",
"quoteAuthor": "George Sheehan"
}, {
"quoteText": "Always be yourself, express yourself, have faith in yourself, do not go out and look for a successful personality and duplicate it.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "Iron rusts from disuse; water loses its purity from stagnation... even so does inaction sap the vigour of the mind.",
"quoteAuthor": "Leonardo da Vinci"
}, {
"quoteText": "A good rest is half the work.",
"quoteAuthor": ""
}, {
"quoteText": "You won't skid if you stay in a rut.",
"quoteAuthor": "Kin Hubbard"
}, {
"quoteText": "We must become the change we want to see.",
"quoteAuthor": "Mahatma Gandhi"
}, {
"quoteText": "A rolling stone gathers no moss.",
"quoteAuthor": "Publilius Syrus"
}, {
"quoteText": "Be not afraid of greatness: some are born great, some achieve greatness, and some have greatness thrust upon them.",
"quoteAuthor": "William Shakespeare"
}, {
"quoteText": "Change in all things is sweet.",
"quoteAuthor": "Aristotle"
}, {
"quoteText": "Fame usually comes to those who are thinking about something else.",
"quoteAuthor": "Holmes"
}, {
"quoteText": "Setting an example is not the main means of influencing another, it is the only means.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "There are two kinds of failures: those who thought and never did, and those who did and never thought.",
"quoteAuthor": "Laurence J. Peter"
}, {
"quoteText": "We know from science that nothing in the universe exists as an isolated or independent entity.",
"quoteAuthor": "Margaret Wheatley"
}, {
"quoteText": "There is only one happiness in life, to love and be loved.",
"quoteAuthor": "George Sand"
}, {
"quoteText": "He that respects himself is safe from others; he wears a coat of mail that none can pierce.",
"quoteAuthor": "Henry Longfellow"
}, {
"quoteText": "The most dangerous way to lose time is not to spend it having fun, but to spend it doing fake work. When you spend time having fun, you know you're being self-indulgent.",
"quoteAuthor": "Paul Graham"
}, {
"quoteText": "Worry often gives a small thing a big shadow.",
"quoteAuthor": "Swedish proverb"
}, {
"quoteText": "If you don't design your own life plan, chances are you'll fall into someone else's plan. And guess what they have planned for you? Not much.",
"quoteAuthor": "Jim Rohn"
}, {
"quoteText": "Of course there is no formula for success except perhaps an unconditional acceptance of life and what it brings.",
"quoteAuthor": "Arthur Rubinstein"
}, {
"quoteText": "It does not matter how slowly you go as long as you do not stop.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Nature is a mutable cloud which is always and never the same.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "We aim above the mark to hit the mark.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Our greatest glory is not in never failing but rising everytime we fall.",
"quoteAuthor": ""
}, {
"quoteText": "It all depends on how we look at things, and not how they are in themselves.",
"quoteAuthor": "Carl Jung"
}, {
"quoteText": "Be like the flower, turn your face to the sun.",
"quoteAuthor": "Kahlil Gibran"
}, {
"quoteText": "He who talks more is sooner exhausted.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Giving up doesn't always mean you are weak; sometimes it means that you are strong enough to let go.",
"quoteAuthor": ""
}, {
"quoteText": "To climb steep hills requires a slow pace at first.",
"quoteAuthor": "William Shakespeare"
}, {
"quoteText": "An idea that is developed and put into action is more important than an idea that exists only as an idea.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "No valid plans for the future can be made by those who have no capacity for living now.",
"quoteAuthor": "Alan Watts"
}, {
"quoteText": "There is nothing impossible to him who will try.",
"quoteAuthor": "Alexander the Great"
}, {
"quoteText": "It is not the possession of truth, but the success which attends the seeking after it, that enriches the seeker and brings happiness to him.",
"quoteAuthor": "Max Planck"
}, {
"quoteText": "Truth is generally the best vindication against slander.",
"quoteAuthor": "Abraham Lincoln"
}, {
"quoteText": "All achievements, all earned riches, have their beginning in an idea.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "To follow, without halt, one aim: There is the secret of success.",
"quoteAuthor": "Anna Pavlova"
}, {
"quoteText": "When the solution is simple, God is answering.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "Imagination is the highest kite one can fly.",
"quoteAuthor": "Lauren Bacall"
}, {
"quoteText": "The way we communicate with others and with ourselves ultimately determines the quality of our lives.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "If the single man plant himself indomitably on his instincts, and there abide, the huge world will come round to him.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "The universe is transformation; our life is what our thoughts make it.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "The greatest minds are capable of the greatest vices as well as of the greatest virtues.",
"quoteAuthor": "Rene Descartes"
}, {
"quoteText": "And as we let our own light shine, we unconsciously give other people permission to do the same.",
"quoteAuthor": "Nelson Mandela"
}, {
"quoteText": "Let go of your attachment to being right, and suddenly your mind is more open. You're able to benefit from the unique viewpoints of others, without being crippled by your own judgement.",
"quoteAuthor": "Ralph Marston"
}, {
"quoteText": "What is a weed? A plant whose virtues have not yet been discovered.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Learn wisdom from the ways of a seedling. A seedling which is never hardened off through stressful situations will never become a strong productive plant.",
"quoteAuthor": "Stephen Sigmund"
}, {
"quoteText": "Those who cannot learn from history are doomed to repeat it.",
"quoteAuthor": "George Santayan"
}, {
"quoteText": "Belief consists in accepting the affirmations of the soul; Unbelief, in denying them.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Living at risk is jumping off the cliff and building your wings on the way down.",
"quoteAuthor": "Ray Bradbury"
}, {
"quoteText": "Remember that sometimes not getting what you want is a wonderful stroke of luck.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Be less curious about people and more curious about ideas.",
"quoteAuthor": "Marie Curie"
}, {
"quoteText": "On every thorn, delightful wisdom grows, In every rill a sweet instruction flows.",
"quoteAuthor": "Edward Young"
}, {
"quoteText": "Many people have gone further than they thought they could because someone else thought they could.",
"quoteAuthor": ""
}, {
"quoteText": "To free us from the expectations of others, to give us back to ourselves � there lies the great, singular power of self-respect.",
"quoteAuthor": "Joan Didion"
}, {
"quoteText": "In rivers, the water that you touch is the last of what has passed and the first of that which comes; so with present time.",
"quoteAuthor": "Leonardo da Vinci"
}, {
"quoteText": "Speak when you are angry and you will make the best speech you will ever regret.",
"quoteAuthor": "Ambrose Bierce"
}, {
"quoteText": "No person is your friend who demands your silence, or denies your right to grow.",
"quoteAuthor": "Alice Walker"
}, {
"quoteText": "We choose our destiny in the way we treat others.",
"quoteAuthor": "Wit"
}, {
"quoteText": "We read the world wrong and say that it deceives us.",
"quoteAuthor": "Rabindranath Tagore"
}, {
"quoteText": "I have just three things to teach: simplicity, patience, compassion. These three are your greatest treasures.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "If only wed stop trying to be happy wed have a pretty good time.",
"quoteAuthor": "Edith Wharton"
}, {
"quoteText": "Don't cry because it's over. Smile because it happened.",
"quoteAuthor": "Dr. Seuss"
}, {
"quoteText": "You must do the things you think you cannot do.",
"quoteAuthor": "Eleanor Roosevelt"
}, {
"quoteText": "The path to success is to take massive, determined action.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "Judge nothing, you will be happy. Forgive everything, you will be happier. Love everything, you will be happiest.",
"quoteAuthor": "Sri Chinmoy"
}, {
"quoteText": "One may say the eternal mystery of the world is its comprehensibility.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "To be upset over what you don't have is to waste what you do have.",
"quoteAuthor": "Ken S. Keyes"
}, {
"quoteText": "Meaning is not what you start with but what you end up with.",
"quoteAuthor": "Peter Elbow"
}, {
"quoteText": "Sometimes your joy is the source of your smile, but sometimes your smile can be the source of your joy.",
"quoteAuthor": "Thich Nhat Hanh"
}, {
"quoteText": "Four steps to achievement: Plan purposefully. Prepare prayerfully. Proceed positively. Pursue persistently.",
"quoteAuthor": "William Arthur Ward"
}, {
"quoteText": "A true friend is the most precious of all possessions and the one we take the least thought about acquiring.",
"quoteAuthor": "Francois de La Rochefoucauld"
}, {
"quoteText": "Be yourself; everyone else is already taken.",
"quoteAuthor": "Oscar Wilde"
}, {
"quoteText": "Sometimes the most important thing in a whole day is the rest we take between two deep breaths.",
"quoteAuthor": "Etty Hillesum"
}, {
"quoteText": "The poor man is not he who is without a cent, but he who is without a dream.",
"quoteAuthor": "Harry Kemp"
}, {
"quoteText": "Loss is nothing else but change,and change is Natures delight.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "When deeds speak, words are nothing.",
"quoteAuthor": "African proverb"
}, {
"quoteText": "Every person, all the events of your life are there because you have drawn them there. What you choose to do with them is up to you.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "Successful people ask better questions, and as a result, they get better answers.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "Our greatest glory is not in never falling, but in rising every time we fall.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "People of mediocre ability sometimes achieve outstanding success because they don't know when to quit. Most men succeed because they are determined to.",
"quoteAuthor": "George Allen"
}, {
"quoteText": "A rolling stone gathers no moss.",
"quoteAuthor": "Publilius Syrus"
}, {
"quoteText": "All that is necessary is to accept the impossible, do without the indispensable, and bear the intolerable.",
"quoteAuthor": "Kathleen Norris"
}, {
"quoteText": "The mark of your ignorance is the depth of your belief in injustice and tragedy. What the caterpillar calls the end of the world, the Master calls the butterfly.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "There is nothing in a caterpillar that tells you it's going to be a butterfly.",
"quoteAuthor": "Buckminster Fuller"
}, {
"quoteText": "Things do not change; we change.",
"quoteAuthor": "Henry Thoreau"
}, {
"quoteText": "There is nothing in a caterpillar that tells you it's going to be a butterfly.",
"quoteAuthor": "Buckminster Fuller"
}, {
"quoteText": "Most of the shadows of life are caused by standing in our own sunshine.",
"quoteAuthor": "Ralph Waldo Emerson"
}, {
"quoteText": "Know, first, who you are, and then adorn yourself accordingly.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "You cannot have what you do not want.",
"quoteAuthor": "John Acosta"
}, {
"quoteText": "I cannot make my days longer so I strive to make them better.",
"quoteAuthor": "Henry David Thoreau"
}, {
"quoteText": "The greatest danger for most of us is not that our aim is too high and we miss it, but that it is too low and we reach it.",
"quoteAuthor": "Michelangelo"
}, {
"quoteText": "Thought is the blossom; language the bud; action the fruit behind it.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Life is not measured by the breaths you take, but by its breathtaking moments.",
"quoteAuthor": "Michael Vance"
}, {
"quoteText": "For everything that lives is holy, life delights in life.",
"quoteAuthor": "William Blake"
}, {
"quoteText": "Don't smother each other. No one can grow in the shade.",
"quoteAuthor": "Leo F. Buscaglia"
}, {
"quoteText": "I am glad that I paid so little attention to good advice; had I abided by it I might have been saved from some of my most valuable mistakes.",
"quoteAuthor": "Edna Millay"
}, {
"quoteText": "The bird of paradise alights only upon the hand that does not grasp.",
"quoteAuthor": "John Berry"
}, {
"quoteText": "To be upset over what you don't have is to waste what you do have.",
"quoteAuthor": "Ken S. Keyes"
}, {
"quoteText": "Nothing great was ever achieved without enthusiasm.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "A thing well said will be wit in all languages.",
"quoteAuthor": "John Dryden"
}, {
"quoteText": "Myths which are believed in tend to become true.",
"quoteAuthor": "George Orwell"
}, {
"quoteText": "Mediocrity knows nothing higher than itself, but talent instantly recognizes genius.",
"quoteAuthor": "Arthur Conan Doyle"
}, {
"quoteText": "Everyone thinks of changing the world, but no one thinks of changing himself.",
"quoteAuthor": "Leo Tolstoy"
}, {
"quoteText": "The greatest remedy for anger is delay.",
"quoteAuthor": "Seneca"
}, {
"quoteText": "One who asks a question is a fool for five minutes; one who does not ask a question remains a fool forever.",
"quoteAuthor": ""
}, {
"quoteText": "Those who are free of resentful thoughts surely find peace.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Great acts are made up of small deeds.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "All the world is a stage, And all the men and women merely players.They have their exits and entrances; Each man in his time plays many parts.",
"quoteAuthor": "William Shakespeare"
}, {
"quoteText": "I gave my life to become the person I am right now. Was it worth it?",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "For every failure, there's an alternative course of action. You just have to find it. When you come to a roadblock, take a detour.",
"quoteAuthor": "Mary Kay Ash"
}, {
"quoteText": "To study and not think is a waste. To think and not study is dangerous.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "The possession of knowledge does not kill the sense of wonder and mystery. There is always more mystery.",
"quoteAuthor": "Anais Nin"
}, {
"quoteText": "Most folks are as happy as they make up their minds to be.",
"quoteAuthor": "Abraham Lincoln"
}, {
"quoteText": "What you see depends on what you're looking for.",
"quoteAuthor": ""
}, {
"quoteText": "If you spend too much time thinking about a thing, you'll never get it done.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "An optimist is a person who sees a green light everywhere, while the pessimist sees only the red spotlight... The truly wise person is colour-blind.",
"quoteAuthor": "Albert Schweitzer"
}, {
"quoteText": "Things turn out best for those who make the best of the way things turn out.",
"quoteAuthor": "Jack Buck"
}, {
"quoteText": "If it is not right do not do it; if it is not true do not say it.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "To be beautiful means to be yourself. You don�t need to be accepted by others. You need to accept yourself.",
"quoteAuthor": "Thich Nhat Hanh"
}, {
"quoteText": "Love is the master key that opens the gates of happiness.",
"quoteAuthor": "Oliver Holmes"
}, {
"quoteText": "Our greatness lies not so much in being able to remake the world as being able to remake ourselves.",
"quoteAuthor": "Mahatma Gandhi"
}, {
"quoteText": "What we achieve inwardly will change outer reality.",
"quoteAuthor": "Plutarch"
}, {
"quoteText": "The most decisive actions of our life... are most often unconsidered actions.",
"quoteAuthor": "Andr� Gide"
}, {
"quoteText": "If I know what love is, it is because of you.",
"quoteAuthor": "Hermann Hesse"
}, {
"quoteText": "Your outlook on life is a direct reflection on how much you like yourself.",
"quoteAuthor": "Lululemon"
}, {
"quoteText": "Nothing is softer or more flexible than water, yet nothing can resist it.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "A subtle thought that is in error may yet give rise to fruitful inquiry that can establish truths of great value.",
"quoteAuthor": "Isaac Asimov"
}, {
"quoteText": "I believe that we are solely responsible for our choices, and we have to accept the consequences of every deed, word, and thought throughout our lifetime.",
"quoteAuthor": "Elisabeth Kubler-Ross"
}, {
"quoteText": "The person who makes a success of living is the one who see his goal steadily and aims for it unswervingly. That is dedication.",
"quoteAuthor": "Cecil B. DeMille"
}, {
"quoteText": "Tension is who you think you should be. Relaxation is who you are.",
"quoteAuthor": "Chinese proverb"
}, {
"quoteText": "Friends are those rare people who ask how we are and then wait to hear the answer.",
"quoteAuthor": "Ed Cunningham"
}, {
"quoteText": "Wishes can be your best avenue of getting what you want when you turn wishes into action. Action moves your wish to the forefront from thought to reality.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "My reputation grows with every failure.",
"quoteAuthor": "George Shaw"
}, {
"quoteText": "We know what we are, but know not what we may be.",
"quoteAuthor": "William Shakespeare"
}, {
"quoteText": "Time is the wisest counsellor of all.",
"quoteAuthor": "Pericles"
}, {
"quoteText": "The greatest good you can do for another is not just to share your riches but to reveal to him his own.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "Good thoughts are no better than good dreams, unless they be executed.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Trust only movement. Life happens at the level of events, not of words. Trust movement.",
"quoteAuthor": "Alfred Adler"
}, {
"quoteText": "Success is getting what you want. Happiness is wanting what you get.",
"quoteAuthor": "Dale Carnegie"
}, {
"quoteText": "Never be afraid to try, remember... Amateurs built the ark, Professionals built the Titanic.",
"quoteAuthor": ""
}, {
"quoteText": "We are the leaves of one branch, the drops of one sea, the flowers of one garden.",
"quoteAuthor": "Jean Lacordaire"
}, {
"quoteText": "The only real failure in life is not to be true to the best one knows.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Happiness does not come about only due to external circumstances; it mainly derives from inner attitudes.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Skill to do comes of doing.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "As we risk ourselves, we grow. Each new experience is a risk.",
"quoteAuthor": "Fran Watson"
}, {
"quoteText": "Be slow of tongue and quick of eye.",
"quoteAuthor": "Cervantes"
}, {
"quoteText": "I always wanted to be somebody, but I should have been more specific.",
"quoteAuthor": "Lily Tomlin"
}, {
"quoteText": "However many holy words you read, however many you speak, what good will they do you if you do not act on upon them?",
"quoteAuthor": "Buddha"
}, {
"quoteText": "The greatest barrier to success is the fear of failure.",
"quoteAuthor": "Eriksson"
}, {
"quoteText": "For success, attitude is equally as important as ability.",
"quoteAuthor": "Harry Banks"
}, {
"quoteText": "If you take each challenge one step at a time, with faith in every footstep, your strength and understanding will increase.",
"quoteAuthor": "James Faust"
}, {
"quoteText": "If you correct your mind, the rest of your life will fall into place.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "A life spent making mistakes is not only more honourable, but more useful than a life spent doing nothing.",
"quoteAuthor": "George Bernard Shaw"
}, {
"quoteText": "Every person, all the events of your life are there because you have drawn them there. What you choose to do with them is up to you.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "There is nothing in a caterpillar that tells you it's going to be a butterfly.",
"quoteAuthor": "Buckminster Fuller"
}, {
"quoteText": "Your work is to discover your work and then with all your heart to give yourself to it.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Man is not sum of what he has already, but rather the sum of what he does not yet have, of what he could have.",
"quoteAuthor": "Jean-Paul Sartre"
}, {
"quoteText": "Imagination is more important than knowledge. For while knowledge defines all we currently know and understand, imagination points to all we might yet discover and create.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "If you don't design your own life plan, chances are you'll fall into someone else's plan. And guess what they have planned for you? Not much.",
"quoteAuthor": "Jim Rohn"
}, {
"quoteText": "Knowledge rests not upon truth alone, but upon error also.",
"quoteAuthor": "Carl Jung"
}, {
"quoteText": "Why worry about things you can�t control when you can keep yourself busy controlling the things that depend on you?",
"quoteAuthor": ""
}, {
"quoteText": "The best and most beautiful things in the world cannot be seen, nor touched... but are felt in the heart.",
"quoteAuthor": "Helen Keller"
}, {
"quoteText": "If you spend your whole life waiting for the storm, you'll never enjoy the sunshine.",
"quoteAuthor": "Morris West"
}, {
"quoteText": "If you are going to achieve excellence in big things, you develop the habit in little matters. Excellence is not an exception, it is a prevailing attitude.",
"quoteAuthor": "Colin Powell"
}, {
"quoteText": "You can observe a lot just by watching.",
"quoteAuthor": "Yogi Berra"
}, {
"quoteText": "Failure will never overtake me if my determination to succeed is strong enough.",
"quoteAuthor": "Og Mandino"
}, {
"quoteText": "The man who trusts men will make fewer mistakes than he who distrusts them.",
"quoteAuthor": "Cavour"
}, {
"quoteText": "To get something you never had, you have to do something you never did.",
"quoteAuthor": ""
}, {
"quoteText": "A person who never made a mistake never tried anything new.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "Your work is to discover your world and then with all your heart give yourself to it.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "The past has no power to stop you from being present now. Only your grievance about the past can do that.",
"quoteAuthor": "Eckhart Tolle"
}, {
"quoteText": "Better than a thousand hollow words is one word that brings peace.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Everything that irritates us about others can lead us to an understanding of ourselves.",
"quoteAuthor": "Carl Jung"
}, {
"quoteText": "Never be afraid to try, remember... Amateurs built the ark, Professionals built the Titanic.",
"quoteAuthor": ""
}, {
"quoteText": "You, yourself, as much as anybody in the entire universe, deserve your love and affection.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "The possibilities are numerous once we decide to act and not react.",
"quoteAuthor": "George Bernard Shaw"
}, {
"quoteText": "The spirit, the will to win, and the will to excel, are the things that endure. These qualities are so much more important than the events that occur.",
"quoteAuthor": "Vincent Lombardi"
}, {
"quoteText": "When fate hands us a lemon, lets try to make lemonade.",
"quoteAuthor": "Dale Carnegie"
}, {
"quoteText": "We can only learn to love by loving.",
"quoteAuthor": "Iris Murdoch"
}, {
"quoteText": "Remember always that you not only have the right to be an individual, you have an obligation to be one.",
"quoteAuthor": "Eleanor Roosevelt"
}, {
"quoteText": "Fine words and an insinuating appearance are seldom associated with true virtue",
"quoteAuthor": "Confucius"
}, {
"quoteText": "He who obtains has little. He who scatters has much.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Self-trust is the first secret of success.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "In the depth of winter, I finally learned that there was within me an invincible summer.",
"quoteAuthor": "Albert Camus"
}, {
"quoteText": "Through perseverance many people win success out of what seemed destined to be certain failure.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "To be wrong is nothing unless you continue to remember it.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Don't compromise yourself. You are all you've got.",
"quoteAuthor": "Janis Joplin"
}, {
"quoteText": "Never ignore a gut feeling, but never believe that it's enough.",
"quoteAuthor": "Robert Heller"
}, {
"quoteText": "Well done is better than well said.",
"quoteAuthor": "Benjamin Franklin"
}, {
"quoteText": "The greatest danger for most of us is not that our aim is too high and we miss it, but that it is too low and we reach it.",
"quoteAuthor": "Michelangelo"
}, {
"quoteText": "Almost everything comes from nothing.",
"quoteAuthor": "Henri Amiel"
}, {
"quoteText": "It isn't where you come from, it's where you're going that counts.",
"quoteAuthor": "Ella Fitzgerald"
}, {
"quoteText": "He who is contented is rich.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Where all think alike, no one thinks very much.",
"quoteAuthor": "Walter Lippmann"
}, {
"quoteText": "The world is round and the place which may seem like the end may also be the beginning.",
"quoteAuthor": "Ivy Baker Priest"
}, {
"quoteText": "I never think of the future. It comes soon enough.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "Sometimes by losing a battle you find a new way to win the war.",
"quoteAuthor": "Donald Trump"
}, {
"quoteText": "Human beings, who are almost unique in having the ability to learn from the experience of others, are also remarkable for their apparent disinclination to do so.",
"quoteAuthor": "Douglas Adams"
}, {
"quoteText": "People of mediocre ability sometimes achieve outstanding success because they don't know when to quit. Most men succeed because they are determined to.",
"quoteAuthor": "George Allen"
}, {
"quoteText": "Listen to what you know instead of what you fear.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "There are things so deep and complex that only intuition can reach it in our stage of development as human beings.",
"quoteAuthor": "John Astin"
}, {
"quoteText": "One secret of success in life is for a man to be ready for his opportunity when it comes.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "You cannot step twice into the same river, for other waters are continually flowing in.",
"quoteAuthor": "Heraclitus"
}, {
"quoteText": "Ideals are an imaginative understanding of that which is desirable in that which is possible.",
"quoteAuthor": "Walter Lippmann"
}, {
"quoteText": "It is easier to live through someone else than to become complete yourself.",
"quoteAuthor": "Betty Friedan"
}, {
"quoteText": "When you doubt your power, you give power to your doubt.",
"quoteAuthor": "Honore de Balzac"
}, {
"quoteText": "It's important to know that words don't move mountains. Work, exacting work moves mountains.",
"quoteAuthor": "Danilo Dolci"
}, {
"quoteText": "When your desires are strong enough you will appear to possess superhuman powers to achieve.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "If you're in a bad situation, don't worry it'll change. If you're in a good situation, don't worry it'll change.",
"quoteAuthor": "John Simone"
}, {
"quoteText": "You can be what you want to be. You have the power within and we will help you always.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "The happy and efficient people in this world are those who accept trouble as a normal detail of human life and resolve to capitalize it when it comes along.",
"quoteAuthor": "H. Bertram Lewis"
}, {
"quoteText": "The possession of knowledge does not kill the sense of wonder and mystery. There is always more mystery.",
"quoteAuthor": "Anais Nin"
}, {
"quoteText": "The greatest obstacle to connecting with our joy is resentment.",
"quoteAuthor": "Pema Chodron"
}, {
"quoteText": "Remember that failure is an event, not a person.",
"quoteAuthor": "Zig Ziglar"
}, {
"quoteText": "Why worry about tomorrow, when today is all we have?",
"quoteAuthor": ""
}, {
"quoteText": "There is no need for temples, no need for complicated philosophies. My brain and my heart are my temples; my philosophy is kindness.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "From little acorns mighty oaks do grow.",
"quoteAuthor": "American proverb"
}, {
"quoteText": "You might well remember that nothing can bring you success but yourself.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Don't settle for a relationship that won't let you be yourself.",
"quoteAuthor": "Oprah Winfrey"
}, {
"quoteText": "Wherever a man turns he can find someone who needs him.",
"quoteAuthor": "Albert Schweitzer"
}, {
"quoteText": "Not what we have but what we enjoy constitutes our abundance.",
"quoteAuthor": "John Petit-Senn"
}, {
"quoteText": "As you think, so shall you become.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "God has given you one face, and you make yourself another.",
"quoteAuthor": "William Shakespeare"
}, {
"quoteText": "Bite off more than you can chew, then chew it.",
"quoteAuthor": "Ella Williams"
}, {
"quoteText": "The way we communicate with others and with ourselves ultimately determines the quality of our lives.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "The only limit to your impact is your imagination and commitment.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "Nothing diminishes anxiety faster than action.",
"quoteAuthor": "Walter Anderson"
}, {
"quoteText": "What the caterpillar calls the end of the world, the master calls a butterfly.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "Instead of saying that man is the creature of circumstance, it would be nearer the mark to say that man is the architect of circumstance.",
"quoteAuthor": "Thomas Carlyle"
}, {
"quoteText": "A little knowledge that acts is worth infinitely more than much knowledge that is idle.",
"quoteAuthor": "Kahlil Gibran"
}, {
"quoteText": "A smile is a light in the window of your face to show your heart is at home.",
"quoteAuthor": ""
}, {
"quoteText": "You might well remember that nothing can bring you success but yourself.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "If you do what you've always done, you'll get what youve always gotten.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "To dare is to lose ones footing momentarily. To not dare is to lose oneself.",
"quoteAuthor": "Soren Kierkegaard"
}, {
"quoteText": "Memory is the mother of all wisdom.",
"quoteAuthor": "Samuel Johnson"
}, {
"quoteText": "Make the best use of what is in your power, and take the rest as it happens.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "Freedom is what you do with what's been done to you.",
"quoteAuthor": "Jean-Paul Sartre"
}, {
"quoteText": "Do not wait for leaders; do it alone, person to person.",
"quoteAuthor": "Mother Teresa"
}, {
"quoteText": "Knowledge has three degrees � opinion, science, illumination. The means or instrument of the first is sense; of the second, dialectic; of the third, intuition.",
"quoteAuthor": "Plotinus"
}, {
"quoteText": "I find hope in the darkest of days, and focus in the brightest. I do not judge the universe.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Mind is everything: muscle, pieces of rubber. All that I am, I am because of my mind.",
"quoteAuthor": "Paavo Nurmi"
}, {
"quoteText": "Never ignore a gut feeling, but never believe that it's enough.",
"quoteAuthor": "Robert Heller"
}, {
"quoteText": "The price of greatness is responsibility.",
"quoteAuthor": "Winston Churchill"
}, {
"quoteText": "You don't drown by falling in water. You drown by staying there.",
"quoteAuthor": ""
}, {
"quoteText": "Obstacles are those things you see when you take your eyes off the goal.",
"quoteAuthor": "Hannah More"
}, {
"quoteText": "Every great dream begins with a dreamer. Always remember, you have within you the strength, the patience, and the passion to reach for the stars to change the world.",
"quoteAuthor": "Harriet Tubman"
}, {
"quoteText": "Don't talk about what you have done or what you are going to do.",
"quoteAuthor": "Thomas Jefferson"
}, {
"quoteText": "Everything in life is luck.",
"quoteAuthor": "Donald Trump"
}, {
"quoteText": "Love vanquishes time. To lovers, a moment can be eternity, eternity can be the tick of a clock.",
"quoteAuthor": "Mary Parrish"
}, {
"quoteText": "Letting go isn�t the end of the world; it�s the beginning of a new life.",
"quoteAuthor": ""
}, {
"quoteText": "Science is organized knowledge. Wisdom is organized life.",
"quoteAuthor": "Immanuel Kant"
}, {
"quoteText": "I'm not afraid of storms, for Im learning how to sail my ship.",
"quoteAuthor": "Louisa Alcott"
}, {
"quoteText": "A little knowledge that acts is worth infinitely more than much knowledge that is idle.",
"quoteAuthor": "Kahlil Gibran"
}, {
"quoteText": "Don't judge each day by the harvest you reap but by the seeds that you plant.",
"quoteAuthor": "Robert Stevenson"
}, {
"quoteText": "It is fatal to enter any war without the will to win it.",
"quoteAuthor": "General Douglas MacArthur"
}, {
"quoteText": "Life is just a chance to grow a soul.",
"quoteAuthor": "A. Powell Davies"
}, {
"quoteText": "Make it a rule of life never to regret and never to look back. Regret is an appalling waste of energy; you can't build on it; it's only for wallowing in.",
"quoteAuthor": "Katherine Mansfield"
}, {
"quoteText": "You can observe a lot just by watching.",
"quoteAuthor": "Yogi Berra"
}, {
"quoteText": "We never live; we are always in the expectation of living.",
"quoteAuthor": "Voltaire"
}, {
"quoteText": "Think like a man of action; act like a man of thought.",
"quoteAuthor": "Henri L. Bergson"
}, {
"quoteText": "The beginning is always today.",
"quoteAuthor": "Mary Wollstonecraft"
}, {
"quoteText": "The universe is transformation; our life is what our thoughts make it.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "You can complain because roses have thorns, or you can rejoice because thorns have roses.",
"quoteAuthor": "Ziggy"
}, {
"quoteText": "Patience is a virtue but you will never ever accomplish anything if you don't exercise action over patience.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "There is not one big cosmic meaning for all, there is only the meaning we each give to our life.",
"quoteAuthor": "Anais Nin"
}, {
"quoteText": "Well done is better than well said.",
"quoteAuthor": "Benjamin Franklin"
}, {
"quoteText": "I always wanted to be somebody, but I should have been more specific.",
"quoteAuthor": "Lily Tomlin"
}, {
"quoteText": "Always do your best. What you plant now, you will harvest later.",
"quoteAuthor": "Og Mandino"
}, {
"quoteText": "Without leaps of imagination, or dreaming, we lose the excitement of possibilities. Dreaming, after all, is a form of planning.",
"quoteAuthor": "Gloria Steinem"
}, {
"quoteText": "A leader is best when people barely know he exists, when his work is done, his aim fulfilled, they will say: we did it ourselves.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "If it is not right do not do it; if it is not true do not say it.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "Every great mistake has a halfway moment, a split second when it can be recalled and perhaps remedied.",
"quoteAuthor": "Pearl Buck"
}, {
"quoteText": "Kindness is more important than wisdom, and the recognition of this is the beginning of wisdom.",
"quoteAuthor": "Theodore Rubin"
}, {
"quoteText": "There are only two ways to live your life. One is as though nothing is a miracle. The other is as though everything is a miracle.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "Time you enjoyed wasting was not wasted.",
"quoteAuthor": "John Lennon"
}, {
"quoteText": "You will never be happy if you continue to search for what happiness consists of. You will never live if you are looking for the meaning of life.",
"quoteAuthor": "Albert Camus"
}, {
"quoteText": "Genuine sincerity opens people's hearts, while manipulation causes them to close.",
"quoteAuthor": "Daisaku Ikeda"
}, {
"quoteText": "Intuition is the supra-logic that cuts out all the routine processes of thought and leaps straight from the problem to the answer.",
"quoteAuthor": "Robert Graves"
}, {
"quoteText": "Something opens our wings. Something makes boredom and hurt disappear. Someone fills the cup in front of us: We taste only sacredness.",
"quoteAuthor": "Rumi"
}, {
"quoteText": "Your big opportunity may be right where you are now.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Do something wonderful, people may imitate it.",
"quoteAuthor": "Albert Schweitzer"
}, {
"quoteText": "To give ones self earnestly to the duties due to men, and, while respecting spiritual beings, to keep aloof from them, may be called wisdom.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "A man's dreams are an index to his greatness.",
"quoteAuthor": "Zadok Rabinowitz"
}, {
"quoteText": "Everyone smiles in the same language.",
"quoteAuthor": ""
}, {
"quoteText": "There is no way to happiness, happiness is the way.",
"quoteAuthor": "Thich Nhat Hanh"
}, {
"quoteText": "We do not quit playing because we grow old, we grow old because we quit playing.",
"quoteAuthor": "Oliver Holmes"
}, {
"quoteText": "You're not obligated to win. You're obligated to keep trying to do the best you can every day.",
"quoteAuthor": "Marian Edelman"
}, {
"quoteText": "Your body is precious. It is our vehicle for awakening. Treat it with care.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Conflict is the gadfly of thought. It stirs us to observation and memory. It instigates to invention. It shocks us out of sheeplike passivity, and sets us at noting and contriving.",
"quoteAuthor": "John Dewey"
}, {
"quoteText": "What you do not want done to yourself, do not do to others.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "How many cares one loses when one decides not to be something but to be someone.",
"quoteAuthor": "Coco Chanel"
}, {
"quoteText": "In a controversy the instant we feel anger we have already ceased striving for the truth, and have begun striving for ourselves.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Why worry about things you can�t control when you can keep yourself busy controlling the things that depend on you?",
"quoteAuthor": ""
}, {
"quoteText": "Why worry about tomorrow, when today is all we have?",
"quoteAuthor": ""
}, {
"quoteText": "Know, first, who you are, and then adorn yourself accordingly.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "Try and fail, but don't fail to try.",
"quoteAuthor": "Stephen Kaggwa"
}, {
"quoteText": "The first duty of a human being is to assume the right functional relationship to society � more briefly, to find your real job, and do it.",
"quoteAuthor": "Charlotte Perkins Gilman"
}, {
"quoteText": "Your big opportunity may be right where you are now.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Be miserable. Or motivate yourself. Whatever has to be done, it's always your choice.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "I believe that we are fundamentally the same and have the same basic potential.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Transformation does not start with some one else changing you; transformation is an inner self reworking of what you are now to what you will be.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Intuition will tell the thinking mind where to look next.",
"quoteAuthor": "Jonas Salk"
}, {
"quoteText": "Our intention creates our reality.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Good timber does not grow with ease; the stronger the wind, the stronger the trees.",
"quoteAuthor": "J. Willard Marriott"
}, {
"quoteText": "Something opens our wings. Something makes boredom and hurt disappear. Someone fills the cup in front of us: We taste only sacredness.",
"quoteAuthor": "Rumi"
}, {
"quoteText": "When you are content to be simply yourself and don't compare or compete, everybody will respect you.",
"quoteAuthor": "Laozi"
}, {
"quoteText": "Strong beliefs win strong men, and then make them stronger.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "The smallest act of kindness is worth more than the grandest intention.",
"quoteAuthor": "Oscar Wilde"
}, {
"quoteText": "If you'll not settle for anything less than your best, you will be amazed at what you can accomplish in your lives.",
"quoteAuthor": "Vince Lombardi"
}, {
"quoteText": "Only through our connectedness to others can we really know and enhance the self. And only through working on the self can we begin to enhance our connectedness to others.",
"quoteAuthor": "Harriet Lerner"
}, {
"quoteText": "Man is equally incapable of seeing the nothingness from which he emerges and the infinity in which he is engulfed.",
"quoteAuthor": "Blaise Pascal"
}, {
"quoteText": "Be thankful when you don't know something for it gives you the opportunity to learn.",
"quoteAuthor": ""
}, {
"quoteText": "Ignorance never settle a question.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "This is the final test of a gentleman: his respect for those who can be of no possible value to him.",
"quoteAuthor": "William Lyon Phelps"
}, {
"quoteText": "Set your goals high, and don't stop till you get there.",
"quoteAuthor": "Bo Jackson"
}, {
"quoteText": "Whoever is happy will make others happy, too.",
"quoteAuthor": "Mark Twain"
}, {
"quoteText": "I would maintain that thanks are the highest form of thought, and that gratitude is happiness doubled by wonder.",
"quoteAuthor": "G. K. Chesterton"
}, {
"quoteText": "No pessimist ever discovered the secrets of the stars, or sailed to an uncharted land, or opened a new heaven to the human spirit.",
"quoteAuthor": "Helen Keller"
}, {
"quoteText": "To follow, without halt, one aim: There is the secret of success.",
"quoteAuthor": "Anna Pavlova"
}, {
"quoteText": "A stumble may prevent a fall.",
"quoteAuthor": ""
}, {
"quoteText": "The years teach much which the days never know.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "God has given you one face, and you make yourself another.",
"quoteAuthor": "William Shakespeare"
}, {
"quoteText": "You teach best what you most need to learn.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "A subtle thought that is in error may yet give rise to fruitful inquiry that can establish truths of great value.",
"quoteAuthor": "Isaac Asimov"
}, {
"quoteText": "Compassion and happiness are not a sign of weakness but a sign of strength.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "When you realize how perfect everything is you will tilt your head back and laugh at the sky.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Watch the little things; a small leak will sink a great ship.",
"quoteAuthor": "Benjamin Franklin"
}, {
"quoteText": "Continuous effort�not strength or intelligence�is the key to unlocking our potential.",
"quoteAuthor": "Winston Churchill"
}, {
"quoteText": "We must learn our limits. We are all something, but none of us are everything.",
"quoteAuthor": "Blaise Pascal"
}, {
"quoteText": "Obstacles are those frightful things you see when you take your eyes off your goal.",
"quoteAuthor": "Henry Ford"
}, {
"quoteText": "Appreciation can make a day, even change a life. Your willingness to put it into words is all that is necessary.",
"quoteAuthor": "Margaret Cousins"
}, {
"quoteText": "Be yourself; everyone else is already taken.",
"quoteAuthor": "Oscar Wilde"
}, {
"quoteText": "Kindness is the language which the deaf can hear and the blind can see.",
"quoteAuthor": "Mark Twain"
}, {
"quoteText": "To be tested is good. The challenged life may be the best therapist.",
"quoteAuthor": "Gail Sheehy"
}, {
"quoteText": "To ensure good health: eat lightly, breathe deeply, live moderately, cultivate cheerfulness, and maintain an interest in life.",
"quoteAuthor": "William Londen"
}, {
"quoteText": "Sooner or later, those who win are those who think they can.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "Happiness is not in the mere possession of money; it lies in the joy of achievement, in the thrill of creative effort.",
"quoteAuthor": "Franklin Roosevelt"
}, {
"quoteText": "Fortune favours the brave.",
"quoteAuthor": "Virgil"
}, {
"quoteText": "The heart has its reasons which reason knows not of.",
"quoteAuthor": "Blaise Pascal"
}, {
"quoteText": "Go for it now. The future is promised to no one.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "When you doubt your power, you give power to your doubt.",
"quoteAuthor": "Honore de Balzac"
}, {
"quoteText": "Never tell a young person that anything cannot be done. God may have been waiting centuries for someone ignorant enough of the impossible to do that very thing.",
"quoteAuthor": "John Holmes"
}, {
"quoteText": "Every action of our lives touches on some chord that will vibrate in eternity.",
"quoteAuthor": "Edwin Chapin"
}, {
"quoteText": "You can adopt the attitude there is nothing you can do, or you can see the challenge as your call to action.",
"quoteAuthor": "Catherine Pulsifer"
}, {
"quoteText": "Don't let what you can't do stop you from doing what you can do.",
"quoteAuthor": ""
}, {
"quoteText": "Wisdom is the reward you get for a lifetime of listening when you'd have preferred to talk.",
"quoteAuthor": "Doug Larson"
}, {
"quoteText": "Just as a candle cannot burn without fire, men cannot live without a spiritual life.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "We come to love not by finding a perfect person, but by learning to see an imperfect person perfectly.",
"quoteAuthor": "Sam Keen"
}, {
"quoteText": "Being right is highly overrated. Even a stopped clock is right twice a day.",
"quoteAuthor": ""
}, {
"quoteText": "To ensure good health: eat lightly, breathe deeply, live moderately, cultivate cheerfulness, and maintain an interest in life.",
"quoteAuthor": "William Londen"
}, {
"quoteText": "It is one of the blessings of old friends that you can afford to be stupid with them.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "In a controversy the instant we feel anger we have already ceased striving for the truth, and have begun striving for ourselves.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Promises are the uniquely human way of ordering the future, making it predictable and reliable to the extent that this is humanly possible.",
"quoteAuthor": "Hannah Arendt"
}, {
"quoteText": "Our passion is our strength.",
"quoteAuthor": "Billie Armstrong"
}, {
"quoteText": "Learning is a treasure that will follow its owner everywhere",
"quoteAuthor": "Chinese proverb"
}, {
"quoteText": "The best way to pay for a lovely moment is to enjoy it.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "Loss is nothing else but change,and change is Natures delight.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "Maxim for life: You get treated in life the way you teach people to treat you.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Whatever happens, take responsibility.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "The only way to tell the truth is to speak with kindness. Only the words of a loving man can be heard.",
"quoteAuthor": "Henry Thoreau"
}, {
"quoteText": "Don't turn away from possible futures before you're certain you don't have anything to learn from them.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "Focusing your life solely on making a buck shows a poverty of ambition. It asks too little of yourself. And it will leave you unfulfilled.",
"quoteAuthor": "Barack Obama"
}, {
"quoteText": "A single conversation across the table with a wise person is worth a months study of books.",
"quoteAuthor": "Chinese proverb"
}, {
"quoteText": "We must not say every mistake is a foolish one.",
"quoteAuthor": "Cicero"
}, {
"quoteText": "There are only two ways to live your life. One is as though nothing is a miracle. The other is as though everything is a miracle.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "With every experience, you alone are painting your own canvas, thought by thought, choice by choice.",
"quoteAuthor": "Oprah Winfrey"
}, {
"quoteText": "The day always looks brighter from behind a smile.",
"quoteAuthor": ""
}, {
"quoteText": "Allow the world to live as it chooses, and allow yourself to live as you choose.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "Bold is not the act of foolishness but the attribute and inner strength to act when others will not so as to move forward not backward.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "From small beginnings come great things.",
"quoteAuthor": ""
}, {
"quoteText": "One secret of success in life is for a man to be ready for his opportunity when it comes.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "If we look at the world with a love of life, the world will reveal its beauty to us.",
"quoteAuthor": "Daisaku Ikeda"
}, {
"quoteText": "Open minds lead to open doors.",
"quoteAuthor": ""
}, {
"quoteText": "The most important point is to accept yourself and stand on your two feet.",
"quoteAuthor": "Shunryu Suzuki"
}, {
"quoteText": "In skating over thin ice our safety is in our speed.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "The self is not something ready-made, but something in continuous formation through choice of action.",
"quoteAuthor": "John Dewey"
}, {
"quoteText": "When you discover your mission, you will feel its demand. It will fill you with enthusiasm and a burning desire to get to work on it.",
"quoteAuthor": "W. Clement Stone"
}, {
"quoteText": "Happiness is the reward we get for living to the highest right we know.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "To want to be what one can be is purpose in life.",
"quoteAuthor": "Cynthia Ozick"
}, {
"quoteText": "Yesterday is history. Tomorrow is a mystery. And today? Today is a gift that's why they call it the present.",
"quoteAuthor": ""
}, {
"quoteText": "Creativity comes from trust. Trust your instincts. And never hope more than you work.",
"quoteAuthor": "Rita Mae Brown"
}, {
"quoteText": "Prejudice is a burden that confuses the past, threatens the future and renders the present inaccessible.",
"quoteAuthor": "Maya Angelou"
}, {
"quoteText": "Whatever we expect with confidence becomes our own self-fulfilling prophecy.",
"quoteAuthor": "Brian Tracy"
}, {
"quoteText": "When you dance, your purpose is not to get to a certain place on the floor. It's to enjoy each step along the way.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Be faithful in small things because it is in them that your strength lies.",
"quoteAuthor": "Mother Teresa"
}, {
"quoteText": "Never deny a diagnosis, but do deny the negative verdict that may go with it.",
"quoteAuthor": "Norman Cousins"
}, {
"quoteText": "The grand essentials of happiness are: something to do, something to love, and something to hope for.",
"quoteAuthor": "Chalmers"
}, {
"quoteText": "Wisdom is knowing what to do next; Skill is knowing how ot do it, and Virtue is doing it.",
"quoteAuthor": "David Jordan"
}, {
"quoteText": "Never promise more than you can perform.",
"quoteAuthor": "Publilius Syrus"
}, {
"quoteText": "No pessimist ever discovered the secrets of the stars, or sailed to an uncharted land, or opened a new heaven to the human spirit.",
"quoteAuthor": "Helen Keller"
}, {
"quoteText": "You were not born a winner, and you were not born a loser. You are what you make yourself be.",
"quoteAuthor": "Lou Holtz"
}, {
"quoteText": "The greatest remedy for anger is delay.",
"quoteAuthor": "Seneca"
}, {
"quoteText": "He who fears being conquered is sure of defeat.",
"quoteAuthor": "Napoleon Bonaparte"
}, {
"quoteText": "Belief consists in accepting the affirmations of the soul; Unbelief, in denying them.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Everyone is a genius at least once a year. A real genius has his original ideas closer together.",
"quoteAuthor": "Georg Lichtenberg"
}, {
"quoteText": "If you don't go after what you want, you'll never have it. If you don't ask, the answer is always no. If you don't step forward, you're always in the same place.",
"quoteAuthor": "Nora Roberts"
}, {
"quoteText": "It is more important to know where you are going than to get there quickly. Do not mistake activity for achievement.",
"quoteAuthor": "Mabel Newcomber"
}, {
"quoteText": "Do not turn back when you are just at the goal.",
"quoteAuthor": "Publilius Syrus"
}, {
"quoteText": "A single conversation across the table with a wise person is worth a months study of books.",
"quoteAuthor": "Chinese proverb"
}, {
"quoteText": "When in doubt, tell the truth.",
"quoteAuthor": "Mark Twain"
}, {
"quoteText": "Every problem has a gift for you in its hands.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "As you think, so shall you become.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "The cautious seldom err.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Be less curious about people and more curious about ideas.",
"quoteAuthor": "Marie Curie"
}, {
"quoteText": "As you think, so shall you become.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "The future belongs to those who believe in the beauty of their dreams.",
"quoteAuthor": "Eleanor Roosevelt"
}, {
"quoteText": "I can't believe that God put us on this earth to be ordinary.",
"quoteAuthor": "Lou Holtz"
}, {
"quoteText": "There are no limitations to the mind except those we acknowledge.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "You won't skid if you stay in a rut.",
"quoteAuthor": "Kin Hubbard"
}, {
"quoteText": "The universe is full of magical things, patiently waiting for our wits to grow sharper.",
"quoteAuthor": "Eden Phillpotts"
}, {
"quoteText": "Ignorance never settle a question.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "To fly, we have to have resistance.",
"quoteAuthor": "Maya Lin"
}, {
"quoteText": "Notice that the stiffest tree is most easily cracked, while the bamboo or willow survives by bending with the wind.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "Things do not change; we change.",
"quoteAuthor": "Henry Thoreau"
}, {
"quoteText": "We never understand how little we need in this world until we know the loss of it.",
"quoteAuthor": "James Barrie"
}, {
"quoteText": "He who angers you conquers you.",
"quoteAuthor": "Elizabeth Kenny"
}, {
"quoteText": "Yesterday is history. Tomorrow is a mystery. And today? Today is a gift. That is why we call it the present.",
"quoteAuthor": "Babatunde Olatunji"
}, {
"quoteText": "Don't think of it as failure. Think of it as time-released success.",
"quoteAuthor": "Robert Orben"
}, {
"quoteText": "Instead of saying that man is the creature of circumstance, it would be nearer the mark to say that man is the architect of circumstance.",
"quoteAuthor": "Thomas Carlyle"
}, {
"quoteText": "The exercise of an extraordinary gift is the supremest pleasure in life.",
"quoteAuthor": "Mark Twain"
}, {
"quoteText": "It is through science that we prove, but through intuition that we discover.",
"quoteAuthor": "Jules Poincare"
}, {
"quoteText": "Every problem has a gift for you in its hands.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "The possession of knowledge does not kill the sense of wonder and mystery. There is always more mystery.",
"quoteAuthor": "Anais Nin"
}, {
"quoteText": "The future is completely open, and we are writing it moment to moment.",
"quoteAuthor": "Pema Chodron"
}, {
"quoteText": "Don't be dismayed by good-byes. A farewell is necessary before you can meet again. And meeting again, after moments or lifetimes, is certain for those who are friends.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "Nothing in life is to be feared. It is only to be understood.",
"quoteAuthor": "Marie Curie"
}, {
"quoteText": "If someone in your life talked to you the way you talk to yourself, you would have left them long ago.",
"quoteAuthor": "Carla Gordon"
}, {
"quoteText": "I will not be concerned at other men is not knowing me;I will be concerned at my own want of ability.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "If you love someone, set them free. If they come back they're yours; if they don't they never were.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "Courage is not about taking risks unknowingly but putting your own being in front of challenges that others may not be able to.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "The cosmos is neither moral or immoral; only people are. He who would move the world must first move himself.",
"quoteAuthor": "Edward Ericson"
}, {
"quoteText": "Some people are always grumbling because roses have thorns; I am thankful that thorns have roses.",
"quoteAuthor": "Alphonse Karr"
}, {
"quoteText": "Everyone smiles in the same language.",
"quoteAuthor": ""
}, {
"quoteText": "If you lose today, win tomorrow. In this never-ending spirit of challenge is the heart of a victor.",
"quoteAuthor": "Daisaku Ikeda"
}, {
"quoteText": "Arrogance and rudeness are training wheels on the bicycle of life � for weak people who cannot keep their balance without them.",
"quoteAuthor": "Laura Teresa Marquez"
}, {
"quoteText": "Well done is better than well said.",
"quoteAuthor": "Benjamin Franklin"
}, {
"quoteText": "No is easier to do. Yes is easier to say.",
"quoteAuthor": "Jason Fried"
}, {
"quoteText": "Myths which are believed in tend to become true.",
"quoteAuthor": "George Orwell"
}, {
"quoteText": "A failure is a man who has blundered but is not capable of cashing in on the experience.",
"quoteAuthor": "Elbert Hubbard"
}, {
"quoteText": "You can do what's reasonable or you can decide what's possible.",
"quoteAuthor": ""
}, {
"quoteText": "We must overcome the notion that we must be regular. It robs you of the chance to be extraordinary and leads you to the mediocre.",
"quoteAuthor": "Uta Hagen"
}, {
"quoteText": "There is a way that nature speaks, that land speaks. Most of the time we are simply not patient enough, quiet enough, to pay attention to the story.",
"quoteAuthor": "Linda Hogan"
}, {
"quoteText": "He who fears being conquered is sure of defeat.",
"quoteAuthor": "Napoleon Bonaparte"
}, {
"quoteText": "You can do it if you believe you can!",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Take time to deliberate, but when the time for action has arrived, stop thinking and go in.",
"quoteAuthor": "Napoleon Bonaparte"
}, {
"quoteText": "To listen well is as powerful a means of communication and influence as to talk well.",
"quoteAuthor": "John Marshall"
}, {
"quoteText": "He who angers you conquers you.",
"quoteAuthor": "Elizabeth Kenny"
}, {
"quoteText": "The secret of joy in work is contained in one word � excellence. To know how to do something well is to enjoy it.",
"quoteAuthor": "Pearl Buck"
}, {
"quoteText": "Transformation doesn't take place with a vacuum; instead, it occurs when we are indirectly and directly connected to all those around us.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Everyone smiles in the same language.",
"quoteAuthor": ""
}, {
"quoteText": "There are two kinds of failures: those who thought and never did, and those who did and never thought.",
"quoteAuthor": "Laurence J. Peter"
}, {
"quoteText": "You cannot make yourself feel something you do not feel, but you can make yourself do right in spite of your feelings.",
"quoteAuthor": "Pearl Buck"
}, {
"quoteText": "Nobody made a greater mistake than he who did nothing because he could do only a little.",
"quoteAuthor": "Edmund Burke"
}, {
"quoteText": "You can adopt the attitude there is nothing you can do, or you can see the challenge as your call to action.",
"quoteAuthor": "Catherine Pulsifer"
}, {
"quoteText": "I have often regretted my speech, never my silence.",
"quoteAuthor": "Publilius Syrus"
}, {
"quoteText": "Never promise more than you can perform.",
"quoteAuthor": "Publilius Syrus"
}, {
"quoteText": "The best and most beautiful things in the world cannot be seen, nor touched... but are felt in the heart.",
"quoteAuthor": "Helen Keller"
}, {
"quoteText": "By going beyond your own problems and taking care of others, you gain inner strength, self-confidence, courage, and a greater sense of calm.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "He can who thinks he can, and he can't who thinks he can't. This is an inexorable, indisputable law.",
"quoteAuthor": "Pablo Picasso"
}, {
"quoteText": "Complaining doesn't change a thing only taking action does.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "If you think you can, you can. And if you think you can't, you're right.",
"quoteAuthor": "Henry Ford"
}, {
"quoteText": "If one advances confidently in the direction of his dream, and endeavours to live the life which he had imagines, he will meet with a success unexpected in common hours.",
"quoteAuthor": "Henry David Thoreau"
}, {
"quoteText": "If you wish to be a writer, write.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "Never tell me the sky�s the limit when there are footprints on the moon.",
"quoteAuthor": ""
}, {
"quoteText": "When people are like each other they tend to like each other.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "I cannot say whether things will get better if we change; what I can say is they must change if they are to get better.",
"quoteAuthor": "Georg Lichtenberg"
}, {
"quoteText": "Happiness cannot be travelled to, owned, earned, worn or consumed. Happiness is the spiritual experience of living every minute with love, grace and gratitude.",
"quoteAuthor": "Denis Waitley"
}, {
"quoteText": "The smallest flower is a thought, a life answering to some feature of the Great Whole, of whom they have a persistent intuition.",
"quoteAuthor": "Honore de Balzac"
}, {
"quoteText": "We must not say every mistake is a foolish one.",
"quoteAuthor": "Cicero"
}, {
"quoteText": "The way is not in the sky. The way is in the heart.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Once we accept our limits, we go beyond them.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "Can miles truly separate you from friends... If you want to be with someone you love, aren't you already there?",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "There are two ways to slide easily through life: to believe everything or to doubt everything; both ways save us from thinking.",
"quoteAuthor": "Alfred Korzybski"
}, {
"quoteText": "Fine words and an insinuating appearance are seldom associated with true virtue",
"quoteAuthor": "Confucius"
}, {
"quoteText": "The greater part of human pain is unnecessary. It is self-created as long as the unobserved mind runs your life.",
"quoteAuthor": "Eckhart Tolle"
}, {
"quoteText": "Shoot for the moon. Even if you miss, you'll land among the stars.",
"quoteAuthor": "Les Brown"
}, {
"quoteText": "If the stars should appear but one night every thousand years how man would marvel and adore.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "The only limit to our realization of tomorrow will be our doubts of today.",
"quoteAuthor": "Franklin Roosevelt"
}, {
"quoteText": "Learning without reflection is a waste, reflection without learning is dangerous.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Think for yourselves and let others enjoy the privilege to do so too.",
"quoteAuthor": "Voltaire"
}, {
"quoteText": "Take it easy � but take it.",
"quoteAuthor": "Woody Guthrie"
}, {
"quoteText": "No garden is without its weeds.",
"quoteAuthor": "Thomas Fuller"
}, {
"quoteText": "Great indeed is the sublimity of the Creative, to which all beings owe their beginning and which permeates all heaven.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "You will never be happy if you continue to search for what happiness consists of. You will never live if you are looking for the meaning of life.",
"quoteAuthor": "Albert Camus"
}, {
"quoteText": "No pessimist ever discovered the secrets of the stars, or sailed to an uncharted land, or opened a new heaven to the human spirit.",
"quoteAuthor": "Helen Keller"
}, {
"quoteText": "Life shrinks or expands in proportion to one's courage.",
"quoteAuthor": "Anais Nin"
}, {
"quoteText": "Thats the risk you take if you change: that people you've been involved with won't like the new you. But other people who do will come along.",
"quoteAuthor": "Lisa Alther"
}, {
"quoteText": "The winds and waves are always on the side of the ablest navigators.",
"quoteAuthor": "Edward Gibbon"
}, {
"quoteText": "No yesterdays are ever wasted for those who give themselves to today.",
"quoteAuthor": "Brendan Francis"
}, {
"quoteText": "When it is obvious that the goals cannot be reached, don't adjust the goals, adjust the action steps.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Meditation brings wisdom; lack of mediation leaves ignorance. Know well what leads you forward and what hold you back, and choose the path that leads to wisdom.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Change your words. Change your world.",
"quoteAuthor": ""
}, {
"quoteText": "If you must tell me your opinions, tell me what you believe in. I have plenty of douts of my own.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "You must train your intuition � you must trust the small voice inside you which tells you exactly what to say, what to decide.",
"quoteAuthor": "Ingrid Bergman"
}, {
"quoteText": "Study the past, if you would divine the future.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "God has given you one face, and you make yourself another.",
"quoteAuthor": "William Shakespeare"
}, {
"quoteText": "The only real valuable thing is intuition.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "It is never too late to be what you might have been.",
"quoteAuthor": "George Eliot"
}, {
"quoteText": "People seldom notice old clothes if you wear a big smile.",
"quoteAuthor": "Lee Mildon"
}, {
"quoteText": "Blessed is the man who expects nothing, for he shall never be disappointed.",
"quoteAuthor": "Alexander Pope"
}, {
"quoteText": "What the caterpillar calls the end of the world, the master calls a butterfly.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "It does not matter how slowly you go as long as you do not stop.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "What we think, we become.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "The foot feels the foot when it feels the ground.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Rainbows apologize for angry skies.",
"quoteAuthor": "Sylvia Voirol"
}, {
"quoteText": "Life isn't about finding yourself. Life is about creating yourself.",
"quoteAuthor": "Bernard Shaw"
}, {
"quoteText": "Success is not the key to happiness. Happiness is the key to success. If you love what you are doing, you will be successful.",
"quoteAuthor": "Albert Schweitzer"
}, {
"quoteText": "He who knows others is wise. He who knows himself is enlightened.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "The greatest way to live with honor in this world is to be what we pretend to be.",
"quoteAuthor": "Socrates"
}, {
"quoteText": "Great are they who see that spiritual is stronger than any material force, that thoughts rule the world.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Trust only movement. Life happens at the level of events, not of words. Trust movement.",
"quoteAuthor": "Alfred Adler"
}, {
"quoteText": "The really unhappy person is the one who leaves undone what they can do, and starts doing what they don't understand; no wonder they come to grief.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "An ant on the move does more than a dozing ox",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "The journey of a thousand miles begins with one step.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "They say that time changes things, but you actually have to change them yourself.",
"quoteAuthor": "Andy Warhol"
}, {
"quoteText": "Learn all you can from the mistakes of others. You won't have time to make them all yourself.",
"quoteAuthor": "Alfred Sheinwold"
}, {
"quoteText": "There are two primary choices in life: to accept conditions as they exist, or accept responsibility for changing them.",
"quoteAuthor": "Denis Waitley"
}, {
"quoteText": "If one is lucky, a solitary fantasy can totally transform one million realities.",
"quoteAuthor": "Maya Angelou"
}, {
"quoteText": "Once we accept our limits, we go beyond them.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "Strength to carry on despite the odds means you have faith in your own abilities and know how.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "And as we let our own light shine, we unconsciously give other people permission to do the same.",
"quoteAuthor": "Nelson Mandela"
}, {
"quoteText": "The greatest pleasure I know is to do a good action by stealth, and to have it found out by accident.",
"quoteAuthor": "Charles Lamb"
}, {
"quoteText": "If you don't design your own life plan, chances are you'll fall into someone else's plan. And guess what they have planned for you? Not much.",
"quoteAuthor": "Jim Rohn"
}, {
"quoteText": "With courage you will dare to take risks, have the strength to be compassionate, and the wisdom to be humble. Courage is the foundation of integrity.",
"quoteAuthor": "Keshavan Nair"
}, {
"quoteText": "Moments of complete apathy are the best for new creations.",
"quoteAuthor": "Philip Breedveld"
}, {
"quoteText": "The best way to predict your future is to create it.",
"quoteAuthor": "Peter Drucker"
}, {
"quoteText": "To avoid criticism, do nothing, say nothing, be nothing.",
"quoteAuthor": "Elbert Hubbard"
}, {
"quoteText": "To accomplish great things, we must dream as well as act.",
"quoteAuthor": "Anatole France"
}, {
"quoteText": "Fear is a darkroom where negatives develop.",
"quoteAuthor": "Usman Asif"
}, {
"quoteText": "We come to love not by finding a perfect person, but by learning to see an imperfect person perfectly.",
"quoteAuthor": "Sam Keen"
}, {
"quoteText": "People take different roads seeking fulfilment and happiness. Just because theyre not on your road doesn't mean they've gotten lost.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Life is what you make of it. Always has been, always will be.",
"quoteAuthor": "Grandma Moses"
}, {
"quoteText": "To see things in the seed, that is genius.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Be miserable. Or motivate yourself. Whatever has to be done, it's always your choice.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Thousands of candles can be lighted from a single candle, and the life of the candle will not be shortened. Happiness never decreases by being shared.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Don't judge each day by the harvest you reap but by the seeds that you plant.",
"quoteAuthor": "Robert Stevenson"
}, {
"quoteText": "Everyone has been made for some particular work, and the desire for that work has been put in every heart.",
"quoteAuthor": "Rumi"
}, {
"quoteText": "Be glad of life because it gives you the chance to love, to work, to play, and to look up at the stars.",
"quoteAuthor": "Henry Van Dyke"
}, {
"quoteText": "A hero is no braver than an ordinary man, but he is braver five minutes longer.",
"quoteAuthor": "Ralph Waldo Emerson"
}, {
"quoteText": "There is no need for temples, no need for complicated philosophies. My brain and my heart are my temples; my philosophy is kindness.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Whoever is happy will make others happy, too.",
"quoteAuthor": "Mark Twain"
}, {
"quoteText": "It's not what happens to you, but how you react to it that matters.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "He that never changes his opinions, never corrects his mistakes, and will never be wiser on the morrow than he is today.",
"quoteAuthor": "Tryon Edwards"
}, {
"quoteText": "Anybody can make history. Only a great man can write it.",
"quoteAuthor": "Oscar Wilde"
}, {
"quoteText": "A garden is always a series of losses set against a few triumphs, like life itself.",
"quoteAuthor": "May Sarton"
}, {
"quoteText": "Difficulties are things that show a person what they are.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "A goal without a plan is just a wish.",
"quoteAuthor": "Larry Elder"
}, {
"quoteText": "Life is so constructed that an event does not, cannot, will not, match the expectation.",
"quoteAuthor": "Charlotte Bronte"
}, {
"quoteText": "We shall never know all the good that a simple smile can do.",
"quoteAuthor": "Mother Teresa"
}, {
"quoteText": "Love is never lost. If not reciprocated, it will flow back and soften and purify the heart.",
"quoteAuthor": "Washington Irving"
}, {
"quoteText": "Do you want to know who you are? Don't ask. Act! Action will delineate and define you.",
"quoteAuthor": "Thomas Jefferson"
}, {
"quoteText": "If facts are the seeds that later produce knowledge and wisdom, then the emotions and the impressions of the senses are the fertile soil in which the seeds must grow.",
"quoteAuthor": "Rachel Carson"
}, {
"quoteText": "The harder you fall, the higher you bounce.",
"quoteAuthor": ""
}, {
"quoteText": "Kindness is more important than wisdom, and the recognition of this is the beginning of wisdom.",
"quoteAuthor": "Theodore Rubin"
}, {
"quoteText": "Compassion and happiness are not a sign of weakness but a sign of strength.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Don't focus on making the right decision, focus on making the decision the right one.",
"quoteAuthor": ""
}, {
"quoteText": "The way is not in the sky. The way is in the heart.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Light tomorrow with today!",
"quoteAuthor": "Elizabeth Browning"
}, {
"quoteText": "Forgiveness does not change the past, but it does enlarge the future.",
"quoteAuthor": "Paul Boese"
}, {
"quoteText": "You won't skid if you stay in a rut.",
"quoteAuthor": "Kin Hubbard"
}, {
"quoteText": "Never mistake motion for action.",
"quoteAuthor": "Ernest Hemingway"
}, {
"quoteText": "Genuine love should first be directed at oneself � if we do not love ourselves, how can we love others?",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Your attitude, not your aptitude, will determine your altitude.",
"quoteAuthor": "Zig Ziglar"
}, {
"quoteText": "Success is not the key to happiness. Happiness is the key to success. If you love what you are doing, you will be successful.",
"quoteAuthor": "Albert Schweitzer"
}, {
"quoteText": "When you see a man of worth, think of how you may emulate him. When you see one who is unworthy, examine yourself.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Never bend your head. Always hold it high. Look the world right in the eye.",
"quoteAuthor": "Helen Keller"
}, {
"quoteText": "A goal without a plan is just a wish.",
"quoteAuthor": "Larry Elder"
}, {
"quoteText": "When it is obvious that the goals cannot be reached, don't adjust the goals, adjust the action steps.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Friendship with oneself is all important because without it one cannot be friends with anybody else in the world.",
"quoteAuthor": "Eleanor Roosevelt"
}, {
"quoteText": "I have often regretted my speech, never my silence.",
"quoteAuthor": "Publilius Syrus"
}, {
"quoteText": "One needs something to believe in, something for which one can have whole-hearted enthusiasm. One needs to feel that ones life has meaning, that one is needed in this world.",
"quoteAuthor": "Hannah Senesh"
}, {
"quoteText": "One who is too insistent on his own views, finds few to agree with him.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Do not be embarrassed by your mistakes. Nothing can teach us better than our understanding of them. This is one of the best ways of self-education.",
"quoteAuthor": "Thomas Carlyle"
}, {
"quoteText": "A single conversation across the table with a wise person is worth a months study of books.",
"quoteAuthor": "Chinese proverb"
}, {
"quoteText": "Be what you are. This is the first step toward becoming better than you are.",
"quoteAuthor": "Julius Charles Hare"
}, {
"quoteText": "Just as a candle cannot burn without fire, men cannot live without a spiritual life.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Your attitude, not your aptitude, will determine your altitude.",
"quoteAuthor": "Zig Ziglar"
}, {
"quoteText": "Ability will never catch up with the demand for it.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Nature gave us one tongue and two ears so we could hear twice as much as we speak.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "To be happy is to be able to become aware of oneself without fright.",
"quoteAuthor": "Walter Benjamin"
}, {
"quoteText": "You only lose what you cling to.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "A weed is no more than a flower in disguise.",
"quoteAuthor": "James Lowell"
}, {
"quoteText": "Genius is one percent inspiration and ninety-nine percent perspiration.",
"quoteAuthor": "Thomas Edison"
}, {
"quoteText": "The secret to a rich life is to have more beginnings than endings.",
"quoteAuthor": "Dave Weinbaum"
}, {
"quoteText": "Translation is the paradigm, the exemplar of all writing. It is translation that demonstrates most vividly the yearning for transformation that underlies every act involving speech, that supremely human gift.",
"quoteAuthor": "Harry Burchell Mathews"
}, {
"quoteText": "Wisdom is the reward you get for a lifetime of listening when you'd have preferred to talk.",
"quoteAuthor": "Doug Larson"
}, {
"quoteText": "Nothing ever goes away until it has taught us what we need to know.",
"quoteAuthor": "Pema Chodron"
}, {
"quoteText": "A successful person is one who can lay a firm foundation with the bricks that others throw at him or her.",
"quoteAuthor": "David Brinkley"
}, {
"quoteText": "Meditation is the dissolution of thoughts in eternal awareness or Pure consciousness without objectification, knowing without thinking, merging finitude in infinity.",
"quoteAuthor": "Voltaire"
}, {
"quoteText": "The reasonable man adapts himself to the world; the unreasonable man persists in trying to adapt the world to himself. Therefore, all progress depends on the unreasonable man.",
"quoteAuthor": "George Shaw"
}, {
"quoteText": "Setting goals is the first step in turning the invisible into the visible.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "The universe is transformation; our life is what our thoughts make it.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "There is no duty we so underrate as the duty of being happy. By being happy we sow anonymous benefits upon the world.",
"quoteAuthor": "Robert Louis Stevenson"
}, {
"quoteText": "Good instincts usually tell you what to do long before your head has figured it out.",
"quoteAuthor": "Michael Burke"
}, {
"quoteText": "Meaning is not what you start with but what you end up with.",
"quoteAuthor": "Peter Elbow"
}, {
"quoteText": "We are all faced with a series of great opportunities brilliantly disguised as impossible situations.",
"quoteAuthor": "Charles R. Swindoll"
}, {
"quoteText": "What matters is the value we've created in our lives, the people we've made happy and how much we've grown as people.",
"quoteAuthor": "Daisaku Ikeda"
}, {
"quoteText": "The biggest adventure you can ever take is to live the life of your dreams.",
"quoteAuthor": "Oprah Winfrey"
}, {
"quoteText": "Logic will get you from A to B. Imagination will take you everywhere.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "Promises are the uniquely human way of ordering the future, making it predictable and reliable to the extent that this is humanly possible.",
"quoteAuthor": "Hannah Arendt"
}, {
"quoteText": "A short saying oft contains much wisdom.",
"quoteAuthor": "Sophocles"
}, {
"quoteText": "Self-complacency is fatal to progress.",
"quoteAuthor": "Margaret Sangster"
}, {
"quoteText": "What is not started today is never finished tomorrow.",
"quoteAuthor": "Goethe"
}, {
"quoteText": "It isn't what happens to us that causes us to suffer; it's what we say to ourselves about what happens.",
"quoteAuthor": "Pema Chodron"
}, {
"quoteText": "The possession of knowledge does not kill the sense of wonder and mystery. There is always more mystery.",
"quoteAuthor": "Anais Nin"
}, {
"quoteText": "Bite off more than you can chew, then chew it.",
"quoteAuthor": "Ella Williams"
}, {
"quoteText": "Ignorance never settle a question.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "Failure will never overtake me if my determination to succeed is strong enough.",
"quoteAuthor": "Og Mandino"
}, {
"quoteText": "Those who dream by day are cognizant of many things which escape those who dream only by night.",
"quoteAuthor": "Edgar Allan Poe"
}, {
"quoteText": "All that we are is the result of what we have thought. The mind is everything. What we think we become.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "There is no need for temples, no need for complicated philosophies. My brain and my heart are my temples; my philosophy is kindness.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "We cannot hold a torch to light another's path without brightening our own.",
"quoteAuthor": "Ben Sweetland"
}, {
"quoteText": "The minute you settle for less than you deserve, you get even less than you settled for.",
"quoteAuthor": "Maureen Dowd"
}, {
"quoteText": "You are never given a wish without also being given the power to make it come true. You may have to work for it, however.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "If you don't design your own life plan, chances are you'll fall into someone else's plan. And guess what they have planned for you? Not much.",
"quoteAuthor": "Jim Rohn"
}, {
"quoteText": "A weed is no more than a flower in disguise.",
"quoteAuthor": "James Lowell"
}, {
"quoteText": "Real success is finding your lifework in the work that you love.",
"quoteAuthor": "David McCullough"
}, {
"quoteText": "Great talent finds happiness in execution.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "We are all faced with a series of great opportunities brilliantly disguised as impossible situations.",
"quoteAuthor": "Charles R. Swindoll"
}, {
"quoteText": "The deepest craving of human nature is the need to be appreciated.",
"quoteAuthor": "William James"
}, {
"quoteText": "If you have no respect for your own values how can you be worthy of respect from others.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Where there is great love, there are always miracles.",
"quoteAuthor": "Willa Cather"
}, {
"quoteText": "I allow my intuition to lead my path.",
"quoteAuthor": "Manuel Puig"
}, {
"quoteText": "Never, never, never give up.",
"quoteAuthor": "Winston Churchill"
}, {
"quoteText": "From little acorns mighty oaks do grow.",
"quoteAuthor": "American proverb"
}, {
"quoteText": "I believe that every person is born with talent.",
"quoteAuthor": "Maya Angelou"
}, {
"quoteText": "The key to transforming our hearts and minds is to have an understanding of how our thoughts and emotions work.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Can you imagine what I would do if I could do all I can?",
"quoteAuthor": "Sun Tzu"
}, {
"quoteText": "Wherever a man may happen to turn, whatever a man may undertake, he will always end up by returning to the path which nature has marked out for him.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "It's so simple to be wise. Just think of something stupid to say and then don't say it.",
"quoteAuthor": "Sam Levenson"
}, {
"quoteText": "When you are content to be simply yourself and don't compare or compete, everybody will respect you.",
"quoteAuthor": "Laozi"
}, {
"quoteText": "Many people have gone further than they thought they could because someone else thought they could.",
"quoteAuthor": ""
}, {
"quoteText": "Keep true to the dreams of thy youth.",
"quoteAuthor": "Friedrich von Schiller"
}, {
"quoteText": "Happiness does not come from having much, but from being attached to little.",
"quoteAuthor": "Cheng Yen"
}, {
"quoteText": "Most smiles are started by another smile.",
"quoteAuthor": ""
}, {
"quoteText": "Through meditation and by giving full attention to one thing at a time, we can learn to direct attention where we choose.",
"quoteAuthor": "Eknath Easwaran"
}, {
"quoteText": "Do not be embarrassed by your mistakes. Nothing can teach us better than our understanding of them. This is one of the best ways of self-education.",
"quoteAuthor": "Thomas Carlyle"
}, {
"quoteText": "If you can't explain it simply, you don't understand it well enough.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "All know the way; few actually walk it.",
"quoteAuthor": "Bodhidharma"
}, {
"quoteText": "However many holy words you read, However many you speak, What good will they do you If you do not act on upon them?",
"quoteAuthor": "Buddha"
}, {
"quoteText": "What matters is the value we've created in our lives, the people we've made happy and how much we've grown as people.",
"quoteAuthor": "Daisaku Ikeda"
}, {
"quoteText": "When you begin to touch your heart or let your heart be touched, you begin to discover that it's bottomless.",
"quoteAuthor": "Pema Chodron"
}, {
"quoteText": "Kind words can be short and easy to speak, but their echoes are truly endless.",
"quoteAuthor": "Mother Teresa"
}, {
"quoteText": "Life shrinks or expands in proportion to one's courage.",
"quoteAuthor": "Anais Nin"
}, {
"quoteText": "With realization of ones own potential and self-confidence in ones ability, one can build a better world.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Count your joys instead of your woes. Count your friends instead of your foes.",
"quoteAuthor": ""
}, {
"quoteText": "The cause is hidden. The effect is visible to all.",
"quoteAuthor": "Ovid"
}, {
"quoteText": "You were not born a winner, and you were not born a loser. You are what you make yourself be.",
"quoteAuthor": "Lou Holtz"
}, {
"quoteText": "If one does not know to which port is sailing, no wind is favorable.",
"quoteAuthor": "Seneca"
}, {
"quoteText": "I think and that is all that I am.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Dreams come true. Without that possibility, nature would not incite us to have them.",
"quoteAuthor": "John Updike"
}, {
"quoteText": "To be able to give away riches is mandatory if you wish to possess them. This is the only way that you will be truly rich.",
"quoteAuthor": "Mahummad Ali"
}, {
"quoteText": "One needs something to believe in, something for which one can have whole-hearted enthusiasm. One needs to feel that ones life has meaning, that one is needed in this world.",
"quoteAuthor": "Hannah Senesh"
}, {
"quoteText": "Nothing in life is to be feared. It is only to be understood.",
"quoteAuthor": "Marie Curie"
}, {
"quoteText": "A little knowledge that acts is worth infinitely more than much knowledge that is idle.",
"quoteAuthor": "Kahlil Gibran"
}, {
"quoteText": "If you would take, you must first give, this is the beginning of intelligence.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Positive thinking will let you do everything better than negative thinking will.",
"quoteAuthor": "Zig Ziglar"
}, {
"quoteText": "He who lives in harmony with himself lives in harmony with the world.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "Staying in one place is the best path to be taken over and surpassed by many.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "To know oneself is to study oneself in action with another person.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "However many holy words you read, however many you speak, what good will they do you if you do not act on upon them?",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Doing nothing is better than being busy doing nothing.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "There is not one big cosmic meaning for all, there is only the meaning we each give to our life.",
"quoteAuthor": "Anais Nin"
}, {
"quoteText": "You can tell whether a man is clever by his answers. You can tell whether a man is wise by his questions.",
"quoteAuthor": "Naguib Mahfouz"
}, {
"quoteText": "The truth of the matter is that you always know the right thing to do. The hard part is doing it.",
"quoteAuthor": "Norman Schwarzkopf"
}, {
"quoteText": "Imagination will often carry us to worlds that never were. But without it we go nowhere.",
"quoteAuthor": "Carl Sagan"
}, {
"quoteText": "When one door of happiness closes, another opens; but often we look so long at the closed door that we do not see the one which has been opened for us.",
"quoteAuthor": "Helen Keller"
}, {
"quoteText": "We must be as courteous to a man as we are to a picture, which we are willing to give the advantage of a good light.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Change your thoughts, change your life!",
"quoteAuthor": ""
}, {
"quoteText": "You have to take it as it happens, but you should try to make it happen the way you want to take it.",
"quoteAuthor": "Old German proverb"
}, {
"quoteText": "All I can say about life is, Oh God, enjoy it!",
"quoteAuthor": "Bob Newhart"
}, {
"quoteText": "Real magic in relationships means an absence of judgement of others.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Problems are only opportunities with thorns on them.",
"quoteAuthor": "Hugh Miller"
}, {
"quoteText": "He who knows himself is enlightened.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "The minute you settle for less than you deserve, you get even less than you settled for.",
"quoteAuthor": "Maureen Dowd"
}, {
"quoteText": "I think and that is all that I am.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Fortune favours the brave.",
"quoteAuthor": "Virgil"
}, {
"quoteText": "A leader or a man of action in a crisis almost always acts subconsciously and then thinks of the reasons for his action.",
"quoteAuthor": "Jawaharlal Nehru"
}, {
"quoteText": "Judge nothing, you will be happy. Forgive everything, you will be happier. Love everything, you will be happiest.",
"quoteAuthor": "Sri Chinmoy"
}, {
"quoteText": "The secret of success is constancy to purpose.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "Absence makes the heart grow fonder.",
"quoteAuthor": "Haynes Bayly"
}, {
"quoteText": "The best place to find a helping hand is at the end of your own arm.",
"quoteAuthor": ""
}, {
"quoteText": "The key to transforming our hearts and minds is to have an understanding of how our thoughts and emotions work.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "I have no special talent. I am only passionately curious.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "He who knows others is wise. He who knows himself is enlightened.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "What matters is the value we've created in our lives, the people we've made happy and how much we've grown as people.",
"quoteAuthor": "Daisaku Ikeda"
}, {
"quoteText": "Self-complacency is fatal to progress.",
"quoteAuthor": "Margaret Sangster"
}, {
"quoteText": "Remember that failure is an event, not a person.",
"quoteAuthor": "Zig Ziglar"
}, {
"quoteText": "In the middle of every difficulty lies opportunity.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "It is more important to know where you are going than to get there quickly. Do not mistake activity for achievement.",
"quoteAuthor": "Mabel Newcomber"
}, {
"quoteText": "We are shaped by our thoughts; we become what we think. When the mind is pure, joy follows like a shadow that never leaves.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "I'm not interested in age. People who tell me their age are silly. You're as old as you feel.",
"quoteAuthor": "Elizabeth Arden"
}, {
"quoteText": "Nothing is softer or more flexible than water, yet nothing can resist it.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Yesterday I dared to struggle. Today I dare to win.",
"quoteAuthor": "Bernadette Devlin"
}, {
"quoteText": "I'm a great believer in luck and I find the harder I work, the more I have of it.",
"quoteAuthor": "Thomas Jefferson"
}, {
"quoteText": "If you look into your own heart, and you find nothing wrong there, what is there to worry about? What is there to fear?",
"quoteAuthor": "Confucius"
}, {
"quoteText": "I endeavour to be wise when I cannot be merry, easy when I cannot be glad, content with what cannot be mended and patient when there is no redress.",
"quoteAuthor": "Elizabeth Montagu"
}, {
"quoteText": "The shoe that fits one person pinches another; there is no recipe for living that suits all cases.",
"quoteAuthor": "Carl Jung"
}, {
"quoteText": "The world has the habit of making room for the man whose actions show that he knows where he is going.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "You always succeed in producing a result.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "You are the only person on earth who can use your ability.",
"quoteAuthor": "Zig Ziglar"
}, {
"quoteText": "To live a pure unselfish life, one must count nothing as ones own in the midst of abundance.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "To be wrong is nothing unless you continue to remember it.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "The happiness that is genuinely satisfying is accompanied by the fullest exercise of our faculties and the fullest realization of the world in which we live.",
"quoteAuthor": "Bertrand Russell"
}, {
"quoteText": "If we learn to open our hearts, anyone, including the people who drive us crazy, can be our teacher.",
"quoteAuthor": "Pema Chodron"
}, {
"quoteText": "A man who doesn't trust himself can never really trust anyone else.",
"quoteAuthor": "Cardinal Retz"
}, {
"quoteText": "Without passion man is a mere latent force and possibility, like the flint which awaits the shock of the iron before it can give forth its spark.",
"quoteAuthor": "Amiel"
}, {
"quoteText": "Not every difficult and dangerous thing is suitable for training, but only that which is conducive to success in achieving the object of our effort.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "It takes both sunshine and rain to make a rainbow.",
"quoteAuthor": ""
}, {
"quoteText": "An idea that is developed and put into action is more important than an idea that exists only as an idea.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "You can do it if you believe you can!",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Do not expect the world to look bright, if you habitually wear gray-brown glasses.",
"quoteAuthor": "Tomas Eliot"
}, {
"quoteText": "Change in all things is sweet.",
"quoteAuthor": "Aristotle"
}, {
"quoteText": "They can do all because they think they can.",
"quoteAuthor": "Virgil"
}, {
"quoteText": "The two most powerful warriors are patience and time.",
"quoteAuthor": "Leo Tolstoy"
}, {
"quoteText": "The height of your accomplishments will equal the depth of your convictions.",
"quoteAuthor": "William Scolavino"
}, {
"quoteText": "If you come to a fork in the road, take it.",
"quoteAuthor": ""
}, {
"quoteText": "Iron rusts from disuse; water loses its purity from stagnation... even so does inaction sap the vigour of the mind.",
"quoteAuthor": "Leonardo da Vinci"
}, {
"quoteText": "However many holy words you read, However many you speak, What good will they do you If you do not act on upon them?",
"quoteAuthor": "Buddha"
}, {
"quoteText": "You cannot be lonely if you like the person you're alone with.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Freedom is the right to live as we wish.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "The truth of the matter is that you always know the right thing to do. The hard part is doing it.",
"quoteAuthor": "Norman Schwarzkopf"
}, {
"quoteText": "Self-complacency is fatal to progress.",
"quoteAuthor": "Margaret Sangster"
}, {
"quoteText": "As we are liberated from our own fear, our presence automatically liberates others.",
"quoteAuthor": "Nelson Mandela"
}, {
"quoteText": "If I am not for myself, who will be for me? If I am not for others, what am I? And if not now, when?",
"quoteAuthor": "Rabbi Hillel"
}, {
"quoteText": "It has never been my object to record my dreams, just to realize them.",
"quoteAuthor": "Man Ray"
}, {
"quoteText": "Wisdom begins in wonder.",
"quoteAuthor": "Socrates"
}, {
"quoteText": "We must never forget that it is through our actions, words, and thoughts that we have a choice.",
"quoteAuthor": "Sogyal Rinpoche"
}, {
"quoteText": "He who experiences the unity of life sees his own Self in all beings, and all beings in his own Self, and looks on everything with an impartial eye.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "When I dare to be powerful, to use my strength in the service of my vision, then it becomes less and less important whether I am afraid.",
"quoteAuthor": "Audre Lorde"
}, {
"quoteText": "To give hope to someone occurs when you teach them how to use the tools to do it for themselves.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "A life spent making mistakes is not only more honourable but more useful than a life spent in doing nothing.",
"quoteAuthor": "Bernard Shaw"
}, {
"quoteText": "We know what we are, but know not what we may be.",
"quoteAuthor": "William Shakespeare"
}, {
"quoteText": "If you let go a little, you will have a little peace. If you let go a lot, you will have a lot of peace.",
"quoteAuthor": "Ajahn Chah"
}, {
"quoteText": "Some people thrive on huge, dramatic change. Some people prefer the slow and steady route. Do what's right for you.",
"quoteAuthor": "Julie Morgenstern"
}, {
"quoteText": "What is a weed? A plant whose virtues have not yet been discovered.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "To be wronged is nothing unless you continue to remember it.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Your destiny isn't just fate; it is how you use your own developed abilities to get what you want.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "How we spend our days is, of course, how we spend our lives.",
"quoteAuthor": "Annie Dillard"
}, {
"quoteText": "To accomplish great things, we must dream as well as act.",
"quoteAuthor": "Anatole France"
}, {
"quoteText": "If we did the things we are capable of, we would astound ourselves.",
"quoteAuthor": "Thomas Edison"
}, {
"quoteText": "You are the only person on Earth who can use your ability.",
"quoteAuthor": "Zig Ziglar"
}, {
"quoteText": "Success is getting what you want. Happiness is wanting what you get.",
"quoteAuthor": "Dale Carnegie"
}, {
"quoteText": "Never idealize others. They will never live up to your expectations.",
"quoteAuthor": "Leo Buscaglia"
}, {
"quoteText": "I cannot always control what goes on outside. But I can always control what goes on inside.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Those who will play with cats must expect to be scratched.",
"quoteAuthor": "Cervantes"
}, {
"quoteText": "We can only be said to be alive in those moments when our hearts are conscious of our treasures.",
"quoteAuthor": "Thornton Wilder"
}, {
"quoteText": "Today is the tomorrow you worried about yesterday.",
"quoteAuthor": ""
}, {
"quoteText": "Every gift from a friend is a wish for your happiness.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "When performance exceeds ambition, the overlap is called success.",
"quoteAuthor": "Cullen Hightower"
}, {
"quoteText": "This is the final test of a gentleman: his respect for those who can be of no possible value to him.",
"quoteAuthor": "William Lyon Phelps"
}, {
"quoteText": "We choose our destiny in the way we treat others.",
"quoteAuthor": "Wit"
}, {
"quoteText": "Divide each difficulty into as many parts as is feasible and necessary to resolve it.",
"quoteAuthor": "Rene Descartes"
}, {
"quoteText": "Only through our connectedness to others can we really know and enhance the self. And only through working on the self can we begin to enhance our connectedness to others.",
"quoteAuthor": "Harriet Lerner"
}, {
"quoteText": "When you discover your mission, you will feel its demand. It will fill you with enthusiasm and a burning desire to get to work on it.",
"quoteAuthor": "W. Clement Stone"
}, {
"quoteText": "You won't skid if you stay in a rut.",
"quoteAuthor": "Kin Hubbard"
}, {
"quoteText": "To listen well is as powerful a means of communication and influence as to talk well.",
"quoteAuthor": "John Marshall"
}, {
"quoteText": "I am a man of fixed and unbending principles, the first of which is to be flexible at all times.",
"quoteAuthor": "Everett Dirksen"
}, {
"quoteText": "Do not give your attention to what others do or fail to do; give it to what you do or fail to do.",
"quoteAuthor": "Dhammapada"
}, {
"quoteText": "Well begun is half done.",
"quoteAuthor": "Aristotle"
}, {
"quoteText": "The years teach much which the days never know.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Set your goals high, and don't stop till you get there.",
"quoteAuthor": "Bo Jackson"
}, {
"quoteText": "What the caterpillar calls the end of the world, the master calls a butterfly.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "An obstacle may be either a stepping stone or a stumbling block.",
"quoteAuthor": ""
}, {
"quoteText": "I am not afraid of tomorrow, for I have seen yesterday and I love today.",
"quoteAuthor": "William White"
}, {
"quoteText": "We know from science that nothing in the universe exists as an isolated or independent entity.",
"quoteAuthor": "Margaret Wheatley"
}, {
"quoteText": "Each misfortune you encounter will carry in it the seed of tomorrows good luck.",
"quoteAuthor": "Og Mandino"
}, {
"quoteText": "If you want to study yourself � look into the hearts of other people. If you want to study other people � look into your own heart.",
"quoteAuthor": "Friedrich von Schiller"
}, {
"quoteText": "Your outlook on life is a direct reflection on how much you like yourself.",
"quoteAuthor": "Lululemon"
}, {
"quoteText": "The place to improve the world is first in one's own heart and head and hands.",
"quoteAuthor": "Robert M. Pirsig"
}, {
"quoteText": "Conflict is the gadfly of thought. It stirs us to observation and memory. It instigates to invention. It shocks us out of sheeplike passivity, and sets us at noting and contriving.",
"quoteAuthor": "John Dewey"
}, {
"quoteText": "Absence makes the heart grow fonder.",
"quoteAuthor": "Haynes Bayly"
}, {
"quoteText": "The highest stage in moral ure at which we can arrive is when we recognize that we ought to control our thoughts.",
"quoteAuthor": "Charles Darwin"
}, {
"quoteText": "Learning without reflection is a waste, reflection without learning is dangerous.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Good timber does not grow with ease; the stronger the wind, the stronger the trees.",
"quoteAuthor": "J. Willard Marriott"
}, {
"quoteText": "If we learn to open our hearts, anyone, including the people who drive us crazy, can be our teacher.",
"quoteAuthor": "Pema Chodron"
}, {
"quoteText": "Happiness is a perfume you cannot pour on others without getting a few drops on yourself.",
"quoteAuthor": "Ralph Waldo Emerson"
}, {
"quoteText": "From error to error one discovers the entire truth.",
"quoteAuthor": "Sigmund Freud"
}, {
"quoteText": "Life is a gift, and it offers us the privilege, opportunity, and responsibility to give something back by becoming more",
"quoteAuthor": "Anthony Robbins"
}, {
"quoteText": "A person who never made a mistake never tried anything new.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "We are shaped by our thoughts; we become what we think. When the mind is pure, joy follows like a shadow that never leaves.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "We must learn our limits. We are all something, but none of us are everything.",
"quoteAuthor": "Blaise Pascal"
}, {
"quoteText": "If you get up one more time than you fall, you will make it through.",
"quoteAuthor": ""
}, {
"quoteText": "All great men are gifted with intuition. They know without reasoning or analysis, what they need to know.",
"quoteAuthor": "Alexis Carrel"
}, {
"quoteText": "Consider that not only do negative thoughts and emotions destroy our experience of peace, they also undermine our health.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "To get the full value of joy you must have someone to divide it with.",
"quoteAuthor": "Mark Twain"
}, {
"quoteText": "Whenever you have eliminated the impossible, whatever remains, however improbable, must be the truth.",
"quoteAuthor": "Arthur Conan Doyle"
}, {
"quoteText": "The mark of your ignorance is the depth of your belief in injustice and tragedy. What the caterpillar calls the end of the world, the Master calls the butterfly.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "We never live; we are always in the expectation of living.",
"quoteAuthor": "Voltaire"
}, {
"quoteText": "To be happy is to be able to become aware of oneself without fright.",
"quoteAuthor": "Walter Benjamin"
}, {
"quoteText": "Sometimes our fate resembles a fruit tree in winter. Who would think that those branches would turn green again and blossom, but we hope it, we know it.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "We lost because we told ourselves we lost.",
"quoteAuthor": "Leo Tolstoy"
}, {
"quoteText": "No pessimist ever discovered the secrets of the stars, or sailed to an uncharted land, or opened a new heaven to the human spirit.",
"quoteAuthor": "Helen Keller"
}, {
"quoteText": "It is more important to know where you are going than to get there quickly. Do not mistake activity for achievement.",
"quoteAuthor": "Mabel Newcomber"
}, {
"quoteText": "We don't stop playing because we grow old; we grow old because we stop playing.",
"quoteAuthor": "Bernard Shaw"
}, {
"quoteText": "Human beings, who are almost unique in having the ability to learn from the experience of others, are also remarkable for their apparent disinclination to do so.",
"quoteAuthor": "Douglas Adams"
}, {
"quoteText": "Our passion is our strength.",
"quoteAuthor": "Billie Armstrong"
}, {
"quoteText": "You teach best what you most need to learn.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "Worry gives a small thing a big shadow.",
"quoteAuthor": ""
}, {
"quoteText": "Fine words and an insinuating appearance are seldom associated with true virtue",
"quoteAuthor": "Confucius"
}, {
"quoteText": "You can do it if you believe you can!",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "No act of kindness, no matter how small, is ever wasted.",
"quoteAuthor": "Aesop"
}, {
"quoteText": "A man's dreams are an index to his greatness.",
"quoteAuthor": "Zadok Rabinowitz"
}, {
"quoteText": "If you change the way you look at things, the things you look at change.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "A subtle thought that is in error may yet give rise to fruitful inquiry that can establish truths of great value.",
"quoteAuthor": "Isaac Asimov"
}, {
"quoteText": "You can't let praise or criticism get to you. It's a weakness to get caught up in either one.",
"quoteAuthor": "John Wooden"
}, {
"quoteText": "Action may not always bring happiness, but there is no happiness without action.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "In three words I can sum up everything Ive learned about life: it goes on.",
"quoteAuthor": "Robert Frost"
}, {
"quoteText": "Learn wisdom from the ways of a seedling. A seedling which is never hardened off through stressful situations will never become a strong productive plant.",
"quoteAuthor": "Stephen Sigmund"
}, {
"quoteText": "A subtle thought that is in error may yet give rise to fruitful inquiry that can establish truths of great value.",
"quoteAuthor": "Isaac Asimov"
}, {
"quoteText": "Don't frown because you never know who is falling in love with your smile.",
"quoteAuthor": "Sinvyest Tan"
}, {
"quoteText": "Without some goals and some efforts to reach it, no man can live.",
"quoteAuthor": "John Dewey"
}, {
"quoteText": "He who knows, does not speak. He who speaks, does not know.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "The only real valuable thing is intuition.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "The best and most beautiful things in the world cannot be seen, nor touched... but are felt in the heart.",
"quoteAuthor": "Helen Keller"
}, {
"quoteText": "Kindness in words creates confidence. Kindness in thinking creates profoundness. Kindness in giving creates love.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Do not wait for leaders; do it alone, person to person.",
"quoteAuthor": "Mother Teresa"
}, {
"quoteText": "As the rest of the world is walking out the door, your best friends are the ones walking in.",
"quoteAuthor": ""
}, {
"quoteText": "With courage you will dare to take risks, have the strength to be compassionate, and the wisdom to be humble. Courage is the foundation of integrity.",
"quoteAuthor": "Keshavan Nair"
}, {
"quoteText": "Whatever happens, take responsibility.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "Keep your eyes on the stars and your feet on the ground.",
"quoteAuthor": "Theodore Roosevelt"
}, {
"quoteText": "Any of us can achieve virtue, if by virtue we merely mean the avoidance of the vices that do not attract us.",
"quoteAuthor": "Robert Lynd"
}, {
"quoteText": "Success is determined by those whom prove the impossible, possible.",
"quoteAuthor": "James Pence"
}, {
"quoteText": "We are all faced with a series of great opportunities brilliantly disguised as impossible situations.",
"quoteAuthor": "Charles R. Swindoll"
}, {
"quoteText": "A fine quotation is a diamond on the finger of a man of wit, and a pebble in the hand of a fool.",
"quoteAuthor": "Joseph Roux"
}, {
"quoteText": "I do not believe in a fate that falls on men however they act; but I do believe in a fate that falls on man unless they act.",
"quoteAuthor": "G. K. Chesterton"
}, {
"quoteText": "Worry often gives a small thing a big shadow.",
"quoteAuthor": "Swedish proverb"
}, {
"quoteText": "We shall never know all the good that a simple smile can do.",
"quoteAuthor": "Mother Teresa"
}, {
"quoteText": "The only real failure in life is not to be true to the best one knows.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Adversity isn't set against you to fail; adversity is a way to build your character so that you can succeed over and over again through perseverance.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Good advice is always certain to be ignored, but that's no reason not to give it.",
"quoteAuthor": "Agatha Christie"
}, {
"quoteText": "God has given you one face, and you make yourself another.",
"quoteAuthor": "William Shakespeare"
}, {
"quoteText": "Wherever a man turns he can find someone who needs him.",
"quoteAuthor": "Albert Schweitzer"
}, {
"quoteText": "As the rest of the world is walking out the door, your best friends are the ones walking in.",
"quoteAuthor": ""
}, {
"quoteText": "The winner ain't the one with the fastest car it's the one who refuses to lose.",
"quoteAuthor": "Dale Earnhardt"
}, {
"quoteText": "Be thankful when you don't know something for it gives you the opportunity to learn.",
"quoteAuthor": ""
}, {
"quoteText": "The best way out is always through.",
"quoteAuthor": "Robert Frost"
}, {
"quoteText": "Deep listening is miraculous for both listener and speaker.When someone receives us with open-hearted, non-judging, intensely interested listening, our spirits expand.",
"quoteAuthor": "Sue Patton Thoele"
}, {
"quoteText": "I am of the opinion that my life belongs to the community, and as long as I live it is my privilege to do for it whatever I can.",
"quoteAuthor": "Bernard Shaw"
}, {
"quoteText": "Spirituality can be severed from both vicious sectarianism and thoughtless banalities. Spirituality, I have come to see, is nothing less than the thoughtful love of life.",
"quoteAuthor": "Robert C. Solomon"
}, {
"quoteText": "You are special, you are unique, you are the best!",
"quoteAuthor": "Cathy Pulsifer"
}, {
"quoteText": "Truth is powerful and it prevails.",
"quoteAuthor": "Sojourner Truth"
}, {
"quoteText": "When you learn, teach. When you get, give.",
"quoteAuthor": "Maya Angelou"
}, {
"quoteText": "A man's dreams are an index to his greatness.",
"quoteAuthor": "Zadok Rabinowitz"
}, {
"quoteText": "Efficiency is doing things right; effectiveness is doing the right things.",
"quoteAuthor": "Peter Drucker"
}, {
"quoteText": "Truth is powerful and it prevails.",
"quoteAuthor": "Sojourner Truth"
}, {
"quoteText": "Through perseverance many people win success out of what seemed destined to be certain failure.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "The wisest men follow their own direction.",
"quoteAuthor": "Euripides"
}, {
"quoteText": "You, yourself, as much as anybody in the entire universe, deserve your love and affection.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Think how hard physics would be if particles could think.",
"quoteAuthor": "Murray Gell-Mann"
}, {
"quoteText": "Before you put on a frown, make absolutely sure there are no smiles available.",
"quoteAuthor": "Jim Beggs"
}, {
"quoteText": "It is with words as with sunbeams. The more they are condensed, the deeper they burn.",
"quoteAuthor": "Robert Southey"
}, {
"quoteText": "To follow, without halt, one aim: There is the secret of success.",
"quoteAuthor": "Anna Pavlova"
}, {
"quoteText": "In the sky, there is no distinction of east and west; people create distinctions out of their own minds and then believe them to be true.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Transformation does not start with some one else changing you; transformation is an inner self reworking of what you are now to what you will be.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "The thing always happens that you really believe in; and the belief in a thing makes it happen.",
"quoteAuthor": "Frank Wright"
}, {
"quoteText": "If we learn to open our hearts, anyone, including the people who drive us crazy, can be our teacher.",
"quoteAuthor": "Pema Chodron"
}, {
"quoteText": "If you kick a stone in anger, you'll hurt your own foot.",
"quoteAuthor": "Korean proverb"
}, {
"quoteText": "Let us revere, let us worship, but erect and open-eyed, the highest, not the lowest; the future, not the past!",
"quoteAuthor": "Charlotte Gilman"
}, {
"quoteText": "Intuition will tell the thinking mind where to look next.",
"quoteAuthor": "Jonas Salk"
}, {
"quoteText": "No one has a finer command of language than the person who keeps his mouth shut.",
"quoteAuthor": "Sam Rayburn"
}, {
"quoteText": "Through perseverance many people win success out of what seemed destined to be certain failure.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "One needs something to believe in, something for which one can have whole-hearted enthusiasm. One needs to feel that ones life has meaning, that one is needed in this world.",
"quoteAuthor": "Hannah Senesh"
}, {
"quoteText": "The only person who never makes mistakes is the person who never does anything.",
"quoteAuthor": "Denis Waitley"
}, {
"quoteText": "We are what we repeatedly do. Excellence, then, is not an act but a habit.",
"quoteAuthor": "Aristotle"
}, {
"quoteText": "Before you put on a frown, make absolutely sure there are no smiles available.",
"quoteAuthor": "Jim Beggs"
}, {
"quoteText": "We cannot direct the wind but we can adjust the sails.",
"quoteAuthor": ""
}, {
"quoteText": "Ask yourself the secret of your success. Listen to your answer, and practice it.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "Letting go isn�t the end of the world; it�s the beginning of a new life.",
"quoteAuthor": ""
}, {
"quoteText": "When you discover your mission, you will feel its demand. It will fill you with enthusiasm and a burning desire to get to work on it.",
"quoteAuthor": "W. Clement Stone"
}, {
"quoteText": "Life is what happens to you while you're busy making other plans.",
"quoteAuthor": "John Lennon"
}, {
"quoteText": "If I could reach up and hold a star for every time you've made me smile, the entire evening sky would be in the palm of my hand.",
"quoteAuthor": ""
}, {
"quoteText": "Let go of your attachment to being right, and suddenly your mind is more open. You're able to benefit from the unique viewpoints of others, without being crippled by your own judgement.",
"quoteAuthor": "Ralph Marston"
}, {
"quoteText": "Your work is to discover your world and then with all your heart give yourself to it.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "When there is no enemy within, the enemies outside cannot hurt you.",
"quoteAuthor": "African proverb"
}, {
"quoteText": "Progress always involves risks. You can't steal second base and keep your foot on first.",
"quoteAuthor": "Frederick Wilcox"
}, {
"quoteText": "Don't be pushed by your problems; be led by your dreams.",
"quoteAuthor": ""
}, {
"quoteText": "Trust your hunches. They're usually based on facts filed away just below the conscious level.",
"quoteAuthor": "Joyce Brothers"
}, {
"quoteText": "Truth is powerful and it prevails.",
"quoteAuthor": "Sojourner Truth"
}, {
"quoteText": "Discovery consists of seeing what everybody has seen and thinking what nobody else has thought.",
"quoteAuthor": "Jonathan Swift"
}, {
"quoteText": "If you wish to be a writer, write.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "In seed time learn, in harvest teach, in winter enjoy.",
"quoteAuthor": "William Blake"
}, {
"quoteText": "Take heed: you do not find what you do not seek.",
"quoteAuthor": "English proverb"
}, {
"quoteText": "Kindness is the language which the deaf can hear and the blind can see.",
"quoteAuthor": "Mark Twain"
}, {
"quoteText": "When you realize there is nothing lacking, the whole world belongs to you.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "The possession of knowledge does not kill the sense of wonder and mystery. There is always more mystery.",
"quoteAuthor": "Anais Nin"
}, {
"quoteText": "Trust only movement. Life happens at the level of events, not of words. Trust movement.",
"quoteAuthor": "Alfred Adler"
}, {
"quoteText": "Knowledge rests not upon truth alone, but upon error also.",
"quoteAuthor": "Carl Jung"
}, {
"quoteText": "No man was ever wise by chance.",
"quoteAuthor": "Seneca"
}, {
"quoteText": "If you have knowledge, let others light their candles in it.",
"quoteAuthor": "Margaret Fuller"
}, {
"quoteText": "To get the full value of joy you must have someone to divide it with.",
"quoteAuthor": "Mark Twain"
}, {
"quoteText": "The superior man is satisfied and composed; the mean man is always full of distress.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "It is impossible for a man to learn what he thinks he already knows.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "Silence is deep as Eternity, Speech is shallow as Time.",
"quoteAuthor": "Carlyle"
}, {
"quoteText": "If you find yourself in a hole, the first thing to do is stop digging.",
"quoteAuthor": "Will Rogers"
}, {
"quoteText": "Never deny a diagnosis, but do deny the negative verdict that may go with it.",
"quoteAuthor": "Norman Cousins"
}, {
"quoteText": "When you see a good person, think of becoming like him. When you see someone not so good, reflect on your own weak points.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "If we could learn to like ourselves, even a little, maybe our cruelties and angers might melt away.",
"quoteAuthor": "John Steinbeck"
}, {
"quoteText": "I have no special talent. I am only passionately curious.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "You will not be punished for your anger, you will be punished by your anger.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "It isn't where you come from, it's where you're going that counts.",
"quoteAuthor": "Ella Fitzgerald"
}, {
"quoteText": "Those who will play with cats must expect to be scratched.",
"quoteAuthor": "Cervantes"
}, {
"quoteText": "Action is the foundational key to all success.",
"quoteAuthor": "Pablo Picasso"
}, {
"quoteText": "To be able to give away riches is mandatory if you wish to possess them. This is the only way that you will be truly rich.",
"quoteAuthor": "Mahummad Ali"
}, {
"quoteText": "To make no mistakes is not in the power of man; but from their errors and mistakes the wise and good learn wisdom for the future.",
"quoteAuthor": "Plutarch"
}, {
"quoteText": "To see things in the seed, that is genius.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Adversity has the effect of eliciting talents, which in prosperous circumstances would have lain dormant.",
"quoteAuthor": "Horace"
}, {
"quoteText": "I am not bothered by the fact that I am unknown. I am bothered when I do not know others.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "To give hope to someone occurs when you teach them how to use the tools to do it for themselves.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Holding on to anger is like grasping a hot coal with the intent of throwing it at someone else; you are the one who gets burned.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Don't smother each other. No one can grow in the shade.",
"quoteAuthor": "Leo F. Buscaglia"
}, {
"quoteText": "When you are content to be simply yourself and don't compare or compete, everybody will respect you.",
"quoteAuthor": "Laozi"
}, {
"quoteText": "Sooner or later, those who win are those who think they can.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "True happiness means forging a strong spirit that is undefeated, no matter how trying our circumstances.",
"quoteAuthor": "Daisaku Ikeda"
}, {
"quoteText": "Every time you smile at someone, it is an action of love, a gift to that person, a beautiful thing.",
"quoteAuthor": "Mother Teresa"
}, {
"quoteText": "I think you can have moderate success by copying something else, but if you really want to knock it out of the park, you have to do something different and take chances.",
"quoteAuthor": "Lee Womack"
}, {
"quoteText": "Giving up doesn't always mean you are weak; sometimes it means that you are strong enough to let go.",
"quoteAuthor": ""
}, {
"quoteText": "Never miss an opportunity to make others happy, even if you have to leave them alone in order to do it.",
"quoteAuthor": ""
}, {
"quoteText": "I am always doing that which I cannot do, in order that I may learn how to do it.",
"quoteAuthor": "Pablo Picasso"
}, {
"quoteText": "To free us from the expectations of others, to give us back to ourselves � there lies the great, singular power of self-respect.",
"quoteAuthor": "Joan Didion"
}, {
"quoteText": "He who controls others may be powerful, but he who has mastered himself is mightier still.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Happiness is when what you think, what you say, and what you do are in harmony.",
"quoteAuthor": "Mohandas Gandhi"
}, {
"quoteText": "When you have got an elephant by the hind legs and he is trying to run away, it's best to let him run.",
"quoteAuthor": "Abraham Lincoln"
}, {
"quoteText": "Everything we hear is an opinion, not a fact. Everything we see is a perspective, not the truth.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "To effectively communicate, we must realize that we are all different in the way we perceive the world and use this understanding as a guide to our communication with others.",
"quoteAuthor": "Anthony Robbins"
}, {
"quoteText": "Six essential qualities that are the key to success: Sincerity, personal integrity, humility, courtesy, wisdom, charity.",
"quoteAuthor": "William Menninger"
}, {
"quoteText": "People are so constituted that everybody would rather undertake what they see others do, whether they have an aptitude for it or not.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "Goals are the fuel in the furnace of achievement.",
"quoteAuthor": "Brian Tracy"
}, {
"quoteText": "Through perseverance many people win success out of what seemed destined to be certain failure.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "Happiness cannot be travelled to, owned, earned, worn or consumed. Happiness is the spiritual experience of living every minute with love, grace and gratitude.",
"quoteAuthor": "Denis Waitley"
}, {
"quoteText": "Be miserable. Or motivate yourself. Whatever has to be done, it's always your choice.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "By accepting yourself and being fully what you are, your presence can make others happy.",
"quoteAuthor": "Jane Roberts"
}, {
"quoteText": "A goal without a plan is just a wish.",
"quoteAuthor": "Larry Elder"
}, {
"quoteText": "A man of ability and the desire to accomplish something can do anything.",
"quoteAuthor": "Donald Kircher"
}, {
"quoteText": "It's important to know that words don't move mountains. Work, exacting work moves mountains.",
"quoteAuthor": "Danilo Dolci"
}, {
"quoteText": "If you are patient in one moment of anger, you will escape one hundred days of sorrow.",
"quoteAuthor": "Chinese proverb"
}, {
"quoteText": "Logic will get you from A to B. Imagination will take you everywhere.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "I am of the opinion that my life belongs to the community, and as long as I live it is my privilege to do for it whatever I can.",
"quoteAuthor": "Bernard Shaw"
}, {
"quoteText": "No yesterdays are ever wasted for those who give themselves to today.",
"quoteAuthor": "Brendan Francis"
}, {
"quoteText": "However many holy words you read, however many you speak, what good will they do you if you do not act on upon them?",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Autumn is a second spring when every leaf is a flower.",
"quoteAuthor": "Albert Camus"
}, {
"quoteText": "There are no failures � just experiences and your reactions to them.",
"quoteAuthor": "Tom Krause"
}, {
"quoteText": "Transformation does not start with some one else changing you; transformation is an inner self reworking of what you are now to what you will be.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "From small beginnings come great things.",
"quoteAuthor": ""
}, {
"quoteText": "Kind words can be short and easy to speak, but their echoes are truly endless.",
"quoteAuthor": "Mother Teresa"
}, {
"quoteText": "Knowing your own darkness is the best method for dealing with the darknesses of other people.",
"quoteAuthor": "Carl Jung"
}, {
"quoteText": "I have an everyday religion that works for me. Love yourself first, and everything else falls into line.",
"quoteAuthor": "Lucille Ball"
}, {
"quoteText": "Well done is better than well said.",
"quoteAuthor": "Benjamin Franklin"
}, {
"quoteText": "Be sure you put your feet in the right place, then stand firm.",
"quoteAuthor": "Abraham Lincoln"
}, {
"quoteText": "Learn all you can from the mistakes of others. You won't have time to make them all yourself.",
"quoteAuthor": "Alfred Sheinwold"
}, {
"quoteText": "Flow with whatever is happening and let your mind be free. Stay centred by accepting whatever you are doing. This is the ultimate.",
"quoteAuthor": "Chuang Tzu"
}, {
"quoteText": "Nothing could be worse than the fear that one had given up too soon, and left one unexpended effort that might have saved the world.",
"quoteAuthor": "Jane Addams"
}, {
"quoteText": "I never worry about action, but only inaction.",
"quoteAuthor": "Winston Churchill"
}, {
"quoteText": "Respect is not something that you can ask for, buy or borrow. Respect is what you earn from each person no matter their background or status.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Change will not come if we wait for some other person or some other time. We are the ones weve been waiting for. We are the change that we seek.",
"quoteAuthor": "Barack Obama"
}, {
"quoteText": "The energy of the mind is the essence of life.",
"quoteAuthor": "Aristotle"
}, {
"quoteText": "We all have problems. The way we solve them is what makes us different.",
"quoteAuthor": ""
}, {
"quoteText": "The man who trusts men will make fewer mistakes than he who distrusts them.",
"quoteAuthor": "Cavour"
}, {
"quoteText": "Gratitude is not only the greatest of virtues, but the paren't of all the others.",
"quoteAuthor": "Cicero"
}, {
"quoteText": "To be happy is to be able to become aware of oneself without fright.",
"quoteAuthor": "Walter Benjamin"
}, {
"quoteText": "Failure will never overtake me if my determination to succeed is strong enough.",
"quoteAuthor": "Og Mandino"
}, {
"quoteText": "In skating over thin ice our safety is in our speed.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "I'm not interested in age. People who tell me their age are silly. You're as old as you feel.",
"quoteAuthor": "Elizabeth Arden"
}, {
"quoteText": "Kindness is the greatest wisdom.",
"quoteAuthor": ""
}, {
"quoteText": "To bring anything into your life, imagine that it's already there.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "What you give is what you get.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "The person who lives life fully, glowing with life's energy, is the person who lives a successful life.",
"quoteAuthor": "Daisaku Ikeda"
}, {
"quoteText": "We are what we repeatedly do. Excellence, then, is not an act, but a habit.",
"quoteAuthor": "Aristotle"
}, {
"quoteText": "Let us revere, let us worship, but erect and open-eyed, the highest, not the lowest; the future, not the past!",
"quoteAuthor": "Charlotte Gilman"
}, {
"quoteText": "The secret of success is constancy to purpose.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "Our intention creates our reality.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "With every experience, you alone are painting your own canvas, thought by thought, choice by choice.",
"quoteAuthor": "Oprah Winfrey"
}, {
"quoteText": "The best place to find a helping hand is at the end of your own arm.",
"quoteAuthor": ""
}, {
"quoteText": "Man cannot discover new oceans unless he has the courage to lose sight of the shore.",
"quoteAuthor": "Andr� Gide"
}, {
"quoteText": "Reviewing what you have learned and learning anew, you are fit to be a teacher.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Begin, be bold, and venture to be wise.",
"quoteAuthor": "Horace"
}, {
"quoteText": "The first step to getting the things you want out of life is this: decide what you want.",
"quoteAuthor": "Ben Stein"
}, {
"quoteText": "There are people who have money and people who are rich.",
"quoteAuthor": "Coco Chanel"
}, {
"quoteText": "While we stop to think, we often miss our opportunity.",
"quoteAuthor": "Publilius Syrus"
}, {
"quoteText": "The trouble with most people is that they think with their hopes or fears or wishes rather than with their minds.",
"quoteAuthor": "Will Durant"
}, {
"quoteText": "You only lose what you cling to.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "You give before you get.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Do good by stealth, and blush to find it fame.",
"quoteAuthor": "Alexander Pope"
}, {
"quoteText": "Opportunity often comes disguised in the form of misfortune, or temporary defeat.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Most great people have attained their greatest success just one step beyond their greatest failure.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "The weak can never forgive. Forgiveness is the attribute of the strong.",
"quoteAuthor": "Mohandas Gandhi"
}, {
"quoteText": "Success means having the courage, the determination, and the will to become the person you believe you were meant to be.",
"quoteAuthor": "George Sheehan"
}, {
"quoteText": "We are either progressing or retrograding all the while. There is no such thing as remaining stationary in this life.",
"quoteAuthor": "James Freeman Clarke"
}, {
"quoteText": "Action will remove the doubts that theory cannot solve.",
"quoteAuthor": "Tehyi Hsieh"
}, {
"quoteText": "Adversity isn't set against you to fail; adversity is a way to build your character so that you can succeed over and over again through perseverance.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Why worry about things you can�t control when you can keep yourself busy controlling the things that depend on you?",
"quoteAuthor": ""
}, {
"quoteText": "Spring is a time for rebirth and the fulfilment of new life.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "In the end we retain from our studies only that which we practically apply.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "Only do what your heart tells you.",
"quoteAuthor": "Princess Diana"
}, {
"quoteText": "Responsibility is not inherited, it is a choice that everyone needs to make at some point in their life.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "You cannot have what you do not want.",
"quoteAuthor": "John Acosta"
}, {
"quoteText": "Great acts are made up of small deeds.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "An optimist is a person who sees a green light everywhere, while the pessimist sees only the red spotlight... The truly wise person is colour-blind.",
"quoteAuthor": "Albert Schweitzer"
}, {
"quoteText": "Always seek out the seed of triumph in every adversity.",
"quoteAuthor": "Og Mandino"
}, {
"quoteText": "Give a man a fish and you feed him for a day. Teach him how to fish and you feed him for a lifetime.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "You must welcome change as the rule but not as your ruler.",
"quoteAuthor": "Denis Waitley"
}, {
"quoteText": "Allow the world to live as it chooses, and allow yourself to live as you choose.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "When you come to the end of your rope, tie a knot and hang on.",
"quoteAuthor": "Franklin Roosevelt"
}, {
"quoteText": "The more you care, the stronger you can be.",
"quoteAuthor": "Jim Rohn"
}, {
"quoteText": "Do not give your attention to what others do or fail to do; give it to what you do or fail to do.",
"quoteAuthor": "Dhammapada"
}, {
"quoteText": "Don't miss all the beautiful colors of the rainbow looking for that pot of gold.",
"quoteAuthor": ""
}, {
"quoteText": "If you love someone, set them free. If they come back they're yours; if they don't they never were.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "Don't be dismayed by good-byes. A farewell is necessary before you can meet again. And meeting again, after moments or lifetimes, is certain for those who are friends.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "Real magic in relationships means an absence of judgement of others.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "He who knows, does not speak. He who speaks, does not know.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "To accomplish great things, we must not only act, but also dream; not only plan, but also believe.",
"quoteAuthor": "Anatole France"
}, {
"quoteText": "When I dare to be powerful, to use my strength in the service of my vision, then it becomes less and less important whether I am afraid.",
"quoteAuthor": "Audre Lorde"
}, {
"quoteText": "Imagination is not a talent of some men but is the health of every man.",
"quoteAuthor": "Ralph Waldo Emerson"
}, {
"quoteText": "If the shoe doesn't fit, must we change the foot?",
"quoteAuthor": "Gloria Steinem"
}, {
"quoteText": "Through pride we are ever deceiving ourselves. But deep down below the surface of the average conscience a still, small voice says to us, Something is out of tune.",
"quoteAuthor": "Carl Jung"
}, {
"quoteText": "Strength does not come from physical capacity. It comes from an indomitable will.",
"quoteAuthor": "Mahatma Gandhi"
}, {
"quoteText": "To be upset over what you don't have is to waste what you do have.",
"quoteAuthor": "Ken S. Keyes"
}, {
"quoteText": "He that respects himself is safe from others; he wears a coat of mail that none can pierce.",
"quoteAuthor": "Henry Longfellow"
}, {
"quoteText": "It is better to travel well than to arrive.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "A dream is your creative vision for your life in the future. You must break out of your current comfort zone and become comfortable with the unfamiliar and the unknown.",
"quoteAuthor": "Denis Waitley"
}, {
"quoteText": "Nothing is softer or more flexible than water, yet nothing can resist it.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "A smile is a light in the window of your face to show your heart is at home.",
"quoteAuthor": ""
}, {
"quoteText": "Time you enjoyed wasting was not wasted.",
"quoteAuthor": "John Lennon"
}, {
"quoteText": "Give whatever you are doing and whoever you are with the gift of your attention.",
"quoteAuthor": "Jim Rohn"
}, {
"quoteText": "A wise man will make more opportunities than he finds.",
"quoteAuthor": "Francis Bacon"
}, {
"quoteText": "Always be yourself, express yourself, have faith in yourself, do not go out and look for a successful personality and duplicate it.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "If one advances confidently in the direction of his dream, and endeavours to live the life which he had imagines, he will meet with a success unexpected in common hours.",
"quoteAuthor": "Henry David Thoreau"
}, {
"quoteText": "Our kindness may be the most persuasive argument for that which we believe.",
"quoteAuthor": "Gordon Hinckley"
}, {
"quoteText": "To climb steep hills requires a slow pace at first.",
"quoteAuthor": "William Shakespeare"
}, {
"quoteText": "Talk doesn't cook rice.",
"quoteAuthor": "Chinese proverb"
}, {
"quoteText": "If you light a lamp for somebody, it will also brighten your path.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Everything you are against weakens you. Everything you are for empowers you.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "There is nothing so useless as doing efficiently that which should not be done at all.",
"quoteAuthor": "Peter Drucker"
}, {
"quoteText": "Everyone smiles in the same language.",
"quoteAuthor": ""
}, {
"quoteText": "A good rest is half the work.",
"quoteAuthor": ""
}, {
"quoteText": "God has given you one face, and you make yourself another.",
"quoteAuthor": "William Shakespeare"
}, {
"quoteText": "Not every difficult and dangerous thing is suitable for training, but only that which is conducive to success in achieving the object of our effort.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "Yesterday is history. Tomorrow is a mystery. And today? Today is a gift that's why they call it the present.",
"quoteAuthor": ""
}, {
"quoteText": "Your ability to learn faster than your competition is your only sustainable competitive advantage.",
"quoteAuthor": "Arie de Gues"
}, {
"quoteText": "When deeds speak, words are nothing.",
"quoteAuthor": "African proverb"
}, {
"quoteText": "The self is not something ready-made, but something in continuous formation through choice of action.",
"quoteAuthor": "John Dewey"
}, {
"quoteText": "If you love someone, set them free. If they come back they're yours; if they don't they never were.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "Trust your own instinct. Your mistakes might as well be your own, instead of someone elses.",
"quoteAuthor": "Billy Wilder"
}, {
"quoteText": "Only those who dare to fail greatly can ever achieve greatly.",
"quoteAuthor": "Robert Kennedy"
}, {
"quoteText": "Whatever we expect with confidence becomes our own self-fulfilling prophecy.",
"quoteAuthor": "Brian Tracy"
}, {
"quoteText": "Be the change that you want to see in the world.",
"quoteAuthor": "Mohandas Gandhi"
}, {
"quoteText": "Human beings, who are almost unique in having the ability to learn from the experience of others, are also remarkable for their apparent disinclination to do so.",
"quoteAuthor": "Douglas Adams"
}, {
"quoteText": "Smile, breathe, and go slowly.",
"quoteAuthor": "Thich Nhat Hanh"
}, {
"quoteText": "Consider how hard it is to change yourself and you'll understand what little chance you have in trying to change others.",
"quoteAuthor": "Jacob Braude"
}, {
"quoteText": "He that never changes his opinions, never corrects his mistakes, and will never be wiser on the morrow than he is today.",
"quoteAuthor": "Tryon Edwards"
}, {
"quoteText": "Life's challenges are not supposed to paralyze you, they're supposed to help you discover who you are.",
"quoteAuthor": "Bernice Reagon"
}, {
"quoteText": "Arriving at one point is the starting point to another.",
"quoteAuthor": "John Dewey"
}, {
"quoteText": "Character is like a tree and reputation like a shadow. The shadow is what we think of it; the tree is the real thing.",
"quoteAuthor": "Abraham Lincoln"
}, {
"quoteText": "Whoever is happy will make others happy, too.",
"quoteAuthor": "Mark Twain"
}, {
"quoteText": "The pessimist sees difficulty in every opportunity. The optimist sees the opportunity in every difficulty.",
"quoteAuthor": "Winston Churchill"
}, {
"quoteText": "Many people think of prosperity that concerns money only to forget that true prosperity is of the mind.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "The difficulties of life are intended to make us better, not bitter.",
"quoteAuthor": ""
}, {
"quoteText": "Slow down and enjoy life. It's not only the scenery you miss by going too fast � you also miss the sense of where you are going and why.",
"quoteAuthor": "Eddie Cantor"
}, {
"quoteText": "What the caterpillar calls the end of the world, the master calls a butterfly.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "When one tugs at a single thing in nature, he finds it attached to the rest of the world.",
"quoteAuthor": "John Muir"
}, {
"quoteText": "We can do no great things, only small things with great love.",
"quoteAuthor": "Mother Teresa"
}, {
"quoteText": "The most dangerous way to lose time is not to spend it having fun, but to spend it doing fake work. When you spend time having fun, you know you're being self-indulgent.",
"quoteAuthor": "Paul Graham"
}, {
"quoteText": "Let go of your attachment to being right, and suddenly your mind is more open. You're able to benefit from the unique viewpoints of others, without being crippled by your own judgement.",
"quoteAuthor": "Ralph Marston"
}, {
"quoteText": "Begin to weave and God will give you the thread.",
"quoteAuthor": "German proverb"
}, {
"quoteText": "Knowledge has three degrees � opinion, science, illumination. The means or instrument of the first is sense; of the second, dialectic; of the third, intuition.",
"quoteAuthor": "Plotinus"
}, {
"quoteText": "Impossibilities are merely things which we have not yet learned.",
"quoteAuthor": "Charles Chesnutt"
}, {
"quoteText": "Don't be pushed by your problems; be led by your dreams.",
"quoteAuthor": ""
}, {
"quoteText": "For every failure, there's an alternative course of action. You just have to find it. When you come to a roadblock, take a detour.",
"quoteAuthor": "Mary Kay Ash"
}, {
"quoteText": "To keep the body in good health is a duty... otherwise we shall not be able to keep our mind strong and clear.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Life is what happens while you are making other plans.",
"quoteAuthor": "John Lennon"
}, {
"quoteText": "Science is organized knowledge. Wisdom is organized life.",
"quoteAuthor": "Immanuel Kant"
}, {
"quoteText": "The greatest antidote to insecurity and the sense of fear is compassion � it brings one back to the basis of one's inner strength",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Courage is the discovery that you may not win, and trying when you know you can lose.",
"quoteAuthor": ""
}, {
"quoteText": "To know oneself is to study oneself in action with another person.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "Many people think of prosperity that concerns money only to forget that true prosperity is of the mind.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "When you are offended at any man's fault, turn to yourself and study your own failings. Then you will forget your anger.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "I seek constantly to improve my manners and graces, for they are the sugar to which all are attracted.",
"quoteAuthor": "Og Mandino"
}, {
"quoteText": "From error to error one discovers the entire truth.",
"quoteAuthor": "Sigmund Freud"
}, {
"quoteText": "We can only be said to be alive in those moments when our hearts are conscious of our treasures.",
"quoteAuthor": "Thornton Wilder"
}, {
"quoteText": "As we express our gratitude, we must never forget that the highest appreciation is not to utter words, but to live by them.",
"quoteAuthor": "John F. Kennedy"
}, {
"quoteText": "Faith in oneself is the best and safest course.",
"quoteAuthor": "Michelangelo"
}, {
"quoteText": "The minute you settle for less than you deserve, you get even less than you settled for.",
"quoteAuthor": "Maureen Dowd"
}, {
"quoteText": "All great achievements require time.",
"quoteAuthor": "Maya Angelou"
}, {
"quoteText": "Miracles come in moments. Be ready and willing.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "We could never learn to be brave and patient if there were only joy in the world.",
"quoteAuthor": "Helen Keller"
}, {
"quoteText": "One today is worth two tomorrows.",
"quoteAuthor": "Benjamin Franklin"
}, {
"quoteText": "Meditation is the dissolution of thoughts in eternal awareness or Pure consciousness without objectification, knowing without thinking, merging finitude in infinity.",
"quoteAuthor": "Voltaire"
}, {
"quoteText": "For every failure, there's an alternative course of action. You just have to find it. When you come to a roadblock, take a detour.",
"quoteAuthor": "Mary Kay Ash"
}, {
"quoteText": "Be a good listener. Your ears will never get you in trouble.",
"quoteAuthor": "Frank Tyger"
}, {
"quoteText": "If you kick a stone in anger, you'll hurt your own foot.",
"quoteAuthor": "Korean proverb"
}, {
"quoteText": "Never miss an opportunity to make others happy, even if you have to leave them alone in order to do it.",
"quoteAuthor": ""
}, {
"quoteText": "A stumble may prevent a fall.",
"quoteAuthor": ""
}, {
"quoteText": "Never regret. If it's good, it's wonderful. If it's bad, it's experience.",
"quoteAuthor": "Victoria Holt"
}, {
"quoteText": "Good luck is another name for tenacity of purpose.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Better than a thousand hollow words, is one word that brings peace.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Our greatness lies not so much in being able to remake the world as being able to remake ourselves.",
"quoteAuthor": "Mahatma Gandhi"
}, {
"quoteText": "The only thing to do with good advice is to pass it on. It is never of any use to oneself.",
"quoteAuthor": "Oscar Wilde"
}, {
"quoteText": "The way we communicate with others and with ourselves ultimately determines the quality of our lives.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "We should all be thankful for those people who rekindle the inner spirit.",
"quoteAuthor": "Albert Schweitzer"
}, {
"quoteText": "Skill to do comes of doing.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "The best place to find a helping hand is at the end of your own arm.",
"quoteAuthor": ""
}, {
"quoteText": "Meaning is not what you start with but what you end up with.",
"quoteAuthor": "Peter Elbow"
}, {
"quoteText": "Numberless are the worlds wonders, but none more wonderful than man.",
"quoteAuthor": "Sophocles"
}, {
"quoteText": "Either you run the day or the day runs you.",
"quoteAuthor": "Jim Rohn"
}, {
"quoteText": "No one saves us but ourselves. No one can and no one may. We ourselves must walk the path.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Don't judge each day by the harvest you reap but by the seeds you plant.",
"quoteAuthor": "Robert Stevenson"
}, {
"quoteText": "Once we accept our limits, we go beyond them.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "Formula for success: under promise and over deliver.",
"quoteAuthor": "Tom Peters"
}, {
"quoteText": "Every artist dips his brush in his own soul, and paints his own nature into his pictures.",
"quoteAuthor": "Henry Ward Beecher"
}, {
"quoteText": "If I am not for myself, who will be for me? If I am not for others, what am I? And if not now, when?",
"quoteAuthor": "Rabbi Hillel"
}, {
"quoteText": "Nothing in life is to be feared. It is only to be understood.",
"quoteAuthor": "Marie Curie"
}, {
"quoteText": "One who gains strength by overcoming obstacles possesses the only strength which can overcome adversity.",
"quoteAuthor": "Albert Schweitzer"
}, {
"quoteText": "Time you enjoy wasting, was not wasted.",
"quoteAuthor": "John Lennon"
}, {
"quoteText": "Life isn't about finding yourself. Life is about creating yourself.",
"quoteAuthor": "Bernard Shaw"
}, {
"quoteText": "In the depth of winter, I finally learned that there was within me an invincible summer.",
"quoteAuthor": "Albert Camus"
}, {
"quoteText": "Happiness cannot be travelled to, owned, earned, worn or consumed. Happiness is the spiritual experience of living every minute with love, grace and gratitude.",
"quoteAuthor": "Denis Waitley"
}, {
"quoteText": "The more you care, the stronger you can be.",
"quoteAuthor": "Jim Rohn"
}, {
"quoteText": "Failure doesn't mean you are a failure it just means you haven't succeeded yet.",
"quoteAuthor": "Robert Schuller"
}, {
"quoteText": "Sometimes the most important thing in a whole day is the rest we take between two deep breaths.",
"quoteAuthor": "Etty Hillesum"
}, {
"quoteText": "Life's challenges are not supposed to paralyze you, they're supposed to help you discover who you are.",
"quoteAuthor": "Bernice Reagon"
}, {
"quoteText": "With courage you will dare to take risks, have the strength to be compassionate, and the wisdom to be humble. Courage is the foundation of integrity.",
"quoteAuthor": "Keshavan Nair"
}, {
"quoteText": "To want to be what one can be is purpose in life.",
"quoteAuthor": "Cynthia Ozick"
}, {
"quoteText": "The important thing is this: to be able at any moment to sacrifice what we are for what we could become.",
"quoteAuthor": "Charles Dubois"
}, {
"quoteText": "Fortune befriends the bold.",
"quoteAuthor": "John Dryden"
}, {
"quoteText": "As we grow as unique persons, we learn to respect the uniqueness of others.",
"quoteAuthor": "Robert Schuller"
}, {
"quoteText": "Love is the master key that opens the gates of happiness.",
"quoteAuthor": "Oliver Holmes"
}, {
"quoteText": "So is cheerfulness, or a good temper, the more it is spent, the more remains.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Reality leaves a lot to the imagination.",
"quoteAuthor": "John Lennon"
}, {
"quoteText": "A man of ability and the desire to accomplish something can do anything.",
"quoteAuthor": "Donald Kircher"
}, {
"quoteText": "Everything in the universe goes by indirection. There are no straight lines.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "The greatest part of our happiness depends on our dispositions, not our circumstances.",
"quoteAuthor": "Martha Washington"
}, {
"quoteText": "You have to take it as it happens, but you should try to make it happen the way you want to take it.",
"quoteAuthor": "Old German proverb"
}, {
"quoteText": "I know but one freedom and that is the freedom of the mind.",
"quoteAuthor": "Antoine de Saint-Exupery"
}, {
"quoteText": "Change your words. Change your world.",
"quoteAuthor": ""
}, {
"quoteText": "The key to growth is the introduction of higher dimensions of consciousness into our awareness.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "The most successful people are those who are good at plan B.",
"quoteAuthor": "James Yorke"
}, {
"quoteText": "Luck is what happens when preparation meets opportunity.",
"quoteAuthor": "Seneca"
}, {
"quoteText": "The highest stage in moral ure at which we can arrive is when we recognize that we ought to control our thoughts.",
"quoteAuthor": "Charles Darwin"
}, {
"quoteText": "Staying in one place is the best path to be taken over and surpassed by many.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "The road leading to a goal does not separate you from the destination; it is essentially a part of it.",
"quoteAuthor": "Charles DeLint"
}, {
"quoteText": "A man should look for what is, and not for what he thinks should be.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "You are the only person on earth who can use your ability.",
"quoteAuthor": "Zig Ziglar"
}, {
"quoteText": "You are always free to change your mind and choose a different future, or a different past.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "One must be fond of people and trust them if one is not to make a mess of life.",
"quoteAuthor": "E. M. Forster"
}, {
"quoteText": "The true way to render ourselves happy is to love our work and find in it our pleasure.",
"quoteAuthor": "Francoise de Motteville"
}, {
"quoteText": "Fortune befriends the bold.",
"quoteAuthor": "John Dryden"
}, {
"quoteText": "Let the future tell the truth, and evaluate each one according to his work and accomplishments. The present is theirs; the future, for which I have really worked, is mine.",
"quoteAuthor": "Nikola Tesla"
}, {
"quoteText": "Worry gives a small thing a big shadow.",
"quoteAuthor": ""
}, {
"quoteText": "Those who are blessed with the most talent don't necessarily outperform everyone else. It's the people with follow-through who excel.",
"quoteAuthor": "Mary Kay Ash"
}, {
"quoteText": "An obstacle may be either a stepping stone or a stumbling block.",
"quoteAuthor": ""
}, {
"quoteText": "The weak can never forgive. Forgiveness is the attribute of the strong.",
"quoteAuthor": "Mohandas Gandhi"
}, {
"quoteText": "We cannot solve our problems with the same thinking we used when we created them.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "We can only be said to be alive in those moments when our hearts are conscious of our treasures.",
"quoteAuthor": "Thornton Wilder"
}, {
"quoteText": "I hear and I forget. I see and I remember. I do and I understand.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Men in general judge more from appearances than from reality. All men have eyes, but few have the gift of penetration.",
"quoteAuthor": "Niccolo Machiavelli"
}, {
"quoteText": "Difficulties are things that show a person what they are.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "Nature takes away any faculty that is not used.",
"quoteAuthor": "William R. Inge"
}, {
"quoteText": "It is not enough to have a good mind; the main thing is to use it well.",
"quoteAuthor": "Rene Descartes"
}, {
"quoteText": "Wit lies in recognizing the resemblance among things which differ and the difference between things which are alike.",
"quoteAuthor": "Madame de Stael"
}, {
"quoteText": "One secret of success in life is for a man to be ready for his opportunity when it comes.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "The secret of success is constancy to purpose.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "To succeed, we must first believe that we can.",
"quoteAuthor": "Michael Korda"
}, {
"quoteText": "When you judge another, you do not define them, you define yourself.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Be thankful when you don't know something for it gives you the opportunity to learn.",
"quoteAuthor": ""
}, {
"quoteText": "Any of us can achieve virtue, if by virtue we merely mean the avoidance of the vices that do not attract us.",
"quoteAuthor": "Robert Lynd"
}, {
"quoteText": "If you don't go after what you want, you'll never have it. If you don't ask, the answer is always no. If you don't step forward, you're always in the same place.",
"quoteAuthor": "Nora Roberts"
}, {
"quoteText": "When you arise in the morning, think of what a precious privilege it is to be alive � to breathe, to think, to enjoy, to love.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "The greatest danger for most of us is not that our aim is too high and we miss it, but that it is too low and we reach it.",
"quoteAuthor": "Michelangelo"
}, {
"quoteText": "Imagination is more important than knowledge. For while knowledge defines all we currently know and understand, imagination points to all we might yet discover and create.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "A subtle thought that is in error may yet give rise to fruitful inquiry that can establish truths of great value.",
"quoteAuthor": "Isaac Asimov"
}, {
"quoteText": "You give before you get.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Make the most of yourself for that is all there is of you.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Those who are free of resentful thoughts surely find peace.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Think for yourselves and let others enjoy the privilege to do so too.",
"quoteAuthor": "Voltaire"
}, {
"quoteText": "If you propose to speak, always ask yourself, is it true, is it necessary, is it kind.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "The journey of a thousand miles begins with one step.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "The least of things with a meaning is worth more in life than the greatest of things without it.",
"quoteAuthor": "Carl Jung"
}, {
"quoteText": "The only way to tell the truth is to speak with kindness. Only the words of a loving man can be heard.",
"quoteAuthor": "Henry Thoreau"
}, {
"quoteText": "Constant kindness can accomplish much. As the sun makes ice melt, kindness causes misunderstanding, mistrust, and hostility to evaporate.",
"quoteAuthor": "Albert Schweitzer"
}, {
"quoteText": "You block your dream when you allow your fear to grow bigger than your faith.",
"quoteAuthor": "Mary Morrissey"
}, {
"quoteText": "I never worry about action, but only inaction.",
"quoteAuthor": "Winston Churchill"
}, {
"quoteText": "The final proof of greatness lies in being able to endure criticism without resentment.",
"quoteAuthor": "Elbert Hubbard"
}, {
"quoteText": "Take it easy � but take it.",
"quoteAuthor": "Woody Guthrie"
}, {
"quoteText": "If you want a thing done well, do it yourself.",
"quoteAuthor": "Napoleon Bonaparte"
}, {
"quoteText": "The past has no power to stop you from being present now. Only your grievance about the past can do that.",
"quoteAuthor": "Eckhart Tolle"
}, {
"quoteText": "Aim for success, not perfection. Never give up your right to be wrong, because then you will lose the ability to learn new things and move forward with your life.",
"quoteAuthor": "Dr. David M. Burns"
}, {
"quoteText": "We are not animals. We are not a product of what has happened to us in our past. We have the power of choice.",
"quoteAuthor": "Stephen Covey"
}, {
"quoteText": "Don't leave a stone unturned. It's always something, to know you have done the most you could.",
"quoteAuthor": "Charles Dickens"
}, {
"quoteText": "Yesterday is history. Tomorrow is a mystery. And today? Today is a gift that's why they call it the present.",
"quoteAuthor": ""
}, {
"quoteText": "Argue for your limitations, and sure enough they're yours.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "If you look into your own heart, and you find nothing wrong there, what is there to worry about? What is there to fear?",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Every person, all the events of your life are there because you have drawn them there. What you choose to do with them is up to you.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "He who deliberates fully before taking a step will spend his entire life on one leg.",
"quoteAuthor": "Chinese proverb"
}, {
"quoteText": "Wisdom is the supreme part of happiness.",
"quoteAuthor": "Sophocles"
}, {
"quoteText": "Every problem has a gift for you in its hands.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "A good plan today is better than a perfect plan tomorrow.",
"quoteAuthor": ""
}, {
"quoteText": "If you have knowledge, let others light their candles in it.",
"quoteAuthor": "Margaret Fuller"
}, {
"quoteText": "The grand essentials of happiness are: something to do, something to love, and something to hope for.",
"quoteAuthor": "Chalmers"
}, {
"quoteText": "A stumble may prevent a fall.",
"quoteAuthor": ""
}, {
"quoteText": "He who wishes to secure the good of others, has already secured his own.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "It is not enough to have a good mind; the main thing is to use it well.",
"quoteAuthor": "Rene Descartes"
}, {
"quoteText": "We are all faced with a series of great opportunities brilliantly disguised as impossible situations.",
"quoteAuthor": "Charles R. Swindoll"
}, {
"quoteText": "We aim above the mark to hit the mark.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Whenever something negative happens to you, there is a deep lesson concealed within it.",
"quoteAuthor": "Eckhart Tolle"
}, {
"quoteText": "I think somehow we learn who we really are and then live with that decision.",
"quoteAuthor": "Eleanor Roosevelt"
}, {
"quoteText": "To give ones self earnestly to the duties due to men, and, while respecting spiritual beings, to keep aloof from them, may be called wisdom.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Good timber does not grow with ease; the stronger the wind, the stronger the trees.",
"quoteAuthor": "J. Willard Marriott"
}, {
"quoteText": "Your friends will know you better in the first minute you meet than your acquaintances will know you in a thousand years.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "If one is lucky, a solitary fantasy can totally transform one million realities.",
"quoteAuthor": "Maya Angelou"
}, {
"quoteText": "Always bear in mind that your own resolution to succeed is more important than any one thing.",
"quoteAuthor": "Abraham Lincoln"
}, {
"quoteText": "Friendship isn't a big thing. It's a million little things.",
"quoteAuthor": ""
}, {
"quoteText": "Wise men talk because they have something to say; fools, because they have to say something.",
"quoteAuthor": "Plato"
}, {
"quoteText": "We don't stop playing because we grow old; we grow old because we stop playing.",
"quoteAuthor": "Bernard Shaw"
}, {
"quoteText": "The time you think you're missing, misses you too.",
"quoteAuthor": "Ymber Delecto"
}, {
"quoteText": "The thought manifests as the word. The word manifests as the deed. The deed develops into habit. And the habit hardens into character.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Money was never a big motivation for me, except as a way to keep score. The real excitement is playing the game.",
"quoteAuthor": "Donald Trump"
}, {
"quoteText": "There are two primary choices in life: to accept conditions as they exist, or accept the responsibility for changing them.",
"quoteAuthor": "Denis Waitley"
}, {
"quoteText": "To climb steep hills requires a slow pace at first.",
"quoteAuthor": "William Shakespeare"
}, {
"quoteText": "If the shoe doesn't fit, must we change the foot?",
"quoteAuthor": "Gloria Steinem"
}, {
"quoteText": "There is no duty we so underrate as the duty of being happy. By being happy we sow anonymous benefits upon the world.",
"quoteAuthor": "Robert Louis Stevenson"
}, {
"quoteText": "You have enemies? Good. That means you've stood up for something, sometime in your life.",
"quoteAuthor": "Winston Churchill"
}, {
"quoteText": "Life is really simple, but we insist on making it complicated.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Nobody made a greater mistake than he who did nothing because he could do only a little.",
"quoteAuthor": "Edmund Burke"
}, {
"quoteText": "Action will remove the doubts that theory cannot solve.",
"quoteAuthor": "Tehyi Hsieh"
}, {
"quoteText": "The universe is made of stories, not atoms.",
"quoteAuthor": "Muriel Rukeyser"
}, {
"quoteText": "With courage you will dare to take risks, have the strength to be compassionate, and the wisdom to be humble. Courage is the foundation of integrity.",
"quoteAuthor": "Keshavan Nair"
}, {
"quoteText": "A man is not where he lives but where he loves.",
"quoteAuthor": ""
}, {
"quoteText": "You can't shake hands with a clenched fist.",
"quoteAuthor": "Indira Gandhi"
}, {
"quoteText": "The future is an opaque mirror. Anyone who tries to look into it sees nothing but the dim outlines of an old and worried face.",
"quoteAuthor": "Jim Bishop"
}, {
"quoteText": "Sometimes the most important thing in a whole day is the rest we take between two deep breaths.",
"quoteAuthor": "Etty Hillesum"
}, {
"quoteText": "Everything that irritates us about others can lead us to a better understanding of ourselves.",
"quoteAuthor": "Carl Jung"
}, {
"quoteText": "Great acts are made up of small deeds.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Many people have gone further than they thought they could because someone else thought they could.",
"quoteAuthor": ""
}, {
"quoteText": "The truth which has made us free will in the end make us glad also.",
"quoteAuthor": "Felix Adler"
}, {
"quoteText": "He who lives in harmony with himself lives in harmony with the universe.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "Yesterday is history. Tomorrow is a mystery. And today? Today is a gift that's why they call it the present.",
"quoteAuthor": ""
}, {
"quoteText": "Kind words do not cost much. Yet they accomplish much.",
"quoteAuthor": "Blaise Pascal"
}, {
"quoteText": "We do not quit playing because we grow old, we grow old because we quit playing.",
"quoteAuthor": "Oliver Holmes"
}, {
"quoteText": "We do not quit playing because we grow old, we grow old because we quit playing.",
"quoteAuthor": "Oliver Holmes"
}, {
"quoteText": "Take rest; a field that has rested gives a bountiful crop.",
"quoteAuthor": "Ovid"
}, {
"quoteText": "Doing what you love is the cornerstone of having abundance in your life.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Action may not always bring happiness; but there is no happiness without action.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "The years teach much which the days never know.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Without some goals and some efforts to reach it, no man can live.",
"quoteAuthor": "John Dewey"
}, {
"quoteText": "Positive thinking will let you do everything better than negative thinking will.",
"quoteAuthor": "Zig Ziglar"
}, {
"quoteText": "No pessimist ever discovered the secrets of the stars, or sailed to an uncharted land, or opened a new heaven to the human spirit.",
"quoteAuthor": "Helen Keller"
}, {
"quoteText": "Do not dwell in the past, do not dream of the future, concentrate the mind on the present moment.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "We must not allow ourselves to become like the system we oppose.",
"quoteAuthor": "Bishop Desmond Tutu"
}, {
"quoteText": "Friends are those rare people who ask how we are and then wait to hear the answer.",
"quoteAuthor": "Ed Cunningham"
}, {
"quoteText": "The most formidable weapon against errors of every kind is reason.",
"quoteAuthor": "Thomas Paine"
}, {
"quoteText": "I am always doing that which I can not do, in order that I may learn how to do it.",
"quoteAuthor": "Pablo Picasso"
}, {
"quoteText": "In order to win, you must expect to win.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "Why compare yourself with others? No one in the entire world can do a better job of being you than you.",
"quoteAuthor": ""
}, {
"quoteText": "Learn to listen. Opportunity could be knocking at your door very softly.",
"quoteAuthor": "Frank Tyger"
}, {
"quoteText": "Never say there is nothing beautiful in the world any more. There is always something to make you wonder in the shape of a tree, the trembling of a leaf.",
"quoteAuthor": "Albert Schweitzer"
}, {
"quoteText": "A weed is no more than a flower in disguise.",
"quoteAuthor": "James Lowell"
}, {
"quoteText": "Treat people as if they were what they ought to be and you help them to become what they are capable of being.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "Anyone who doesn't take truth seriously in small matters cannot be trusted in large ones either.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "Mediocrity knows nothing higher than itself, but talent instantly recognizes genius.",
"quoteAuthor": "Arthur Conan Doyle"
}, {
"quoteText": "Beware of the half truth. You may have gotten hold of the wrong half.",
"quoteAuthor": ""
}, {
"quoteText": "At the center of your being you have the answer; you know who you are and you know what you want.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Imagination rules the world.",
"quoteAuthor": "Napoleon Bonaparte"
}, {
"quoteText": "The only real mistake is the one from which we learn nothing.",
"quoteAuthor": "John Powell"
}, {
"quoteText": "Most folks are about as happy as they make up their minds to be.",
"quoteAuthor": "Abraham Lincoln"
}, {
"quoteText": "If you can't feed a hundred people, then feed just one.",
"quoteAuthor": "Mother Teresa"
}, {
"quoteText": "The heart has its reasons which reason knows not of.",
"quoteAuthor": "Blaise Pascal"
}, {
"quoteText": "Sincerity is the way of Heaven. The attainment of sincerity is the way of men.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Be as you wish to seem.",
"quoteAuthor": "Socrates"
}, {
"quoteText": "The greatest mistake you can make in life is to be continually fearing you will make one.",
"quoteAuthor": "Elbert Hubbard"
}, {
"quoteText": "A leader is best when people barely know he exists, when his work is done, his aim fulfilled, they will say: we did it ourselves.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Wicked people are always surprised to find ability in those that are good.",
"quoteAuthor": "Marquis Vauvenargues"
}, {
"quoteText": "Do what you can. Want what you have. Be who you are.",
"quoteAuthor": "Forrest Church"
}, {
"quoteText": "The less effort, the faster and more powerful you will be.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "The free man is he who does not fear to go to the end of his thought.",
"quoteAuthor": "Leon Blum"
}, {
"quoteText": "People seldom notice old clothes if you wear a big smile.",
"quoteAuthor": "Lee Mildon"
}, {
"quoteText": "Rainbows apologize for angry skies.",
"quoteAuthor": "Sylvia Voirol"
}, {
"quoteText": "People may doubt what you say, but they will believe what you do.",
"quoteAuthor": "Lewis Cass"
}, {
"quoteText": "All perceiving is also thinking, all reasoning is also intuition, all observation is also invention.",
"quoteAuthor": "Rudolf Arnheim"
}, {
"quoteText": "Never idealize others. They will never live up to your expectations.",
"quoteAuthor": "Leo Buscaglia"
}, {
"quoteText": "Iron rusts from disuse; water loses its purity from stagnation... even so does inaction sap the vigour of the mind.",
"quoteAuthor": "Leonardo da Vinci"
}, {
"quoteText": "No act of kindness, no matter how small, is ever wasted.",
"quoteAuthor": "Aesop"
}, {
"quoteText": "The best cure for the body is a quiet mind.",
"quoteAuthor": "Napoleon Bonaparte"
}, {
"quoteText": "Listen to your intuition. It will tell you everything you need to know.",
"quoteAuthor": "Anthony D'Angelo"
}, {
"quoteText": "Do not be embarrassed by your mistakes. Nothing can teach us better than our understanding of them. This is one of the best ways of self-education.",
"quoteAuthor": "Thomas Carlyle"
}, {
"quoteText": "Nothing is softer or more flexible than water, yet nothing can resist it.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "What the caterpillar calls the end of the world, the master calls a butterfly.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "I am of the opinion that my life belongs to the community, and as long as I live it is my privilege to do for it whatever I can.",
"quoteAuthor": "Bernard Shaw"
}, {
"quoteText": "Translation is the paradigm, the exemplar of all writing. It is translation that demonstrates most vividly the yearning for transformation that underlies every act involving speech, that supremely human gift.",
"quoteAuthor": "Harry Burchell Mathews"
}, {
"quoteText": "The right way is not always the popular and easy way. Standing for right when it is unpopular is a true test of moral character.",
"quoteAuthor": "Margaret Smith"
}, {
"quoteText": "The past has no power to stop you from being present now. Only your grievance about the past can do that.",
"quoteAuthor": "Eckhart Tolle"
}, {
"quoteText": "A really great talent finds its happiness in execution.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "Take things as they are. Punch when you have to punch. Kick when you have to kick.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "Promises are the uniquely human way of ordering the future, making it predictable and reliable to the extent that this is humanly possible.",
"quoteAuthor": "Hannah Arendt"
}, {
"quoteText": "If you can dream it, you can do it.",
"quoteAuthor": "Walt Disney"
}, {
"quoteText": "The key to transforming our hearts and minds is to have an understanding of how our thoughts and emotions work.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Men of perverse opinion do not know the excellence of what is in their hands, till some one dash it from them.",
"quoteAuthor": "Sophocles"
}, {
"quoteText": "Let us revere, let us worship, but erect and open-eyed, the highest, not the lowest; the future, not the past!",
"quoteAuthor": "Charlotte Gilman"
}, {
"quoteText": "In the depth of winter, I finally learned that there was within me an invincible summer.",
"quoteAuthor": "Albert Camus"
}, {
"quoteText": "If A is success in life, then A equals x plus y plus z. Work is x; y is play; and z is keeping your mouth shut.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "A man sees in the world what he carries in his heart.",
"quoteAuthor": "Goethe"
}, {
"quoteText": "As we risk ourselves, we grow. Each new experience is a risk.",
"quoteAuthor": "Fran Watson"
}, {
"quoteText": "I have never been hurt by anything I didn't say.",
"quoteAuthor": "Calvin Coolidge"
}, {
"quoteText": "The dream was always running ahead of me. To catch up, to live for a moment in unison with it, that was the miracle.",
"quoteAuthor": "Anais Nin"
}, {
"quoteText": "Real success is finding your lifework in the work that you love.",
"quoteAuthor": "David McCullough"
}, {
"quoteText": "The most beautiful things in the world cannot be seen or even touched. They must be felt with the heart.",
"quoteAuthor": "Helen Keller"
}, {
"quoteText": "Opportunity often comes disguised in the form of misfortune, or temporary defeat.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Be not angry that you cannot make others as you wish them to be, since you cannot make yourself as you wish to be.",
"quoteAuthor": "Thomas Kempis"
}, {
"quoteText": "Nothing is predestined: The obstacles of your past can become the gateways that lead to new beginnings.",
"quoteAuthor": "Ralph Blum"
}, {
"quoteText": "Appreciation is the highest form of prayer, for it acknowledges the presence of good wherever you shine the light of your thankful thoughts.",
"quoteAuthor": "Alan Cohen"
}, {
"quoteText": "Sadness flies away on the wings of time.",
"quoteAuthor": "Jean de la Fontaine"
}, {
"quoteText": "Man cannot discover new oceans unless he has the courage to lose sight of the shore.",
"quoteAuthor": "Andr� Gide"
}, {
"quoteText": "Why worry about tomorrow, when today is all we have?",
"quoteAuthor": ""
}, {
"quoteText": "As you think, so shall you become.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "Kind words can be short and easy to speak, but their echoes are truly endless.",
"quoteAuthor": "Mother Teresa"
}, {
"quoteText": "Most smiles are started by another smile.",
"quoteAuthor": ""
}, {
"quoteText": "You can't create in a vacuum. Life gives you the material and dreams can propel new beginnings.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Cherish your visions and your dreams as they are the children of your soul; the blueprints of your ultimate achievements.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "A man who doesn't trust himself can never really trust anyone else.",
"quoteAuthor": "Cardinal Retz"
}, {
"quoteText": "Adversity causes some men to break, others to break records.",
"quoteAuthor": "William Ward"
}, {
"quoteText": "When your desires are strong enough you will appear to possess superhuman powers to achieve.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Just trust yourself, then you will know how to live.",
"quoteAuthor": "Goethe"
}, {
"quoteText": "Whenever something negative happens to you, there is a deep lesson concealed within it.",
"quoteAuthor": "Eckhart Tolle"
}, {
"quoteText": "It is with words as with sunbeams. The more they are condensed, the deeper they burn.",
"quoteAuthor": "Robert Southey"
}, {
"quoteText": "It is the mark of an educated mind to be able to entertain a thought without accepting it.",
"quoteAuthor": "Aristotle"
}, {
"quoteText": "The greatest mistake you can make in life is to be continually fearing you will make one.",
"quoteAuthor": "Elbert Hubbard"
}, {
"quoteText": "A short saying oft contains much wisdom.",
"quoteAuthor": "Sophocles"
}, {
"quoteText": "The superior man is modest in his speech, but exceeds in his actions.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Our deepest wishes are whispers of our authentic selves. We must learn to respect them. We must learn to listen.",
"quoteAuthor": "Sarah Breathnach"
}, {
"quoteText": "I will not be concerned at other men is not knowing me;I will be concerned at my own want of ability.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Your work is to discover your world and then with all your heart give yourself to it.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Very little is needed to make a happy life; it is all within yourself, in your way of thinking.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "Change your words. Change your world.",
"quoteAuthor": ""
}, {
"quoteText": "Take it easy � but take it.",
"quoteAuthor": "Woody Guthrie"
}, {
"quoteText": "Every adversity, every failure, every heartache carries with it the seed of an equal or greater benefit.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "The universe is transformation; our life is what our thoughts make it.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "Be your own hero, it's cheaper than a movie ticket.",
"quoteAuthor": "Doug Horton"
}, {
"quoteText": "The Superior Man is aware of Righteousness, the inferior man is aware of advantage.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Gratitude is not only the greatest of virtues, but the paren't of all the others.",
"quoteAuthor": "Cicero"
}, {
"quoteText": "Goals are the fuel in the furnace of achievement.",
"quoteAuthor": "Brian Tracy"
}, {
"quoteText": "You are the only person on Earth who can use your ability.",
"quoteAuthor": "Zig Ziglar"
}, {
"quoteText": "They say that time changes things, but you actually have to change them yourself.",
"quoteAuthor": "Andy Warhol"
}, {
"quoteText": "A true friend is the most precious of all possessions and the one we take the least thought about acquiring.",
"quoteAuthor": "Francois de La Rochefoucauld"
}, {
"quoteText": "We are what we think. All that we are arises with our thoughts. With our thoughts, we make the world.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Courage is what it takes to stand up and speak; courage is also what it takes to sit down and listen.",
"quoteAuthor": "Winston Churchill"
}, {
"quoteText": "A man of ability and the desire to accomplish something can do anything.",
"quoteAuthor": "Donald Kircher"
}, {
"quoteText": "If you seek truth you will not seek victory by dishonourable means, and if you find truth you will become invincible.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "Reason and free inquiry are the only effectual agents against error.",
"quoteAuthor": "Thomas Jefferson"
}, {
"quoteText": "The best teacher is experience learned from failures.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Everyone should carefully observe which way his heart draws him, and then choose that way with all his strength.",
"quoteAuthor": "Hasidic saying"
}, {
"quoteText": "Every great dream begins with a dreamer. Always remember, you have within you the strength, the patience, and the passion to reach for the stars to change the world.",
"quoteAuthor": "Harriet Tubman"
}, {
"quoteText": "Never miss an opportunity to make others happy, even if you have to leave them alone in order to do it.",
"quoteAuthor": ""
}, {
"quoteText": "A smile is a light in the window of your face to show your heart is at home.",
"quoteAuthor": ""
}, {
"quoteText": "I have just three things to teach: simplicity, patience, compassion. These three are your greatest treasures.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "An invincible determination can accomplish almost anything and in this lies the great distinction between great men and little men.",
"quoteAuthor": "Thomas Fuller"
}, {
"quoteText": "All that we are is the result of what we have thought. The mind is everything. What we think we become.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "A lot of people give up just before theyre about to make it. You know you never know when that next obstacle is going to be the last one.",
"quoteAuthor": "Chuck Norris"
}, {
"quoteText": "If you are going to achieve excellence in big things, you develop the habit in little matters. Excellence is not an exception, it is a prevailing attitude.",
"quoteAuthor": "Colin Powell"
}, {
"quoteText": "People may doubt what you say, but they will believe what you do.",
"quoteAuthor": "Lewis Cass"
}, {
"quoteText": "A bend in the road is not the end of the road...unless you fail to make the turn.",
"quoteAuthor": ""
}, {
"quoteText": "When you judge another, you do not define them, you define yourself.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Strength does not come from physical capacity. It comes from an indomitable will.",
"quoteAuthor": "Mahatma Gandhi"
}, {
"quoteText": "The universe is full of magical things, patiently waiting for our wits to grow sharper.",
"quoteAuthor": "Eden Phillpotts"
}, {
"quoteText": "Speak low, if you speak love.",
"quoteAuthor": "William Shakespeare"
}, {
"quoteText": "The industrial landscape is already littered with remains of once successful companies that could not adapt their strategic vision to altered conditions of competition.",
"quoteAuthor": "Abernathy"
}, {
"quoteText": "We must not allow ourselves to become like the system we oppose.",
"quoteAuthor": "Bishop Desmond Tutu"
}, {
"quoteText": "Change your thoughts, change your life!",
"quoteAuthor": ""
}, {
"quoteText": "When performance exceeds ambition, the overlap is called success.",
"quoteAuthor": "Cullen Hightower"
}, {
"quoteText": "To fly, we have to have resistance.",
"quoteAuthor": "Maya Lin"
}, {
"quoteText": "To be thoughtful and kind only takes a few seconds compared to the timeless hurt caused by one rude gesture.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "All our knowledge has its origins in our perceptions.",
"quoteAuthor": "Leonardo da Vinci"
}, {
"quoteText": "Gratitude is the fairest blossom which springs from the soul.",
"quoteAuthor": "Henry Beecher"
}, {
"quoteText": "A good rest is half the work.",
"quoteAuthor": ""
}, {
"quoteText": "Tension is who you think you should be. Relaxation is who you are.",
"quoteAuthor": "Chinese proverb"
}, {
"quoteText": "Anything you really want, you can attain, if you really go after it.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "A leader or a man of action in a crisis almost always acts subconsciously and then thinks of the reasons for his action.",
"quoteAuthor": "Jawaharlal Nehru"
}, {
"quoteText": "Thousands of candles can be lit from a single, and the life of the candle will not be shortened. Happiness never decreases by being shared.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Let the beauty of what you love be what you do.",
"quoteAuthor": "Rumi"
}, {
"quoteText": "Ask yourself the secret of your success. Listen to your answer, and practice it.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "The truth which has made us free will in the end make us glad also.",
"quoteAuthor": "Felix Adler"
}, {
"quoteText": "Chaos is inherent in all compounded things. Strive on with diligence.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Action is the foundational key to all success.",
"quoteAuthor": "Pablo Picasso"
}, {
"quoteText": "We must not say every mistake is a foolish one.",
"quoteAuthor": "Cicero"
}, {
"quoteText": "Ability will never catch up with the demand for it.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "I want you to be everything that's you, deep at the center of your being.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Love is the master key that opens the gates of happiness.",
"quoteAuthor": "Oliver Holmes"
}, {
"quoteText": "From error to error one discovers the entire truth.",
"quoteAuthor": "Sigmund Freud"
}, {
"quoteText": "It isn't where you come from, it's where you're going that counts.",
"quoteAuthor": "Ella Fitzgerald"
}, {
"quoteText": "Speak when you are angry and you will make the best speech you will ever regret.",
"quoteAuthor": "Ambrose Bierce"
}, {
"quoteText": "A thing long expected takes the form of the unexpected when at last it comes.",
"quoteAuthor": "Mark Twain"
}, {
"quoteText": "I know but one freedom and that is the freedom of the mind.",
"quoteAuthor": "Antoine de Saint-Exupery"
}, {
"quoteText": "The only difference between your abilities and others is the ability to put yourself in their shoes and actually try.",
"quoteAuthor": "Leonardo Ruiz"
}, {
"quoteText": "Our strength grows out of our weaknesses.",
"quoteAuthor": "Ralph Waldo Emerson"
}, {
"quoteText": "You teach best what you most need to learn.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "As we grow as unique persons, we learn to respect the uniqueness of others.",
"quoteAuthor": "Robert Schuller"
}, {
"quoteText": "If I am not for myself, who will be for me? If I am not for others, what am I? And if not now, when?",
"quoteAuthor": "Rabbi Hillel"
}, {
"quoteText": "Man cannot discover new oceans unless he has the courage to lose sight of the shore.",
"quoteAuthor": "Andr� Gide"
}, {
"quoteText": "In separateness lies the world's great misery, in compassion lies the world's true strength.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "If you can't explain it simply, you don't understand it well enough.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "Most smiles are started by another smile.",
"quoteAuthor": ""
}, {
"quoteText": "Example has more followers than reason.",
"quoteAuthor": "Christian Bovee"
}, {
"quoteText": "Happiness does not come from having much, but from being attached to little.",
"quoteAuthor": "Cheng Yen"
}, {
"quoteText": "You must train your intuition � you must trust the small voice inside you which tells you exactly what to say, what to decide.",
"quoteAuthor": "Ingrid Bergman"
}, {
"quoteText": "Time changes everything except something within us which is always surprised by change.",
"quoteAuthor": "Thomas Hardy"
}, {
"quoteText": "Nothing is so strong as gentleness. Nothing is so gentle as real strength.",
"quoteAuthor": "Frances de Sales"
}, {
"quoteText": "Blessed is the man who expects nothing, for he shall never be disappointed.",
"quoteAuthor": "Alexander Pope"
}, {
"quoteText": "The real measure of your wealth is how much youd be worth if you lost all your money.",
"quoteAuthor": ""
}, {
"quoteText": "Trust your hunches. They're usually based on facts filed away just below the conscious level.",
"quoteAuthor": "Joyce Brothers"
}, {
"quoteText": "Wherever a man turns he can find someone who needs him.",
"quoteAuthor": "Albert Schweitzer"
}, {
"quoteText": "The universe is full of magical things, patiently waiting for our wits to grow sharper.",
"quoteAuthor": "Eden Phillpotts"
}, {
"quoteText": "Never tell me the sky�s the limit when there are footprints on the moon.",
"quoteAuthor": ""
}, {
"quoteText": "Be kind whenever possible. It is always possible.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Don't wait for your feelings to change to take the action. Take the action and your feelings will change.",
"quoteAuthor": "Barbara Baron"
}, {
"quoteText": "It is impossible for a man to learn what he thinks he already knows.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "Success is getting what you want. Happiness is wanting what you get.",
"quoteAuthor": "Dale Carnegie"
}, {
"quoteText": "One that desires to excel should endeavour in those things that are in themselves most excellent.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "If you have made mistakes, there is always another chance for you. You may have a fresh start any moment you choose.",
"quoteAuthor": "Mary Pickford"
}, {
"quoteText": "The greatest mistake you can make in life is to be continually fearing you will make one.",
"quoteAuthor": "Elbert Hubbard"
}, {
"quoteText": "Imagination is the living power and prime agent of all human perception.",
"quoteAuthor": "Samuel Taylor Coleridge"
}, {
"quoteText": "My mama always said: life's like a box of chocolate � you never know what you gonna get.",
"quoteAuthor": "Forrest Gump"
}, {
"quoteText": "The only Zen you find on the tops of mountains is the Zen you bring up there.",
"quoteAuthor": "Robert Pirsig"
}, {
"quoteText": "Yeah we all shine on, like the moon, and the stars, and the sun.",
"quoteAuthor": "John Lennon"
}, {
"quoteText": "The thing always happens that you really believe in; and the belief in a thing makes it happen.",
"quoteAuthor": "Frank Wright"
}, {
"quoteText": "Nature gave us one tongue and two ears so we could hear twice as much as we speak.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "The only limit to our realization of tomorrow will be our doubts of today.",
"quoteAuthor": "Franklin Roosevelt"
}, {
"quoteText": "Appreciation can make a day, even change a life. Your willingness to put it into words is all that is necessary.",
"quoteAuthor": "Margaret Cousins"
}, {
"quoteText": "A person who never made a mistake never tried anything new.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "When you are content to be simply yourself and don't compare or compete, everybody will respect you.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "There is no way to prosperity, prosperity is the way.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "We are not animals. We are not a product of what has happened to us in our past. We have the power of choice.",
"quoteAuthor": "Stephen Covey"
}, {
"quoteText": "Life is not measured by the breaths you take, but by its breathtaking moments.",
"quoteAuthor": "Michael Vance"
}, {
"quoteText": "If I know what love is, it is because of you.",
"quoteAuthor": "Hermann Hesse"
}, {
"quoteText": "The less effort, the faster and more powerful you will be.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "Every new day is another chance to change your life.",
"quoteAuthor": ""
}, {
"quoteText": "To keep the body in good health is a duty... otherwise we shall not be able to keep our mind strong and clear.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "It isn't where you come from, it's where you're going that counts.",
"quoteAuthor": "Ella Fitzgerald"
}, {
"quoteText": "The winner ain't the one with the fastest car it's the one who refuses to lose.",
"quoteAuthor": "Dale Earnhardt"
}, {
"quoteText": "Talk doesn't cook rice.",
"quoteAuthor": "Chinese proverb"
}, {
"quoteText": "To be thoughtful and kind only takes a few seconds compared to the timeless hurt caused by one rude gesture.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Prejudice is a burden that confuses the past, threatens the future and renders the present inaccessible.",
"quoteAuthor": "Maya Angelou"
}, {
"quoteText": "Gratitude is riches. Complaint is poverty.",
"quoteAuthor": "Doris Day"
}, {
"quoteText": "One must be fond of people and trust them if one is not to make a mess of life.",
"quoteAuthor": "E. M. Forster"
}, {
"quoteText": "Rather than wishing for change, you first must be prepared to change.",
"quoteAuthor": "Catherine Pulsifer"
}, {
"quoteText": "Setting goals is the first step in turning the invisible into the visible.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "For everything that lives is holy, life delights in life.",
"quoteAuthor": "William Blake"
}, {
"quoteText": "By accepting yourself and being fully what you are, your presence can make others happy.",
"quoteAuthor": "Jane Roberts"
}, {
"quoteText": "Flow with whatever is happening and let your mind be free. Stay centred by accepting whatever you are doing. This is the ultimate.",
"quoteAuthor": "Chuang Tzu"
}, {
"quoteText": "The best thing in every noble dream is the dreamer...",
"quoteAuthor": "Moncure Conway"
}, {
"quoteText": "There is nothing in a caterpillar that tells you it's going to be a butterfly.",
"quoteAuthor": "Buckminster Fuller"
}, {
"quoteText": "Do not give your attention to what others do or fail to do; give it to what you do or fail to do.",
"quoteAuthor": "Dhammapada"
}, {
"quoteText": "Success means having the courage, the determination, and the will to become the person you believe you were meant to be.",
"quoteAuthor": "George Sheehan"
}, {
"quoteText": "Sadness may be part of life but there is no need to let it dominate your entire life.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "The only real mistake is the one from which we learn nothing.",
"quoteAuthor": "John Powell"
}, {
"quoteText": "Myths which are believed in tend to become true.",
"quoteAuthor": "George Orwell"
}, {
"quoteText": "Life isn't about finding yourself. Life is about creating yourself.",
"quoteAuthor": "Bernard Shaw"
}, {
"quoteText": "Strong people make as many mistakes as weak people. Difference is that strong people admit their mistakes, laugh at them, learn from them. That is how they become strong.",
"quoteAuthor": "Richard Needham"
}, {
"quoteText": "The superior man acts before he speaks, and afterwards speaks according to his action.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Well done is better than well said.",
"quoteAuthor": "Benjamin Franklin"
}, {
"quoteText": "I hear and I forget. I see and I remember. I do and I understand.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Life is a learning experience, only if you learn.",
"quoteAuthor": "Yogi Berra"
}, {
"quoteText": "Argue for your limitations, and sure enough they're yours.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "No man can succeed in a line of endeavor which he does not like.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Though no one can go back and make a brand new start, anyone can start from now and make a brand new ending.",
"quoteAuthor": ""
}, {
"quoteText": "In rivers, the water that you touch is the last of what has passed and the first of that which comes; so with present time.",
"quoteAuthor": "Leonardo da Vinci"
}, {
"quoteText": "If you're in a bad situation, don't worry it'll change. If you're in a good situation, don't worry it'll change.",
"quoteAuthor": "John Simone"
}, {
"quoteText": "Love is just a word until someone comes along and gives it meaning.",
"quoteAuthor": ""
}, {
"quoteText": "I know but one freedom and that is the freedom of the mind.",
"quoteAuthor": "Antoine de Saint-Exupery"
}, {
"quoteText": "Action will remove the doubts that theory cannot solve.",
"quoteAuthor": "Tehyi Hsieh"
}, {
"quoteText": "Don't leave a stone unturned. It's always something, to know you have done the most you could.",
"quoteAuthor": "Charles Dickens"
}, {
"quoteText": "Every great dream begins with a dreamer. Always remember, you have within you the strength, the patience, and the passion to reach for the stars to change the world.",
"quoteAuthor": "Harriet Tubman"
}, {
"quoteText": "Thousands of candles can be lighted from a single candle, and the life of the candle will not be shortened. Happiness never decreases by being shared.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "If you're in a bad situation, don't worry it'll change. If you're in a good situation, don't worry it'll change.",
"quoteAuthor": "John Simone"
}, {
"quoteText": "Most folks are about as happy as they make up their minds to be.",
"quoteAuthor": "Abraham Lincoln"
}, {
"quoteText": "The greatest way to live with honor in this world is to be what we pretend to be.",
"quoteAuthor": "Socrates"
}, {
"quoteText": "Kindness is the greatest wisdom.",
"quoteAuthor": ""
}, {
"quoteText": "To know your purpose is to live a life of direction, and in that direction is found peace and tranquillity.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "The past has no power to stop you from being present now. Only your grievance about the past can do that.",
"quoteAuthor": "Eckhart Tolle"
}, {
"quoteText": "If you would take, you must first give, this is the beginning of intelligence.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Imagination disposes of everything; it creates beauty, justice, and happiness, which are everything in this world.",
"quoteAuthor": "Blaise Pascal"
}, {
"quoteText": "I will not be concerned at other men is not knowing me;I will be concerned at my own want of ability.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "If A is success in life, then A equals x plus y plus z. Work is x; y is play; and z is keeping your mouth shut.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "Our intention creates our reality.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "The most precious gift we can offer anyone is our attention. When mindfulness embraces those we love, they will bloom like flowers.",
"quoteAuthor": "Thich Nhat Hanh"
}, {
"quoteText": "Don't judge each day by the harvest you reap but by the seeds that you plant.",
"quoteAuthor": "Robert Stevenson"
}, {
"quoteText": "When the solution is simple, God is answering.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "The doors we open and close each day decide the lives we live.",
"quoteAuthor": "Flora Whittemore"
}, {
"quoteText": "Life is just a chance to grow a soul.",
"quoteAuthor": "A. Powell Davies"
}, {
"quoteText": "He who obtains has little. He who scatters has much.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "If you spend too much time thinking about a thing, you'll never get it done.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "Those who are free of resentful thoughts surely find peace.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "All men have a sweetness in their life. That is what helps them go on. It is towards that they turn when they feel too worn out.",
"quoteAuthor": "Albert Camus"
}, {
"quoteText": "Wisdom is the reward you get for a lifetime of listening when you'd have preferred to talk.",
"quoteAuthor": "Doug Larson"
}, {
"quoteText": "The odds of hitting your target go up dramatically when you aim at it.",
"quoteAuthor": "Mal Pancoast"
}, {
"quoteText": "Fear is a darkroom where negatives develop.",
"quoteAuthor": "Usman Asif"
}, {
"quoteText": "Your work is to discover your work and then with all your heart to give yourself to it.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Do not be embarrassed by your mistakes. Nothing can teach us better than our understanding of them. This is one of the best ways of self-education.",
"quoteAuthor": "Thomas Carlyle"
}, {
"quoteText": "From wonder into wonder existence opens.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Liberty, taking the word in its concrete sense, consists in the ability to choose.",
"quoteAuthor": "Simone Weil"
}, {
"quoteText": "He who lives in harmony with himself lives in harmony with the universe.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "You can stand tall without standing on someone. You can be a victor without having victims.",
"quoteAuthor": "Harriet Woods"
}, {
"quoteText": "I believe that we are fundamentally the same and have the same basic potential.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "If you cannot do great things, do small things in a great way.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Neither genius, fame, nor love show the greatness of the soul. Only kindness can do that.",
"quoteAuthor": "Jean Lacordaire"
}, {
"quoteText": "I believe in one thing only, the power of human will.",
"quoteAuthor": "Joseph Stalin"
}, {
"quoteText": "You can't choose up sides on a round world.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Excellence is not a skill. It is an attitude.",
"quoteAuthor": "Ralph Marston"
}, {
"quoteText": "It's not what happens to you, but how you react to it that matters.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "Bad times have a scientific value. These are occasions a good learner would not miss.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Though no one can go back and make a brand new start, anyone can start from now and make a brand new ending.",
"quoteAuthor": ""
}, {
"quoteText": "Life is like riding a bicycle. To keep your balance you must keep moving.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "It's not who you are that holds you back, it's who you think you're not.",
"quoteAuthor": ""
}, {
"quoteText": "A subtle thought that is in error may yet give rise to fruitful inquiry that can establish truths of great value.",
"quoteAuthor": "Isaac Asimov"
}, {
"quoteText": "Miracles come in moments. Be ready and willing.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Everything that irritates us about others can lead us to a better understanding of ourselves.",
"quoteAuthor": "Carl Jung"
}, {
"quoteText": "The deepest craving of human nature is the need to be appreciated.",
"quoteAuthor": "William James"
}, {
"quoteText": "The free man is he who does not fear to go to the end of his thought.",
"quoteAuthor": "Leon Blum"
}, {
"quoteText": "All children are artists. The problem is how to remain an artist once he grows up.",
"quoteAuthor": "Pablo Picasso"
}, {
"quoteText": "You can do it if you believe you can!",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Each time we face a fear, we gain strength, courage, and confidence in the doing.",
"quoteAuthor": ""
}, {
"quoteText": "I seek constantly to improve my manners and graces, for they are the sugar to which all are attracted.",
"quoteAuthor": "Og Mandino"
}, {
"quoteText": "There never was a good knife made of bad steel.",
"quoteAuthor": "Benjamin Franklin"
}, {
"quoteText": "Either I will find a way, or I will make one.",
"quoteAuthor": "Philip Sidney"
}, {
"quoteText": "Learn all you can from the mistakes of others. You won't have time to make them all yourself.",
"quoteAuthor": "Alfred Sheinwold"
}, {
"quoteText": "I am glad that I paid so little attention to good advice; had I abided by it I might have been saved from some of my most valuable mistakes.",
"quoteAuthor": "Edna Millay"
}, {
"quoteText": "There are two kinds of failures: those who thought and never did, and those who did and never thought.",
"quoteAuthor": "Laurence J. Peter"
}, {
"quoteText": "Take no thought of who is right or wrong or who is better than. Be not for or against.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "Argue for your limitations, and sure enough theyre yours.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "Good people are good because they've come to wisdom through failure. We get very little wisdom from success, you know.",
"quoteAuthor": "William Saroyan"
}, {
"quoteText": "Love is the master key that opens the gates of happiness.",
"quoteAuthor": "Oliver Holmes"
}, {
"quoteText": "Neither a lofty degree of intelligence nor imagination nor both together go to the making of genius. Love, love, love, that is the soul of genius.",
"quoteAuthor": "Wolfgang Amadeus Mozart"
}, {
"quoteText": "There is only one success � to be able to spend your life in your own way.",
"quoteAuthor": "Christopher Morley"
}, {
"quoteText": "We lost because we told ourselves we lost.",
"quoteAuthor": "Leo Tolstoy"
}, {
"quoteText": "All the flowers of all the tomorrows are in the seeds of today.",
"quoteAuthor": ""
}, {
"quoteText": "The difficulties of life are intended to make us better, not bitter.",
"quoteAuthor": ""
}, {
"quoteText": "Man is not sum of what he has already, but rather the sum of what he does not yet have, of what he could have.",
"quoteAuthor": "Jean-Paul Sartre"
}, {
"quoteText": "A stumble may prevent a fall.",
"quoteAuthor": ""
}, {
"quoteText": "We can only be said to be alive in those moments when our hearts are conscious of our treasures.",
"quoteAuthor": "Thornton Wilder"
}, {
"quoteText": "As we express our gratitude, we must never forget that the highest appreciation is not to utter words, but to live by them.",
"quoteAuthor": "John F. Kennedy"
}, {
"quoteText": "You have power over your mind � not outside events. Realize this, and you will find strength.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "The fox has many tricks. The hedgehog has but one. But that is the best of all.",
"quoteAuthor": "Desiderius Erasmus"
}, {
"quoteText": "Do not expect the world to look bright, if you habitually wear gray-brown glasses.",
"quoteAuthor": "Tomas Eliot"
}, {
"quoteText": "Nothing strengthens authority so much as silence.",
"quoteAuthor": "Leonardo da Vinci"
}, {
"quoteText": "Everything that irritates us about others can lead us to a better understanding of ourselves.",
"quoteAuthor": "Carl Jung"
}, {
"quoteText": "For success, attitude is equally as important as ability.",
"quoteAuthor": "Harry Banks"
}, {
"quoteText": "He who knows that enough is enough will always have enough.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "The cautious seldom err.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "He who talks more is sooner exhausted.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "We are the leaves of one branch, the drops of one sea, the flowers of one garden.",
"quoteAuthor": "Jean Lacordaire"
}, {
"quoteText": "I think somehow we learn who we really are and then live with that decision.",
"quoteAuthor": "Eleanor Roosevelt"
}, {
"quoteText": "Sometimes your joy is the source of your smile, but sometimes your smile can be the source of your joy.",
"quoteAuthor": "Thich Nhat Hanh"
}, {
"quoteText": "The winner ain't the one with the fastest car it's the one who refuses to lose.",
"quoteAuthor": "Dale Earnhardt"
}, {
"quoteText": "People may doubt what you say, but they will believe what you do.",
"quoteAuthor": "Lewis Cass"
}, {
"quoteText": "Money was never a big motivation for me, except as a way to keep score. The real excitement is playing the game.",
"quoteAuthor": "Donald Trump"
}, {
"quoteText": "To succeed, we must first believe that we can.",
"quoteAuthor": "Michael Korda"
}, {
"quoteText": "What you give is what you get.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "To avoid criticism, do nothing, say nothing, be nothing.",
"quoteAuthor": "Elbert Hubbard"
}, {
"quoteText": "Consider how hard it is to change yourself and you'll understand what little chance you have in trying to change others.",
"quoteAuthor": "Jacob Braude"
}, {
"quoteText": "Mistakes are always forgivable, if one has the courage to admit them.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "Liberty, taking the word in its concrete sense, consists in the ability to choose.",
"quoteAuthor": "Simone Weil"
}, {
"quoteText": "Success is determined by those whom prove the impossible, possible.",
"quoteAuthor": "James Pence"
}, {
"quoteText": "Absence makes the heart grow fonder.",
"quoteAuthor": "Haynes Bayly"
}, {
"quoteText": "Life is a succession of moments. To live each one is to succeed.",
"quoteAuthor": "Corita Kent"
}, {
"quoteText": "Doing what you love is the cornerstone of having abundance in your life.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Let us be grateful to people who make us happy; they are the charming gardeners who make our souls blossom.",
"quoteAuthor": "Marcel Proust"
}, {
"quoteText": "All is flux; nothing stays still.",
"quoteAuthor": "Heraclitus"
}, {
"quoteText": "I have always thought the actions of men the best interpreters of their thoughts.",
"quoteAuthor": "John Locke"
}, {
"quoteText": "Fear not for the future, weep not for the past.",
"quoteAuthor": "Percy Shelley"
}, {
"quoteText": "Adversity isn't set against you to fail; adversity is a way to build your character so that you can succeed over and over again through perseverance.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Wrinkles should merely indicate where smiles have been.",
"quoteAuthor": "Mark Twain"
}, {
"quoteText": "The only way to have a friend is to be one.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "We choose our destiny in the way we treat others.",
"quoteAuthor": "Wit"
}, {
"quoteText": "Love is the master key that opens the gates of happiness.",
"quoteAuthor": "Oliver Holmes"
}, {
"quoteText": "In the sky, there is no distinction of east and west; people create distinctions out of their own minds and then believe them to be true.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "If you break your neck, if you have nothing to eat, if your house is on fire, then you got a problem. Everything else is inconvenience.",
"quoteAuthor": "Robert Fulghum"
}, {
"quoteText": "Being in humaneness is good. If we select other goodness and thus are far apart from humaneness, how can we be the wise?",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Everyone has been made for some particular work, and the desire for that work has been put in every heart.",
"quoteAuthor": "Rumi"
}, {
"quoteText": "Men of perverse opinion do not know the excellence of what is in their hands, till some one dash it from them.",
"quoteAuthor": "Sophocles"
}, {
"quoteText": "If you would take, you must first give, this is the beginning of intelligence.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Knowledge has three degrees � opinion, science, illumination. The means or instrument of the first is sense; of the second, dialectic; of the third, intuition.",
"quoteAuthor": "Plotinus"
}, {
"quoteText": "Discovery consists of seeing what everybody has seen and thinking what nobody else has thought.",
"quoteAuthor": "Jonathan Swift"
}, {
"quoteText": "This is the final test of a gentleman: his respect for those who can be of no possible value to him.",
"quoteAuthor": "William Lyon Phelps"
}, {
"quoteText": "To ensure good health: eat lightly, breathe deeply, live moderately, cultivate cheerfulness, and maintain an interest in life.",
"quoteAuthor": "William Londen"
}, {
"quoteText": "Wisdom is the supreme part of happiness.",
"quoteAuthor": "Sophocles"
}, {
"quoteText": "You may only be someone in the world, but to someone else, you may be the world.",
"quoteAuthor": ""
}, {
"quoteText": "Most people are about as happy as they make up their minds to be",
"quoteAuthor": "Abraham Lincoln"
}, {
"quoteText": "Every sixty seconds you spend angry, upset or mad, is a full minute of happiness you�ll never get back.",
"quoteAuthor": ""
}, {
"quoteText": "If we had no winter, the spring would not be so pleasant; if we did not sometimes taste of adversity, prosperity would not be so welcome.",
"quoteAuthor": "Anne Bradstreet"
}, {
"quoteText": "The greatest way to live with honor in this world is to be what we pretend to be.",
"quoteAuthor": "Socrates"
}, {
"quoteText": "No one saves us but ourselves. No one can and no one may. We ourselves must walk the path.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Each misfortune you encounter will carry in it the seed of tomorrows good luck.",
"quoteAuthor": "Og Mandino"
}, {
"quoteText": "Slow down and everything you are chasing will come around and catch you.",
"quoteAuthor": "John De Paola"
}, {
"quoteText": "A hero is no braver than an ordinary man, but he is braver five minutes longer.",
"quoteAuthor": "Ralph Waldo Emerson"
}, {
"quoteText": "Staying in one place is the best path to be taken over and surpassed by many.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "The cause is hidden. The effect is visible to all.",
"quoteAuthor": "Ovid"
}, {
"quoteText": "Joy is what happens to us when we allow ourselves to recognize how good things really are.",
"quoteAuthor": "Marianne Williamson"
}, {
"quoteText": "I begin with an idea and then it becomes something else.",
"quoteAuthor": "Pablo Picasso"
}, {
"quoteText": "It is not enough to have a good mind; the main thing is to use it well.",
"quoteAuthor": "Rene Descartes"
}, {
"quoteText": "All is flux; nothing stays still.",
"quoteAuthor": "Heraclitus"
}, {
"quoteText": "Silence is a fence around wisdom.",
"quoteAuthor": "German proverb"
}, {
"quoteText": "Although there may be tragedy in your life, there's always a possibility to triumph. It doesn't matter who you are, where you come from. The ability to triumph begins with you. Always.",
"quoteAuthor": "Oprah Winfrey"
}, {
"quoteText": "Better than a thousand hollow words, is one word that brings peace.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "We cannot solve our problems with the same thinking we used when we created them.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "If you can dream it, you can do it.",
"quoteAuthor": "Walt Disney"
}, {
"quoteText": "Your vision will become clear only when you can look into your own heart. Who looks outside, dreams; who looks inside, awakes.",
"quoteAuthor": "Carl Jung"
}, {
"quoteText": "You will never be happy if you continue to search for what happiness consists of. You will never live if you are looking for the meaning of life.",
"quoteAuthor": "Albert Camus"
}, {
"quoteText": "Never say there is nothing beautiful in the world any more. There is always something to make you wonder in the shape of a tree, the trembling of a leaf.",
"quoteAuthor": "Albert Schweitzer"
}, {
"quoteText": "Friends are those rare people who ask how we are and then wait to hear the answer.",
"quoteAuthor": "Ed Cunningham"
}, {
"quoteText": "I may not know everything, but everything is not known yet anyway.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "It is the greatest of all mistakes to do nothing because you can only do little � do what you can.",
"quoteAuthor": "Sydney Smith"
}, {
"quoteText": "Everything in the universe goes by indirection. There are no straight lines.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Vision without action is a daydream. Action without vision is a nightmare.",
"quoteAuthor": "Japanese proverb"
}, {
"quoteText": "From wonder into wonder existence opens.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "There is never enough time to do everything, but there is always enough time to do the most important thing.",
"quoteAuthor": "Brian Tracy"
}, {
"quoteText": "You really can change the world if you care enough.",
"quoteAuthor": "Marian Edelman"
}, {
"quoteText": "The years teach much which the days never know.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Thousands of candles can be lit from a single, and the life of the candle will not be shortened. Happiness never decreases by being shared.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "You do not become good by trying to be good, but by finding the goodness that is already within you.",
"quoteAuthor": "Eckhart Tolle"
}, {
"quoteText": "You can observe a lot just by watching.",
"quoteAuthor": "Yogi Berra"
}, {
"quoteText": "Life is not measured by the breaths we take, but by the moments that take our breath.",
"quoteAuthor": ""
}, {
"quoteText": "Setting an example is not the main means of influencing another, it is the only means.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "The best way out is always through.",
"quoteAuthor": "Robert Frost"
}, {
"quoteText": "All things change; nothing perishes.",
"quoteAuthor": "Ovid"
}, {
"quoteText": "There is nothing in a caterpillar that tells you it's going to be a butterfly.",
"quoteAuthor": "Buckminster Fuller"
}, {
"quoteText": "You only lose what you cling to.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "The only real failure in life is not to be true to the best one knows.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "On every thorn, delightful wisdom grows, In every rill a sweet instruction flows.",
"quoteAuthor": "Edward Young"
}, {
"quoteText": "Just as much as we see in others we have in ourselves.",
"quoteAuthor": "William Hazlitt"
}, {
"quoteText": "What you are is what you have been. What you�ll be is what you do now.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "If there is no struggle, there is no progress.",
"quoteAuthor": "Frederick Douglass"
}, {
"quoteText": "The cure for boredom is curiosity. There is no cure for curiosity.",
"quoteAuthor": "Ellen Parr"
}, {
"quoteText": "Good people are good because they've come to wisdom through failure. We get very little wisdom from success, you know.",
"quoteAuthor": "William Saroyan"
}, {
"quoteText": "To bring anything into your life, imagine that it's already there.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "A fine quotation is a diamond on the finger of a man of wit, and a pebble in the hand of a fool.",
"quoteAuthor": "Joseph Roux"
}, {
"quoteText": "People grow through experience if they meet life honestly and courageously. This is how character is built.",
"quoteAuthor": "Eleanor Roosevelt"
}, {
"quoteText": "It's not what happens to you, but how you react to it that matters.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "Never put off till tomorrow what you can do today.",
"quoteAuthor": "Thomas Jefferson"
}, {
"quoteText": "It isn't where you come from, it's where you're going that counts.",
"quoteAuthor": "Ella Fitzgerald"
}, {
"quoteText": "The meaning I picked, the one that changed my life: Overcome fear, behold wonder.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "If you think you can, you can. And if you think you can't, you're right.",
"quoteAuthor": "Henry Ford"
}, {
"quoteText": "It's so simple to be wise. Just think of something stupid to say and then don't say it.",
"quoteAuthor": "Sam Levenson"
}, {
"quoteText": "Experience keeps a dear school, but fools will learn in no other.",
"quoteAuthor": "Benjamin Franklin"
}, {
"quoteText": "Every problem has a gift for you in its hands.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "We are the leaves of one branch, the drops of one sea, the flowers of one garden.",
"quoteAuthor": "Jean Lacordaire"
}, {
"quoteText": "Happiness is when what you think, what you say, and what you do are in harmony.",
"quoteAuthor": "Mohandas Gandhi"
}, {
"quoteText": "Our lives are the only meaningful expression of what we believe and in Whom we believe. And the only real wealth, for any of us, lies in our faith.",
"quoteAuthor": "Gordon Hinckley"
}, {
"quoteText": "There surely is in human nature an inherent propensity to extract all the good out of all the evil.",
"quoteAuthor": "Benjamin Haydon"
}, {
"quoteText": "Thats the risk you take if you change: that people you've been involved with won't like the new you. But other people who do will come along.",
"quoteAuthor": "Lisa Alther"
}, {
"quoteText": "Let me tell you the secret that has led me to my goal: my strength lies solely in my tenacity",
"quoteAuthor": "Louis Pasteur"
}, {
"quoteText": "No one can make you feel inferior without your consent.",
"quoteAuthor": "Eleanor Roosevelt"
}, {
"quoteText": "The only way to have a friend is to be one.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "There never was a good knife made of bad steel.",
"quoteAuthor": "Benjamin Franklin"
}, {
"quoteText": "Wisdom is knowing what to do next; Skill is knowing how ot do it, and Virtue is doing it.",
"quoteAuthor": "David Jordan"
}, {
"quoteText": "Beauty is not in the face; beauty is a light in the heart.",
"quoteAuthor": "Kahlil Gibran"
}, {
"quoteText": "The beginning of knowledge is the discovery of something we do not understand.",
"quoteAuthor": "Frank Herbert"
}, {
"quoteText": "The future is completely open, and we are writing it moment to moment.",
"quoteAuthor": "Pema Chodron"
}, {
"quoteText": "Music in the soul can be heard by the universe.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "It is through science that we prove, but through intuition that we discover.",
"quoteAuthor": "Jules Poincare"
}, {
"quoteText": "Our doubts are traitors and make us lose the good we often might win, by fearing to attempt.",
"quoteAuthor": "Jane Addams"
}, {
"quoteText": "We have two ears and one mouth so that we can listen twice as much as we speak.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "Nature gave us one tongue and two ears so we could hear twice as much as we speak.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "You may be deceived if you trust too much, but you will live in torment if you don't trust enough.",
"quoteAuthor": "Frank Crane"
}, {
"quoteText": "A subtle thought that is in error may yet give rise to fruitful inquiry that can establish truths of great value.",
"quoteAuthor": "Isaac Asimov"
}, {
"quoteText": "What we see depends mainly on what we look for.",
"quoteAuthor": "John Lubbock"
}, {
"quoteText": "It is difficult to achieve a spirit of genuine cooperation as long as people remain indifferent to the feelings and happiness of others.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "If you don't like something, change it. If you can't change it, change your attitude.",
"quoteAuthor": "Maya Angelou"
}, {
"quoteText": "When I dare to be powerful, to use my strength in the service of my vision, then it becomes less and less important whether I am afraid.",
"quoteAuthor": "Audre Lorde"
}, {
"quoteText": "It does not matter how slowly you go as long as you do not stop.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "To hell with circumstances; I create opportunities.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "Every problem has a gift for you in its hands.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "It's easier to see the mistakes on someone else's paper.",
"quoteAuthor": ""
}, {
"quoteText": "Compassion and happiness are not a sign of weakness but a sign of strength.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "No day in which you learn something is a complete loss.",
"quoteAuthor": "David Eddings"
}, {
"quoteText": "He who has imagination without learning has wings but no feet.",
"quoteAuthor": "Joseph Joubert"
}, {
"quoteText": "If A is success in life, then A equals x plus y plus z. Work is x; y is play; and z is keeping your mouth shut.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "Everything in the universe goes by indirection. There are no straight lines.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Passion creates the desire for more and action fuelled by passion creates a future.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "The moment one gives close attention to anything, it becomes a mysterious, awesome, indescribably magnificent world in itself.",
"quoteAuthor": "Henry Miller"
}, {
"quoteText": "The first step to getting the things you want out of life is this: decide what you want.",
"quoteAuthor": "Ben Stein"
}, {
"quoteText": "When in doubt, tell the truth.",
"quoteAuthor": "Mark Twain"
}, {
"quoteText": "The world is always in movement.",
"quoteAuthor": "V. Naipaul"
}, {
"quoteText": "No pessimist ever discovered the secrets of the stars, or sailed to an uncharted land, or opened a new heaven to the human spirit.",
"quoteAuthor": "Helen Keller"
}, {
"quoteText": "A man sees in the world what he carries in his heart.",
"quoteAuthor": "Goethe"
}, {
"quoteText": "You might well remember that nothing can bring you success but yourself.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Learning is finding out what you already know.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "I have never been hurt by anything I didn't say.",
"quoteAuthor": "Calvin Coolidge"
}, {
"quoteText": "You are never given a wish without also being given the power to make it come true. You may have to work for it, however.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "Only through our connectedness to others can we really know and enhance the self. And only through working on the self can we begin to enhance our connectedness to others.",
"quoteAuthor": "Harriet Lerner"
}, {
"quoteText": "What you give is what you get.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "The world is always in movement.",
"quoteAuthor": "V. Naipaul"
}, {
"quoteText": "The art of progress is to preserve order amid change, and to preserve change amid order.",
"quoteAuthor": "Alfred Whitehead"
}, {
"quoteText": "The future is completely open, and we are writing it moment to moment.",
"quoteAuthor": "Pema Chodron"
}, {
"quoteText": "Silences make the real conversations between friends. Not the saying but the never needing to say is what counts.",
"quoteAuthor": "Margaret Runbeck"
}, {
"quoteText": "Why compare yourself with others? No one in the entire world can do a better job of being you than you.",
"quoteAuthor": ""
}, {
"quoteText": "Nothing ever goes away until it has taught us what we need to know.",
"quoteAuthor": "Pema Chodron"
}, {
"quoteText": "A little knowledge that acts is worth infinitely more than much knowledge that is idle.",
"quoteAuthor": "Kahlil Gibran"
}, {
"quoteText": "A good teacher is like a candle � it consumes itself to light the way for others.",
"quoteAuthor": ""
}, {
"quoteText": "Follow effective action with quiet reflection. From the quiet reflection will come even more effective action.",
"quoteAuthor": "Peter Drucker"
}, {
"quoteText": "The Superior Man is aware of Righteousness, the inferior man is aware of advantage.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "A little more persistence, a little more effort, and what seemed hopeless failure may turn to glorious success.",
"quoteAuthor": "Elbert Hubbard"
}, {
"quoteText": "Myths which are believed in tend to become true.",
"quoteAuthor": "George Orwell"
}, {
"quoteText": "Id rather regret the things that I have done than the things that I have not done.",
"quoteAuthor": "Lucille Ball"
}, {
"quoteText": "When you meet someone better than yourself, turn your thoughts to becoming his equal. When you meet someone not as good as you are, look within and examine your own self.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Go put your creed into the deed. Nor speak with double tongue.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "The happiness of a man in this life does not consist in the absence but in the mastery of his passions.",
"quoteAuthor": "Alfred Tennyson"
}, {
"quoteText": "The aim of life is self-development. To realize ones nature perfectly � that is what each of us is here for.",
"quoteAuthor": "Oscar Wilde"
}, {
"quoteText": "It all depends on how we look at things, and not how they are in themselves.",
"quoteAuthor": "Carl Jung"
}, {
"quoteText": "Those who cannot learn from history are doomed to repeat it.",
"quoteAuthor": "George Santayan"
}, {
"quoteText": "It isn't where you come from, it's where you're going that counts.",
"quoteAuthor": "Ella Fitzgerald"
}, {
"quoteText": "Keep yourself to the sunshine and you cannot see the shadow.",
"quoteAuthor": "Helen Keller"
}, {
"quoteText": "We never live; we are always in the expectation of living.",
"quoteAuthor": "Voltaire"
}, {
"quoteText": "Happiness is a Swedish sunset � it is there for all, but most of us look the other way and lose it.",
"quoteAuthor": "Mark Twain"
}, {
"quoteText": "To enjoy life, we must touch much of it lightly.",
"quoteAuthor": "Voltaire"
}, {
"quoteText": "Iron rusts from disuse; water loses its purity from stagnation... even so does inaction sap the vigour of the mind.",
"quoteAuthor": "Leonardo da Vinci"
}, {
"quoteText": "Failure will never overtake me if my determination to succeed is strong enough.",
"quoteAuthor": "Og Mandino"
}, {
"quoteText": "Divide each difficulty into as many parts as is feasible and necessary to resolve it.",
"quoteAuthor": "Rene Descartes"
}, {
"quoteText": "If you cannot do great things, do small things in a great way.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "If one does not know to which port is sailing, no wind is favorable.",
"quoteAuthor": "Seneca"
}, {
"quoteText": "The cosmos is neither moral or immoral; only people are. He who would move the world must first move himself.",
"quoteAuthor": "Edward Ericson"
}, {
"quoteText": "Try not to become a man of success, but rather try to become a man of value.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "Smile, breathe and go slowly.",
"quoteAuthor": "Thich Nhat Hanh"
}, {
"quoteText": "Wherever a man turns he can find someone who needs him.",
"quoteAuthor": "Albert Schweitzer"
}, {
"quoteText": "The minute you settle for less than you deserve, you get even less than you settled for.",
"quoteAuthor": "Maureen Dowd"
}, {
"quoteText": "The most complicated achievements of thought are possible without the assistance of consciousness.",
"quoteAuthor": "Sigmund Freud"
}, {
"quoteText": "A failure is a man who has blundered but is not capable of cashing in on the experience.",
"quoteAuthor": "Elbert Hubbard"
}, {
"quoteText": "Stay away from what might have been and look at what will be.",
"quoteAuthor": "Marsha Petrie Sue"
}, {
"quoteText": "Choose a job you love, and you will never have to work a day in your life.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "He who lives in harmony with himself lives in harmony with the universe.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "There is only one corner of the universe you can be certain of improving, and that's your own self.",
"quoteAuthor": "Aldous Huxley"
}, {
"quoteText": "This world, after all our science and sciences, is still a miracle; wonderful, inscrutable, magical and more, to whosoever will think of it.",
"quoteAuthor": "Thomas Carlyle"
}, {
"quoteText": "The truest greatness lies in being kind, the truest wisdom in a happy mind.",
"quoteAuthor": "Ella Wilcox"
}, {
"quoteText": "An ounce of emotion is equal to a ton of facts.",
"quoteAuthor": "John Junor"
}, {
"quoteText": "Whenever you have eliminated the impossible, whatever remains, however improbable, must be the truth.",
"quoteAuthor": "Arthur Conan Doyle"
}, {
"quoteText": "Risk more than others think is safe. Care more than others think is wise. Dream more than others think is practical.Expect more than others think is possible.",
"quoteAuthor": "Cadet Maxim"
}, {
"quoteText": "Try not to become a man of success but rather try to become a man of value.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "At the center of your being you have the answer; you know who you are and you know what you want.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "The person who lives life fully, glowing with life's energy, is the person who lives a successful life.",
"quoteAuthor": "Daisaku Ikeda"
}, {
"quoteText": "At the center of your being you have the answer; you know who you are and you know what you want.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "It is the greatest of all mistakes to do nothing because you can only do little � do what you can.",
"quoteAuthor": "Sydney Smith"
}, {
"quoteText": "The superior man is satisfied and composed; the mean man is always full of distress.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Do not waste yourself in rejection, nor bark against the bad, but chant the beauty of the good.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "If a man does his best, what else is there?",
"quoteAuthor": "George Patton"
}, {
"quoteText": "If you are patient in one moment of anger, you will escape one hundred days of sorrow.",
"quoteAuthor": "Chinese proverb"
}, {
"quoteText": "Only when we are no longer afraid do we begin to live.",
"quoteAuthor": "Dorothy Thompson"
}, {
"quoteText": "Our strength grows out of our weaknesses.",
"quoteAuthor": "Ralph Waldo Emerson"
}, {
"quoteText": "Peace is not something you wish for. It's something you make, something you do, something you are, and something you give away.",
"quoteAuthor": "Robert Fulghum"
}, {
"quoteText": "Patience and perseverance have a magical effect before which difficulties disappear and obstacles vanish.",
"quoteAuthor": "John Adams"
}, {
"quoteText": "We need to find the courage to say NO to the things and people that are not serving us if we want to rediscover ourselves and live our lives with authenticity.",
"quoteAuthor": "Barbara De Angelis"
}, {
"quoteText": "Treat people as if they were what they ought to be and you help them to become what they are capable of being.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "When in doubt, tell the truth.",
"quoteAuthor": "Mark Twain"
}, {
"quoteText": "You do not become good by trying to be good, but by finding the goodness that is already within you.",
"quoteAuthor": "Eckhart Tolle"
}, {
"quoteText": "It's not who you are that holds you back, it's who you think you're not.",
"quoteAuthor": ""
}, {
"quoteText": "It is not so important to know everything as to appreciate what we learn.",
"quoteAuthor": "Hannah More"
}, {
"quoteText": "We must become the change we want to see.",
"quoteAuthor": "Mahatma Gandhi"
}, {
"quoteText": "Great is the art of beginning, but greater is the art of ending.",
"quoteAuthor": "Lazurus Long"
}, {
"quoteText": "Can miles truly separate you from friends... If you want to be with someone you love, aren't you already there?",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "To study and not think is a waste. To think and not study is dangerous.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Simply put, you believer that things or people make you unhappy, but this is not accurate. You make yourself unhappy.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Simply put, you believer that things or people make you unhappy, but this is not accurate. You make yourself unhappy.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Smile, breathe and go slowly.",
"quoteAuthor": "Thich Nhat Hanh"
}, {
"quoteText": "Courage is not the absence of fear, but simply moving on with dignity despite that fear.",
"quoteAuthor": "Pat Riley"
}, {
"quoteText": "It is better to take many small steps in the right direction than to make a great leap forward only to stumble backward.",
"quoteAuthor": ""
}, {
"quoteText": "Time is the most valuable thing a man can spend.",
"quoteAuthor": "Theophrastus"
}, {
"quoteText": "Chaos and Order are not enemies, only opposites.",
"quoteAuthor": "Richard Garriott"
}, {
"quoteText": "The day you decide to do it is your lucky day.",
"quoteAuthor": "Japanese proverb"
}, {
"quoteText": "To keep the body in good health is a duty... otherwise we shall not be able to keep our mind strong and clear.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Be glad of life because it gives you the chance to love, to work, to play, and to look up at the stars.",
"quoteAuthor": "Henry Van Dyke"
}, {
"quoteText": "To forgive is to set a prisoner free and realize that prisoner was you.",
"quoteAuthor": "Lewis B. Smedes"
}, {
"quoteText": "Wishes can be your best avenue of getting what you want when you turn wishes into action. Action moves your wish to the forefront from thought to reality.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Look back over the past, with its changing empires that rose and fell, and you can foresee the future, too.",
"quoteAuthor": "Marcus Aurelius"
}, {
"quoteText": "We are the leaves of one branch, the drops of one sea, the flowers of one garden.",
"quoteAuthor": "Jean Lacordaire"
}, {
"quoteText": "True happiness means forging a strong spirit that is undefeated, no matter how trying our circumstances.",
"quoteAuthor": "Daisaku Ikeda"
}, {
"quoteText": "There are two primary choices in life: to accept conditions as they exist, or accept the responsibility for changing them.",
"quoteAuthor": "Denis Waitley"
}, {
"quoteText": "I prefer to be true to myself, even at the hazard of incurring the ridicule of others, rather than to be false, and to incur my own abhorrence.",
"quoteAuthor": "Frederick Douglass"
}, {
"quoteText": "You give before you get.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "More often than not, anger is actually an indication of weakness rather than of strength.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Setting an example is not the main means of influencing another, it is the only means.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "Keep your eyes on the stars and your feet on the ground.",
"quoteAuthor": "Theodore Roosevelt"
}, {
"quoteText": "Take things as they are. Punch when you have to punch. Kick when you have to kick.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "Argue for your limitations, and sure enough theyre yours.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "The only limit to your impact is your imagination and commitment.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "A good teacher is like a candle � it consumes itself to light the way for others.",
"quoteAuthor": ""
}, {
"quoteText": "You must welcome change as the rule but not as your ruler.",
"quoteAuthor": "Denis Waitley"
}, {
"quoteText": "If you correct your mind, the rest of your life will fall into place.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Work for something because it is good, not just because it stands a chance to succeed.",
"quoteAuthor": "Vaclav Havel"
}, {
"quoteText": "It is the mark of an educated mind to be able to entertain a thought without accepting it.",
"quoteAuthor": "Aristotle"
}, {
"quoteText": "We can only be said to be alive in those moments when our hearts are conscious of our treasures.",
"quoteAuthor": "Thornton Wilder"
}, {
"quoteText": "Trouble is only opportunity in work clothes.",
"quoteAuthor": "Henry J. Kaiser"
}, {
"quoteText": "You're never a loser until you quit trying.",
"quoteAuthor": "Mike Ditka"
}, {
"quoteText": "If the shoe doesn't fit, must we change the foot?",
"quoteAuthor": "Gloria Steinem"
}, {
"quoteText": "You may only be someone in the world, but to someone else, you may be the world.",
"quoteAuthor": ""
}, {
"quoteText": "I am glad that I paid so little attention to good advice; had I abided by it I might have been saved from some of my most valuable mistakes.",
"quoteAuthor": "Edna Millay"
}, {
"quoteText": "Let your hook always be cast; in the pool where you least expect it, there will be a fish.",
"quoteAuthor": "Ovid"
}, {
"quoteText": "There are two primary choices in life: to accept conditions as they exist, or accept the responsibility for changing them.",
"quoteAuthor": "Denis Waitley"
}, {
"quoteText": "The world has the habit of making room for the man whose actions show that he knows where he is going.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Nothing will work unless you do.",
"quoteAuthor": "Maya Angelou"
}, {
"quoteText": "If you're walking down the right path and you're willing to keep walking, eventually you'll make progress.",
"quoteAuthor": "Barack Obama"
}, {
"quoteText": "It is common sense to take a method and try it. If it fails, admit it frankly and try another. But above all, try something.",
"quoteAuthor": "Franklin D. Roosevelt"
}, {
"quoteText": "If your actions inspire others to dream more, learn more, do more and become more, you are a leader.",
"quoteAuthor": "John Quincy Adams"
}, {
"quoteText": "It is surprising what a man can do when he has to, and how little most men will do when they don't have to.",
"quoteAuthor": "Walter Linn"
}, {
"quoteText": "Doing nothing is better than being busy doing nothing.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "I know but one freedom and that is the freedom of the mind.",
"quoteAuthor": "Antoine de Saint-Exupery"
}, {
"quoteText": "You might well remember that nothing can bring you success but yourself.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Life's challenges are not supposed to paralyse you, they're supposed to help you discover who you are.",
"quoteAuthor": "Bernice Reagon"
}, {
"quoteText": "Your worst enemy cannot harm you as much as your own unguarded thoughts.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "The world has the habit of making room for the man whose actions show that he knows where he is going.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "We know what we are, but know not what we may be.",
"quoteAuthor": "William Shakespeare"
}, {
"quoteText": "Peace cannot be kept by force. It can only be achieved by understanding.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "Our ability to achieve happiness and success depends on the strength of our wings.",
"quoteAuthor": "Catherine Pulsifer"
}, {
"quoteText": "The road leading to a goal does not separate you from the destination; it is essentially a part of it.",
"quoteAuthor": "Charles DeLint"
}, {
"quoteText": "The least of things with a meaning is worth more in life than the greatest of things without it.",
"quoteAuthor": "Carl Jung"
}, {
"quoteText": "They must often change, who would be constant in happiness or wisdom.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "If you want a thing done well, do it yourself.",
"quoteAuthor": "Napoleon Bonaparte"
}, {
"quoteText": "Let yourself be silently drawn by the stronger pull of what you really love.",
"quoteAuthor": "Rumi"
}, {
"quoteText": "Do not expect the world to look bright, if you habitually wear gray-brown glasses.",
"quoteAuthor": "Tomas Eliot"
}, {
"quoteText": "Why compare yourself with others? No one in the entire world can do a better job of being you than you.",
"quoteAuthor": ""
}, {
"quoteText": "Don't fear failure so much that you refuse to try new things. The saddest summary of life contains three descriptions: could have, might have, and should have.",
"quoteAuthor": ""
}, {
"quoteText": "Patience is the companion of wisdom.",
"quoteAuthor": "Saint Augustine"
}, {
"quoteText": "If you cannot be silent be brilliant and thoughtful.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Action may not always bring happiness, but there is no happiness without action.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "A rolling stone gathers no moss.",
"quoteAuthor": "Publilius Syrus"
}, {
"quoteText": "To go against the dominant thinking of your friends, of most of the people you see every day, is perhaps the most difficult act of heroism you can perform.",
"quoteAuthor": "Theodore H. White"
}, {
"quoteText": "To fly, we have to have resistance.",
"quoteAuthor": "Maya Lin"
}, {
"quoteText": "Never mistake activity for achievement.",
"quoteAuthor": "John Wooden"
}, {
"quoteText": "As the rest of the world is walking out the door, your best friends are the ones walking in.",
"quoteAuthor": ""
}, {
"quoteText": "Take no thought of who is right or wrong or who is better than. Be not for or against.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "Six essential qualities that are the key to success: Sincerity, personal integrity, humility, courtesy, wisdom, charity.",
"quoteAuthor": "William Menninger"
}, {
"quoteText": "The bird of paradise alights only upon the hand that does not grasp.",
"quoteAuthor": "John Berry"
}, {
"quoteText": "Why worry about tomorrow, when today is all we have?",
"quoteAuthor": ""
}, {
"quoteText": "Live through feeling and you will live through love. For feeling is the language of the soul, and feeling is truth.",
"quoteAuthor": "Matt Zotti"
}, {
"quoteText": "Those who are free of resentful thoughts surely find peace.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Pick battles big enough to matter, small enough to win.",
"quoteAuthor": "Jonathan Kozol"
}, {
"quoteText": "Maxim for life: You get treated in life the way you teach people to treat you.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "The ladder of success is never crowded at the top.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Happiness is a perfume you cannot pour on others without getting a few drops on yourself.",
"quoteAuthor": "Ralph Waldo Emerson"
}, {
"quoteText": "Love is the flower you've got to let grow.",
"quoteAuthor": "John Lennon"
}, {
"quoteText": "Trust yourself. You know more than you think you do.",
"quoteAuthor": "Benjamin Spock"
}, {
"quoteText": "We must embrace pain and burn it as fuel for our journey.",
"quoteAuthor": "Kenji Miyazawa"
}, {
"quoteText": "I am glad that I paid so little attention to good advice; had I abided by it I might have been saved from some of my most valuable mistakes.",
"quoteAuthor": "Edna Millay"
}, {
"quoteText": "Life a culmination of the past, an awareness of the present, an indication of the future beyond knowledge, the quality that gives a touch of divinity to matter.",
"quoteAuthor": "Charles A. Lindbergh"
}, {
"quoteText": "He who is fixed to a star does not change his mind.",
"quoteAuthor": "Leonardo da Vinci"
}, {
"quoteText": "Try not to become a man of success, but rather try to become a man of value.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "The superior man is modest in his speech, but exceeds in his actions.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "There are two primary choices in life: to accept conditions as they exist, or accept responsibility for changing them.",
"quoteAuthor": "Denis Waitley"
}, {
"quoteText": "Never be afraid to try, remember... Amateurs built the ark, Professionals built the Titanic.",
"quoteAuthor": ""
}, {
"quoteText": "If I am not for myself, who will be for me? If I am not for others, what am I? And if not now, when?",
"quoteAuthor": "Rabbi Hillel"
}, {
"quoteText": "You can't trust without risk but neither can you live in a cocoon.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "There is nothing in a caterpillar that tells you it's going to be a butterfly.",
"quoteAuthor": "Buckminster Fuller"
}, {
"quoteText": "Be a good listener. Your ears will never get you in trouble.",
"quoteAuthor": "Frank Tyger"
}, {
"quoteText": "The greatest good you can do for another is not just to share your riches but to reveal to him his own.",
"quoteAuthor": "Benjamin Disraeli"
}, {
"quoteText": "We have two ears and one mouth so that we can listen twice as much as we speak.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "A thing long expected takes the form of the unexpected when at last it comes.",
"quoteAuthor": "Mark Twain"
}, {
"quoteText": "Do what you can. Want what you have. Be who you are.",
"quoteAuthor": "Forrest Church"
}, {
"quoteText": "Think for yourselves and let others enjoy the privilege to do so too.",
"quoteAuthor": "Voltaire"
}, {
"quoteText": "I am not bothered by the fact that I am unknown. I am bothered when I do not know others.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "Gratitude makes sense of our past, brings peace for today, and creates a vision for tomorrow.",
"quoteAuthor": "Melody Beattie"
}, {
"quoteText": "I endeavour to be wise when I cannot be merry, easy when I cannot be glad, content with what cannot be mended and patient when there is no redress.",
"quoteAuthor": "Elizabeth Montagu"
}, {
"quoteText": "My advice to you is not to inquire why or whither, but just enjoy your ice cream while its on your plate � that's my philosophy.",
"quoteAuthor": "Thornton Wilder"
}, {
"quoteText": "Things do not change, we change.",
"quoteAuthor": "Henry Thoreau"
}, {
"quoteText": "I love my past. I love my present. Im not ashamed of what Ive had, and Im not sad because I have it no longer.",
"quoteAuthor": "Colette"
}, {
"quoteText": "Many people think of prosperity that concerns money only to forget that true prosperity is of the mind.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "They can do all because they think they can.",
"quoteAuthor": "Virgil"
}, {
"quoteText": "When you are content to be simply yourself and don't compare or compete, everybody will respect you.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Love at first sight is easy to understand; its when two people have been looking at each other for a lifetime that it becomes a miracle.",
"quoteAuthor": "Amy Bloom"
}, {
"quoteText": "It is not only for what we do that we are held responsible, but also for what we do not do.",
"quoteAuthor": "Moliere"
}, {
"quoteText": "Obstacles are those things you see when you take your eyes off the goal.",
"quoteAuthor": "Hannah More"
}, {
"quoteText": "Everything that irritates us about others can lead us to an understanding of ourselves.",
"quoteAuthor": "Carl Jung"
}, {
"quoteText": "Thats the risk you take if you change: that people you've been involved with won't like the new you. But other people who do will come along.",
"quoteAuthor": "Lisa Alther"
}, {
"quoteText": "If you are patient in one moment of anger, you will escape one hundred days of sorrow.",
"quoteAuthor": "Chinese proverb"
}, {
"quoteText": "Every time you smile at someone, it is an action of love, a gift to that person, a beautiful thing.",
"quoteAuthor": "Mother Teresa"
}, {
"quoteText": "Into each life rain must fall but rain can be the giver of life and it is all in your attitude that makes rain produce sunshine.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "What is new in the world? Nothing. What is old in the world? Nothing. Everything has always been and will always be.",
"quoteAuthor": "Sai Baba"
}, {
"quoteText": "Work for something because it is good, not just because it stands a chance to succeed.",
"quoteAuthor": "Vaclav Havel"
}, {
"quoteText": "To be tested is good. The challenged life may be the best therapist.",
"quoteAuthor": "Gail Sheehy"
}, {
"quoteText": "Happiness does not come from having much, but from being attached to little.",
"quoteAuthor": "Cheng Yen"
}, {
"quoteText": "Act as if what you do makes a difference. It does.",
"quoteAuthor": "William James"
}, {
"quoteText": "The fox has many tricks. The hedgehog has but one. But that is the best of all.",
"quoteAuthor": "Desiderius Erasmus"
}, {
"quoteText": "Our intention creates our reality.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "We are all inclined to judge ourselves by our ideals; others, by their acts.",
"quoteAuthor": "Harold Nicolson"
}, {
"quoteText": "A goal is a dream with a deadline.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Always be yourself, express yourself, have faith in yourself, do not go out and look for a successful personality and duplicate it.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "Whenever you have eliminated the impossible, whatever remains, however improbable, must be the truth.",
"quoteAuthor": "Arthur Conan Doyle"
}, {
"quoteText": "When you have got an elephant by the hind legs and he is trying to run away, it's best to let him run.",
"quoteAuthor": "Abraham Lincoln"
}, {
"quoteText": "The amount of happiness that you have depends on the amount of freedom you have in your heart.",
"quoteAuthor": "Thich Nhat Hanh"
}, {
"quoteText": "Nothing is a waste of time if you use the experience wisely.",
"quoteAuthor": "Rodin"
}, {
"quoteText": "The years teach much which the days never know.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Life is a learning experience, only if you learn.",
"quoteAuthor": "Yogi Berra"
}, {
"quoteText": "Don't settle for a relationship that won't let you be yourself.",
"quoteAuthor": "Oprah Winfrey"
}, {
"quoteText": "If we did the things we are capable of, we would astound ourselves.",
"quoteAuthor": "Thomas Edison"
}, {
"quoteText": "To give hope to someone occurs when you teach them how to use the tools to do it for themselves.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "A life spent making mistakes is not only more honourable but more useful than a life spent in doing nothing.",
"quoteAuthor": "Bernard Shaw"
}, {
"quoteText": "The only real valuable thing is intuition.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "Never miss an opportunity to make others happy, even if you have to leave them alone in order to do it.",
"quoteAuthor": ""
}, {
"quoteText": "If we are facing in the right direction, all we have to do is keep on walking.",
"quoteAuthor": ""
}, {
"quoteText": "Give me six hours to chop down a tree and I will spend the first four sharpening the axe.",
"quoteAuthor": "Abraham Lincoln"
}, {
"quoteText": "You always succeed in producing a result.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "A prudent question is one half of wisdom.",
"quoteAuthor": "Francis Bacon"
}, {
"quoteText": "Knowing is not enough; we must apply!",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "Don't wait. The time will never be just right.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Know how to listen, and you will profit even from those who talk badly.",
"quoteAuthor": "Plutarch"
}, {
"quoteText": "Mountains cannot be surmounted except by winding paths.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "You can be what you want to be. You have the power within and we will help you always.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "If you surrender to the wind, you can ride it.",
"quoteAuthor": "Toni Morrison"
}, {
"quoteText": "All know the way; few actually walk it.",
"quoteAuthor": "Bodhidharma"
}, {
"quoteText": "He that never changes his opinions, never corrects his mistakes, and will never be wiser on the morrow than he is today.",
"quoteAuthor": "Tryon Edwards"
}, {
"quoteText": "Those who are free of resentful thoughts surely find peace.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "No is easier to do. Yes is easier to say.",
"quoteAuthor": "Jason Fried"
}, {
"quoteText": "What lies behind us and what lies before us are small matters compared to what lies within us.",
"quoteAuthor": "Oliver Holmes"
}, {
"quoteText": "People are not lazy. They simply have impotent goals � that is, goals that do not inspire them.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "Don't miss all the beautiful colors of the rainbow looking for that pot of gold.",
"quoteAuthor": ""
}, {
"quoteText": "Truth, and goodness, and beauty are but different faces of the same all.",
"quoteAuthor": "Ralph Emerson"
}, {
"quoteText": "Forgiveness does not change the past, but it does enlarge the future.",
"quoteAuthor": "Paul Boese"
}, {
"quoteText": "If one way be better than another, that you may be sure is natures way.",
"quoteAuthor": "Aristotle"
}, {
"quoteText": "To know your purpose is to live a life of direction, and in that direction is found peace and tranquillity.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "A beautiful thing is never perfect.",
"quoteAuthor": ""
}, {
"quoteText": "Keep your eyes on the stars and your feet on the ground.",
"quoteAuthor": "Theodore Roosevelt"
}, {
"quoteText": "You are never given a wish without also being given the power to make it come true. You may have to work for it, however.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "From error to error one discovers the entire truth.",
"quoteAuthor": "Sigmund Freud"
}, {
"quoteText": "In order to live free and happily you must sacrifice boredom. It is not always an easy sacrifice.",
"quoteAuthor": "Richard Bach"
}, {
"quoteText": "I am not bothered by the fact that I am unknown. I am bothered when I do not know others.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "When it is obvious that the goals cannot be reached, don't adjust the goals, adjust the action steps.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "I believe that every person is born with talent.",
"quoteAuthor": "Maya Angelou"
}, {
"quoteText": "Doing nothing is better than being busy doing nothing.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "To be thoughtful and kind only takes a few seconds compared to the timeless hurt caused by one rude gesture.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "Make the best use of what is in your power, and take the rest as it happens.",
"quoteAuthor": "Epictetus"
}, {
"quoteText": "The right way is not always the popular and easy way. Standing for right when it is unpopular is a true test of moral character.",
"quoteAuthor": "Margaret Smith"
}, {
"quoteText": "To be wronged is nothing unless you continue to remember it.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "The only limit to our realization of tomorrow will be our doubts of today.",
"quoteAuthor": "Franklin Roosevelt"
}, {
"quoteText": "The future is completely open, and we are writing it moment to moment.",
"quoteAuthor": "Pema Chodron"
}, {
"quoteText": "More often than not, anger is actually an indication of weakness rather than of strength.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Some people thrive on huge, dramatic change. Some people prefer the slow and steady route. Do what's right for you.",
"quoteAuthor": "Julie Morgenstern"
}, {
"quoteText": "Victory belongs to the most persevering.",
"quoteAuthor": "Napoleon Bonaparte"
}, {
"quoteText": "They say that time changes things, but you actually have to change them yourself.",
"quoteAuthor": "Andy Warhol"
}, {
"quoteText": "He who deliberates fully before taking a step will spend his entire life on one leg.",
"quoteAuthor": "Chinese proverb"
}, {
"quoteText": "A house divided against itself cannot stand.",
"quoteAuthor": "Abraham Lincoln"
}, {
"quoteText": "Everything that irritates us about others can lead us to an understanding about ourselves.",
"quoteAuthor": "Carl Jung"
}, {
"quoteText": "Mind is everything: muscle, pieces of rubber. All that I am, I am because of my mind.",
"quoteAuthor": "Paavo Nurmi"
}, {
"quoteText": "It isn't what happens to us that causes us to suffer; it's what we say to ourselves about what happens.",
"quoteAuthor": "Pema Chodron"
}, {
"quoteText": "Absence makes the heart grow fonder.",
"quoteAuthor": "Haynes Bayly"
}, {
"quoteText": "We must become the change we want to see.",
"quoteAuthor": "Mahatma Gandhi"
}, {
"quoteText": "Good timber does not grow with ease; the stronger the wind, the stronger the trees.",
"quoteAuthor": "J. Willard Marriott"
}, {
"quoteText": "All our talents increase in the using, and the every faculty, both good and bad, strengthen by exercise.",
"quoteAuthor": "Anne Bronte"
}, {
"quoteText": "Enjoy the little things, for one day you may look back and realize they were the big things.",
"quoteAuthor": "Robert Brault"
}, {
"quoteText": "True happiness means forging a strong spirit that is undefeated, no matter how trying our circumstances.",
"quoteAuthor": "Daisaku Ikeda"
}, {
"quoteText": "We are the leaves of one branch, the drops of one sea, the flowers of one garden.",
"quoteAuthor": "Jean Lacordaire"
}, {
"quoteText": "Experience is simply the name we give our mistakes.",
"quoteAuthor": "Oscar Wilde"
}, {
"quoteText": "What you are is what you have been. What you�ll be is what you do now.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Watch the little things; a small leak will sink a great ship.",
"quoteAuthor": "Benjamin Franklin"
}, {
"quoteText": "Self-complacency is fatal to progress.",
"quoteAuthor": "Margaret Sangster"
}, {
"quoteText": "The journey of a thousand miles begins with one step.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Being right is highly overrated. Even a stopped clock is right twice a day.",
"quoteAuthor": ""
}, {
"quoteText": "We know from science that nothing in the universe exists as an isolated or independent entity.",
"quoteAuthor": "Margaret Wheatley"
}, {
"quoteText": "Let me tell you the secret that has led me to my goal: my strength lies solely in my tenacity",
"quoteAuthor": "Louis Pasteur"
}, {
"quoteText": "Ideals are an imaginative understanding of that which is desirable in that which is possible.",
"quoteAuthor": "Walter Lippmann"
}, {
"quoteText": "All achievements, all earned riches, have their beginning in an idea.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "The greatest way to live with honour in this world is to be what we pretend to be.",
"quoteAuthor": "Socrates"
}, {
"quoteText": "I believe that we are fundamentally the same and have the same basic potential.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "Life is what happens to you while you're busy making other plans.",
"quoteAuthor": "John Lennon"
}, {
"quoteText": "Peace begins with a smile.",
"quoteAuthor": "Mother Teresa"
}, {
"quoteText": "I have always thought the actions of men the best interpreters of their thoughts.",
"quoteAuthor": "John Locke"
}, {
"quoteText": "Life a culmination of the past, an awareness of the present, an indication of the future beyond knowledge, the quality that gives a touch of divinity to matter.",
"quoteAuthor": "Charles A. Lindbergh"
}, {
"quoteText": "Here is one quality that one must possess to win, and that is definiteness of purpose, the knowledge of what one wants, and a burning desire to possess it.",
"quoteAuthor": "Napoleon Hill"
}, {
"quoteText": "Kindness is the golden chain by which society is bound together.",
"quoteAuthor": "Johann Wolfgang von Goethe"
}, {
"quoteText": "In the long run we get no more than we have been willing to risk giving.",
"quoteAuthor": "Sheldon Kopp"
}, {
"quoteText": "We are Divine enough to ask and we are important enough to receive.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "All the world is a stage, And all the men and women merely players.They have their exits and entrances; Each man in his time plays many parts.",
"quoteAuthor": "William Shakespeare"
}, {
"quoteText": "Three things cannot be long hidden: the sun, the moon, and the truth.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "I am not afraid of tomorrow, for I have seen yesterday and I love today.",
"quoteAuthor": "William White"
}, {
"quoteText": "You do not become good by trying to be good, but by finding the goodness that is already within you.",
"quoteAuthor": "Eckhart Tolle"
}, {
"quoteText": "When you lose, don't lose the lesson.",
"quoteAuthor": ""
}, {
"quoteText": "Worry gives a small thing a big shadow.",
"quoteAuthor": ""
}, {
"quoteText": "Successful people ask better questions, and as a result, they get better answers.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "A man of ability and the desire to accomplish something can do anything.",
"quoteAuthor": "Donald Kircher"
}, {
"quoteText": "My reputation grows with every failure.",
"quoteAuthor": "George Shaw"
}, {
"quoteText": "A good plan today is better than a perfect plan tomorrow.",
"quoteAuthor": ""
}, {
"quoteText": "The awareness of our own strength makes us modest.",
"quoteAuthor": "Paul Cezanne"
}, {
"quoteText": "By letting it go it all gets done. The world is won by those who let it go. But when you try and try. The world is beyond the winning.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "A good rest is half the work.",
"quoteAuthor": ""
}, {
"quoteText": "He who conquers others is strong; He who conquers himself is mighty.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "Patience is the companion of wisdom.",
"quoteAuthor": "Saint Augustine"
}, {
"quoteText": "Some people thrive on huge, dramatic change. Some people prefer the slow and steady route. Do what's right for you.",
"quoteAuthor": "Julie Morgenstern"
}, {
"quoteText": "You do not become good by trying to be good, but by finding the goodness that is already within you.",
"quoteAuthor": "Eckhart Tolle"
}, {
"quoteText": "I think somehow we learn who we really are and then live with that decision.",
"quoteAuthor": "Eleanor Roosevelt"
}, {
"quoteText": "A man may fulfil the object of his existence by asking a question he cannot answer, and attempting a task he cannot achieve.",
"quoteAuthor": "Oliver Holmes"
}, {
"quoteText": "Every man takes the limits of his own field of vision for the limits of the world.",
"quoteAuthor": "Arthur Schopenhauer"
}, {
"quoteText": "Count your joys instead of your woes. Count your friends instead of your foes.",
"quoteAuthor": ""
}, {
"quoteText": "If you break your neck, if you have nothing to eat, if your house is on fire, then you got a problem. Everything else is inconvenience.",
"quoteAuthor": "Robert Fulghum"
}, {
"quoteText": "It is not in the stars to hold our destiny but in ourselves.",
"quoteAuthor": "William Shakespeare"
}, {
"quoteText": "Take no thought of who is right or wrong or who is better than. Be not for or against.",
"quoteAuthor": "Bruce Lee"
}, {
"quoteText": "Weve got to have a dream if we are going to make a dream come true.",
"quoteAuthor": "Walt Disney"
}, {
"quoteText": "You can adopt the attitude there is nothing you can do, or you can see the challenge as your call to action.",
"quoteAuthor": "Catherine Pulsifer"
}, {
"quoteText": "Follow your instincts. That is where true wisdom manifests itself.",
"quoteAuthor": "Oprah Winfrey"
}, {
"quoteText": "A man should look for what is, and not for what he thinks should be.",
"quoteAuthor": "Albert Einstein"
}, {
"quoteText": "Those that know, do. Those that understand, teach.",
"quoteAuthor": "Aristotle"
}, {
"quoteText": "To be upset over what you don't have is to waste what you do have.",
"quoteAuthor": "Ken S. Keyes"
}, {
"quoteText": "When in doubt, tell the truth.",
"quoteAuthor": "Mark Twain"
}, {
"quoteText": "Think how hard physics would be if particles could think.",
"quoteAuthor": "Murray Gell-Mann"
}, {
"quoteText": "You are important enough to ask and you are blessed enough to receive back.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Without this playing with fantasy no creative work has ever yet come to birth. The debt we owe to the play of the imagination is incalculable.",
"quoteAuthor": "Carl Jung"
}, {
"quoteText": "They can do all because they think they can.",
"quoteAuthor": "Virgil"
}, {
"quoteText": "You, yourself, as much as anybody in the entire universe, deserve your love and affection.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "We could never learn to be brave and patient if there were only joy in the world.",
"quoteAuthor": "Helen Keller"
}, {
"quoteText": "Compassion and happiness are not a sign of weakness but a sign of strength.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "I believe that every person is born with talent.",
"quoteAuthor": "Maya Angelou"
}, {
"quoteText": "Maxim for life: You get treated in life the way you teach people to treat you.",
"quoteAuthor": "Wayne Dyer"
}, {
"quoteText": "Using the power of decision gives you the capacity to get past any excuse to change any and every part of your life in an instant.",
"quoteAuthor": "Tony Robbins"
}, {
"quoteText": "An invincible determination can accomplish almost anything and in this lies the great distinction between great men and little men.",
"quoteAuthor": "Thomas Fuller"
}, {
"quoteText": "There are people who have money and people who are rich.",
"quoteAuthor": "Coco Chanel"
}, {
"quoteText": "The more you know yourself, the more you forgive yourself.",
"quoteAuthor": "Confucius"
}, {
"quoteText": "The art of progress is to preserve order amid change, and to preserve change amid order.",
"quoteAuthor": "Alfred Whitehead"
}, {
"quoteText": "Never doubt that a small group of thoughtful, committed people can change the world. Indeed. It is the only thing that ever has.",
"quoteAuthor": "Margaret Mead"
}, {
"quoteText": "Kind words will unlock an iron door.",
"quoteAuthor": "Turkish proverb"
}, {
"quoteText": "Sometimes the most important thing in a whole day is the rest we take between two deep breaths.",
"quoteAuthor": "Etty Hillesum"
}, {
"quoteText": "To get the full value of joy you must have someone to divide it with.",
"quoteAuthor": "Mark Twain"
}, {
"quoteText": "To make no mistakes is not in the power of man; but from their errors and mistakes the wise and good learn wisdom for the future.",
"quoteAuthor": "Plutarch"
}, {
"quoteText": "If you accept the expectations of others, especially negative ones, then you never will change the outcome.",
"quoteAuthor": "Michael Jordan"
}, {
"quoteText": "Flow with whatever is happening and let your mind be free. Stay centred by accepting whatever you are doing. This is the ultimate.",
"quoteAuthor": "Chuang Tzu"
}, {
"quoteText": "If you want things to be different, perhaps the answer is to become different yourself.",
"quoteAuthor": "Norman Peale"
}, {
"quoteText": "I can't change the direction of the wind, but I can adjust my sails to always reach my destination.",
"quoteAuthor": "Jimmy Dean"
}, {
"quoteText": "The happiness that is genuinely satisfying is accompanied by the fullest exercise of our faculties and the fullest realization of the world in which we live.",
"quoteAuthor": "Bertrand Russell"
}, {
"quoteText": "Everyone should carefully observe which way his heart draws him, and then choose that way with all his strength.",
"quoteAuthor": "Hasidic saying"
}, {
"quoteText": "We have committed the Golden Rule to memory; let us now commit it to life.",
"quoteAuthor": "Edwin Markham"
}, {
"quoteText": "Where there is great love, there are always miracles.",
"quoteAuthor": "Willa Cather"
}, {
"quoteText": "Let go of your attachment to being right, and suddenly your mind is more open. You're able to benefit from the unique viewpoints of others, without being crippled by your own judgement.",
"quoteAuthor": "Ralph Marston"
}, {
"quoteText": "To see things in the seed, that is genius.",
"quoteAuthor": "Lao Tzu"
}, {
"quoteText": "We must become the change we want to see.",
"quoteAuthor": "Mahatma Gandhi"
}, {
"quoteText": "Life a culmination of the past, an awareness of the present, an indication of the future beyond knowledge, the quality that gives a touch of divinity to matter.",
"quoteAuthor": "Charles A. Lindbergh"
}, {
"quoteText": "I have often regretted my speech, never my silence.",
"quoteAuthor": "Publilius Syrus"
}, {
"quoteText": "Your worst enemy cannot harm you as much as your own unguarded thoughts.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "If I know what love is, it is because of you.",
"quoteAuthor": "Hermann Hesse"
}, {
"quoteText": "All children are artists. The problem is how to remain an artist once he grows up.",
"quoteAuthor": "Pablo Picasso"
}, {
"quoteText": "Patience is a virtue but you will never ever accomplish anything if you don't exercise action over patience.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "If you have knowledge, let others light their candles in it.",
"quoteAuthor": "Margaret Fuller"
}, {
"quoteText": "What you fear is that which requires action to overcome.",
"quoteAuthor": "Byron Pulsifer"
}, {
"quoteText": "I will prepare and some day my chance will come.",
"quoteAuthor": "Abraham Lincoln"
}, {
"quoteText": "Life's challenges are not supposed to paralyse you, they're supposed to help you discover who you are.",
"quoteAuthor": "Bernice Reagon"
}, {
"quoteText": "Think as a wise man but communicate in the language of the people.",
"quoteAuthor": "William Yeats"
}, {
"quoteText": "Kind words can be short and easy to speak, but their echoes are truly endless.",
"quoteAuthor": "Mother Teresa"
}, {
"quoteText": "No valid plans for the future can be made by those who have no capacity for living now.",
"quoteAuthor": "Alan Watts"
}, {
"quoteText": "Imagination rules the world.",
"quoteAuthor": "Napoleon Bonaparte"
}, {
"quoteText": "Many of life's failures are people who did not realize how close they were to success when they gave up.",
"quoteAuthor": "Thomas Edison"
}, {
"quoteText": "Of course there is no formula for success except perhaps an unconditional acceptance of life and what it brings.",
"quoteAuthor": "Arthur Rubinstein"
}, {
"quoteText": "Excellence is to do a common thing in an uncommon way.",
"quoteAuthor": "Booker Washington"
}, {
"quoteText": "Be kind whenever possible. It is always possible.",
"quoteAuthor": "Dalai Lama"
}, {
"quoteText": "The true way to render ourselves happy is to love our work and find in it our pleasure.",
"quoteAuthor": "Francoise de Motteville"
}, {
"quoteText": "What we see depends mainly on what we look for.",
"quoteAuthor": "John Lubbock"
}, {
"quoteText": "He who experiences the unity of life sees his own Self in all beings, and all beings in his own Self, and looks on everything with an impartial eye.",
"quoteAuthor": "Buddha"
}, {
"quoteText": "Sadness flies away on the wings of time.",
"quoteAuthor": "Jean de la Fontaine"
}, {
"quoteText": "The only Zen you find on the tops of mountains is the Zen you bring up there.",
"quoteAuthor": "Robert Pirsig"
}, {
"quoteText": "You may be deceived if you trust too much, but you will live in torment if you don't trust enough.",
"quoteAuthor": "Frank Crane"
}, {
"quoteText": "It is not enough to have a good mind; the main thing is to use it well.",
"quoteAuthor": "Rene Descartes"
}, {
"quoteText": "The winds and waves are always on the side of the ablest navigators.",
"quoteAuthor": "Edward Gibbon"
}, {
"quoteText": "Victory belongs to the most persevering.",
"quoteAuthor": "Napoleon Bonaparte"
}, {
"quoteText": "I believe that every person is born with talent.",
"quoteAuthor": "Maya Angelou"
}, {
"quoteText": "It is the quality of our work which will please God, not the quantity.",
"quoteAuthor": "Mahatma Gandhi"
}, {
"quoteText": "If one advances confidently in the direction of his dream, and endeavours to live the life which he had imagines, he will meet with a success unexpected in common hours.",
"quoteAuthor": "Henry David Thoreau"
}, {
"quoteText": "Sometimes the cards we are dealt are not always fair. However you must keep smiling and moving on.",
"quoteAuthor": "Tom Jackson"
}]

