from kraken.core import GraphExecutorObserver, TaskStatus, TaskStatusType
from kraken.core.executor.default import DefaultPrintingExecutorObserver
from termcolor import colored

COLORS_BY_STATUS = {
    TaskStatusType.PENDING: "magenta",
    TaskStatusType.FAILED: "red",
    TaskStatusType.INTERRUPTED: "red",
    TaskStatusType.SKIPPED: "yellow",
    TaskStatusType.SUCCEEDED: "green",
    TaskStatusType.STARTED: "magenta",
    TaskStatusType.UP_TO_DATE: "green",
}


def status_to_text(status: TaskStatus) -> str:
    message = colored(status.type.name, COLORS_BY_STATUS.get(status.type))
    if status.message:
        message += f" ({status.message})"
    return message


def get_executor_observer() -> GraphExecutorObserver:
    return DefaultPrintingExecutorObserver(
        status_to_text=status_to_text,
        format_header=lambda s: colored(s, "cyan", attrs=["bold", "underline"]),
        format_duration=lambda s: colored(s, "cyan"),
    )
