from pathlib import Path
from typing import Any
from typing import TypeAlias

def load_yaml(resource_name: str, parent: NavigableDict | None = ...) -> NavDict: ...
def load_csv(resource_name: str, *args, parent: navdict | None = None, **kwargs): ...
def get_resource_location(parent_location: Path | None, in_dir: str | None) -> Path: ...

class NavigableDict(dict):
    def __init__(
        self,
        head: dict | None = ...,
        label: str | None = ...,
        _filename: str | Path | None = ...,
    ): ...
    @staticmethod
    def from_yaml_file(filename: str | Path | None = ...) -> NavigableDict: ...
    @staticmethod
    def from_yaml_string(yaml_content: str | None = None, label: str | None = None) -> NavigableDict: ...
    @staticmethod
    def from_dict(my_dict: dict, label: str | None = None) -> NavigableDict: ...
    def to_yaml_file(
        self, filename: str | Path | None = ..., header: str = None, top_level_group: str = None
    ) -> None: ...
    def get_private_attribute(self, key: str) -> Any: ...
    def set_private_attribute(self, key: str, value: Any) -> None: ...
    def has_private_attribute(self, key) -> bool: ...
    def get_label(self) -> str: ...
    def set_label(self, value: str) -> None: ...
    def get_raw_value(self, key): ...

navdict: TypeAlias = NavigableDict
NavDict: TypeAlias = NavigableDict
