from importlib.metadata import EntryPoint
from typing import Callable

class Directive:
    def __init__(self, ep: EntryPoint | None = None, *, name: str | None = None, func: Callable | None = None):
        self.ep = None
        self.directive_func = None
        self.directive_name = None

    @property
    def name(self) -> str: ...
    @property
    def func(self) -> Callable: ...

def is_directive(value: str) -> bool: ...
def get_directive_plugin(name: str) -> Directive | None: ...
def unravel_directive(value: str) -> tuple[str, str]: ...
def register_directive(name: str, func: Callable) -> None: ...
