# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['knowit', 'knowit.properties', 'knowit.providers', 'knowit.rules']

package_data = \
{'': ['*']}

install_requires = \
['babelfish>=0.6.0,<0.7.0',
 'enzyme>=0.4.1,<0.5.0',
 'pint>=0.20.1,<0.21.0',
 'pymediainfo>=6.0.1,<7.0.0',
 'pyyaml>=6.0,<7.0',
 'trakit>=0.2.1,<0.3.0']

entry_points = \
{'console_scripts': ['knowit = knowit.__main__:main']}

setup_kwargs = {
    'name': 'knowit',
    'version': '0.5.1',
    'description': 'Know better your media files',
    'long_description': '# KnowIt\n\nKnow better your media files.\n\n[![Latest\nVersion](https://img.shields.io/pypi/v/knowit.svg)](https://pypi.python.org/pypi/knowit)\n\n[![tests](https://github.com/ratoaq2/knowit/actions/workflows/test.yml/badge.svg)](https://github.com/ratoaq2/knowit/actions/workflows/test.yml)\n\n[![License](https://img.shields.io/github/license/ratoaq2/knowit.svg)](https://github.com/ratoaq2/knowit/blob/master/LICENSE)\n\n  - Project page  \n    <https://github.com/ratoaq2/knowit>\n\n## Usage\n\n### CLI\n\nExtract information from a video file:\n\n    $ knowit /folder/Audio Samples/hd_dtsma_7.1.mkv\n    For: /folder/Audio Samples/hd_dtsma_7.1.mkv\n    Knowit 0.4.0 found:\n    {\n        "title": "7.1Ch DTS-HD MA - Speaker Mapping Test File",\n        "path": "/folder/Audio Samples/hd_dtsma_7.1.mkv",\n        "duration": "0:01:37",\n        "size": "40.77 MB",\n        "bit_rate": "3.3 Mbps",\n        "container": "mkv",\n        "video": [\n            {\n                "id": 1,\n                "duration": "0:01:37",\n                "width": "1920 pixel",\n                "height": "1080 pixel",\n                "scan_type": "Progressive",\n                "aspect_ratio": "1.778",\n                "pixel_aspect_ratio": "1.0",\n                "resolution": "1080p",\n                "frame_rate": "23.976 FPS",\n                "bit_depth": "8 bit",\n                "codec": "H.264",\n                "profile": "Main",\n                "profile_level": "4",\n                "media_type": "video/H264",\n                "default": true\n            }\n        ],\n        "audio": [\n            {\n                "id": 2,\n                "name": "7.1Ch DTS-HD MA",\n                "language": "English",\n                "duration": "0:01:37",\n                "codec": "DTS-HD",\n                "profile": "Master Audio",\n                "channels_count": 8,\n                "channels": "7.1",\n                "bit_depth": "24 bit",\n                "bit_rate_mode": "Variable",\n                "sampling_rate": "48.0 KHz",\n                "compression": "Lossless",\n                "default": true\n            }\n        ],\n        "provider": {\n            "name": "mediainfo",\n            "version": {\n                "pymediainfo": "5.0.3",\n                "libmediainfo.so.0": "v20.9"\n            }\n        }\n    }\n\nExtract information from a video file using ffmpeg:\n\n    $ knowit --provider ffmpeg /folder/Audio Samples/hd_dtsma_7.1.mkv\n    For: /folder/Audio Samples/hd_dtsma_7.1.mkv\n    Knowit 0.4.0 found:\n    {\n        "title": "7.1Ch DTS-HD MA - Speaker Mapping Test File",\n        "path": "/folder/Audio Samples/hd_dtsma_7.1.mkv",\n        "duration": "0:01:37",\n        "size": "40.77 MB",\n        "bit_rate": "3.3 Mbps",\n        "container": "mkv",\n        "video": [\n            {\n                "id": 0,\n                "width": "1920 pixel",\n                "height": "1080 pixel",\n                "scan_type": "Progressive",\n                "aspect_ratio": "1.778",\n                "pixel_aspect_ratio": "1.0",\n                "resolution": "1080p",\n                "frame_rate": "23.976 FPS",\n                "bit_depth": "8 bit",\n                "codec": "H.264",\n                "profile": "Main",\n                "default": true\n            }\n        ],\n        "audio": [\n            {\n                "id": 1,\n                "name": "7.1Ch DTS-HD MA",\n                "language": "English",\n                "codec": "DTS-HD",\n                "profile": "Master Audio",\n                "channels_count": 8,\n                "channels": "7.1",\n                "bit_depth": "24 bit",\n                "sampling_rate": "48.0 KHz",\n                "default": true\n            }\n        ],\n        "provider": {\n            "name": "ffmpeg",\n            "version": {\n                "ffprobe": "v4.2.4-1ubuntu0.1"\n            }\n        }\n    }\n\nUsing docker:\n\n    docker run -it --rm -v /folder:/folder knowit /folder/Audio Samples/hd_dtsma_7.1.mkv\n    For: /folder/Audio Samples/hd_dtsma_7.1.mkv\n    Knowit 0.4.0 found:\n    {\n        "title": "7.1Ch DTS-HD MA - Speaker Mapping Test File",\n        "path": "/folder/Audio Samples/hd_dtsma_7.1.mkv",\n        "duration": "0:01:37",\n        "size": "40.77 MB",\n        "bit_rate": "3.3 Mbps",\n        "container": "mkv",\n        "video": [\n            {\n                "id": 1,\n                "duration": "0:01:37",\n                "width": "1920 pixel",\n                "height": "1080 pixel",\n                "scan_type": "Progressive",\n                "aspect_ratio": "1.778",\n                "pixel_aspect_ratio": "1.0",\n                "resolution": "1080p",\n                "frame_rate": "23.976 FPS",\n                "bit_depth": "8 bit",\n                "codec": "H.264",\n                "profile": "Main",\n                "profile_level": "4",\n                "media_type": "video/H264",\n                "default": true\n            }\n        ],\n        "audio": [\n            {\n                "id": 2,\n                "name": "7.1Ch DTS-HD MA",\n                "language": "English",\n                "duration": "0:01:37",\n                "codec": "DTS-HD",\n                "profile": "Master Audio",\n                "channels_count": 8,\n                "channels": "7.1",\n                "bit_depth": "24 bit",\n                "bit_rate_mode": "Variable",\n                "sampling_rate": "48.0 KHz",\n                "compression": "Lossless",\n                "default": true\n            }\n        ],\n        "provider": {\n            "name": "mediainfo",\n            "version": {\n                "pymediainfo": "5.0.3",\n                "libmediainfo.so.0": "v20.9"\n            }\n        }\n    }\n\nAll available CLI options:\n\n    $ knowit --help\n    usage: knowit [-h] [-p PROVIDER] [--debug] [--report] [-y] [-N] [-P PROFILE] [--mediainfo MEDIAINFO] [--ffmpeg FFMPEG] [--mkvmerge MKVMERGE] [--version] [videopath [videopath ...]]\n    \n    positional arguments:\n      videopath             Path to the video to introspect\n    \n    optional arguments:\n      -h, --help            show this help message and exit\n    \n    Providers:\n      -p PROVIDER, --provider PROVIDER\n                            The provider to be used: mediainfo, ffmpeg, mkvmerge or enzyme.\n    \n    Output:\n      --debug               Print information for debugging knowit and for reporting bugs.\n      --report              Parse media and report all non-detected values\n      -y, --yaml            Display output in yaml format\n      -N, --no-units        Display output without units\n      -P PROFILE, --profile PROFILE\n                            Display values according to specified profile: code, default, human, technical\n    \n    Configuration:\n      --mediainfo MEDIAINFO\n                            The location to search for MediaInfo binaries\n      --ffmpeg FFMPEG       The location to search for ffprobe (FFmpeg) binaries\n      --mkvmerge MKVMERGE   The location to search for mkvmerge (MKVToolNix) binaries\n    \n    Information:\n      --version             Display knowit version.\n\n## Installation\n\nKnowIt can be installed as a regular python module by running:\n\n    $ [sudo] pip install knowit\n\nFor a better isolation with your system you should use a dedicated\nvirtualenv or install for your user only using the `--user` flag.\n\n## External dependencies\n\nKnowIt can use MediaInfo, ffprobe (FFmpeg) or mkvmerge (MKVToolNix)\n\nKnowIt supports MKV regardless if MediaInfo, FFmpeg or MKVToolNix are\ninstalled.\n\nMediaInfo, FFmpeg or MKVToolNix increases the number of supported\nformats and the number of extracted information.\n\nMediaInfo is the default provider. Visit their\n[website](http://mediaarea.net/MediaInfo) and install the proper package\nfor your system.\n\nffprobe (FFmpeg) can be downloaded\n[here](https://ffmpeg.org/download.html)\n\nmkvmerge (MKVToolNix) can be downloaded\n[here](https://mkvtoolnix.download/downloads.html)\n',
    'author': 'Rato',
    'author_email': 'None',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/ratoaq2/knowit',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8.1,<4.0.0',
}


setup(**setup_kwargs)
