"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Service = exports.GitHubConnection = exports.ConfigurationSourceType = exports.AssetSource = exports.EcrPublicSource = exports.EcrSource = exports.GithubSource = exports.Source = exports.Runtime = exports.Memory = exports.Cpu = exports.ImageRepositoryType = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const cdk = require("aws-cdk-lib");
const aws_apprunner_1 = require("aws-cdk-lib/aws-apprunner");
/**
 * The image repository types
 */
var ImageRepositoryType;
(function (ImageRepositoryType) {
    /**
     * Amazon ECR Public
     */
    ImageRepositoryType["ECR_PUBLIC"] = "ECR_PUBLIC";
    /**
     * Amazon ECR
     */
    ImageRepositoryType["ECR"] = "ECR";
})(ImageRepositoryType = exports.ImageRepositoryType || (exports.ImageRepositoryType = {}));
/**
 * The number of CPU units reserved for each instance of your App Runner service.
 *
 */
class Cpu {
    /**
     *
     * @param unit The unit of CPU.
     */
    constructor(unit) {
        this.unit = unit;
    }
    /**
     * Custom CPU unit
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-instanceconfiguration.html#cfn-apprunner-service-instanceconfiguration-cpu
     *
     * @param unit custom CPU unit
     */
    static of(unit) { return new Cpu(unit); }
}
exports.Cpu = Cpu;
_a = JSII_RTTI_SYMBOL_1;
Cpu[_a] = { fqn: "@aws-cdk/aws-apprunner-alpha.Cpu", version: "2.27.0-alpha.0" };
/**
 * 1 vCPU
 */
Cpu.ONE_VCPU = Cpu.of('1 vCPU');
/**
 * 2 vCPU
 */
Cpu.TWO_VCPU = Cpu.of('2 vCPU');
/**
 * The amount of memory reserved for each instance of your App Runner service.
 */
class Memory {
    /**
     *
     * @param unit The unit of memory.
     */
    constructor(unit) {
        this.unit = unit;
    }
    /**
     * Custom Memory unit
     *
     * @param unit custom Memory unit
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-instanceconfiguration.html#cfn-apprunner-service-instanceconfiguration-memory
     */
    static of(unit) { return new Memory(unit); }
}
exports.Memory = Memory;
_b = JSII_RTTI_SYMBOL_1;
Memory[_b] = { fqn: "@aws-cdk/aws-apprunner-alpha.Memory", version: "2.27.0-alpha.0" };
/**
 * 2 GB(for 1 vCPU)
 */
Memory.TWO_GB = Memory.of('2 GB');
/**
 * 3 GB(for 1 vCPU)
 */
Memory.THREE_GB = Memory.of('3 GB');
/**
 * 4 GB(for 1 or 2 vCPU)
 */
Memory.FOUR_GB = Memory.of('4 GB');
/**
 * The code runtimes
 */
class Runtime {
    /**
     *
     * @param name The runtime name.
     */
    constructor(name) {
        this.name = name;
    }
    /**
     * Other runtimes
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfigurationvalues.html#cfn-apprunner-service-codeconfigurationvalues-runtime for all available runtimes.
     *
     * @param name runtime name
     *
     */
    static of(name) { return new Runtime(name); }
}
exports.Runtime = Runtime;
_c = JSII_RTTI_SYMBOL_1;
Runtime[_c] = { fqn: "@aws-cdk/aws-apprunner-alpha.Runtime", version: "2.27.0-alpha.0" };
/**
 * NodeJS 12
 */
Runtime.NODEJS_12 = Runtime.of('NODEJS_12');
/**
 * Python 3
 */
Runtime.PYTHON_3 = Runtime.of('PYTHON_3');
/**
 * Represents the App Runner service source.
 */
class Source {
    /**
     * Source from the GitHub repository.
     */
    static fromGitHub(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_GithubRepositoryProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromGitHub);
            }
            throw error;
        }
        return new GithubSource(props);
    }
    /**
     * Source from the ECR repository.
     */
    static fromEcr(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_EcrProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromEcr);
            }
            throw error;
        }
        return new EcrSource(props);
    }
    /**
     * Source from the ECR Public repository.
     */
    static fromEcrPublic(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_EcrPublicProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromEcrPublic);
            }
            throw error;
        }
        return new EcrPublicSource(props);
    }
    /**
     * Source from local assets.
     */
    static fromAsset(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_AssetProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromAsset);
            }
            throw error;
        }
        return new AssetSource(props);
    }
}
exports.Source = Source;
_d = JSII_RTTI_SYMBOL_1;
Source[_d] = { fqn: "@aws-cdk/aws-apprunner-alpha.Source", version: "2.27.0-alpha.0" };
/**
 * Represents the service source from a Github repository.
 */
class GithubSource extends Source {
    constructor(props) {
        super();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_GithubRepositoryProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.props = props;
    }
    bind(_scope) {
        var _l;
        return {
            codeRepository: {
                codeConfiguration: {
                    configurationSource: this.props.configurationSource,
                    configurationValues: this.props.codeConfigurationValues,
                },
                repositoryUrl: this.props.repositoryUrl,
                sourceCodeVersion: {
                    type: 'BRANCH',
                    value: (_l = this.props.branch) !== null && _l !== void 0 ? _l : 'main',
                },
                connection: this.props.connection,
            },
        };
    }
}
exports.GithubSource = GithubSource;
_e = JSII_RTTI_SYMBOL_1;
GithubSource[_e] = { fqn: "@aws-cdk/aws-apprunner-alpha.GithubSource", version: "2.27.0-alpha.0" };
/**
 * Represents the service source from ECR.
 */
class EcrSource extends Source {
    constructor(props) {
        super();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_EcrProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.props = props;
    }
    bind(_scope) {
        return {
            imageRepository: {
                imageConfiguration: this.props.imageConfiguration,
                imageIdentifier: this.props.repository.repositoryUriForTagOrDigest(this.props.tagOrDigest || this.props.tag || 'latest'),
                imageRepositoryType: ImageRepositoryType.ECR,
            },
            ecrRepository: this.props.repository,
        };
    }
}
exports.EcrSource = EcrSource;
_f = JSII_RTTI_SYMBOL_1;
EcrSource[_f] = { fqn: "@aws-cdk/aws-apprunner-alpha.EcrSource", version: "2.27.0-alpha.0" };
/**
 * Represents the service source from ECR Public.
 */
class EcrPublicSource extends Source {
    constructor(props) {
        super();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_EcrPublicProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.props = props;
    }
    bind(_scope) {
        return {
            imageRepository: {
                imageConfiguration: this.props.imageConfiguration,
                imageIdentifier: this.props.imageIdentifier,
                imageRepositoryType: ImageRepositoryType.ECR_PUBLIC,
            },
        };
    }
}
exports.EcrPublicSource = EcrPublicSource;
_g = JSII_RTTI_SYMBOL_1;
EcrPublicSource[_g] = { fqn: "@aws-cdk/aws-apprunner-alpha.EcrPublicSource", version: "2.27.0-alpha.0" };
/**
 * Represents the source from local assets.
 */
class AssetSource extends Source {
    constructor(props) {
        super();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_AssetProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.props = props;
    }
    bind(_scope) {
        return {
            imageRepository: {
                imageConfiguration: this.props.imageConfiguration,
                imageIdentifier: this.props.asset.imageUri,
                imageRepositoryType: ImageRepositoryType.ECR,
            },
            ecrRepository: this.props.asset.repository,
        };
    }
}
exports.AssetSource = AssetSource;
_h = JSII_RTTI_SYMBOL_1;
AssetSource[_h] = { fqn: "@aws-cdk/aws-apprunner-alpha.AssetSource", version: "2.27.0-alpha.0" };
/**
 * The source of the App Runner configuration.
 */
var ConfigurationSourceType;
(function (ConfigurationSourceType) {
    /**
     * App Runner reads configuration values from `the apprunner.yaml` file in the source code repository
     * and ignores `configurationValues`.
     */
    ConfigurationSourceType["REPOSITORY"] = "REPOSITORY";
    /**
     * App Runner uses configuration values provided in `configurationValues` and ignores the `apprunner.yaml`
     * file in the source code repository.
     */
    ConfigurationSourceType["API"] = "API";
})(ConfigurationSourceType = exports.ConfigurationSourceType || (exports.ConfigurationSourceType = {}));
/**
 * Represents the App Runner connection that enables the App Runner service to connect
 * to a source repository. It's required for GitHub code repositories.
 */
class GitHubConnection {
    constructor(arn) {
        this.connectionArn = arn;
    }
    /**
     * Using existing App Runner connection by specifying the connection ARN.
     * @param arn connection ARN
     * @returns Connection
     */
    static fromConnectionArn(arn) {
        return new GitHubConnection(arn);
    }
}
exports.GitHubConnection = GitHubConnection;
_j = JSII_RTTI_SYMBOL_1;
GitHubConnection[_j] = { fqn: "@aws-cdk/aws-apprunner-alpha.GitHubConnection", version: "2.27.0-alpha.0" };
/**
 * The App Runner Service.
 */
class Service extends cdk.Resource {
    constructor(scope, id, props) {
        var _l, _m, _o, _p, _q, _r, _s;
        super(scope, id);
        /**
         * Environment variables for this service
         */
        this.environment = {};
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_ServiceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        const source = props.source.bind(this);
        this.source = source;
        this.props = props;
        // generate an IAM role only when ImageRepositoryType is ECR and props.role is undefined
        this.accessRole = (((_l = this.source.imageRepository) === null || _l === void 0 ? void 0 : _l.imageRepositoryType) == ImageRepositoryType.ECR) ?
            this.props.accessRole ? this.props.accessRole : this.generateDefaultRole() : undefined;
        if (((_m = source.codeRepository) === null || _m === void 0 ? void 0 : _m.codeConfiguration.configurationSource) == ConfigurationSourceType.REPOSITORY && ((_o = source.codeRepository) === null || _o === void 0 ? void 0 : _o.codeConfiguration.configurationValues)) {
            throw new Error('configurationValues cannot be provided if the ConfigurationSource is Repository');
        }
        const resource = new aws_apprunner_1.CfnService(this, 'Resource', {
            instanceConfiguration: {
                cpu: (_p = props.cpu) === null || _p === void 0 ? void 0 : _p.unit,
                memory: (_q = props.memory) === null || _q === void 0 ? void 0 : _q.unit,
                instanceRoleArn: (_r = props.instanceRole) === null || _r === void 0 ? void 0 : _r.roleArn,
            },
            sourceConfiguration: {
                authenticationConfiguration: this.renderAuthenticationConfiguration(),
                imageRepository: source.imageRepository ? this.renderImageRepository() : undefined,
                codeRepository: source.codeRepository ? this.renderCodeConfiguration() : undefined,
            },
            networkConfiguration: {
                egressConfiguration: {
                    egressType: this.props.vpcConnector ? 'VPC' : 'DEFAULT',
                    vpcConnectorArn: (_s = this.props.vpcConnector) === null || _s === void 0 ? void 0 : _s.vpcConnectorArn,
                },
            },
        });
        // grant required privileges for the role
        if (source.ecrRepository && this.accessRole) {
            source.ecrRepository.grantPull(this.accessRole);
        }
        this.serviceArn = resource.attrServiceArn;
        this.serviceId = resource.attrServiceId;
        this.serviceUrl = resource.attrServiceUrl;
        this.serviceStatus = resource.attrStatus;
        this.serviceName = resource.ref;
    }
    /**
     * Import from service name.
     */
    static fromServiceName(scope, id, serviceName) {
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.serviceName = serviceName;
                this.serviceArn = cdk.Stack.of(this).formatArn({
                    resource: 'service',
                    service: 'apprunner',
                    resourceName: serviceName,
                });
            }
        }
        return new Import(scope, id);
    }
    /**
     * Import from service attributes.
     */
    static fromServiceAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_ServiceAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromServiceAttributes);
            }
            throw error;
        }
        const serviceArn = attrs.serviceArn;
        const serviceName = attrs.serviceName;
        const serviceUrl = attrs.serviceUrl;
        const serviceStatus = attrs.serviceStatus;
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.serviceArn = serviceArn;
                this.serviceName = serviceName;
                this.serviceUrl = serviceUrl;
                this.serviceStatus = serviceStatus;
            }
        }
        return new Import(scope, id);
    }
    renderAuthenticationConfiguration() {
        var _l, _m, _o;
        return {
            accessRoleArn: (_l = this.accessRole) === null || _l === void 0 ? void 0 : _l.roleArn,
            connectionArn: (_o = (_m = this.source.codeRepository) === null || _m === void 0 ? void 0 : _m.connection) === null || _o === void 0 ? void 0 : _o.connectionArn,
        };
    }
    renderCodeConfiguration() {
        return {
            codeConfiguration: {
                configurationSource: this.source.codeRepository.codeConfiguration.configurationSource,
                // codeConfigurationValues will be ignored if configurationSource is REPOSITORY
                codeConfigurationValues: this.source.codeRepository.codeConfiguration.configurationValues ?
                    this.renderCodeConfigurationValues(this.source.codeRepository.codeConfiguration.configurationValues) : undefined,
            },
            repositoryUrl: this.source.codeRepository.repositoryUrl,
            sourceCodeVersion: this.source.codeRepository.sourceCodeVersion,
        };
    }
    renderCodeConfigurationValues(props) {
        this.environment = props.environment;
        return {
            port: props.port,
            buildCommand: props.buildCommand,
            runtime: props.runtime.name,
            runtimeEnvironmentVariables: this.renderEnvironmentVariables(),
            startCommand: props.startCommand,
        };
    }
    renderImageRepository() {
        var _l, _m, _o, _p;
        const repo = this.source.imageRepository;
        this.environment = (_l = repo.imageConfiguration) === null || _l === void 0 ? void 0 : _l.environment;
        return Object.assign(repo, {
            imageConfiguration: {
                port: (_o = (_m = repo.imageConfiguration) === null || _m === void 0 ? void 0 : _m.port) === null || _o === void 0 ? void 0 : _o.toString(),
                startCommand: (_p = repo.imageConfiguration) === null || _p === void 0 ? void 0 : _p.startCommand,
                runtimeEnvironmentVariables: this.renderEnvironmentVariables(),
            },
        });
    }
    renderEnvironmentVariables() {
        if (this.environment) {
            let env = [];
            for (const [key, value] of Object.entries(this.environment)) {
                if (key.startsWith('AWSAPPRUNNER')) {
                    throw new Error(`Environment variable key ${key} with a prefix of AWSAPPRUNNER is not allowed`);
                }
                env.push({ name: key, value: value });
            }
            return env;
        }
        else {
            return undefined;
        }
    }
    generateDefaultRole() {
        const accessRole = new iam.Role(this, 'AccessRole', {
            assumedBy: new iam.ServicePrincipal('build.apprunner.amazonaws.com'),
        });
        accessRole.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['ecr:GetAuthorizationToken'],
            resources: ['*'],
        }));
        this.accessRole = accessRole;
        return accessRole;
    }
}
exports.Service = Service;
_k = JSII_RTTI_SYMBOL_1;
Service[_k] = { fqn: "@aws-cdk/aws-apprunner-alpha.Service", version: "2.27.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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