"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Application = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_certificatemanager_1 = require("@aws-cdk/aws-certificatemanager");
const aws_cloudfront_1 = require("@aws-cdk/aws-cloudfront");
const aws_cloudfront_origins_1 = require("@aws-cdk/aws-cloudfront-origins");
const aws_ec2_1 = require("@aws-cdk/aws-ec2");
const aws_ecs_1 = require("@aws-cdk/aws-ecs");
const aws_elasticloadbalancingv2_1 = require("@aws-cdk/aws-elasticloadbalancingv2");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const aws_logs_1 = require("@aws-cdk/aws-logs");
const aws_s3_1 = require("@aws-cdk/aws-s3");
const core_1 = require("@aws-cdk/core");
const dns_1 = require("./dns");
const CUSTOM_HTTP_HEADER = 'X_Request_From_CloudFront';
class Application extends core_1.Construct {
    constructor(scope, id, props) {
        var _b, _c, _d, _e;
        super(scope, id);
        const stack = core_1.Stack.of(this);
        this.domainName = props.domainName;
        this.domainZone = props.domainZone;
        this.cloudFrontHashHeader = (_b = props.cloudFrontHashHeader) !== null && _b !== void 0 ? _b : Buffer.from(`${stack.stackName}.${this.domainName}`).toString('base64');
        this.removalPolicy = props.removalPolicy;
        const cluster = new aws_ecs_1.Cluster(this, 'Cluster', {
            containerInsights: true,
            vpc: props.vpc,
        });
        this.targetGroup = new aws_elasticloadbalancingv2_1.ApplicationTargetGroup(this, 'TargetGroup', {
            vpc: props.vpc,
            port: 80,
            targetType: aws_elasticloadbalancingv2_1.TargetType.IP,
            stickinessCookieDuration: core_1.Duration.days(7),
        });
        this.targetGroup.configureHealthCheck({
            path: '/wp-includes/images/blank.gif',
            interval: core_1.Duration.minutes(1),
        });
        const loadBalancer = new aws_elasticloadbalancingv2_1.ApplicationLoadBalancer(this, 'Loadbalancer', {
            vpc: props.vpc,
            internetFacing: true,
            http2Enabled: true,
        });
        this.listener = loadBalancer.addListener('Listener', {
            port: 443,
            protocol: aws_elasticloadbalancingv2_1.ApplicationProtocol.HTTPS,
            certificates: [
                aws_elasticloadbalancingv2_1.ListenerCertificate.fromCertificateManager(new aws_certificatemanager_1.Certificate(this, 'LBCertificate', {
                    domainName: this.domainName,
                    validation: aws_certificatemanager_1.CertificateValidation.fromDns(this.domainZone),
                })),
            ],
            sslPolicy: aws_elasticloadbalancingv2_1.SslPolicy.FORWARD_SECRECY_TLS12,
            defaultAction: aws_elasticloadbalancingv2_1.ListenerAction.fixedResponse(403, {
                contentType: 'text/plain',
                messageBody: 'Access denied',
            }),
        });
        this.listener.addAction('Cloudfornt', {
            action: aws_elasticloadbalancingv2_1.ListenerAction.forward([this.targetGroup]),
            conditions: [aws_elasticloadbalancingv2_1.ListenerCondition.httpHeader(CUSTOM_HTTP_HEADER, [this.cloudFrontHashHeader])],
            priority: 100,
        });
        const taskDefinition = new aws_ecs_1.FargateTaskDefinition(this, 'TaskDefinition', {
            memoryLimitMiB: (_c = props.memoryLimitMiB) !== null && _c !== void 0 ? _c : 512,
            cpu: 256,
            volumes: [props.volume],
        });
        const container = taskDefinition.addContainer('Wordpress', {
            image: (_d = props.image) !== null && _d !== void 0 ? _d : aws_ecs_1.ContainerImage.fromRegistry('wordpress:5.8-apache'),
            environment: {
                ...props.environment,
                ...props.database.environment,
            },
            secrets: {
                ...props.secrets,
                ...props.database.secrets,
            },
            logging: (_e = props.logDriver) !== null && _e !== void 0 ? _e : aws_ecs_1.LogDriver.awsLogs({
                streamPrefix: `${stack.stackName}WordpressContainerLog`,
                logRetention: aws_logs_1.RetentionDays.ONE_MONTH,
            }),
        });
        container.addPortMappings({
            containerPort: 80,
        });
        container.addMountPoints({
            containerPath: '/var/www/html',
            readOnly: false,
            sourceVolume: props.volume.name,
        });
        this.service = new aws_ecs_1.FargateService(this, 'Service', {
            cluster,
            serviceName: props.serviceName,
            taskDefinition,
            desiredCount: 2,
        });
        this.service.connections.allowFrom(loadBalancer, aws_ec2_1.Port.tcp(80));
        this.targetGroup.addTarget(this.service);
        const origin = new aws_cloudfront_origins_1.LoadBalancerV2Origin(loadBalancer, {
            originSslProtocols: [aws_cloudfront_1.OriginSslPolicy.TLS_V1_2],
            customHeaders: {
                [CUSTOM_HTTP_HEADER]: this.cloudFrontHashHeader,
            },
            readTimeout: core_1.Duration.seconds(60),
            protocolPolicy: aws_cloudfront_1.OriginProtocolPolicy.HTTPS_ONLY,
        });
        this.distribution = new aws_cloudfront_1.Distribution(this, 'WorpdressDistribution', {
            comment: 'wordpress cdn',
            defaultBehavior: {
                origin,
                originRequestPolicy: new aws_cloudfront_1.OriginRequestPolicy(this, 'OriginRequestPolicy', {
                    originRequestPolicyName: 'WordpressDefaultBehavior',
                    cookieBehavior: aws_cloudfront_1.OriginRequestCookieBehavior.allowList('comment_*', 'wordpress_*', 'wp-settings-*'),
                    headerBehavior: aws_cloudfront_1.OriginRequestHeaderBehavior.allowList('Host', 'CloudFront-Forwarded-Proto', 'CloudFront-Is-Mobile-Viewer', 'CloudFront-Is-Tablet-Viewer', 'CloudFront-Is-Desktop-Viewer'),
                    queryStringBehavior: aws_cloudfront_1.OriginRequestQueryStringBehavior.all(),
                }),
                allowedMethods: aws_cloudfront_1.AllowedMethods.ALLOW_ALL,
                cachedMethods: aws_cloudfront_1.CachedMethods.CACHE_GET_HEAD_OPTIONS,
                viewerProtocolPolicy: aws_cloudfront_1.ViewerProtocolPolicy.REDIRECT_TO_HTTPS,
            },
            additionalBehaviors: {
                'wp-admin/*': {
                    origin,
                    originRequestPolicy: aws_cloudfront_1.OriginRequestPolicy.ALL_VIEWER,
                    allowedMethods: aws_cloudfront_1.AllowedMethods.ALLOW_ALL,
                    cachedMethods: aws_cloudfront_1.CachedMethods.CACHE_GET_HEAD_OPTIONS,
                    viewerProtocolPolicy: aws_cloudfront_1.ViewerProtocolPolicy.REDIRECT_TO_HTTPS,
                },
                'wp-login.php': {
                    origin,
                    originRequestPolicy: aws_cloudfront_1.OriginRequestPolicy.ALL_VIEWER,
                    allowedMethods: aws_cloudfront_1.AllowedMethods.ALLOW_ALL,
                    cachedMethods: aws_cloudfront_1.CachedMethods.CACHE_GET_HEAD_OPTIONS,
                    viewerProtocolPolicy: aws_cloudfront_1.ViewerProtocolPolicy.REDIRECT_TO_HTTPS,
                },
            },
            enableIpv6: true,
            httpVersion: aws_cloudfront_1.HttpVersion.HTTP2,
            certificate: props.certificate,
            domainNames: [this.domainName],
            priceClass: aws_cloudfront_1.PriceClass.PRICE_CLASS_100,
        });
        new dns_1.Dns(this, 'WordpressDns', {
            domainName: this.domainName,
            domainZone: this.domainZone,
            distribution: this.distribution,
        });
    }
    enableStaticContentOffload(domainName, certificate) {
        const bucket = new aws_s3_1.Bucket(this, 'Bucket', {
            encryption: aws_s3_1.BucketEncryption.S3_MANAGED,
            versioned: true,
            removalPolicy: this.removalPolicy,
            autoDeleteObjects: this.removalPolicy === core_1.RemovalPolicy.DESTROY,
        });
        bucket.grantReadWrite(this.service.taskDefinition.taskRole);
        this.service.taskDefinition.taskRole.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['s3:GetBucketLocation'],
            resources: [bucket.bucketArn],
        }));
        const distribution = new aws_cloudfront_1.Distribution(this, 'StaticContentDistribution', {
            comment: 'static content cdn',
            defaultBehavior: {
                origin: new aws_cloudfront_origins_1.S3Origin(bucket),
                allowedMethods: aws_cloudfront_1.AllowedMethods.ALLOW_GET_HEAD,
                cachedMethods: aws_cloudfront_1.CachedMethods.CACHE_GET_HEAD,
                viewerProtocolPolicy: aws_cloudfront_1.ViewerProtocolPolicy.REDIRECT_TO_HTTPS,
            },
            enableIpv6: true,
            httpVersion: aws_cloudfront_1.HttpVersion.HTTP2,
            certificate,
            domainNames: [domainName],
            priceClass: aws_cloudfront_1.PriceClass.PRICE_CLASS_100,
        });
        new dns_1.Dns(this, 'StaticContentDns', {
            domainName: domainName,
            domainZone: this.domainZone,
            distribution,
        });
        return {
            domainName,
            distribution,
        };
    }
}
exports.Application = Application;
_a = JSII_RTTI_SYMBOL_1;
Application[_a] = { fqn: "@cloudcomponents/cdk-wordpress.Application", version: "1.42.0" };
//# sourceMappingURL=data:application/json;base64,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