import { ICertificate } from '@aws-cdk/aws-certificatemanager';
import { IDistribution } from '@aws-cdk/aws-cloudfront';
import { IVpc } from '@aws-cdk/aws-ec2';
import { ContainerImage, FargateService, LogDriver, Secret } from '@aws-cdk/aws-ecs';
import { ApplicationListener, ApplicationTargetGroup } from '@aws-cdk/aws-elasticloadbalancingv2';
import { IHostedZone } from '@aws-cdk/aws-route53';
import { Construct, RemovalPolicy } from '@aws-cdk/core';
import { Database } from './database';
import { EfsVolume } from './efs-volume';
export interface ApplicationProps {
    readonly domainName: string;
    readonly domainZone: IHostedZone;
    readonly certificate: ICertificate;
    readonly vpc: IVpc;
    readonly volume: EfsVolume;
    readonly database: Database;
    readonly image?: ContainerImage;
    readonly serviceName?: string;
    readonly memoryLimitMiB?: number;
    readonly environment?: Record<string, string>;
    readonly secrets?: Record<string, Secret>;
    readonly logDriver?: LogDriver;
    readonly cloudFrontHashHeader?: string;
    readonly removalPolicy?: RemovalPolicy;
}
export interface StaticContentOffload {
    readonly domainName: string;
    readonly distribution: IDistribution;
}
export declare class Application extends Construct {
    readonly domainName: string;
    readonly domainZone: IHostedZone;
    readonly distribution: IDistribution;
    readonly service: FargateService;
    readonly targetGroup: ApplicationTargetGroup;
    readonly listener: ApplicationListener;
    private readonly cloudFrontHashHeader;
    private readonly removalPolicy?;
    constructor(scope: Construct, id: string, props: ApplicationProps);
    enableStaticContentOffload(domainName: string, certificate: ICertificate): StaticContentOffload;
}
