"use strict";
const lib_1 = require("../lib");
module.exports = {
    'boolean type'(test) {
        test.equals(lib_1.Schema.BOOLEAN.inputString, 'boolean');
        test.equals(lib_1.Schema.BOOLEAN.isPrimitive, true);
        test.done();
    },
    'binary type'(test) {
        test.equals(lib_1.Schema.BINARY.inputString, 'binary');
        test.equals(lib_1.Schema.BINARY.isPrimitive, true);
        test.done();
    },
    'bigint type'(test) {
        test.equals(lib_1.Schema.BIG_INT.inputString, 'bigint');
        test.equals(lib_1.Schema.BIG_INT.isPrimitive, true);
        test.done();
    },
    'double type'(test) {
        test.equals(lib_1.Schema.DOUBLE.inputString, 'double');
        test.equals(lib_1.Schema.DOUBLE.isPrimitive, true);
        test.done();
    },
    'float type'(test) {
        test.equals(lib_1.Schema.FLOAT.inputString, 'float');
        test.equals(lib_1.Schema.FLOAT.isPrimitive, true);
        test.done();
    },
    'integer type'(test) {
        test.equals(lib_1.Schema.INTEGER.inputString, 'int');
        test.equals(lib_1.Schema.INTEGER.isPrimitive, true);
        test.done();
    },
    'smallint type'(test) {
        test.equals(lib_1.Schema.SMALL_INT.inputString, 'smallint');
        test.equals(lib_1.Schema.SMALL_INT.isPrimitive, true);
        test.done();
    },
    'tinyint type'(test) {
        test.equals(lib_1.Schema.TINY_INT.inputString, 'tinyint');
        test.equals(lib_1.Schema.TINY_INT.isPrimitive, true);
        test.done();
    },
    'decimal type'(test) {
        test.equals(lib_1.Schema.decimal(16).inputString, 'decimal(16)');
        test.equals(lib_1.Schema.decimal(16, 1).inputString, 'decimal(16,1)');
        test.equals(lib_1.Schema.decimal(16).isPrimitive, true);
        test.equals(lib_1.Schema.decimal(16, 1).isPrimitive, true);
        test.done();
    },
    // TODO: decimal bounds
    'date type'(test) {
        test.equals(lib_1.Schema.DATE.inputString, 'date');
        test.equals(lib_1.Schema.DATE.isPrimitive, true);
        test.done();
    },
    'timestamp type'(test) {
        test.equals(lib_1.Schema.TIMESTAMP.inputString, 'timestamp');
        test.equals(lib_1.Schema.TIMESTAMP.isPrimitive, true);
        test.done();
    },
    'string type'(test) {
        test.equals(lib_1.Schema.STRING.inputString, 'string');
        test.equals(lib_1.Schema.STRING.isPrimitive, true);
        test.done();
    },
    'char type'(test) {
        test.equals(lib_1.Schema.char(1).inputString, 'char(1)');
        test.equals(lib_1.Schema.char(1).isPrimitive, true);
        test.done();
    },
    'char length must be at least 1'(test) {
        test.doesNotThrow(() => lib_1.Schema.char(1));
        test.throws(() => lib_1.Schema.char(0));
        test.throws(() => lib_1.Schema.char(-1));
        test.done();
    },
    'char length must be <= 255'(test) {
        test.doesNotThrow(() => lib_1.Schema.char(255));
        test.throws(() => lib_1.Schema.char(256));
        test.done();
    },
    'varchar type'(test) {
        test.equals(lib_1.Schema.varchar(1).inputString, 'varchar(1)');
        test.equals(lib_1.Schema.varchar(1).isPrimitive, true);
        test.done();
    },
    'varchar length must be at least 1'(test) {
        test.doesNotThrow(() => lib_1.Schema.varchar(1));
        test.throws(() => lib_1.Schema.varchar(0));
        test.throws(() => lib_1.Schema.varchar(-1));
        test.done();
    },
    'varchar length must be <= 65535'(test) {
        test.doesNotThrow(() => lib_1.Schema.varchar(65535));
        test.throws(() => lib_1.Schema.varchar(65536));
        test.done();
    },
    'array<string>'(test) {
        const type = lib_1.Schema.array(lib_1.Schema.STRING);
        test.equals(type.inputString, 'array<string>');
        test.equals(type.isPrimitive, false);
        test.done();
    },
    'array<char(1)>'(test) {
        const type = lib_1.Schema.array(lib_1.Schema.char(1));
        test.equals(type.inputString, 'array<char(1)>');
        test.equals(type.isPrimitive, false);
        test.done();
    },
    'array<array>'(test) {
        const type = lib_1.Schema.array(lib_1.Schema.array(lib_1.Schema.STRING));
        test.equals(type.inputString, 'array<array<string>>');
        test.equals(type.isPrimitive, false);
        test.done();
    },
    'array<map>'(test) {
        const type = lib_1.Schema.array(lib_1.Schema.map(lib_1.Schema.STRING, lib_1.Schema.STRING));
        test.equals(type.inputString, 'array<map<string,string>>');
        test.equals(type.isPrimitive, false);
        test.done();
    },
    'array<struct>'(test) {
        const type = lib_1.Schema.array(lib_1.Schema.struct([{
                name: 'key',
                type: lib_1.Schema.STRING,
            }]));
        test.equals(type.inputString, 'array<struct<key:string>>');
        test.equals(type.isPrimitive, false);
        test.done();
    },
    'map<string,string>'(test) {
        const type = lib_1.Schema.map(lib_1.Schema.STRING, lib_1.Schema.STRING);
        test.equals(type.inputString, 'map<string,string>');
        test.equals(type.isPrimitive, false);
        test.done();
    },
    'map<int,string>'(test) {
        const type = lib_1.Schema.map(lib_1.Schema.INTEGER, lib_1.Schema.STRING);
        test.equals(type.inputString, 'map<int,string>');
        test.equals(type.isPrimitive, false);
        test.done();
    },
    'map<char(1),char(1)>'(test) {
        const type = lib_1.Schema.map(lib_1.Schema.char(1), lib_1.Schema.char(1));
        test.equals(type.inputString, 'map<char(1),char(1)>');
        test.equals(type.isPrimitive, false);
        test.done();
    },
    'map<string,array>'(test) {
        const type = lib_1.Schema.map(lib_1.Schema.char(1), lib_1.Schema.array(lib_1.Schema.STRING));
        test.equals(type.inputString, 'map<char(1),array<string>>');
        test.equals(type.isPrimitive, false);
        test.done();
    },
    'map<string,map>'(test) {
        const type = lib_1.Schema.map(lib_1.Schema.char(1), lib_1.Schema.map(lib_1.Schema.STRING, lib_1.Schema.STRING));
        test.equals(type.inputString, 'map<char(1),map<string,string>>');
        test.equals(type.isPrimitive, false);
        test.done();
    },
    'map<string,struct>'(test) {
        const type = lib_1.Schema.map(lib_1.Schema.char(1), lib_1.Schema.struct([{
                name: 'key',
                type: lib_1.Schema.STRING,
            }]));
        test.equals(type.inputString, 'map<char(1),struct<key:string>>');
        test.equals(type.isPrimitive, false);
        test.done();
    },
    'map throws if keyType is non-primitive'(test) {
        test.throws(() => lib_1.Schema.map(lib_1.Schema.array(lib_1.Schema.STRING), lib_1.Schema.STRING));
        test.throws(() => lib_1.Schema.map(lib_1.Schema.map(lib_1.Schema.STRING, lib_1.Schema.STRING), lib_1.Schema.STRING));
        test.throws(() => lib_1.Schema.map(lib_1.Schema.struct([{
                name: 'key',
                type: lib_1.Schema.STRING,
            }]), lib_1.Schema.STRING));
        test.done();
    },
    'struct type'(test) {
        const type = lib_1.Schema.struct([{
                name: 'primitive',
                type: lib_1.Schema.STRING,
            }, {
                name: 'with_comment',
                type: lib_1.Schema.STRING,
                comment: 'this has a comment',
            }, {
                name: 'array',
                type: lib_1.Schema.array(lib_1.Schema.STRING),
            }, {
                name: 'map',
                type: lib_1.Schema.map(lib_1.Schema.STRING, lib_1.Schema.STRING),
            }, {
                name: 'nested_struct',
                type: lib_1.Schema.struct([{
                        name: 'nested',
                        type: lib_1.Schema.STRING,
                        comment: 'nested comment',
                    }]),
            }]);
        test.equals(type.isPrimitive, false);
        test.equals(type.inputString, 
        // tslint:disable-next-line:max-line-length
        'struct<primitive:string,with_comment:string COMMENT \'this has a comment\',array:array<string>,map:map<string,string>,nested_struct:struct<nested:string COMMENT \'nested comment\'>>');
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVzdC5zY2hlbWEuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ0ZXN0LnNjaGVtYS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBRUEsZ0NBQWdDO0FBRWhDLGlCQUFTO0lBQ1AsY0FBYyxDQUFDLElBQVU7UUFDdkIsSUFBSSxDQUFDLE1BQU0sQ0FBQyxZQUFNLENBQUMsT0FBTyxDQUFDLFdBQVcsRUFBRSxTQUFTLENBQUMsQ0FBQztRQUNuRCxJQUFJLENBQUMsTUFBTSxDQUFDLFlBQU0sQ0FBQyxPQUFPLENBQUMsV0FBVyxFQUFFLElBQUksQ0FBQyxDQUFDO1FBQzlDLElBQUksQ0FBQyxJQUFJLEVBQUUsQ0FBQztJQUNkLENBQUM7SUFFRCxhQUFhLENBQUMsSUFBVTtRQUN0QixJQUFJLENBQUMsTUFBTSxDQUFDLFlBQU0sQ0FBQyxNQUFNLENBQUMsV0FBVyxFQUFFLFFBQVEsQ0FBQyxDQUFDO1FBQ2pELElBQUksQ0FBQyxNQUFNLENBQUMsWUFBTSxDQUFDLE1BQU0sQ0FBQyxXQUFXLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDN0MsSUFBSSxDQUFDLElBQUksRUFBRSxDQUFDO0lBQ2QsQ0FBQztJQUVELGFBQWEsQ0FBQyxJQUFVO1FBQ3RCLElBQUksQ0FBQyxNQUFNLENBQUMsWUFBTSxDQUFDLE9BQU8sQ0FBQyxXQUFXLEVBQUUsUUFBUSxDQUFDLENBQUM7UUFDbEQsSUFBSSxDQUFDLE1BQU0sQ0FBQyxZQUFNLENBQUMsT0FBTyxDQUFDLFdBQVcsRUFBRSxJQUFJLENBQUMsQ0FBQztRQUM5QyxJQUFJLENBQUMsSUFBSSxFQUFFLENBQUM7SUFDZCxDQUFDO0lBRUQsYUFBYSxDQUFDLElBQVU7UUFDdEIsSUFBSSxDQUFDLE1BQU0sQ0FBQyxZQUFNLENBQUMsTUFBTSxDQUFDLFdBQVcsRUFBRSxRQUFRLENBQUMsQ0FBQztRQUNqRCxJQUFJLENBQUMsTUFBTSxDQUFDLFlBQU0sQ0FBQyxNQUFNLENBQUMsV0FBVyxFQUFFLElBQUksQ0FBQyxDQUFDO1FBQzdDLElBQUksQ0FBQyxJQUFJLEVBQUUsQ0FBQztJQUNkLENBQUM7SUFFRCxZQUFZLENBQUMsSUFBVTtRQUNyQixJQUFJLENBQUMsTUFBTSxDQUFDLFlBQU0sQ0FBQyxLQUFLLENBQUMsV0FBVyxFQUFFLE9BQU8sQ0FBQyxDQUFDO1FBQy9DLElBQUksQ0FBQyxNQUFNLENBQUMsWUFBTSxDQUFDLEtBQUssQ0FBQyxXQUFXLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDNUMsSUFBSSxDQUFDLElBQUksRUFBRSxDQUFDO0lBQ2QsQ0FBQztJQUVELGNBQWMsQ0FBQyxJQUFVO1FBQ3ZCLElBQUksQ0FBQyxNQUFNLENBQUMsWUFBTSxDQUFDLE9BQU8sQ0FBQyxXQUFXLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFDL0MsSUFBSSxDQUFDLE1BQU0sQ0FBQyxZQUFNLENBQUMsT0FBTyxDQUFDLFdBQVcsRUFBRSxJQUFJLENBQUMsQ0FBQztRQUM5QyxJQUFJLENBQUMsSUFBSSxFQUFFLENBQUM7SUFDZCxDQUFDO0lBRUQsZUFBZSxDQUFDLElBQVU7UUFDeEIsSUFBSSxDQUFDLE1BQU0sQ0FBQyxZQUFNLENBQUMsU0FBUyxDQUFDLFdBQVcsRUFBRSxVQUFVLENBQUMsQ0FBQztRQUN0RCxJQUFJLENBQUMsTUFBTSxDQUFDLFlBQU0sQ0FBQyxTQUFTLENBQUMsV0FBVyxFQUFFLElBQUksQ0FBQyxDQUFDO1FBQ2hELElBQUksQ0FBQyxJQUFJLEVBQUUsQ0FBQztJQUNkLENBQUM7SUFFRCxjQUFjLENBQUMsSUFBVTtRQUN2QixJQUFJLENBQUMsTUFBTSxDQUFDLFlBQU0sQ0FBQyxRQUFRLENBQUMsV0FBVyxFQUFFLFNBQVMsQ0FBQyxDQUFDO1FBQ3BELElBQUksQ0FBQyxNQUFNLENBQUMsWUFBTSxDQUFDLFFBQVEsQ0FBQyxXQUFXLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDL0MsSUFBSSxDQUFDLElBQUksRUFBRSxDQUFDO0lBQ2QsQ0FBQztJQUVELGNBQWMsQ0FBQyxJQUFVO1FBQ3ZCLElBQUksQ0FBQyxNQUFNLENBQUMsWUFBTSxDQUFDLE9BQU8sQ0FBQyxFQUFFLENBQUMsQ0FBQyxXQUFXLEVBQUUsYUFBYSxDQUFDLENBQUM7UUFDM0QsSUFBSSxDQUFDLE1BQU0sQ0FBQyxZQUFNLENBQUMsT0FBTyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxXQUFXLEVBQUUsZUFBZSxDQUFDLENBQUM7UUFDaEUsSUFBSSxDQUFDLE1BQU0sQ0FBQyxZQUFNLENBQUMsT0FBTyxDQUFDLEVBQUUsQ0FBQyxDQUFDLFdBQVcsRUFBRSxJQUFJLENBQUMsQ0FBQztRQUNsRCxJQUFJLENBQUMsTUFBTSxDQUFDLFlBQU0sQ0FBQyxPQUFPLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLFdBQVcsRUFBRSxJQUFJLENBQUMsQ0FBQztRQUNyRCxJQUFJLENBQUMsSUFBSSxFQUFFLENBQUM7SUFDZCxDQUFDO0lBQ0QsdUJBQXVCO0lBRXZCLFdBQVcsQ0FBQyxJQUFVO1FBQ3BCLElBQUksQ0FBQyxNQUFNLENBQUMsWUFBTSxDQUFDLElBQUksQ0FBQyxXQUFXLEVBQUUsTUFBTSxDQUFDLENBQUM7UUFDN0MsSUFBSSxDQUFDLE1BQU0sQ0FBQyxZQUFNLENBQUMsSUFBSSxDQUFDLFdBQVcsRUFBRSxJQUFJLENBQUMsQ0FBQztRQUMzQyxJQUFJLENBQUMsSUFBSSxFQUFFLENBQUM7SUFDZCxDQUFDO0lBRUQsZ0JBQWdCLENBQUMsSUFBVTtRQUN6QixJQUFJLENBQUMsTUFBTSxDQUFDLFlBQU0sQ0FBQyxTQUFTLENBQUMsV0FBVyxFQUFFLFdBQVcsQ0FBQyxDQUFDO1FBQ3ZELElBQUksQ0FBQyxNQUFNLENBQUMsWUFBTSxDQUFDLFNBQVMsQ0FBQyxXQUFXLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDaEQsSUFBSSxDQUFDLElBQUksRUFBRSxDQUFDO0lBQ2QsQ0FBQztJQUVELGFBQWEsQ0FBQyxJQUFVO1FBQ3RCLElBQUksQ0FBQyxNQUFNLENBQUMsWUFBTSxDQUFDLE1BQU0sQ0FBQyxXQUFXLEVBQUUsUUFBUSxDQUFDLENBQUM7UUFDakQsSUFBSSxDQUFDLE1BQU0sQ0FBQyxZQUFNLENBQUMsTUFBTSxDQUFDLFdBQVcsRUFBRSxJQUFJLENBQUMsQ0FBQztRQUM3QyxJQUFJLENBQUMsSUFBSSxFQUFFLENBQUM7SUFDZCxDQUFDO0lBRUQsV0FBVyxDQUFDLElBQVU7UUFDcEIsSUFBSSxDQUFDLE1BQU0sQ0FBQyxZQUFNLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLFdBQVcsRUFBRSxTQUFTLENBQUMsQ0FBQztRQUNuRCxJQUFJLENBQUMsTUFBTSxDQUFDLFlBQU0sQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUMsV0FBVyxFQUFFLElBQUksQ0FBQyxDQUFDO1FBQzlDLElBQUksQ0FBQyxJQUFJLEVBQUUsQ0FBQztJQUNkLENBQUM7SUFFRCxnQ0FBZ0MsQ0FBQyxJQUFVO1FBQ3pDLElBQUksQ0FBQyxZQUFZLENBQUMsR0FBRyxFQUFFLENBQUMsWUFBTSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO1FBQ3hDLElBQUksQ0FBQyxNQUFNLENBQUMsR0FBRyxFQUFFLENBQUMsWUFBTSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO1FBQ2xDLElBQUksQ0FBQyxNQUFNLENBQUMsR0FBRyxFQUFFLENBQUMsWUFBTSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFDbkMsSUFBSSxDQUFDLElBQUksRUFBRSxDQUFDO0lBQ2QsQ0FBQztJQUVELDRCQUE0QixDQUFDLElBQVU7UUFDckMsSUFBSSxDQUFDLFlBQVksQ0FBQyxHQUFHLEVBQUUsQ0FBQyxZQUFNLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUM7UUFDMUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxHQUFHLEVBQUUsQ0FBQyxZQUFNLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUM7UUFDcEMsSUFBSSxDQUFDLElBQUksRUFBRSxDQUFDO0lBQ2QsQ0FBQztJQUVELGNBQWMsQ0FBQyxJQUFVO1FBQ3ZCLElBQUksQ0FBQyxNQUFNLENBQUMsWUFBTSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQyxXQUFXLEVBQUUsWUFBWSxDQUFDLENBQUM7UUFDekQsSUFBSSxDQUFDLE1BQU0sQ0FBQyxZQUFNLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDLFdBQVcsRUFBRSxJQUFJLENBQUMsQ0FBQztRQUNqRCxJQUFJLENBQUMsSUFBSSxFQUFFLENBQUM7SUFDZCxDQUFDO0lBRUQsbUNBQW1DLENBQUMsSUFBVTtRQUM1QyxJQUFJLENBQUMsWUFBWSxDQUFDLEdBQUcsRUFBRSxDQUFDLFlBQU0sQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztRQUMzQyxJQUFJLENBQUMsTUFBTSxDQUFDLEdBQUcsRUFBRSxDQUFDLFlBQU0sQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztRQUNyQyxJQUFJLENBQUMsTUFBTSxDQUFDLEdBQUcsRUFBRSxDQUFDLFlBQU0sQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO1FBQ3RDLElBQUksQ0FBQyxJQUFJLEVBQUUsQ0FBQztJQUNkLENBQUM7SUFFRCxpQ0FBaUMsQ0FBQyxJQUFVO1FBQzFDLElBQUksQ0FBQyxZQUFZLENBQUMsR0FBRyxFQUFFLENBQUMsWUFBTSxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDO1FBQy9DLElBQUksQ0FBQyxNQUFNLENBQUMsR0FBRyxFQUFFLENBQUMsWUFBTSxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDO1FBQ3pDLElBQUksQ0FBQyxJQUFJLEVBQUUsQ0FBQztJQUNkLENBQUM7SUFFRCxlQUFlLENBQUMsSUFBVTtRQUN4QixNQUFNLElBQUksR0FBRyxZQUFNLENBQUMsS0FBSyxDQUFDLFlBQU0sQ0FBQyxNQUFNLENBQUMsQ0FBQztRQUN6QyxJQUFJLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxXQUFXLEVBQUUsZUFBZSxDQUFDLENBQUM7UUFDL0MsSUFBSSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsV0FBVyxFQUFFLEtBQUssQ0FBQyxDQUFDO1FBQ3JDLElBQUksQ0FBQyxJQUFJLEVBQUUsQ0FBQztJQUNkLENBQUM7SUFFRCxnQkFBZ0IsQ0FBQyxJQUFVO1FBQ3pCLE1BQU0sSUFBSSxHQUFHLFlBQU0sQ0FBQyxLQUFLLENBQUMsWUFBTSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO1FBQzFDLElBQUksQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLFdBQVcsRUFBRSxnQkFBZ0IsQ0FBQyxDQUFDO1FBQ2hELElBQUksQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLFdBQVcsRUFBRSxLQUFLLENBQUMsQ0FBQztRQUNyQyxJQUFJLENBQUMsSUFBSSxFQUFFLENBQUM7SUFDZCxDQUFDO0lBRUQsY0FBYyxDQUFDLElBQVU7UUFDdkIsTUFBTSxJQUFJLEdBQUcsWUFBTSxDQUFDLEtBQUssQ0FDdkIsWUFBTSxDQUFDLEtBQUssQ0FBQyxZQUFNLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQztRQUMvQixJQUFJLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxXQUFXLEVBQUUsc0JBQXNCLENBQUMsQ0FBQztRQUN0RCxJQUFJLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxXQUFXLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFDckMsSUFBSSxDQUFDLElBQUksRUFBRSxDQUFDO0lBQ2QsQ0FBQztJQUVELFlBQVksQ0FBQyxJQUFVO1FBQ3JCLE1BQU0sSUFBSSxHQUFHLFlBQU0sQ0FBQyxLQUFLLENBQ3ZCLFlBQU0sQ0FBQyxHQUFHLENBQUMsWUFBTSxDQUFDLE1BQU0sRUFBRSxZQUFNLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQztRQUM1QyxJQUFJLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxXQUFXLEVBQUUsMkJBQTJCLENBQUMsQ0FBQztRQUMzRCxJQUFJLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxXQUFXLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFDckMsSUFBSSxDQUFDLElBQUksRUFBRSxDQUFDO0lBQ2QsQ0FBQztJQUVELGVBQWUsQ0FBQyxJQUFVO1FBQ3hCLE1BQU0sSUFBSSxHQUFHLFlBQU0sQ0FBQyxLQUFLLENBQ3ZCLFlBQU0sQ0FBQyxNQUFNLENBQUMsQ0FBQztnQkFDYixJQUFJLEVBQUUsS0FBSztnQkFDWCxJQUFJLEVBQUUsWUFBTSxDQUFDLE1BQU07YUFDcEIsQ0FBQyxDQUFDLENBQUMsQ0FBQztRQUNQLElBQUksQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLFdBQVcsRUFBRSwyQkFBMkIsQ0FBQyxDQUFDO1FBQzNELElBQUksQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLFdBQVcsRUFBRSxLQUFLLENBQUMsQ0FBQztRQUNyQyxJQUFJLENBQUMsSUFBSSxFQUFFLENBQUM7SUFDZCxDQUFDO0lBRUQsb0JBQW9CLENBQUMsSUFBVTtRQUM3QixNQUFNLElBQUksR0FBRyxZQUFNLENBQUMsR0FBRyxDQUNyQixZQUFNLENBQUMsTUFBTSxFQUNiLFlBQU0sQ0FBQyxNQUFNLENBQ2QsQ0FBQztRQUNGLElBQUksQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLFdBQVcsRUFBRSxvQkFBb0IsQ0FBQyxDQUFDO1FBQ3BELElBQUksQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLFdBQVcsRUFBRSxLQUFLLENBQUMsQ0FBQztRQUNyQyxJQUFJLENBQUMsSUFBSSxFQUFFLENBQUM7SUFDZCxDQUFDO0lBRUQsaUJBQWlCLENBQUMsSUFBVTtRQUMxQixNQUFNLElBQUksR0FBRyxZQUFNLENBQUMsR0FBRyxDQUNyQixZQUFNLENBQUMsT0FBTyxFQUNkLFlBQU0sQ0FBQyxNQUFNLENBQ2QsQ0FBQztRQUNGLElBQUksQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLFdBQVcsRUFBRSxpQkFBaUIsQ0FBQyxDQUFDO1FBQ2pELElBQUksQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLFdBQVcsRUFBRSxLQUFLLENBQUMsQ0FBQztRQUNyQyxJQUFJLENBQUMsSUFBSSxFQUFFLENBQUM7SUFDZCxDQUFDO0lBRUQsc0JBQXNCLENBQUMsSUFBVTtRQUMvQixNQUFNLElBQUksR0FBRyxZQUFNLENBQUMsR0FBRyxDQUNyQixZQUFNLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUNkLFlBQU0sQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQ2YsQ0FBQztRQUNGLElBQUksQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLFdBQVcsRUFBRSxzQkFBc0IsQ0FBQyxDQUFDO1FBQ3RELElBQUksQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLFdBQVcsRUFBRSxLQUFLLENBQUMsQ0FBQztRQUNyQyxJQUFJLENBQUMsSUFBSSxFQUFFLENBQUM7SUFDZCxDQUFDO0lBRUQsbUJBQW1CLENBQUMsSUFBVTtRQUM1QixNQUFNLElBQUksR0FBRyxZQUFNLENBQUMsR0FBRyxDQUNyQixZQUFNLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUNkLFlBQU0sQ0FBQyxLQUFLLENBQUMsWUFBTSxDQUFDLE1BQU0sQ0FBQyxDQUM1QixDQUFDO1FBQ0YsSUFBSSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsV0FBVyxFQUFFLDRCQUE0QixDQUFDLENBQUM7UUFDNUQsSUFBSSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsV0FBVyxFQUFFLEtBQUssQ0FBQyxDQUFDO1FBQ3JDLElBQUksQ0FBQyxJQUFJLEVBQUUsQ0FBQztJQUNkLENBQUM7SUFFRCxpQkFBaUIsQ0FBQyxJQUFVO1FBQzFCLE1BQU0sSUFBSSxHQUFHLFlBQU0sQ0FBQyxHQUFHLENBQ3JCLFlBQU0sQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQ2QsWUFBTSxDQUFDLEdBQUcsQ0FDUixZQUFNLENBQUMsTUFBTSxFQUNiLFlBQU0sQ0FBQyxNQUFNLENBQUMsQ0FDakIsQ0FBQztRQUNGLElBQUksQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLFdBQVcsRUFBRSxpQ0FBaUMsQ0FBQyxDQUFDO1FBQ2pFLElBQUksQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLFdBQVcsRUFBRSxLQUFLLENBQUMsQ0FBQztRQUNyQyxJQUFJLENBQUMsSUFBSSxFQUFFLENBQUM7SUFDZCxDQUFDO0lBRUQsb0JBQW9CLENBQUMsSUFBVTtRQUM3QixNQUFNLElBQUksR0FBRyxZQUFNLENBQUMsR0FBRyxDQUNyQixZQUFNLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUNkLFlBQU0sQ0FBQyxNQUFNLENBQUMsQ0FBQztnQkFDYixJQUFJLEVBQUUsS0FBSztnQkFDWCxJQUFJLEVBQUUsWUFBTSxDQUFDLE1BQU07YUFDcEIsQ0FBQyxDQUFDLENBQ0osQ0FBQztRQUNGLElBQUksQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLFdBQVcsRUFBRSxpQ0FBaUMsQ0FBQyxDQUFDO1FBQ2pFLElBQUksQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLFdBQVcsRUFBRSxLQUFLLENBQUMsQ0FBQztRQUNyQyxJQUFJLENBQUMsSUFBSSxFQUFFLENBQUM7SUFDZCxDQUFDO0lBRUQsd0NBQXdDLENBQUMsSUFBVTtRQUNqRCxJQUFJLENBQUMsTUFBTSxDQUFDLEdBQUcsRUFBRSxDQUFDLFlBQU0sQ0FBQyxHQUFHLENBQzFCLFlBQU0sQ0FBQyxLQUFLLENBQUMsWUFBTSxDQUFDLE1BQU0sQ0FBQyxFQUMzQixZQUFNLENBQUMsTUFBTSxDQUNkLENBQUMsQ0FBQztRQUNILElBQUksQ0FBQyxNQUFNLENBQUMsR0FBRyxFQUFFLENBQUMsWUFBTSxDQUFDLEdBQUcsQ0FDMUIsWUFBTSxDQUFDLEdBQUcsQ0FBQyxZQUFNLENBQUMsTUFBTSxFQUFFLFlBQU0sQ0FBQyxNQUFNLENBQUMsRUFDeEMsWUFBTSxDQUFDLE1BQU0sQ0FDZCxDQUFDLENBQUM7UUFDSCxJQUFJLENBQUMsTUFBTSxDQUFDLEdBQUcsRUFBRSxDQUFDLFlBQU0sQ0FBQyxHQUFHLENBQzFCLFlBQU0sQ0FBQyxNQUFNLENBQUMsQ0FBQztnQkFDYixJQUFJLEVBQUUsS0FBSztnQkFDWCxJQUFJLEVBQUUsWUFBTSxDQUFDLE1BQU07YUFDcEIsQ0FBQyxDQUFDLEVBQ0gsWUFBTSxDQUFDLE1BQU0sQ0FDZCxDQUFDLENBQUM7UUFDSCxJQUFJLENBQUMsSUFBSSxFQUFFLENBQUM7SUFDZCxDQUFDO0lBRUQsYUFBYSxDQUFDLElBQVU7UUFDdEIsTUFBTSxJQUFJLEdBQUcsWUFBTSxDQUFDLE1BQU0sQ0FBQyxDQUFDO2dCQUMxQixJQUFJLEVBQUUsV0FBVztnQkFDakIsSUFBSSxFQUFFLFlBQU0sQ0FBQyxNQUFNO2FBQ3BCLEVBQUU7Z0JBQ0QsSUFBSSxFQUFFLGNBQWM7Z0JBQ3BCLElBQUksRUFBRSxZQUFNLENBQUMsTUFBTTtnQkFDbkIsT0FBTyxFQUFFLG9CQUFvQjthQUM5QixFQUFFO2dCQUNELElBQUksRUFBRSxPQUFPO2dCQUNiLElBQUksRUFBRSxZQUFNLENBQUMsS0FBSyxDQUFDLFlBQU0sQ0FBQyxNQUFNLENBQUM7YUFDbEMsRUFBRTtnQkFDRCxJQUFJLEVBQUUsS0FBSztnQkFDWCxJQUFJLEVBQUUsWUFBTSxDQUFDLEdBQUcsQ0FBQyxZQUFNLENBQUMsTUFBTSxFQUFFLFlBQU0sQ0FBQyxNQUFNLENBQUM7YUFDL0MsRUFBRTtnQkFDRCxJQUFJLEVBQUUsZUFBZTtnQkFDckIsSUFBSSxFQUFFLFlBQU0sQ0FBQyxNQUFNLENBQUMsQ0FBQzt3QkFDbkIsSUFBSSxFQUFFLFFBQVE7d0JBQ2QsSUFBSSxFQUFFLFlBQU0sQ0FBQyxNQUFNO3dCQUNuQixPQUFPLEVBQUUsZ0JBQWdCO3FCQUMxQixDQUFDLENBQUM7YUFDSixDQUFDLENBQUMsQ0FBQztRQUVKLElBQUksQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLFdBQVcsRUFBRSxLQUFLLENBQUMsQ0FBQztRQUNyQyxJQUFJLENBQUMsTUFBTSxDQUNULElBQUksQ0FBQyxXQUFXO1FBQ2hCLDJDQUEyQztRQUMzQyx1TEFBdUwsQ0FBQyxDQUFDO1FBQzNMLElBQUksQ0FBQyxJQUFJLEVBQUUsQ0FBQztJQUNkLENBQUM7Q0FDRixDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgVGVzdCB9IGZyb20gJ25vZGV1bml0JztcblxuaW1wb3J0IHsgU2NoZW1hIH0gZnJvbSAnLi4vbGliJztcblxuZXhwb3J0ID0ge1xuICAnYm9vbGVhbiB0eXBlJyh0ZXN0OiBUZXN0KSB7XG4gICAgdGVzdC5lcXVhbHMoU2NoZW1hLkJPT0xFQU4uaW5wdXRTdHJpbmcsICdib29sZWFuJyk7XG4gICAgdGVzdC5lcXVhbHMoU2NoZW1hLkJPT0xFQU4uaXNQcmltaXRpdmUsIHRydWUpO1xuICAgIHRlc3QuZG9uZSgpO1xuICB9LFxuXG4gICdiaW5hcnkgdHlwZScodGVzdDogVGVzdCkge1xuICAgIHRlc3QuZXF1YWxzKFNjaGVtYS5CSU5BUlkuaW5wdXRTdHJpbmcsICdiaW5hcnknKTtcbiAgICB0ZXN0LmVxdWFscyhTY2hlbWEuQklOQVJZLmlzUHJpbWl0aXZlLCB0cnVlKTtcbiAgICB0ZXN0LmRvbmUoKTtcbiAgfSxcblxuICAnYmlnaW50IHR5cGUnKHRlc3Q6IFRlc3QpIHtcbiAgICB0ZXN0LmVxdWFscyhTY2hlbWEuQklHX0lOVC5pbnB1dFN0cmluZywgJ2JpZ2ludCcpO1xuICAgIHRlc3QuZXF1YWxzKFNjaGVtYS5CSUdfSU5ULmlzUHJpbWl0aXZlLCB0cnVlKTtcbiAgICB0ZXN0LmRvbmUoKTtcbiAgfSxcblxuICAnZG91YmxlIHR5cGUnKHRlc3Q6IFRlc3QpIHtcbiAgICB0ZXN0LmVxdWFscyhTY2hlbWEuRE9VQkxFLmlucHV0U3RyaW5nLCAnZG91YmxlJyk7XG4gICAgdGVzdC5lcXVhbHMoU2NoZW1hLkRPVUJMRS5pc1ByaW1pdGl2ZSwgdHJ1ZSk7XG4gICAgdGVzdC5kb25lKCk7XG4gIH0sXG5cbiAgJ2Zsb2F0IHR5cGUnKHRlc3Q6IFRlc3QpIHtcbiAgICB0ZXN0LmVxdWFscyhTY2hlbWEuRkxPQVQuaW5wdXRTdHJpbmcsICdmbG9hdCcpO1xuICAgIHRlc3QuZXF1YWxzKFNjaGVtYS5GTE9BVC5pc1ByaW1pdGl2ZSwgdHJ1ZSk7XG4gICAgdGVzdC5kb25lKCk7XG4gIH0sXG5cbiAgJ2ludGVnZXIgdHlwZScodGVzdDogVGVzdCkge1xuICAgIHRlc3QuZXF1YWxzKFNjaGVtYS5JTlRFR0VSLmlucHV0U3RyaW5nLCAnaW50Jyk7XG4gICAgdGVzdC5lcXVhbHMoU2NoZW1hLklOVEVHRVIuaXNQcmltaXRpdmUsIHRydWUpO1xuICAgIHRlc3QuZG9uZSgpO1xuICB9LFxuXG4gICdzbWFsbGludCB0eXBlJyh0ZXN0OiBUZXN0KSB7XG4gICAgdGVzdC5lcXVhbHMoU2NoZW1hLlNNQUxMX0lOVC5pbnB1dFN0cmluZywgJ3NtYWxsaW50Jyk7XG4gICAgdGVzdC5lcXVhbHMoU2NoZW1hLlNNQUxMX0lOVC5pc1ByaW1pdGl2ZSwgdHJ1ZSk7XG4gICAgdGVzdC5kb25lKCk7XG4gIH0sXG5cbiAgJ3RpbnlpbnQgdHlwZScodGVzdDogVGVzdCkge1xuICAgIHRlc3QuZXF1YWxzKFNjaGVtYS5USU5ZX0lOVC5pbnB1dFN0cmluZywgJ3RpbnlpbnQnKTtcbiAgICB0ZXN0LmVxdWFscyhTY2hlbWEuVElOWV9JTlQuaXNQcmltaXRpdmUsIHRydWUpO1xuICAgIHRlc3QuZG9uZSgpO1xuICB9LFxuXG4gICdkZWNpbWFsIHR5cGUnKHRlc3Q6IFRlc3QpIHtcbiAgICB0ZXN0LmVxdWFscyhTY2hlbWEuZGVjaW1hbCgxNikuaW5wdXRTdHJpbmcsICdkZWNpbWFsKDE2KScpO1xuICAgIHRlc3QuZXF1YWxzKFNjaGVtYS5kZWNpbWFsKDE2LCAxKS5pbnB1dFN0cmluZywgJ2RlY2ltYWwoMTYsMSknKTtcbiAgICB0ZXN0LmVxdWFscyhTY2hlbWEuZGVjaW1hbCgxNikuaXNQcmltaXRpdmUsIHRydWUpO1xuICAgIHRlc3QuZXF1YWxzKFNjaGVtYS5kZWNpbWFsKDE2LCAxKS5pc1ByaW1pdGl2ZSwgdHJ1ZSk7XG4gICAgdGVzdC5kb25lKCk7XG4gIH0sXG4gIC8vIFRPRE86IGRlY2ltYWwgYm91bmRzXG5cbiAgJ2RhdGUgdHlwZScodGVzdDogVGVzdCkge1xuICAgIHRlc3QuZXF1YWxzKFNjaGVtYS5EQVRFLmlucHV0U3RyaW5nLCAnZGF0ZScpO1xuICAgIHRlc3QuZXF1YWxzKFNjaGVtYS5EQVRFLmlzUHJpbWl0aXZlLCB0cnVlKTtcbiAgICB0ZXN0LmRvbmUoKTtcbiAgfSxcblxuICAndGltZXN0YW1wIHR5cGUnKHRlc3Q6IFRlc3QpIHtcbiAgICB0ZXN0LmVxdWFscyhTY2hlbWEuVElNRVNUQU1QLmlucHV0U3RyaW5nLCAndGltZXN0YW1wJyk7XG4gICAgdGVzdC5lcXVhbHMoU2NoZW1hLlRJTUVTVEFNUC5pc1ByaW1pdGl2ZSwgdHJ1ZSk7XG4gICAgdGVzdC5kb25lKCk7XG4gIH0sXG5cbiAgJ3N0cmluZyB0eXBlJyh0ZXN0OiBUZXN0KSB7XG4gICAgdGVzdC5lcXVhbHMoU2NoZW1hLlNUUklORy5pbnB1dFN0cmluZywgJ3N0cmluZycpO1xuICAgIHRlc3QuZXF1YWxzKFNjaGVtYS5TVFJJTkcuaXNQcmltaXRpdmUsIHRydWUpO1xuICAgIHRlc3QuZG9uZSgpO1xuICB9LFxuXG4gICdjaGFyIHR5cGUnKHRlc3Q6IFRlc3QpIHtcbiAgICB0ZXN0LmVxdWFscyhTY2hlbWEuY2hhcigxKS5pbnB1dFN0cmluZywgJ2NoYXIoMSknKTtcbiAgICB0ZXN0LmVxdWFscyhTY2hlbWEuY2hhcigxKS5pc1ByaW1pdGl2ZSwgdHJ1ZSk7XG4gICAgdGVzdC5kb25lKCk7XG4gIH0sXG5cbiAgJ2NoYXIgbGVuZ3RoIG11c3QgYmUgYXQgbGVhc3QgMScodGVzdDogVGVzdCkge1xuICAgIHRlc3QuZG9lc05vdFRocm93KCgpID0+IFNjaGVtYS5jaGFyKDEpKTtcbiAgICB0ZXN0LnRocm93cygoKSA9PiBTY2hlbWEuY2hhcigwKSk7XG4gICAgdGVzdC50aHJvd3MoKCkgPT4gU2NoZW1hLmNoYXIoLTEpKTtcbiAgICB0ZXN0LmRvbmUoKTtcbiAgfSxcblxuICAnY2hhciBsZW5ndGggbXVzdCBiZSA8PSAyNTUnKHRlc3Q6IFRlc3QpIHtcbiAgICB0ZXN0LmRvZXNOb3RUaHJvdygoKSA9PiBTY2hlbWEuY2hhcigyNTUpKTtcbiAgICB0ZXN0LnRocm93cygoKSA9PiBTY2hlbWEuY2hhcigyNTYpKTtcbiAgICB0ZXN0LmRvbmUoKTtcbiAgfSxcblxuICAndmFyY2hhciB0eXBlJyh0ZXN0OiBUZXN0KSB7XG4gICAgdGVzdC5lcXVhbHMoU2NoZW1hLnZhcmNoYXIoMSkuaW5wdXRTdHJpbmcsICd2YXJjaGFyKDEpJyk7XG4gICAgdGVzdC5lcXVhbHMoU2NoZW1hLnZhcmNoYXIoMSkuaXNQcmltaXRpdmUsIHRydWUpO1xuICAgIHRlc3QuZG9uZSgpO1xuICB9LFxuXG4gICd2YXJjaGFyIGxlbmd0aCBtdXN0IGJlIGF0IGxlYXN0IDEnKHRlc3Q6IFRlc3QpIHtcbiAgICB0ZXN0LmRvZXNOb3RUaHJvdygoKSA9PiBTY2hlbWEudmFyY2hhcigxKSk7XG4gICAgdGVzdC50aHJvd3MoKCkgPT4gU2NoZW1hLnZhcmNoYXIoMCkpO1xuICAgIHRlc3QudGhyb3dzKCgpID0+IFNjaGVtYS52YXJjaGFyKC0xKSk7XG4gICAgdGVzdC5kb25lKCk7XG4gIH0sXG5cbiAgJ3ZhcmNoYXIgbGVuZ3RoIG11c3QgYmUgPD0gNjU1MzUnKHRlc3Q6IFRlc3QpIHtcbiAgICB0ZXN0LmRvZXNOb3RUaHJvdygoKSA9PiBTY2hlbWEudmFyY2hhcig2NTUzNSkpO1xuICAgIHRlc3QudGhyb3dzKCgpID0+IFNjaGVtYS52YXJjaGFyKDY1NTM2KSk7XG4gICAgdGVzdC5kb25lKCk7XG4gIH0sXG5cbiAgJ2FycmF5PHN0cmluZz4nKHRlc3Q6IFRlc3QpIHtcbiAgICBjb25zdCB0eXBlID0gU2NoZW1hLmFycmF5KFNjaGVtYS5TVFJJTkcpO1xuICAgIHRlc3QuZXF1YWxzKHR5cGUuaW5wdXRTdHJpbmcsICdhcnJheTxzdHJpbmc+Jyk7XG4gICAgdGVzdC5lcXVhbHModHlwZS5pc1ByaW1pdGl2ZSwgZmFsc2UpO1xuICAgIHRlc3QuZG9uZSgpO1xuICB9LFxuXG4gICdhcnJheTxjaGFyKDEpPicodGVzdDogVGVzdCkge1xuICAgIGNvbnN0IHR5cGUgPSBTY2hlbWEuYXJyYXkoU2NoZW1hLmNoYXIoMSkpO1xuICAgIHRlc3QuZXF1YWxzKHR5cGUuaW5wdXRTdHJpbmcsICdhcnJheTxjaGFyKDEpPicpO1xuICAgIHRlc3QuZXF1YWxzKHR5cGUuaXNQcmltaXRpdmUsIGZhbHNlKTtcbiAgICB0ZXN0LmRvbmUoKTtcbiAgfSxcblxuICAnYXJyYXk8YXJyYXk+Jyh0ZXN0OiBUZXN0KSB7XG4gICAgY29uc3QgdHlwZSA9IFNjaGVtYS5hcnJheShcbiAgICAgIFNjaGVtYS5hcnJheShTY2hlbWEuU1RSSU5HKSk7XG4gICAgdGVzdC5lcXVhbHModHlwZS5pbnB1dFN0cmluZywgJ2FycmF5PGFycmF5PHN0cmluZz4+Jyk7XG4gICAgdGVzdC5lcXVhbHModHlwZS5pc1ByaW1pdGl2ZSwgZmFsc2UpO1xuICAgIHRlc3QuZG9uZSgpO1xuICB9LFxuXG4gICdhcnJheTxtYXA+Jyh0ZXN0OiBUZXN0KSB7XG4gICAgY29uc3QgdHlwZSA9IFNjaGVtYS5hcnJheShcbiAgICAgIFNjaGVtYS5tYXAoU2NoZW1hLlNUUklORywgU2NoZW1hLlNUUklORykpO1xuICAgIHRlc3QuZXF1YWxzKHR5cGUuaW5wdXRTdHJpbmcsICdhcnJheTxtYXA8c3RyaW5nLHN0cmluZz4+Jyk7XG4gICAgdGVzdC5lcXVhbHModHlwZS5pc1ByaW1pdGl2ZSwgZmFsc2UpO1xuICAgIHRlc3QuZG9uZSgpO1xuICB9LFxuXG4gICdhcnJheTxzdHJ1Y3Q+Jyh0ZXN0OiBUZXN0KSB7XG4gICAgY29uc3QgdHlwZSA9IFNjaGVtYS5hcnJheShcbiAgICAgIFNjaGVtYS5zdHJ1Y3QoW3tcbiAgICAgICAgbmFtZTogJ2tleScsXG4gICAgICAgIHR5cGU6IFNjaGVtYS5TVFJJTkcsXG4gICAgICB9XSkpO1xuICAgIHRlc3QuZXF1YWxzKHR5cGUuaW5wdXRTdHJpbmcsICdhcnJheTxzdHJ1Y3Q8a2V5OnN0cmluZz4+Jyk7XG4gICAgdGVzdC5lcXVhbHModHlwZS5pc1ByaW1pdGl2ZSwgZmFsc2UpO1xuICAgIHRlc3QuZG9uZSgpO1xuICB9LFxuXG4gICdtYXA8c3RyaW5nLHN0cmluZz4nKHRlc3Q6IFRlc3QpIHtcbiAgICBjb25zdCB0eXBlID0gU2NoZW1hLm1hcChcbiAgICAgIFNjaGVtYS5TVFJJTkcsXG4gICAgICBTY2hlbWEuU1RSSU5HLFxuICAgICk7XG4gICAgdGVzdC5lcXVhbHModHlwZS5pbnB1dFN0cmluZywgJ21hcDxzdHJpbmcsc3RyaW5nPicpO1xuICAgIHRlc3QuZXF1YWxzKHR5cGUuaXNQcmltaXRpdmUsIGZhbHNlKTtcbiAgICB0ZXN0LmRvbmUoKTtcbiAgfSxcblxuICAnbWFwPGludCxzdHJpbmc+Jyh0ZXN0OiBUZXN0KSB7XG4gICAgY29uc3QgdHlwZSA9IFNjaGVtYS5tYXAoXG4gICAgICBTY2hlbWEuSU5URUdFUixcbiAgICAgIFNjaGVtYS5TVFJJTkcsXG4gICAgKTtcbiAgICB0ZXN0LmVxdWFscyh0eXBlLmlucHV0U3RyaW5nLCAnbWFwPGludCxzdHJpbmc+Jyk7XG4gICAgdGVzdC5lcXVhbHModHlwZS5pc1ByaW1pdGl2ZSwgZmFsc2UpO1xuICAgIHRlc3QuZG9uZSgpO1xuICB9LFxuXG4gICdtYXA8Y2hhcigxKSxjaGFyKDEpPicodGVzdDogVGVzdCkge1xuICAgIGNvbnN0IHR5cGUgPSBTY2hlbWEubWFwKFxuICAgICAgU2NoZW1hLmNoYXIoMSksXG4gICAgICBTY2hlbWEuY2hhcigxKSxcbiAgICApO1xuICAgIHRlc3QuZXF1YWxzKHR5cGUuaW5wdXRTdHJpbmcsICdtYXA8Y2hhcigxKSxjaGFyKDEpPicpO1xuICAgIHRlc3QuZXF1YWxzKHR5cGUuaXNQcmltaXRpdmUsIGZhbHNlKTtcbiAgICB0ZXN0LmRvbmUoKTtcbiAgfSxcblxuICAnbWFwPHN0cmluZyxhcnJheT4nKHRlc3Q6IFRlc3QpIHtcbiAgICBjb25zdCB0eXBlID0gU2NoZW1hLm1hcChcbiAgICAgIFNjaGVtYS5jaGFyKDEpLFxuICAgICAgU2NoZW1hLmFycmF5KFNjaGVtYS5TVFJJTkcpLFxuICAgICk7XG4gICAgdGVzdC5lcXVhbHModHlwZS5pbnB1dFN0cmluZywgJ21hcDxjaGFyKDEpLGFycmF5PHN0cmluZz4+Jyk7XG4gICAgdGVzdC5lcXVhbHModHlwZS5pc1ByaW1pdGl2ZSwgZmFsc2UpO1xuICAgIHRlc3QuZG9uZSgpO1xuICB9LFxuXG4gICdtYXA8c3RyaW5nLG1hcD4nKHRlc3Q6IFRlc3QpIHtcbiAgICBjb25zdCB0eXBlID0gU2NoZW1hLm1hcChcbiAgICAgIFNjaGVtYS5jaGFyKDEpLFxuICAgICAgU2NoZW1hLm1hcChcbiAgICAgICAgU2NoZW1hLlNUUklORyxcbiAgICAgICAgU2NoZW1hLlNUUklORyksXG4gICAgKTtcbiAgICB0ZXN0LmVxdWFscyh0eXBlLmlucHV0U3RyaW5nLCAnbWFwPGNoYXIoMSksbWFwPHN0cmluZyxzdHJpbmc+PicpO1xuICAgIHRlc3QuZXF1YWxzKHR5cGUuaXNQcmltaXRpdmUsIGZhbHNlKTtcbiAgICB0ZXN0LmRvbmUoKTtcbiAgfSxcblxuICAnbWFwPHN0cmluZyxzdHJ1Y3Q+Jyh0ZXN0OiBUZXN0KSB7XG4gICAgY29uc3QgdHlwZSA9IFNjaGVtYS5tYXAoXG4gICAgICBTY2hlbWEuY2hhcigxKSxcbiAgICAgIFNjaGVtYS5zdHJ1Y3QoW3tcbiAgICAgICAgbmFtZTogJ2tleScsXG4gICAgICAgIHR5cGU6IFNjaGVtYS5TVFJJTkcsXG4gICAgICB9XSksXG4gICAgKTtcbiAgICB0ZXN0LmVxdWFscyh0eXBlLmlucHV0U3RyaW5nLCAnbWFwPGNoYXIoMSksc3RydWN0PGtleTpzdHJpbmc+PicpO1xuICAgIHRlc3QuZXF1YWxzKHR5cGUuaXNQcmltaXRpdmUsIGZhbHNlKTtcbiAgICB0ZXN0LmRvbmUoKTtcbiAgfSxcblxuICAnbWFwIHRocm93cyBpZiBrZXlUeXBlIGlzIG5vbi1wcmltaXRpdmUnKHRlc3Q6IFRlc3QpIHtcbiAgICB0ZXN0LnRocm93cygoKSA9PiBTY2hlbWEubWFwKFxuICAgICAgU2NoZW1hLmFycmF5KFNjaGVtYS5TVFJJTkcpLFxuICAgICAgU2NoZW1hLlNUUklORyxcbiAgICApKTtcbiAgICB0ZXN0LnRocm93cygoKSA9PiBTY2hlbWEubWFwKFxuICAgICAgU2NoZW1hLm1hcChTY2hlbWEuU1RSSU5HLCBTY2hlbWEuU1RSSU5HKSxcbiAgICAgIFNjaGVtYS5TVFJJTkcsXG4gICAgKSk7XG4gICAgdGVzdC50aHJvd3MoKCkgPT4gU2NoZW1hLm1hcChcbiAgICAgIFNjaGVtYS5zdHJ1Y3QoW3tcbiAgICAgICAgbmFtZTogJ2tleScsXG4gICAgICAgIHR5cGU6IFNjaGVtYS5TVFJJTkcsXG4gICAgICB9XSksXG4gICAgICBTY2hlbWEuU1RSSU5HLFxuICAgICkpO1xuICAgIHRlc3QuZG9uZSgpO1xuICB9LFxuXG4gICdzdHJ1Y3QgdHlwZScodGVzdDogVGVzdCkge1xuICAgIGNvbnN0IHR5cGUgPSBTY2hlbWEuc3RydWN0KFt7XG4gICAgICBuYW1lOiAncHJpbWl0aXZlJyxcbiAgICAgIHR5cGU6IFNjaGVtYS5TVFJJTkcsXG4gICAgfSwge1xuICAgICAgbmFtZTogJ3dpdGhfY29tbWVudCcsXG4gICAgICB0eXBlOiBTY2hlbWEuU1RSSU5HLFxuICAgICAgY29tbWVudDogJ3RoaXMgaGFzIGEgY29tbWVudCcsXG4gICAgfSwge1xuICAgICAgbmFtZTogJ2FycmF5JyxcbiAgICAgIHR5cGU6IFNjaGVtYS5hcnJheShTY2hlbWEuU1RSSU5HKSxcbiAgICB9LCB7XG4gICAgICBuYW1lOiAnbWFwJyxcbiAgICAgIHR5cGU6IFNjaGVtYS5tYXAoU2NoZW1hLlNUUklORywgU2NoZW1hLlNUUklORyksXG4gICAgfSwge1xuICAgICAgbmFtZTogJ25lc3RlZF9zdHJ1Y3QnLFxuICAgICAgdHlwZTogU2NoZW1hLnN0cnVjdChbe1xuICAgICAgICBuYW1lOiAnbmVzdGVkJyxcbiAgICAgICAgdHlwZTogU2NoZW1hLlNUUklORyxcbiAgICAgICAgY29tbWVudDogJ25lc3RlZCBjb21tZW50JyxcbiAgICAgIH1dKSxcbiAgICB9XSk7XG5cbiAgICB0ZXN0LmVxdWFscyh0eXBlLmlzUHJpbWl0aXZlLCBmYWxzZSk7XG4gICAgdGVzdC5lcXVhbHMoXG4gICAgICB0eXBlLmlucHV0U3RyaW5nLFxuICAgICAgLy8gdHNsaW50OmRpc2FibGUtbmV4dC1saW5lOm1heC1saW5lLWxlbmd0aFxuICAgICAgJ3N0cnVjdDxwcmltaXRpdmU6c3RyaW5nLHdpdGhfY29tbWVudDpzdHJpbmcgQ09NTUVOVCBcXCd0aGlzIGhhcyBhIGNvbW1lbnRcXCcsYXJyYXk6YXJyYXk8c3RyaW5nPixtYXA6bWFwPHN0cmluZyxzdHJpbmc+LG5lc3RlZF9zdHJ1Y3Q6c3RydWN0PG5lc3RlZDpzdHJpbmcgQ09NTUVOVCBcXCduZXN0ZWQgY29tbWVudFxcJz4+Jyk7XG4gICAgdGVzdC5kb25lKCk7XG4gIH0sXG59OyJdfQ==