import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { IAMClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../IAMClient";
import { CreateLoginProfileRequest, CreateLoginProfileResponse } from "../models/models_0";
export interface CreateLoginProfileCommandInput extends CreateLoginProfileRequest {
}
export interface CreateLoginProfileCommandOutput extends CreateLoginProfileResponse, __MetadataBearer {
}
/**
 * <p>Creates a password for the specified IAM user. A password allows an IAM user to
 *             access Amazon Web Services services through the Amazon Web Services Management Console.</p>
 *         <p>You can use the CLI, the Amazon Web Services API, or the <b>Users</b>
 *             page in the IAM console to create a password for any IAM user. Use <a>ChangePassword</a> to update your own existing password in the <b>My Security Credentials</b> page in the Amazon Web Services Management Console.</p>
 *         <p>For more information about managing passwords, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html">Managing passwords</a> in the
 *                 <i>IAM User Guide</i>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { IAMClient, CreateLoginProfileCommand } from "@aws-sdk/client-iam"; // ES Modules import
 * // const { IAMClient, CreateLoginProfileCommand } = require("@aws-sdk/client-iam"); // CommonJS import
 * const client = new IAMClient(config);
 * const command = new CreateLoginProfileCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link CreateLoginProfileCommandInput} for command's `input` shape.
 * @see {@link CreateLoginProfileCommandOutput} for command's `response` shape.
 * @see {@link IAMClientResolvedConfig | config} for IAMClient's `config` shape.
 *
 */
export declare class CreateLoginProfileCommand extends $Command<CreateLoginProfileCommandInput, CreateLoginProfileCommandOutput, IAMClientResolvedConfig> {
    readonly input: CreateLoginProfileCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: CreateLoginProfileCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: IAMClientResolvedConfig, options?: __HttpHandlerOptions): Handler<CreateLoginProfileCommandInput, CreateLoginProfileCommandOutput>;
    private serialize;
    private deserialize;
}
