import { getEndpointPlugin } from "@aws-sdk/middleware-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ListAttachedGroupPoliciesRequestFilterSensitiveLog, ListAttachedGroupPoliciesResponseFilterSensitiveLog, } from "../models/models_0";
import { deserializeAws_queryListAttachedGroupPoliciesCommand, serializeAws_queryListAttachedGroupPoliciesCommand, } from "../protocols/Aws_query";
export class ListAttachedGroupPoliciesCommand extends $Command {
    constructor(input) {
        super();
        this.input = input;
    }
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getEndpointPlugin(configuration, ListAttachedGroupPoliciesCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "IAMClient";
        const commandName = "ListAttachedGroupPoliciesCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: ListAttachedGroupPoliciesRequestFilterSensitiveLog,
            outputFilterSensitiveLog: ListAttachedGroupPoliciesResponseFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return serializeAws_queryListAttachedGroupPoliciesCommand(input, context);
    }
    deserialize(output, context) {
        return deserializeAws_queryListAttachedGroupPoliciesCommand(output, context);
    }
}
