"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.waitUntilPolicyExists = exports.waitForPolicyExists = void 0;
const util_waiter_1 = require("@aws-sdk/util-waiter");
const GetPolicyCommand_1 = require("../commands/GetPolicyCommand");
const checkState = async (client, input) => {
    let reason;
    try {
        const result = await client.send(new GetPolicyCommand_1.GetPolicyCommand(input));
        reason = result;
        return { state: util_waiter_1.WaiterState.SUCCESS, reason };
    }
    catch (exception) {
        reason = exception;
        if (exception.name && exception.name == "NoSuchEntity") {
            return { state: util_waiter_1.WaiterState.RETRY, reason };
        }
    }
    return { state: util_waiter_1.WaiterState.RETRY, reason };
};
const waitForPolicyExists = async (params, input) => {
    const serviceDefaults = { minDelay: 1, maxDelay: 120 };
    return (0, util_waiter_1.createWaiter)({ ...serviceDefaults, ...params }, input, checkState);
};
exports.waitForPolicyExists = waitForPolicyExists;
const waitUntilPolicyExists = async (params, input) => {
    const serviceDefaults = { minDelay: 1, maxDelay: 120 };
    const result = await (0, util_waiter_1.createWaiter)({ ...serviceDefaults, ...params }, input, checkState);
    return (0, util_waiter_1.checkExceptions)(result);
};
exports.waitUntilPolicyExists = waitUntilPolicyExists;
