import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  WithdrawByoipCidrRequest,
  WithdrawByoipCidrResult,
} from "../models/models_6";
export interface WithdrawByoipCidrCommandInput
  extends WithdrawByoipCidrRequest {}
export interface WithdrawByoipCidrCommandOutput
  extends WithdrawByoipCidrResult,
    __MetadataBearer {}
export declare class WithdrawByoipCidrCommand extends $Command<
  WithdrawByoipCidrCommandInput,
  WithdrawByoipCidrCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: WithdrawByoipCidrCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: WithdrawByoipCidrCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<WithdrawByoipCidrCommandInput, WithdrawByoipCidrCommandOutput>;
  private serialize;
  private deserialize;
}
