import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  ResetAddressAttributeRequest,
  ResetAddressAttributeResult,
} from "../models/models_6";
export interface ResetAddressAttributeCommandInput
  extends ResetAddressAttributeRequest {}
export interface ResetAddressAttributeCommandOutput
  extends ResetAddressAttributeResult,
    __MetadataBearer {}
export declare class ResetAddressAttributeCommand extends $Command<
  ResetAddressAttributeCommandInput,
  ResetAddressAttributeCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: ResetAddressAttributeCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: ResetAddressAttributeCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    ResetAddressAttributeCommandInput,
    ResetAddressAttributeCommandOutput
  >;
  private serialize;
  private deserialize;
}
