import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  ReplaceRouteTableAssociationRequest,
  ReplaceRouteTableAssociationResult,
} from "../models/models_6";
export interface ReplaceRouteTableAssociationCommandInput
  extends ReplaceRouteTableAssociationRequest {}
export interface ReplaceRouteTableAssociationCommandOutput
  extends ReplaceRouteTableAssociationResult,
    __MetadataBearer {}
export declare class ReplaceRouteTableAssociationCommand extends $Command<
  ReplaceRouteTableAssociationCommandInput,
  ReplaceRouteTableAssociationCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: ReplaceRouteTableAssociationCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: ReplaceRouteTableAssociationCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    ReplaceRouteTableAssociationCommandInput,
    ReplaceRouteTableAssociationCommandOutput
  >;
  private serialize;
  private deserialize;
}
