import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import { RegisterImageRequest, RegisterImageResult } from "../models/models_6";
export interface RegisterImageCommandInput extends RegisterImageRequest {}
export interface RegisterImageCommandOutput
  extends RegisterImageResult,
    __MetadataBearer {}
export declare class RegisterImageCommand extends $Command<
  RegisterImageCommandInput,
  RegisterImageCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: RegisterImageCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: RegisterImageCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<RegisterImageCommandInput, RegisterImageCommandOutput>;
  private serialize;
  private deserialize;
}
