import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  ProvisionIpamPoolCidrRequest,
  ProvisionIpamPoolCidrResult,
} from "../models/models_6";
export interface ProvisionIpamPoolCidrCommandInput
  extends ProvisionIpamPoolCidrRequest {}
export interface ProvisionIpamPoolCidrCommandOutput
  extends ProvisionIpamPoolCidrResult,
    __MetadataBearer {}
export declare class ProvisionIpamPoolCidrCommand extends $Command<
  ProvisionIpamPoolCidrCommandInput,
  ProvisionIpamPoolCidrCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: ProvisionIpamPoolCidrCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: ProvisionIpamPoolCidrCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    ProvisionIpamPoolCidrCommandInput,
    ProvisionIpamPoolCidrCommandOutput
  >;
  private serialize;
  private deserialize;
}
