import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  GetVerifiedAccessGroupPolicyRequest,
  GetVerifiedAccessGroupPolicyResult,
} from "../models/models_5";
export interface GetVerifiedAccessGroupPolicyCommandInput
  extends GetVerifiedAccessGroupPolicyRequest {}
export interface GetVerifiedAccessGroupPolicyCommandOutput
  extends GetVerifiedAccessGroupPolicyResult,
    __MetadataBearer {}
export declare class GetVerifiedAccessGroupPolicyCommand extends $Command<
  GetVerifiedAccessGroupPolicyCommandInput,
  GetVerifiedAccessGroupPolicyCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: GetVerifiedAccessGroupPolicyCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: GetVerifiedAccessGroupPolicyCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    GetVerifiedAccessGroupPolicyCommandInput,
    GetVerifiedAccessGroupPolicyCommandOutput
  >;
  private serialize;
  private deserialize;
}
