import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  GetLaunchTemplateDataRequest,
  GetLaunchTemplateDataResult,
} from "../models/models_5";
export interface GetLaunchTemplateDataCommandInput
  extends GetLaunchTemplateDataRequest {}
export interface GetLaunchTemplateDataCommandOutput
  extends GetLaunchTemplateDataResult,
    __MetadataBearer {}
export declare class GetLaunchTemplateDataCommand extends $Command<
  GetLaunchTemplateDataCommandInput,
  GetLaunchTemplateDataCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: GetLaunchTemplateDataCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: GetLaunchTemplateDataCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    GetLaunchTemplateDataCommandInput,
    GetLaunchTemplateDataCommandOutput
  >;
  private serialize;
  private deserialize;
}
