import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  GetCapacityReservationUsageRequest,
  GetCapacityReservationUsageResult,
} from "../models/models_5";
export interface GetCapacityReservationUsageCommandInput
  extends GetCapacityReservationUsageRequest {}
export interface GetCapacityReservationUsageCommandOutput
  extends GetCapacityReservationUsageResult,
    __MetadataBearer {}
export declare class GetCapacityReservationUsageCommand extends $Command<
  GetCapacityReservationUsageCommandInput,
  GetCapacityReservationUsageCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: GetCapacityReservationUsageCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: GetCapacityReservationUsageCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    GetCapacityReservationUsageCommandInput,
    GetCapacityReservationUsageCommandOutput
  >;
  private serialize;
  private deserialize;
}
