import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DisableSerialConsoleAccessRequest,
  DisableSerialConsoleAccessResult,
} from "../models/models_5";
export interface DisableSerialConsoleAccessCommandInput
  extends DisableSerialConsoleAccessRequest {}
export interface DisableSerialConsoleAccessCommandOutput
  extends DisableSerialConsoleAccessResult,
    __MetadataBearer {}
export declare class DisableSerialConsoleAccessCommand extends $Command<
  DisableSerialConsoleAccessCommandInput,
  DisableSerialConsoleAccessCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DisableSerialConsoleAccessCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DisableSerialConsoleAccessCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DisableSerialConsoleAccessCommandInput,
    DisableSerialConsoleAccessCommandOutput
  >;
  private serialize;
  private deserialize;
}
