import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DescribeStaleSecurityGroupsRequest,
  DescribeStaleSecurityGroupsResult,
} from "../models/models_4";
export interface DescribeStaleSecurityGroupsCommandInput
  extends DescribeStaleSecurityGroupsRequest {}
export interface DescribeStaleSecurityGroupsCommandOutput
  extends DescribeStaleSecurityGroupsResult,
    __MetadataBearer {}
export declare class DescribeStaleSecurityGroupsCommand extends $Command<
  DescribeStaleSecurityGroupsCommandInput,
  DescribeStaleSecurityGroupsCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DescribeStaleSecurityGroupsCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DescribeStaleSecurityGroupsCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DescribeStaleSecurityGroupsCommandInput,
    DescribeStaleSecurityGroupsCommandOutput
  >;
  private serialize;
  private deserialize;
}
