import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DescribeScheduledInstancesRequest,
  DescribeScheduledInstancesResult,
} from "../models/models_4";
export interface DescribeScheduledInstancesCommandInput
  extends DescribeScheduledInstancesRequest {}
export interface DescribeScheduledInstancesCommandOutput
  extends DescribeScheduledInstancesResult,
    __MetadataBearer {}
export declare class DescribeScheduledInstancesCommand extends $Command<
  DescribeScheduledInstancesCommandInput,
  DescribeScheduledInstancesCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DescribeScheduledInstancesCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DescribeScheduledInstancesCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DescribeScheduledInstancesCommandInput,
    DescribeScheduledInstancesCommandOutput
  >;
  private serialize;
  private deserialize;
}
