import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DescribeLocalGatewaysRequest,
  DescribeLocalGatewaysResult,
} from "../models/models_4";
export interface DescribeLocalGatewaysCommandInput
  extends DescribeLocalGatewaysRequest {}
export interface DescribeLocalGatewaysCommandOutput
  extends DescribeLocalGatewaysResult,
    __MetadataBearer {}
export declare class DescribeLocalGatewaysCommand extends $Command<
  DescribeLocalGatewaysCommandInput,
  DescribeLocalGatewaysCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DescribeLocalGatewaysCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DescribeLocalGatewaysCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DescribeLocalGatewaysCommandInput,
    DescribeLocalGatewaysCommandOutput
  >;
  private serialize;
  private deserialize;
}
