import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DescribeCarrierGatewaysRequest,
  DescribeCarrierGatewaysResult,
} from "../models/models_3";
export interface DescribeCarrierGatewaysCommandInput
  extends DescribeCarrierGatewaysRequest {}
export interface DescribeCarrierGatewaysCommandOutput
  extends DescribeCarrierGatewaysResult,
    __MetadataBearer {}
export declare class DescribeCarrierGatewaysCommand extends $Command<
  DescribeCarrierGatewaysCommandInput,
  DescribeCarrierGatewaysCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DescribeCarrierGatewaysCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DescribeCarrierGatewaysCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DescribeCarrierGatewaysCommandInput,
    DescribeCarrierGatewaysCommandOutput
  >;
  private serialize;
  private deserialize;
}
