import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DeleteCoipPoolRequest,
  DeleteCoipPoolResult,
} from "../models/models_2";
export interface DeleteCoipPoolCommandInput extends DeleteCoipPoolRequest {}
export interface DeleteCoipPoolCommandOutput
  extends DeleteCoipPoolResult,
    __MetadataBearer {}
export declare class DeleteCoipPoolCommand extends $Command<
  DeleteCoipPoolCommandInput,
  DeleteCoipPoolCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DeleteCoipPoolCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DeleteCoipPoolCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<DeleteCoipPoolCommandInput, DeleteCoipPoolCommandOutput>;
  private serialize;
  private deserialize;
}
