import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  CreateLaunchTemplateRequest,
  CreateLaunchTemplateResult,
} from "../models/models_1";
export interface CreateLaunchTemplateCommandInput
  extends CreateLaunchTemplateRequest {}
export interface CreateLaunchTemplateCommandOutput
  extends CreateLaunchTemplateResult,
    __MetadataBearer {}
export declare class CreateLaunchTemplateCommand extends $Command<
  CreateLaunchTemplateCommandInput,
  CreateLaunchTemplateCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: CreateLaunchTemplateCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: CreateLaunchTemplateCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    CreateLaunchTemplateCommandInput,
    CreateLaunchTemplateCommandOutput
  >;
  private serialize;
  private deserialize;
}
