import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  AcceptReservedInstancesExchangeQuoteRequest,
  AcceptReservedInstancesExchangeQuoteResult,
} from "../models/models_0";
export interface AcceptReservedInstancesExchangeQuoteCommandInput
  extends AcceptReservedInstancesExchangeQuoteRequest {}
export interface AcceptReservedInstancesExchangeQuoteCommandOutput
  extends AcceptReservedInstancesExchangeQuoteResult,
    __MetadataBearer {}
export declare class AcceptReservedInstancesExchangeQuoteCommand extends $Command<
  AcceptReservedInstancesExchangeQuoteCommandInput,
  AcceptReservedInstancesExchangeQuoteCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: AcceptReservedInstancesExchangeQuoteCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: AcceptReservedInstancesExchangeQuoteCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    AcceptReservedInstancesExchangeQuoteCommandInput,
    AcceptReservedInstancesExchangeQuoteCommandOutput
  >;
  private serialize;
  private deserialize;
}
