import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { ModifyVerifiedAccessInstanceLoggingConfigurationRequest, ModifyVerifiedAccessInstanceLoggingConfigurationResult } from "../models/models_6";
export interface ModifyVerifiedAccessInstanceLoggingConfigurationCommandInput extends ModifyVerifiedAccessInstanceLoggingConfigurationRequest {
}
export interface ModifyVerifiedAccessInstanceLoggingConfigurationCommandOutput extends ModifyVerifiedAccessInstanceLoggingConfigurationResult, __MetadataBearer {
}
/**
 * <p>Modifies the logging configuration for the specified Amazon Web Services Verified Access instance.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, ModifyVerifiedAccessInstanceLoggingConfigurationCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, ModifyVerifiedAccessInstanceLoggingConfigurationCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new ModifyVerifiedAccessInstanceLoggingConfigurationCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link ModifyVerifiedAccessInstanceLoggingConfigurationCommandInput} for command's `input` shape.
 * @see {@link ModifyVerifiedAccessInstanceLoggingConfigurationCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class ModifyVerifiedAccessInstanceLoggingConfigurationCommand extends $Command<ModifyVerifiedAccessInstanceLoggingConfigurationCommandInput, ModifyVerifiedAccessInstanceLoggingConfigurationCommandOutput, EC2ClientResolvedConfig> {
    readonly input: ModifyVerifiedAccessInstanceLoggingConfigurationCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: ModifyVerifiedAccessInstanceLoggingConfigurationCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<ModifyVerifiedAccessInstanceLoggingConfigurationCommandInput, ModifyVerifiedAccessInstanceLoggingConfigurationCommandOutput>;
    private serialize;
    private deserialize;
}
