import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { EnableAwsNetworkPerformanceMetricSubscriptionRequest, EnableAwsNetworkPerformanceMetricSubscriptionResult } from "../models/models_5";
export interface EnableAwsNetworkPerformanceMetricSubscriptionCommandInput extends EnableAwsNetworkPerformanceMetricSubscriptionRequest {
}
export interface EnableAwsNetworkPerformanceMetricSubscriptionCommandOutput extends EnableAwsNetworkPerformanceMetricSubscriptionResult, __MetadataBearer {
}
/**
 * <p>Enables Infrastructure Performance subscriptions.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, EnableAwsNetworkPerformanceMetricSubscriptionCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, EnableAwsNetworkPerformanceMetricSubscriptionCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new EnableAwsNetworkPerformanceMetricSubscriptionCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link EnableAwsNetworkPerformanceMetricSubscriptionCommandInput} for command's `input` shape.
 * @see {@link EnableAwsNetworkPerformanceMetricSubscriptionCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class EnableAwsNetworkPerformanceMetricSubscriptionCommand extends $Command<EnableAwsNetworkPerformanceMetricSubscriptionCommandInput, EnableAwsNetworkPerformanceMetricSubscriptionCommandOutput, EC2ClientResolvedConfig> {
    readonly input: EnableAwsNetworkPerformanceMetricSubscriptionCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: EnableAwsNetworkPerformanceMetricSubscriptionCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<EnableAwsNetworkPerformanceMetricSubscriptionCommandInput, EnableAwsNetworkPerformanceMetricSubscriptionCommandOutput>;
    private serialize;
    private deserialize;
}
