import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DescribeVerifiedAccessTrustProvidersRequest, DescribeVerifiedAccessTrustProvidersResult } from "../models/models_4";
export interface DescribeVerifiedAccessTrustProvidersCommandInput extends DescribeVerifiedAccessTrustProvidersRequest {
}
export interface DescribeVerifiedAccessTrustProvidersCommandOutput extends DescribeVerifiedAccessTrustProvidersResult, __MetadataBearer {
}
/**
 * <p>Describe details of existing Verified Access trust providers.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DescribeVerifiedAccessTrustProvidersCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DescribeVerifiedAccessTrustProvidersCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new DescribeVerifiedAccessTrustProvidersCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link DescribeVerifiedAccessTrustProvidersCommandInput} for command's `input` shape.
 * @see {@link DescribeVerifiedAccessTrustProvidersCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class DescribeVerifiedAccessTrustProvidersCommand extends $Command<DescribeVerifiedAccessTrustProvidersCommandInput, DescribeVerifiedAccessTrustProvidersCommandOutput, EC2ClientResolvedConfig> {
    readonly input: DescribeVerifiedAccessTrustProvidersCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: DescribeVerifiedAccessTrustProvidersCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DescribeVerifiedAccessTrustProvidersCommandInput, DescribeVerifiedAccessTrustProvidersCommandOutput>;
    private serialize;
    private deserialize;
}
