import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { CreateCoipCidrRequest } from "../models/models_0";
import { CreateCoipCidrResult } from "../models/models_1";
export interface CreateCoipCidrCommandInput extends CreateCoipCidrRequest {
}
export interface CreateCoipCidrCommandOutput extends CreateCoipCidrResult, __MetadataBearer {
}
/**
 * <p>
 *      Creates a range of customer-owned IP addresses.
 *       </p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, CreateCoipCidrCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, CreateCoipCidrCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new CreateCoipCidrCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link CreateCoipCidrCommandInput} for command's `input` shape.
 * @see {@link CreateCoipCidrCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class CreateCoipCidrCommand extends $Command<CreateCoipCidrCommandInput, CreateCoipCidrCommandOutput, EC2ClientResolvedConfig> {
    readonly input: CreateCoipCidrCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: CreateCoipCidrCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<CreateCoipCidrCommandInput, CreateCoipCidrCommandOutput>;
    private serialize;
    private deserialize;
}
