import { getEndpointPlugin } from "@aws-sdk/middleware-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeLaunchTemplatesRequestFilterSensitiveLog, DescribeLaunchTemplatesResultFilterSensitiveLog, } from "../models/models_4";
import { deserializeAws_ec2DescribeLaunchTemplatesCommand, serializeAws_ec2DescribeLaunchTemplatesCommand, } from "../protocols/Aws_ec2";
export class DescribeLaunchTemplatesCommand extends $Command {
    constructor(input) {
        super();
        this.input = input;
    }
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getEndpointPlugin(configuration, DescribeLaunchTemplatesCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "EC2Client";
        const commandName = "DescribeLaunchTemplatesCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: DescribeLaunchTemplatesRequestFilterSensitiveLog,
            outputFilterSensitiveLog: DescribeLaunchTemplatesResultFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return serializeAws_ec2DescribeLaunchTemplatesCommand(input, context);
    }
    deserialize(output, context) {
        return deserializeAws_ec2DescribeLaunchTemplatesCommand(output, context);
    }
}
