import { getEndpointPlugin } from "@aws-sdk/middleware-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { AssociateInstanceEventWindowRequestFilterSensitiveLog, AssociateInstanceEventWindowResultFilterSensitiveLog, } from "../models/models_0";
import { deserializeAws_ec2AssociateInstanceEventWindowCommand, serializeAws_ec2AssociateInstanceEventWindowCommand, } from "../protocols/Aws_ec2";
export class AssociateInstanceEventWindowCommand extends $Command {
    constructor(input) {
        super();
        this.input = input;
    }
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getEndpointPlugin(configuration, AssociateInstanceEventWindowCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "EC2Client";
        const commandName = "AssociateInstanceEventWindowCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: AssociateInstanceEventWindowRequestFilterSensitiveLog,
            outputFilterSensitiveLog: AssociateInstanceEventWindowResultFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return serializeAws_ec2AssociateInstanceEventWindowCommand(input, context);
    }
    deserialize(output, context) {
        return deserializeAws_ec2AssociateInstanceEventWindowCommand(output, context);
    }
}
