"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.waitUntilInternetGatewayExists = exports.waitForInternetGatewayExists = void 0;
const util_waiter_1 = require("@aws-sdk/util-waiter");
const DescribeInternetGatewaysCommand_1 = require("../commands/DescribeInternetGatewaysCommand");
const checkState = async (client, input) => {
    let reason;
    try {
        const result = await client.send(new DescribeInternetGatewaysCommand_1.DescribeInternetGatewaysCommand(input));
        reason = result;
        try {
            const returnComparator = () => {
                const flat_1 = [].concat(...result.InternetGateways);
                const projection_3 = flat_1.map((element_2) => {
                    return element_2.InternetGatewayId;
                });
                return projection_3.length > 0.0;
            };
            if (returnComparator() == true) {
                return { state: util_waiter_1.WaiterState.SUCCESS, reason };
            }
        }
        catch (e) { }
    }
    catch (exception) {
        reason = exception;
        if (exception.name && exception.name == "InvalidInternetGateway.NotFound") {
            return { state: util_waiter_1.WaiterState.RETRY, reason };
        }
    }
    return { state: util_waiter_1.WaiterState.RETRY, reason };
};
const waitForInternetGatewayExists = async (params, input) => {
    const serviceDefaults = { minDelay: 5, maxDelay: 120 };
    return (0, util_waiter_1.createWaiter)({ ...serviceDefaults, ...params }, input, checkState);
};
exports.waitForInternetGatewayExists = waitForInternetGatewayExists;
const waitUntilInternetGatewayExists = async (params, input) => {
    const serviceDefaults = { minDelay: 5, maxDelay: 120 };
    const result = await (0, util_waiter_1.createWaiter)({ ...serviceDefaults, ...params }, input, checkState);
    return (0, util_waiter_1.checkExceptions)(result);
};
exports.waitUntilInternetGatewayExists = waitUntilInternetGatewayExists;
