"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.waitUntilImageExists = exports.waitForImageExists = void 0;
const util_waiter_1 = require("@aws-sdk/util-waiter");
const DescribeImagesCommand_1 = require("../commands/DescribeImagesCommand");
const checkState = async (client, input) => {
    let reason;
    try {
        const result = await client.send(new DescribeImagesCommand_1.DescribeImagesCommand(input));
        reason = result;
        try {
            const returnComparator = () => {
                const flat_1 = [].concat(...result.Images);
                return flat_1.length > 0.0;
            };
            if (returnComparator() == true) {
                return { state: util_waiter_1.WaiterState.SUCCESS, reason };
            }
        }
        catch (e) { }
    }
    catch (exception) {
        reason = exception;
        if (exception.name && exception.name == "InvalidAMIID.NotFound") {
            return { state: util_waiter_1.WaiterState.RETRY, reason };
        }
    }
    return { state: util_waiter_1.WaiterState.RETRY, reason };
};
const waitForImageExists = async (params, input) => {
    const serviceDefaults = { minDelay: 15, maxDelay: 120 };
    return (0, util_waiter_1.createWaiter)({ ...serviceDefaults, ...params }, input, checkState);
};
exports.waitForImageExists = waitForImageExists;
const waitUntilImageExists = async (params, input) => {
    const serviceDefaults = { minDelay: 15, maxDelay: 120 };
    const result = await (0, util_waiter_1.createWaiter)({ ...serviceDefaults, ...params }, input, checkState);
    return (0, util_waiter_1.checkExceptions)(result);
};
exports.waitUntilImageExists = waitUntilImageExists;
