"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.paginateDescribeHosts = void 0;
const DescribeHostsCommand_1 = require("../commands/DescribeHostsCommand");
const EC2_1 = require("../EC2");
const EC2Client_1 = require("../EC2Client");
const makePagedClientRequest = async (client, input, ...args) => {
    return await client.send(new DescribeHostsCommand_1.DescribeHostsCommand(input), ...args);
};
const makePagedRequest = async (client, input, ...args) => {
    return await client.describeHosts(input, ...args);
};
async function* paginateDescribeHosts(config, input, ...additionalArguments) {
    let token = config.startingToken || undefined;
    let hasNext = true;
    let page;
    while (hasNext) {
        input.NextToken = token;
        input["MaxResults"] = config.pageSize;
        if (config.client instanceof EC2_1.EC2) {
            page = await makePagedRequest(config.client, input, ...additionalArguments);
        }
        else if (config.client instanceof EC2Client_1.EC2Client) {
            page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        }
        else {
            throw new Error("Invalid client, expected EC2 | EC2Client");
        }
        yield page;
        const prevToken = token;
        token = page.NextToken;
        hasNext = !!(token && (!config.stopOnSameToken || token !== prevToken));
    }
    return undefined;
}
exports.paginateDescribeHosts = paginateDescribeHosts;
