"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ModifyInstanceEventWindowCommand = void 0;
const middleware_endpoint_1 = require("@aws-sdk/middleware-endpoint");
const middleware_serde_1 = require("@aws-sdk/middleware-serde");
const smithy_client_1 = require("@aws-sdk/smithy-client");
const models_6_1 = require("../models/models_6");
const Aws_ec2_1 = require("../protocols/Aws_ec2");
class ModifyInstanceEventWindowCommand extends smithy_client_1.Command {
    constructor(input) {
        super();
        this.input = input;
    }
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, ModifyInstanceEventWindowCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "EC2Client";
        const commandName = "ModifyInstanceEventWindowCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: models_6_1.ModifyInstanceEventWindowRequestFilterSensitiveLog,
            outputFilterSensitiveLog: models_6_1.ModifyInstanceEventWindowResultFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return (0, Aws_ec2_1.serializeAws_ec2ModifyInstanceEventWindowCommand)(input, context);
    }
    deserialize(output, context) {
        return (0, Aws_ec2_1.deserializeAws_ec2ModifyInstanceEventWindowCommand)(output, context);
    }
}
exports.ModifyInstanceEventWindowCommand = ModifyInstanceEventWindowCommand;
