"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VTVpc = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
//import * as cdk from 'aws-cdk-lib';
//import { RemovalPolicy, Stack, StackProps, Tags, custom_resources as cr, CustomResource, CfnOutput, Duration, } from 'aws-cdk-lib';
const aws_cdk_lib_1 = require("aws-cdk-lib");
//import { aws_ec2 as ec2, aws_logs as logs, aws_iam as iam } from 'aws-cdk-lib';
const lambda = require("aws-cdk-lib/aws-lambda");
//import {aws_ssm as ssm } from 'aws-cdk-lib'
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
//import { NodejsFunction } from 'aws-cdk-lib/aws-lambda-nodejs';
const constructs_1 = require("constructs");
class VTVpc extends constructs_1.Construct {
    constructor(parent, id, props) {
        super(parent, id);
        const natGatewayProvider = aws_cdk_lib_1.aws_ec2.NatProvider.instance({
            instanceType: new aws_cdk_lib_1.aws_ec2.InstanceType('t3.nano'),
        });
        // Create new VPC
        const constructVpc = new aws_cdk_lib_1.aws_ec2.Vpc(this, `${props.solutionName}-VPC`, {
            vpcName: props.solutionName,
            natGatewayProvider: natGatewayProvider,
            maxAzs: 3,
            //cidr: props.cidr,
            ipAddresses: props && props.cidr ? aws_cdk_lib_1.aws_ec2.IpAddresses.cidr(props.cidr) : aws_cdk_lib_1.aws_ec2.IpAddresses.cidr('172.16.0.0/16'),
            natGateways: 2,
            enableDnsHostnames: true,
            enableDnsSupport: true,
            subnetConfiguration: [
                {
                    name: `${props.solutionName}-public-0`,
                    cidrMask: 24,
                    mapPublicIpOnLaunch: true,
                    subnetType: aws_cdk_lib_1.aws_ec2.SubnetType.PUBLIC,
                },
                {
                    name: `${props.solutionName}-public-1`,
                    cidrMask: 24,
                    mapPublicIpOnLaunch: true,
                    subnetType: aws_cdk_lib_1.aws_ec2.SubnetType.PUBLIC,
                },
                {
                    name: `${props.solutionName}-public-2`,
                    cidrMask: 24,
                    mapPublicIpOnLaunch: true,
                    subnetType: aws_cdk_lib_1.aws_ec2.SubnetType.PUBLIC,
                },
                {
                    name: `${props.solutionName}-private-egress-0`,
                    cidrMask: 24,
                    subnetType: aws_cdk_lib_1.aws_ec2.SubnetType.PRIVATE_WITH_EGRESS,
                },
                {
                    name: `${props.solutionName}-private-egress-2`,
                    cidrMask: 24,
                    subnetType: aws_cdk_lib_1.aws_ec2.SubnetType.PRIVATE_WITH_EGRESS,
                },
                {
                    name: `${props.solutionName}-private-egress-3`,
                    cidrMask: 24,
                    subnetType: aws_cdk_lib_1.aws_ec2.SubnetType.PRIVATE_WITH_EGRESS,
                },
                {
                    name: `${props.solutionName}-isolated-0`,
                    cidrMask: 24,
                    subnetType: aws_cdk_lib_1.aws_ec2.SubnetType.PRIVATE_ISOLATED,
                },
                {
                    name: `${props.solutionName}-isolated-1`,
                    cidrMask: 24,
                    subnetType: aws_cdk_lib_1.aws_ec2.SubnetType.PRIVATE_ISOLATED,
                },
                {
                    name: `${props.solutionName}-isolated-2`,
                    cidrMask: 24,
                    subnetType: aws_cdk_lib_1.aws_ec2.SubnetType.PRIVATE_ISOLATED,
                },
            ],
        });
        /*
      // VPCID SSM Param
      new ssm.StringParameter(this, 'vpcid ssm param', {
        parameterName: `/${props.solutionName}/${props.environment}/vpcId`,
        stringValue: vpc.vpcId,
        description: `param for ${props.solutionName} vpcid`,
        type: ssm.ParameterType.STRING,
        tier: ssm.ParameterTier.INTELLIGENT_TIERING,
        allowedPattern: '.*',
      });
       */
        //EC2 Security Group
        const ec2SG = new aws_cdk_lib_1.aws_ec2.SecurityGroup(this, 'EC2-SG', {
            vpc: constructVpc,
            description: `${props.solutionName} EC2 ${props.environment} SecurityGroup`,
            securityGroupName: `${props.solutionName}-EC2-${props.environment}-SG`,
        });
        ec2SG.addIngressRule(ec2SG, aws_cdk_lib_1.aws_ec2.Port.allTraffic(), 'allow all east/west traffic inside security group');
        /*
        // createSsmParam.standardStringParameter(ecsSgSsmParam, ecsSG.securityGroupId);
        new ssm.StringParameter(this, 'ec2 sg ssm param', {
            parameterName: `/${props.solutionName}/${props.environment}/ec2SgId`,
            stringValue: ec2SG.securityGroupId,
            description: `param for ${props.solutionName} ec2 security group id`,
            type: ssm.ParameterType.STRING,
            tier: ssm.ParameterTier.INTELLIGENT_TIERING,
            allowedPattern: '.*',
        });
     */
        // S3 Gateway Endpoint
        constructVpc.addGatewayEndpoint('s3GatewayEndpoint', {
            service: aws_cdk_lib_1.aws_ec2.GatewayVpcEndpointAwsService.S3,
            // Add only to ISOLATED subnets
            subnets: [
                { subnetType: aws_cdk_lib_1.aws_ec2.SubnetType.PRIVATE_ISOLATED },
                { subnetType: aws_cdk_lib_1.aws_ec2.SubnetType.PRIVATE_WITH_EGRESS },
            ],
        });
        // DynamoDb Gateway endpoint
        constructVpc.addGatewayEndpoint('DynamoDbEndpoint', {
            service: aws_cdk_lib_1.aws_ec2.GatewayVpcEndpointAwsService.DYNAMODB,
            // Add only to ISOLATED subnets
            subnets: [
                { subnetType: aws_cdk_lib_1.aws_ec2.SubnetType.PRIVATE_ISOLATED },
                { subnetType: aws_cdk_lib_1.aws_ec2.SubnetType.PRIVATE_WITH_EGRESS },
            ],
        });
        // Add an interface endpoint
        constructVpc.addInterfaceEndpoint('SystemsManagerEndpoint', {
            service: aws_cdk_lib_1.aws_ec2.InterfaceVpcEndpointAwsService.SSM,
            // Uncomment the following to allow more fine-grained control over
            // who can access the endpoint via the '.connections' object.
            // open: false
            lookupSupportedAzs: true,
            open: true,
            securityGroups: [ec2SG],
        });
        // CloudWatch interface endpoint
        constructVpc.addInterfaceEndpoint('CloudWatchEndpoint', {
            service: aws_cdk_lib_1.aws_ec2.InterfaceVpcEndpointAwsService.CLOUDWATCH,
            // Uncomment the following to allow more fine-grained control over
            // who can access the endpoint via the '.connections' object.
            // open: false
            lookupSupportedAzs: true,
            open: true,
            securityGroups: [ec2SG],
        });
        // CW Events interface endpoint
        constructVpc.addInterfaceEndpoint('CloudWatch_Events_Endpoint', {
            service: aws_cdk_lib_1.aws_ec2.InterfaceVpcEndpointAwsService.CLOUDWATCH_EVENTS,
            // Uncomment the following to allow more fine-grained control over
            // who can access the endpoint via the '.connections' object.
            // open: false
            lookupSupportedAzs: true,
            open: true,
            securityGroups: [ec2SG],
        });
        // CW Logs interface endpoint
        constructVpc.addInterfaceEndpoint('CloudWatch_Logs_Endpoint', {
            service: aws_cdk_lib_1.aws_ec2.InterfaceVpcEndpointAwsService.CLOUDWATCH_LOGS,
            // Uncomment the following to allow more fine-grained control over
            // who can access the endpoint via the '.connections' object.
            // open: false
            lookupSupportedAzs: true,
            open: true,
            securityGroups: [ec2SG],
        });
        // ECR interface endpoint
        constructVpc.addInterfaceEndpoint('EcrDockerEndpoint', {
            service: aws_cdk_lib_1.aws_ec2.InterfaceVpcEndpointAwsService.ECR_DOCKER,
            // Uncomment the following to allow more fine-grained control over
            // who can access the endpoint via the '.connections' object.
            // open: false
            securityGroups: [ec2SG],
            lookupSupportedAzs: true,
            open: true,
        });
        // EFS interface endpoint
        constructVpc.addInterfaceEndpoint('EFSEndpoint', {
            service: aws_cdk_lib_1.aws_ec2.InterfaceVpcEndpointAwsService.ELASTIC_FILESYSTEM,
            // Uncomment the following to allow more fine-grained control over
            // who can access the endpoint via the '.connections' object.
            // open: false
            lookupSupportedAzs: true,
            open: true,
        });
        /*
        new ec2.InterfaceVpcEndpoint(this, "efs endpoint", {
          vpc,
          service: new ec2.InterfaceVpcEndpointService(`com.amazonaws.${this.region}.elasticfilesystem`, 2049),
          securityGroups: [ecsSG],
          open: true ,
          lookupSupportedAzs: true
        })
    */
        // Configure Cloudwatch Log group:
        const logGroup = new aws_cdk_lib_1.aws_logs.LogGroup(this, 'create solution Log group', {
            logGroupName: `/${props.solutionName}/${props.environment}/`,
            removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY,
            retention: aws_cdk_lib_1.aws_logs.RetentionDays.ONE_MONTH,
        });
        /*
      //CW Log group SSM Param
      new ssm.StringParameter(this, 'log group name ssm param', {
        parameterName: `/${props.solutionName}/${props.environment}/logGroupName`,
        stringValue: logGroup.logGroupName,
        description: `param for ${props.solutionName} log group name`,
        type: ssm.ParameterType.STRING,
        tier: ssm.ParameterTier.INTELLIGENT_TIERING,
        allowedPattern: '.*',
      });
       */
        /*
      const vpcFlowlogsRole = new iam.Role(this, `${props.solutionName}-role-for-vpcflowlogs`, {
        assumedBy: new iam.ServicePrincipal('vpc-flow-logs.amazonaws.com')
      });
    
      new ec2.FlowLog(this, 'FlowLog', {
        flowLogName: `${props.solutionName}-${props.environment}-vpclogs`,
        resourceType: ec2.FlowLogResourceType.fromVpc(vpc),
        trafficType: ec2.FlowLogTrafficType.ALL,
        destination: ec2.FlowLogDestination.toCloudWatchLogs(logGroup, vpcFlowlogsRole)
      }); */
        this.vpc = constructVpc;
        const sdk3layer = new lambda.LayerVersion(this, 'HelperLayer', {
            // code: lambda.Code.fromAsset('assets/lambda-layers/aws-sdk-3-layer'),
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, '/../../assets/lambda-layers/aws-sdk-3-layer'), {
            //    bundling: {
            //   command: [
            //     "bash",
            //     "-c",
            //     "npm install && npm run build && cp -rT /asset-input/dist/ /asset-output/",
            //   ],
            //   image: lambda.Runtime.NODEJS_14_X.bundlingImage,
            //   user: "root",
            //  },
            }),
            description: 'AWS JS SDK v3',
            compatibleRuntimes: [lambda.Runtime.NODEJS_14_X, lambda.Runtime.NODEJS_16_X],
            removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY,
        });
        /*
        const crLambda = new NodejsFunction(this, 'customResourceFunction', {
          functionName: `${props.solutionName}-update-infrastructure-${props.environment}`,
          entry: path.join(__dirname, '/../../assets/customResourceLambda/index.ts'),
          runtime: lambda.Runtime.NODEJS_14_X,
          handler: 'handler',
          timeout: Duration.minutes(10),
          layers: [sdk3layer],
          environment: {
            REGION: parent.region,
          },
          bundling: {
            minify: true,
            externalModules: ['aws-sdk', '@aws-sdk/client-iam', '@aws-sdk/client-ec2'],
          },
        });
    
         */
        const crLambda = new aws_lambda_1.Function(this, 'customResourceFunction', {
            functionName: `${props.solutionName}-update-infrastructure-${props.environment}`,
            description: 'customer resource function to tag vpc interfaces and delete natgateway on destroy',
            //entry: path.join(__dirname, '/../../assets/customResourceLambda/index.ts'),
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, '/../../lib/assets/customResourceLambda'), {
            //  bundling: {
            //   command: [
            //     "bash",
            //     "-c",
            //     "npm install && npm run build && cp -rT /asset-input/dist/ /asset-output/",
            //   ],
            //   image: lambda.Runtime.NODEJS_14_X.bundlingImage,
            //   user: "root",
            // },
            }),
            runtime: aws_lambda_1.Runtime.NODEJS_14_X,
            handler: 'index.handler',
            timeout: aws_cdk_lib_1.Duration.minutes(10),
            layers: [sdk3layer],
            tracing: aws_lambda_1.Tracing.ACTIVE,
            environment: {
                REGION: parent.region,
            },
        });
        const provider = new aws_cdk_lib_1.custom_resources.Provider(this, 'Provider', {
            onEventHandler: crLambda,
        });
        provider.onEventHandler.addToRolePolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
            actions: ['iam:*', 'ec2:*'],
            effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
            resources: ['*'],
        }));
        // Custom resource to add tag to interface gateways and manage nat gateway:
        new aws_cdk_lib_1.CustomResource(this, 'CustomResource', {
            serviceToken: provider.serviceToken,
            properties: {
                natGateways: natGatewayProvider.configuredGateways,
                vpcId: constructVpc.vpcId,
                tags: [{ Key: 'environment', Value: props.environment }, { Key: 'solution', Value: props.solutionName }, { Key: 'costcenter', Value: props.costcenter }],
            },
        });
        // Tags.of(this).add("service", `${props.serviceName}`,{
        //   includeResourceTypes: []
        // })
        aws_cdk_lib_1.Tags.of(this).add('environment', props.environment);
        aws_cdk_lib_1.Tags.of(this).add('solution', props.solutionName);
        aws_cdk_lib_1.Tags.of(this).add('costcenter', props.costcenter);
        //Tags.of(this).add("ShutdownPolicy", "NoShutdown")
        new aws_cdk_lib_1.CfnOutput(this, 'VPCId', { value: constructVpc.vpcId, exportName: `${props.solutionName}:${props.environment}:VPCID:${parent.region}` });
        //new CfnOutput(this, 'NatGateways', { value: natGatewayProvider.configuredGateways.toString()} );
        new aws_cdk_lib_1.CfnOutput(this, 'VPCCIDR', { value: constructVpc.vpcCidrBlock, exportName: `${props.solutionName}:VpcCIDR` });
        new aws_cdk_lib_1.CfnOutput(this, 'VPCPrivateSubnet0', { value: constructVpc.privateSubnets[0].subnetId, exportName: `${props.solutionName}:PrivateSubnet0` });
        new aws_cdk_lib_1.CfnOutput(this, 'VPCPrivateSubnet1', { value: constructVpc.privateSubnets[1].subnetId, exportName: `${props.solutionName}:PrivateSubnet1` });
        new aws_cdk_lib_1.CfnOutput(this, 'VPCPrivateSubnet2', { value: constructVpc.privateSubnets[2].subnetId, exportName: `${props.solutionName}:PrivateSubnet2` });
        new aws_cdk_lib_1.CfnOutput(this, 'VPCPrivateSubnet0-AZ', { value: constructVpc.privateSubnets[0].availabilityZone, exportName: `${props.solutionName}:PrivateAZ0` });
        new aws_cdk_lib_1.CfnOutput(this, 'VPCPrivateSubnet1-AZ', { value: constructVpc.privateSubnets[1].availabilityZone, exportName: `${props.solutionName}:PrivateAZ1` });
        new aws_cdk_lib_1.CfnOutput(this, 'VPCPrivateSubnet2-AZ', { value: constructVpc.privateSubnets[2].availabilityZone, exportName: `${props.solutionName}:PrivateAZ2` });
        new aws_cdk_lib_1.CfnOutput(this, 'EC2SecurityGroup', { value: ec2SG.securityGroupId, exportName: `${props.solutionName}:EC2SecurityGroup` });
        new aws_cdk_lib_1.CfnOutput(this, 'LogGroupName', { value: logGroup.logGroupName });
    }
}
exports.VTVpc = VTVpc;
_a = JSII_RTTI_SYMBOL_1;
VTVpc[_a] = { fqn: "vt-vpc-construct.VTVpc", version: "0.0.4" };
//# sourceMappingURL=data:application/json;base64,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