"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// assets/customResourceLambda/index.ts
var customResourceLambda_exports = {};
__export(customResourceLambda_exports, {
  handler: () => handler
});
module.exports = __toCommonJS(customResourceLambda_exports);
var import_client_iam = require("@aws-sdk/client-iam");
var import_client_ec2 = require("@aws-sdk/client-ec2");
var iamClient = new import_client_iam.IAMClient({ region: process.env.REGION });
var ec2Client = new import_client_ec2.EC2Client({ region: process.env.REGION });
var tagVPCEndpoints = async (event) => {
  const vpcId = event.ResourceProperties["vpcId"];
  const tags = event.ResourceProperties["tags"];
  let endPointTags = [...tags];
  let endPoints = [];
  const describeEndPoints = new import_client_ec2.DescribeVpcEndpointsCommand({ Filters: [{ Name: "vpc-id", Values: [vpcId] }] });
  let result = await ec2Client.send(describeEndPoints);
  for (const vpce of result.VpcEndpoints) {
    endPoints.push(vpce.VpcEndpointId);
  }
  try {
    const createTags = new import_client_ec2.CreateTagsCommand({ Resources: [...endPoints], Tags: [...endPointTags] });
    const request = await ec2Client.send(createTags);
    return {
      PhysicalResourceId: request.$metadata.requestId,
      data: {
        status: request.$metadata.httpStatusCode
      }
    };
  } catch (error) {
    console.log("create Tags error: ", error);
  }
};
var deleteNatInstanceRole = async (event) => {
  const instances = event.ResourceProperties["natGateways"];
  console.log(instances);
  let profileName;
  let roleName;
  for (const instance of instances) {
    try {
      console.log(instance);
      console.log("Instance gatewayID", instance.gatewayId);
      let describeInstance = new import_client_ec2.DescribeInstancesCommand({ InstanceIds: [instance.gatewayId] });
      let instanceData = await ec2Client.send(describeInstance);
      let instanceProfileArn = instanceData.Reservations[0].Instances[0].IamInstanceProfile.Arn;
      profileName = instanceProfileArn.split("/")[1];
      console.log("parsed: ", profileName);
      let getInstanceProfile = new import_client_iam.GetInstanceProfileCommand({ InstanceProfileName: profileName });
      let profileDetails = await iamClient.send(getInstanceProfile);
      console.log(profileDetails.InstanceProfile.Roles[0].RoleName);
      roleName = profileDetails.InstanceProfile.Roles[0].RoleName;
      let removeProfile = new import_client_iam.RemoveRoleFromInstanceProfileCommand({ InstanceProfileName: profileName, RoleName: roleName });
      const request = await iamClient.send(removeProfile);
    } catch (error) {
      console.log("remove profile error: ", error);
    }
  }
  try {
    console.log("Delete Role Try ");
    let detachRolePolicy = new import_client_iam.DetachRolePolicyCommand({ PolicyArn: "arn:aws:iam::aws:policy/AmazonSSMManagedInstanceCore", RoleName: roleName });
    await iamClient.send(detachRolePolicy);
    let deleteRole = new import_client_iam.DeleteRoleCommand({ RoleName: roleName });
    const request = await iamClient.send(deleteRole);
    return {
      // PhysicalResourceId: roleName
      Data: {
        requestId: request.$metadata.requestId,
        requestStatus: request.$metadata.httpStatusCode
      }
    };
  } catch (error) {
    console.log("remove role error: ", error);
  } finally {
    console.log("Completed role removal commands");
  }
};
var handler = async (event, context) => {
  console.log("event object: ", event);
  console.log("context object", context);
  switch (event.RequestType) {
    case "Create":
      return tagVPCEndpoints(event);
      event;
    case "Update":
      return tagVPCEndpoints(event);
    case "Delete":
      return deleteNatInstanceRole(event);
  }
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handler
});
