from __future__ import annotations

from typing import Any, Optional

from .. import Tensor
from ..fluid.data_feeder import check_dtype as check_dtype
from ..fluid.data_feeder import check_type as check_type
from ..fluid.data_feeder import check_variable_and_dtype as check_variable_and_dtype
from ..fluid.data_feeder import convert_dtype as convert_dtype
from ..fluid.dygraph.inplace_utils import (
    inplace_apis_in_dygraph_only as inplace_apis_in_dygraph_only,
)
from ..fluid.framework import in_dygraph_mode as in_dygraph_mode
from ..fluid.layer_helper import LayerHelper as LayerHelper

def abs(x: Tensor, with_quant_attr: bool, name: Optional[str] = ...) -> Tensor: ...
def acos(x: Tensor, with_quant_attr: bool, name: Optional[str] = ...) -> Tensor: ...
def acosh(x: Tensor, with_quant_attr: bool, name: Optional[str] = ...) -> Tensor: ...
def asin(x: Tensor, with_quant_attr: bool, name: Optional[str] = ...) -> Tensor: ...
def asinh(x: Tensor, with_quant_attr: bool, name: Optional[str] = ...) -> Tensor: ...
def atan(x: Tensor, with_quant_attr: bool, name: Optional[str] = ...) -> Tensor: ...
def atanh(x: Tensor, with_quant_attr: bool, name: Optional[str] = ...) -> Tensor: ...
def ceil(x: Tensor, with_quant_attr: bool, name: Optional[str] = ...) -> Tensor: ...
def ceil_(x: Tensor, with_quant_attr: bool, name: Optional[str] = ...) -> Tensor: ...
def cos(x: Tensor, with_quant_attr: bool, name: Optional[str] = ...) -> Tensor: ...
def cosh(x: Tensor, with_quant_attr: bool, name: Optional[str] = ...) -> Tensor: ...
def erf(x: Tensor, name: Optional[str] = ...) -> Tensor: ...
def exp(x: Tensor, with_quant_attr: bool, name: Optional[str] = ...) -> Tensor: ...
def exp_(x: Tensor, with_quant_attr: bool, name: Optional[str] = ...) -> Tensor: ...
def expm1(x: Tensor, with_quant_attr: bool, name: Optional[str] = ...) -> Tensor: ...
def floor(x: Tensor, with_quant_attr: bool, name: Optional[str] = ...) -> Tensor: ...
def floor_(x: Tensor, with_quant_attr: bool, name: Optional[str] = ...) -> Tensor: ...
def lgamma(x: Tensor, with_quant_attr: bool, name: Optional[str] = ...) -> Tensor: ...
def log(x: Tensor, name: Optional[str] = ...) -> Tensor: ...
def multiplex(inputs: list[Tensor], index: Tensor, name: Optional[str] = ...) -> Tensor: ...
def reciprocal(x: Tensor, with_quant_attr: bool, name: Optional[str] = ...) -> Tensor: ...
def reciprocal_(x: Tensor, with_quant_attr: bool, name: Optional[str] = ...) -> Tensor: ...
def round(x: Tensor, with_quant_attr: bool, name: Optional[str] = ...) -> Tensor: ...
def round_(x: Tensor, with_quant_attr: bool, name: Optional[str] = ...) -> Tensor: ...
def rsqrt(x: Tensor, with_quant_attr: bool, name: Optional[str] = ...) -> Tensor: ...
def rsqrt_(x: Tensor, with_quant_attr: bool, name: Optional[str] = ...) -> Tensor: ...
def scale(
    x: Tensor,
    scale: float | Tensor = ...,
    bias: float = ...,
    bias_after_scale: bool = ...,
    act: Optional[str] = ...,
    name: Optional[str] = ...,
) -> Tensor: ...
def sin(x: Tensor, with_quant_attr: bool, name: Optional[str] = ...) -> Tensor: ...
def sinh(x: Tensor, with_quant_attr: bool, name: Optional[str] = ...) -> Tensor: ...
def sqrt(x: Tensor, with_quant_attr: bool, name: Optional[str] = ...) -> Tensor: ...
def sqrt_(x: Tensor, with_quant_attr: bool, name: Optional[str] = ...) -> Tensor: ...
def square(x: Tensor, with_quant_attr: bool, name: Optional[str] = ...) -> Tensor: ...
def stanh(x: Tensor, scale_a: float = ..., scale_b: float = ..., name=Optional[str]) -> Tensor: ...
def tan(x: Tensor, scale_a: float = ..., scale_b: float = ..., name=Optional[str]) -> Tensor: ...

from ..fluid.layers.layer_function_generator import (
    generate_activation_fn as generate_activation_fn,
)
from ..fluid.layers.layer_function_generator import (
    generate_layer_fn as generate_layer_fn,
)
from ..framework import convert_np_dtype_to_dtype_ as convert_np_dtype_to_dtype_
from ..framework import core as core

def scale_(
    x: Any,
    scale: float = ...,
    bias: float = ...,
    bias_after_scale: bool = ...,
    act: Optional[Any] = ...,
    name: Optional[Any] = ...,
): ...
def pow(x: Any, y: Any, name: Optional[Any] = ...): ...

OP_NAMEMAPPING: Any

def add(x: Any, y: Any, name: Optional[Any] = ...): ...
def add_(x: Any, y: Any, name: Optional[Any] = ...): ...
def subtract(x: Any, y: Any, name: Optional[Any] = ...): ...
def subtract_(x: Any, y: Any, name: Optional[Any] = ...): ...
def divide(x: Any, y: Any, name: Optional[Any] = ...): ...
def floor_divide(x: Any, y: Any, name: Optional[Any] = ...): ...
def remainder(x: Any, y: Any, name: Optional[Any] = ...): ...

mod = remainder
floor_mod = remainder

def multiply(x: Any, y: Any, name: Optional[Any] = ...): ...
def maximum(x: Any, y: Any, name: Optional[Any] = ...): ...
def minimum(x: Any, y: Any, name: Optional[Any] = ...): ...
def fmax(x: Any, y: Any, name: Optional[Any] = ...): ...
def fmin(x: Any, y: Any, name: Optional[Any] = ...): ...

proto_dict: Any
op_proto: Any
additional_args_lines: Any

def sum(
    x: Any, axis: Optional[Any] = ..., dtype: Optional[Any] = ..., keepdim: bool = ..., name: Optional[Any] = ...
): ...
def nansum(
    x: Any, axis: Optional[Any] = ..., dtype: Optional[Any] = ..., keepdim: bool = ..., name: Optional[Any] = ...
): ...
def nanmean(x: Any, axis: Optional[Any] = ..., keepdim: bool = ..., name: Optional[Any] = ...): ...
def add_n(inputs: Any, name: Optional[Any] = ...): ...
def trunc(input: Any, name: Optional[Any] = ...): ...
def mm(input: Any, mat2: Any, name: Optional[Any] = ...): ...
def addmm(input: Any, x: Any, y: Any, beta: float = ..., alpha: float = ..., name: Optional[Any] = ...): ...
def renorm(x: Any, p: Any, axis: Any, max_norm: Any): ...
def inner(x: Any, y: Any, name: Optional[Any] = ...): ...
def outer(x: Any, y: Any, name: Optional[Any] = ...): ...
def logsumexp(x: Any, axis: Optional[Any] = ..., keepdim: bool = ..., name: Optional[Any] = ...): ...
def inverse(x: Tensor, name: Optional[str] = ...) -> Tensor: ...
def max(x: Any, axis: Optional[Any] = ..., keepdim: bool = ..., name: Optional[Any] = ...): ...
def min(x: Any, axis: Optional[Any] = ..., keepdim: bool = ..., name: Optional[Any] = ...): ...
def amax(x: Any, axis: Optional[Any] = ..., keepdim: bool = ..., name: Optional[Any] = ...): ...
def amin(x: Any, axis: Optional[Any] = ..., keepdim: bool = ..., name: Optional[Any] = ...): ...
def log1p(x: Any, name: Optional[Any] = ...): ...
def log2(x: Any, name: Optional[Any] = ...): ...
def log10(x: Any, name: Optional[Any] = ...): ...
def clip(x: Any, min: Optional[Any] = ..., max: Optional[Any] = ..., name: Optional[Any] = ...): ...
def clip_(x: Any, min: Optional[Any] = ..., max: Optional[Any] = ..., name: Optional[Any] = ...): ...
def trace(x: Any, offset: int = ..., axis1: int = ..., axis2: int = ..., name: Optional[Any] = ...): ...
def diagonal(x: Any, offset: int = ..., axis1: int = ..., axis2: int = ..., name: Optional[Any] = ...): ...
def kron(x: Any, y: Any, name: Optional[Any] = ...): ...
def cumsum(x: Any, axis: Optional[Any] = ..., dtype: Optional[Any] = ..., name: Optional[Any] = ...): ...
def cumprod(x: Any, dim: Optional[Any] = ..., dtype: Optional[Any] = ..., name: Optional[Any] = ...): ...
def isfinite(x: Any, name: Optional[Any] = ...): ...
def isinf(x: Any, name: Optional[Any] = ...): ...
def isnan(x: Any, name: Optional[Any] = ...): ...
def prod(
    x: Any, axis: Optional[Any] = ..., keepdim: bool = ..., dtype: Optional[Any] = ..., name: Optional[Any] = ...
): ...
def sign(x: Any, name: Optional[Any] = ...): ...
def tanh(x: Tensor, name: Optional[Any] = ...) -> Tensor: ...
def tanh_(x: Tensor, name: Optional[Any] = ...) -> Tensor: ...
def increment(x: Any, value: float = ..., name: Optional[Any] = ...): ...
def all(x: Any, axis: Optional[Any] = ..., keepdim: bool = ..., name: Optional[Any] = ...): ...
def any(x: Any, axis: Optional[Any] = ..., keepdim: bool = ..., name: Optional[Any] = ...): ...
def broadcast_shape(x_shape: Any, y_shape: Any): ...
def conj(x: Any, name: Optional[Any] = ...): ...
def digamma(x: Any, name: Optional[Any] = ...): ...
def neg(x: Any, name: Optional[Any] = ...): ...
def atan2(x: Any, y: Any, name: Optional[Any] = ...): ...
def logit(x: Any, eps: Optional[Any] = ..., name: Optional[Any] = ...): ...
def lerp(x: Any, y: Any, weight: Any, name: Optional[Any] = ...): ...
def lerp_(x: Any, y: Any, weight: Any, name: Optional[Any] = ...): ...
def erfinv(x: Any, name: Optional[Any] = ...): ...
def erfinv_(x: Any, name: Optional[Any] = ...): ...
def rad2deg(x: Any, name: Optional[Any] = ...): ...
def deg2rad(x: Any, name: Optional[Any] = ...): ...
def gcd(x: Any, y: Any, name: Optional[Any] = ...): ...
def lcm(x: Any, y: Any, name: Optional[Any] = ...): ...
def diff(
    x: Any,
    n: int = ...,
    axis: int = ...,
    prepend: Optional[Any] = ...,
    append: Optional[Any] = ...,
    name: Optional[Any] = ...,
): ...
def angle(x: Any, name: Optional[Any] = ...): ...
